<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/*
|--------------------------------------------------------------------------
| Display Debug backtrace
|--------------------------------------------------------------------------
|
| If set to TRUE, a backtrace will be displayed along with php errors. If
| error_reporting is disabled, the backtrace will not display, regardless
| of this setting
|
*/
defined('SHOW_DEBUG_BACKTRACE') OR define('SHOW_DEBUG_BACKTRACE', TRUE);

/*
|--------------------------------------------------------------------------
| File and Directory Modes
|--------------------------------------------------------------------------
|
| These prefs are used when checking and setting modes when working
| with the file system.  The defaults are fine on servers with proper
| security, but you may wish (or even need) to change the values in
| certain environments (Apache running a separate process for each
| user, PHP under CGI with Apache suEXEC, etc.).  Octal values should
| always be used to set the mode correctly.
|
*/
defined('FILE_READ_MODE')  OR define('FILE_READ_MODE', 0644);
defined('FILE_WRITE_MODE') OR define('FILE_WRITE_MODE', 0666);
defined('DIR_READ_MODE')   OR define('DIR_READ_MODE', 0755);
defined('DIR_WRITE_MODE')  OR define('DIR_WRITE_MODE', 0755);

/*
|--------------------------------------------------------------------------
| File Stream Modes
|--------------------------------------------------------------------------
|
| These modes are used when working with fopen()/popen()
|
*/
defined('FOPEN_READ')                           OR define('FOPEN_READ', 'rb');
defined('FOPEN_READ_WRITE')                     OR define('FOPEN_READ_WRITE', 'r+b');
defined('FOPEN_WRITE_CREATE_DESTRUCTIVE')       OR define('FOPEN_WRITE_CREATE_DESTRUCTIVE', 'wb'); // truncates existing file data, use with care
defined('FOPEN_READ_WRITE_CREATE_DESTRUCTIVE')  OR define('FOPEN_READ_WRITE_CREATE_DESTRUCTIVE', 'w+b'); // truncates existing file data, use with care
defined('FOPEN_WRITE_CREATE')                   OR define('FOPEN_WRITE_CREATE', 'ab');
defined('FOPEN_READ_WRITE_CREATE')              OR define('FOPEN_READ_WRITE_CREATE', 'a+b');
defined('FOPEN_WRITE_CREATE_STRICT')            OR define('FOPEN_WRITE_CREATE_STRICT', 'xb');
defined('FOPEN_READ_WRITE_CREATE_STRICT')       OR define('FOPEN_READ_WRITE_CREATE_STRICT', 'x+b');

/*
|--------------------------------------------------------------------------
| Exit Status Codes
|--------------------------------------------------------------------------
|
| Used to indicate the conditions under which the script is exit()ing.
| While there is no universal standard for error codes, there are some
| broad conventions.  Three such conventions are mentioned below, for
| those who wish to make use of them.  The CodeIgniter defaults were
| chosen for the least overlap with these conventions, while still
| leaving room for others to be defined in future versions and user
| applications.
|
| The three main conventions used for determining exit status codes
| are as follows:
|
|    Standard C/C++ Library (stdlibc):
|       http://www.gnu.org/software/libc/manual/html_node/Exit-Status.html
|       (This link also contains other GNU-specific conventions)
|    BSD sysexits.h:
|       http://www.gsp.com/cgi-bin/man.cgi?section=3&topic=sysexits
|    Bash scripting:
|       http://tldp.org/LDP/abs/html/exitcodes.html
|
*/
defined('EXIT_SUCCESS')        OR define('EXIT_SUCCESS', 0); // no errors
defined('EXIT_ERROR')          OR define('EXIT_ERROR', 1); // generic error
defined('EXIT_CONFIG')         OR define('EXIT_CONFIG', 3); // configuration error
defined('EXIT_UNKNOWN_FILE')   OR define('EXIT_UNKNOWN_FILE', 4); // file not found
defined('EXIT_UNKNOWN_CLASS')  OR define('EXIT_UNKNOWN_CLASS', 5); // unknown class
defined('EXIT_UNKNOWN_METHOD') OR define('EXIT_UNKNOWN_METHOD', 6); // unknown class member
defined('EXIT_USER_INPUT')     OR define('EXIT_USER_INPUT', 7); // invalid user input
defined('EXIT_DATABASE')       OR define('EXIT_DATABASE', 8); // database error
defined('EXIT__AUTO_MIN')      OR define('EXIT__AUTO_MIN', 9); // lowest automatically-assigned error code
defined('EXIT__AUTO_MAX')      OR define('EXIT__AUTO_MAX', 125); // highest automatically-assigned error code


/*
|--------------------------------------------------------------------------
| Mapeo de examenes
|--------------------------------------------------------------------------
|
*/
$mapeo = serialize( array(
    'TOXI'      => array('tabla' => 'fsm_toxicologico', 'fecha' =>  'fsm_f', 'alias' => 'TOXI','id' => '5321'),
    'TOXIS'     => array('tabla' => 'fsm_toxicologico7', 'fecha' => 'fsm_f', 'alias' => 'TOXIS','id' => '7560'),
    'PSIC'      => array('tabla' => 'fsm_psicologico', 'fecha' => 'fsm_f', 'alias' => 'PSIC','id' => '4520'),
    'ACRED'     => array('tabla' => 'fsm_acreditacion', 'fecha' => 'fsm_f', 'alias' => 'ACRED','id' => '7860'),
    'MEDFIS'    => array('tabla' => 'fsm_medico_fisico', 'fecha' => 'fsm_f', 'alias' => 'MEDFIS','id' => '3527'),
    'SOCIE'     => array('tabla' => 'socio_eco', 'fecha' => 'fecha_eval', 'alias' => 'SOCIE','id' => '9622'),
    'ENTSOC'    => array('tabla' => 'entorno_soc', 'fecha' => 'fecha_eval', 'alias' => 'ENTSOC','id' => '4785'),
    'CED'       => array('tabla' => 'fsm_poligrafico', 'fecha' => 'polig_fecha_eval', 'alias' => 'CED', 'where' => array('campo' => 'polig_tipo_cve','valor' => 'CEDULA'),'id' => '7520'),
    'POL'       => array('tabla' => 'fsm_poligrafico', 'fecha' => 'polig_fecha_eval', 'alias' => 'POL', 'where' => array('campo' => 'polig_tipo_cve','valor' => 'POLI'),'id' => '6420'),
    'HIST'      => array('tabla' => 'fsm_historia_clinica', 'fecha' => 'fsm_f','alias' => 'HIST','id' => '2145'),
    'TOXIN'     => array('tabla' => 'fsm_toxi', 'fecha' => 'fsm_f', 'alias' => 'TOXIN','id' => '2056'),
    'ESTSOC'    => array('tabla' => 'esc', 'fecha' => 'esc_f','alias' => 'ESTSOC','id' => '8520'),
    'QUISAN'    => array('tabla' => 'fsm_quimica_sanguinea', 'fecha' => 'qui_f_recibido','alias' => 'QUISAN','id' => '7160'),
    'ORINA'     => array('tabla' => 'fsm_orina', 'fecha' => 'ori_f_recibido', 'alias' => 'ORINA','id' => '6431'),
    'BIOHEM'    => array('tabla' => 'fsm_biometria_hematica', 'fecha' => 'bio_f_recibido','alias' => 'BIOHEM','id' => '1346'),
    'GPOSAN'    => array('tabla' => 'fsm_grupo_sanguineo', 'fecha' => 'gs_f_recibido', 'alias' => 'GPOSAN','id' => '7319'),
    'REPSIC'    => array('tabla' => 'fsm_psicologico_2', 'fecha' => 'fsm_f', 'alias' => 'REPSIC','id' => '8462'),
    'EYED'      => array('tabla' => 'fsm_eye_detect', 'fecha' => 'fsm_f', 'alias' => 'EYED','id' => '2648'),
    'SOCLAB'    => array('tabla' => 'fsm_sociolab', 'fecha' => 'fsm_f', 'alias' => 'SOCLAB','id' => '7342')
));
defined('MAPEO_EXAMENES') OR define('MAPEO_EXAMENES', $mapeo);