﻿<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Nom035i extends CI_Controller {
    
    function __construct() {
        parent::__construct();
        $this->load->model('persona/Persona_model','cliente');
        $this->load->model('servicio/Servicio_model','servicio');
		$this->load->model('empleado/Empleado_model','medico');
		$this->load->helper('util');
    }
 

    public function rep_eva()
    {
        $this->load->helper('template');
        $params_view = array(
            'title' => 'Inicio',
            'view' => 'persona/inicio_view_rep_evaluados',
            'view_data' => $data
            );
        render_template($params_view);
    } 

    public function rep_lab()
    {
        $this->load->helper('template');
        $params_view = array(
            'title' => 'Inicio',
            'view' => 'persona/inicio_view_rep_eva_lab',
            'view_data' => $data
            );
        render_template($params_view);
    }

 
    public function lista()
    {   //date_default_timezone_set('America/Mexico_City');
	    //echo " Punto A ";
		$suc=get_sucursal_id();
		$user_despacho=get_desp_id_usr();
		
		$user_cei=get_cei_id();
		$user_root1=get_my_user_root1();
		//echo " cei ".get_cei_id();
		//echo " root1 ".get_my_user_root1();
        $rows = 30;
        $this->load->library('pagination');
        $config['base_url'] = base_url('persona/lista/');
        //$config['total_rows'] = $this->cliente->count_all();
		$config['total_rows'] = $this->cliente->count_allo($suc,$user_despacho,$user_cei,$user_root1);
        $config['per_page'] = $rows;
        $config['attributes'] = array('class' => 'pagination');
        $config['full_tag_open'] = '<div class="pagination-full">';
        $config['full_tag_close'] = '</div>';
        $config['uri_segment'] = 3;
        $config['query_string_segment'] = 4;
        $config['use_page_numbers'] = TRUE;
        $this->pagination->initialize($config);
        
		//echo " Punto B ";
        //$data['clientes'] = $this->cliente->get_all($rows);
		
		$data['clientes'] = $this->cliente->get_allo($rows,get_sucursal_id(),$user_despacho,$user_cei,$user_root1);
		//echo " Punto C ";
		
        $this->load->model('empresa/Empresa_model','empresa');
		//echo " Punto D ";
		
        $data['empresas'] = $this->empresa->trae_empresas();//$this->empresa->get_all_empresas();
		//echo " Punto E ";
        
        $this->load->helper('template');
        $params_view = array(
            'title' => 'Personas',
            'view' => 'persona/index',
            'view_data' => $data 
           );
        render_template($params_view);  
    }
    
    public function id($id)
    {   //date_default_timezone_set('America/Mexico_City');
		$n=get_desp_id_usr();
		$user_cei=get_cei_id();
		$user_root1=get_my_user_root1();		
        $data['cliente'] = $this->cliente->get($id,$n);
        
		if($data['cliente'])
        {
            $this->load->model('examen/Entorno_social_model','entorno_social');
            $this->load->model('examen/Socioeconomico_model','socio_economico');
            $this->load->model('examen/Poligrafico_model','poligrafico');
            $this->load->model('examen/Medico_fisico_model','medico_fisico');

            $this->load->model('examen/Psicologico_model','psicologico');
           
		    $this->load->model('examen/Toxicologico_model','toxicologico');
            $this->load->model('examen/Toxicologico_model7','toxicologico7');
            $this->load->model('examen/prueba_model','prueba');
            $this->load->model('examen/Acreditacion_model','acreditacion');
            $this->load->model('examen/Historia_clinica_model','historia_clinica');
            $this->load->model('examen/Quimica_sanguinea_model','quimicasan');
            $this->load->model('examen/Biometria_hematica_model','biometria');
            $this->load->model('examen/Grupo_sanguineo_model','grupo_sanguineo');
            $this->load->model('examen/Orina_model','orina');
            $this->load->model('examen/Essoec_model','gsi');
            $this->load->model('examen/Sociolaboral_model','sociolaboral');
            $this->load->model('examen/Eye_detect_model','eye_detect');
			$this->load->model('examen/Pie_model','pie_detect');
			$this->load->model('examen/Historia_clinica_model','fpfh_detect');
			$this->load->model('examen/Historia_clinica_model','fsm_odon_detect');
			$this->load->model('examen/Pie_model','pyb');
			$this->load->model('examen/SS/Ssestsoc_model','segurisec');
			$this->load->model('examen/Nom035_model','nom035');
			$this->load->model('examen/Nom035ii_model','nom035ii');
			$this->load->model('examen/Nom035iii_model','nom035iii');

            $user = $this->session->user;

            $data['medico']=$user;
            $data['socio_economicos'] = $this->socio_economico->get_by_clte($id,$n);
            
			$data['entorno_social'] = $this->entorno_social->get_by_clte($id,$n);
            
			$data['fsms_02'] = $this->poligrafico->get_by_clte($id,'POLI',$n);
            $data['fsmsc_02'] = $this->poligrafico->get_by_clte($id,'CEDULA',$n);
						
            $data['fsms_04'] = $this->medico_fisico->get_by_clte($id,$n);
			
            $data['fsms_05'] = $this->psicologico->get_by_clte($id,$n); /*CEDULA PSICOLOGICA*/				
			$data['fsms_psicor'] = $this->psicologico->get_by_clte_r($id,$n); /*REPORTE PSICOLOGICO*/
		
            $data['fsms_05_simple'] = $this->psicologico->get_by_clte_simple($id,$n); /*CEDULA PSICOLOGICA SIMPLE*/				
			$data['fsms_psicor_simple'] = $this->psicologico->get_by_clte_r_simple($id,$n); /*REPORTE PSICOLOGICO SIMPLE*/
		
            $data['fsms_06'] = $this->toxicologico->get_by_clte($id,$n);
			
            $data['fsms_07'] = $this->toxicologico7->get_by_clte($id,$n);
			
            $data['fsms_09'] = $this->prueba->get_by_clte($id,$n);
			
            $data['fsms_03'] = $this->acreditacion->get_by_clte($id,$n);
			
            $data['fsms_lala'] = $this->historia_clinica->get_by_clte($id,'',$n);
			$data['fsm_odon'] = $this->historia_clinica->get_by_clte($id,'fsm_odon',$n);
			$data['fpfh'] = $this->historia_clinica->get_by_clte($id,'fpfh',$n);
			
            $data['fsm_qs'] = $this->quimicasan->get_by_clte($id,$n);
			
            $data['fsm_bh'] = $this->biometria->get_by_clte($id,$n);
			
            $data['fsm_gs'] = $this->grupo_sanguineo->get_by_clte($id,$n);
			
            $data['fsm_or'] = $this->orina->get_by_clte($id,$n);

            $data['sociolaboral'] = $this->sociolaboral->get_by_clte($id,$n);
			
     		$data['essoecs'] = $this->gsi->get_by_clte($id,$n);	
            
			$data['fsm_pie'] = $this->pie_detect->get_by_clte($id,$n);
            
			$data['eyes'] = $this->eye_detect->get_by_clte($id,$n);
           
			
			$data['fsm_pyb'] = $this->pyb->get_by_clte_pyb($id,'fsm_pyb',$n);
			
			$data['fsm_ssestsoc'] = $this->segurisec->get_by_clte($id,$n);
			
			$data['fsms_nom035'] = $this->nom035->get_by_clte($id,$n);
			$data['fsms_nom035ii'] = $this->nom035ii->get_by_clte($id,$n);
			$data['fsms_nom035iii'] = $this->nom035iii->get_by_clte($id,$n);
			
			//$data['root'] = get_my_user_root2(); 
			//echo '--->'.$data['myroot2'].'<--';
            $data['docs'] = $this->cliente->get_docs($id);
			$data['coms'] = $this->cliente->get_coms($id);
			$data['hon_docs'] = $this->cliente->get_hon_docs($id);
			$data['compo_docs'] = $this->cliente->get_compo_docs($id);
			$data['sgmty_docs'] = $this->cliente->get_sgmty_docs($id);
			$data['covid_docs'] = $this->cliente->get_covid_docs($id);
			
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Persona',
                'view' => 'persona/cliente',
                'view_data' => $data 
               );

            render_template($params_view);  
        }
        else
        {
            show_error('El cliente no existe.');
        }
    }
    
    public function edita($cliente_id)
    {   //date_default_timezone_set('America/Mexico_City');
        
		$cliente = $this->cliente->get($cliente_id);
        
		if ($cliente['serv_id'] > 0)
		{	
			$servicio = $this->servicio->get($cliente['serv_id']);
		}
		
        if($cliente)
        {

            if(isset($_POST) && count($_POST) > 0)     
            {
                $this->load->library('form_validation');
                $this->form_validation->set_rules('nombre','Nombre','required');
                $this->form_validation->set_rules('paterno','Apellido Paterno','required');
                $this->form_validation->set_rules('materno','Apellido Materno','required');
                /*$this->form_validation->set_rules('fnac','Fecha de nacimiento','required');*/
                $this->form_validation->set_rules('genero','Género','required');
                //$this->form_validation->set_rules('civil','Estado civil','required');
                //$this->form_validation->set_rules('rfc','RFC','required');
                //$this->form_validation->set_rules('curp','CURP','required');

                if($this->form_validation->run())
                {
                    //informncion general de la pérsona
                    $data_clte['clte_nombre_crypt'] =  trim($this->input->post('nombre'));
                    $data_clte['clte_2_nombre_crypt'] =  trim($this->input->post('nombre_adic'));
                    $data_clte['clte_paterno_crypt'] =  trim($this->input->post('paterno'));
                    $data_clte['clte_materno_crypt'] =  trim($this->input->post('materno'));
                    
					$data_clte['clte_f_nac'] = formatea_fecha_mysql($this->input->post('fnac'));
                    $data_clte['clte_genero_cve'] =  $this->input->post('genero');
                    $data_clte['clte_rfc_crypt'] =  $this->input->post('rfc');
                    $data_clte['clte_curp_crypt'] =  $this->input->post('curp');
					

					

                    //dopmcicio de la persona
                    $data_clte['clte_env_pais_cve'] =  $this->input->post('pais');
                    $data_clte['clte_env_cp'] =  $this->input->post('cp');
                    $data_clte['clte_env_edo_cve'] =  $this->input->post('entidad');
                    $data_clte['clte_env_colonia_crypt'] =  $this->input->post('colonia');
                    $data_clte['clte_env_localidad'] =  $this->input->post('localidad');
                    $data_clte['clte_env_municipio'] =  $this->input->post('municipio');
                    $data_clte['clte_env_calle_crypt'] =  $this->input->post('calle');
                    $data_clte['clte_env_num_ext_crypt'] =  $this->input->post('next');
                    $data_clte['clte_env_num_int_crypt'] =  $this->input->post('nint');
					$data_clte['clte_nss_crypt'] =  $this->input->post('nss');
                    //informacion de conrtaxcto de la persona
                    $data_clte['clte_tel_casa_crypt'] = limpia_telefono($this->input->post('tel'));                
                    $data_clte['clte_cel_crypt'] =  limpia_telefono($this->input->post('cel'));
                    $data_clte['clte_email_crypt'] =  $this->input->post('correo');

                    //nuevos campos
                    $data_clte['clte_grado_acad_cve'] =  $this->input->post('grado');
                    $data_clte['clte_puesto'] =  $this->input->post('puesto');
                    $data_clte['clte_edo_civ_cve'] =  $this->input->post('civil');
                    $data_clte['clte_nac_cve'] =  $this->input->post('nac');

                    //empresa donde va a loborar la persona
                    $data_clte['emp_id'] =  $this->input->post('empresa');
                    
                    //nuevo campo de unicacion
                    $data_clte['clte_lab_ubicacion'] =  $this->input->post('ubicacion');
                     
					//despachos 
					$data_clte['desp_id'] =  $this->input->post('despacho');
					$data_clte['clte_reclutador'] =  $this->input->post('reclutador');					 
					 
                     //examenes

				/* 	$data_clte['acred'] =  $this->input->post('acreditacion'); 	
					$data_clte['biohem'] =  $this->input->post('biometria_hematica'); 		
					$data_clte['ced_pol'] =  $this->input->post('poligrafo_celula'); 
					
					$data_clte['ced_psci'] =  $this->input->post('psico_celula'); 				
					$data_clte['psci'] =  $this->input->post('psico_reporte'); 	 
					$data_clte['repsic'] =  $this->input->post('psico_reporte');
					$data_clte['pssim'] =  $this->input->post('psico_simple'); 						
					 
					
					$data_clte['sangre'] =  $this->input->post('sangre'); 
					$data_clte['sociol'] =  $this->input->post('sociolaboral'); 						
					$data_clte['hist'] =  $this->input->post('historia_clinica'); 	 	
					$data_clte['entsoc'] =  $this->input->post('entorno_social'); 	 	
					
					
					$data_clte['estsoc'] = $this->input->post('estudio_socioeconomico'); 	 	
					$data_clte['eyed'] =  $this->input->post('eye'); 	 	
					$data_clte['fpfh0105'] =  $this->input->post('fpfh0105'); 	 	
					$data_clte['medfis'] =  $this->input->post('medico_fisico'); 	 	
					$data_clte['odo'] =  $this->input->post('odontologica'); 	 	
					$data_clte['orina'] =  $this->input->post('orina'); 	 	
					$data_clte['pie'] =  $this->input->post('pie'); 	 	
					$data_clte['pol'] =  $this->input->post('poligrafo_reporte'); 	 	
						 	
					
					$data_clte['quisan'] =  $this->input->post('quimica_sanguinea'); 	 	
					$data_clte['socie'] =  $this->input->post('socioeconomico'); 	 	
					$data_clte['toxi'] =  $this->input->post('toxicologico5'); 	
					
					$data_clte['toxin'] =  $this->input->post('toxicologico9'); 	
					$data_clte['toxis'] =  $this->input->post('toxicologico7');
					
					$data_clte['pyb'] =  $this->input->post('pyb');*/
                    
					
					$nomserv='';
					if ($this->input->post('nom35i') == 'OK')
					{$nomserv=$nomserv.'nom0351;';}	
					if ($this->input->post('nom35ii') == 'OK')
					{$nomserv=$nomserv.'nom0352;';}
					if ($this->input->post('nom35iii') == 'OK')
					{$nomserv=$nomserv.'nom0353;';}	
					if ($this->input->post('honestidad') == 'OK')
					{$nomserv=$nomserv.'HONE;';}
					if ($this->input->post('comportamiento') == 'OK')
					{$nomserv=$nomserv.'COMPO;';}
					if ($this->input->post('certificado') == 'OK')
					{$nomserv=$nomserv.'CERTI;';}
/***************************************************************************************/
						
					$cat_examen = get_cat_nombre_var('EXAMEN');
					$i=0;
					$cat_categorias = get_cat_nombre_var('CATEGORIA_EX');
					foreach($cat_categorias as $categoria): 
						//echo $categoria['cat_nombre'].' ';
						$linea_examenes=get_examen_de_empresa_por_categoria($cliente['emp_id'], $categoria['cat_nombre']);
						
						if (strlen($linea_examenes) > 0)
						{
							foreach (explode(';', $linea_examenes) as $det):
								if (strlen($det) > 0)
								{

										//<?php echo $categoria['cat_nombre'];

										//<?php echo get_nombre_de_examen($det, 'EXAMEN');
										
										$exa=$this->input->post($categoria['cat_nombre'].'_'.$i);
										$nomserv.=$exa;
										$i++;
										//<input type="checkbox" id="<?php echo $categoria['cat_nombre'].'_'.$i; " name="<?php echo $categoria['cat_nombre'].'_'.$i; " value="<?php echo $det.';'; $i++; " <?php if (strstr($persona['nomserv'], $det.';')) { echo 'checked';} 

								}
								
							endforeach;										
						}
					endforeach;
/***************************************************************************************/

					$data_clte['nomserv'] =  $nomserv;
					
					if ($data_clte['emp_id'] == 152)
					{
						$data_clte['nomserv']='SGMTY;';
					}elseif ($data_clte['emp_id'] == 194)
					{
						$data_clte['nomserv']='PREVEM;';
					}elseif ($data_clte['emp_id'] == 193)
					{
						$data_clte['nomserv']='ALLIANZ;';
					}  
					
                    //despacho
                      $data_clte['desp_id'] =  $this->input->post('despacho');
					  if ($data_clte['desp_id'] == 1) {$data_clte['desp_id']=0;}
					  $data_clte['clte_reclutador'] =  $this->input->post('reclutador');
					
					//orden de servicio
					
					if ($this->input->post('serv_id') > 0)
					{	
						$data_clte['serv_id'] =$this->input->post('serv_id');
					}				
					
					//orden de servicio		13 feb 2020		
					/*if ($this->input->post('serv_id') > 0)
					{	
						if ($this->input->post('empresa') == 31)
						{	
							$data_clte['serv_id'] = 215;
						}
						else
						{
							$servicio_form = $this->servicio->get($this->input->post('serv_id'));
							$data_clte['desp_id'] =  $servicio_form['desp_id'];
							$data_clte['clte_reclutador'] =  $servicio_form['reclutador'];
							$data_clte['serv_id'] =  $this->input->post('serv_id');
						}
					}*/
					
					//sucursal
					$data_clte['suc_id'] =  $this->input->post('sucursal');
					
					//cei
					$data_clte['cei_id'] =  $this->input->post('cei');
					
					
//*************************************
//$data_clte['root'] = 'OK';
//*************************************


                    if(!empty($_FILES['foto']['name']))
                    {
                        $this->load->library('upload');
                        $filename = md5(time());
                        $config = array(
                                'upload_path'   => './../../files/fotos/',
                                'overwrite'     => TRUE,
                                'file_name'     => $filename,
                                'allowed_types' => 'png|jpg|jpeg',
                                'max_size'      => '10000'
                        );

                        $this->upload->initialize($config);
                        if ( ! $this->upload->do_upload('foto'))
                        {
                            send_json_error($this->upload->display_errors());
                        }
                        else 
                        {
                            $data = $this->upload->data();
                            $data_clte['clte_path_foto'] = $data['file_name'];
                        }
                    }

					if (($data_clte['clte_f_nac'] =='') && ($data_clte['emp_id'] !=152))
					{
						send_json_error('Ocurrió un error, no se registro la FECHA DE NACIMIENTO.');
					}
                    else
					{
						
						if ($this->input->post('rregistrar') == 'rr')
						{						
							if($this->cliente->actualiza_registro($cliente_id, array_to_upper($data_clte)))
							{
								send_json_ok(array('msg' =>'Se actualizó y registro nuevamente el evaluado de forma correcta', 'id' => $cliente_id));
							}
							else
							{
								send_json_error('Ocurrió un error al actualizar la persona.');
							}
						}
						else
						{	
						
							if($this->cliente->actualiza($cliente_id, array_to_upper($data_clte)))
							{
								send_json_ok(array('msg' =>'Se actualizó de forma correcta', 'id' => $cliente_id));
							}
							else
							{
								send_json_error('Ocurrió un error al actualizar la persona.');
							}
						}
					}
                }
                else
                {
                    send_json_error(validation_errors('<div />'));
                }
            }
            else 
            {
				//echo "----------->".$cliente['suc_id']."<-----------";
                $this->load->model('empresa/Empresa_model','empresa');
                $data['empresas'] = $this->empresa->trae_empresas();//$this->empresa->get_all_empresas();
				$data['despachos'] = $this->empresa->get_all_despachos();
				$data['sucursals'] = $this->empresa->get_all_sucursales();
				$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($cliente['emp_id']);
                $data['persona'] = 	$cliente;
				if ($cliente['serv_id'] > 0)
				{
					$data['servicio'] = $servicio;
				}
                $this->load->helper('template');
                $params_view = array(
                    'title' => 'Personas',
                    'view' => 'persona/edit',
                    'view_data' => $data
                   );
                render_template($params_view);  
            }
        }
        else 
        {
            show_error('No existe el cliente');
        }
    }
    
    public function nuevo()
    {    
	    //date_default_timezone_set('America/Mexico_City');
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('nombre','Nombre','required');
            $this->form_validation->set_rules('paterno','Apellido Paterno','required');
            $this->form_validation->set_rules('materno','Apellido Materno','required');
            //$this->form_validation->set_rules('fnac','Fecha de nacimiento','required');
            $this->form_validation->set_rules('genero','Género','required');
           // $this->form_validation->set_rules('civil','Estado civil','required');
           // $this->form_validation->set_rules('rfc','RFC','required');           
           //$this->form_validation->set_rules('curp','CURP','required');

            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_nombre_crypt'] =  trim($this->input->post('nombre'));
                $data_clte['clte_2_nombre_crypt'] =  trim($this->input->post('nombre_adic'));
                $data_clte['clte_paterno_crypt'] =  trim($this->input->post('paterno'));
                $data_clte['clte_materno_crypt'] =  trim($this->input->post('materno'));
                
				$data_clte['clte_f_nac'] = formatea_fecha_mysql($this->input->post('fnac'));
                
				$data_clte['clte_genero_cve'] =  $this->input->post('genero');
                				
				$data_clte['clte_rfc_crypt'] =  $this->input->post('rfc');
                				
				$data_clte['clte_curp_crypt'] =  $this->input->post('curp');
                
                //dopmcicio de la persona
                $data_clte['clte_env_pais_cve'] =  $this->input->post('pais');
                $data_clte['clte_env_cp'] =  $this->input->post('cp');
                $data_clte['clte_env_edo_cve'] =  $this->input->post('entidad');
                $data_clte['clte_env_colonia_crypt'] =  $this->input->post('colonia');
                $data_clte['clte_env_localidad'] =  $this->input->post('localidad');
                $data_clte['clte_env_municipio'] =  $this->input->post('municipio');
                $data_clte['clte_env_calle_crypt'] =  $this->input->post('calle');
                $data_clte['clte_env_num_ext_crypt'] =  $this->input->post('next');
                $data_clte['clte_env_num_int_crypt'] =  $this->input->post('nint');
                $data_clte['clte_nss_crypt'] =  $this->input->post('nss');
                //informacion de conrtaxcto de la persona
                $data_clte['clte_tel_casa_crypt'] =  limpia_telefono($this->input->post('tel'));                
                $data_clte['clte_cel_crypt'] =  limpia_telefono($this->input->post('cel'));
                $data_clte['clte_email_crypt'] =  $this->input->post('correo');
                
                //nuevos campos
                $data_clte['clte_grado_acad_cve'] =  $this->input->post('grado');
                $data_clte['clte_puesto'] =  $this->input->post('puesto');
                $data_clte['clte_edo_civ_cve'] =  $this->input->post('civil');
                $data_clte['clte_nac_cve'] =  $this->input->post('nac');
                
                //empresa donde va a loborar la persona
                $data_clte['emp_id'] =  $this->input->post('empresa');
                
                //nuevo campo de ubicacion
                $data_clte['clte_lab_ubicacion'] =  $this->input->post('ubicacion');

                //despacho
                  $data_clte['desp_id'] =  $this->input->post('despacho');
				  if ($data_clte['desp_id'] == 1) {$data_clte['desp_id']=0;}
			      $data_clte['clte_reclutador'] =  $this->input->post('reclutador');
				
				//orden de servicio	nueva estrutura para evaluados 13 feb 2020
				/* $bandera=0;
				if ($this->input->post('serv_id') > 0)
				{	
					if ($this->input->post('empresa') == 31)
					{	
						$data_clte['serv_id'] = 215;
					}
					else
					{
						$servicio_form = $this->servicio->get_evaluado($this->input->post('serv_id'),$data_clte['emp_id']);
						if ($servicio_form['serv_id'] > 0)
						{	
							$data_clte['desp_id'] =  $servicio_form['desp_id'];
							$data_clte['clte_reclutador'] =  $servicio_form['reclutador'];
							$data_clte['serv_id'] =  $this->input->post('serv_id');
						}
						else
						{
							$bandera=1;
						}	
					}
				} */
				
				
				//sucursal
                $data_clte['suc_id'] =  $this->input->post('sucursal');
				//cei
				if ($this->input->post('empresa') == 16)
				{	
					$data_clte['cei_id'] =  7;
				}
				else 
				{
					if ($this->input->post('empresa') == 31)
					{	
						$data_clte['cei_id'] =  2;
					}
					else
					{
						$data_clte['cei_id'] =  $this->input->post('cei');
					}
				}

                $data_clte['desp_id'] =  $this->input->post('despacho');
                $data_clte['clte_reclutador'] =  $this->input->post('reclutador');
				
				//examenes
				
					$nomserv='';


/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/					
			/*		if (
						($data_clte['emp_id'] == 136) || 
						($data_clte['emp_id'] == 102) || 												
						($data_clte['emp_id'] == 103) || 
						($data_clte['emp_id'] == 104) || 
						($data_clte['emp_id'] == 15) || 
						($data_clte['emp_id'] == 105)
					   )
					   {
						   
						$data_clte['acred'] =  'OK';   
						$data_clte['ced_psci'] = 'OK';
						$data_clte['fpfh0105'] =  'OK'; 	 	
						$data_clte['medfis'] =  'OK'; 
						$data_clte['socie'] =  'OK'; 	 	
						$data_clte['toxi'] = 'OK';
						
						//$nomserv='ACRED;PSIC;FSM0105;MEDFIS;SOCIE;TOXI;';
						
					   }
					   else
					   {
						$data_clte['acred'] =  $this->input->post('acreditacion'); 	
						$data_clte['biohem'] =  $this->input->post('biometria_hematica'); 		
						$data_clte['ced_pol'] =  $this->input->post('poligrafo_celula'); 
						$data_clte['ced_psci'] =  $this->input->post('psico_celula'); 				
						$data_clte['sangre'] =  $this->input->post('sangre'); 
						$data_clte['sociol'] =  $this->input->post('sociolaboral'); 						
						$data_clte['hist'] =  $this->input->post('historia_clinica'); 	 	
						$data_clte['entsoc'] =  $this->input->post('entorno_social'); 	 	
						$data_clte['estsoc'] =  $this->input->post('estudio_socioeconomico'); 	 	
						$data_clte['eyed'] =  $this->input->post('eye'); 	 	
						$data_clte['fpfh0105'] =  $this->input->post('fpfh0105'); 	 	
						$data_clte['medfis'] =  $this->input->post('medico_fisico'); 	 	
						$data_clte['odo'] =  $this->input->post('odontologica'); 	 	
						$data_clte['orina'] =  $this->input->post('orina'); 	 	
						$data_clte['pie'] =  $this->input->post('pie'); 	 	
						$data_clte['pol'] =  $this->input->post('poligrafo_reporte'); 	 	
						$data_clte['psci'] =  $this->input->post('psico_reporte'); 	 	
						$data_clte['repsic'] =  $this->input->post('psico_reporte'); 	 	
						$data_clte['quisan'] =  $this->input->post('quimica_sanguinea'); 	 	
						$data_clte['socie'] =  $this->input->post('socioeconomico'); 	 	
						$data_clte['toxi'] =  $this->input->post('toxicologico5');
						$data_clte['pssim'] =  $this->input->post('psico_simple'); 
						$data_clte['toxin'] =  $this->input->post('toxicologico9'); 	
						$data_clte['toxis'] =  $this->input->post('toxicologico7'); 	 
						$data_clte['pyb'] =  $this->input->post('pyb');
						
						
						if ($this->input->post('nom35i') == 'OK')
						{$nomserv=$nomserv.'nom0351;';}	
						if ($this->input->post('nom35ii') == 'OK')
						{$nomserv=$nomserv.'nom0352;';}
						if ($this->input->post('nom35iii') == 'OK')
						{$nomserv=$nomserv.'nom0353;';}	
						if ($this->input->post('honestidad') == 'OK')
						{$nomserv=$nomserv.'HONE;';}
						if ($this->input->post('comportamiento') == 'OK')
						{$nomserv=$nomserv.'COMPO;';}				
					}	*/						
/************ nace sin datos de examen
					$cat_examen = get_cat_nombre_var('EXAMEN');
					
					$cat_categorias = get_cat_nombre_var('CATEGORIA_EX');
					foreach($cat_categorias as $categoria): 
						$linea_examenes=get_examen_de_empresa_por_categoria($data_clte['emp_id'], $categoria['cat_nombre']);
						
						if (strlen($linea_examenes) > 0)
						{
							foreach (explode(';', $linea_examenes) as $det):
								if (strlen($det) > 0)
								{
										$exa=$det.';';
										$nomserv.=$exa;
										
								}
							endforeach;										
						}
					endforeach;					
/*****************************				
					$data_clte['nomserv'] =  $nomserv;	*/			

//*************************************
//$data_clte['root'] = 'OK';
//*************************************


                
                if(!empty($_FILES['foto']['name']))
                {
                    $this->load->library('upload');
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/fotos/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg',
                            'max_size'      => '10000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('foto'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['clte_path_foto'] = $data['file_name'];
                    }
                }
				
				if ($data_clte['emp_id'] == 152)
				{
					$data_clte['nomserv']='SGMTY;';
				}elseif ($data_clte['emp_id'] == 194)
				{
					$data_clte['nomserv']='PREVEM;';
				} 

				$data_clte=array_to_upper($data_clte);
				$encontrado = $this->cliente->buscate($data_clte['clte_nombre_crypt'], $data_clte['clte_2_nombre_crypt'],  $data_clte['clte_paterno_crypt'],$data_clte['clte_materno_crypt']);
				$diff=61;
				
				$rfc_test=$data_clte['clte_rfc_crypt'];
				
				$encontrado_error_long_rfc=0;
				
				
				//if ($data_clte['emp_id'] == 152)
				{
					if (strlen($data_clte['clte_rfc_crypt']) < 10)
					{						
						$data_clte['clte_rfc_crypt']=substr($data_clte['clte_paterno_crypt'],0,2).substr($data_clte['clte_materno_crypt'],0,1).substr($data_clte['clte_nombre_crypt'],0,1).substr($data_clte['clte_f_nac'],2,2).substr($data_clte['clte_f_nac'],5,2).substr($data_clte['clte_f_nac'],8,2);
					}
				}
             /*   else				
				{	
					if (strlen($rfc_test) <10)
					{
						$encontrado_long_rfc=1;
					}
					else
					{
						$rfc_test= substr($rfc_test,0,10);
						$encontrado_rfc = $this->cliente->buscate_rfc($rfc_test,$data_clte['emp_id']);
					}	
				}*/
				
				
				
				if ($encontrado)
				{
					$unafecha=$encontrado[0]['log_insrt_f'];
					$diff= abs(intval(dateDifference($unafecha,date('Y-m-d'))));

				}
	             
				if (($encontrado) && ( $diff < 20))
				{
					send_json_error('Ocurrió un error, el candidato ya fue registrado en la plataforma en la fecha '.formatea_fecha($unafecha).', hace '.$diff.' días.');
				}
				elseif ($data_clte['emp_id'] ==0)
				{
					send_json_error('Ocurrió un error, no se selecciono la EMPRESA.');
					
				}
				elseif (($data_clte['clte_f_nac'] =='') && ($data_clte['emp_id'] !=152))
				{
					send_json_error('Ocurrió un error, no se registro la FECHA DE NACIMIENTO.');
				}				
				/*elseif( $encontrado_long_rfc ==1)
				{
					send_json_error('Ocurrió un error, el RFC capturado: "'.$rfc_test.'", debe tener al menos 10 caracteres.');
					
				} elseif($encontrado_rfc)
				{
					send_json_error('Ocurrió un error, el evaluado ya habia sido registrado anterioremente con el ID "'.$encontrado_rfc[0]['clte_id'].'", por favor usar el registro ya establecido.');
				}*/				
				elseif($cliente_id = $this->cliente->inserta(array_to_upper($data_clte)))
                {
                    send_json_ok(array('msg' =>'Se guardó de forma correcta el registro del evaluado.', 'id' => $cliente_id));
                }
                else
                {
                    send_json_error('Ocurrió un error al guardar la persona.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $this->load->model('empresa/Empresa_model','empresa');
            $data['empresas'] = $this->empresa->trae_empresas();//$this->empresa->get_all_empresas();
			$data['sucursals'] = $this->empresa->get_all_sucursales();
			$data['despachos'] = $this->empresa->get_all_despachos();
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'persona/add',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }

/*************************************************************************************/
    public function nuevo_n()
    {    
	    //date_default_timezone_set('America/Mexico_City');
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('nombre','Nombre','required');
            $this->form_validation->set_rules('paterno','Apellido Paterno','required');
            $this->form_validation->set_rules('materno','Apellido Materno','required');
            $this->form_validation->set_rules('fnac','Fecha de nacimiento','required');
            $this->form_validation->set_rules('genero','Género','required');
           // $this->form_validation->set_rules('civil','Estado civil','required');
            $this->form_validation->set_rules('rfc','RFC','required');
            //
            //$this->form_validation->set_rules('curp','CURP','required');

            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_nombre_crypt'] =  trim($this->input->post('nombre'));
                $data_clte['clte_2_nombre_crypt'] =  trim($this->input->post('nombre_adic'));
                $data_clte['clte_paterno_crypt'] =  trim($this->input->post('paterno'));
                $data_clte['clte_materno_crypt'] =  trim($this->input->post('materno'));
                
				$data_clte['clte_f_nac'] = formatea_fecha_mysql($this->input->post('fnac'));
                $data_clte['clte_genero_cve'] =  $this->input->post('genero');
      				
				$data_clte['clte_rfc_crypt'] =  $this->input->post('rfc');
                				
				$data_clte['clte_curp_crypt'] = ''; // $this->input->post('curp');
                
                //dopmcicio de la persona
                $data_clte['clte_env_pais_cve'] =  $this->input->post('pais');
                $data_clte['clte_env_cp'] =  $this->input->post('cp');
                $data_clte['clte_env_edo_cve'] =  $this->input->post('entidad');
                $data_clte['clte_env_colonia_crypt'] =  $this->input->post('colonia');
                $data_clte['clte_env_localidad'] =  $this->input->post('localidad');
                $data_clte['clte_env_municipio'] =  $this->input->post('municipio');
                $data_clte['clte_env_calle_crypt'] =  $this->input->post('calle');
                $data_clte['clte_env_num_ext_crypt'] =  $this->input->post('next');
                $data_clte['clte_env_num_int_crypt'] =  $this->input->post('nint');
				
                $data_clte['clte_nss_crypt'] = ''; // $this->input->post('nss');
                
				//informacion de conrtaxcto de la persona
                $data_clte['clte_tel_casa_crypt'] =  limpia_telefono($this->input->post('tel'));                
                $data_clte['clte_cel_crypt'] =  limpia_telefono($this->input->post('cel'));
                $data_clte['clte_email_crypt'] =  $this->input->post('correo');
                
                //nuevos campos
                $data_clte['clte_grado_acad_cve'] =  $this->input->post('grado');
                $data_clte['clte_puesto'] =  $this->input->post('puesto');
                $data_clte['clte_edo_civ_cve'] =  $this->input->post('civil');
                $data_clte['clte_nac_cve'] =  $this->input->post('nac');
                
                //empresa donde va a loborar la persona
                $data_clte['emp_id'] = 189 ;  // solo NOVERITE //$this->input->post('empresa');
                
                //nuevo campo de ubicacion
                $data_clte['clte_lab_ubicacion'] = ''; // $this->input->post('ubicacion');

                //despacho
				$data_clte['desp_id']=0;
			    $data_clte['clte_reclutador'] ='';  //$this->input->post('reclutador');
				
				//sucursal
                $data_clte['suc_id'] =0;//$this->input->post('sucursal');
				$data_clte['cei_id'] =  2;
					
					$nomserv='';
					

					$data_clte['nomserv'] =  $nomserv;

 /***************************** CARGA DE LA FOTO DEL EVALUADO ************************/               
                if(!empty($_FILES['foto']['name']))
                {
                    $this->load->library('upload');
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/fotos/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg',
                            'max_size'      => '10000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('foto'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['clte_path_foto'] = $data['file_name'];
                    }
                }
/*************************************************************************************/
				$data_clte=array_to_upper($data_clte);
				
				$encontrado = $this->cliente->buscate($data_clte['clte_nombre_crypt'], $data_clte['clte_2_nombre_crypt'],  $data_clte['clte_paterno_crypt'],$data_clte['clte_materno_crypt']);
				$diff=61;
				
				$rfc_test=$data_clte['clte_rfc_crypt'];
				
				$encontrado_error_long_rfc=0;
				
				if (strlen($rfc_test) <10)
				{
					$encontrado_long_rfc=1;
				}
				else
				{
					$rfc_test= substr($rfc_test,0,10);
					$encontrado_rfc = $this->cliente->buscate_rfc($rfc_test,$data_clte['emp_id']);
				}	
			
				
				if ($encontrado)
				{
					$unafecha=$encontrado[0]['log_insrt_f'];
					$diff= abs(intval(dateDifference($unafecha,date('Y-m-d'))));

				}
	             
				if (($encontrado) && ( $diff < 20))
				{
					send_json_error('Ocurrió un error, el candidato ya fue registrado en la plataforma en la fecha '.formatea_fecha($unafecha).', hace '.$diff.' días.');
				}
				elseif( $encontrado_long_rfc ==1)
				{
					send_json_error('Ocurrió un error, el RFC capturado: "'.$rfc_test.'", debe tener al menos 10 caracteres.');
					
				}elseif($encontrado_rfc)
				{
					send_json_error('Ocurrió un error, el evaluado ya habia sido registrado anterioremente con el ID "'.$encontrado_rfc[0]['clte_id'].'", por favor usar el registro ya establecido.');
				}
				elseif($cliente_id = $this->cliente->inserta(array_to_upper($data_clte)))
                {
                    send_json_ok(array('msg' =>'Se guardó de forma correcta', 'id' => $cliente_id));
                    
                }
                else
                {
                    send_json_error('Ocurrió un error al guardar la persona.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $this->load->model('empresa/Empresa_model','empresa');
            $data['empresas'] = $this->empresa->get_all_empresas();
			$data['sucursals'] = $this->empresa->get_all_sucursales();
			$data['despachos'] = $this->empresa->get_all_despachos();
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'persona/add_n',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }

/*************************************************************************************/
    
    public function nuevo_doc($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('nombre','Nombre documento','required');

            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_id'] =  $cliente_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
				$data_clte['serv_id'] =  $persona['serv_id'];
                
                $this->load->library('upload');
                if(!empty($_FILES['doc']['name']))
                {
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/docs/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg|pdf|doc|docx',
                            'max_size'      => '10000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('doc'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['doc_path'] = $data['file_name'];
                        if($this->cliente->add_doc(array_to_upper($data_clte)))
                        {
                            send_json_ok('Se guardó de forma correcta');
                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
                    send_json_error($this->upload->display_errors());
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'persona/add_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }
 
    public function nuevo_hon_doc($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('nombre','Nombre documento','required');
			$this->form_validation->set_rules('servicio','Orden de servicio','required');
			
            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_id'] =  $cliente_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                $data_clte['emp_id'] =  $this->input->post('emp_id');
				$data_clte['serv_id'] = $this->input->post('servicio');
				
				
                $this->load->library('upload');
                if(!empty($_FILES['doc']['name']))
                {
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/docs/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg|pdf|doc|docx',
                            'max_size'      => '10000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('doc'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['doc_path'] = $data['file_name'];
                        if($this->cliente->add_hon_doc(array_to_upper($data_clte)))
                        {
                            send_json_ok('Se guardó de forma correcta');
                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
                    send_json_error($this->upload->display_errors());
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'persona/add_hon_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }

    public function nuevo_covid_doc($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('nombre','Nombre documento','required');
			$this->form_validation->set_rules('servicio','Orden de servicio','required');
			
            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_id'] =  $cliente_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                $data_clte['emp_id'] =  $this->input->post('emp_id');
				$data_clte['serv_id'] = $this->input->post('servicio');
				
				
                $this->load->library('upload');
                if(!empty($_FILES['doc']['name']))
                {
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/docs/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg|pdf|doc|docx',
                            'max_size'      => '10000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('doc'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['doc_path'] = $data['file_name'];
                        if($this->cliente->add_covid_doc(array_to_upper($data_clte)))
                        {
                            send_json_ok('Se guardó de forma correcta');
                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
                    send_json_error($this->upload->display_errors());
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'persona/add_covid_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }

    public function nuevo_compo_doc($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('nombre','Nombre documento','required');
			$this->form_validation->set_rules('servicio','Orden de servicio','required');
			
            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_id'] =  $cliente_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                $data_clte['emp_id'] =  $this->input->post('emp_id');
				$data_clte['serv_id'] = $this->input->post('servicio');
				
				
                $this->load->library('upload');
                if(!empty($_FILES['doc']['name']))
                {
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/docs/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg|pdf|doc|docx',
                            'max_size'      => '10000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('doc'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['doc_path'] = $data['file_name'];
                        if($this->cliente->add_compo_doc(array_to_upper($data_clte)))
                        {
                            send_json_ok('Se guardó de forma correcta');
                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
                    send_json_error($this->upload->display_errors());
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'persona/add_compo_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }
 
 
     public function nuevo_prevem_doc($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
		
		
        
        if(isset($_POST) && count($_POST) > 0)     
        {
			$this->cliente->borra_sgmty_doc($cliente_id);
            $this->load->library('form_validation');
            $this->form_validation->set_rules('nombre','Nombre documento','required');
			$this->form_validation->set_rules('servicio','Orden de servicio','required');
			
            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_id'] =  $cliente_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                $data_clte['emp_id'] =  $this->input->post('emp_id');
				$data_clte['serv_id'] = $this->input->post('servicio');
				$data_clte['doc_pkts'] ='';

				$i=1;
				$paquetes='';
				$fsm_pakts= get_costos_paquetes_empresa($this->input->post('emp_id'));
				if($fsm_pakts):
					foreach($fsm_pakts as $fsm_pakt):			
						$indice=str_replace(' ','_',$fsm_pakt['cost_nombre_pkt']).'_'.$i;
						if (strlen($this->input->post($indice)) > 1)
						{	
							$paquetes.=$this->input->post($indice);										
						}
						$i++;									
					endforeach;
				endif;
				$data_clte['doc_pkts'] = $paquetes;
				//$data_clte['contador']=$this->input->post('contador');

                $this->load->library('upload');
                if(!empty($_FILES['doc']['name']))
                {
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/docs/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg|pdf|doc|docx',
                            'max_size'      => '10000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('doc'))
                    {
                        //send_json_error($this->upload->display_errors());
						send_json_error('El documento nos se ha podido cargar, por favor revisa');
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['doc_path'] = $data['file_name'];
                        if($this->cliente->add_sgmty_doc(array_to_upper($data_clte)))
                        {
                            send_json_ok('Se guardó de forma correcta');
                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
                    send_json_error($this->upload->display_errors());
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'persona/add_sgmty_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }
 
 
     public function nuevo_sgmty_doc($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
		
		
        
        if(isset($_POST) && count($_POST) > 0)     
        {
			$this->cliente->borra_sgmty_doc($cliente_id);
            $this->load->library('form_validation');
            $this->form_validation->set_rules('nombre','Nombre documento','required');
			$this->form_validation->set_rules('servicio','Orden de servicio','required');
			
            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_id'] =  $cliente_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                $data_clte['emp_id'] =  $this->input->post('emp_id');
				$data_clte['serv_id'] = $this->input->post('servicio');
				$data_clte['doc_pkts'] ='';

				$i=1;
				$paquetes='';
				$fsm_pakts= get_costos_paquetes_empresa($this->input->post('emp_id'));
				if($fsm_pakts):
					foreach($fsm_pakts as $fsm_pakt):			
						$indice=str_replace(' ','_',$fsm_pakt['cost_nombre_pkt']).'_'.$i;
						if (strlen($this->input->post($indice)) > 1)
						{	
							$paquetes.=$this->input->post($indice);										
						}
						$i++;									
					endforeach;
				endif;
				$data_clte['doc_pkts'] = $paquetes;
				//$data_clte['contador']=$this->input->post('contador');

                $this->load->library('upload');
                if(!empty($_FILES['doc']['name']))
                {
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/docs/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg|pdf|doc|docx',
                            'max_size'      => '10000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('doc'))
                    {
                        //send_json_error($this->upload->display_errors());
						send_json_error('El documento nos se ha podido cargar, por favor revisa');
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['doc_path'] = $data['file_name'];
                        if($this->cliente->add_sgmty_doc(array_to_upper($data_clte)))
                        {
                            send_json_ok('Se guardó de forma correcta');
                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
                    send_json_error($this->upload->display_errors());
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'persona/add_sgmty_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }
 
 
 /***/
      public function nuevo_allianz_doc($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
		
		
        
        if(isset($_POST) && count($_POST) > 0)     
        {
			$this->cliente->borra_sgmty_doc($cliente_id);
            $this->load->library('form_validation');
            $this->form_validation->set_rules('nombre','Nombre documento','required');
			$this->form_validation->set_rules('servicio','Orden de servicio','required');
			
            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_id'] =  $cliente_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                $data_clte['emp_id'] =  $this->input->post('emp_id');
				$data_clte['serv_id'] = $this->input->post('servicio');
				$data_clte['doc_pkts'] ='';

				$i=1;
				$paquetes='';
				$fsm_pakts= get_costos_paquetes_empresa($this->input->post('emp_id'));
				if($fsm_pakts):
					foreach($fsm_pakts as $fsm_pakt):			
						$indice=str_replace(' ','_',$fsm_pakt['cost_nombre_pkt']).'_'.$i;
						if (strlen($this->input->post($indice)) > 1)
						{	
							$paquetes.=$this->input->post($indice);										
						}
						$i++;									
					endforeach;
				endif;
				$data_clte['doc_pkts'] = $paquetes;
				//$data_clte['contador']=$this->input->post('contador');

                $this->load->library('upload');
                if(!empty($_FILES['doc']['name']))
                {
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/docs/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg|pdf|doc|docx',
                            'max_size'      => '10000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('doc'))
                    {
                        //send_json_error($this->upload->display_errors());
						send_json_error('El documento nos se ha podido cargar, por favor revisa');
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['doc_path'] = $data['file_name'];
                        if($this->cliente->add_sgmty_doc(array_to_upper($data_clte)))
                        {
                            send_json_ok('Se guardó de forma correcta');
                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
                    send_json_error($this->upload->display_errors());
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'persona/add_sgmty_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }
 
    function descarga_doc($file)
    {
        $this->load->helper('download');
        force_download('./docs/'.$file, NULL);
    }
	
    function busca()
    {   $despacho=get_desp_id_usr();
		$emp_id_user=get_emp_id();
		$roots=get_my_user_root2();    
        $empresa = $this->input->post('empresa');
        $nombre  = strtoupper($this->input->post('nombre'));
		$paterno  = strtoupper($this->input->post('paterno'));
		$materno  = strtoupper($this->input->post('materno'));
        $rfc     = strtoupper($this->input->post('rfc'));
        $ubicacion     = strtoupper($this->input->post('ubicacion'));
        $data['clientes'] = $this->cliente->busca($empresa, $nombre,$paterno, $materno, $rfc, $ubicacion,$despacho,$emp_id_user);
        send_json_ok($this->load->view('persona/busca',$data,TRUE));
    }	
    
 /*   function hc_guarda_heredofamiliar($cliente_id)
    {
        $user = $this->session->user;
        $data_insert['clte_id'] = $cliente_id;
        $data_insert['usr_id']  = $user['usr_id'];
        $data_insert['her_fecha']   = date("Y-m-d");
        $data_insert['cie_clave'] = $this->input->post('cie');
        $data_insert['her_parent_cve'] = $this->input->post('par');
        $data_insert['her_causo_muerte_cve'] = $this->input->post('muerte');

        if($this->cliente->add_heredofamiliar(array_to_upper($data_insert)))
        {
            send_json_ok('Se guardó de forma correcta');
        }
        else
        {
            send_json_error('Ocurrió un error al guardar.');
        }
    }
    
    function hc_guarda_nopat($cliente_id)
    {
        $user = $this->session->user;
        $data_insert['clte_id'] = $cliente_id;
        $data_insert['usr_id']  = $user['usr_id'];
        $data_insert['nopat_fecha']   = date("Y-m-d");
        $data_insert['nopat_tipo_cve'] = $this->input->post('sus');
        $data_insert['nopat_f_ini'] = formatea_fecha_mysql($this->input->post('ini'));
        $data_insert['nopat_f_fin'] = formatea_fecha_mysql($this->input->post('fin'));
        $data_insert['nopat_cant'] = $this->input->post('cant');
        $data_insert['nopat_frec_cve'] = $this->input->post('frec');

        if($this->cliente->add_nopatologico(array_to_upper($data_insert)))
        {
            send_json_ok('Se guardó de forma correcta');
        }
        else
        {
            send_json_error('Ocurrió un error al guardar.');
        }
    }
    
    function hc_guarda_pat($cliente_id)
    {
        $user = $this->session->user;
        $data_insert['clte_id'] = $cliente_id;
        $data_insert['usr_id']  = $user['usr_id'];
        //$data_insert['pat_fecha']   = date("Y-m-d");
        //$data_insert['nopat_tipo_cve'] = $this->input->post('sus');
        $data_insert['pat_fecha_detecto'] = formatea_fecha_mysql($this->input->post('ini'));
        $data_insert['pat_fecha_fin'] = formatea_fecha_mysql($this->input->post('fin'));
        $data_insert['cie_clave'] = $this->input->post('cie');
        //$data_insert['nopat_frec_cve'] = $this->input->post('frec');

        if($this->cliente->add_patologico(array_to_upper($data_insert)))
        {
            send_json_ok('Se guardó de forma correcta');
        }
        else
        {
            send_json_error('Ocurrió un error al guardar.');
        }
    }
    
    function hc_borra_pat($id)
    {
        if($this->cliente->delete_patologico($id))
        {
            send_json_ok('Se eliminó de forma correcta');
        }
        else
        {
            send_json_error('Ocurrió un error al borrar.');
        }
    }
    
    function hc_guarda_signos($cliente_id)
    {
        $user = $this->session->user;
        $this->load->library('form_validation');
        $this->form_validation->set_rules('sig_talla','Talla','required');
        $this->form_validation->set_rules('sig_peso','Peso','required');
        $this->form_validation->set_rules('sig_presion_sis','Presión sistólica','required');
        $this->form_validation->set_rules('sig_presion_dias','Presión diastólica','required');
        $this->form_validation->set_rules('sig_temp','Temperatura','required');

        if($this->form_validation->run())
        {
            $data_insert['clte_id'] = $cliente_id;
            $data_insert['usr_id']  = $user['usr_id'];
            $data_insert['sig_fecha']   = date("Y-m-d H:i:s");
            $data_insert['sig_talla'] = $this->input->post('sig_talla');
            $data_insert['sig_peso'] = $this->input->post('sig_peso');
            $data_insert['sig_presion_sis'] = $this->input->post('sig_presion_sis');
            $data_insert['sig_presion_dias'] = $this->input->post('sig_presion_dias');
            $data_insert['sig_frec_card'] = $this->input->post('sig_frec_card');
            $data_insert['sig_frec_resp'] = $this->input->post('sig_frec_resp');
            $data_insert['sig_temp'] = $this->input->post('sig_temp');

            if($this->cliente->add_signosvitales(array_to_upper($data_insert)))
            {
                send_json_ok('Se guardó de forma correcta');
            }
            else
            {
                send_json_error('Ocurrió un error al guardar.');
            }
        }
        else
        {
            send_json_error(validation_errors('<div />'));
        }
    }
    
    function hc_borra_signos($id)
    {
        if($this->cliente->delete_signosvitales($id))
        {
            send_json_ok('Se eliminó de forma correcta');
        }
        else
        {
            send_json_error('Ocurrió un error al borrar.');
        }
    }
    
    function hc_borra_nopat($id)
    {
        if($this->cliente->delete_nopatologico($id))
        {
            send_json_ok('Se eliminó de forma correcta');
        }
        else
        {
            send_json_error('Ocurrió un error al borrar.');
        }
    }
    
    function hc_borra_heredofamiliar($id)
    {
        if($this->cliente->delete_heredofamiliar($id))
        {
            send_json_ok('Se eliminó de forma correcta');
        }
        else
        {
            send_json_error('Ocurrió un error al borrar.');
        }
    }
    

    
    public function estudio_pdf($cliente_id, $id)
    {
        $data['persona'] = $this->cliente->get($cliente_id);
        $data['heredo'] = $this->cliente->get_heredofamiliar($cliente_id);
        $data['nopat'] = $this->cliente->get_nopatologico($cliente_id);
        $data['pat'] = $this->cliente->get_patologico($cliente_id);
        $data['signos'] = $this->cliente->get_signosvitales($cliente_id);
        $data['cirugia'] = $this->cliente->get_cirugia($cliente_id);
        $data['discap'] = $this->cliente->get_discapacidad($cliente_id);
        $data['dificul'] = $this->cliente->get_dificultad($cliente_id);
        $data['alergia'] = $this->cliente->get_alergia($cliente_id);
        $data['gineco'] = $this->cliente->get_gineco($cliente_id);
        $this->load->helper('pdf');
        genera_pdf($this->load->view('estudio/form'.$id.'_pdf',$data,TRUE),'historia_clinica','historia_clinica','historia_clinica');  
    }

    function hc_guarda_cirugia($cliente_id)
    {
        $user = $this->session->user;
        $data_insert['clte_id'] = $cliente_id;
        $data_insert['usr_id']  = $user['usr_id'];
        $data_insert['cir_fecha']   = formatea_fecha_mysql($this->input->post('cir_fecha'));
        $data_insert['proc_cve_proc'] = $this->input->post('proc_cve_proc');
        $data_insert['cir_notas_crypt'] = $this->input->post('cir_notas');

        if($this->cliente->add_cirugia(array_to_upper($data_insert)))
        {
            send_json_ok('Se guardó de forma correcta');
        }
        else
        {
            send_json_error('Ocurrió un error al guardar.');
        }
    }
    
    function hc_guarda_discap($cliente_id)
    {
        $user = $this->session->user;
        $data_insert['clte_id'] = $cliente_id;
        $data_insert['usr_id']  = $user['usr_id'];
        $data_insert['discap_cve'] = $this->input->post('discap_cve');
        $data_insert['dis_cif_nota_crypt'] = $this->input->post('dis_cif_nota');

        if($this->cliente->add_discapacidad(array_to_upper($data_insert)))
        {
            send_json_ok('Se guardó de forma correcta');
        }
        else
        {
            send_json_error('Ocurrió un error al guardar.');
        }
    }
    
    function hc_guarda_dific($cliente_id)
    {
        $user = $this->session->user;
        $data_insert['clte_id'] = $cliente_id;
        $data_insert['usr_id']  = $user['usr_id'];
        $data_insert['dis_dif_tipo_cve'] = $this->input->post('dis_dif_tipo_cve');
        $data_insert['dis_dif_orig_cve'] = $this->input->post('dis_dif_orig_cve');
        $data_insert['dis_dif_grado_cve'] = $this->input->post('dis_dif_grado_cve');
        $data_insert['dis_cif_nota_crypt'] = $this->input->post('dis_cif_nota');

        if($this->cliente->add_discapacidad(array_to_upper($data_insert)))
        {
            send_json_ok('Se guardó de forma correcta');
        }
        else
        {
            send_json_error('Ocurrió un error al guardar.');
        }
    }
    
    function hc_guarda_alergia($cliente_id)
    {
        $user = $this->session->user;
        $data_insert['clte_id'] = $cliente_id;
        $data_insert['usr_id']  = $user['usr_id'];
        $data_insert['alerg_alergeno'] = $this->input->post('alerg_alergeno');
        $data_insert['alerg_reaccion'] = $this->input->post('alerg_reaccion');
        $data_insert['alerg_nota_crypt'] = $this->input->post('alerg_nota');

        if($this->cliente->add_alergia(array_to_upper($data_insert)))
        {
            send_json_ok('Se guardó de forma correcta');
        }
        else
        {
            send_json_error('Ocurrió un error al guardar.');
        }
    }
    
    function hc_borra_cirugia($id)
    {
        if($this->cliente->delete_cirugia($id))
        {
            send_json_ok('Se eliminó de forma correcta');
        }
        else
        {
            send_json_error('Ocurrió un error al borrar.');
        }
    }
    
    function hc_borra_discap($id)
    {
        if($this->cliente->delete_discapacidad($id))
        {
            send_json_ok('Se eliminó de forma correcta');
        }
        else
        {
            send_json_error('Ocurrió un error al borrar.');
        }
    }
    
    function hc_borra_alergia($id)
    {
        if($this->cliente->delete_alergia($id))
        {
            send_json_ok('Se eliminó de forma correcta');
        }
        else
        {
            send_json_error('Ocurrió un error al borrar.');
        }
    }
    
    function hc_guarda_gineco($cliente_id)
    {
        $gin_id = ($this->uri->segment(4) == '')?0:$this->uri->segment(4);
        
        $user = $this->session->user;
        $data_insert['clte_id'] = $cliente_id;
        $data_insert['usr_id']  = $user['usr_id'];
        $data_insert['gin_ritmo_cve'] = $this->input->post('gin_ritmo_cve');
        $data_insert['gin_menst_cada'] = $this->input->post('gin_menst_cada');
        $data_insert['gin_menst_dura'] = $this->input->post('gin_menst_dura');
        $data_insert['gin_f_ult_menst'] = formatea_fecha_mysql($this->input->post('gin_f_ult_mens'));
        $data_insert['gin_ivsa'] = $this->input->post('gin_ivsa');
        $data_insert['gin_mpf_cve'] = $this->input->post('gin_mpf_cve');
        $data_insert['gin_docma_f'] = formatea_fecha_mysql($this->input->post('gin_docma_f'));
        $data_insert['gin_docma_nota_crypt'] = $this->input->post('gin_docma_nota');
        $data_insert['gin_papanic_f'] = formatea_fecha_mysql($this->input->post('gin_papanic_f'));
        $data_insert['gin_papanic_nota_crypt'] = $this->input->post('gin_papanic_nota');
        $data_insert['gin_colposc_f'] = formatea_fecha_mysql($this->input->post('gin_colposc_f'));
        $data_insert['gin_colposc_nota_crypt'] = $this->input->post('gin_colposc_nota');
        
        $data_insert['gin_num_gestas'] = $this->input->post('gin_num_gestas');
        $data_insert['gin_num_abortos'] = $this->input->post('gin_num_abortos');
        $data_insert['gin_num_partos'] = $this->input->post('gin_num_partos');
        $data_insert['gin_num_cesareas'] = $this->input->post('gin_num_cesareas');
        $data_insert['gin_f_ult_parto'] = formatea_fecha_mysql($this->input->post('gin_f_ult_parto'));
        $data_insert['gin_f_ult_aborto'] = formatea_fecha_mysql($this->input->post('gin_f_ult_aborto'));
        $data_insert['gin_notas_crypt'] = $this->input->post('nota');

        if($gin_id === 0)
        {
            if($this->cliente->add_gineco(array_to_upper($data_insert)))
            {
                send_json_ok('Se guardó de forma correcta');
            }
            else
            {
                send_json_error('Ocurrió un error al guardar.');
            }
        }
        else
        {
            if($this->cliente->update_gineco($gin_id, array_to_upper($data_insert)))
            {
                send_json_ok('Se guardó de forma correcta');
            }
            else
            {
                send_json_error('Ocurrió un error al guardar.');
            }
        }
    } */
}