﻿<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Guia extends CI_Controller {
    
    function __construct() {
        parent::__construct();
        $this->load->model('guia/Guia_model','cliente');
        $this->load->model('empleado/Empleado_model','medico');
    }
    
    
    public function id($id)
    {
		
        $data['cliente'] = $this->cliente->get($id);
        if($data['cliente'])
        {
            $id=1; 
            $data['docs'] = $this->cliente->get_docs($id);
		
			$data['docs_guias'] = $this->cliente->get_docs_section($id,'GUIAS');
			
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Guias',
                'view' => 'guia/cliente',
                'view_data' => $data 
               );
            render_template($params_view);  
        }
        else
        {
            show_error('El cliente no existe.');
        }
    }
    
  
    
    public function nuevo_doc($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('nombre','Nombre documento','required');

            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_id'] = 1;  //$cliente_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                $data_clte['empresa'] =  $this->input->post('empre');
				$data_clte['doc_fecha_efectiva'] =  formatea_fecha_mysql($this->input->post('fecha_efe'));
				
                $this->load->library('upload');
				
				
				
                if(!empty($_FILES['doc']['name']))
                {
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/isos/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'gif|png|jpg|jpeg|pdf|doc|docx|xls|xlsx|pptx|ppt|mp4',
                            'max_size'      => '50000'
                    );
					
					
                    
					$this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('doc'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['doc_path'] = $data['file_name'];
                        if($this->cliente->add_doc(array_to_upper($data_clte)))
                        {
                            send_json_ok('Se guardó de forma correcta');
                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
                    send_json_error($this->upload->display_errors());
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Guias',
                'view' => 'guia/add_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }
    
    function descarga_doc($file)
    {
        $this->load->helper('download');
        force_download('./docs/'.$file, NULL);
    }
    
   

    
    function busca()
    {        
        $empresa = $this->input->post('empresa');
        $nombre  = strtoupper($this->input->post('nombre'));
        $rfc     = strtoupper($this->input->post('rfc'));
        $data['clientes'] = $this->cliente->busca($empresa, $nombre, $rfc);
        send_json_ok($this->load->view('publicidad/busca',$data,TRUE));
    }
    
    public function borra_iso($fsm_id)
    {
		$documento=$this->cliente->get_doc($fsm_id);
		$documento['doc_path']=strtolower($documento['doc_path']);
		$this->cliente->inserta_borrado($documento);
        if($this->cliente->delete_iso($fsm_id))
        {
            send_json_ok('Se eliminó de forma correcta.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar.');
        }
    }


}