﻿<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Conduce extends CI_Controller {
    
    function __construct() {
        parent::__construct();
        $this->load->model('conduce/Conduce_model','cliente');
		$this->load->model('empleado/Empleado_model','usuario');
		$this->load->model('examen/Conduce_comentarios_model','comentarios');
		$this->load->model('sasegurados/Sasegurados_model','asegurado');
		$this->load->model('servicio/Servicio_model','servicio');
		$this->load->model('empleado/Empleado_model','medico');
		$this->load->helper('util');
    }




    public function nuevo_entrega($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
        $user = $this->session->user;
		$usuario = $this->usuario->get($user['usr_id']);
        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
				$this->form_validation->set_rules('seccion_externa_a' ,'Sección externa A','required');
				$this->form_validation->set_rules('seccion_externa_b' ,'Sección externa B','required');
				$this->form_validation->set_rules('seccion_externa_c' ,'Sección externa C','required');
				$this->form_validation->set_rules('seccion_externa_d' ,'Sección externa D','required');
				$this->form_validation->set_rules('seccion_interna_a' ,'Sección interna A','required');
				$this->form_validation->set_rules('seccion_interna_b' ,'Sección interna B','required');
				$this->form_validation->set_rules('seccion_interna_c','Sección interna D','required'); 
				$this->form_validation->set_rules('seccion_interna_d' ,'Sección interna C','required'); 
				$this->form_validation->set_rules('quien_recibe' ,'Persona que recibe el Vehículo','required'); 
				
            if($this->form_validation->run())
            {
              $data_insert['cond_id']  = $cliente_id;
                $data_insert['cond_conductor']  = $usuario['usr_id'];
                $data_insert['cond_poliza'] = $persona['cond_poliza'];
                $data_insert['cond_origen']  = $persona['cond_origen'];

				$data_insert['seccion_externa_a'] = $this->input->post('seccion_externa_a');
				$data_insert['det_seccion_externa_a'] = $this->input->post('det_seccion_externa_a');
				$data_insert['seccion_externa_b'] = $this->input->post('seccion_externa_b');
				$data_insert['det_seccion_externa_b'] = $this->input->post('det_seccion_externa_b');
				$data_insert['seccion_externa_c'] = $this->input->post('seccion_externa_c');
				$data_insert['det_seccion_externa_c'] = $this->input->post('det_seccion_externa_c');
				$data_insert['seccion_externa_d'] = $this->input->post('seccion_externa_d');
				$data_insert['det_seccion_externa_d'] = $this->input->post('det_seccion_externa_d');
				$data_insert['seccion_interna_a'] = $this->input->post('seccion_interna_a');
				$data_insert['det_seccion_interna_a'] = $this->input->post('det_seccion_interna_a');
				$data_insert['seccion_interna_b'] = $this->input->post('seccion_interna_b');
				$data_insert['det_seccion_interna_b'] = $this->input->post('det_seccion_interna_b');
				$data_insert['seccion_interna_c'] = $this->input->post('seccion_interna_c');
				$data_insert['det_seccion_interna_c'] = $this->input->post('det_seccion_interna_c');
				$data_insert['seccion_interna_d'] = $this->input->post('seccion_interna_d');
				$data_insert['det_seccion_interna_d'] = $this->input->post('det_seccion_interna_d');
				$data_insert['recibe_obs'] = $this->input->post('recibe_obs');
				$data_insert['quien_recibe'] = $this->input->post('quien_recibe');
				$data_insert['kilometraje'] = $this->input->post('kilometraje');
				$data_insert['cap_gas'] = $this->input->post('cap_gas');
				$data_insert['cond_f_entregado']  =  date('Y-m-d H:i:s');
				$data_insert['log_insrt_f']  =  date('Y-m-d H:i:s');
                $data_insert=array_to_upper($data_insert);
				
				if($this->input->post('firma_med') != '')
                {
                    $data_insert['fsm_firma_med'] = $this->input->post('firma_med');
                }
				
                if($this->input->post('firma_pac') != '')
                {
                    $data_insert['fsm_firma_pac'] = $this->input->post('firma_pac');
                }
				
				
                if ($this->cliente->inserta_documento_entrega($data_insert))
                {
                    send_json_ok('Se guardó de forma correcta');
                }
                else
                {
                    send_json_error('Ocurrió un error al guardar.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['conduce'] = $persona;
            $data['medico'] = $medico;
            $this->load->helper('template');
            $params_view = array(
                'title' => 'nuevo_form_entrega',
                'view' => 'conduce/nuevo_form_entrega',
                'view_data' => $data 
               );
            render_template($params_view);
        }
    }


    public function pdf_entrega_sura($cliente_id, $fsm_id)
    {
        $data['conduce'] = $this->cliente->get($cliente_id);
        $data['fsm'] = $this->cliente->get_doc_entrega($fsm_id);
        $data['usuario'] = $this->usuario->get($data['fsm']['con_conductor']);
        $this->load->helper('pdf');
		//genera_pdf_lab_new_y ($this->load->view('conduce/pdf_recibe',$data,TRUE),'conduce_recibe','conduce_recibe',$med_name,$observaciones,$fuera_rango);	
		sura_amplete($this->load->view('conduce/pdf_entrega_sura',$data,TRUE), 'conduce_entregado','conduce_entregado','Humancenter Review S.A de C.V.');
	}



    public function pdf_recibe_sura($cliente_id, $fsm_id)
    {
        $data['conduce'] = $this->cliente->get($cliente_id);
        $data['fsm'] = $this->cliente->get_doc_recibe($fsm_id);
        $data['usuario'] = $this->usuario->get($data['fsm']['con_conductor']);
        $this->load->helper('pdf');
		//genera_pdf_lab_new_y ($this->load->view('conduce/pdf_recibe',$data,TRUE),'conduce_recibe','conduce_recibe',$med_name,$observaciones,$fuera_rango);	
		sura_amplete($this->load->view('conduce/pdf_recibe_sura',$data,TRUE), 'conduce_recibe','conduce_recibe','Humancenter Review S.A de C.V.');
	}
	
    public function pdf_resumen($cliente_id, $fsm_id)
    {
        $data['conduce'] = $this->cliente->get($cliente_id);
        $data['fsm'] = $this->cliente->get_doc_resumen($fsm_id);
        $data['usuario'] = $this->usuario->get($data['fsm']['con_conductor']);
		$data['fsm2'] = $this->cliente->get_doc_entrega_by_cliente($cliente_id);
        $this->load->helper('pdf');
		//genera_pdf_lab_new_y ($this->load->view('conduce/pdf_recibe',$data,TRUE),'conduce_recibe','conduce_recibe',$med_name,$observaciones,$fuera_rango);	
		sura_amplete($this->load->view('conduce/pdf_resumen_sura',$data,TRUE), 'conduce_resumen','conduce_resumen','Humancenter Review S.A de C.V.');
	}	
	

    public function pdf_recibe($cliente_id, $fsm_id)
    {
        $data['conduce'] = $this->cliente->get($cliente_id);
        $data['fsm'] = $this->cliente->get_doc_recibe($fsm_id);
        $data['usuario'] = $this->usuario->get($data['fsm']['con_conductor']);
        $this->load->helper('pdf');
		//genera_pdf_lab_new_y ($this->load->view('conduce/pdf_recibe',$data,TRUE),'conduce_recibe','conduce_recibe',$med_name,$observaciones,$fuera_rango);	
		xamplete ($this->load->view('conduce/pdf_recibe',$data,TRUE), 'conduce_recibe','conduce_recibe','Humancenter Review S.A de C.V.');
	}


	
    public function pdf_entrega($cliente_id, $fsm_id)
    {
        $data['conduce'] = $this->cliente->get($cliente_id);
        $data['fsm'] = $this->cliente->get_doc_entrega($fsm_id);
        $data['usuario'] = $this->usuario->get($data['fsm']['con_conductor']);
        $this->load->helper('pdf');
		//genera_pdf_lab_new_y ($this->load->view('conduce/pdf_recibe',$data,TRUE),'conduce_recibe','conduce_recibe',$med_name,$observaciones,$fuera_rango);	
		xamplete ($this->load->view('conduce/pdf_entrega',$data,TRUE), 'conduce_recibe','conduce_recibe','Humancenter Review S.A de C.V.');
	}	
	

    public function nuevo_recibo($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
        $user = $this->session->user;
		$usuario = $this->usuario->get($user['usr_id']);
        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
				$this->form_validation->set_rules('seccion_externa_a' ,'Sección externa A','required');
				$this->form_validation->set_rules('seccion_externa_b' ,'Sección externa B','required');
				$this->form_validation->set_rules('seccion_externa_c' ,'Sección externa C','required');
				$this->form_validation->set_rules('seccion_externa_d' ,'Sección externa D','required');
				$this->form_validation->set_rules('seccion_interna_a' ,'Sección interna A','required');
				$this->form_validation->set_rules('seccion_interna_b' ,'Sección interna B','required');
				$this->form_validation->set_rules('seccion_interna_c','Sección interna D','required'); 
				$this->form_validation->set_rules('seccion_interna_d' ,'Sección interna C','required'); 

            if($this->form_validation->run())
            {
              $data_insert['cond_id']  = $cliente_id;
                $data_insert['cond_conductor']  = $usuario['usr_id'];
                $data_insert['cond_poliza'] = $persona['cond_poliza'];
                $data_insert['cond_origen']  = $persona['cond_origen'];

				$data_insert['seccion_externa_a'] = $this->input->post('seccion_externa_a');
				$data_insert['det_seccion_externa_a'] = $this->input->post('det_seccion_externa_a');
				$data_insert['seccion_externa_b'] = $this->input->post('seccion_externa_b');
				$data_insert['det_seccion_externa_b'] = $this->input->post('det_seccion_externa_b');
				$data_insert['seccion_externa_c'] = $this->input->post('seccion_externa_c');
				$data_insert['det_seccion_externa_c'] = $this->input->post('det_seccion_externa_c');
				$data_insert['seccion_externa_d'] = $this->input->post('seccion_externa_d');
				$data_insert['det_seccion_externa_d'] = $this->input->post('det_seccion_externa_d');
				$data_insert['seccion_interna_a'] = $this->input->post('seccion_interna_a');
				$data_insert['det_seccion_interna_a'] = $this->input->post('det_seccion_interna_a');
				$data_insert['seccion_interna_b'] = $this->input->post('seccion_interna_b');
				$data_insert['det_seccion_interna_b'] = $this->input->post('det_seccion_interna_b');
				$data_insert['seccion_interna_c'] = $this->input->post('seccion_interna_c');
				$data_insert['det_seccion_interna_c'] = $this->input->post('det_seccion_interna_c');
				$data_insert['seccion_interna_d'] = $this->input->post('seccion_interna_d');
				$data_insert['det_seccion_interna_d'] = $this->input->post('det_seccion_interna_d');
				$data_insert['recibe_obs'] = $this->input->post('recibe_obs');
				
				$data_insert['kilometraje'] = $this->input->post('kilometraje');
				$data_insert['cap_gas'] = $this->input->post('cap_gas');
				$data_insert['cond_f_recibido']  =  date('Y-m-d H:i:s');
				$data_insert['log_insrt_f']  =  date('Y-m-d H:i:s');
                $data_insert=array_to_upper($data_insert);
				
				if($this->input->post('firma_med') != '')
                {
                    $data_insert['fsm_firma_med'] = $this->input->post('firma_med');
                }
				
                if($this->input->post('firma_pac') != '')
                {
                    $data_insert['fsm_firma_pac'] = $this->input->post('firma_pac');
                }
				
				
                if ($this->cliente->inserta_documento_recibo($data_insert))
                {
                    send_json_ok('Se guardó de forma correcta');
                }
                else
                {
                    send_json_error('Ocurrió un error al guardar.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['conduce'] = $persona;
            $data['medico'] = $medico;
            $this->load->helper('template');
            $params_view = array(
                'title' => 'nuevo_form_recibo',
                'view' => 'conduce/nuevo_form_recibo',
                'view_data' => $data 
               );
            render_template($params_view);
        }
    }



    public function nuevo_recibo_sura($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
        $user = $this->session->user;
		$usuario = $this->usuario->get($user['usr_id']);
        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
			/*	$this->form_validation->set_rules('seccion_externa_a' ,'Sección externa A','required');
				$this->form_validation->set_rules('seccion_externa_b' ,'Sección externa B','required');
				$this->form_validation->set_rules('seccion_externa_c' ,'Sección externa C','required');
				$this->form_validation->set_rules('seccion_externa_d' ,'Sección externa D','required');
				$this->form_validation->set_rules('seccion_interna_a' ,'Sección interna A','required');
				$this->form_validation->set_rules('seccion_interna_b' ,'Sección interna B','required');
				$this->form_validation->set_rules('seccion_interna_c','Sección interna D','required'); 
				$this->form_validation->set_rules('seccion_interna_d' ,'Sección interna C','required'); 
			*/
			$this->form_validation->set_rules('pregunta_1','Pregunta 1','required'); 
		/*	$this->form_validation->set_rules('bateria','Batería','required'); 
			$this->form_validation->set_rules('alfombra','Alfombra','required'); 
			$this->form_validation->set_rules('asientos_delanteros','Asientos Delanteros','required'); 
			$this->form_validation->set_rules('asientos_traseros','Asientos Traseros','required'); 
			$this->form_validation->set_rules('botones_radio_estereo','Botones Radio Estereo','required'); 
			$this->form_validation->set_rules('bocinas_radio','Bocinas Radio','required'); 
			$this->form_validation->set_rules('bocinas_radio_marca','Marca de Bocinas Radio','required'); 
			$this->form_validation->set_rules('bocinas_radio_numero','Número Bocinas Radio','required'); 
			$this->form_validation->set_rules('cabeceras','Cabeceras','required'); 
			$this->form_validation->set_rules('bolsas_de_aire','Bolsas de Aire','required'); 
			$this->form_validation->set_rules('bolsas_de_aire_numero','Número Bolsas de Aire','required'); 
			$this->form_validation->set_rules('cajuela_de_guantes','Cajuela de Guantes','required'); 
			$this->form_validation->set_rules('ceniceros','Ceniceros','required'); 
			$this->form_validation->set_rules('cinturones_de_seguridad','Cinturones de Seguridad','required'); 
			$this->form_validation->set_rules('claxón','Claxón','required'); 
			$this->form_validation->set_rules('coderas','Coderas','required'); 
			$this->form_validation->set_rules('compac_disc','Compac Disc','required'); 
			$this->form_validation->set_rules('compac_disc_marca','Marca Compac Disc','required'); 
			$this->form_validation->set_rules('consola','Consola','required'); 
			$this->form_validation->set_rules('control_aire_acondicionado','Control Aire Acondicionado','required'); 
			$this->form_validation->set_rules('control_calefación','Control Calefacción','required'); 
			$this->form_validation->set_rules('control_eléctrico','Control Eléctrico','required'); 
			$this->form_validation->set_rules('defroster','Defroster','required'); 
			$this->form_validation->set_rules('encendedor','Encendedor','required'); 
			$this->form_validation->set_rules('espejo_interior','Espejo Interior','required'); 
			$this->form_validation->set_rules('extinguidor','Extinguidor','required'); 
			$this->form_validation->set_rules('luz_interior','Luz Interior','required'); 
			$this->form_validation->set_rules('luz_stop','Luz Stop','required'); 
			$this->form_validation->set_rules('manijas_interiores','Manijas Interiores','required'); 
			$this->form_validation->set_rules('palanca_de_velocidades','Palanca de Velocidades','required'); 
			$this->form_validation->set_rules('perilla_palanca','Perilla Palanca','required'); 
			$this->form_validation->set_rules('radio_estereo','Radio Estéreo','required'); 
			$this->form_validation->set_rules('radio_estereo_marca','Radio Estéreo Marca','required'); 
			$this->form_validation->set_rules('reloj','Reloj','required'); 
			$this->form_validation->set_rules('seguros_eléctricos','Seguros Eléctricos','required'); 
			$this->form_validation->set_rules('tablero','Tablero','required'); 
			$this->form_validation->set_rules('tapetes','Tapetes','required'); 
			$this->form_validation->set_rules('tapetes_numero','Tapetes Numero','required'); 
			$this->form_validation->set_rules('ventanas_eléctricas','Ventanas Eléctricas','required'); 
			$this->form_validation->set_rules('vestiduras','Vestiduras','required'); 
			$this->form_validation->set_rules('viceras','Viceras','required'); 
			$this->form_validation->set_rules('volante','Volante','required'); 
			$this->form_validation->set_rules('alfombra_cajuela','Alfombra Cajuela','required'); 
			$this->form_validation->set_rules('cables_para_corriente','Cables para Corriente','required'); 
			$this->form_validation->set_rules('cartón_cajuela','Cartón Cajuela','required'); 
			$this->form_validation->set_rules('gato','Gato','required'); 
			$this->form_validation->set_rules('gato_tipo','Gato Tipo','required'); 
			$this->form_validation->set_rules('herramientas','Herramientas','required'); 
			$this->form_validation->set_rules('herramientas_numero','Número de Herramientas','required'); 
			$this->form_validation->set_rules('llave_de_ruedas','Llave de Ruedas','required'); 
			$this->form_validation->set_rules('llanta_refac','Llanta de Refacción','required'); 
			$this->form_validation->set_rules('llanta_refac_marca','Marca de Llanta de Refacción','required'); 
			$this->form_validation->set_rules('llanta_refac_vida','Vida de Llanta de Refacción','required'); 
			$this->form_validation->set_rules('señales_de_carretera','Señales de Carretera','required'); 
			$this->form_validation->set_rules('biseles','Biseles','required'); 
			$this->form_validation->set_rules('brazos_limpiadores','Brazos Limpiadores','required'); 
			$this->form_validation->set_rules('cofre','Cofre','required'); 
			$this->form_validation->set_rules('cuartos_de_luz','Cuartos de Luz','required'); 
			$this->form_validation->set_rules('defensa_delatera','Defensa Delantera','required'); 
			$this->form_validation->set_rules('faros_halógeno','Faros Halógeno','required'); 
			$this->form_validation->set_rules('faros_niebla','Faros Niebla','required'); 
			$this->form_validation->set_rules('parabrisas','Parabrisas','required'); 
			$this->form_validation->set_rules('parrilla','Parrilla','required'); 
			$this->form_validation->set_rules('plumas_limpiadoras','Plumas Limpiadoras','required'); 
			
			$this->form_validation->set_rules('topes_trasero','Topes Taseros','required'); 
			$this->form_validation->set_rules('brazo_limpiador','Brazo Limpiador','required'); 
			$this->form_validation->set_rules('calavera','Calavera','required'); 
			$this->form_validation->set_rules('chapa_cajuela','Chapa Cajuela','required'); 
			$this->form_validation->set_rules('defensa_trasera','Defensa Trasera','required'); 
			$this->form_validation->set_rules('medallón','Medallón','required'); 
			$this->form_validation->set_rules('pluma_limpiador','Pluma Limpiador','required'); 
			$this->form_validation->set_rules('porta_placa_delantero','Porta Placa Delantero','required'); 
			$this->form_validation->set_rules('porta_placa_trasero','Porta Placa Trasero','required'); 
			$this->form_validation->set_rules('sistema_escape','Sistema Escape','required'); 
			$this->form_validation->set_rules('tapa_cajuela','Tapa Cajuela','required'); 
			$this->form_validation->set_rules('topes_delantero','Topes Delantero','required'); 
			$this->form_validation->set_rules('antena','Antena','required'); 
			$this->form_validation->set_rules('canastilla','Canastilla','required'); 
			$this->form_validation->set_rules('emblemas','Emblemas','required'); 
			$this->form_validation->set_rules('espoilers_delantero','Espoilers Delanteros','required'); 
			$this->form_validation->set_rules('espoilers_trasero','Espoilers Traseros','required'); 
			$this->form_validation->set_rules('fusibles_relevadores','Fusibles Relevadores','required'); 
			
			$this->form_validation->set_rules('quemacocos','Quemacocos','required'); 
			$this->form_validation->set_rules('rines','Rines','required'); 
			$this->form_validation->set_rules('tapón_de_gasolina','Tapón de Gasolina','required'); 
			$this->form_validation->set_rules('toldo','Toldo','required'); 
			$this->form_validation->set_rules('alarma','Alarma','required'); 
			$this->form_validation->set_rules('extinguidor','Extinguidor','required'); 
			$this->form_validation->set_rules('llanta_dd','Llanta Delantera Derecha','required'); 
			$this->form_validation->set_rules('llanta_di','Llanta Delantera Izquierda','required'); 
			$this->form_validation->set_rules('llanta_td','Llanta Trasera Derecha','required'); 
			$this->form_validation->set_rules('llanta_ti','Llanta Trasera Izquierda','required'); 
			$this->form_validation->set_rules('llaves','Llaves','required'); 
			$this->form_validation->set_rules('llavero','Llavero','required'); 
			$this->form_validation->set_rules('control','Control','required'); 
			$this->form_validation->set_rules('objetos_personales','Objetos Personales','required'); 
			$this->form_validation->set_rules('otros_papeles','Otros Papeles','required'); 
			$this->form_validation->set_rules('placa_vin','Placa Vin','required'); 
			$this->form_validation->set_rules('telefóno','Teléfono','required'); 
			$this->form_validation->set_rules('aletas_d','Aletas Lado Derecho','required'); 
			$this->form_validation->set_rules('costados_d','Costados Lado Derecho','required'); 
			$this->form_validation->set_rules('cristales_puerta_delantera_d','Cristales Puerta Delantera Lado Derecho','required'); 
			$this->form_validation->set_rules('cristales_puerta_trasera_d','Cristales Puerta Trasera Lado Derecho','required'); 
			$this->form_validation->set_rules('espejo_exterior_d','Espejo Exterior Lado Derecho','required'); 
			$this->form_validation->set_rules('estribo_d','Estribo Lado Derecho','required'); 
			$this->form_validation->set_rules('manijas_exteriores_d','Manijas Exterior Lado Derecho','required'); 
			$this->form_validation->set_rules('molduras_d','Molduras Lado Derecho','required'); 
			$this->form_validation->set_rules('molduras_numero_d','Número Molduras Lado Derecho','required'); 
			$this->form_validation->set_rules('puerta_delantera_d','Puerta Delantera Lado Derecho','required'); 
			$this->form_validation->set_rules('puerta_trasera_d','Puerta Trasera Lado Derecho','required'); 
			$this->form_validation->set_rules('reflejante_lateral_delantero_d','Reflejante Lateral Delantero Lado Derecho','required'); 
			$this->form_validation->set_rules('reflejante_lateral_trasero_d','Reflejante Lateral Trasero Lado Derecho','required'); 
			$this->form_validation->set_rules('salpicadero_d','Salpicadera Lado Derecho','required'); 
			$this->form_validation->set_rules('tapones_ruedas_d','Tapones de Ruedas Lado Derecho','required'); 
			$this->form_validation->set_rules('aletas_i','Aletas Izquierdo','required'); 
			$this->form_validation->set_rules('costados_i','Costados Izquierdo','required'); 
			$this->form_validation->set_rules('cristales_puerta_delantera_i','Cristales Puerta Delantera Lado Izquierdo','required'); 
			$this->form_validation->set_rules('cristales_puerta_trasera_i','Cristales Puerta Trasera Lado Izquierdo','required'); 
			$this->form_validation->set_rules('espejo_exterior_i','Espejo Exterior Lado Izquierdo','required'); 
			$this->form_validation->set_rules('estribo_i','Estribo Lado Izquierdo','required'); 
			$this->form_validation->set_rules('manijas_exteriores_i','Manijas Exteriores Lado Izquierdo','required'); 
			$this->form_validation->set_rules('molduras_i','Molduras Lado Izquierdo','required'); 
			$this->form_validation->set_rules('molduras_numero_i','Molduras Numero Lado Izquierdo','required'); 
			$this->form_validation->set_rules('puerta_delantera_i','Puerta Delantera Lado Izquierdo','required'); 
			$this->form_validation->set_rules('puerta_trasera_i','Puerta Trasera Lado Izquierdo','required'); 
			$this->form_validation->set_rules('reflejante_lateral_delantero_i','Reflejante Lateral Delantero Lado Izquierdo','required'); 
			$this->form_validation->set_rules('reflejante_lateral_trasero_i','Reflejante Lateral Trasero Lado Izquierdo','required'); 
			$this->form_validation->set_rules('salpicadero_i','Salpicadero Lado Izquierdo','required'); 
			$this->form_validation->set_rules('tapones_ruedas_i','Tapones Ruedas Lado Izquierdo','required'); 
			$this->form_validation->set_rules('pasajero_1','Pasajero 1','required'); 
			$this->form_validation->set_rules('pasajero_2','Pasajero 2','required'); 
			$this->form_validation->set_rules('pasajero_3','Pasajero 3','required'); 
			$this->form_validation->set_rules('pasajero_4','Pasajero 4','required'); 
			$this->form_validation->set_rules('pasajero_5','Pasajero 5','required'); 			
			*/
			
            if($this->form_validation->run())
            {
				$data_insert['cond_id']  = $cliente_id;
                $data_insert['cond_conductor']  = $usuario['usr_id'];
                $data_insert['cond_poliza'] = $persona['cond_poliza'];
                $data_insert['cond_origen']  = $persona['cond_origen'];

				$data_insert['pregunta_1']  = $this->input->post('pregunta_1');
				$data_insert['det_pregunta_1']  = $this->input->post('det_pregunta_1');
				$data_insert['pregunta_2']  = $this->input->post('pregunta_2');
				$data_insert['det_pregunta_2']  = $this->input->post('det_pregunta_2');
				$data_insert['pregunta_3']  = $this->input->post('pregunta_3');
				$data_insert['det_pregunta_3']  = $this->input->post('det_pregunta_3');
				$data_insert['pregunta_4']  = $this->input->post('pregunta_4');
				$data_insert['det_pregunta_4']  = $this->input->post('det_pregunta_4');
				$data_insert['pregunta_5']  = $this->input->post('pregunta_5');
				$data_insert['det_pregunta_5']  = $this->input->post('det_pregunta_5');
				$data_insert['pregunta_6']  = $this->input->post('pregunta_6');
				$data_insert['det_pregunta_6']  = $this->input->post('det_pregunta_6');

				$data_insert['numero_serie_motor']  = $this->input->post('numero_serie_motor');
				$data_insert['color_auto']  = $this->input->post('color_auto');
				
				$data_insert['kilometraje_inicial'] = $this->input->post('kilometraje_inicial');
				$data_insert['cap_gas_inicial'] = $this->input->post('cap_gas_inicial');

				$data_insert['seccion_externa_a'] = $this->input->post('seccion_externa_a');
				$data_insert['det_seccion_externa_a'] = $this->input->post('det_seccion_externa_a');
				$data_insert['seccion_externa_b'] = $this->input->post('seccion_externa_b');
				$data_insert['det_seccion_externa_b'] = $this->input->post('det_seccion_externa_b');
				$data_insert['seccion_externa_c'] = $this->input->post('seccion_externa_c');
				$data_insert['det_seccion_externa_c'] = $this->input->post('det_seccion_externa_c');
				$data_insert['seccion_externa_d'] = $this->input->post('seccion_externa_d');
				$data_insert['det_seccion_externa_d'] = $this->input->post('det_seccion_externa_d');
				
				$data_insert['seccion_interna_a'] = $this->input->post('seccion_interna_a');
				$data_insert['det_seccion_interna_a'] = $this->input->post('det_seccion_interna_a');
				$data_insert['seccion_interna_b'] = $this->input->post('seccion_interna_b');
				$data_insert['det_seccion_interna_b'] = $this->input->post('det_seccion_interna_b');
				$data_insert['seccion_interna_c'] = $this->input->post('seccion_interna_c');
				$data_insert['det_seccion_interna_c'] = $this->input->post('det_seccion_interna_c');
				$data_insert['seccion_interna_d'] = $this->input->post('seccion_interna_d');
				$data_insert['det_seccion_interna_d'] = $this->input->post('det_seccion_interna_d');

				$data_insert['fsm_alfombra_cajuela'] = $this->input->post('alfombra_cajuela');
				$data_insert['fsm_cables_para_corriente'] = $this->input->post('cables_para_corriente');
				$data_insert['fsm_cartón_cajuela'] = $this->input->post('cartón_cajuela');
				$data_insert['fsm_gato'] = $this->input->post('gato');
				$data_insert['fsm_gato_tipo'] = $this->input->post('gato_tipo');
				$data_insert['fsm_herramientas'] = $this->input->post('herramientas');
				$data_insert['fsm_herramientas_numero'] = $this->input->post('herramientas_numero');
				$data_insert['fsm_llave_de_ruedas'] = $this->input->post('llave_de_ruedas');
				$data_insert['fsm_llanta_refac'] = $this->input->post('llanta_refac');
				$data_insert['fsm_llanta_refac_marca'] = $this->input->post('llanta_refac_marca');
				$data_insert['fsm_llanta_refac_vida'] = $this->input->post('llanta_refac_vida');
				$data_insert['fsm_señales_de_carretera'] = $this->input->post('señales_de_carretera');
				
				$data_insert['fsm_pasajero_1'] = $this->input->post('pasajero_1');
				$data_insert['fsm_pasajero_2'] = $this->input->post('pasajero_2');
				$data_insert['fsm_pasajero_3'] = $this->input->post('pasajero_3');
				$data_insert['fsm_pasajero_4'] = $this->input->post('pasajero_4');
				$data_insert['fsm_pasajero_5'] = $this->input->post('pasajero_5');					
				
				$data_insert['valores'] = $this->input->post('valores');
				
				
				$data_insert['recibe_obs'] = $this->input->post('recibe_obs');
				
				
				$data_insert['cond_f_recibido']  =  date('Y-m-d H:i:s');
				$data_insert['log_insrt_f']  =  date('Y-m-d H:i:s');


			/*
				$data_insert['fsm_alternador'] = $this->input->post('alternador');
				$data_insert['fsm_bateria'] = $this->input->post('bateria');
				$data_insert['fsm_alfombra'] = $this->input->post('alfombra');
				$data_insert['fsm_asientos_delanteros'] = $this->input->post('asientos_delanteros');
				$data_insert['fsm_asientos_traseros'] = $this->input->post('asientos_traseros');
				$data_insert['fsm_botones_radio_estereo'] = $this->input->post('botones_radio_estereo');
				$data_insert['fsm_bocinas_radio'] = $this->input->post('bocinas_radio');
				$data_insert['fsm_bocinas_radio_marca'] = $this->input->post('bocinas_radio_marca');
				$data_insert['fsm_bocinas_radio_numero'] = $this->input->post('bocinas_radio_numero');
				$data_insert['fsm_cabeceras'] = $this->input->post('cabeceras');
				$data_insert['fsm_bolsas_de_aire'] = $this->input->post('bolsas_de_aire');
				$data_insert['fsm_bolsas_de_aire_numero'] = $this->input->post('bolsas_de_aire_numero');
				$data_insert['fsm_cajuela_de_guantes'] = $this->input->post('cajuela_de_guantes');
				$data_insert['fsm_ceniceros'] = $this->input->post('ceniceros');
				$data_insert['fsm_cinturones_de_seguridad'] = $this->input->post('cinturones_de_seguridad');
				$data_insert['fsm_claxón'] = $this->input->post('claxón');
				$data_insert['fsm_coderas'] = $this->input->post('coderas');
			*/	
			/*
				$data_insert['fsm_compac_disc'] = $this->input->post('compac_disc');
				$data_insert['fsm_compac_disc_marca'] = $this->input->post('compac_disc_marca');
				$data_insert['fsm_consola'] = $this->input->post('consola');
				$data_insert['fsm_control_aire_acondicionado'] = $this->input->post('control_aire_acondicionado');
				$data_insert['fsm_control_calefación'] = $this->input->post('control_calefación');
				$data_insert['fsm_control_eléctrico'] = $this->input->post('control_eléctrico');
				$data_insert['fsm_defroster'] = $this->input->post('defroster');
				$data_insert['fsm_encendedor'] = $this->input->post('encendedor');
				$data_insert['fsm_espejo_interior'] = $this->input->post('espejo_interior');
				$data_insert['fsm_extinguidor'] = $this->input->post('extinguidor');
				$data_insert['fsm_luz_interior'] = $this->input->post('luz_interior');
				$data_insert['fsm_luz_stop'] = $this->input->post('luz_stop');
				$data_insert['fsm_manijas_interiores'] = $this->input->post('manijas_interiores');
				$data_insert['fsm_palanca_de_velocidades'] = $this->input->post('palanca_de_velocidades');
				$data_insert['fsm_perilla_palanca'] = $this->input->post('perilla_palanca');
				$data_insert['fsm_radio_estereo'] = $this->input->post('radio_estereo');
				$data_insert['fsm_radio_estereo_marca'] = $this->input->post('radio_estereo_marca');
				$data_insert['fsm_reloj'] = $this->input->post('reloj');
				$data_insert['fsm_seguros_eléctricos'] = $this->input->post('seguros_eléctricos');
				$data_insert['fsm_tablero'] = $this->input->post('tablero');
				$data_insert['fsm_tapetes'] = $this->input->post('tapetes');
			
				$data_insert['fsm_tapetes_numero'] = $this->input->post('tapetes_numero');
				$data_insert['fsm_ventanas_eléctricas'] = $this->input->post('ventanas_eléctricas');
				$data_insert['fsm_vestiduras'] = $this->input->post('vestiduras');
				$data_insert['fsm_viceras'] = $this->input->post('viceras');
				$data_insert['fsm_volante'] = $this->input->post('volante');
			*/	
				
				

				
			/*	
				$data_insert['fsm_biseles'] = $this->input->post('biseles');
				$data_insert['fsm_brazos_limpiadores'] = $this->input->post('brazos_limpiadores');
				$data_insert['fsm_cofre'] = $this->input->post('cofre');
				$data_insert['fsm_cuartos_de_luz'] = $this->input->post('cuartos_de_luz');
				$data_insert['fsm_defensa_delatera'] = $this->input->post('defensa_delatera');
				$data_insert['fsm_faros_halógeno'] = $this->input->post('faros_halógeno');
				$data_insert['fsm_faros_niebla'] = $this->input->post('faros_niebla');
				$data_insert['fsm_parabrisas'] = $this->input->post('parabrisas');
				$data_insert['fsm_parrilla'] = $this->input->post('parrilla');
				$data_insert['fsm_plumas_limpiadoras'] = $this->input->post('plumas_limpiadoras');
				$data_insert['fsm_porta_placa_trasero'] = $this->input->post('porta_placa_trasero');
				$data_insert['fsm_topes_trasero'] = $this->input->post('topes_trasero');
				$data_insert['fsm_brazo_limpiador'] = $this->input->post('brazo_limpiador');
				$data_insert['fsm_calavera'] = $this->input->post('calavera');
				$data_insert['fsm_chapa_cajuela'] = $this->input->post('chapa_cajuela');
				$data_insert['fsm_defensa_trasera'] = $this->input->post('defensa_trasera');
				$data_insert['fsm_medallón'] = $this->input->post('medallón');
			
				$data_insert['fsm_pluma_limpiador'] = $this->input->post('pluma_limpiador');
				$data_insert['fsm_porta_placa_delantero'] = $this->input->post('porta_placa_delantero');
				$data_insert['fsm_sistema_escape'] = $this->input->post('sistema_escape');
				$data_insert['fsm_tapa_cajuela'] = $this->input->post('tapa_cajuela');
				$data_insert['fsm_topes_delantero'] = $this->input->post('topes_delantero');
				$data_insert['fsm_antena'] = $this->input->post('antena');
				$data_insert['fsm_canastilla'] = $this->input->post('canastilla');
				$data_insert['fsm_emblemas'] = $this->input->post('emblemas');
				$data_insert['fsm_espoilers_delantero'] = $this->input->post('espoilers_delantero');
				$data_insert['fsm_espoilers_trasero'] = $this->input->post('espoilers_trasero');
				$data_insert['fsm_fusibles_relevadores'] = $this->input->post('fusibles_relevadores');
				$data_insert['fsm_placa_delantera'] = $this->input->post('placa_delantera');
				$data_insert['fsm_placa_trasera'] = $this->input->post('placa_trasera');				
				$data_insert['fsm_quemacocos'] = $this->input->post('quemacocos');
				$data_insert['fsm_rines'] = $this->input->post('rines');
				$data_insert['fsm_tapón_de_gasolina'] = $this->input->post('tapón_de_gasolina');
				$data_insert['fsm_toldo'] = $this->input->post('toldo');
				$data_insert['fsm_alarma'] = $this->input->post('alarma');
				$data_insert['fsm_extinguidor_otro'] = $this->input->post('extinguidor_otro');
			
				$data_insert['fsm_llanta_dd'] = $this->input->post('llanta_dd');
				$data_insert['fsm_llanta_di'] = $this->input->post('llanta_di');
				$data_insert['fsm_llanta_td'] = $this->input->post('llanta_td');
				$data_insert['fsm_llanta_ti'] = $this->input->post('llanta_ti');
				$data_insert['fsm_llaves'] = $this->input->post('llaves');
				$data_insert['fsm_llavero'] = $this->input->post('llavero');
				$data_insert['fsm_control'] = $this->input->post('control');
				$data_insert['fsm_objetos_personales'] = $this->input->post('objetos_personales');
				$data_insert['fsm_otros_papeles'] = $this->input->post('otros_papeles');
				$data_insert['fsm_placa_vin'] = $this->input->post('placa_vin');
				$data_insert['fsm_telefóno'] = $this->input->post('telefóno');
				$data_insert['fsm_aletas_d'] = $this->input->post('aletas_d');
				$data_insert['fsm_costados_d'] = $this->input->post('costados_d');
				$data_insert['fsm_cristales_puerta_delantera_d'] = $this->input->post('cristales_puerta_delantera_d');
				$data_insert['fsm_cristales_puerta_trasera_d'] = $this->input->post('cristales_puerta_trasera_d');
				$data_insert['fsm_espejo_exterior_d'] = $this->input->post('espejo_exterior_d');
				$data_insert['fsm_estribo_d'] = $this->input->post('estribo_d');
				$data_insert['fsm_manijas_exteriores_d'] = $this->input->post('manijas_exteriores_d');
				$data_insert['fsm_molduras_d'] = $this->input->post('molduras_d');
				$data_insert['fsm_molduras_numero_d'] = $this->input->post('molduras_numero_d');
				$data_insert['fsm_puerta_delantera_d'] = $this->input->post('puerta_delantera_d');
				$data_insert['fsm_puerta_trasera_d'] = $this->input->post('puerta_trasera_d');
				$data_insert['fsm_reflejante_lateral_delantero_d'] = $this->input->post('reflejante_lateral_delantero_d');
				$data_insert['fsm_reflejante_lateral_trasero_d'] = $this->input->post('reflejante_lateral_trasero_d');
				$data_insert['fsm_salpicadero_d'] = $this->input->post('salpicadero_d');
				$data_insert['fsm_tapones_ruedas_d'] = $this->input->post('tapones_ruedas_d');
				$data_insert['fsm_aletas_i'] = $this->input->post('aletas_i');
				$data_insert['fsm_costados_i'] = $this->input->post('costados_i');
				$data_insert['fsm_cristales_puerta_delantera_i'] = $this->input->post('cristales_puerta_delantera_i');
				$data_insert['fsm_cristales_puerta_trasera_i'] = $this->input->post('cristales_puerta_trasera_i');
			

				$data_insert['fsm_espejo_exterior_i'] = $this->input->post('espejo_exterior_i');
				$data_insert['fsm_estribo_i'] = $this->input->post('estribo_i');
				$data_insert['fsm_manijas_exteriores_i'] = $this->input->post('manijas_exteriores_i');
				$data_insert['fsm_molduras_i'] = $this->input->post('molduras_i');
				$data_insert['fsm_molduras_numero_i'] = $this->input->post('molduras_numero_i');
				$data_insert['fsm_puerta_delantera_i'] = $this->input->post('puerta_delantera_i');
				$data_insert['fsm_puerta_trasera_i'] = $this->input->post('puerta_trasera_i');
				$data_insert['fsm_reflejante_lateral_delantero_i'] = $this->input->post('reflejante_lateral_delantero_i');
				$data_insert['fsm_reflejante_lateral_trasero_i'] = $this->input->post('reflejante_lateral_trasero_i');
				$data_insert['fsm_salpicadero_i'] = $this->input->post('salpicadero_i');
				$data_insert['fsm_tapones_ruedas_i'] = $this->input->post('tapones_ruedas_i');
			*/	
				
				
				
				

              

			   $data_insert=array_to_upper($data_insert);
				
				if($this->input->post('firma_med') != '')
                {
                    $data_insert['fsm_firma_med'] = $this->input->post('firma_med');
                }
				
                if($this->input->post('firma_pac') != '')
                {
                    $data_insert['fsm_firma_pac'] = $this->input->post('firma_pac');
                }
				
				
                if ($this->cliente->inserta_documento_recibo($data_insert))
                {
                    send_json_ok('Se guardó de forma correcta');
                }
                else
                {
                    send_json_error('Ocurrió un error al guardar.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['conduce'] = $persona;
            $data['medico'] = $medico;
            $this->load->helper('template');
            $params_view = array(
                'title' => 'nuevo_form_recibo',
                'view' => 'conduce/nuevo_form_recibo_sura',
                'view_data' => $data 
               );
            render_template($params_view);
        }
    }



    public function nuevo_entrega_sura($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
		
		$fsm_recibido= $this->cliente->get_by_ultimo_documento_recibo($cliente_id);
        $user = $this->session->user;
		$usuario = $this->usuario->get($user['usr_id']);
        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
			/*	$this->form_validation->set_rules('seccion_externa_a' ,'Sección externa A','required');
				$this->form_validation->set_rules('seccion_externa_b' ,'Sección externa B','required');
				$this->form_validation->set_rules('seccion_externa_c' ,'Sección externa C','required');
				$this->form_validation->set_rules('seccion_externa_d' ,'Sección externa D','required');
				$this->form_validation->set_rules('seccion_interna_a' ,'Sección interna A','required');
				$this->form_validation->set_rules('seccion_interna_b' ,'Sección interna B','required');
				$this->form_validation->set_rules('seccion_interna_c','Sección interna D','required'); 
				$this->form_validation->set_rules('seccion_interna_d' ,'Sección interna C','required'); 
			*/
			$this->form_validation->set_rules('kilometraje_final','Kilometraje Final','required'); 
		/*	$this->form_validation->set_rules('bateria','Batería','required'); 
			$this->form_validation->set_rules('alfombra','Alfombra','required'); 
			$this->form_validation->set_rules('asientos_delanteros','Asientos Delanteros','required'); 
			$this->form_validation->set_rules('asientos_traseros','Asientos Traseros','required'); 
			$this->form_validation->set_rules('botones_radio_estereo','Botones Radio Estereo','required'); 
			$this->form_validation->set_rules('bocinas_radio','Bocinas Radio','required'); 
			$this->form_validation->set_rules('bocinas_radio_marca','Marca de Bocinas Radio','required'); 
			$this->form_validation->set_rules('bocinas_radio_numero','Número Bocinas Radio','required'); 
			$this->form_validation->set_rules('cabeceras','Cabeceras','required'); 
			$this->form_validation->set_rules('bolsas_de_aire','Bolsas de Aire','required'); 
			$this->form_validation->set_rules('bolsas_de_aire_numero','Número Bolsas de Aire','required'); 
			$this->form_validation->set_rules('cajuela_de_guantes','Cajuela de Guantes','required'); 
			$this->form_validation->set_rules('ceniceros','Ceniceros','required'); 
			$this->form_validation->set_rules('cinturones_de_seguridad','Cinturones de Seguridad','required'); 
			$this->form_validation->set_rules('claxón','Claxón','required'); 
			$this->form_validation->set_rules('coderas','Coderas','required'); 
			$this->form_validation->set_rules('compac_disc','Compac Disc','required'); 
			$this->form_validation->set_rules('compac_disc_marca','Marca Compac Disc','required'); 
			$this->form_validation->set_rules('consola','Consola','required'); 
			$this->form_validation->set_rules('control_aire_acondicionado','Control Aire Acondicionado','required'); 
			$this->form_validation->set_rules('control_calefación','Control Calefacción','required'); 
			$this->form_validation->set_rules('control_eléctrico','Control Eléctrico','required'); 
			$this->form_validation->set_rules('defroster','Defroster','required'); 
			$this->form_validation->set_rules('encendedor','Encendedor','required'); 
			$this->form_validation->set_rules('espejo_interior','Espejo Interior','required'); 
			$this->form_validation->set_rules('extinguidor','Extinguidor','required'); 
			$this->form_validation->set_rules('luz_interior','Luz Interior','required'); 
			$this->form_validation->set_rules('luz_stop','Luz Stop','required'); 
			$this->form_validation->set_rules('manijas_interiores','Manijas Interiores','required'); 
			$this->form_validation->set_rules('palanca_de_velocidades','Palanca de Velocidades','required'); 
			$this->form_validation->set_rules('perilla_palanca','Perilla Palanca','required'); 
			$this->form_validation->set_rules('radio_estereo','Radio Estéreo','required'); 
			$this->form_validation->set_rules('radio_estereo_marca','Radio Estéreo Marca','required'); 
			$this->form_validation->set_rules('reloj','Reloj','required'); 
			$this->form_validation->set_rules('seguros_eléctricos','Seguros Eléctricos','required'); 
			$this->form_validation->set_rules('tablero','Tablero','required'); 
			$this->form_validation->set_rules('tapetes','Tapetes','required'); 
			$this->form_validation->set_rules('tapetes_numero','Tapetes Numero','required'); 
			$this->form_validation->set_rules('ventanas_eléctricas','Ventanas Eléctricas','required'); 
			$this->form_validation->set_rules('vestiduras','Vestiduras','required'); 
			$this->form_validation->set_rules('viceras','Viceras','required'); 
			$this->form_validation->set_rules('volante','Volante','required'); 
			$this->form_validation->set_rules('alfombra_cajuela','Alfombra Cajuela','required'); 
			$this->form_validation->set_rules('cables_para_corriente','Cables para Corriente','required'); 
			$this->form_validation->set_rules('cartón_cajuela','Cartón Cajuela','required'); 
			$this->form_validation->set_rules('gato','Gato','required'); 
			$this->form_validation->set_rules('gato_tipo','Gato Tipo','required'); 
			$this->form_validation->set_rules('herramientas','Herramientas','required'); 
			$this->form_validation->set_rules('herramientas_numero','Número de Herramientas','required'); 
			$this->form_validation->set_rules('llave_de_ruedas','Llave de Ruedas','required'); 
			$this->form_validation->set_rules('llanta_refac','Llanta de Refacción','required'); 
			$this->form_validation->set_rules('llanta_refac_marca','Marca de Llanta de Refacción','required'); 
			$this->form_validation->set_rules('llanta_refac_vida','Vida de Llanta de Refacción','required'); 
			$this->form_validation->set_rules('señales_de_carretera','Señales de Carretera','required'); 
			$this->form_validation->set_rules('biseles','Biseles','required'); 
			$this->form_validation->set_rules('brazos_limpiadores','Brazos Limpiadores','required'); 
			$this->form_validation->set_rules('cofre','Cofre','required'); 
			$this->form_validation->set_rules('cuartos_de_luz','Cuartos de Luz','required'); 
			$this->form_validation->set_rules('defensa_delatera','Defensa Delantera','required'); 
			$this->form_validation->set_rules('faros_halógeno','Faros Halógeno','required'); 
			$this->form_validation->set_rules('faros_niebla','Faros Niebla','required'); 
			$this->form_validation->set_rules('parabrisas','Parabrisas','required'); 
			$this->form_validation->set_rules('parrilla','Parrilla','required'); 
			$this->form_validation->set_rules('plumas_limpiadoras','Plumas Limpiadoras','required'); 
			
			$this->form_validation->set_rules('topes_trasero','Topes Taseros','required'); 
			$this->form_validation->set_rules('brazo_limpiador','Brazo Limpiador','required'); 
			$this->form_validation->set_rules('calavera','Calavera','required'); 
			$this->form_validation->set_rules('chapa_cajuela','Chapa Cajuela','required'); 
			$this->form_validation->set_rules('defensa_trasera','Defensa Trasera','required'); 
			$this->form_validation->set_rules('medallón','Medallón','required'); 
			$this->form_validation->set_rules('pluma_limpiador','Pluma Limpiador','required'); 
			$this->form_validation->set_rules('porta_placa_delantero','Porta Placa Delantero','required'); 
			$this->form_validation->set_rules('porta_placa_trasero','Porta Placa Trasero','required'); 
			$this->form_validation->set_rules('sistema_escape','Sistema Escape','required'); 
			$this->form_validation->set_rules('tapa_cajuela','Tapa Cajuela','required'); 
			$this->form_validation->set_rules('topes_delantero','Topes Delantero','required'); 
			$this->form_validation->set_rules('antena','Antena','required'); 
			$this->form_validation->set_rules('canastilla','Canastilla','required'); 
			$this->form_validation->set_rules('emblemas','Emblemas','required'); 
			$this->form_validation->set_rules('espoilers_delantero','Espoilers Delanteros','required'); 
			$this->form_validation->set_rules('espoilers_trasero','Espoilers Traseros','required'); 
			$this->form_validation->set_rules('fusibles_relevadores','Fusibles Relevadores','required'); 
			
			$this->form_validation->set_rules('quemacocos','Quemacocos','required'); 
			$this->form_validation->set_rules('rines','Rines','required'); 
			$this->form_validation->set_rules('tapón_de_gasolina','Tapón de Gasolina','required'); 
			$this->form_validation->set_rules('toldo','Toldo','required'); 
			$this->form_validation->set_rules('alarma','Alarma','required'); 
			$this->form_validation->set_rules('extinguidor','Extinguidor','required'); 
			$this->form_validation->set_rules('llanta_dd','Llanta Delantera Derecha','required'); 
			$this->form_validation->set_rules('llanta_di','Llanta Delantera Izquierda','required'); 
			$this->form_validation->set_rules('llanta_td','Llanta Trasera Derecha','required'); 
			$this->form_validation->set_rules('llanta_ti','Llanta Trasera Izquierda','required'); 
			$this->form_validation->set_rules('llaves','Llaves','required'); 
			$this->form_validation->set_rules('llavero','Llavero','required'); 
			$this->form_validation->set_rules('control','Control','required'); 
			$this->form_validation->set_rules('objetos_personales','Objetos Personales','required'); 
			$this->form_validation->set_rules('otros_papeles','Otros Papeles','required'); 
			$this->form_validation->set_rules('placa_vin','Placa Vin','required'); 
			$this->form_validation->set_rules('telefóno','Teléfono','required'); 
			$this->form_validation->set_rules('aletas_d','Aletas Lado Derecho','required'); 
			$this->form_validation->set_rules('costados_d','Costados Lado Derecho','required'); 
			$this->form_validation->set_rules('cristales_puerta_delantera_d','Cristales Puerta Delantera Lado Derecho','required'); 
			$this->form_validation->set_rules('cristales_puerta_trasera_d','Cristales Puerta Trasera Lado Derecho','required'); 
			$this->form_validation->set_rules('espejo_exterior_d','Espejo Exterior Lado Derecho','required'); 
			$this->form_validation->set_rules('estribo_d','Estribo Lado Derecho','required'); 
			$this->form_validation->set_rules('manijas_exteriores_d','Manijas Exterior Lado Derecho','required'); 
			$this->form_validation->set_rules('molduras_d','Molduras Lado Derecho','required'); 
			$this->form_validation->set_rules('molduras_numero_d','Número Molduras Lado Derecho','required'); 
			$this->form_validation->set_rules('puerta_delantera_d','Puerta Delantera Lado Derecho','required'); 
			$this->form_validation->set_rules('puerta_trasera_d','Puerta Trasera Lado Derecho','required'); 
			$this->form_validation->set_rules('reflejante_lateral_delantero_d','Reflejante Lateral Delantero Lado Derecho','required'); 
			$this->form_validation->set_rules('reflejante_lateral_trasero_d','Reflejante Lateral Trasero Lado Derecho','required'); 
			$this->form_validation->set_rules('salpicadero_d','Salpicadera Lado Derecho','required'); 
			$this->form_validation->set_rules('tapones_ruedas_d','Tapones de Ruedas Lado Derecho','required'); 
			$this->form_validation->set_rules('aletas_i','Aletas Izquierdo','required'); 
			$this->form_validation->set_rules('costados_i','Costados Izquierdo','required'); 
			$this->form_validation->set_rules('cristales_puerta_delantera_i','Cristales Puerta Delantera Lado Izquierdo','required'); 
			$this->form_validation->set_rules('cristales_puerta_trasera_i','Cristales Puerta Trasera Lado Izquierdo','required'); 
			$this->form_validation->set_rules('espejo_exterior_i','Espejo Exterior Lado Izquierdo','required'); 
			$this->form_validation->set_rules('estribo_i','Estribo Lado Izquierdo','required'); 
			$this->form_validation->set_rules('manijas_exteriores_i','Manijas Exteriores Lado Izquierdo','required'); 
			$this->form_validation->set_rules('molduras_i','Molduras Lado Izquierdo','required'); 
			$this->form_validation->set_rules('molduras_numero_i','Molduras Numero Lado Izquierdo','required'); 
			$this->form_validation->set_rules('puerta_delantera_i','Puerta Delantera Lado Izquierdo','required'); 
			$this->form_validation->set_rules('puerta_trasera_i','Puerta Trasera Lado Izquierdo','required'); 
			$this->form_validation->set_rules('reflejante_lateral_delantero_i','Reflejante Lateral Delantero Lado Izquierdo','required'); 
			$this->form_validation->set_rules('reflejante_lateral_trasero_i','Reflejante Lateral Trasero Lado Izquierdo','required'); 
			$this->form_validation->set_rules('salpicadero_i','Salpicadero Lado Izquierdo','required'); 
			$this->form_validation->set_rules('tapones_ruedas_i','Tapones Ruedas Lado Izquierdo','required'); 
			$this->form_validation->set_rules('pasajero_1','Pasajero 1','required'); 
			$this->form_validation->set_rules('pasajero_2','Pasajero 2','required'); 
			$this->form_validation->set_rules('pasajero_3','Pasajero 3','required'); 
			$this->form_validation->set_rules('pasajero_4','Pasajero 4','required'); 
			$this->form_validation->set_rules('pasajero_5','Pasajero 5','required'); 			
			*/
			
            if($this->form_validation->run())
            {
				$data_insert['cond_id']  = $cliente_id;
                $data_insert['cond_conductor']  = $usuario['usr_id'];
                $data_insert['cond_poliza'] = $persona['cond_poliza'];
                $data_insert['cond_origen']  = $persona['cond_origen'];

				$data_insert['pregunta_1']  = $this->input->post('pregunta_1');
				$data_insert['det_pregunta_1']  = $this->input->post('det_pregunta_1');
				$data_insert['pregunta_2']  = $this->input->post('pregunta_2');
				$data_insert['det_pregunta_2']  = $this->input->post('det_pregunta_2');
				$data_insert['pregunta_3']  = $this->input->post('pregunta_3');
				$data_insert['det_pregunta_3']  = $this->input->post('det_pregunta_3');
				$data_insert['pregunta_4']  = $this->input->post('pregunta_4');
				$data_insert['det_pregunta_4']  = $this->input->post('det_pregunta_4');
				$data_insert['pregunta_5']  = $this->input->post('pregunta_5');
				$data_insert['det_pregunta_5']  = $this->input->post('det_pregunta_5');
				$data_insert['pregunta_6']  = $this->input->post('pregunta_6');
				$data_insert['det_pregunta_6']  = $this->input->post('det_pregunta_6');

				$data_insert['numero_serie_motor']  = $this->input->post('numero_serie_motor');
				$data_insert['color_auto']  = $this->input->post('color_auto');
				
				$data_insert['kilometraje_inicial'] = $this->input->post('kilometraje_inicial');
				$data_insert['cap_gas_inicial'] = $this->input->post('cap_gas_inicial');


				$data_insert['kilometraje_final'] = $this->input->post('kilometraje_final');
				$data_insert['cap_gas_final'] = $this->input->post('cap_gas_final');

				$data_insert['seccion_externa_a'] = $this->input->post('seccion_externa_a');
				$data_insert['det_seccion_externa_a'] = $this->input->post('det_seccion_externa_a');
				$data_insert['seccion_externa_b'] = $this->input->post('seccion_externa_b');
				$data_insert['det_seccion_externa_b'] = $this->input->post('det_seccion_externa_b');
				$data_insert['seccion_externa_c'] = $this->input->post('seccion_externa_c');
				$data_insert['det_seccion_externa_c'] = $this->input->post('det_seccion_externa_c');
				$data_insert['seccion_externa_d'] = $this->input->post('seccion_externa_d');
				$data_insert['det_seccion_externa_d'] = $this->input->post('det_seccion_externa_d');
				
				$data_insert['seccion_interna_a'] = $this->input->post('seccion_interna_a');
				$data_insert['det_seccion_interna_a'] = $this->input->post('det_seccion_interna_a');
				$data_insert['seccion_interna_b'] = $this->input->post('seccion_interna_b');
				$data_insert['det_seccion_interna_b'] = $this->input->post('det_seccion_interna_b');
				$data_insert['seccion_interna_c'] = $this->input->post('seccion_interna_c');
				$data_insert['det_seccion_interna_c'] = $this->input->post('det_seccion_interna_c');
				$data_insert['seccion_interna_d'] = $this->input->post('seccion_interna_d');
				$data_insert['det_seccion_interna_d'] = $this->input->post('det_seccion_interna_d');

				$data_insert['fsm_alfombra_cajuela'] = $this->input->post('alfombra_cajuela');
				$data_insert['fsm_cables_para_corriente'] = $this->input->post('cables_para_corriente');
				$data_insert['fsm_cartón_cajuela'] = $this->input->post('cartón_cajuela');
				$data_insert['fsm_gato'] = $this->input->post('gato');
				$data_insert['fsm_gato_tipo'] = $this->input->post('gato_tipo');
				$data_insert['fsm_herramientas'] = $this->input->post('herramientas');
				$data_insert['fsm_herramientas_numero'] = $this->input->post('herramientas_numero');
				$data_insert['fsm_llave_de_ruedas'] = $this->input->post('llave_de_ruedas');
				$data_insert['fsm_llanta_refac'] = $this->input->post('llanta_refac');
				$data_insert['fsm_llanta_refac_marca'] = $this->input->post('llanta_refac_marca');
				$data_insert['fsm_llanta_refac_vida'] = $this->input->post('llanta_refac_vida');
				$data_insert['fsm_señales_de_carretera'] = $this->input->post('señales_de_carretera');
				
				$data_insert['fsm_pasajero_1'] = $this->input->post('pasajero_1');
				$data_insert['fsm_pasajero_2'] = $this->input->post('pasajero_2');
				$data_insert['fsm_pasajero_3'] = $this->input->post('pasajero_3');
				$data_insert['fsm_pasajero_4'] = $this->input->post('pasajero_4');
				$data_insert['fsm_pasajero_5'] = $this->input->post('pasajero_5');					
				$data_insert['valores'] = $this->input->post('valores');
				$data_insert['recibe_obs'] = $this->input->post('recibe_obs');
				
				
				$data_insert['cond_f_recibido']  =  date('Y-m-d H:i:s');
				$data_insert['log_insrt_f']  =  date('Y-m-d H:i:s');


			/*
				$data_insert['fsm_alternador'] = $this->input->post('alternador');
				$data_insert['fsm_bateria'] = $this->input->post('bateria');
				$data_insert['fsm_alfombra'] = $this->input->post('alfombra');
				$data_insert['fsm_asientos_delanteros'] = $this->input->post('asientos_delanteros');
				$data_insert['fsm_asientos_traseros'] = $this->input->post('asientos_traseros');
				$data_insert['fsm_botones_radio_estereo'] = $this->input->post('botones_radio_estereo');
				$data_insert['fsm_bocinas_radio'] = $this->input->post('bocinas_radio');
				$data_insert['fsm_bocinas_radio_marca'] = $this->input->post('bocinas_radio_marca');
				$data_insert['fsm_bocinas_radio_numero'] = $this->input->post('bocinas_radio_numero');
				$data_insert['fsm_cabeceras'] = $this->input->post('cabeceras');
				$data_insert['fsm_bolsas_de_aire'] = $this->input->post('bolsas_de_aire');
				$data_insert['fsm_bolsas_de_aire_numero'] = $this->input->post('bolsas_de_aire_numero');
				$data_insert['fsm_cajuela_de_guantes'] = $this->input->post('cajuela_de_guantes');
				$data_insert['fsm_ceniceros'] = $this->input->post('ceniceros');
				$data_insert['fsm_cinturones_de_seguridad'] = $this->input->post('cinturones_de_seguridad');
				$data_insert['fsm_claxón'] = $this->input->post('claxón');
				$data_insert['fsm_coderas'] = $this->input->post('coderas');
			*/	
			/*
				$data_insert['fsm_compac_disc'] = $this->input->post('compac_disc');
				$data_insert['fsm_compac_disc_marca'] = $this->input->post('compac_disc_marca');
				$data_insert['fsm_consola'] = $this->input->post('consola');
				$data_insert['fsm_control_aire_acondicionado'] = $this->input->post('control_aire_acondicionado');
				$data_insert['fsm_control_calefación'] = $this->input->post('control_calefación');
				$data_insert['fsm_control_eléctrico'] = $this->input->post('control_eléctrico');
				$data_insert['fsm_defroster'] = $this->input->post('defroster');
				$data_insert['fsm_encendedor'] = $this->input->post('encendedor');
				$data_insert['fsm_espejo_interior'] = $this->input->post('espejo_interior');
				$data_insert['fsm_extinguidor'] = $this->input->post('extinguidor');
				$data_insert['fsm_luz_interior'] = $this->input->post('luz_interior');
				$data_insert['fsm_luz_stop'] = $this->input->post('luz_stop');
				$data_insert['fsm_manijas_interiores'] = $this->input->post('manijas_interiores');
				$data_insert['fsm_palanca_de_velocidades'] = $this->input->post('palanca_de_velocidades');
				$data_insert['fsm_perilla_palanca'] = $this->input->post('perilla_palanca');
				$data_insert['fsm_radio_estereo'] = $this->input->post('radio_estereo');
				$data_insert['fsm_radio_estereo_marca'] = $this->input->post('radio_estereo_marca');
				$data_insert['fsm_reloj'] = $this->input->post('reloj');
				$data_insert['fsm_seguros_eléctricos'] = $this->input->post('seguros_eléctricos');
				$data_insert['fsm_tablero'] = $this->input->post('tablero');
				$data_insert['fsm_tapetes'] = $this->input->post('tapetes');
			
				$data_insert['fsm_tapetes_numero'] = $this->input->post('tapetes_numero');
				$data_insert['fsm_ventanas_eléctricas'] = $this->input->post('ventanas_eléctricas');
				$data_insert['fsm_vestiduras'] = $this->input->post('vestiduras');
				$data_insert['fsm_viceras'] = $this->input->post('viceras');
				$data_insert['fsm_volante'] = $this->input->post('volante');
			*/	
				
				

				
			/*	
				$data_insert['fsm_biseles'] = $this->input->post('biseles');
				$data_insert['fsm_brazos_limpiadores'] = $this->input->post('brazos_limpiadores');
				$data_insert['fsm_cofre'] = $this->input->post('cofre');
				$data_insert['fsm_cuartos_de_luz'] = $this->input->post('cuartos_de_luz');
				$data_insert['fsm_defensa_delatera'] = $this->input->post('defensa_delatera');
				$data_insert['fsm_faros_halógeno'] = $this->input->post('faros_halógeno');
				$data_insert['fsm_faros_niebla'] = $this->input->post('faros_niebla');
				$data_insert['fsm_parabrisas'] = $this->input->post('parabrisas');
				$data_insert['fsm_parrilla'] = $this->input->post('parrilla');
				$data_insert['fsm_plumas_limpiadoras'] = $this->input->post('plumas_limpiadoras');
				$data_insert['fsm_porta_placa_trasero'] = $this->input->post('porta_placa_trasero');
				$data_insert['fsm_topes_trasero'] = $this->input->post('topes_trasero');
				$data_insert['fsm_brazo_limpiador'] = $this->input->post('brazo_limpiador');
				$data_insert['fsm_calavera'] = $this->input->post('calavera');
				$data_insert['fsm_chapa_cajuela'] = $this->input->post('chapa_cajuela');
				$data_insert['fsm_defensa_trasera'] = $this->input->post('defensa_trasera');
				$data_insert['fsm_medallón'] = $this->input->post('medallón');
			
				$data_insert['fsm_pluma_limpiador'] = $this->input->post('pluma_limpiador');
				$data_insert['fsm_porta_placa_delantero'] = $this->input->post('porta_placa_delantero');
				$data_insert['fsm_sistema_escape'] = $this->input->post('sistema_escape');
				$data_insert['fsm_tapa_cajuela'] = $this->input->post('tapa_cajuela');
				$data_insert['fsm_topes_delantero'] = $this->input->post('topes_delantero');
				$data_insert['fsm_antena'] = $this->input->post('antena');
				$data_insert['fsm_canastilla'] = $this->input->post('canastilla');
				$data_insert['fsm_emblemas'] = $this->input->post('emblemas');
				$data_insert['fsm_espoilers_delantero'] = $this->input->post('espoilers_delantero');
				$data_insert['fsm_espoilers_trasero'] = $this->input->post('espoilers_trasero');
				$data_insert['fsm_fusibles_relevadores'] = $this->input->post('fusibles_relevadores');
				$data_insert['fsm_placa_delantera'] = $this->input->post('placa_delantera');
				$data_insert['fsm_placa_trasera'] = $this->input->post('placa_trasera');				
				$data_insert['fsm_quemacocos'] = $this->input->post('quemacocos');
				$data_insert['fsm_rines'] = $this->input->post('rines');
				$data_insert['fsm_tapón_de_gasolina'] = $this->input->post('tapón_de_gasolina');
				$data_insert['fsm_toldo'] = $this->input->post('toldo');
				$data_insert['fsm_alarma'] = $this->input->post('alarma');
				$data_insert['fsm_extinguidor_otro'] = $this->input->post('extinguidor_otro');
			
				$data_insert['fsm_llanta_dd'] = $this->input->post('llanta_dd');
				$data_insert['fsm_llanta_di'] = $this->input->post('llanta_di');
				$data_insert['fsm_llanta_td'] = $this->input->post('llanta_td');
				$data_insert['fsm_llanta_ti'] = $this->input->post('llanta_ti');
				$data_insert['fsm_llaves'] = $this->input->post('llaves');
				$data_insert['fsm_llavero'] = $this->input->post('llavero');
				$data_insert['fsm_control'] = $this->input->post('control');
				$data_insert['fsm_objetos_personales'] = $this->input->post('objetos_personales');
				$data_insert['fsm_otros_papeles'] = $this->input->post('otros_papeles');
				$data_insert['fsm_placa_vin'] = $this->input->post('placa_vin');
				$data_insert['fsm_telefóno'] = $this->input->post('telefóno');
				$data_insert['fsm_aletas_d'] = $this->input->post('aletas_d');
				$data_insert['fsm_costados_d'] = $this->input->post('costados_d');
				$data_insert['fsm_cristales_puerta_delantera_d'] = $this->input->post('cristales_puerta_delantera_d');
				$data_insert['fsm_cristales_puerta_trasera_d'] = $this->input->post('cristales_puerta_trasera_d');
				$data_insert['fsm_espejo_exterior_d'] = $this->input->post('espejo_exterior_d');
				$data_insert['fsm_estribo_d'] = $this->input->post('estribo_d');
				$data_insert['fsm_manijas_exteriores_d'] = $this->input->post('manijas_exteriores_d');
				$data_insert['fsm_molduras_d'] = $this->input->post('molduras_d');
				$data_insert['fsm_molduras_numero_d'] = $this->input->post('molduras_numero_d');
				$data_insert['fsm_puerta_delantera_d'] = $this->input->post('puerta_delantera_d');
				$data_insert['fsm_puerta_trasera_d'] = $this->input->post('puerta_trasera_d');
				$data_insert['fsm_reflejante_lateral_delantero_d'] = $this->input->post('reflejante_lateral_delantero_d');
				$data_insert['fsm_reflejante_lateral_trasero_d'] = $this->input->post('reflejante_lateral_trasero_d');
				$data_insert['fsm_salpicadero_d'] = $this->input->post('salpicadero_d');
				$data_insert['fsm_tapones_ruedas_d'] = $this->input->post('tapones_ruedas_d');
				$data_insert['fsm_aletas_i'] = $this->input->post('aletas_i');
				$data_insert['fsm_costados_i'] = $this->input->post('costados_i');
				$data_insert['fsm_cristales_puerta_delantera_i'] = $this->input->post('cristales_puerta_delantera_i');
				$data_insert['fsm_cristales_puerta_trasera_i'] = $this->input->post('cristales_puerta_trasera_i');
			

				$data_insert['fsm_espejo_exterior_i'] = $this->input->post('espejo_exterior_i');
				$data_insert['fsm_estribo_i'] = $this->input->post('estribo_i');
				$data_insert['fsm_manijas_exteriores_i'] = $this->input->post('manijas_exteriores_i');
				$data_insert['fsm_molduras_i'] = $this->input->post('molduras_i');
				$data_insert['fsm_molduras_numero_i'] = $this->input->post('molduras_numero_i');
				$data_insert['fsm_puerta_delantera_i'] = $this->input->post('puerta_delantera_i');
				$data_insert['fsm_puerta_trasera_i'] = $this->input->post('puerta_trasera_i');
				$data_insert['fsm_reflejante_lateral_delantero_i'] = $this->input->post('reflejante_lateral_delantero_i');
				$data_insert['fsm_reflejante_lateral_trasero_i'] = $this->input->post('reflejante_lateral_trasero_i');
				$data_insert['fsm_salpicadero_i'] = $this->input->post('salpicadero_i');
				$data_insert['fsm_tapones_ruedas_i'] = $this->input->post('tapones_ruedas_i');
			*/	
				
				
				
				

              

			   $data_insert=array_to_upper($data_insert);
				
				if($this->input->post('firma_med') != '')
                {
                    $data_insert['fsm_firma_med'] = $this->input->post('firma_med');
                }
				
                if($this->input->post('firma_pac') != '')
                {
                    $data_insert['fsm_firma_pac'] = $this->input->post('firma_pac');
                }
				
				
                if ($this->cliente->inserta_documento_entrega($data_insert))
                {
                    send_json_ok('Se guardó de forma correcta');
                }
                else
                {
                    send_json_error('Ocurrió un error al guardar.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['conduce'] = $persona;
            $data['medico'] = $medico;
			$data['fsm_entrega'] =$fsm_recibido;
            $this->load->helper('template');
            $params_view = array(
                'title' => 'nuevo_form_recibo',
                'view' => 'conduce/nuevo_form_entrega_sura',
                'view_data' => $data 
               );
            render_template($params_view);
        }
    }






    public function borra_documento($fsm_id)
    {
		$documento=$this->cliente->get_doc($fsm_id);
		
		$doc_borra['cond_id']=$documento['cond_id'];
		$doc_borra['doc_nombre']=$documento['doc_nombre'];
		$doc_borra['doc_path']=strtolower($documento['doc_path']);
		$doc_borra['doc_f']=$documento['doc_f'];
		$doc_borra['empresa']='SURA CONDUCE';
		$doc_borra['doc_fecha_efectiva']=date();
		
		$this->cliente->inserta_borrado($doc_borra);
        if($this->cliente->delete_doc($fsm_id))
        {
            send_json_ok('Se eliminó de forma correcta.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar.');
        }
    }

 public function edita_g($fsm_id,$cliente_id)
    {           
		$cliente = $this->cliente->get($cliente_id);		
		$documento=$this->cliente->get_doc($fsm_id);         
		
        if($documento)
        {

            if(isset($_POST) && count($_POST) > 0)     
            {
                $this->load->library('form_validation');
                $this->form_validation->set_rules('nuevo_nombre','Nuevo Nombre del Archivo','required');


                if($this->form_validation->run())
                {

                    $data_clte['doc_nombre'] =  trim($this->input->post('nuevo_nombre'));
					
					if($this->cliente->actualiza_nombre_doc($fsm_id, array_to_upper($data_clte)))
					{
						send_json_ok(array('msg' =>'Se actualizado el Nombre del Archivo.', 'id' => $cliente_id));
					}
					else
					{
						send_json_error('Ocurrió un error al actualizar el nuevo nombre.');
					}
                }
                else
                {
                    send_json_error(validation_errors('<div />'));
                }
            }
            else 
            {

                $data['conduce'] = 	$cliente;
				$data['documento'] = $documento;
				

                $this->load->helper('template');
                $params_view = array(
                    'title' => 'Conduces',
                    'view' => 'conduce/edit_g',
                    'view_data' => $data
                   );
                render_template($params_view);  
            }
        }
        else 
        {
            show_error('No existe el registro');
        }
    }

    public function nuevo_doc($cliente_id)
    {
        $conduce = $this->cliente->get($cliente_id);
		$user = $this->session->user;
		$usuario = $this->medico->get($user['usr_id']);
		
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('nombre','Nombre documento','required');

            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['cond_id'] =  $cliente_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                
                $this->load->library('upload');
				sleep(1);
                if(!empty($_FILES['doc']['name']))
                {
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/docs_conduce/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'doc|docx|pdf|txt|xlsx|xls|png|jpg|jpeg|mp4',
                            'max_size'      => '190000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('doc'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['doc_path'] = $data['file_name'];
                        if($this->cliente->add_doc(array_to_upper($data_clte)))
                        {
                            send_json_ok('Se guardó de forma correcta');
                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
                    send_json_error($this->upload->display_errors());
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {	$data['usuario'] = $usuario;
            $data['conduce'] = $conduce;
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Conduces',
                'view' => 'conduce/add_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }



    public function id($id)
    {   //echo 'a';
		$user = $this->session->user;
		//echo '-a-';
		$usuario = $this->usuario->get($user['usr_id']);
		//echo '-aa-';
		$data['coms'] = $this->cliente->get_coms($id);
	    //echo 'b';
		$data['docs'] = $this->cliente->get_docs($id);
		//echo 'c';
		$data['cliente'] = $this->cliente->get($id);
		$data['usuario'] = $usuario;
		//echo $id;		
		$data['fsm_conduce_recibo'] = $this->cliente->get_by_documento_recibo($id);
		//echo 'e';
		$data['fsm_conduce_entrega'] = $this->cliente->get_by_documento_entrega($id);
		$data['fsm_conduce_resumen'] = $this->cliente->get_by_documento_resumen($id);	
		//echo 'f';					
		if($data['cliente'])
        {
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Conduce',
                'view' => 'conduce/cliente',
                'view_data' => $data 
               );

            render_template($params_view);  
        }
        else
        {
            show_error('El cliente no existe.');
        }
    }

    function busca()	
    {   
			$user = $this->session->user; 
			$usuario = $this->medico->get($user['usr_id']);
    
			$id = $this->input->post('id');
			$nombre  = trim(strtoupper($this->input->post('nombre')));
			$paterno  = trim(strtoupper($this->input->post('paterno')));
			$materno  = trim(strtoupper($this->input->post('materno')));
			$poliza     = trim(strtoupper($this->input->post('poliza')));
			$estatus     = strtoupper($this->input->post('status_proc'));
			$orden_f_ini = $this->input->post('f_ini');
			$orden_f_fin = $this->input->post('f_fin');
			

			$data['clientes'] = $this->cliente->busca(
			$id, 
			$nombre,
			$paterno, 
			$materno, 
			$poliza, 
			$estatus,
			$orden_f_ini,
			$orden_f_fin
			);

			send_json_ok($this->load->view('conduce/busca',$data,TRUE));
    }


    public function edita($cliente_id)
    {   //date_default_timezone_set('America/Mexico_City');
        $user = $this->session->user;
		$cliente = $this->cliente->get($cliente_id);		
		$usuario_activo = $this->usuario->get($user['usr_id']);
		$usuario=$usuario_activo;
		$data_asegurado=$this->asegurado->buscalo($cliente['cond_poliza']);
        if($cliente)
        {
            if(isset($_POST) && count($_POST) > 0)     
            {
                $this->load->library('form_validation');
                $this->form_validation->set_rules('nombre','Nombre','required');
                $this->form_validation->set_rules('paterno','Apellido Paterno','required');
                $this->form_validation->set_rules('materno','Apellido Materno','required');

                if($this->form_validation->run())
                {
					
					
					$data_clte['cond_nombre_servicio'] =  trim($this->input->post('nombre'));
                    $data_clte['cond_paterno_servicio'] =  trim($this->input->post('paterno'));
					$data_clte['cond_materno_servicio'] =  trim($this->input->post('materno'));
					$data_clte['cond_tel'] =  trim($this->input->post('telefono'));
					
					$data_clte['cond_origen'] =  trim($this->input->post('origen'));
					$data_clte['cond_destino'] =  trim($this->input->post('destino'));
					$data_clte['cond_tvehiculo'] =  trim($this->input->post('tvehiculo'));
					$data_clte['cond_mvehiculo'] =  trim($this->input->post('mvehiculo'));
					$data_clte['cond_movehiculo'] =  trim($this->input->post('movehiculo'));
					$data_clte['cond_pvehiculo'] =  trim($this->input->post('pvehiculo'));
					$data_clte['cond_referencia'] =  trim($this->input->post('referencia'));
					$data_clte['cond_estatus'] =  trim($this->input->post('cond_estatus'));
					$data_clte['cond_conductor'] =  ($this->input->post('chofer'));
					$data_clte['cond_email'] =  trim($this->input->post('email'));
					$data_clte['cond_nombre_recibe'] =  trim($this->input->post('nombre_recibe'));
                    $data_clte['cond_paterno_recibe'] =  trim($this->input->post('paterno_recibe'));
					$data_clte['cond_materno_recibe'] =  trim($this->input->post('materno_recibe'));
					$data_clte['cond_tel_recibe'] =  trim($this->input->post('telefono_recibe'));					
					$data_clte['cond_gasto_kilometros'] =  trim($this->input->post('kilometros_usados'));
					$primera_asignacion=0;
					
					if 	(
							($cliente['cond_estatus'] == 'REGISTRADO')
							&&
							($cliente['cond_conductor'] == 0)
						)
						{
							
							if 	(
									($data_clte['cond_estatus'] == 'REGISTRADO')
									&&
									($data_clte['cond_conductor'] != 0)								
								)
								{									
									$primera_asignacion=1;
								}
							
						}	
					$primera_asignacion=1;
					$data_clte['cei_id'] = 4;
					$data_clte=array_to_upper($data_clte);
					if ($this->cliente->actualiza($cliente_id, $data_clte))
					{
						if ($usuario['usr_puesto'] == 'ANALISTA SURA')
						{
							/*$data_clte=array_to_upper($data_clte);
								
							$this->load->helper('mail');
							$data_clte['cond_id']= $cliente_id;
							$data_email['asegurado'] = $data_clte;
							$data_email['usuario'] = $usuario;
							$email_quien_recibe['correo']=strtolower($usuario['usr_correo']);
							$email_quien_recibe['nombre']=$usuario['usr_nombre'].' '.$usuario['usr_paterno'].' '.$usuario['usr_materno'];

							$mail_anexo['correo']='sura_conduce@humancenter.com.mx';
							$mail_anexo['nombre']='ADMINISTRADOR';				
											
							$html = $this->load->view('examen/conduce_comentarios/email_aviso_comentario',$data_email,TRUE);
							$asunto= 'NOTIFICACIÓN DE CREACIÓN DE SERVICIO *TU SEGURO CONDUCE* '.$cliente_id;
							send_mail_nuevo_comentario2($email_quien_recibe, $asunto, $html,$mail_anexo);
							*/

							$data_insert['emp_id']           = $usuario['emp_id'];
							$data_insert['cond_id']          = $cliente_id;
							$data_insert['usr_id']           = $usuario['usr_id'];
							$data_insert['usr_username']     = $usuario['usr_username'];

							$data_insert['com_comentario']   ="Se crea servicio: ".$cliente_id."<br>";	
							$data_insert['com_f']            =	date('Y-m-d H:i:s'); 
							$data_insert['com_cod']          =	'00';
							$this->comentarios->insert(array_to_upper($data_insert));
							
							//$data_asegurado=$this->asegurado->buscalo($cliente['cond_poliza']);

							$params['aseg_origen'] =$data_clte['cond_origen']; //'45fbdjskfhbasjbfshdbfajbfjhdbjh';//trim($this->input->post('origen'));
							$params['aseg_destino'] =$data_clte['cond_destino']; 
							$params['aseg_tvehiculo'] =trim($this->input->post('tvehiculo'));//$data_clte['cond_tvehiculo']; 
							$params['aseg_mvehiculo'] =trim($this->input->post('mvehiculo'));//$data_clte['cond_mvehiculo']; 
							$params['aseg_movehiculo'] =trim($this->input->post('movehiculo')); //$data_clte['cond_movehiculo']; 
							$params['aseg_pvehiculo'] =trim($this->input->post('pvehiculo'));
/*								$params['aseg_referencia'] =$data_clte['cond_referencia']; 
*/
							$asegurado_id=$this->asegurado->actualiza($data_asegurado['aseg_id'], $params);
							
						}
						elseif ($data_clte['cond_estatus'] == 'CANCELADO')
						{
							$data_clte=array_to_upper($data_clte);

							$data_insert['emp_id']           = $usuario['emp_id'];
							$data_insert['cond_id']          = $cliente_id;
							$data_insert['usr_id']           = $usuario['usr_id'];
							$data_insert['usr_username']     = $usuario['usr_username'];

							$data_insert['com_comentario']   ="Se CANCELA el servicio: ".$cliente_id.". POR FAVOR AGREGAR A CONTINUACIÓN LA RAZÓN DE LA CANCELACIÓN.<br> ";	
							$data_insert['com_f']            =	date('Y-m-d H:i:s');  
							$data_insert['com_cod']          =	'08';
							$this->comentarios->insert(array_to_upper($data_insert));
							
							
							//$params['aseg_gasto_kilometros'] = $cliente['cond_gasto_kilometros'];
							$params['aseg_estatus'] = 'CANCELADO';
							$asegurado_id=$this->asegurado->actualiza($data_asegurado['aseg_id'], $params);
							
							$data_usr['usr_unidad_reclutadora']=0;
							$this->usuario->actualiza($cliente['cond_conductor'], $data_usr);
							
						}						
						elseif ($data_clte['cond_estatus'] == 'CONCLUÍDO')
						{
							$data_clte=array_to_upper($data_clte);
							$this->load->helper('mail');
							$data_clte['cond_id']= $cliente_id;
							$data_email['asegurado'] = $data_clte;
							$data_email['usuario'] = $usuario;
														
							$email_quien_recibe['correo']=strtolower($usuario['usr_correo']);
							$email_quien_recibe['nombre']=$usuario['usr_nombre'].' '.$usuario['usr_paterno'].' '.$usuario['usr_materno'];

							$mail_anexo['correo']='sura_conduce@humancenter.com.mx';
							$mail_anexo['nombre']='ADMINISTRADOR';				
							
							/* GENERAR NUEVA ESTRCURA DE CORREO
							$html = $this->load->view('examen/conduce_comentarios/email_aviso_comentario',$data_email,TRUE);
						
							$asunto= 'NOTIFICACIÓN DE TRASLADO DEL VEHICULO DEL SERVICIO *TU SEGURO CONDUCE* '.$cliente_id;
							
							send_mail_nuevo_comentario2($email_quien_recibe, $asunto, $html,$mail_anexo);
							*/

							$data_insert['emp_id']           = $usuario['emp_id'];
							$data_insert['cond_id']          = $cliente_id;
							$data_insert['usr_id']           = $usuario['usr_id'];
							$data_insert['usr_username']     = $usuario['usr_username'];

							$data_insert['com_comentario']   ="Se concluyo el servicio: ".$cliente_id."<br> ";	
							$data_insert['com_f']            =	date('Y-m-d H:i:s');  
							$data_insert['com_cod']          =	'07';
							$this->comentarios->insert(array_to_upper($data_insert));
							
							
							$kilometros_finales= floatval($cliente['cond_credito_kilometros'])-floatval($cliente['cond_gasto_kilometros']);
							
							$params['aseg_estatus'] = 'CONCLUÍDO';
							$params['aseg_gasto_kilometros'] = $cliente['cond_gasto_kilometros'];
							$params['aseg_final_kilometros'] = $kilometros_finales;
							$asegurado_id=$this->asegurado->actualiza($data_asegurado['aseg_id'], $params);
							
							$data_usr['usr_unidad_reclutadora']=0;
							$this->usuario->actualiza($cliente['cond_conductor'], $data_usr);
							
														
							$data_resumen['cond_id'] = $cliente_id;
							$data_resumen['cond_f_resumen'] = date('Y-m-d H:i:s');	
							$data_resumen['log_insrt_f'] = date('Y-m-d H:i:s');		
							$data_resumen['log_insrt_usr_cve'] = $user['usr_id'];	
							$data_resumen['cond_credito_kilometros'] = $cliente['cond_credito_kilometros'];
							$data_resumen['cond_gasto_kilometros'] = $cliente['cond_gasto_kilometros'];
							$data_resumen['cond_kilometros_finales'] = $kilometros_finales;
							$data_resumen['cond_conductor']=$cliente['cond_conductor'];
							
							
							$this->cliente->inserta_documento_resumen($data_resumen);
							
							$data_clte2['cond_eventos_sasegurados']= $cliente ['cond_eventos_sasegurados']+1;
							$this->cliente->actualiza($cliente_id, $data_clte2);
						}
						elseif ($primera_asignacion == 1)
						{							
							$data_clte=array_to_upper($data_clte);
							$this->load->helper('mail');
							$data_clte['cond_id']= $cliente_id;
							$data_email['asegurado'] = $data_clte;
							$data_email['usuario'] = $usuario;
							$chofer = $this->usuario->get($data_clte['cond_conductor']);
							
							/*$email_quien_recibe['correo']=strtolower($chofer['usr_correo']);
							$email_quien_recibe['nombre']=$chofer['usr_nombre'].' '.$chofer['usr_paterno'].' '.$chofer['usr_materno'];
							
							$mail_anexo['correo']='sura_conduce@humancenter.com.mx';
							$mail_anexo['nombre']='ADMINISTRADOR';								
							
							$html = $this->load->view('examen/conduce_comentarios/email_aviso_comentario',$data_email,TRUE);
						
							$asunto= 'ASIGNACIÓN DE SERVICIO '.$cliente_id;	
							send_mail_nuevo_comentario2($email_quien_recibe, $asunto, $html,$mail_anexo);*/

							$data_insert['emp_id']           = $usuario['emp_id'];
							$data_insert['cond_id']          = $cliente_id;
							$data_insert['usr_id']           = $usuario['usr_id'];
							$data_insert['usr_username']     = $usuario['usr_username'];

							$data_insert['com_comentario']   ="Se asigna el servicio al conductor: ".$chofer['usr_nombre'].' '.$chofer['usr_paterno'].' '.$chofer['usr_materno']."<br>";	
							$data_insert['com_f']            =	date('Y-m-d H:i:s');
							$data_insert['com_cod']          =	'01';
							$this->comentarios->insert(array_to_upper($data_insert));	
							
							$params['aseg_estatus'] = 'EN PROCESO';
							$this->asegurado->actualiza($data_asegurado['aseg_id'], $params);
							
							$data_usr['usr_unidad_reclutadora']=-1;
							$this->usuario->actualiza($this->input->post('chofer'), $data_usr);
						}
						
						send_json_ok(array('msg' =>'Se actualizó de forma correcta', 'id' => $cliente_id));
					}
					else
					{
						send_json_error('Ocurrió un error al actualizar el registro.');
					}

                }
                else
                {
                    send_json_error(validation_errors('<div />'));
                }
            }
            else 
            {
	
				$data['conduce'] = 	$cliente;
				$data['choferes']=$this->usuario->get_all_conductores();
				$data['data_asegurado']=$data_asegurado;
                $this->load->helper('template');
                $params_view = array(
                    'title' => 'Conduce',
                    'view' => 'conduce/edit',
                    'view_data' => $data
                   );
                render_template($params_view);  
            }
        }
        else 
        {
            show_error('No existe el cliente');
        }
    }


    public function edita_chofer($cliente_id)
    {  
        $user = $this->session->user;
		$cliente = $this->cliente->get($cliente_id);		
		$usuario_activo = $this->usuario->get($user['usr_id']);
		$usuario=$usuario_activo;
        if($cliente)
        {
            if(isset($_POST) && count($_POST) > 0)     
            {
                if(1)
                {

					$data_clte['cond_estatus'] =  trim($this->input->post('cond_estatus'));

					if ( $this->cliente->actualiza($cliente_id, array_to_upper($data_clte) ) )
					{

						if ($data_clte['cond_estatus'] == 'ASIGNACIÓN CONFIRMADA')
						{
							/* $data_clte=array_to_upper($data_clte);
							$this->load->helper('mail');
							$data_clte['cond_id']= $cliente_id;
							$data_email['asegurado'] = $data_clte;
							$data_email['usuario'] = $usuario;
														
							$email_quien_recibe['correo']=strtolower($usuario['usr_correo']);
							$email_quien_recibe['nombre']=$usuario['usr_nombre'].' '.$usuario['usr_paterno'].' '.$usuario['usr_materno'];

							$mail_anexo['correo']='sura_conduce@humancenter.com.mx';
							$mail_anexo['nombre']='ADMINISTRADOR';				
							
							
							$html = $this->load->view('examen/conduce_comentarios/email_aviso_comentario',$data_email,TRUE);
						
							$asunto= 'NOTIFICACIÓN ASIGNACIÓN CONFIRMADA DEL SERVICIO *TU SEGURO CONDUCE* '.$cliente_id;
							
							send_mail_nuevo_comentario2($email_quien_recibe, $asunto, $html,$mail_anexo);
						 */

							$data_insert['emp_id']           = $usuario['emp_id'];
							$data_insert['cond_id']          = $cliente_id;
							$data_insert['usr_id']           = $usuario['usr_id'];
							$data_insert['usr_username']     = $usuario['usr_username'];

							$data_insert['com_comentario']   ="Se confirma la asignación del servicio ".$cliente_id." por parte del conductor ".$usuario['usr_nombre'].' '.$usuario['usr_paterno'].' '.$usuario['usr_materno']."; se procederá a comunicarse con el usuario que solicito el servicio.<br>";	
							$data_insert['com_f']            =	date('Y-m-d H:i:s');   
							$data_insert['com_cod']          =	'04';
							$this->comentarios->insert(array_to_upper($data_insert));
							
							
							$data_usr['usr_unidad_reclutadora']=$data_insert['cond_id'];
							$this->usuario->actualiza($usuario_activo['usr_id'], $data_usr);
							}
						elseif ($data_clte['cond_estatus'] == 'EL CONDUCTOR HA LLEGADO AL SITIO')
						{
							$data_clte=array_to_upper($data_clte);
							$this->load->helper('mail');
							$data_clte['cond_id']= $cliente_id;
							$data_email['asegurado'] = $data_clte;
							$data_email['usuario'] = $usuario;
							
							/*			
							$email_quien_recibe['correo']=strtolower($usuario['usr_correo']);
							$email_quien_recibe['nombre']=$usuario['usr_nombre'].' '.$usuario['usr_paterno'].' '.$usuario['usr_materno'];

							$mail_anexo['correo']='sura_conduce@humancenter.com.mx';
							$mail_anexo['nombre']='ADMINISTRADOR';				
							
							
							$html = $this->load->view('examen/conduce_comentarios/email_aviso_comentario',$data_email,TRUE);
						
							$asunto= 'NOTIFICACIÓN DE LLEGADA AL SITIO DEL SERVICIO *TU SEGURO CONDUCE* '.$cliente_id;
							
							send_mail_nuevo_comentario2($email_quien_recibe, $asunto, $html,$mail_anexo);
							*/

							$data_insert['emp_id']           = $usuario['emp_id'];
							$data_insert['cond_id']          = $cliente_id;
							$data_insert['usr_id']           = $usuario['usr_id'];
							$data_insert['usr_username']     = $usuario['usr_username'];

							$data_insert['com_comentario']   ="El conductor ".$usuario['usr_nombre'].' '.$usuario['usr_paterno'].' '.$usuario['usr_materno']." ha llegado al sitio origen del servicio ".$cliente_id."<br> ";	
							$data_insert['com_f']            =	date('Y-m-d H:i:s');                
							$data_insert['com_cod']          =	'05';
							$this->comentarios->insert(array_to_upper($data_insert));
						}
						elseif ($data_clte['cond_estatus'] == 'EL CONDUCTOR ACEPTA VEHÍCULO')
						{
							$data_clte=array_to_upper($data_clte);
							$this->load->helper('mail');
							$data_clte['cond_id']= $cliente_id;
							/*$data_email['asegurado'] = $data_clte;
							$data_email['usuario'] = $usuario;
														
							$email_quien_recibe['correo']=strtolower($usuario['usr_correo']);
							$email_quien_recibe['nombre']=$usuario['usr_nombre'].' '.$usuario['usr_paterno'].' '.$usuario['usr_materno'];

							$mail_anexo['correo']='sura_conduce@humancenter.com.mx';
							$mail_anexo['nombre']='ADMINISTRADOR';				
							
							
							$html = $this->load->view('examen/conduce_comentarios/email_aviso_comentario',$data_email,TRUE);
						
							$asunto= 'NOTIFICACIÓN DE ACEPTACIÓN DEL VEHICULO DEL SERVICIO *TU SEGURO CONDUCE* '.$cliente_id;
							
							send_mail_nuevo_comentario2($email_quien_recibe, $asunto, $html,$mail_anexo);
							*/

							$data_insert['emp_id']           = $usuario['emp_id'];
							$data_insert['cond_id']          = $cliente_id;
							$data_insert['usr_id']           = $usuario['usr_id'];
							$data_insert['usr_username']     = $usuario['usr_username'];

							$data_insert['com_comentario']   ="El conductor ".$usuario['usr_nombre'].' '.$usuario['usr_paterno'].' '.$usuario['usr_materno']." ha aceptado el vehículo con placa ".$cliente['cond_pvehiculo'].' del servicio '.$cliente_id."<br> ";	
							$data_insert['com_f']            =	date('Y-m-d H:i:s');
							$data_insert['com_cod']          =	'02';
							$this->comentarios->insert(array_to_upper($data_insert));
						}
						elseif ($data_clte['cond_estatus'] == 'EN TRASLADO')
						{
							$data_clte=array_to_upper($data_clte);
							$this->load->helper('mail');
							$data_clte['cond_id']= $cliente_id;
							/*$data_email['asegurado'] = $data_clte;
							$data_email['usuario'] = $usuario;
														
							$email_quien_recibe['correo']=strtolower($usuario['usr_correo']);
							$email_quien_recibe['nombre']=$usuario['usr_nombre'].' '.$usuario['usr_paterno'].' '.$usuario['usr_materno'];

							$mail_anexo['correo']='sura_conduce@humancenter.com.mx';
							$mail_anexo['nombre']='ADMINISTRADOR';				
							
							
							$html = $this->load->view('examen/conduce_comentarios/email_aviso_comentario',$data_email,TRUE);
						
							$asunto= 'NOTIFICACIÓN DE TRASLADO DEL VEHICULO DEL SERVICIO *TU SEGURO CONDUCE* '.$cliente_id;
							
							send_mail_nuevo_comentario2($email_quien_recibe, $asunto, $html,$mail_anexo);
							*/

							$data_insert['emp_id']           = $usuario['emp_id'];
							$data_insert['cond_id']          = $cliente_id;
							$data_insert['usr_id']           = $usuario['usr_id'];
							$data_insert['usr_username']     = $usuario['usr_username'];

							$data_insert['com_comentario']   ="El conductor ".$usuario['usr_nombre'].' '.$usuario['usr_paterno'].' '.$usuario['usr_materno']." esta transladando el vehículo con placa ".$cliente['cond_pvehiculo'].' del servicio '.$cliente_id."<br> ";	
							$data_insert['com_f']            =	date('Y-m-d H:i:s');  
							$data_insert['com_cod']          =	'03';
							$this->comentarios->insert(array_to_upper($data_insert));
						}
						elseif ($data_clte['cond_estatus'] == 'SE ENTREGA VEHÍCULO')
						{
							$data_clte=array_to_upper($data_clte);
							$this->load->helper('mail');
							$data_clte['cond_id']= $cliente_id;
							/*
							$data_email['asegurado'] = $data_clte;
							$data_email['usuario'] = $usuario;
														
							$email_quien_recibe['correo']=strtolower($usuario['usr_correo']);
							$email_quien_recibe['nombre']=$usuario['usr_nombre'].' '.$usuario['usr_paterno'].' '.$usuario['usr_materno'];

							$mail_anexo['correo']='sura_conduce@humancenter.com.mx';
							$mail_anexo['nombre']='ADMINISTRADOR';				
							
						
							$html = $this->load->view('examen/conduce_comentarios/email_aviso_comentario',$data_email,TRUE);
						
							$asunto= 'NOTIFICACIÓN DE TRASLADO DEL VEHICULO DEL SERVICIO *TU SEGURO CONDUCE* '.$cliente_id;
							
							send_mail_nuevo_comentario2($email_quien_recibe, $asunto, $html,$mail_anexo);
							*/

							$data_insert['emp_id']           = $usuario['emp_id'];
							$data_insert['cond_id']          = $cliente_id;
							$data_insert['usr_id']           = $usuario['usr_id'];
							$data_insert['usr_username']     = $usuario['usr_username'];

							$data_insert['com_comentario']   ="El conductor ".$usuario['usr_nombre'].' '.$usuario['usr_paterno'].' '.$usuario['usr_materno']." ha entregado el vehículo con placa ".$cliente['cond_pvehiculo'].' del servicio '.$cliente_id."<br> ";	
							$data_insert['com_f']            =	date('Y-m-d H:i:s');
							$data_insert['com_cod']          =	'06';
							$this->comentarios->insert(array_to_upper($data_insert));
						}
						
						
						send_json_ok(array('msg' =>'Se actualizó de forma correcta', 'id' => $cliente_id));
					}
					else
					{
						send_json_error('Ocurrió un error al actualizar la conduce.');
					}
                }
                else
                {
                    send_json_error(validation_errors('<div />'));
                }
            }
            else 
            {
	
				$data['conduce'] = 	$cliente;
				$data['choferes']=$this->usuario->get_all_conductores();
				
                $this->load->helper('template');
                $params_view = array(
                    'title' => 'Conduce',
                    'view' => 'conduce/edit_chofer',
                    'view_data' => $data
                   );
                render_template($params_view);  
            }
        }
        else 
        {
            show_error('No existe el cliente');
        }
    }


    public function nuevo()
    {   
		$user = $this->session->user; 
		$usuario = $this->medico->get($user['usr_id']);
		
	    //date_default_timezone_set('America/Mexico_City');
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('nombre','Nombre','required');
            $this->form_validation->set_rules('paterno','Apellido Paterno','required');
            $this->form_validation->set_rules('materno','Apellido Materno','required');
            $this->form_validation->set_rules('poliza','Número de Poliza','required');
			$this->form_validation->set_rules('telefono','Teléfono','required');
			
			$this->form_validation->set_rules('servicio_sura','Tipo de Servicio','required');
			$this->form_validation->set_rules('tipo_usuario','Tipo de Usuario','required');

            if($this->form_validation->run())
            {

                $data_clte['cond_nombre'] =  trim($this->input->post('nombre'));
                $data_clte['cond_paterno'] =  trim($this->input->post('paterno'));
                $data_clte['cond_materno'] =  trim($this->input->post('materno'));
                $data_clte['cond_poliza'] =  trim($this->input->post('poliza'));
				$data_clte['cond_tel'] = trim($this->input->post('telefono'));
				$data_clte['cond_servicio_sura'] = trim($this->input->post('servicio_sura'));
				$data_clte['cond_tipo_usuario'] = trim($this->input->post('tipo_usuario'));				
				$data_clte['cond_rol_sura_servicio']=$this->input->post('rol_sura_servicio');				
				$data_clte['cond_email']=$this->input->post('email');



				if ($data_clte['cond_rol_sura_servicio'] == 4)
				{
					$data_clte['cond_nombre_servicio'] =  trim($this->input->post('nombre_servicio'));
					$data_clte['cond_paterno_servicio'] =  trim($this->input->post('paterno_servicio'));
					$data_clte['cond_materno_servicio'] =  trim($this->input->post('materno_servicio'));					
				}	
				else
				{
					$data_clte['cond_nombre_servicio'] =  trim($this->input->post('nombre'));
					$data_clte['cond_paterno_servicio'] =  trim($this->input->post('paterno'));
					$data_clte['cond_materno_servicio'] =  trim($this->input->post('materno'));					
					
				}	

				
				$data_clte=array_to_upper($data_clte);
				$data_asegurado=$this->asegurado->buscalo($data_clte['cond_poliza']);
                $data_clte['cond_eventos_sasegurados']=$this->asegurado->count_eventos_sasegurados($data_clte['cond_poliza']);

				if($cliente_id = $this->cliente->inserta($data_clte))
                {
					
					if ($data_asegurado)
					{
						//existe el asegurado hay que actualizar el registro
						
						$params['cond_id'] =  $cliente_id;
						$params['aseg_sura'] =  $user['usr_id'];
						$params['aseg_credito_kilometros'] ='si entre al loop:'.$params['cond_id'].'|';
						$params['log_insrt_f'] = $data_asegurado['log_insrt_f'];
						$params['aseg_f'] =  date('Y-m-d H:i:s');
						$params['aseg_estatus'] =  'ACTIVO';
						$params['aseg_credito_kilometros'] =  $data_asegurado['aseg_final_kilometros'];
						$params['aseg_gasto_kilometros'] =  '0.00';
						$params['aseg_final_kilometros']=$data_asegurado['aseg_final_kilometros']; //$data_asegurado['aseg_credito_kilometros'];
						
						$params['aseg_nombre'] =  $data_clte['cond_nombre'];
						$params['aseg_paterno'] =  $data_clte['cond_paterno'];
						$params['aseg_materno'] =  $data_clte['cond_materno'];
						$params['aseg_poliza'] =  $data_clte['cond_poliza'];
						
								
						$params['aseg_rol_sura_servicio'] = $data_clte['cond_rol_sura_servicio'];

						$params['aseg_nombre_servicio'] = $data_clte['cond_nombre_servicio'];
						$params['aseg_paterno_servicio'] = $data_clte['cond_paterno_servicio'];
						$params['aseg_materno_servicio'] = $data_clte['cond_materno_servicio'];							
						
						
						
						$params['aseg_tel'] = $data_clte['cond_tel'] ;
						$params['aseg_servicio_sura'] = $data_clte['cond_servicio_sura'];
					
						$params['aseg_tipo_usuario'] = $data_clte['cond_tipo_usuario'];
					/**/	
						$asegurado_id=$this->asegurado->inserta($params);

					}
					else
					{
						//no exite el asegurado se debe crear
						
						$params['cond_id'] =  $cliente_id;
						$params['aseg_sura'] =  $user['usr_id'];
						$params['log_insrt_f'] =  date('Y-m-d H:i:s');
						$params['aseg_f'] =  date('Y-m-d H:i:s');
						$params['aseg_estatus'] =  'ACTIVO';
						$params['aseg_credito_kilometros'] =  '100.00';
						$params['aseg_gasto_kilometros'] =  '0.00';
						$params['aseg_final_kilometros']=$params['aseg_credito_kilometros'];

						$params['aseg_rol_sura_servicio'] = $data_clte['cond_rol_sura_servicio'];

						$params['aseg_nombre_servicio'] = $data_clte['cond_nombre_servicio'];
						$params['aseg_paterno_servicio'] = $data_clte['cond_paterno_servicio'];
						$params['aseg_materno_servicio'] = $data_clte['cond_materno_servicio'];							
						
						$params['aseg_nombre'] =  $data_clte['cond_nombre'];
						$params['aseg_paterno'] =  $data_clte['cond_paterno'];
						$params['aseg_materno'] =  $data_clte['cond_materno'];
						$params['aseg_poliza'] =  $data_clte['cond_poliza'];
						$params['aseg_tel'] = $data_clte['cond_tel'];
						$params['aseg_servicio_sura'] = $data_clte['cond_servicio_sura'];
						$params['aseg_tipo_usuario'] = $data_clte['cond_tipo_usuario'];
						
						$asegurado_id=$this->asegurado->inserta($params);
						
					}	
					
					$params0['cond_credito_kilometros']=$params['aseg_credito_kilometros'];
					$params0['aseg_id']=$asegurado_id;
					
					$this->cliente->actualiza($cliente_id, $params0);					
					
						/*
							$this->load->helper('mail');						
							$data_email['asegurado'] = $data_clte;
							$data_email['usuario'] = $usuario;
														
							$email_quien_recibe['correo']=strtolower($usuario['usr_correo']);
							$email_quien_recibe['nombre']=$usuario['usr_nombre'].' '.$usuario['usr_paterno'].' '.$usuario['usr_materno'];

							$mail_anexo['correo']='sura_conduce@humancenter.com.mx';
							$mail_anexo['nombre']='ADMINISTRADOR';				
							
				
							$html = $this->load->view('examen/conduce_comentarios/email_aviso_comentario',$data_email,TRUE);
						
							$asunto= 'NOTIFICACIÓN DE COMENTARIO SOBRE '.$persona['clte_nombre'].' '.$persona['clte_2_nombre'].' '.$persona['clte_paterno'].' '.$persona['clte_materno'];
							
							send_mail_nuevo_comentario2($email_quien_recibe, $asunto, $html,$mail_anexo);	                
						*/
							send_json_ok(array('msg' =>'Se registro adecuadamente.', 'id' => $cliente_id));
                }
                else
                {
                    send_json_error('Ocurrió un error al guardar el registro.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
		
/*		
            $this->load->model('empresa/Empresa_model','empresa');
	
			
			if (($user_root3 == 2) && ($user_root4 == 3))
			{
				$data['empresas'] = $this->empresa->get_all_empresas_gsi_id();;			
			}
			elseif ($user_root4 == 5)
			{
				$data['empresas'] = $this->empresa->trae_emp_asig($medico['usr_emp_asig']);			
			}
			else
			{
				$data['empresas'] = $this->empresa->trae_empresas();//$this->empresa->get_all_empresas();
			}
			
		
			$data['sucursals'] = $this->empresa->get_all_sucursales();
			
			//$data['despachos'] = $this->empresa->get_all_despachos();
      */     
			
			$this->load->helper('template');
            $params_view = array(
                'title' => 'Conduces',
                'view' => 'conduce/add',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }

    public function lista()
    {   //date_default_timezone_set('America/Mexico_City');
	    //echo " Punto A ";

		//echo " Punto AA ";

		//echo " Punto AAA ";
		$user_cei=get_cei_id();
		//echo " Punto AAAA ";

		$user = $this->session->user; 
		$medico = $this->medico->get($user['usr_id']);
		$usuario = $this->medico->get($user['usr_id']);
		
        $rows = 30;
        $this->load->library('pagination');
        $config['base_url'] = base_url('conduce/lista/');
		
		if ($usuario['usr_puesto']=='CONDUCTOR')
		{
			$config['total_rows'] = $this->cliente->count_allo_conductor($user['usr_id']);
		}	
		else
		{
			$config['total_rows'] = $this->cliente->count_allo();
		}
		
		$config['per_page'] = $rows;
        $config['attributes'] = array('class' => 'pagination');
        $config['full_tag_open'] = '<div class="pagination-full">';
        $config['full_tag_close'] = '</div>';
        $config['uri_segment'] = 3;
        $config['query_string_segment'] = 4;
        $config['use_page_numbers'] = TRUE;
        $this->pagination->initialize($config);


		if ($usuario['usr_puesto']=='CONDUCTOR')
		{
			$data['clientes'] = $this->cliente->get_allo_conductor($rows,$user['usr_id']);
		}	
		else
		{
			$data['clientes'] = $this->cliente->get_allo($rows);
		}
		

       $this->load->helper('template');
        $params_view = array(
            'title' => 'Conduces',
            'view' => 'conduce/index',
            'view_data' => $data 
           );
        render_template($params_view);  
    }

/***********************************************************************************************/
    public function rep_eee()
    {
        $this->load->helper('template');
        $params_view = array(
            'title' => 'Inicio',
            'view' => 'conduce/inicio_view_rep_eee',
            'view_data' => $data
            );
        render_template($params_view);
    } 
    public function rep_seg()
    {
        $this->load->helper('template');
        $params_view = array(
            'title' => 'Inicio',
            'view' => 'conduce/inicio_view_rep_seguridad',
            'view_data' => $data
            );
        render_template($params_view);
    }


    public function rep_seg_pdf()
    {
        $this->load->helper('template');
        $params_view = array(
            'title' => 'Inicio',
            'view' => 'conduce/inicio_view_pdf_seguridad',
            'view_data' => $data
            );
        render_template($params_view);
    }


    public function rep_eva()
    {
        $this->load->helper('template');
        $params_view = array(
            'title' => 'Inicio',
            'view' => 'conduce/inicio_view_rep_evaluados',
            'view_data' => $data
            );
        render_template($params_view);
    } 

    public function rep_emp()
    {
        $this->load->helper('template');
        $params_view = array(
            'title' => 'Inicio',
            'view' => 'conduce/inicio_view_rep_empleados',
            'view_data' => $data
            );
        render_template($params_view);
    } 



    public function rep_emp_sw($modo)
    {
        $this->load->helper('template');
		$data['modo']=$modo;
        $params_view = array(
            'title' => 'Inicio',
            'view' => 'conduce/inicio_view_rep_emp_sw',
            'view_data' => $data
            );
        render_template($params_view);
    } 


    public function rep_empleados_mod($modo)
    {
        $this->load->helper('template');
		$data['modo']=$modo;
        $params_view = array(
            'title' => 'Inicio',
            'view' => 'conduce/inicio_view_rep_emp_mod',
            'view_data' => $data
            );
        render_template($params_view);
    } 


    public function rep_lab()
    {
        $this->load->helper('template');
        $params_view = array(
            'title' => 'Inicio',
            'view' => 'conduce/inicio_view_rep_eva_lab',
            'view_data' => $data
            );
        render_template($params_view);
    }



    public function lista_empleados_gsi()
    {   //date_default_timezone_set('America/Mexico_City');
	    //echo " Punto A ";
		$suc=get_sucursal_id();
		//echo " Punto AA ";
		$user_despacho=get_desp_id_usr();
		//echo " Punto AAA ";
		$user_cei=get_cei_id();
		//echo " Punto AAAA ";
		$user_root1=get_my_user_root1();
		$user_root3=get_my_user_root3();
		$user_root4=get_my_user_root4();
		$user = $this->session->user; 
		$medico = $this->medico->get($user['usr_id']);

        $rows = 30;
        $this->load->library('pagination');
        $config['base_url'] = base_url('conduce/lista_empleados_gsi/');
        //$config['total_rows'] = $this->cliente->count_all();

		$gss=get_empresas_corporativo('GSI');		
		//print_r($gss);
		
		$config['total_rows'] = $this->cliente->count_allo_empleados_empresas($gss);			

		
		$config['per_page'] = $rows;
        $config['attributes'] = array('class' => 'pagination');
        $config['full_tag_open'] = '<div class="pagination-full">';
        $config['full_tag_close'] = '</div>';
        $config['uri_segment'] = 3;
        $config['query_string_segment'] = 4;
        $config['use_page_numbers'] = TRUE;
        $this->pagination->initialize($config);
        
		$data['clientes'] = $this->cliente->get_allo_empleados_empresas($rows,$gss);			

        $this->load->model('empresa/Empresa_model','empresa');

		$data['empresas'] =  $this->empresa->get_all_empresas_gss($gss);			
		$data['sucursales'] = $this->empresa->get_all_sucursales_empresas($gss);

        
        $this->load->helper('template');
        $params_view = array(
            'title' => 'Conduces',
            'view' => 'conduce/index_empleados_gsi',
            'view_data' => $data 
           );
        render_template($params_view);  
    }


 

 
 
     public function lista_wrk()
    {   
	    //echo " Punto A ";
		$suc=get_sucursal_id();
		//echo " Punto AA ";
		$user_despacho=get_desp_id_usr();
		//echo " Punto AAA ";
		$user_cei=get_cei_id();
		//echo " Punto AAAA ";
		$user_root1=get_my_user_root1();
		$user_root3=get_my_user_root3();
		$user_root4=get_my_user_root4();
		$user = $this->session->user; 
		$medico = $this->medico->get($user['usr_id']);
		$usuario = $this->medico->get($user['usr_id']);
        $rows = 30;
        $this->load->library('pagination');
        $config['base_url'] = base_url('conduce/lista_wrk/');
		
		
		//echo $usuario['empresas'];
		$i=0;
		foreach ( explode(';',$usuario['empresas'] )  as $esta_empresa) 
		{
			if ($esta_empresa > 0)
			{	
				$empresas[$i]=$esta_empresa;
				$i++;
			}
		}
		
		
		
		//$empresas= array(31,289,293);
		$config['total_rows'] = $this->cliente->count_all_wrk($empresas);
 		
		$config['per_page'] = $rows;
        $config['attributes'] = array('class' => 'pagination');
        $config['full_tag_open'] = '<div class="pagination-full">';
        $config['full_tag_close'] = '</div>';
        $config['uri_segment'] = 3;
        $config['query_string_segment'] = 4;
        $config['use_page_numbers'] = TRUE;
        $this->pagination->initialize($config);

		$data['clientes'] = $this->cliente->get_all_wrk($rows, $empresas);
			
        $this->load->model('empresa/Empresa_model','empresa');
        $data['empresas'] = $this->empresa->trae_empresas_wrk($empresas);

        $this->load->helper('template');
        $params_view = array(
            'title' => 'Conduces',
            'view' => 'conduce/index_wrk',
            'view_data' => $data 
           );
        render_template($params_view);  
    }
 
 
 
 
 
     public function lista_evaluados()
    {   
	    //echo " Punto A ";
		$suc=get_sucursal_id();
		//echo " Punto AA ";
		$user_despacho=get_desp_id_usr();
		//echo " Punto AAA ";
		$user_cei=get_cei_id();
		//echo " Punto AAAA ";
		$user_root1=get_my_user_root1();
		$user_root3=get_my_user_root3();
		$user_root4=get_my_user_root4();
		$user = $this->session->user; 
		$medico = $this->medico->get($user['usr_id']);
		$medico['emp_id']=$user['emp_id'];
		

        $rows = 30;
        $this->load->library('pagination');
        $config['base_url'] = base_url('conduce/lista_evaluados/');
        //$config['total_rows'] = $this->cliente->count_all();
		
		$config['total_rows'] = $this->cliente->count_allo_emp_asig($medico['emp_id']);

		$config['per_page'] = $rows;
        $config['attributes'] = array('class' => 'pagination');
        $config['full_tag_open'] = '<div class="pagination-full">';
        $config['full_tag_close'] = '</div>';
        $config['uri_segment'] = 3;
        $config['query_string_segment'] = 4;
        $config['use_page_numbers'] = TRUE;
        $this->pagination->initialize($config);
        
		$data['clientes'] = $this->cliente->get_allo_emp_asig_psw($rows,$medico['emp_id']);

        $this->load->model('empresa/Empresa_model','empresa');
		$data['empresas'] = $this->empresa->trae_emp_asig($medico['emp_id']);		

        $this->load->helper('template');
        $params_view = array(
            'title' => 'Conduces',
            'view' => 'conduce/index_evaluados',
            'view_data' => $data 
           );
        render_template($params_view);  
    }
 

    public function lista_psw()
    {   
	    //echo " Punto A ";
		$suc=get_sucursal_id();
		//echo " Punto AA ";
		$user_despacho=get_desp_id_usr();
		//echo " Punto AAA ";
		$user_cei=get_cei_id();
		//echo " Punto AAAA ";
		$user_root1=get_my_user_root1();
		$user_root3=get_my_user_root3();
		$user_root4=get_my_user_root4();
		$user = $this->session->user; 
		$medico = $this->medico->get($user['usr_id']);
		$medico['emp_id']=253;
		

        $rows = 30;
        $this->load->library('pagination');
        $config['base_url'] = base_url('conduce/lista_psw/');
        //$config['total_rows'] = $this->cliente->count_all();
		
		$config['total_rows'] = $this->cliente->count_allo_emp_asig($medico['emp_id']);

		$config['per_page'] = $rows;
        $config['attributes'] = array('class' => 'pagination');
        $config['full_tag_open'] = '<div class="pagination-full">';
        $config['full_tag_close'] = '</div>';
        $config['uri_segment'] = 3;
        $config['query_string_segment'] = 4;
        $config['use_page_numbers'] = TRUE;
        $this->pagination->initialize($config);
        
		$data['clientes'] = $this->cliente->get_allo_emp_asig_psw($rows,$medico['emp_id']);

        $this->load->model('empresa/Empresa_model','empresa');
		$data['empresas'] = $this->empresa->trae_emp_asig($medico['emp_id']);		

        $this->load->helper('template');
        $params_view = array(
            'title' => 'Conduces',
            'view' => 'conduce/index_psw',
            'view_data' => $data 
           );
        render_template($params_view);  
    }

    public function lista_dx()
    {   
	    //echo " Punto A ";
		
		$user = $this->session->user; 
		$medico = $this->medico->get($user['usr_id']);
		$corporacion=  get_corporativo_consultorio($medico['usr_emp_asig']);
		$suc=get_sucursal_id();
		$user_despacho=get_desp_id_usr();
		$user_cei=get_cei_id();
		$user_root1=get_my_user_root1();

        $rows = 30;
        $this->load->library('pagination');
        $config['base_url'] = base_url('conduce/lista_dx/');
		
		$config['total_rows'] = $this->cliente->count_allo_dx();
		

        $config['per_page'] = $rows;
        $config['attributes'] = array('class' => 'pagination');
        $config['full_tag_open'] = '<div class="pagination-full">';
        $config['full_tag_close'] = '</div>';
        $config['uri_segment'] = 3;
        $config['query_string_segment'] = 4;
        $config['use_page_numbers'] = TRUE;
        $this->pagination->initialize($config);
        //echo " Punto ".$medico['usr_emp_asig'];
		//echo " Punto B ";
        //$data['clientes'] = $this->cliente->get_all($rows);
		
		$data['clientes'] = $this->cliente->get_allo_dx($rows);
		
		
		//echo " Punto C ";
		$this->load->model('empresa/Empresa_model','empresa');
		$data['sucursales']=$this->empresa->get_all_sucursales(get_empresa_consultorio($medico['usr_emp_asig']));

		//echo " Punto E ";		
		$data['corporacion']=$corporacion;
        $data['medico']=$medico;
		$this->load->helper('template');
        $params_view = array(
            'title' => 'Conduces',
            'view' => 'conduce/index_dx',
            'view_data' => $data 
           );
        render_template($params_view);  
    }

    public function lista_px()
    {   
	    //echo " Punto A ";
		
		$user = $this->session->user; 
		$medico = $this->medico->get($user['usr_id']);
		$corporacion=  get_corporativo_consultorio($medico['usr_emp_asig']);
		$suc=get_sucursal_id();
		$user_despacho=get_desp_id_usr();
		$user_cei=get_cei_id();
		$user_root1=get_my_user_root1();

        $rows = 30;
        $this->load->library('pagination');
        $config['base_url'] = base_url('conduce/lista_p/');
		
		$config['total_rows'] = $this->cliente->count_allo_p($suc,$medico['usr_emp_asig'],$user_despacho,$user_cei,$user_root1,1);

        $config['per_page'] = $rows;
        $config['attributes'] = array('class' => 'pagination');
        $config['full_tag_open'] = '<div class="pagination-full">';
        $config['full_tag_close'] = '</div>';
        $config['uri_segment'] = 3;
        $config['query_string_segment'] = 4;
        $config['use_page_numbers'] = TRUE;
        $this->pagination->initialize($config);
        //echo " Punto ".$medico['usr_emp_asig'];
		//echo " Punto B ";
        //$data['clientes'] = $this->cliente->get_all($rows);
		
		$data['clientes'] = $this->cliente->get_allo_p($rows,$medico['usr_emp_asig'],get_sucursal_id(),$user_despacho,$user_cei,$user_root1,1);
		
		
		//echo " Punto C ";
		$this->load->model('empresa/Empresa_model','empresa');
		$data['sucursales']=$this->empresa->get_all_sucursales(get_empresa_consultorio($medico['usr_emp_asig']));

		//echo " Punto E ";		
		$data['corporacion']=$corporacion;
        $data['medico']=$medico;
		$this->load->helper('template');
        $params_view = array(
            'title' => 'Conduces',
            'view' => 'conduce/index_px',
            'view_data' => $data 
           );
        render_template($params_view);  
    }



    public function lista_p($corporacion)
    {   
	    //echo " Punto A ";
		$corporacion='GSI';
		$suc=get_sucursal_id();
		$user_despacho=get_desp_id_usr();
		$user_cei=get_cei_id();
		$user_root1=get_my_user_root1();
		$user = $this->session->user; 
		$medico = $this->medico->get($user['usr_id']);
		
		/**es el medico ISMAEL PEREZ GUTIERREZ?*/
		$segundo_turno='Saturday';
		$dia='semana';
		if ($user['usr_id'] == 402) 
		{
			$dia=date('l jS \of F Y');
			//echo $dia;
		}
		
        $rows = 30;
        $this->load->library('pagination');
        $config['base_url'] = base_url('conduce/lista_p/');
		
		if ($corporacion == 'GSI')
		{
			if ( ($user['usr_id'] == 402)  && strstr($dia,$segundo_turno) )
			{
				$config['total_rows'] = $this->cliente->count_allo_p_gsi($suc,94,$user_despacho,$user_cei,$user_root1,1);
			}
			else
			{
				$config['total_rows'] = $this->cliente->count_allo_p_gsi($suc,$medico['usr_emp_asig'],$user_despacho,$user_cei,$user_root1,1);
			}
		}
		
        $config['per_page'] = $rows;
        $config['attributes'] = array('class' => 'pagination');
        $config['full_tag_open'] = '<div class="pagination-full">';
        $config['full_tag_close'] = '</div>';
        $config['uri_segment'] = 3;
        $config['query_string_segment'] = 4;
        $config['use_page_numbers'] = TRUE;
        $this->pagination->initialize($config);
        //echo " Punto ".$medico['usr_emp_asig'];
		//echo " Punto B ";
        //$data['clientes'] = $this->cliente->get_all($rows);
		
		
		if ($corporacion == 'GSI')
		{
			if ( ($user['usr_id'] == 402)  && strstr($dia,$segundo_turno) )
			{
				$data['clientes'] = $this->cliente->get_allo_p_gsi($rows,94,get_sucursal_id(),$user_despacho,$user_cei,$user_root1,1);
			}
			else
			{
				$data['clientes'] = $this->cliente->get_allo_p_gsi($rows,$medico['usr_emp_asig'],get_sucursal_id(),$user_despacho,$user_cei,$user_root1,1);
			}
		}
				
		
		//echo " Punto C ";
		$this->load->model('empresa/Empresa_model','empresa');

		if ($corporacion == 'GSI')
		{	
			$data['empresas'] = $this->empresa->get_sis15_empresas_gsi(); //$this->empresa->get_all_empresas_gsi();
		}
		
		//echo " Punto E ";		
		
        $data['medico']=$medico;
		$this->load->helper('template');
        $params_view = array(
            'title' => 'Conduces',
            'view' => 'conduce/index_p',
            'view_data' => $data 
           );
        render_template($params_view);  
    }





 

 


   public function ida($cliente_id)
    {   
		$user = $this->session->user; 
		$usuario = $this->medico->get($user['usr_id']);
		$data['conduce'] = $this->cliente->get($cliente_id,0); //get_desp_id_usr()
		$this->load->helper('pdf');
		tamplete($this->load->view('conduce/pdf_ida',$data,TRUE),$data['cliente']['med_id'],$data['cliente']['med_id'],$data['cliente']['med_id'],'Humancenter Review S.A de C.V.');
	}


 
     public function nuevo_objeto()
    {    
		$user_root1=get_my_user_root1();
		$user_root3=get_my_user_root3();
		$user_root4=get_my_user_root4();
		$user = $this->session->user; 
		$medico = $this->medico->get($user['usr_id']);
	    //date_default_timezone_set('America/Mexico_City');
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('nombre','Número de Serie','required');
            $this->form_validation->set_rules('nombre_adic','Número de Serie del Motor','required');
			$this->form_validation->set_rules('paterno','Marca','required');
			$this->form_validation->set_rules('materno','Submarca','required');
			$this->form_validation->set_rules('puesto','Modelo (Año)','required');
			$this->form_validation->set_rules('nac','Placa','required');
            $this->form_validation->set_rules('curp','Kilometraje presentado','required');
			$this->form_validation->set_rules('rfc','Tarjeta de Circulación','required');
            $this->form_validation->set_rules('fnac','Fecha de Adquisición','required');
            $this->form_validation->set_rules('genero','Carga Máxima (Toneladas)','required');
			$this->form_validation->set_rules('grado','Combustible','required');
			$this->form_validation->set_rules('reclutador','Número de Cilindros','required');
			$this->form_validation->set_rules('empresa','Empresa','required');


            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_nombre_crypt'] =  trim($this->input->post('nombre'));
                $data_clte['clte_2_nombre_crypt'] =  trim($this->input->post('nombre_adic'));
                $data_clte['clte_paterno_crypt'] =  trim($this->input->post('paterno'));
                $data_clte['clte_materno_crypt'] =  trim($this->input->post('materno'));
                
				$data_clte['clte_f_nac'] = formatea_fecha_mysql($this->input->post('fnac'));
				//$data_clte['clte_f_nac'] = $this->input->post('fnac');
				
				$data_clte['clte_genero_cve'] =  $this->input->post('genero');
                				
				$data_clte['clte_rfc_crypt'] =  $this->input->post('rfc');
                				
				$data_clte['clte_curp_crypt'] =  $this->input->post('curp');
                
                //dopmcicio de la conduce
                $data_clte['clte_env_pais_cve'] =  $this->input->post('pais');
                $data_clte['clte_env_cp'] =  $this->input->post('cp');
                $data_clte['clte_env_edo_cve'] =  $this->input->post('entidad');
                $data_clte['clte_env_colonia_crypt'] =  $this->input->post('colonia');
                $data_clte['clte_env_localidad'] =  $this->input->post('localidad');
                $data_clte['clte_env_municipio'] =  $this->input->post('municipio');
                $data_clte['clte_env_calle_crypt'] =  $this->input->post('calle');
                $data_clte['clte_env_num_ext_crypt'] =  $this->input->post('next');
                $data_clte['clte_env_num_int_crypt'] =  $this->input->post('nint');
                $data_clte['clte_nss_crypt'] =  $this->input->post('nss');
                //informacion de conrtaxcto de la conduce
                $data_clte['clte_tel_casa_crypt'] =  limpia_telefono($this->input->post('tel'));                
                $data_clte['clte_cel_crypt'] =  limpia_telefono($this->input->post('cel'));
                $data_clte['clte_email_crypt'] =  $this->input->post('correo');
                
                //nuevos campos
                $data_clte['clte_grado_acad_cve'] =  $this->input->post('grado');
                $data_clte['clte_puesto'] =  $this->input->post('puesto');
                $data_clte['clte_edo_civ_cve'] =  $this->input->post('civil');
                $data_clte['clte_nac_cve'] =  $this->input->post('nac');
				//nuevo campo de ubicacion
				
                $data_clte['clte_lab_ubicacion'] =  $this->input->post('ubicacion');
				$data_clte['clte_reclutador'] =  $this->input->post('reclutador');
  
                //empresa donde va a loborar la conduce
				
				
                $data_clte['emp_id'] =  $this->input->post('empresa');
				
				if ( $data_clte['emp_id'] != 180)
				{
				$data_clte['desp_id'] =  $this->input->post('despacho');
				if ($data_clte['desp_id'] == 1) 
				{$data_clte['desp_id']=0;}
			    $data_clte['suc_id'] =  $this->input->post('sucursal');
				}
				else
				{
					$data_clte['emp_id'] = 117;
					$data_clte['suc_id'] = 43;
				}	
				
				
				//cei
				if ($this->input->post('empresa') == 16)
				{	
					$data_clte['cei_id'] =  7;
				}
				else 
				{
					if ($this->input->post('empresa') == 31)
					{	
						$data_clte['cei_id'] =  2;
					}
					else
					{
						$data_clte['cei_id'] =  $this->input->post('cei');
					}
				}


				if (valida_corporacion($data_clte['emp_id'],'GSI') === 'GSI')
				{
					
					if ( ($data_clte['cei_id'] !=6) || ($data_clte['cei_id'] !=4))
					{
						$data_clte['cei_id'] = get_cei_id();
					}
					
				}

					if (($user_root3 == 2) && ($user_root4 == 3))
					{
						$data_clte['cei_id'] = get_cei_id();
					}

                $data_clte['desp_id'] =  $this->input->post('despacho');
                $data_clte['clte_reclutador'] =  $this->input->post('reclutador');
				
				//examenes
				
					$nomserv='';

                
                if(!empty($_FILES['foto']['name']))
                {
                    $this->load->library('upload');
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/fotos/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg',
                            'max_size'      => '25000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('foto'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['clte_path_foto'] = $data['file_name'];
                    }
                }

				if ($data_clte['emp_id'] == 194)
				{
					$data_clte['nomserv']='PREVEM;';
				}elseif ($data_clte['emp_id'] == 182)
				{
					$data_clte['nomserv']='FILOA;';
				}elseif ($data_clte['emp_id'] == 193)
				{
					$data_clte['nomserv']='ALLIANZ;';
				} 
				elseif ($data_clte['emp_id'] == 230)
					{
						$data_clte['nomserv'].='AXA;';
					}
				$data_clte['clte_objeto'] =  $this->input->post('objeto');
				$data_clte=array_to_upper($data_clte);
				$encontrado = $this->cliente->buscate($data_clte['clte_nombre_crypt'], $data_clte['clte_2_nombre_crypt'],  $data_clte['clte_paterno_crypt'],$data_clte['clte_materno_crypt']);
				$diff=61;
				
				$rfc_test=$data_clte['clte_rfc_crypt'];
				
				$encontrado_error_long_rfc=0;
				

				{
					if (strlen($data_clte['clte_rfc_crypt']) < 10)
					{						
						$data_clte['clte_rfc_crypt']=substr($data_clte['clte_paterno_crypt'],0,2).substr($data_clte['clte_materno_crypt'],0,1).substr($data_clte['clte_nombre_crypt'],0,1).substr($data_clte['clte_f_nac'],2,2).substr($data_clte['clte_f_nac'],5,2).substr($data_clte['clte_f_nac'],8,2);
					}
				}

				
				if ($encontrado)
				{
					$unafecha=$encontrado[0]['log_insrt_f'];
					$diff= abs(intval(dateDifference($unafecha,date('Y-m-d'))));

				}
	             
				if (($encontrado) && ( $diff < 20))
				{
					send_json_error('Ocurrió un error, el candidato ya fue registrado en la plataforma en la fecha '.formatea_fecha($unafecha).', hace '.$diff.' días.');
				}
				elseif ($data_clte['emp_id'] ==0)
				{
					send_json_error('Ocurrió un error, no se selecciono la EMPRESA.');
					
				}
				elseif($cliente_id = $this->cliente->inserta(array_to_upper($data_clte)))
                {
                    send_json_ok(array('msg' =>'Se guardó de forma correcta el registro del evaluado.', 'id' => $cliente_id));
                }
                else
                {
                    send_json_error('Ocurrió un error al guardar la conduce.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
			
            $this->load->model('empresa/Empresa_model','empresa');
			
			
			if (($user_root3 == 2) && ($user_root4 == 3))
			{
				$data['empresas'] = $this->empresa->get_all_empresas_gsi_id();;			
			}
			elseif ($user_root4 == 5)
			{
				$data['empresas'] = $this->empresa->trae_emp_asig($medico['usr_emp_asig']);			
			}
			else
			{
				$data['empresas'] = $this->empresa->trae_empresas();//$this->empresa->get_all_empresas();
			}
			$data['sucursals'] = $this->empresa->get_all_sucursales();
			//$data['despachos'] = $this->empresa->get_all_despachos();
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Conduces',
                'view' => 'conduce/add_objeto',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }

 
 


/*************************************************************************************/


}