 <?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Easegurados extends CI_Controller {
    
    function __construct() {
        parent::__construct();
		$this->load->model('easegurados/Easegurados_model','easegurado');
		$this->load->model('sasegurados/Sasegurados_model','asegurado');
        $this->load->model('empleado/empleado_model','empleado');
		$this->load->model('persona/Persona_model','cliente');
		$this->load->model('empresa/Empresa_model','empresa');
		$this->load->helper('util');
		$this->load->helper('catalogo');
    }

    function reporte_empleado()
    {

		   $f_ini = $this->input->post('f_ini'); 
           $f_fin = $this->input->post('f_fin'); 
		   $easegurados = $this->easegurado->get_all_reg_by_fecha($f_ini,$f_fin);
   
            $this->load->helper('template');	
            	
		?>


		<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
		<html xmlns="http://www.w3.org/1999/xhtml">

		<head>
		<meta content="es-mx" http-equiv="Content-Language" />
		<meta content="text/html; charset=utf-8" http-equiv="Content-Type" />

            <?php
                $date2today = date("Y-m-d H:i:s");
                $date3today = date("YmdHis");

                header("Content-type: application/octet-stream; charset=latin1");
                header("Content-Disposition: attachment; filename=Rep_reg_insvir_sura_".$date3today.".xls");
                header("Pragma: no-cache");
                header("Expires: 0");
            ?>
				<title>REPORTE USUARIOS</title>
				<style type="text/css">
					.auto-style1 {
						font-family: Arial, Helvetica, sans-serif;
						color: #FFFFFF;
						background-color: #3D5588;
						font-size: small;
					}
					.auto-style4 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: xx-small;
					}
					.auto-style5 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: medium;
					}
					.auto-style6 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: x-large;
						text-align: right;
						font-weight: normal;
					}
					.auto-style7 {
						font-size: small;
					}
					.auto-style8 {
						color: #3D5588;
                        
					}
					.auto-style9 {
						color: #3AD4A7;
					}
								.auto-style11 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: small;
						text-align: right;
					}
					.auto-style12 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: small;
						text-align: center;
					}
					.auto-style13 {
						font-size: xx-small;
					}
					.auto-style14 {
						font-family: Arial, Helvetica, sans-serif;
						color: #FFFFFF;
						background-color: #3D5588;
						font-size: xx-small;
					}
					.auto-style15 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: x-small;
					}
					.auto-style16 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: x-small;
						text-align: right;
					}
					.auto-style17 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: x-small;
						text-align: left;
					}
					.auto-style18 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: xx-small;
						text-align: center;
					}
								.auto-style19 {
						color: #3D5588;
						font-size: medium;
					}
					.auto-style20 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: xx-small;
						text-align: center;
						background-color: #BFEADD;
					}
					.auto-style21 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: xx-small;
						background-color: #BFEADD;
					}

                    
                    
				</style>
			</head>

			<body>
				<table>
					<thead>
						<tr>
							<th class="auto-style5" >&nbsp;</th>
							<th class="auto-style5" >&nbsp;</th>
							<th class="auto-style5" >&nbsp;</th>
							<th class="auto-style5" >&nbsp;</th>
							<th class="auto-style5" >&nbsp;</th>
							<th class="auto-style5" >&nbsp;</th>
						</tr>
						<tr>
							<th class="auto-style5" >&nbsp;</th>
							<th class="auto-style5" ><span class="auto-style8">human</span><span class="auto-style9">center</span></strong></th>
							<th class="auto-style5" > <span class="auto-style8" style="text-align: right">Reporte de Registros VINs y Correos Electrónicos en Plataforma</th>
							<th class="auto-style5" >&nbsp;</th>
							<th class="auto-style5" >&nbsp;</th>
						</tr>
						<tr>
							<th class="auto-style5" >&nbsp;</th>
							<th class="auto-style5" style="height: 27px;"><span class="auto-style19">online</span><sup><span class="auto-style13" style="color: rgb(34, 34, 34); font-family: arial, sans-serif; font-style: normal; font-variant-ligatures: normal; font-variant-caps: normal; font-weight: 400; letter-spacing: normal; orphans: 2; text-align: left; text-indent: 0px; text-transform: none; white-space: normal; widows: 2; word-spacing: 0px; -webkit-text-stroke-width: 0px; background-color: rgb(255, 255, 255); text-decoration-style: initial; text-decoration-color: initial; display: inline !important; float: none;">®</span></sup></th>
							<th class="auto-style5" style="height: 27px;"> <?php echo $date2today; ?></th>
							<th class="auto-style5" >&nbsp;</th>
							<th class="auto-style5" >&nbsp;</th>
							<th class="auto-style5" >&nbsp;</th>							
						</tr>
						<tr>
							<th class="auto-style5" >&nbsp;</th>
							<th class="auto-style5" >&nbsp;</th>
							<th class="auto-style5" style="height: 27px;"> <?php echo 'Del '.formatea_fecha($f_ini).' al '.formatea_fecha($f_fin); ?></th>
							<th class="auto-style5" >&nbsp;</th>
							<th class="auto-style5" >&nbsp;</th>
							<th class="auto-style5" >&nbsp;</th>
						</tr>
						<tr>
							<th class="auto-style5" >&nbsp;</th>
							<th class="auto-style5" >&nbsp;</th>
							<th class="auto-style5" >&nbsp;</th>
							<th class="auto-style5" >&nbsp;</th>
							<th class="auto-style5" >&nbsp;</th>
							<th class="auto-style5" >&nbsp;</th>
						</tr>
                        
						<tr>
							<th class="auto-style14" style="width: 150px">Id</th>
							<th class="auto-style14" style="width: 500px">Número de Serie / VIN</th>
							<th class="auto-style14" style="width: 800px">Correo Electrónico</th>
							<th class="auto-style14" style="width: 200px">Fecha de Registro</th>
                            <th class="auto-style14" style="width: 200px">Registrado por</th>
						</tr>

					</thead>
					<tbody id="resultado">
						<?php        
						$class18=" ";
						if($easegurados): 
						
							foreach ($easegurados  as $easegurado): 
								if ($class18 != "auto-style18")
								{
									$class18="auto-style18";
									$class4="auto-style4";
                                    
								}	
								else
								{
									$class18="auto-style20";
									$class4="auto-style21";	
								}
							?>
					
								<tr  style="background-color:<?php echo $renglon; ?>;"  >

                                    <td class=<?php echo $class18; ?>>
										<b>
											<?php echo $easegurado['sura_id']; ?> 
										</b>	
                                    </td>

									<td class=<?php echo $class18; ?>>
										<b>
											<?php echo $easegurado['sura_numeroserie']; ?>
										</b>
									</td>

                                    <td class=<?php echo $class18; ?>>
										<b>
											<?php echo $easegurado['sura_correo']; ?>
										</b>
									</td>

                                    <td class=<?php echo $class18; ?>>
										<b>
											<?php echo formatea_fechahora($easegurado['log_insrt_f']); ?>
										</b>
									</td>

                                    <td class=<?php echo $class18; ?>>
										<b>
											<?php echo $easegurado['log_insrt_usr_cve']; ?>
										</b>
									</td>
                                </tr>
							<?php 
							endforeach;
						endif;
						?> 
					</tbody>
				</table>
			</body>
		</html>
		<?php 
	    }
		

    public function nuevo_reporte()
    {       
		$this->load->helper('template');
		$params_view = array(
			'title' => 'Servicios',
			'view' => 'easegurados/ficha_easegurados',
			'view_data' => $data
		   );
		
		render_template($params_view);  
    }

    function busca()
    {    
		$user = $this->session->user; 
		$analista = $this->empleado->get($user['usr_id']);
        $id = trim($this->input->post('id'));
		$numserie = trim(strtoupper($this->input->post('numserie')));
		$mail = trim(strtolower($this->input->post('correo')));
		


		if ( strstr($analista['acciones'],'SURASUPERVISOR') )
		{	
			$analista = $this->input->post('analista');
			$data['easegurados'] = $this->easegurado->busca($id,$numserie,$mail,$analista);
		}
		else
		{									
			$data['easegurados'] = $this->easegurado->busca_by_user($id,$numserie,$mail,$analista['usr_id']);
		}
        send_json_ok($this->load->view('easegurados/busca',$data,TRUE));
    }





    public function reenvia($sura_id)
    {
        $easegurado = $this->easegurado->get($sura_id);
		$user = $this->session->user; 
		$analista = $this->empleado->get($user['usr_id']);
        if($easegurado)
        {

            if(isset($_POST) && count($_POST) > 0)     
            {
                $this->load->library('form_validation');
                $this->form_validation->set_rules('correo','Correo electrónico','required');
                
                if($this->form_validation->run())
                {
                    $data_user['sura_numeroserie'] =  $easegurado ['sura_numeroserie'];
					$data_usr['sura_correo'] =  trim($this->input->post('correo'));

                    if($this->easegurado->actualiza($sura_id, $data_usr))
                    {
						
						$this->load->helper('mail');
                        $data_email = array('sura_numeroserie' => $data_user['sura_numeroserie']);	
						
                        $html = $this->load->view('easegurados/email_add',$data_email,TRUE);
						
						send_mail_from_sura($data_usr['sura_correo'],$html);
						
						$data_log['sura_numeroserie'] =  $data_user['sura_numeroserie'] ;
						$data_log['sura_correo'] = strtolower(trim($this->input->post('correo')));
						$data_log['usr_id'] =  $analista['usr_id'];
						$data_log['emp_id'] =  $analista['emp_id'];		
						$data_log['sura_id'] =  $sura_id;
						$this->easegurado->inserta_ins_log($data_log,'ACTUALIZA REGISTRO');

                        send_json_ok('Se actualizó de forma el reenvio');
                    }
                    else
                    {
                        send_json_error('Ocurrió un error al intentar enviar el correo.');
                    }
                }
                else
                {
                    send_json_error(validation_errors('<div />'));
                }
            }
            else 
            {
			
                $data['easegurado'] = $easegurado;

				$this->load->helper('template');
                $params_view = array(
                    'title' => 'Easegurados',
                    'view' => 'easegurados/edit',
                    'view_data' => $data
                   );
                render_template($params_view);  
            }
        }
        else 
        {
            show_error('No existe el cliente');
        }
    }


    public function index()
    {		
	
		$user = $this->session->user; 
		$analista = $this->empleado->get($user['usr_id']);

        $rows = 15; 
        $this->load->library('pagination');
        $config['base_url'] = base_url('easegurados/index/');
		
		if ( strstr($analista['acciones'],'SURASUPERVISOR') )
		{									
			$config['total_rows'] = $this->easegurado->count_all();
		}
		else
		{									
			$config['total_rows'] = $this->easegurado->count_all_by_user($analista['usr_id']);
		}		
		
		$config['per_page'] = $rows;
        $config['attributes'] = array('class' => 'pagination');
        $config['full_tag_open'] = '<div class="pagination-full">';
        $config['full_tag_close'] = '</div>';
        $config['uri_segment'] = 3;
        $config['query_string_segment'] = 4;
        $config['use_page_numbers'] = TRUE;
        $this->pagination->initialize($config); 


		if ( strstr($analista['acciones'],'SURASUPERVISOR') )
		{									
			$data['easegurados'] = $this->easegurado->get_allo($rows);
			$data['los_analistas']= $this->easegurado->get_analistas('ANALISTA');
		}
		else
		{									
			$data['easegurados'] = $this->easegurado->get_allo_by_user($rows,$analista['usr_id']);
		}
		
		
		$data['analista']=$analista;
        $this->load->helper('template');
        $params_view = array(
            'title' => 'Easegurados',
            'view' => 'easegurados/index',
            'view_data' => $data 
           );
        render_template($params_view);  
    }


    public function nuevo()
    {
		$user = $this->session->user; 
		$analista = $this->empleado->get($user['usr_id']);
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
			$this->form_validation->set_rules('numserie','Número de Serie','required');
			$this->form_validation->set_rules('correo','Correo electrónico','required');
			
            if($this->form_validation->run())
            {
			
				$data_usr['sura_numeroserie'] =  trim($this->input->post('numserie'));
                $data_usr = array_to_upper($data_usr);
				$data_usr['sura_correo'] = strtolower(trim($this->input->post('correo')));
				
				
				$data_usr['usr_id'] =  $analista['usr_id'];
				$data_usr['emp_id'] =  $analista['emp_id'];
				
				$repetido=$this->easegurado->buscat($data_usr['sura_numeroserie']);
				
                if ( $repetido == $data_usr['sura_numeroserie'] )
				{
					send_json_error('El número de serie /VIN ya esta registrado en la base de datos.');	
				}		
				elseif($sura_id=$this->easegurado->inserta($data_usr))
                {
						$this->load->helper('mail');
                        $data_email = array('sura_numeroserie' => $data_usr['sura_numeroserie']);	
						
                        $html = $this->load->view('easegurados/email_add',$data_email,TRUE);
						
						send_mail_from_sura($data_usr['sura_correo'],$html);
						
						$data_log['sura_numeroserie'] =  trim($this->input->post('numserie'));
						$data_log = array_to_upper($data_usr);
						$data_log['sura_correo'] = strtolower(trim($this->input->post('correo')));
						$data_log['usr_id'] =  $analista['usr_id'];
						$data_log['emp_id'] =  $analista['emp_id'];	
						$data_log['sura_id'] =  $sura_id;							
						$this->easegurado->inserta_ins_log($data_log,'INSERTA REGISTRO');
						
					
                    send_json_ok('Se registro la información y se envio el correo electrónico.');
                }
                else
                {
                    send_json_error('Ocurrió un error al guardar el registro.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Easegurados',
                'view' => 'easegurados/add',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }

	/*
   public function borra($sura_id)
    {
        if($this->easegurado->borra($sura_id))
        {
            send_json_ok('Se eliminó de forma correcta el registro.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar.');
        }
    }
*/

	
   public function borra($sura_id)
    {
		$easegurado_por_borrar = $this->easegurado->get($sura_id);
		
		$sura_numeroserie=$easegurado_por_borrar['sura_numeroserie'];
				
		$this->asegurado->borra_lote_fotografico_by_folio($sura_numeroserie);

		$data_log['sura_id'] =  $easegurado_por_borrar['sura_id'];
		$data_log['sura_numeroserie'] =  $easegurado_por_borrar['sura_numeroserie'];
		$data_log['sura_correo'] = $easegurado_por_borrar['sura_correo'];
		$data_log['usr_id'] =  $easegurado_por_borrar['usr_id'];
		$data_log['emp_id'] =  $easegurado_por_borrar['emp_id'];						
		$this->easegurado->inserta_ins_log($data_log,'BORRADO DE REGISTRO');

        if ($this->easegurado->borra($sura_id))		
        {

			$this->asegurado->borra_lote_fotografico_by_folio_ori($sura_numeroserie);

            send_json_ok('Se eliminó de forma correcta todos los registros ligados al FOLIO: '.$sura_numeroserie);
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar.');
        }
    }	


	
	
/******************************************************/
	
    }
