<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Cotinina extends CI_Controller {
    function __construct() {
        parent::__construct();
        $this->load->model('persona/Persona_model','cliente');
		$this->load->model('servicio/Servicio_model','servicio');
        $this->load->model('empleado/Empleado_model','medico');
        $this->load->model('examen/Cotinina_model','cotinina');
		$this->load->helper('util');
		$this->load->helper('report');
    }
    
    public function nuevo($cliente_id)
    {
		
        $persona = $this->cliente->get($cliente_id);
        $user = $this->session->user;
		$metodo=0;

        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
			if (($persona['serv_id'] == 0) ||(get_status_serv($persona['serv_id']) != 'PROCESO'))
			{					
					$this->form_validation->set_rules('servicio','Orden de servicio','required');
			}
			else
			{
					$this->form_validation->set_rules('servicio','Orden de servicio','integer');
			}
            
			$this->form_validation->set_rules('fis_resultado','NICOTINA (COTININA) ORINA','required'); 
           
            if($this->form_validation->run())
            {
                $data_insert['usr_id']  = $user['usr_id']; 
				$data_insert['med_id']  = $this->input->post('laboratorista'); 
				
                $data_insert['clte_id'] = $persona['clte_id'];
                $data_insert['emp_id']  = $persona['emp_id'];

				if (($persona['serv_id'] == 0) || (get_status_serv($persona['serv_id']) != 'PROCESO'))
				{	
						$data_insert['serv_id']  = $this->input->post('servicio');
				}
				else
				{	
						$data_insert['serv_id']  = $persona['serv_id'];
				}

                $data_insert['cotinina_medico_sol'] = $this->input->post('medico_sol');
                $data_insert['cotinina_f_recibido']   =  formatea_fecha_mysql($this->input->post('f_recibido'));
                $data_insert['cotinina_f_impresion']  =  formatea_fecha_mysql($this->input->post('f_impresion'));
				$data_insert['cotinina_metodo'] = $this->input->post('metodo');
				$data_insert['cotinina_fis_resultado']= $this->input->post('fis_resultado');
				$data_insert['cotinina_lab'] = $this->input->post('laboratorista');
				
                $data_insert['log_insrt_f']= date('Y-m-d H:i:s'); 
				$metodo=$this->input->post('metodo');			
				
				$data_insert=array_to_upper($data_insert);	
				$data_insert['cotinina_obs']= $this->input->post('cotinina_obs');                 
				//$data_insert['cotinina_fuera_rango'] = $this->input->post('fuera_rango');
				
				if ($metodo > 0)
				{	
					if($this->cotinina->insert($data_insert))
					{
						send_json_ok('Se guardó de forma correcta');
						$servicios=$persona['domserv'];					
						
						$servicio='CONTIN;'; /*CODIGO DEL EXAMEN*/
						if (!(strstr($servicios,$servicio)))
						{							
							$servicios.=$servicio;
							$data_clte['domserv']=$servicios;
							$data_clte['clte_status_proc'] = 'EN PROCESO';
							$res=$this->cliente->actualiza_registro_individual($cliente_id, $data_clte);
						}
					}
					else
					{
						send_json_error('Ocurrió un error al guardar.'); 
					}
				}
				else
				{
					send_json_error('No has elegido el Método.');
				}
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
            $data['medico'] = $medico;
			$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);
            $this->load->helper('template');
            $params_view = array(
                'title' => 'COTININA',
                'view' => 'examen/cotinina/nuevo_form',
                'view_data' => $data 
               );
            render_template($params_view);
        }
    }
    
    public function pdf($cliente_id, $fsm_id)
    {
        $data['persona'] = $this->cliente->get($cliente_id,get_desp_id_usr());
        $data['fsm'] = $this->cotinina->get($fsm_id,get_desp_id_usr());
        $data['medico'] = $this->medico->get_id($data['fsm']['med_id']);
        $data['empresa'] = $this->cliente->get_empresa_by_id($data['fsm']['emp_id']);
        $this->load->helper('pdf');

		$med_name=$data['fsm']['cotinina_lab'];
		$emp_id=$data['fsm']['emp_id'];
		$observaciones=$data['fsm']['cotinina_obs'];
		$data_empresa = $this->cliente->get_empresa_by_id($emp_id);
		if ($data_empresa['emp_giro'] == 'SEGURIDAD')
		{
			genera_pdf_tohuanti($this->load->view('examen/cotinina/pdf',$data,TRUE),'cotinina','cotinina');
		}
		else
			
		{	
			//$med_name=agrega_cedula($med_name,'Cédula Profesional:');
			//genera_pdf_lab_new($this->load->view('examen/cotinina/pdf',$data,TRUE),'cotinina','cotinina',$med_name,$observaciones);		
			$med_name=agrega_cedula_ext($data['fsm']['med_id']);
			genera_pdf_lab_new_x($this->load->view('examen/cotinina/pdf',$data,TRUE),'cotinina','cotinina',$med_name,$observaciones,$fuera_rango);

		}
    }

    public function borra_cotinina($fsm_id)
    {
        if($this->cotinina->delete_cotinina($fsm_id))
        {
            send_json_ok('Se eliminó de forma correcta.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar.');
        }
    }


}