<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Prueba extends CI_Controller {
    function __construct() {
        parent::__construct();
        $this->load->model('persona/Persona_model','cliente');
        $this->load->model('empleado/Empleado_model','medico');
        $this->load->model('examen/Prueba_model','prueba');
    }
    
    public function nuevo($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
        $user = $this->session->user;
        $medico = $this->medico->get_id(26);
        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('servicio','Orden de servicio','required');
            $this->form_validation->set_rules('anf','Anfetaminas','required');
            $this->form_validation->set_rules('coc','Cocana','required');
            $this->form_validation->set_rules('mar','Marihuana','required');
            $this->form_validation->set_rules('opi','Opiaceos','required');
            $this->form_validation->set_rules('pcp','PCP','required');
            $this->form_validation->set_rules('bzd','benzodiacepina','required');
            $this->form_validation->set_rules('bar','barbituricos','required');
            $this->form_validation->set_rules('mdt','benzodiacepina','required');
            $this->form_validation->set_rules('met','barbituricos','required');

           
            if($this->form_validation->run())
            {
                $data_insert['emp_id']  = $persona['emp_id'];
                $data_insert['clte_id'] = $persona['clte_id'];
                $data_insert['usr_id']  = $user['usr_id'];
                $data_insert['med_id']  = $medico['usr_id'];
                $data_insert['serv_id']  = $this->input->post('servicio');
                $data_insert['fsm_f']   = date("Y-m-d H:i:s");
                $data_insert['fsm_anf_cve'] = $this->input->post('anf');
                $data_insert['fsm_coc_cve'] = $this->input->post('coc');
                $data_insert['fsm_mar_cve'] = $this->input->post('mar');
                $data_insert['fsm_opi_cve'] = $this->input->post('opi');
                $data_insert['fsm_pcp_cve'] = $this->input->post('pcp');
                $data_insert['fsm_bzd_cve'] = $this->input->post('bzd');             
                $data_insert['fsm_bar_cve'] = $this->input->post('bar');   
                $data_insert['fsm_mdt_cve'] = $this->input->post('mdt');             
                $data_insert['fsm_met_cve'] = $this->input->post('met');   

   
                if($this->Prueba->insert(array_to_upper($data_insert)))
                {
                    send_json_ok('Se guard de forma correcta');
                }
                else
                {
                    send_json_error('Ocurri un error al guardar.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
            $data['medico'] = $medico;
            $this->load->helper('template');
            $params_view = array(
                'title' => '',
                'view' => 'examen/toxicologico/nuevo_form9',
                'view_data' => $data 
               );
            render_template($params_view);
        }
    }
    
    public function pdf($cliente_id, $fsm_id)
    {
        $data['persona'] = $this->cliente->get($cliente_id);
        $data['fsm'] = $this->prueba->get($fsm_id);
        $data['medico'] = $this->medico->get_id($data['fsm']['med_id']);
        $data['empresa'] = $this->cliente->get_empresa_by_id($data['fsm']['emp_id']);
        $this->load->helper('pdf');
        genera_pdf($this->load->view('examen/toxicologico/pdf9',$data,TRUE),'prueba','prueba','prueba');
    }
}