  <?php
defined('BASEPATH') OR exit('No direct script access allowed');


    
class Gvidia extends CI_Controller {
    
     function __construct() {
        parent::__construct();
        $this->load->model('persona/Persona_model','cliente');
        $this->load->model('empleado/Empleado_model','medico');
		$this->load->model('empresa/Empresa_model','empresa');
    }
    
    public function index()
    {   $suc=get_sucursal_id();
	
		$gsi=$this->empresa->get_all_empresas_gsi_id();
        $rows = 30;
        $this->load->library('pagination');
        $config['base_url'] = base_url('gvidia/index/');
        //$config['total_rows'] = $this->cliente->count_all();
		$config['total_rows'] = $this->cliente->count_allo_gsi($suc);
        $config['per_page'] = $rows;
        $config['attributes'] = array('class' => 'pagination');
        $config['full_tag_open'] = '<div class="pagination-full">';
        $config['full_tag_close'] = '</div>';
        $config['uri_segment'] = 3;
        $config['query_string_segment'] = 4;
        $config['use_page_numbers'] = TRUE;
        $this->pagination->initialize($config);
									
		$data['clientes'] = $this->cliente->get_allo_gsi($rows,get_sucursal_id());
       
        $data['empresas'] = $this->empresa->get_all_empresas_gsi();
		
		
		//echo " Punto F ";
        
        $this->load->helper('template');
        $params_view = array(
            'title' => 'Personas',
            'view' => 'gvidia/index',
            'view_data' => $data 
           );
        render_template($params_view);  
    }
	
	public function busca()
    {        
        $empresa = $this->input->post('empresa');
		$cei = $this->input->post('cei');
        $nombre  = strtoupper($this->input->post('nombre'));
        $rfc     = strtoupper($this->input->post('rfc'));
		$regby = strtoupper($this->input->post('regby'));
		$f_ini = formatea_fecha_mysql($this->input->post('f_ini'));
        $f_fin = formatea_fecha_mysql($this->input->post('f_fin'));
        $data['clientes'] = $this->cliente->buscandote($empresa,$cei, $nombre, $rfc, $regby,$f_ini,$f_fin);
        send_json_ok($this->load->view('gvidia/busca',$data,TRUE));
    }
	
    public function reporte_gsi_control()
    {
        $this->load->model('vidia/Vidia_model','vidia');
        $this->load->model('servicio/Servicio_model','servicio');


        $data['servicios'] = $this->servicio->get_all('','PROCESO');

        $ini = date('Y-m-01');
        $fin = date('Y-m-d');

        $data['examenes'] = $this->vidia->get_examenes('',$ini, $fin);
		$i = 0;
        $emp_id = 0;
        foreach($data['examenes'] as $examen){
            if($emp_id != $examen['emp_id']){
                $costos = $this->vidia->get_costos($examen['emp_id']);
                if(!$costos)
                {
                    $costos = FALSE;
                }
                $data['examenes'][$i]['costos'] = $costos;
                $emp_id = $examen['emp_id'];
            }
            $i++;
        }
		$data['empresas'] = $this->empresa->get_all_empresas_gsi();
        $this->load->helper('template');
        $params_view = array(
            'title' => 'Inicio',
            'view' => 'gvidia/inicio_gsi_reporte',
            'view_data' => $data
            );
        render_template($params_view);
    }	

    function gsi_reporte()
    {
        $this->load->model('vidia/Vidia_model','vidia');
        //$this->load->model('empresa/Empresa_model','empresa');
		//$this->load->model('persona/Persona_model','cliente');
		$this->load->helper('util');
       
		$empresa = $this->input->post('empresa');
		$cei = $this->input->post('cei');
        $nombre  = strtoupper($this->input->post('nombre'));
        $rfc     = strtoupper($this->input->post('rfc'));
		$regby = strtoupper($this->input->post('regby'));
		$f_ini = formatea_fecha_mysql($this->input->post('f_ini'));
        $f_fin = formatea_fecha_mysql($this->input->post('f_fin'));
		$data['clientes'] = $this->cliente->buscando_evaluados_gsi($empresa,$cei, $nombre, $rfc, $regby,$f_ini,$f_fin);
		$emp_id=$empresa;
		
		date_default_timezone_set('America/Mexico_City');
		$date2today = date("Y-m-d H:i:s");
		?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">

<head>
<meta content="es-mx" http-equiv="Content-Language" />
<meta content="text/html; charset=utf-8" http-equiv="Content-Type" />
<?php
	header("Content-type: application/octet-stream; charset=latin1");
	header("Content-Disposition: attachment; filename=Rep_Control_Servicios.xls");
	header("Pragma: no-cache");
	header("Expires: 0");
?>

<title>#</title>
<style type="text/css">
.auto-style1 {
	font-family: Arial, Helvetica, sans-serif;
	color: #FFFFFF;
	background-color: #3D5588;
	font-size: small;
}
.auto-style4 {
	font-family: Arial, Helvetica, sans-serif;
	font-size: xx-small;
}
.auto-style5 {
	font-family: Arial, Helvetica, sans-serif;
	font-size: medium;
}
.auto-style6 {
	font-family: Arial, Helvetica, sans-serif;
	font-size: x-large;
	text-align: right;
	font-weight: normal;
}
.auto-style7 {
	font-size: small;
}
.auto-style8 {
	color: #3D5588;
}
.auto-style9 {
	color: #3AD4A7;
}
			.auto-style11 {
	font-family: Arial, Helvetica, sans-serif;
	font-size: small;
	text-align: right;
}
.auto-style12 {
	font-family: Arial, Helvetica, sans-serif;
	font-size: small;
	text-align: center;
}
.auto-style13 {
	font-size: xx-small;
}
.auto-style14 {
	font-family: Arial, Helvetica, sans-serif;
	color: #FFFFFF;
	background-color: #3D5588;
	font-size: xx-small;
}



.auto-style15 {
	font-family: Arial, Helvetica, sans-serif;
	font-size: x-small;
}
.auto-style16 {
	font-family: Arial, Helvetica, sans-serif;
	font-size: x-small;
	text-align: right;
}
.auto-style17 {
	font-family: Arial, Helvetica, sans-serif;
	font-size: x-small;
	text-align: left;
}
.auto-style18 {
	font-family: Arial, Helvetica, sans-serif;
	font-size: xx-small;
	text-align: center;
}
			.auto-style19 {
	color: #3D5588;
	font-size: medium;
}
.auto-style20 {
	font-family: Arial, Helvetica, sans-serif;
	font-size: xx-small;
	text-align: center;
	background-color: #BFEADD;
}
.auto-style21 {
	font-family: Arial, Helvetica, sans-serif;
	font-size: xx-small;
	background-color: #BFEADD;
}

			</style>
</head>
			<body>
			<?php 
			date_default_timezone_set('America/Mexico_City');
				?>
				<!-- clases 20 y 21 color hc #3AD4A7; -->
				<table> 
					<thead>
						<tr>
							<th style="width: 64px" class="auto-style5">&nbsp;</th>
							<th style="width: 78px" class="auto-style5">&nbsp;</th>
							<th style="width: 78px" class="auto-style5">&nbsp;</th>
							<th style="width: 393px" class="auto-style5">&nbsp;</th>
							<th style="width: 281px" class="auto-style5">&nbsp;</th>
							<th style="width: 625px" class="auto-style5">&nbsp;</th>
							<th style="width: 95px" class="auto-style5">&nbsp;</th>
								<th style="width: 303px" class="auto-style5">&nbsp;</th>
						</tr>
						<tr>
							<th style="width: 64px" class="auto-style5">&nbsp;</th>
							<th style="width: 78px" class="auto-style5">&nbsp;</th>
							<th style="width: 78px" class="auto-style5">&nbsp;</th>
							<th style="width: 393px" class="auto-style6">
							<strong><span class="auto-style8">human</span><span class="auto-style9">center</span></strong></th>
							<th style="width: 281px" class="auto-style11">&nbsp;</th>
							<th style="width: 625px" class="auto-style12">
							Reporte de Control de Servicios</th>
							<th style="width: 95px" class="auto-style5">&nbsp;</th>
								<th style="width: 303px" class="auto-style5">&nbsp;</th>
						</tr>
						<tr>
							<th style="width: 64px" class="auto-style5">&nbsp;</th>
							<th style="width: 78px" class="auto-style5">&nbsp;</th>
							<th style="width: 78px" class="auto-style5">&nbsp;</th>
							<th style="width: 393px" class="auto-style6">
							<span class="auto-style19">online</span><sup><span class="auto-style13" style="color: rgb(34, 34, 34); font-family: arial, sans-serif; font-style: normal; font-variant-ligatures: normal; font-variant-caps: normal; font-weight: 400; letter-spacing: normal; orphans: 2; text-align: left; text-indent: 0px; text-transform: none; white-space: normal; widows: 2; word-spacing: 0px; -webkit-text-stroke-width: 0px; background-color: rgb(255, 255, 255); text-decoration-style: initial; text-decoration-color: initial; display: inline !important; float: none;">®</span></sup></th>

						<?php if ($emp_id == "")
						{ ?>
							<th style="width: 281px" class="auto-style16">Varias</th>
							<th style="width: 625px" class="auto-style17">&nbsp; GSI Empresas</th>	
						<?php }
						else
						{ 
							$empresa=$this->empresa->get_empresa($emp_id);
							?>
							<th style="width: 281px" class="auto-style16">Empresa:</th>
							<th style="width: 625px" class="auto-style17">&nbsp;&nbsp;<?php echo $empresa['emp_razon_social']; ?></th>							
						<?php } ?>

							<th style="width: 95px" class="auto-style5">&nbsp;</th>
							<th style="width: 303px" class="auto-style5">&nbsp;</th>
						</tr>
						<tr>
							<th style="width: 64px" class="auto-style5">&nbsp;</th>
							<th style="width: 78px" class="auto-style5">&nbsp;</th>
							<th style="width: 78px" class="auto-style5">&nbsp;</th>
							<th style="width: 393px" class="auto-style5">&nbsp;</th>
							<th style="width: 281px" class="auto-style16">Del:</th>
							<th style="width: 625px" class="auto-style17">&nbsp;&nbsp;<?php echo $this->input->post('f_ini') ; ?></th>
							<th style="width: 95px" class="auto-style5">&nbsp;</th>
								<th style="width: 303px" class="auto-style5">&nbsp;</th>
						</tr>
						<tr>
							<th style="width: 64px" class="auto-style5">&nbsp;</th>
							<th style="width: 78px" class="auto-style5">&nbsp;</th>
							<th style="width: 78px" class="auto-style5">&nbsp;</th>
							<th style="width: 393px" class="auto-style5">&nbsp;</th>
							<th style="width: 281px" class="auto-style16">al:</th>
							<th style="width: 625px" class="auto-style17">&nbsp;&nbsp;<?php echo $this->input->post('f_fin') ; ?></th>
							<th style="width: 95px" class="auto-style5">&nbsp;</th>
								<th style="width: 303px" class="auto-style5">&nbsp;</th>
						</tr>
						<tr>
							<th style="width: 64px" class="auto-style5">&nbsp;</th>
							<th style="width: 78px" class="auto-style5">&nbsp;</th>
							<th style="width: 78px" class="auto-style5">&nbsp;</th>
							<th style="width: 393px" class="auto-style5">&nbsp;</th>
							<th style="width: 281px" class="auto-style16">Generado el día:</th>
							<th style="width: 625px" class="auto-style17">&nbsp;&nbsp;<?php echo date("d/m/y h:i:sa"); ?></th>
							<th style="width: 95px" class="auto-style5">&nbsp;</th>
								<th style="width: 303px" class="auto-style5">&nbsp;</th>
						</tr>
						<tr>
							<th style="width: 64px" class="auto-style5">&nbsp;</th>
							<th style="width: 78px" class="auto-style5">&nbsp;</th>
							<th style="width: 78px" class="auto-style5">&nbsp;</th>
							<th style="width: 393px" class="auto-style5">&nbsp;</th>
							<th style="width: 281px" class="auto-style15">&nbsp;</th>
							<th style="width: 625px" class="auto-style5">&nbsp;</th>
							<th style="width: 95px" class="auto-style5">&nbsp;</th>
								<th style="width: 303px" class="auto-style5">&nbsp;</th>
						</tr>
					<thead>
				</table> 
				<table>
                <thead>
                    <tr>
                        <th class="auto-style14">CEI</th>
						<th class="auto-style14" >Id</th>
						<th class="auto-style14">Registrado por</th>
                        <th class="auto-style14">Nombre</th>
						<th class="auto-style14">RFC</th>
                        <th class="auto-style14">Empresa</th>
                        <th class="auto-style14" style="width: 75px;">Fecha de Registro</th>
						<th class="auto-style14"style="width: 75px;">Fecha Inicio Orden de Servicio</th>
						<th class="auto-style14" style="width: 75px;">Fecha Final Orden de Servicio</th>
						<th class="auto-style14" style="width: 40px;">Orden de Servicio</th>
						<th class="auto-style14" style="width: 40px;">Pedido</th>
						<th class="auto-style14" style="width: 155px;">Servicios en Pedido</th>
						<th class="auto-style14">Servicios Realizados</th>
                        <th class="auto-style14">Archivos Electrónicos</th>
                    </tr>
                </thead>
                <tbody id="resultado">
                    <?php
					$CIs =& get_instance();
					$CIs->load->model('vidia/Vidia_model','examenes');
					$class18=" ";
                        if($data['clientes']):
                            foreach ($data['clientes'] as $cliente): 
									$ini = '2017-01-01'; $fin = '2022-12-31';
									$TOXI= $CIs->examenes->get_examenes_realizados_detail('TOXI', $cliente['clte_id'],$cliente['emp_id'], $ini, $fin);
									$TOXIS= $CIs->examenes->get_examenes_realizados_detail('TOXIS', $cliente['clte_id'],$cliente['emp_id'], $ini, $fin); 
									$PSIC= $CIs->examenes->get_examenes_realizados_detail('PSIC', $cliente['clte_id'],$cliente['emp_id'], $ini, $fin); 
									$ACRED= $CIs->examenes->get_examenes_realizados_detail('ACRED', $cliente['clte_id'],$cliente['emp_id'], $ini, $fin); 
									$MEDFIS= $CIs->examenes->get_examenes_realizados_detail('MEDFIS', $cliente['clte_id'],$cliente['emp_id'], $ini, $fin); 
									$SOCIE= $CIs->examenes->get_examenes_realizados_detail('SOCIE', $cliente['clte_id'],$cliente['emp_id'], $ini, $fin); 
									$ENTSOC= $CIs->examenes->get_examenes_realizados_detail('ENTSOC', $cliente['clte_id'],$cliente['emp_id'], $ini, $fin); 
									$CED= $CIs->examenes->get_examenes_realizados_detail('CED', $cliente['clte_id'],$cliente['emp_id'], $ini, $fin); 
									$POL= $CIs->examenes->get_examenes_realizados_detail('POL', $cliente['clte_id'],$cliente['emp_id'], $ini, $fin); 
									$HIST= $CIs->examenes->get_examenes_realizados_detail('HIST', $cliente['clte_id'],$cliente['emp_id'], $ini, $fin); 
									$TOXIN= $CIs->examenes->get_examenes_realizados_detail('TOXIN', $cliente['clte_id'],$cliente['emp_id'], $ini, $fin); 
									$ESTSOC= $CIs->examenes->get_examenes_realizados_detail('ESTSOC', $cliente['clte_id'],$cliente['emp_id'], $ini, $fin); 
									$QUISAN= $CIs->examenes->get_examenes_realizados_detail('QUISAN', $cliente['clte_id'],$cliente['emp_id'], $ini, $fin); 		
									$SOCIOL= $CIs->examenes->get_examenes_realizados_detail('SOCIOL', $cliente['clte_id'],$cliente['emp_id'], $ini, $fin); 		
									$ORINA= $CIs->examenes->get_examenes_realizados_detail('ORINA', $cliente['clte_id'],$cliente['emp_id'], $ini, $fin); 		
									$BIOHEM= $CIs->examenes->get_examenes_realizados_detail('BIOHEM', $cliente['clte_id'],$cliente['emp_id'], $ini, $fin); 		
									$GPOSAN= $CIs->examenes->get_examenes_realizados_detail('GPOSAN', $cliente['clte_id'],$cliente['emp_id'], $ini, $fin); 		
									$REPSIC= $CIs->examenes->get_examenes_realizados_detail('REPSIC', $cliente['clte_id'],$cliente['emp_id'], $ini, $fin); 		
									$EYED= $CIs->examenes->get_examenes_realizados_detail('EYED', $cliente['clte_id'],$cliente['emp_id'], $ini, $fin); 		
									$PIE= $CIs->examenes->get_examenes_realizados_detail('PIE', $cliente['clte_id'],$cliente['emp_id'], $ini, $fin); 		
									$ODO= $CIs->examenes->get_examenes_realizados_detail('ODO', $cliente['clte_id'],$cliente['emp_id'], $ini, $fin); 		
									$fpfh0105= $CIs->examenes->get_examenes_realizados_detail('fpfh0105', $cliente['clte_id'],$cliente['emp_id'], $ini, $fin); 	
									$docs= $CIs->examenes->get_docs($cliente['clte_id']); 	
									        
										$squery= "UPDATE sis05_clientes SET ";	
										    if ($ACRED) {$squery=$squery."acred= 'OK', ";} else {$squery=$squery."acred= '', ";} 
											if ($BIOHEM) {$squery=$squery."biohem= 'OK', ";} else {$squery=$squery."biohem= '', ";} 
											if ($CED) {$squery=$squery."ced_pol= 'OK', ";} else {$squery=$squery."ced_pol= '', ";} 
											if ($HIST){$squery=$squery."hist= 'OK', ";} else {$squery=$squery."hist= '', ";} 
											if ($ENTSOC) {$squery=$squery."entsoc= 'OK', ";} else {$squery=$squery."entsoc='', ";} 
											if ($ESTSOC) {$squery=$squery."estsoc= 'OK', ";} else {$squery=$squery."estsoc= '', ";} 
											if ($EYED) {$squery=$squery."eyed= 'OK', ";} else {$squery=$squery."eyed= '', ";} 
											if ($fpfh0105) {$squery=$squery."fpfh0105= 'OK', ";} else {$squery=$squery."fpfh0105= '', ";} 
											if ($GPOSAN) {$squery=$squery."sangre= 'OK', ";} else {$squery=$squery."sangre= '', ";} 
											if ($MEDFIS) {$squery=$squery."medfis= 'OK', ";} else {$squery=$squery."medfis= '', ";} 
											if ($ODO) {$squery=$squery."odo= 'OK', ";} else {$squery=$squery."odo= '', ";} 
											if ($ORINA) {$squery=$squery."orina= 'OK', ";} else {$squery=$squery."orina= '', ";} 
											if ($PIE) {$squery=$squery."pie= 'OK', ";} else {$squery=$squery."pie= '', ";} 
											if ($POL) {$squery=$squery."pol= 'OK', ";} else {$squery=$squery."pol= '', ";} 
											if ($PSIC) {$squery=$squery."psci= 'OK', ";} else {$squery=$squery."psci= '', ";} 
											if ($REPSIC) {$squery=$squery."repsic= 'OK', ";} else {$squery=$squery."repsic= '', ";} 
											if ($QUISAN) {$squery=$squery."quisan= 'OK', ";} else {$squery=$squery."quisan= '', ";} 
											if ($SOCIE) {$squery=$squery."socie= 'OK', ";} else {$squery=$squery."socie= '', ";} 
											if ($TOXI) {$squery=$squery."toxi= 'OK', ";} else {$squery=$squery."toxi= '', ";} 
											if ($TOXIS) {$squery=$squery."toxis= 'OK', ";} else {$squery=$squery."toxis= '', ";} 
											if ($TOXIN) {$squery=$squery."toxin= 'OK', ";} else {$squery=$squery."toxin= '', ";} 
											if ($SOCIOL) {$squery=$squery."sociol= 'OK' ";} else {$squery=$squery."sociol= '' ";} 
											
										    $squery=$squery." WHERE clte_id='".$cliente['clte_id']."';";
										    										if ($class18 != "auto-style18")
										{
											$class18="auto-style18";
											$class4="auto-style4";
										}	
										else
										{
											$class18="auto-style20";
											$class4="auto-style21";							
										}	
							?> 	
                                <tr class=<?php echo $class18; ?> >
                                    <td align="center"><?php echo get_cei($cliente['cei_id']); ?></td>
									<td align="center"><?php echo $cliente['clte_id']; ?></td>
									<td align="center"><?php echo $cliente['log_insrt_usr_cve']; ?></td>
                                    <td>
r                                       <?php echo $cliente['clte_paterno']; ?> 
                                        <?php echo $cliente['clte_materno']; ?>
										<?php echo $cliente['clte_nombre']; ?> 
                                        <?php echo $cliente['clte_2_nombre']; ?> 										
									</td>
									<td align="center">	
									<?php	if (strlen($cliente['clte_rfc']) < 1 )
											{ 
											  
												 echo " ¡Sin RFC! "; 
										
											}
											else
											{
												echo $cliente['clte_rfc'];
											}
										
										
											/* if (strlen($cliente['clte_path_foto']) < 1 )
											  { 
											   ?> <a style='display:inline-block; padding:2px; background:#FE322E; font-size:70%; color:white;'> <?php
												 echo " ¡Sin foto! "; 
												 ?> </a> <?php
											  }	  */

										?>
                                    </td>
                                    <td align="center"><?php 
									if ($cliente['suc_id'] != 0)
									{
										echo $cliente['emp_razon_social'].' - '.get_una_sucursal($cliente['suc_id']);
									}else
									{
										echo $cliente['emp_razon_social'];
									}
									?></td>
                                    <td align="center"><?php echo formatea_fechahora_yy($cliente['log_insrt_f']); ?></td>
									<td align="center"><?php 
											$examenes_detectados="";
											$servicios_det=0;											
											$servicios[0]=NULL;
											if ($ACRED) {$servicios[$servicios_det]=$ACRED['serv_id'];$servicios_det++;$examenes_detectados=$examenes_detectados. "ACREDITACIÓN<BR>";} //: ".implode($TOXI)."<br>" ;}
											if ($BIOHEM){$servicios[$servicios_det]=$BIOHEM['serv_id'];$servicios_det++;$examenes_detectados=$examenes_detectados. "BIOMETRÍA HEMÁTICA<BR>";} //: ".implode($TOXI)."<br>" ;}
											if ($CED) {$servicios[$servicios_det]=$CED['serv_id'];$servicios_det++;$examenes_detectados=$examenes_detectados. "CED. POLIGRAFICA<BR>";} //: ".implode($TOXI)."<br>" ;}
											if ($HIST){$servicios[$servicios_det]=$HIST['serv_id'];$servicios_det++;$examenes_detectados=$examenes_detectados. "HISTORIA CLINICA<BR>";} //: ".implode($TOXI)."<br>" ;}
											if ($ENTSOC) {$servicios[$servicios_det]=$ENTSOC['serv_id'];$servicios_det++;$examenes_detectados=$examenes_detectados. "ENTORNO SOCIOECONÓMICO<BR>";} //: ".implode($TOXI)."<br>" ;}
											if ($ESTSOC){$servicios[$servicios_det]=$ESTSOC['serv_id'];$servicios_det++;$examenes_detectados=$examenes_detectados. "ESTUDIO SOCIOECONÓMICO<BR>";} //: ".implode($TOXI)."<br>" ;}
											if ($EYED){$servicios[$servicios_det]=$EYED['serv_id'];$servicios_det++;$examenes_detectados=$examenes_detectados. "EYE DETECT<BR>";} //: ".implode($TOXI)."<br>" ;}	
											if ($fpfh0105){$servicios[$servicios_det]=$fpfh0105['serv_id'];$servicios_det++; $examenes_detectados=$examenes_detectados. "HISTORIA CLÍNICA 0105<BR>";} //: ".implode($TOXI)."<br>" ;}
											if ($GPOSAN){$servicios[$servicios_det]=$GPOSAN['serv_id'];$servicios_det++;$examenes_detectados=$examenes_detectados. "GRUPO SANGUINEO<BR>";} //: ".implode($TOXI)."<br>" ;}
											if ($MEDFIS){$servicios[$servicios_det]=$MEDFIS['serv_id'];$servicios_det++; $examenes_detectados=$examenes_detectados. "MÉDICO-FÍSICO<BR>";} //: ".implode($TOXI)."<br>" ;}
											if ($ODO){$servicios[$servicios_det]=$ODO['serv_id'];$servicios_det++;$examenes_detectados=$examenes_detectados. "EX. ODONTOLÓGICO<BR>";} //: ".implode($TOXI)."<br>" ;}	
											if ($ORINA){$servicios[$servicios_det]=$ORINA['serv_id'];$servicios_det++;$examenes_detectados=$examenes_detectados. "EGO<BR>";} //: ".implode($TOXI)."<br>" ;}
											if ($PIE){$servicios[$servicios_det]=$PIE['serv_id'];$servicios_det++;$examenes_detectados=$examenes_detectados. "PRUEBA DE EMBARAZO<BR>";} //: ".implode($TOXI)."<br>" ;}											
											if ($POL) {$servicios[$servicios_det]=$POL['serv_id'];$servicios_det++;$examenes_detectados=$examenes_detectados. "POLÍGRAFO<BR>";} //: ".implode($TOXI)."<br>" ;}
											if ($PSIC){$servicios[$servicios_det]=$PSIC['serv_id'];$servicios_det++;$examenes_detectados=$examenes_detectados. "CEL PSICOLÓGICA<BR>";} //: ".implode($TOXI)."<br>" ;}
											if ($REPSIC){$servicios[$servicios_det]=$REPSIC['serv_id'];$servicios_det++;$examenes_detectados=$examenes_detectados. "REP PSICOLÓGICO<BR>";} //: ".implode($TOXI)."<br>" ;}
											if ($QUISAN){$servicios[$servicios_det]=$QUISAN['serv_id'];$servicios_det++;$examenes_detectados=$examenes_detectados. "QUÍMICA SANGUÍNEA<BR>";} //: ".implode($TOXI)."<br>" ;}
											if ($SOCIE) {$servicios[$servicios_det]=$SOCIE['serv_id'];$servicios_det++;$examenes_detectados=$examenes_detectados. "SOCIOECONÓMICO<BR>";} //: ".implode($TOXI)."<br>" ;}
											if ($TOXI){$servicios[$servicios_det]=$TOXI['serv_id'];$servicios_det++;$examenes_detectados=$examenes_detectados."TOXICO 5<BR>";} //: ".implode($TOXI)."<br>" ;} 
											if ($TOXIS){$servicios[$servicios_det]=$TOXIS['serv_id'];$servicios_det++; $examenes_detectados=$examenes_detectados. "TOXICO 7<BR>";} //: ".implode($TOXI)."<br>" ;}
											if ($TOXIN){$servicios[$servicios_det]=$TOXIN['serv_id'];$servicios_det++;$examenes_detectados=$examenes_detectados. "TOXICO 9<BR>";} //: ".implode($TOXI)."<br>" ;}
											if ($SOCIOL){$servicios[$servicios_det]=$SOCIOL['serv_id'];$servicios_det++;$examenes_detectados=$examenes_detectados. "SOCIOLABORAL<BR>";} //: ".implode($TOXI)."<br>" ;}
											if ($PSSIM){$servicios[$servicios_det]=$PSSIM['serv_id'];$servicios_det++;$examenes_detectados=$examenes_detectados. "PSICOLOGICO SIMPLE<BR>";} //: ".implode($TOXI)."<br>" ;}
											if ($HONE)
											{	
												$servicios[$servicios_det]=$HONE['serv_id'];
												$servicios_det++;
												$examenes_detectados=$examenes_detectados."HONESTIDAD<BR>";
											}
											if ($COMPO)
											{	
												$servicios[$servicios_det]=$COMPO['serv_id'];
												$servicios_det++;
												$examenes_detectados=$examenes_detectados."COMPO<BR>";
											}											
											$SOCIOL= $CIs->examenes->get_examenes_realizados_detail('SOCIOL', $cliente['clte_id'],$cliente['emp_id'], $ini, $fin); 	
											$orden_de_servicio_examenes=NULL;
											if ($servicios_det > 0)
											{	//echo "servcios[0] :".$servicios[0]."|"; 
												$orden_de_servicio=$CIs->examenes->get_orden_de_servicio($servicios[0]);
												$orden_de_servicio_examenes=$CIs->examenes->get_orden_de_servicio_examenes($servicios[0]);
												
												//echo "ID SERV:".$servicios[0]."ORD SERV: ".$orden_de_servicio['serv_orden'];
												//echo "ID SERV: "
												
												$serv_f_inicio=$orden_de_servicio['serv_f_inicio'];
												$serv_f_fin=$orden_de_servicio['serv_f_fin'];
												echo formatea_fechahora_yy($serv_f_inicio);?></td>
												<td align="center"><?php echo formatea_fechahora_yy($serv_f_fin); ?></td> <?php
												?> 												
												<td align="center"><?php echo $servicios[0];?></td>
												<td align="center"><?php
												 echo $orden_de_servicio['serv_orden'];?></td>
												<td align="left"><?php
											}
											
											    $oexamenes=" ";
												$res="";
												if($orden_de_servicio_examenes) 
												{
												//echo "-->".$orden_de_servicio_examenes)."<--";	
												
													foreach($orden_de_servicio_examenes as $exa):  
														$res=$exa['exam_cve'];
														$res1='';
														if (strstr($res,'TOXIS')){$res1.="TOXICO 7 <BR>";}
														elseif (strstr($res , 'TOXIN')){$res1.="TOXICO 9 <BR>";}														
														elseif (strstr($res ,'TOXI')){$res1.="TOXICO 5 <BR>";}

														if (strstr($res , 'BIOHEM')){$res1.="BIOMETRÍA HEMÁTICA <BR>";}
														if (strstr($res , 'FSM0105')){$res1.="HISTORIA CLÍNICA 0105 <BR>";}
														if (strstr($res , 'MEDFIS')){$res1.="MÉDICO-FISICO <BR>";}
														
														if (strstr($res , 'GPOSAN')){$res1.="GRUPO SANGUÍNEO <BR>";}
														if (strstr($res , 'ODO')){$res1.="EX. ODONTOLÓGICO <BR>";}
														if (strstr($res , 'ORINA')){$res1.="EGO <BR>";}
														if (strstr($res , 'PIE')){$res1.="PRUEBA EMBARAZO <BR>";}
														if (strstr($res , 'QUISAN')){$res1.="QUÍMICA SANGUÍNEA <BR>";}	
														$oexamenes=$oexamenes.$res1;
								
													endforeach;	
												?>
												<?php												
												echo "".$oexamenes;											
												}
												else
												{
												?>
												<?php
												echo "¡SIN INFORMACIÓN!";?></td>
												<td><?php echo "¡SIN INFORMACIÓN!";?></td>
												<td><?php echo "¡SIN INFORMACIÓN!";?></td>
												<td><?php echo "¡SIN INFORMACIÓN!";?></td>
												<td><?php echo "¡SIN INFORMACIÓN!";
												}	
															
									?>		
									</td>
									<td align="left">								
							
										<?php 
										
										 if (strlen($examenes_detectados) > 0)
										 {	 
											
											echo $examenes_detectados;
										 }
										 else
										 {
											
											echo "¡SIN INFORMACIÓN!";											 
										 }
										?>
										
									</td>
									<td  align="left">
										<?php 
											if($docs) {
												foreach($docs as $doc): ?>
													
														<?php echo $doc['doc_nombre'].'<br>'; ?>
												
												<?php 
												endforeach;
											}else{
												?>
													 
														<?php echo "¡Sin documentación!" ?>

												<?php 
											}	
										?>

	
                                </tr>
								
						
                            <?php 
                            endforeach;
                        endif;

                    ?>
            </table>				
				</body>
				</html><?php 	
	/*    $html = $this->load->view('vidia/lista_costos.php',$data,TRUE);
        send_json_ok($html);*/
    }




	
}