﻿<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Medica extends CI_Controller {
    
    function __construct() {
        parent::__construct();
        $this->load->model('medica/Medica_model','cliente');
		$this->load->model('servicio/Servicio_model','servicio');
		$this->load->model('empleado/Empleado_model','medico');
		$this->load->helper('util');
    }
 

    public function rep_eva()
    {
        $this->load->helper('template');
        $params_view = array(
            'title' => 'Inicio',
            'view' => 'medica/inicio_view_rep_evaluados',
            'view_data' => $data
            );
        render_template($params_view);
    } 

    public function rep_emp()
    {
        $this->load->helper('template');
        $params_view = array(
            'title' => 'Inicio',
            'view' => 'medica/inicio_view_rep_empleados',
            'view_data' => $data
            );
        render_template($params_view);
    } 


    public function rep_lab()
    {
        $this->load->helper('template');
        $params_view = array(
            'title' => 'Inicio',
            'view' => 'medica/inicio_view_rep_eva_lab',
            'view_data' => $data
            );
        render_template($params_view);
    }


    public function solrep()
    {
        $this->load->helper('template');
        $params_view = array(
            'title' => 'Inicio',
            'view' => 'medica/inicio_rep_veh',
            'view_data' => $data
            );
        render_template($params_view);
    } 


    function rep_vehicular()
    {
		$user = $this->session->user;
        $this->load->model('empresa/Empresa_model','empresa');
		$this->load->model('persona/Persona_model','cliente');
		$this->load->helper('util');
       
		//$f_ini = formatea_fecha_mysql($this->input->post('f_ini'));
        //$f_fin = formatea_fecha_mysql($this->input->post('f_fin')); 

		$f_ini = $this->input->post('f_ini');
        $f_fin = $this->input->post('f_fin'); 

	/*	if ( ($user['usr_id']==532) || ($user['usr_id']==531) || ($user['usr_id']==468) || ($user['usr_id']==22) )
		{
			$emp_id=229;	
		}
		else
		{*/
			$emp_id=$user['emp_id'];
			
/*		}*/

/*++++++++++++++++++*/
		
		//date_default_timezone_set('America/Mexico_City');
		$date2today = date("Y-m-d H:i:s");
		?>
		<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
		<html xmlns="http://www.w3.org/1999/xhtml">

		<head>
			<meta content="es-mx" http-equiv="Content-Language" />
			<meta content="text/html; charset=utf-8" http-equiv="Content-Type" />
			<?php
				header("Content-type: application/octet-stream; charset=latin1");
				header("Content-Disposition: attachment; filename=Rep_sup_med.xls");
				header("Pragma: no-cache");
				header("Expires: 0");
			?>

			<title>#</title>
			<style type="text/css">
				.auto-style1 {
					font-family: Arial, Helvetica, sans-serif;
					color: #FFFFFF;
					background-color: #3D5588;
					font-size: small;
				}
				.auto-style4 {
					font-family: Arial, Helvetica, sans-serif;
					font-size: xx-small;
				}
				.auto-style5 {
					font-family: Arial, Helvetica, sans-serif;
					font-size: medium;
				}
				.auto-style6 {
					font-family: Arial, Helvetica, sans-serif;
					font-size: x-large;
					text-align: right;
					font-weight: normal;
				}
				.auto-style7 {
					font-size: small;
				}
				.auto-style8 {
					color: #3D5588;
				}
				.auto-style9 {
					color: #3AD4A7;
				}
							.auto-style11 {
					font-family: Arial, Helvetica, sans-serif;
					font-size: small;
					text-align: right;
				}
				.auto-style12 {
					font-family: Arial, Helvetica, sans-serif;
					font-size: small;
					text-align: center;
				}
				.auto-style13 {
					font-size: xx-small;
				}
				.auto-style14 {
					font-family: Arial, Helvetica, sans-serif;
					color: #FFFFFF;
					background-color: #3D5588;
					font-size: xx-small;
				}
				.auto-style15 {
					font-family: Arial, Helvetica, sans-serif;
					font-size: x-small;
				}
				.auto-style16 {
					font-family: Arial, Helvetica, sans-serif;
					font-size: x-small;
					text-align: right;
				}
				.auto-style17 {
					font-family: Arial, Helvetica, sans-serif;
					font-size: x-small;
					text-align: left;
				}
				.auto-style18 {
					font-family: Arial, Helvetica, sans-serif;
					font-size: xx-small;
					text-align: center;
				}
				.auto-style19 {
					color: #3D5588;
					font-size: medium;
				}
				.auto-style20 {
					font-family: Arial, Helvetica, sans-serif;
					font-size: xx-small;
					text-align: center;
					background-color: #BFEADD;
				}
				.auto-style21 {
					font-family: Arial, Helvetica, sans-serif;
					font-size: xx-small;
					background-color: #BFEADD;
				}

			</style>
		</head>
		
		<body>
		<?php 
			//date_default_timezone_set('America/Mexico_City');
		?>
				<table> 
					<thead>
						<tr>
							<th style="width: 64px" class="auto-style5">&nbsp;</th>
							<th style="width: 78px" class="auto-style5">&nbsp;</th>
							<th style="width: 78px" class="auto-style5">&nbsp;</th>
							<th style="width: 393px" class="auto-style5">&nbsp;</th>
							<th style="width: 281px" class="auto-style5">&nbsp;</th>
							<th style="width: 625px" class="auto-style5">&nbsp;</th>
							<th style="width: 95px" class="auto-style5">&nbsp;</th>
								<th style="width: 303px" class="auto-style5">&nbsp;</th>
						</tr>
						<tr>
							<th style="width: 64px" class="auto-style5">&nbsp;</th>
							<th style="width: 78px" class="auto-style5">&nbsp;</th>
							<th style="width: 78px" class="auto-style5">&nbsp;</th>
							<th style="width: 393px" class="auto-style6">
							<strong><span class="auto-style8">human</span><span class="auto-style9">center</span></strong></th>
							<th style="width: 281px" class="auto-style11">&nbsp;</th>
							<th style="width: 625px" class="auto-style12">
							Reporte de Supervisión Médica</th>
							<th style="width: 95px" class="auto-style5">&nbsp;</th>
								<th style="width: 303px" class="auto-style5">&nbsp;</th>
						</tr>
						<tr>
							<th style="width: 64px" class="auto-style5">&nbsp;</th>
							<th style="width: 78px" class="auto-style5">&nbsp;</th>
							<th style="width: 78px" class="auto-style5">&nbsp;</th>
							<th style="width: 393px" class="auto-style6">
							<span class="auto-style19">online</span><sup><span class="auto-style13" style="color: rgb(34, 34, 34); font-family: arial, sans-serif; font-style: normal; font-variant-ligatures: normal; font-variant-caps: normal; font-weight: 400; letter-spacing: normal; orphans: 2; text-align: left; text-indent: 0px; text-transform: none; white-space: normal; widows: 2; word-spacing: 0px; -webkit-text-stroke-width: 0px; background-color: rgb(255, 255, 255); text-decoration-style: initial; text-decoration-color: initial; display: inline !important; float: none;">®</span></sup></th>

						<?php if ($emp_id == "")
						{ ?>
							<th style="width: 281px" class="auto-style16">Varias</th>
							<th style="width: 625px" class="auto-style17">&nbsp;Empresas</th>	
						<?php }
						else
						{ 
							$empresa=$this->empresa->get_empresa($emp_id);
							?>
							<th style="width: 281px" class="auto-style16">Empresa:</th>
							<th style="width: 625px" class="auto-style17">&nbsp;&nbsp;<?php echo $empresa['emp_razon_social']; ?></th>							
						<?php } ?>

							<th style="width: 95px" class="auto-style5">&nbsp;</th>
							<th style="width: 303px" class="auto-style5">&nbsp;</th>
						</tr>
						<tr>
							<th style="width: 64px" class="auto-style5">&nbsp;</th>
							<th style="width: 78px" class="auto-style5">&nbsp;</th>
							<th style="width: 78px" class="auto-style5">&nbsp;</th>
							<th style="width: 393px" class="auto-style5">&nbsp;</th>
							<th style="width: 281px" class="auto-style16">Del:</th>
							<th style="width: 625px" class="auto-style17">&nbsp;&nbsp;<?php echo formatea_fecha($this->input->post('f_ini')) ; ?></th>
							<th style="width: 95px" class="auto-style5">&nbsp;</th>
								<th style="width: 303px" class="auto-style5">&nbsp;</th>
						</tr>
						<tr>
							<th style="width: 64px" class="auto-style5">&nbsp;</th>
							<th style="width: 78px" class="auto-style5">&nbsp;</th>
							<th style="width: 78px" class="auto-style5">&nbsp;</th>
							<th style="width: 393px" class="auto-style5">&nbsp;</th>
							<th style="width: 281px" class="auto-style16">al:</th>
							<th style="width: 625px" class="auto-style17">&nbsp;&nbsp;<?php echo formatea_fecha($this->input->post('f_fin')) ; ?></th>
							<th style="width: 95px" class="auto-style5">&nbsp;</th>
								<th style="width: 303px" class="auto-style5">&nbsp;</th>
						</tr>
						<tr>
							<th style="width: 64px" class="auto-style5">&nbsp;</th>
							<th style="width: 78px" class="auto-style5">&nbsp;</th>
							<th style="width: 78px" class="auto-style5">&nbsp;</th>
							<th style="width: 393px" class="auto-style5">&nbsp;</th>
							<th style="width: 281px" class="auto-style16">Generado el día:</th>
							<th style="width: 625px" class="auto-style17">&nbsp;&nbsp;<?php echo date("d/m/y h:i:sa"); ?></th>
							<th style="width: 95px" class="auto-style5">&nbsp;</th>
								<th style="width: 303px" class="auto-style5">&nbsp;</th>
						</tr>
						<tr>
							<th style="width: 64px" class="auto-style5">&nbsp;</th>
							<th style="width: 78px" class="auto-style5">&nbsp;</th>
							<th style="width: 78px" class="auto-style5">&nbsp;</th>
							<th style="width: 393px" class="auto-style5">&nbsp;</th>
							<th style="width: 281px" class="auto-style15">&nbsp;</th>
							<th style="width: 625px" class="auto-style5">&nbsp;</th>
							<th style="width: 95px" class="auto-style5">&nbsp;</th>
							<th style="width: 303px" class="auto-style5">&nbsp;</th>
						</tr>
					<thead>
				</table> 
				
				<table>
					<thead>
                    <tr>
						<th class="auto-style14" >#</th>
						<th class="auto-style14" >Id</th>
                        <th class="auto-style14" >Institucion </th>
						<th class="auto-style14" >Fecha </th>
						<th class="auto-style14" >Notificación</th>
						<th class="auto-style14" >Encargado</th>
						<th class="auto-style14" >Médico</th>
						<th class="auto-style14" >Gerente</th>
						<th class="auto-style14" >Responsable Médico </th>						
						<th class="auto-style14" >Ins. Limpieza </th>
						<th class="auto-style14" >Ins. control_medica </th>
						<th class="auto-style14" >Ins. fisico </th>
						<th class="auto-style14" >Ins. electronicos </th>
						<th class="auto-style14" >Ins. profesional </th>
						<th class="auto-style14" >Ins. imagen </th>					
                    </tr>
                </thead>
				
                <tbody id="resultado">
                    <?php
						if ( ($user['usr_id']==532) || ($user['usr_id']==531) || ($user['usr_id']==468) || ($user['usr_id']==22) )
						{
							$data['clientes'] = $this->cliente->get_all_emp($emp_id);
						}
						else
						{
							$data['clientes'] = $this->cliente->get_all_by_emp($emp_id);
						}
						
						$class18=" ";
						$i=1;
                        if($data['clientes']):
                            foreach ($data['clientes'] as $cliente): 
								if ($class18 != "auto-style18")
								{
									$class18="auto-style18";
									$class4="auto-style4";
								}	
								else
								{
									$class18="auto-style20";
									$class4="auto-style21";							
								}										

							?> 	
                                <tr>
									<td class=<?php echo $class18; ?>><?php echo $i; $i++;?></td>
									<td class=<?php echo $class18; ?>><?php echo $cliente['clte_id']; ?></td>
									<td class=<?php echo $class18; ?>><?php echo $cliente['clte_institucion']; ?></td>
									<td class=<?php echo $class18; ?>><?php echo formatea_fechahora($cliente['clte_fecha_institucion']); ?></td>
									
									<td class=<?php echo $class18; ?>><?php echo $cliente['clte_notificacion']; ?></td>
									<td class=<?php echo $class18; ?>><?php echo $cliente['clte_encargado']; ?></td>
                                    <td class=<?php echo $class18; ?>><?php echo $cliente['clte_medico']; ?></td>
									<td class=<?php echo $class18; ?>><?php echo $cliente['clte_gerente']; ?></td>
									<td class=<?php echo $class18; ?>><?php echo $cliente['clte_resp_medico']; ?></td>

									<td class=<?php echo $class18; ?>><?php echo $cliente['clte_limpieza_ques'].' APROBADO'; ?></td>
									<!-- <td class=<?php echo $class18; ?>><?php echo $cliente['clte_limpieza_obs']; ?></td> -->
									<td class=<?php echo $class18; ?>><?php echo $cliente['clte_control_medica_ques'].' APROBADO'; ?></td>
									<!-- <td class=<?php echo $class18; ?>><?php echo $cliente['clte_control_medica_obs']; ?></td> -->
									<td class=<?php echo $class18; ?>><?php echo $cliente['clte_fisico_ques'].' APROBADO'; ?></td>
									<!-- <td class=<?php echo $class18; ?>><?php echo $cliente['clte_fisico_obs']; ?></td> -->
									<td class=<?php echo $class18; ?>><?php echo $cliente['clte_electronicos_ques'].' APROBADO'; ?></td>
									<!-- <td class=<?php echo $class18; ?>><?php echo $cliente['clte_electronico_obs']; ?></td> -->
									<td class=<?php echo $class18; ?>><?php echo $cliente['clte_profesional_ques'].' APROBADO'; ?></td>
									<!-- <td class=<?php echo $class18; ?>><?php echo $cliente['clte_profesional_obs']; ?></td> -->
									<td class=<?php echo $class18; ?>><?php echo $cliente['clte_imagen_ques'].' APROBADO'; ?></td>
									<!-- <td class=<?php echo $class18; ?>><?php echo $cliente['clte_imagen_obs']; ?></td> -->
									<!--<td class=<?php echo $class18; ?>><?php echo $cliente['clte_gerente_dis_ques'].' APROBADO'; ?></td>-->
									<!-- <td class=<?php echo $class18; ?>><?php echo $cliente['clte_gerente_dis_obs']; ?></td> -->
									<!--<td class=<?php echo $class18; ?>><?php echo $cliente['clte_medico_observa_ques'].' APROBADO'; ?></td>-->
									<!-- <td class=<?php echo $class18; ?>><?php echo $cliente['clte_medico_observa_obs']; ?></td> -->
									<!-- <td class=<?php echo $class18; ?>><?php echo $cliente['clte_entrevista_gerente']; ?></td> -->
								</tr>
				            <?php              
                            endforeach;
							
							?>
                    <tr>
                        <td class="auto-style14"></td>
						<td class="auto-style14"></td>
                        <td class="auto-style14"></td>
						<td class="auto-style14"></td>
                        <td class="auto-style14"></td>
                        <td class="auto-style14"></td>
						<td class="auto-style14"></td>
						<td class="auto-style14"></td> 	
						<td class="auto-style14"></td>
						<td class="auto-style14"></td>
						<td class="auto-style14"></td>
						<td class="auto-style14"></td>
						<td class="auto-style14"></td>
						<td class="auto-style14"></td>
						<td class="auto-style14"></td>
                    </tr>							
					<?php			
                        endif;

                    ?>
                </tbody>
				</table>
				</html><?php 	
	 }



    function busca()
    {   
		//VEHICULOS
		$user = $this->session->user; 
        $emp_id = $user['emp_id'];
		
		$id = $this->input->post('id');
		$institucion= strtoupper($this->input->post('institucion_b'));
		$encargado= strtoupper($this->input->post('encargado_b'));
		$notificacion= strtoupper($this->input->post('notificacion_b'));


        $data['clientes'] = $this->cliente->busca($emp_id,$id,$institucion,$encargado,$notificacion);
        send_json_ok($this->load->view('medica/busca',$data,TRUE));
    }
 
    public function lista()
    {   //VEHICULOS
	    //echo " Punto A ";
		$suc=get_sucursal_id();
		//echo " Punto AA ";
		$user_despacho=get_desp_id_usr();
		//echo " Punto AAA ";
		$user_cei=get_cei_id();
		//echo " Punto AAAA ";
		$user_root1=get_my_user_root1();
		$user_root3=get_my_user_root3();
		$user_root4=get_my_user_root4();
		$user = $this->session->user; 
		$medico = $this->medico->get($user['usr_id']);
		
		
		
		//echo " root1 ".get_my_user_root1();
		
        $rows = 30;
        $this->load->library('pagination');
        $config['base_url'] = base_url('medica/lista/');
        //$config['total_rows'] = $this->cliente->count_all();
		

		$config['total_rows'] = $this->cliente->count_allo($suc,$user_despacho,$user_cei,$user_root1);
		
		
		$config['per_page'] = $rows;
        $config['attributes'] = array('class' => 'pagination');
        $config['full_tag_open'] = '<div class="pagination-full">';
        $config['full_tag_close'] = '</div>';
        $config['uri_segment'] = 3;
        $config['query_string_segment'] = 4;
        $config['use_page_numbers'] = TRUE;
        $this->pagination->initialize($config);
        
		$this->load->model('empresa/Empresa_model','empresa');
		$data['clientes'] = $this->cliente->get_allo($rows,get_sucursal_id(),$user_despacho,$user_cei,$user_root1);
		$data['empresas'] = $this->empresa->get_all_empresas_gsi_id();

        
        $this->load->helper('template');
        $params_view = array(
            'title' => 'Personas',
            'view' => 'medica/index',
            'view_data' => $data 
           );
        render_template($params_view);  
    }
 


 
    public function id($id)
    {   //VEHICULO
		$n=get_desp_id_usr();
		$user_cei=get_cei_id();
		$user_root1=get_my_user_root1();		
		//echo '---A---';
		
        $data['cliente'] = $this->cliente->get($id,$n);
		//echo '---B---';
		
		if($data['cliente'])
        {
			//echo '---C---';
           /* $this->load->model('examen/Entorno_social_model','entorno_social');
            $this->load->model('examen/Socioeconomico_model','socio_economico');
            $this->load->model('examen/Poligrafico_model','poligrafico');
            $this->load->model('examen/Medico_fisico_model','medico_fisico');

            $this->load->model('examen/Psicologico_model','psicologico');
            $this->load->model('examen/Recetario_model','recetario');
		    $this->load->model('examen/Toxicologico_model','toxicologico');
            $this->load->model('examen/Toxicologico_model7','toxicologico7');
			$this->load->model('examen/Toxicologico_model3','toxicologico3');
            $this->load->model('examen/prueba_model','prueba');
            $this->load->model('examen/Acreditacion_model','acreditacion');
            $this->load->model('examen/Historia_clinica_model','historia_clinica');
			
            $this->load->model('examen/Quimica_sanguinea_model','quimicasan');
			
			$this->load->model('examen/Quimica_sanguinea3_model','quimicasan3');
            $this->load->model('examen/Quimica_sanguinea6_model','quimicasan6');
            $this->load->model('examen/Quimica_sanguinea12_model','quimicasan12');
            $this->load->model('examen/Quimica_sanguinea15_model','quimicasan15');
            $this->load->model('examen/Quimica_sanguinea24_model','quimicasan24');
			$this->load->model('examen/Quimica_sanguinea27_model','quimicasan27');
            $this->load->model('examen/Quimica_sanguinea38_model','quimicasan38');
			
			$this->load->model('examen/Biometria_hematica_model','biometria');
            $this->load->model('examen/Grupo_sanguineo_model','grupo_sanguineo');
            $this->load->model('examen/Orina_model','orina');
            $this->load->model('examen/Essoec_model','gsi');
            $this->load->model('examen/Sociolaboral_model','sociolaboral');
            $this->load->model('examen/Eye_detect_model','eye_detect');
			$this->load->model('examen/Pie_model','pie_detect');
			
			$this->load->model('examen/Alcohol_model','alcohol_detect');
			$this->load->model('examen/Covid_model','covid_detect');
			
			$this->load->model('examen/Historia_clinica_model','fpfh_detect');
			$this->load->model('examen/Historia_clinica_model','fsm_odon_detect');
			$this->load->model('examen/Pie_model','pyb');
			$this->load->model('examen/SS/Ssestsoc_model','segurisec');
			$this->load->model('examen/Nom035_model','nom035');
			$this->load->model('examen/Nom035ii_model','nom035ii');
			$this->load->model('examen/Nom035iii_model','nom035iii');
			
			$this->load->model('examen/Prestamo_model','prestamo');*/

            $user = $this->session->user;

            $data['medico']=$user;
           
/*		   $data['socio_economicos'] = $this->socio_economico->get_by_clte($id,$n);
            
			$data['entorno_social'] = $this->entorno_social->get_by_clte($id,$n);
            
			$data['fsms_02'] = $this->poligrafico->get_by_clte($id,'POLI',$n);
            $data['fsmsc_02'] = $this->poligrafico->get_by_clte($id,'CEDULA',$n);
						
            $data['fsms_04'] = $this->medico_fisico->get_by_clte($id,$n);
			
            $data['fsms_05'] = $this->psicologico->get_by_clte($id,$n);			
			$data['fsms_psicor'] = $this->psicologico->get_by_clte_r($id,$n); 
		
            $data['fsms_05_simple'] = $this->psicologico->get_by_clte_simple($id,$n);			
			$data['fsms_psicor_simple'] = $this->psicologico->get_by_clte_r_simple($id,$n); 
		
            $data['fsms_06'] = $this->toxicologico->get_by_clte($id,$n);
			$data['fsms_t3'] = $this->toxicologico3->get_by_clte($id,$n);
            $data['fsms_07'] = $this->toxicologico7->get_by_clte($id,$n);
			
            $data['fsms_09'] = $this->prueba->get_by_clte($id,$n);
			
            $data['fsms_03'] = $this->acreditacion->get_by_clte($id,$n);
			
            $data['fsms_lala'] = $this->historia_clinica->get_by_clte($id,'',$n);
			$data['fsm_odon'] = $this->historia_clinica->get_by_clte($id,'fsm_odon',$n);
			$data['fpfh'] = $this->historia_clinica->get_by_clte($id,'fpfh',$n);
			
            $data['fsm_qs'] = $this->quimicasan->get_by_clte($id,$n);
			
            $data['fsm_qs3'] = $this->quimicasan3->get_by_clte($id,$n);
            $data['fsm_qs6'] = $this->quimicasan6->get_by_clte($id,$n);
            $data['fsm_qs12'] = $this->quimicasan12->get_by_clte($id,$n);
            $data['fsm_qs15'] = $this->quimicasan15->get_by_clte($id,$n);
            $data['fsm_qs24'] = $this->quimicasan24->get_by_clte($id,$n);
			$data['fsm_qs27'] = $this->quimicasan27->get_by_clte($id,$n);
            $data['fsm_qs38'] = $this->quimicasan38->get_by_clte($id,$n);
			
            $data['fsm_bh'] = $this->biometria->get_by_clte($id,$n);
			
            $data['fsm_gs'] = $this->grupo_sanguineo->get_by_clte($id,$n);
			
            $data['fsm_or'] = $this->orina->get_by_clte($id,$n);

            $data['sociolaboral'] = $this->sociolaboral->get_by_clte($id,$n);
			
     		$data['essoecs'] = $this->gsi->get_by_clte($id,$n);	
            
			$data['fsm_pie'] = $this->pie_detect->get_by_clte($id,$n);
            
			$data['fsm_alcohol'] = $this->alcohol_detect->get_by_clte($id,$n);
			$data['fsm_covid'] = $this->covid_detect->get_by_clte($id,$n);
			
			$data['eyes'] = $this->eye_detect->get_by_clte($id,$n);
   		
			$data['fsm_pyb'] = $this->pyb->get_by_clte_pyb($id,'fsm_pyb',$n);
			
			$data['fsm_ssestsoc'] = $this->segurisec->get_by_clte($id,$n);
			
			$data['fsms_nom035'] = $this->nom035->get_by_clte($id,$n);
			$data['fsms_nom035ii'] = $this->nom035ii->get_by_clte($id,$n);
			$data['fsms_nom035iii'] = $this->nom035iii->get_by_clte($id,$n);
			$data['fsms_prestamo'] = $this->prestamo->get_by_clte($id,$n);
			

			$data['hon_docs'] = $this->cliente->get_hon_docs($id);
			$data['compo_docs'] = $this->cliente->get_compo_docs($id);
			$data['PENSA_docs'] = $this->cliente->get_PENSA_docs($id);
			$data['INTE_docs'] = $this->cliente->get_INTE_docs($id);			
			$data['PUESIC_docs'] = $this->cliente->get_PUESIC_docs($id);
			$data['sgmty_docs'] = $this->cliente->get_sgmty_docs($id);
			$data['covid_docs'] = $this->cliente->get_covid_docs($id);
			$data['AUDIO_docs'] = $this->cliente->get_AUDIO_docs($id);
			$data['VISTA_docs'] = $this->cliente->get_VISTA_docs($id);
			$data['ELECTRO_docs'] = $this->cliente->get_ELECTRO_docs($id);

			$data['PAPAN_docs'] = $this->cliente->get_PAPAN_docs($id);
			$data['RADIOT_docs'] = $this->cliente->get_RADIOT_docs($id);
			$data['RADIOL_docs'] = $this->cliente->get_RADIOL_docs($id);
			$data['fsms_recetario'] = $this->recetario->get_by_clte_r($id,$n);
*/
			//echo '---d---';
			$data['docs'] = $this->cliente->get_docs($id);
			$data['coms'] = $this->cliente->get_coms($id);
			//echo '---e---';
			
			
			
			
            $this->load->helper('template');
				
            $params_view = array(
                'title' => 'Persona',
                'view' => 'medica/cliente',
                'view_data' => $data 
               );

            render_template($params_view);  
        }
        else
        {
            show_error('El cliente no existe.');
        }
    }
    
    public function edita($cliente_id)
    {   //VEHICULO
        $user = $this->session->user;
		$cliente = $this->cliente->get($cliente_id);
		$medico = $this->medico->get($user['usr_id']);

        if($cliente)
        {

            if(isset($_POST) && count($_POST) > 0)     
            {
                $this->load->library('form_validation');
                //$this->form_validation->set_rules('observaciones_salida','Observaciones al Salir','required');

                //if($this->form_validation->run())
				if(true)	
                {
                   /* $data_clte['clte_observaciones_sal'] =  trim($this->input->post('observaciones_salida'));
					$data_clte['clte_f_salida'] = date('Y-m-d H:i:s');
					$data_clte['clte_usr_id_sal'] =  $user['usr_id'];*/

					/*$data_clte['clte_institucion'] =  trim($this->input->post('institucion'));*/
					$data_clte['clte_notificacion'] =  trim($this->input->post('notificacion'));
					$data_clte['clte_fecha_institucion'] =  trim($this->input->post('fecha_institucion'));
					$data_clte['clte_fecha_notitificacion'] =  trim($this->input->post('fecha_notitificacion'));
					$data_clte['clte_encargado'] =  trim($this->input->post('encargado'));
					$data_clte['clte_medico'] =  trim($this->input->post('medico'));
					$data_clte['clte_gerente'] =  trim($this->input->post('gerente'));
					$data_clte['clte_resp_medico'] =  trim($this->input->post('resp_medico'));
					$data_clte['clte_domicilio'] =  trim($this->input->post('domicilio'));
					$data_clte['clte_limpieza_ques'] =  trim($this->input->post('limpieza_ques'));
					$data_clte['clte_limpieza_obs'] =  trim($this->input->post('limpieza_obs'));
					$data_clte['clte_control_medica_ques'] =  trim($this->input->post('control_medica_ques'));
					$data_clte['clte_control_medica_obs'] =  trim($this->input->post('control_medica_obs'));
					$data_clte['clte_fisico_ques'] =  trim($this->input->post('fisico_ques'));
					$data_clte['clte_fisico_obs'] =  trim($this->input->post('fisico_obs'));
					$data_clte['clte_electronicos_ques'] =  trim($this->input->post('electronicos_ques'));
					$data_clte['clte_electronico_obs'] =  trim($this->input->post('electronico_obs'));
					$data_clte['clte_profesional_ques'] =  trim($this->input->post('profesional_ques'));
					$data_clte['clte_profesional_obs'] =  trim($this->input->post('profesional_obs'));
					$data_clte['clte_imagen_ques'] =  trim($this->input->post('imagen_ques'));
					$data_clte['clte_imagen_obs'] =  trim($this->input->post('imagen_obs'));
					$data_clte['clte_gerente_dis_ques'] =  trim($this->input->post('gerente_dis_ques'));
					$data_clte['clte_gerente_dis_obs'] =  trim($this->input->post('gerente_dis_obs'));
					$data_clte['clte_medico_observa_ques'] =  trim($this->input->post('medico_observa_ques'));
					$data_clte['clte_medico_observa_obs'] =  trim($this->input->post('medico_observa_obs'));
					$data_clte['clte_entrevista_gerente'] =  trim($this->input->post('entrevista_gerente'));				

					if($this->cliente->actualiza($cliente_id, array_to_upper($data_clte)))
					{
						send_json_ok(array('msg' =>'Se actualizó de forma correcta', 'id' => $cliente_id));
					}
					else
					{
						send_json_error('Ocurrió un error al actualizar el registro.');
					}

                }
                else
                {
                    send_json_error(validation_errors('<div />'));
                }
            }
            else 
            {
               
				$data['cliente'] = 	$cliente;

                $this->load->helper('template');
                $params_view = array(
                    'title' => 'Personas',
                    'view' => 'medica/edit',
                    'view_data' => $data
                   );
                render_template($params_view);  
            }
        }
        else 
        {
            show_error('No existe el cliente');
        }
    }
  

    public function nuevo()
    {   
		$user = $this->session->user; 
		$medico = $this->medico->get($user['usr_id']);

        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
			$this->form_validation->set_rules('institucion','Institución','required');
			$this->form_validation->set_rules('notificacion','Notificación de Supervisión','required');
			$this->form_validation->set_rules('encargado','Encargado de Institución','required');
			$this->form_validation->set_rules('medico','Médico en sucursal','required');
			$this->form_validation->set_rules('gerente','Gerente en sucursal','required');
			$this->form_validation->set_rules('resp_medico','Responsable Médico','required');
			$this->form_validation->set_rules('Domicilio donde se realiza la supervisión','required');

            if($this->form_validation->run())
            {
				
				$data_clte['clte_institucion'] =  trim($this->input->post('institucion'));
				$data_clte['clte_notificacion'] =  trim($this->input->post('notificacion'));
				$data_clte['clte_fecha_institucion'] =  trim($this->input->post('fecha_institucion'));
				$data_clte['clte_fecha_notitificacion'] =  trim($this->input->post('fecha_notitificacion'));
				$data_clte['clte_encargado'] =  trim($this->input->post('encargado'));
				$data_clte['clte_medico'] =  trim($this->input->post('medico'));
				$data_clte['clte_gerente'] =  trim($this->input->post('gerente'));
				$data_clte['clte_resp_medico'] =  trim($this->input->post('resp_medico'));
				$data_clte['clte_domicilio'] =  trim($this->input->post('domicilio'));
				$data_clte['clte_limpieza_ques'] =  trim($this->input->post('limpieza_ques'));
				$data_clte['clte_limpieza_obs'] =  trim($this->input->post('limpieza_obs'));
				$data_clte['clte_control_medica_ques'] =  trim($this->input->post('control_medica_ques'));
				$data_clte['clte_control_medica_obs'] =  trim($this->input->post('control_medica_obs'));
				$data_clte['clte_fisico_ques'] =  trim($this->input->post('fisico_ques'));
				$data_clte['clte_fisico_obs'] =  trim($this->input->post('fisico_obs'));
				$data_clte['clte_electronicos_ques'] =  trim($this->input->post('electronicos_ques'));
				$data_clte['clte_electronico_obs'] =  trim($this->input->post('electronico_obs'));
				$data_clte['clte_profesional_ques'] =  trim($this->input->post('profesional_ques'));
				$data_clte['clte_profesional_obs'] =  trim($this->input->post('profesional_obs'));
				$data_clte['clte_imagen_ques'] =  trim($this->input->post('imagen_ques'));
				$data_clte['clte_imagen_obs'] =  trim($this->input->post('imagen_obs'));
				$data_clte['clte_gerente_dis_ques'] =  trim($this->input->post('gerente_dis_ques'));
				$data_clte['clte_gerente_dis_obs'] =  trim($this->input->post('gerente_dis_obs'));
				$data_clte['clte_medico_observa_ques'] =  trim($this->input->post('medico_observa_ques'));
				$data_clte['clte_medico_observa_obs'] =  trim($this->input->post('medico_observa_obs'));
				$data_clte['clte_entrevista_gerente'] =  trim($this->input->post('entrevista_gerente'));

				
				$data_clte['emp_id'] = $user['emp_id'];
				$data_clte['clte_usr_id'] =  $user['usr_id'];
				$data_clte['clte_f_entrada'] = date('Y-m-d H:i:s');				
  
              /*  if(!empty($_FILES['foto']['name']))
                {
                    $this->load->library('upload');
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/fotos_vehiculos/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg',
                            'max_size'      => '10000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('foto'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['clte_path_foto'] = $data['file_name'];
                    }
                }*/
				
				$data_clte=array_to_upper($data_clte);
					
				if($cliente_id = $this->cliente->inserta(array_to_upper($data_clte)))
                {
                    send_json_ok(array('msg' =>'Se guardó de forma correcta el registro del evaluado.', 'id' => $cliente_id));
                }
                else
                {
                    send_json_error('Ocurrió un error al guardar registro del reporte.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
			
            $this->load->model('empresa/Empresa_model','empresa');
			
			$data['empresas'] = $this->empresa->get_all_empresas_gsi_id();;			
			$data['sucursals'] = $this->empresa->get_all_sucursales();
			$data['despachos'] = $this->empresa->get_all_despachos();
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'medica/add',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }



    public function nuevo_doc($cliente_id)
    {	//vehiculos
        $persona = $this->cliente->get($cliente_id);
        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('nombre','Nombre documento','required');

            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_id'] =  $cliente_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
				$data_clte['serv_id'] =  $persona['serv_id'];
                
                $this->load->library('upload');
                if(!empty($_FILES['doc']['name']))
                {
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/docs_medica/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg|pdf|doc|docx',
                            'max_size'      => '10000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('doc'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['doc_path'] = $data['file_name'];
                        if($this->cliente->add_doc(array_to_upper($data_clte)))
                        {
                            send_json_ok('Se guardó de forma correcta');
                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
                    send_json_error($this->upload->display_errors());
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'medica/add_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }

    public function edita_g($fsm_id,$cliente_id)
    {    //vehiculos       
		$cliente = $this->cliente->get($cliente_id);		
		$documento=$this->cliente->get_doc($fsm_id);         
		
        if($documento)
        {

            if(isset($_POST) && count($_POST) > 0)     
            {
                $this->load->library('form_validation');
                $this->form_validation->set_rules('nuevo_nombre','Nuevo Nombre del Archivo','required');


                if($this->form_validation->run())
                {

                    $data_clte['doc_nombre'] =  trim($this->input->post('nuevo_nombre'));
					
					if($this->cliente->actualiza_nombre_doc($fsm_id, array_to_upper($data_clte)))
					{
						send_json_ok(array('msg' =>'Se actualizado el Nombre del Archivo.', 'id' => $cliente_id));
					}
					else
					{
						send_json_error('Ocurrió un error al actualizar el nuevo nombre.');
					}
                }
                else
                {
                    send_json_error(validation_errors('<div />'));
                }
            }
            else 
            {

                $data['persona'] = 	$cliente;
				$data['documento'] = 	$documento;
				

                $this->load->helper('template');
                $params_view = array(
                    'title' => 'Personas',
                    'view' => 'medica/edit_g',
                    'view_data' => $data
                   );
                render_template($params_view);  
            }
        }
        else 
        {
            show_error('No existe el registro');
        }
    }
	
    public function pdf($cliente_id)
    {
        $data['cliente'] =  $this->cliente->get($cliente_id);

		$this->load->helper('pdf');
		//genera_pdf_lab_new($this->load->view('medica/pdf',$data,TRUE),'medica','medica',$med_name,$observaciones);		
		genera_pdf_documento2($this->load->view('medica/pdf',$data,TRUE),'medica','medica');	
    }	
	


   public function borra($fsm_id)
    {
        if($this->cliente->borra_evaluado($fsm_id))
        {
            send_json_ok('Se eliminó de forma correcta.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar.');
        }
    }

	
/*************************************************************************************/
    

 
   	
	


    function busca_evaluado()
    {   $despacho=get_desp_id_usr();
		$emp_id_user=get_emp_id();
		$roots=get_my_user_root2();    
        $empresa = $this->input->post('empresa');
		$id_persona = strtoupper($this->input->post('id_persona'));
        $nombre  = strtoupper($this->input->post('nombre'));
		$paterno  = strtoupper($this->input->post('paterno'));
		$materno  = strtoupper($this->input->post('materno'));
        $rfc     = strtoupper($this->input->post('rfc'));
        $ubicacion     = strtoupper($this->input->post('ubicacion'));
        $data['clientes'] = $this->cliente->busca($empresa, $nombre,$paterno, $materno, $rfc, $ubicacion,$despacho,$emp_id_user,$id_persona);
        send_json_ok($this->load->view('medica/busca',$data,TRUE));
    }


    function busca_p()
    {   $despacho=get_desp_id_usr();
		$emp_id_user=get_emp_id();
		$user = $this->session->user; 
		//$usuario = $CIs->empleado->get($user['usr_id']);
		$medico=$this->medico->get($user['usr_id']);
		
		$roots=get_my_user_root2();    
        $empresa = $this->input->post('empresa');
        $nombre  = strtoupper($this->input->post('nombre'));
		$nombre2 = strtoupper($this->input->post('nombre2'));
		$empleado =	strtoupper($this->input->post('empleado'));
		$receta=	strtoupper($this->input->post('receta'));
		$paterno  = strtoupper($this->input->post('paterno'));
		$materno  = strtoupper($this->input->post('materno'));

		//echo '--'.$medico['usr_emp_asig'].'--';
        $data['clientes'] = $this->cliente->busca_p($empresa, $nombre, $nombre2,$paterno, $materno, $empleado, $receta,$despacho,$medico['usr_emp_asig']);
        
		send_json_ok($this->load->view('medica/busca_p',$data,TRUE));
    }

	



    public function nuevo_e()
    {    
		$user = $this->session->user; 
		$medico = $this->medico->get($user['usr_id']);
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('nombre','Nombre','required');
            $this->form_validation->set_rules('paterno','Apellido Paterno','required');
            $this->form_validation->set_rules('materno','Apellido Materno','required');
            $this->form_validation->set_rules('fnac','Fecha de nacimiento','required');
            $this->form_validation->set_rules('genero','Género','required');

            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_nombre_crypt'] =  trim($this->input->post('nombre'));
                $data_clte['clte_2_nombre_crypt'] =  trim($this->input->post('nombre_adic'));
                $data_clte['clte_paterno_crypt'] =  trim($this->input->post('paterno'));
                $data_clte['clte_materno_crypt'] =  trim($this->input->post('materno'));
                
				$data_clte['clte_f_nac'] = formatea_fecha_mysql($this->input->post('fnac'));
                $data_clte['clte_genero_cve'] =  $this->input->post('genero');      				
				$data_clte['clte_rfc_crypt'] =  $this->input->post('rfc');                				
				$data_clte['clte_curp_crypt'] = $this->input->post('curp');
				$data_clte['clte_nss_crypt'] =  $this->input->post('nss');
                $data_clte['clte_grado_acad_cve'] =  $this->input->post('grado');
                $data_clte['clte_edo_civ_cve'] =  $this->input->post('civil');
                $data_clte['clte_nac_cve'] =  $this->input->post('nac');				
				
                $data_clte['empleado'] = 1;
                
                $data_clte['emp_id'] =$this->input->post('empresa');//$medico['usr_emp_asig'];
                $data_clte['clte_puesto'] = $this->input->post('puesto');
				$data_clte['num_empleado'] = $this->input->post('nempleado');
				
				//sucursal
                $data_clte['suc_id'] =0;
				$data_clte['cei_id'] =  4;

				$nomserv='NOM0351;NOM0352;NOM0353;';
				$data_clte['nomserv'] =  $nomserv;

 /***************************** CARGA DE LA FOTO DEL EVALUADO ************************/               
                if(!empty($_FILES['foto']['name']))
                {
                    $this->load->library('upload');
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/fotos/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg',
                            'max_size'      => '10000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('foto'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['clte_path_foto'] = $data['file_name'];
                    }
                }
/*************************************************************************************/
				$data_clte=array_to_upper($data_clte);
				$data_clte['clte_email_crypt'] =  $this->input->post('correo');
				if ($cliente_id = $this->cliente->inserta($data_clte))
                {
                    send_json_ok(array('msg' =>'Se guardó de forma correcta', 'id' => $cliente_id));
                    
                }
                else
                {
                    send_json_error('Ocurrió un error al guardar la persona.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $this->load->model('empresa/Empresa_model','empresa');
            //$data['empresas'] = $this->empresa->get_all_empresas();
			$data['empresas'] =$this->empresa->get_all_empresas_gsi();
			$data['sucursals'] = $this->empresa->get_all_sucursales();
			$data['despachos'] = $this->empresa->get_all_despachos();
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'medica/add_e',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }


	
    function busca_a()
    {   $despacho=get_desp_id_usr();
		$emp_id_user=get_emp_id();
		$roots=get_my_user_root2();    
        $empresa = $emp_id_user; //$this->input->post('empresa');
        $nombre  = strtoupper($this->input->post('nombre'));
		$nombre2 = strtoupper($this->input->post('nombre2'));
		$paterno  = strtoupper($this->input->post('paterno'));
		$materno  = strtoupper($this->input->post('materno'));
        $data['clientes'] = $this->cliente->busca_a($empresa, $nombre, $nombre2,$paterno, $materno);
        
		send_json_ok($this->load->view('medica/busca_a',$data,TRUE));
    } 
	
	
    public function borra_comentario($fsm_id)
    {
        if($this->cliente->borrar_comentario($fsm_id))
        {
            send_json_ok('Se eliminó de forma correcta.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar.');
        }
    }	

    public function borra_documento($fsm_id)
    {
		$documento=$this->cliente->get_doc($fsm_id);
		
		$doc_borra['clte_id']=$documento['clte_id'];
		$doc_borra['doc_nombre']=$documento['doc_nombre'];
		$doc_borra['doc_path']=strtolower($documento['doc_path']);
		$doc_borra['doc_f']=$documento['doc_f'];
		$doc_borra['empresa']='EVALUADOS';
		$doc_borra['doc_fecha_efectiva']=date();
		
		$this->cliente->inserta_borrado($doc_borra);
        if($this->cliente->delete_doc($fsm_id))
        {
            send_json_ok('Se eliminó de forma correcta.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar.');
        }
    }



	
 
}