 <?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Sasegurados extends CI_Controller {
    
    function __construct() {
        parent::__construct();
		$this->load->model('sasegurados/Sasegurados_model','asegurado');
        $this->load->model('empleado/Empleado_model','empleado');
		$this->load->model('empresa/Empresa_model','empresa');
		$this->load->model('easegurados/Easegurados_model','easegurado');
    }


    public function reenvio($folio_id)
    {
        //$easegurado = $this->easegurado->get($sura_id);
		$user = $this->session->user; 
		$analista = $this->empleado->get($user['usr_id']);
            if(isset($_POST) && count($_POST) > 0)     
            {
                $this->load->library('form_validation');
                $this->form_validation->set_rules('correo','Correo electrónico','required');
                
                if($this->form_validation->run())
                {
                    $data_usr['sura_numeroserie'] = $folio_id;
					$data_usr['sura_correo'] =  trim($this->input->post('correo'));				
					$data_usr['usr_id'] =  $analista['usr_id'];
					$data_usr['emp_id'] =  $analista['emp_id'];
				
					$this->asegurado->borra_lote_fotografico_by_folio($folio_id);
					$this->asegurado->borra_lote_fotografico_by_folio_ori($folio_id);
					$this->asegurado->borra_sis02_sura_comercial($folio_id);
	
					if($sura_id=$this->easegurado->inserta($data_usr))
                    {	

					
						$this->load->helper('mail');
                        $data_email = array('sura_numeroserie' => $data_usr['sura_numeroserie']);	
						
                        $html = $this->load->view('easegurados/email_add',$data_email,TRUE);
						
						send_mail_from_sura($data_usr['sura_correo'],$html);
						
						$data_log['sura_numeroserie'] =  $data_usr['sura_numeroserie'] ;
						$data_log['sura_correo'] = strtolower(trim($this->input->post('correo')));
						$data_log['usr_id'] =  $analista['usr_id'];
						$data_log['emp_id'] =  $analista['emp_id'];		
						$data_log['sura_id'] =  $sura_id;
						$this->easegurado->inserta_ins_log($data_log,'SE CREO REGISTRO QUE NO TENIA FOTOS');

                        send_json_ok('Se actualizó de forma correscta el reenvio');
                    }
                    else
                    {
                        send_json_error('Ocurrió un error al intentar enviar el correo.');
                    }
                }
                else
                {
                    send_json_error(validation_errors('<div />'));
                }
            }
            else 
            {
			
                $data['folio_id'] = $folio_id;

				$this->load->helper('template');
                $params_view = array(
                    'title' => 'Sasegurados',
                    'view' => 'sasegurados/edit_envio',
                    'view_data' => $data
                   );
                render_template($params_view);  
            }
    }


    public function pdf($id_folio)
    {
		$user = $this->session->user; 
		$usuario = $this->empleado->get($user['usr_id']);
		
		$data['folio']=$id_folio;
		$data['cliente'] = $this->asegurado->get_alot($id_folio);		
		$data['fotografias'] =  $this->asegurado->get_photo($id_folio);

        $this->load->helper('pdf');

		genera_pdf_new_reporte_poli($this->load->view('sasegurados/pdf',$data,TRUE),'SURA_SINIESTROS_'.$id_folio,'SURA_SINIESTROS',$id_folio);
	}


    function reporte_empleado()
    {

		   $f_ini = $this->input->post('f_ini'); 
           $f_fin = $this->input->post('f_fin'); 
		   $sasegurados = $this->asegurado->get_all_reg_by_fecha($f_ini,$f_fin);
   
            $this->load->helper('template');	
            	
		?>


		<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
		<html xmlns="http://www.w3.org/1999/xhtml">

		<head>
		<meta content="es-mx" http-equiv="Content-Language" />
		<meta content="text/html; charset=utf-8" http-equiv="Content-Type" />

            <?php
                $date2today = date("Y-m-d H:i:s");
                $date3today = date("YmdHis");

                header("Content-type: application/octet-stream; charset=latin1");
                header("Content-Disposition: attachment; filename=Rep_reg_insvir_registros_sura_".$date3today.".xls");
                header("Pragma: no-cache");
                header("Expires: 0");
            ?>
				<title>REPORTE USUARIOS</title>
				<style type="text/css">
					.auto-style1 {
						font-family: Arial, Helvetica, sans-serif;
						color: #FFFFFF;
						background-color: #3D5588;
						font-size: small;
					}
					.auto-style4 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: xx-small;
					}
					.auto-style5 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: medium;
					}
					.auto-style6 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: x-large;
						text-align: right;
						font-weight: normal;
					}
					.auto-style7 {
						font-size: small;
					}
					.auto-style8 {
						color: #3D5588;
                        
					}
					.auto-style9 {
						color: #3AD4A7;
					}
								.auto-style11 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: small;
						text-align: right;
					}
					.auto-style12 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: small;
						text-align: center;
					}
					.auto-style13 {
						font-size: xx-small;
					}
					.auto-style14 {
						font-family: Arial, Helvetica, sans-serif;
						color: #FFFFFF;
						background-color: #3D5588;
						font-size: xx-small;
					}
					.auto-style15 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: x-small;
					}
					.auto-style16 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: x-small;
						text-align: right;
					}
					.auto-style17 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: x-small;
						text-align: left;
					}
					.auto-style18 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: xx-small;
						text-align: center;
					}
								.auto-style19 {
						color: #3D5588;
						font-size: medium;
					}
					.auto-style20 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: xx-small;
						text-align: center;
						background-color: #BFEADD;
					}
					.auto-style21 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: xx-small;
						background-color: #BFEADD;
					}

                    
                    
				</style>
			</head>

			<body>
				<table>
					<thead>
						<tr>
							<th class="auto-style5" >&nbsp;</th>
							<th class="auto-style5" >&nbsp;</th>
							<th class="auto-style5" >&nbsp;</th>
						</tr>
						<tr>
							<th class="auto-style5" ><span class="auto-style8">human</span><span class="auto-style9">center</span></strong></th>
							<th class="auto-style5" > <span class="auto-style8" style="text-align: right">Reportes de Num. de serie de Grupos Fotográficos de Inspección Virtual</th>
							<th class="auto-style5" >&nbsp;</th>
						</tr>
						<tr>
							<th class="auto-style5" style="height: 27px;"><span class="auto-style19">online</span><sup><span class="auto-style13" style="color: rgb(34, 34, 34); font-family: arial, sans-serif; font-style: normal; font-variant-ligatures: normal; font-variant-caps: normal; font-weight: 400; letter-spacing: normal; orphans: 2; text-align: left; text-indent: 0px; text-transform: none; white-space: normal; widows: 2; word-spacing: 0px; -webkit-text-stroke-width: 0px; background-color: rgb(255, 255, 255); text-decoration-style: initial; text-decoration-color: initial; display: inline !important; float: none;">®</span></sup></th>
							<th class="auto-style5" style="height: 27px;"> <?php echo $date2today; ?></th>
							<th class="auto-style5" >&nbsp;</th>
						</tr>
						<tr>
							<th class="auto-style5" >&nbsp;</th>
							<th class="auto-style5" style="height: 27px;"> <?php echo 'Del '.formatea_fecha($f_ini).' al '.formatea_fecha($f_fin); ?></th>
							<th class="auto-style5" >&nbsp;</th>
						</tr>
						<tr>
							<th class="auto-style5" >&nbsp;</th>
							<th class="auto-style5" >&nbsp;</th>
							<th class="auto-style5" >&nbsp;</th>
						</tr>
                        
						<tr>
							<th class="auto-style14" style="width: 250px">Id</th>
							<th class="auto-style14" style="width: 700px">Folio (Número de Serie / VIN)</th>
							<th class="auto-style14" style="width: 200px">Fecha de Registro</th>
						</tr>

					</thead>
					<tbody id="resultado">
						<?php        
						$class18=" ";
						if($sasegurados): 
						
							foreach ($sasegurados  as $sasegurado): 
								if ($class18 != "auto-style18")
								{
									$class18="auto-style18";
									$class4="auto-style4";
                                    
								}	
								else
								{
									$class18="auto-style20";
									$class4="auto-style21";	
								}
							
					
					
								$elementoLoteFotografico=$this->asegurado->obtenLoteFotograficoFolio($sasegurado['fsm_folio']);
						?>
								<tr  style="background-color:<?php echo $renglon; ?>;"  >

                                    <td class=<?php echo $class18; ?>>
										<b>
											<?php echo $elementoLoteFotografico['sura_id']; ?> 
										</b>	
                                    </td>

									<td class=<?php echo $class18; ?>>
										<b>
											<?php echo $elementoLoteFotografico['fsm_folio']; ?>
										</b>
									</td>
									

                                    <td class=<?php echo $class18; ?>>
										<b>
											<?php echo formatea_fechahora($elementoLoteFotografico['fsm_f']); ?>
										</b>
									</td>

                                </tr>
							<?php 
							endforeach;
						endif;
						?> 
					</tbody>
				</table>
			</body>
		</html>
		<?php 
	    }

    public function nuevo_reporte()
    {       
		$this->load->helper('template');
		$params_view = array(
			'title' => 'Servicios',
			'view' => 'sasegurados/ficha_sasegurados',
			'view_data' => $data
		   );
		
		render_template($params_view);  
    }


    public function nuevo_comentario($folio, $descripcion)
    {
      /*  $persona = $this->cliente->get($cliente_id);
        $user = $this->session->user;	
		$usuario = $this->empleado->get($user['usr_id']);
        $empresa = $this->cliente->get_empresa_by_clte($cliente_id);*/

        if(isset($_POST) && count($_POST) > 0)  
        {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('com_comentario','COMENTARIOS','required');
            

            if($this->form_validation->run())
            {
                
				$data_insert['com_folio']           = $this->input->post('folio');
				$data_insert['com_descripcion']     = $this->input->post('descripcion');
                $data_insert['com_comentario']   =	$this->input->post('com_comentario');
                $data_insert['com_f']            =	date('Y-m-d H:i:s');                
				
                if($this->asegurado->insert_comentarios(array_to_upper($data_insert)))
                {	
                    send_json_ok('Se guardó de forma correcta');
                }
                else
                {
                    send_json_error('Ocurrió un error al guardar.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['folio'] = $folio;
            $data['descripcion'] = $descripcion;
            $this->load->helper('template');
            $params_view = array(
                'title' => '',
                'view' => 'sasegurados/nuevo_comentario',
                'view_data' => $data 
               );
            render_template($params_view);
        }
    }



    function busca_log()
    {        
        $folio  = trim(strtoupper($this->input->post('folio')));
		$f_registro =strtoupper($this->input->post('f_registro'));
		
		
		$id= $this->input->post('id');
		$numserie= trim(strtoupper($this->input->post('numserie')));
		$correo= trim(strtoupper($this->input->post('correo')));
		$analista= trim(strtoupper($this->input->post('analista')));	

		//$data['asegurado']  = $this->asegurado->busca($id,$numserie,$correo,$analista);
		$data1['asegurado'] = $this->asegurado->busca($folio,$f_registro);
        send_json_ok($this->load->view('sasegurados/busca_log',$data1,TRUE));
    }




    function busca()
    {        
        $folio  = trim(strtoupper($this->input->post('folio')));
		$f_registro =strtoupper($this->input->post('f_registro'));
		$data['asegurado'] = $this->asegurado->busca($folio,$f_registro);
        send_json_ok($this->load->view('sasegurados/busca',$data,TRUE));
    }

	public function id($id_folio)
    {   

		$user = $this->session->user; 
		$usuario = $this->empleado->get($user['usr_id']);
		
		$data['cliente'] = $this->asegurado->get_alot($id_folio);		
		$data['fotografias'] =  $this->asegurado->get_photo($id_folio);
		if($data['cliente'])
        {
						
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Sura Comercial',
                'view' => 'sasegurados/cliente',
                'view_data' => $data 
               );

            render_template($params_view);  
        }
        else
        {
            show_error('El cliente no existe.');
        }
    }




   public function borra($fsm_id)
    {
        if($this->asegurado->borra($fsm_id))
        {
            send_json_ok('Se eliminó de forma correcta.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar.');
        }
    }


   public function index()
    {	
        $rows = 15; 
        $this->load->library('pagination');
        $config['base_url'] = base_url('sasegurados/index/');
        $config['total_rows'] = $this->asegurado->count_all();
		
		$config['total_rows'] = $this->asegurado->cuentaEfectivaLoteFotografia();
        $config['per_page'] = $rows;
        $config['attributes'] = array('class' => 'pagination');
        $config['full_tag_open'] = '<div class="pagination-full">';
        $config['full_tag_close'] = '</div>';
        $config['uri_segment'] = 3;
        $config['query_string_segment'] = 4;
        $config['use_page_numbers'] = TRUE;
        $this->pagination->initialize($config);

        $data['asegurado'] = $this->asegurado->get_allo($rows);
		$data['folios_lotes_fotograficos'] = $this->asegurado->obtenEfectivoLoteFotografia($rows);
     
	   $this->load->helper('template');
        $params_view = array(
            'title' => 'Usuario',
            'view' => 'sasegurados/index',
            'view_data' => $data 
           );
        render_template($params_view);  
    }
 
 
 
 
 
 
    public function index_log()
    {	
        $rows = 15; 
        $this->load->library('pagination');
        $config['base_url'] = base_url('sasegurados/index_log/');
        $config['total_rows'] = $this->asegurado->count_all();
		
		$config['total_rows'] = $this->asegurado->cuentaEfectivaLog();
        $config['per_page'] = $rows;
        $config['attributes'] = array('class' => 'pagination');
        $config['full_tag_open'] = '<div class="pagination-full">';
        $config['full_tag_close'] = '</div>';
        $config['uri_segment'] = 3;
        $config['query_string_segment'] = 4;
        $config['use_page_numbers'] = TRUE;
        $this->pagination->initialize($config);

		$data['folios_log'] = $this->asegurado->obtenEfectivoLog($rows);
		$data['los_analistas']= $this->easegurado->get_analistas('ANALISTA');
	   $this->load->helper('template');
        $params_view = array(
            'title' => 'Usuario',
            'view' => 'sasegurados/index_log',
            'view_data' => $data 
           );
        render_template($params_view);  
    }
 
 
 
 

    public function edita($aseg_id)
    {
        $item = $this->asegurado->get($aseg_id);		
		$user = $this->session->user;
        
        if($item)
        {

            if(isset($_POST) && count($_POST) > 0)     
            {
                $this->load->library('form_validation');
				$this->form_validation->set_rules('cat_grupo','Grupo (cat_grupo)','required');
				$this->form_validation->set_rules('cat_grupo_nombre','Sub Grupo','required');
				$this->form_validation->set_rules('cat_seq','Secuencia','required');
				$this->form_validation->set_rules('cat_cve','Clave','required');
				$this->form_validation->set_rules('cat_nombre','Detalle','required');
				$this->form_validation->set_rules('cat_estatus_cve','Estatus','required');

                if($this->form_validation->run())
                {
					$data_usr['cat_grupo'] = trim($this->input->post('cat_grupo'));       
					$data_usr['cat_grupo_nombre'] = trim($this->input->post('cat_grupo_nombre')); 
					$data_usr['cat_seq'] = trim($this->input->post('cat_seq')); 
					$data_usr['cat_cve'] = trim($this->input->post('cat_cve')); 
					$data_usr['cat_nombre'] = trim($this->input->post('cat_nombre')); 
					$data_usr['cat_estatus_cve'] = trim($this->input->post('cat_estatus_cve')); 
				    $data_usr = array_to_upper($data_usr);
					
                    if($this->asegurado->actualiza($aseg_id, $data_usr))
                    {
                        send_json_ok('Se actualizó de forma correcta');
                    }
                    else
                    {
                        send_json_error('Ocurrió un error al actualizar el item.');
                    }
                }
                else
                {
                    send_json_error(validation_errors('<div />'));
                }
            }
            else 
            {
				

                $data['item'] =  $item;

				$this->load->helper('template');
                $params_view = array(
                    'title' => 'Empleados',
                    'view' => 'sasegurados/edit',
                    'view_data' => $data
                   );
                render_template($params_view);  
            }
        }
        else 
        {
            show_error('No existe el item');
        }
    }
 
    public function nuevo()
    {
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('cat_grupo','Grupo (cat_grupo)','required');
            $this->form_validation->set_rules('cat_grupo_nombre','Sub Grupo','required');
            $this->form_validation->set_rules('cat_seq','Secuencia','required');
            $this->form_validation->set_rules('cat_cve','Clave','required');
            $this->form_validation->set_rules('cat_nombre','Detalle','required');
            $this->form_validation->set_rules('cat_estatus_cve','Estatus','required');
  
            if($this->form_validation->run())
            {
                $data_usr['cat_grupo'] = trim($this->input->post('cat_grupo'));       
				$data_usr['cat_grupo_nombre'] = trim($this->input->post('cat_grupo_nombre')); 
				$data_usr['cat_seq'] = trim($this->input->post('cat_seq')); 
				$data_usr['cat_cve'] = trim($this->input->post('cat_cve')); 
				$data_usr['cat_nombre'] = trim($this->input->post('cat_nombre')); 				
				$data_usr['cat_estatus_cve'] = trim($this->input->post('cat_estatus_cve')); 
                $data_usr = array_to_upper($data_usr);
				
                if($this->asegurado->inserta($data_usr))
                {
                    send_json_ok('Se guardó de forma correcta');
                }
                else
                {
                    send_json_error('Ocurrió un error al guardar el empleado.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {

            $this->load->helper('template');
            $params_view = array(
                'title' => 'Empleados',
                'view' => 'sasegurados/add',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }







   public function duplicar($aseg_id)
    {
        $item = $this->asegurado->get($aseg_id);		
		$user = $this->session->user;
		
        if($item)
        {

            if(isset($_POST) && count($_POST) > 0)     
            { 

                $this->load->library('form_validation');
				$this->form_validation->set_rules('cat_grupo','Grupo (cat_grupo)','required');
				$this->form_validation->set_rules('cat_grupo_nombre','Sub Grupo','required');
				$this->form_validation->set_rules('cat_seq','Secuencia','required');
				$this->form_validation->set_rules('cat_cve','Clave','required');
				$this->form_validation->set_rules('cat_nombre','Detalle','required');
				$this->form_validation->set_rules('cat_estatus_cve','Estatus','required');
				
				if($this->form_validation->run())
                { 
					$data_usr['cat_grupo'] = trim($this->input->post('cat_grupo'));       
					$data_usr['cat_grupo_nombre'] = trim($this->input->post('cat_grupo_nombre')); 
					$data_usr['cat_seq'] = trim($this->input->post('cat_seq')); 
					$data_usr['cat_cve'] = trim($this->input->post('cat_cve')); 
					$data_usr['cat_nombre'] = trim($this->input->post('cat_nombre')); 
					$data_usr['cat_estatus_cve'] = trim($this->input->post('cat_estatus_cve')); 
					$data_usr = array_to_upper($data_usr);
					if($this->asegurado->inserta($data_usr))
					{
						send_json_ok('Se guardó de forma correcta');
					}
					else
					{
						send_json_error('Ocurrió un error al guardar el empleado.');
					}
                }
                else
                {
                    send_json_error(validation_errors('<div />'));
                }
            }
            else 
            {
                $data['item'] = 	$item;
                $this->load->helper('template');
                $params_view = array(
                    'title' => 'sasegurados',
                    'view' => 'sasegurados/copy',
                    'view_data' => $data
                   );
                render_template($params_view);  
            }
        }
        else 
        {
            show_error('No existe el registro');
        }
    }


    public function reporte_card()
    {
        $this->load->helper('template');
        $params_view = array(
            'title' => 'Inicio',
            'view' => 'sasegurados/inicio_view_rep',
            'view_data' => $data
            );
        render_template($params_view);
    }
 

	
     function reporte_asegurados()
    {
        $grupo  = trim(strtoupper($this->input->post('grupo')));
		$subgrupo  = trim(strtoupper($this->input->post('subgrupo')));
		$clave = trim(strtoupper($this->input->post('clave')));
		$estatus = $this->input->post('estatus');  
		$detalle= trim(strtoupper($this->input->post('detalle'))); 
		$asegurado = $this->asegurado->busca($grupo,$subgrupo ,$clave, $estatus, $detalle);
		
        //$this->load->model('empresa/Empresa_model','empresa');
        //$data['empresas'] = $this->empresa->get_all_empresas();
        $this->load->helper('template');		
		?>
		<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
		<html xmlns="http://www.w3.org/1999/xhtml">

		<head>
		<meta content="es-mx" http-equiv="Content-Language" />
		<meta content="text/html; charset=utf-8" http-equiv="Content-Type" />
				<?php
					date_default_timezone_set('America/Mexico_City');
					$date2today = date("_dmY_His");
					header("Content-type: application/octet-stream; charset=latin1");
					header("Content-Disposition: attachment; filename=rep_asegurado".$date2today.".xls");
					header("Pragma: no-cache");
					header("Expires: 0");
					$date2today = date("d/m/Y H:i:s");
				?>
				<title>REPORTE USUARIOS</title>
				<style type="text/css">
					.auto-style1 {
						font-family: Arial, Helvetica, sans-serif;
						color: #FFFFFF;
						background-color: #3D5588;
						font-size: small;
					}
					.auto-style4 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: xx-small;
					}
					.auto-style5 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: medium;
					}
					.auto-style6 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: x-large;
						text-align: right;
						font-weight: normal;
					}
					.auto-style7 {
						font-size: small;
					}
					.auto-style8 {
						color: #3D5588;
					}
					.auto-style9 {
						color: #3AD4A7;
					}
								.auto-style11 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: small;
						text-align: right;
					}
					.auto-style12 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: small;
						text-align: center;
					}
					.auto-style13 {
						font-size: xx-small;
					}
					.auto-style14 {
						font-family: Arial, Helvetica, sans-serif;
						color: #FFFFFF;
						background-color: #3D5588;
						font-size: xx-small;
					}
					.auto-style15 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: x-small;
					}
					.auto-style16 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: x-small;
						text-align: right;
					}
					.auto-style17 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: x-small;
						text-align: left;
					}
					.auto-style18 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: xx-small;
						text-align: center;
					}
								.auto-style19 {
						color: #3D5588;
						font-size: medium;
					}
					.auto-style20 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: xx-small;
						text-align: center;
						background-color: #BFEADD;
					}
					.auto-style21 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: xx-small;
						background-color: #BFEADD;
					}
				</style>
			</head>

			<body>
				<table>
					<thead>
						<tr>
							<th class="auto-style5" style="width: 75px">&nbsp;</th>
							<th class="auto-style5" style="width: 150px">&nbsp;</th>
							<th class="auto-style5" style="width: 150px">&nbsp;</th>
							<th class="auto-style5" style="width: 150px">&nbsp;</th>
							<th class="auto-style5" style="width: 150px">&nbsp;</th>
							<th class="auto-style5" style="width: 350px">&nbsp;</th>
							<th class="auto-style5" style="width: 150px">&nbsp;</th>
						</tr>
						<tr>
							<th class="auto-style5">&nbsp;</th>
							<th class="auto-style5"><span class="auto-style8">human</span><span class="auto-style9">center</span></strong></th>
							<th class="auto-style5">&nbsp;</th>
							<th class="auto-style5">&nbsp;</th>
							<th class="auto-style5">&nbsp;</th>
							<th class="auto-style5">Reporte de Catálogos en Plataforma</th>
						</tr>
						<tr>
							<th class="auto-style5">&nbsp;</th>
							<th class="auto-style5" style=" height: 27px;"><span class="auto-style19">online</span><sup><span class="auto-style13" style="color: rgb(34, 34, 34); font-family: arial, sans-serif; font-style: normal; font-variant-ligatures: normal; font-variant-caps: normal; font-weight: 400; letter-spacing: normal; orphans: 2; text-align: left; text-indent: 0px; text-transform: none; white-space: normal; widows: 2; word-spacing: 0px; -webkit-text-stroke-width: 0px; background-color: rgb(255, 255, 255); text-decoration-style: initial; text-decoration-color: initial; display: inline !important; float: none;">®</span></sup></th>
							<th class="auto-style5" >&nbsp;</th>
							<th class="auto-style5" >&nbsp;</th>
							<th class="auto-style5">&nbsp;</th>
							<th class="auto-style5" style=" height: 27px;"><?php echo $date2today; ?></th>
						</tr>
						<tr>
							<th class="auto-style5" >&nbsp;</th>
							<th class="auto-style5" >&nbsp;</th>
							<th class="auto-style5" >&nbsp;</th>
							<th class="auto-style5">&nbsp;</th>
							<th class="auto-style5" >&nbsp;</th>
							<th class="auto-style5" >&nbsp;</th>
						</tr>
						<tr>
							<th class="auto-style5">&nbsp;</th>
							<th class="auto-style5">&nbsp;</th>
							<th class="auto-style5" >&nbsp;</th>
							<th class="auto-style5" >&nbsp;</th>
							<th class="auto-style5" >&nbsp;</th>
							<th class="auto-style5" >&nbsp;</th>
						</tr>
						<tr>
							<th class="auto-style14" >ID</th>
							<th class="auto-style14" >Grupo</th>
							<th class="auto-style14" >Sub Grupo</th>
							<th class="auto-style14">Secuencia</th>
							<th class="auto-style14" >Clave</th>
							<th class="auto-style14" >Detalle</th>
							<th class="auto-style14" >Estatus</th>
						</tr>
					</thead>
					<tbody id="resultado">
						<?php
						$class18=" ";
                        if($asegurado): 
                            foreach ($asegurado as $elemento): 

								if ($class18 != "auto-style18")
								{
									$class18="auto-style18";
									$class4="auto-style4";
								}	
								else
								{
									$class18="auto-style20";
									$class4="auto-style21";							
								}

								if ( $elemento['cat_estatus_cve'] === 'ACTIVO')
								{ $color='dark';} else { $color='red';}
								?>
								
                                <tr>
                                    <td class=<?php echo $class18; ?>>
										<b>
											<?php echo $elemento['aseg_id']; ?> 
										</b>	
                                    </td>								
                                    <td class=<?php echo $class18; ?>>
										<b>
											<?php echo $elemento['cat_grupo']; ?> 
										</b>	
                                    </td>
                                    <td class=<?php echo $class18; ?>>
										<b>
											<?php echo $elemento['cat_grupo_nombre']; ?>
										</b>
									</td>
                                    <td class=<?php echo $class18; ?>>
										<b>
											<?php echo $elemento['cat_seq']; ?>
										</b>	
									</td>
									<td class=<?php echo $class18; ?>>
										<b>
											<?php echo $elemento['cat_cve']; ?>
										</b>	
									</td>
									<td class=<?php echo $class18; ?>>
										<b>
											<?php echo $elemento['cat_nombre']; ?>
										</b>	
									</td>	
									<td class=<?php echo $class18; ?>>
										<b>
											<?php echo $elemento['cat_estatus_cve']; ?>
										</b>	
									</td>									
                                </tr>
                            <?php 
                            endforeach;
                        endif;
                    ?>						
						
		
					</tbody>
				</table>
			</body>
		</html>
		<?php 
	}
		
	
}