<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Fisioterapia extends CI_Controller {
    function __construct() {
        parent::__construct();
        $this->load->model('persona/Persona_model','cliente');
		$this->load->model('servicio/Servicio_model','servicio');
        $this->load->model('empleado/Empleado_model','medico');
        $this->load->model('examen/Fisioterapia_model','fisioterapia');
		$this->load->helper('util'); 
    }
 

	public function nuevo($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
        $user = $this->session->user;

        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');

            if (1) //($this->form_validation->run())
            {
                $data_insert['emp_id']  = $persona['emp_id'];
                $data_insert['clte_id'] = $persona['clte_id'];
                $data_insert['usr_id']  = $user['usr_id'];
                $data_insert['fsm_f']   =  date('Y-m-d H:i:s');
				$data_insert['med_id']   =  $this->input->post('medico');
                $data_insert['fsm_cve']     =	$this->input->post('servicio');
				$data_insert['fsm_servicio_me']     =	$this->fisioterapia->get_catalogo_cat_nombre('FISIOTERAPIA', $data_insert['fsm_cve']);
 
				$data_insert=array_to_upper($data_insert);
			 	$data_insert['fsm_evaluacion']     =	$this->input->post('evaluacion'); 
				$data_insert['fsm_conclusiones']     =	$this->input->post('conclusiones');
				
 	 
				$data_insert['log_insrt_f']  =  date('Y-m-d H:i:s');

	
                if($this->fisioterapia->insert_r_simple($data_insert))
                {
                    send_json_ok('Se guardó de forma correcta');
                }
                else
                {
                    send_json_error('Ocurrió un error al guardar.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
            $data['medico'] = $medico;
            $this->load->helper('template');
            $params_view = array(
                'title' => '',
                'view' => 'examen/fisioterapia/nuevo',
                'view_data' => $data 
               );
            render_template($params_view);
        }
    }

    public function pdf($cliente_id, $fsm_id)
    {
        $data['persona'] = $this->cliente->get($cliente_id,get_desp_id_usr());
        $data['fsm'] = $this->fisioterapia->get_r_simple($fsm_id,get_desp_id_usr());
        $data['medico'] = $this->medico->get_id($data['fsm']['med_id']);
        $data['empresa'] = $this->cliente->get_empresa_by_id($data['fsm']['emp_id']);
        $this->load->helper('pdf');
        genera_pdf_jr($this->load->view('examen/fisioterapia/pdf',$data,TRUE),'fisioterapia','fisioterapia','');		
    }





    public function editar($cliente_id, $fsm_id)
    {
        $persona = $this->cliente->get($cliente_id);
		$data['fsm'] = $this->fisioterapia->get_r_simple($fsm_id);		
        $user = $this->session->user;


        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
            if(true)
            {
                $data_update['usr_id']  = $user['usr_id'];
				$data_update['med_id']   =  $this->input->post('medico');
                $data_update['fsm_cve']     =	$this->input->post('servicio');				
				$data_update['fsm_servicio_me']     =	$this->fisioterapia->get_catalogo_cat_nombre('FISIOTERAPIA', $data_update['fsm_cve']);
				$data_update=array_to_upper($data_update);
			 	$data_update['fsm_evaluacion']     =	$this->input->post('evaluacion'); 
				$data_update['fsm_conclusiones']     =	$this->input->post('conclusiones');
				$data_update['log_updt_f']  =  date('Y-m-d H:i:s');
				$result_update = $this->fisioterapia->update_r_simple($fsm_id, $data_update);
				if($result_update)
                {
                    send_json_ok('Se guardó de forma correcta');
                }
                else
                {
                    send_json_error('Ocurrió un error al guardar.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
            $this->load->helper('template');
            $params_view = array(
                'title' => '',
                'view' => 'examen/fisioterapia/edita',
                'view_data' => $data 
               );
            render_template($params_view);
        }
    }

 
 
     public function borra_fisioterapia($fsm_id)
    {
        if($this->fisioterapia->delete_fisioterapia($fsm_id))
        {
            send_json_ok('Se eliminó de forma correcta.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar.');
        }
    }
 
	
}