<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Hba1c extends CI_Controller {
    function __construct() {
        parent::__construct();
        $this->load->model('persona/Persona_model','cliente');
		$this->load->model('servicio/Servicio_model','servicio');
        $this->load->model('empleado/Empleado_model','medico');
        $this->load->model('examen/Hba1c_model','hba1c');
		$this->load->helper('util');
		$this->load->helper('report');
		$this->load->helper('laboratorx');
    }
    
    public function nuevo($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
        $user = $this->session->user;		
		$metodo=0;

        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
			if (($persona['serv_id'] == 0) ||(get_status_serv($persona['serv_id']) != 'PROCESO'))
			{					
					$this->form_validation->set_rules('servicio','Orden de servicio','required');
			}
			else
			{
					$this->form_validation->set_rules('servicio','Orden de servicio','integer');
			}
            
			$this->form_validation->set_rules('fis_resultado','HEMOGLOBINA GLICOSILADA','required'); 
           
            if($this->form_validation->run())
            {
                $data_insert['usr_id']  = $user['usr_id']; 
				$data_insert['med_id']  = $this->input->post('laboratorista'); 
				
                $data_insert['clte_id'] = $persona['clte_id'];
                $data_insert['emp_id']  = $persona['emp_id'];

				if (($persona['serv_id'] == 0) || (get_status_serv($persona['serv_id']) != 'PROCESO'))
				{	
						$data_insert['serv_id']  = $this->input->post('servicio');
				}
				else
				{	
						$data_insert['serv_id']  = $persona['serv_id'];
				}

                $data_insert['hba1c_medico_sol'] = $this->input->post('medico_sol');
                $data_insert['hba1c_f_recibido']   =  formatea_fecha_mysql($this->input->post('f_recibido'));
                $data_insert['hba1c_f_impresion']  =  formatea_fecha_mysql($this->input->post('f_impresion'));
				$data_insert['hba1c_fis_resultado']= $this->input->post('fis_resultado');
				$data_insert['hba1c_lab'] = $this->input->post('laboratorista');
				$data_insert['hba1c_metodo'] = $this->input->post('laboratorio_metodo');
				$metodo=$this->input->post('laboratorio_metodo');
                $data_insert['log_insrt_f']= date('Y-m-d H:i:s'); 
				
				
				$data_insert['hba1c_obs']= $this->input->post('hba1c_obs');
				$data_insert=array_to_upper($data_insert);	
				/*$data_insert['hba1c_fuera_rango'] = $this->input->post('fuera_rango');*/
                 
				
                if($this->hba1c->insert($data_insert) && ($metodo > 0))
                {
                    send_json_ok('Se guardó de forma correcta');
					$servicios=$persona['domserv'];					
					$servicio='HBA1C;'; /*CODIGO DEL EXAMEN*/
					if (!(strstr($servicios,$servicio)))
					{							
						$servicios.=$servicio;
						$data_clte['domserv']=$servicios;
						$data_clte['clte_status_proc'] = 'EN PROCESO';
						$res=$this->cliente->actualiza_registro_individual($cliente_id, $data_clte);
					}
                }
                else
                {
					if ($metodo == 0)
					{	send_json_error('No has elegido el Método.'); 	}
					else { send_json_error('Ocurrió un error al guardar.'); }
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
            $data['medico'] = $medico;
			$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Hba1c',
                'view' => 'examen/hba1c/nuevo_form',
                'view_data' => $data 
               );
            render_template($params_view);
        }
    }
    
    public function pdf($cliente_id, $fsm_id)
    {
        $data['persona'] = $this->cliente->get($cliente_id,get_desp_id_usr());
        $data['fsm'] = $this->hba1c->get($fsm_id,get_desp_id_usr());
        $data['medico'] = $this->medico->get_id($data['fsm']['med_id']);
        $data['empresa'] = $this->cliente->get_empresa_by_id($data['fsm']['emp_id']);
        $this->load->helper('pdf');

		$med_name=$data['fsm']['hba1c_lab'];
		$emp_id=$data['fsm']['emp_id'];
		$observaciones=$data['fsm']['hba1c_obs'];
		$data_empresa = $this->cliente->get_empresa_by_id($emp_id);
		if ($data_empresa['emp_giro'] == 'SEGURIDAD')
		{
			genera_pdf_tohuanti($this->load->view('examen/hba1c/pdf',$data,TRUE),'hba1c','hba1c');
		}
		else
		{	
			//$med_name=agrega_cedula($med_name,'Cédula Profesional:');
			//genera_pdf_lab_new($this->load->view('examen/hba1c/pdf',$data,TRUE),'hba1c','hba1c',$med_name,$observaciones);		
			$med_name=agrega_cedula_ext($data['fsm']['med_id']);
			genera_pdf_lab_new_x($this->load->view('examen/hba1c/pdf',$data,TRUE),'hba1c','hba1c',$med_name,$observaciones,$fuera_rango);	
		}
    }

    public function borra_hba1c($fsm_id)
    {
        if($this->hba1c->delete_hba1c($fsm_id))
        {
            send_json_ok('Se eliminó de forma correcta.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar.');
        }
    }


}