<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Historia_clinica extends CI_Controller {
    function __construct() {
        parent::__construct();
        $this->load->model('persona/Persona_model','cliente');
        $this->load->model('empleado/Empleado_model','medico');
        $this->load->model('examen/Historia_clinica_model','historia_clinica');
		$this->load->helper('util');
    }
    
    /* nuevo desarrollo  */
    function nuevo($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
        $medico = $this->session->user;
        
        if(isset($_POST) && count($_POST) > 0)  
        {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('servicio','Orden de servicio','required');
           // $this->form_validation->set_rules('planta','CEDIS/Planta','required');
            $this->form_validation->set_rules('dependientes','Dependientes ecónomicos','required');
            $this->form_validation->set_rules('lugar','Lugar','required');
            
            if($this->form_validation->run())
            {
                $data_insert = array(
                    'clte_id' => $cliente_id,
                    'usr_id' => $medico['usr_id'],
                    'emp_id' => $persona['emp_id'],
                    'fsm_f' => date("Y-m-d H:i:s"),
                    'serv_id' => $this->input->post('servicio'),
                    'fsm_pat_infec_rube' => $this->input->post('pat_infec_rube'),
                    'fsm_pat_infec_esca' => $this->input->post('pat_infec_esca'),
                    'fsm_pat_infec_amig' => $this->input->post('pat_infec_amig'),
                    'fsm_pat_infec_otit' => $this->input->post('pat_infec_otit'),
                    'fsm_pat_infec_tube' => $this->input->post('pat_infec_tube'),
                    'fsm_pat_infec_bron' => $this->input->post('pat_infec_bron'),
                    'fsm_pat_infec_otras' => $this->input->post('pat_infec_otras'),
                    'fsm_gine_f_ult_regla' => formatea_fecha_mysql($this->input->post('gine_f_ult_regla')),
                    'fsm_gine_dias_regla' => $this->input->post('gine_dias_regla'),
                    'fsm_gine_dura_regla' => $this->input->post('gine_dura_regla'),
                    'fsm_gine_vida_sex' => $this->input->post('gine_vida_sex'),
                    'fsm_gine_control_anti' => $this->input->post('gine_control_anti'),
                    'fsm_gine_embarazos' => $this->input->post('gine_embarazos'),
                    'fsm_gine_abortos' => $this->input->post('gine_abortos'),
                    'fsm_gine_cesarea' => $this->input->post('gine_cesarea'),
                    'fsm_gine_f_parto' => formatea_fecha_mysql($this->input->post('gine_f_parto')),
                    'fsm_lugar' => $this->input->post('lugar'),
                    'fsm_int_edo_gral' => $this->input->post('int_edo_gral'),
                    'fsm_relig_id' => $this->input->post('relig_id'),
                    'fsm_int_edo_gral_obs' => $this->input->post('int_edo_gral_obs'),
                    'fsm_planta' => $this->input->post('planta'),
                    'fsm_int_sis_endo' => $this->input->post('int_sis_endo'),
                    'fsm_dependientes' => $this->input->post('dependientes'),
                    'fsm_int_sis_endo_obs' => $this->input->post('int_sis_endo_obs'),
                    'fsm_padre_pad_diab' => $this->input->post('padre_pad_diab'),
                    'fsm_int_org_sent' => $this->input->post('int_org_sent'),
                    'fsm_padre_caus_diab' => $this->input->post('padre_caus_diab'),
                    'fsm_int_org_sent_obs' => $this->input->post('int_org_sent_obs'),
                    'fsm_abu_pad_diab' => $this->input->post('abu_pad_diab'),
                    'fsm_int_apa_dige' => $this->input->post('int_apa_dige'),
                    'fsm_abu_caus_diab' => $this->input->post('abu_caus_diab'),
                    'fsm_int_apa_dige_obs' => $this->input->post('int_apa_dige_obs'),
                    'fsm_tio_pad_diab' => $this->input->post('tio_pad_diab'),
                    'fsm_int_apa_resp' => $this->input->post('int_apa_resp'),
                    'fsm_tio_caus_diab' => $this->input->post('tio_caus_diab'),
                    'fsm_int_apa_resp_obs' => $this->input->post('int_apa_resp_obs'),
                    'fsm_her_pad_diab' => $this->input->post('her_pad_diab'),
                    'fsm_int_apa_card' => $this->input->post('int_apa_card'),
                    'fsm_her_caus_diab' => $this->input->post('her_caus_diab'),
                    'fsm_int_apa_card_obs' => $this->input->post('int_apa_card_obs'),
                    'fsm_hij_pad_diab' => $this->input->post('hij_pad_diab'),
                    'fsm_int_apa_urin' => $this->input->post('int_apa_urin'),
                    'fsm_hij_caus_diab' => $this->input->post('hij_caus_diab'),
                    'fsm_int_apa_urin_obs' => $this->input->post('int_apa_urin_obs'),
                    'fsm_con_pad_diab' => $this->input->post('con_pad_diab'),
                    'fsm_int_apa_genfem' => $this->input->post('int_apa_genfem'),
                    'fsm_con_caus_diab' => $this->input->post('con_caus_diab'),
                    'fsm_int_apa_genfem_obs' => $this->input->post('int_apa_genfem_obs'),
                    'fsm_padre_pad_obes' => $this->input->post('padre_pad_obes'),
                    'fsm_int_apa_genmas' => $this->input->post('int_apa_genmas'),
                    'fsm_padre_caus_obes' => $this->input->post('padre_caus_obes'),
                    'fsm_int_apa_genmas_obs' => $this->input->post('int_apa_genmas_obs'),
                    'fsm_abu_pad_obes' => $this->input->post('abu_pad_obes'),
                    'fsm_int_ctr_nata' => $this->input->post('int_ctr_nata'),
                    'fsm_abu_caus_obes' => $this->input->post('abu_caus_obes'),
                    'fsm_int_ctr_nata_obs' => $this->input->post('int_ctr_nata_obs'),
                    'fsm_tio_pad_obes' => $this->input->post('tio_pad_obes'),
                    'fsm_int_piel' => $this->input->post('int_piel'),
                    'fsm_tio_caus_obes' => $this->input->post('tio_caus_obes'),
                    'fsm_int_piel_obs' => $this->input->post('int_piel_obs'),
                    'fsm_her_pad_obes' => $this->input->post('her_pad_obes'),
                    'fsm_int_sis_nerv' => $this->input->post('int_sis_nerv'),
                    'fsm_her_caus_obes' => $this->input->post('her_caus_obes'),
                    'fsm_int_sis_nerv_obs' => $this->input->post('int_sis_nerv_obs'),
                    'fsm_hij_pad_obes' => $this->input->post('hij_pad_obes'),
                    'fsm_int_sis_hema' => $this->input->post('int_sis_hema'),
                    'fsm_hij_caus_obes' => $this->input->post('hij_caus_obes'),
                    'fsm_int_sis_hema_obs' => $this->input->post('int_sis_hema_obs'),
                    'fsm_con_pad_obes' => $this->input->post('con_pad_obes'),
                    'fsm_int_mus_esqu' => $this->input->post('int_mus_esqu'),
                    'fsm_con_caus_obes' => $this->input->post('con_caus_obes'),
                    'fsm_int_mus_esqu_obs' => $this->input->post('int_mus_esqu_obs'),
                    'fsm_padre_pad_cora' => $this->input->post('padre_pad_cora'),
                    'fsm_int_ant_psic' => $this->input->post('int_ant_psic'),
                    'fsm_padre_caus_cora' => $this->input->post('padre_caus_cora'),
                    'fsm_int_ant_psic_obs' => $this->input->post('int_ant_psic_obs'),
                    'fsm_abu_pad_cora' => $this->input->post('abu_pad_cora'),
                    'fsm_sg_peso' => $this->input->post('sg_peso'),
                    'fsm_abu_caus_cora' => $this->input->post('abu_caus_cora'),
                    'fsm_sg_talla' => $this->input->post('sg_talla'),
                    'fsm_tio_pad_cora' => $this->input->post('tio_pad_cora'),
                    'fsm_sg_imc' => $this->input->post('sg_imc'),
                    'fsm_tio_caus_cora' => $this->input->post('tio_caus_cora'),
                    'fsm_sg_temp' => $this->input->post('sg_temp'),
                    'fsm_her_pad_cora' => $this->input->post('her_pad_cora'),
                    'fsm_sg_fc' => $this->input->post('sg_fc'),
                    'fsm_her_caus_cora' => $this->input->post('her_caus_cora'),
                    'fsm_sg_fr' => $this->input->post('sg_fr'),
                    'fsm_hij_pad_cora' => $this->input->post('hij_pad_cora'),
                    'fsm_sg_biotipo' => $this->input->post('sg_biotipo'),
                    'fsm_hij_caus_cora' => $this->input->post('hij_caus_cora'),
                    'fsm_sg_ta' => $this->input->post('sg_ta'),
                    'fsm_sg_glu' => $this->input->post('sg_glu'),
                    'fsm_con_pad_cora' => $this->input->post('con_pad_cora'),
                    'fsm_ef_craneo' => $this->input->post('ef_craneo'),
                    'fsm_con_caus_cora' => $this->input->post('con_caus_cora'),
                    'fsm_ef_craneo_obs' => $this->input->post('ef_craneo_obs'),
                    'fsm_padre_pad_conv' => $this->input->post('padre_pad_conv'),
                    'fsm_ef_pelo' => $this->input->post('ef_pelo'),
                    'fsm_padre_caus_conv' => $this->input->post('padre_caus_conv'),
                    'fsm_ef_pelo_obs' => $this->input->post('ef_pelo_obs'),
                    'fsm_abu_pad_conv' => $this->input->post('abu_pad_conv'),
                    'fsm_ef_oido_der' => $this->input->post('ef_oido_der'),
                    'fsm_abu_caus_conv' => $this->input->post('abu_caus_conv'),
                    'fsm_ef_crom_od_af' => $this->input->post('ef_crom_od_af'),
                    'fsm_tio_pad_conv' => $this->input->post('tio_pad_conv'),
                    'fsm_ef_camp_od_af' => $this->input->post('ef_camp_od_af'),
                    'fsm_tio_caus_conv' => $this->input->post('tio_caus_conv'),
                    'fsm_ef_crom_od_al' => $this->input->post('ef_crom_od_al'),
                    'fsm_her_pad_conv' => $this->input->post('her_pad_conv'),
                    'fsm_ef_camp_od_al' => $this->input->post('ef_camp_od_al'),
                    'fsm_her_caus_conv' => $this->input->post('her_caus_conv'),
                    'fsm_ef_oido_der_obs' => $this->input->post('ef_oido_der_obs'),
                    'fsm_hij_pad_conv' => $this->input->post('hij_pad_conv'),
                    'fsm_ef_oido_izq' => $this->input->post('ef_oido_izq'),
                    'fsm_hij_caus_conv' => $this->input->post('hij_caus_conv'),
                    'fsm_ef_crom_oi_af' => $this->input->post('ef_crom_oi_af'),
                    'fsm_con_pad_conv' => $this->input->post('con_pad_conv'),
                    'fsm_ef_camp_oi_af' => $this->input->post('ef_camp_oi_af'),
                    'fsm_con_caus_conv' => $this->input->post('con_caus_conv'),
                    'fsm_ef_crom_oi_al' => $this->input->post('ef_crom_oi_al'),
                    'fsm_padre_pad_pres' => $this->input->post('padre_pad_pres'),
                    'fsm_ef_camp_oi_al' => $this->input->post('ef_camp_oi_al'),
                    'fsm_padre_caus_pres' => $this->input->post('padre_caus_pres'),
                    'fsm_ef_oido_izq_obs' => $this->input->post('ef_oido_izq_obs'),
                    'fsm_abu_pad_pres' => $this->input->post('abu_pad_pres'),
                    'fsm_ef_webber' => $this->input->post('ef_webber'),
                    'fsm_abu_caus_pres' => $this->input->post('abu_caus_pres'),
                    'fsm_ef_webber_obs' => $this->input->post('ef_webber_obs'),
                    'fsm_tio_pad_pres' => $this->input->post('tio_pad_pres'),
                    'fsm_ef_rinne' => $this->input->post('ef_rinne'),
                    'fsm_tio_caus_pres' => $this->input->post('tio_caus_pres'),
                    'fsm_ef_rinne_obs' => $this->input->post('ef_rinne_obs'),
                    'fsm_her_pad_pres' => $this->input->post('her_pad_pres'),
                    'fsm_ef_visual_od' => $this->input->post('ef_visual_od'),
                    'fsm_ef_visual_od_obs' => $this->input->post('ef_visual_od_obs'),
                    'fsm_her_caus_pres' => $this->input->post('her_caus_pres'),
                    'fsm_ef_visual_oi' => $this->input->post('ef_visual_oi'),
                    'fsm_ef_visual_oi_obs' => $this->input->post('ef_visual_oi_obs'),
                    'fsm_hij_pad_pres' => $this->input->post('hij_pad_pres'),
                    'fsm_ef_visual_ao' => $this->input->post('ef_visual_ao'),
                    'fsm_ef_visual_ao_obs' => $this->input->post('ef_visual_ao_obs'),
                    'fsm_hij_caus_pres' => $this->input->post('hij_caus_pres'),
                    'fsm_ef_nariz' => $this->input->post('ef_nariz'),
                    'fsm_con_pad_pres' => $this->input->post('con_pad_pres'),
                    'fsm_ef_nariz_obs' => $this->input->post('ef_nariz_obs'),
                    'fsm_con_caus_pres' => $this->input->post('con_caus_pres'),
                    'fsm_ef_labios' => $this->input->post('ef_labios'),
                    'fsm_padre_pad_rino' => $this->input->post('padre_pad_rino'),
                    'fsm_ef_labios_obs' => $this->input->post('ef_labios_obs'),
                    'fsm_padre_caus_rino' => $this->input->post('padre_caus_rino'),
                    'fsm_ef_mucosas' => $this->input->post('ef_mucosas'),
                    'fsm_abu_pad_rino' => $this->input->post('abu_pad_rino'),
                    'fsm_ef_mucosas_obs' => $this->input->post('ef_mucosas_obs'),
                    'fsm_abu_caus_rino' => $this->input->post('abu_caus_rino'),
                    'fsm_ef_dientes' => $this->input->post('ef_dientes'),
                    'fsm_tio_pad_rino' => $this->input->post('tio_pad_rino'),
                    'fsm_ef_dientes_obs' => $this->input->post('ef_dientes_obs'),
                    'fsm_tio_caus_rino' => $this->input->post('tio_caus_rino'),
                    'fsm_ef_faringe' => $this->input->post('ef_faringe'),
                    'fsm_her_pad_rino' => $this->input->post('her_pad_rino'),
                    'fsm_ef_faringe_obs' => $this->input->post('ef_faringe_obs'),
                    'fsm_her_caus_rino' => $this->input->post('her_caus_rino'),
                    'fsm_ef_amigdalas' => $this->input->post('ef_amigdalas'),
                    'fsm_hij_pad_rino' => $this->input->post('hij_pad_rino'),
                    'fsm_ef_amigdalas_obs' => $this->input->post('ef_amigdalas_obs'),
                    'fsm_ef_cuello' => $this->input->post('ef_cuello'),
                    'fsm_ef_cuello_obs' => $this->input->post('ef_cuello_obs'),
                    'fsm_hij_caus_rino' => $this->input->post('hij_caus_rino'),
                    'fsm_ef_tiroides' => $this->input->post('ef_tiroides'),
                    'fsm_con_pad_rino' => $this->input->post('con_pad_rino'),
                    'fsm_ef_tiroides_obs' => $this->input->post('ef_tiroides_obs'),
                    'fsm_con_caus_rino' => $this->input->post('con_caus_rino'),
                    'fsm_ef_torax' => $this->input->post('ef_torax'),
                    'fsm_padre_pad_canc' => $this->input->post('padre_pad_canc'),
                    'fsm_ef_torax_obs' => $this->input->post('ef_torax_obs'),
                    'fsm_padre_caus_canc' => $this->input->post('padre_caus_canc'),
                    'fsm_ef_extre_sup' => $this->input->post('ef_extre_sup'),
                    'fsm_abu_pad_canc' => $this->input->post('abu_pad_canc'),
                    'fsm_ef_extre_sup_obs' => $this->input->post('ef_extre_sup_obs'),
                    'fsm_abu_caus_canc' => $this->input->post('abu_caus_canc'),
                    'fsm_ef_abdomen' => $this->input->post('ef_abdomen'),
                    'fsm_tio_pad_canc' => $this->input->post('tio_pad_canc'),
                    'fsm_ef_abdomen_obs' => $this->input->post('ef_abdomen_obs'),
                    'fsm_tio_caus_canc' => $this->input->post('tio_caus_canc'),
                    'fsm_ef_genitales' => $this->input->post('ef_genitales'),
                    'fsm_her_pad_canc' => $this->input->post('her_pad_canc'),
                    'fsm_ef_genitales_obs' => $this->input->post('ef_genitales_obs'),
                    'fsm_her_caus_canc' => $this->input->post('her_caus_canc'),
                    'fsm_ef_extre_inf' => $this->input->post('ef_extre_inf'),
                    'fsm_hij_pad_canc' => $this->input->post('hij_pad_canc'),
                    'fsm_ef_extre_inf_obs' => $this->input->post('ef_extre_inf_obs'),
                    'fsm_hij_caus_canc' => $this->input->post('hij_caus_canc'),
                    'fsm_ef_columna_lumb' => $this->input->post('ef_columna_lumb'),
                    'fsm_con_pad_canc' => $this->input->post('con_pad_canc'),
                    'fsm_ef_columna_lumb_obs' => $this->input->post('ef_columna_lumb_obs'),
                    'fsm_con_caus_canc' => $this->input->post('con_caus_canc'),
                    'fsm_ef_piel' => $this->input->post('ef_piel'),
                    'fsm_padre_pad_tube' => $this->input->post('padre_pad_tube'),
                    'fsm_ef_piel_obs' => $this->input->post('ef_piel_obs'),
                    'fsm_padre_caus_tube' => $this->input->post('padre_caus_tube'),
                    'fsm_ef_tatu' => $this->input->post('ef_tatu'),
                    'fsm_abu_pad_tube' => $this->input->post('abu_pad_tube'),
                    'fsm_ef_tatu_obs' => $this->input->post('ef_tatu_obs'),
                    'fsm_abu_caus_tube' => $this->input->post('abu_caus_tube'),
                    'fsm_tio_pad_tube' => $this->input->post('tio_pad_tube'),
                    'fsm_odon_28' => $this->input->post('odon_28'),
                    'fsm_tio_caus_tube' => $this->input->post('tio_caus_tube'),
                    'fsm_odon_27' => $this->input->post('odon_27'),
                    'fsm_her_pad_tube' => $this->input->post('her_pad_tube'),
                    'fsm_odon_26' => $this->input->post('odon_26'),
                    'fsm_her_caus_tube' => $this->input->post('her_caus_tube'),
                    'fsm_odon_25' => $this->input->post('odon_25'),
                    'fsm_hij_pad_tube' => $this->input->post('hij_pad_tube'),
                    'fsm_odon_24' => $this->input->post('odon_24'),
                    'fsm_hij_caus_tube' => $this->input->post('hij_caus_tube'),
                    'fsm_odon_23' => $this->input->post('odon_23'),
                    'fsm_con_pad_tube' => $this->input->post('con_pad_tube'),
                    'fsm_odon_22' => $this->input->post('odon_22'),
                    'fsm_con_caus_tube' => $this->input->post('con_caus_tube'),
                    'fsm_odon_21' => $this->input->post('odon_21'),
                    'fsm_padre_pad_asma' => $this->input->post('padre_pad_asma'),
                    'fsm_odon_11' => $this->input->post('odon_11'),
                    'fsm_padre_caus_asma' => $this->input->post('padre_caus_asma'),
                    'fsm_odon_12' => $this->input->post('odon_12'),
                    'fsm_abu_pad_asma' => $this->input->post('abu_pad_asma'),
                    'fsm_odon_13' => $this->input->post('odon_13'),
                    'fsm_abu_caus_asma' => $this->input->post('abu_caus_asma'),
                    'fsm_odon_14' => $this->input->post('odon_14'),
                    'fsm_tio_pad_asma' => $this->input->post('tio_pad_asma'),
                    'fsm_odon_15' => $this->input->post('odon_15'),
                    'fsm_tio_caus_asma' => $this->input->post('tio_caus_asma'),
                    'fsm_odon_16' => $this->input->post('odon_16'),
                    'fsm_her_pad_asma' => $this->input->post('her_pad_asma'),
                    'fsm_odon_17' => $this->input->post('odon_17'),
                    'fsm_her_caus_asma' => $this->input->post('her_caus_asma'),
                    'fsm_odon_18' => $this->input->post('odon_18'),
                    'fsm_hij_pad_asma' => $this->input->post('hij_pad_asma'),
                    'fsm_odon_48' => $this->input->post('odon_48'),
                    'fsm_hij_caus_asma' => $this->input->post('hij_caus_asma'),
                    'fsm_odon_47' => $this->input->post('odon_47'),
                    'fsm_con_pad_asma' => $this->input->post('con_pad_asma'),
                    'fsm_odon_46' => $this->input->post('odon_46'),
                    'fsm_con_caus_asma' => $this->input->post('con_caus_asma'),
                    'fsm_odon_45' => $this->input->post('odon_45'),
                    'fsm_padre_pad_psic' => $this->input->post('padre_pad_psic'),
                    'fsm_odon_44' => $this->input->post('odon_44'),
                    'fsm_padre_caus_psic' => $this->input->post('padre_caus_psic'),
                    'fsm_odon_43' => $this->input->post('odon_43'),
                    'fsm_abu_pad_psic' => $this->input->post('abu_pad_psic'),
                    'fsm_odon_42' => $this->input->post('odon_42'),
                    'fsm_abu_caus_psic' => $this->input->post('abu_caus_psic'),
                    'fsm_odon_41' => $this->input->post('odon_41'),
                    'fsm_tio_pad_psic' => $this->input->post('tio_pad_psic'),
                    'fsm_odon_31' => $this->input->post('odon_31'),
                    'fsm_tio_caus_psic' => $this->input->post('tio_caus_psic'),
                    'fsm_odon_32' => $this->input->post('odon_32'),
                    'fsm_her_pad_psic' => $this->input->post('her_pad_psic'),
                    'fsm_odon_33' => $this->input->post('odon_33'),
                    'fsm_her_caus_psic' => $this->input->post('her_caus_psic'),
                    'fsm_odon_34' => $this->input->post('odon_34'),
                    'fsm_hij_pad_psic' => $this->input->post('hij_pad_psic'),
                    'fsm_odon_35' => $this->input->post('odon_35'),
                    'fsm_hij_caus_psic' => $this->input->post('hij_caus_psic'),
                    'fsm_odon_36' => $this->input->post('odon_36'),
                    'fsm_con_pad_psic' => $this->input->post('con_pad_psic'),
                    'fsm_odon_37' => $this->input->post('odon_37'),
                    'fsm_con_caus_psic' => $this->input->post('con_caus_psic'),
                    'fsm_odon_38' => $this->input->post('odon_38'),
                    'fsm_toxi_mar' => $this->input->post('toxi_mar'),
                    'fsm_lab_ini_trab' => $this->input->post('lab_ini_trab'),
                    'fsm_toxi_coc' => $this->input->post('toxi_coc'),
                    'fsm_lab_emp_1' => $this->input->post('lab_emp_1'),
                    'fsm_toxi_met' => $this->input->post('toxi_met'),
                    'fsm_lab_emp_1_prod' => $this->input->post('lab_emp_1_prod'),
                    'fsm_res_eval' => $this->input->post('res_eval'),
                    'fsm_lab_emp_1_pto_trab' => $this->input->post('lab_emp_1_pto_trab'),
                    'fsm_lab_emp_1_dura_trab' => $this->input->post('lab_emp_1_dura_trab'),
                    'fsm_lab_emp_1_horas_trab' => $this->input->post('lab_emp_1_horas_trab'),
                    'fsm_lab_emp_1_extra_trab' => $this->input->post('lab_emp_1_extra_trab'),
                    'fsm_lab_emp_1_msal' => $this->input->post('lab_emp_1_msal'),
                    'fsm_lab_emp_2' => $this->input->post('lab_emp_2'),
                    'fsm_lab_emp_2_prod' => $this->input->post('lab_emp_2_prod'),
                    'fsm_lab_emp_2_pto_trab' => $this->input->post('lab_emp_2_pto_trab'),
                    'fsm_lab_emp_2_dura_trab' => $this->input->post('lab_emp_2_dura_trab'),
                    'fsm_lab_emp_2_horas_trab' => $this->input->post('lab_emp_2_horas_trab'),
                    'fsm_lab_emp_2_extra_trab' => $this->input->post('lab_emp_2_extra_trab'),
                    'fsm_lab_emp_2_msal' => $this->input->post('lab_emp_2_msal'),
                    'fsm_lab_emp_3' => $this->input->post('lab_emp_3'),
                    'fsm_lab_emp_3_prod' => $this->input->post('lab_emp_3_prod'),
                    'fsm_lab_emp_3_pto_trab' => $this->input->post('lab_emp_3_pto_trab'),
                    'fsm_lab_emp_3_dura_trab' => $this->input->post('lab_emp_3_dura_trab'),
                    'fsm_lab_emp_3_horas_trab' => $this->input->post('lab_emp_3_horas_trab'),
                    'fsm_lab_emp_3_extra_trab' => $this->input->post('lab_emp_3_extra_trab'),
                    'fsm_lab_emp_3_msal' => $this->input->post('lab_emp_3_msal'),
                    'fsm_lab_factores_cve' => $this->input->post('lab_factores_cve'),
                    'fsm_lab_factores_desc' => $this->input->post('lab_factores_desc'),
                    'fsm_lab_accidente_cve' => $this->input->post('lab_accidente_cve'),
                    'fsm_lab_accidente_obs' => $this->input->post('lab_accidente_obs'),
                    'fsm_lab_enfermedad_cve' => $this->input->post('lab_enfermedad_cve'),
                    'fsm_lab_enfermedad_obs' => $this->input->post('lab_enfermedad_obs'),
                    'fsm_lab_incapacidad_cve' => $this->input->post('lab_incapacidad_cve'),
                    'fsm_lab_incapacidad_obs' => $this->input->post('lab_incapacidad_obs'),
                    'fsm_lab_obs' => $this->input->post('lab_obs'),
                    'fsm_nopat_casa' => $this->input->post('nopat_casa'),
                    'fsm_nopat_pers_crto' => $this->input->post('nopat_pers_crto'),
                    'fsm_nopat_zoonosis' => $this->input->post('nopat_zoonosis'),
                    'fsm_nopat_serv_mun' => $this->input->post('nopat_serv_mun'),
                    'fsm_nopat_alimenta' => $this->input->post('nopat_alimenta'),
                    'fsm_nopat_banio' => $this->input->post('nopat_banio'),
                    'fsm_nopat_ropa' => $this->input->post('nopat_ropa'),
                    'fsm_nopat_dental' => $this->input->post('nopat_dental'),
                    'fsm_nopat_fuma' => $this->input->post('nopat_fuma'),
                    'fsm_nopat_fuma_cuando' => $this->input->post('nopat_fuma_cuando'),
                    'fsm_nopat_fuma_cantidad' => $this->input->post('nopat_fuma_cantidad'),
                    'fsm_nopat_toma' => $this->input->post('nopat_toma'),
                    'fsm_nopat_toma_cuando' => $this->input->post('nopat_toma_cuando'),
                    'fsm_nopat_toma_tipo' => $this->input->post('nopat_toma_tipo'),
                    'fsm_nopat_toma_cada_cuando' => $this->input->post('nopat_toma_cada_cuando'),
                    'fsm_nopat_toma_cantidad' => $this->input->post('nopat_toma_cantidad'),
                    'fsm_nopat_toma_embriaga' => $this->input->post('nopat_toma_embriaga'),
                    'fsm_nopat_toma_embriaga_frec' => $this->input->post('nopat_toma_embriaga_frec'),
                    'fsm_nopat_deporte' => $this->input->post('nopat_deporte'),
                    'fsm_nopat_deporte_obs' => $this->input->post('nopat_deporte_obs'),
                    'fsm_nopat_med' => $this->input->post('nopat_med'),
                    'fsm_nopat_med_tipo' => $this->input->post('nopat_med_tipo'),
                    'fsm_nopat_vac' => $this->input->post('nopat_vac'),
                    'fsm_nopat_vac_para' => $this->input->post('nopat_vac_para'),
                    'fsm_pat_amiba' => $this->input->post('pat_amiba'),
                    'fsm_pat_amiba_obs' => $this->input->post('pat_amiba_obs'),
                    'fsm_pat_diab' => $this->input->post('pat_diab'),
                    'fsm_pat_diab_obs' => $this->input->post('pat_diab_obs'),
                    'fsm_pat_aler' => $this->input->post('pat_aler'),
                    'fsm_pat_aler_obs' => $this->input->post('pat_aler_obs'),
                    'fsm_pat_hepa' => $this->input->post('pat_hepa'),
                    'fsm_pat_hepa_obs' => $this->input->post('pat_hepa_obs'),
                    'fsm_pat_para' => $this->input->post('pat_para'),
                    'fsm_pat_para_obs' => $this->input->post('pat_para_obs'),
                    'fsm_pat_bron' => $this->input->post('pat_bron'),
                    'fsm_pat_bron_obs' => $this->input->post('pat_bron_obs'),
                    'fsm_pat_asma' => $this->input->post('pat_asma'),
                    'fsm_pat_asma_obs' => $this->input->post('pat_asma_obs'),
                    'fsm_pat_resp' => $this->input->post('pat_resp'),
                    'fsm_pat_resp_obs' => $this->input->post('pat_resp_obs'),
                    'fsm_pat_cora' => $this->input->post('pat_cora'),
                    'fsm_pat_cora_obs' => $this->input->post('pat_cora_obs'),
                    'fsm_pat_calc' => $this->input->post('pat_calc'),
                    'fsm_pat_calc_obs' => $this->input->post('pat_calc_obs'),
                    'fsm_pat_hemo' => $this->input->post('pat_hemo'),
                    'fsm_pat_hemo_obs' => $this->input->post('pat_hemo_obs'),
                    'fsm_pat_ataq' => $this->input->post('pat_ataq'),
                    'fsm_pat_ataq_obs' => $this->input->post('pat_ataq_obs'),
                    'fsm_pat_art' => $this->input->post('pat_art'),
                    'fsm_pat_art_obs' => $this->input->post('pat_art_obs'),
                    'fsm_pat_pres_alta' => $this->input->post('pat_pres_alta'),
                    'fsm_pat_pres_alta_obs' => $this->input->post('pat_pres_alta_obs'),
                    'fsm_pat_pres_baja' => $this->input->post('pat_pres_baja'),
                    'fsm_pat_pres_baja_obs' => $this->input->post('pat_pres_baja_obs'),
                    'fsm_pat_hema' => $this->input->post('pat_hema'),
                    'fsm_pat_hema_obs' => $this->input->post('pat_hema_obs'),
                    'fsm_pat_trans' => $this->input->post('pat_trans'),
                    'fsm_pat_trans_obs' => $this->input->post('pat_trans_obs'),
                    'fsm_pat_diar' => $this->input->post('pat_diar'),
                    'fsm_pat_diar_obs' => $this->input->post('pat_diar_obs'),
                    'fsm_pat_endo' => $this->input->post('pat_endo'),
                    'fsm_pat_endo_obs' => $this->input->post('pat_endo_obs'),
                    'fsm_pat_rena' => $this->input->post('pat_rena'),
                    'fsm_pat_rena_obs' => $this->input->post('pat_rena_obs'),
                    'fsm_pat_pedi' => $this->input->post('pat_pedi'),
                    'fsm_pat_pedi_obs' => $this->input->post('pat_pedi_obs'),
                    'fsm_pat_fractura' => $this->input->post('pat_fractura'),
                    'fsm_pat_fractura_obs' => $this->input->post('pat_fractura_obs'),
                    'fsm_pat_esguince' => $this->input->post('pat_esguince'),
                    'fsm_pat_esguince_obs' => $this->input->post('pat_esguince_obs'),
                    'fsm_pat_luxa' => $this->input->post('pat_luxa'),
                    'fsm_pat_luxa_obs' => $this->input->post('pat_luxa_obs'),
                    'fsm_pat_its' => $this->input->post('pat_its'),
                    'fsm_pat_its_obs' => $this->input->post('pat_its_obs'),
                    'fsm_pat_tatu' => $this->input->post('pat_tatu'),
                    'fsm_pat_tatu_obs' => $this->input->post('pat_tatu_obs'),
                    'fsm_pat_lente' => $this->input->post('pat_lente'),
                    'fsm_pat_lente_obs' => $this->input->post('pat_lente_obs'),
                    'fsm_pat_sangre' => $this->input->post('pat_sangre'),
                    'fsm_pat_operacion' => $this->input->post('pat_operacion'),
                    'fsm_pat_operacion_obs' => $this->input->post('pat_operacion_obs'),
                    'fsm_pat_otras' => $this->input->post('pat_otras'),
                    'fsm_pat_otras_obs' => $this->input->post('pat_otras_obs'),
                    'fsm_pat_infec_sara' => $this->input->post('pat_infec_sara'),
                    'fsm_pat_infec_vari' => $this->input->post('pat_infec_vari'),
                    'fsm_pat_infec_paro' => $this->input->post('pat_infec_paro'),
                    'fsm_pat_infec_vene' => $this->input->post('pat_infec_vene'),
                    'fsm_pad_meses' => $this->input->post('pad_meses'),
                    'fsm_ef_obs_adic' => $this->input->post('ef_obs_adic'),
                    'fsm_pad_observaciones' => $this->input->post('pad_observaciones'),
                    'fsm_obs' => $this->input->post('obs'),
                    'fsm_padre_pad_oper' => $this->input->post('padre_pad_oper'),
                    'fsm_padre_caus_oper' => $this->input->post('padre_caus_oper'),
                    'fsm_abu_pad_oper' => $this->input->post('abu_pad_oper'),
                    'fsm_abu_caus_oper' => $this->input->post('abu_caus_oper'),
                    'fsm_tio_pad_oper' => $this->input->post('tio_pad_oper'),
                    'fsm_tio_caus_oper' => $this->input->post('tio_caus_oper'),
                    'fsm_her_pad_oper' => $this->input->post('her_pad_oper'),
                    'fsm_her_caus_oper' => $this->input->post('her_caus_oper'),
                    'fsm_hij_pad_oper' => $this->input->post('hij_pad_oper'),
                    'fsm_hij_caus_oper' => $this->input->post('hij_caus_oper'),
                    'fsm_con_pad_oper' => $this->input->post('con_pad_oper'),
                    'fsm_con_caus_oper' => $this->input->post('con_caus_oper'),
                    'fsm_lab_pto_trab' => $this->input->post('lab_pto_trab')
                );
                
                $data_insert = array_to_upper($data_insert);
                if($this->input->post('firma_med') != '')
                {
                    $data_insert['fsm_firma_med'] = $this->input->post('firma_med');
                }
                if($this->input->post('firma_pac') != '')
                {
                    $data_insert['fsm_firma_pac'] = $this->input->post('firma_pac');
                }
                
                if($this->historia_clinica->insert($data_insert))
                {
                    send_json_ok('Se guardó de forma correcta');
                }
                else
                {
                    send_json_error('Ocurrió un error al guardar.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
            $data['medico'] = $medico;
            $data['empresa'] = $this->cliente->get_empresa_by_id($persona['emp_id']);;
            $this->load->helper('template');
            $params_view = array(
                'title' => '',
                'view' => 'examen/historia_clinica/nuevo_form',
                'view_data' => $data 
               );
            render_template($params_view);
        }
    }
    
    function edita($cliente_id, $fsm_id)
    {
        $this->load->model('empleado/Empleado_model','empleado');
        $data['persona'] = $this->cliente->get($cliente_id);
        $data['fsm'] = $this->historia_clinica->get($fsm_id);
        $data['medico'] = $this->empleado->get_id($data['fsm']['usr_id']);
        $data['empresa'] = $this->cliente->get_empresa_by_id($data['fsm']['emp_id']);
        
        if(isset($_POST) && count($_POST) > 0)  
        {
            $this->load->library('form_validation');
           // $this->form_validation->set_rules('planta','CEDIS/Planta','required');
            $this->form_validation->set_rules('dependientes','Dependientes ecónomicos','required');
            $this->form_validation->set_rules('lugar','Lugar','required');
            
            if($this->form_validation->run())
            {
                $data_insert = array(
                    'fsm_pat_infec_rube' => $this->input->post('pat_infec_rube'),
                    'fsm_pat_infec_esca' => $this->input->post('pat_infec_esca'),
                    'fsm_pat_infec_amig' => $this->input->post('pat_infec_amig'),
                    'fsm_pat_infec_otit' => $this->input->post('pat_infec_otit'),
                    'fsm_pat_infec_tube' => $this->input->post('pat_infec_tube'),
                    'fsm_pat_infec_bron' => $this->input->post('pat_infec_bron'),
                    'fsm_pat_infec_otras' => $this->input->post('pat_infec_otras'),
                    'fsm_gine_f_ult_regla' => formatea_fecha_mysql($this->input->post('gine_f_ult_regla')),
                    'fsm_gine_dias_regla' => $this->input->post('gine_dias_regla'),
                    'fsm_gine_dura_regla' => $this->input->post('gine_dura_regla'),
                    'fsm_gine_vida_sex' => $this->input->post('gine_vida_sex'),
                    'fsm_gine_control_anti' => $this->input->post('gine_control_anti'),
                    'fsm_gine_embarazos' => $this->input->post('gine_embarazos'),
                    'fsm_gine_abortos' => $this->input->post('gine_abortos'),
                    'fsm_gine_cesarea' => $this->input->post('gine_cesarea'),
                    'fsm_gine_f_parto' => formatea_fecha_mysql($this->input->post('gine_f_parto')),
                    'fsm_lugar' => $this->input->post('lugar'),
                    'fsm_int_edo_gral' => $this->input->post('int_edo_gral'),
                    'fsm_relig_id' => $this->input->post('relig_id'),
                    'fsm_int_edo_gral_obs' => $this->input->post('int_edo_gral_obs'),
                    'fsm_planta' => $this->input->post('planta'),
                    'fsm_int_sis_endo' => $this->input->post('int_sis_endo'),
                    'fsm_dependientes' => $this->input->post('dependientes'),
                    'fsm_int_sis_endo_obs' => $this->input->post('int_sis_endo_obs'),
                    'fsm_padre_pad_diab' => $this->input->post('padre_pad_diab'),
                    'fsm_int_org_sent' => $this->input->post('int_org_sent'),
                    'fsm_padre_caus_diab' => $this->input->post('padre_caus_diab'),
                    'fsm_int_org_sent_obs' => $this->input->post('int_org_sent_obs'),
                    'fsm_abu_pad_diab' => $this->input->post('abu_pad_diab'),
                    'fsm_int_apa_dige' => $this->input->post('int_apa_dige'),
                    'fsm_abu_caus_diab' => $this->input->post('abu_caus_diab'),
                    'fsm_int_apa_dige_obs' => $this->input->post('int_apa_dige_obs'),
                    'fsm_tio_pad_diab' => $this->input->post('tio_pad_diab'),
                    'fsm_int_apa_resp' => $this->input->post('int_apa_resp'),
                    'fsm_tio_caus_diab' => $this->input->post('tio_caus_diab'),
                    'fsm_int_apa_resp_obs' => $this->input->post('int_apa_resp_obs'),
                    'fsm_her_pad_diab' => $this->input->post('her_pad_diab'),
                    'fsm_int_apa_card' => $this->input->post('int_apa_card'),
                    'fsm_her_caus_diab' => $this->input->post('her_caus_diab'),
                    'fsm_int_apa_card_obs' => $this->input->post('int_apa_card_obs'),
                    'fsm_hij_pad_diab' => $this->input->post('hij_pad_diab'),
                    'fsm_int_apa_urin' => $this->input->post('int_apa_urin'),
                    'fsm_hij_caus_diab' => $this->input->post('hij_caus_diab'),
                    'fsm_int_apa_urin_obs' => $this->input->post('int_apa_urin_obs'),
                    'fsm_con_pad_diab' => $this->input->post('con_pad_diab'),
                    'fsm_int_apa_genfem' => $this->input->post('int_apa_genfem'),
                    'fsm_con_caus_diab' => $this->input->post('con_caus_diab'),
                    'fsm_int_apa_genfem_obs' => $this->input->post('int_apa_genfem_obs'),
                    'fsm_padre_pad_obes' => $this->input->post('padre_pad_obes'),
                    'fsm_int_apa_genmas' => $this->input->post('int_apa_genmas'),
                    'fsm_padre_caus_obes' => $this->input->post('padre_caus_obes'),
                    'fsm_int_apa_genmas_obs' => $this->input->post('int_apa_genmas_obs'),
                    'fsm_abu_pad_obes' => $this->input->post('abu_pad_obes'),
                    'fsm_int_ctr_nata' => $this->input->post('int_ctr_nata'),
                    'fsm_abu_caus_obes' => $this->input->post('abu_caus_obes'),
                    'fsm_int_ctr_nata_obs' => $this->input->post('int_ctr_nata_obs'),
                    'fsm_tio_pad_obes' => $this->input->post('tio_pad_obes'),
                    'fsm_int_piel' => $this->input->post('int_piel'),
                    'fsm_tio_caus_obes' => $this->input->post('tio_caus_obes'),
                    'fsm_int_piel_obs' => $this->input->post('int_piel_obs'),
                    'fsm_her_pad_obes' => $this->input->post('her_pad_obes'),
                    'fsm_int_sis_nerv' => $this->input->post('int_sis_nerv'),
                    'fsm_her_caus_obes' => $this->input->post('her_caus_obes'),
                    'fsm_int_sis_nerv_obs' => $this->input->post('int_sis_nerv_obs'),
                    'fsm_hij_pad_obes' => $this->input->post('hij_pad_obes'),
                    'fsm_int_sis_hema' => $this->input->post('int_sis_hema'),
                    'fsm_hij_caus_obes' => $this->input->post('hij_caus_obes'),
                    'fsm_int_sis_hema_obs' => $this->input->post('int_sis_hema_obs'),
                    'fsm_con_pad_obes' => $this->input->post('con_pad_obes'),
                    'fsm_int_mus_esqu' => $this->input->post('int_mus_esqu'),
                    'fsm_con_caus_obes' => $this->input->post('con_caus_obes'),
                    'fsm_int_mus_esqu_obs' => $this->input->post('int_mus_esqu_obs'),
                    'fsm_padre_pad_cora' => $this->input->post('padre_pad_cora'),
                    'fsm_int_ant_psic' => $this->input->post('int_ant_psic'),
                    'fsm_padre_caus_cora' => $this->input->post('padre_caus_cora'),
                    'fsm_int_ant_psic_obs' => $this->input->post('int_ant_psic_obs'),
                    'fsm_abu_pad_cora' => $this->input->post('abu_pad_cora'),
                    'fsm_sg_peso' => $this->input->post('sg_peso'),
                    'fsm_abu_caus_cora' => $this->input->post('abu_caus_cora'),
                    'fsm_sg_talla' => $this->input->post('sg_talla'),
                    'fsm_tio_pad_cora' => $this->input->post('tio_pad_cora'),
                    'fsm_sg_imc' => $this->input->post('sg_imc'),
                    'fsm_tio_caus_cora' => $this->input->post('tio_caus_cora'),
                    'fsm_sg_temp' => $this->input->post('sg_temp'),
                    'fsm_her_pad_cora' => $this->input->post('her_pad_cora'),
                    'fsm_sg_fc' => $this->input->post('sg_fc'),
                    'fsm_her_caus_cora' => $this->input->post('her_caus_cora'),
                    'fsm_sg_fr' => $this->input->post('sg_fr'),
                    'fsm_hij_pad_cora' => $this->input->post('hij_pad_cora'),
                    'fsm_sg_biotipo' => $this->input->post('sg_biotipo'),
                    'fsm_hij_caus_cora' => $this->input->post('hij_caus_cora'),
                    'fsm_sg_ta' => $this->input->post('sg_ta'),
                    'fsm_sg_glu' => $this->input->post('sg_glu'),
                    'fsm_con_pad_cora' => $this->input->post('con_pad_cora'),
                    'fsm_ef_craneo' => $this->input->post('ef_craneo'),
                    'fsm_con_caus_cora' => $this->input->post('con_caus_cora'),
                    'fsm_ef_craneo_obs' => $this->input->post('ef_craneo_obs'),
                    'fsm_padre_pad_conv' => $this->input->post('padre_pad_conv'),
                    'fsm_ef_pelo' => $this->input->post('ef_pelo'),
                    'fsm_padre_caus_conv' => $this->input->post('padre_caus_conv'),
                    'fsm_ef_pelo_obs' => $this->input->post('ef_pelo_obs'),
                    'fsm_abu_pad_conv' => $this->input->post('abu_pad_conv'),
                    'fsm_ef_oido_der' => $this->input->post('ef_oido_der'),
                    'fsm_abu_caus_conv' => $this->input->post('abu_caus_conv'),
                    'fsm_ef_crom_od_af' => $this->input->post('ef_crom_od_af'),
                    'fsm_tio_pad_conv' => $this->input->post('tio_pad_conv'),
                    'fsm_ef_camp_od_af' => $this->input->post('ef_camp_od_af'),
                    'fsm_tio_caus_conv' => $this->input->post('tio_caus_conv'),
                    'fsm_ef_crom_od_al' => $this->input->post('ef_crom_od_al'),
                    'fsm_her_pad_conv' => $this->input->post('her_pad_conv'),
                    'fsm_ef_camp_od_al' => $this->input->post('ef_camp_od_al'),
                    'fsm_her_caus_conv' => $this->input->post('her_caus_conv'),
                    'fsm_ef_oido_der_obs' => $this->input->post('ef_oido_der_obs'),
                    'fsm_hij_pad_conv' => $this->input->post('hij_pad_conv'),
                    'fsm_ef_oido_izq' => $this->input->post('ef_oido_izq'),
                    'fsm_hij_caus_conv' => $this->input->post('hij_caus_conv'),
                    'fsm_ef_crom_oi_af' => $this->input->post('ef_crom_oi_af'),
                    'fsm_con_pad_conv' => $this->input->post('con_pad_conv'),
                    'fsm_ef_camp_oi_af' => $this->input->post('ef_camp_oi_af'),
                    'fsm_con_caus_conv' => $this->input->post('con_caus_conv'),
                    'fsm_ef_crom_oi_al' => $this->input->post('ef_crom_oi_al'),
                    'fsm_padre_pad_pres' => $this->input->post('padre_pad_pres'),
                    'fsm_ef_camp_oi_al' => $this->input->post('ef_camp_oi_al'),
                    'fsm_padre_caus_pres' => $this->input->post('padre_caus_pres'),
                    'fsm_ef_oido_izq_obs' => $this->input->post('ef_oido_izq_obs'),
                    'fsm_abu_pad_pres' => $this->input->post('abu_pad_pres'),
                    'fsm_ef_webber' => $this->input->post('ef_webber'),
                    'fsm_abu_caus_pres' => $this->input->post('abu_caus_pres'),
                    'fsm_ef_webber_obs' => $this->input->post('ef_webber_obs'),
                    'fsm_tio_pad_pres' => $this->input->post('tio_pad_pres'),
                    'fsm_ef_rinne' => $this->input->post('ef_rinne'),
                    'fsm_tio_caus_pres' => $this->input->post('tio_caus_pres'),
                    'fsm_ef_rinne_obs' => $this->input->post('ef_rinne_obs'),
                    'fsm_her_pad_pres' => $this->input->post('her_pad_pres'),
                    'fsm_ef_visual_od' => $this->input->post('ef_visual_od'),
                    'fsm_ef_visual_od_obs' => $this->input->post('ef_visual_od_obs'),
                    'fsm_her_caus_pres' => $this->input->post('her_caus_pres'),
                    'fsm_ef_visual_oi' => $this->input->post('ef_visual_oi'),
                    'fsm_ef_visual_oi_obs' => $this->input->post('ef_visual_oi_obs'),
                    'fsm_hij_pad_pres' => $this->input->post('hij_pad_pres'),
                    'fsm_ef_visual_ao' => $this->input->post('ef_visual_ao'),
                    'fsm_ef_visual_ao_obs' => $this->input->post('ef_visual_ao_obs'),
                    'fsm_hij_caus_pres' => $this->input->post('hij_caus_pres'),
                    'fsm_ef_nariz' => $this->input->post('ef_nariz'),
                    'fsm_con_pad_pres' => $this->input->post('con_pad_pres'),
                    'fsm_ef_nariz_obs' => $this->input->post('ef_nariz_obs'),
                    'fsm_con_caus_pres' => $this->input->post('con_caus_pres'),
                    'fsm_ef_labios' => $this->input->post('ef_labios'),
                    'fsm_padre_pad_rino' => $this->input->post('padre_pad_rino'),
                    'fsm_ef_labios_obs' => $this->input->post('ef_labios_obs'),
                    'fsm_padre_caus_rino' => $this->input->post('padre_caus_rino'),
                    'fsm_ef_mucosas' => $this->input->post('ef_mucosas'),
                    'fsm_abu_pad_rino' => $this->input->post('abu_pad_rino'),
                    'fsm_ef_mucosas_obs' => $this->input->post('ef_mucosas_obs'),
                    'fsm_abu_caus_rino' => $this->input->post('abu_caus_rino'),
                    'fsm_ef_dientes' => $this->input->post('ef_dientes'),
                    'fsm_tio_pad_rino' => $this->input->post('tio_pad_rino'),
                    'fsm_ef_dientes_obs' => $this->input->post('ef_dientes_obs'),
                    'fsm_tio_caus_rino' => $this->input->post('tio_caus_rino'),
                    'fsm_ef_faringe' => $this->input->post('ef_faringe'),
                    'fsm_her_pad_rino' => $this->input->post('her_pad_rino'),
                    'fsm_ef_faringe_obs' => $this->input->post('ef_faringe_obs'),
                    'fsm_her_caus_rino' => $this->input->post('her_caus_rino'),
                    'fsm_ef_amigdalas' => $this->input->post('ef_amigdalas'),
                    'fsm_hij_pad_rino' => $this->input->post('hij_pad_rino'),
                    'fsm_ef_amigdalas_obs' => $this->input->post('ef_amigdalas_obs'),
                    'fsm_ef_cuello' => $this->input->post('ef_cuello'),
                    'fsm_ef_cuello_obs' => $this->input->post('ef_cuello_obs'),
                    'fsm_hij_caus_rino' => $this->input->post('hij_caus_rino'),
                    'fsm_ef_tiroides' => $this->input->post('ef_tiroides'),
                    'fsm_con_pad_rino' => $this->input->post('con_pad_rino'),
                    'fsm_ef_tiroides_obs' => $this->input->post('ef_tiroides_obs'),
                    'fsm_con_caus_rino' => $this->input->post('con_caus_rino'),
                    'fsm_ef_torax' => $this->input->post('ef_torax'),
                    'fsm_padre_pad_canc' => $this->input->post('padre_pad_canc'),
                    'fsm_ef_torax_obs' => $this->input->post('ef_torax_obs'),
                    'fsm_padre_caus_canc' => $this->input->post('padre_caus_canc'),
                    'fsm_ef_extre_sup' => $this->input->post('ef_extre_sup'),
                    'fsm_abu_pad_canc' => $this->input->post('abu_pad_canc'),
                    'fsm_ef_extre_sup_obs' => $this->input->post('ef_extre_sup_obs'),
                    'fsm_abu_caus_canc' => $this->input->post('abu_caus_canc'),
                    'fsm_ef_abdomen' => $this->input->post('ef_abdomen'),
                    'fsm_tio_pad_canc' => $this->input->post('tio_pad_canc'),
                    'fsm_ef_abdomen_obs' => $this->input->post('ef_abdomen_obs'),
                    'fsm_tio_caus_canc' => $this->input->post('tio_caus_canc'),
                    'fsm_ef_genitales' => $this->input->post('ef_genitales'),
                    'fsm_her_pad_canc' => $this->input->post('her_pad_canc'),
                    'fsm_ef_genitales_obs' => $this->input->post('ef_genitales_obs'),
                    'fsm_her_caus_canc' => $this->input->post('her_caus_canc'),
                    'fsm_ef_extre_inf' => $this->input->post('ef_extre_inf'),
                    'fsm_hij_pad_canc' => $this->input->post('hij_pad_canc'),
                    'fsm_ef_extre_inf_obs' => $this->input->post('ef_extre_inf_obs'),
                    'fsm_hij_caus_canc' => $this->input->post('hij_caus_canc'),
                    'fsm_ef_columna_lumb' => $this->input->post('ef_columna_lumb'),
                    'fsm_con_pad_canc' => $this->input->post('con_pad_canc'),
                    'fsm_ef_columna_lumb_obs' => $this->input->post('ef_columna_lumb_obs'),
                    'fsm_con_caus_canc' => $this->input->post('con_caus_canc'),
                    'fsm_ef_piel' => $this->input->post('ef_piel'),
                    'fsm_padre_pad_tube' => $this->input->post('padre_pad_tube'),
                    'fsm_ef_piel_obs' => $this->input->post('ef_piel_obs'),
                    'fsm_padre_caus_tube' => $this->input->post('padre_caus_tube'),
                    'fsm_ef_tatu' => $this->input->post('ef_tatu'),
                    'fsm_abu_pad_tube' => $this->input->post('abu_pad_tube'),
                    'fsm_ef_tatu_obs' => $this->input->post('ef_tatu_obs'),
                    'fsm_abu_caus_tube' => $this->input->post('abu_caus_tube'),
                    'fsm_tio_pad_tube' => $this->input->post('tio_pad_tube'),
                    'fsm_odon_28' => $this->input->post('odon_28'),
                    'fsm_tio_caus_tube' => $this->input->post('tio_caus_tube'),
                    'fsm_odon_27' => $this->input->post('odon_27'),
                    'fsm_her_pad_tube' => $this->input->post('her_pad_tube'),
                    'fsm_odon_26' => $this->input->post('odon_26'),
                    'fsm_her_caus_tube' => $this->input->post('her_caus_tube'),
                    'fsm_odon_25' => $this->input->post('odon_25'),
                    'fsm_hij_pad_tube' => $this->input->post('hij_pad_tube'),
                    'fsm_odon_24' => $this->input->post('odon_24'),
                    'fsm_hij_caus_tube' => $this->input->post('hij_caus_tube'),
                    'fsm_odon_23' => $this->input->post('odon_23'),
                    'fsm_con_pad_tube' => $this->input->post('con_pad_tube'),
                    'fsm_odon_22' => $this->input->post('odon_22'),
                    'fsm_con_caus_tube' => $this->input->post('con_caus_tube'),
                    'fsm_odon_21' => $this->input->post('odon_21'),
                    'fsm_padre_pad_asma' => $this->input->post('padre_pad_asma'),
                    'fsm_odon_11' => $this->input->post('odon_11'),
                    'fsm_padre_caus_asma' => $this->input->post('padre_caus_asma'),
                    'fsm_odon_12' => $this->input->post('odon_12'),
                    'fsm_abu_pad_asma' => $this->input->post('abu_pad_asma'),
                    'fsm_odon_13' => $this->input->post('odon_13'),
                    'fsm_abu_caus_asma' => $this->input->post('abu_caus_asma'),
                    'fsm_odon_14' => $this->input->post('odon_14'),
                    'fsm_tio_pad_asma' => $this->input->post('tio_pad_asma'),
                    'fsm_odon_15' => $this->input->post('odon_15'),
                    'fsm_tio_caus_asma' => $this->input->post('tio_caus_asma'),
                    'fsm_odon_16' => $this->input->post('odon_16'),
                    'fsm_her_pad_asma' => $this->input->post('her_pad_asma'),
                    'fsm_odon_17' => $this->input->post('odon_17'),
                    'fsm_her_caus_asma' => $this->input->post('her_caus_asma'),
                    'fsm_odon_18' => $this->input->post('odon_18'),
                    'fsm_hij_pad_asma' => $this->input->post('hij_pad_asma'),
                    'fsm_odon_48' => $this->input->post('odon_48'),
                    'fsm_hij_caus_asma' => $this->input->post('hij_caus_asma'),
                    'fsm_odon_47' => $this->input->post('odon_47'),
                    'fsm_con_pad_asma' => $this->input->post('con_pad_asma'),
                    'fsm_odon_46' => $this->input->post('odon_46'),
                    'fsm_con_caus_asma' => $this->input->post('con_caus_asma'),
                    'fsm_odon_45' => $this->input->post('odon_45'),
                    'fsm_padre_pad_psic' => $this->input->post('padre_pad_psic'),
                    'fsm_odon_44' => $this->input->post('odon_44'),
                    'fsm_padre_caus_psic' => $this->input->post('padre_caus_psic'),
                    'fsm_odon_43' => $this->input->post('odon_43'),
                    'fsm_abu_pad_psic' => $this->input->post('abu_pad_psic'),
                    'fsm_odon_42' => $this->input->post('odon_42'),
                    'fsm_abu_caus_psic' => $this->input->post('abu_caus_psic'),
                    'fsm_odon_41' => $this->input->post('odon_41'),
                    'fsm_tio_pad_psic' => $this->input->post('tio_pad_psic'),
                    'fsm_odon_31' => $this->input->post('odon_31'),
                    'fsm_tio_caus_psic' => $this->input->post('tio_caus_psic'),
                    'fsm_odon_32' => $this->input->post('odon_32'),
                    'fsm_her_pad_psic' => $this->input->post('her_pad_psic'),
                    'fsm_odon_33' => $this->input->post('odon_33'),
                    'fsm_her_caus_psic' => $this->input->post('her_caus_psic'),
                    'fsm_odon_34' => $this->input->post('odon_34'),
                    'fsm_hij_pad_psic' => $this->input->post('hij_pad_psic'),
                    'fsm_odon_35' => $this->input->post('odon_35'),
                    'fsm_hij_caus_psic' => $this->input->post('hij_caus_psic'),
                    'fsm_odon_36' => $this->input->post('odon_36'),
                    'fsm_con_pad_psic' => $this->input->post('con_pad_psic'),
                    'fsm_odon_37' => $this->input->post('odon_37'),
                    'fsm_con_caus_psic' => $this->input->post('con_caus_psic'),
                    'fsm_odon_38' => $this->input->post('odon_38'),
                    'fsm_toxi_mar' => $this->input->post('toxi_mar'),
                    'fsm_lab_ini_trab' => $this->input->post('lab_ini_trab'),
                    'fsm_toxi_coc' => $this->input->post('toxi_coc'),
                    'fsm_lab_emp_1' => $this->input->post('lab_emp_1'),
                    'fsm_toxi_met' => $this->input->post('toxi_met'),
                    'fsm_lab_emp_1_prod' => $this->input->post('lab_emp_1_prod'),
                    'fsm_res_eval' => $this->input->post('res_eval'),
                    'fsm_lab_emp_1_pto_trab' => $this->input->post('lab_emp_1_pto_trab'),
                    'fsm_lab_emp_1_dura_trab' => $this->input->post('lab_emp_1_dura_trab'),
                    'fsm_lab_emp_1_horas_trab' => $this->input->post('lab_emp_1_horas_trab'),
                    'fsm_lab_emp_1_extra_trab' => $this->input->post('lab_emp_1_extra_trab'),
                    'fsm_lab_emp_1_msal' => $this->input->post('lab_emp_1_msal'),
                    'fsm_lab_emp_2' => $this->input->post('lab_emp_2'),
                    'fsm_lab_emp_2_prod' => $this->input->post('lab_emp_2_prod'),
                    'fsm_lab_emp_2_pto_trab' => $this->input->post('lab_emp_2_pto_trab'),
                    'fsm_lab_emp_2_dura_trab' => $this->input->post('lab_emp_2_dura_trab'),
                    'fsm_lab_emp_2_horas_trab' => $this->input->post('lab_emp_2_horas_trab'),
                    'fsm_lab_emp_2_extra_trab' => $this->input->post('lab_emp_2_extra_trab'),
                    'fsm_lab_emp_2_msal' => $this->input->post('lab_emp_2_msal'),
                    'fsm_lab_emp_3' => $this->input->post('lab_emp_3'),
                    'fsm_lab_emp_3_prod' => $this->input->post('lab_emp_3_prod'),
                    'fsm_lab_emp_3_pto_trab' => $this->input->post('lab_emp_3_pto_trab'),
                    'fsm_lab_emp_3_dura_trab' => $this->input->post('lab_emp_3_dura_trab'),
                    'fsm_lab_emp_3_horas_trab' => $this->input->post('lab_emp_3_horas_trab'),
                    'fsm_lab_emp_3_extra_trab' => $this->input->post('lab_emp_3_extra_trab'),
                    'fsm_lab_emp_3_msal' => $this->input->post('lab_emp_3_msal'),
                    'fsm_lab_factores_cve' => $this->input->post('lab_factores_cve'),
                    'fsm_lab_factores_desc' => $this->input->post('lab_factores_desc'),
                    'fsm_lab_accidente_cve' => $this->input->post('lab_accidente_cve'),
                    'fsm_lab_accidente_obs' => $this->input->post('lab_accidente_obs'),
                    'fsm_lab_enfermedad_cve' => $this->input->post('lab_enfermedad_cve'),
                    'fsm_lab_enfermedad_obs' => $this->input->post('lab_enfermedad_obs'),
                    'fsm_lab_incapacidad_cve' => $this->input->post('lab_incapacidad_cve'),
                    'fsm_lab_incapacidad_obs' => $this->input->post('lab_incapacidad_obs'),
                    'fsm_lab_obs' => $this->input->post('lab_obs'),
                    'fsm_nopat_casa' => $this->input->post('nopat_casa'),
                    'fsm_nopat_pers_crto' => $this->input->post('nopat_pers_crto'),
                    'fsm_nopat_zoonosis' => $this->input->post('nopat_zoonosis'),
                    'fsm_nopat_serv_mun' => $this->input->post('nopat_serv_mun'),
                    'fsm_nopat_alimenta' => $this->input->post('nopat_alimenta'),
                    'fsm_nopat_banio' => $this->input->post('nopat_banio'),
                    'fsm_nopat_ropa' => $this->input->post('nopat_ropa'),
                    'fsm_nopat_dental' => $this->input->post('nopat_dental'),
                    'fsm_nopat_fuma' => $this->input->post('nopat_fuma'),
                    'fsm_nopat_fuma_cuando' => $this->input->post('nopat_fuma_cuando'),
                    'fsm_nopat_fuma_cantidad' => $this->input->post('nopat_fuma_cantidad'),
                    'fsm_nopat_toma' => $this->input->post('nopat_toma'),
                    'fsm_nopat_toma_cuando' => $this->input->post('nopat_toma_cuando'),
                    'fsm_nopat_toma_tipo' => $this->input->post('nopat_toma_tipo'),
                    'fsm_nopat_toma_cada_cuando' => $this->input->post('nopat_toma_cada_cuando'),
                    'fsm_nopat_toma_cantidad' => $this->input->post('nopat_toma_cantidad'),
                    'fsm_nopat_toma_embriaga' => $this->input->post('nopat_toma_embriaga'),
                    'fsm_nopat_toma_embriaga_frec' => $this->input->post('nopat_toma_embriaga_frec'),
                    'fsm_nopat_deporte' => $this->input->post('nopat_deporte'),
                    'fsm_nopat_deporte_obs' => $this->input->post('nopat_deporte_obs'),
                    'fsm_nopat_med' => $this->input->post('nopat_med'),
                    'fsm_nopat_med_tipo' => $this->input->post('nopat_med_tipo'),
                    'fsm_nopat_vac' => $this->input->post('nopat_vac'),
                    'fsm_nopat_vac_para' => $this->input->post('nopat_vac_para'),
                    'fsm_pat_amiba' => $this->input->post('pat_amiba'),
                    'fsm_pat_amiba_obs' => $this->input->post('pat_amiba_obs'),
                    'fsm_pat_diab' => $this->input->post('pat_diab'),
                    'fsm_pat_diab_obs' => $this->input->post('pat_diab_obs'),
                    'fsm_pat_aler' => $this->input->post('pat_aler'),
                    'fsm_pat_aler_obs' => $this->input->post('pat_aler_obs'),
                    'fsm_pat_hepa' => $this->input->post('pat_hepa'),
                    'fsm_pat_hepa_obs' => $this->input->post('pat_hepa_obs'),
                    'fsm_pat_para' => $this->input->post('pat_para'),
                    'fsm_pat_para_obs' => $this->input->post('pat_para_obs'),
                    'fsm_pat_bron' => $this->input->post('pat_bron'),
                    'fsm_pat_bron_obs' => $this->input->post('pat_bron_obs'),
                    'fsm_pat_asma' => $this->input->post('pat_asma'),
                    'fsm_pat_asma_obs' => $this->input->post('pat_asma_obs'),
                    'fsm_pat_resp' => $this->input->post('pat_resp'),
                    'fsm_pat_resp_obs' => $this->input->post('pat_resp_obs'),
                    'fsm_pat_cora' => $this->input->post('pat_cora'),
                    'fsm_pat_cora_obs' => $this->input->post('pat_cora_obs'),
                    'fsm_pat_calc' => $this->input->post('pat_calc'),
                    'fsm_pat_calc_obs' => $this->input->post('pat_calc_obs'),
                    'fsm_pat_hemo' => $this->input->post('pat_hemo'),
                    'fsm_pat_hemo_obs' => $this->input->post('pat_hemo_obs'),
                    'fsm_pat_ataq' => $this->input->post('pat_ataq'),
                    'fsm_pat_ataq_obs' => $this->input->post('pat_ataq_obs'),
                    'fsm_pat_art' => $this->input->post('pat_art'),
                    'fsm_pat_art_obs' => $this->input->post('pat_art_obs'),
                    'fsm_pat_pres_alta' => $this->input->post('pat_pres_alta'),
                    'fsm_pat_pres_alta_obs' => $this->input->post('pat_pres_alta_obs'),
                    'fsm_pat_pres_baja' => $this->input->post('pat_pres_baja'),
                    'fsm_pat_pres_baja_obs' => $this->input->post('pat_pres_baja_obs'),
                    'fsm_pat_hema' => $this->input->post('pat_hema'),
                    'fsm_pat_hema_obs' => $this->input->post('pat_hema_obs'),
                    'fsm_pat_trans' => $this->input->post('pat_trans'),
                    'fsm_pat_trans_obs' => $this->input->post('pat_trans_obs'),
                    'fsm_pat_diar' => $this->input->post('pat_diar'),
                    'fsm_pat_diar_obs' => $this->input->post('pat_diar_obs'),
                    'fsm_pat_endo' => $this->input->post('pat_endo'),
                    'fsm_pat_endo_obs' => $this->input->post('pat_endo_obs'),
                    'fsm_pat_rena' => $this->input->post('pat_rena'),
                    'fsm_pat_rena_obs' => $this->input->post('pat_rena_obs'),
                    'fsm_pat_pedi' => $this->input->post('pat_pedi'),
                    'fsm_pat_pedi_obs' => $this->input->post('pat_pedi_obs'),
                    'fsm_pat_fractura' => $this->input->post('pat_fractura'),
                    'fsm_pat_fractura_obs' => $this->input->post('pat_fractura_obs'),
                    'fsm_pat_esguince' => $this->input->post('pat_esguince'),
                    'fsm_pat_esguince_obs' => $this->input->post('pat_esguince_obs'),
                    'fsm_pat_luxa' => $this->input->post('pat_luxa'),
                    'fsm_pat_luxa_obs' => $this->input->post('pat_luxa_obs'),
                    'fsm_pat_its' => $this->input->post('pat_its'),
                    'fsm_pat_its_obs' => $this->input->post('pat_its_obs'),
                    'fsm_pat_tatu' => $this->input->post('pat_tatu'),
                    'fsm_pat_tatu_obs' => $this->input->post('pat_tatu_obs'),
                    'fsm_pat_lente' => $this->input->post('pat_lente'),
                    'fsm_pat_lente_obs' => $this->input->post('pat_lente_obs'),
                    'fsm_pat_sangre' => $this->input->post('pat_sangre'),
                    'fsm_pat_operacion' => $this->input->post('pat_operacion'),
                    'fsm_pat_operacion_obs' => $this->input->post('pat_operacion_obs'),
                    'fsm_pat_otras' => $this->input->post('pat_otras'),
                    'fsm_pat_otras_obs' => $this->input->post('pat_otras_obs'),
                    'fsm_pat_infec_sara' => $this->input->post('pat_infec_sara'),
                    'fsm_pat_infec_vari' => $this->input->post('pat_infec_vari'),
                    'fsm_pat_infec_paro' => $this->input->post('pat_infec_paro'),
                    'fsm_pat_infec_vene' => $this->input->post('pat_infec_vene'),
                    'fsm_pad_meses' => $this->input->post('pad_meses'),
                    'fsm_ef_obs_adic' => $this->input->post('ef_obs_adic'),
                    'fsm_pad_observaciones' => $this->input->post('pad_observaciones'),
                    'fsm_obs' => $this->input->post('obs'),
                    'fsm_padre_pad_oper' => $this->input->post('padre_pad_oper'),
                    'fsm_padre_caus_oper' => $this->input->post('padre_caus_oper'),
                    'fsm_abu_pad_oper' => $this->input->post('abu_pad_oper'),
                    'fsm_abu_caus_oper' => $this->input->post('abu_caus_oper'),
                    'fsm_tio_pad_oper' => $this->input->post('tio_pad_oper'),
                    'fsm_tio_caus_oper' => $this->input->post('tio_caus_oper'),
                    'fsm_her_pad_oper' => $this->input->post('her_pad_oper'),
                    'fsm_her_caus_oper' => $this->input->post('her_caus_oper'),
                    'fsm_hij_pad_oper' => $this->input->post('hij_pad_oper'),
                    'fsm_hij_caus_oper' => $this->input->post('hij_caus_oper'),
                    'fsm_con_pad_oper' => $this->input->post('con_pad_oper'),
                    'fsm_con_caus_oper' => $this->input->post('con_caus_oper'),
                    'fsm_lab_pto_trab' => $this->input->post('lab_pto_trab')
                );
                
                $data_insert = array_to_upper($data_insert);
                if($this->input->post('firma_med') != '')
                {
                    $data_insert['fsm_firma_med'] = $this->input->post('firma_med');
                }
                if($this->input->post('firma_pac') != '')
                {
                    $data_insert['fsm_firma_pac'] = $this->input->post('firma_pac');
                }
                
                if($this->historia_clinica->update($fsm_id, $data_insert))
                {
                    send_json_ok('Se actualizó de forma correcta');
                }
                else
                {
                    send_json_error('Ocurrió un error al actualizar.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $this->load->helper('template');
            $params_view = array(
                'title' => '',
                'view' => 'examen/historia_clinica/edita_form',
                'view_data' => $data 
               );
            render_template($params_view);
        }
    }
    
    
    public function pdf($cliente_id, $fsm_id)
    {
        $data['persona'] = $this->cliente->get($cliente_id,get_desp_id_usr()); 
        $data['medico'] = $this->session->user;
        $data['fsm'] = $this->historia_clinica->get($fsm_id,get_desp_id_usr());
        $data['empresa'] = $this->cliente->get_empresa_by_id($data['fsm']['emp_id']);
        $html = $this->load->view('examen/historia_clinica/pdf',$data,TRUE);
        $this->load->helper('pdf');
        genera_pdf($html,'historia_clinica','historia_clinica','historia_clinica');
    }
    
    public function firma_lala($fsm_id)
    {
        $data_update['firma'] = $this->input->post('firma');
        if($this->cliente->update_lala($fsm_id ,$data_update))
        {
            send_json_ok('Se firmó de forma correcta');
        }
        else
        {
            send_json_error('Ocurrió un error al actualizar.');
        }
    }
}