<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Prestamo extends CI_Controller {
    function __construct() {
        parent::__construct();
        $this->load->model('persona/Persona_model','cliente');
		
		/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
		$this->load->model('servicio/Servicio_model','servicio');
		/*************************************************/			
        $this->load->model('empleado/Empleado_model','medico');
        $this->load->model('examen/Prestamo_model','prestamo');
		$this->load->helper('util');
    }
    
    public function nuevo($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
        $user = $this->session->user;
		
       
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('sueldo_mes','Sueldo neto percibido al mes','required');
            $this->form_validation->set_rules('monto_sol','Monto del préstamo a solicitar','required');
           
            if($this->form_validation->run())
            {
                /*$data_insert['usr_id']  = $medico['usr_id'];
                $data_insert['med_id']  = $medico['usr_id'];
                $data_insert['clte_id'] = $persona['clte_id'];
                $data_insert['emp_id']  = $persona['emp_id'];
                $data_insert['pie_medico_sol'] = $this->input->post('medico_sol');
                $data_insert['pie_f_recibido']   =  formatea_fecha_mysql($this->input->post('f_recibido'));
                $data_insert['pie_f_impresion']  =  formatea_fecha_mysql($this->input->post('f_impresion'));
				$data_insert['pie_fis_resultado']= $this->input->post('fis_resultado');
				$data_insert['pie_lab'] = $this->input->post('laboratorista');                			
                $data_insert['pie_obs']= $this->input->post('pie_obs');*/
				
				
                //informncion general de la pérsona
				$data_insert['clte_id'] =  $persona['clte_id'];
				$data_insert['usr_id'] =  $user['usr_id'];
				$data_insert['f_registro'] =  date('Y-m-d H:i:s');
				$data_insert['f_ingreso'] = formatea_fecha_mysql($this->input->post('f_ingreso'));
				$data_insert['f_inicial'] = formatea_fecha_mysql($this->input->post('f_inicial'));
				$data_insert['f_final'] = formatea_fecha_mysql($this->input->post('f_final'));				
                $data_insert['sueldo_mes'] =  $this->input->post('sueldo_mes');
                $data_insert['monto_sol'] =  $this->input->post('monto_sol');
                $data_insert['autorizado'] =  $this->input->post('autorizado');
                $data_insert['emp_id'] =  $user['emp_id']; 				

				$data_insert=array_to_upper($data_insert);					
                if($this->prestamo->insert($data_insert))
                {
                    send_json_ok('Se guardó de forma correcta');
                }
                else
                {
                    send_json_error('Ocurrió un error al guardar.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
            $data['medico'] = $medico;
            $this->load->helper('template');
            $params_view = array(
                'title' => '',
                'view' => 'examen/prestamo/nuevo_form',
                'view_data' => $data 
               );
            render_template($params_view);
        }
    }
    
    public function pdf($cliente_id, $fsm_id)
    {
        $data['persona'] = $this->cliente->get($cliente_id,get_desp_id_usr());
		
        $data['fsm'] = $this->prestamo->get($fsm_id,get_desp_id_usr());
        $data['medico'] = $this->medico->get_id($data['fsm']['med_id']);
        $data['empresa'] = $this->cliente->get_empresa_by_id($data['fsm']['emp_id']);
        $this->load->helper('pdf');

		$med_name='fulano';
		$emp_id=$data['fsm']['emp_id'];
		$observaciones=$data['fsm']['pie_obs'];
		$data_empresa = $this->cliente->get_empresa_by_id($emp_id);
		$ruta=base_url('../dist/images/hclogo.jpg');
		
		$fecha_entrada = strtotime($data['fsm']['f_registro']);
		$fecha_vigente = strtotime("2022-04-29 00:00:00");
		
		 
		if  ($fecha_entrada > $fecha_vigente)
		{	
		genera_pdf_documento2($this->load->view('examen/prestamo/pdf',$data,TRUE),'prestamo','prestamo','prestamo','Humancenter Review S.A de C.V.','P',$ruta);
		}
		else
		{	
		genera_pdf_documento2($this->load->view('examen/prestamo/pdf_antes_29_04_22',$data,TRUE),'prestamo','prestamo','prestamo','Humancenter Review S.A de C.V.','P',$ruta);
		}
	}

    public function borra_pie($fsm_id)
    {
        if($this->prestamo->delete_pie($fsm_id))
        {
            send_json_ok('Se eliminó de forma correcta.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar.');
        }
    }


}