<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Toxicologico7 extends CI_Controller {
    function __construct() {
        parent::__construct();
        $this->load->model('persona/Persona_model','cliente');
        $this->load->model('empleado/Empleado_model','medico');
		$this->load->model('servicio/Servicio_model','servicio');
        $this->load->model('examen/Toxicologico_model7','toxicologico7');
		$this->load->helper('util');
		$this->load->helper('report');		
    }
 
 
     public function edita_serviseg($cliente_id, $fsm_id)
    {
		$this->load->model('empleado/Empleado_model','empleado');
        $persona = $this->cliente->get($cliente_id);
        $user = $this->session->user;
		$data['fsm'] = $this->toxicologico7->get($fsm_id);
        $medico = $this->empleado->get_id($data['fsm']['med_id']);
        $empresa = $this->cliente->get_empresa_by_id($data['fsm']['emp_id']);
		
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
           
            if(true)
            {
	
				$data_insert['fsm_anf_cve'] = $this->input->post('anf');
                $data_insert['fsm_coc_cve'] = $this->input->post('coc');
                $data_insert['fsm_mar_cve'] = $this->input->post('mar');
                $data_insert['fsm_opi_cve'] = $this->input->post('opi');
                $data_insert['fsm_pcp_cve'] = $this->input->post('pcp');
                $data_insert['fsm_bzd_cve'] = $this->input->post('bzd');             
                $data_insert['fsm_bar_cve'] = $this->input->post('bar');
				$data_insert['fsm_f']   = $this->input->post('fecha_eva');
				$data_insert['log_insrt_f']  = $data_insert['fsm_f'];  
				$data_insert['log_updt_f']=  date('Y-m-d H:i:s');				

                $this->db->trans_start();
               
                if($this->toxicologico7->update($fsm_id, $data_insert))
                {
                   send_json_ok('Se guardó de forma correcta');
                }
                else
                {
                    send_json_error('Ocurrió un error al guardar.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
            $data['medico'] = $medico;
			$data['empresa'] = $empresa;
            $this->load->helper('template');
            $params_view = array(
                'title' => '',
                'view' => 'examen/toxicologico/edita_form_serviseg7',
                'view_data' => $data 
               );
            render_template($params_view);
        }
    }
 
 
	public function spy($cliente_id, $fsm_id) 
    {

        $persona = $this->cliente->get($cliente_id,get_desp_id_usr());
        $fsm = $this->toxicologico7->get($fsm_id,get_desp_id_usr());
        $medico = $this->medico->get_id($data['fsm']['med_id']);
        $empresa = $this->cliente->get_empresa_by_id($data['fsm']['emp_id']);
		$user = $this->session->user;
		$usuario = $this->medico->get($user['usr_id']);	
		
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');

			if (($persona['serv_id'] == 0) /* ||(get_status_serv($persona['serv_id']) != 'PROCESO') */)
			{					
					$this->form_validation->set_rules('servicio','Orden de servicio','required');
			}
			else
			{
					$this->form_validation->set_rules('servicio','Orden de servicio','integer');
			}

            if($this->form_validation->run())
            {


				if (($persona['serv_id'] == 0) /*|| (get_status_serv($persona['serv_id']) != 'PROCESO') */)
				{	
						$data_insert['serv_id']  = $this->input->post('servicio');
				}
				else
				{	
						$data_insert['serv_id']  = $persona['serv_id'];
				}
			
			/*	$data_insert['clte_id'] = $persona['clte_id'];
				$data_insert['emp_id'] = $persona['emp_id'];
				$data_insert['suc_id'] = $persona['suc_id'];
                $data_insert['med_id'] = $this->input->post('medicos'); 
                $data_insert['usr_id']  = $user['usr_id'];
			*/	
				
				 $data_insert['fsm_f']   =  $this->input->post('f_registro');
				 $data_insert['log_insrt_f']   =  $this->input->post('f_registro');
				 $data_insert['log_insrt_usr_cve']   =  $usuario['usr_username'];
				 $data_insert['log_insrt_prg']   =  "FUE SPY";
				 
				 

 			/*	$data_insert['log_insrt_f']   = date("Y-m-d H:i:s");  
				$data_insert['log_insrt_usr_cve']   =  $user['usr_id'];  	
				$data_insert['log_updt_f']   =  $data_insert['fsm_f'];*/ 		
				$data_insert['log_updt_usr_cve']   =  $fsm['log_updt_usr_cve'] + 1; ;	
			
				
			/*	$data_insert['fsm_observaciones']=$this->input->post('ex_obs');*/
				
				$data_insert=array_to_upper($data_insert);

			
		        if($this->toxicologico7->update($fsm_id,$data_insert))
                {
                    send_json_ok('Se guardó de forma correcta.');
                }
                else
                {
                    send_json_error('Ocurrió un error al guardar.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        { 
			$data['persona'] =$persona ;
			$data['fsm'] = $fsm;
			$data['medico'] = $medico;
			$data['empresa'] = $empresa;
			$data['usuario'] = $usuario;
			$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);
            $this->load->helper('template');
            $params_view = array(
                'title' => '',
                'view' => 'examen/toxicologico/spy',
                'view_data' => $data 
               );
            render_template($params_view);
        }
    }



 
    public function nuevo7($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
        $user = $this->session->user;
		
        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
			/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
			if (($persona['serv_id'] == 0) ||(get_status_serv($persona['serv_id']) != 'PROCESO'))
			{
					$this->form_validation->set_rules('servicio','Orden de servicio','required');
			}
            /*************************************************/
            $this->form_validation->set_rules('anf','Anfetaminas','required');
            $this->form_validation->set_rules('coc','Cocaína','required');
            $this->form_validation->set_rules('mar','Marihuana','required');
            $this->form_validation->set_rules('opi','Opiaceos','required');
            $this->form_validation->set_rules('pcp','Metanfetaminas','required');
            $this->form_validation->set_rules('bzd','benzodiacepina','required');
            $this->form_validation->set_rules('bar','barbituricos','required');
            
            if($this->form_validation->run())
            {
                $data_insert['emp_id']  = $persona['emp_id'];
                $data_insert['clte_id'] = $persona['clte_id'];
                $data_insert['usr_id']  = $user['usr_id'];
                $data_insert['med_id']  = $this->input->post('laboratorista'); 

				if (($persona['serv_id'] == 0) || (get_status_serv($persona['serv_id']) != 'PROCESO'))
				{	
						$data_insert['serv_id']  = $this->input->post('servicio');
				}
				else
				{	
						$data_insert['serv_id']  = $persona['serv_id'];
				}
				$data_insert['fsm_medico_sol'] = $this->input->post('medico_sol');
                $data_insert['fsm_f']   = date('Y-m-d H:i:s');
               // $data_insert['fsm_f']   = $this->input->post('fecha_rec');
				$data_insert['fsm_anf_cve'] = $this->input->post('anf');
                $data_insert['fsm_coc_cve'] = $this->input->post('coc');
                $data_insert['fsm_mar_cve'] = $this->input->post('mar');
                $data_insert['fsm_opi_cve'] = $this->input->post('opi');
                $data_insert['fsm_pcp_cve'] = $this->input->post('pcp');
                $data_insert['fsm_bzd_cve'] = $this->input->post('bzd');             
                $data_insert['fsm_bar_cve'] = $this->input->post('bar');
				$data_insert['log_insrt_f']  =  date('Y-m-d H:i:s');
                if($this->toxicologico7->insert(array_to_upper($data_insert)))
                {
                    send_json_ok('Se guardó de forma correcta');
					/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
					$servicios=$persona['domserv'];					
					
					$servicio='TOXIS;'; /*CODIGO DEL EXAMEN*/
					if (!(strstr($servicios,$servicio)))
					{							
						$servicios.=$servicio;
						$data_clte['domserv']=$servicios;
						$res=$this->cliente->actualiza_registro_individual($cliente_id, $data_clte);
					}
					/**************************************************/					
                }
                else
                {
                    send_json_error('Ocurrió un error al guardar.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
            $data['medico'] = $medico;
			/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
			$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);
			/**************************************************/			
            $this->load->helper('template');
            $params_view = array(
                'title' => '',
                'view' => 'examen/toxicologico/nuevo_form7',
                'view_data' => $data 
               );
            render_template($params_view);
        }
    }
    
    public function pdf($cliente_id, $fsm_id)
    {
        $data['persona'] = $this->cliente->get($cliente_id,get_desp_id_usr());
        $data['fsm'] = $this->toxicologico7->get($fsm_id,get_desp_id_usr());
        $data['medico'] = $this->medico->get_id($data['fsm']['med_id']);
        $data['empresa'] = $this->cliente->get_empresa_by_id($data['fsm']['emp_id']);
        $this->load->helper('pdf');
		if ($data['empresa']['emp_giro']== 'SEGURIDAD')
		{	
			//genera_pdf($this->load->view('examen/toxicologico/pdf7',$data,TRUE),'toxicologico7','toxicologico7','toxicologico7');
			genera_pdf_lab_new_z($this->load->view('examen/toxicologico/pdf7',$data,TRUE),'toxicologico7','toxicologico7',$med_name,$observaciones,$fuera_rango);	

		}
		else
		{
			
			if ($data['fsm']['med_id'] == 113 )
			{
				
				$titulo=$usuario['usr_titulo'].'Q.F.B. ';
				$nombre.=' ';

				$nombre= 'MONTSERRAT JAIMES FLORES';
				
				$texto='          Cédula Profesional: ';
				$cedula='11322160';			
				$med_name=$titulo.$nombre.$texto.$cedula;
				
			}	
			else
			{	
			$med_name=agrega_cedula_ext($data['fsm']['med_id']);
			}
			
			genera_pdf_lab_new_xg($this->load->view('examen/toxicologico/pdf7',$data,TRUE),'toxicologico7','toxicologico7',$med_name,$observaciones,$fuera_rango);	
		}	
	}
	
	public function pdfr($cliente_id, $fsm_id)
    {
        $data['persona'] = $this->cliente->get($cliente_id,get_desp_id_usr());
        $data['fsm'] = $this->toxicologico7->get($fsm_id,get_desp_id_usr());
        $data['medico'] = $this->medico->get_id($data['fsm']['med_id']);
        $data['empresa'] = $this->cliente->get_empresa_by_id($data['fsm']['emp_id']);
        $this->load->helper('pdf');
			if ($data['fsm']['med_id'] == 113 )
			{
				
				$titulo=$usuario['usr_titulo'].'Q.F.B. ';
				$nombre.=' ';

				$nombre= 'MONTSERRAT JAIMES FLORES';
				
				$texto='          Cédula Profesional: ';
				$cedula='11322160';			
				$med_name=$titulo.$nombre.$texto.$cedula;
				
			}	
			else
			{	
				$med_name=agrega_cedula_ext($data['fsm']['med_id']);
			}
			genera_pdf_lab_new_x($this->load->view('examen/toxicologico/pdf7r',$data,TRUE),'ANTIDOPING7','ANTIDOPING7',$med_name,$observaciones,$fuera_rango);			
		
       // genera_pdf_tohuanti2($this->load->view('examen/toxicologico/pdf7r',$data,TRUE),'toxicologico7','toxicologico7','toxicologico7');
    }

    public function borra_toxicologico7($fsm_id)
    {
        if($this->toxicologico7->delete_toxicologico7($fsm_id))
        {
            send_json_ok('Se eliminó de forma correcta.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar.');
        }
    }	
	
}