﻿<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Nx extends CI_Controller {
    
    function __construct() {
        parent::__construct();
        $this->load->model('nx/Nx_model','cliente');
		$this->load->model('nx/Nx_model','registros');
        $this->load->model('servicio/Servicio_model','servicio');
		$this->load->model('empleado/Empleado_model','medico');
		$this->load->helper('util');
    }
 

    public function rep_eva()
    {
        $this->load->helper('template');
        $params_view = array(
            'title' => 'Inicio',
            'view' => 'nx/inicio_view_rep_evaluados',
            'view_data' => $data
            );
        render_template($params_view);
    } 

    public function rep_lab()
    {
        $this->load->helper('template');
        $params_view = array(
            'title' => 'Inicio',
            'view' => 'nx/inicio_view_rep_eva_lab',
            'view_data' => $data
            );
        render_template($params_view);
    }

 
    public function lista()
    {   
		$suc=get_sucursal_id();

		$user_despacho=get_desp_id_usr();

		$user_cei=get_cei_id();

		$user_root1=get_my_user_root1();

        $rows = 30;
        $this->load->library('pagination');
        $config['base_url'] = base_url('nx/lista/');

		
		$config['total_rows'] = $this->registros->count_allo($suc,$user_despacho,$user_cei,$user_root1);
        $config['per_page'] = $rows;
        $config['attributes'] = array('class' => 'pagination');
        $config['full_tag_open'] = '<div class="pagination-full">';
        $config['full_tag_close'] = '</div>';
        $config['uri_segment'] = 3;
        $config['query_string_segment'] = 4;
        $config['use_page_numbers'] = TRUE;
        $this->pagination->initialize($config);

		
		$data['clientes'] = $this->registros->get_allo($rows,get_sucursal_id(),$user_despacho,$user_cei,$user_root1);

		
        $this->load->model('empresa/Empresa_model','empresa');

		
        $data['empresas'] = $this->empresa->get_all_empresas_gsi_id();//$this->empresa->get_all_empresas();

        
        $this->load->helper('template');
        $params_view = array(
            'title' => 'Registros',
            'view' => 'nx/index',
            'view_data' => $data 
           );
        render_template($params_view);  
    }
 


 
    public function id($id)
    {   
	
		$n=get_desp_id_usr();
		$user_cei=get_cei_id();
		$user_root1=get_my_user_root1();

        $data['registros'] = $this->registros->get($id,$n);

		if($data['registros'])
        {

            $user = $this->session->user;

            $data['medico']=$user;
			
			//$data['root'] = get_my_user_root2(); 
			//echo '--->'.$data['myroot2'].'<--';
            $data['docs'] = $this->registros->get_docs_nx($id);
			
			
			$data['coms'] = $this->registros->get_coms($id);
			$data['fsm']['familiares'] = $this->cliente->get_nx_examenes($id);
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Registros Detalles',
                'view' => 'nx/cliente',
                'view_data' => $data 
               );

            render_template($params_view);  
        }
        else
        {
            show_error('El cliente no existe.');
        }
    }
 
    public function nuevo()
    {    
	    if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('nx_concepto','Concepto','required');

            if($this->form_validation->run())
            {
                //información
                $data_clte['nx_empresa'] =  $this->input->post('nx_empresa');
				$data_clte['nx_concepto'] =  $this->input->post('nx_concepto');
				/*$data_clte['nx_periodo_inicial'] =  formatea_fecha_mysql($this->input->post('nx_periodo_inicial'));
				$data_clte['nx_periodo_final'] =  formatea_fecha_mysql($this->input->post('nx_periodo_final'));*/
				
				$data_clte['nx_periodo_inicial'] = $this->input->post('nx_periodo_inicial');
				$data_clte['nx_periodo_final'] =  $this->input->post('nx_periodo_final');
				
				$data_clte['nx_monto_sin_iva'] =  str_replace(',','',$this->input->post('nx_monto_sin_iva'));
				$data_clte['nx_monto_con_iva'] =  bcdiv(str_replace(',','',$this->input->post('nx_monto_sin_iva'))* 1.16, '1', 2) ;
				
				$data_clte['nx_orden_de_venta'] =  $this->input->post('nx_orden_de_venta');
				$data_clte['nx_folio_orden_de_compra'] =  $this->input->post('nx_folio_orden_de_compra');
				$data_clte['nx_numero_de_factura'] =  $this->input->post('nx_numero_de_factura');
				$data_clte['nx_folio_5000'] =  $this->input->post('nx_folio_5000');
				$data_clte['nx_folio_5000_fecha'] =  $this->input->post('nx_folio_5000_fecha');
				//$data_clte['nx_pedido_de_compra'] =  $this->input->post('nx_pedido_de_compra');
				
				$data_clte['nx_status'] =  $this->input->post('nx_status');
				$data_clte['cei_id'] = $this->input->post('cei');
				
				
				
				$nomserv='';

				if($cliente_id = $this->registros->inserta(array_to_upper($data_clte)))
                {
                    send_json_ok(array('msg' =>'Se guardó de forma correcta el registro.', 'id' => $cliente_id));
                }
                else
                {
                    send_json_error('Ocurrió un error al guardar el registro.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $this->load->model('empresa/Empresa_model','empresa');
            $data['empresas'] = $this->empresa->trae_empresas();//$this->empresa->get_all_empresas();
			$data['sucursals'] = $this->empresa->get_all_sucursales();
			$data['despachos'] = $this->empresa->get_all_despachos();
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'nx/add',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }


 
    public function edita($cliente_id)
    {   //date_default_timezone_set('America/Mexico_City');
        
		$registros = $this->registros->get($cliente_id);
        
        if($registros)
        {
            if(isset($_POST) && count($_POST) > 0)     
            {
					$this->load->library('form_validation');
					
					$this->form_validation->set_rules('nx_concepto','Concepto','required');

					if($this->form_validation->run())
					{
						//información
						//$data_clte['nx_empresa'] =  $this->input->post('nx_empresa');
						$data_clte['nx_concepto'] =  $this->input->post('nx_concepto');
						$data_clte['nx_periodo_inicial'] = $this->input->post('nx_periodo_inicial');
						$data_clte['nx_periodo_final'] =  $this->input->post('nx_periodo_final');	

						$data_clte['nx_monto_sin_iva'] =  $this->input->post('nx_monto_sin_iva');
						$data_clte['nx_monto_con_iva'] =  bcdiv($this->input->post('nx_monto_sin_iva'), '1', 2 * 1.16);
				
						//$data_clte['nx_monto_sin_iva'] =  $this->input->post('nx_monto_sin_iva');
						//$data_clte['nx_monto_con_iva'] =  $this->input->post('nx_monto_sin_iva')*1.16;
						
						$data_clte['nx_orden_de_venta'] =  $this->input->post('nx_orden_de_venta');
						$data_clte['nx_folio_orden_de_compra'] =  $this->input->post('nx_folio_orden_de_compra');
						$data_clte['nx_numero_de_factura'] =  $this->input->post('nx_numero_de_factura');
						$data_clte['nx_folio_5000'] =  $this->input->post('nx_folio_5000');
						$data_clte['nx_folio_5000_fecha'] =  $this->input->post('nx_folio_5000_fecha');
						
						
						//$data_clte['nx_pedido_de_compra'] =  $this->input->post('nx_pedido_de_compra');
						
						$data_clte['nx_status'] =  $this->input->post('nx_status');
						
						$this->cliente->insert_arreglo($this->input->post('familia'), 'parentesco', $cliente_id, 'nx_examenes');
						
						
						
						//$data_clte['cei_id'] = $this->input->post('cei');

						if($this->cliente->actualiza($cliente_id, array_to_upper($data_clte)))
						{
							send_json_ok(array('msg' =>'Se actualizó de forma correcta', 'id' => $cliente_id));
						}
						else
						{
							send_json_error('Ocurrió un error al actualizar la persona.');
						}
                }
                else
                {
                    send_json_error(validation_errors('<div />'));
                }
            }
            else 
            {
				//echo "----------->".$cliente['suc_id']."<-----------";
                $this->load->model('empresa/Empresa_model','empresa');
                $data['empresas'] = $this->empresa->trae_empresas();//$this->empresa->get_all_empresas();
				$data['despachos'] = $this->empresa->get_all_despachos();
				$data['sucursals'] = $this->empresa->get_all_sucursales();
				$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($cliente['emp_id']);
                //$data['persona'] = 	$cliente;
				
				$data['fsm']['familiares'] = $this->registros->get_nx_examenes($cliente_id);
				
				$data['registros'] = $registros;

                $this->load->helper('template');
                $params_view = array(
                    'title' => 'Registros',
                    'view' => 'nx/edit',
                    'view_data' => $data
                   );
                render_template($params_view);  
            }
        }
        else 
        {
            show_error('No existe el cliente');
        }
    }
 

    public function borra_familiar($fsm_id, $id)
    {
        if($this->cliente->delete_familiar($fsm_id,$id))
        {
            send_json_ok('Se eliminó de forma correcta.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar.');
        }
    } 


    public function nuevo_doc($cliente_id)
    {
        $persona = $this->registros->get($cliente_id);
        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('nombre','Nombre documento','required');

            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_id'] =  $cliente_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
				$data_clte['serv_id'] =  $persona['serv_id'];
                
                $this->load->library('upload');
                if(!empty($_FILES['doc']['name']))
                {
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/facturas/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg|pdf|xml',
                            'max_size'      => '10000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('doc'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['doc_path'] = $data['file_name'];
                        if($this->registros->add_doc_nx(array_to_upper($data_clte)))
                        {
                            send_json_ok('Se guardó de forma correcta');
                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
                    send_json_error($this->upload->display_errors());
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['registros'] = $persona;
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'nx/add_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }



    public function borra_documento_nx($fsm_id)
    {
		$documento=$this->registros->get_doc_nx($fsm_id);
		
		$doc_borra['clte_id']=$documento['clte_id'];
		$doc_borra['doc_nombre']=$documento['doc_nombre'];
		$doc_borra['doc_path']=strtolower($documento['doc_path']);
		$doc_borra['doc_f']=$documento['doc_f'];
		$doc_borra['empresa']='NX';
		$doc_borra['doc_fecha_efectiva']=date();
		
		$this->registros->inserta_borrado($doc_borra);
        if($this->registros->delete_doc_nx($fsm_id))
        {
            send_json_ok('Se eliminó de forma correcta.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar.');
        }
    }


    function busca()
    {   $despacho=get_desp_id_usr();
		$emp_id_user=get_emp_id();
		$roots=get_my_user_root2();    
        $empresa = $this->input->post('empresa');
		$concepto=$this->input->post('concepto');
        $orden_de_venta=$this->input->post('orden_de_venta');
        $orden_de_compra=$this->input->post('orden_de_compra');
        $f_ini=$this->input->post('f_ini');
        $f_fin=$this->input->post('f_fin');
        $numero_de_factura=$this->input->post('numero_de_factura');
        $folio_5000=$this->input->post('folio_5000');
        $estatus=$this->input->post('estatus');

        $data['clientes'] = $this->cliente->busca($empresa,$concepto,$orden_de_venta,$orden_de_compra,$f_ini,$f_fin,$numero_de_factura,$folio_5000,$estatus);
        send_json_ok($this->load->view('nx/busca',$data,TRUE));
    }	

    function busca_nx()
    {   		
        $empresa = $this->input->post('empresa');
		
		/*$concepto= strtoupper($this->input->post('concepto'));
		$orden_de_venta= strtoupper($this->input->post('orden_de_venta'));
		$orden_de_compra= strtoupper($this->input->post('orden_de_compra'));
		$f_ini= $this->input->post('f_ini');
		$f_fin= $this->input->post('f_fin');
		$numero_de_factura= $this->input->post('$numero_de_factura');
		$folio_5000= $this->input->post('$folio_5000');
		$estatus= strtoupper($this->input->post('estatus'));*/

       // $data['clientes'] = $this->registros->busca_nx($empresa);
        send_json_ok($this->load->view('nx/busca',$data,TRUE));
    }	


/*==================================================================================*/



    public function edita_a($cliente_id)
    {   //date_default_timezone_set('America/Mexico_City');
        
		$cliente = $this->cliente->get($cliente_id);
        
		if ($cliente['serv_id'] > 0)
		{	
			$servicio = $this->servicio->get($cliente['serv_id']);
		}
		
        if($cliente)
        {

            if(isset($_POST) && count($_POST) > 0)     
            {
                $this->load->library('form_validation');
                $this->form_validation->set_rules('nombre','Nombre','required');
                $this->form_validation->set_rules('paterno','Apellido Paterno','required');
                $this->form_validation->set_rules('materno','Apellido Materno','required');
                /*$this->form_validation->set_rules('fnac','Fecha de nacimiento','required');*/
                $this->form_validation->set_rules('genero','Género','required');
                //$this->form_validation->set_rules('civil','Estado civil','required');
                //$this->form_validation->set_rules('rfc','RFC','required');
                //$this->form_validation->set_rules('curp','CURP','required');

                if($this->form_validation->run())
                {
                    //informncion general de la pérsona
                    $data_clte['clte_nombre_crypt'] =  trim($this->input->post('nombre'));
                    $data_clte['clte_2_nombre_crypt'] =  trim($this->input->post('nombre_adic'));
                    $data_clte['clte_paterno_crypt'] =  trim($this->input->post('paterno'));
                    $data_clte['clte_materno_crypt'] =  trim($this->input->post('materno'));
                    
					$data_clte['clte_f_nac'] = formatea_fecha_mysql($this->input->post('fnac'));
                    $data_clte['clte_genero_cve'] =  $this->input->post('genero');
                    $data_clte['clte_rfc_crypt'] =  $this->input->post('rfc');
                    $data_clte['clte_curp_crypt'] =  $this->input->post('curp');
					

					

                    //dopmcicio de la persona
                    $data_clte['clte_env_pais_cve'] =  $this->input->post('pais');
                    $data_clte['clte_env_cp'] =  $this->input->post('cp');
                    $data_clte['clte_env_edo_cve'] =  $this->input->post('entidad');
                    $data_clte['clte_env_colonia_crypt'] =  $this->input->post('colonia');
                    $data_clte['clte_env_localidad'] =  $this->input->post('localidad');
                    $data_clte['clte_env_municipio'] =  $this->input->post('municipio');
                    $data_clte['clte_env_calle_crypt'] =  $this->input->post('calle');
                    $data_clte['clte_env_num_ext_crypt'] =  $this->input->post('next');
                    $data_clte['clte_env_num_int_crypt'] =  $this->input->post('nint');
					$data_clte['clte_nss_crypt'] =  $this->input->post('nss');
                    //informacion de conrtaxcto de la persona
                    $data_clte['clte_tel_casa_crypt'] = limpia_telefono($this->input->post('tel'));                
                    $data_clte['clte_cel_crypt'] =  limpia_telefono($this->input->post('cel'));
                    $data_clte['clte_email_crypt'] =  $this->input->post('correo');

                    //nuevos campos
                    $data_clte['clte_grado_acad_cve'] =  $this->input->post('grado');
                    $data_clte['clte_puesto'] =  $this->input->post('puesto');
                    $data_clte['clte_edo_civ_cve'] =  $this->input->post('civil');
                    $data_clte['clte_nac_cve'] =  $this->input->post('nac');

                    //empresa donde va a loborar la persona
                    $data_clte['emp_id'] =  $this->input->post('empresa');
                    
                    //nuevo campo de unicacion
                    $data_clte['clte_lab_ubicacion'] =  $this->input->post('ubicacion');
                     
					//despachos 
					$data_clte['desp_id'] =  $this->input->post('despacho');
					$data_clte['clte_reclutador'] =  $this->input->post('reclutador');					 
					 
                     //examenes
					/*
				 	$data_clte['acred'] =  $this->input->post('acreditacion'); 	
					$data_clte['biohem'] =  $this->input->post('biometria_hematica'); 		
					$data_clte['ced_pol'] =  $this->input->post('poligrafo_celula'); 
					
					$data_clte['ced_psci'] =  $this->input->post('psico_celula'); 				
					$data_clte['psci'] =  $this->input->post('psico_reporte'); 	 
					$data_clte['repsic'] =  $this->input->post('psico_reporte');
					$data_clte['pssim'] =  $this->input->post('psico_simple'); 						
					 
					
					$data_clte['sangre'] =  $this->input->post('sangre'); 
					$data_clte['sociol'] =  $this->input->post('sociolaboral'); 						
					$data_clte['hist'] =  $this->input->post('historia_clinica'); 	 	
					$data_clte['entsoc'] =  $this->input->post('entorno_social'); 	 	
					
					
					$data_clte['estsoc'] = $this->input->post('estudio_socioeconomico'); 	 	
					$data_clte['eyed'] =  $this->input->post('eye'); 	 	
					$data_clte['fpfh0105'] =  $this->input->post('fpfh0105'); 	 	
					$data_clte['medfis'] =  $this->input->post('medico_fisico'); 	 	
					$data_clte['odo'] =  $this->input->post('odontologica'); 	 	
					$data_clte['orina'] =  $this->input->post('orina'); 	 	
					$data_clte['pie'] =  $this->input->post('pie'); 	 	
					$data_clte['pol'] =  $this->input->post('poligrafo_reporte'); 	 	
						 	
					
					$data_clte['quisan'] =  $this->input->post('quimica_sanguinea'); 	 	
					$data_clte['socie'] =  $this->input->post('socioeconomico'); 	 	
					$data_clte['toxi'] =  $this->input->post('toxicologico5'); 	
					
					$data_clte['toxin'] =  $this->input->post('toxicologico9'); 	
					$data_clte['toxis'] =  $this->input->post('toxicologico7');
					
					$data_clte['pyb'] =  $this->input->post('pyb');
                    */
					
					$nomserv='';
					if ($this->input->post('nom35i') == 'OK')
					{$nomserv=$nomserv.'nom0351;';}	
					if ($this->input->post('nom35ii') == 'OK')
					{$nomserv=$nomserv.'nom0352;';}
					if ($this->input->post('nom35iii') == 'OK')
					{$nomserv=$nomserv.'nom0353;';}	
					
					/*
					if ($this->input->post('honestidad') == 'OK')
					{$nomserv=$nomserv.'HONE;';}
					if ($this->input->post('comportamiento') == 'OK')
					{$nomserv=$nomserv.'COMPO;';}
					if ($this->input->post('certificado') == 'OK')
					{$nomserv=$nomserv.'CERTI;';}
					*/
/***************************************************************************************/
						
					$cat_examen = get_cat_nombre_var('EXAMEN');
					$i=0;
					$cat_categorias = get_cat_nombre_var('CATEGORIA_EX');
					foreach($cat_categorias as $categoria): 
						//echo $categoria['cat_nombre'].' ';
						$linea_examenes=get_examen_de_empresa_por_categoria($cliente['emp_id'], $categoria['cat_nombre']);
						
						if (strlen($linea_examenes) > 0)
						{
							foreach (explode(';', $linea_examenes) as $det):
								if (strlen($det) > 0)
								{

										//<?php echo $categoria['cat_nombre'];

										//<?php echo get_nombre_de_examen($det, 'EXAMEN');
										
										$exa=$this->input->post($categoria['cat_nombre'].'_'.$i);
										$nomserv.=$exa;
										$i++;
										//<input type="checkbox" id="<?php echo $categoria['cat_nombre'].'_'.$i; " name="<?php echo $categoria['cat_nombre'].'_'.$i; " value="<?php echo $det.';'; $i++; " <?php if (strstr($persona['nomserv'], $det.';')) { echo 'checked';} 

								}
								
							endforeach;										
						}
					endforeach;
/***************************************************************************************/

					$data_clte['nomserv'] =  $nomserv;
					
					// Se convierte en un empleado de HC
					$data_clte['hc'] =  1;
		
                    //despacho
					/*
                      $data_clte['desp_id'] =  $this->input->post('despacho');
					  if ($data_clte['desp_id'] == 1) {$data_clte['desp_id']=0;}
					  $data_clte['clte_reclutador'] =  $this->input->post('reclutador');
					
					
					if ($this->input->post('serv_id') > 0)
					{	
						$data_clte['serv_id'] =$this->input->post('serv_id');
					}				
					*/
					
					//sucursal
					$data_clte['suc_id'] =  $this->input->post('sucursal');
					
					//cei
					$data_clte['cei_id'] =  $this->input->post('cei');
					
					
//*************************************
//$data_clte['root'] = 'OK';
//*************************************


                    if(!empty($_FILES['foto']['name']))
                    {
                        $this->load->library('upload');
                        $filename = md5(time());
                        $config = array(
                                'upload_path'   => './../../files/fotos/',
                                'overwrite'     => TRUE,
                                'file_name'     => $filename,
                                'allowed_types' => 'png|jpg|jpeg',
                                'max_size'      => '10000'
                        );

                        $this->upload->initialize($config);
                        if ( ! $this->upload->do_upload('foto'))
                        {
                            send_json_error($this->upload->display_errors());
                        }
                        else 
                        {
                            $data = $this->upload->data();
                            $data_clte['clte_path_foto'] = $data['file_name'];
                        }
                    }

					if (($data_clte['clte_f_nac'] =='') && ($data_clte['emp_id'] !=152))
					{
						send_json_error('Ocurrió un error, no se registro la FECHA DE NACIMIENTO.');
					}
                    else
					{
						
						if ($this->input->post('rregistrar') == 'rr')
						{						
							if($this->cliente->actualiza_registro($cliente_id, array_to_upper($data_clte)))
							{
								send_json_ok(array('msg' =>'Se actualizó y registro nuevamente el evaluado de forma correcta', 'id' => $cliente_id));
							}
							else
							{
								send_json_error('Ocurrió un error al actualizar la persona.');
							}
						}
						else
						{	
						
							if($this->cliente->actualiza($cliente_id, array_to_upper($data_clte)))
							{
								send_json_ok(array('msg' =>'Se actualizó y ha sido Contratado en HC de forma correcta', 'id' => $cliente_id));
							}
							else
							{
								send_json_error('Ocurrió un error al actualizar la persona.');
							}
						}
					}
                }
                else
                {
                    send_json_error(validation_errors('<div />'));
                }
            }
            else 
            {
				//echo "----------->".$cliente['suc_id']."<-----------";
                $this->load->model('empresa/Empresa_model','empresa');
                $data['empresas'] = $this->empresa->trae_empresas();//$this->empresa->get_all_empresas();
				$data['despachos'] = $this->empresa->get_all_despachos();
				$data['sucursals'] = $this->empresa->get_all_sucursales();
				$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($cliente['emp_id']);
                $data['persona'] = 	$cliente;
				if ($cliente['serv_id'] > 0)
				{
					$data['servicio'] = $servicio;
				}
                $this->load->helper('template');
                $params_view = array(
                    'title' => 'Personas',
                    'view' => 'nx/edit_a',
                    'view_data' => $data
                   );
                render_template($params_view);  
            }
        }
        else 
        {
            show_error('No existe el cliente');
        }
    }

    public function edita_c($cliente_id)
    {           
		$cliente = $this->cliente->get($cliente_id);
        
		if ($cliente['serv_id'] > 0)
		{	
			$servicio = $this->servicio->get($cliente['serv_id']);
		}
		
        if($cliente)
        {

            if(isset($_POST) && count($_POST) > 0)     
            {
                $this->load->library('form_validation');
                $this->form_validation->set_rules('nombre','Nombre','required');
                $this->form_validation->set_rules('paterno','Apellido Paterno','required');
                $this->form_validation->set_rules('materno','Apellido Materno','required');
                /*$this->form_validation->set_rules('fnac','Fecha de nacimiento','required');*/
                $this->form_validation->set_rules('genero','Género','required');
                //$this->form_validation->set_rules('civil','Estado civil','required');
                //$this->form_validation->set_rules('rfc','RFC','required');
                //$this->form_validation->set_rules('curp','CURP','required');

                if($this->form_validation->run())
                {
                    //informncion general de la pérsona
                    $data_clte['clte_nombre_crypt'] =  trim($this->input->post('nombre'));
                    $data_clte['clte_2_nombre_crypt'] =  trim($this->input->post('nombre_adic'));
                    $data_clte['clte_paterno_crypt'] =  trim($this->input->post('paterno'));
                    $data_clte['clte_materno_crypt'] =  trim($this->input->post('materno'));
                    
					$data_clte['clte_f_nac'] = formatea_fecha_mysql($this->input->post('fnac'));
                    $data_clte['clte_genero_cve'] =  $this->input->post('genero');
                    $data_clte['clte_rfc_crypt'] =  $this->input->post('rfc');
                    $data_clte['clte_curp_crypt'] =  $this->input->post('curp');
					

					

                    //dopmcicio de la persona
                    $data_clte['clte_env_pais_cve'] =  $this->input->post('pais');
                    $data_clte['clte_env_cp'] =  $this->input->post('cp');
                    $data_clte['clte_env_edo_cve'] =  $this->input->post('entidad');
                    $data_clte['clte_env_colonia_crypt'] =  $this->input->post('colonia');
                    $data_clte['clte_env_localidad'] =  $this->input->post('localidad');
                    $data_clte['clte_env_municipio'] =  $this->input->post('municipio');
                    $data_clte['clte_env_calle_crypt'] =  $this->input->post('calle');
                    $data_clte['clte_env_num_ext_crypt'] =  $this->input->post('next');
                    $data_clte['clte_env_num_int_crypt'] =  $this->input->post('nint');
					$data_clte['clte_nss_crypt'] =  $this->input->post('nss');
                    //informacion de conrtaxcto de la persona
                    $data_clte['clte_tel_casa_crypt'] = limpia_telefono($this->input->post('tel'));                
                    $data_clte['clte_cel_crypt'] =  limpia_telefono($this->input->post('cel'));
                    $data_clte['clte_email_crypt'] =  $this->input->post('correo');

                    //nuevos campos
                    $data_clte['clte_grado_acad_cve'] =  $this->input->post('grado');
                    $data_clte['clte_puesto'] =  $this->input->post('puesto');
                    $data_clte['clte_edo_civ_cve'] =  $this->input->post('civil');
                    $data_clte['clte_nac_cve'] =  $this->input->post('nac');

                    //empresa donde va a loborar la persona
                    $data_clte['emp_id'] =  $this->input->post('empresa');
                    
                    //nuevo campo de unicacion
                    $data_clte['clte_lab_ubicacion'] =  $this->input->post('ubicacion');
                     
					//despachos 
					$data_clte['desp_id'] =  $this->input->post('despacho');
					$data_clte['clte_reclutador'] =  $this->input->post('reclutador');					 
					 
	
					$nomserv='';
					if ($this->input->post('nom35i') == 'OK')
					{$nomserv=$nomserv.'nom0351;';}	
					if ($this->input->post('nom35ii') == 'OK')
					{$nomserv=$nomserv.'nom0352;';}
					if ($this->input->post('nom35iii') == 'OK')
					{$nomserv=$nomserv.'nom0353;';}	
					
					/*
					if ($this->input->post('honestidad') == 'OK')
					{$nomserv=$nomserv.'HONE;';}
					if ($this->input->post('comportamiento') == 'OK')
					{$nomserv=$nomserv.'COMPO;';}
					if ($this->input->post('certificado') == 'OK')
					{$nomserv=$nomserv.'CERTI;';}
					*/
/***************************************************************************************/
						
					$cat_examen = get_cat_nombre_var('EXAMEN');
					$i=0;
					$cat_categorias = get_cat_nombre_var('CATEGORIA_EX');
					foreach($cat_categorias as $categoria): 
						//echo $categoria['cat_nombre'].' ';
						$linea_examenes=get_examen_de_empresa_por_categoria($cliente['emp_id'], $categoria['cat_nombre']);
						
						if (strlen($linea_examenes) > 0)
						{
							foreach (explode(';', $linea_examenes) as $det):
								if (strlen($det) > 0)
								{

										//<?php echo $categoria['cat_nombre'];

										//<?php echo get_nombre_de_examen($det, 'EXAMEN');
										
										$exa=$this->input->post($categoria['cat_nombre'].'_'.$i);
										$nomserv.=$exa;
										$i++;
										//<input type="checkbox" id="<?php echo $categoria['cat_nombre'].'_'.$i; " name="<?php echo $categoria['cat_nombre'].'_'.$i; " value="<?php echo $det.';'; $i++; " <?php if (strstr($persona['nomserv'], $det.';')) { echo 'checked';} 

								}
								
							endforeach;										
						}
					endforeach;
/***************************************************************************************/

					$data_clte['nomserv'] =  $nomserv;
					
					// Se convierte en un empleado de HC
					$data_clte['hc'] =  1;
					echo $this->input->post('estatus');
					//if ($this->input->post('estatus') == 'noactivo')
					{
						$data_clte['status'] =  $this->input->post('status');
					}
		
                    //despacho
					/*
                      $data_clte['desp_id'] =  $this->input->post('despacho');
					  if ($data_clte['desp_id'] == 1) {$data_clte['desp_id']=0;}
					  $data_clte['clte_reclutador'] =  $this->input->post('reclutador');
					
					
					if ($this->input->post('serv_id') > 0)
					{	
						$data_clte['serv_id'] =$this->input->post('serv_id');
					}				
					*/
					
					//sucursal
					$data_clte['suc_id'] =  $this->input->post('sucursal');
					
					//cei
					$data_clte['cei_id'] =  $this->input->post('cei');
					
					
//*************************************
//$data_clte['root'] = 'OK';
//*************************************


                    if(!empty($_FILES['foto']['name']))
                    {
                        $this->load->library('upload');
                        $filename = md5(time());
                        $config = array(
                                'upload_path'   => './../../files/fotos/',
                                'overwrite'     => TRUE,
                                'file_name'     => $filename,
                                'allowed_types' => 'png|jpg|jpeg',
                                'max_size'      => '10000'
                        );

                        $this->upload->initialize($config);
                        if ( ! $this->upload->do_upload('foto'))
                        {
                            send_json_error($this->upload->display_errors());
                        }
                        else 
                        {
                            $data = $this->upload->data();
                            $data_clte['clte_path_foto'] = $data['file_name'];
                        }
                    }

					if (($data_clte['clte_f_nac'] =='') && ($data_clte['emp_id'] !=152))
					{
						send_json_error('Ocurrió un error, no se registro la FECHA DE NACIMIENTO.');
					}
                    else
					{
						
						if ($this->input->post('rregistrar') == 'rr')
						{						
							if($this->cliente->actualiza_registro($cliente_id, array_to_upper($data_clte)))
							{
								send_json_ok(array('msg' =>'Se actualizó y registro nuevamente el evaluado de forma correcta', 'id' => $cliente_id));
							}
							else
							{
								send_json_error('Ocurrió un error al actualizar la persona.');
							}
						}
						else
						{	
						
							if($this->cliente->actualiza($cliente_id, array_to_upper($data_clte)))
							{
								send_json_ok(array('msg' =>'Se actualizó y ha sido Contratado en HC de forma correcta', 'id' => $cliente_id));
							}
							else
							{
								send_json_error('Ocurrió un error al actualizar la persona.');
							}
						}
					}
                }
                else
                {
                    send_json_error(validation_errors('<div />'));
                }
            }
            else 
            {
				//echo "----------->".$cliente['suc_id']."<-----------";
                $this->load->model('empresa/Empresa_model','empresa');
                $data['empresas'] = $this->empresa->trae_empresas();//$this->empresa->get_all_empresas();
				$data['despachos'] = $this->empresa->get_all_despachos();
				$data['sucursals'] = $this->empresa->get_all_sucursales();
				$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($cliente['emp_id']);
                $data['persona'] = 	$cliente;
				if ($cliente['serv_id'] > 0)
				{
					$data['servicio'] = $servicio;
				}
                $this->load->helper('template');
                $params_view = array(
                    'title' => 'Personas',
                    'view' => 'nx/edit_c',
                    'view_data' => $data
                   );
                render_template($params_view);  
            }
        }
        else 
        {
            show_error('No existe el cliente');
        }
    }
  


/*************************************************************************************/
    public function nuevo_n()
    {    
	    //date_default_timezone_set('America/Mexico_City');
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('nombre','Nombre','required');
            $this->form_validation->set_rules('paterno','Apellido Paterno','required');
            $this->form_validation->set_rules('materno','Apellido Materno','required');
            $this->form_validation->set_rules('fnac','Fecha de nacimiento','required');
            $this->form_validation->set_rules('genero','Género','required');
           // $this->form_validation->set_rules('civil','Estado civil','required');
            $this->form_validation->set_rules('rfc','RFC','required');
            //
            //$this->form_validation->set_rules('curp','CURP','required');

            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_nombre_crypt'] =  trim($this->input->post('nombre'));
                $data_clte['clte_2_nombre_crypt'] =  trim($this->input->post('nombre_adic'));
                $data_clte['clte_paterno_crypt'] =  trim($this->input->post('paterno'));
                $data_clte['clte_materno_crypt'] =  trim($this->input->post('materno'));
                
				$data_clte['clte_f_nac'] = formatea_fecha_mysql($this->input->post('fnac'));
                $data_clte['clte_genero_cve'] =  $this->input->post('genero');
      				
				$data_clte['clte_rfc_crypt'] =  $this->input->post('rfc');
                				
				$data_clte['clte_curp_crypt'] = ''; // $this->input->post('curp');
                
                //dopmcicio de la persona
                $data_clte['clte_env_pais_cve'] =  $this->input->post('pais');
                $data_clte['clte_env_cp'] =  $this->input->post('cp');
                $data_clte['clte_env_edo_cve'] =  $this->input->post('entidad');
                $data_clte['clte_env_colonia_crypt'] =  $this->input->post('colonia');
                $data_clte['clte_env_localidad'] =  $this->input->post('localidad');
                $data_clte['clte_env_municipio'] =  $this->input->post('municipio');
                $data_clte['clte_env_calle_crypt'] =  $this->input->post('calle');
                $data_clte['clte_env_num_ext_crypt'] =  $this->input->post('next');
                $data_clte['clte_env_num_int_crypt'] =  $this->input->post('nint');
				
                $data_clte['clte_nss_crypt'] = ''; // $this->input->post('nss');
                
				//informacion de conrtaxcto de la persona
                $data_clte['clte_tel_casa_crypt'] =  limpia_telefono($this->input->post('tel'));                
                $data_clte['clte_cel_crypt'] =  limpia_telefono($this->input->post('cel'));
                $data_clte['clte_email_crypt'] =  $this->input->post('correo');
                
                //nuevos campos
                $data_clte['clte_grado_acad_cve'] =  $this->input->post('grado');
                $data_clte['clte_puesto'] =  $this->input->post('puesto');
                $data_clte['clte_edo_civ_cve'] =  $this->input->post('civil');
                $data_clte['clte_nac_cve'] =  $this->input->post('nac');
                
                //empresa donde va a loborar la persona
                $data_clte['emp_id'] = 189 ;  // solo NOVERITE //$this->input->post('empresa');
                
                //nuevo campo de ubicacion
                $data_clte['clte_lab_ubicacion'] = ''; // $this->input->post('ubicacion');

                //despacho
				$data_clte['desp_id']=0;
			    $data_clte['clte_reclutador'] ='';  //$this->input->post('reclutador');
				
				//sucursal
                $data_clte['suc_id'] =0;//$this->input->post('sucursal');
				$data_clte['cei_id'] =  2;

					
					$nomserv='';
					
					$data_clte['nomserv'] =  $nomserv;

 /***************************** CARGA DE LA FOTO DEL EVALUADO ************************/               
                if(!empty($_FILES['foto']['name']))
                {
                    $this->load->library('upload');
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/fotos/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg',
                            'max_size'      => '10000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('foto'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['clte_path_foto'] = $data['file_name'];
                    }
                }
/*************************************************************************************/
				$data_clte=array_to_upper($data_clte);
				
				$encontrado = $this->cliente->buscate($data_clte['clte_nombre_crypt'], $data_clte['clte_2_nombre_crypt'],  $data_clte['clte_paterno_crypt'],$data_clte['clte_materno_crypt']);
				$diff=61;
				
				$rfc_test=$data_clte['clte_rfc_crypt'];
				
				$encontrado_error_long_rfc=0;
				
				if (strlen($rfc_test) <10)
				{
					$encontrado_long_rfc=1;
				}
				else
				{
					$rfc_test= substr($rfc_test,0,10);
					$encontrado_rfc = $this->cliente->buscate_rfc($rfc_test,$data_clte['emp_id']);
				}	
			
				
				if ($encontrado)
				{
					$unafecha=$encontrado[0]['log_insrt_f'];
					$diff= abs(intval(dateDifference($unafecha,date('Y-m-d'))));

				}
	             
				if (($encontrado) && ( $diff < 20))
				{
					send_json_error('Ocurrió un error, el candidato ya fue registrado en la plataforma en la fecha '.formatea_fecha($unafecha).', hace '.$diff.' días.');
				}
				elseif( $encontrado_long_rfc ==1)
				{
					send_json_error('Ocurrió un error, el RFC capturado: "'.$rfc_test.'", debe tener al menos 10 caracteres.');
					
				}elseif($encontrado_rfc)
				{
					send_json_error('Ocurrió un error, el evaluado ya habia sido registrado anterioremente con el ID "'.$encontrado_rfc[0]['clte_id'].'", por favor usar el registro ya establecido.');
				}
				elseif($cliente_id = $this->cliente->inserta(array_to_upper($data_clte)))
                {
                    send_json_ok(array('msg' =>'Se guardó de forma correcta', 'id' => $cliente_id));
                    
                }
                else
                {
                    send_json_error('Ocurrió un error al guardar la persona.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $this->load->model('empresa/Empresa_model','empresa');
            $data['empresas'] = $this->empresa->get_all_empresas();
			$data['sucursals'] = $this->empresa->get_all_sucursales();
			$data['despachos'] = $this->empresa->get_all_despachos();
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'nx/add_n',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }


/*************************************************************************************/
    public function nuevo_p()
    {    
		$user = $this->session->user; 
		$medico = $this->medico->get($user['usr_id']);
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('nombre','Nombre','required');
            $this->form_validation->set_rules('paterno','Apellido Paterno','required');
            $this->form_validation->set_rules('materno','Apellido Materno','required');
            $this->form_validation->set_rules('fnac','Fecha de nacimiento','required');
            $this->form_validation->set_rules('genero','Género','required');

            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_nombre_crypt'] =  trim($this->input->post('nombre'));
                $data_clte['clte_2_nombre_crypt'] =  trim($this->input->post('nombre_adic'));
                $data_clte['clte_paterno_crypt'] =  trim($this->input->post('paterno'));
                $data_clte['clte_materno_crypt'] =  trim($this->input->post('materno'));
                
				$data_clte['clte_f_nac'] = formatea_fecha_mysql($this->input->post('fnac'));
                $data_clte['clte_genero_cve'] =  $this->input->post('genero');
      				
				$data_clte['clte_rfc_crypt'] =  $this->input->post('rfc');
                				
				$data_clte['clte_curp_crypt'] = ''; // $this->input->post('curp');
                $data_clte['paciente'] = 1;
                
                $data_clte['emp_id'] =$this->input->post('empresa');//$medico['usr_emp_asig'];
                $data_clte['clte_puesto'] = $this->input->post('puesto');
				$data_clte['num_empleado'] = $this->input->post('nempleado');
				
				//sucursal
                $data_clte['suc_id'] =0;
				$data_clte['cei_id'] =  4;

				$nomserv='RECETA;';
				$data_clte['nomserv'] =  $nomserv;

 /***************************** CARGA DE LA FOTO DEL EVALUADO ************************/               
                if(!empty($_FILES['foto']['name']))
                {
                    $this->load->library('upload');
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/fotos/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg',
                            'max_size'      => '10000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('foto'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['clte_path_foto'] = $data['file_name'];
                    }
                }
/*************************************************************************************/
				$data_clte=array_to_upper($data_clte);
				
				if($cliente_id = $this->cliente->inserta(array_to_upper($data_clte)))
                {
                    send_json_ok(array('msg' =>'Se guardó de forma correcta', 'id' => $cliente_id));
                    
                }
                else
                {
                    send_json_error('Ocurrió un error al guardar la persona.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $this->load->model('empresa/Empresa_model','empresa');
            //$data['empresas'] = $this->empresa->get_all_empresas();
			$data['empresas'] =$this->empresa->get_all_empresas_gsi();
			$data['sucursals'] = $this->empresa->get_all_sucursales();
			$data['despachos'] = $this->empresa->get_all_despachos();
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'nx/add_p',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }

/*************************************************************************************/
    

 
    public function nuevo_hon_doc($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('nombre','Nombre documento','required');
			$this->form_validation->set_rules('servicio','Orden de servicio','required');
			
            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_id'] =  $cliente_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                $data_clte['emp_id'] =  $this->input->post('emp_id');
				$data_clte['serv_id'] = $this->input->post('servicio');
				
				
                $this->load->library('upload');
                if(!empty($_FILES['doc']['name']))
                {
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/docs/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg|pdf|doc|docx',
                            'max_size'      => '10000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('doc'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['doc_path'] = $data['file_name'];
                        if($this->cliente->add_hon_doc(array_to_upper($data_clte)))
                        {
                            send_json_ok('Se guardó de forma correcta');
                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
                    send_json_error($this->upload->display_errors());
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'nx/add_hon_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }

    public function nuevo_covid_doc($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('nombre','Nombre documento','required');
			$this->form_validation->set_rules('servicio','Orden de servicio','required');
			
            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_id'] =  $cliente_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                $data_clte['emp_id'] =  $this->input->post('emp_id');
				$data_clte['serv_id'] = $this->input->post('servicio');
				
				
                $this->load->library('upload');
                if(!empty($_FILES['doc']['name']))
                {
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/docs/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg|pdf|doc|docx',
                            'max_size'      => '10000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('doc'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['doc_path'] = $data['file_name'];
                        if($this->cliente->add_covid_doc(array_to_upper($data_clte)))
                        {
                            send_json_ok('Se guardó de forma correcta');
                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
                    send_json_error($this->upload->display_errors());
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'nx/add_covid_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }

    public function nuevo_compo_doc($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('nombre','Nombre documento','required');
			$this->form_validation->set_rules('servicio','Orden de servicio','required');
			
            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_id'] =  $cliente_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                $data_clte['emp_id'] =  $this->input->post('emp_id');
				$data_clte['serv_id'] = $this->input->post('servicio');
				
				
                $this->load->library('upload');
                if(!empty($_FILES['doc']['name']))
                {
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/docs/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg|pdf|doc|docx',
                            'max_size'      => '10000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('doc'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['doc_path'] = $data['file_name'];
                        if($this->cliente->add_compo_doc(array_to_upper($data_clte)))
                        {
                            send_json_ok('Se guardó de forma correcta');
                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
                    send_json_error($this->upload->display_errors());
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'nx/add_compo_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }
 
 
     public function nuevo_prevem_doc($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
		
		
        
        if(isset($_POST) && count($_POST) > 0)     
        {
			$this->cliente->borra_sgmty_doc($cliente_id);
            $this->load->library('form_validation');
            $this->form_validation->set_rules('nombre','Nombre documento','required');
			$this->form_validation->set_rules('servicio','Orden de servicio','required');
			
            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_id'] =  $cliente_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                $data_clte['emp_id'] =  $this->input->post('emp_id');
				$data_clte['serv_id'] = $this->input->post('servicio');
				$data_clte['doc_pkts'] ='';

				$i=1;
				$paquetes='';
				$fsm_pakts= get_costos_paquetes_empresa($this->input->post('emp_id'));
				if($fsm_pakts):
					foreach($fsm_pakts as $fsm_pakt):			
						$indice=str_replace(' ','_',$fsm_pakt['cost_nombre_pkt']).'_'.$i;
						if (strlen($this->input->post($indice)) > 1)
						{	
							$paquetes.=$this->input->post($indice);										
						}
						$i++;									
					endforeach;
				endif;
				$data_clte['doc_pkts'] = $paquetes;
				//$data_clte['contador']=$this->input->post('contador');

                $this->load->library('upload');
                if(!empty($_FILES['doc']['name']))
                {
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/docs/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg|pdf|doc|docx',
                            'max_size'      => '10000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('doc'))
                    {
                        //send_json_error($this->upload->display_errors());
						send_json_error('El documento nos se ha podido cargar, por favor revisa');
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['doc_path'] = $data['file_name'];
                        if($this->cliente->add_sgmty_doc(array_to_upper($data_clte)))
                        {
                            send_json_ok('Se guardó de forma correcta');
                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
                    send_json_error($this->upload->display_errors());
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'nx/add_sgmty_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }
 
    public function nuevo_sgmty_venta($cliente_id, $tipo=0)
    {
        $persona = $this->cliente->get($cliente_id);		
        
        if(isset($_POST) && count($_POST) > 0)     
        {
			$this->cliente->borra_sgmty_venta($cliente_id,$venta);
            $this->load->library('form_validation');
			$this->form_validation->set_rules('servicio','Orden de servicio','required');
			
            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_id'] =  $cliente_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                $data_clte['emp_id'] =  $this->input->post('emp_id');
				$data_clte['serv_id'] = $this->input->post('servicio');
				$data_clte['doc_pkts'] ='';

				$i=0;
				$paquetes='';
				$fsm_pakts= get_costos_paquetes_empresa($this->input->post('emp_id'));
				if($fsm_pakts):
					foreach($fsm_pakts as $fsm_pakt):			
						$indice=str_replace(' ','_',$fsm_pakt['cost_nombre_pkt']).'_'.$i;
						if (strlen($this->input->post($indice)) > 1)
						{	
							$paquetes.=$this->input->post($indice);										
						}
						$i++;									
					endforeach;
				endif;
				
				$data_clte['doc_pkts'] = $paquetes;
				$data_clte['doc_path'] = $this->input->post('cantidad');
				
                $this->load->library('upload');				

				if (strlen($data_clte['doc_path']) > 0)
				{
					$data = $this->upload->data();
					if($this->cliente->add_sgmty_doc(array_to_upper($data_clte)))
					{
						send_json_ok('Se guardó de forma correcta');
					}
					else
					{
						send_json_error('Ocurrió un error al guardar el documento.');
					}
				}
				else 
				{
					
					send_json_error('No escribio la cantidad, por favor revisa');
				}						
					
            }
            else
            {
                send_json_error(validation_errors('¡Error!<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
			$data['tipo'] = $tipo;
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'nx/add_sgmty_venta',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }
 
 
 
    public function nuevo_sgmty_doc($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
		
		
        
        if(isset($_POST) && count($_POST) > 0)     
        {
			$this->cliente->borra_sgmty_doc($cliente_id);
            $this->load->library('form_validation');
			$this->form_validation->set_rules('nombre','Nombre documento','required');
			$this->form_validation->set_rules('servicio','Orden de servicio','required');
			
            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_id'] =  $cliente_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                $data_clte['emp_id'] =  $this->input->post('emp_id');
				$data_clte['serv_id'] = $this->input->post('servicio');
				$data_clte['doc_pkts'] ='';

				$i=1;
				$paquetes='';
				$fsm_pakts= get_costos_paquetes_empresa($this->input->post('emp_id'));
				if($fsm_pakts):
					foreach($fsm_pakts as $fsm_pakt):			
						$indice=str_replace(' ','_',$fsm_pakt['cost_nombre_pkt']).'_'.$i;
						if (strlen($this->input->post($indice)) > 1)
						{	
							$paquetes.=$this->input->post($indice);
							if ($this->input->post('emp_id') == 182)
							{
								if (
									($fsm_pakt['cost_nombre_pkt'] == 'ANALISIS BACTERIOLOGICO DE HIELO') 
									||	($fsm_pakt['cost_nombre_pkt'] == 'ANALISIS BACTERIOLOGICO DE AGUA')
									||	($fsm_pakt['cost_nombre_pkt'] == 'CULTIVO DE ALIMENTO CRUDO')
									||	($fsm_pakt['cost_nombre_pkt'] == 'CULTIVO DE ALIMENTO COCIDO')
									||	($fsm_pakt['cost_nombre_pkt'] == 'CULTIVO DE SUPERFICIE INERTE')
									||	($fsm_pakt['cost_nombre_pkt'] == 'CULTIVO DE SUPERFICIE VIVA')
									)
									{
										$indice_muestra=$indice.'_MUESTRA';
										$paquetes=substr($paquetes, 0, -1);
										$paquetes.='x'.$this->input->post($indice_muestra).';';
									}	
							}

						}
						$i++;									
					endforeach;
				endif;
				
				$data_clte['doc_pkts'] = $paquetes;
				
                $this->load->library('upload');
				
				
                if(!empty($_FILES['doc']['name']))
                {
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/docs/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg|pdf|doc|docx',
                            'max_size'      => '10000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('doc'))
                    {
                        
						send_json_error('El documento nos se ha podido cargar, por favor revisa');
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['doc_path'] = $data['file_name'];
                        if($this->cliente->add_sgmty_doc(array_to_upper($data_clte)))
                        {
                            send_json_ok('Se guardó de forma correcta');
                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
                    send_json_error($this->upload->display_errors());
                }
				
				
				
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
			$this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'nx/add_sgmty_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }
 
 
 /***/
      public function nuevo_allianz_doc($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
		
		
        
        if(isset($_POST) && count($_POST) > 0)     
        {
			$this->cliente->borra_sgmty_doc($cliente_id);
            $this->load->library('form_validation');
            $this->form_validation->set_rules('nombre','Nombre documento','required');
			$this->form_validation->set_rules('servicio','Orden de servicio','required');
			
            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_id'] =  $cliente_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                $data_clte['emp_id'] =  $this->input->post('emp_id');
				$data_clte['serv_id'] = $this->input->post('servicio');
				$data_clte['doc_pkts'] ='';

				$i=1;
				$paquetes='';
				$fsm_pakts= get_costos_paquetes_empresa($this->input->post('emp_id'));
				if($fsm_pakts):
					foreach($fsm_pakts as $fsm_pakt):			
						$indice=str_replace(' ','_',$fsm_pakt['cost_nombre_pkt']).'_'.$i;
						if (strlen($this->input->post($indice)) > 1)
						{	
							$paquetes.=$this->input->post($indice);										
						}
						$i++;									
					endforeach;
				endif;
				$data_clte['doc_pkts'] = $paquetes;
				//$data_clte['contador']=$this->input->post('contador');

                $this->load->library('upload');
                if(!empty($_FILES['doc']['name']))
                {
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/docs/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg|pdf|doc|docx',
                            'max_size'      => '10000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('doc'))
                    {
                        //send_json_error($this->upload->display_errors());
						send_json_error('El documento nos se ha podido cargar, por favor revisa');
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['doc_path'] = $data['file_name'];
                        if($this->cliente->add_sgmty_doc(array_to_upper($data_clte)))
                        {
                            send_json_ok('Se guardó de forma correcta');
                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
                    send_json_error($this->upload->display_errors());
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'nx/add_sgmty_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }
 
    function descarga_doc($file)
    {
        $this->load->helper('download');
        force_download('./docs/'.$file, NULL);
    }
	



    function busca_p()
    {   $despacho=get_desp_id_usr();
		$emp_id_user=get_emp_id();
		$roots=get_my_user_root2();    
        $empresa = $this->input->post('empresa');
        $nombre  = strtoupper($this->input->post('nombre'));
		$nombre2 = strtoupper($this->input->post('nombre2'));
		$empleado =	strtoupper($this->input->post('empleado'));
		$receta=	strtoupper($this->input->post('receta'));
		$paterno  = strtoupper($this->input->post('paterno'));
		$materno  = strtoupper($this->input->post('materno'));
      /*  $rfc     = strtoupper($this->input->post('rfc'));
        $ubicacion     = strtoupper($this->input->post('ubicacion'));*/
        $data['clientes'] = $this->cliente->busca_p($empresa, $nombre, $nombre2,$paterno, $materno, $empleado, $receta,$despacho,$emp_id_user);
        
		send_json_ok($this->load->view('nx/busca_p',$data,TRUE));
    }

	
   public function borra($fsm_id)
    {
        if($this->cliente->borra_evaluado($fsm_id))
        {
            send_json_ok('Se eliminó de forma correcta.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar.');
        }
    }

/*************************************************************************************/
    public function lista_e()
    {   //date_default_timezone_set('America/Mexico_City');
	    //echo " Punto A ";
		$suc=get_sucursal_id();
		$user_despacho=get_desp_id_usr();
		$user_cei=get_cei_id();
		$user_root1=get_my_user_root1();
		$user = $this->session->user; 
		$medico = $this->medico->get($user['usr_id']);
		$emp_id=$user['emp_id'];
        $rows = 30;
        $this->load->library('pagination');
        $config['base_url'] = base_url('nx/lista_e/');
        //$config['total_rows'] = $this->cliente->count_all();
		$config['total_rows'] = $this->cliente->count_allo_e($emp_id,$suc,$user_despacho,$user_cei,$user_root1,1);
        
		$config['per_page'] = $rows;
        $config['attributes'] = array('class' => 'pagination');
        $config['full_tag_open'] = '<div class="pagination-full">';
        $config['full_tag_close'] = '</div>';
        $config['uri_segment'] = 3;
        $config['query_string_segment'] = 4;
        $config['use_page_numbers'] = TRUE;
        $this->pagination->initialize($config);
        //echo " Punto ".$medico['usr_emp_asig'];
		//echo " Punto B ";
        //$data['clientes'] = $this->cliente->get_all($rows);
		//echo " Punto ".$emp_id;
		$data['clientes'] = $this->cliente->get_allo_e($rows,$emp_id,get_sucursal_id(),$user_despacho,$user_cei,$user_root1,1);
		
		//echo " Punto C ";
		
        //$this->load->model('empresa/Empresa_model','empresa');
		//echo " Punto D ";
		
        //$data['empresas'] = $this->empresa->trae_empresas(1);//$this->empresa->get_all_empresas();
		//$data['empresas'] = $this->empresa->get_all_empresas_gsi();
		//echo " Punto E ";
        
        $this->load->helper('template');
        $params_view = array(
            'title' => 'Personas',
            'view' => 'nx/index_e',
            'view_data' => $data 
           );
        render_template($params_view);  
    }
/*************************************************************************************/
    public function lista_a()
    {   
	    //echo " Punto A ";
		$suc=get_sucursal_id();
		$user_despacho=get_desp_id_usr();
		$user_cei=get_cei_id();
		$user_root1=get_my_user_root1();
		$user = $this->session->user; 
		$medico = $this->medico->get($user['usr_id']);
		$emp_id=$user['emp_id'];
        $rows = 30;
        $this->load->library('pagination');
        $config['base_url'] = base_url('nx/lista_a/');
        //$config['total_rows'] = $this->cliente->count_all();
		$config['total_rows'] = $this->cliente->count_allo_a($emp_id,$suc,$user_despacho,$user_cei,$user_root1,1);
        
		$config['per_page'] = $rows;
        $config['attributes'] = array('class' => 'pagination');
        $config['full_tag_open'] = '<div class="pagination-full">';
        $config['full_tag_close'] = '</div>';
        $config['uri_segment'] = 3;
        $config['query_string_segment'] = 4;
        $config['use_page_numbers'] = TRUE;
        $this->pagination->initialize($config);
		//echo " Punto B ";
		//echo " Punto ".$emp_id;
		$data['clientes'] = $this->cliente->get_allo_a($rows,$emp_id,get_sucursal_id(),$user_despacho,$user_cei,$user_root1,1);
		
		//echo " Punto C ";
		//echo " Punto D ";
		//echo " Punto E ";
        
        $this->load->helper('template');
        $params_view = array(
            'title' => 'Personas',
            'view' => 'nx/index_a',
            'view_data' => $data 
           );
        render_template($params_view);  
    }
/*************************************************************************************/
    public function lista_b()
    {   
	    //echo " Punto A ";
		$suc=get_sucursal_id();
		$user_despacho=get_desp_id_usr();
		$user_cei=get_cei_id();
		$user_root1=get_my_user_root1();
		$user = $this->session->user; 
		$medico = $this->medico->get($user['usr_id']);
		$emp_id=$user['emp_id'];
        $rows = 30;
        $this->load->library('pagination');
        $config['base_url'] = base_url('nx/lista_b/');
        //$config['total_rows'] = $this->cliente->count_all();
		$config['total_rows'] = $this->cliente->count_allo_b($emp_id,$suc,$user_despacho,$user_cei,$user_root1,1);
        
		$config['per_page'] = $rows;
        $config['attributes'] = array('class' => 'pagination');
        $config['full_tag_open'] = '<div class="pagination-full">';
        $config['full_tag_close'] = '</div>';
        $config['uri_segment'] = 3;
        $config['query_string_segment'] = 4;
        $config['use_page_numbers'] = TRUE;
        $this->pagination->initialize($config);
		//echo " Punto B ";
		//echo " Punto ".$emp_id;
		$data['clientes'] = $this->cliente->get_allo_b($rows,$emp_id,get_sucursal_id(),$user_despacho,$user_cei,$user_root1,1);
		
		//echo " Punto C ";
		//echo " Punto D ";
		//echo " Punto E ";
        
        $this->load->helper('template');
        $params_view = array(
            'title' => 'Personas',
            'view' => 'nx/index_b',
            'view_data' => $data 
           );
        render_template($params_view);  
    }


    public function nuevo_e()
    {    
		$user = $this->session->user; 
		$medico = $this->medico->get($user['usr_id']);
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('nombre','Nombre','required');
            $this->form_validation->set_rules('paterno','Apellido Paterno','required');
            $this->form_validation->set_rules('materno','Apellido Materno','required');
            $this->form_validation->set_rules('fnac','Fecha de nacimiento','required');
            $this->form_validation->set_rules('genero','Género','required');

            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_nombre_crypt'] =  trim($this->input->post('nombre'));
                $data_clte['clte_2_nombre_crypt'] =  trim($this->input->post('nombre_adic'));
                $data_clte['clte_paterno_crypt'] =  trim($this->input->post('paterno'));
                $data_clte['clte_materno_crypt'] =  trim($this->input->post('materno'));
                
				$data_clte['clte_f_nac'] = formatea_fecha_mysql($this->input->post('fnac'));
                $data_clte['clte_genero_cve'] =  $this->input->post('genero');
      				
				$data_clte['clte_rfc_crypt'] =  $this->input->post('rfc');
                				
				$data_clte['clte_curp_crypt'] = ''; // $this->input->post('curp');
                $data_clte['empleado'] = 1;
                
                $data_clte['emp_id'] =$this->input->post('empresa');//$medico['usr_emp_asig'];
                $data_clte['clte_puesto'] = $this->input->post('puesto');
				$data_clte['num_empleado'] = $this->input->post('nempleado');
				
				//sucursal
                $data_clte['suc_id'] =0;
				$data_clte['cei_id'] =  4;

				$nomserv='NOM0351;NOM0352;NOM0353;';
				$data_clte['nomserv'] =  $nomserv;

 /***************************** CARGA DE LA FOTO DEL EVALUADO ************************/               
                if(!empty($_FILES['foto']['name']))
                {
                    $this->load->library('upload');
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/fotos/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg',
                            'max_size'      => '10000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('foto'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['clte_path_foto'] = $data['file_name'];
                    }
                }
/*************************************************************************************/
				$data_clte=array_to_upper($data_clte);
				
				if($cliente_id = $this->cliente->inserta(array_to_upper($data_clte)))
                {
                    send_json_ok(array('msg' =>'Se guardó de forma correcta', 'id' => $cliente_id));
                    
                }
                else
                {
                    send_json_error('Ocurrió un error al guardar la persona.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $this->load->model('empresa/Empresa_model','empresa');
            //$data['empresas'] = $this->empresa->get_all_empresas();
			$data['empresas'] =$this->empresa->get_all_empresas_gsi();
			$data['sucursals'] = $this->empresa->get_all_sucursales();
			$data['despachos'] = $this->empresa->get_all_despachos();
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'nx/add_e',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }


/*************************************************************************************/	
    function busca_e()
    {   $despacho=get_desp_id_usr();
		$emp_id_user=get_emp_id();
		$roots=get_my_user_root2();    
        $empresa = $emp_id_user; //$this->input->post('empresa');
        $nombre  = strtoupper($this->input->post('nombre'));
		$nombre2 = strtoupper($this->input->post('nombre2'));
		
		$empleado =	strtoupper($this->input->post('empleado'));
		$receta=	strtoupper($this->input->post('receta'));
		$paterno  = strtoupper($this->input->post('paterno'));
		$materno  = strtoupper($this->input->post('materno'));
        $data['clientes'] = $this->cliente->busca_e($empresa, $nombre, $nombre2,$paterno, $materno, $empleado, $receta,$despacho,$emp_id_user);
        
		send_json_ok($this->load->view('nx/busca_e',$data,TRUE));
    } 

 /*************************************************************************************/	
    function busca_a()
    {   $despacho=get_desp_id_usr();
		$emp_id_user=get_emp_id();
		$roots=get_my_user_root2();    
        $empresa = $emp_id_user; //$this->input->post('empresa');
        $nombre  = strtoupper($this->input->post('nombre'));
		$nombre2 = strtoupper($this->input->post('nombre2'));
		$paterno  = strtoupper($this->input->post('paterno'));
		$materno  = strtoupper($this->input->post('materno'));
        $data['clientes'] = $this->cliente->busca_a($empresa, $nombre, $nombre2,$paterno, $materno);
        
		send_json_ok($this->load->view('nx/busca_a',$data,TRUE));
    } 
 
}