<?php
/* 
 * Generated by CRUDigniter v2.3 Beta 
 * www.crudigniter.com
 */
 
class Agevento extends CI_Controller
{
    function __construct()
    {
        parent::__construct();
        $this->load->model('bitacora/Bitacora_model','registro');
		$this->load->model('util/Agenda_model','agenda');
		$this->load->helper('util');
    }

    /*
     * Listing of empresas
     */

    function index()
    {
        //echo "-1-";
		$rows = 30; //6;
		//$data['registros'] = $this->registro->get_allo_registros($rows);
		$data['eventos'] = $this->agenda->get_allo_eventos($rows);
		
		
        //echo "-2-";
        $this->load->library('pagination');
        $config['base_url'] = base_url('agevento/index/');
        //$config['total_rows'] = $this->registro->count_all();
		$config['total_rows'] = $this->agenda->count_all();
        $config['per_page'] = $rows;
        $config['attributes'] = array('class' => 'pagination');
        $config['full_tag_open'] = '<div class="pagination-full">';
        $config['full_tag_close'] = '</div>';
        $config['uri_segment'] = 3;
        $config['query_string_segment'] = 4;
        $config['use_page_numbers'] = TRUE;
        $this->pagination->initialize($config);
		//echo "-3-";
        $this->load->helper('template');
        $params_view = array(
            'title' => 'Eventos Agendados',
            'view' => 'agenda/index',
            'view_data' => $data 
           );
        render_template($params_view);  
    }


    public function reporte_dia()
    {
        $this->load->helper('template');
        $params_view = array(
            'title' => 'Inicio',
            'view' => 'agenda/rep_dia',
            'view_data' => $data
            );
        render_template($params_view);
    }


    function view_reporte_dia()
    {       
		//$f_ini = formatea_fecha_mysql($this->input->post('f_ini'));
        //$f_fin = formatea_fecha_mysql($this->input->post('f_fin'));	
		$f_ini = $this->input->post('f_ini');
        $f_fin = $this->input->post('f_fin');	
		$empresa = $this->input->post('empresa');
		$cei = $this->input->post('cei');		
		$data['eventos'] = $this->agenda->eventos_dia($empresa,$cei,$f_ini,$f_fin);
		$data['empresa'] = $empresa;
		$data['fecha'] = $f_ini;
		
		$sendmail = $this->input->post('sendmail');
		
		if ($sendmail == 'si')
		{	
			$this->load->helper('mail');
			$html = $this->load->view('agenda/mail_rep_dia',$data,TRUE);		
			send_mail_agenda_next_day('',$html,$empresa,$f_ini);

			//  phpinfo();
		
			/*$this->load->helper('mailer');
			manda_correo();*/
		}
		
		$this->load->helper('template');
        $params_view = array(
            'title' => 'Inicio',
            'view' => 'agenda/view_rep_dia',
            'view_data' => $data
            );
        render_template($params_view);

	}





    function busca()
    {        
       // $empresa = $this->input->post('empresa');   
        $nombre  = strtoupper($this->input->post('nombre'));
        $rfc     = strtoupper($this->input->post('rfc'));
        //$ubicacion     = strtoupper($this->input->post('ubicacion'));
        $data['empresas'] = $this->empresa->busca($nombre, $rfc);
        send_json_ok($this->load->view('empresa/busca',$data,TRUE));
    }



	

    function reporte_empresa_global()
    {
        //$data['empleados'] = $this->empleado->get_all();
		
        $this->load->model('empresa/Empresa_model','empresa');
        $data['empresas'] = $this->empresa->get_all_empresas();
        $this->load->helper('template');		
		?>
		
		<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
		<html xmlns="http://www.w3.org/1999/xhtml">

		<head>
		<meta content="es-mx" http-equiv="Content-Language" />
		<meta content="text/html; charset=utf-8" http-equiv="Content-Type" />
				<?php
					header("Content-type: application/octet-stream; charset=latin1");
					header("Content-Disposition: attachment; filename=Rep_Empresas.xls");
					header("Pragma: no-cache");
					header("Expires: 0");
				?>
			<title>REPORTE EMPRESAS</title>
				<style type="text/css">
					.auto-style1 {
						font-family: Arial, Helvetica, sans-serif;
						color: #FFFFFF;
						background-color: #3D5588;
						font-size: small;
					}
					.auto-style4 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: xx-small;
					}
					.auto-style5 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: medium;
					}
					.auto-style6 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: x-large;
						text-align: right;
						font-weight: normal;
					}
					.auto-style7 {
						font-size: small;
					}
					.auto-style8 {
						color: #3D5588;
					}
					.auto-style9 {
						color: #3AD4A7;
					}
								.auto-style11 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: small;
						text-align: right;
					}
					.auto-style12 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: small;
						text-align: center;
					}
					.auto-style13 {
						font-size: xx-small;
					}
					.auto-style14 {
						font-family: Arial, Helvetica, sans-serif;
						color: #FFFFFF;
						background-color: #3D5588;
						font-size: xx-small;
					}
					.auto-style15 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: x-small;
					}
					.auto-style16 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: x-small;
						text-align: right;
					}
					.auto-style17 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: x-small;
						text-align: left;
					}
					.auto-style18 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: xx-small;
						text-align: center;
					}
								.auto-style19 {
						color: #3D5588;
						font-size: medium;
					}
					.auto-style20 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: xx-small;
						text-align: center;
						background-color: #BFEADD;
					}
					.auto-style21 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: xx-small;
						background-color: #BFEADD;
					}
				</style>
			</head>
				<?php
					date_default_timezone_set('America/Mexico_City');
					$date2today = date("Y-m-d H:i:s");
				?>			
			<body>
				<table>
					<thead>
						<tr>
							<th class="auto-style5" style="width: 82px">&nbsp;</th>
							<th class="auto-style5" style="width: 325px">&nbsp;</th>
							<th class="auto-style5" style="width: 82px">&nbsp;</th>
							<th class="auto-style5" style="width: 82px">&nbsp;</th>
							<th class="auto-style5" style="width: 150px">&nbsp;</th>
							<th class="auto-style26" style="width: 424px">&nbsp;</th>
						</tr>
						<tr>
							<th class="auto-style5" style="width: 82px">&nbsp;</th>
							<th class="auto-style6" style="width: 325px"><strong><span class="auto-style8">human</span><span class="auto-style9">center</span></strong></th>
							<th class="auto-style5" style="width: 82px">&nbsp;</th>
							<th class="auto-style5" style="width: 82px">&nbsp;</th>
							<th class="auto-style5" style="width: 150px">&nbsp;</th>
							<th class="auto-style5" style="width: 424px">Reporte Global de Empresas 
							en Plataforma</th>
						</tr>

						<tr>
							<th class="auto-style5" style="width: 82px">&nbsp;</th>
							<th class="auto-style6" style="width: 325px;"><span class="auto-style19">online</span><sup><span class="auto-style13" style="color: rgb(34, 34, 34); font-family: arial, sans-serif; font-style: normal; font-variant-ligatures: normal; font-variant-caps: normal; font-weight: 400; letter-spacing: normal; orphans: 2; text-align: left; text-indent: 0px; text-transform: none; white-space: normal; widows: 2; word-spacing: 0px; -webkit-text-stroke-width: 0px; background-color: rgb(255, 255, 255); text-decoration-style: initial; text-decoration-color: initial; display: inline !important; float: none;">®</span></sup></th>
							<th class="auto-style5" style="width: 82px">&nbsp;</th>
							<th class="auto-style5" style="width: 82px">&nbsp;</th>
							<th class="auto-style5" style="width: 150px">&nbsp;</th>
							<th class="auto-style5" style="width: 424px; height: 27px;"><?php echo $date2today; ?></th>
						</tr>
						<tr>
							<th class="auto-style5" style="width: 82px">&nbsp;</th>
							<th class="auto-style5" style="width: 325px">&nbsp;</th>
							<th class="auto-style5" style="width: 82px">&nbsp;</th>
							<th class="auto-style5" style="width: 82px">&nbsp;</th>
							<th class="auto-style5" style="width: 150px">&nbsp;</th>
							<th class="auto-style5" style="width: 424px">&nbsp;</th>
						</tr>
						<tr>
							<th class="auto-style5" style="width: 82px">&nbsp;</th>
							<th class="auto-style5" style="width: 325px">&nbsp;</th>
							<th class="auto-style5" style="width: 82px">&nbsp;</th>
							<th class="auto-style5" style="width: 82px">&nbsp;</th>
							<th class="auto-style5" style="width: 150px">&nbsp;</th>
							<th class="auto-style5" style="width: 424px">&nbsp;</th>
						</tr>
					</thead>						
				</table>
				<table>
					<thead>				
						<tr>
							<th class="auto-style14" style="width: 50px">ID</th>
							<th class="auto-style14" style="width: 330px">Razón Social</th>
							<th class="auto-style14" style="width: 100px">RFC</th>
							<th class="auto-style14" style="width: 300px">Contacto</th>
							<th class="auto-style14" style="width: 80px">Tel. Contacto</th>
							<th class="auto-style14" style="width: 300px">EMAIL Contacto</th>
							<th class="auto-style14" style="width: 90px">Cotización</th>
							<th class="auto-style14" style="width: 80px">Evaluados</th>
							<th class="auto-style14" style="width: 80px">Estatus</th>
							<?php
								$cat_examen = get_cat_nombre_var('EXAMEN');
								if($cat_examen): 
									foreach($cat_examen as $examen): ?>
										<th class="auto-style14" style="width: 80px"><?php echo $examen['cat_nombre'];?></th>
	                            <?php
									endforeach; 
                                endif;?> 							
						</tr>
					</thead>
					<tbody id="resultado">
						<?php
						$class18=" ";
						if($data['empresas']): 
							foreach ($data['empresas'] as $empresa): 
							
								if ($class18 != "auto-style18")
								{
									$class18="auto-style18";
									$class4="auto-style4";
								}	
								else
								{
									$class18="auto-style20";
									$class4="auto-style21";							
								}							
							
							?>
								<tr>
									<td class=<?php echo $class18; ?>><?php echo $empresa['emp_id']; ?></td>
									<td class=<?php echo $class18; ?>><?php echo get_code_html($empresa['emp_razon_social']); ?></td> 
									<td class=<?php echo $class18; ?>><?php echo $empresa['emp_rfc']; ?></td> 
									<td class=<?php echo $class18; ?>><?php echo get_code_html($empresa['emp_responsable']); ?></td>
									<td class=<?php echo $class18; ?>><?php echo $empresa['emp_telefono']; ?></td>
									<td class=<?php echo $class18; ?>><?php echo $empresa['emp_correo']; ?></td>
									<?php 
									$d= $this->empresa->get_una_cotizacion($empresa['emp_id']);
									if (strlen($d['doc_path']) > 0)
									{?>
										<td class=<?php echo $class18; ?>><?php echo get_code_html('CON COTIZACIÓN'); ?></td>	
									<?php  }	
									else
									{ ?>
										<td class=<?php echo $class18; ?>><?php echo get_code_html('SIN COTIZACIÓN'); ?></td>	
									<?php }	
									?>
									
									<td class=<?php echo $class18; ?>><?php echo $empresa['empleados']; ?></td>
									<td class=<?php echo $class18; ?>><?php echo $empresa['emp_estatus_cve']; ?></td>									
									<?php
										$cat_examen = get_cat_nombre_var('EXAMEN');
										$examenes = $this->empresa->get_examenes($empresa['emp_id']);
										if($cat_examen): 
											foreach($cat_examen as $examen): 
												$costo = get_costo_unitario($examen, $examenes);?>
												<td class=<?php echo $class18; ?>><?php echo $costo['cost_monto'];?></th>
										<?php
											endforeach; 
										endif;?> 	
								</tr>
							<?php 
							endforeach;
						endif;
						?> 
					</tbody>
				</table>
			</body>
		</html>
		<?php 
	}
	


    /*
     * Adding a new empresa
     */
    
    function find()
    {
        $term = $this->input->get('term');
        $empresas = $this->empresa->find_empresa($term);
        $empresas_formated = array();
        foreach ($empresas as $empresa) {
            $empresas_formated[] = array('label' => $empresa['emp_nombre'],'value' => $empresa['emp_id']);
        }
        echo json_encode($empresas_formated);
    }
    
    function get($emp_id)
    {
        if($emp_id)
        {
            send_json('OK',$this->empresa->get_empresa($emp_id));
        }
        else
        {
            send_json('ERROR','');
        }
    }
    










	
	
	


	
}