<?php 
defined('BASEPATH') OR exit('No direct script access allowed');

class Perfil_psicologico extends CI_Controller {
    function __construct() {
        parent::__construct();
        $this->load->model('persona/Persona_model','cliente');
		$this->load->model('servicio/Servicio_model','servicio');
        $this->load->model('empleado/Empleado_model','medico');
        $this->load->model('examen/Perfil_psicologico_model','psico');
		$this->load->model('examen/Salud_ocupacional_model','salud_ocupacional');



		$this->load->helper('util');
    }
    
    public function nuevo($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
        $user = $this->session->user;
     if(isset($_POST) && count($_POST) > 0)     
        { $this->load->library('form_validation');
		    
            $this->form_validation->set_rules('coeficiente','coeficiente','required');
            $this->form_validation->set_rules('test_personalidad','coeficiente','required');
            $this->form_validation->set_rules('test_gestaltico','coeficiente','required');
            if($this->form_validation->run())
            {
                $data_insert['emp_id']  = $persona['emp_id'];
                $data_insert['clte_id'] = $persona['clte_id'];
                $data_insert['usr_id']  = $user['usr_id'];
                $data_insert['serv_id']  = $this->input->post('servicio');
        	/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
                $data_insert['med_id']  = $user['usr_id'];
                $data_insert['fsm_f']   = date("Y-m-d H:i:s");
                $data_insert['fsm_coeficiente']  = $this->input->post('coeficiente');
                $data_insert['fsm_test_personalidad']  = $this->input->post('test_personalidad');
                $data_insert['fsm_test_gestaltico']  = $this->input->post('test_gestaltico');
           
                $data_insert['fsm_psicologo'] = $this->input->post('psicologo');

                $medico = $this->medico->get_id($this->input->post('psicologo'));
                $data_insert['fsm_psicologo_cedula'] = $medico['usr_cedula'];
                $data_insert['fsm_psicologo_carrera'] = $medico['usr_carrera'];
                
                $data_insert['log_insrt_f']   = date("Y-m-d H:i:s");
                $data_insert['log_insrt_usr_cve']  =  $user['usr_username'] ;
                
              
                if($this->psico->insert(array_to_upper($data_insert)))
                {
                    send_json_ok('Se guardó de forma correcta');

                }
                else
                {
                    send_json_error('Ocurrió un error al guardar.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
            $data['medico'] = $medico;
			/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
			//$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);
			/**************************************************/			
            $this->load->helper('template');
            $params_view = array(
                'title' => '',
                'view' => 'examen/perfil_psicologico/nuevo_perfil_psicologico',
                'view_data' => $data 
               );
            render_template($params_view);
        }
    }


    public function editar_PERFPSC($cliente_id,$fsm_id) 
    {

        $persona = $this->cliente->get($cliente_id);
        $user = $this->session->user;
	
     
        $data_insert['serv_id']  = $this->input->post('servicio');
        $data['persona'] = $this->cliente->get($cliente_id,get_desp_id_usr());
        $data['fsm'] = $this->psico->get_PERFPSC($fsm_id);
        $data['medico'] = $this->medico->get_id($data['fsm']['med_id']);
        $data['empresa'] = $this->cliente->get_empresa_by_id($data['fsm']['emp_id']);
       
      if(isset($_POST) && count($_POST) > 0)     
        { $this->load->library('form_validation');
		    
            //$this->form_validation->set_rules('fsm_fis_loc_cve','Locomoción','required');
           
            if(/*$this->form_validation->run()*/1)
            {
                $data_update['emp_id']  = $persona['emp_id'];
                $data_update['clte_id'] = $persona['clte_id'];
                $data_update['usr_id']  = $user['usr_id'];
                $data_update['med_id']  = $user['usr_id'];
                
                if($this->input->post('fecha_consulta')>0){
                    $data_update['fsm_f']   =   formatea_fecha_mysql($this->input->post('fecha_consulta'));
                }
                      
                $data_update['fsm_coeficiente']  = $this->input->post('coeficiente');
                $data_update['fsm_test_personalidad']  = $this->input->post('test_personalidad');
                $data_update['fsm_test_gestaltico']  = $this->input->post('test_gestaltico');
                $data_update['fsm_psicologo'] = $this->input->post('psicologo');

                $medico = $this->medico->get_id($this->input->post('psicologo'));
                $data_update['fsm_psicologo_cedula'] = $medico['usr_cedula'];
                $data_update['fsm_psicologo_carrera'] = $medico['usr_carrera'];
                   
               $data_update['log_updt_f']  =date("Y-m-d H:i:s") ;
               $data_update['log_updt_usr_cve']  =  $user['usr_username'] ;
                
                $data_update=array_to_upper($data_update);

			              
                if($this->psico->actualizar($fsm_id,$data_update))
                {
                    send_json_ok('Se actualizo de forma correcta');

                }
                else
                {
                    send_json_error('Ocurrió un error al actualizar el registro.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
            $data['medico'] = $medico;
			/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
			//$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);
			/**************************************************/			
            $this->load->helper('template');
            $params_view = array(
                'title' => '',
                'view' => 'examen/perfil_psicologico/edita_perfil_psicologico',
                'view_data' => $data 
               );
            render_template($params_view);
        }

    }




    public function spy($cliente_id, $fsm_id) 
    {
        $persona = $this->cliente->get($cliente_id,get_desp_id_usr());
        $fsm = $this->psico->get($fsm_id,get_desp_id_usr());
        $medico = $this->medico->get_id($data['fsm']['med_id']);
        $empresa = $this->cliente->get_empresa_by_id($data['fsm']['emp_id']);
		$user = $this->session->user;
		$usuario = $this->medico->get($user['usr_id']);	
	
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');

			if (($persona['serv_id'] == 0) /*||(get_status_serv($persona['serv_id']) != 'PROCESO') */)
			{					
					$this->form_validation->set_rules('servicio','Orden de servicio','required');
			}
			else
			{
					$this->form_validation->set_rules('servicio','Orden de servicio','integer');
			}

            if($this->form_validation->run())
            {

				if (($persona['serv_id'] == 0) /*|| (get_status_serv($persona['serv_id']) != 'PROCESO')*/)
				{	
					$data_insert['serv_id']  = $this->input->post('servicio');
				}
				else
				{	
                    $data_insert['serv_id']  = $persona['servicio'];
				}
			
				 $data_insert['fsm_f']   =  $this->input->post('f_registro');
				 $data_insert['log_insrt_f']   =  $this->input->post('f_registro');
				 $data_insert['log_insrt_usr_cve']   =  $usuario['usr_username'];
				 $data_insert['log_insrt_prg']   =  "FUE SPY";
				 
				$data_insert['log_updt_usr_cve']   =  $fsm['log_updt_usr_cve'] + 1; ;					
				$data_insert=array_to_upper($data_insert);

			
		        if($this->psico->actualizar($fsm_id,$data_insert))
                {
                    send_json_ok('Se guardó de forma correcta.');
                }
                else
                {
                    send_json_error('Ocurrió un error al guardar.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
			$data['persona'] =$persona ;
			$data['fsm'] = $fsm;
			$data['medico'] = $medico;
			$data['empresa'] = $empresa;
			$data['usuario'] = $usuario;
			$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);
            $this->load->helper('template');
            $params_view = array(
                'title' => '',
                'view' => 'examen/perfil_psicologico/spy',
                'view_data' => $data 
               );
            render_template($params_view);
        }
    }
                
          
     



    public function pdf_PERFPSC($cliente_id, $fsm_id)
    {
        

        $user = $this->session->user;
        $data['persona'] = $this->cliente->get($cliente_id,get_desp_id_usr());
        $data['fsm'] = $this->psico->get_PERFPSC($fsm_id);
        $data['medico'] = $this->medico->get_id($data['fsm']['med_id']);
        $data['empresa'] = $this->cliente->get_empresa_by_id($data['fsm']['emp_id']);
        $reporte=$user['usr_id'].'_'.$data['fsm']['emp_id'].'_'.date("Ymd_His");
		$this->load->helper('pdf');
		$ruta=base_url('../dist/images/hclogo.jpg');
		genera_pdf_lab_new_y($this->load->view('examen/perfil_psicologico/pdf_perfil_psicologico',$data,TRUE),$reporte,$user['usr_id']);

       
    }

  




    public function borra($fsm_id)
    {
        if($this->psico->borra($fsm_id))
        {
            send_json_ok('Se eliminó de forma correcta.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar.');
        }
    }		
	
	
}