﻿<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Quimica_sanguinea12 extends CI_Controller {
    function __construct() {
        parent::__construct();
        $this->load->model('persona/Persona_model','cliente');
		$this->load->model('servicio/Servicio_model','servicio');
        $this->load->model('empleado/Empleado_model','medico');
        $this->load->model('examen/Quimica_sanguinea12_model','qui_san12');
		$this->load->helper('laboratorium');
		$this->load->helper('util');
		$this->load->helper('report');
    }
    
    public function nuevo($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
        $user = $this->session->user;
       
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
			if (($persona['serv_id'] == 0) ||(get_status_serv($persona['serv_id']) != 'PROCESO'))
			{					
					$this->form_validation->set_rules('servicio','Orden de servicio','required');
			}
			else
			{
					$this->form_validation->set_rules('servicio','Orden de servicio','integer');
			}

			$this->form_validation->set_rules('glucosa','GLUCOSA BASAL','required');
			//$this->form_validation->set_rules('urea','UREA','required');
			//$this->form_validation->set_rules('creatinina','CREATININA','required');
			//$this->form_validation->set_rules('acidourico','ÁCIDO URICO','required');
			//$this->form_validation->set_rules('got-ast','ASPARTATO AMINOTRANSFERASA (GOT/AST)','required');
			//$this->form_validation->set_rules('ggt','GAMMA GLUTAMIL TRANSFERASA (GGT)','required');
			$this->form_validation->set_rules('billi-total','BILIRRUBINA TOTAL','required');
			$this->form_validation->set_rules('billi-directa','BILIRRUBINA DIRECTA','required');  
			$this->form_validation->set_rules('billi-indirecta','BILIRRUBINA INDIRECTA','required');
			//$this->form_validation->set_rules('colesterol-total','COLESTEROL TOTAL','required');
			//$this->form_validation->set_rules('colesterol-ldl','COLESTEROL LDL','required'); 
			$this->form_validation->set_rules('trigliceridos','TRIGLICÉRIDOS','required'); 
			//$this->form_validation->set_rules('relacion-col-hdl','RELACIÓN COL/HDL','required');
			
            if($this->form_validation->run())
            {
                $data_insert['usr_id']  = $user['usr_id']; 
				$data_insert['med_id']  = $this->input->post('laboratorista'); 
				
                $data_insert['clte_id'] = $persona['clte_id'];
                $data_insert['emp_id']  = $persona['emp_id'];
				
				if (($persona['serv_id'] == 0) || (get_status_serv($persona['serv_id']) != 'PROCESO'))
				{	
						$data_insert['serv_id']  = $this->input->post('servicio');
				}
				else
				{	
						$data_insert['serv_id']  = $persona['serv_id'];
				}
				
				$data_insert['qui_medico_sol'] = $this->input->post('medico_sol');
				
				$data_insert['qui_f_recibido']   = formatea_fecha_mysql($this->input->post('fecha_rec')); //date('Y-m-d H:i:s'); 
                $data_insert['qui_f_impresion']  = formatea_fecha_mysql($this->input->post('fecha_imp')); //date('Y-m-d H:i:s');
                $data_insert['log_insrt_f']  =  date('Y-m-d H:i:s');

				/*nueva estrutura para control de laboratorios*/
				$data_insert['qui_metodo'] = $this->input->post('laboratorio_metodo');
				$metodo=$this->input->post('laboratorio_metodo');


				if ($metodo==1)
				{	
					$data_insert['qui_glucosa']      =	$this->input->post('glucosa');
					$data_insert['qui_urea']=	$this->input->post('urea');
					$data_insert['qui_creatinina']=	$this->input->post('creatinina');
					$data_insert['qui_acidourico']=	$this->input->post('acidourico');
					$data_insert['qui_got-ast']   =	$this->input->post('got-ast');
					$data_insert['qui_ggt']=	$this->input->post('ggt');               
					$data_insert['qui_billi-total']=	$this->input->post('billi-total');
					$data_insert['qui_billi-directa']=	$this->input->post('billi-directa');
					$data_insert['qui_billi-indirecta']=	$this->input->post('billi-indirecta'); 
					$data_insert['qui_colesterol-total']=	$this->input->post('colesterol-total');
					$data_insert['qui_colesterol-ldl']=	$this->input->post('colesterol-ldl');                
					$data_insert['qui_trigliceridos']=	$this->input->post('trigliceridos');
					$data_insert['qui_relacion-col-hdl']=	$this->input->post('relacion-col-hdl');
				}
				elseif ($metodo==2)
				{	
					$data_insert['qui_glucosa']      =	$this->input->post('glucosa');
					$data_insert['qui_fosforo']=	$this->input->post('fosforo');
					
					$data_insert['qui_calcio_serico']=	$this->input->post('calcio_serico');
					$data_insert['qui_ldh']=	$this->input->post('ldh');
					$data_insert['qui_fosfatasa_alacalina']=	$this->input->post('fosfatasa_alacalina');
					$data_insert['qui_tgo']=	$this->input->post('tgo');
					
					$data_insert['qui_billi-total']=	$this->input->post('billi-total');
					$data_insert['qui_billi-directa']=	$this->input->post('billi-directa');
					$data_insert['qui_billi-indirecta']=	$this->input->post('billi-indirecta');
					
					$data_insert['qui_albumina-globulina']=	$this->input->post('albumina-globulina');
					$data_insert['qui_globulina']=	$this->input->post('globulina');
					$data_insert['qui_albumina_en_suero']=	$this->input->post('albumina_en_suero');
					$data_insert['qui_proteinas_totales']=	$this->input->post('proteinas_totales');
					
					$data_insert['qui_trigliceridos']=	$this->input->post('trigliceridos');
					
					$data_insert['qui_colesterol_total']=	$this->input->post('colesterol_total');
					$data_insert['qui_acido_urico_en_suero']=	$this->input->post('acido_urico_en_suero');
					$data_insert['qui_creatinina_serica']=	$this->input->post('creatinina_serica');
					$data_insert['qui_urea_en_suero']=	$this->input->post('urea_en_suero');
					$data_insert['qui_bun']=	$this->input->post('bun');
				}				
								
				$data_insert['qui_lab'] = $this->input->post('laboratorista');
				
				
				$data_insert= array_to_upper($data_insert);				
				$data_insert['qui_obs']  = $this->input->post('q_sang_obs');
				//$data_insert['qui_fuera_rango'] = $this->input->post('fuera_rango');
                //$data_insert['log_insrt_f']  =  date('Y-m-d H:i:s');
                if($this->qui_san12->insert($data_insert) && ($metodo!=0) )
                {
                    send_json_ok('Se guardó de forma correcta');
					$servicios=$persona['domserv'];					
					
					$servicio='QS12;'; 
					if (!(strstr($servicios,$servicio)))
					{							
						$servicios.=$servicio;
						$data_clte['domserv']=$servicios;
						$res=$this->cliente->actualiza_registro_individual($cliente_id, $data_clte);
					}
                }
                else
                {
                    send_json_error('Ocurrió un error al guardar.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
            $data['medico'] = $medico;
			$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);
            $this->load->helper('template');
            $params_view = array(
                'title' => '',
                'view' => 'examen/quimica_sanguinea12/nuevo_form',
                'view_data' => $data 
               );
            render_template($params_view);
        }
    }
    
    public function pdf($cliente_id, $fsm_id)
    {
        $data['persona'] = $this->cliente->get($cliente_id,get_desp_id_usr());
        $data['fsm'] = $this->qui_san12->get($fsm_id,get_desp_id_usr());
        $data['medico'] = $this->medico->get_id($data['fsm']['med_id']);
        $data['empresa'] = $this->cliente->get_empresa_by_id($data['fsm']['emp_id']);
        $this->load->helper('pdf');
		
		$med_name=$data['fsm']['qui_lab']; //'Q.F.B. JAIMES FLORES MONTSERRAT    11322160                                                                                                                        ';
		$emp_id=$data['fsm']['emp_id'];
		$observaciones=$data['fsm']['qui_obs'];
		$fuera_rango=$data['fsm']['qui_fuera_rango'];
		$data_empresa = $this->cliente->get_empresa_by_id($emp_id);	
		
	/*	if ($data_empresa['emp_giro'] == 'SEGURIDAD')
		{
			$med_name=$data['fsm']['qui_lab']; //'Q.F.B. JAIMES FLORES MONTSERRAT    11322160                                                                                                                        ';
			genera_pdf_tohuanti($this->load->view('examen/quimica_sanguinea12/pdf',$data,TRUE),'quimica_sanguinea12','quimica_sanguinea12','quimica_sanguinea12');
		}
		else*/
		{	
			//$med_name=agrega_cedula($med_name,'Cédula Profesional:');
			//genera_pdf_lab_new($this->load->view('examen/quimica_sanguinea12/pdf',$data,TRUE),'quimica_sanguinea12','quimica_sanguinea12',$med_name,$observaciones,$fuera_rango);	

			$med_name=agrega_cedula_ext($data['fsm']['med_id']);
			genera_pdf_lab_new_x($this->load->view('examen/quimica_sanguinea12/pdf',$data,TRUE),'quimica_sanguinea12','quimica_sanguinea12',$med_name,$observaciones,$fuera_rango);			
		}	   
	   /* esta versión numera las hojas
			genera_pdf_lab_new_l($this->load->view('examen/quimica_sanguinea38/pdf',$data,TRUE),'quimica_sanguinea38','quimica_sanguinea38',$med_name,$observaciones, $ruta);		
       */
	}
	

    public function borra_qui_san($fsm_id)
    {
        if($this->qui_san12->delete_qui_san($fsm_id))
        {
            send_json_ok('Se eliminó de forma correcta.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar.');
        }
    }
	
	
}
