﻿<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Institucion extends CI_Controller {
    
    function __construct() {
        parent::__construct();
        $this->load->model('institucion/Institucion_model','cliente');
        $this->load->model('empleado/Empleado_model','medico');
    }
    
    public function lista()
    {
        $rows = 30;
        $this->load->library('pagination');
        $config['base_url'] = base_url('institucion/lista/');
        $config['total_rows'] = $this->cliente->count_all();
        $config['per_page'] = $rows;
        $config['attributes'] = array('class' => 'pagination');
        $config['full_tag_open'] = '<div class="pagination-full">';
        $config['full_tag_close'] = '</div>';
        $config['uri_segment'] = 3;
        $config['query_string_segment'] = 4;
        $config['use_page_numbers'] = TRUE;
        $this->pagination->initialize($config);
        
        $data['clientes'] = $this->cliente->get_all($rows);
        $data['empresas'] = $this->cliente->get_empresas();
        
        $this->load->helper('template');
        $params_view = array(
            'title' => 'Personas',
            'view' => 'protocolo/index',
            'view_data' => $data 
           );
        render_template($params_view);  
    }
    
    public function id($id)
    {
        $data['cliente'] = $this->cliente->get($id);
        if(1)
        {	$id=24;
        /*    $this->load->model('examen/Entorno_social_model','entorno_social');
            $this->load->model('examen/Socioeconomico_model','socio_economico');
            $this->load->model('examen/Poligrafico_model','poligrafico');
            $this->load->model('examen/Medico_fisico_model','medico_fisico');
            $this->load->model('examen/Psicologico_model','psicologico');
            $this->load->model('examen/Toxicologico_model','toxicologico');
            $this->load->model('examen/Acreditacion_model','acreditacion');
            $this->load->model('examen/Historia_clinica_model','historia_clinica');*/
            $user = $this->session->user;

            $data['medico']=$user;
         /*   $data['socio_economicos'] = $this->socio_economico->get_by_clte($id);
            $data['entorno_social'] = $this->entorno_social->get_by_clte($id);
            $data['fsms_02'] = $this->poligrafico->get_by_clte($id,'POLI');
            $data['fsmsc_02'] = $this->poligrafico->get_by_clte($id,'CEDULA');
            $data['fsms_04'] = $this->medico_fisico->get_by_clte($id);
            $data['fsms_05'] = $this->psicologico->get_by_clte($id);
            $data['fsms_06'] = $this->toxicologico->get_by_clte($id);
            $data['fsms_03'] = $this->acreditacion->get_by_clte($id);
            $data['fsms_lala'] = $this->historia_clinica->get_by_clte($id);*/
            
            $data['docs'] = $this->cliente->get_docs_emp($id,$user['emp_id']);
            $this->load->helper('template');
			$this->load->helper('util');
            $params_view = array(
                'title' => 'Institucion',
                'view' => 'institucion/cliente',
                'view_data' => $data 
               );
            render_template($params_view);  
        }
        else
        {
            show_error('El cliente no existe.');
        }
    }
    
    public function edita($cliente_id)
    {
        $cliente = $this->cliente->get($cliente_id);
        
        if($cliente)
        {

            if(isset($_POST) && count($_POST) > 0)     
            {
                $this->load->library('form_validation');
                $this->form_validation->set_rules('nombre','Nombre','required');
                $this->form_validation->set_rules('paterno','Apellido Paterno','required');
                $this->form_validation->set_rules('materno','Apellido Materno','required');
                $this->form_validation->set_rules('fnac','Fecha de nacimiento','required');
                $this->form_validation->set_rules('genero','Género','required');
                //$this->form_validation->set_rules('civil','Estado civil','required');
                //$this->form_validation->set_rules('rfc','RFC','required');
                //$this->form_validation->set_rules('curp','CURP','required');

                if($this->form_validation->run())
                {
                    //informncion general de la pérsona
                    $data_clte['clte_nombre_crypt'] =  $this->input->post('nombre');
                    $data_clte['clte_2_nombre_crypt'] =  $this->input->post('nombre_adic');
                    $data_clte['clte_paterno_crypt'] =  $this->input->post('paterno');
                    $data_clte['clte_materno_crypt'] =  $this->input->post('materno');
                    $data_clte['clte_f_nac'] = formatea_fecha_mysql($this->input->post('fnac'));
                    $data_clte['clte_genero_cve'] =  $this->input->post('genero');
                    $data_clte['clte_rfc_crypt'] =  $this->input->post('rfc');
                    $data_clte['clte_curp_crypt'] =  $this->input->post('curp');

                    //dopmcicio de la persona
                    $data_clte['clte_env_pais_cve'] =  $this->input->post('pais');
                    $data_clte['clte_env_cp'] =  $this->input->post('cp');
                    $data_clte['clte_env_edo_cve'] =  $this->input->post('entidad');
                    $data_clte['clte_env_colonia_crypt'] =  $this->input->post('colonia');
                    $data_clte['clte_env_localidad'] =  $this->input->post('localidad');
                    $data_clte['clte_env_municipio'] =  $this->input->post('municipio');
                    $data_clte['clte_env_calle_crypt'] =  $this->input->post('calle');
                    $data_clte['clte_env_num_ext_crypt'] =  $this->input->post('next');
                    $data_clte['clte_env_num_int_crypt'] =  $this->input->post('nint');

                    //informacion de conrtaxcto de la persona
                    $data_clte['clte_tel_casa_crypt'] = limpia_telefono($this->input->post('tel'));                
                    $data_clte['clte_cel_crypt'] =  limpia_telefono($this->input->post('cel'));
                    $data_clte['clte_email_crypt'] =  $this->input->post('correo');

                    //nuevos campos
                    $data_clte['clte_grado_acad_cve'] =  $this->input->post('grado');
                    $data_clte['clte_puesto'] =  $this->input->post('puesto');
                    $data_clte['clte_edo_civ_cve'] =  $this->input->post('civil');
                    $data_clte['clte_nac_cve'] =  $this->input->post('nac');

                    //empresa donde va a loborar la persona
                    $data_clte['emp_id'] =  $this->input->post('empresa');
                    
                    //nuevo cambpo de unicacion
                    $data_clte['clte_lab_ubicacion'] =  $this->input->post('ubicacion');

                    if(!empty($_FILES['foto']['name']))
                    {
                        $this->load->library('upload');
                        $filename = md5(time());
                        $config = array(
                                'upload_path'   => './../../files/fotos/',
                                'overwrite'     => TRUE,
                                'file_name'     => $filename,
                                'allowed_types' => 'png|jpg|jpeg',
                                'max_size'      => '10000'
                        );

                        $this->upload->initialize($config);
                        if ( ! $this->upload->do_upload('foto'))
                        {
                            send_json_error($this->upload->display_errors());
                        }
                        else 
                        {
                            $data = $this->upload->data();
                            $data_clte['clte_path_foto'] = $data['file_name'];
                        }
                    }

                    if($this->cliente->actualiza($cliente_id, array_to_upper($data_clte)))
                    {
                        send_json_ok('Se actualizó de forma correcta');
                    }
                    else
                    {
                        send_json_error('Ocurrió un error al actualizar la persona.');
                    }
                }
                else
                {
                    send_json_error(validation_errors('<div />'));
                }
            }
            else 
            {
                $this->load->model('empresa/Empresa_model','empresa');
                $data['empresas'] = $this->empresa->get_all_empresas();
                $data['persona'] = $cliente;
                $this->load->helper('template');
                $params_view = array(
                    'title' => 'Personas',
                    'view' => 'persona/edit',
                    'view_data' => $data
                   );
                render_template($params_view);  
            }
        }
        else 
        {
            show_error('No existe el cliente');
        }
    }
    
    public function nuevo()
    {
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('nombre','Nombre','required');
            $this->form_validation->set_rules('paterno','Apellido Paterno','required');
            $this->form_validation->set_rules('materno','Apellido Materno','required');
            $this->form_validation->set_rules('fnac','Fecha de nacimiento','required');
            $this->form_validation->set_rules('genero','Género','required');
            //$this->form_validation->set_rules('civil','Estado civil','required');
            //$this->form_validation->set_rules('rfc','RFC','required');
            //
            //$this->form_validation->set_rules('curp','CURP','required');

            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_nombre_crypt'] =  $this->input->post('nombre');
                $data_clte['clte_2_nombre_crypt'] =  $this->input->post('nombre_adic');
                $data_clte['clte_paterno_crypt'] =  $this->input->post('paterno');
                $data_clte['clte_materno_crypt'] =  $this->input->post('materno');
                $data_clte['clte_f_nac'] = formatea_fecha_mysql($this->input->post('fnac'));
                $data_clte['clte_genero_cve'] =  $this->input->post('genero');
                $data_clte['clte_rfc_crypt'] =  $this->input->post('rfc');
                $data_clte['clte_curp_crypt'] =  $this->input->post('curp');
                
                //dopmcicio de la persona
                $data_clte['clte_env_pais_cve'] =  $this->input->post('pais');
                $data_clte['clte_env_cp'] =  $this->input->post('cp');
                $data_clte['clte_env_edo_cve'] =  $this->input->post('entidad');
                $data_clte['clte_env_colonia_crypt'] =  $this->input->post('colonia');
                $data_clte['clte_env_localidad'] =  $this->input->post('localidad');
                $data_clte['clte_env_municipio'] =  $this->input->post('municipio');
                $data_clte['clte_env_calle_crypt'] =  $this->input->post('calle');
                $data_clte['clte_env_num_ext_crypt'] =  $this->input->post('next');
                $data_clte['clte_env_num_int_crypt'] =  $this->input->post('nint');
                
                //informacion de conrtaxcto de la persona
                $data_clte['clte_tel_casa_crypt'] =  limpia_telefono($this->input->post('tel'));                
                $data_clte['clte_cel_crypt'] =  limpia_telefono($this->input->post('cel'));
                $data_clte['clte_email_crypt'] =  $this->input->post('correo');
                
                //nuevos campos
                $data_clte['clte_grado_acad_cve'] =  $this->input->post('grado');
                $data_clte['clte_puesto'] =  $this->input->post('puesto');
                $data_clte['clte_edo_civ_cve'] =  $this->input->post('civil');
                $data_clte['clte_nac_cve'] =  $this->input->post('nac');
                
                //empresa donde va a loborar la persona
                $data_clte['emp_id'] =  $this->input->post('empresa');
                
                //nuevo campo de ubicacion
                $data_clte['clte_lab_ubicacion'] =  $this->input->post('ubicacion');
                
                if(!empty($_FILES['foto']['name']))
                {
                    $this->load->library('upload');
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/fotos/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg',
                            'max_size'      => '10000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('foto'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['clte_path_foto'] = $data['file_name'];
                    }
                }

                if($this->cliente->inserta(array_to_upper($data_clte)))
                {
                    send_json_ok('Se guardó de forma correcta');
                }
                else
                {
                    send_json_error('Ocurrió un error al guardar la persona.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $this->load->model('empresa/Empresa_model','empresa');
            $data['empresas'] = $this->empresa->get_all_empresas();
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'protocolo/add',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }
    
    public function nuevo_doc($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
        $user = $this->session->user;
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('nombre','Nombre documento','required');

            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_id'] = 24; // $cliente_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
				$data_clte['emp_id'] = 	$user['emp_id'];
                $this->load->library('upload');
                if(!empty($_FILES['doc']['name']))
                {
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/docs/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg|pdf|doc|docx',
                            'max_size'      => '50000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('doc'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['doc_path'] = $data['file_name'];
                        if($this->cliente->add_doc(array_to_upper($data_clte)))
                        {
                            send_json_ok('Se guardó de forma correcta');
                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
                    send_json_error($this->upload->display_errors());
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Institucion',
                'view' => 'institucion/add_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }
    
    function descarga_doc($file)
    {
        $this->load->helper('download');
        force_download('./docs/'.$file, NULL);
    }
    

    
    function hc_borra_signos($id)
    {
        if($this->cliente->delete_signosvitales($id))
        {
            send_json_ok('Se eliminó de forma correcta');
        }
        else
        {
            send_json_error('Ocurrió un error al borrar.');
        }
    }
    
    function hc_borra_nopat($id)
    {
        if($this->cliente->delete_nopatologico($id))
        {
            send_json_ok('Se eliminó de forma correcta');
        }
        else
        {
            send_json_error('Ocurrió un error al borrar.');
        }
    }
    
    function hc_borra_heredofamiliar($id)
    {
        if($this->cliente->delete_heredofamiliar($id))
        {
            send_json_ok('Se eliminó de forma correcta');
        }
        else
        {
            send_json_error('Ocurrió un error al borrar.');
        }
    }
    
    function busca()
    {        
        $empresa = $this->input->post('empresa');
        $nombre  = strtoupper($this->input->post('nombre'));
        $rfc     = strtoupper($this->input->post('rfc'));
        $data['clientes'] = $this->cliente->busca($empresa, $nombre, $rfc);
        send_json_ok($this->load->view('persona/busca',$data,TRUE));
    }
    

}