﻿<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Recursosh extends CI_Controller {
    
    function __construct() {
        parent::__construct();
        $this->load->model('recursosh/Persona_model','cliente');
        $this->load->model('empleado/Empleado_model','medico');
    }
    
    public function lista()
    {
        $rows = 30;
        $this->load->library('pagination');
        $config['base_url'] = base_url('juridico/lista/');
        $config['total_rows'] = $this->cliente->count_all();
        $config['per_page'] = $rows;
        $config['attributes'] = array('class' => 'pagination');
        $config['full_tag_open'] = '<div class="pagination-full">';
        $config['full_tag_close'] = '</div>';
        $config['uri_segment'] = 3;
        $config['query_string_segment'] = 4;
        $config['use_page_numbers'] = TRUE;
        $this->pagination->initialize($config);
        
        $data['clientes'] = $this->cliente->get_all($rows);
        $data['empresas'] = $this->cliente->get_empresas();
        
        $this->load->helper('template');
        $params_view = array(
            'title' => 'Personas',
            'view' => 'recursosh/index',
            'view_data' => $data 
           );
        render_template($params_view);  
    }
    
    public function id($id)
    {
        $data['cliente'] = $this->cliente->get($id);
        if($data['cliente'])
        {
            $this->load->model('examen/Entorno_social_model','entorno_social');
            $this->load->model('examen/Socioeconomico_model','socio_economico');
            $this->load->model('examen/Poligrafico_model','poligrafico');
            $this->load->model('examen/Medico_fisico_model','medico_fisico');
            $this->load->model('examen/Psicologico_model','psicologico');
            $this->load->model('examen/Toxicologico_model','toxicologico');
            $this->load->model('examen/Acreditacion_model','acreditacion');
            $this->load->model('examen/Historia_clinica_model','historia_clinica');
            $user = $this->session->user;

            $data['medico']=$user;
            $data['socio_economicos'] = $this->socio_economico->get_by_clte($id);
            $data['entorno_social'] = $this->entorno_social->get_by_clte($id);
            $data['fsms_02'] = $this->poligrafico->get_by_clte($id,'POLI');
            $data['fsmsc_02'] = $this->poligrafico->get_by_clte($id,'CEDULA');
            $data['fsms_04'] = $this->medico_fisico->get_by_clte($id);
            $data['fsms_05'] = $this->psicologico->get_by_clte($id);
            $data['fsms_06'] = $this->toxicologico->get_by_clte($id);
            $data['fsms_03'] = $this->acreditacion->get_by_clte($id);
            $data['fsms_lala'] = $this->historia_clinica->get_by_clte($id);
            
            $data['docs'] = $this->cliente->get_docs($id);
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Persona',
                'view' => 'recursosh/cliente',
                'view_data' => $data 
               );
            render_template($params_view);  
        }
        else
        {
            show_error('El cliente no existe.');
        }
    }
    
    public function edita($cliente_id)
    {
        $cliente = $this->cliente->get($cliente_id);
        
        if($cliente)
        {

            if(isset($_POST) && count($_POST) > 0)     
            {
                $this->load->library('form_validation');
                $this->form_validation->set_rules('nombre','Nombre','required');
                $this->form_validation->set_rules('paterno','Apellido Paterno','required');
                $this->form_validation->set_rules('materno','Apellido Materno','required');
                $this->form_validation->set_rules('fnac','Fecha de nacimiento','required');
                $this->form_validation->set_rules('genero','Género','required');
                //$this->form_validation->set_rules('civil','Estado civil','required');
                //$this->form_validation->set_rules('rfc','RFC','required');
                //$this->form_validation->set_rules('curp','CURP','required');

                if($this->form_validation->run())
                {
                    //informncion general de la pérsona
                    $data_clte['clte_nombre_crypt'] =  $this->input->post('nombre');
                    $data_clte['clte_2_nombre_crypt'] =  $this->input->post('nombre_adic');
                    $data_clte['clte_paterno_crypt'] =  $this->input->post('paterno');
                    $data_clte['clte_materno_crypt'] =  $this->input->post('materno');
                    $data_clte['clte_f_nac'] = formatea_fecha_mysql($this->input->post('fnac'));
                    $data_clte['clte_genero_cve'] =  $this->input->post('genero');
                    $data_clte['clte_rfc_crypt'] =  $this->input->post('rfc');
                    $data_clte['clte_curp_crypt'] =  $this->input->post('curp');

                    //dopmcicio de la persona
                    $data_clte['clte_env_pais_cve'] =  $this->input->post('pais');
                    $data_clte['clte_env_cp'] =  $this->input->post('cp');
                    $data_clte['clte_env_edo_cve'] =  $this->input->post('entidad');
                    $data_clte['clte_env_colonia_crypt'] =  $this->input->post('colonia');
                    $data_clte['clte_env_localidad'] =  $this->input->post('localidad');
                    $data_clte['clte_env_municipio'] =  $this->input->post('municipio');
                    $data_clte['clte_env_calle_crypt'] =  $this->input->post('calle');
                    $data_clte['clte_env_num_ext_crypt'] =  $this->input->post('next');
                    $data_clte['clte_env_num_int_crypt'] =  $this->input->post('nint');

                    //informacion de conrtaxcto de la persona
                    $data_clte['clte_tel_casa_crypt'] = limpia_telefono($this->input->post('tel'));                
                    $data_clte['clte_cel_crypt'] =  limpia_telefono($this->input->post('cel'));
                    $data_clte['clte_email_crypt'] =  $this->input->post('correo');

                    //nuevos campos
                    $data_clte['clte_grado_acad_cve'] =  $this->input->post('grado');
                    $data_clte['clte_puesto'] =  $this->input->post('puesto');
                    $data_clte['clte_edo_civ_cve'] =  $this->input->post('civil');
                    $data_clte['clte_nac_cve'] =  $this->input->post('nac');

                    //empresa donde va a loborar la persona
                    $data_clte['emp_id'] =  $this->input->post('empresa');
                    
                    //nuevo cambpo de unicacion
                    $data_clte['clte_lab_ubicacion'] =  $this->input->post('ubicacion');

                    if(!empty($_FILES['foto']['name']))
                    {
                        $this->load->library('upload');
                        $filename = md5(time());
                        $config = array(
                                'upload_path'   => './../../files/fotos/',
                                'overwrite'     => TRUE,
                                'file_name'     => $filename,
                                'allowed_types' => 'png|jpg|jpeg',
                                'max_size'      => '10000'
                        );

                        $this->upload->initialize($config);
                        if ( ! $this->upload->do_upload('foto'))
                        {
                            send_json_error($this->upload->display_errors());
                        }
                        else 
                        {
                            $data = $this->upload->data();
                            $data_clte['clte_path_foto'] = $data['file_name'];
                        }
                    }

                    if($this->cliente->actualiza($cliente_id, array_to_upper($data_clte)))
                    {
                        send_json_ok('Se actualizó de forma correcta');
                    }
                    else
                    {
                        send_json_error('Ocurrió un error al actualizar la persona.');
                    }
                }
                else
                {
                    send_json_error(validation_errors('<div />'));
                }
            }
            else 
            {
                $this->load->model('empresa/Empresa_model','empresa');
                $data['empresas'] = $this->empresa->get_all_empresas();
                $data['persona'] = $cliente;
                $this->load->helper('template');
                $params_view = array(
                    'title' => 'Personas',
                    'view' => 'recursosh/edit',
                    'view_data' => $data
                   );
                render_template($params_view);  
            }
        }
        else 
        {
            show_error('No existe el cliente');
        }
    }
    
    public function nuevo()
    {
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('nombre','Nombre','required');
            $this->form_validation->set_rules('paterno','Apellido Paterno','required');
            $this->form_validation->set_rules('materno','Apellido Materno','required');
            $this->form_validation->set_rules('fnac','Fecha de nacimiento','required');
            $this->form_validation->set_rules('genero','Género','required');
            //$this->form_validation->set_rules('civil','Estado civil','required');
            //$this->form_validation->set_rules('rfc','RFC','required');
            //
            //$this->form_validation->set_rules('curp','CURP','required');

            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_nombre_crypt'] =  $this->input->post('nombre');
                $data_clte['clte_2_nombre_crypt'] =  $this->input->post('nombre_adic');
                $data_clte['clte_paterno_crypt'] =  $this->input->post('paterno');
                $data_clte['clte_materno_crypt'] =  $this->input->post('materno');
                $data_clte['clte_f_nac'] = formatea_fecha_mysql($this->input->post('fnac'));
                $data_clte['clte_genero_cve'] =  $this->input->post('genero');
                $data_clte['clte_rfc_crypt'] =  $this->input->post('rfc');
                $data_clte['clte_curp_crypt'] =  $this->input->post('curp');
                
                //dopmcicio de la persona
                $data_clte['clte_env_pais_cve'] =  $this->input->post('pais');
                $data_clte['clte_env_cp'] =  $this->input->post('cp');
                $data_clte['clte_env_edo_cve'] =  $this->input->post('entidad');
                $data_clte['clte_env_colonia_crypt'] =  $this->input->post('colonia');
                $data_clte['clte_env_localidad'] =  $this->input->post('localidad');
                $data_clte['clte_env_municipio'] =  $this->input->post('municipio');
                $data_clte['clte_env_calle_crypt'] =  $this->input->post('calle');
                $data_clte['clte_env_num_ext_crypt'] =  $this->input->post('next');
                $data_clte['clte_env_num_int_crypt'] =  $this->input->post('nint');
                
                //informacion de conrtaxcto de la persona
                $data_clte['clte_tel_casa_crypt'] =  limpia_telefono($this->input->post('tel'));                
                $data_clte['clte_cel_crypt'] =  limpia_telefono($this->input->post('cel'));
                $data_clte['clte_email_crypt'] =  $this->input->post('correo');
                
                //nuevos campos
                $data_clte['clte_grado_acad_cve'] =  $this->input->post('grado');
                $data_clte['clte_puesto'] =  $this->input->post('puesto');
                $data_clte['clte_edo_civ_cve'] =  $this->input->post('civil');
                $data_clte['clte_nac_cve'] =  $this->input->post('nac');
                
                //empresa donde va a loborar la persona
                $data_clte['emp_id'] =  $this->input->post('empresa');
                
                //nuevo campo de ubicacion
                $data_clte['clte_lab_ubicacion'] =  $this->input->post('ubicacion');
                
                if(!empty($_FILES['foto']['name']))
                {
                    $this->load->library('upload');
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/fotos/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg',
                            'max_size'      => '10000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('foto'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['clte_path_foto'] = $data['file_name'];
                    }
                }

                if($this->cliente->inserta(array_to_upper($data_clte)))
                {
                    send_json_ok('Se guardó de forma correcta');
                }
                else
                {
                    send_json_error('Ocurrió un error al guardar la persona.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $this->load->model('empresa/Empresa_model','empresa');
            $data['empresas'] = $this->empresa->get_all_empresas();
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'recursosh/add',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }
    
    public function nuevo_doc($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('nombre','Nombre documento','required');

            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_id'] =  $cliente_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                $data_clte['empresa'] =  $this->input->post('empre');

                $this->load->library('upload');
                if(!empty($_FILES['doc']['name']))
                {
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/docs/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg|pdf|doc|docx',
                            'max_size'      => '10000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('doc'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['doc_path'] = $data['file_name'];
                        if($this->cliente->add_doc(array_to_upper($data_clte)))
                        {
                            send_json_ok('Se guardó de forma correcta');
                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
                    send_json_error($this->upload->display_errors());
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'recursosh/add_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }
    
    function descarga_doc($file)
    {
        $this->load->helper('download');
        force_download('./docs/'.$file, NULL);
    }
    
    function hc_guarda_heredofamiliar($cliente_id)
    {
        $user = $this->session->user;
        $data_insert['clte_id'] = $cliente_id;
        $data_insert['usr_id']  = $user['usr_id'];
        $data_insert['her_fecha']   = date("Y-m-d");
        $data_insert['cie_clave'] = $this->input->post('cie');
        $data_insert['her_parent_cve'] = $this->input->post('par');
        $data_insert['her_causo_muerte_cve'] = $this->input->post('muerte');

        if($this->cliente->add_heredofamiliar(array_to_upper($data_insert)))
        {
            send_json_ok('Se guardó de forma correcta');
        }
        else
        {
            send_json_error('Ocurrió un error al guardar.');
        }
    }
    
    function hc_guarda_nopat($cliente_id)
    {
        $user = $this->session->user;
        $data_insert['clte_id'] = $cliente_id;
        $data_insert['usr_id']  = $user['usr_id'];
        $data_insert['nopat_fecha']   = date("Y-m-d");
        $data_insert['nopat_tipo_cve'] = $this->input->post('sus');
        $data_insert['nopat_f_ini'] = formatea_fecha_mysql($this->input->post('ini'));
        $data_insert['nopat_f_fin'] = formatea_fecha_mysql($this->input->post('fin'));
        $data_insert['nopat_cant'] = $this->input->post('cant');
        $data_insert['nopat_frec_cve'] = $this->input->post('frec');

        if($this->cliente->add_nopatologico(array_to_upper($data_insert)))
        {
            send_json_ok('Se guardó de forma correcta');
        }
        else
        {
            send_json_error('Ocurrió un error al guardar.');
        }
    }
    
    function hc_guarda_pat($cliente_id)
    {
        $user = $this->session->user;
        $data_insert['clte_id'] = $cliente_id;
        $data_insert['usr_id']  = $user['usr_id'];
        //$data_insert['pat_fecha']   = date("Y-m-d");
        //$data_insert['nopat_tipo_cve'] = $this->input->post('sus');
        $data_insert['pat_fecha_detecto'] = formatea_fecha_mysql($this->input->post('ini'));
        $data_insert['pat_fecha_fin'] = formatea_fecha_mysql($this->input->post('fin'));
        $data_insert['cie_clave'] = $this->input->post('cie');
        //$data_insert['nopat_frec_cve'] = $this->input->post('frec');

        if($this->cliente->add_patologico(array_to_upper($data_insert)))
        {
            send_json_ok('Se guardó de forma correcta');
        }
        else
        {
            send_json_error('Ocurrió un error al guardar.');
        }
    }
    
    function hc_borra_pat($id)
    {
        if($this->cliente->delete_patologico($id))
        {
            send_json_ok('Se eliminó de forma correcta');
        }
        else
        {
            send_json_error('Ocurrió un error al borrar.');
        }
    }
    
    function hc_guarda_signos($cliente_id)
    {
        $user = $this->session->user;
        $this->load->library('form_validation');
        $this->form_validation->set_rules('sig_talla','Talla','required');
        $this->form_validation->set_rules('sig_peso','Peso','required');
        $this->form_validation->set_rules('sig_presion_sis','Presión sistólica','required');
        $this->form_validation->set_rules('sig_presion_dias','Presión diastólica','required');
        $this->form_validation->set_rules('sig_temp','Temperatura','required');

        if($this->form_validation->run())
        {
            $data_insert['clte_id'] = $cliente_id;
            $data_insert['usr_id']  = $user['usr_id'];
            $data_insert['sig_fecha']   = date("Y-m-d H:i:s");
            $data_insert['sig_talla'] = $this->input->post('sig_talla');
            $data_insert['sig_peso'] = $this->input->post('sig_peso');
            $data_insert['sig_presion_sis'] = $this->input->post('sig_presion_sis');
            $data_insert['sig_presion_dias'] = $this->input->post('sig_presion_dias');
            $data_insert['sig_frec_card'] = $this->input->post('sig_frec_card');
            $data_insert['sig_frec_resp'] = $this->input->post('sig_frec_resp');
            $data_insert['sig_temp'] = $this->input->post('sig_temp');

            if($this->cliente->add_signosvitales(array_to_upper($data_insert)))
            {
                send_json_ok('Se guardó de forma correcta');
            }
            else
            {
                send_json_error('Ocurrió un error al guardar.');
            }
        }
        else
        {
            send_json_error(validation_errors('<div />'));
        }
    }
    
    function hc_borra_signos($id)
    {
        if($this->cliente->delete_signosvitales($id))
        {
            send_json_ok('Se eliminó de forma correcta');
        }
        else
        {
            send_json_error('Ocurrió un error al borrar.');
        }
    }
    
    function hc_borra_nopat($id)
    {
        if($this->cliente->delete_nopatologico($id))
        {
            send_json_ok('Se eliminó de forma correcta');
        }
        else
        {
            send_json_error('Ocurrió un error al borrar.');
        }
    }
    
    function hc_borra_heredofamiliar($id)
    {
        if($this->cliente->delete_heredofamiliar($id))
        {
            send_json_ok('Se eliminó de forma correcta');
        }
        else
        {
            send_json_error('Ocurrió un error al borrar.');
        }
    }
    
    function busca()
    {        
        $empresa = $this->input->post('empresa');
        $nombre  = strtoupper($this->input->post('nombre'));
        $rfc     = strtoupper($this->input->post('rfc'));
        $data['clientes'] = $this->cliente->busca($empresa, $nombre, $rfc);
        send_json_ok($this->load->view('persona/busca',$data,TRUE));
    }
    
    public function estudio_pdf($cliente_id, $id)
    {
        $data['persona'] = $this->cliente->get($cliente_id);
        $data['heredo'] = $this->cliente->get_heredofamiliar($cliente_id);
        $data['nopat'] = $this->cliente->get_nopatologico($cliente_id);
        $data['pat'] = $this->cliente->get_patologico($cliente_id);
        $data['signos'] = $this->cliente->get_signosvitales($cliente_id);
        $data['cirugia'] = $this->cliente->get_cirugia($cliente_id);
        $data['discap'] = $this->cliente->get_discapacidad($cliente_id);
        $data['dificul'] = $this->cliente->get_dificultad($cliente_id);
        $data['alergia'] = $this->cliente->get_alergia($cliente_id);
        $data['gineco'] = $this->cliente->get_gineco($cliente_id);
        $this->load->helper('pdf');
        genera_pdf($this->load->view('estudio/form'.$id.'_pdf',$data,TRUE),'historia_clinica','historia_clinica','historia_clinica');  
    }

    function hc_guarda_cirugia($cliente_id)
    {
        $user = $this->session->user;
        $data_insert['clte_id'] = $cliente_id;
        $data_insert['usr_id']  = $user['usr_id'];
        $data_insert['cir_fecha']   = formatea_fecha_mysql($this->input->post('cir_fecha'));
        $data_insert['proc_cve_proc'] = $this->input->post('proc_cve_proc');
        $data_insert['cir_notas_crypt'] = $this->input->post('cir_notas');

        if($this->cliente->add_cirugia(array_to_upper($data_insert)))
        {
            send_json_ok('Se guardó de forma correcta');
        }
        else
        {
            send_json_error('Ocurrió un error al guardar.');
        }
    }
    
    function hc_guarda_discap($cliente_id)
    {
        $user = $this->session->user;
        $data_insert['clte_id'] = $cliente_id;
        $data_insert['usr_id']  = $user['usr_id'];
        $data_insert['discap_cve'] = $this->input->post('discap_cve');
        $data_insert['dis_cif_nota_crypt'] = $this->input->post('dis_cif_nota');

        if($this->cliente->add_discapacidad(array_to_upper($data_insert)))
        {
            send_json_ok('Se guardó de forma correcta');
        }
        else
        {
            send_json_error('Ocurrió un error al guardar.');
        }
    }
    
    function hc_guarda_dific($cliente_id)
    {
        $user = $this->session->user;
        $data_insert['clte_id'] = $cliente_id;
        $data_insert['usr_id']  = $user['usr_id'];
        $data_insert['dis_dif_tipo_cve'] = $this->input->post('dis_dif_tipo_cve');
        $data_insert['dis_dif_orig_cve'] = $this->input->post('dis_dif_orig_cve');
        $data_insert['dis_dif_grado_cve'] = $this->input->post('dis_dif_grado_cve');
        $data_insert['dis_cif_nota_crypt'] = $this->input->post('dis_cif_nota');

        if($this->cliente->add_discapacidad(array_to_upper($data_insert)))
        {
            send_json_ok('Se guardó de forma correcta');
        }
        else
        {
            send_json_error('Ocurrió un error al guardar.');
        }
    }
    
    function hc_guarda_alergia($cliente_id)
    {
        $user = $this->session->user;
        $data_insert['clte_id'] = $cliente_id;
        $data_insert['usr_id']  = $user['usr_id'];
        $data_insert['alerg_alergeno'] = $this->input->post('alerg_alergeno');
        $data_insert['alerg_reaccion'] = $this->input->post('alerg_reaccion');
        $data_insert['alerg_nota_crypt'] = $this->input->post('alerg_nota');

        if($this->cliente->add_alergia(array_to_upper($data_insert)))
        {
            send_json_ok('Se guardó de forma correcta');
        }
        else
        {
            send_json_error('Ocurrió un error al guardar.');
        }
    }
    
    function hc_borra_cirugia($id)
    {
        if($this->cliente->delete_cirugia($id))
        {
            send_json_ok('Se eliminó de forma correcta');
        }
        else
        {
            send_json_error('Ocurrió un error al borrar.');
        }
    }
    
    function hc_borra_discap($id)
    {
        if($this->cliente->delete_discapacidad($id))
        {
            send_json_ok('Se eliminó de forma correcta');
        }
        else
        {
            send_json_error('Ocurrió un error al borrar.');
        }
    }
    
    function hc_borra_alergia($id)
    {
        if($this->cliente->delete_alergia($id))
        {
            send_json_ok('Se eliminó de forma correcta');
        }
        else
        {
            send_json_error('Ocurrió un error al borrar.');
        }
    }
    
    function hc_guarda_gineco($cliente_id)
    {
        $gin_id = ($this->uri->segment(4) == '')?0:$this->uri->segment(4);
        
        $user = $this->session->user;
        $data_insert['clte_id'] = $cliente_id;
        $data_insert['usr_id']  = $user['usr_id'];
        $data_insert['gin_ritmo_cve'] = $this->input->post('gin_ritmo_cve');
        $data_insert['gin_menst_cada'] = $this->input->post('gin_menst_cada');
        $data_insert['gin_menst_dura'] = $this->input->post('gin_menst_dura');
        $data_insert['gin_f_ult_menst'] = formatea_fecha_mysql($this->input->post('gin_f_ult_mens'));
        $data_insert['gin_ivsa'] = $this->input->post('gin_ivsa');
        $data_insert['gin_mpf_cve'] = $this->input->post('gin_mpf_cve');
        $data_insert['gin_docma_f'] = formatea_fecha_mysql($this->input->post('gin_docma_f'));
        $data_insert['gin_docma_nota_crypt'] = $this->input->post('gin_docma_nota');
        $data_insert['gin_papanic_f'] = formatea_fecha_mysql($this->input->post('gin_papanic_f'));
        $data_insert['gin_papanic_nota_crypt'] = $this->input->post('gin_papanic_nota');
        $data_insert['gin_colposc_f'] = formatea_fecha_mysql($this->input->post('gin_colposc_f'));
        $data_insert['gin_colposc_nota_crypt'] = $this->input->post('gin_colposc_nota');
        
        $data_insert['gin_num_gestas'] = $this->input->post('gin_num_gestas');
        $data_insert['gin_num_abortos'] = $this->input->post('gin_num_abortos');
        $data_insert['gin_num_partos'] = $this->input->post('gin_num_partos');
        $data_insert['gin_num_cesareas'] = $this->input->post('gin_num_cesareas');
        $data_insert['gin_f_ult_parto'] = formatea_fecha_mysql($this->input->post('gin_f_ult_parto'));
        $data_insert['gin_f_ult_aborto'] = formatea_fecha_mysql($this->input->post('gin_f_ult_aborto'));
        $data_insert['gin_notas_crypt'] = $this->input->post('nota');

        if($gin_id === 0)
        {
            if($this->cliente->add_gineco(array_to_upper($data_insert)))
            {
                send_json_ok('Se guardó de forma correcta');
            }
            else
            {
                send_json_error('Ocurrió un error al guardar.');
            }
        }
        else
        {
            if($this->cliente->update_gineco($gin_id, array_to_upper($data_insert)))
            {
                send_json_ok('Se guardó de forma correcta');
            }
            else
            {
                send_json_error('Ocurrió un error al guardar.');
            }
        }
    }
}