<?php
/* 
 * Generated by CRUDigniter v2.3 Beta 
 * www.crudigniter.com
 */ 
 
class Agendaos extends CI_Controller
{
    function __construct()
    {
        parent::__construct();
		$this->load->helper('util');
        $this->load->model('util/Agendaos_model','agenda');
		$this->load->model('empleado/Empleado_model','empleado');
		$this->load->model('empresa/Empresa_model','empresa');
		$this->load->model('servicio/Servicio_model','servicio');
		$this->load->model('programmer/Programmer_model','cliente');
    }
    
    function index()
    {
        $this->load->helper('template');
        $params_view = array(
            'title' => 'Citas',
            'view' => 'agendaos/calendar'
           );
        render_template($params_view); 
    }
    
    function eventjson()
    {
        if($this->uri->segment(3))
        {
            $year = date('Y', strtotime($this->uri->segment(3)));
            $month = date('m', strtotime($this->uri->segment(3)));
        }
        else 
        {
            $year = date('Y');
            $month = date('m');
        }
        $eventos = $this->agenda->get_all_eventos_json($year,$month);
        if($eventos)
        {
            send_json_ok($eventos);
        }
        else
        {
            send_json_error('No hay eventos.');
        }
    }
/*************function add_evento() original************************************************************************/	    
    function add_evento()
    {
        $data_view['evento_dia'] = date('Y-m-d',strtotime($this->uri->segment(3)));
        
        $fecha_div = explode('T', $this->uri->segment(3));
        if(isset($fecha_div[1]))
        {
            $data_view['hora_ini'] = date('H:i',strtotime($fecha_div[1]));
        }
        else
        {
            $data_view['hora_ini'] = date('H:i');
        }
        if(isset($_POST) && count($_POST) > 0)     
        {
            //recibe los datos
            $this->load->library('form_validation');
            $this->form_validation->set_rules('fecha','Fecha','required');
            $this->form_validation->set_rules('asunto','Asunto','required');
            $this->form_validation->set_rules('fecha_event_ini','Fecha inicia','required');
            $this->form_validation->set_rules('hora_event_ini','Hora inicia','required');
            $this->form_validation->set_rules('fecha_event_fin','Fecha fin','required');
            $this->form_validation->set_rules('hora_event_fin','Hora fin','required');



			if($this->form_validation->run())
            {
                $fecha_ini = formatea_fechahora_mysql($this->input->post('fecha_event_ini').' '.$this->input->post('hora_event_ini'));
                $fecha_fin = formatea_fechahora_mysql($this->input->post('fecha_event_fin').' '.$this->input->post('hora_event_fin'));
                                
                $params = array(
                    'cal_fecha' => $this->input->post('fecha'),
                    'cal_titulo' => $this->input->post('asunto'),
                    'cal_servicio' => NULL,
                    'cal_descripcion' => $this->input->post('descripcion'),
                    'cal_fecha_ini' => $fecha_ini,
                    'cal_fecha_fin' => $fecha_fin,
                    'cal_uid' => uniqid(rand(0, getmypid()))
                );
                if($this->input->post('lugar'))
                {
                    $params['cal_lugar'] = $this->input->post('lugar');
                }

                if($this->input->post('emp_id'))
                {
                    $params['emp_id'] = $this->input->post('emp_id');
                }
                
                if(get_perfil_id() == 4){
                    $params['emp_id'] = get_emp_id();
                }
                
                if($this->input->post('recordar') == 'si')
                {
                    $params['cal_email'] = $this->input->post('mail');
                }
                else
                {
                    $params['cal_email'] = NULL;
                }
                
                //requerimiento HC-02
                //ALTER TABLE `doc10_calendario` ADD `cal_anexo_path` VARCHAR(150) NULL AFTER `cal_uid`;
                if(!empty($_FILES['anexo']['name']))
                {
                    $this->load->library('upload');
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/anexos/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'doc|docx|pdf|txt|xlsx|xls',
                            'max_size'      => '10000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('anexo'))
                    {
                        //send_json_error($this->upload->display_errors());
                        //send_json_error($this->upload->display_errors());
                        echo json_encode(array('status' => 'error','content' => $this->upload->display_errors()));
                        exit;
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $params['cal_anexo_path'] = $data['file_name'];
                    }
                }
                
                $cal_id = $this->agenda->add_evento(array_to_upper($params));
                if($cal_id)
                {

                        $this->load->helper('mail');
                        $evento = $this->agenda->get_evento($cal_id);
                        $data_email = array('evento' => $evento);
                        $html = $this->load->view('agendaos/email_add_std_event',$data_email,TRUE);
                        
					send_mail_std_event($this->input->post('mail'), $evento, $html);
                    send_json_ok('Se guardó de forma correcta.');
                }
                else
                {
                    send_json_error('Ocurrió un error al guardar, intente de nuevo más tarde.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div>'));
            }
        }
        else
        {
            if($this->uri->segment(3) != '')
            {
                $data_view['evento_dia'] = date('Y-m-d',strtotime($this->uri->segment(3)));
            }
            else
            {
                $data_view['evento_dia'] = date('Y-m-d');
            }
            $data_view['pac'] = FALSE;
            //$data_view['title_modal'] = 'Nueva cita';
            $view = $this->load->view('agendaos/add',$data_view,TRUE);
            send_json_ok($view);
        }
    }
/*************************************************************************************/	

/*************MODIFICADO ******************************************************************/	    
    function add_sol_serv_hc()
    {
        
		$user = $this->session->user;
		
		$data_view['evento_dia'] = date('Y-m-d',strtotime($this->uri->segment(3)));
        
        $fecha_div = explode('T', $this->uri->segment(3));
        if(isset($fecha_div[1]))
        {
            $data_view['hora_ini'] = date('H:i',strtotime($fecha_div[1]));
        }
        else
        {
            $data_view['hora_ini'] = date('H:i');
        }
        if(isset($_POST) && count($_POST) > 1)     
        {
            //recibe los datos
            $this->load->library('form_validation');
            $this->form_validation->set_rules('fecha','Fecha','required');
           // $this->form_validation->set_rules('asunto','Asunto','required');
            $this->form_validation->set_rules('fecha_event_ini','Fecha inicia','required');
            $this->form_validation->set_rules('hora_event_ini','Hora inicia','required');
            $this->form_validation->set_rules('fecha_event_fin','Fecha fin','required');
            $this->form_validation->set_rules('hora_event_fin','Hora fin','required');			
			$this->form_validation->set_rules('observaciones','Observaciones','required');
			$this->form_validation->set_rules('evaluados','Evaluados','required');
			$this->form_validation->set_rules('lugar','Lugar de realización de los servicios','required');
			
            if($this->form_validation->run())
            {
                $fecha_ini = formatea_fechahora_mysql($this->input->post('fecha_event_ini').' '.$this->input->post('hora_event_ini'));
                $fecha_fin = formatea_fechahora_mysql($this->input->post('fecha_event_fin').' '.$this->input->post('hora_event_fin'));
                                
                $params = array(
					//toxixo
					'cal_toxi5' => $this->input->post('toxi5'),
					'cal_toxi7' => $this->input->post('toxi7'),
					'cal_toxi9' => $this->input->post('toxi9'),
					//LABORATORIO
					'cal_sangre' => $this->input->post('sangre'),
					'cal_orina' => $this->input->post('orina'),
					'cal_electro' => $this->input->post('electro'),
					'cal_muestra' => $this->input->post('muestra'),
					
					//SEGUROS	
					'cal_exmed' => $this->input->post('exmed'),	
					
					'cal_electro_sitio' => $this->input->post('electro_sitio'),	
					'cal_electro_domi' => $this->input->post('electro_domi'),	
					'cal_usonido' => $this->input->post('usonido'),	

					'cal_esfuerzo' => $this->input->post('esfuerzo'),	
					'cal_torax' => $this->input->post('torax'),	
					'cal_papani' => $this->input->post('papani'),	
					
					'cal_cotinina' => $this->input->post('cotinina'),	
					'cal_drogas' => $this->input->post('drogas'),						
					
					'cal_quisan' => $this->input->post('quisan'),
					'cal_biohem' => $this->input->post('biohem'),
					
					'cal_antipro' => $this->input->post('antipro'),
					'cal_hiv' => $this->input->post('hiv'),					
					'cal_pie' => $this->input->post('pie'),					
					
					'cal_HbA1c' => $this->input->post('HbA1c'),
					'cal_HBsAg' => $this->input->post('HBsAg'),
					'cal_hepac' => $this->input->post('hepac'),

					'cal_gposan' => $this->input->post('gposan'),
	
					//MÉDICO FÍSICO
					'cal_medfi' => $this->input->post('medfis'),
					'cal_odon' => $this->input->post('odon'),
									
					
					//ESTUDIOS SOCIOECONÓMICOS
					'cal_estsocv' => $this->input->post('estsocv'),
					'cal_estsosv' => $this->input->post('estsosv'),
					//ESTUDIOS PSICOLÓGICOS
					'cal_estpsicr' => $this->input->post('estpsicr'),
					'cal_estpsisr' => $this->input->post('estpsisr'),
					//ESTUDIOS POLIGRÁFICOS
					'cal_estpolcr' => $this->input->post('estpolcr'),
					'cal_estpolsr' => $this->input->post('estpolsr'),
					//ESPECIALES</td>
					'cal_acre' => $this->input->post('acre'),
					'cal_eye' => $this->input->post('eye'),
					//Observaciones
					'cal_observaciones' => $this->input->post('observaciones'),
					//Evaluados
					'cal_evaluados' => $this->input->post('evaluados'),
					
					'cal_usr_nombre' => $user['usr_nombre'],
					'cal_usr_paterno' => $user['usr_paterno'],
					'cal_usr_materno' => $user['usr_materno'],
					'cal_usr_correo' => $user['usr_correo'],
		
					
					//datos normales de calendario	
                    'cal_fecha' => $this->input->post('fecha'),
                    'cal_titulo' => $this->input->post('asunto'),
                    'cal_servicio' => NULL,
                    'cal_descripcion' => $this->input->post('descripcion'),
                    'cal_fecha_ini' => $fecha_ini,
                    'cal_fecha_fin' => $fecha_fin,
                    'cal_uid' => uniqid(rand(0, getmypid()))
                );


				if ($user['emp_id'] == 31)
				{					
					$params['emp_id'] = $this->input->post('empresa');
				}
				elseif  (
							($user['emp_id'] == 126)   ||
							($user['emp_id'] ==125)   ||
							($user['emp_id'] ==33)   ||
							($user['emp_id'] ==179)   ||
							($user['emp_id'] ==181)   ||
							($user['emp_id'] ==180)   ||
							($user['emp_id'] ==77)   ||
							($user['emp_id'] ==176)   ||
							($user['emp_id'] ==178)   ||
							($user['emp_id'] ==177)   ||
							($user['emp_id'] ==57)   ||
							($user['emp_id'] ==175)   ||
							($user['emp_id'] ==174)   ||						 
							($user['emp_id'] == 127)    
							|| ($user['emp_id'] == 183)
							|| ($user['emp_id'] ==33)
							|| ($user['emp_id'] ==77)
							|| ($user['emp_id'] ==106)
							|| ($user['emp_id'] ==148)							
						)/*es un despacho de GSI*/
				{
					$params['emp_id'] = $user['emp_id'];
					$params['desp_emp_id'] = $this->input->post('empresa');
				}
				else
				{
					$params['emp_id'] = $user['emp_id'];
					$params['desp_emp_id'] = 0;
				}
                
                //if($this->input->post('lugar'))
                
                $params['cal_lugar'] = $this->input->post('lugar');
				
				if (($user['emp_id'] != 152) || ($user['emp_id'] != 230))
				{					
					$params['cal_lugar_det'] = $this->input->post('lugar_det');
					
                }
				else
				{								
				 /*	if ($params['cal_lugar'] == 0)
					{
						$params['cal_lugar_det'] = $this->input->post('lugar_det');
					}
					elseif ($params['cal_lugar'] == 2) 
					{	
						$params['cal_lugar_det'] ='Calle San Borja 1365, Vértiz Narvarte, Benito Juárez, C.P. 03600, CDMX'; 
					}
					else
					{	
						$params['cal_lugar_det'] = 'Paseo de la Reforma No. 342, Piso 14, Col. Juárez, Del. Cuauhtémoc, C.P. 06600, CDMX';  
					}	
				*/					
			
				}	
				
				
				
                /*if($this->input->post('recordar') == 'si')
                {*/
                    $params['cal_email'] = $user['usr_correo'].'; '.$this->input->post('mail');
               /* }
                else
                {
                    $params['cal_email'] = NULL;
                }*/
                
                //requerimiento HC-02
                //ALTER TABLE `doc10_calendario` ADD `cal_anexo_path` VARCHAR(150) NULL AFTER `cal_uid`;
               
			   if(!empty($_FILES['anexo']['name']))
                {
					$nombre_anexo=$_FILES['anexo']['name'];
                    $this->load->library('upload');
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/anexos/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'doc|docx|pdf|txt|xlsx|xls|png|jpg|jpeg',
                            'max_size'      => '10000'
                    );

                    $this->upload->initialize($config);
					
                    if ( ! $this->upload->do_upload('anexo'))
                    {
                        echo json_encode(array('status' => 'error','content' => $this->upload->display_errors()));
                        exit;
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $params['cal_anexo_path'] = $data['file_name'];
						$params['cal_anexo_nombre'] = $nombre_anexo;
                    }
                }
/******NUEVOS ARCHIVO ANEXO 1 ******************************/
                if(!empty($_FILES['anexo1']['name']))
                {
					$nombre_anexo=$_FILES['anexo1']['name'];
                    $this->load->library('upload');
					
					sleep(1);
                    $filename1 = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/anexos/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename1,
                            'allowed_types' => 'doc|docx|pdf|txt|xlsx|xls|png|jpg|jpeg',
                            'max_size'      => '10000'
                    );

                    $this->upload->initialize($config);
					
                    if ( ! $this->upload->do_upload('anexo1'))
                    {
                        echo json_encode(array('status' => 'error','content' => $this->upload->display_errors()));
                        exit;
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $params['cal_anexo1_path'] = $data['file_name'];
						$params['cal_anexo1_nombre'] = $nombre_anexo;
                    }
                }

/**********************************************************/				
				
/******NUEVOS ARCHIVO ANEXO 2 ******************************/
                if(!empty($_FILES['anexo2']['name']))
                {
					$nombre_anexo=$_FILES['anexo2']['name'];
                    $this->load->library('upload');
					
					sleep(1);
                    $filename2 = md5(time());
                    $config2 = array(
                            'upload_path'   => './../../files/anexos/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename2,
                            'allowed_types' => 'doc|docx|pdf|txt|xlsx|xls|png|jpg|jpeg',
                            'max_size'      => '10000'
                    );

                    $this->upload->initialize($config2);
					
                    if ( ! $this->upload->do_upload('anexo2'))
                    {
                        echo json_encode(array('status' => 'error','content' => $this->upload->display_errors()));
                        exit;
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $params['cal_anexo2_path'] = $data['file_name'];
						$params['cal_anexo2_nombre'] = $nombre_anexo;
                    }
                }

/**********************************************************/	
/******NUEVOS ARCHIVO ANEXO 3 ******************************/
                if(!empty($_FILES['anexo3']['name']))
                {
					$nombre_anexo=$_FILES['anexo3']['name'];
                    $this->load->library('upload');
					
					sleep(1);
                    $filename3 = md5(time());
                    $config3 = array(
                            'upload_path'   => './../../files/anexos/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename3,
                            'allowed_types' => 'doc|docx|pdf|txt|xlsx|xls|png|jpg|jpeg',
                            'max_size'      => '10000'
                    );

                    $this->upload->initialize($config3);
					
                    if ( ! $this->upload->do_upload('anexo3'))
                    {
                        echo json_encode(array('status' => 'error','content' => $this->upload->display_errors()));
                        exit;
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $params['cal_anexo3_path'] = $data['file_name'];
						$params['cal_anexo3_nombre'] = $nombre_anexo;
						
                    }
                }

/**********************************************************/	
/******NUEVOS ARCHIVO ANEXO 4 ******************************/
                if(!empty($_FILES['anexo4']['name']))
                {
					$nombre_anexo=$_FILES['anexo4']['name'];
                    $this->load->library('upload');
					
					sleep(1);
                    $filename4 = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/anexos/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename4,
                            'allowed_types' => 'doc|docx|pdf|txt|xlsx|xls|png|jpg|jpeg',
                            'max_size'      => '10000'
                    );

                    $this->upload->initialize($config);
					
                    if ( ! $this->upload->do_upload('anexo4'))
                    {
                        echo json_encode(array('status' => 'error','content' => $this->upload->display_errors()));
                        exit;
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $params['cal_anexo4_path'] = $data['file_name'];
						$params['cal_anexo4_nombre'] = $nombre_anexo;
                    }
                }

/**********************************************************/				
				
				
                if ($params['emp_id'] > 0)
				{	
                $cal_id = $this->agenda->add_evento_folio(array_to_upper($params));
				}
				
				if($cal_id)
                {

                        $this->load->helper('mail');
                        $evento = $this->agenda->get_evento($cal_id);
						
                        $data_email = array('evento' => $evento);						
                        $html = $this->load->view('agendaos/email_add_std_event_serv',$data_email,TRUE);
                        
						if ($user['emp_id'] == 31)
						{
							$this->load->model('empresa/Empresa_model','empresa');
							$data_empresa = $this->empresa->get_empresa_by_id($params['emp_id']);
							send_mail_std_event_serv(
							$this->input->post('mail'), 
							$evento, 
							$html,
							$cal_id,
							get_empresa($params['emp_id']),
							$user['usr_nombre'].' '.$user['usr_paterno'],
							$user['usr_correo'],
							$data_empresa['emp_responsable'] , 
							$data_empresa['emp_correo']
							,$params['cal_lugar'] );
						}
						else
						{
							send_mail_std_event_serv(
							$this->input->post('mail'), 
							$evento, 
							$html,
							$cal_id,
							get_empresa($params['emp_id']),
							$user['usr_nombre'].' '.$user['usr_paterno'],
							$user['usr_correo'],
							'',
							'',
							$params['cal_lugar'] );
						}

                    send_json_ok('Se guardó de forma correcta.');
                }
                else
                {
                    send_json_error('Ocurrió un error al guardar, Por favor revise si toda su información esta completa y vuelva intentar.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div>'));
            }
        }
        else
        {
            if($this->uri->segment(3) != '')
            {
                $data_view['evento_dia'] = date('Y-m-d',strtotime($this->uri->segment(3)));
            }
            else
            {
                $data_view['evento_dia'] = date('Y-m-d');
            }
			
			/*if ($cal_id)
			{
				$data_view['cal_id'] = $cal_id;
			}*/
			
            $data_view['pac'] = FALSE;
			$data_view['solicita'] =$user['usr_nombre'].' '.$user['usr_paterno'];
			
			if ($user['emp_id'] == 31)
			{
				$this->load->model('empresa/Empresa_model','empresa');
				//$data_view['las_empresas'] = $this->empresa->get_all_empresas_no_31();
				$data_view['las_empresas'] =$this->empresa->trae_empresas();//$this->empresa->get_all_empresas(); 
			}
			elseif  (
							($user['emp_id'] == 126)   ||
							($user['emp_id'] == 125)   ||
							($user['emp_id'] == 33)   ||
							($user['emp_id'] == 179)   ||
							($user['emp_id'] == 181)   ||
							($user['emp_id'] == 180)   ||
							($user['emp_id'] == 77)   ||
							($user['emp_id'] == 176)   ||
							($user['emp_id'] == 178)   ||
							($user['emp_id'] == 177)   ||
							($user['emp_id'] ==57)   ||
							($user['emp_id'] ==175)   ||
							($user['emp_id'] ==174)   ||						 
							($user['emp_id'] == 127) 
							|| ($user['emp_id'] == 183)
							|| ($user['emp_id'] ==33)
							|| ($user['emp_id'] ==77)
							|| ($user['emp_id'] ==106)
							|| ($user['emp_id'] ==148)
							
						)/*es un despacho de GSI*/
			{
				$this->load->model('empresa/Empresa_model','empresa');
				$data_view['las_empresas'] = $this->empresa->get_all_empresas_gsi();
			}
				$data_view['empresa'] =$user['emp_id'];
	
			
            //$data_view['title_modal'] = 'Nueva cita';
            $view = $this->load->view('agendaos/add_serv_hc',$data_view,TRUE);
            send_json_ok($view);
        }
    }
/****************MODIFICADO  hc*********************************************************************/	

	
/*************MODIFICADO ******************************************************************/	    
    function add_sol_serv()
    {
        
		$user = $this->session->user;
		
		$data_view['evento_dia'] = date('Y-m-d',strtotime($this->uri->segment(3)));
        
        $fecha_div = explode('T', $this->uri->segment(3));
        if(isset($fecha_div[1]))
        {
            $data_view['hora_ini'] = date('H:i',strtotime($fecha_div[1]));
        }
        else
        {
            $data_view['hora_ini'] = date('H:i');
        }
        if(isset($_POST) && count($_POST) > 0)     
        {
            //recibe los datos
            $this->load->library('form_validation');
            $this->form_validation->set_rules('fecha','Fecha','required');
           // $this->form_validation->set_rules('asunto','Asunto','required');
            $this->form_validation->set_rules('fecha_event_ini','Fecha inicia','required');
            $this->form_validation->set_rules('hora_event_ini','Hora inicia','required');
            $this->form_validation->set_rules('fecha_event_fin','Fecha fin','required');
            $this->form_validation->set_rules('hora_event_fin','Hora fin','required');
			
			$this->form_validation->set_rules('observaciones','Observaciones','required');
			$this->form_validation->set_rules('evaluados','Evaluados','required');
			$this->form_validation->set_rules('lugar','Lugar de realización de los servicios','required');
			
            if($this->form_validation->run())
            {
                $fecha_ini = formatea_fechahora_mysql($this->input->post('fecha_event_ini').' '.$this->input->post('hora_event_ini'));
                $fecha_fin = formatea_fechahora_mysql($this->input->post('fecha_event_fin').' '.$this->input->post('hora_event_fin'));
                                
                $params = array(
					//toxixo
					'cal_toxi5' => $this->input->post('toxi5'),
					'cal_toxi7' => $this->input->post('toxi7'),
					'cal_toxi9' => $this->input->post('toxi9'),
					//LABORATORIO
					'cal_sangre' => $this->input->post('sangre'),
					'cal_orina' => $this->input->post('orina'),
					'cal_electro' => $this->input->post('electro'),
					'cal_muestra' => $this->input->post('muestra'),
					
					//SEGUROS	
					'cal_exmed' => $this->input->post('exmed'),	
					
					'cal_electro_sitio' => $this->input->post('electro_sitio'),	
					'cal_electro_domi' => $this->input->post('electro_domi'),	
					'cal_usonido' => $this->input->post('usonido'),	

					'cal_esfuerzo' => $this->input->post('esfuerzo'),	
					'cal_torax' => $this->input->post('torax'),	
					'cal_papani' => $this->input->post('papani'),	
					
					'cal_cotinina' => $this->input->post('cotinina'),	
					'cal_drogas' => $this->input->post('drogas'),						
					
					'cal_quisan' => $this->input->post('quisan'),
					'cal_biohem' => $this->input->post('biohem'),
					
					'cal_antipro' => $this->input->post('antipro'),
					'cal_hiv' => $this->input->post('hiv'),					
					'cal_pie' => $this->input->post('pie'),					
					
					'cal_HbA1c' => $this->input->post('HbA1c'),
					'cal_HBsAg' => $this->input->post('HBsAg'),
					'cal_hepac' => $this->input->post('hepac'),

					'cal_gposan' => $this->input->post('gposan'),
	
					//MÉDICO FÍSICO
					'cal_medfi' => $this->input->post('medfis'),
					'cal_odon' => $this->input->post('odon'),
									
					
					//ESTUDIOS SOCIOECONÓMICOS
					'cal_estsocv' => $this->input->post('estsocv'),
					'cal_estsosv' => $this->input->post('estsosv'),
					//ESTUDIOS PSICOLÓGICOS
					'cal_estpsicr' => $this->input->post('estpsicr'),
					'cal_estpsisr' => $this->input->post('estpsisr'),
					//ESTUDIOS POLIGRÁFICOS
					'cal_estpolcr' => $this->input->post('estpolcr'),
					'cal_estpolsr' => $this->input->post('estpolsr'),
					//ESPECIALES</td>
					'cal_acre' => $this->input->post('acre'),
					'cal_eye' => $this->input->post('eye'),
					//Observaciones
					'cal_observaciones' => $this->input->post('observaciones'),
					//Evaluados
					'cal_evaluados' => $this->input->post('evaluados'),
					
					'cal_usr_nombre' => $user['usr_nombre'],
					'cal_usr_paterno' => $user['usr_paterno'],
					'cal_usr_materno' => $user['usr_materno'],
					'cal_usr_correo' => $user['usr_correo'],
		
					
					//datos normales de calendario	
                    'cal_fecha' => $this->input->post('fecha'),
                    'cal_titulo' => $this->input->post('asunto'),
                    'cal_servicio' => NULL,
                    'cal_descripcion' => $this->input->post('descripcion'),
                    'cal_fecha_ini' => $fecha_ini,
                    'cal_fecha_fin' => $fecha_fin,
                    'cal_uid' => uniqid(rand(0, getmypid()))
                );


				if ($user['emp_id'] == 31)
				{					
					$params['emp_id'] = $this->input->post('empresa');
				}
				elseif  (
							($user['emp_id'] == 126)   ||
							($user['emp_id'] ==125)   ||
							($user['emp_id'] ==33)   ||
							($user['emp_id'] ==179)   ||
							($user['emp_id'] ==181)   ||
							($user['emp_id'] ==180)   ||
							($user['emp_id'] ==77)   ||
							($user['emp_id'] ==176)   ||
							($user['emp_id'] ==178)   ||
							($user['emp_id'] ==177)   ||
							($user['emp_id'] ==57)   ||
							($user['emp_id'] ==175)   ||
							($user['emp_id'] ==174)   ||						 
							($user['emp_id'] == 127)    
							|| ($user['emp_id'] == 183)
							|| ($user['emp_id'] ==33)
							|| ($user['emp_id'] ==77)
							|| ($user['emp_id'] ==106)
							|| ($user['emp_id'] ==148)							
						)/*es un despacho de GSI*/
				{
					$params['emp_id'] = $user['emp_id'];
					$params['desp_emp_id'] = $this->input->post('empresa');
				}
				else
				{
					$params['emp_id'] = $user['emp_id'];
					$params['desp_emp_id'] = 0;
				}
                
                //if($this->input->post('lugar'))
                
                $params['cal_lugar'] = $this->input->post('lugar');
				
				if (($user['emp_id'] != 152) || ($user['emp_id'] != 230))
				{					
					$params['cal_lugar_det'] = $this->input->post('lugar_det');
					
                }
				else
				{								
					if ($params['cal_lugar'] == 0)
					{
						$params['cal_lugar_det'] = $this->input->post('lugar_det');
					}
					elseif ($params['cal_lugar'] == 2) 
					{	
						$params['cal_lugar_det'] ='Calle San Borja 1365, Vértiz Narvarte, Benito Juárez, C.P. 03600, CDMX'; 
					}
					else
					{	
						$params['cal_lugar_det'] = 'Paseo de la Reforma No. 342, Piso 14, Col. Juárez, Del. Cuauhtémoc, C.P. 06600, CDMX';  
					}							
			
				}	

                $params['cal_email'] = $user['usr_correo'].'; '.$this->input->post('mail');

                if(!empty($_FILES['anexo']['name']))
                {
					$nombre_anexo=$_FILES['anexo']['name'];
                    $this->load->library('upload');
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/anexos/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'doc|docx|pdf|txt|xlsx|xls|png|jpg|jpeg',
                            'max_size'      => '10000'
                    );

                    $this->upload->initialize($config);
					
                    if ( ! $this->upload->do_upload('anexo'))
                    {
                        echo json_encode(array('status' => 'error','content' => $this->upload->display_errors()));
                        exit;
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $params['cal_anexo_path'] = $data['file_name'];
						$params['cal_anexo_nombre'] = $nombre_anexo;
                    }
                }
/******NUEVOS ARCHIVO ANEXO 1 ******************************/
                if(!empty($_FILES['anexo1']['name']))
                {
					$nombre_anexo=$_FILES['anexo1']['name'];
                    $this->load->library('upload');
					
					sleep(1);
                    $filename1 = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/anexos/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename1,
                            'allowed_types' => 'doc|docx|pdf|txt|xlsx|xls|png|jpg|jpeg',
                            'max_size'      => '10000'
                    );

                    $this->upload->initialize($config);
					
                    if ( ! $this->upload->do_upload('anexo1'))
                    {
                        //send_json_error($this->upload->display_errors());
                        //send_json_error($this->upload->display_errors());
                        echo json_encode(array('status' => 'error','content' => $this->upload->display_errors()));
                        exit;
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $params['cal_anexo1_path'] = $data['file_name'];
						$params['cal_anexo1_nombre'] = $nombre_anexo;
                    }
                }

/**********************************************************/				
				
/******NUEVOS ARCHIVO ANEXO 2 ******************************/
                if(!empty($_FILES['anexo2']['name']))
                {
					$nombre_anexo=$_FILES['anexo2']['name'];
                    $this->load->library('upload');
					
					sleep(1);
                    $filename2 = md5(time());
                    $config2 = array(
                            'upload_path'   => './../../files/anexos/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename2,
                            'allowed_types' => 'doc|docx|pdf|txt|xlsx|xls|png|jpg|jpeg',
                            'max_size'      => '10000'
                    );

                    $this->upload->initialize($config2);
					
                    if ( ! $this->upload->do_upload('anexo2'))
                    {
                        //send_json_error($this->upload->display_errors());
                        //send_json_error($this->upload->display_errors());
                        echo json_encode(array('status' => 'error','content' => $this->upload->display_errors()));
                        exit;
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $params['cal_anexo2_path'] = $data['file_name'];
						$params['cal_anexo2_nombre'] = $nombre_anexo;
                    }
                }

/**********************************************************/	
/******NUEVOS ARCHIVO ANEXO 3 ******************************/
                if(!empty($_FILES['anexo3']['name']))
                {
					$nombre_anexo=$_FILES['anexo3']['name'];
                    $this->load->library('upload');
					
					sleep(1);
                    $filename3 = md5(time());
                    $config3 = array(
                            'upload_path'   => './../../files/anexos/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename3,
                            'allowed_types' => 'doc|docx|pdf|txt|xlsx|xls|png|jpg|jpeg',
                            'max_size'      => '10000'
                    );

                    $this->upload->initialize($config3);
					
                    if ( ! $this->upload->do_upload('anexo3'))
                    {
                        //send_json_error($this->upload->display_errors());
                        //send_json_error($this->upload->display_errors());
                        echo json_encode(array('status' => 'error','content' => $this->upload->display_errors()));
                        exit;
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $params['cal_anexo3_path'] = $data['file_name'];
						$params['cal_anexo3_nombre'] = $nombre_anexo;
						
                    }
                }

/**********************************************************/	
/******NUEVOS ARCHIVO ANEXO 4 ******************************/
                if(!empty($_FILES['anexo4']['name']))
                {
					$nombre_anexo=$_FILES['anexo4']['name'];
                    $this->load->library('upload');
					
					sleep(1);
                    $filename4 = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/anexos/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename4,
                            'allowed_types' => 'doc|docx|pdf|txt|xlsx|xls|png|jpg|jpeg',
                            'max_size'      => '10000'
                    );

                    $this->upload->initialize($config);
					
                    if ( ! $this->upload->do_upload('anexo4'))
                    {
                        echo json_encode(array('status' => 'error','content' => $this->upload->display_errors()));
                        exit;
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $params['cal_anexo4_path'] = $data['file_name'];
						$params['cal_anexo4_nombre'] = $nombre_anexo;
                    }
                }

/**********************************************************/				
				
				
                if ($params['emp_id'] > 0)
				{	
                $cal_id = $this->agenda->add_evento_folio(array_to_upper($params));
				}
				
				if($cal_id)
                {

                        $this->load->helper('mail');
                        $evento = $this->agenda->get_evento($cal_id);
						
                        $data_email = array('evento' => $evento);						
                        $html = $this->load->view('agendaos/email_add_std_event_serv',$data_email,TRUE);
                        
						if ($user['emp_id'] == 31)
						{
							$this->load->model('empresa/Empresa_model','empresa');
							$data_empresa = $this->empresa->get_empresa_by_id($params['emp_id']);
							send_mail_std_event_serv(
							$this->input->post('mail'), 
							$evento, 
							$html,
							$cal_id,
							get_empresa($params['emp_id']),
							$user['usr_nombre'].' '.$user['usr_paterno'],
							$user['usr_correo'],
							$data_empresa['emp_responsable'] , 
							$data_empresa['emp_correo']
							,$params['cal_lugar'] );
						}
						else
						{
							send_mail_std_event_serv(
							$this->input->post('mail'), 
							$evento, 
							$html,
							$cal_id,
							get_empresa($params['emp_id']),
							$user['usr_nombre'].' '.$user['usr_paterno'],
							$user['usr_correo'],
							'',
							'',
							$params['cal_lugar'] );
						}

                    send_json_ok('Se guardó de forma correcta.');
                }
                else
                {
                    send_json_error('Ocurrió un error al guardar, Por favor revise si toda su información esta completa y vuelva intentar.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div>'));
            }
        }
        else
        {
            if($this->uri->segment(3) != '')
            {
                $data_view['evento_dia'] = date('Y-m-d',strtotime($this->uri->segment(3)));
            }
            else
            {
                $data_view['evento_dia'] = date('Y-m-d');
            }
			
			/*if ($cal_id)
			{
				$data_view['cal_id'] = $cal_id;
			}*/
			
            $data_view['pac'] = FALSE;
			$data_view['solicita'] =$user['usr_nombre'].' '.$user['usr_paterno'];
			
			if ($user['emp_id'] == 31)
			{
				$this->load->model('empresa/Empresa_model','empresa');
				//$data_view['las_empresas'] = $this->empresa->get_all_empresas_no_31();
				$data_view['las_empresas'] =$this->empresa->trae_empresas();//$this->empresa->get_all_empresas(); 
			}
			elseif  (
							($user['emp_id'] == 126)   ||
							($user['emp_id'] == 125)   ||
							($user['emp_id'] == 33)   ||
							($user['emp_id'] == 179)   ||
							($user['emp_id'] == 181)   ||
							($user['emp_id'] == 180)   ||
							($user['emp_id'] == 77)   ||
							($user['emp_id'] == 176)   ||
							($user['emp_id'] == 178)   ||
							($user['emp_id'] == 177)   ||
							($user['emp_id'] ==57)   ||
							($user['emp_id'] ==175)   ||
							($user['emp_id'] ==174)   ||						 
							($user['emp_id'] == 127) 
							|| ($user['emp_id'] == 183)
							|| ($user['emp_id'] ==33)
							|| ($user['emp_id'] ==77)
							|| ($user['emp_id'] ==106)
							|| ($user['emp_id'] ==148)
							
						)/*es un despacho de GSI*/
			{
				$this->load->model('empresa/Empresa_model','empresa');
				$data_view['las_empresas'] = $this->empresa->get_all_empresas_gsi();
			}
				$data_view['empresa'] =$user['emp_id'];
	
			
            //$data_view['title_modal'] = 'Nueva cita';
            $view = $this->load->view('agendaos/add_serv',$data_view,TRUE);
            send_json_ok($view);
        }
    }
/*************************************************************************************/	
/*************filtro ******************************************************************/	    
    function filtro()
    {
        $user_root4=get_my_user_root4();
		$user = $this->session->user;
		
		
        if(isset($_POST) && count($_POST) > 0)     
        {
            //recibe los datos
            $this->load->library('form_validation');
            $this->form_validation->set_rules('empresa','Empresa','required');
           // $this->form_validation->set_rules('asunto','Asunto','required');
			
            if($this->form_validation->run())
            {
				
				$params['filtro_so_id'] = $this->input->post('empresa');
				$empleado_id=$user['usr_id'];

                $cal_id = $this->empleado->actualiza($empleado_id, $params); //$this->agenda->add_evento_folio(array_to_upper($params));

				if($cal_id)
                {
                    send_json_ok('Se guardó el filtro en forma correcta.');
                }
                else
                {
                    send_json_error('Ocurrió un error al guardar, Por favor revise si toda su información esta completa y vuelva intentar.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div>'));
            }
        }
	
        else
        {   

           
			$data_view['solicita'] =$user['usr_nombre'].' '.$user['usr_paterno'];
			//$this->load->model('empresa/Empresa_model','empresa');

			if ($user_root4 > 4)
			{
				$data_view['las_empresas'] = $this->empresa->get_all_empresas_gsi();
			}
			else
			{
				$data_view['las_empresas'] = $this->empresa->trae_empresas_categoria('SALUD OCUPACIONAL');//trae_empresas();//$this->empresa->get_all_empresas();
			}

			$data_view['empresa'] =$user['emp_id'];
	
			
            //$data_view['title_modal'] = 'Nueva cita';
            $view = $this->load->view('agendaos/filtro',$data_view,TRUE);
            send_json_ok($view);
        }
    }
/*************************************************************************************/	
/******************************/
    function nueva_t()
    {   $user = $this->session->user;
		
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
			$this->form_validation->set_rules('empresa','Empresa','required');
			
            if($this->form_validation->run())
            {
				
				$params['emp_id'] = $this->input->post('empresa');
				$empleado_id=$user['usr_id'];
				
				
                if(1)
                {
					$this->empresa->get_empresa($params['emp_id']);
                    send_json_ok('Se guardó de forma correcta');

           $this->load->helper('template');
			$data_view['solicita'] =$user['usr_nombre'].' '.$user['usr_paterno'];
			$data_view['las_empresas'] = $this->empresa->trae_empresas();//$this->empresa->get_all_empresas();
			$data_view['empresa'] =$user['emp_id'];
			$params_view = array(
                'title' => 'Solicita Empresa',
                'view' => 'agendaos/add_emp',
				'view_data' => $data_view
               );
            render_template($params_view);  
        
					

                }
                else
                {
                    send_json_error('Ocurrió un error al registrar la empresa.');
                }
				
				
				
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $this->load->helper('template');
			$data_view['solicita'] =$user['usr_nombre'].' '.$user['usr_paterno'];
			$data_view['las_empresas'] = $this->empresa->trae_empresas();//$this->empresa->get_all_empresas();
			$data_view['empresa'] =$user['emp_id'];
			$params_view = array(
                'title' => 'Solicita Empresa',
                'view' => 'agendaos/add_emp',
				'view_data' => $data_view
               );
            render_template($params_view);  
        }
    }  



/*********************************/ 
/******************************/
    function nueva_tr()
    {   $user = $this->session->user;
		
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
			$this->form_validation->set_rules('empresa','Empresa','required');
			
            if($this->form_validation->run())
            {
				
				$params['emp_id'] = $this->input->post('empresa');
				$empleado_id=$user['usr_id'];
				
				
                if($this->empresa->get_empresa($params['emp_id']) )
                {
                    send_json_ok('Se guardó de forma correcta');

                }
                else
                {
                    send_json_error('Ocurrió un error al registrar la empresa.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $this->load->helper('template');
			$data_view['solicita'] =$user['usr_nombre'].' '.$user['usr_paterno'];
			$data_view['las_empresas'] = $this->empresa->trae_empresas();//$this->empresa->get_all_empresas();
			$data_view['empresa'] =$user['emp_id'];
			$params_view = array(
                'title' => 'Solicita Empresa',
                'view' => 'agendaos/add_emp',
				'view_data' => $data_view
               );
            render_template($params_view);  
        }
    }  



/*********************************/ 
/************* empresa_select ******************************************************************/	    
    function empresa_select()
    {
        
		$user = $this->session->user;
		
		
        if(isset($_POST) && count($_POST) > 0)     
        {
            //recibe los datos
            $this->load->library('form_validation');
            $this->form_validation->set_rules('empresa','Empresa','required');
          			
            if($this->form_validation->run())
            {
				
					$params['filtro_id'] = $this->input->post('empresa');
					$empleado_id=$user['usr_id'];

					$cal_id = $this->empleado->actualiza($empleado_id, $params); //$this->agenda->add_evento_folio(array_to_upper($params));

				if($cal_id)
                {
                    send_json_ok('Se guardó el filtro en forma correcta.');

							
                }
                else
                {
                    send_json_error('Ocurrió un error al guardar, Por favor revise si toda su información esta completa y vuelva intentar.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div>'));
            }
        }
	
        else
        {   

           
			$data_view['solicita'] =$user['usr_nombre'].' '.$user['usr_paterno'];
			$data_view['las_empresas'] = $this->empresa->trae_empresas();//$this->empresa->get_all_empresas();
			$data_view['empresa'] =$user['emp_id'];

            $this->load->helper('template');
            $params_view = array(
                'title' => 'Servicios',
                'view' => 'agendaos/empresa_select',
                'view_data' => $data_view
               );
            render_template($params_view); 

			
        //    $view = $this->load->view('agendaos/empresa_select',$data_view,TRUE);
        //    send_json_ok($view);
        }
    }	
/*************************************************************************************/	




/*************filtro ******************************************************************/	    
    function empresa_solicita()
    {
        
		$user = $this->session->user;
		
		
        if(isset($_POST) && count($_POST) > 0)     
        {
			
			$user_root4=get_my_user_root4();
            //recibe los datos
            $this->load->library('form_validation');
            $this->form_validation->set_rules('empresa','Empresa','required');
           // $this->form_validation->set_rules('asunto','Asunto','required');
			
            if($this->form_validation->run())
            {
				
					$params['filtro_id'] = $this->input->post('empresa');
					$empleado_id=$user['usr_id'];
				
				
               /* if ($params['emp_id'] > 0)
				{	*/
                $cal_id = $this->empleado->actualiza($empleado_id, $params); //$this->agenda->add_evento_folio(array_to_upper($params));
				/*}*/
				
				if($cal_id)
                {
                    send_json_ok('Se guardó el filtro en forma correcta.');
					redirect('empresa/index');
					exit;
                }
                else
                {
                    send_json_error('Ocurrió un error al guardar, Por favor revise si toda su información esta completa y vuelva intentar.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div>'));
            }
        }
	
        else
        {   

           
			$data_view['solicita'] =$user['usr_nombre'].' '.$user['usr_paterno'];
			//$this->load->model('empresa/Empresa_model','empresa');

			$data_view['las_empresas'] = $this->empresa->trae_empresas();//$this->empresa->get_all_empresas();

			$data_view['empresa'] =$user['emp_id'];
	
			
            //$data_view['title_modal'] = 'Nueva cita';
            $view = $this->load->view('agendaos/empresa_solicita',$data_view,TRUE);
            send_json_ok($view);
        }
    }
/*************************************************************************************/	

/*************************************************************************************/ 
/*								Validador DE EVENTOS									 */ 
/*************************************************************************************/ 
public function valida_empresa() 
    {
		$user = $this->session->user;
		$evento = $this->agenda->get_evento('2885');
		$titulo=$evento['cal_titulo'];
        
        if($evento)
        {

            if (0) //  (isset($_POST) && count($_POST) > 0 )     
            {
               $this->load->library('form_validation');
              //  $this->form_validation->set_rules('nombre','Nombre','required');
               // $this->form_validation->set_rules('paterno','Apellido Paterno','required');
              //  $this->form_validation->set_rules('materno','Apellido Materno','required');
              //  $this->form_validation->set_rules('fnac','Fecha de nacimiento','required');
               $this->form_validation->set_rules('clave_valida','Clave de Aprobación','required');
               $this->form_validation->set_rules('valida_obs','Observaciones','required');
                

                   // $data_usr = array_to_upper($data_usr);
                    
					$params['cal_user_valida'] = $this->input->post('user_valida');
					$params['cal_clave_valida'] = $this->input->post('clave_valida');
					$params['cal_det_validacion'] = $this->input->post('valida_obs');
		
					if ($this->input->post('clave_valida') == '2020')
					{	
                    $cal_id = $this->agenda->update_evento($evento['cal_id'], array_to_upper($params));
                    }
					
					if($cal_id)
                    {
						$this->load->helper('mail');
                        $evento_n = $this->agenda->get_evento($evento_id);
                        $data_email = array(
                                            'evento' => $evento_n, 
                                            'evento_old' => $evento
											);
						
						$html = $this->load->view('agendaos/email_valid_std_event_serv',$data_email,TRUE);
						send_mail_valid_std_event_serv($this->input->post('mail'), $evento_n, $html,$evento_id,get_empresa($user['emp_id']),$user['usr_nombre'].' '.$user['usr_paterno'],$user['usr_correo'],$params['cal_lugar']);
                        send_json_ok('Se actualizó de forma correcta');
                    }
                    else
                    {
                        send_json_error('Ocurrió un error al v a l id a r el servicio.');
                    }
            }
            else 
            {
				
               // $this->load->model('empresa/Empresa_model','empresa');
               // $data['empresas'] = $this->empresa->get_all_empresas();
			//	$data['sucursals'] = $this->empresa->get_all_sucursales();
               $data['empleado'] = $user;
			   $data['evento'] = $evento;
			//data['empleado_password'] = $empleado_password;
				
				
				
				$this->load->helper('template');
                $params_view = array(
                    'title' => 'Valida',
                    'view' => 'agendaos/valida',
                    'view_data' => $data
                   );
                render_template($params_view);  
            }
        }
        else 
        {
            show_error('No existe el Evento');
        }
    } 



/*************************************************************************************/ 
/*								Validador DE EVENTOS									 */ 
/*************************************************************************************/ 
public function valida($evento_id) 
    {
		$user = $this->session->user;
		$evento = $this->agenda->get_evento($evento_id);
		$titulo=$evento['cal_titulo'];
        
        if($evento)
        {

            if(isset($_POST) && count($_POST) > 0)     
            {
               $this->load->library('form_validation');
              //  $this->form_validation->set_rules('nombre','Nombre','required');
               // $this->form_validation->set_rules('paterno','Apellido Paterno','required');
              //  $this->form_validation->set_rules('materno','Apellido Materno','required');
              //  $this->form_validation->set_rules('fnac','Fecha de nacimiento','required');
               $this->form_validation->set_rules('clave_valida','Clave de Aprobación','required');
               $this->form_validation->set_rules('valida_obs','Observaciones','required');
                

                   // $data_usr = array_to_upper($data_usr);
                    
					$params['cal_user_valida'] = $this->input->post('user_valida');
					$params['cal_clave_valida'] = $this->input->post('clave_valida');
					$params['cal_det_validacion'] = $this->input->post('valida_obs');
		
					if ($this->input->post('clave_valida') == '2020')
					{	
                    $cal_id = $this->agenda->update_evento($evento['cal_id'], array_to_upper($params));
                    }
					
					if($cal_id)
                    {
						$this->load->helper('mail');
                        $evento_n = $this->agenda->get_evento($evento_id);
                        $data_email = array(
                                            'evento' => $evento_n, 
                                            'evento_old' => $evento
											);
						
						$html = $this->load->view('agendaos/email_valid_std_event_serv',$data_email,TRUE);
						send_mail_valid_std_event_serv($this->input->post('mail'), $evento_n, $html,$evento_id,get_empresa($user['emp_id']),$user['usr_nombre'].' '.$user['usr_paterno'],$user['usr_correo'],$params['cal_lugar']);
                        send_json_ok('Se actualizó de forma correcta');
                    }
                    else
                    {
                        send_json_error('Ocurrió un error al validar el servicio.');
                    }
               // }
               // else
               // {
               //     send_json_error(validation_errors('<div />'));
               // }
            }
            else 
            {
				
               // $this->load->model('empresa/Empresa_model','empresa');
               // $data['empresas'] = $this->empresa->get_all_empresas();
			//	$data['sucursals'] = $this->empresa->get_all_sucursales();
               $data['empleado'] = $user;
			   $data['evento'] = $evento;
			//data['empleado_password'] = $empleado_password;
				
				
				
				$this->load->helper('template');
                $params_view = array(
                    'title' => 'Valida',
                    'view' => 'agendaos/valida',
                    'view_data' => $data
                   );
                render_template($params_view);  
            }
        }
        else 
        {
            show_error('No existe el Evento');
        }
    } 



/*************************************************************************************/ 
/*								EDITOR DE EVENTOS									 */ 
/*************************************************************************************/ 
    function evento($evento_id) 
    {
	   $user = $this->session->user;	   
       $evento = $this->agenda->get_evento($evento_id);
	   $programa = $this->cliente->get($evento['prog_id']);
	   $empresa= $this->empresa->get_empresa($evento['emp_id']);
	   
		if(isset($evento['cal_id']))
		{			   
			if(isset($_POST) && count($_POST) > 0)     
			{
				//$this->load->library('form_validation');
				if (1) //($this->form_validation->run())
				{
					//$calendar['cal_fecha']=date('Y-m-d');
					//$calendar['cal_fecha_ini']=$fecha_1.' 00:00:01';
					//$calendar['cal_fecha_fin']=$fecha_1.' 23:59:59';
					$calendar['cal_titulo']=$programa['prog_tema'].' - '.$programa['prog_actividad'];
					//$calendar['emp_id']=$data_clte['emp_id'];					

					$calendar['log_updt_f'] = date('Y-m-d H:i:s');
					$calendar['log_updt_usr_cve'] =  $user['usr_id'];								
													
					$calendar['log_updt_prg']= 'CARGA PROG';
					$calendar['cal_observaciones']= $this->input->post('observaciones');
					$calendar['cal_uid']=uniqid(rand(0, getmypid()));
					$calendar['cal_email'] = $this->input->post('mail');
		
					$data_clte['prog_id'] =  $evento['prog_id'];                
					$data_clte['doc_f'] =  date('Y-m-d H:i:s');
					$data_clte['index_id'] =  $programa['prog_loads']+1;
					$data_clte['usr_id'] =  $user['usr_id'];
					$data_clte['doc_nombre'] =  $user['usr_id'].'_'.date('YmdHis');				
	
					if(!empty($_FILES['anexo']['name']))
					{	
						//$nombre_anexo=$_FILES['anexo']['name'];
						sleep(1);						
						$this->load->library('upload');
						$filename = $data_clte['doc_nombre']; 
						$pig=substr(md5(time()),-4);
						$filename=$filename.'_'.$pig;
						$data_clte['doc_nombre']=$filename;
						
						//$filename = md5(time());
						$config = array(
								'upload_path'   => './../../files/docs_programmer/',
								'overwrite'     => TRUE,
								'file_name'     => $filename,
								'allowed_types' => 'doc|docx|pdf|txt|xlsx|xls|png|jpg|jpeg',
								'max_size'      => '10000'
						);
						
						$this->upload->initialize($config);
						
						if ( ! $this->upload->do_upload('anexo'))
						{
							echo json_encode(array('status' => 'error','content' => $this->upload->display_errors()));
							exit;
						}
						else 
						{

							$data = $this->upload->data();
							$calendar['cal_anexo_path'] = $data['file_name'];
							$calendar['cal_anexo_nombre'] = $nombre_anexo;
							$data_clte['doc_path'] = $data['file_name'];
							//$calendar['cal_estatus'] = 'DESACTIVADO';
							$calendar['cal_estatus']= 'CON CARGA';
							
							$cal_id = $this->agenda->update_evento($evento['cal_id'], array_to_upper($calendar));
							$doc_id= $this->cliente->add_doc(array_to_upper($data_clte));

							if  ( ($cal_id) && ($doc_id) )
							{	
						
								$prog_update['prog_loads']= $programa['prog_loads']+1;
								$prog_update['prog_load_f']= $data_clte['doc_f'];
								$this->cliente->actualiza($programa['prog_id'], $prog_update);
								
								
								$this->load->helper('mail');
								
								$evento_n = $this->agenda->get_evento($evento_id);
								$programa = $this->cliente->get($evento['prog_id']);
								
								$data_email = array(
													'evento' => $evento_n, 
													'programa' => $programa
													);

								$html = $this->load->view('agendaos/email_edit_evento_servicio',$data_email,TRUE);
								send_mail_event_load_docs($this->input->post('mail'), $evento_n, $html,$user['usr_nombre'].' '.$user['usr_paterno'],$user['usr_correo']);
								
								send_json_ok('Se cargo y registro de forma correcta el documento.');
							
							}
							else
							{
								send_json_error('Ocurrió un error al actualizar, intente de nuevo más tarde.');
							}
						}	
					}
					else
					{
						send_json_error('Se debe carga run archivo para actualziar el registro');
					}				
				}
			}
			else
			{
				$this->load->model('empleado/Empleado_model','empleado');							  
				$data_view['asignado'] = $this->empleado->get($evento['cal_asignacion']);
				$data_view['title_modal'] = 'Programas';
				$data_view['evento'] = $evento;
				$data_view['empresa'] = $empresa;	
				$data_view['programa'] = $programa;				
				$view = $this->load->view('agendaos/edit_serv',$data_view,TRUE);
				send_json_ok($view);
			}				
		}
		else
		{
			send_json_error('No existe el evento.');
		}
    }

    //elimina el evento
    function borra($evento_id)
    { 
        $evento = $this->agenda->get_evento($evento_id);
		
		$id_horario =$evento['cal_id_horario'];
		$cuantos_evaluados=$evento['cal_cuantos_evaluados'];
		
		$horario_ok=$this->agenda->get_horario($id_horario);
		
		$horario_ok['she_capacidad']=$horario_ok['she_capacidad']+$cuantos_evaluados;
		$horario_apartado=$this->agenda->aparta_horario($id_horario,$horario_ok);
		
        if(isset($evento['cal_id']))
        {
            if($this->agenda->delete_evento($evento_id))
            {
                    $this->load->helper('mail');
                    $data_email = array('evento' => $evento);
					
					
                    $html = $this->load->view('agendaos/email_del_std_event',$data_email,TRUE);
					send_mail_del_std_event($evento['cal_email'], $evento, $html);
 
                //} 
                send_json_ok('Se eliminó de forma correcta');
            }
            else 
            {
                send_json_error('Ocurrió un error al eliminar el evento, intente de nuevo más tarde');
            }
        }
        else
        {
            send_json_error('No existe el evento.');
        }
    }
    
    public function get_emp_json()
    {
        $this->load->model('empresa/Empresa_model','empresa');
        $term = $this->input->get('term');
        $emps = $this->empresa->find_empresa($term);
        $emps_formated = array();
        foreach ($emps as $emp)
        {
            $emps_formated[] = array('label' => mb_strtoupper($emp['emp_razon_social']),'value' => $emp['emp_id'],'email' => $emp['emp_correo'],'tel'=> $emp['emp_telefono'],'resp' => $emp['emp_responsable']);
        }
        echo json_encode($emps_formated);
    }
}