<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Cert_medico extends CI_Controller {
    function __construct() {
        parent::__construct();
        $this->load->model('persona/Persona_model','cliente');
        $this->load->model('empleado/Empleado_model','medico');
		$this->load->model('servicio/Servicio_model','servicio');
		$this->load->model('examen/Cert_medico_model','certificado');
		$this->load->helper('util'); 
    }

	public function nuevorx($cliente_id)
    {
		
		$persona = $this->cliente->get($cliente_id);
		$user = $this->session->user;
		$medico = $this->medico->get($user['usr_id']);  
	
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');

			if (($persona['serv_id'] == 0) ||(get_status_serv($persona['serv_id']) != 'PROCESO'))
			{					
					$this->form_validation->set_rules('servicio','Orden de servicio','required');
			}
			else
			{
					$this->form_validation->set_rules('servicio','Orden de servicio','integer');
			}

            			
			//$this->form_validation->set_rules('ex_obs','Observaciones','required');

            if($this->form_validation->run())
            {


				if (($persona['serv_id'] == 0) || (get_status_serv($persona['serv_id']) != 'PROCESO'))
				{	
						$data_insert['serv_id']  = $this->input->post('servicio');
				}
				else
				{	
						$data_insert['serv_id']  = $persona['serv_id'];
				}
			
				$data_insert['clte_id'] = $persona['clte_id'];
				$data_insert['emp_id'] = $persona['emp_id'];
				$data_insert['suc_id'] = $persona['suc_id'];
                $data_insert['med_id'] = $this->input->post('medicos'); 
                $data_insert['usr_id']  = $user['usr_id'];
				 $data_insert['fsm_fecha_certificado']   =  $this->input->post('fecha_examen');
				$data_insert['fsm_lugar']   =  $this->input->post('lugar_examen');    
 				$data_insert['log_insrt_f']   = date("Y-m-d H:i:s");  
				$data_insert['log_insrt_usr_cve']   =  $user['usr_id'];  	
				$data_insert['log_updt_f']   =  $data_insert['fsm_f']; 		
				$data_insert['log_updt_usr_cve']   =  $user['usr_id'];	

				$data_insert['fsm_peso']=$this->input->post('fsm_peso');
				$data_insert['fsm_ta']=$this->input->post('fsm_ta');
				$data_insert['fsm_talla']=$this->input->post('fsm_talla');
				$data_insert['fsm_alergia']=$this->input->post('fsm_alergia');
				$data_insert['fsm_imc']=$this->input->post('fsm_imc');
				$data_insert['fsm_fc']=$this->input->post('fsm_fc');
				$data_insert['fsm_avisual']=$this->input->post('fsm_avisual');
				$data_insert['fsm_fr']=$this->input->post('fsm_fr');
				$data_insert['fsm_gsanguineo']=$this->input->post('fsm_gsanguineo');
				$data_insert['fsm_actividad']=$this->input->post('fsm_actividad');
				$data_insert['fsm_ante']=$this->input->post('fsm_ante');				
				$data_insert['fsm_observaciones']=$this->input->post('fsm_observaciones');
				
				$data_insert=array_to_upper($data_insert);

			
		        if($this->certificado->insert_r($data_insert))
                {
                    send_json_ok('Se guardó de forma correcta.');
                }
                else
                {
                    send_json_error('Ocurrió un error al guardar.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
			
			
            $data['persona'] = $persona;
            $data['medico'] = $medico;
			$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);
            $this->load->helper('template');
            $params_view = array(
                'title' => '',
                'view' => 'examen/cert_medico/nuevo_form_rx',
                'view_data' => $data 
               );
            render_template($params_view);
        }
    }




	 public function editarx($cliente_id, $fsm_id)
    {
        $persona = $this->cliente->get($cliente_id);
		$data['fsm'] = $this->certificado->get_r($fsm_id);
		
        $medico = $this->medico->get_id($data['fsm']['med_id']);		
		$user = $this->session->user;
        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
			
            if(true)
            {	
				$data_insert['med_id'] = $this->input->post('medicos'); 
				$data_insert['log_updt_f']   =  date("Y-m-d H:i:s"); 		
				$data_insert['log_updt_usr_cve']   =  $user['usr_id'];				

                $data_insert['usr_id']  = $user['usr_id'];
				$data_insert['fsm_fecha_certificado']   =  $this->input->post('fecha_examen');
				
				$data_insert['fsm_lugar']   =  $this->input->post('lugar_examen');  


				$data_insert['fsm_peso']=$this->input->post('fsm_peso');
				$data_insert['fsm_ta']=$this->input->post('fsm_ta');
				$data_insert['fsm_talla']=$this->input->post('fsm_talla');
				$data_insert['fsm_alergia']=$this->input->post('fsm_alergia');
				$data_insert['fsm_imc']=$this->input->post('fsm_imc');
				$data_insert['fsm_fc']=$this->input->post('fsm_fc');
				$data_insert['fsm_avisual']=$this->input->post('fsm_avisual');
				$data_insert['fsm_fr']=$this->input->post('fsm_fr');
				$data_insert['fsm_gsanguineo']=$this->input->post('fsm_gsanguineo');
				$data_insert['fsm_actividad']=$this->input->post('fsm_actividad');
				$data_insert['fsm_ante']=$this->input->post('fsm_ante');
				$data_insert['fsm_observaciones']=$this->input->post('fsm_observaciones');	
				/*$medico = $this->medico->get_id($data_insert['med_id']);
				
				if ($medico['usr_genero_cve'] == 'H')
				{
					$genero='LIC. ';
				}
				else
				{
					$genero='LIC. ';
				}
				
				$data_insert['fsm_med_nombre'] =$genero.$medico['usr_nombre'].' '.$medico['usr_paterno'].' '.$medico['usr_materno'];
				
				$data_insert['fsm_emp_atte'] = $persona['emp_id'];
				$data_insert['fsm_emp_atte'] = $medico['usr_emp_asig'];

				$data_insert['fsm_med_cedula'] = $medico['usr_cedula'];
				$data_insert['fsm_med_carrera'] = $medico['usr_carrera'];
				$data_insert['fsm_med_escuela'] = $medico['usr_institucion']; */
			
			
				$data_insert=array_to_upper($data_insert);
				$this->db->trans_start();
				
				
				if($this->certificado->update_r($fsm_id,$data_insert))
                {
                    send_json_ok('Se guardó de forma correcta');
                }
                else
                {
                    send_json_error('Ocurrió un error al guardar.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
            $data['medico'] = $medico;
            $this->load->helper('template');
            $params_view = array(
                'title' => '',
                'view' => 'examen/cert_medico/editar_form_rx',
                'view_data' => $data 
               );
            render_template($params_view);
        }
    }

    
    public function pdfr($cliente_id, $fsm_id)
    {
        $data['persona'] = $this->cliente->get($cliente_id,get_desp_id_usr());
        $data['fsm'] = $this->certificado->get_r($fsm_id,get_desp_id_usr());
        $data['medico'] = $this->medico->get_id($data['fsm']['med_id']);
        $data['empresa'] = $this->cliente->get_empresa_by_id($data['fsm']['emp_id']);
        $this->load->helper('pdf');
		//$ruta=base_url('../dist/images/hclogo.jpg');	
		//genera_pdf_receta($this->load->view('examen/notas_psicologicas/pdf_rx',$data,TRUE),'npsicologicas','npsicologicas','npsicologicas','Humancenter Review S.A de C.V.','P',$ruta);
		xamplete_certificado($this->load->view('examen/cert_medico/pdf_rx',$data,TRUE),'certificado','certificados','certificados','Humancenter Review S.A de C.V.');
	}
	
    public function borra($fsm_id)
    {
        if($this->certificado->delete_nota_psicologica($fsm_id))
        {
            send_json_ok('Se eliminó de forma correcta.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar.');
        }
    }
	
/*****************************************************************/
}