﻿<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Perfil_tiroideo_i extends CI_Controller {
    function __construct() {
        parent::__construct();
        $this->load->model('persona/Persona_model','cliente');
		/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
		$this->load->model('servicio/Servicio_model','servicio');
		/*************************************************/			
        $this->load->model('empleado/Empleado_model','medico');
        $this->load->model('examen/Perfil_tiroideo_i_model','qui_san38');
		$this->load->helper('util');
		$this->load->helper('report');
		$this->load->helper('laboratorpi');
    }
    
    public function nuevo($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
        $user = $this->session->user;
		$laboratorio=0;

        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
			/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
			if (($persona['serv_id'] == 0) ||(get_status_serv($persona['serv_id']) != 'PROCESO'))
			{					
					$this->form_validation->set_rules('servicio','Orden de servicio','required');
			}
			else
			{
					$this->form_validation->set_rules('servicio','Orden de servicio','integer');
			}
            /*************************************************/
			$this->form_validation->set_rules('triyodotironina_t3_total','TRIYODOTIRONINA (T3) TOTAL','required');
			$this->form_validation->set_rules('t3_uptake','T3 UPTAKE','required');
			$this->form_validation->set_rules('tiroxina_t4_total','TIROXINA (T4) TOTAL','required');

			$this->form_validation->set_rules('yodo_proteico_ip','YODO PROTEÍCO (IP)','required'); 
			$this->form_validation->set_rules('itl','ÍNDICE DE TIROXINA LIBRE (ITL)','required');  
			$this->form_validation->set_rules('tsh','HORMONA ESTIMULANTE DE LA TIROIDES (TSH)','required'); 

            if($this->form_validation->run())
            {
                $data_insert['usr_id']  = $user['usr_id']; 
				$data_insert['med_id']  = $this->input->post('laboratorista'); 
				
                $data_insert['clte_id'] = $persona['clte_id'];
                $data_insert['emp_id']  = $persona['emp_id'];
				/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
				if (($persona['serv_id'] == 0) || (get_status_serv($persona['serv_id']) != 'PROCESO'))
				{	
						$data_insert['serv_id']  = $this->input->post('servicio');
				}
				else
				{	
						$data_insert['serv_id']  = $persona['serv_id'];
				}
				/**************************************************/			
				$data_insert['qui_medico_sol'] = $this->input->post('medico_sol');
				
                $data_insert['qui_f_recibido']   = formatea_fecha_mysql($this->input->post('fecha_rec')); //date('Y-m-d H:i:s'); 
                $data_insert['qui_f_impresion']  = formatea_fecha_mysql($this->input->post('fecha_imp')); //date('Y-m-d H:i:s');
                $data_insert['log_insrt_f']  =  date('Y-m-d H:i:s');

                $data_insert['qui_triyodotironina_t3_total']  = $this->input->post('triyodotironina_t3_total');
                $data_insert['qui_t3_uptake']=	$this->input->post('t3_uptake');
                $data_insert['qui_tiroxina_t4_total']=	$this->input->post('tiroxina_t4_total');

                $data_insert['qui_yodo_proteico_ip']=	$this->input->post('yodo_proteico_ip');
                $data_insert['qui_itl']=	$this->input->post('itl');
                $data_insert['qui_tsh']=	$this->input->post('tsh');
				
				$data_insert['qui_obs']  = $this->input->post('q_sang_obs');
				
				$laboratorio=$this->input->post('laboratorio');
				$data_insert['qui_laboratorio']  = $this->input->post('laboratorio');
				
				$data_insert= array_to_upper($data_insert);
				
				
				
                if ($laboratorio > 0)
                {
					if ($this->qui_san38->insert($data_insert))
					{
						send_json_ok('Se guardó de forma correcta');
						$servicios=$persona['domserv'];					
						
						$servicio='QSAXA;'; /*CODIGO DEL EXAMEN*/
						if (!(strstr($servicios,$servicio)))
						{							
							$servicios.=$servicio;
							$data_clte['domserv']=$servicios;
							$res=$this->cliente->actualiza_registro_individual($cliente_id, $data_clte);
						}
					}
					else { send_json_error('Ocurrió un error al guardar.'); }
                }
                else
                {
					send_json_error('No has elegido el Laboratorio.'); 					
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
            $data['medico'] = $medico;
			/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
			$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);
			/**************************************************/			
            $this->load->helper('template');
            $params_view = array(
                'title' => '',
                'view' => 'examen/perfil_tiroideo_i/nuevo_form',
                'view_data' => $data 
               );
            render_template($params_view);
        }
    }
    
    public function pdf($cliente_id, $fsm_id)
    {
        $data['persona'] = $this->cliente->get($cliente_id,get_desp_id_usr());
        $data['fsm'] = $this->qui_san38->get($fsm_id,get_desp_id_usr());
        $data['medico'] = $this->medico->get_id($data['fsm']['med_id']);
        $data['empresa'] = $this->cliente->get_empresa_by_id($data['fsm']['emp_id']);
        $this->load->helper('pdf');
		
		$med_name=$data['fsm']['qui_lab']; //'Q.F.B. JAIMES FLORES MONTSERRAT    11322160                                                                                                                        ';
		$emp_id=$data['fsm']['emp_id'];
		$observaciones=$data['fsm']['qui_obs'];
		$fuera_rango=$data['fsm']['qui_fuera_rango'];
        $data_empresa = $this->cliente->get_empresa_by_id($emp_id);	
       // $ruta = base_url('../dist/images/hclogo.jpg');
	   
		if ($data_empresa['emp_giro'] == 'SEGURIDAD')
		{
			$med_name=$data['fsm']['qui_lab']; //'Q.F.B. JAIMES FLORES MONTSERRAT    11322160                                                                                                                        ';
			genera_pdf_tohuanti($this->load->view('examen/perfil_tiroideo_i/pdf',$data,TRUE),'perfil tiroideo I','perfil tiroideo I','perfil tiroideo I');
		}
		else
		{	
			//$med_name=agrega_cedula($med_name,'Cédula Profesional:');
			//genera_pdf_lab_new($this->load->view('examen/quimica_sanguinea38/pdf',$data,TRUE),'quimica_sanguinea38','quimica_sanguinea38',$med_name,$observaciones,$fuera_rango);		
			$med_name=agrega_cedula_ext($data['fsm']['med_id']);
			genera_pdf_lab_new_x($this->load->view('examen/perfil_tiroideo_i/pdf',$data,TRUE),'perfil tiroideo I','perfil tiroideo I',$med_name,$observaciones,$fuera_rango);	
		}	   
	   /* esta versión numera las hojas
			genera_pdf_lab_new_l($this->load->view('examen/quimica_sanguinea38/pdf',$data,TRUE),'quimica_sanguinea38','quimica_sanguinea38',$med_name,$observaciones, $ruta);		
       */
	}
	

    public function borra($fsm_id)
    {
        if($this->qui_san38->delete_qui_san($fsm_id))
        {
            send_json_ok('Se eliminó de forma correcta.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar.');
        }
    }
	
	
}
