<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Salud_ocupacional extends CI_Controller {
    function __construct() {
        parent::__construct();
        $this->load->model('persona/Persona_model','cliente');
        $this->load->model('empleado/Empleado_model','medico');
		$this->load->model('empresa/Empresa_model','empresa');	
		$this->load->model('examen/Salud_ocupacional_model','salud_ocupacional');
		$this->load->helper('util'); 
		$this->load->helper('report'); 
    }

/*************************************************************************************/
	public function editar_CARATULA($cliente_id, $fsm_id)
    {
        $persona = $this->cliente->get($cliente_id);
		$data['fsm'] = $this->salud_ocupacional->get_CARATULA($fsm_id);		
        $user = $this->session->user;

        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');

            if(true)
            {
			/*	$data_insert['clte_id'] = $persona['clte_id'];
				$data_insert['fsm_edad']=intval(trim(str_replace("años", "",get_edad($persona['clte_f_nac']))));
				
				$data_insert['fsm_f_nac']=$persona['clte_f_nac'];
				$data_insert['fsm_genero']=$persona['clte_genero_cve'];
				$data_insert['emp_id'] = $persona['emp_id'];
				$data_insert['suc_id'] = $persona['suc_id'];               
                $data_insert['serv_id']  = '';
                $data_insert['usr_id']  = $user['usr_id'];
                $data_insert['fsm_f']   =  date("Y-m-d H:i:s");
				
				$data_insert['fsm_f_y']   =  date("Y");
				$data_insert['fsm_f_m']   =  date("m");
				$data_insert['fsm_f_d']   =  date("d");
				$data_insert['fsm_f_h']   =  date("H");
				$data_insert['fsm_f_i']   =  date("i");
			*/					

/**************************************/
								
				$data_insert['med_id'] = $this->input->post('medico');				
				$medico = $this->medico->get($data_insert['med_id']);
			
				$data_insert['fsm_jefe'] = $this->input->post('jefe');
				$data_insert['fsm_planta'] = $this->input->post('planta');
				$data_insert['fsm_antiguedad_empresa'] = $this->input->post('antiguedad_empresa');
				$data_insert['fsm_linea'] = $this->input->post('linea');
				$data_insert['fsm_antiguedad_area'] = $this->input->post('antiguedad_area');
				$data_insert['fsm_area_depto'] = $this->input->post('area_depto');
				$data_insert['fsm_puesto'] = $this->input->post('puesto');

				$data_insert['fsm_tipo_identifica'] = $this->input->post('tipo_identifica');
				$data_insert['fsm_no_identifica'] = $this->input->post('no_identifica');
				$data_insert['fsm_medicamentos'] = $this->input->post('medicamentos');
				
				$data_insert['fsm_maleatorio'] = $this->input->post('maleatorio');
				$data_insert['fsm_mperiodico'] = $this->input->post('mperiodico');
				$data_insert['fsm_motro'] = $this->input->post('motro');
				$data_insert['fsm_motro_exp'] = $this->input->post('motro_exp');
				
				$data_insert['fsm_autorizo_f'] = $this->input->post('autorizo_f');
				$data_insert['fsm_autorizo_d'] = $this->input->post('autorizo_d');
				$data_insert['fsm_medico'] = $this->input->post('medico');
				$data_insert['fsm_colector_f'] = $this->input->post('colector_f');
				$data_insert['fsm_colector_d'] = $this->input->post('colector_d');
				$data_insert['fsm_amp_neg'] = $this->input->post('amp_neg');
				$data_insert['fsm_amp_inv'] = $this->input->post('amp_inv');
				$data_insert['fsm_amp_nne'] = $this->input->post('amp_nne');
				$data_insert['fsm_coc_neg'] = $this->input->post('coc_neg');
				$data_insert['fsm_coc_inv'] = $this->input->post('coc_inv');
				$data_insert['fsm_coc_nne'] = $this->input->post('coc_nne');
				$data_insert['fsm_thc_neg'] = $this->input->post('thc_neg');
				$data_insert['fsm_thc_inv'] = $this->input->post('thc_inv');
				$data_insert['fsm_thc_nne'] = $this->input->post('thc_nne');
				$data_insert['fsm_opi_neg'] = $this->input->post('opi_neg');
				$data_insert['fsm_opi_inv'] = $this->input->post('opi_inv');
				$data_insert['fsm_opi_nne'] = $this->input->post('opi_nne');
				$data_insert['fsm_met_neg'] = $this->input->post('met_neg');
				$data_insert['fsm_met_inv'] = $this->input->post('met_inv');
				$data_insert['fsm_met_nne'] = $this->input->post('met_nne');
				$data_insert['fsm_recibe_lab'] = $this->input->post('recibe_lab');
				$data_insert['fsm_lab_f'] = $this->input->post('lab_f');
				$data_insert['fsm_lab_h'] = $this->input->post('lab_h');
				$data_insert['fsm_integridad'] = $this->input->post('integridad');
				$data_insert['fsm_observaciones'] = $this->input->post('observaciones');
	
				if ($medico['usr_genero_cve'] == 'H') {$gen= 'Dr. ';} else {$gen= 'Dra. ';}
				$data_insert['fsm_med_nombre'] = $gen.$medico['usr_nombre'].' '.$medico['usr_paterno'].' '.$medico['usr_materno'];
				$data_insert['fsm_med_cedula'] =$medico['usr_cedula'];
				$data_insert['fsm_med_carrera'] =$medico['usr_carrera'];
				$data_insert['fsm_med_escuela'] =$medico['usr_institucion'];

				$data_insert['log_updt_f']   =  date("Y-m-d H:i:s");
				$data_insert['log_updt_usr_cve']  = $user['usr_id']; 

				$data_insert=array_to_upper($data_insert);

				if ($this->salud_ocupacional->update_CARATULA($fsm_id,$data_insert))
                {	
					header('Location:'.base_url('persona/id').'/'.$cliente_id); 
					exit;
                   // send_json_ok('Se actualizo el registro en forma correcta.');
                }
                else
                {
                    send_json_error('Ocurrió un error al actualizar el registro.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
            $this->load->helper('template');
            $params_view = array(
                'title' => '',
                'view' => 'examen/salud_ocupacional/edit_CARATULA',
                'view_data' => $data 
               );
            render_template($params_view);
        }
    }
/*************************************************************************************/
    public function nuevo_CARATULA($cliente_id)
    {    
		$user = $this->session->user;
		$cliente = $this->cliente->get($cliente_id);
		$empresa=$cliente['emp_id'];	
		$persona = $this->cliente->get($cliente_id);

        if($cliente)
        {
            if(isset($_POST) && count($_POST) > 0)     
            {
                $this->load->library('form_validation');

                //$this->form_validation->set_rules('jefe','Nombre del testigo','required');

                //if($this->form_validation->run())
				if(1)	
                {
				$data_insert['clte_id'] = $persona['clte_id'];
				$data_insert['fsm_edad']=intval(trim(str_replace("años", "",get_edad($persona['clte_f_nac']))));
				
				$data_insert['fsm_f_nac']=$persona['clte_f_nac'];
				$data_insert['fsm_genero']=$persona['clte_genero_cve'];
				$data_insert['emp_id'] = $persona['emp_id'];
				$data_insert['suc_id'] = $persona['suc_id'];               
                $data_insert['serv_id']  = '';
                $data_insert['usr_id']  = $user['usr_id'];
                $data_insert['fsm_f']   =  date("Y-m-d H:i:s");
				
				$data_insert['fsm_f_y']   =  date("Y");
				$data_insert['fsm_f_m']   =  date("m");
				$data_insert['fsm_f_d']   =  date("d");
				$data_insert['fsm_f_h']   =  date("H");
				$data_insert['fsm_f_i']   =  date("i");
								
				//$data_insert['med_id'] = $this->input->post('medico');				
				//$medico = $this->medico->get($data_insert['med_id']);			
				$data_insert['diabetes'] = $this->input->post('diabetes');
				$data_insert['diabetes_ext'] = $this->input->post('diabetes_ext');
				$data_insert['hipertension'] = $this->input->post('hipertension');
				$data_insert['hipertension_ext'] = $this->input->post('hipertension_ext');
				$data_insert['obesidad'] = $this->input->post('obesidad');
				$data_insert['obesidad_ext'] = $this->input->post('obesidad_ext');
				$data_insert['asma'] = $this->input->post('asma');
				$data_insert['asma_ext'] = $this->input->post('asma_ext');
				
				
				$data_insert['cardiopatias'] = $this->input->post('cardiopatias');
				$data_insert['cardiopatias_ext'] = $this->input->post('cardiopatias_ext');
				
			
				$data_insert['otro'] = $this->input->post('otro');
				$data_insert['otro_ext'] = $this->input->post('otro_ext');
				$data_insert['hoja_frontal'] = $this->input->post('hoja_frontal');
				$data_insert['nota_medica'] = $this->input->post('nota_medica');
				$data_insert['avisos'] = $this->input->post('avisos');
				$data_insert['clinico'] = $this->input->post('clinico');
				$data_insert['eperiodicos'] = $this->input->post('eperiodicos');
				$data_insert['eingreso'] = $this->input->post('eingreso');
				/*
				if ($medico['usr_genero_cve'] == 'H') {$gen= 'Dr. ';} else {$gen= 'Dra. ';}
				$data_insert['fsm_med_nombre'] = $gen.$medico['usr_nombre'].' '.$medico['usr_paterno'].' '.$medico['usr_materno'];
				$data_insert['fsm_med_cedula'] =$medico['usr_cedula'];
				$data_insert['fsm_med_carrera'] =$medico['usr_carrera'];
				$data_insert['fsm_med_escuela'] =$medico['usr_institucion'];
				*/
				$data_insert['log_insrt_f']   =  date("Y-m-d H:i:s");
				$data_insert['log_insrt_usr_cve']  = $user['usr_id'];
				$data_insert['log_updt_f']   =  date("Y-m-d H:i:s");
				$data_insert['log_updt_usr_cve']  = $user['usr_id']; 

					
					$CARATULA=$this->salud_ocupacional->insert_CARATULA(array_to_upper($data_insert));

					if($CARATULA)
					{
						send_json_ok(array('msg' =>'Se realizo el registro adecuadamente', 'id' => $cliente_id));
					}
					else
					{
						send_json_error('Ocurrió un error al realizar el registro');
					}					
					
                }
                else
                {
                    send_json_error(validation_errors('<div />'));
                }
            }
            else
 
            {
				$data['persona'] = 	$cliente;

                $this->load->helper('template');
                $params_view = array(
                    'title' => 'Personas',
                    /*'view' => 'persona/edit_empleado_x',*/
					'view' => 'examen/salud_ocupacional/nuevo_form_CARATULA',
                    'view_data' => $data
                   );
                render_template($params_view);  
            }
        }
        else 
        {
            show_error('No existe el cliente');
        }
    }
	
   public function borra_CARATULA($fsm_id)
    {
        if($this->salud_ocupacional->borra_CARATULA($fsm_id))
        {
            send_json_ok('Se eliminó de forma correcta el registro.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar el registro.');
        }
    }

    public function pdf_CARATULA($cliente_id, $fsm_id)
    {
		$user = $this->session->user;
		
        $data['persona'] = $this->cliente->get($cliente_id,get_desp_id_usr());
        $data['fsm'] = $this->salud_ocupacional->get_CARATULA($fsm_id);
        $data['medico'] = $this->medico->get_id($data['fsm']['med_id']);
        $data['empresa'] = $this->cliente->get_empresa_by_id($data['fsm']['emp_id']);
        $reporte=$user['usr_id'].'_'.$data['fsm']['emp_id'].'_'.date("Ymd_His");
		$this->load->helper('pdf');
		$ruta=base_url('../dist/images/hclogo.jpg');
		
		$persona= $data['persona']['clte_paterno'].'_'. $data['persona']['clte_materno'].'_'. $data['persona']['clte_nombre'];
		genera_pdf_lab_new_g($this->load->view('examen/salud_ocupacional/pdf_CARATULA',$data,TRUE),$reporte,$user['usr_id'].'_'.$persona,$reporte,$user['usr_id'].'_'.$persona,'Humancenter Review S.A de C.V.','P',$ruta);

	}

	
/*************************************************************/
/*************************************************************************************/
	public function editar_FEHS035($cliente_id, $fsm_id)
    {
        $persona = $this->cliente->get($cliente_id);
		$data['fsm'] = $this->salud_ocupacional->get_FEHS035($fsm_id);		
        $user = $this->session->user;

        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');

            if(true)
            {
			/*	$data_insert['clte_id'] = $persona['clte_id'];
				$data_insert['fsm_edad']=intval(trim(str_replace("años", "",get_edad($persona['clte_f_nac']))));
				
				$data_insert['fsm_f_nac']=$persona['clte_f_nac'];
				$data_insert['fsm_genero']=$persona['clte_genero_cve'];
				$data_insert['emp_id'] = $persona['emp_id'];
				$data_insert['suc_id'] = $persona['suc_id'];               
                $data_insert['serv_id']  = '';
                $data_insert['usr_id']  = $user['usr_id'];
                $data_insert['fsm_f']   =  date("Y-m-d H:i:s");
				
				$data_insert['fsm_f_y']   =  date("Y");
				$data_insert['fsm_f_m']   =  date("m");
				$data_insert['fsm_f_d']   =  date("d");
				$data_insert['fsm_f_h']   =  date("H");
				$data_insert['fsm_f_i']   =  date("i");
			*/					

/**************************************/
								
				$data_insert['med_id'] = $this->input->post('medico');				
				$medico = $this->medico->get($data_insert['med_id']);
			
				$data_insert['fsm_jefe'] = $this->input->post('jefe');
				$data_insert['fsm_planta'] = $this->input->post('planta');
				$data_insert['fsm_antiguedad_empresa'] = $this->input->post('antiguedad_empresa');
				$data_insert['fsm_linea'] = $this->input->post('linea');
				$data_insert['fsm_antiguedad_area'] = $this->input->post('antiguedad_area');
				$data_insert['fsm_area_depto'] = $this->input->post('area_depto');
				$data_insert['fsm_puesto'] = $this->input->post('puesto');

				$data_insert['fsm_tipo_identifica'] = $this->input->post('tipo_identifica');
				$data_insert['fsm_no_identifica'] = $this->input->post('no_identifica');
				$data_insert['fsm_medicamentos'] = $this->input->post('medicamentos');
				
				$data_insert['fsm_maleatorio'] = $this->input->post('maleatorio');
				$data_insert['fsm_mperiodico'] = $this->input->post('mperiodico');
				$data_insert['fsm_motro'] = $this->input->post('motro');
				$data_insert['fsm_motro_exp'] = $this->input->post('motro_exp');
				
				$data_insert['fsm_autorizo_f'] = $this->input->post('autorizo_f');
				$data_insert['fsm_autorizo_d'] = $this->input->post('autorizo_d');
				$data_insert['fsm_medico'] = $this->input->post('medico');
				$data_insert['fsm_colector_f'] = $this->input->post('colector_f');
				$data_insert['fsm_colector_d'] = $this->input->post('colector_d');
				$data_insert['fsm_amp_neg'] = $this->input->post('amp_neg');
				$data_insert['fsm_amp_inv'] = $this->input->post('amp_inv');
				$data_insert['fsm_amp_nne'] = $this->input->post('amp_nne');
				$data_insert['fsm_coc_neg'] = $this->input->post('coc_neg');
				$data_insert['fsm_coc_inv'] = $this->input->post('coc_inv');
				$data_insert['fsm_coc_nne'] = $this->input->post('coc_nne');
				$data_insert['fsm_thc_neg'] = $this->input->post('thc_neg');
				$data_insert['fsm_thc_inv'] = $this->input->post('thc_inv');
				$data_insert['fsm_thc_nne'] = $this->input->post('thc_nne');
				$data_insert['fsm_opi_neg'] = $this->input->post('opi_neg');
				$data_insert['fsm_opi_inv'] = $this->input->post('opi_inv');
				$data_insert['fsm_opi_nne'] = $this->input->post('opi_nne');
				$data_insert['fsm_met_neg'] = $this->input->post('met_neg');
				$data_insert['fsm_met_inv'] = $this->input->post('met_inv');
				$data_insert['fsm_met_nne'] = $this->input->post('met_nne');
				$data_insert['fsm_recibe_lab'] = $this->input->post('recibe_lab');
				$data_insert['fsm_lab_f'] = $this->input->post('lab_f');
				$data_insert['fsm_lab_h'] = $this->input->post('lab_h');
				$data_insert['fsm_integridad'] = $this->input->post('integridad');
				$data_insert['fsm_observaciones'] = $this->input->post('observaciones');
	
				if ($medico['usr_genero_cve'] == 'H') {$gen= 'Dr. ';} else {$gen= 'Dra. ';}
				$data_insert['fsm_med_nombre'] = $gen.$medico['usr_nombre'].' '.$medico['usr_paterno'].' '.$medico['usr_materno'];
				$data_insert['fsm_med_cedula'] =$medico['usr_cedula'];
				$data_insert['fsm_med_carrera'] =$medico['usr_carrera'];
				$data_insert['fsm_med_escuela'] =$medico['usr_institucion'];

				$data_insert['log_updt_f']   =  date("Y-m-d H:i:s");
				$data_insert['log_updt_usr_cve']  = $user['usr_id']; 

				$data_insert=array_to_upper($data_insert);

				if ($this->salud_ocupacional->update_FEHS035($fsm_id,$data_insert))
                {	
					header('Location:'.base_url('persona/id').'/'.$cliente_id); 
					exit;
                   // send_json_ok('Se actualizo el registro en forma correcta.');
                }
                else
                {
                    send_json_error('Ocurrió un error al actualizar el registro.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
            $this->load->helper('template');
            $params_view = array(
                'title' => '',
                'view' => 'examen/salud_ocupacional/edit_FEHS035',
                'view_data' => $data 
               );
            render_template($params_view);
        }
    }
/*************************************************************************************/
    public function nuevo_FEHS035($cliente_id)
    {    
		$user = $this->session->user;
		$cliente = $this->cliente->get($cliente_id);
		$empresa=$cliente['emp_id'];	
		$persona = $this->cliente->get($cliente_id);

        if($cliente)
        {

            if(isset($_POST) && count($_POST) > 0)     
            {
                $this->load->library('form_validation');

                $this->form_validation->set_rules('jefe','Nombrew del testigo','required');

                //if($this->form_validation->run())
				if(1)	
                {
				$data_insert['clte_id'] = $persona['clte_id'];
				$data_insert['fsm_edad']=intval(trim(str_replace("años", "",get_edad($persona['clte_f_nac']))));
				
				$data_insert['fsm_f_nac']=$persona['clte_f_nac'];
				$data_insert['fsm_genero']=$persona['clte_genero_cve'];
				$data_insert['emp_id'] = $persona['emp_id'];
				$data_insert['suc_id'] = $persona['suc_id'];               
                $data_insert['serv_id']  = '';
                $data_insert['usr_id']  = $user['usr_id'];
                $data_insert['fsm_f']   =  date("Y-m-d H:i:s");
				
				$data_insert['fsm_f_y']   =  date("Y");
				$data_insert['fsm_f_m']   =  date("m");
				$data_insert['fsm_f_d']   =  date("d");
				$data_insert['fsm_f_h']   =  date("H");
				$data_insert['fsm_f_i']   =  date("i");
								
				$data_insert['med_id'] = $this->input->post('medico');				
				//$medico = $this->medico->get($data_insert['med_id']);
			
				$data_insert['fsm_jefe'] = $this->input->post('jefe');
				$data_insert['fsm_autorizo_f'] = $this->input->post('autorizo_f');
				
				
				/*
				if ($medico['usr_genero_cve'] == 'H') {$gen= 'Dr. ';} else {$gen= 'Dra. ';}
				$data_insert['fsm_med_nombre'] = $gen.$medico['usr_nombre'].' '.$medico['usr_paterno'].' '.$medico['usr_materno'];
				$data_insert['fsm_med_cedula'] =$medico['usr_cedula'];
				$data_insert['fsm_med_carrera'] =$medico['usr_carrera'];
				$data_insert['fsm_med_escuela'] =$medico['usr_institucion'];
				*/
				$data_insert['log_insrt_f']   =  date("Y-m-d H:i:s");
				$data_insert['log_insrt_usr_cve']  = $user['usr_id'];
				$data_insert['log_updt_f']   =  date("Y-m-d H:i:s");
				$data_insert['log_updt_usr_cve']  = $user['usr_id']; 

					
					$FEHS035=$this->salud_ocupacional->insert_FEHS035(array_to_upper($data_insert));

					if($FEHS035)
					{
						send_json_ok(array('msg' =>'Se realizo el registro adecuadamente', 'id' => $cliente_id));
					}
					else
					{
						send_json_error('Ocurrió un error al realizar el registro');
					}					
					
                }
                else
                {
                    send_json_error(validation_errors('<div />'));
                }
            }
            else 
            {
				$data['persona'] = 	$cliente;

                $this->load->helper('template');
                $params_view = array(
                    'title' => 'Personas',
                    /*'view' => 'persona/edit_empleado_x',*/
					'view' => 'examen/salud_ocupacional/nuevo_form_FEHS035',
                    'view_data' => $data
                   );
                render_template($params_view);  
            }
        }
        else 
        {
            show_error('No existe el cliente');
        }
    }
	
   public function borra_FEHS035($fsm_id)
    {
        if($this->salud_ocupacional->borra_FEHS035($fsm_id))
        {
            send_json_ok('Se eliminó de forma correcta el registro.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar el registro.');
        }
    }

    public function pdf_FEHS035($cliente_id, $fsm_id)
    {
		$user = $this->session->user;
		
        $data['persona'] = $this->cliente->get($cliente_id,get_desp_id_usr());
        $data['fsm'] = $this->salud_ocupacional->get_FEHS035($fsm_id);
        $data['medico'] = $this->medico->get_id($data['fsm']['med_id']);
        $data['empresa'] = $this->cliente->get_empresa_by_id($data['fsm']['emp_id']);
        $reporte=$user['usr_id'].'_'.$data['fsm']['emp_id'].'_'.date("Ymd_His");
		$this->load->helper('pdf');
		$ruta=base_url('../dist/images/hclogo.jpg');
		genera_pdf_lab_new_g($this->load->view('examen/salud_ocupacional/pdf_FEHS035',$data,TRUE),$reporte,$user['usr_id'],'fsm773','Humancenter Review S.A de C.V.','P',$ruta);

	}

	
/*************************************************************/

/*************************************************************************************/
	public function editar_FEHS034($cliente_id, $fsm_id)
    {
        $persona = $this->cliente->get($cliente_id);
		$data['fsm'] = $this->salud_ocupacional->get_FEHS034($fsm_id);		
        $user = $this->session->user;

        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');

            if(true)
            {
			/*	$data_insert['clte_id'] = $persona['clte_id'];
				$data_insert['fsm_edad']=intval(trim(str_replace("años", "",get_edad($persona['clte_f_nac']))));
				
				$data_insert['fsm_f_nac']=$persona['clte_f_nac'];
				$data_insert['fsm_genero']=$persona['clte_genero_cve'];
				$data_insert['emp_id'] = $persona['emp_id'];
				$data_insert['suc_id'] = $persona['suc_id'];               
                $data_insert['serv_id']  = '';
                $data_insert['usr_id']  = $user['usr_id'];
                $data_insert['fsm_f']   =  date("Y-m-d H:i:s");
				
				$data_insert['fsm_f_y']   =  date("Y");
				$data_insert['fsm_f_m']   =  date("m");
				$data_insert['fsm_f_d']   =  date("d");
				$data_insert['fsm_f_h']   =  date("H");
				$data_insert['fsm_f_i']   =  date("i");
			*/					

/**************************************/
								
				$data_insert['med_id'] = $this->input->post('medico');				
				$medico = $this->medico->get($data_insert['med_id']);
			
				$data_insert['fsm_jefe'] = $this->input->post('jefe');
				$data_insert['fsm_planta'] = $this->input->post('planta');
				$data_insert['fsm_antiguedad_empresa'] = $this->input->post('antiguedad_empresa');
				$data_insert['fsm_linea'] = $this->input->post('linea');
				$data_insert['fsm_antiguedad_area'] = $this->input->post('antiguedad_area');
				$data_insert['fsm_area_depto'] = $this->input->post('area_depto');
				$data_insert['fsm_puesto'] = $this->input->post('puesto');

				$data_insert['fsm_tipo_identifica'] = $this->input->post('tipo_identifica');
				$data_insert['fsm_no_identifica'] = $this->input->post('no_identifica');
				$data_insert['fsm_medicamentos'] = $this->input->post('medicamentos');
				
				$data_insert['fsm_maleatorio'] = $this->input->post('maleatorio');
				$data_insert['fsm_mperiodico'] = $this->input->post('mperiodico');
				$data_insert['fsm_motro'] = $this->input->post('motro');
				$data_insert['fsm_motro_exp'] = $this->input->post('motro_exp');
				
				$data_insert['fsm_autorizo_f'] = $this->input->post('autorizo_f');
				$data_insert['fsm_autorizo_d'] = $this->input->post('autorizo_d');
				$data_insert['fsm_medico'] = $this->input->post('medico');
				$data_insert['fsm_colector_f'] = $this->input->post('colector_f');
				$data_insert['fsm_colector_d'] = $this->input->post('colector_d');
				$data_insert['fsm_amp_neg'] = $this->input->post('amp_neg');
				$data_insert['fsm_amp_inv'] = $this->input->post('amp_inv');
				$data_insert['fsm_amp_nne'] = $this->input->post('amp_nne');
				$data_insert['fsm_coc_neg'] = $this->input->post('coc_neg');
				$data_insert['fsm_coc_inv'] = $this->input->post('coc_inv');
				$data_insert['fsm_coc_nne'] = $this->input->post('coc_nne');
				$data_insert['fsm_thc_neg'] = $this->input->post('thc_neg');
				$data_insert['fsm_thc_inv'] = $this->input->post('thc_inv');
				$data_insert['fsm_thc_nne'] = $this->input->post('thc_nne');
				$data_insert['fsm_opi_neg'] = $this->input->post('opi_neg');
				$data_insert['fsm_opi_inv'] = $this->input->post('opi_inv');
				$data_insert['fsm_opi_nne'] = $this->input->post('opi_nne');
				$data_insert['fsm_met_neg'] = $this->input->post('met_neg');
				$data_insert['fsm_met_inv'] = $this->input->post('met_inv');
				$data_insert['fsm_met_nne'] = $this->input->post('met_nne');
				$data_insert['fsm_recibe_lab'] = $this->input->post('recibe_lab');
				$data_insert['fsm_lab_f'] = $this->input->post('lab_f');
				$data_insert['fsm_lab_h'] = $this->input->post('lab_h');
				$data_insert['fsm_integridad'] = $this->input->post('integridad');
				$data_insert['fsm_observaciones'] = $this->input->post('observaciones');
	
				if ($medico['usr_genero_cve'] == 'H') {$gen= 'Dr. ';} else {$gen= 'Dra. ';}
				$data_insert['fsm_med_nombre'] = $gen.$medico['usr_nombre'].' '.$medico['usr_paterno'].' '.$medico['usr_materno'];
				$data_insert['fsm_med_cedula'] =$medico['usr_cedula'];
				$data_insert['fsm_med_carrera'] =$medico['usr_carrera'];
				$data_insert['fsm_med_escuela'] =$medico['usr_institucion'];

				$data_insert['log_updt_f']   =  date("Y-m-d H:i:s");
				$data_insert['log_updt_usr_cve']  = $user['usr_id']; 

				$data_insert=array_to_upper($data_insert);

				if ($this->salud_ocupacional->update_FEHS034($fsm_id,$data_insert))
                {	
					header('Location:'.base_url('persona/id').'/'.$cliente_id); 
					exit;
                   // send_json_ok('Se actualizo el registro en forma correcta.');
                }
                else
                {
                    send_json_error('Ocurrió un error al actualizar el registro.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
            $this->load->helper('template');
            $params_view = array(
                'title' => '',
                'view' => 'examen/salud_ocupacional/edit_FEHS034',
                'view_data' => $data 
               );
            render_template($params_view);
        }
    }
/*************************************************************************************/
    public function nuevo_FEHS034($cliente_id)
    {    
		$user = $this->session->user;
		$cliente = $this->cliente->get($cliente_id);
		$empresa=$cliente['emp_id'];	
		$persona = $this->cliente->get($cliente_id);

        if($cliente)
        {

            if(isset($_POST) && count($_POST) > 0)     
            {
                $this->load->library('form_validation');
               /* $this->form_validation->set_rules('nombre','Nombre','required');
                $this->form_validation->set_rules('paterno','Apellido Paterno','required');
                $this->form_validation->set_rules('materno','Apellido Materno','required');
                $this->form_validation->set_rules('fnac','Fecha de nacimiento','required');*/
                $this->form_validation->set_rules('puesto','Puesto','required');
              /*  $this->form_validation->set_rules('civil','Estado civil','required');
                $this->form_validation->set_rules('rfc','RFC','required');
                $this->form_validation->set_rules('curp','CURP','required');*/

                if($this->form_validation->run())
                {

/*********************************************************************/

				$data_insert['clte_id'] = $persona['clte_id'];
				$data_insert['fsm_edad']=intval(trim(str_replace("años", "",get_edad($persona['clte_f_nac']))));
				
				$data_insert['fsm_f_nac']=$persona['clte_f_nac'];
				$data_insert['fsm_genero']=$persona['clte_genero_cve'];
				$data_insert['emp_id'] = $persona['emp_id'];
				$data_insert['suc_id'] = $persona['suc_id'];               
                $data_insert['serv_id']  = '';
                $data_insert['usr_id']  = $user['usr_id'];
                $data_insert['fsm_f']   =  date("Y-m-d H:i:s");
				
				$data_insert['fsm_f_y']   =  date("Y");
				$data_insert['fsm_f_m']   =  date("m");
				$data_insert['fsm_f_d']   =  date("d");
				$data_insert['fsm_f_h']   =  date("H");
				$data_insert['fsm_f_i']   =  date("i");
								
				$data_insert['med_id'] = $this->input->post('medico');				
				$medico = $this->medico->get($data_insert['med_id']);
			
				$data_insert['fsm_jefe'] = $this->input->post('jefe');
				$data_insert['fsm_planta'] = $this->input->post('planta');
				$data_insert['fsm_antiguedad_empresa'] = $this->input->post('antiguedad_empresa');
				$data_insert['fsm_linea'] = $this->input->post('linea');
				$data_insert['fsm_antiguedad_area'] = $this->input->post('antiguedad_area');
				$data_insert['fsm_area_depto'] = $this->input->post('area_depto');
				$data_insert['fsm_puesto'] = $this->input->post('puesto');

				$data_insert['fsm_tipo_identifica'] = $this->input->post('tipo_identifica');
				$data_insert['fsm_no_identifica'] = $this->input->post('no_identifica');
				$data_insert['fsm_medicamentos'] = $this->input->post('medicamentos');
				
				$data_insert['fsm_maleatorio'] = $this->input->post('maleatorio');
				$data_insert['fsm_mperiodico'] = $this->input->post('mperiodico');
				$data_insert['fsm_motro'] = $this->input->post('motro');
				$data_insert['fsm_motro_exp'] = $this->input->post('motro_exp');
				
				$data_insert['fsm_autorizo_f'] = $this->input->post('autorizo_f');
				$data_insert['fsm_autorizo_d'] = $this->input->post('autorizo_d');
				$data_insert['fsm_medico'] = $this->input->post('medico');
				$data_insert['fsm_colector_f'] = $this->input->post('colector_f');
				$data_insert['fsm_colector_d'] = $this->input->post('colector_d');
				$data_insert['fsm_amp_neg'] = $this->input->post('amp_neg');
				$data_insert['fsm_amp_inv'] = $this->input->post('amp_inv');
				$data_insert['fsm_amp_nne'] = $this->input->post('amp_nne');
				$data_insert['fsm_coc_neg'] = $this->input->post('coc_neg');
				$data_insert['fsm_coc_inv'] = $this->input->post('coc_inv');
				$data_insert['fsm_coc_nne'] = $this->input->post('coc_nne');
				$data_insert['fsm_thc_neg'] = $this->input->post('thc_neg');
				$data_insert['fsm_thc_inv'] = $this->input->post('thc_inv');
				$data_insert['fsm_thc_nne'] = $this->input->post('thc_nne');
				$data_insert['fsm_opi_neg'] = $this->input->post('opi_neg');
				$data_insert['fsm_opi_inv'] = $this->input->post('opi_inv');
				$data_insert['fsm_opi_nne'] = $this->input->post('opi_nne');
				$data_insert['fsm_met_neg'] = $this->input->post('met_neg');
				$data_insert['fsm_met_inv'] = $this->input->post('met_inv');
				$data_insert['fsm_met_nne'] = $this->input->post('met_nne');
				$data_insert['fsm_recibe_lab'] = $this->input->post('recibe_lab');
				$data_insert['fsm_lab_f'] = $this->input->post('lab_f');
				$data_insert['fsm_lab_h'] = $this->input->post('lab_h');
				$data_insert['fsm_integridad'] = $this->input->post('integridad');			
				
				$data_insert['fsm_observaciones'] = $this->input->post('observaciones');

				if ($medico['usr_genero_cve'] == 'H') {$gen= 'Dr. ';} else {$gen= 'Dra. ';}
				$data_insert['fsm_med_nombre'] = $gen.$medico['usr_nombre'].' '.$medico['usr_paterno'].' '.$medico['usr_materno'];
				$data_insert['fsm_med_cedula'] =$medico['usr_cedula'];
				$data_insert['fsm_med_carrera'] =$medico['usr_carrera'];
				$data_insert['fsm_med_escuela'] =$medico['usr_institucion'];
				
				$data_insert['log_insrt_f']   =  date("Y-m-d H:i:s");
				$data_insert['log_insrt_usr_cve']  = $user['usr_id'];
				$data_insert['log_updt_f']   =  date("Y-m-d H:i:s");
				$data_insert['log_updt_usr_cve']  = $user['usr_id']; 

					
					$FEHS034=$this->salud_ocupacional->insert_FEHS034(array_to_upper($data_insert));

					if($FEHS034)
					{
						send_json_ok(array('msg' =>'Se actualizó la información del Empleado', 'id' => $cliente_id));
					}
					else
					{
						send_json_error('Ocurrió un error al actualizar la persona.');
					}
					
					
                }
                else
                {
                    send_json_error(validation_errors('<div />'));
                }
            }
            else 
            {
                $this->load->model('empresa/Empresa_model','empresa');

				$data['sucursals'] = $this->empresa->get_all_sucursales($empresa);
				$data['consultorios'] = $this->empresa->get_lista_consultorios();
                $data['persona'] = 	$cliente;
				$data['worker'] = 	$worker;
				$data['worker_usr'] = 	$worker_usr;
				
				if ($cliente['serv_id'] > 0)
				{
					$data['servicio'] = $servicio;
				}
                $this->load->helper('template');
                $params_view = array(
                    'title' => 'Personas',
                    /*'view' => 'persona/edit_empleado_x',*/
					'view' => 'examen/salud_ocupacional/nuevo_form_FEHS034',
                    'view_data' => $data
                   );
                render_template($params_view);  
            }
        }
        else 
        {
            show_error('No existe el cliente');
        }
    }
	
   public function borra_FEHS034($fsm_id)
    {
        if($this->salud_ocupacional->borra_FEHS034($fsm_id))
        {
            send_json_ok('Se eliminó de forma correcta el registro.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar el registro.');
        }
    }

    public function pdf_FEHS034($cliente_id, $fsm_id)
    {
		$user = $this->session->user;
		
        $data['persona'] = $this->cliente->get($cliente_id,get_desp_id_usr());
        $data['fsm'] = $this->salud_ocupacional->get_FEHS034($fsm_id);
        $data['medico'] = $this->medico->get_id($data['fsm']['med_id']);
        $data['empresa'] = $this->cliente->get_empresa_by_id($data['fsm']['emp_id']);
        $reporte=$user['usr_id'].'_'.$data['fsm']['emp_id'].'_'.date("Ymd_His");
		$this->load->helper('pdf');
		$ruta=base_url('../dist/images/hclogo.jpg');
		genera_pdf_lab_new_g($this->load->view('examen/salud_ocupacional/pdf_FEHS034',$data,TRUE),$reporte,$user['usr_id'],'fsm773','Humancenter Review S.A de C.V.','P',$ruta);

	}

	
/*************************************************************/
/*************************************************************/

	
   public function borra_ISONORDICO($fsm_id)
    {
        if($this->salud_ocupacional->borra_ISONORDICO($fsm_id))
        {
            send_json_ok('Se eliminó de forma correcta el registro.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar el registro.');
        }
    }

    public function pdf_ISONORDICO($cliente_id, $fsm_id)
    {
		$user = $this->session->user;
		
        $data['persona'] = $this->cliente->get($cliente_id,get_desp_id_usr());
        $data['fsm'] = $this->salud_ocupacional->get_ISONORDICO($fsm_id);
        $data['medico'] = $this->medico->get_id($data['fsm']['med_id']);
        $data['empresa'] = $this->cliente->get_empresa_by_id($data['fsm']['emp_id']);
        $reporte=$user['usr_id'].'_'.$data['fsm']['emp_id'].'_'.date("Ymd_His");
		$this->load->helper('pdf');
		$ruta=base_url('../dist/images/hclogo.jpg');
		genera_pdf_lab_new_g($this->load->view('examen/salud_ocupacional/pdf_ISONORDICO',$data,TRUE),$reporte,$user['usr_id'],'fsm773','Humancenter Review S.A de C.V.','P',$ruta);

	}

	
/*************************************************************/
/*************************************************************/

	
   public function borra_ISOEXMEDINEX($fsm_id)
    {
        if($this->salud_ocupacional->borra_ISOEXMEDINEX($fsm_id))
        {
            send_json_ok('Se eliminó de forma correcta el registro.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar el registro.');
        }
    }

    public function pdf_ISOEXMEDINEX($cliente_id, $fsm_id)
    {
		$user = $this->session->user;
		
        $data['persona'] = $this->cliente->get($cliente_id,get_desp_id_usr());
        $data['fsm'] = $this->salud_ocupacional->get_ISOEXMEDINEX($fsm_id);
        $data['medico'] = $this->medico->get_id($data['fsm']['med_id']);
        $data['empresa'] = $this->cliente->get_empresa_by_id($data['fsm']['emp_id']);
        $reporte=$user['usr_id'].'_'.$data['fsm']['emp_id'].'_'.date("Ymd_His");
		$this->load->helper('pdf');
		$ruta=  "http://13.57.91.218/humancenter/dist/images/qr//hclogo.jpg";//base_url('../dist/images/hclogo.jpg');
		genera_pdf_lab_new_g($this->load->view('examen/salud_ocupacional/pdf_ISOEXMEDINEX',$data,TRUE),$reporte,$user['usr_id'],'fsm773','Humancenter Review S.A de C.V.','P',$ruta);

	}

	
/*************************************************************/

/*************************************************************/
	public function nuevo_ISOEXMP($cliente_id)
    {
		
		$persona = $this->cliente->get($cliente_id);
        $user = $this->session->user;
        //$this->session->user;
       
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');			
		//	$this->form_validation->set_rules('antiguedad','ANTIGUEDAD LABORAL','required');
		//	$this->form_validation->set_rules('area','AREA','required');
		//	$this->form_validation->set_rules('turno','TURNO','required');
/*********************************************************/	
			//$this->form_validation->set_rules('accidente_av','EN CASO DE ACCIDENTE AVISAR A','required');
			//$this->form_validation->set_rules('parentesco_av','PARENTESCO','required');
			//$this->form_validation->set_rules('telefono_av','TELÉFONO','required');
			//$this->form_validation->set_rules('clinica_imss','CLÍNICA DEL IMSS','required');
			//$this->form_validation->set_rules('no_consultorio','No. DE CONSULTORIO','required');
				
			$this->form_validation->set_rules('ante_no_pato','ANTECEDENTES PERSONALES NO PATOLÓGICOS','required');
			$this->form_validation->set_rules('ante_pato','ANTECEDENTES PERSONALES PATOLÓGICOS','required');
			$this->form_validation->set_rules('padec_actual','PADECIMIENTO ACTUAL','required');
			$this->form_validation->set_rules('ta1','TA/','required');
			$this->form_validation->set_rules('ta2','/TA','required');
			$this->form_validation->set_rules('sato2','SatO2','required');
			$this->form_validation->set_rules('fc','FC','required');
			$this->form_validation->set_rules('fr','FR','required');
			$this->form_validation->set_rules('temp','TEMPERATURA','required');
			$this->form_validation->set_rules('estatura','ESTATURA','required');
			$this->form_validation->set_rules('peso','PESO','required');
			$this->form_validation->set_rules('imc','IMC','required');
			$this->form_validation->set_rules('craneo','CRANEO','required');
			//$this->form_validation->set_rules('craneo_exp','craneo_exp','required');
			$this->form_validation->set_rules('pupila_der','PUPILA DERECHA','required');
			$this->form_validation->set_rules('pupila_izq','PUPILA IZQUIERDA','required');
			//$this->form_validation->set_rules('pupila_exp','pupila_exp','required');
			$this->form_validation->set_rules('cara','CARA','required');
			//$this->form_validation->set_rules('cara_exp','TURNO','required');
			$this->form_validation->set_rules('cornea_der','CORNEA DERECHA','required');
			$this->form_validation->set_rules('cornea_izq','CORNEA IZQUIERDA','required');
			//$this->form_validation->set_rules('cornea_exp','cornea_exp','required');
			$this->form_validation->set_rules('cuello','CUELLO','required');
			//$this->form_validation->set_rules('cuello_exp','cuello_exp','required');
			$this->form_validation->set_rules('avisualsl_der','AGUDEZA VISUAL S/L DERECHA','required');
			$this->form_validation->set_rules('avisualsl_izq','AGUDEZA VISUAL S/L IZQUIERDA','required');
			//$this->form_validation->set_rules('avisualsl_exp','avisualsl_exp','required');
			$this->form_validation->set_rules('avisualcl_der','AGUDEZA VISUAL C/L DERECHA','required');
			$this->form_validation->set_rules('avisualcl_izq','AGUDEZA VISUAL C/L IZQUIERDA','required');
			//$this->form_validation->set_rules('avisualcl_exp','avisualcl_exp','required');
			$this->form_validation->set_rules('membrana_timpano_der','MEBRANA TIMPANO DERECHA','required');
			$this->form_validation->set_rules('membrana_timpano_izq','MEBRANA TIMPANO IZQUIERDA','required');
			//$this->form_validation->set_rules('membrana_timpano_exp','membrana_timpano_exp','required');
			$this->form_validation->set_rules('identifica_colores_der','IDENTIFICA COLORES DERECHA','required');
			$this->form_validation->set_rules('identifica_colores_izq','IDENTIFICA COLORES IZQUIERDA','required');
			//$this->form_validation->set_rules('identifica_colores_exp','identifica_colores_exp','required');
			$this->form_validation->set_rules('conducto_der','CONDUCTO DERECHA','required');
			$this->form_validation->set_rules('conducto_izq','CONDUCTO IZQUIERDA','required');
			//$this->form_validation->set_rules('conducto_exp','conducto_exp','required');
			$this->form_validation->set_rules('movimiento_ocular_der','MOVIMIENTO OCULAR DERECHO','required');
			$this->form_validation->set_rules('movimiento_ocular_izq','MOVIMIENTO OCULAR IZQUIERDO','required');
			//$this->form_validation->set_rules('movimiento_ocular_exp','movimiento_ocular_exp','required');
			//$this->form_validation->set_rules('ojo_otros_exp','ojo_otros_exp','required');
			$this->form_validation->set_rules('ptregion_der','PTREGION DERECHA','required');
			$this->form_validation->set_rules('ptregion_izq','PTREGION IZQUIERDA','required');
			//$this->form_validation->set_rules('ptregion_exp','TURNO','required');
			$this->form_validation->set_rules('dermis','DERMIS','required');
			//$this->form_validation->set_rules('dermis_exp','TURNO','required');
			$this->form_validation->set_rules('simetria','SIMETRIA','required');
			//$this->form_validation->set_rules('simetria_exp','TURNO','required');
			$this->form_validation->set_rules('cabello','CABELLO','required');
			//$this->form_validation->set_rules('cabello_exp','TURNO','required');
			$this->form_validation->set_rules('amplexion','APLEXIÓN','required');
			//$this->form_validation->set_rules('amplexion_exp','TURNO','required');
			$this->form_validation->set_rules('unias','UÑAS','required');
			//$this->form_validation->set_rules('unias_exp','TURNO','required');
			$this->form_validation->set_rules('murmullo','MURMULLO','required');
			//$this->form_validation->set_rules('murmullo_exp','TURNO','required');
			$this->form_validation->set_rules('ritmo','RITMO','required');
			//$this->form_validation->set_rules('ritmo_exp','TURNO','required');
			$this->form_validation->set_rules('conformacion','CONFORMACIÓN','required');
			$this->form_validation->set_rules('intensidad','INTENSIDAD','required');
			//$this->form_validation->set_rules('intensidad_exp','TURNO','required');
			$this->form_validation->set_rules('peritasis','PERITASIS','required');
			//$this->form_validation->set_rules('peritasis_exp','TURNO','required');
			$this->form_validation->set_rules('ruidos','RUIDOS','required');
			//$this->form_validation->set_rules('ruidos_exp','TURNO','required');
			$this->form_validation->set_rules('visceromegalias','VICEROMEGALIAS','required');
			//$this->form_validation->set_rules('visceromegalias_exp','TURNO','required');
			$this->form_validation->set_rules('soplos','SOPLOS','required');
			//$this->form_validation->set_rules('soplos_exp','TURNO','required');
			$this->form_validation->set_rules('hernias','HERNIAS','required');
			//$this->form_validation->set_rules('hernias_exp','TURNO','required');
			//$this->form_validation->set_rules('abdomen_otros_exp','TURNO','required');
			$this->form_validation->set_rules('coordinacion','COORDINACIÓN','required');
			//$this->form_validation->set_rules('coordinacion_exp','TURNO','required');
			$this->form_validation->set_rules('sensibilidad','SENSIBILIDAD','required');
			//$this->form_validation->set_rules('sensibilidad_exp','TURNO','required');
			$this->form_validation->set_rules('cv_conformacion','CV CONFORMACIÓN','required');
			//$this->form_validation->set_rules('cv_conformacion_exp','TURNO','required');
			$this->form_validation->set_rules('equilibrio','EQUILIBRIO','required');
			//$this->form_validation->set_rules('equilibrio_exp','TURNO','required');
			$this->form_validation->set_rules('arcos_mov','ARCOS MOV.','required');
			//$this->form_validation->set_rules('arcos_mov_exp','TURNO','required');
			$this->form_validation->set_rules('marcha','MARCHA','required');
			//$this->form_validation->set_rules('marcha_exp','TURNO','required');
			$this->form_validation->set_rules('escoliosis','ESCOLIASIS','required');
			//$this->form_validation->set_rules('escoliosis_exp','TURNO','required');
			$this->form_validation->set_rules('lordosis','LORDOSIS','required');
			//$this->form_validation->set_rules('lordosis_exp','TURNO','required');
			$this->form_validation->set_rules('xifosis','XIFOSIS','required');
			//$this->form_validation->set_rules('xifosis_exp','TURNO','required');
			$this->form_validation->set_rules('mt_integridad_der','mt integridad derecha','required');
			$this->form_validation->set_rules('mt_integridad_izq','mt integridad izquierda','required');
			//$this->form_validation->set_rules('mt_integridad_exp','TURNO','required');
			$this->form_validation->set_rules('mp_integridad_der','mp integridad derecha','required');
			$this->form_validation->set_rules('mp_integridad_izq','mp integridad izquierda','required');
			//$this->form_validation->set_rules('mp_integridad_exp','TURNO','required');
			$this->form_validation->set_rules('mt_mobilidad_der','mt mobilidad derecha','required');
			$this->form_validation->set_rules('mt_mobilidad_izq','mt mobilidad izquierda','required');
			//$this->form_validation->set_rules('mt_mobilidad_exp','TURNO','required');
			$this->form_validation->set_rules('mp_mobilidad_der','mp mobilidad derecha','required');
			$this->form_validation->set_rules('mp_mobilidad_izq','mp mobilidad izquierda','required');
			//$this->form_validation->set_rules('mp_mobilidad_exp','TURNO','required');
			$this->form_validation->set_rules('mt_rot_der','mt rot derecha','required');
			$this->form_validation->set_rules('mt_rot_izq','mt rot izquirda','required');
			//$this->form_validation->set_rules('mt_rot_exp','TURNO','required');
			$this->form_validation->set_rules('mp_rot_der','mp rot derecha','required');
			$this->form_validation->set_rules('mp_rot_izq','mp rot izquierdo','required');
			//$this->form_validation->set_rules('mp_rot_exp','TURNO','required');
			$this->form_validation->set_rules('mt_sensibilidad_der','mt sensibilidad derecha','required');
			$this->form_validation->set_rules('mt_sensibilidad_izq','mt sensibilidad izquierda','required');
			//$this->form_validation->set_rules('mt_sensibilidad_exp','TURNO','required');
			$this->form_validation->set_rules('mp_sensibilidad_der','mp sensibilidad derecha','required');
			$this->form_validation->set_rules('mp_sensibilidad_izq','mp sensibilidad izquierda','required');
			//$this->form_validation->set_rules('mp_sensibilidad_exp','TURNO','required');
			$this->form_validation->set_rules('mt_fuerza_der','mt fuerza derecha','required');
			$this->form_validation->set_rules('mt_fuerza_izq','mt fuerza izquierda','required');
			//$this->form_validation->set_rules('mt_fuerza_exp','TURNO','required');
			$this->form_validation->set_rules('mp_fuerza_der','mp fuerza derecha','required');
			$this->form_validation->set_rules('mp_fuerza_izq','mp fuerza izquierda','required');
			//$this->form_validation->set_rules('mp_fuerza_exp','TURNO','required');
			$this->form_validation->set_rules('mt_pulsos_der','mt pulsos derecha','required');
			$this->form_validation->set_rules('mt_pulsos_izq','mt pulsos izquierda','required');
			//$this->form_validation->set_rules('mt_pulsos_exp','TURNO','required');
			$this->form_validation->set_rules('mp_pulsos_der','mp pulsos derecha','required');
			$this->form_validation->set_rules('mp_pulsos_izq','mp pulsos izquierda','required');
			//$this->form_validation->set_rules('mp_pulsos_exp','TURNO','required');
			$this->form_validation->set_rules('gineco1','GENITOURINARIO 1','required');
			$this->form_validation->set_rules('gineco1_res','GENITOURINARIO SITUACIÓN 1','required');
		//	$this->form_validation->set_rules('gineco1_exp','TURNO','required');
			$this->form_validation->set_rules('gineco2','GENITOURINARIO 2','required');
			$this->form_validation->set_rules('gineco2_res','GENITOURINARIO SITUACIÓN 2','required');
		//	$this->form_validation->set_rules('gineco2_exp','TURNO','required');
			$this->form_validation->set_rules('sangre','TIPO DE SANGRE','required');
			$this->form_validation->set_rules('fac_a_1','FAC A 1','required');
			$this->form_validation->set_rules('fac_a_2','FAC A 2','required');
			$this->form_validation->set_rules('fac_a_3','FAC A 3','required');
			$this->form_validation->set_rules('fac_a_4','FAC A 4','required');
			$this->form_validation->set_rules('fac_b_1','FAC B 1','required');
			$this->form_validation->set_rules('fac_b_2','FAC B 2','required');
			$this->form_validation->set_rules('fac_b_3','FAC B 3','required');
			$this->form_validation->set_rules('fac_b_4','FAC B 4','required');
			$this->form_validation->set_rules('fac_b_5','FAC B 5','required');
			$this->form_validation->set_rules('fac_b_6','FAC B 6','required');
			$this->form_validation->set_rules('fac_b_7','FAC B 7','required');
			$this->form_validation->set_rules('fac_b_8','FAC B 8','required');
			//$this->form_validation->set_rules('fac_total_a','TURNO','required');
			//$this->form_validation->set_rules('fac_total_b','TURNO','required');
			
			$this->form_validation->set_rules('diag_imc','DIAGNÓSTICO IMC','required');
			$this->form_validation->set_rules('diag_antidoping','DIAGNÓSTICO ANTIDOPING','required');
			$this->form_validation->set_rules('diag_agudesa_visual','DIAGNÓSTICO AGUDEZA VISUAL','required');
			$this->form_validation->set_rules('diag_audiometria','DIAGNÓSTICO AUDIOMETRÍA','required');
			$this->form_validation->set_rules('diag_odontologico','DIAGNÓSTICO ODONTOLÓGICO','required');
			$this->form_validation->set_rules('diag_espirometria','DIAGNÓSTICO ESPIROMETRÍA','required');
			$this->form_validation->set_rules('diag_aptitud','DIAGNÓSTICO APTITUD','required');
			
			//$this->form_validation->set_rules('observaciones','TURNO','required');
/*********************************************************/	
			//$this->form_validation->set_rules('cronicodegenerativas','ENF. CRÓNICODEGENERATIVAS','required');
			//$this->form_validation->set_rules('imc','IMC');
			//$this->form_validation->set_rules('agudeza_visual','AGUDEZA VISUAL','required');
			//$this->form_validation->set_rules('daltonismo','DALTONISMO','required');
			//$this->form_validation->set_rules('audicion','AUDICIÓN','required');
			//$this->form_validation->set_rules('musculo_exq','ENF. MUSCULO-ESQUELÉTICAS','required');
			//$this->form_validation->set_rules('toxicologico','TOXICOLÓGICO','required');
			//$this->form_validation->set_rules('observaciones','OBSERVACIONES','required');
			$this->form_validation->set_rules('medico','MEDICO QUE ATENDIO','required');			

            if($this->form_validation->run())
            {
				$data_insert['clte_id'] = $persona['clte_id'];
				$data_insert['fsm_edad']=intval(trim(str_replace("años", "",get_edad($persona['clte_f_nac']))));
				
				$data_insert['fsm_f_nac']=$persona['clte_f_nac'];
				$data_insert['fsm_genero']=$persona['clte_genero_cve'];
				$data_insert['emp_id'] = $persona['emp_id'];
				$data_insert['suc_id'] = $persona['suc_id'];               
                $data_insert['serv_id']  = '';
                $data_insert['usr_id']  = $user['usr_id'];
                $data_insert['fsm_f']   =  date("Y-m-d H:i:s");
				
				$data_insert['fsm_f_y']   =  date("Y");
				$data_insert['fsm_f_m']   =  date("m");
				$data_insert['fsm_f_d']   =  date("d");
				$data_insert['fsm_f_h']   =  date("H");
				$data_insert['fsm_f_i']   =  date("i");
								
				$data_insert['med_id'] = $this->input->post('medico');				
				$medico = $this->medico->get($data_insert['med_id']);				
				$data_insert['fsm_area'] = $this->input->post('area');
				$data_insert['fsm_turno'] = $this->input->post('turno');
				$data_insert['fsm_antiguedad'] = $this->input->post('antiguedad'); 

				$data_insert['fsm_accidente_av'] = $this->input->post('accidente_av');
				$data_insert['fsm_parentesco_av'] = $this->input->post('parentesco_av');
				$data_insert['fsm_telefono_av'] = $this->input->post('telefono_av');
				$data_insert['fsm_clinica_imss'] = $this->input->post('clinica_imss');
				$data_insert['fsm_no_consultorio'] = $this->input->post('no_consultorio');
				
				$data_insert['fsm_ante_no_pato'] = $this->input->post('ante_no_pato');
				$data_insert['fsm_ante_pato'] = $this->input->post('ante_pato');
				$data_insert['fsm_padec_actual'] = $this->input->post('padec_actual');
				$data_insert['fsm_ta1'] = $this->input->post('ta1');
				$data_insert['fsm_ta2'] = $this->input->post('ta2');
				$data_insert['fsm_sato2'] = $this->input->post('sato2');
				$data_insert['fsm_fc'] = $this->input->post('fc');
				$data_insert['fsm_fr'] = $this->input->post('fr');
				$data_insert['fsm_temp'] = $this->input->post('temp');
				$data_insert['fsm_estatura'] = $this->input->post('estatura');
				$data_insert['fsm_peso'] = $this->input->post('peso');
				$data_insert['fsm_imc'] = $this->input->post('imc');
				$data_insert['fsm_craneo'] = $this->input->post('craneo');
				$data_insert['fsm_craneo_exp'] = $this->input->post('craneo_exp');
				$data_insert['fsm_pupila_der'] = $this->input->post('pupila_der');
				$data_insert['fsm_pupila_izq'] = $this->input->post('pupila_izq');
				$data_insert['fsm_pupila_exp'] = $this->input->post('pupila_exp');
				$data_insert['fsm_cara'] = $this->input->post('cara');
				$data_insert['fsm_cara_exp'] = $this->input->post('cara_exp');
				$data_insert['fsm_cornea_der'] = $this->input->post('cornea_der');
				$data_insert['fsm_cornea_izq'] = $this->input->post('cornea_izq');
				$data_insert['fsm_cornea_exp'] = $this->input->post('cornea_exp');
				$data_insert['fsm_cuello'] = $this->input->post('cuello');
				$data_insert['fsm_cuello_exp'] = $this->input->post('cuello_exp');
				$data_insert['fsm_avisualsl_der'] = $this->input->post('avisualsl_der');
				$data_insert['fsm_avisualsl_izq'] = $this->input->post('avisualsl_izq');
				$data_insert['fsm_avisualsl_exp'] = $this->input->post('avisualsl_exp');
				$data_insert['fsm_avisualcl_der'] = $this->input->post('avisualcl_der');
				$data_insert['fsm_avisualcl_izq'] = $this->input->post('avisualcl_izq');
				$data_insert['fsm_avisualcl_exp'] = $this->input->post('avisualcl_exp');
				$data_insert['fsm_membrana_timpano_der'] = $this->input->post('membrana_timpano_der');
				$data_insert['fsm_membrana_timpano_izq'] = $this->input->post('membrana_timpano_izq');
				$data_insert['fsm_membrana_timpano_exp'] = $this->input->post('membrana_timpano_exp');
				$data_insert['fsm_identifica_colores_der'] = $this->input->post('identifica_colores_der');
				$data_insert['fsm_identifica_colores_izq'] = $this->input->post('identifica_colores_izq');
				$data_insert['fsm_identifica_colores_exp'] = $this->input->post('identifica_colores_exp');
				$data_insert['fsm_conducto_der'] = $this->input->post('conducto_der');
				$data_insert['fsm_conducto_izq'] = $this->input->post('conducto_izq');
				$data_insert['fsm_conducto_exp'] = $this->input->post('conducto_exp');
				$data_insert['fsm_movimiento_ocular_der'] = $this->input->post('movimiento_ocular_der');
				$data_insert['fsm_movimiento_ocular_izq'] = $this->input->post('movimiento_ocular_izq');
				$data_insert['fsm_movimiento_ocular_exp'] = $this->input->post('movimiento_ocular_exp');
				$data_insert['fsm_ojo_otros_exp'] = $this->input->post('ojo_otros_exp');
				$data_insert['fsm_ptregion_der'] = $this->input->post('ptregion_der');
				$data_insert['fsm_ptregion_izq'] = $this->input->post('ptregion_izq');
				$data_insert['fsm_ptregion_exp'] = $this->input->post('ptregion_exp');
				$data_insert['fsm_dermis'] = $this->input->post('dermis');
				$data_insert['fsm_dermis_exp'] = $this->input->post('dermis_exp');
				$data_insert['fsm_simetria'] = $this->input->post('simetria');
				$data_insert['fsm_simetria_exp'] = $this->input->post('simetria_exp');
				$data_insert['fsm_cabello'] = $this->input->post('cabello');
				$data_insert['fsm_cabello_exp'] = $this->input->post('cabello_exp');
				$data_insert['fsm_amplexion'] = $this->input->post('amplexion');
				$data_insert['fsm_amplexion_exp'] = $this->input->post('amplexion_exp');
				$data_insert['fsm_unias'] = $this->input->post('unias');
				$data_insert['fsm_unias_exp'] = $this->input->post('unias_exp');
				$data_insert['fsm_murmullo'] = $this->input->post('murmullo');
				$data_insert['fsm_murmullo_exp'] = $this->input->post('murmullo_exp');
				$data_insert['fsm_ritmo'] = $this->input->post('ritmo');
				$data_insert['fsm_ritmo_exp'] = $this->input->post('ritmo_exp');
				$data_insert['fsm_conformacion'] = $this->input->post('conformacion');
				$data_insert['fsm_intensidad'] = $this->input->post('intensidad');
				$data_insert['fsm_intensidad_exp'] = $this->input->post('intensidad_exp');
				$data_insert['fsm_peritasis'] = $this->input->post('peritasis');
				$data_insert['fsm_peritasis_exp'] = $this->input->post('peritasis_exp');
				$data_insert['fsm_ruidos'] = $this->input->post('ruidos');
				$data_insert['fsm_ruidos_exp'] = $this->input->post('ruidos_exp');
				$data_insert['fsm_visceromegalias'] = $this->input->post('visceromegalias');
				$data_insert['fsm_visceromegalias_exp'] = $this->input->post('visceromegalias_exp');
				$data_insert['fsm_soplos'] = $this->input->post('soplos');
				$data_insert['fsm_soplos_exp'] = $this->input->post('soplos_exp');
				$data_insert['fsm_hernias'] = $this->input->post('hernias');
				$data_insert['fsm_hernias_exp'] = $this->input->post('hernias_exp');
				$data_insert['fsm_abdomen_otros_exp'] = $this->input->post('abdomen_otros_exp');
				$data_insert['fsm_coordinacion'] = $this->input->post('coordinacion');
				$data_insert['fsm_coordinacion_exp'] = $this->input->post('coordinacion_exp');
				$data_insert['fsm_sensibilidad'] = $this->input->post('sensibilidad');
				$data_insert['fsm_sensibilidad_exp'] = $this->input->post('sensibilidad_exp');
				$data_insert['fsm_cv_conformacion'] = $this->input->post('cv_conformacion');
				$data_insert['fsm_cv_conformacion_exp'] = $this->input->post('cv_conformacion_exp');
				$data_insert['fsm_equilibrio'] = $this->input->post('equilibrio');
				$data_insert['fsm_equilibrio_exp'] = $this->input->post('equilibrio_exp');
				$data_insert['fsm_arcos_mov'] = $this->input->post('arcos_mov');
				$data_insert['fsm_arcos_mov_exp'] = $this->input->post('arcos_mov_exp');
				$data_insert['fsm_marcha'] = $this->input->post('marcha');
				$data_insert['fsm_marcha_exp'] = $this->input->post('marcha_exp');
				$data_insert['fsm_escoliosis'] = $this->input->post('escoliosis');
				$data_insert['fsm_escoliosis_exp'] = $this->input->post('escoliosis_exp');
				$data_insert['fsm_lordosis'] = $this->input->post('lordosis');
				$data_insert['fsm_lordosis_exp'] = $this->input->post('lordosis_exp');
				$data_insert['fsm_xifosis'] = $this->input->post('xifosis');
				$data_insert['fsm_xifosis_exp'] = $this->input->post('xifosis_exp');
				$data_insert['fsm_mt_integridad_der'] = $this->input->post('mt_integridad_der');
				$data_insert['fsm_mt_integridad_izq'] = $this->input->post('mt_integridad_izq');
				$data_insert['fsm_mt_integridad_exp'] = $this->input->post('mt_integridad_exp');
				$data_insert['fsm_mp_integridad_der'] = $this->input->post('mp_integridad_der');
				$data_insert['fsm_mp_integridad_izq'] = $this->input->post('mp_integridad_izq');
				$data_insert['fsm_mp_integridad_exp'] = $this->input->post('mp_integridad_exp');
				$data_insert['fsm_mt_mobilidad_der'] = $this->input->post('mt_mobilidad_der');
				$data_insert['fsm_mt_mobilidad_izq'] = $this->input->post('mt_mobilidad_izq');
				$data_insert['fsm_mt_mobilidad_exp'] = $this->input->post('mt_mobilidad_exp');
				$data_insert['fsm_mp_mobilidad_der'] = $this->input->post('mp_mobilidad_der');
				$data_insert['fsm_mp_mobilidad_izq'] = $this->input->post('mp_mobilidad_izq');
				$data_insert['fsm_mp_mobilidad_exp'] = $this->input->post('mp_mobilidad_exp');
				$data_insert['fsm_mt_rot_der'] = $this->input->post('mt_rot_der');
				$data_insert['fsm_mt_rot_izq'] = $this->input->post('mt_rot_izq');
				$data_insert['fsm_mt_rot_exp'] = $this->input->post('mt_rot_exp');
				$data_insert['fsm_mp_rot_der'] = $this->input->post('mp_rot_der');
				$data_insert['fsm_mp_rot_izq'] = $this->input->post('mp_rot_izq');
				$data_insert['fsm_mp_rot_exp'] = $this->input->post('mp_rot_exp');
				$data_insert['fsm_mt_sensibilidad_der'] = $this->input->post('mt_sensibilidad_der');
				$data_insert['fsm_mt_sensibilidad_izq'] = $this->input->post('mt_sensibilidad_izq');
				$data_insert['fsm_mt_sensibilidad_exp'] = $this->input->post('mt_sensibilidad_exp');
				$data_insert['fsm_mp_sensibilidad_der'] = $this->input->post('mp_sensibilidad_der');
				$data_insert['fsm_mp_sensibilidad_izq'] = $this->input->post('mp_sensibilidad_izq');
				$data_insert['fsm_mp_sensibilidad_exp'] = $this->input->post('mp_sensibilidad_exp');
				$data_insert['fsm_mt_fuerza_der'] = $this->input->post('mt_fuerza_der');
				$data_insert['fsm_mt_fuerza_izq'] = $this->input->post('mt_fuerza_izq');
				$data_insert['fsm_mt_fuerza_exp'] = $this->input->post('mt_fuerza_exp');
				$data_insert['fsm_mp_fuerza_der'] = $this->input->post('mp_fuerza_der');
				$data_insert['fsm_mp_fuerza_izq'] = $this->input->post('mp_fuerza_izq');
				$data_insert['fsm_mp_fuerza_exp'] = $this->input->post('mp_fuerza_exp');
				$data_insert['fsm_mt_pulsos_der'] = $this->input->post('mt_pulsos_der');
				$data_insert['fsm_mt_pulsos_izq'] = $this->input->post('mt_pulsos_izq');
				$data_insert['fsm_mt_pulsos_exp'] = $this->input->post('mt_pulsos_exp');
				$data_insert['fsm_mp_pulsos_der'] = $this->input->post('mp_pulsos_der');
				$data_insert['fsm_mp_pulsos_izq'] = $this->input->post('mp_pulsos_izq');
				$data_insert['fsm_mp_pulsos_exp'] = $this->input->post('mp_pulsos_exp');
				$data_insert['fsm_gineco1'] = $this->input->post('gineco1');
				$data_insert['fsm_gineco1_res'] = $this->input->post('gineco1_res');
				$data_insert['fsm_gineco1_exp'] = $this->input->post('gineco1_exp');
				$data_insert['fsm_gineco2'] = $this->input->post('gineco2');
				$data_insert['fsm_gineco2_res'] = $this->input->post('gineco2_res');
				$data_insert['fsm_gineco2_exp'] = $this->input->post('gineco2_exp');
				$data_insert['fsm_sangre'] = $this->input->post('sangre');
				$data_insert['fsm_fac_a_1'] = $this->input->post('fac_a_1');
				$data_insert['fsm_fac_a_2'] = $this->input->post('fac_a_2');
				$data_insert['fsm_fac_a_3'] = $this->input->post('fac_a_3');
				$data_insert['fsm_fac_a_4'] = $this->input->post('fac_a_4');
				$data_insert['fsm_fac_b_1'] = $this->input->post('fac_b_1');
				$data_insert['fsm_fac_b_2'] = $this->input->post('fac_b_2');
				$data_insert['fsm_fac_b_3'] = $this->input->post('fac_b_3');
				$data_insert['fsm_fac_b_4'] = $this->input->post('fac_b_4');
				$data_insert['fsm_fac_b_5'] = $this->input->post('fac_b_5');
				$data_insert['fsm_fac_b_6'] = $this->input->post('fac_b_6');
				$data_insert['fsm_fac_b_7'] = $this->input->post('fac_b_7');
				$data_insert['fsm_fac_b_8'] = $this->input->post('fac_b_8');
				$data_insert['fsm_fac_total_a'] = $this->input->post('fac_total_a');
				$data_insert['fsm_fac_total_b'] = $this->input->post('fac_total_b');
				
				$data_insert['fsm_diag_imc'] = $this->input->post('diag_imc');
				$data_insert['fsm_diag_antidoping'] = $this->input->post('diag_antidoping');
				$data_insert['fsm_diag_agudesa_visual'] = $this->input->post('diag_agudesa_visual');
				$data_insert['fsm_diag_audiometria'] = $this->input->post('diag_audiometria');
				$data_insert['fsm_diag_odontologico'] = $this->input->post('diag_odontologico');
				$data_insert['fsm_diag_espirometria'] = $this->input->post('diag_espirometria');
				
				$data_insert['fsm_diag_aptitud'] = $this->input->post('diag_aptitud');
				
				$data_insert['fsm_observaciones'] = $this->input->post('observaciones');

				if ($medico['usr_genero_cve'] == 'H') {$gen= 'Dr. ';} else {$gen= 'Dra. ';}
				$data_insert['fsm_med_nombre'] = $gen.$medico['usr_nombre'].' '.$medico['usr_paterno'].' '.$medico['usr_materno'];
				$data_insert['fsm_med_cedula'] =$medico['usr_cedula'];
				$data_insert['fsm_med_carrera'] =$medico['usr_carrera'];
				$data_insert['fsm_med_escuela'] =$medico['usr_institucion'];
				
				$data_insert['log_insrt_f']   =  date("Y-m-d H:i:s");
				$data_insert['log_insrt_usr_cve']  = $user['usr_id'];
				$data_insert['log_updt_f']   =  date("Y-m-d H:i:s");
				$data_insert['log_updt_usr_cve']  = $user['usr_id']; 
				$ISOEXMP=$this->salud_ocupacional->insert_ISOEXMP(array_to_upper($data_insert));
				if ($ISOEXMP)
                {		
					$data_insert_ISOEXP['clte_id'] = $persona['clte_id'];
					$data_insert_ISOEXP['fsm_edad']=intval(trim(str_replace("años", "",get_edad($persona['clte_f_nac']))));
				
					$data_insert_ISOEXP['fsm_f_nac']=$persona['clte_f_nac'];
					$data_insert_ISOEXP['fsm_genero']=$persona['clte_genero_cve'];
					$data_insert_ISOEXP['emp_id'] = $persona['emp_id'];
					$data_insert_ISOEXP['suc_id'] = $persona['suc_id'];               
					$data_insert_ISOEXP['serv_id']  = '';
					$data_insert_ISOEXP['usr_id']  = $user['usr_id'];
					$data_insert_ISOEXP['fsm_f']   =  date("Y-m-d H:i:s");
				
					$data_insert_ISOEXP['fsm_f_y']   =  date("Y");
					$data_insert_ISOEXP['fsm_f_m']   =  date("m");
					$data_insert_ISOEXP['fsm_f_d']   =  date("d");
					$data_insert_ISOEXP['fsm_f_h']   =  date("H");
					$data_insert_ISOEXP['fsm_f_i']   =  date("i");
								
					$data_insert_ISOEXP['med_id'] = $this->input->post('medico');				
					$medico = $this->medico->get($data_insert_ISOEXP['med_id']);				
					$data_insert_ISOEXP['fsm_area'] = $this->input->post('area');
					$data_insert_ISOEXP['fsm_turno'] = $this->input->post('turno');
					$data_insert_ISOEXP['fsm_antiguedad'] = $this->input->post('antiguedad');
					$data_insert_ISOEXP['fsm_imc'] = $this->input->post('diag_imc');
					 
					$data_insert_ISOEXP['fsm_toxicologico'] = $this->input->post('diag_antidoping');
					$data_insert_ISOEXP['fsm_agudeza_visual'] = $this->input->post('diag_agudesa_visual');
					$data_insert_ISOEXP['fsm_aptitud'] = $this->input->post('diag_aptitud');
					$data_insert_ISOEXP['fsm_audicion'] = $this->input->post('diag_audiometria');
					
					$data_insert_ISOEXP['fsm_odontologico'] = $this->input->post('diag_odontologico');
					$data_insert_ISOEXP['fsm_espirometria'] = $this->input->post('diag_espirometria');
					$data_insert_ISOEXP['fsm_isoexmp'] = $ISOEXMP;



					//$data_insert_ISOEXP['fsm_cronicodegenerativas'] = $this->input->post('cronicodegenerativas');
					//$data_insert_ISOEXP['fsm_daltonismo'] = $this->input->post('daltonismo');
					//$data_insert_ISOEXP['fsm_musculo_exq'] = $this->input->post('musculo_exq');
					
					
				/*
				$data_insert['fsm_diag_imc'] = $this->input->post('diag_imc');
				$data_insert['fsm_diag_antidoping'] = $this->input->post('diag_antidoping');
				$data_insert['fsm_diag_agudesa_visual'] = $this->input->post('diag_agudesa_visual');
				$data_insert['fsm_diag_aptitud'] = $this->input->post('diag_aptitud');
				$data_insert['fsm_diag_audiometria'] = $this->input->post('diag_audiometria');
			
				
				$data_insert['fsm_diag_odontologico'] = $this->input->post('diag_odontologico');
				$data_insert['fsm_diag_espirometria'] = $this->input->post('diag_espirometria');
				
				
				
				*/
					$data_insert_ISOEXP['fsm_observaciones'] = $this->input->post('observaciones');				

					$data_insert_ISOEXP['fsm_med_nombre'] = $medico['usr_nombre'].' '.$medico['usr_paterno'].' '.$medico['usr_materno'];
					$data_insert_ISOEXP['fsm_med_cedula'] =$medico['usr_cedula'];
					$data_insert_ISOEXP['fsm_med_carrera'] =$medico['usr_carrera'];
					$data_insert_ISOEXP['fsm_med_escuela'] =$medico['usr_institucion'];
				
					$data_insert_ISOEXP['log_insrt_f']   =  date("Y-m-d H:i:s");
					$data_insert_ISOEXP['log_insrt_usr_cve']  = $user['usr_id'];
					$data_insert_ISOEXP['log_updt_f']   =  date("Y-m-d H:i:s");
					$data_insert_ISOEXP['log_updt_usr_cve']  = $user['usr_id']; 
			
					$this->salud_ocupacional->insert_ISOEXP(array_to_upper($data_insert_ISOEXP));

					$data_clte['clte_accidente_av'] =  $this->input->post('accidente_av'); 					
					$data_clte['clte_parentesco_av'] =  $this->input->post('parentesco_av'); 					
					$data_clte['clte_telefono_av'] =  $this->input->post('telefono_av');					
					$data_clte['clte_clinica_imss'] =  $this->input->post('clinica_imss'); 					
					$data_clte['clte_no_consultorio'] =  $this->input->post('no_consultorio');					
					$data_clte['clte_f_consulta'] =  date("Y-m-d");
					$this->cliente->actualiza($cliente_id, array_to_upper($data_clte));
                    
					send_json_ok('Se registro de forma correcta.');
                }
                else
                {
                    send_json_error('Ocurrió un error al registrar.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
			
            $data['persona'] = $persona;
            $this->load->helper('template');
            $params_view = array(
                'title' => '',
                'view' => 'examen/salud_ocupacional/nuevo_form_ISOEXMP',
                'view_data' => $data 
               );
            render_template($params_view);
        }
    }


	public function editar_ISOEXMP($cliente_id, $fsm_id)
    {
        $persona = $this->cliente->get($cliente_id);
		$data['fsm'] = $this->salud_ocupacional->get_ISOEXMP($fsm_id);		
        $user = $this->session->user;

        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');

            if(true)
            {
			/*	$data_insert['clte_id'] = $persona['clte_id'];
				$data_insert['fsm_edad']=intval(trim(str_replace("años", "",get_edad($persona['clte_f_nac']))));
				
				$data_insert['fsm_f_nac']=$persona['clte_f_nac'];
				$data_insert['fsm_genero']=$persona['clte_genero_cve'];
				$data_insert['emp_id'] = $persona['emp_id'];
				$data_insert['suc_id'] = $persona['suc_id'];               
                $data_insert['serv_id']  = '';
                $data_insert['usr_id']  = $user['usr_id'];
                $data_insert['fsm_f']   =  date("Y-m-d H:i:s");
				
				$data_insert['fsm_f_y']   =  date("Y");
				$data_insert['fsm_f_m']   =  date("m");
				$data_insert['fsm_f_d']   =  date("d");
				$data_insert['fsm_f_h']   =  date("H");
				$data_insert['fsm_f_i']   =  date("i");
			*/					
				$data_insert['med_id'] = $this->input->post('medico');				
				$medico = $this->medico->get($data_insert['med_id']);				
				$data_insert['fsm_area'] = $this->input->post('area');
				$data_insert['fsm_turno'] = $this->input->post('turno');
				$data_insert['fsm_antiguedad'] = $this->input->post('antiguedad'); 
				
				
				$data_insert['fsm_ante_no_pato'] = $this->input->post('ante_no_pato');
				$data_insert['fsm_ante_pato'] = $this->input->post('ante_pato');
				$data_insert['fsm_padec_actual'] = $this->input->post('padec_actual');
				$data_insert['fsm_ta1'] = $this->input->post('ta1');
				$data_insert['fsm_ta2'] = $this->input->post('ta2');
				$data_insert['fsm_sato2'] = $this->input->post('sato2');
				$data_insert['fsm_fc'] = $this->input->post('fc');
				$data_insert['fsm_fr'] = $this->input->post('fr');
				$data_insert['fsm_temp'] = $this->input->post('temp');
				$data_insert['fsm_estatura'] = $this->input->post('estatura');
				$data_insert['fsm_peso'] = $this->input->post('peso');
				$data_insert['fsm_imc'] = $this->input->post('imc');
				$data_insert['fsm_craneo'] = $this->input->post('craneo');
				$data_insert['fsm_craneo_exp'] = $this->input->post('craneo_exp');
				$data_insert['fsm_pupila_der'] = $this->input->post('pupila_der');
				$data_insert['fsm_pupila_izq'] = $this->input->post('pupila_izq');
				$data_insert['fsm_pupila_exp'] = $this->input->post('pupila_exp');
				$data_insert['fsm_cara'] = $this->input->post('cara');
				$data_insert['fsm_cara_exp'] = $this->input->post('cara_exp');
				$data_insert['fsm_cornea_der'] = $this->input->post('cornea_der');
				$data_insert['fsm_cornea_izq'] = $this->input->post('cornea_izq');
				$data_insert['fsm_cornea_exp'] = $this->input->post('cornea_exp');
				$data_insert['fsm_cuello'] = $this->input->post('cuello');
				$data_insert['fsm_cuello_exp'] = $this->input->post('cuello_exp');
				$data_insert['fsm_avisualsl_der'] = $this->input->post('avisualsl_der');
				$data_insert['fsm_avisualsl_izq'] = $this->input->post('avisualsl_izq');
				$data_insert['fsm_avisualsl_exp'] = $this->input->post('avisualsl_exp');
				$data_insert['fsm_avisualcl_der'] = $this->input->post('avisualcl_der');
				$data_insert['fsm_avisualcl_izq'] = $this->input->post('avisualcl_izq');
				$data_insert['fsm_avisualcl_exp'] = $this->input->post('avisualcl_exp');
				$data_insert['fsm_membrana_timpano_der'] = $this->input->post('membrana_timpano_der');
				$data_insert['fsm_membrana_timpano_izq'] = $this->input->post('membrana_timpano_izq');
				$data_insert['fsm_membrana_timpano_exp'] = $this->input->post('membrana_timpano_exp');
				$data_insert['fsm_identifica_colores_der'] = $this->input->post('identifica_colores_der');
				$data_insert['fsm_identifica_colores_izq'] = $this->input->post('identifica_colores_izq');
				$data_insert['fsm_identifica_colores_exp'] = $this->input->post('identifica_colores_exp');
				$data_insert['fsm_conducto_der'] = $this->input->post('conducto_der');
				$data_insert['fsm_conducto_izq'] = $this->input->post('conducto_izq');
				$data_insert['fsm_conducto_exp'] = $this->input->post('conducto_exp');
				$data_insert['fsm_movimiento_ocular_der'] = $this->input->post('movimiento_ocular_der');
				$data_insert['fsm_movimiento_ocular_izq'] = $this->input->post('movimiento_ocular_izq');
				$data_insert['fsm_movimiento_ocular_exp'] = $this->input->post('movimiento_ocular_exp');
				$data_insert['fsm_ojo_otros_exp'] = $this->input->post('ojo_otros_exp');
				$data_insert['fsm_ptregion_der'] = $this->input->post('ptregion_der');
				$data_insert['fsm_ptregion_izq'] = $this->input->post('ptregion_izq');
				$data_insert['fsm_ptregion_exp'] = $this->input->post('ptregion_exp');
				$data_insert['fsm_dermis'] = $this->input->post('dermis');
				$data_insert['fsm_dermis_exp'] = $this->input->post('dermis_exp');
				$data_insert['fsm_simetria'] = $this->input->post('simetria');
				$data_insert['fsm_simetria_exp'] = $this->input->post('simetria_exp');
				$data_insert['fsm_cabello'] = $this->input->post('cabello');
				$data_insert['fsm_cabello_exp'] = $this->input->post('cabello_exp');
				$data_insert['fsm_amplexion'] = $this->input->post('amplexion');
				$data_insert['fsm_amplexion_exp'] = $this->input->post('amplexion_exp');
				$data_insert['fsm_unias'] = $this->input->post('unias');
				$data_insert['fsm_unias_exp'] = $this->input->post('unias_exp');
				$data_insert['fsm_murmullo'] = $this->input->post('murmullo');
				$data_insert['fsm_murmullo_exp'] = $this->input->post('murmullo_exp');
				$data_insert['fsm_ritmo'] = $this->input->post('ritmo');
				$data_insert['fsm_ritmo_exp'] = $this->input->post('ritmo_exp');
				$data_insert['fsm_conformacion'] = $this->input->post('conformacion');
				$data_insert['fsm_intensidad'] = $this->input->post('intensidad');
				$data_insert['fsm_intensidad_exp'] = $this->input->post('intensidad_exp');
				$data_insert['fsm_peritasis'] = $this->input->post('peritasis');
				$data_insert['fsm_peritasis_exp'] = $this->input->post('peritasis_exp');
				$data_insert['fsm_ruidos'] = $this->input->post('ruidos');
				$data_insert['fsm_ruidos_exp'] = $this->input->post('ruidos_exp');
				$data_insert['fsm_visceromegalias'] = $this->input->post('visceromegalias');
				$data_insert['fsm_visceromegalias_exp'] = $this->input->post('visceromegalias_exp');
				$data_insert['fsm_soplos'] = $this->input->post('soplos');
				$data_insert['fsm_soplos_exp'] = $this->input->post('soplos_exp');
				$data_insert['fsm_hernias'] = $this->input->post('hernias');
				$data_insert['fsm_hernias_exp'] = $this->input->post('hernias_exp');
				$data_insert['fsm_abdomen_otros_exp'] = $this->input->post('abdomen_otros_exp');
				$data_insert['fsm_coordinacion'] = $this->input->post('coordinacion');
				$data_insert['fsm_coordinacion_exp'] = $this->input->post('coordinacion_exp');
				$data_insert['fsm_sensibilidad'] = $this->input->post('sensibilidad');
				$data_insert['fsm_sensibilidad_exp'] = $this->input->post('sensibilidad_exp');
				$data_insert['fsm_cv_conformacion'] = $this->input->post('cv_conformacion');
				$data_insert['fsm_cv_conformacion_exp'] = $this->input->post('cv_conformacion_exp');
				$data_insert['fsm_equilibrio'] = $this->input->post('equilibrio');
				$data_insert['fsm_equilibrio_exp'] = $this->input->post('equilibrio_exp');
				$data_insert['fsm_arcos_mov'] = $this->input->post('arcos_mov');
				$data_insert['fsm_arcos_mov_exp'] = $this->input->post('arcos_mov_exp');
				$data_insert['fsm_marcha'] = $this->input->post('marcha');
				$data_insert['fsm_marcha_exp'] = $this->input->post('marcha_exp');
				$data_insert['fsm_escoliosis'] = $this->input->post('escoliosis');
				$data_insert['fsm_escoliosis_exp'] = $this->input->post('escoliosis_exp');
				$data_insert['fsm_lordosis'] = $this->input->post('lordosis');
				$data_insert['fsm_lordosis_exp'] = $this->input->post('lordosis_exp');
				$data_insert['fsm_xifosis'] = $this->input->post('xifosis');
				$data_insert['fsm_xifosis_exp'] = $this->input->post('xifosis_exp');
				$data_insert['fsm_mt_integridad_der'] = $this->input->post('mt_integridad_der');
				$data_insert['fsm_mt_integridad_izq'] = $this->input->post('mt_integridad_izq');
				$data_insert['fsm_mt_integridad_exp'] = $this->input->post('mt_integridad_exp');
				$data_insert['fsm_mp_integridad_der'] = $this->input->post('mp_integridad_der');
				$data_insert['fsm_mp_integridad_izq'] = $this->input->post('mp_integridad_izq');
				$data_insert['fsm_mp_integridad_exp'] = $this->input->post('mp_integridad_exp');
				$data_insert['fsm_mt_mobilidad_der'] = $this->input->post('mt_mobilidad_der');
				$data_insert['fsm_mt_mobilidad_izq'] = $this->input->post('mt_mobilidad_izq');
				$data_insert['fsm_mt_mobilidad_exp'] = $this->input->post('mt_mobilidad_exp');
				$data_insert['fsm_mp_mobilidad_der'] = $this->input->post('mp_mobilidad_der');
				$data_insert['fsm_mp_mobilidad_izq'] = $this->input->post('mp_mobilidad_izq');
				$data_insert['fsm_mp_mobilidad_exp'] = $this->input->post('mp_mobilidad_exp');
				$data_insert['fsm_mt_rot_der'] = $this->input->post('mt_rot_der');
				$data_insert['fsm_mt_rot_izq'] = $this->input->post('mt_rot_izq');
				$data_insert['fsm_mt_rot_exp'] = $this->input->post('mt_rot_exp');
				$data_insert['fsm_mp_rot_der'] = $this->input->post('mp_rot_der');
				$data_insert['fsm_mp_rot_izq'] = $this->input->post('mp_rot_izq');
				$data_insert['fsm_mp_rot_exp'] = $this->input->post('mp_rot_exp');
				$data_insert['fsm_mt_sensibilidad_der'] = $this->input->post('mt_sensibilidad_der');
				$data_insert['fsm_mt_sensibilidad_izq'] = $this->input->post('mt_sensibilidad_izq');
				$data_insert['fsm_mt_sensibilidad_exp'] = $this->input->post('mt_sensibilidad_exp');
				$data_insert['fsm_mp_sensibilidad_der'] = $this->input->post('mp_sensibilidad_der');
				$data_insert['fsm_mp_sensibilidad_izq'] = $this->input->post('mp_sensibilidad_izq');
				$data_insert['fsm_mp_sensibilidad_exp'] = $this->input->post('mp_sensibilidad_exp');
				$data_insert['fsm_mt_fuerza_der'] = $this->input->post('mt_fuerza_der');
				$data_insert['fsm_mt_fuerza_izq'] = $this->input->post('mt_fuerza_izq');
				$data_insert['fsm_mt_fuerza_exp'] = $this->input->post('mt_fuerza_exp');
				$data_insert['fsm_mp_fuerza_der'] = $this->input->post('mp_fuerza_der');
				$data_insert['fsm_mp_fuerza_izq'] = $this->input->post('mp_fuerza_izq');
				$data_insert['fsm_mp_fuerza_exp'] = $this->input->post('mp_fuerza_exp');
				$data_insert['fsm_mt_pulsos_der'] = $this->input->post('mt_pulsos_der');
				$data_insert['fsm_mt_pulsos_izq'] = $this->input->post('mt_pulsos_izq');
				$data_insert['fsm_mt_pulsos_exp'] = $this->input->post('mt_pulsos_exp');
				$data_insert['fsm_mp_pulsos_der'] = $this->input->post('mp_pulsos_der');
				$data_insert['fsm_mp_pulsos_izq'] = $this->input->post('mp_pulsos_izq');
				$data_insert['fsm_mp_pulsos_exp'] = $this->input->post('mp_pulsos_exp');
				$data_insert['fsm_gineco1'] = $this->input->post('gineco1');
				$data_insert['fsm_gineco1_res'] = $this->input->post('gineco1_res');
				$data_insert['fsm_gineco1_exp'] = $this->input->post('gineco1_exp');
				$data_insert['fsm_gineco2'] = $this->input->post('gineco2');
				$data_insert['fsm_gineco2_res'] = $this->input->post('gineco2_res');
				$data_insert['fsm_gineco2_exp'] = $this->input->post('gineco2_exp');
				$data_insert['fsm_sangre'] = $this->input->post('sangre');
				$data_insert['fsm_fac_a_1'] = $this->input->post('fac_a_1');
				$data_insert['fsm_fac_a_2'] = $this->input->post('fac_a_2');
				$data_insert['fsm_fac_a_3'] = $this->input->post('fac_a_3');
				$data_insert['fsm_fac_a_4'] = $this->input->post('fac_a_4');
				$data_insert['fsm_fac_b_1'] = $this->input->post('fac_b_1');
				$data_insert['fsm_fac_b_2'] = $this->input->post('fac_b_2');
				$data_insert['fsm_fac_b_3'] = $this->input->post('fac_b_3');
				$data_insert['fsm_fac_b_4'] = $this->input->post('fac_b_4');
				$data_insert['fsm_fac_b_5'] = $this->input->post('fac_b_5');
				$data_insert['fsm_fac_b_6'] = $this->input->post('fac_b_6');
				$data_insert['fsm_fac_b_7'] = $this->input->post('fac_b_7');
				$data_insert['fsm_fac_b_8'] = $this->input->post('fac_b_8');
				$data_insert['fsm_fac_total_a'] = $this->input->post('fac_total_a');
				$data_insert['fsm_fac_total_b'] = $this->input->post('fac_total_b');
				
				$data_insert['fsm_diag_imc'] = $this->input->post('diag_imc');
				$data_insert['fsm_diag_antidoping'] = $this->input->post('diag_antidoping');
				$data_insert['fsm_diag_agudesa_visual'] = $this->input->post('diag_agudesa_visual');
				$data_insert['fsm_diag_aptitud'] = $this->input->post('diag_aptitud');
				$data_insert['fsm_diag_aptitud'] = $this->input->post('diag_audiometria');
				$data_insert['fsm_diag_odontologico'] = $this->input->post('diag_odontologico');
				$data_insert['fsm_diag_espirometria'] = $this->input->post('diag_espirometria');
				$data_insert['fsm_observaciones'] = $this->input->post('observaciones');				
			
				if ($medico['usr_genero_cve'] == 'H') {$gen= 'Dr. ';} else {$gen= 'Dra. ';}
				$data_insert['fsm_med_nombre'] = $gen.$medico['usr_nombre'].' '.$medico['usr_paterno'].' '.$medico['usr_materno'];
				$data_insert['fsm_med_cedula'] =$medico['usr_cedula'];
				$data_insert['fsm_med_carrera'] =$medico['usr_carrera'];
				$data_insert['fsm_med_escuela'] =$medico['usr_institucion'];
				
				$data_insert['log_updt_f']   =  date("Y-m-d H:i:s");
				$data_insert['log_updt_usr_cve']  = $user['usr_id']; 
				$data_insert=array_to_upper($data_insert);
				if ($this->salud_ocupacional->update_ISOEXMP($fsm_id,$data_insert))
                {					
                    send_json_ok('Se actualizo el registro en forma correcta.');
                }
                else
                {
                    send_json_error('Ocurrió un error al actualizar el registro.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
            $this->load->helper('template');
            $params_view = array(
                'title' => '',
                'view' => 'examen/salud_ocupacional/edit_ISOEXMP',
                'view_data' => $data 
               );
            render_template($params_view);
        }
    }

	
   public function borra_ISOEXMP($fsm_id)
    {
        if($this->salud_ocupacional->borra_ISOEXMP($fsm_id))
        {
            send_json_ok('Se eliminó de forma correcta el registro.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar el registro.');
        }
    }

    public function pdf_ISOEXMP($cliente_id, $fsm_id)
    {
		$user = $this->session->user;
		
        $data['persona'] = $this->cliente->get($cliente_id,get_desp_id_usr());
        $data['fsm'] = $this->salud_ocupacional->get_ISOEXMP($fsm_id);
        $data['medico'] = $this->medico->get_id($data['fsm']['med_id']);
        $data['empresa'] = $this->cliente->get_empresa_by_id($data['fsm']['emp_id']);
        $reporte=$user['usr_id'].'_'.$data['fsm']['emp_id'].'_'.date("Ymd_His");
		$this->load->helper('pdf');
		$ruta=base_url('../dist/images/hclogo.jpg');
		genera_pdf_lab_new_g($this->load->view('examen/salud_ocupacional/pdf_ISOEXMP',$data,TRUE),$reporte,$user['usr_id'],'fsm773','Humancenter Review S.A de C.V.','P',$ruta);

	}

	
/*************************************************************/

/*************************************************************/
	public function nuevo_ISOCP($cliente_id)
    {
		
		$persona = $this->cliente->get($cliente_id);
        $user = $this->session->user;
        //$this->session->user;
       
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');			
			//$this->form_validation->set_rules('antiguedad','ANTIGUEDAD LABORAL','required');
			$this->form_validation->set_rules('area','AREA','required');
			$this->form_validation->set_rules('turno','TURNO','required');
			
			$this->form_validation->set_rules('atencion','TIPO DE ATENCIÓN','required');
			$this->form_validation->set_rules('f_fum','FUM','required');
			$this->form_validation->set_rules('f_fpp','FPP','required');
			$this->form_validation->set_rules('sdg','SDG','required');
			$this->form_validation->set_rules('riesgo_gest','RIESGO GESTACIONAL','required');
			$this->form_validation->set_rules('cambio_area','CAMBIO DE ÁREA','required');
			$this->form_validation->set_rules('rec_rest','RECOMENDACIONES Y/O RESTRICCIONES','required');

			$this->form_validation->set_rules('medico','MEDICO QUE ATENDIO','required');			

            if($this->form_validation->run())
            {
				$data_insert['clte_id'] = $persona['clte_id'];
				$data_insert['fsm_edad']=intval(trim(str_replace("años", "",get_edad($persona['clte_f_nac']))));
				
				$data_insert['fsm_f_nac']=$persona['clte_f_nac'];
				$data_insert['fsm_genero']=$persona['clte_genero_cve'];
				$data_insert['emp_id'] = $persona['emp_id'];
				$data_insert['suc_id'] = $persona['suc_id'];               
                $data_insert['serv_id']  = '';
                $data_insert['usr_id']  = $user['usr_id'];
                $data_insert['fsm_f']   =  date("Y-m-d H:i:s");
				
				$data_insert['fsm_f_y']   =  date("Y");
				$data_insert['fsm_f_m']   =  date("m");
				$data_insert['fsm_f_d']   =  date("d");
				$data_insert['fsm_f_h']   =  date("H");
				$data_insert['fsm_f_i']   =  date("i");
								
				$data_insert['med_id'] = $this->input->post('medico');
				
				$medico = $this->medico->get($data_insert['med_id']);				
				
				$data_insert['fsm_area'] = $this->input->post('area');
				$data_insert['fsm_turno'] = $this->input->post('turno');				
				$data_insert['fsm_antiguedad'] = $this->input->post('antiguedad');
				
				$data_insert['fsm_atencion'] = $this->input->post('atencion');
				$data_insert['fsm_f_fum'] = $this->input->post('f_fum');
				$data_insert['fsm_f_fpp'] = $this->input->post('f_fpp');
				$data_insert['fsm_sdg'] = $this->input->post('sdg');
				$data_insert['fsm_riesgo_gest'] = $this->input->post('riesgo_gest');
				$data_insert['fsm_cambio_area'] = $this->input->post('cambio_area');
				$data_insert['fsm_rec_rest'] = $this->input->post('rec_rest');

				$data_insert['fsm_med_nombre'] = $medico['usr_nombre'].' '.$medico['usr_paterno'].' '.$medico['usr_materno'];
				$data_insert['fsm_med_cedula'] =$medico['usr_cedula'];
				$data_insert['fsm_med_carrera'] =$medico['usr_carrera'];
				$data_insert['fsm_med_escuela'] =$medico['usr_institucion'];
				
				$data_insert['log_insrt_f']   =  date("Y-m-d H:i:s");
				$data_insert['log_insrt_usr_cve']  = $user['usr_id'];
				$data_insert['log_updt_f']   =  date("Y-m-d H:i:s");
				$data_insert['log_updt_usr_cve']  = $user['usr_id']; 
			
				if ($this->salud_ocupacional->insert_ISOCP(array_to_upper($data_insert)))
                {					
                    send_json_ok('Se registro de forma correcta.');
                }
                else
                {
                    send_json_error('Ocurrió un error al registrar.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
            $this->load->helper('template');
            $params_view = array(
                'title' => '',
                'view' => 'examen/salud_ocupacional/nuevo_form_ISOCP',
                'view_data' => $data 
               );
            render_template($params_view);
        }
    }


	public function editar_ISOCP($cliente_id, $fsm_id)
    {
        $persona = $this->cliente->get($cliente_id);
		$data['fsm'] = $this->salud_ocupacional->get_ISOCP($fsm_id);		
        $user = $this->session->user;

        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');

            if(true)
            {
			/*	$data_insert['clte_id'] = $persona['clte_id'];
				$data_insert['fsm_edad']=intval(trim(str_replace("años", "",get_edad($persona['clte_f_nac']))));
				
				$data_insert['fsm_f_nac']=$persona['clte_f_nac'];
				$data_insert['fsm_genero']=$persona['clte_genero_cve'];
				$data_insert['emp_id'] = $persona['emp_id'];
				$data_insert['suc_id'] = $persona['suc_id'];               
                $data_insert['serv_id']  = '';
                $data_insert['usr_id']  = $user['usr_id'];
                $data_insert['fsm_f']   =  date("Y-m-d H:i:s");
				
				$data_insert['fsm_f_y']   =  date("Y");
				$data_insert['fsm_f_m']   =  date("m");
				$data_insert['fsm_f_d']   =  date("d");
				$data_insert['fsm_f_h']   =  date("H");
				$data_insert['fsm_f_i']   =  date("i");
			*/					
				$data_insert['med_id'] = $this->input->post('medico');
				
				$medico = $this->medico->get($data_insert['med_id']);				
				
				$data_insert['fsm_area'] = $this->input->post('area');
				$data_insert['fsm_turno'] = $this->input->post('turno');				
				$data_insert['fsm_antiguedad'] = $this->input->post('antiguedad');
				
				$data_insert['fsm_atencion'] = $this->input->post('atencion');
				$data_insert['fsm_f_fum'] = $this->input->post('f_fum');
				$data_insert['fsm_f_fpp'] = $this->input->post('f_fpp');
				$data_insert['fsm_sdg'] = $this->input->post('sdg');
				$data_insert['fsm_riesgo_gest'] = $this->input->post('riesgo_gest');
				$data_insert['fsm_cambio_area'] = $this->input->post('cambio_area');
				$data_insert['fsm_rec_rest'] = $this->input->post('rec_rest');			

				$data_insert['fsm_med_nombre'] = $medico['usr_nombre'].' '.$medico['usr_paterno'].' '.$medico['usr_materno'];
				$data_insert['fsm_med_cedula'] =$medico['usr_cedula'];
				$data_insert['fsm_med_carrera'] =$medico['usr_carrera'];
				$data_insert['fsm_med_escuela'] =$medico['usr_institucion'];
				
				$data_insert['log_updt_f']   =  date("Y-m-d H:i:s");
				$data_insert['log_updt_usr_cve']  = $user['usr_id']; 
				$data_insert=array_to_upper($data_insert);
				if ($this->salud_ocupacional->update_ISOCP($fsm_id,$data_insert))
                {					
                    send_json_ok('Se actualizo el registro en forma correcta.');
                }
                else
                {
                    send_json_error('Ocurrió un error al actualizar el registro.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
            $this->load->helper('template');
            $params_view = array(
                'title' => '',
                'view' => 'examen/salud_ocupacional/edit_ISOCP',
                'view_data' => $data 
               );
            render_template($params_view);
        }
    }

	
   public function borra_ISOCP($fsm_id)
    {
        if($this->salud_ocupacional->borra_ISOCP($fsm_id))
        {
            send_json_ok('Se eliminó de forma correcta el registro.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar el registro.');
        }
    }

    public function pdf_ISOCP($cliente_id, $fsm_id)
    {
		$user = $this->session->user;
		
        $data['persona'] = $this->cliente->get($cliente_id,get_desp_id_usr());
        $data['fsm'] = $this->salud_ocupacional->get_ISOCP($fsm_id);
        $data['medico'] = $this->medico->get_id($data['fsm']['med_id']);
        $data['empresa'] = $this->cliente->get_empresa_by_id($data['fsm']['emp_id']);
        $reporte=$user['usr_id'].'_'.$data['fsm']['emp_id'].'_'.date("Ymd_His");
		$this->load->helper('pdf');
		$ruta=base_url('../dist/images/hclogo.jpg');
		genera_pdf_receta($this->load->view('examen/salud_ocupacional/pdf_ISOCP',$data,TRUE),$reporte,$user['usr_id'],'fsm773','Humancenter Review S.A de C.V.','P',$ruta);

	}

	
/*************************************************************/	

	public function nuevo_ISOPV($cliente_id)
    {
		
		$persona = $this->cliente->get($cliente_id);
        $user = $this->session->user;
        //$this->session->user;
       
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');			
		//	$this->form_validation->set_rules('antiguedad','ANTIGUEDAD LABORAL','required');
			$this->form_validation->set_rules('area','AREA','required');
			$this->form_validation->set_rules('turno','TURNO','required');
			
			$this->form_validation->set_rules('atencion','TIPO DE ATENCIÓN','required');
			$this->form_validation->set_rules('patalogia','PATOLOGÍA','required');
			$this->form_validation->set_rules('f_diagnostico','FECHA DE DIAGNÓSTICO','required');
			$this->form_validation->set_rules('tratamiento','TRATAMIENTO ACTUAL','required');
			$this->form_validation->set_rules('estatus','ESTATUS','required');
			
			$this->form_validation->set_rules('cambio_area','CAMBIO DE ÁREA','required');
			$this->form_validation->set_rules('rec_rest','RECOMENDACIONES Y/O RESTRICCIONES','required');
			
			$this->form_validation->set_rules('medico','MEDICO QUE ATENDIO','required');			

            if($this->form_validation->run())
            {
				$data_insert['clte_id'] = $persona['clte_id'];
				$data_insert['fsm_edad']=intval(trim(str_replace("años", "",get_edad($persona['clte_f_nac']))));
				
				$data_insert['fsm_f_nac']=$persona['clte_f_nac'];
				$data_insert['fsm_genero']=$persona['clte_genero_cve'];
				$data_insert['emp_id'] = $persona['emp_id'];
				$data_insert['suc_id'] = $persona['suc_id'];               
                $data_insert['serv_id']  = '';
                $data_insert['usr_id']  = $user['usr_id'];
                $data_insert['fsm_f']   =  date("Y-m-d H:i:s");
				
				$data_insert['fsm_f_y']   =  date("Y");
				$data_insert['fsm_f_m']   =  date("m");
				$data_insert['fsm_f_d']   =  date("d");
				$data_insert['fsm_f_h']   =  date("H");
				$data_insert['fsm_f_i']   =  date("i");
								
				$data_insert['med_id'] = $this->input->post('medico');
				
				$medico = $this->medico->get($data_insert['med_id']);				
				
				$data_insert['fsm_area'] = $this->input->post('area');
				$data_insert['fsm_turno'] = $this->input->post('turno');				
				$data_insert['fsm_antiguedad'] = $this->input->post('antiguedad');	
				
				$data_insert['fsm_atencion'] = $this->input->post('atencion');
				$data_insert['fsm_patalogia'] = $this->input->post('patalogia');
				$data_insert['fsm_f_diagnostico'] = $this->input->post('f_diagnostico');
				$data_insert['fsm_tratamiento'] = $this->input->post('tratamiento');
				$data_insert['fsm_estatus'] = $this->input->post('estatus');
				$data_insert['fsm_cambio_area'] = $this->input->post('cambio_area');
				$data_insert['fsm_rec_rest'] = $this->input->post('rec_rest');			
				
				$data_insert['fsm_med_nombre'] = $medico['usr_nombre'].' '.$medico['usr_paterno'].' '.$medico['usr_materno'];
				$data_insert['fsm_med_cedula'] =$medico['usr_cedula'];
				$data_insert['fsm_med_carrera'] =$medico['usr_carrera'];
				$data_insert['fsm_med_escuela'] =$medico['usr_institucion'];
				
				$data_insert['log_insrt_f']   =  date("Y-m-d H:i:s");
				$data_insert['log_insrt_usr_cve']  = $user['usr_id'];
				$data_insert['log_updt_f']   =  date("Y-m-d H:i:s");
				$data_insert['log_updt_usr_cve']  = $user['usr_id']; 
			
				if ($this->salud_ocupacional->insert_ISOPV(array_to_upper($data_insert)))
                {					
                    send_json_ok('Se registro de forma correcta.');
                }
                else
                {
                    send_json_error('Ocurrió un error al registrar.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
            $this->load->helper('template');
            $params_view = array(
                'title' => '',
                'view' => 'examen/salud_ocupacional/nuevo_form_ISOPV',
                'view_data' => $data 
               );
            render_template($params_view);
        }
    }


	public function editar_ISOPV($cliente_id, $fsm_id)
    {
        $persona = $this->cliente->get($cliente_id);
		$data['fsm'] = $this->salud_ocupacional->get_ISOPV($fsm_id);		
        $user = $this->session->user;

        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');

            if(true)
            {
			/*	$data_insert['clte_id'] = $persona['clte_id'];
				$data_insert['fsm_edad']=intval(trim(str_replace("años", "",get_edad($persona['clte_f_nac']))));
				
				$data_insert['fsm_f_nac']=$persona['clte_f_nac'];
				$data_insert['fsm_genero']=$persona['clte_genero_cve'];
				$data_insert['emp_id'] = $persona['emp_id'];
				$data_insert['suc_id'] = $persona['suc_id'];               
                $data_insert['serv_id']  = '';
                $data_insert['usr_id']  = $user['usr_id'];
                $data_insert['fsm_f']   =  date("Y-m-d H:i:s");
				
				$data_insert['fsm_f_y']   =  date("Y");
				$data_insert['fsm_f_m']   =  date("m");
				$data_insert['fsm_f_d']   =  date("d");
				$data_insert['fsm_f_h']   =  date("H");
				$data_insert['fsm_f_i']   =  date("i");
			*/					
				$data_insert['med_id'] = $this->input->post('medico');
				
				$medico = $this->medico->get($data_insert['med_id']);				
				
				$data_insert['fsm_area'] = $this->input->post('area');
				$data_insert['fsm_turno'] = $this->input->post('turno');	
				$data_insert['fsm_antiguedad'] = $this->input->post('antiguedad');					
				
				$data_insert['fsm_atencion'] = $this->input->post('atencion');
				$data_insert['fsm_patalogia'] = $this->input->post('patalogia');
				$data_insert['fsm_f_diagnostico'] = $this->input->post('f_diagnostico');
				$data_insert['fsm_tratamiento'] = $this->input->post('tratamiento');
				$data_insert['fsm_estatus'] = $this->input->post('estatus');
				$data_insert['fsm_cambio_area'] = $this->input->post('cambio_area');
				$data_insert['fsm_rec_rest'] = $this->input->post('rec_rest');				

				$data_insert['fsm_med_nombre'] = $medico['usr_nombre'].' '.$medico['usr_paterno'].' '.$medico['usr_materno'];
				$data_insert['fsm_med_cedula'] =$medico['usr_cedula'];
				$data_insert['fsm_med_carrera'] =$medico['usr_carrera'];
				$data_insert['fsm_med_escuela'] =$medico['usr_institucion'];
				
				$data_insert['log_updt_f']   =  date("Y-m-d H:i:s");
				$data_insert['log_updt_usr_cve']  = $user['usr_id']; 
				$data_insert=array_to_upper($data_insert);
				if ($this->salud_ocupacional->update_ISOPV($fsm_id,$data_insert))
                {					
                    send_json_ok('Se actualizo el registro en forma correcta.');
                }
                else
                {
                    send_json_error('Ocurrió un error al actualizar el registro.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
            $this->load->helper('template');
            $params_view = array(
                'title' => '',
                'view' => 'examen/salud_ocupacional/edit_ISOPV',
                'view_data' => $data 
               );
            render_template($params_view);
        }
    }

	
   public function borra_ISOPV($fsm_id)
    {
        if($this->salud_ocupacional->borra_ISOPV($fsm_id))
        {
            send_json_ok('Se eliminó de forma correcta el registro.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar el registro.');
        }
    }

    public function pdf_ISOPV($cliente_id, $fsm_id)
    {
		$user = $this->session->user;
		
        $data['persona'] = $this->cliente->get($cliente_id,get_desp_id_usr());
        $data['fsm'] = $this->salud_ocupacional->get_ISOPV($fsm_id);
        $data['medico'] = $this->medico->get_id($data['fsm']['med_id']);
        $data['empresa'] = $this->cliente->get_empresa_by_id($data['fsm']['emp_id']);
        $reporte=$user['usr_id'].'_'.$data['fsm']['emp_id'].'_'.date("Ymd_His");
		$this->load->helper('pdf');
		$ruta=base_url('../dist/images/hclogo.jpg');
		genera_pdf_receta($this->load->view('examen/salud_ocupacional/pdf_ISOPV',$data,TRUE),$reporte,$user['usr_id'],'fsm773','Humancenter Review S.A de C.V.','P',$ruta);

	}

	
/*************************************************************/	
	public function nuevo_ISOAM($cliente_id)
    {
		
		$persona = $this->cliente->get($cliente_id);
        $user = $this->session->user;
        //$this->session->user;
       
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');			
		//	$this->form_validation->set_rules('antiguedad','ANTIGUEDAD LABORAL','required');
			$this->form_validation->set_rules('area','AREA','required');
			$this->form_validation->set_rules('turno','TURNO','required');
			$this->form_validation->set_rules('motivo','MOTIVO DE LA CONSULTA','required');
			$this->form_validation->set_rules('enfermendad','TIPO DE ENFERMEDAD','required');
			$this->form_validation->set_rules('terapeutica','TERAPÉUTICA EMPLEADA','required');
			$this->form_validation->set_rules('pase','PASE','required');
			$this->form_validation->set_rules('observaciones','OBSERVACIONES','required');
			$this->form_validation->set_rules('medico','MEDICO QUE ATENDIO','required');			

			$this->form_validation->set_rules('hora_ingreso','HORA DE INGRESO','required');
			$this->form_validation->set_rules('hora_engreso','HORA DE EGRESO','required');

            if($this->form_validation->run())
            {
				$data_insert['clte_id'] = $persona['clte_id'];
				$data_insert['fsm_edad']=intval(trim(str_replace("años", "",get_edad($persona['clte_f_nac']))));
				
				$data_insert['fsm_f_nac']=$persona['clte_f_nac'];
				$data_insert['fsm_genero']=$persona['clte_genero_cve'];
				$data_insert['emp_id'] = $persona['emp_id'];
				$data_insert['suc_id'] = $persona['suc_id'];               
                $data_insert['serv_id']  = '';
                $data_insert['usr_id']  = $user['usr_id'];
                $data_insert['fsm_f']   =  date("Y-m-d H:i:s");
				
				$data_insert['fsm_f_y']   =  date("Y");
				$data_insert['fsm_f_m']   =  date("m");
				$data_insert['fsm_f_d']   =  date("d");
				$data_insert['fsm_f_h']   =  date("H");
				$data_insert['fsm_f_i']   =  date("i");
								
				$data_insert['fsm_f_eva'] = formatea_fecha_mysql($this->input->post('fecha_consulta')); 
				$data_insert['fsm_hora_ingreso'] = $this->input->post('hora_ingreso');
				$data_insert['fsm_hora_engreso'] = $this->input->post('hora_engreso');
								
				$data_insert['med_id'] = $this->input->post('medico');
				
				$medico = $this->medico->get($data_insert['med_id']);				
				
				$data_insert['fsm_area'] = $this->input->post('area');
				$data_insert['fsm_turno'] = $this->input->post('turno');
				$data_insert['fsm_antiguedad'] = $this->input->post('antiguedad');	
				
				$data_insert['fsm_motivo'] = $this->input->post('motivo');
				$data_insert['fsm_enfermendad'] = $this->input->post('enfermendad');
				$data_insert['fsm_terapeutica'] = $this->input->post('terapeutica');
				$data_insert['fsm_pase'] = $this->input->post('pase');
				$data_insert['fsm_antiguedad'] = $this->input->post('antiguedad'); 
				$data_insert['fsm_observaciones'] = $this->input->post('observaciones');				

				$data_insert['fsm_med_nombre'] = $medico['usr_nombre'].' '.$medico['usr_paterno'].' '.$medico['usr_materno'];
				$data_insert['fsm_med_cedula'] =$medico['usr_cedula'];
				$data_insert['fsm_med_carrera'] =$medico['usr_carrera'];
				$data_insert['fsm_med_escuela'] =$medico['usr_institucion'];
				
				$data_insert['log_insrt_f']   =  date("Y-m-d H:i:s");
				$data_insert['log_insrt_usr_cve']  = $user['usr_id'];
				$data_insert['log_updt_f']   =  date("Y-m-d H:i:s");
				$data_insert['log_updt_usr_cve']  = $user['usr_id']; 
			
				if ($this->salud_ocupacional->insert_ISOAM(array_to_upper($data_insert)))
                {					
                    send_json_ok('Se registro de forma correcta.');
                }
                else
                {
                    send_json_error('Ocurrió un error al registrar.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
            $this->load->helper('template');
            $params_view = array(
                'title' => '',
                'view' => 'examen/salud_ocupacional/nuevo_form_ISOAM',
                'view_data' => $data 
               );
            render_template($params_view);
        }
    }


	public function editar_ISOAM($cliente_id, $fsm_id)
    {
        $persona = $this->cliente->get($cliente_id);
		$data['fsm'] = $this->salud_ocupacional->get_ISOAM($fsm_id);		
        $user = $this->session->user;

        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');

            if(true)
            {
			/*	$data_insert['clte_id'] = $persona['clte_id'];
				$data_insert['fsm_edad']=intval(trim(str_replace("años", "",get_edad($persona['clte_f_nac']))));
				
				$data_insert['fsm_f_nac']=$persona['clte_f_nac'];
				$data_insert['fsm_genero']=$persona['clte_genero_cve'];
				$data_insert['emp_id'] = $persona['emp_id'];
				$data_insert['suc_id'] = $persona['suc_id'];               
                $data_insert['serv_id']  = '';
                $data_insert['usr_id']  = $user['usr_id'];
                $data_insert['fsm_f']   =  date("Y-m-d H:i:s");
				
				$data_insert['fsm_f_y']   =  date("Y");
				$data_insert['fsm_f_m']   =  date("m");
				$data_insert['fsm_f_d']   =  date("d");
				$data_insert['fsm_f_h']   =  date("H");
				$data_insert['fsm_f_i']   =  date("i");
			*/					
				$data_insert['med_id'] = $this->input->post('medico');
				
				$medico = $this->medico->get($data_insert['med_id']);				
				
				$data_insert['fsm_area'] = $this->input->post('area');
				$data_insert['fsm_turno'] = $this->input->post('turno');	
				$data_insert['fsm_antiguedad'] = $this->input->post('antiguedad');	
				
				$data_insert['fsm_motivo'] = $this->input->post('motivo');
				$data_insert['fsm_enfermendad'] = $this->input->post('enfermendad');
				$data_insert['fsm_terapeutica'] = $this->input->post('terapeutica');
				$data_insert['fsm_pase'] = $this->input->post('pase');
				$data_insert['fsm_antiguedad'] = $this->input->post('antiguedad');   
				$data_insert['fsm_observaciones'] = $this->input->post('observaciones');				

				$data_insert['fsm_f_eva'] = formatea_fecha_mysql($this->input->post('fecha_consulta')); 
				$data_insert['fsm_hora_ingreso'] = $this->input->post('hora_ingreso');
				$data_insert['fsm_hora_engreso'] = $this->input->post('hora_engreso');
				
				$data_insert['fsm_med_nombre'] = $medico['usr_nombre'].' '.$medico['usr_paterno'].' '.$medico['usr_materno'];
				$data_insert['fsm_med_cedula'] =$medico['usr_cedula'];
				$data_insert['fsm_med_carrera'] =$medico['usr_carrera'];
				$data_insert['fsm_med_escuela'] =$medico['usr_institucion'];
				
				$data_insert['log_updt_f']   =  date("Y-m-d H:i:s");
				$data_insert['log_updt_usr_cve']  = $user['usr_id']; 
				$data_insert=array_to_upper($data_insert);
				if ($this->salud_ocupacional->update_ISOAM($fsm_id,$data_insert))
                {					
                    send_json_ok('Se actualizo el registro en forma correcta.');
                }
                else
                {
                    send_json_error('Ocurrió un error al actualizar el registro.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
            $this->load->helper('template');
            $params_view = array(
                'title' => '',
                'view' => 'examen/salud_ocupacional/edit_ISOAM',
                'view_data' => $data 
               );
            render_template($params_view);
        }
    }

	
   public function borra_ISOAM($fsm_id)
    {
        if($this->salud_ocupacional->borra_ISOAM($fsm_id))
        {
            send_json_ok('Se eliminó de forma correcta el registro.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar el registro.');
        }
    }

    public function pdf_ISOAM($cliente_id, $fsm_id)
    {
		$user = $this->session->user;
		
        $data['persona'] = $this->cliente->get($cliente_id,get_desp_id_usr());
        $data['fsm'] = $this->salud_ocupacional->get_ISOAM($fsm_id);
        $data['medico'] = $this->medico->get_id($data['fsm']['med_id']);
        $data['empresa'] = $this->cliente->get_empresa_by_id($data['fsm']['emp_id']);
        $reporte=$user['usr_id'].'_'.$data['fsm']['emp_id'].'_'.date("Ymd_His");
		$this->load->helper('pdf');
		$ruta=base_url('../dist/images/hclogo.jpg');
		genera_pdf_receta($this->load->view('examen/salud_ocupacional/pdf_ISOAM',$data,TRUE),$reporte,$user['usr_id'],'fsm773','Humancenter Review S.A de C.V.','P',$ruta);

	}

	
/*************************************************************/
	public function nuevo_ISOACC($cliente_id)
    {
		
		$persona = $this->cliente->get($cliente_id);
        $user = $this->session->user;
        //$this->session->user;
       
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
		//	$this->form_validation->set_rules('antiguedad','ANTIGUEDAD LABORAL','required');
			$this->form_validation->set_rules('area','AREA','required');
			$this->form_validation->set_rules('turno','TURNO','required');
			
			$this->form_validation->set_rules('acc_f_h','FECHA Y HORA DEL ACCIDENTE','required');
			$this->form_validation->set_rules('lesion','OBJETO DE LESIÓN','required');
			$this->form_validation->set_rules('diagnostico','DIÁGNÓSTICO','required');
			$this->form_validation->set_rules('parte_afectada','PARTE DEL CUERPO AFECTADA','required');
			$this->form_validation->set_rules('mecanismo_lesion','MECANISMO DE LESIÓN','required');
			$this->form_validation->set_rules('traslado_imss','TRASLADO IMSS','required');
			$this->form_validation->set_rules('incapacidad','INCAPACIDAD IMSS','required');
			$this->form_validation->set_rules('st7','st7','required');
			$this->form_validation->set_rules('st2','st2','required');
			$this->form_validation->set_rules('st9','st9','required');
			$this->form_validation->set_rules('observaciones','OBSERVACIONES','required');
			$this->form_validation->set_rules('medico','MEDICO QUE ATENDIO','required');			

            if($this->form_validation->run())
            {
				$data_insert['clte_id'] = $persona['clte_id'];
				$data_insert['fsm_edad']=intval(trim(str_replace("años", "",get_edad($persona['clte_f_nac']))));
				
				$data_insert['fsm_f_nac']=$persona['clte_f_nac'];
				$data_insert['fsm_genero']=$persona['clte_genero_cve'];
				$data_insert['emp_id'] = $persona['emp_id'];
				$data_insert['suc_id'] = $persona['suc_id'];               
                $data_insert['serv_id']  = '';
                $data_insert['usr_id']  = $user['usr_id'];
                $data_insert['fsm_f']   =  date("Y-m-d H:i:s");
				
				$data_insert['fsm_f_y']   =  date("Y");
				$data_insert['fsm_f_m']   =  date("m");
				$data_insert['fsm_f_d']   =  date("d");
				$data_insert['fsm_f_h']   =  date("H");
				$data_insert['fsm_f_i']   =  date("i");
				
				
				$data_insert['med_id'] = $this->input->post('medico');				
				$medico = $this->medico->get($data_insert['med_id']);
				$data_insert['fsm_area'] = $this->input->post('area');
				$data_insert['fsm_turno'] = $this->input->post('turno');
				$data_insert['fsm_antiguedad'] = $this->input->post('antiguedad'); 				
								
				
				$data_insert['fsm_acc_f_h'] = $this->input->post('acc_f_h');
				$data_insert['fsm_lesion'] = $this->input->post('lesion');						
				$data_insert['fsm_diagnostico'] = $this->input->post('diagnostico');
				$data_insert['fsm_parte_afectada'] = $this->input->post('parte_afectada');
				$data_insert['fsm_mecanismo_lesion'] = $this->input->post('mecanismo_lesion');
				$data_insert['fsm_traslado_imss'] = $this->input->post('traslado_imss');
				$data_insert['fsm_incapacidad'] = $this->input->post('incapacidad');  
				$data_insert['fsm_st7'] = $this->input->post('st7');
				$data_insert['fsm_st2'] = $this->input->post('st2');
				$data_insert['fsm_st9'] = $this->input->post('st9');
				$data_insert['fsm_observaciones'] = $this->input->post('observaciones');				

				$data_insert['fsm_med_nombre'] = $medico['usr_nombre'].' '.$medico['usr_paterno'].' '.$medico['usr_materno'];
				$data_insert['fsm_med_cedula'] =$medico['usr_cedula'];
				$data_insert['fsm_med_carrera'] =$medico['usr_carrera'];
				$data_insert['fsm_med_escuela'] =$medico['usr_institucion'];
				
				$data_insert['log_insrt_f']   =  date("Y-m-d H:i:s");
				$data_insert['log_insrt_usr_cve']  = $user['usr_id'];
				$data_insert['log_updt_f']   =  date("Y-m-d H:i:s");
				$data_insert['log_updt_usr_cve']  = $user['usr_id']; 
			
				if ($this->salud_ocupacional->insert_ISOACC(array_to_upper($data_insert)))
                {					
                    send_json_ok('Se registro de forma correcta.');
                }
                else
                {
                    send_json_error('Ocurrió un error al registrar.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
            $this->load->helper('template');
            $params_view = array(
                'title' => '',
                'view' => 'examen/salud_ocupacional/nuevo_form_ISOACC',
                'view_data' => $data 
               );
            render_template($params_view);
        }
    }


	public function editar_ISOACC($cliente_id, $fsm_id)
    {
        $persona = $this->cliente->get($cliente_id);
		$data['fsm'] = $this->salud_ocupacional->get_ISOACC($fsm_id);		
        $user = $this->session->user;

        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');

            if(true)
            {
			/*	$data_insert['clte_id'] = $persona['clte_id'];
				$data_insert['fsm_edad']=intval(trim(str_replace("años", "",get_edad($persona['clte_f_nac']))));
				
				$data_insert['fsm_f_nac']=$persona['clte_f_nac'];
				$data_insert['fsm_genero']=$persona['clte_genero_cve'];
				$data_insert['emp_id'] = $persona['emp_id'];
				$data_insert['suc_id'] = $persona['suc_id'];               
                $data_insert['serv_id']  = '';
                $data_insert['usr_id']  = $user['usr_id'];
                $data_insert['fsm_f']   =  date("Y-m-d H:i:s");
				
				$data_insert['fsm_f_y']   =  date("Y");
				$data_insert['fsm_f_m']   =  date("m");
				$data_insert['fsm_f_d']   =  date("d");
				$data_insert['fsm_f_h']   =  date("H");
				$data_insert['fsm_f_i']   =  date("i");
			*/					
				$data_insert['med_id'] = $this->input->post('medico');				
				$medico = $this->medico->get($data_insert['med_id']);
				$data_insert['fsm_area'] = $this->input->post('area');
				$data_insert['fsm_turno'] = $this->input->post('turno');
				$data_insert['fsm_antiguedad'] = $this->input->post('antiguedad'); 				
								
				
				$data_insert['fsm_acc_f_h'] = $this->input->post('acc_f_h');
				$data_insert['fsm_lesion'] = $this->input->post('lesion');						
				$data_insert['fsm_diagnostico'] = $this->input->post('diagnostico');
				$data_insert['fsm_parte_afectada'] = $this->input->post('parte_afectada');
				$data_insert['fsm_mecanismo_lesion'] = $this->input->post('mecanismo_lesion');
				$data_insert['fsm_traslado_imss'] = $this->input->post('traslado_imss');
				$data_insert['fsm_incapacidad'] = $this->input->post('incapacidad'); 
				$data_insert['fsm_st7'] = $this->input->post('st7');
				$data_insert['fsm_st2'] = $this->input->post('st2');
				$data_insert['fsm_st9'] = $this->input->post('st9');
				$data_insert['fsm_observaciones'] = $this->input->post('observaciones');				

				$data_insert['fsm_med_nombre'] = $medico['usr_nombre'].' '.$medico['usr_paterno'].' '.$medico['usr_materno'];
				$data_insert['fsm_med_cedula'] =$medico['usr_cedula'];
				$data_insert['fsm_med_carrera'] =$medico['usr_carrera'];
				$data_insert['fsm_med_escuela'] =$medico['usr_institucion'];
				
				$data_insert['log_updt_f']   =  date("Y-m-d H:i:s");
				$data_insert['log_updt_usr_cve']  = $user['usr_id']; 
				$data_insert=array_to_upper($data_insert);
				if ($this->salud_ocupacional->update_ISOACC($fsm_id,$data_insert))
                {					
                    send_json_ok('Se actualizo el registro en forma correcta.');
                }
                else
                {
                    send_json_error('Ocurrió un error al actualizar el registro.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
            $this->load->helper('template');
            $params_view = array(
                'title' => '',
                'view' => 'examen/salud_ocupacional/edit_ISOACC',
                'view_data' => $data 
               );
            render_template($params_view);
        }
    }

	
   public function borra_ISOACC($fsm_id)
    {
        if($this->salud_ocupacional->borra_ISOACC($fsm_id))
        {
            send_json_ok('Se eliminó de forma correcta el registro.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar el registro.');
        }
    }

    public function pdf_ISOACC($cliente_id, $fsm_id)
    {
		$user = $this->session->user;
		
        $data['persona'] = $this->cliente->get($cliente_id,get_desp_id_usr());
        $data['fsm'] = $this->salud_ocupacional->get_ISOACC($fsm_id);
        $data['medico'] = $this->medico->get_id($data['fsm']['med_id']);
        $data['empresa'] = $this->cliente->get_empresa_by_id($data['fsm']['emp_id']);
        $reporte=$user['usr_id'].'_'.$data['fsm']['emp_id'].'_'.date("Ymd_His");
		$this->load->helper('pdf');
		$ruta=base_url('../dist/images/hclogo.jpg');
		genera_pdf_receta($this->load->view('examen/salud_ocupacional/pdf_ISOACC',$data,TRUE),$reporte,$user['usr_id'],'fsm773','Humancenter Review S.A de C.V.','P',$ruta);

	}

	
/*************************************************************/
	public function nuevo_ISOEXP($cliente_id)
    {
		
		$persona = $this->cliente->get($cliente_id);
        $user = $this->session->user;
        //$this->session->user;
       
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');			
		//	$this->form_validation->set_rules('antiguedad','ANTIGUEDAD LABORAL','required');
			$this->form_validation->set_rules('area','AREA','required');
			$this->form_validation->set_rules('turno','TURNO','required');
			
			$this->form_validation->set_rules('cronicodegenerativas','ENF. CRÓNICODEGENERATIVAS','required');
			$this->form_validation->set_rules('imc','IMC');
			$this->form_validation->set_rules('agudeza_visual','AGUDEZA VISUAL','required');
			$this->form_validation->set_rules('daltonismo','DALTONISMO','required');
			$this->form_validation->set_rules('audicion','AUDICIÓN','required');
			$this->form_validation->set_rules('musculo_exq','ENF. MUSCULO-ESQUELÉTICAS','required');
			$this->form_validation->set_rules('toxicologico','TOXICOLÓGICO','required');
			$this->form_validation->set_rules('observaciones','OBSERVACIONES','required');
			$this->form_validation->set_rules('medico','MEDICO QUE ATENDIO','required');			

            if($this->form_validation->run())
            {
				$data_insert['clte_id'] = $persona['clte_id'];
				$data_insert['fsm_edad']=intval(trim(str_replace("años", "",get_edad($persona['clte_f_nac']))));
				
				$data_insert['fsm_f_nac']=$persona['clte_f_nac'];
				$data_insert['fsm_genero']=$persona['clte_genero_cve'];
				$data_insert['emp_id'] = $persona['emp_id'];
				$data_insert['suc_id'] = $persona['suc_id'];               
                $data_insert['serv_id']  = '';
                $data_insert['usr_id']  = $user['usr_id'];
                $data_insert['fsm_f']   =  date("Y-m-d H:i:s");
				
				$data_insert['fsm_f_y']   =  date("Y");
				$data_insert['fsm_f_m']   =  date("m");
				$data_insert['fsm_f_d']   =  date("d");
				$data_insert['fsm_f_h']   =  date("H");
				$data_insert['fsm_f_i']   =  date("i");
								
				$data_insert['med_id'] = $this->input->post('medico');				
				$medico = $this->medico->get($data_insert['med_id']);				
				$data_insert['fsm_area'] = $this->input->post('area');
				$data_insert['fsm_turno'] = $this->input->post('turno');
				$data_insert['fsm_antiguedad'] = $this->input->post('antiguedad'); 
				
				$data_insert['fsm_cronicodegenerativas'] = $this->input->post('cronicodegenerativas');
				$data_insert['fsm_imc'] = $this->input->post('imc');
				$data_insert['fsm_agudeza_visual'] = $this->input->post('agudeza_visual');
				$data_insert['fsm_daltonismo'] = $this->input->post('daltonismo');
				$data_insert['fsm_audicion'] = $this->input->post('audicion');	
				$data_insert['fsm_musculo_exq'] = $this->input->post('musculo_exq');
				$data_insert['fsm_toxicologico'] = $this->input->post('toxicologico');
				$data_insert['fsm_aptitud'] = $this->input->post('aptitud');
				
				$data_insert['fsm_observaciones'] = $this->input->post('observaciones');				

				$data_insert['fsm_med_nombre'] = $medico['usr_nombre'].' '.$medico['usr_paterno'].' '.$medico['usr_materno'];
				$data_insert['fsm_med_cedula'] =$medico['usr_cedula'];
				$data_insert['fsm_med_carrera'] =$medico['usr_carrera'];
				$data_insert['fsm_med_escuela'] =$medico['usr_institucion'];
				
				$data_insert['log_insrt_f']   =  date("Y-m-d H:i:s");
				$data_insert['log_insrt_usr_cve']  = $user['usr_id'];
				$data_insert['log_updt_f']   =  date("Y-m-d H:i:s");
				$data_insert['log_updt_usr_cve']  = $user['usr_id']; 
			
				if ($this->salud_ocupacional->insert_ISOEXP(array_to_upper($data_insert)))
                {					
                    send_json_ok('Se registro de forma correcta.');
                }
                else
                {
                    send_json_error('Ocurrió un error al registrar.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
            $this->load->helper('template');
            $params_view = array(
                'title' => '',
                'view' => 'examen/salud_ocupacional/nuevo_form_ISOEXP',
                'view_data' => $data 
               );
            render_template($params_view);
        }
    }


	public function editar_ISOEXP($cliente_id, $fsm_id)
    {
        $persona = $this->cliente->get($cliente_id);
		$data['fsm'] = $this->salud_ocupacional->get_ISOEXP($fsm_id);		
        $user = $this->session->user;

        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');

            if(true)
            {
			/*	$data_insert['clte_id'] = $persona['clte_id'];
				$data_insert['fsm_edad']=intval(trim(str_replace("años", "",get_edad($persona['clte_f_nac']))));
				
				$data_insert['fsm_f_nac']=$persona['clte_f_nac'];
				$data_insert['fsm_genero']=$persona['clte_genero_cve'];
				$data_insert['emp_id'] = $persona['emp_id'];
				$data_insert['suc_id'] = $persona['suc_id'];               
                $data_insert['serv_id']  = '';
                $data_insert['usr_id']  = $user['usr_id'];
                $data_insert['fsm_f']   =  date("Y-m-d H:i:s");
				
				$data_insert['fsm_f_y']   =  date("Y");
				$data_insert['fsm_f_m']   =  date("m");
				$data_insert['fsm_f_d']   =  date("d");
				$data_insert['fsm_f_h']   =  date("H");
				$data_insert['fsm_f_i']   =  date("i");
			*/					
				$data_insert['med_id'] = $this->input->post('medico');				
				$medico = $this->medico->get($data_insert['med_id']);				
				$data_insert['fsm_area'] = $this->input->post('area');
				$data_insert['fsm_turno'] = $this->input->post('turno');
				$data_insert['fsm_antiguedad'] = $this->input->post('antiguedad'); 
				
				$data_insert['fsm_cronicodegenerativas'] = $this->input->post('cronicodegenerativas');
				$data_insert['fsm_imc'] = $this->input->post('imc');
				$data_insert['fsm_agudeza_visual'] = $this->input->post('agudeza_visual');
				$data_insert['fsm_daltonismo'] = $this->input->post('daltonismo');
				$data_insert['fsm_audicion'] = $this->input->post('audicion');	
				$data_insert['fsm_musculo_exq'] = $this->input->post('musculo_exq');
				$data_insert['fsm_toxicologico'] = $this->input->post('toxicologico');
				$data_insert['fsm_aptitud'] = $this->input->post('aptitud');
				$data_insert['fsm_observaciones'] = $this->input->post('observaciones');				

				$data_insert['fsm_med_nombre'] = $medico['usr_nombre'].' '.$medico['usr_paterno'].' '.$medico['usr_materno'];
				$data_insert['fsm_med_cedula'] =$medico['usr_cedula'];
				$data_insert['fsm_med_carrera'] =$medico['usr_carrera'];
				$data_insert['fsm_med_escuela'] =$medico['usr_institucion'];
				
				$data_insert['log_updt_f']   =  date("Y-m-d H:i:s");
				$data_insert['log_updt_usr_cve']  = $user['usr_id']; 
				$data_insert=array_to_upper($data_insert);
				if ($this->salud_ocupacional->update_ISOEXP($fsm_id,$data_insert))
                {					
                    send_json_ok('Se actualizo el registro en forma correcta.');
                }
                else
                {
                    send_json_error('Ocurrió un error al actualizar el registro.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
            $this->load->helper('template');
            $params_view = array(
                'title' => '',
                'view' => 'examen/salud_ocupacional/edit_ISOEXP',
                'view_data' => $data 
               );
            render_template($params_view);
        }
    }

	
   public function borra_ISOEXP($fsm_id)
    {
        if($this->salud_ocupacional->borra_ISOEXP($fsm_id))
        {
            send_json_ok('Se eliminó de forma correcta el registro.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar el registro.');
        }
    }

    public function pdf_ISOEXP($cliente_id, $fsm_id)
    {
		$user = $this->session->user;
		
        $data['persona'] = $this->cliente->get($cliente_id,get_desp_id_usr());
        $data['fsm'] = $this->salud_ocupacional->get_ISOEXP($fsm_id);
        $data['medico'] = $this->medico->get_id($data['fsm']['med_id']);
        $data['empresa'] = $this->cliente->get_empresa_by_id($data['fsm']['emp_id']);
        $reporte=$user['usr_id'].'_'.$data['fsm']['emp_id'].'_'.date("Ymd_His");
		$this->load->helper('pdf');
		$ruta=base_url('../dist/images/hclogo.jpg');
		genera_pdf_receta($this->load->view('examen/salud_ocupacional/pdf_ISOEXP',$data,TRUE),$reporte,$user['usr_id'],'fsm773','Humancenter Review S.A de C.V.','P',$ruta);

	}

	
/*************************************************************/
	public function nuevo_ISOINC($cliente_id)
    {
		
		$persona = $this->cliente->get($cliente_id);
        $user = $this->session->user;
        //$this->session->user;
       
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');			
		//	$this->form_validation->set_rules('antiguedad','ANTIGUEDAD LABORAL','required');
			$this->form_validation->set_rules('area','AREA','required');
			$this->form_validation->set_rules('turno','TURNO','required');
			$this->form_validation->set_rules('diagnostico','DIAGNÓSTICO','required');
			$this->form_validation->set_rules('incapacidad','TIPO DE INCAPACIDAD','required');
			$this->form_validation->set_rules('ini_sub','INICIAL/SUBSECUENTE','required');
			$this->form_validation->set_rules('seguro','RAMO DEL SEGURO','required');			
			$this->form_validation->set_rules('dias','DÍAS','required');
			$this->form_validation->set_rules('f_inicio','FECHA DE INICIO','required');
			$this->form_validation->set_rules('f_fin','FECHA DE TERMINO','required');
			$this->form_validation->set_rules('f_rei','FECHA DE REINCORPORACIÓN','required');
			$this->form_validation->set_rules('aptitud','APTITUD LABORAL','required');
			
			
			$this->form_validation->set_rules('observaciones','OBSERVACIONES','required');
			$this->form_validation->set_rules('medico','MEDICO QUE ATENDIO','required');			

            if($this->form_validation->run())
            {
				$data_insert['clte_id'] = $persona['clte_id'];
				$data_insert['fsm_edad']=intval(trim(str_replace("años", "",get_edad($persona['clte_f_nac']))));
				
				$data_insert['fsm_f_nac']=$persona['clte_f_nac'];
				$data_insert['fsm_genero']=$persona['clte_genero_cve'];
				$data_insert['emp_id'] = $persona['emp_id'];
				$data_insert['suc_id'] = $persona['suc_id'];               
                $data_insert['serv_id']  = '';
                $data_insert['usr_id']  = $user['usr_id'];
                $data_insert['fsm_f']   =  date("Y-m-d H:i:s");
				
				$data_insert['fsm_f_y']   =  date("Y");
				$data_insert['fsm_f_m']   =  date("m");
				$data_insert['fsm_f_d']   =  date("d");
				$data_insert['fsm_f_h']   =  date("H");
				$data_insert['fsm_f_i']   =  date("i");
								
				$data_insert['med_id'] = $this->input->post('medico');				
				$medico = $this->medico->get($data_insert['med_id']);			
				$data_insert['fsm_area'] = $this->input->post('area');
				$data_insert['fsm_turno'] = $this->input->post('turno');
				$data_insert['fsm_antiguedad'] = $this->input->post('antiguedad'); 
				
				$data_insert['fsm_diagnostico'] = $this->input->post('diagnostico');
				$data_insert['fsm_incapacidad'] = $this->input->post('incapacidad');
				$data_insert['fsm_ini_sub'] = $this->input->post('ini_sub');
				$data_insert['fsm_seguro'] = $this->input->post('seguro');			
				$data_insert['fsm_dias'] = $this->input->post('dias');
				$data_insert['fsm_f_inicio'] = $this->input->post('f_inicio');
				$data_insert['fsm_f_fin'] = $this->input->post('f_fin');
				$data_insert['fsm_f_rei'] = $this->input->post('f_rei');
				$data_insert['fsm_aptitud'] = $this->input->post('aptitud');
				
				
				$data_insert['fsm_observaciones'] = $this->input->post('observaciones');				

				$data_insert['fsm_med_nombre'] = $medico['usr_nombre'].' '.$medico['usr_paterno'].' '.$medico['usr_materno'];
				$data_insert['fsm_med_cedula'] =$medico['usr_cedula'];
				$data_insert['fsm_med_carrera'] =$medico['usr_carrera'];
				$data_insert['fsm_med_escuela'] =$medico['usr_institucion'];
				
				$data_insert['log_insrt_f']   =  date("Y-m-d H:i:s");
				$data_insert['log_insrt_usr_cve']  = $user['usr_id'];
				$data_insert['log_updt_f']   =  date("Y-m-d H:i:s");
				$data_insert['log_updt_usr_cve']  = $user['usr_id']; 
			
				if ($this->salud_ocupacional->insert_ISOINC(array_to_upper($data_insert)))
                {					
                    send_json_ok('Se registro de forma correcta.');
                }
                else
                {
                    send_json_error('Ocurrió un error al registrar.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
            $this->load->helper('template');
            $params_view = array(
                'title' => '',
                'view' => 'examen/salud_ocupacional/nuevo_form_ISOINC',
                'view_data' => $data 
               );
            render_template($params_view);
        }
    }


	public function editar_ISOINC($cliente_id, $fsm_id)
    {
        $persona = $this->cliente->get($cliente_id);
		$data['fsm'] = $this->salud_ocupacional->get_ISOINC($fsm_id);		
        $user = $this->session->user;

        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');

            if(true)
            {
			/*	$data_insert['clte_id'] = $persona['clte_id'];
				$data_insert['fsm_edad']=intval(trim(str_replace("años", "",get_edad($persona['clte_f_nac']))));
				
				$data_insert['fsm_f_nac']=$persona['clte_f_nac'];
				$data_insert['fsm_genero']=$persona['clte_genero_cve'];
				$data_insert['emp_id'] = $persona['emp_id'];
				$data_insert['suc_id'] = $persona['suc_id'];               
                $data_insert['serv_id']  = '';
                $data_insert['usr_id']  = $user['usr_id'];
                $data_insert['fsm_f']   =  date("Y-m-d H:i:s");
				
				$data_insert['fsm_f_y']   =  date("Y");
				$data_insert['fsm_f_m']   =  date("m");
				$data_insert['fsm_f_d']   =  date("d");
				$data_insert['fsm_f_h']   =  date("H");
				$data_insert['fsm_f_i']   =  date("i");
			*/					
				$data_insert['med_id'] = $this->input->post('medico');				
				$medico = $this->medico->get($data_insert['med_id']);			
				$data_insert['fsm_area'] = $this->input->post('area');
				$data_insert['fsm_turno'] = $this->input->post('turno');
				$data_insert['fsm_antiguedad'] = $this->input->post('antiguedad'); 
				
				$data_insert['fsm_diagnostico'] = $this->input->post('diagnostico');
				$data_insert['fsm_incapacidad'] = $this->input->post('incapacidad');
				$data_insert['fsm_ini_sub'] = $this->input->post('ini_sub');
				$data_insert['fsm_seguro'] = $this->input->post('seguro');			
				$data_insert['fsm_dias'] = $this->input->post('dias');
				$data_insert['fsm_f_inicio'] = $this->input->post('f_inicio');
				$data_insert['fsm_f_fin'] = $this->input->post('f_fin');
				$data_insert['fsm_f_rei'] = $this->input->post('f_rei');
				$data_insert['fsm_aptitud'] = $this->input->post('aptitud');
				
				
				$data_insert['fsm_observaciones'] = $this->input->post('observaciones');					

				$data_insert['fsm_med_nombre'] = $medico['usr_nombre'].' '.$medico['usr_paterno'].' '.$medico['usr_materno'];
				$data_insert['fsm_med_cedula'] =$medico['usr_cedula'];
				$data_insert['fsm_med_carrera'] =$medico['usr_carrera'];
				$data_insert['fsm_med_escuela'] =$medico['usr_institucion'];
				
				$data_insert['log_updt_f']   =  date("Y-m-d H:i:s");
				$data_insert['log_updt_usr_cve']  = $user['usr_id']; 
				$data_insert=array_to_upper($data_insert);
				if ($this->salud_ocupacional->update_ISOINC($fsm_id,$data_insert))
                {					
                    send_json_ok('Se actualizo el registro en forma correcta.');
                }
                else
                {
                    send_json_error('Ocurrió un error al actualizar el registro.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
            $this->load->helper('template');
            $params_view = array(
                'title' => '',
                'view' => 'examen/salud_ocupacional/edit_ISOINC',
                'view_data' => $data 
               );
            render_template($params_view);
        }
    }

	
   public function borra_ISOINC($fsm_id)
    {
        if($this->salud_ocupacional->borra_ISOINC($fsm_id))
        {
            send_json_ok('Se eliminó de forma correcta el registro.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar el registro.');
        }
    }

    public function pdf_ISOINC($cliente_id, $fsm_id)
    {
		$user = $this->session->user;
		
        $data['persona'] = $this->cliente->get($cliente_id,get_desp_id_usr());
        $data['fsm'] = $this->salud_ocupacional->get_ISOINC($fsm_id);
        $data['medico'] = $this->medico->get_id($data['fsm']['med_id']);
        $data['empresa'] = $this->cliente->get_empresa_by_id($data['fsm']['emp_id']);
        $reporte=$user['usr_id'].'_'.$data['fsm']['emp_id'].'_'.date("Ymd_His");
		$this->load->helper('pdf');
		$ruta=base_url('../dist/images/hclogo.jpg');
		genera_pdf_receta($this->load->view('examen/salud_ocupacional/pdf_ISOINC',$data,TRUE),$reporte,$user['usr_id'],'fsm773','Humancenter Review S.A de C.V.','P',$ruta);

	}

	
/*************************************************************/
	public function nuevo_ISOEXI($cliente_id)
    {
		
		$persona = $this->cliente->get($cliente_id);
        $user = $this->session->user;
        //$this->session->user;
       
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');			
            $this->load->library('form_validation');			
			//$this->form_validation->set_rules('antiguedad','ANTIGUEDAD LABORAL','required');
			//$this->form_validation->set_rules('area','AREA','required');
			//$this->form_validation->set_rules('turno','TURNO','required');
			
			$this->form_validation->set_rules('cronicodegenerativas','ENF. CRÓNICODEGENERATIVAS','required');
			$this->form_validation->set_rules('imc','IMC');
			$this->form_validation->set_rules('agudeza_visual','AGUDEZA VISUAL','required');
			$this->form_validation->set_rules('daltonismo','DALTONISMO','required');
			$this->form_validation->set_rules('audicion','AUDICIÓN','required');
			$this->form_validation->set_rules('observaciones','OBSERVACIONES','required');
			$this->form_validation->set_rules('medico','MEDICO QUE ATENDIO','required');			
			

            if($this->form_validation->run())
            {
				$data_insert['clte_id'] = $persona['clte_id'];
				$data_insert['fsm_edad']=intval(trim(str_replace("años", "",get_edad($persona['clte_f_nac']))));
				
				$data_insert['fsm_f_nac']=$persona['clte_f_nac'];
				$data_insert['fsm_genero']=$persona['clte_genero_cve'];
				$data_insert['emp_id'] = $persona['emp_id'];
				$data_insert['suc_id'] = $persona['suc_id'];               
                $data_insert['serv_id']  = '';
                $data_insert['usr_id']  = $user['usr_id'];
                $data_insert['fsm_f']   =  date("Y-m-d H:i:s");
				
				$data_insert['fsm_f_y']   =  date("Y");
				$data_insert['fsm_f_m']   =  date("m");
				$data_insert['fsm_f_d']   =  date("d");
				$data_insert['fsm_f_h']   =  date("H");
				$data_insert['fsm_f_i']   =  date("i");
								
				$data_insert['med_id'] = $this->input->post('medico');				
				$medico = $this->medico->get($data_insert['med_id']);				
				$data_insert['fsm_area'] = $this->input->post('area');
				$data_insert['fsm_turno'] = $this->input->post('turno');
				$data_insert['fsm_antiguedad'] = $this->input->post('antiguedad'); 
				
				$data_insert['fsm_cronicodegenerativas'] = $this->input->post('cronicodegenerativas');
				$data_insert['fsm_imc'] = $this->input->post('imc');
				$data_insert['fsm_agudeza_visual'] = $this->input->post('agudeza_visual');
				$data_insert['fsm_daltonismo'] = $this->input->post('daltonismo');
				$data_insert['fsm_audicion'] = $this->input->post('audicion');	
				$data_insert['fsm_aptitud'] = $this->input->post('aptitud');
				$data_insert['fsm_enfermendad'] = $this->input->post('enfermendad');
				$data_insert['fsm_observaciones'] = $this->input->post('observaciones');				

				$data_insert['fsm_med_nombre'] = $medico['usr_nombre'].' '.$medico['usr_paterno'].' '.$medico['usr_materno'];
				$data_insert['fsm_med_cedula'] =$medico['usr_cedula'];
				$data_insert['fsm_med_carrera'] =$medico['usr_carrera'];
				$data_insert['fsm_med_escuela'] =$medico['usr_institucion'];
				
				$data_insert['log_insrt_f']   =  date("Y-m-d H:i:s");
				$data_insert['log_insrt_usr_cve']  = $user['usr_id'];
				$data_insert['log_updt_f']   =  date("Y-m-d H:i:s");
				$data_insert['log_updt_usr_cve']  = $user['usr_id']; 
			
				if ($this->salud_ocupacional->insert_ISOEXI(array_to_upper($data_insert)))
                {					
                    send_json_ok('Se registro de forma correcta.');
                }
                else
                {
                    send_json_error('Ocurrió un error al registrar.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
            $this->load->helper('template');
            $params_view = array(
                'title' => '',
                'view' => 'examen/salud_ocupacional/nuevo_form_ISOEXI',
                'view_data' => $data 
               );
            render_template($params_view);
        }
    }


	public function editar_ISOEXI($cliente_id, $fsm_id)
    {
        $persona = $this->cliente->get($cliente_id);
		$data['fsm'] = $this->salud_ocupacional->get_ISOEXI($fsm_id);		
        $user = $this->session->user;

        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');

            if(true)
            {
			/*	$data_insert['clte_id'] = $persona['clte_id'];
				$data_insert['fsm_edad']=intval(trim(str_replace("años", "",get_edad($persona['clte_f_nac']))));
				
				$data_insert['fsm_f_nac']=$persona['clte_f_nac'];
				$data_insert['fsm_genero']=$persona['clte_genero_cve'];
				$data_insert['emp_id'] = $persona['emp_id'];
				$data_insert['suc_id'] = $persona['suc_id'];               
                $data_insert['serv_id']  = '';
                $data_insert['usr_id']  = $user['usr_id'];
                $data_insert['fsm_f']   =  date("Y-m-d H:i:s");
				
				$data_insert['fsm_f_y']   =  date("Y");
				$data_insert['fsm_f_m']   =  date("m");
				$data_insert['fsm_f_d']   =  date("d");
				$data_insert['fsm_f_h']   =  date("H");
				$data_insert['fsm_f_i']   =  date("i");
			*/					
				$data_insert['med_id'] = $this->input->post('medico');				
				$medico = $this->medico->get($data_insert['med_id']);				
				$data_insert['fsm_area'] = $this->input->post('area');
				$data_insert['fsm_turno'] = $this->input->post('turno');
				$data_insert['fsm_antiguedad'] = $this->input->post('antiguedad'); 
				
				$data_insert['fsm_cronicodegenerativas'] = $this->input->post('cronicodegenerativas');
				$data_insert['fsm_imc'] = $this->input->post('imc');
				$data_insert['fsm_agudeza_visual'] = $this->input->post('agudeza_visual');
				$data_insert['fsm_daltonismo'] = $this->input->post('daltonismo');
				$data_insert['fsm_audicion'] = $this->input->post('audicion');	
				$data_insert['fsm_enfermendad'] = $this->input->post('enfermendad');
				$data_insert['fsm_aptitud'] = $this->input->post('aptitud');				
				$data_insert['fsm_observaciones'] = $this->input->post('observaciones');				

				$data_insert['fsm_med_nombre'] = $medico['usr_nombre'].' '.$medico['usr_paterno'].' '.$medico['usr_materno'];
				$data_insert['fsm_med_cedula'] =$medico['usr_cedula'];
				$data_insert['fsm_med_carrera'] =$medico['usr_carrera'];
				$data_insert['fsm_med_escuela'] =$medico['usr_institucion'];
				
				$data_insert['log_updt_f']   =  date("Y-m-d H:i:s");
				$data_insert['log_updt_usr_cve']  = $user['usr_id']; 
				$data_insert=array_to_upper($data_insert);
				if ($this->salud_ocupacional->update_ISOEXI($fsm_id,$data_insert))
                {					
                    send_json_ok('Se actualizo el registro en forma correcta.');
                }
                else
                {
                    send_json_error('Ocurrió un error al actualizar el registro.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
            $this->load->helper('template');
            $params_view = array(
                'title' => '',
                'view' => 'examen/salud_ocupacional/edit_ISOEXI',
                'view_data' => $data 
               );
            render_template($params_view);
        }
    }

	
   public function borra_ISOEXI($fsm_id)
    {
        if($this->salud_ocupacional->borra_ISOEXI($fsm_id))
        {
            send_json_ok('Se eliminó de forma correcta el registro.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar el registro.');
        }
    }

    public function pdf_ISOEXI($cliente_id, $fsm_id)
    {
		$user = $this->session->user;
		
        $data['persona'] = $this->cliente->get($cliente_id,get_desp_id_usr());
        $data['fsm'] = $this->salud_ocupacional->get_ISOEXI($fsm_id);
        $data['medico'] = $this->medico->get_id($data['fsm']['med_id']);
        $data['empresa'] = $this->cliente->get_empresa_by_id($data['fsm']['emp_id']);
        $reporte=$user['usr_id'].'_'.$data['fsm']['emp_id'].'_'.date("Ymd_His");
		$this->load->helper('pdf');
		$ruta=base_url('../dist/images/hclogo.jpg');
		genera_pdf_receta($this->load->view('examen/salud_ocupacional/pdf_ISOEXI',$data,TRUE),$reporte,$user['usr_id'],'fsm773','Humancenter Review S.A de C.V.','P',$ruta);

	}


}