<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Entorno_serviseg extends CI_Controller {
    function __construct() {
        parent::__construct();
        $this->load->model('persona/Persona_model','cliente');
		/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
		$this->load->model('servicio/Servicio_model','servicio');
		/*************************************************/			
        $this->load->model('examen/Entorno_serviseg_model','entorno_social');
		$this->load->helper('util'); 
    }
    
    public function nuevo($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
        $medico = $this->session->user;
        $empresa = $this->cliente->get_empresa_by_clte($cliente_id);

        if(isset($_POST) && count($_POST) > 0)  
        {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('descripción','Descripción','required');
		    //$this->form_validation->set_rules('foto_1','Foto','required');
            
            if($this->form_validation->run())
            {
                $data_insert['clte_id'] = $persona['clte_id'];
                $data_insert['usr_id'] = $medico['usr_id'];
                $data_insert['emp_id'] = $empresa['emp_id'];
				
				
                $data_insert['motivo'] = $this->input->post('descripción');
				$data_insert['fecha_eval'] = $this->input->post('fecha_eval');		
				$data_insert['log_insrt_f']  =  date('Y-m-d H:i:s');
				$data_insert['log_updt_f']= $data_insert['log_insrt_f'];
				$data_insert = array_to_upper($data_insert);
				$this->load->library('upload');
				sleep(1);
                if(!empty($_FILES['doc']['name']))
                {   
                    
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/fotos/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg',
                            'max_size'      => '25000'
                    );

                    $this->upload->initialize($config);
					
                    if ( ! $this->upload->do_upload('doc'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_insert['clte_path_foto_1'] = $data['file_name'];
						
                    }
                }				
				
				
               
                

                
                $this->db->trans_start();
                $fsm_id = $this->entorno_social->add($data_insert);
                if ($fsm_id)
                {
                    send_json_ok('Se insertó de forma correcta TODOS LOS DATOS');
                }
                else
                {
                    send_json_error('Ocurrió un error al insertar.');
                }
                $this->db->trans_complete();
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
            $data['medico'] = $medico;
            $data['empresa'] = $empresa;
            $this->load->helper('template');
            $params_view = array(
                'title' => '',
                'view' => 'examen/entorno_serviseg/add',
                'view_data' => $data 
               );
            render_template($params_view);
        }
    }
    

    
    public function pdf($cliente_id, $fsm_id)
    {
        $this->load->model('empleado/Empleado_model','empleado');
        $this->load->helper('util');
		
		
        $persona = $this->cliente->get($cliente_id,get_desp_id_usr());    
		
        
		$data['imagenes'] = $this->entorno_social->get_imagenes($cliente_id);
        
        $data['persona'] = $persona;
        $data['medico'] = $medico;
        $data['empresa'] = $empresa;
        
        $this->load->helper('pdf');
        genera_pdf($this->load->view('examen/entorno_serviseg/pdf',$data,TRUE),'imagenes','imagenes','imagenes');
    }
    

    
    public function borra_imagen($fsm_id, $img_id)
    {
        if($this->entorno_social->delete_imagen($fsm_id,$img_id))
        {
            send_json_ok('Se eliminó de forma correcta.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar.');
        }
    }
    
    
 
}