﻿<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Sociolaboral extends CI_Controller {
    function __construct() {
        parent::__construct();
        $this->load->model('persona/Persona_model','cliente');
		/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
		$this->load->model('servicio/Servicio_model','servicio');
		/*************************************************/			
        $this->load->model('examen/Sociolaboral_model','sociolaboral');
		$this->load->helper('util');
    }
    
    public function nuevo($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
        $medico = $this->session->user;
        $empresa = $this->cliente->get_empresa_by_clte($cliente_id);

        if(isset($_POST) && count($_POST) > 0)  
        {
            $this->load->library('form_validation');
			/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
			if (($persona['serv_id'] == 0) ||(get_status_serv($persona['serv_id']) != 'PROCESO'))
			{					
					$this->form_validation->set_rules('servicio','Orden de servicio','required');
			}
			else
			{
					$this->form_validation->set_rules('servicio','Orden de servicio','integer');
			}
            /*************************************************/ 
            
            if($this->form_validation->run())
            {
                //para los socieconomicos
                $data_insert['clte_id'] = $persona['clte_id'];
                $data_insert['usr_id'] = $medico['usr_id'];
                $data_insert['emp_id'] = $empresa['emp_id'];
				/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
				if (($persona['serv_id'] == 0) || (get_status_serv($persona['serv_id']) != 'PROCESO'))
				{	
						$data_insert['serv_id']  = $this->input->post('servicio');
				}
				else
				{	
						$data_insert['serv_id']  = $persona['serv_id'];
				}
				/**************************************************/
                $data_insert['fsm_f'] = formatea_fecha_mysql($this->input->post('fecha'));
                $data_insert['fsm_solicito']  = $this->input->post('solicito');
                $data_insert['idioma'] = $this->input->post('idioma');
                $data_insert['fsm_valido']  = $this->input->post('valido');
                $data_insert['fsm_puesto'] = $this->input->post('puesto');
                $data_insert['fsm_emp'] = $this->input->post('emp');
                $data_insert['fsm_res_area_soc_cve'] = $this->input->post('social'); 
                $data_insert['fsm_res_area_esc_cve'] = $this->input->post('escolar'); 
                $data_insert['fsm_res_area_lab_cve'] = $this->input->post('laboral'); 
                
                $data_insert['fsm_recomendacion_cve'] = $this->input->post('recomendacion'); 
				$data_insert['fsm_apto_v_documentos'] = $this->input->post('fsm_apto_v_documentos');
				$data_insert['fsm_apto_v_academicos'] = $this->input->post('fsm_apto_v_academicos');
				$data_insert['fsm_apto_v_personales'] = $this->input->post('fsm_apto_v_personales');
				$data_insert['fsm_apto_v_laboral'] = $this->input->post('fsm_apto_v_laboral');

                $data_insert['fsm_estatus'] = 'CAP';
                $data_insert['fsm_empresa'] = $this->input->post('empresa');
                $data_insert['fsm_valido'] = $this->input->post('valido');
                $data_insert['fsm_evaluador'] = $this->input->post('evaluador');
				$data_insert['log_insrt_f']  =  date('Y-m-d H:i:s');
				$data_insert['log_insrt_usr_cve']  =  $medico['usr_username'];
				$data_insert['log_insrt_prg']  =  'CREADO';
				
                if($this->input->post('curp') != '' || $this->input->post('nss') != ''){
                    $data_update_clte['clte_curp_crypt'] =  $this->input->post('curp');
                    $data_update_clte['clte_nss_crypt'] =  $this->input->post('nss');
                    $this->cliente->actualiza($cliente_id, array_to_upper($data_update_clte));
                }

                $data_insert = array_to_upper($data_insert);
				$data_insert['fsm_res_obs'] = $this->input->post('obs'); 
				
                if($this->input->post('firma') != '')
                {
                    $data_insert['fsm_firma_eval'] = $this->input->post('firma');
                }
                
                $this->db->trans_start();
                $fsm_id = $this->sociolaboral->add($data_insert);
                if($fsm_id)
                {
                    /*referencias personales*/
                    $this->sociolaboral->insert_arreglo($this->input->post('refper'), 'ref_nombre', $fsm_id, 'fsm_sociolab_ref');
                    /*antecedentes laborales*/
                    $this->sociolaboral->insert_arreglo($this->input->post('antlab'), 'antlab_empresa', $fsm_id, 'fsm_sociolab_antlab');
                    /*empleos*/
                    $this->sociolaboral->insert_arreglo($this->input->post('empleo'), 'empleo_empresa', $fsm_id, 'fsm_sociolab_empleos');                   
                    //send_json_ok('Se guardó de forma correcta');
					send_json_ok(array('msg' =>'Se guardó de forma correcta.', 'id' => $cliente_id));
					/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
					$servicios=$persona['domserv'];					
					
					$servicio='SOCLAB;'; /*CODIGO DEL EXAMEN*/
					if (!(strstr($servicios,$servicio)))
					{							
						$servicios.=$servicio;
						$data_clte['domserv']=$servicios;
						$res=$this->cliente->actualiza_registro_individual($cliente_id, $data_clte);
					}
					/**************************************************/					
                }
                else
                {
                    send_json_error('Ocurrió un error al actualizar.');
                }
                $this->db->trans_complete();
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
        
            $data['persona'] = $persona;
            $data['medico'] = $medico;
            $data['empresa'] = $empresa;
			/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
			$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);
			/**************************************************/			
            $this->load->helper('template');
            $params_view = array(
                'title' => '',
                'view' => 'examen/sociolaboral/nuevo_form',
                'view_data' => $data 
               );
            render_template($params_view);
        }
    }

    public function edita($cliente_id, $fsm_id)
    {
        $persona = $this->cliente->get($cliente_id);
        $medico = $this->session->user;
        $empresa = $this->cliente->get_empresa_by_clte($cliente_id);

        if(isset($_POST) && count($_POST) > 0)  
        {
            /*$this->load->library('form_validation');
            $this->form_validation->set_rules('servicio','Orden de servicio','required');*/
            
            if(true)
            {
                $data_update['idioma'] = $this->input->post('idioma');
                $data_update['fsm_solicito']  = $this->input->post('solicito');
                $data_update['fsm_valido']  = $this->input->post('valido');
                $data_update['fsm_puesto'] = $this->input->post('puesto');
                $data_update['fsm_emp'] = $this->input->post('emp');
                $data_update['fsm_res_area_soc_cve'] = $this->input->post('social'); 
                $data_update['fsm_res_area_esc_cve'] = $this->input->post('escolar'); 
                $data_update['fsm_res_area_lab_cve'] = $this->input->post('laboral'); 
                $data_update['fsm_apto_v_documentos'] = $this->input->post('fsm_apto_v_documentos');
				$data_update['fsm_apto_v_academicos'] = $this->input->post('fsm_apto_v_academicos');
				$data_update['fsm_apto_v_personales'] = $this->input->post('fsm_apto_v_personales');
				$data_update['fsm_apto_v_laboral'] = $this->input->post('fsm_apto_v_laboral');
                $data_update['fsm_recomendacion_cve'] = $this->input->post('recomendacion'); 
                $data_update['fsm_estatus'] = 'CAP';
                $data_update['fsm_empresa'] = $this->input->post('empresa');
                $data_update['fsm_valido'] = $this->input->post('valido');
                $data_update['fsm_evaluador'] = $this->input->post('evaluador');

				$data_update['no_encuenstador']  =  $this->input->post('cerrar_encuesta');
				$data_update['entorno_envia'] = $this->input->post('entorno_envia');

                if($this->input->post('curp') != '' || $this->input->post('nss') != ''){
                    $data_update_clte['clte_curp_crypt'] =  $this->input->post('curp');
                    $data_update_clte['clte_nss_crypt'] =  $this->input->post('nss');
                    $this->cliente->actualiza($cliente_id, array_to_upper($data_update_clte));
                }

                $data_update = array_to_upper($data_update);
				$data_update['fsm_res_obs'] = $this->input->post('obs'); 
				
				

                if($this->input->post('firma') != '')
                {
                    $data_update['fsm_firma_eval'] = $this->input->post('firma');
                }
                
                $this->db->trans_start();
                $fsm_id_up = $this->sociolaboral->update($fsm_id,$data_update);
                if($fsm_id_up)
                {
                    /*referencias personales  */
                    $this->sociolaboral->update_arreglo($this->input->post('refper'), 'ref_nombre', $fsm_id, 'fsm_sociolab_ref');
                    /*antecedentes laborales*/
                    $this->sociolaboral->update_arreglo($this->input->post('antlab'), 'antlab_empresa', $fsm_id, 'fsm_sociolab_antlab');
                    /*empleos*/
                    $this->sociolaboral->update_arreglo($this->input->post('empleo'), 'empleo_empresa', $fsm_id, 'fsm_sociolab_empleos');                   
                    //send_json_ok('Se actualizó de forma correcta');
					send_json_ok(array('msg' =>'Se actualizó de forma correcta', 'id' => $cliente_id));
                }
                else
                {
                    send_json_error('Ocurrió un error al actualizar.');
                }
                $this->db->trans_complete();
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
            $data['medico'] = $medico;
            $data['empresa'] = $empresa;
            $data['fsm'] = $this->sociolaboral->get($fsm_id);

            $data['refper'] = $this->sociolaboral->get_data('fsm_sociolab_ref',$fsm_id);             //documentos
            $data['antlab'] = $this->sociolaboral->get_data('fsm_sociolab_antlab',$fsm_id);          //situacion academica
            $data['empleos'] = $this->sociolaboral->get_data('fsm_sociolab_empleos',$fsm_id);        //familiares

            $this->load->helper('template');
            $params_view = array(
                'title' => '',
                'view' => 'examen/sociolaboral/edita_form',
                'view_data' => $data 
               );
            render_template($params_view);
        }
    }
        
    public function pdf($cliente_id, $fsm_id)
    {
        $this->load->model('empleado/Empleado_model','empleado'); 
        
        $persona = $this->cliente->get($cliente_id,get_desp_id_usr());
        $data['fsm'] = $this->sociolaboral->get($fsm_id,get_desp_id_usr());
        $medico = $this->empleado->get_id($data['fsm']['usr_id']);
        $empresa = $this->cliente->get_empresa_by_id($data['fsm']['emp_id']);
        
        
        $data['refper'] = $this->sociolaboral->get_data('fsm_sociolab_ref',$fsm_id);             //documentos
        $data['antlab'] = $this->sociolaboral->get_data('fsm_sociolab_antlab',$fsm_id);          //situacion academica
        $data['empleos'] = $this->sociolaboral->get_data('fsm_sociolab_empleos',$fsm_id);        //familiares
        
        $data['persona'] = $persona;
        $data['medico'] = $medico;
        $data['empresa'] = $empresa;
        $this->load->helper('pdf');
		
		$evaluado= $data['persona']['clte_nombre'].' ';
		if ( strlen($data['persona']['clte_2_nombre']) > 0)
		{
			$evaluado= $evaluado.$data['persona']['clte_2_nombre'].' ';
		}
		$evaluado= $evaluado.$data['persona']['clte_paterno'].' ';			
		$evaluado= $evaluado.$data['persona']['clte_materno'].' ';
		genera_pdf_new_reporte_poli($this->load->view('examen/sociolaboral/pdf',$data,TRUE),'estudio_sociolaboral','estudio_sociolaboral',$evaluado);
       // genera_pdf_ma($this->load->view('examen/sociolaboral/pdf',$data,TRUE),'estudio_sociolaboral','estudio_sociolaboral');
    }

    public function borra_sociolaboral($fsm_id)
    {
        if($this->sociolaboral->delete_sociolaboral($fsm_id))
        {
            send_json_ok('Se eliminó de forma correcta.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar.');
        }
    }


    public function elimina($mapeo,$fsm_id, $id )
    {
        $array_tablas = array(
            'refper' => 'fsm_sociolab_ref',
            'antlab' => 'fsm_sociolab_antlab',
            'empleo' => 'fsm_sociolab_empleos'
        );

        if($this->sociolaboral->delete_tabla($fsm_id,$id,$array_tablas[$mapeo]))
        {
            send_json_ok('Se eliminó de forma correcta.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar.');
        }
    }
}