﻿<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Servicio extends CI_Controller {
    
    function __construct() {
        parent::__construct();
		$this->load->model('util/Agenda_model','agenda');
        $this->load->model('persona/Persona_model','cliente');
        $this->load->model('servicio/Servicio_model','servicio');
		$this->load->model('empleado/Empleado_model','medico');
		$this->load->helper('util');
		$this->load->helper('catalogo');
		$this->load->helper('edo');		
    }
 
     public function edita_s($serv_id)
    {
       $servicio = $this->servicio->get($serv_id);	     
	   $medico = $this->session->user;
	   $usuario = $this->medico->get($medico['usr_id']);
       //echo 'A';
	   if(isset($_POST) && count($_POST) > 0)     
        {	$continuar=1;
            
            $this->load->library('form_validation');
			
			if (
				( ($servicio['serv_estatus_cve'] == 'CONCLUIDO') && ($medico['usr_id'] != 261) )
				/* ||
				( ($servicio['serv_estatus_cve'] == 'PREPAGADO') && ($servicio['serv_factura_path'] == '') &&  ($servicio['serv_xml_path'] == '') )
 			    */
			    )
			{
				$this->form_validation->set_rules('cantidad_facturada','Cantidad Facturada (sin iva)','required');
				$this->form_validation->set_rules('estatus','Estatus','required');
			}
			elseif ($servicio['serv_estatus_cve'] == 'FIN') 
			{
				$this->form_validation->set_rules('estatus','Estatus','required');
			}				
			else
			{	
				$this->form_validation->set_rules('orden','Pedido','required');
				//$this->form_validation->set_rules('emp_id','Empresa','required');
				$this->form_validation->set_rules('f_ini','Fecha inicio','required');
				//$this->form_validation->set_rules('h_ini','Hora inicio','required');
				$this->form_validation->set_rules('f_fin','Fecha fin','required');
				//$this->form_validation->set_rules('h_fin','Hora fin','required');
				$this->form_validation->set_rules('descrip','Descripción','required');
				//$this->form_validation->set_rules('ubicacion','Ubicación','required');
				//$this->form_validation->set_rules('responsable','Responsable','required');
				$this->form_validation->set_rules('estatus','Estatus','required');
			}

            if($this->form_validation->run())
            {
               
				$hoy='';
				$factudado=0;
				
				if 	(					
						($servicio['serv_estatus_cve'] == 'PREPAGADO') 
						&&
						(!empty($_FILES['factura']['name']))
						&&
						(!empty($_FILES['xml']['name']))
					)
				{
					
					$data_serv['serv_cantidad_facturada'] = $this->input->post('cantidad_facturada');
					$data_serv['serv_quien_factura'] = $medico['usr_nombre'].' '.$medico['usr_paterno'];
					$data_serv['serv_fecha_factura'] = date("Y-m-d H:i:s");
					$data_serv['serv_estatus_cve'] = $this->input->post('estatus');
					$data_serv['serv_f_inicio'] = $fecha_ini=$servicio['serv_f_inicio'];
					$data_serv['serv_f_fin'] = $fecha_fin=$servicio['serv_f_inicio'];
					
					//$hoy='HC_'.$servicio['emp_id'].'_'.date("dmY_His").'_';
					$data_serv['serv_ubicacion'] = $servicio['serv_ubicacion'];
					if(!empty($_FILES['factura']['name']))
					{
						$nombre_anexo=$_FILES['factura']['name'];
						$this->load->library('upload');
						$filename = md5(time());
						$config = array(
								'upload_path'   => './../../files/facturas/',
								'overwrite'     => TRUE,
								'file_name'     => $filename,
								'allowed_types' => 'pdf',
								'max_size'      => '10000'
						);

						$this->upload->initialize($config);
						if ( ! $this->upload->do_upload('factura'))
						{
							echo json_encode(array('status' => 'error','content' => $this->upload->display_errors()));
							exit;
						}
						else 
						{
							$data = $this->upload->data();
							$data_serv['serv_factura_nombre'] = $data['file_name'];
							$data_serv['serv_factura_path '] = $nombre_anexo;
							$factudado++;
						}
					}
					

					if(!empty($_FILES['xml']['name']))
					{
						$nombre_anexo=$_FILES['xml']['name'];
						$this->load->library('upload');
						$filename = md5(time());
						$config = array(
								'upload_path'   => './../../files/facturas/',
								'overwrite'     => TRUE,
								'file_name'     => $filename,
								'allowed_types' => 'xml',
								'max_size'      => '10000'
						);

						$this->upload->initialize($config);
						if ( ! $this->upload->do_upload('xml'))
						{
							echo json_encode(array('status' => 'error','content' => $this->upload->display_errors()));
							exit;
						}
						else 
						{
							$data = $this->upload->data();
							$data_serv['serv_xml_nombre'] = $data['file_name'];
							$data_serv['serv_xml_path '] = $nombre_anexo;
							$factudado++;
						}
					}					
					
					
				}
				elseif ($servicio['serv_estatus_cve'] == 'CONCLUIDO') 
				{
					
					$data_serv['serv_cantidad_facturada'] = $this->input->post('cantidad_facturada');
					$data_serv['serv_quien_factura'] = $medico['usr_nombre'].' '.$medico['usr_paterno'];
					$data_serv['serv_fecha_factura'] = date("Y-m-d H:i:s");
					$data_serv['serv_estatus_cve'] = $this->input->post('estatus');
					$data_serv['serv_f_inicio'] = $fecha_ini=$servicio['serv_f_inicio'];
					$data_serv['serv_f_fin'] = $fecha_fin=$servicio['serv_f_inicio'];
					
					//$hoy='HC_'.$servicio['emp_id'].'_'.date("dmY_His").'_';
					$data_serv['serv_ubicacion'] = $servicio['serv_ubicacion'];
					if(!empty($_FILES['factura']['name']))
					{
						$nombre_anexo=$_FILES['factura']['name'];
						$this->load->library('upload');
						$filename = md5(time());
						$config = array(
								'upload_path'   => './../../files/facturas/',
								'overwrite'     => TRUE,
								'file_name'     => $filename,
								'allowed_types' => 'pdf',
								'max_size'      => '10000'
						);

						$this->upload->initialize($config);
						if ( ! $this->upload->do_upload('factura'))
						{
							echo json_encode(array('status' => 'error','content' => $this->upload->display_errors()));
							exit;
						}
						else 
						{
							$data = $this->upload->data();
							$data_serv['serv_factura_nombre'] = $data['file_name'];
							$data_serv['serv_factura_path '] = $nombre_anexo;
							$factudado++;
						}
					}
					

					if(!empty($_FILES['xml']['name']))
					{
						$nombre_anexo=$_FILES['xml']['name'];
						$this->load->library('upload');
						$filename = md5(time());
						$config = array(
								'upload_path'   => './../../files/facturas/',
								'overwrite'     => TRUE,
								'file_name'     => $filename,
								'allowed_types' => 'xml',
								'max_size'      => '10000'
						);

						$this->upload->initialize($config);
						if ( ! $this->upload->do_upload('xml'))
						{
							echo json_encode(array('status' => 'error','content' => $this->upload->display_errors()));
							exit;
						}
						else 
						{
							$data = $this->upload->data();
							$data_serv['serv_xml_nombre'] = $data['file_name'];
							$data_serv['serv_xml_path '] = $nombre_anexo;
							$factudado++;
						}
					}					
					
					
				}
				else
				{			   
					$fecha_ini = $this->input->post('f_ini').' '.formatea_hora_mysql($this->input->post('h_ini'));
					$fecha_fin = $this->input->post('f_fin').' '.formatea_hora_mysql($this->input->post('h_fin'));					
					$data_serv['serv_orden'] = $this->input->post('orden');
					$data_serv['serv_f_inicio'] = $fecha_ini;
					$data_serv['serv_f_fin'] = $fecha_fin;
					$data_serv['serv_desc'] = $this->input->post('descrip');
					$data_serv['serv_ubicacion'] = $this->input->post('ubicacion');
					$data_serv['serv_contacto_per'] = $this->input->post('responsable');
					$data_serv['serv_contacto_tel'] = limpia_telefono($this->input->post('telefono'));
					$data_serv['serv_acuerdos'] = $this->input->post('clausulas');                
					$data_serv['serv_estatus_cve'] = $this->input->post('estatus');
					$data_serv['cei_id'] = $this->input->post('cei');
					$data_serv['cei_control_id'] = $this->input->post('cei_control');
					$data_serv['reclutador'] = $this->input->post('reclutador');					
					
					$data_serv['serv_viaticos'] = $this->input->post('viaticos');
					
					if ( $data_serv['serv_viaticos'] == 0)
					{
						$data_serv['serv_costo_viaticos'] = 0.00;
					}
					else
					{	
						$data_serv['serv_costo_viaticos'] = $this->input->post('gastos_operacion');
					}
					
					$data_serv=array_to_upper($data_serv);
				}				
				
	
			

				if ($servicio['cal_id'] > 0)
				{
					$evento = $this->agenda->get_evento($servicio['cal_id']);				
					
					$evento['serv_orden']=$data_serv['serv_orden'];
					
					$evento['cal_fecha_ini']=$data_serv['serv_f_inicio'] = $fecha_ini;
					$evento['cal_fecha_fin']=$data_serv['serv_f_fin'] = $fecha_fin;
					
					$evento['cal_descripcion'] = $this->input->post('descrip');
					
					if (strlen($data_serv['serv_anexo_path'])>0)
					{	
					$evento['cal_anexo_path']=$data_serv['serv_anexo_path'];
					$evento['cal_anexo_nombre']=$data_serv['serv_anexo_nombre'];
					}
					if (strlen($data_serv['serv_anexo1_path'])>0)
					{
					$evento['cal_anexo1_path']=$data_serv['serv_anexo1_path'];
					$evento['cal_anexo1_nombre']=$data_serv['serv_anexo1_nombre'];
					}
					if (strlen($data_serv['serv_anexo2_path'])>0)
					{
					$evento['cal_anexo2_path']=$data_serv['serv_anexo2_path'];
					$evento['cal_anexo2_nombre']=$data_serv['serv_anexo2_nombre'];	
					}
					if (strlen($data_serv['serv_anexo3_path'])>0)
					{
					$evento['cal_anexo3_path']=$data_serv['serv_anexo3_path'];
					$evento['cal_anexo3_nombre']=$data_serv['serv_anexo3_nombre'];	
					}
					if (strlen($data_serv['serv_anexo4_path'])>0)
					{
					$evento['cal_anexo4_path']=$data_serv['serv_anexo4_path'];
					$evento['cal_anexo4_nombre']=$data_serv['serv_anexo4_nombre'];
					}
				}			
				
				if  (
					  ($servicio['serv_estatus_cve'] == 'CONCLUIDO') &&
					  ($factudado>1)
					)
				{
					$data_serv['serv_estatus_cve'] ='FIN';
					$data_serv['cei_id']=$servicio['cei_id'];
					$data_serv['cei_control_id']=$servicio['cei_control_id'];
					
				}
				elseif  (
					  ($servicio['serv_estatus_cve'] == 'CONCLUIDO') &&
					  ($factudado<2)
					)
				{
					$continuar=0;
				}	
				
				if  ($servicio['serv_estatus_cve'] == 'FIN') 
				{				
					if ($this->input->post('pagado') == 'SI')
					{
						$data_serv['serv_estatus_cve'] ='PAGADO';
						$data_serv['serv_fecha_pago'] =date("Y-m-d H:i:s");
						$data_serv['cei_control_id']=$servicio['cei_control_id'];
						$data_serv['serv_ubicacion'] = $servicio['serv_ubicacion'];
					}	
					
					$data_serv['cei_id']=$servicio['cei_id'];
				}
				
				
				if (($continuar==0)  && ($medico['usr_id'] == 261))
				{
					$continuar=1;
				}
				
				if ($continuar==1)
				{
					if ($this->servicio->update($serv_id,$data_serv))
					{					
						if ($servicio['cal_id'] > 0)
						{
							$cal_id = $this->agenda->update_evento($servicio['cal_id'],$evento);
						
						}		
						
						//inserta las obervaciones
						if($this->input->post('obervaciones') != '')
						{
							$data_serv_obs['serv_id'] = $serv_id;
							$data_serv_obs['usr_id'] = $medico['usr_id'];
							$data_serv_obs['nota_f'] = date('Y-m-d H:i:s');
							$data_serv_obs['nota_descripcion'] = $this->input->post('obervaciones');
							$this->servicio->inserta_nota(array_to_upper($data_serv_obs));
						}
						
						/*************************************************************************************/                   
						/*                  Nueva estructura para examenes y paquetes asignados              */					
						/*************************************************************************************/   
						
						if 
						(
							($data_serv['serv_estatus_cve'] == 'PROCESO')
						)
						{
							$this->servicio->delete_examenes($serv_id);	
							
							$serv_emp=$this->servicio->get_serv_emp($serv_id);
											
							$fsm_pakts= get_costos_paquetes_empresa($serv_emp['emp_id']);
							
							$total_examenes_selectos= $this->input->post('total_examenes_selectos');	

							
							if($fsm_pakts):
								$paquetes='';
								foreach($fsm_pakts as $fsm_pakt): 
											
										for($i=1; $i <= $total_examenes_selectos; $i++)
										{	
											
											$indice='examen_select_pkt_'.strval($i);
											$cost_id = $this->input->post($indice);	
												
											if ( $fsm_pakt['cost_id'] === $cost_id)
											{
												$examen_ins['exam_nombre_pkt'] = $fsm_pakt['cost_nombre_pkt']; //nombre del paquete
												$examen_ins['serv_id'] = $serv_id;
												$examen_ins['exam_cve'] = $fsm_pakt['cost_examen_cve']; //lo que contiene el paquete
												$paquetes.=$fsm_pakt['cost_nombre_pkt'].';';
												$examen_ins['exam_monto'] = $fsm_pakt['cost_monto']; //lo que cuesta el paquete								 	 
												$examen_ins['exam_cantidad'] = 1;
												$examen_ins['exam_estatus_cve'] = 'PEND';
												$examen_ins['exam_tipo_pkt'] = $fsm_pakt['cost_tipo_pkt'];
												$this->servicio->inserta_examen($examen_ins);
												//$i=$total_examenes_selectos+1;
											}										
											
										}	
								endforeach;
							endif;
							$evento['cal_pkts']=$paquetes;
						}
							
						if ($servicio['cal_id'] > 0)
						{
							$cal_id = $this->agenda->update_evento($servicio['cal_id'],$evento);
						
						}

	/*************************************************************************************/                   
	/*                  Solo en caso de concluir la orden de servicios                   */					
	/*************************************************************************************/   

						if  (($data_serv['serv_estatus_cve'] == 'CONCLUIDO') ||
							 ($data_serv['serv_estatus_cve'] == 'FTIEMPOCON'))
						{
							$this->load->helper('mail');
							$data_email['serv'] = $this->servicio->get($serv_id);
							$data_email['personas'] = $this->servicio->get_examenes_serv($serv_id);
							$data_email['clientes'] = $this->servicio->get_examenes_serv($serv_id);
							$html = $this->load->view('servicio/email_service_special_concluido',$data_email,TRUE);

							$servicior = $this->servicio->get($serv_id);
							send_mail_service_concluido($servicior, $html,$this->input->post('cei') );
						}
	/*************************************************************************************/ 

	/*************************************************************************************/                   
	/*                  Solo en caso de Facturar la orden de servicios                   */					
	/*************************************************************************************/ 
						if  ($data_serv['serv_estatus_cve'] == 'FIN')
						{
							$this->load->helper('mail');
							$data_email['serv'] = $this->servicio->get($serv_id);
							$data_email['personas'] = $this->servicio->get_examenes_serv($serv_id);
							$data_email['clientes'] = $this->servicio->get_examenes_serv($serv_id);
							$data_email['emp_id'] = $this->input->post('emp_id');							
							$html = $this->load->view('agenda/email_service_facturado',$data_email,TRUE);
							$servicior = $this->servicio->get($serv_id);
							send_mail_service_facturado($servicior, $html,$this->input->post('cei') );
						
						}
	/*************************************************************************************/ 	
						send_json_ok('Se actualizó de forma correcta');
					}
					else
					{
						send_json_error('Ocurrió un error al actualizar el servicio.');
					}
				
				}
				else
				{
					
					send_json_error('Ocurrió un error, faltan los archivos de facturación.');
				}	
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['serv'] = $servicio;
            //echo 'B';
            $data['examenes'] = $this->servicio->get_examenes($serv_id);
			//echo 'C';
            $data['notas'] = $this->servicio->get_notas($serv_id);
			//echo 'D';
            $data['anexos'] = $this->servicio->get_anexos($serv_id);
			 $data['usuario'] =$usuario;
            //echo 'E';
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Servicios',
                'view' => 'servicio/edit_s',
                'view_data' => $data
               );
			//echo 'F';
            render_template($params_view);  
        }
    }
 
 
 
     public function index()
    {   	

		$user = $this->session->user; 
		$medico = $this->medico->get($user['usr_id']);
		$usuario = $this->medico->get($user['usr_id']);
		$user_root4=get_my_user_root4();
		$n=get_desp_id_usr();		
		
        $rows = 30;
        $this->load->library('pagination');
        $config['base_url'] = base_url('servicio/index/');
		
        
		/*if (($user['usr_id'] == 736) || ($user['usr_id'] == 737))
		{
			$gss=array(242,95,92,124);
			$config['total_rows'] = $this->servicio->count_all_empresas_asig($gss);
		}
		elseif (($user['usr_id'] == 589) || ($user['usr_id'] == 590) || ($user['usr_id'] == 591))
		{
			$gss=array(242,95,92);
			$config['total_rows'] = $this->servicio->count_all_empresas_asig($gss);
		}
		elseif ($user['usr_id'] == 510) 
		{
			$cometra=array(93,174,175,150,129,30);
			$config['total_rows'] = $this->servicio->count_all_empresas_asig($cometra);
		}elseif ($user_root4 == 5)
		{
			$config['total_rows'] = $this->servicio->count_all_emp_asig($medico['usr_emp_asig'],$n);			
		}
		elseif ($user_root4 == 6)
		{
			$config['total_rows'] = $this->servicio->count_all_empresas_gsi();
		}
	*/	
		
		if (get_perfil_id()>2) //usuario de cliente
		{
			$config['total_rows'] = $this->servicio->count_all_emp_asignada($usuario['emp_id']);			
		}
		else //usuario humancenter
		{
			$config['total_rows'] = $this->servicio->count_all_empresa();
		}



		
		
		if ( strstr($usuario['portal'],'CORPO') )
		{	
			if ( strstr($usuario['empresas'],'TGSI') )
			{
				$config['total_rows'] = $this->servicio->count_all_empresas_gsi();
			}
			else
			{
				$i=0;
				foreach ( explode(';',$usuario['empresas'] )  as $esta_empresa) 
				{
					if ($esta_empresa > 0)
					{	
						$gss[$i]=$esta_empresa;
						$i++;
					}
				}	
				$config['total_rows'] = $this->servicio->count_all_empresas_asig($gss);
				$data['c_empresas'] = $i; 
			}				
		
		}
		elseif ( strstr($usuario['portal'],'EMPSGSI') )
		{	
			if ( strstr($usuario['empresas'],'TGSI') )
			{
				$config['total_rows'] = $this->servicio->count_all_empresas_gsi();
			}
			else
			{
				$i=0;
				foreach ( explode(';',$usuario['empresas'] )  as $esta_empresa) 
				{
					if ($esta_empresa > 0)
					{	
						$gss[$i]=$esta_empresa;
						$i++;
					}
				}	
				$config['total_rows'] = $this->servicio->count_all_empresas_asig($gss);
				$data['c_empresas'] = $i; 
			}				
		
		}
		
		
		
		
		
		$config['per_page'] = $rows;
        $config['attributes'] = array('class' => 'pagination');
        $config['full_tag_open'] = '<div class="pagination-full">';
        $config['full_tag_close'] = '</div>';
        $config['uri_segment'] = 3;
        $config['query_string_segment'] = 4;
        $config['use_page_numbers'] = TRUE;
        $this->pagination->initialize($config);
            
		/*if (($user['usr_id'] == 736) || ($user['usr_id'] == 737))
		{
			$gss=array(242,95,92,124);
			$data['servicios'] = $this->servicio->get_all_ac_gsi_gss('', $rows,$n);
		}
		elseif (($user['usr_id'] == 589) || ($user['usr_id'] == 590) || ($user['usr_id'] == 591))
		{
			$gss=array(242,95,92);
			$data['servicios'] = $this->servicio->get_all_ac_gsi_gss('', $rows,$n);
		}
		elseif ($user['usr_id'] == 510) 
		{	
			$cometra=array(93,174,175,150,129,30);
			$data['servicios'] = $this->servicio->get_all_ac_gsi_cometra('', $rows,$n);
		}
		elseif ($user_root4 == 5)
		{
			$data['servicios'] =$this->servicio->get_all_ac_gsi('', $rows,$n); 	
		}
		elseif ($user_root4 == 6)
		{
			$data['servicios'] = $this->servicio->get_all_ac_gsi('', $rows,$n); 
		}
		else
		{		
			$data['servicios'] = $this->servicio->get_all_ac('', '', $rows,$n); 
		}	
*/	


		if (get_perfil_id()>2) //usuario de cliente
		{
			$data['servicios'] = $this->servicio->get_empresa_especifica($usuario['emp_id'], '', $rows); 
		}
		else //usuario humancenter
		{
			$data['servicios'] = $this->servicio->get_todas_empresas('', $rows); 
		}







		if ( strstr($usuario['portal'],'CORPO') )
		{	
			if ( strstr($usuario['empresas'],'TGSI') )
			{
				$data['servicios'] = $this->servicio->get_all_ac_gsi('', $rows,$n); 
			}
			else
			{
				$i=0;
				foreach ( explode(';',$usuario['empresas'] )  as $esta_empresa) 
				{
					if ($esta_empresa > 0)
					{	
						$gss[$i]=$esta_empresa;
						$i++;
					}
				}	
				$data['servicios'] = $this->servicio->get_all_ac_gsi_gss_2('',$rows,$gss,$n);
				$data['c_empresas'] = $i; 
			}				
		
		}elseif ( strstr($usuario['portal'],'EMPSGSI') )
		{	
			if ( strstr($usuario['empresas'],'TGSI') )
			{
				$data['servicios'] = $this->servicio->get_all_ac_gsi('', $rows,$n); 
			}
			else
			{
				$i=0;
				foreach ( explode(';',$usuario['empresas'] )  as $esta_empresa) 
				{
					if ($esta_empresa > 0)
					{	
						$gss[$i]=$esta_empresa;
						$i++;
					}
				}	
				$data['servicios'] = $this->servicio->get_all_ac_gsi_gss_2('',$rows,$gss,$n);
				$data['c_empresas'] = $i; 
			}				
		
		}


		$this->load->model('empresa/Empresa_model','empresa');

	/*	if (($user['usr_id'] == 736) || ($user['usr_id'] == 737))
		{
			$gss=array(242,95,92,124);
			$data['empresas'] =  $this->empresa->get_all_empresas_gss($gss);			
		}				
		elseif (($user['usr_id'] == 589) || ($user['usr_id'] == 590) || ($user['usr_id'] == 591))
		{$gss=array(242,95,92);
			$data['empresas'] =  $this->empresa->get_all_empresas_gss($gss);			
		}				
		elseif ($user['usr_id'] == 510) 
		{		
			$data['empresas'] = $this->empresa->get_all_empresas_subcorp('GSI', 'COMETRA');	
		}elseif ($user_root4 == 5)
		{
			$data['empresas'] = $this->empresa->trae_emp_asig($medico['usr_emp_asig']);			
		}
		elseif ($user_root4 == 6)
		{
			$data['empresas'] = $this->empresa->get_all_empresas_gsi_id();			
		}
		else
		{		
			$data['empresas'] = $this->cliente->trae_empresas(); 
		}	
		*/
	

		if (get_perfil_id()>2) //usuario de cliente
		{
			$data['empresas'] = $this->empresa->trae_emp_asig($usuario['emp_id']);	
		}
		else //usuario humancenter
		{
			$data['empresas'] = $this->cliente->trae_empresas(); 
		}


	
		

		if ( strstr($usuario['portal'],'CORPO') )
		{	
			if ( strstr($usuario['empresas'],'TGSI') )
			{
				$data['empresas'] = $this->empresa->get_all_empresas_gsi_id();	
				$data['c_empresas'] = 0; 
			}
			else
			{
				$i=0;
				foreach ( explode(';',$usuario['empresas'] )  as $esta_empresa) 
				{
					if ($esta_empresa > 0)
					{	
						$gss[$i]=$esta_empresa;
						$i++;
					}
				}	
				
				$data['empresas'] =  $this->empresa->get_all_empresas_gss($gss);
				$data['c_empresas'] = $i; 
			}	
		
		}elseif ( strstr($usuario['portal'],'EMPSGSI') )
		{	
			if ( strstr($usuario['empresas'],'TGSI') )
			{
				$data['empresas'] = $this->empresa->get_all_empresas_gsi_id();	
				$data['c_empresas'] = 0; 
			}
			else
			{
				$i=0;
				foreach ( explode(';',$usuario['empresas'] )  as $esta_empresa) 
				{
					if ($esta_empresa > 0)
					{	
						$gss[$i]=$esta_empresa;
						$i++;
					}
				}	
				
				$data['empresas'] =  $this->empresa->get_all_empresas_gss($gss);
				$data['c_empresas'] = $i; 
			}	
		
		}

	        
        $this->load->helper('template');
	
        $params_view = array(
            'title' => 'Servicios',
            'view' => 'servicio/index',
            'view_data' => $data 
           );
        render_template($params_view);  
    }

 
 
 
 /************************************************************************/

/************************************************************************************/  
    public function edita_hc($emp_id,$modo=0)
    {

		$user = $this->session->user;
		$user_empresa=$user['emp_id'];
		$user_cei=get_cei_id();		
		
		if(isset($_POST) && count($_POST) > 0)     
		{
            //recibe los datos
            $this->load->library('form_validation');          	
            $this->form_validation->set_rules('fecha_event_ini','Fecha inicia','required');
            $this->form_validation->set_rules('hora_event_ini','Hora inicia','required');
            $this->form_validation->set_rules('fecha_event_fin','Fecha fin','required');
            $this->form_validation->set_rules('hora_event_fin','Hora fin','required');			

            if($this->form_validation->run())
            {
				
				$reclutamiento['reclu_puesto']=$this->input->post('puesto');
				$reclutamiento['reclu_solicitante']=$this->input->post('solicitante');
				$reclutamiento['reclu_cei']=$this->input->post('cei_control');
				$reclutamiento['reclu_nombramiento']=$this->input->post('nombramiento');
				$reclutamiento['reclu_motivo']=$this->input->post('motivo');
				$reclutamiento['reclu_duracion']=$this->input->post('duracion');
				$reclutamiento['reclu_remplaza']=$this->input->post('remplaza');
				$reclutamiento['reclu_edad']=$this->input->post('edad');
				$reclutamiento['reclu_sexo']=$this->input->post('sexo');
				$reclutamiento['reclu_civil']=$this->input->post('civil');
				$reclutamiento['reclu_escolaridad']=$this->input->post('escolaridad');
				$reclutamiento['reclu_carrera']=$this->input->post('carrera');
				$reclutamiento['reclu_especialidad']=$this->input->post('especialidad');
				$reclutamiento['reclu_experiencia']=$this->input->post('experiencia');
				$reclutamiento['reclu_anios']=$this->input->post('anios');
				$reclutamiento['reclu_area']=$this->input->post('area');
				$reclutamiento['reclu_lugar']=$this->input->post('lugar');
		
				$reclutamiento['reclu_horario']='';
				if ($this->input->post('domingo') != '') {$reclutamiento['reclu_horario'].=$this->input->post('domingo').','; } 
				if ($this->input->post('lunes') != '') {$reclutamiento['reclu_horario'].=$this->input->post('lunes').',';} 
				if ($this->input->post('martes') != '') {$reclutamiento['reclu_horario'].=$this->input->post('martes').',';} 
				if ($this->input->post('miercoles') != '') {$reclutamiento['reclu_horario'].=$this->input->post('miercoles').',';} 
				if ($this->input->post('jueves') != '') {$reclutamiento['reclu_horario'].=$this->input->post('jueves').',';} 
				if ($this->input->post('viernes') != '') {$reclutamiento['reclu_horario'].=$this->input->post('viernes').',';} 
				if ($this->input->post('sabado') != '') {$reclutamiento['reclu_horario'].=$this->input->post('sabado').',';} 
				
				$long_reclu_horario=strlen($reclutamiento['reclu_horario']);
				$reclutamiento['reclu_horario'][$long_reclu_horario-1]='-';				
		
				$reclutamiento['reclu_horario'].='Hora de entrada: '.$this->input->post('hora_entrada').' - Hora de salida: '.$this->input->post('hora_salida').' ¿Sale al día siguiente? '.$this->input->post('fin_dia_siguiente');

				//$reclutamiento['reclu_horario']=;
				
				$reclutamiento['reclu_viajar']=$this->input->post('viajar');
				
				$reclutamiento['reclu_roles']=$this->input->post('roles');
				$reclutamiento['reclu_competencias']=$this->input->post('competencias');
				
				$reclutamiento['reclu_idioma']=$this->input->post('idioma');
				$reclutamiento['reclu_habla']=$this->input->post('habla');
				$reclutamiento['reclu_escribe']=$this->input->post('escribe');
				$reclutamiento['reclu_traduce']=$this->input->post('traduce');
				$reclutamiento['reclu_habilidades']=$this->input->post('habilidades');	
				$reclutamiento['reclu_sueldo']=$this->input->post('sueldo');
				$reclutamiento['reclu_condiciones']=$this->input->post('condiciones');					
				
				$total_examenes_selectos=$this->input->post('total_examenes_selectos');
					$paquetes='';
					$detecta_pkts=0;
					for($i=1; $i <= $total_examenes_selectos; $i++)
					{
						$indice='examen_select_pkt_'.strval($i);
						if ($this->input->post($indice) != NULL)
						{	
						$paquetes.=$this->input->post($indice).';';
						$detecta_pkts++;
						}
						
					}			
					
					$fecha_ini = formatea_fechahora_mysql($this->input->post('fecha_event_ini').' '.$this->input->post('hora_event_ini'));
					$fecha_fin = formatea_fechahora_mysql($this->input->post('fecha_event_fin').' '.$this->input->post('hora_event_fin'));					
				
     				$params = array
					(
						'cal_pkts' => $paquetes,
						//Observaciones
						'cal_observaciones' =>$this->input->post('observaciones'),
						//Evaluados
						'cal_evaluados' => $los_evaluados, 	
						//Solicitante
						'cal_usr_nombre' => $user['usr_nombre'],
						'cal_usr_paterno' => $user['usr_paterno'],
						'cal_usr_materno' => $user['usr_materno'],
						'cal_usr_correo' => $user['usr_correo'],					
						//datos normales de calendario	
						'cal_fecha' => $this->input->post('fecha'),
						'cal_titulo' => $this->input->post('asunto'),
						'cal_servicio' => NULL,
						'cal_descripcion' => $this->input->post('descripcion'),
						'cal_fecha_ini' => $fecha_ini,
						'cal_fecha_fin' => $fecha_fin,
						'cal_id_horario' => $id_horario,					
						'cal_cuantos_evaluados' => $cuantos_evaluados,
						'cal_uid' => uniqid(rand(0, getmypid()))					
					);

					$params['emp_id'] = $emp_id;
					$params['desp_emp_id'] = 0;				
					$params['cal_lugar'] = $this->input->post('lugar');
					$params['cal_lugar_det'] = $this->input->post('lugar_det');
					$params['cal_lugar_det'] ='Calle San Borja 1365, Vértiz Narvarte, Benito Juárez, C.P. 03600, CDMX'; 
					$params['cal_lugar_det'] = 'Paseo de la Reforma No. 342, Piso 14, Col. Juárez, Del. Cuauhtémoc, C.P. 06600, CDMX';  
					$params['cal_email'] = $user['usr_correo'].'; '.$this->input->post('mail');

					/******NUEVOS ARCHIVO ANEXO 0 *****/
					if(!empty($_FILES['anexo']['name']))
					{
						$nombre_anexo=$_FILES['anexo']['name'];
						$this->load->library('upload');
						$filename = md5(time());
						$config = array(
								'upload_path'   => './../../files/anexos/',
								'overwrite'     => TRUE,
								'file_name'     => $filename,
								'allowed_types' => 'doc|docx|pdf|txt|xlsx|xls|png|jpg|jpeg',
								'max_size'      => '10000'
						);

						$this->upload->initialize($config);
						
						if ( ! $this->upload->do_upload('anexo'))
						{
							echo json_encode(array('status' => 'error','content' => $this->upload->display_errors()));
							exit;
						}
						else 
						{
							$data = $this->upload->data();
							$params['cal_anexo_path'] = $data['file_name'];
							$params['cal_anexo_nombre'] = $nombre_anexo;
							$data_serv['serv_anexo_path'] = $data['file_name'];
							$data_serv['serv_anexo_nombre'] = $nombre_anexo;
							
						}
					}

					/******NUEVOS ARCHIVO ANEXO 1 *****/
					if(!empty($_FILES['anexo1']['name']))
					{
						$nombre_anexo=$_FILES['anexo1']['name'];
						$this->load->library('upload');
						
						sleep(1);
						$filename1 = md5(time());
						$config = array(
								'upload_path'   => './../../files/anexos/',
								'overwrite'     => TRUE,
								'file_name'     => $filename1,
								'allowed_types' => 'doc|docx|pdf|txt|xlsx|xls|png|jpg|jpeg',
								'max_size'      => '10000'
						);

						$this->upload->initialize($config);
						
						if ( ! $this->upload->do_upload('anexo1'))
						{
							  echo json_encode(array('status' => 'error','content' => $this->upload->display_errors()));
							exit;
						}
						else 
						{
							$data = $this->upload->data();
							$params['cal_anexo1_path'] = $data['file_name'];
							$params['cal_anexo1_nombre'] = $nombre_anexo;
							$data_serv['serv_anexo1_path'] = $data['file_name'];
							$data_serv['serv_anexo1_nombre'] = $nombre_anexo;
						}
					}
		
					/******NUEVOS ARCHIVO ANEXO 2 ******/
					if(!empty($_FILES['anexo2']['name']))
					{
						$nombre_anexo=$_FILES['anexo2']['name'];
						$this->load->library('upload');
						
						sleep(1);
						$filename2 = md5(time());
						$config2 = array(
								'upload_path'   => './../../files/anexos/',
								'overwrite'     => TRUE,
								'file_name'     => $filename2,
								'allowed_types' => 'doc|docx|pdf|txt|xlsx|xls|png|jpg|jpeg',
								'max_size'      => '10000'
						);

						$this->upload->initialize($config2);
						
						if ( ! $this->upload->do_upload('anexo2'))
						{

							echo json_encode(array('status' => 'error','content' => $this->upload->display_errors()));
							exit;
						}
						else 
						{
							$data = $this->upload->data();
							$params['cal_anexo2_path'] = $data['file_name'];
							$params['cal_anexo2_nombre'] = $nombre_anexo;
							$data_serv['serv_anexo2_path'] = $data['file_name'];
							$data_serv['serv_anexo2_nombre'] = $nombre_anexo;
						}
					}
		
					/******NUEVOS ARCHIVO ANEXO 3 ******/
					if(!empty($_FILES['anexo3']['name']))
					{
						$nombre_anexo=$_FILES['anexo3']['name'];
						$this->load->library('upload');
						
						sleep(1);
						$filename3 = md5(time());
						$config3 = array(
								'upload_path'   => './../../files/anexos/',
								'overwrite'     => TRUE,
								'file_name'     => $filename3,
								'allowed_types' => 'doc|docx|pdf|txt|xlsx|xls|png|jpg|jpeg',
								'max_size'      => '10000'
						);

						$this->upload->initialize($config3);
						
						if ( ! $this->upload->do_upload('anexo3'))
						{

							echo json_encode(array('status' => 'error','content' => $this->upload->display_errors()));
							exit;
						}
						else 
						{
							$data = $this->upload->data();
							$params['cal_anexo3_path'] = $data['file_name'];
							$params['cal_anexo3_nombre'] = $nombre_anexo;
							$data_serv['serv_anexo3_path'] = $data['file_name'];
							$data_serv['serv_anexo3_nombre'] = $nombre_anexo;
							
						}
					}
		
					/******NUEVOS ARCHIVO ANEXO 4 ******************************/
					if(!empty($_FILES['anexo4']['name']))
					{
						$nombre_anexo=$_FILES['anexo4']['name'];
						$this->load->library('upload');
						
						sleep(1);
						$filename4 = md5(time());
						$config = array(
								'upload_path'   => './../../files/anexos/',
								'overwrite'     => TRUE,
								'file_name'     => $filename4,
								'allowed_types' => 'doc|docx|pdf|txt|xlsx|xls|png|jpg|jpeg',
								'max_size'      => '10000'
						);

						$this->upload->initialize($config);
						
						if ( ! $this->upload->do_upload('anexo4'))
						{

							echo json_encode(array('status' => 'error','content' => $this->upload->display_errors()));
							exit;
						}
						else 
						{
							$data = $this->upload->data();
							$params['cal_anexo4_path'] = $data['file_name'];
							$params['cal_anexo4_nombre'] = $nombre_anexo;
							$data_serv['serv_anexo4_path'] = $data['file_name'];
							$data_serv['serv_anexo4_nombre'] = $nombre_anexo;
						}
					}

					/*** Estructura para generar Orden de Servicio ****/
					$params['cei_control_id'] = $this->input->post('cei_control');
					$data_serv['cei_control_id'] = $this->input->post('cei_control');

					$f = new DateTime();
					$ff= $reclutamiento['reclu_puesto'].' - '.get_cei($data_serv['cei_control_id']).' - '. $f->getTimestamp();			
					$params['serv_orden']= $ff;
					$data_serv['serv_orden'] = $ff;

					$data_serv['emp_id'] =  $emp_id;
					$data_serv['usr_id'] = $user['usr_id'];
					$data_serv['serv_f_inicio'] = $fecha_ini;
					$data_serv['serv_f_fin'] = $fecha_fin;
					$data_serv['serv_desc'] = $this->input->post('observaciones');
					$data_serv['serv_ubicacion'] =   $this->input->post('lugar');

					$data_serv['serv_estatus_cve'] = 'PROCESO';
					$data_serv['cei_id'] = $user['cei_id'];

					if (($params['emp_id'] > 0) && ($detecta_pkts > 0) )
					{	
						//se crea evento en agenda
						$cal_id = $this->agenda->add_evento_folio(array_to_upper($params));
						$serv_id=0;	

						//el evento se le da al servicio
						$data_serv['cal_folio'] = $cal_id;
						$data_serv['cal_id'] = $cal_id;
						
						//el servicio se crea
						$serv_id = $this->servicio->inserta(array_to_upper($data_serv));			

						//costos para el servicio creado
						$total_examenes_selectos= $this->input->post('total_examenes_selectos');	
						
						$fsm_pakts= get_costos_paquetes_empresa($emp_id);
						if($fsm_pakts):
							foreach($fsm_pakts as $fsm_pakt): 
										
									for($i=1; $i <= $total_examenes_selectos; $i++)
									{									
										$indice='examen_select_pkt_'.strval($i);
										$paquetes= $this->input->post($indice);	
												
										if ( $fsm_pakt['cost_nombre_pkt'] === $paquetes)
										{
											$examen_ins['exam_nombre_pkt'] = $fsm_pakt['cost_nombre_pkt']; //nombre del paquete
											$examen_ins['serv_id'] = $serv_id;
											$examen_ins['exam_cve'] = $fsm_pakt['cost_examen_cve']; //lo que contiene el paquete
											$examen_ins['exam_monto'] = $fsm_pakt['cost_monto']; //lo que contiene el paquete								 	 
											$examen_ins['exam_cantidad'] = 1;
											$examen_ins['exam_estatus_cve'] = 'PEND';
											$examen_ins['exam_tipo_pkt'] = $fsm_pakt['cost_tipo_pkt'];
											$this->servicio->inserta_examen($examen_ins);
											//$i=$total_examenes_selectos+1;
										}							
									}	
							endforeach;
						endif;	
	
						}

						$param['cal_titulo']= get_empresa($params['emp_id']).', OS:'.$serv_id.', IDA:'.$cal_id; 

						$param['serv_id']=$serv_id;
						$this->agenda->update_evento($cal_id,$param);
						
						$reclutamiento['emp_id']=$emp_id;
						$reclutamiento['usr_id']=$user['usr_id'];
						$reclutamiento['cal_id']=$cal_id;
						$reclutamiento['serv_id']=$serv_id;
						$reclutamiento=array_to_upper($reclutamiento);
						$this->servicio->inserta_reclutamiento($reclutamiento);

						if ($cal_id) 
						{
								$this->load->helper('mail');
								$evento = $this->agenda->get_evento($cal_id);
								
								$data_email = array('evento' => $evento,
								              'reclutamiento' => $reclutamiento);											  
											  
								$html = $this->load->view('agenda/email_add_evento_reclutamiento',$data_email,TRUE);
								$html_r = $this->load->view('agenda/email_add_evento_reclutamiento_r',$data_email,TRUE);


								$this->load->helper('mail');
								
								send_mail_std_event_reclu(
															$this->input->post('mail'), 
															$evento, 
															$html,
															$cal_id,
															get_empresa($emp_id),
															$user['usr_nombre'].' '.$user['usr_paterno'],
															$user['usr_correo'],
															'',
															'',
															$params['cal_lugar'] 
														);
					
								send_json_ok('Se guardó de forma correcta.');
						}
						else
						{   
								if ($detecta_pkts > 0)
								{
									send_json_error('Ocurrió un error al guardar, por favor revise si toda su información esta completa y vuelva intentar.');
								}
								else
								{
									send_json_error('Ocurrió un error al guardar, ¿eligio al menos un examen para este servicio?');
								}
						
						}
				}
				else
				{
					send_json_error(validation_errors('<div />'));
				}
		}
		else 
		{
			$data['empresa'] = $emp_id;
			$this->load->helper('template');
			$params_view = array(
				'title' => 'Servicios',
				'view' => 'servicio/edit_hc',
				'view_data' => $data
			   );
			render_template($params_view);  
		}

    }   

    public function rep_ordenes_serv_by_pedido()
    {
        $this->load->helper('template');
        $params_view = array(
            'title' => 'Inicio',
            'view' => 'servicio/ini_view_rep_ord_serv_pedido',
            'view_data' => $data
            );
        render_template($params_view);
    }


    function gen_rep_ordenes_serv_by_pedido()
    {
        
		
		$f_ini = $this->input->post('f_ini');
        $f_fin = $this->input->post('f_fin'); 
		$data['emp_id']=$this->input->post('empresa');
		$data['pedido']=$this->input->post('pedido');
		$data['pedido_prefijo']=$this->input->post('pedido_prefijo');
		$reporte=$this->input->post('reporte');
		$data['f_ini_o']=$f_ini;
		$data['f_fin_o']=$f_fin;
		$data['f_ini']=$f_ini;
		$data['f_fin']=$f_fin;

		if ( $reporte == 1 )
		{
			$this->load->helper('template');
			$params_view = array(
				'title' => 'Inicio',
				'view' => 'servicio/x_rep_ordenes_serv_by_pedido_display',
				'view_data' => $data
				);
			render_template($params_view);
		}
		else
		{
			$user = $this->session->user;
			$f_ini_o=$this->input->post('f_ini');
			$f_fin_o=$this->input->post('f_fin');
			$emp_id=$this->input->post('empresa');
			$empresa_l=get_empresa($this->input->post('empresa'));
			$pedido=$this->input->post('pedido');
			$pedido_prefijo=$this->input->post('pedido_prefijo');

			?>
				<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
				<html xmlns="http://www.w3.org/1999/xhtml">
				
					<head>
					<meta content="es-mx" http-equiv="Content-Language" />
					<meta content="text/html; charset=utf-8" http-equiv="Content-Type" />
					<?php
						header("Content-type: application/octet-stream; charset=latin1");
						header("Content-Disposition: attachment; filename=Rep_".$empresa_l.date("d/m/y h:i:sa").".xls");
						header("Pragma: no-cache");
						header("Expires: 0");
					?>			
					<title>#</title>
					<style type="text/css">
					.auto-style1 {
						font-family: Arial, Helvetica, sans-serif;
						color: #FFFFFF;
						background-color: #3D5588;
						font-size: small;
					}
					.auto-style4 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: xx-small;
					}
					.auto-style5 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: medium;
					}
					.auto-style6 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: x-large;
						text-align: right;
						font-weight: normal;
					}
					.auto-style7 {
						font-size: small;
					}
					.auto-style8 {
						color: #3D5588;
					}
					.auto-style9 {
						color: #3AD4A7;
					}
								.auto-style11 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: small;
						text-align: right;
					}
					.auto-style12 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: small;
						text-align: center;
					}
					.auto-style13 {
						font-size: xx-small;
					}
					.auto-style14 {
						font-family: Arial, Helvetica, sans-serif;
						color: #FFFFFF;
						background-color: #3D5588;
						font-size: 14px;
						text-align: center;
					}

					.auto-style144 {
						font-family: Arial, Helvetica, sans-serif;
						color: #FFFFFF;
						background-color: #3D5588;
						font-size: 16px;
						text-align: center;
					}

					.auto-style144_R {
						font-family: Arial, Helvetica, sans-serif;
						color: #FFFFFF;
						background-color: #FF0000;
						font-size: 10px;
						text-align: center;
					}

					.auto-style144_A {
						font-family: Arial, Helvetica, sans-serif;
						color: #000000;
						background-color: #f7d917;
						font-size: 10px;
						text-align: center;
					}

					.auto-style144_V {
						font-family: Arial, Helvetica, sans-serif;
						color: #ffffff;
						background-color:  #007336;
						font-size: 10px;
						text-align: center;
					}


					.auto-style15 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: x-small;
					}
					.auto-style16 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: x-small;
						text-align: right;
					}
					.auto-style17 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: x-small;
						text-align: left;
					}
					.auto-style18 {
						font-family: Arial, Helvetica, sans-serif;
						color: #000000;
						font-size: xx-small;
						text-align: center;
					}

					.auto-style154 {
						font-family: Arial, Helvetica, sans-serif;
						color: #000000;
						font-size: xx-small;
						text-align: center;
						background-color: #BDD7EE;
					}

					.auto-style189 {
						font-family: Arial, Helvetica, sans-serif;
						color: #000000;
						font-size: xx-small;
						text-align: center;
						background-color: #DDEBF7;
					}

					.auto-style188 {
						font-family: Arial, Helvetica, sans-serif;
						color: #000000;
						font-size: xx-small;
						text-align: left;
					}

					.auto-style88 {
						font-family: Arial, Helvetica, sans-serif;
						color: #3D5588;
						font-size: small;
						text-align: right;	
					}

					.auto-style19 {
						color: #3D5588;
						font-size: medium;
					}
					.auto-style20 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: xx-small;
						text-align: center;
						background-color: #BFEADD;
					}
					.auto-style21 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: xx-small;
						background-color: #BFEADD;
					}

					.auto-style190 {
						font-family: Arial, Helvetica, sans-serif;
						color: #0000FF;
					}

					.APTO {
						color: #008000;
						font-weight: bold;
					}
					.NOAPTO {
						color: #FF0000;
						font-weight: bold;
					}

					.PENDIENTE {
						color: #FF00FF;
						font-weight: bold;
					}
					</style>
					</head>
					<body>
						<div class="contenedor">
							<div class="contenido">
									<table> 
										<thead>
											<tr>
												<th style="width: 64px" class="auto-style5">&nbsp;</th>
												<th style="width: 78px" class="auto-style5">&nbsp;</th>
												<th style="width: 78px" class="auto-style5">&nbsp;</th>
												<th style="width: 393px" class="auto-style5">&nbsp;</th>
												<th style="width: 281px" class="auto-style5">&nbsp;</th>
												<th style="width: 625px" class="auto-style5">&nbsp;</th>
												<th style="width: 95px" class="auto-style5">&nbsp;</th>
													<th style="width: 303px" class="auto-style5">&nbsp;</th>
											</tr>
											<tr>
												<th style="width: 64px" class="auto-style5">&nbsp;</th>
												<th style="width: 78px" class="auto-style5">&nbsp;</th>
												<th style="width: 78px" class="auto-style5">&nbsp;</th>
												<th style="width: 393px" class="auto-style6">
												<strong><span class="auto-style8">human</span><span class="auto-style9">center</span></strong></th>
												<th style="width: 281px" class="auto-style11">&nbsp;</th>
												<th style="width: 625px" class="auto-style12"></th>
												<th style="width: 95px" class="auto-style5">&nbsp;</th>
													<th style="width: 303px" class="auto-style5">&nbsp;</th>
											</tr>
											<tr>
												<th style="width: 64px" class="auto-style5">&nbsp;</th>
												<th style="width: 78px" class="auto-style5">&nbsp;</th>
												<th style="width: 78px" class="auto-style5">&nbsp;</th>
												<th style="width: 393px" class="auto-style6">
												<span class="auto-style19">Online</span><sup><span class="auto-style13" style="color: rgb(34, 34, 34); font-family: arial, sans-serif; font-style: normal; font-variant-ligatures: normal; font-variant-caps: normal; font-weight: 400; letter-spacing: normal; orphans: 2; text-align: left; text-indent: 0px; text-transform: none; white-space: normal; widows: 2; word-spacing: 0px; -webkit-text-stroke-width: 0px; background-color: rgb(255, 255, 255); text-decoration-style: initial; text-decoration-color: initial; display: inline !important; float: none;">®</span></sup></th>
												<th style="width: 281px" class="auto-style88">Empresa:</th>
												<th style="width: 625px" class="auto-style17">&nbsp;&nbsp;<?php echo get_empresa($emp_id); ?></th>							
												<th style="width: 95px" class="auto-style5">&nbsp;</th>
												<th style="width: 303px" class="auto-style5">&nbsp;</th>
											</tr>
											<tr>
												<th style="width: 64px" class="auto-style5">&nbsp;</th>
												<th style="width: 78px" class="auto-style5">&nbsp;</th>
												<th style="width: 78px" class="auto-style5">&nbsp;</th>
												<th style="width: 393px" class="auto-style5">&nbsp;</th>
												<th style="width: 281px" class="auto-style16">Del:</th>
												<th style="width: 625px" class="auto-style17">&nbsp;&nbsp;<?php echo formatea_fecha($f_ini_o) ?></th>
												<th style="width: 95px" class="auto-style5">&nbsp;</th>
													<th style="width: 303px" class="auto-style5">&nbsp;</th>
											</tr>
											<tr>
												<th style="width: 64px" class="auto-style5">&nbsp;</th>
												<th style="width: 78px" class="auto-style5">&nbsp;</th>
												<th style="width: 78px" class="auto-style5">&nbsp;</th>
												<th style="width: 393px" class="auto-style5">&nbsp;</th>
												<th style="width: 281px" class="auto-style16">al:</th>
												<th style="width: 625px" class="auto-style17">&nbsp;&nbsp;<?php echo formatea_fecha($f_fin_o); ?></th>
												<th style="width: 95px" class="auto-style5">&nbsp;</th>
													<th style="width: 303px" class="auto-style5">&nbsp;</th>
											</tr>
											<tr>
												<th style="width: 64px" class="auto-style5">&nbsp;</th>
												<th style="width: 78px" class="auto-style5">&nbsp;</th>
												<th style="width: 78px" class="auto-style5">&nbsp;</th>
												<th style="width: 393px" class="auto-style5">&nbsp;</th>
												<th style="width: 281px" class="auto-style16">Generado el día:</th>
												<th style="width: 625px" class="auto-style17">&nbsp;&nbsp;<?php echo date("d/m/y h:i:sa"); ?></th>
												<th style="width: 95px" class="auto-style5">&nbsp;</th>
													<th style="width: 303px" class="auto-style5">&nbsp;</th>
											</tr>
											<tr>
												<th style="width: 64px" class="auto-style5">&nbsp;</th>
												<th style="width: 78px" class="auto-style5">&nbsp;</th>
												<th style="width: 78px" class="auto-style5">&nbsp;</th>
												<th style="width: 393px" class="auto-style5">&nbsp;</th>
												<th style="width: 281px" class="auto-style15">&nbsp;</th>
												<th style="width: 625px" class="auto-style5">&nbsp;</th>
												<th style="width: 95px" class="auto-style5">&nbsp;</th>
													<th style="width: 303px" class="auto-style5">&nbsp;</th>
											</tr>
										</thead>
									</table> 
<!-------------------------------------------------------------------------------------->
<!-------------------------------INICIA MODULO COMUN------------------------------------>
<!-------------------------------------------------------------------------------------->
<?php
	//
	//edo_page($serv,$mode_p=0,$no_estatus=0,$sin_titulos=0,$s_mty_br=0,$ini_f = '',$fin_f = '',$control_pedido=0,$pedido_prefijo='',$empresa=0)
	edo_page($pedido,1,0,1,0,$f_ini,$f_fin,1,$pedido_prefijo,$emp_id);	
?>
<!-------------------------------------------------------------------------------------->
<!-----------------------------FIN DE MODULO COMUN-------------------------------------->
<!-------------------------------------------------------------------------------------->


					</body>
				</html>
			<?php
		}		
	}





    public function rep_orserv()
    {
        $this->load->helper('template');
        $params_view = array(
            'title' => 'Inicio',
            'view' => 'servicio/inicio_view_rep_ordenes',
            'view_data' => $data
            );
        render_template($params_view);
    }  
 
    function spy($serv_id)
    {
		$servicio = $this->servicio->get($serv_id);
		$data['servicio'] = $servicio;
	
		if($data['servicio'])
        {
			
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Evaluados',
                'view' => 'servicio/spy',
                'view_data' => $data 
               );

            render_template($params_view);  
        }
        else
        {
            show_error('El servicio no existe.');
        }
    }


    public function index_ordenes()
    {   		
		$user = $this->session->user; 
		$medico = $this->medico->get($user['usr_id']);
		$user_root4=get_my_user_root4();
		$n=get_desp_id_usr();		
		
        $rows = 30;
        $this->load->library('pagination');
        $config['base_url'] = base_url('servicio/index_ordenes/');
		
		
        /*$config['total_rows'] = $this->servicio->count_all($n);*/
        
		if (($user['usr_id'] == 736) || ($user['usr_id'] == 737))
		{
			$gss=array(242,95,92,124);
			$config['total_rows'] = $this->servicio->count_all_empresas_asig($gss);
		}
		elseif (($user['usr_id'] == 589) || ($user['usr_id'] == 590) || ($user['usr_id'] == 591))
		{
			$gss=array(242,95,92);
			$config['total_rows'] = $this->servicio->count_all_empresas_asig($gss);
		}
		elseif ($user['usr_id'] == 510) /*GSI-COMETRA*/
		{
			$cometra=array(93,174,175,150,129,30);
			$config['total_rows'] = $this->servicio->count_all_empresas_asig($cometra);
		}elseif ($user_root4 == 5)
		{
			$config['total_rows'] = $this->servicio->count_all_emp_asig($medico['usr_emp_asig'],$n);			
		}
		elseif ($user_root4 == 6)
		{
			$config['total_rows'] = $this->servicio->count_all_empresas_gsi();
		}
		else
		{
			$config['total_rows'] = $this->servicio->count_all($n);
		}      
		
		
		$config['per_page'] = $rows;
        $config['attributes'] = array('class' => 'pagination');
        $config['full_tag_open'] = '<div class="pagination-full">';
        $config['full_tag_close'] = '</div>';
        $config['uri_segment'] = 3;
        $config['query_string_segment'] = 4;
        $config['use_page_numbers'] = TRUE;
        $this->pagination->initialize($config);
            
        
	
        /*$data['servicios'] = $this->servicio->get_all_ac('', '', $rows,$n); */
		if (($user['usr_id'] == 736) || ($user['usr_id'] == 737))
		{
			$gss=array(242,95,92,124);
			$data['servicios'] = $this->servicio->get_all_ac_gsi_gss('', $rows,$n);
		}
		elseif (($user['usr_id'] == 589) || ($user['usr_id'] == 590) || ($user['usr_id'] == 591))
		{
			$gss=array(242,95,92);
			$data['servicios'] = $this->servicio->get_all_ac_gsi_gss('', $rows,$n);
		}
		elseif ($user['usr_id'] == 510) 
		{	
			$cometra=array(93,174,175,150,129,30);
			$data['servicios'] = $this->servicio->get_all_ac_gsi_cometra('', $rows,$n);
		
		//$data['servicios'] = $this->servicio->get_all_ac_gsi('', $rows,$n); 
		}
		elseif ($user_root4 == 5)
		{
			$data['servicios'] =$this->servicio->get_all_ac_gsi('', $rows,$n); 	
		}
		elseif ($user_root4 == 6)
		{
			$data['servicios'] = $this->servicio->get_all_ac_gsi('', $rows,$n); //get_all('', '', $rows,$n);			
		}
		else
		{		
			$data['servicios'] = $this->servicio->get_all_ac('', '', $rows,$n); //get_all('', '', $rows,$n);
		}		
		

        /*$data['empresas'] = $this->cliente->trae_empresas(); */
		$this->load->model('empresa/Empresa_model','empresa');

		if (($user['usr_id'] == 736) || ($user['usr_id'] == 737))
		{
			$gss=array(242,95,92,124);
			$data['empresas'] =  $this->empresa->get_all_empresas_gss($gss);			
		}				
		elseif (($user['usr_id'] == 589) || ($user['usr_id'] == 590) || ($user['usr_id'] == 591))
		{$gss=array(242,95,92);
			$data['empresas'] =  $this->empresa->get_all_empresas_gss($gss);			
		}				
		elseif ($user['usr_id'] == 510) 
		{		
			$data['empresas'] = $this->empresa->get_all_empresas_subcorp('GSI', 'COMETRA');	
		}elseif ($user_root4 == 5)
		{
			$data['empresas'] = $this->empresa->trae_emp_asig($medico['usr_emp_asig']);			
		}
		elseif ($user_root4 == 6)
		{
			$data['empresas'] = $this->empresa->get_all_empresas_gsi_id();			
		}
		else
		{		
			$data['empresas'] = $this->cliente->trae_empresas(); 
		}	

	        
        $this->load->helper('template');
	
        $params_view = array(
            'title' => 'Servicios',
            'view' => 'servicio/index_ordenes',
            'view_data' => $data 
           );
        render_template($params_view);  
    }



 



    public function list_servs_status()
    {   		
		$user = $this->session->user; 
		$medico = $this->medico->get($user['usr_id']);
		$user_root4=get_my_user_root4();
		$n=get_desp_id_usr();		
		
        $rows = 30;
        $this->load->library('pagination');
        $config['base_url'] = base_url('servicio/index/');
		
		
        /*$config['total_rows'] = $this->servicio->count_all($n);*/
        
		if ($user['usr_id'] == 510) /*GSI-COMETRA*/
		{
			$cometra=array(93,174,175,150,129,30);
			$config['total_rows'] = $this->servicio->count_all_empresas_asig($cometra);
			//echo '|'.$config['total_rows'].'|';
		}elseif ($user_root4 == 5)
		{
			$config['total_rows'] = $this->servicio->count_all_emp_asig($medico['usr_emp_asig'],$n);			
		}
		elseif ($user_root4 == 6)
		{
			$config['total_rows'] = $this->servicio->count_all_empresas_gsi();
		}
		else
		{
			$config['total_rows'] = $this->servicio->count_all($n);
		}      
		
		
		$config['per_page'] = $rows;
        $config['attributes'] = array('class' => 'pagination');
        $config['full_tag_open'] = '<div class="pagination-full">';
        $config['full_tag_close'] = '</div>';
        $config['uri_segment'] = 3;
        $config['query_string_segment'] = 4;
        $config['use_page_numbers'] = TRUE;
        $this->pagination->initialize($config);
            
        
	
        /*$data['servicios'] = $this->servicio->get_all_ac('', '', $rows,$n); */
		if ($user['usr_id'] == 510) 
		{	
			$cometra=array(93,174,175,150,129,30);
			$data['servicios'] = $this->servicio->get_all_ac_gsi_cometra('', $rows,$n);
		
		//$data['servicios'] = $this->servicio->get_all_ac_gsi('', $rows,$n); 
		}
		elseif ($user_root4 == 5)
		{
			$data['servicios'] =$this->servicio->get_all_ac_gsi('', $rows,$n); 	
		}
		elseif ($user_root4 == 6)
		{
			$data['servicios'] = $this->servicio->get_all_ac_gsi('', $rows,$n); //get_all('', '', $rows,$n);			
		}
		else
		{		
			$data['servicios'] = $this->servicio->get_all_ac('', '', $rows,$n); //get_all('', '', $rows,$n);
		}		
		

        /*$data['empresas'] = $this->cliente->trae_empresas(); */
		$this->load->model('empresa/Empresa_model','empresa');
		if ($user['usr_id'] == 510) 
		{		
			$data['empresas'] = $this->empresa->get_all_empresas_subcorp('GSI', 'COMETRA');	
		}elseif ($user_root4 == 5)
		{
			$data['empresas'] = $this->empresa->trae_emp_asig($medico['usr_emp_asig']);			
		}
		elseif ($user_root4 == 6)
		{
			$data['empresas'] = $this->empresa->get_all_empresas_gsi_id();			
		}
		else
		{		
			$data['empresas'] = $this->cliente->trae_empresas(); 
		}	

	        
        $this->load->helper('template');
	
        $params_view = array(
            'title' => 'Servicios',
            'view' => 'servicio/list_servs_status',
            'view_data' => $data 
           );
        render_template($params_view);  
    }


    
    public function busca()
    {   $user = $this->session->user; 
	
		$orden_f_ini = $this->input->post('f_ini');
		$orden_f_fin = $this->input->post('f_fin');
		
		$orden_cei = $this->input->post('orden_cei');
        $orden_servicio = $this->input->post('orden_servicio');
		$orden_venta = $this->input->post('orden_venta');
		$emp_id = $this->input->post('empresa');
        $estatus = $this->input->post('estatus');
		
		/*
		if ($user['usr_id'] == 510) 
		{	
			
			$data['servicios'] = $this->servicio->get_all($emp_id, $estatus, $rows,0,$orden_servicio,$orden_venta,$orden_cei);
		}
		else
		{	
			$data['servicios'] = $this->servicio->get_all($emp_id, $estatus, $rows,0,$orden_servicio,$orden_venta,$orden_cei);
        }
		*/
		
		$data['servicios'] = $this->servicio->get_all_services_dates($emp_id, $estatus, $rows,0,$orden_servicio,$orden_venta,$orden_cei,$orden_f_ini,$orden_f_fin);
		//$data['servicios'] = $this->servicio->get_all_services($emp_id, $estatus, $rows,0,$orden_servicio,$orden_venta,$orden_cei);
		send_json_ok($this->load->view('servicio/busca',$data,TRUE));
    }
/************************************************************************************/
public function nuevo_a($emp_id)
    {
        if(isset($_POST) && count($_POST) > 0)     
        {
            $medico = $this->session->user;
            $this->load->library('form_validation');
            $this->form_validation->set_rules('orden','Pedido','required');
            //$this->form_validation->set_rules('emp_id','Empresa','required');
            $this->form_validation->set_rules('f_ini','Fecha inicio','required');
            $this->form_validation->set_rules('h_ini','Hora inicio','required');
            $this->form_validation->set_rules('f_fin','Fecha fin','required');
            $this->form_validation->set_rules('h_fin','Hora fin','required');
            $this->form_validation->set_rules('descrip','Descripción','required');
            $this->form_validation->set_rules('ubicacion','Ubicación','required');
            //$this->form_validation->set_rules('responsable','Responsable','required');
            $this->form_validation->set_rules('estatus','Estatus','required');

            if($this->form_validation->run())
            {
                //$fecha_ini = formatea_fechahora_mysql($this->input->post('f_ini').' '.$this->input->post('h_ini'));
                //$fecha_fin = formatea_fechahora_mysql($this->input->post('f_fin').' '.$this->input->post('h_fin'));
                
				$fecha_ini = $this->input->post('f_ini').' '.formatea_hora_mysql($this->input->post('h_ini'));
                $fecha_fin = $this->input->post('f_fin').' '.formatea_hora_mysql($this->input->post('h_fin'));
				
                $data_serv['serv_orden'] = $this->input->post('orden');
                $data_serv['emp_id'] = $this->input->post('emp_id');
                $data_serv['usr_id'] = $medico['usr_id'];
                $data_serv['serv_f_inicio'] = $fecha_ini;
                $data_serv['serv_f_fin'] = $fecha_fin;
                $data_serv['serv_desc'] = $this->input->post('descrip');
                $data_serv['serv_ubicacion'] = $this->input->post('ubicacion');
                $data_serv['serv_contacto_per'] = $this->input->post('responsable');
                $data_serv['serv_contacto_tel'] = limpia_telefono($this->input->post('telefono'));
                $data_serv['serv_acuerdos'] = $this->input->post('clausulas');
                $data_serv['serv_estatus_cve'] = $this->input->post('estatus');
				$data_serv['cei_id'] = $this->input->post('cei');
				$data_serv['cei_control_id'] = $this->input->post('cei_control');
				
				$data_serv['serv_viaticos'] = $this->input->post('viaticos');
				$data_serv['serv_costo_viaticos'] = $this->input->post('gastos_operacion');
				
				if ($this->input->post('folio_calendario') == "Sin Folio")
				{
					$data_serv['cal_folio'] = 0;
				}
				else
				{
					$data_serv['cal_folio'] = $this->input->post('folio_calendario');
				}
				
				$data_serv['desp_id'] = $this->input->post('despachos');
				$data_serv['reclutador'] = $this->input->post('reclutador');
				
				/********************* se excluyen la toma de examenes por el usuario   ********/                
                //$examenes = $this->input->post('examen');
				$data_serv=array_to_upper($data_serv);
					
				/******NUEVOS ARCHIVO ANEXO 1 ******************************/
                if(!empty($_FILES['anexo1']['name']))
                {
					$nombre_anexo=$_FILES['anexo1']['name'];
                    $this->load->library('upload');
					
					sleep(1);
                    $filename1 = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/anexos/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename1,
                            'allowed_types' => 'doc|docx|pdf|txt|xlsx|xls|png|jpg|jpeg',
                            'max_size'      => '10000'
                    );

                    $this->upload->initialize($config);
					
                    if ( ! $this->upload->do_upload('anexo1'))
                    {
                          echo json_encode(array('status' => 'error','content' => $this->upload->display_errors()));
                        exit;
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_serv['serv_anexo1_path'] = $data['file_name'];
						$data_serv['serv_anexo1_nombre'] = $nombre_anexo;
                    }
                }
				/***********************************************************/					
						$hay_exaamens =0;
						$total_examenes_selectos= $this->input->post('total_examenes_selectos');	
						$fsm_pakts= get_costos_paquetes_empresa($this->input->post('emp_id'));
						if($fsm_pakts):
							foreach($fsm_pakts as $fsm_pakt):										
									for($i=1; $i <= $total_examenes_selectos; $i++)
									{	
										$indice='examen_select_pkt_'.strval($i);
										$paquetes= $this->input->post($indice);	
												
										if ( $fsm_pakt['cost_nombre_pkt'] === $paquetes)
										{
											$hay_exaamens++;
										}
									}	
							endforeach;
						endif;
					
					
					
					if ($hay_exaamens >0)
					{	
						$serv_id = $this->servicio->inserta($data_serv);
					}
					
					
					
					
					
					
					
					if($serv_id)
                    {
                        //inserta las obervaciones
                        if($this->input->post('obervaciones') != '')
                        {
                            $data_serv_obs['serv_id'] = $serv_id;
                            $data_serv_obs['usr_id'] = $medico['usr_id'];
                            $data_serv_obs['nota_f'] = date('Y-m-d H:i:s');
                            $data_serv_obs['nota_descripcion'] = $this->input->post('obervaciones');
                            $this->servicio->inserta_nota(array_to_upper($data_serv_obs));
                        }
	
						$total_examenes_selectos= $this->input->post('total_examenes_selectos');	
						$fsm_pakts= get_costos_paquetes_empresa($this->input->post('emp_id'));
						if($fsm_pakts):
							foreach($fsm_pakts as $fsm_pakt): 
										
									for($i=1; $i <= $total_examenes_selectos; $i++)
									{									
										$indice='examen_select_pkt_'.strval($i);
										$paquetes= $this->input->post($indice);	
												
										if ( $fsm_pakt['cost_nombre_pkt'] === $paquetes)
										{
											$examen_ins['exam_nombre_pkt'] = $fsm_pakt['cost_nombre_pkt']; //nombre del paquete
											$examen_ins['serv_id'] = $serv_id;
											$examen_ins['exam_cve'] = $fsm_pakt['cost_examen_cve']; //lo que contiene el paquete
											$examen_ins['exam_monto'] = $fsm_pakt['cost_monto']; //lo que contiene el paquete								 	 
											$examen_ins['exam_cantidad'] = 1;
											$examen_ins['exam_estatus_cve'] = 'PEND';
											$examen_ins['exam_tipo_pkt'] = $fsm_pakt['cost_tipo_pkt'];
											$this->servicio->inserta_examen($examen_ins);
											//$i=$total_examenes_selectos+1;
										}							
									}	
							endforeach;
						endif;
						
						send_json_ok('Se guardó de forma correcta la orden de servicio.');
                    }
                    else
                    {
                       send_json_error('No se puede regsitrar el servicio, por favor revisa que la información este completa. ¿Esta marcado alguno de los paquetes y/o examen?');
                    }

            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $this->load->helper('template');
			//nuevo para despachos
			$data['despachos'] = $this->cliente->get_despachos();
			$data['empresas'] = $this->cliente->trae_empresas();
			$data['la_empresa'] = $emp_id;
            $params_view = array(
                'title' => 'Servicios',
                'view' => 'servicio/add_a',
				'view_data' => $data
               );
            render_template($params_view);  
        }
    }
/************************************************************************************/ 


/************************************************************************************/
public function nuevo_ss($emp_id)
    {
        if(isset($_POST) && count($_POST) > 0)     
        {
            $medico = $this->session->user;
            $this->load->library('form_validation');
            $this->form_validation->set_rules('orden','Pedido','required');
            //$this->form_validation->set_rules('emp_id','Empresa','required');
            $this->form_validation->set_rules('f_ini','Fecha inicio','required');
          //  $this->form_validation->set_rules('h_ini','Hora inicio','required');
            $this->form_validation->set_rules('f_fin','Fecha fin','required');
           // $this->form_validation->set_rules('h_fin','Hora fin','required');
            $this->form_validation->set_rules('descrip','Descripción','required');
            $this->form_validation->set_rules('ubicacion','Ubicación','required');
            //$this->form_validation->set_rules('responsable','Responsable','required');
            $this->form_validation->set_rules('estatus','Estatus','required');


            if($this->form_validation->run())
            {
                //$fecha_ini = formatea_fechahora_mysql($this->input->post('f_ini').' '.$this->input->post('h_ini'));
                //$fecha_fin = formatea_fechahora_mysql($this->input->post('f_fin').' '.$this->input->post('h_fin'));
                
				$bandera_anexo=0;
				$bandera_anexo1=0;
				
				$fecha_ini = $this->input->post('f_ini').' '.formatea_hora_mysql($this->input->post('h_ini'));
                $fecha_fin = $this->input->post('f_fin').' '.formatea_hora_mysql($this->input->post('h_fin'));
				
                $data_serv['serv_orden'] = $this->input->post('orden');
                $data_serv['emp_id'] = $this->input->post('emp_id');
                $data_serv['usr_id'] = $medico['usr_id'];
                $data_serv['serv_f_inicio'] = $fecha_ini;
                $data_serv['serv_f_fin'] = $fecha_fin;
                $data_serv['serv_desc'] = $this->input->post('descrip');
                $data_serv['serv_ubicacion'] = $this->input->post('ubicacion');
                $data_serv['serv_contacto_per'] = $this->input->post('responsable');
                $data_serv['serv_contacto_tel'] = limpia_telefono($this->input->post('telefono'));
                $data_serv['serv_acuerdos'] = $this->input->post('clausulas');
                $data_serv['serv_estatus_cve'] = $this->input->post('estatus');
				$data_serv['cei_id'] = $this->input->post('cei');
				$data_serv['cei_control_id'] = $this->input->post('cei_control');
				
				$data_serv['serv_viaticos'] = $this->input->post('viaticos');
				$data_serv['serv_costo_viaticos'] = $this->input->post('gastos_operacion');
				
				if ($this->input->post('folio_calendario') == "Sin Folio")
				{
					$data_serv['cal_folio'] = 0;
				}
				else
				{
					$data_serv['cal_folio'] = $this->input->post('folio_calendario');
				}
				
				$data_serv['desp_id'] = $this->input->post('despachos');
				$data_serv['reclutador'] = $this->input->post('reclutador');
				
				$data_serv=array_to_upper($data_serv);
				$data_serv['serv_tipo'] = "ESPECIALES";	
				
				
	
				/******NUEVOS ARCHIVO ANEXO ******************************/
                if(!empty($_FILES['anexo']['name']))
                {
					$nombre_anexo=$_FILES['anexo']['name'];
                    $this->load->library('upload');
					
					sleep(1);
                    $filename1 = $data_serv['emp_id'].'_'.'RQOC'.'_'.md5(time());
                    $config = array(
                            'upload_path'   => './../../files/anexos/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename1,
                            'allowed_types' => 'pdf',
                            'max_size'      => '10000'
                    );

                    $this->upload->initialize($config);
					
                    if ( ! $this->upload->do_upload('anexo'))
                    {
                          echo json_encode(array('status' => 'error','content' => $this->upload->display_errors()));
                        exit;
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_serv['serv_anexo_path'] = $data['file_name'];
						$data_serv['serv_anexo_nombre'] = $nombre_anexo;
						$bandera_anexo=1;
                    }
                }

	
				
				/******NUEVOS ARCHIVO ANEXO 1 ******************************/
                if(!empty($_FILES['anexo1']['name']))
                {
					$nombre_anexo=$_FILES['anexo1']['name'];
                    $this->load->library('upload');
					
					sleep(1);
                    $filename1 = $data_serv['emp_id'].'_'.'SD'.'_'.md5(time());
                    $config = array(
                            'upload_path'   => './../../files/anexos/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename1,
                            'allowed_types' => 'pdf',
                            'max_size'      => '10000'
                    );

                    $this->upload->initialize($config);
					
                    if ( ! $this->upload->do_upload('anexo1'))
                    {
                          echo json_encode(array('status' => 'error','content' => $this->upload->display_errors()));
                        exit;
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_serv['serv_anexo1_path'] = $data['file_name'];
						$data_serv['serv_anexo1_nombre'] = $nombre_anexo;
						$bandera_anexo1=1;
                    }
                }
				/***********************************************************/					
						$hay_exaamens =0;
						$total_examenes_selectos= $this->input->post('total_examenes_selectos');	
						$fsm_pakts= get_costos_paquetes_empresa($this->input->post('emp_id'));
						if($fsm_pakts):
							foreach($fsm_pakts as $fsm_pakt):										
									for($i=1; $i <= $total_examenes_selectos; $i++)
									{	
										$indice='examen_select_pkt_'.strval($i);
										$paquetes= $this->input->post($indice);	
												
										if ( $fsm_pakt['cost_nombre_pkt'] === $paquetes)
										{
											$hay_exaamens++;
										}
									}	
							endforeach;
						endif;
					
					
					
					if (($hay_exaamens >0) &&  ($bandera_anexo1==1) && ($bandera_anexo==1))
					{	
						$serv_id = $this->servicio->inserta($data_serv);
					}

					
					if($serv_id)
                    {
                        //inserta las obervaciones
                        if($this->input->post('obervaciones') != '')
                        {
                            $data_serv_obs['serv_id'] = $serv_id;
                            $data_serv_obs['usr_id'] = $medico['usr_id'];
                            $data_serv_obs['nota_f'] = date('Y-m-d H:i:s');
                            $data_serv_obs['nota_descripcion'] = $this->input->post('obervaciones');
                            $this->servicio->inserta_nota(array_to_upper($data_serv_obs));
                        }
	
						$total_examenes_selectos= $this->input->post('total_examenes_selectos');	
						$fsm_pakts= get_costos_paquetes_empresa($this->input->post('emp_id'));
						if($fsm_pakts):
							foreach($fsm_pakts as $fsm_pakt): 
										
									for($i=1; $i <= $total_examenes_selectos; $i++)
									{									
										$indice='examen_select_pkt_'.strval($i);
										$paquetes= $this->input->post($indice);	
												
										if ( $fsm_pakt['cost_nombre_pkt'] === $paquetes)
										{
											$examen_ins['exam_nombre_pkt'] = $fsm_pakt['cost_nombre_pkt']; //nombre del paquete
											$examen_ins['serv_id'] = $serv_id;
											$examen_ins['exam_cve'] = $fsm_pakt['cost_examen_cve']; //lo que contiene el paquete
											$examen_ins['exam_monto'] = $fsm_pakt['cost_monto']; //lo que contiene el paquete								 	 
											$examen_ins['exam_cantidad'] = 1;
											$examen_ins['exam_estatus_cve'] = 'PEND';
											$examen_ins['exam_tipo_pkt'] = $fsm_pakt['cost_tipo_pkt'];
											$this->servicio->inserta_examen($examen_ins);
											//$i=$total_examenes_selectos+1;
										}							
									}	
							endforeach;
						endif;
						
						send_json_ok('Se guardó de forma correcta la orden de servicio.');
                    }
                    else
                    {
                       send_json_error('No se puede regsitrar el servicio, por favor revisa que la información este completa. ¿Esta marcado alguno de los paquetes y/o examen? ¿Coloscaste los archivos requeridos?');
                    }

            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $this->load->helper('template');
			//nuevo para despachos
			$data['despachos'] = $this->cliente->get_despachos();
			$data['empresas'] = $this->cliente->trae_empresas();
			$data['la_empresa'] = $emp_id;
            $params_view = array(
                'title' => 'Servicios',
                'view' => 'servicio/add_ss',
				'view_data' => $data
               );
            render_template($params_view);  
        }
    }
/************************************************************************************/ 



/************************************************************************************/
public function nuevo_b()
    {
	
		$user = $this->session->user; 
		$user_root4=get_my_user_root4();
		$usuario = $this->medico->get($user['usr_id']);
	
        if(isset($_POST) && count($_POST) > 0)     
        {
            $medico = $this->session->user;
            $this->load->library('form_validation');
            $this->form_validation->set_rules('emp_id','Empresa','required');

            if($this->form_validation->run())
            {				
				$emp_id = $this->input->post('emp_id');
				
				$modo = $this->input->post('modo');
						
					if($emp_id)
                    {
						//send_json_ok('Se guardó de forma correcta la orden de servicio.');
						
						/****************************************************************/
						if($emp_id == 253)	
						  {	 
						   $servicios_hc = $this->input->post('servicios_hc');
						   if ($servicios_hc == 0)
						   {	   
								header('Location:'.base_url('servicio/edita_b').'/'.$emp_id);
						   }
						   else
						   {
								header('Location:'.base_url('servicio/edita_bsw').'/'.$emp_id);  
						   }	   
						   exit;
						  }
						  elseif($modo == 1)
						{
						   header('Location:'.base_url('servicio/edita_b').'/'.$emp_id.'/1');
						   exit;
						}
						else
						{
						  if($emp_id != 31)	
						  {	
								if (get_emp_osa($emp_id) == 3)
								{
									header('Location:'.base_url('servicio/edita_b_pedido').'/'.$emp_id);
								}
								else
								{
									header('Location:'.base_url('servicio/edita_b').'/'.$emp_id);
								}
						   
						   exit;
						  }
						  else
						  {	  
								$modo_hc = $this->input->post('modo_hc');
							   if ($modo_hc == 1)
							   {	   
								   header('Location:'.base_url('servicio/edita_hc').'/'.$emp_id);
								   exit;
							   }
							   else
							   {	  
								   header('Location:'.base_url('servicio/edita_b').'/'.$emp_id);
								   exit;
							  }				   
						  }							  
						}
						   
						/****************************************************************/
                    }
                    else
                    {
                        send_json_error('Ocurrió un error al guardar el servicio.');
                    }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
		    $this->load->helper('template');
			$this->load->model('empresa/Empresa_model','empresa');

			if (($usuario['emp_id'] == 31) && ($usuario['corporacion'] == 'GSI'))
			{
				$data['empresas'] = $this->empresa->get_all_empresas_gsi();
			}
			elseif ($user['usr_id'] == 701)
			{
				$data['empresas'] = $this->empresa->get_all_empresas_gsi();
			}
			elseif (($user_root4 == 6) || ($user['emp_id'] == 126) || (($user_root3 == 2) && ($user_root4 == 3)) )
			{
				$data['empresas'] = $this->empresa->get_all_empresas_gsi();
			}
			else
			{
			  $data['empresas'] = $this->cliente->trae_empresas();
            }			

				$params_view = array(
					'title' => 'Servicios',
					'view' => 'servicio/add_b',
					'view_data' => $data
				   );
			
			   
            render_template($params_view); 	
        }
        else 
        {
            $this->load->helper('template');		
			$this->load->model('empresa/Empresa_model','empresa');
			
			if (($usuario['emp_id'] == 31) && ($usuario['corporacion'] == 'GSI'))
			{
				$data['empresas'] = $this->empresa->get_all_empresas_gsi();
			}
			elseif ($user['usr_id'] == 701)
			{
				$data['empresas'] = $this->empresa->get_all_empresas_gsi();
			}
			elseif ($user['usr_id'] == 510) 
			{		
				$data['empresas'] = $this->empresa->get_all_empresas_subcorp('GSI', 'COMETRA');	
			}
			elseif (($user_root4 == 6) || ($user['emp_id'] == 126) || ($user['usr_id'] == 466) )
			{
				$data['empresas'] = $this->empresa->get_all_empresas_gsi();
			}
			elseif ( strstr($usuario['portal'],'CORPO') )
			{	
				
				$data['empresas'] = $this->empresa->get_all_empresas_subcorp($usuario['corporacion'], '');
			
			}			
			else
			{
			  $data['empresas'] = $this->cliente->trae_empresas();
            }	

			
			$params_view = array(
				'title' => 'Servicios',
				'view' => 'servicio/add_b',
				'view_data' => $data
			   );
			
            render_template($params_view);  
        }
    }
/************************************************************************************/
public function nuevo_s()
    {
        if(isset($_POST) && count($_POST) > 0)     
        {
            $medico = $this->session->user;
            $this->load->library('form_validation');
            $this->form_validation->set_rules('emp_id','Empresa','required');

            if($this->form_validation->run())
            {				
				$emp_id = $this->input->post('emp_id');
						
					if($emp_id)
                    {
						   header('Location:'.base_url('servicio/nuevo_ss').'/'.$emp_id);
						   exit;
                    }
                    else
                    {
                        //send_json_error('Ocurrió un error al guardar el servicio.');
                    }
            }
            else
            {
                //send_json_error(validation_errors('<div />'));
            }
		    $this->load->helper('template');
			$data['empresas'] = $this->cliente->trae_empresas();
            $params_view = array(
                'title' => 'Servicios',
                'view' => 'servicio/add_s',
				'view_data' => $data
               );
            render_template($params_view); 	
        }
        else 
        {
            $this->load->helper('template');
			$data['empresas'] = $this->cliente->trae_empresas();
            $params_view = array(
                'title' => 'Servicios',
                'view' => 'servicio/add_s',
				'view_data' => $data
               );
            render_template($params_view);  
        }
    } 

/************************************************************************************/
public function nuevo_c()
    {
        if(isset($_POST) && count($_POST) > 0)     
        {
            $medico = $this->session->user;
            $this->load->library('form_validation');
            //$this->form_validation->set_rules('orden','Pedido','required');
            $this->form_validation->set_rules('emp_id','Empresa','required');

            if($this->form_validation->run())
            {				
				$emp_id = $this->input->post('emp_id');
						
					if($emp_id)
                    {
						//send_json_ok('Se guardó de forma correcta la orden de servicio.');
						
						/****************************************************************/
						   header('Location:'.base_url('servicio/nuevo_a').'/'.$emp_id);
						   exit;
						/****************************************************************/
                    }
                    else
                    {
                        //send_json_error('Ocurrió un error al guardar el servicio.');
                    }
            }
            else
            {
                //send_json_error(validation_errors('<div />'));
            }
		    $this->load->helper('template');
			$data['empresas'] = $this->cliente->trae_empresas();
            $params_view = array(
                'title' => 'Servicios',
                'view' => 'servicio/add_c',
				'view_data' => $data
               );
            render_template($params_view); 	
        }
        else 
        {
            $this->load->helper('template');
			$data['empresas'] = $this->cliente->trae_empresas();
            $params_view = array(
                'title' => 'Servicios',
                'view' => 'servicio/add_c',
				'view_data' => $data
               );
            render_template($params_view);  
        }
    }


/************************************************************************************/   
    public function edita_bsw($emp_id,$modo=0)
    {
		$user = $this->session->user;
		$user_empresa=$user['emp_id'];
		$user_cei=get_cei_id();		
		
		$data['evento_dia'] = date('Y-m-d',strtotime($this->uri->segment(3)));
		$fecha_div = explode('T', $this->uri->segment(3));
		$error_gsi=0;
		
		$error_observaciones_puestos=0;
		

		
		if ($modo == 1)
		{
			$data['modo']=1;
		}
		else
		{
			$data['modo']=0;
		}
		
        if(isset($fecha_div[1]))
        {
            $data['hora_ini'] = date('H:i',strtotime($fecha_div[1]));
        }
        else
        {
            $data['hora_ini'] = date('H:i');
        }	
       
	   if(isset($_POST) && count($_POST) > 0)     
       {
            //recibe los datos
            $this->load->library('form_validation');
            $this->form_validation->set_rules('fecha_event_ini','Fecha inicia','required');
            $this->form_validation->set_rules('hora_event_ini','Hora inicia','required');
            $this->form_validation->set_rules('fecha_event_fin','Fecha fin','required');
            $this->form_validation->set_rules('hora_event_fin','Hora fin','required');			
			$this->form_validation->set_rules('observaciones','Observaciones','required');
			//$this->form_validation->set_rules('lugar','Lugar de realización de los servicios','required');
			
            if($this->form_validation->run())
            {
				
				
				
			 if ($error_observaciones_puestos == 0 )
			 {	 
				$total_examenes_selectos=$this->input->post('total_examenes_selectos');
				$paquetes='';
				$detecta_pkts=0;
				for($i=1; $i <= $total_examenes_selectos; $i++)
				{
					$indice='examen_select_pkt_'.strval($i);
					if ($this->input->post($indice) != NULL)
					{	
					$paquetes.=$this->input->post($indice).';';
					$detecta_pkts++;
					}
					
				}				
				
				$id_horario=0;					
				$cuantos_evaluados=0;
				$los_evaluados=$this->input->post('evaluados');
				$modo=$this->input->post('modo');
				
				if ($user['usr_id'] == 466) /*es unidad reclutadora*/
				{
					$modo=1;
				}
				
				if ((valida_corporacion($emp_id,'GSI') == 'GSI') && ($modo==0) &&  ( ($user_cei == 4) || ($user_cei == 8) ))
				{
					$id_horario=$this->input->post('horario');
					
					$cuantos_evaluados=$this->input->post('num_eva');
					
					if (!($cuantos_evaluados > 0))
					{
						$cuantos_evaluados=1;
					}
					
					$horario_ok=$this->agenda->valida_horario($id_horario,$cuantos_evaluados,$table);
					
					if ($horario_ok)
					{


						
						/*$el_eva1 = strstr($this->input->post('evaluado1'), ' - ', true); 
						$el_eva2 = strstr($this->input->post('evaluado2'), ' - ', true); 
						$el_eva3 = strstr($this->input->post('evaluado3'), ' - ', true); 
						$cuantos_evaluados=0;
						if (strlen($this->input->post('evaluado1')) > 3) {$cuantos_evaluados++;}
						if (strlen($this->input->post('evaluado2')) > 3) {$cuantos_evaluados++;}
						if (strlen($this->input->post('evaluado3')) > 3) {$cuantos_evaluados++;}
						*/
						
												//$el_eva1 = strstr($this->input->post('evaluado1'), ' - ', true); 
						//$el_eva2 = strstr($this->input->post('evaluado2'), ' - ', true); 
						//$el_eva3 = strstr($this->input->post('evaluado3'), ' - ', true); 

						$cuantos_evaluados=0;
						if (strlen($this->input->post('evaluado1')) > 3) 
						{
							if (($horario_ok['she_capacidad']-$cuantos_evaluados) > 0)
							{	
								$el_eva1 = strstr($this->input->post('evaluado1'), ' - ', true); 
								$cuantos_evaluados++;
							}
							else
							{
								$el_eva1 =0;
							}	
						}
						if (strlen($this->input->post('evaluado2')) > 3) 
						{
							if (($horario_ok['she_capacidad']-$cuantos_evaluados) > 0)
							{	
								$el_eva2 = strstr($this->input->post('evaluado2'), ' - ', true); 
								$cuantos_evaluados++;
							}
							else
							{
								$el_eva2 =0;
							}	
						}
						if (strlen($this->input->post('evaluado3')) > 3) 
						{	
							if (($horario_ok['she_capacidad']-$cuantos_evaluados) > 0)
								{	
									$el_eva3 = strstr($this->input->post('evaluado3'), ' - ', true); 
									$cuantos_evaluados++;
								}
								else
								{
									$el_eva3 =0;
								}
						}
						
						$horario_ok['she_capacidad']=$horario_ok['she_capacidad']-$cuantos_evaluados;
						$horario_apartado=$this->agenda->aparta_horario($id_horario,$horario_ok,$table);
	
						$fecha_ini = $horario_ok['she_fecha'].' '.$horario_ok['she_hora_ini'].':02';
						$fecha_fin = $horario_ok['she_fecha'].' '.$horario_ok['she_hora_fin'].':02';			
						

						foreach (explode(';', $paquetes) as $detalle)
						{
							if ( strlen($detalle) > 0)
							{												
								$exa_sel['nomserv'].= get_nombre_de_examen_por_empresa($detalle,$emp_id);							
							}
						}

				
					$k=0;
						if ( $el_eva1 > 0)
						{
						$cliente_gsi_id = $this->cliente->actualiza( $el_eva1,$exa_sel);
						}
											
						if ( $el_eva2 > 0)
						{
						$cliente_gsi_id = $this->cliente->actualiza($el_eva2,$exa_sel);
						}
						if ( $el_eva3 > 0)
						{
						$cliente_gsi_id = $this->cliente->actualiza($el_eva3,$exa_sel);
						}						

						$los_evaluados='';
						
						if ( $el_eva1 > 0)
						{
							$los_evaluados.=' | '.$this->input->post('evaluado1').' | ';
							$k++;
						}
						if ( $el_eva2 > 0)
						{
							$los_evaluados.=' | '.$this->input->post('evaluado2').' | ';
							$k++;
						}
						if ( $el_eva3 > 0)
						{
							$los_evaluados.=' | '.$this->input->post('evaluado3').' | ';
							$k++;
						}	
										
					/*	$los_evaluados=' | '.$exa_sel['nomserv'].' | ';*/	
					}
					else
					{
						$fecha_ini='21-01-01 01:01:01';
						$fecha_fin='21-01-01 01:01:01';
						$error_gsi=1;
					}
					
				}
				else
				{
					$fecha_ini = formatea_fechahora_mysql($this->input->post('fecha_event_ini').' '.$this->input->post('hora_event_ini'));
					$fecha_fin = formatea_fechahora_mysql($this->input->post('fecha_event_fin').' '.$this->input->post('hora_event_fin'));					
				}				
		    
	

				$params = array
				(
					'cal_pkts' => $paquetes,
					//Observaciones
					'cal_observaciones' =>$this->input->post('observaciones'),
					//Evaluados
					'cal_evaluados' => $los_evaluados, 	
					//Solicitante
					'cal_usr_nombre' => $user['usr_nombre'],
					'cal_usr_paterno' => $user['usr_paterno'],
					'cal_usr_materno' => $user['usr_materno'],
					'cal_usr_correo' => $user['usr_correo'],					
					//datos normales de calendario	
                    'cal_fecha' => $this->input->post('fecha'),
                    'cal_titulo' => $this->input->post('asunto'),
                    'cal_servicio' => NULL,
                    'cal_descripcion' => $this->input->post('descripcion'),
                    'cal_fecha_ini' => $fecha_ini,
                    'cal_fecha_fin' => $fecha_fin,
					'cal_id_horario' => $id_horario,					
					'cal_cuantos_evaluados' => $cuantos_evaluados,
                    'cal_uid' => uniqid(rand(0, getmypid()))					
                );

				if ( ($emp_id == 298) || ($emp_id == 152) || ($emp_id  == 193) || ($emp_id  == 210) || ($emp_id  == 311))
				{	
					if (strlen($this->input->post('hc1')) > 0)
					{
						$params['hc1'] =$this->input->post('hc1');
					}

					if (strlen($this->input->post('hc2')) > 0)
					{
						$params['hc2'] =$this->input->post('hc2');
					}

					if (strlen($this->input->post('hc3')) > 0)
					{
						$params['hc3'] =$this->input->post('hc3');
					}				
				}

				if ($user['emp_id'] == 31)
				{					
					$params['emp_id'] = $emp_id;
				}				
				elseif  (
							($user['emp_id'] == 126)   ||
							($user['emp_id'] ==125)   ||
							($user['emp_id'] ==33)   ||
							($user['emp_id'] ==179)   ||
							($user['emp_id'] ==181)   ||
							($user['emp_id'] ==180)   ||
							($user['emp_id'] ==77)   ||
							($user['emp_id'] ==176)   ||
							($user['emp_id'] ==178)   ||
							($user['emp_id'] ==177)   ||
							($user['emp_id'] ==57)   ||
							($user['emp_id'] ==175)   ||
							($user['emp_id'] ==174)   ||						 
							($user['emp_id'] == 127)    
							|| ($user['emp_id'] == 183)
							|| ($user['emp_id'] ==33)
							|| ($user['emp_id'] ==77)
							|| ($user['emp_id'] ==106)
							|| ($user['emp_id'] ==148)							
						)/*es un despacho de GSI*/
				{
					$params['emp_id'] = $emp_id;
					$params['desp_emp_id'] = $this->input->post('empresa');
				}
				else
				{
					$params['emp_id'] = $emp_id;
					$params['desp_emp_id'] = 0;
				}
				
				

				
                $params['cal_lugar'] = $this->input->post('lugar');
				
				if ( ($emp_id != 298) && ($emp_id != 152) && ($emp_id  != 193)  && ($emp_id  != 210))
				{					
					$params['cal_lugar_det'] = $this->input->post('lugar_det');
					
                }
				else
				{								
					if ($params['cal_lugar'] == 0)
					{
						//$params['cal_lugar_det'] = $this->input->post('lugar_det');
						
						$domicilio=$this->input->post('calle').' ';
						$domicilio.=$this->input->post('next').' '.$this->input->post('nint').' ';
						$domicilio.=$this->input->post('colonia').', ';
						$domicilio.='C.P. '.$this->input->post('cp').', ';
						$domicilio.=$this->input->post('municipio').', ';
						$domicilio.=$this->input->post('localidad').', ';
						$domicilio.=$this->input->post('entidad').', ';
						$domicilio.=$this->input->post('pais').'.';

						$params['cal_lugar_det'] = 	$domicilio;	

						$params['cal_eva_telefono_1'] = $this->input->post('telefono_1');						
						$params['cal_eva_telefono_2'] = $this->input->post('telefono_2');						
						
					}
					elseif ($params['cal_lugar'] == 2) 
					{	
						$params['cal_lugar_det'] ='Calle San Borja 1365, Vértiz Narvarte, Benito Juárez, C.P. 03600, CDMX'; 
					}
					else
					{	
						$params['cal_lugar_det'] = 'Paseo de la Reforma No. 342, Piso 14, Col. Juárez, Del. Cuauhtémoc, C.P. 06600, CDMX';  
					}							
			
				}

                $params['cal_email'] = $user['usr_correo'].'; '.$this->input->post('mail');


				/*if (($emp_id == 152) || ($emp_id  == 193))
				{*/	
				/***********************************************************/				
				/******NUEVOS ARCHIVO ANEXO 0 ******************************/
				if(!empty($_FILES['anexo']['name']))
				{
					$nombre_anexo=$_FILES['anexo']['name'];
					$this->load->library('upload');
					$filename = md5(time());
					$config = array(
							'upload_path'   => './../../files/anexos/',
							'overwrite'     => TRUE,
							'file_name'     => $filename,
							'allowed_types' => 'doc|docx|pdf|txt|xlsx|xls|png|jpg|jpeg',
							'max_size'      => '10000'
					);

					$this->upload->initialize($config);
					
					if ( ! $this->upload->do_upload('anexo'))
					{
						echo json_encode(array('status' => 'error','content' => $this->upload->display_errors()));
						exit;
					}
					else 
					{
						$data = $this->upload->data();
						$params['cal_anexo_path'] = $data['file_name'];
						$params['cal_anexo_nombre'] = $nombre_anexo;
						$data_serv['serv_anexo_path'] = $data['file_name'];
						$data_serv['serv_anexo_nombre'] = $nombre_anexo;
						
					}
				/*}*/
				/***********************************************************/	
				}

				/******NUEVOS ARCHIVO ANEXO 1 ******************************/
                if(!empty($_FILES['anexo1']['name']))
                {
					$nombre_anexo=$_FILES['anexo1']['name'];
                    $this->load->library('upload');
					
					sleep(1);
                    $filename1 = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/anexos/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename1,
                            'allowed_types' => 'doc|docx|pdf|txt|xlsx|xls|png|jpg|jpeg',
                            'max_size'      => '10000'
                    );

                    $this->upload->initialize($config);
					
                    if ( ! $this->upload->do_upload('anexo1'))
                    {
                          echo json_encode(array('status' => 'error','content' => $this->upload->display_errors()));
                        exit;
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $params['cal_anexo1_path'] = $data['file_name'];
						$params['cal_anexo1_nombre'] = $nombre_anexo;
						$data_serv['serv_anexo1_path'] = $data['file_name'];
						$data_serv['serv_anexo1_nombre'] = $nombre_anexo;
                    }
                }
				/***********************************************************/				
				
				//if (($emp_id == 152) || ($emp_id  == 193))
				{	
				/******NUEVOS ARCHIVO ANEXO 2 ******************************/
								if(!empty($_FILES['anexo2']['name']))
								{
									$nombre_anexo=$_FILES['anexo2']['name'];
									$this->load->library('upload');
									
									sleep(1);
									$filename2 = md5(time());
									$config2 = array(
											'upload_path'   => './../../files/anexos/',
											'overwrite'     => TRUE,
											'file_name'     => $filename2,
											'allowed_types' => 'doc|docx|pdf|txt|xlsx|xls|png|jpg|jpeg',
											'max_size'      => '10000'
									);

									$this->upload->initialize($config2);
									
									if ( ! $this->upload->do_upload('anexo2'))
									{

										echo json_encode(array('status' => 'error','content' => $this->upload->display_errors()));
										exit;
									}
									else 
									{
										$data = $this->upload->data();
										$params['cal_anexo2_path'] = $data['file_name'];
										$params['cal_anexo2_nombre'] = $nombre_anexo;
										$data_serv['serv_anexo2_path'] = $data['file_name'];
										$data_serv['serv_anexo2_nombre'] = $nombre_anexo;
									}
								}
				/***********************************************************/	
				/******NUEVOS ARCHIVO ANEXO 3 ******************************/
								if(!empty($_FILES['anexo3']['name']))
								{
									$nombre_anexo=$_FILES['anexo3']['name'];
									$this->load->library('upload');
									
									sleep(1);
									$filename3 = md5(time());
									$config3 = array(
											'upload_path'   => './../../files/anexos/',
											'overwrite'     => TRUE,
											'file_name'     => $filename3,
											'allowed_types' => 'doc|docx|pdf|txt|xlsx|xls|png|jpg|jpeg',
											'max_size'      => '10000'
									);

									$this->upload->initialize($config3);
									
									if ( ! $this->upload->do_upload('anexo3'))
									{

										echo json_encode(array('status' => 'error','content' => $this->upload->display_errors()));
										exit;
									}
									else 
									{
										$data = $this->upload->data();
										$params['cal_anexo3_path'] = $data['file_name'];
										$params['cal_anexo3_nombre'] = $nombre_anexo;
										$data_serv['serv_anexo3_path'] = $data['file_name'];
										$data_serv['serv_anexo3_nombre'] = $nombre_anexo;
										
									}
								}
				/***********************************************************/	
				/******NUEVOS ARCHIVO ANEXO 4 ******************************/
								if(!empty($_FILES['anexo4']['name']))
								{
									$nombre_anexo=$_FILES['anexo4']['name'];
									$this->load->library('upload');
									
									sleep(1);
									$filename4 = md5(time());
									$config = array(
											'upload_path'   => './../../files/anexos/',
											'overwrite'     => TRUE,
											'file_name'     => $filename4,
											'allowed_types' => 'doc|docx|pdf|txt|xlsx|xls|png|jpg|jpeg',
											'max_size'      => '10000'
									);

									$this->upload->initialize($config);
									
									if ( ! $this->upload->do_upload('anexo4'))
									{

										echo json_encode(array('status' => 'error','content' => $this->upload->display_errors()));
										exit;
									}
									else 
									{
										$data = $this->upload->data();
										$params['cal_anexo4_path'] = $data['file_name'];
										$params['cal_anexo4_nombre'] = $nombre_anexo;
										$data_serv['serv_anexo4_path'] = $data['file_name'];
										$data_serv['serv_anexo4_nombre'] = $nombre_anexo;
									}
								}
				/***********************************************************/	
				}

/****************** Estructura para generar Orden de Servicio*****************************************/

				$params['cei_control_id'] = $this->input->post('cei_control');
				$data_serv['cei_control_id'] = $this->input->post('cei_control');

				if (($user['emp_id'] == 31) &&  (strlen($this->input->post('serv_orden')) > 0))
				{					
					$params['serv_orden'] = $this->input->post('serv_orden');
					$data_serv['serv_orden'] =$this->input->post('serv_orden');
				}
				else
				{	
					$f = new DateTime();
					$ff= 'PROVISIONAL_'. $f->getTimestamp();			
					$params['serv_orden']= $ff;
					$data_serv['serv_orden'] = $ff;
				}	
				

					if (!(valida_corporacion($emp_id,'GSI') === 'GSI') || ($emp_id !=31) )
					{	
						$data_serv['emp_id'] =  $emp_id;
						$data_serv['usr_id'] = $user['usr_id'];
						$data_serv['serv_f_inicio'] = $fecha_ini;
						$data_serv['serv_f_fin'] = $fecha_fin;
						$data_serv['serv_desc'] = $this->input->post('observaciones');
						$data_serv['serv_ubicacion'] =   $this->input->post('lugar');
						// $this->input->post('ubicacion');
						//$data_serv['serv_contacto_per'] = $this->input->post('responsable');
						//$data_serv['serv_contacto_tel'] = limpia_telefono($this->input->post('telefono'));
						//$data_serv['serv_acuerdos'] = $this->input->post('clausulas');
						$data_serv['serv_estatus_cve'] = 'PROCESO';//$this->input->post('estatus');
						$data_serv['cei_id'] = $user['cei_id'];//$this->input->post('lugar');//$params['cal_lugar'];
						//$data_serv['desp_id'] = $this->input->post('despachos');
						//$data_serv['reclutador'] = $this->input->post('reclutador');
					}

/***********************************************************/
                if (($params['emp_id'] > 0) && ($detecta_pkts > 0) )
				{	
					//se crea evento en agenda
					$cal_id = $this->agenda->add_evento_folio(array_to_upper($params));
					$serv_id=0;
					
					if ( 	
							(!(valida_corporacion($emp_id,'GSI') === 'GSI')) &&  
							($emp_id != 298) &&  
							($emp_id != 152) && 
							($emp_id != 193) && 
							($emp_id != 31)  &&
							($emp_id != 321)
						)
					{
						
						$data_serv['cal_folio'] = $cal_id;
						$data_serv['cal_id'] = $cal_id;
						
						
						$serv_id = $this->servicio->inserta(array_to_upper($data_serv));			

						
						$total_examenes_selectos= $this->input->post('total_examenes_selectos');	
						$fsm_pakts= get_costos_paquetes_empresa($emp_id);
						if($fsm_pakts):
							foreach($fsm_pakts as $fsm_pakt): 
										
									for($i=1; $i <= $total_examenes_selectos; $i++)
									{									
										$indice='examen_select_pkt_'.strval($i);
										$paquetes= $this->input->post($indice);	
												
										if ( $fsm_pakt['cost_nombre_pkt'] === $paquetes)
										{
											$examen_ins['exam_nombre_pkt'] = $fsm_pakt['cost_nombre_pkt']; //nombre del paquete
											$examen_ins['serv_id'] = $serv_id;
											$examen_ins['exam_cve'] = $fsm_pakt['cost_examen_cve']; //lo que contiene el paquete
											$examen_ins['exam_monto'] = $fsm_pakt['cost_monto']; //lo que contiene el paquete								 	 
											$examen_ins['exam_cantidad'] = 1;
											$examen_ins['exam_estatus_cve'] = 'PEND';
											$examen_ins['exam_tipo_pkt'] = $fsm_pakt['cost_tipo_pkt'];
											$this->servicio->inserta_examen($examen_ins);
										}							
									}	
							endforeach;
						endif;	
					}

					
					if ( ($emp_id == 298) || ($emp_id == 152) ||  ($emp_id  == 193) ||  ($emp_id  == 210) ||  ($emp_id  == 311))
					{						
						//se extraen examenes de los paquetes para evaluados de seguros
						$nomserv='';
						
						$cat_examen = get_cat_nombre_var('EXAMEN');		
						$cat_categorias = get_cat_nombre_var('CATEGORIA_EX');
						foreach($cat_categorias as $categoria): 
							$linea_examenes=get_examen_de_empresa_por_categoria($emp_id, $categoria['cat_nombre']);
							
							if (strlen($linea_examenes) > 0)
							{
								foreach (explode(';', $linea_examenes) as $det):
									if (strlen($det) > 0)
									{
											$exa=$det.';';
											$nomserv.=$exa;
											
									}
								endforeach;										
							}
						endforeach;					
				
						$data_clte['nomserv'] =  $nomserv;	

						//evaluados de seguros

							$j=1;
							for($i=1; $i <= 4; $i++)
							{	
								if 	(
									(strlen($this->input->post('nombre'.strval($i)))>0) &&
									(strlen($this->input->post('paterno'.strval($i)))>0)
									)
									
								{
								//informncion general de evaluado
								$data_clte['clte_nombre_crypt'] =  trim($this->input->post('nombre'.strval($i)));
								$data_clte['clte_2_nombre_crypt'] =  trim($this->input->post('nombre_adic'.strval($i)));
								$data_clte['clte_paterno_crypt'] =  trim($this->input->post('paterno'.strval($i)));
								$data_clte['clte_materno_crypt'] =  trim($this->input->post('materno'.strval($i)));
								$data_clte['clte_f_nac'] = formatea_fecha_mysql($this->input->post('fnac'.strval($i)));
								$data_clte['clte_genero_cve'] =  $this->input->post('genero'.strval($i));                				
								

								$data_clte['clte_rfc_crypt']=substr($data_clte['clte_paterno_crypt'],0,2).substr($data_clte['clte_materno_crypt'],0,1).substr($data_clte['clte_nombre_crypt'],0,1).substr($data_clte['clte_f_nac'],2,2).substr($data_clte['clte_f_nac'],5,2).substr($data_clte['clte_f_nac'],8,2);

								//$data_clte['clte_rfc_crypt'] =  $this->input->post('rfc'.strval($i));                				
			
								//$data_clte['clte_curp_crypt'] =  $this->input->post('curp'.strval($i));     
								//Orden de Servicio Asociada
								$data_clte['serv_id'] =  $this->input->post('serv_id');
								//domicilio del evaluado*/
								$data_clte['clte_env_pais_cve'] =  $this->input->post('pais');
								$data_clte['clte_env_cp'] =  $this->input->post('cp');
								$data_clte['clte_env_edo_cve'] =  $this->input->post('entidad');
								$data_clte['clte_env_colonia_crypt'] =  $this->input->post('colonia');
								$data_clte['clte_env_localidad'] =  $this->input->post('localidad');
								$data_clte['clte_env_municipio'] =  $this->input->post('municipio');
								$data_clte['clte_env_calle_crypt'] =  $this->input->post('calle');
								$data_clte['clte_env_num_ext_crypt'] =  $this->input->post('next');
								$data_clte['clte_env_num_int_crypt'] =  $this->input->post('nint');
								
												
								//informacion de contacto del evaluado
								/*$data_clte['clte_nss_crypt'] =  $this->input->post('nss'.strval($i)); 
								$data_clte['clte_tel_casa_crypt'] =  limpia_telefono($this->input->post('tel'.strval($i)));                
								$data_clte['clte_cel_crypt'] =  limpia_telefono($this->input->post('cel'.strval($i)));
								$data_clte['clte_email_crypt'] =  $this->input->post('correo'.strval($i)); */               
								//nuevos campos
								/*$data_clte['clte_grado_acad_cve'] =  $this->input->post('grado'.strval($i));
								$data_clte['clte_puesto'] =  $this->input->post('puesto'.strval($i));*/
								$data_clte['clte_edo_civ_cve'] =  $this->input->post('civil'.strval($i));
								/*$data_clte['clte_nac_cve'] =  $this->input->post('nac'.strval($i));  */              
								//empresa donde va a loborar la persona
								$data_clte['emp_id'] =  $emp_id;  
								$data_clte['cei_id'] =  $this->input->post('cei_control');
								
																
								if ($emp_id == 298)
								{
									$data_clte['nomserv'] =  'EMVX+';
								}
								elseif ($emp_id == 152)
								{
									$data_clte['nomserv'] =  'SGMTY';
								}
								elseif ($emp_id  == 193)
								{
									$data_clte['nomserv'] =  'ALLIANZ';
								}
								elseif ($emp_id  == 210)
								{
									$data_clte['nomserv'] =  'INSIGNIA';
								}	
								
								//nuevo campo de ubicacion
								/*$data_clte['clte_lab_ubicacion'] =  $this->input->post('ubicacion'.strval($i));					

								$data_clte['desp_id'] =  $this->input->post('despacho'.strval($i));
								$data_clte['clte_reclutador'] =  $this->input->post('reclutador'.strval($i));					
								¨*/
								$cliente_id = $this->cliente->inserta(array_to_upper($data_clte));
								
								$param['eva'.strval($j)]=$cliente_id;
								$j++;
								
								}					
							}
					}
					
					//el titulo del servicio y evento se actualiza segun empresa 
					if ( ($emp_id == 298) || ($emp_id == 152) || ($emp_id == 193) || ($emp_id == 311) )
					{		
						
						if ($emp_id == 298)
						{
							$param['cal_titulo']= 'BX+ - ';
						}
						elseif ($emp_id == 152)
						{
							$param['cal_titulo']= 'SMTY - ';
						}
						elseif ($emp_id == 193)
						{
							$param['cal_titulo']= 'ALLIANZ - ';
						}
						elseif ($emp_id == 311)
						{
							$param['cal_titulo']= 'GNP - ';
						}
						else
						{
							$param['cal_titulo']= '';
						}	
						
						$eva0=strtoupper(trim($this->input->post('nombre1')).' '.trim($this->input->post('paterno1')).' '.trim($this->input->post('materno1')));
						$param['cal_titulo'].=$eva0;
						
						
						if (strlen($this->input->post('nombre2')) > 0) 
							{
								$eva0=chr(10).strtoupper(trim($this->input->post('nombre2')).' '.trim($this->input->post('paterno2')).' '.trim($this->input->post('materno2')));
								$param['cal_titulo'].=$eva0; 
							}	
						
						if (strlen($this->input->post('nombre3')) > 0) 
							{
								$eva0=chr(10).strtoupper(trim($this->input->post('nombre3')).' '.trim($this->input->post('paterno3')).' '.trim($this->input->post('materno3')));
								$param['cal_titulo'].=$eva0; 
							}	
						
						if (strlen($this->input->post('nombre4')) > 0) 
							{
								$eva0=chr(10).strtoupper(trim($this->input->post('nombre4')).' '.trim($this->input->post('paterno4')).' '.trim($this->input->post('materno4')));
								$param['cal_titulo'].=$eva0; 
							}						
						
						$param['cal_titulo'].=' ** '.get_options_per_grupo('HC_SEGUROS', $params['hc1']);		
						
					}elseif (($emp_id == 210) /*|| ($emp_id == 193)*/ )
					{				
						$param['cal_titulo']= get_empresa($params['emp_id']).' ';
						$eva0=strtoupper(trim($this->input->post('nombre1')).' '.trim($this->input->post('paterno1')).' '.trim($this->input->post('materno1')));
						$param['cal_titulo'].=$eva0;
						
						
						if (strlen($this->input->post('nombre2')) > 0) 
							{
								$eva0=chr(10).strtoupper(trim($this->input->post('nombre2')).' '.trim($this->input->post('paterno2')).' '.trim($this->input->post('materno2')));
								$param['cal_titulo'].=$eva0; 
							}	
						
						if (strlen($this->input->post('nombre3')) > 0) 
							{
								$eva0=chr(10).strtoupper(trim($this->input->post('nombre3')).' '.trim($this->input->post('paterno3')).' '.trim($this->input->post('materno3')));
								$param['cal_titulo'].=$eva0; 
							}	
						
						if (strlen($this->input->post('nombre4')) > 0) 
							{
								$eva0=chr(10).strtoupper(trim($this->input->post('nombre4')).' '.trim($this->input->post('paterno4')).' '.trim($this->input->post('materno4')));
								$param['cal_titulo'].=$eva0; 
							}						
						
						$param['cal_titulo'].=' ** '.get_options_per_grupo('HC_SEGUROS', $params['hc1']);		
						
					}
					else
					{	
						if ($serv_id == 0 )
						{
							$param['cal_titulo']= get_empresa($params['emp_id']).', IDA:'.$cal_id; 
						}
						else
						{
							$param['cal_titulo']= get_empresa($params['emp_id']).', OS:'.$serv_id.', IDA:'.$cal_id; 
						}
					}					

										
					$param['serv_id']=$serv_id;
					$this->agenda->update_evento($cal_id,$param);	

				
				}
	 
	         }
				if ( ($cal_id) && ($error_gsi == 0) && ($error_observaciones_puestos == 0) )
                {
                        $this->load->helper('mail');
                        $evento = $this->agenda->get_evento($cal_id);
						
                        $data_email = array('evento' => $evento);						
                        $html = $this->load->view('agenda/email_add_evento_servicio',$data_email,TRUE);
                      /****************************/
					  /*solo para pruebas         */					  
					  /*****************************/
					  //$user['usr_nombre'] ='USUARIO DE PRUEBAS';
					  //$user['usr_paterno'] ='PRUEBAS';
					  //$user['usr_correo']= 'antoniovallejo@gmail.com';
					  /*****************************/
							$this->load->helper('mail');
							//$this->load->helper('mailer');							
							//manda_correo();
							if ($emp_id == 31)
							{
								$this->load->model('empresa/Empresa_model','empresa');
								
								$data_empresa = $this->empresa->get_empresa_by_id($emp_id);
								
								send_mail_std_event_serv(
								$this->input->post('mail'), 
								$evento, 
								$html,
								$cal_id,
								get_empresa($params['emp_id']),
								$user['usr_nombre'].' '.$user['usr_paterno'],
								$user['usr_correo'],
								$data_empresa['emp_responsable'] , 
								$data_empresa['emp_correo']
								,$params['cal_lugar'] );

							}
								else
							{

								send_mail_std_event_serv(
								$this->input->post('mail'), 
								$evento, 
								$html,
								$cal_id,
								get_empresa($emp_id),
								$user['usr_nombre'].' '.$user['usr_paterno'],
								$user['usr_correo'],
								'',
								'',
								$params['cal_lugar'] );

							}
							
			
                    send_json_ok('Se guardó de forma correcta.');
                }
                else
                {   if ($error_observaciones_puestos == 1)
					{
						send_json_error('Ha ocurrido un error en los campos de OBSERVACIONES y PUESTOS, por favor revisar.');
					}
			        elseif ($error_gsi == 0)
					{
						if ($detecta_pkts > 0)
						{
							send_json_error('Ocurrió un error al guardar, por favor revise si toda su información esta completa y vuelva intentar.');
						}
						else
						{
							send_json_error('Ocurrió un error al guardar, ¿eligio al menos un examen para este servicio?');
						}
					}
					else
					{
						send_json_error('No pudo agendarse la fecha deseada, Por favor busque otra fecha con la capacidad deseada.');
					}
				
                }				
				
				
			}
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
			
  			if($this->uri->segment(3) != '')
            {
                $data['evento_dia'] = date('Y-m-d',strtotime($this->uri->segment(3)));
            }
            else
            {
                $data['evento_dia'] = date('Y-m-d');
            }
			
			
			$data['evento_dia'] = date('Y-m-d');
			$data['empresa'] = $emp_id;
			
			$date_string = date('Y-m-d'); // "2021-02-19";
			//echo 'date: '.date('Y-m-d')." Weeknummer: " . intval(date("W", strtotime($date_string)));			
			
			
			if (($user_cei == 4) || ($user_cei == 8))
			{	
				$data['sheduler']=$this->agenda->horario(intval(date("W", strtotime($date_string))),$table);
			}
			
			
			if ($user['emp_id'] == 126)
			{
				$data['evaluados'] = $this->cliente->get_allo_gsi_agenda_reclutadoras(60,$user['emp_id']);	
			}
			else
			{
				$data['evaluados'] = $this->cliente->get_allo_gsi_agenda(60,$emp_id);
			}
			
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Servicios',
                'view' => 'servicio/edit_bsw',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }



/************************************************************************************/   
    public function edita_b_pedido($emp_id,$modo=0)
    {
		if (get_emp_osa($emp_id) == 3)
		{	
			$control_empresa_osa_3=$emp_id;
		}
		else
		{
			$control_empresa_osa_3=36000;
		}
		
		
		$user = $this->session->user;
		$usuario = $this->medico->get($user['usr_id']);
		$user_empresa=$user['emp_id'];
		$user_cei=get_cei_id();		
		
		$data['evento_dia'] = date('Y-m-d',strtotime($this->uri->segment(3)));
		$fecha_div = explode('T', $this->uri->segment(3));
		$error_gsi=0;
		
		$error_observaciones_puestos=0;
		
		/*SE PREPARA A USAR EL SCHEDULER REQUERIDOS*/
		if (strstr($usuario['portal'],'ALPURA'))
		{
			$table='doc12_sheduler';
		}
		elseif (strstr($usuario['acciones'],'SBORJA+'))
		{
			$table='doc09_sheduler';
		}
		elseif ($user_cei == 4)
		{	
			$table='doc10_sheduler';
		}
		elseif ($user_cei == 8)
		{	
			$table='doc11_sheduler';
		}
	

		
		if ($modo == 1)
		{
			$data['modo']=1;
		}
		else
		{
			$data['modo']=0;
		}
		
        if(isset($fecha_div[1]))
        {
            $data['hora_ini'] = date('H:i',strtotime($fecha_div[1]));
        }
        else
        {
            $data['hora_ini'] = date('H:i');
        }	
       
	   if(isset($_POST) && count($_POST) > 0)     
       {
            //recibe los datos
            $this->load->library('form_validation');
           
			if (
				($emp_id == 298) ||  /*SEGUROS BX+ */
				($emp_id == 152) ||  /*SEGUROS MONTERREY*/
				($emp_id  == 193) || /*ALLIANZ*/
				($emp_id  == 210) || /*INSIGNIA LIFE*/
				($emp_id  == 230) || /*AXA*/
				($emp_id  == 142) || /*GENERAL DE SEGUROS*/
				($emp_id  == 311)    /*GNP*/
				|| (get_emp_osa($emp_id) == 3)
			 )
			{	
			
				if ($emp_id == 193)
				{					
					$this->form_validation->set_rules('fsm_autoriza','Autoriza ha Realizar Confirmación','required');
					$this->form_validation->set_rules('nombre1','Nombre de Evaluado','required');
					$this->form_validation->set_rules('paterno1','Apellido Paterno del Evaluado','required');
					$this->form_validation->set_rules('materno1','Apellido Materno del Evaluado','required');
					$this->form_validation->set_rules('materno1','Apellido Materno del Evaluado','required');
					$this->form_validation->set_rules('cp','Código Postal de la dirección del evaluado','required');
					
				}
				elseif ($user['emp_id'] == 31)
				{
					
					
					if ( ($emp_id == 15200) || ($emp_id  == 230) || ($emp_id  == 311) )
					{	
						$this->form_validation->set_rules('serv_orden','Orden de Servicio/Pedido','required');
						$this->form_validation->set_rules('fsm_viaticos','Viáticos','required');
					}
					
					if ($emp_id == 152)
					{					
						$this->form_validation->set_rules('zona','Zona','required');
						if ($this->input->post('zona')=='ZONA 1')
						{ $this->form_validation->set_rules('region1','Región de Zona 1','required'); }
						elseif ($this->input->post('zona')=='ZONA 2')
						{ $this->form_validation->set_rules('region2','Región de Zona 2','required'); }
						if ($this->input->post('zona')=='ZONA 3')
						{ $this->form_validation->set_rules('region3','Región de Zona 3','required'); }
						if ($this->input->post('zona')=='ZONA 4')
						{ $this->form_validation->set_rules('region4','Región de Zona 4','required'); }
						if ($this->input->post('zona')=='ZONA 5')
						{ $this->form_validation->set_rules('region5','Región de Zona 5','required'); }
	
					}

				
					$this->form_validation->set_rules('nombre1','Nombre de Evaluado','required');
					$this->form_validation->set_rules('paterno1','Apellido Paterno del Evaluado','required');
					$this->form_validation->set_rules('materno1','Apellido Materno del Evaluado','required');

					
					if ($emp_id == 152)
					{
						$this->form_validation->set_rules('webflow1','Web Flow del Evaluado','required');
					}
					
					if ($emp_id != $control_empresa_osa_3)
					{
						$this->form_validation->set_rules('cp','Código Postal de la dirección del evaluado','required');
					}

				}
				elseif ($user['emp_id'] == 210)
				{
					$this->form_validation->set_rules('nombre1','Nombre de Evaluado','required');
					$this->form_validation->set_rules('paterno1','Apellido Paterno del Evaluado','required');
					$this->form_validation->set_rules('materno1','Apellido Materno del Evaluado','required');
					$this->form_validation->set_rules('webflow1','ODT','required');	
					$this->form_validation->set_rules('cp','Código Postal de la Dirección donde se aplicara el servicio','required');	
				}				
			}
			elseif (!(strstr($usuario['portal'],'ALPURA')))
			{
				 $this->form_validation->set_rules('observaciones','Observaciones','required');	
			}	

			
			if ((!(valida_corporacion($emp_id,'GSI') == 'GSI')) && !(strstr($usuario['portal'],'ALPURA')))
			{
				$this->form_validation->set_rules('fecha_event_ini','Fecha inicia','required');
				$this->form_validation->set_rules('hora_event_ini','Hora inicia','required');
				$this->form_validation->set_rules('fecha_event_fin','Fecha fin','required');
				$this->form_validation->set_rules('hora_event_fin','Hora fin','required');			
			}
			
			$this->form_validation->set_rules('lugar','Lugar de realización de los servicios','required');
			
            if($this->form_validation->run())
            {
					if ($user['usr_id'] == 261)
					{
						$usr_admin=$this->input->post('administrador');
						if ($usr_admin == 0){$usr_admin = 22;}
						$user=get_a_usuario($usr_admin);						
					}	
				
				
					if
					(
					(strlen ($this->input->post('observaciones')) > 1) &&	
					(strlen ($this->input->post('descripcion')  ) > 1) 
					)
					{
						if ( trim($this->input->post('observaciones')) == trim($this->input->post('descripcion')) ) 
						{ $error_observaciones_puestos=1; }	
						
					}
				
					 if ($error_observaciones_puestos == 0 )
					 {	 
						$total_examenes_selectos=$this->input->post('total_examenes_selectos');
						$paquetes='';
						$detecta_pkts=0;
						for($i=1; $i <= $total_examenes_selectos; $i++)
						{
							$indice='examen_select_pkt_'.strval($i);
							if ($this->input->post($indice) != NULL)
							{	
							$paquetes.=$this->input->post($indice).';';
							$detecta_pkts++;
							}
							
						}				
						
						$id_horario=0;					
						$cuantos_evaluados=0;
						$los_evaluados=$this->input->post('evaluados');
						$modo=$this->input->post('modo');
						
						if ($user['usr_id'] == 466) /*es unidad reclutadora*/
						{
							$modo=1;
						}
						
						if  (
								(($user_root3 == 2) && ($user_root4 == 3)) 
								||
								(strstr($usuario['acciones'],'REGNORMAL'))
							)	
							{$modo = 1;}
							
						
						
						
						if (strstr($usuario['portal'],'ALPURA'))	
						{
							$id_horario=$this->input->post('horario');
							
							$cuantos_evaluados=$this->input->post('num_eva');
							
							if (!($cuantos_evaluados > 0))
							{
								$cuantos_evaluados=1;
							}
							
							$horario_ok=$this->agenda->valida_horario($id_horario,$cuantos_evaluados,$table);
							
							if ($horario_ok)					
							{
								$cuantos_evaluados=0;
								if (strlen($this->input->post('evaluado1')) > 3) 
								{
									if (($horario_ok['she_capacidad']-$cuantos_evaluados) > 0)
									{	
										$el_eva1 = strstr($this->input->post('evaluado1'), ' - ', true); 
										$cuantos_evaluados++;
									}
									else
									{
										$el_eva1 =0;
									}	
								}
								if (strlen($this->input->post('evaluado2')) > 3) 
								{
									if (($horario_ok['she_capacidad']-$cuantos_evaluados) > 0)
									{	
										$el_eva2 = strstr($this->input->post('evaluado2'), ' - ', true); 
										$cuantos_evaluados++;
									}
									else
									{
										$el_eva2 =0;
									}	
								}
								if (strlen($this->input->post('evaluado3')) > 3) 
								{	
									if (($horario_ok['she_capacidad']-$cuantos_evaluados) > 0)
										{	
											$el_eva3 = strstr($this->input->post('evaluado3'), ' - ', true); 
											$cuantos_evaluados++;
										}
										else
										{
											$el_eva3 =0;
										}
								}
								
								$horario_ok['she_capacidad']=$horario_ok['she_capacidad']-$cuantos_evaluados;
								$horario_apartado=$this->agenda->aparta_horario($id_horario,$horario_ok,$table);
			
								$fecha_ini = $horario_ok['she_fecha'].' '.$horario_ok['she_hora_ini'].':02';
								$fecha_fin = $horario_ok['she_fecha'].' '.$horario_ok['she_hora_fin'].':02';

								
								
								foreach (explode(';', $paquetes) as $detalle)
								{
									if ( strlen($detalle) > 0)
									{												
										$exa_sel['nomserv'].= get_nombre_de_examen_por_empresa($detalle,$emp_id);							
									}
								}

						
							$k=0;
								if ( $el_eva1 > 0)
								{
								$cliente_gsi_id = $this->cliente->actualiza( $el_eva1,$exa_sel);
								}
													
								if ( $el_eva2 > 0)
								{
								$cliente_gsi_id = $this->cliente->actualiza($el_eva2,$exa_sel);
								}
								if ( $el_eva3 > 0)
								{
								$cliente_gsi_id = $this->cliente->actualiza($el_eva3,$exa_sel);
								}						

								$los_evaluados='';
								
								if ( $el_eva1 > 0)
								{
									$los_evaluados.=' | '.$this->input->post('evaluado1').' | ';
									$k++;
								}
								if ( $el_eva2 > 0)
								{
									$los_evaluados.=' | '.$this->input->post('evaluado2').' | ';
									$k++;
								}
								if ( $el_eva3 > 0)
								{
									$los_evaluados.=' | '.$this->input->post('evaluado3').' | ';
									$k++;
								}	
												
							}
							else
							{
								$fecha_ini='21-01-01 01:01:01';
								$fecha_fin='21-01-01 01:01:01';
								$error_gsi=1;
							}
							
						}
						elseif ((valida_corporacion($emp_id,'GSI') == 'GSI') && ($modo==0) &&  ( ($user_cei == 4) || ($user_cei == 8) ))
						{
							$id_horario=$this->input->post('horario');
							
							$cuantos_evaluados=$this->input->post('num_eva');
							
							if (!($cuantos_evaluados > 0))
							{
								$cuantos_evaluados=1;
							}
							
							$horario_ok=$this->agenda->valida_horario($id_horario,$cuantos_evaluados,$table);
							
							if ($horario_ok)					
							{

								$cuantos_evaluados=0;
								if (strlen($this->input->post('evaluado1')) > 3) 
								{
									if (($horario_ok['she_capacidad']-$cuantos_evaluados) > 0)
									{	
										$el_eva1 = strstr($this->input->post('evaluado1'), ' - ', true); 
										$cuantos_evaluados++;
									}
									else
									{
										$el_eva1 =0;
									}	
								}
								if (strlen($this->input->post('evaluado2')) > 3) 
								{
									if (($horario_ok['she_capacidad']-$cuantos_evaluados) > 0)
									{	
										$el_eva2 = strstr($this->input->post('evaluado2'), ' - ', true); 
										$cuantos_evaluados++;
									}
									else
									{
										$el_eva2 =0;
									}	
								}
								if (strlen($this->input->post('evaluado3')) > 3) 
								{	
									if (($horario_ok['she_capacidad']-$cuantos_evaluados) > 0)
										{	
											$el_eva3 = strstr($this->input->post('evaluado3'), ' - ', true); 
											$cuantos_evaluados++;
										}
										else
										{
											$el_eva3 =0;
										}
								}
								
								$horario_ok['she_capacidad']=$horario_ok['she_capacidad']-$cuantos_evaluados;
								$horario_apartado=$this->agenda->aparta_horario($id_horario,$horario_ok,$table);
			
								$fecha_ini = $horario_ok['she_fecha'].' '.$horario_ok['she_hora_ini'].':02';
								$fecha_fin = $horario_ok['she_fecha'].' '.$horario_ok['she_hora_fin'].':02';

								
								
								foreach (explode(';', $paquetes) as $detalle)
								{
									if ( strlen($detalle) > 0)
									{												
										$exa_sel['nomserv'].= get_nombre_de_examen_por_empresa($detalle,$emp_id);							
									}
								}

						
							$k=0;
								if ( $el_eva1 > 0)
								{
								$cliente_gsi_id = $this->cliente->actualiza( $el_eva1,$exa_sel);
								}
													
								if ( $el_eva2 > 0)
								{
								$cliente_gsi_id = $this->cliente->actualiza($el_eva2,$exa_sel);
								}
								if ( $el_eva3 > 0)
								{
								$cliente_gsi_id = $this->cliente->actualiza($el_eva3,$exa_sel);
								}						

								$los_evaluados='';
								
								if ( $el_eva1 > 0)
								{
									$los_evaluados.=' | '.$this->input->post('evaluado1').' | ';
									$k++;
								}
								if ( $el_eva2 > 0)
								{
									$los_evaluados.=' | '.$this->input->post('evaluado2').' | ';
									$k++;
								}
								if ( $el_eva3 > 0)
								{
									$los_evaluados.=' | '.$this->input->post('evaluado3').' | ';
									$k++;
								}	
												
							}
							else
							{
								$fecha_ini='21-01-01 01:01:01';
								$fecha_fin='21-01-01 01:01:01';
								$error_gsi=1;
							}
							
						}
						else
						{
							$fecha_ini = formatea_fechahora_mysql($this->input->post('fecha_event_ini').' '.$this->input->post('hora_event_ini'));
							$fecha_fin = formatea_fechahora_mysql($this->input->post('fecha_event_fin').' '.$this->input->post('hora_event_fin'));					
						}				
					
			

						$params = array
						(
							'cal_pkts' => $paquetes,
							//Observaciones
							'cal_observaciones' =>$this->input->post('observaciones'),
							//Evaluados
							'cal_evaluados' => $los_evaluados, 	
							//Solicitante
							'cal_usr_nombre' => $user['usr_nombre'],
							'cal_usr_paterno' => $user['usr_paterno'],
							'cal_usr_materno' => $user['usr_materno'],
							'cal_usr_correo' => $user['usr_correo'],					
							//datos normales de calendario	
							'cal_fecha' => $this->input->post('fecha'),
							'cal_titulo' => $this->input->post('asunto'),
							'cal_servicio' => NULL,
							'cal_descripcion' => $this->input->post('descripcion'),
							'cal_fecha_ini' => $fecha_ini,
							'cal_fecha_fin' => $fecha_fin,
							'cal_id_horario' => $id_horario,					
							'cal_cuantos_evaluados' => $cuantos_evaluados,
							'cal_uid' => uniqid(rand(0, getmypid()))					
						);

						if (($emp_id == 298) ||  ($emp_id == 152) || ($emp_id  == 193) || ($emp_id  == 210) || ($emp_id  == 230) || ($emp_id  == 311) || ($emp_id  == 142))
						{	
							if (strlen($this->input->post('hc1')) > 0)
							{
								$params['hc1'] =$this->input->post('hc1');
							}

							if (strlen($this->input->post('hc2')) > 0)
							{
								$params['hc2'] =$this->input->post('hc2');
							}

							if (strlen($this->input->post('hc3')) > 0)
							{
								$params['hc3'] =$this->input->post('hc3');
							}				
						}

						if ($user['emp_id'] == 31)
						{					
							$params['cal_viaticos'] =$this->input->post('fsm_viaticos');
						}				
						else
						{
							$params['cal_viaticos'] ='NO';
						}	

						if ($emp_id == 193)
						{		
							$params['cal_autoriza'] =$this->input->post('fsm_autoriza');				
						}



						if ($user['emp_id'] == 31)
						{					
							$params['emp_id'] = $emp_id;
						}				
						elseif  (
									($user['emp_id'] == 126)   ||
									($user['emp_id'] ==125)   ||
									($user['emp_id'] ==33)   ||
									($user['emp_id'] ==179)   ||
									($user['emp_id'] ==181)   ||
									($user['emp_id'] ==180)   ||
									($user['emp_id'] ==77)   ||
									($user['emp_id'] ==176)   ||
									($user['emp_id'] ==178)   ||
									($user['emp_id'] ==177)   ||
									($user['emp_id'] ==57)   ||
									($user['emp_id'] ==175)   ||
									($user['emp_id'] ==174)   ||						 
									($user['emp_id'] == 127)    
									|| ($user['emp_id'] == 183)
									|| ($user['emp_id'] ==33)
									|| ($user['emp_id'] ==77)
									|| ($user['emp_id'] ==106)
									|| ($user['emp_id'] ==148)							
								)/*es un despacho de GSI*/
						{
							$params['emp_id'] = $emp_id;
							$params['desp_emp_id'] = $this->input->post('empresa');
						}
						else
						{
							$params['emp_id'] = $emp_id;
							$params['desp_emp_id'] = 0;
						}
						
						

						
						$params['cal_lugar'] = $this->input->post('lugar');
						

						if (!(get_empresas_giro($emp_id,'SEGUROS')))
						{					
							$params['cal_lugar_det'] = $this->input->post('lugar_det');					
						}
						else
						{								
							if ($params['cal_lugar'] == 0)
							{												
								$domicilio=$this->input->post('calle').' ';
								$domicilio.=$this->input->post('next').' '.$this->input->post('nint').' ';
								$domicilio.=$this->input->post('colonia').', ';
								$domicilio.='C.P. '.$this->input->post('cp').', ';
								$domicilio.=$this->input->post('municipio').', ';
								$domicilio.=$this->input->post('localidad').', ';
								$domicilio.=$this->input->post('entidad').', ';
								$domicilio.=$this->input->post('pais').'.';

								$params['cal_lugar_det'] = 	$domicilio;	

								$params['cal_eva_telefono_1'] = $this->input->post('telefono_1');						
								$params['cal_eva_telefono_2'] = $this->input->post('telefono_2');						
							}
							elseif ($params['cal_lugar'] == 2) 
							{	
								$params['cal_lugar_det'] ='Calle San Borja 1365, Vértiz Narvarte, Benito Juárez, C.P. 03600, CDMX'; 
							}
							else
							{	
								$params['cal_lugar_det'] = 'Paseo de la Reforma No. 342, Piso 14, Col. Juárez, Del. Cuauhtémoc, C.P. 06600, CDMX';  
							}							
					
						}

						$params['cal_email'] = $user['usr_correo'].'; '.$this->input->post('mail');


						/******NUEVOS ARCHIVO ANEXO 0 ******************************/
						if(!empty($_FILES['anexo']['name']))
						{
							$nombre_anexo=$_FILES['anexo']['name'];
							$this->load->library('upload');
							$filename = md5(time());
							$config = array(
									'upload_path'   => './../../files/anexos/',
									'overwrite'     => TRUE,
									'file_name'     => $filename,
									'allowed_types' => 'doc|docx|pdf|txt|xlsx|xls|png|jpg|jpeg',
									'max_size'      => '10000'
							);

							$this->upload->initialize($config);
							
							if ( ! $this->upload->do_upload('anexo'))
							{
								echo json_encode(array('status' => 'error','content' => $this->upload->display_errors()));
								exit;
							}
							else 
							{
								$data = $this->upload->data();
								$params['cal_anexo_path'] = $data['file_name'];
								$params['cal_anexo_nombre'] = $nombre_anexo;
								$data_serv['serv_anexo_path'] = $data['file_name'];
								$data_serv['serv_anexo_nombre'] = $nombre_anexo;
								
							}
						/*}*/
						/***********************************************************/	
						}

						/******NUEVOS ARCHIVO ANEXO 1 ******************************/
						if(!empty($_FILES['anexo1']['name']))
						{
							$nombre_anexo=$_FILES['anexo1']['name'];
							$this->load->library('upload');
							
							sleep(1);
							$filename1 = md5(time());
							$config = array(
									'upload_path'   => './../../files/anexos/',
									'overwrite'     => TRUE,
									'file_name'     => $filename1,
									'allowed_types' => 'doc|docx|pdf|txt|xlsx|xls|png|jpg|jpeg',
									'max_size'      => '10000'
							);

							$this->upload->initialize($config);
							
							if ( ! $this->upload->do_upload('anexo1'))
							{
								  echo json_encode(array('status' => 'error','content' => $this->upload->display_errors()));
								exit;
							}
							else 
							{
								$data = $this->upload->data();
								$params['cal_anexo1_path'] = $data['file_name'];
								$params['cal_anexo1_nombre'] = $nombre_anexo;
								$data_serv['serv_anexo1_path'] = $data['file_name'];
								$data_serv['serv_anexo1_nombre'] = $nombre_anexo;
							}
						}
						/***********************************************************/				
						
						/******NUEVOS ARCHIVO ANEXO 2 ******************************/
										if(!empty($_FILES['anexo2']['name']))
										{
											$nombre_anexo=$_FILES['anexo2']['name'];
											$this->load->library('upload');
											
											sleep(1);
											$filename2 = md5(time());
											$config2 = array(
													'upload_path'   => './../../files/anexos/',
													'overwrite'     => TRUE,
													'file_name'     => $filename2,
													'allowed_types' => 'doc|docx|pdf|txt|xlsx|xls|png|jpg|jpeg',
													'max_size'      => '10000'
											);

											$this->upload->initialize($config2);
											
											if ( ! $this->upload->do_upload('anexo2'))
											{

												echo json_encode(array('status' => 'error','content' => $this->upload->display_errors()));
												exit;
											}
											else 
											{
												$data = $this->upload->data();
												$params['cal_anexo2_path'] = $data['file_name'];
												$params['cal_anexo2_nombre'] = $nombre_anexo;
												$data_serv['serv_anexo2_path'] = $data['file_name'];
												$data_serv['serv_anexo2_nombre'] = $nombre_anexo;
											}
										}
						/***********************************************************/	
						/******NUEVOS ARCHIVO ANEXO 3 ******************************/
										if(!empty($_FILES['anexo3']['name']))
										{
											$nombre_anexo=$_FILES['anexo3']['name'];
											$this->load->library('upload');
											
											sleep(1);
											$filename3 = md5(time());
											$config3 = array(
													'upload_path'   => './../../files/anexos/',
													'overwrite'     => TRUE,
													'file_name'     => $filename3,
													'allowed_types' => 'doc|docx|pdf|txt|xlsx|xls|png|jpg|jpeg',
													'max_size'      => '10000'
											);

											$this->upload->initialize($config3);
											
											if ( ! $this->upload->do_upload('anexo3'))
											{

												echo json_encode(array('status' => 'error','content' => $this->upload->display_errors()));
												exit;
											}
											else 
											{
												$data = $this->upload->data();
												$params['cal_anexo3_path'] = $data['file_name'];
												$params['cal_anexo3_nombre'] = $nombre_anexo;
												$data_serv['serv_anexo3_path'] = $data['file_name'];
												$data_serv['serv_anexo3_nombre'] = $nombre_anexo;
												
											}
										}
						/***********************************************************/	
						/******NUEVOS ARCHIVO ANEXO 4 ******************************/
										if(!empty($_FILES['anexo4']['name']))
										{
											$nombre_anexo=$_FILES['anexo4']['name'];
											$this->load->library('upload');
											
											sleep(1);
											$filename4 = md5(time());
											$config = array(
													'upload_path'   => './../../files/anexos/',
													'overwrite'     => TRUE,
													'file_name'     => $filename4,
													'allowed_types' => 'doc|docx|pdf|txt|xlsx|xls|png|jpg|jpeg',
													'max_size'      => '10000'
											);

											$this->upload->initialize($config);
											
											if ( ! $this->upload->do_upload('anexo4'))
											{

												echo json_encode(array('status' => 'error','content' => $this->upload->display_errors()));
												exit;
											}
											else 
											{
												$data = $this->upload->data();
												$params['cal_anexo4_path'] = $data['file_name'];
												$params['cal_anexo4_nombre'] = $nombre_anexo;
												$data_serv['serv_anexo4_path'] = $data['file_name'];
												$data_serv['serv_anexo4_nombre'] = $nombre_anexo;
											}
										}

		/****************** Estructura para generar Orden de Servicio*****************************************/
		 
						$params['cei_control_id'] = $this->input->post('cei_control');
						$data_serv['cei_control_id'] = $this->input->post('cei_control');
						
						if (($user['emp_id'] == 31) &&  (strlen($this->input->post('serv_orden')) > 0))
						{					
							$params['serv_orden'] = $this->input->post('serv_orden');
							$data_serv['serv_orden'] =$this->input->post('serv_orden');
						}
						else
						{	
							$f = new DateTime();
							
							if (get_emp_osa($emp_id) == 3)
							{
								$ff= $emp_id.'_'.strtoupper(trim($this->input->post('nombre1')).'_'.trim($this->input->post('paterno1')).'_'.trim($this->input->post('materno1'))).'_'.$f->getTimestamp();
							}						
							elseif ($user['emp_id'] == 321)
							{
								$ff= 'PROV_'.$this->input->post('zona_securitas').'_'.$f->getTimestamp();
							}						
							else
							{	
								$ff= 'PROVISIONAL_'. $f->getTimestamp();			
							}
							
							$params['serv_orden']= $ff;
							$data_serv['serv_orden'] = $ff;
						}	
						

						if (!(valida_corporacion($emp_id,'GSI') === 'GSI') || ($emp_id !=31) )
						{	
							$data_serv['emp_id'] =  $emp_id;
							$data_serv['usr_id'] = $user['usr_id'];
							$data_serv['serv_f_inicio'] = $fecha_ini;
							$data_serv['serv_f_fin'] = $fecha_fin;
							$data_serv['serv_desc'] = $this->input->post('observaciones');
							$data_serv['serv_ubicacion'] =   $this->input->post('lugar');
							$data_serv['serv_estatus_cve'] = 'PROCESO';
							$data_serv['cei_id'] = $user['cei_id'];

						}
		/***********************************************************/
						if  (
								($params['emp_id'] > 0) && 
								($detecta_pkts > 0) &&
								(strlen($params['cal_viaticos']) == 2) /*control de viaticos*/
							)
						{	
							//SE CREA EVENTO DE LA AGENDA						
							$cal_id = $this->agenda->add_evento_folio(array_to_upper($params));
							
							$serv_id=0;
							
							//para evitar que se genere orden de servicio
							  if (get_emp_osa($emp_id) == 3)
								{
									//el evento se le da al servicio
									$data_serv['cal_folio'] = $cal_id;
									$data_serv['cal_id'] = $cal_id;
									
									//el servicio se crea
									$serv_id = $this->servicio->inserta(array_to_upper($data_serv));			
									$serv_id_152=$serv_id ; 

									
									//costos para el servicio creado edita b
									$total_examenes_selectos= $this->input->post('total_examenes_selectos');	
									$fsm_pakts= get_costos_paquetes_empresa($emp_id);
									if($fsm_pakts):
										foreach($fsm_pakts as $fsm_pakt): 
													
												for($i=1; $i <= $total_examenes_selectos; $i++)
												{									
													$indice='examen_select_pkt_'.strval($i);
													$paquetes= $this->input->post($indice);	
															
													if ( $fsm_pakt['cost_nombre_pkt'] === $paquetes)
													{
														$examen_ins['exam_nombre_pkt'] = $fsm_pakt['cost_nombre_pkt']; //nombre del paquete
														$examen_ins['serv_id'] = $serv_id;
														$examen_ins['exam_cve'] = $fsm_pakt['cost_examen_cve']; //lo que contiene el paquete
														$examen_ins['exam_monto'] = $fsm_pakt['cost_monto']; //lo que se cobra del paquete								 	 
														$examen_ins['exam_cantidad'] = 1;
														$examen_ins['exam_estatus_cve'] = 'PEND';
														$examen_ins['exam_tipo_pkt'] = $fsm_pakt['cost_tipo_pkt'];
														$this->servicio->inserta_examen($examen_ins);
													}							
												}	
										endforeach;
									endif;	
								}

								if (($emp_id == 298) ||  ($emp_id == 152) ||  ($emp_id  == 193) ||  ($emp_id  == 210) || ($emp_id  == 230) || ($emp_id  == 311) || ($emp_id  == 142) || (get_emp_osa($emp_id) == 3) )
								{						
									//se extraen examenes de los paquetes para evaluados de seguros
									$nomserv='';
									
									$cat_examen = get_cat_nombre_var('EXAMEN');		
									$cat_categorias = get_cat_nombre_var('CATEGORIA_EX');
									foreach($cat_categorias as $categoria): 
										$linea_examenes=get_examen_de_empresa_por_categoria($emp_id, $categoria['cat_nombre']);
										
										if (strlen($linea_examenes) > 0)
										{
											foreach (explode(';', $linea_examenes) as $det):
												if (strlen($det) > 0)
												{
														$exa=$det.';';
														$nomserv.=$exa;											
												}
											endforeach;										
										}
									endforeach;					
							
									$data_clte['nomserv'] =  $nomserv;	

									//evaluados de seguros

										$j=1;
										for($i=1; $i <= 4; $i++)
										{	
											if 	(
												(strlen($this->input->post('nombre'.strval($i)))>0) &&
												(strlen($this->input->post('paterno'.strval($i)))>0)
												)
												
											{
											//informncion general de evaluado
											$data_clte['clte_nombre_crypt'] =  trim($this->input->post('nombre'.strval($i)));
											$data_clte['clte_2_nombre_crypt'] =  trim($this->input->post('nombre_adic'.strval($i)));
											$data_clte['clte_paterno_crypt'] =  trim($this->input->post('paterno'.strval($i)));
											$data_clte['clte_materno_crypt'] =  trim($this->input->post('materno'.strval($i)));
											$data_clte['clte_f_nac'] = formatea_fecha_mysql($this->input->post('fnac'.strval($i)));
											$data_clte['clte_genero_cve'] =  $this->input->post('genero'.strval($i));                				
											

											$data_clte['clte_rfc_crypt']=substr($data_clte['clte_paterno_crypt'],0,2).substr($data_clte['clte_materno_crypt'],0,1).substr($data_clte['clte_nombre_crypt'],0,1).substr($data_clte['clte_f_nac'],2,2).substr($data_clte['clte_f_nac'],5,2).substr($data_clte['clte_f_nac'],8,2);

											$data_clte['serv_id'] =  $this->input->post('serv_id');
											
											
											
											if ($emp_id == 152)
											{
												if ($j== 1)
												{	
													$data_clte['clte_webflow'] =  $this->input->post('webflow1');
												}
												elseif ($j== 2)
												{
													$data_clte['clte_webflow'] =  $this->input->post('webflow2');
												}
												elseif ($j== 3)
												{
													$data_clte['clte_webflow'] =  $this->input->post('webflow3');
												}
												else
												{
													$data_clte['clte_webflow'] =  $this->input->post('webflow4');
												}
												
												
												if ($this->input->post('region1') !='')
												{	
													$data_clte['clte_region'] =  $this->input->post('region1');
												}
												elseif ($this->input->post('region2') !='')
												{	
													$data_clte['clte_region'] =  $this->input->post('region2');
												}
												elseif ($this->input->post('region3') !='')
												{	
													$data_clte['clte_region'] =  $this->input->post('region3');
												}
												elseif ($this->input->post('region4') !='')
												{	
													$data_clte['clte_region'] =  $this->input->post('region4');
												}
												elseif ($this->input->post('region5') !='')
												{	
													$data_clte['clte_region'] =  $this->input->post('region5');
												}
											
												
												$data_clte['clte_zona'] = $this->input->post('zona');
												
												
												
												$cal_lugar_det= $this->input->post('lugar_det');
												
												/*
												$zonificacion='ZONA 0';												
												if ($cal_lugar_det !=0 )
												{
													$zonificacion='ZONA 1';
												}	
												else
												{
													$cp_codigo=$this->input->post('cp');
													
													$this->db->select('*');
													$this->db->from('cat_dir_cp');
													$this->db->like('cp_codigo',$cp_codigo);
													$this->db->limit(1); 
													$zona=$this->db->get()->row_array();
													
														if (
															($zona['cp_ciudad'] == 'QUERÉTARO') ||
															($zona['cp_ciudad'] == 'CIUDAD DE MÉXICO') ||
															($zona['estado'] == 'MÉXICO') || 
															($zona['estado'] == 'QUERÉTARO') || 
															($zona['cp_ciudad'] == 'MONTERREY')
														   )
														{
															$zonificacion='ZONA 2';
														}
														elseif (
															($zona['cp_ciudad'] == 'PUEBLA (HEROICA PUEBLA)') ||
															($zona['cp_ciudad'] == 'CUERNAVACA') ||
															($zona['estado'] == 'HIDALGO') || 
															($zona['estado'] == 'PUEBLA') ||												
															($zona['estado'] == 'TLAXCALA') ||
															($zona['estado'] == 'GUANAJUATO') ||
															($zona['cp_ciudad'] == 'TLAXCALA (TLAXCALA DE XICOTENCATL)') ||
															($zona['cp_ciudad'] == 'CELAYA') ||
															($zona['cp_ciudad'] == 'IRAPUATO')
														   )
														{
															$zonificacion='ZONA 3';
														}
														elseif (
															($zona['cp_ciudad'] == 'LEÓN DE LOS ALDAMA') ||
															($zona['cp_ciudad'] == 'SAN LUIS POTOSÍ') ||
															($zona['estado'] == 'SAN LUIS POTOSÍ') ||
															($zona['cp_ciudad'] == 'TORREÓN')
														   )
														{
															$zonificacion='ZONA 4';
														}
														else	
														{
															$zonificacion='ZONA 5'; 
														}					
														
												}											
												$data_clte['clte_zona'] = $zonificacion;
												*/
											}	
				
											if ($emp_id == 311)
											{
												if ($cal_lugar_det !=0 )
												{
													$zonificacion='ZONA 01';
												}	
												else
												{
													$cp_codigo=$this->input->post('cp');
													
													$this->db->select('*');
													$this->db->from('cat_dir_cp');
													$this->db->like('cp_codigo',$cp_codigo);
													$this->db->limit(1); 
													$zona=$this->db->get()->row_array();
													
														if (
															($zona['cp_ciudad'] == 'QUERÉTARO') ||
															($zona['cp_ciudad'] == 'CIUDAD DE MÉXICO') ||
															($zona['cp_ciudad'] == 'MONTERREY')
														   )
														{
															$zonificacion='ZONA 01';
														}
														elseif (
															($zona['cp_ciudad'] == 'PUEBLA (HEROICA PUEBLA)') ||
															($zona['cp_ciudad'] == 'CUERNAVACA') ||
															($zona['cp_ciudad'] == 'LEÓN DE LOS ALDAMA') ||
															($zona['cp_ciudad'] == 'GUADALAJARA') ||
															($zona['cp_ciudad'] == 'AGUASCALIENTES')
														   )
														{
															$zonificacion='ZONA 02';
														}
														else	
														{
															$zonificacion='ZONA 03'; 
														}					
														
												}
												$data_clte['clte_zona'] = $zonificacion;
											}

				

											$data_clte['clte_env_pais_cve'] =  $this->input->post('pais');
											$data_clte['clte_env_cp'] =  $this->input->post('cp');
											$data_clte['clte_env_edo_cve'] =  $this->input->post('entidad');
											$data_clte['clte_env_colonia_crypt'] =  $this->input->post('colonia');
											$data_clte['clte_env_localidad'] =  $this->input->post('localidad');
											$data_clte['clte_env_municipio'] =  $this->input->post('municipio');
											$data_clte['clte_env_calle_crypt'] =  $this->input->post('calle');
											$data_clte['clte_env_num_ext_crypt'] =  $this->input->post('next');
											$data_clte['clte_env_num_int_crypt'] =  $this->input->post('nint');														
											$data_clte['clte_edo_civ_cve'] =  $this->input->post('civil'.strval($i));											
											$data_clte['log_insrt_f'] =  date('Y-m-d H:i:s'); 
											$data_clte['log_updt_f'] =  date('Y-m-d H:i:s'); 
											//empresa donde va a loborar la persona
											$data_clte['emp_id'] =  $emp_id;  
											$data_clte['cei_id'] =  $this->input->post('cei_control');
											
											if ($emp_id == 298)
											{
												$data_clte['nomserv'] =  'BX+';
											}
											elseif (($emp_id == 152) || ($emp_id == $control_empresa_osa_3))
											{
												foreach (explode(';', $params['cal_pkts']) as $pkt_examen):
													if (strlen($pkt_examen) > 0)
													{	//$nomserv_serguros.=$pkt_examen.';';
														$nomserv_serguros.=get_cve_exam_per_pakts_by_empresa($emp_id,$pkt_examen);
													}
												endforeach;	
												$data_clte['nomserv'] =  $nomserv_serguros;   
												if (get_emp_osa($emp_id ) == 3)
												{	
													$data_clte['serv_id'] =  $serv_id_152;
												}	
												else
												{	
													$data_clte['serv_id'] =  $this->input->post('serv_orden');
												}
											}
											elseif ($emp_id  == 193)
											{
												$data_clte['nomserv'] =  'ALLIANZ';
												
											}
											elseif ($emp_id  == 142)
											{
												foreach (explode(';', $params['cal_pkts']) as $pkt_examen):
													if (strlen($pkt_examen) > 0)
													{	//$nomserv_serguros.=$pkt_examen.';';
														$nomserv_serguros.=get_cve_exam_per_pakts_by_empresa($emp_id,$pkt_examen);
													}
												endforeach;	
												$data_clte['nomserv'] =  $nomserv_serguros;
												$data_clte['serv_id'] = $serv_id; 
												//$data_clte['serv_id'] =  $this->input->post('serv_orden');
											}
											elseif ($emp_id  == 210)
											{
												$data_clte['nomserv'] = $examen_ins['exam_cve'];// 'INSIGNIA';
												$data_clte['suc_id'] = $usuario['suc_id']; /*insignia*/
												$data_clte['serv_id'] = $serv_id; 
											}
											elseif ($emp_id  == 230)
											{
												foreach (explode(';', $params['cal_pkts']) as $pkt_examen):
													if (strlen($pkt_examen) > 0)
													{	//$nomserv_serguros.=$pkt_examen.';';
														$nomserv_serguros.=get_cve_exam_per_pakts_by_empresa($emp_id,$pkt_examen);
													}
												endforeach;	
												$data_clte['nomserv'] =  $nomserv_serguros.'AXA';
												$data_clte['serv_id'] =  $this->input->post('serv_orden');
											}
											elseif ($emp_id  == 211)
											{
												foreach (explode(';', $params['cal_pkts']) as $pkt_examen):
													if (strlen($pkt_examen) > 0)
													{	//$nomserv_serguros.=$pkt_examen.';';
														$nomserv_serguros.=get_cve_exam_per_pakts_by_empresa($emp_id,$pkt_examen);
													}
												endforeach;	
												$data_clte['nomserv'] =  $nomserv_serguros;
												$data_clte['serv_id'] =  $this->input->post('serv_orden');
											}
											elseif ($emp_id  == 311)
											{
												foreach (explode(';', $params['cal_pkts']) as $pkt_examen):
													if (strlen($pkt_examen) > 0)
													{	//$nomserv_serguros.=$pkt_examen.';';
														$nomserv_serguros.=get_cve_exam_per_pakts_by_empresa($emp_id,$pkt_examen);
													}
												endforeach;	
												$data_clte['nomserv'] =  $nomserv_serguros;
												$data_clte['serv_id'] =  $this->input->post('serv_orden');
											}
											/*********************************************
											validar que el evaluado no este rregistrado
											********************************************/
												
											$data_clte= array_to_upper($data_clte);
												
											$cliente_encontrado = $this->cliente->busca_asegurado($data_clte['clte_nombre_crypt'],
																			$data_clte['clte_2_nombre_crypt'],
																			$data_clte['clte_paterno_crypt'],
																			$data_clte['clte_materno_crypt'],
																			$data_clte['emp_id']);
											
											if ($cliente_encontrado)
											{
												$data_x['clte_zona']=$this->input->post('zona_insignia'); 
												$data_x['clte_env_pais_cve']=$data_clte['clte_env_pais_cve'];
												$data_x['clte_env_cp']=$data_clte['clte_env_cp'];
												$data_x['clte_env_edo_cve']=$data_clte['clte_env_edo_cve'];
												$data_x['clte_env_colonia_crypt']=$data_clte['clte_env_colonia_crypt'];
												$data_x['clte_env_localidad']=$data_clte['clte_env_localidad'];
												$data_x['clte_env_municipio']=$data_clte['clte_env_municipio'];
												$data_x['clte_env_calle_crypt']=$data_clte['clte_env_calle_crypt'];
												$data_x['clte_env_num_ext_crypt']=$data_clte['clte_env_num_ext_crypt'];
												$data_x['clte_env_num_int_crypt']=$data_clte['clte_env_num_int_crypt'];
												$data_x['clte_webflow']=$data_clte['clte_webflow'];
												$data_x['serv_id']=$data_clte['serv_id'];
												$data_x['clte_region']=$data_clte['clte_region'];
												$data_x['nomserv']=$data_clte['nomserv'];
												
												$this->cliente->actualiza_registro_sin_log($cliente_encontrado['clte_id'],array_to_upper($data_x));
											}
											else
											{	
												$cliente_id = $this->cliente->inserta(array_to_upper($data_clte));
											}
											
											
											$param['eva'.strval($j)]=$cliente_id;
											$j++;
											
											}					
										}
								}
							
								if ((get_empresas_giro($emp_id ,'SEGUROS')))
								{	
									
									if ($emp_id == 298)
									{
										$param['cal_titulo']= 'BX+ - ';
									}
									elseif ($emp_id == 152)
									{
										$param['cal_titulo']= 'SMTY - ';
									}
									elseif ($emp_id == 193)
									{
										$param['cal_titulo']= 'ALLIANZ - ';
									}
									elseif ($emp_id == 230)
									{
										$param['cal_titulo']= 'AXA - ';
									}
									elseif ($emp_id == 311)
									{
										$param['cal_titulo']= 'GNP - ';
									}
									elseif ($emp_id == 142)
									{
										$param['cal_titulo']= 'GENERAL DE SEGUROS - ';
									}						
									else
									{
										$param['cal_titulo']= get_empresida($emp_id).' - ';
									}	
									
									$eva0=strtoupper(trim($this->input->post('nombre1')).' '.trim($this->input->post('paterno1')).' '.trim($this->input->post('materno1')));
									$param['cal_titulo'].=$eva0;
									
									
									if (strlen($this->input->post('nombre2')) > 0) 
										{
											$eva0=chr(10).strtoupper(trim($this->input->post('nombre2')).' '.trim($this->input->post('paterno2')).' '.trim($this->input->post('materno2')));
											$param['cal_titulo'].=$eva0; 
										}	
									
									if (strlen($this->input->post('nombre3')) > 0) 
										{
											$eva0=chr(10).strtoupper(trim($this->input->post('nombre3')).' '.trim($this->input->post('paterno3')).' '.trim($this->input->post('materno3')));
											$param['cal_titulo'].=$eva0; 
										}	
									
									if (strlen($this->input->post('nombre4')) > 0) 
										{
											$eva0=chr(10).strtoupper(trim($this->input->post('nombre4')).' '.trim($this->input->post('paterno4')).' '.trim($this->input->post('materno4')));
											$param['cal_titulo'].=$eva0; 
										}						
									
									$param['cal_titulo'].=' ** '.get_options_per_grupo('HC_SEGUROS', $params['hc1']);		
									
								}
								elseif (($emp_id == 210) /*|| ($emp_id == 193)*/ )
								{	
								
									$param['cal_titulo']= get_empresa($params['emp_id']).' ';
									$eva0=strtoupper(trim($this->input->post('nombre1')).' '.trim($this->input->post('paterno1')).' '.trim($this->input->post('materno1')));
									$param['cal_titulo'].=$eva0;
									
									
									if (strlen($this->input->post('nombre2')) > 0) 
										{
											$eva0=chr(10).strtoupper(trim($this->input->post('nombre2')).' '.trim($this->input->post('paterno2')).' '.trim($this->input->post('materno2')));
											$param['cal_titulo'].=$eva0; 
										}	
									
									if (strlen($this->input->post('nombre3')) > 0) 
										{
											$eva0=chr(10).strtoupper(trim($this->input->post('nombre3')).' '.trim($this->input->post('paterno3')).' '.trim($this->input->post('materno3')));
											$param['cal_titulo'].=$eva0; 
										}	
									
									if (strlen($this->input->post('nombre4')) > 0) 
										{
											$eva0=chr(10).strtoupper(trim($this->input->post('nombre4')).' '.trim($this->input->post('paterno4')).' '.trim($this->input->post('materno4')));
											$param['cal_titulo'].=$eva0; 
										}						
									
									$param['cal_titulo'].=' ** '.get_options_per_grupo('HC_SEGUROS', $params['hc1']);		
									
								}
								else
								{	if ($serv_id == 0 )
									{
										$param['cal_titulo']= get_empresa($params['emp_id']).', IDA:'.$cal_id; 
									}
									else
									{
										$param['cal_titulo']= get_empresa($params['emp_id']).', OS:'.$serv_id.', IDA:'.$cal_id; 
									}
								}					

												
								$param['serv_id']=$serv_id;
								$this->agenda->update_evento($cal_id,$param);	
							}
							elseif  ($emp_id == 210) /* PROCESA Insignia Life*/
							{	
								$error_archivo_servcios=0;
								if(!empty($_FILES['paquete']['name']))
								{
									$nombre_anexo_p=$_FILES['paquete']['name'];
									$this->load->library('upload');
									
									sleep(1);

									$filename1 ='insignia_'.date(dmYHis).'_'.rand(1,99);//.md5(time());
									$config = array(
											'upload_path'   => './../../files/anexos/',
											'overwrite'     => TRUE,
											'file_name'     => $filename1,
											'allowed_types' => 'doc|docx|pdf|txt|xlsx|xls|png|jpg|jpeg',
											'max_size'      => '10000'
									);

									$this->upload->initialize($config);
									
									if ( ! $this->upload->do_upload('paquete'))
									{
										  echo json_encode(array('status' => 'error','content' => $this->upload->display_errors()));
										exit;
									}
									else /*HAY QUE ACTUALIZAR*/
									{
										$data_p = $this->upload->data();
										$params['cal_arch_serv_path'] = $data_p['file_name'];
										$params['cal_arch_serv_nombre'] = $nombre_anexo_p;
										$data_serv['serv_arch_serv_path'] = $data_p['file_name'];
										$data_serv['serv_arch_serv_nombre '] = $nombre_anexo_p;
									}
								}
								else
								{
									$error_archivo_servcios=1;
								}					
						
							if  (
								(($this->input->post('nombre2'))	== '') &&				
								(($this->input->post('paterno2')) == '') &&
								(($this->input->post('materno2')) == '') &&
								(($this->input->post('webflow2')) == '')
								)
								{
									$error_evaluado2=0;
								}
								elseif  (
										(($this->input->post('nombre2'))	!= '') &&				
										(($this->input->post('paterno2')) != '') &&
										(($this->input->post('materno2')) != '') &&
										(($this->input->post('webflow2')) != '')
										)
										{
											$error_evaluado2=0;
										}
										else { $error_evaluado2=1;}
										
							if  (
								(($this->input->post('nombre3'))	== '') &&				
								(($this->input->post('paterno3')) == '') &&
								(($this->input->post('materno3')) == '') &&
								(($this->input->post('webflow3')) == '')
								)
								{
									$error_evaluado3=0;
								}
								elseif  (
										(($this->input->post('nombre3'))	!= '') &&				
										(($this->input->post('paterno3')) != '') &&
										(($this->input->post('materno3')) != '') &&
										(($this->input->post('webflow3')) != '')
										)
										{
											$error_evaluado3=0;
										}
										else { $error_evaluado3=1;}

							if  (
								(($this->input->post('nombre4'))	== '') &&				
								(($this->input->post('paterno4')) == '') &&
								(($this->input->post('materno4')) == '') &&
								(($this->input->post('webflow4')) == '')
								)
								{
									$error_evaluado4=0;
								}
								elseif  (
										(($this->input->post('nombre4'))	!= '') &&				
										(($this->input->post('paterno4')) != '') &&
										(($this->input->post('materno4')) != '') &&
										(($this->input->post('webflow4')) != '')
										)
										{
											$error_evaluado4=0;
										}
										else { $error_evaluado4=1;}


						
							if  ( ($error_archivo_servcios == 0) && 
								  ($error_evaluado2 == 0) &&
								  ($error_evaluado3 == 0) &&
								  ($error_evaluado4 == 0) 
								)
							{
								$detecta_pkts = 1;
								$params['cal_viaticos'] = 'NO';
								//se crea evento en agenda
								$params=array_to_upper($params);
								$params['cal_arch_serv_path'] = $data_p['file_name'];
								$params['cal_arch_serv_nombre'] = $nombre_anexo_p;
								$cal_id = $this->agenda->add_evento_folio($params);
								$serv_id=0;
								
								//solo empresas que generaran orden de servicio	
									if ( 	
											!(valida_corporacion($emp_id,'SERVISEG') === 'SERVISEG') &&  
											!(valida_corporacion($emp_id,'GSI') === 'GSI') &&  
											($emp_id != 290) &&
											($emp_id != 353) &&
											($emp_id != 302) &&
											($emp_id != 298) && 
											($emp_id != 152) && 
											($emp_id != 193) && 
											($emp_id != 230) &&
											($emp_id != 311) &&
											($emp_id != 31) &&
											($emp_id != 37) &&
											($emp_id != 213) &&
											($emp_id != 253) && /*SWOBODA*/
											($emp_id != 346) && /*genesis*/
											($emp_id != 321) 
								
										)
									{
										//el evento se le da al servicio
										$data_serv['cal_folio'] = $cal_id;
										$data_serv['cal_id'] = $cal_id;
										
										//el servicio se crea
										$serv_id = $this->servicio->inserta(array_to_upper($data_serv));			

									}

								if (($emp_id == 298) ||  ($emp_id == 152) ||  ($emp_id  == 193) ||  ($emp_id  == 210) || ($emp_id  == 230) || ($emp_id  == 311) || ($emp_id  == 142) )
								{						
									//se extraen examenes de los paquetes para evaluados de seguros
									$nomserv='';
									
							
									$data_clte['nomserv'] =  $nomserv;	

									//evaluados de seguros

										$j=1;
										for($i=1; $i <= 4; $i++)
										{	
											if 	(
												(strlen($this->input->post('nombre'.strval($i)))>0) &&
												(strlen($this->input->post('paterno'.strval($i)))>0)
												)
												
											{
											//informncion general de evaluado
											$data_clte['clte_nombre_crypt'] =  trim($this->input->post('nombre'.strval($i)));
											$data_clte['clte_2_nombre_crypt'] =  trim($this->input->post('nombre_adic'.strval($i)));
											$data_clte['clte_paterno_crypt'] =  trim($this->input->post('paterno'.strval($i)));
											$data_clte['clte_materno_crypt'] =  trim($this->input->post('materno'.strval($i)));
											$data_clte['clte_f_nac'] = formatea_fecha_mysql($this->input->post('fnac'.strval($i)));
											$data_clte['clte_genero_cve'] =  $this->input->post('genero'.strval($i));                				
											

											$data_clte['clte_rfc_crypt']=substr($data_clte['clte_paterno_crypt'],0,2).substr($data_clte['clte_materno_crypt'],0,1).substr($data_clte['clte_nombre_crypt'],0,1).substr($data_clte['clte_f_nac'],2,2).substr($data_clte['clte_f_nac'],5,2).substr($data_clte['clte_f_nac'],8,2);

											$data_clte['serv_id'] =  $this->input->post('serv_id');
											
											if ($emp_id == 210)
											{
												if ($j== 1)
												{	
													$data_clte['clte_webflow'] =  $this->input->post('webflow1');
												}
												elseif ($j== 2)
												{
													$data_clte['clte_webflow'] =  $this->input->post('webflow2');
												}
												elseif ($j== 3)
												{
													$data_clte['clte_webflow'] =  $this->input->post('webflow3');
												}
												else
												{
													$data_clte['clte_webflow'] =  $this->input->post('webflow4');
												}
												
												$data_clte['clte_region'] =  $this->input->post('region');									
												$cal_lugar_det= $this->input->post('lugar_det');
												
												$cp_codigo=$this->input->post('cp');
												
												$this->db->select('*');
												$this->db->from('cat_dir_cp');
												$this->db->like('cp_codigo',$cp_codigo);
												$this->db->limit(1); 
												$zona=$this->db->get()->row_array();
													
												if (
													($zona['cp_ciudad'] == 'QUERÉTARO') ||
													($zona['cp_ciudad'] == 'CIUDAD DE MÉXICO') ||												
													($zona['estado'] == 'QUERÉTARO') || 
													($zona['cp_ciudad'] == 'MONTERREY')
												   )
												{
													$zonificacion='ZONA 1';
												}
												elseif (
													($zona['cp_ciudad'] == 'PUEBLA (HEROICA PUEBLA)') ||
													($zona['cp_ciudad'] == 'CUERNAVACA') ||
													($zona['cp_ciudad'] == 'LEÓN DE LOS ALDAMA') ||												
													($zona['cp_ciudad'] == 'GUADALAJARA') ||
													($zona['cp_ciudad'] == 'AGUASCALIENTES') ||
													($zona['cp_ciudad'] == 'CANCÚN') ||
													($zona['cp_ciudad'] == 'VILLAHERMOSA') ||
													($zona['estado'] == 'JALISCO') ||  
													($zona['estado'] == 'MÉXICO')  
												   )
												{
													$zonificacion='ZONA 2';
												}
												else	
												{
													$zonificacion='ZONA 3'; 
												}					
														
											}								

											$data_clte['clte_zona'] = $zonificacion;
											$data_clte['clte_status_proc'] = 'AGENDADO';
				

											$data_clte['clte_env_pais_cve'] =  $this->input->post('pais');
											$data_clte['clte_env_cp'] =  $this->input->post('cp');
											$data_clte['clte_env_edo_cve'] =  $this->input->post('entidad');
											$data_clte['clte_env_colonia_crypt'] =  $this->input->post('colonia');
											$data_clte['clte_env_localidad'] =  $this->input->post('localidad');
											$data_clte['clte_env_municipio'] =  $this->input->post('municipio');
											$data_clte['clte_env_calle_crypt'] =  $this->input->post('calle');
											$data_clte['clte_env_num_ext_crypt'] =  $this->input->post('next');
											$data_clte['clte_env_num_int_crypt'] =  $this->input->post('nint');
											
															
											$data_clte['clte_edo_civ_cve'] =  $this->input->post('civil'.strval($i));
											
											$data_clte['emp_id'] =  $emp_id;  
											$data_clte['cei_id'] =  $this->input->post('cei_control');
											$data_clte['clte_f_nac'] =  date('Y-m-d');
											
											if ($emp_id  == 210)
											{
												$data_clte['nomserv'] = $examen_ins['exam_cve'].'INSIGEXMED;TOMAM;';// 'INSIGNIA';
												$data_clte['suc_id'] = $usuario['suc_id']; /*insignia*/
												$data_clte['serv_id'] = $serv_id; 
											}
											
											/*********************************************
											validar que el evaluado no este rregistrado
											********************************************/
												
											$data_clte= array_to_upper($data_clte);										
											$cliente_encontrado=0;
											
											if ($cliente_encontrado)
											{
												
												$data_x['clte_env_pais_cve']=$data_clte['clte_env_pais_cve'];
												$data_x['clte_env_cp']=$data_clte['clte_env_cp'];
												$data_x['clte_env_edo_cve']=$data_clte['clte_env_edo_cve'];
												$data_x['clte_env_colonia_crypt']=$data_clte['clte_env_colonia_crypt'];
												$data_x['clte_env_localidad']=$data_clte['clte_env_localidad'];
												$data_x['clte_env_municipio']=$data_clte['clte_env_municipio'];
												$data_x['clte_env_calle_crypt']=$data_clte['clte_env_calle_crypt'];
												$data_x['clte_env_num_ext_crypt']=$data_clte['clte_env_num_ext_crypt'];
												$data_x['clte_env_num_int_crypt']=$data_clte['clte_env_num_int_crypt'];
												$data_x['clte_webflow']=$data_clte['clte_webflow'];
												$data_x['clte_zona'] = $zonificacion;
												$data_x['serv_id']=$data_clte['serv_id'];
												$data_x['clte_region']=$data_clte['clte_region'];
												$data_x['nomserv']=$data_clte['nomserv'];
												
												$this->cliente->actualiza_registro_sin_log($cliente_encontrado['clte_id'],array_to_upper($data_x));
											}
											else
											{	
												$cliente_id = $this->cliente->inserta(array_to_upper($data_clte));
												
												$data_archivero_elect['clte_id'] =  $cliente_id;
												$data_archivero_elect['doc_nombre'] =  'ODT';
												$data_archivero_elect['doc_f'] =  date('Y-m-d H:i:s');
												$data_archivero_elect['serv_id'] =  $data_clte['serv_id'];
												$data_archivero_elect['doc_path'] = $data_p['file_name'];
												$data_archivero_elect['doc_type'] = 'SEGUROS';
												$this->cliente->add_doc(array_to_upper($data_archivero_elect));

												if ($data_serv['serv_anexo_nombre'])
												{	
													$data_archivero_elect['doc_nombre'] =  $data_serv['serv_anexo_nombre'];
													$data_archivero_elect['serv_id'] =  $data_clte['serv_id'];
													$data_archivero_elect['doc_path'] = $data_serv['serv_anexo_path'];
													$this->cliente->add_doc(array_to_upper($data_archivero_elect));
												}
											}
											
											$param['eva'.strval($j)]=$cliente_id;
											$j++;
											
											}					
										}
								}
								
								//el titulo del servicio y evento se actualiza segun empresa 
								if ((get_empresas_giro($emp_id ,'SEGUROS')))
								{	
									
									if ($emp_id == 298)
									{
										$param['cal_titulo']= 'BX+ - ';
									}
									elseif ($emp_id == 152)
									{
										$param['cal_titulo']= 'SMTY - ';
									}
									elseif ($emp_id == 193)
									{
										$param['cal_titulo']= 'ALLIANZ - ';
									}
									elseif ($emp_id == 230)
									{
										$param['cal_titulo']= 'AXA - ';
									}
									elseif ($emp_id == 311)
									{
										$param['cal_titulo']= 'GNP - ';
									}
									elseif ($emp_id == 142)
									{
										$param['cal_titulo']= 'GENERAL DE SEGUROS - ';
									}						
									else
									{
										$param['cal_titulo']= 'INSIGNIA LIFE - ';
									}	
									
									$eva0=strtoupper(trim($this->input->post('nombre1')).' '.trim($this->input->post('paterno1')).' '.trim($this->input->post('materno1')));
									$param['cal_titulo'].=$eva0;
									
									
									if (strlen($this->input->post('nombre2')) > 0) 
										{
											$eva0=chr(10).strtoupper(trim($this->input->post('nombre2')).' '.trim($this->input->post('paterno2')).' '.trim($this->input->post('materno2')));
											$param['cal_titulo'].=$eva0; 
										}	
									
									if (strlen($this->input->post('nombre3')) > 0) 
										{
											$eva0=chr(10).strtoupper(trim($this->input->post('nombre3')).' '.trim($this->input->post('paterno3')).' '.trim($this->input->post('materno3')));
											$param['cal_titulo'].=$eva0; 
										}	
									
									if (strlen($this->input->post('nombre4')) > 0) 
										{
											$eva0=chr(10).strtoupper(trim($this->input->post('nombre4')).' '.trim($this->input->post('paterno4')).' '.trim($this->input->post('materno4')));
											$param['cal_titulo'].=$eva0; 
										}						
									
									$param['cal_titulo'].=' ** '.get_options_per_grupo('HC_SEGUROS', $params['hc1']);		
									
								}
								elseif (($emp_id == 210) /*|| ($emp_id == 193)*/ )
								{				
									$param['cal_titulo']= get_empresa($params['emp_id']).' ';
									$eva0=strtoupper(trim($this->input->post('nombre1')).' '.trim($this->input->post('paterno1')).' '.trim($this->input->post('materno1')));
									$param['cal_titulo'].=$eva0;
									
									
									if (strlen($this->input->post('nombre2')) > 0) 
										{
											$eva0=chr(10).strtoupper(trim($this->input->post('nombre2')).' '.trim($this->input->post('paterno2')).' '.trim($this->input->post('materno2')));
											$param['cal_titulo'].=$eva0; 
										}	
									
									if (strlen($this->input->post('nombre3')) > 0) 
										{
											$eva0=chr(10).strtoupper(trim($this->input->post('nombre3')).' '.trim($this->input->post('paterno3')).' '.trim($this->input->post('materno3')));
											$param['cal_titulo'].=$eva0; 
										}	
									
									if (strlen($this->input->post('nombre4')) > 0) 
										{
											$eva0=chr(10).strtoupper(trim($this->input->post('nombre4')).' '.trim($this->input->post('paterno4')).' '.trim($this->input->post('materno4')));
											$param['cal_titulo'].=$eva0; 
										}						
									
									$param['cal_titulo'].=' ** '.get_options_per_grupo('HC_SEGUROS', $params['hc1']);		
									
								}
								else
								{	if ($serv_id == 0 )
									{
										$param['cal_titulo']= get_empresa($params['emp_id']).', IDA:'.$cal_id; 
									}
									else
									{
										$param['cal_titulo']= get_empresa($params['emp_id']).', OS:'.$serv_id.', IDA:'.$cal_id; 
									}
								}					

													
								$param['serv_id']=$serv_id;
								$this->agenda->update_evento($cal_id,$param);	
							}

						}

					}
			 
					if ($emp_id == 253)
					{   
								$this->load->helper('mail');
								$evento = $this->agenda->get_evento($cal_id);
								
								$data_email = array('evento' => $evento);						
								$html = $this->load->view('agenda/email_add_evento_servicio',$data_email,TRUE);
								$this->load->helper('mail');
							
									if ($emp_id == 31)
									{
										$this->load->model('empresa/Empresa_model','empresa');
										
										$data_empresa = $this->empresa->get_empresa_by_id($emp_id);
										
										send_mail_std_event_serv(
										$this->input->post('mail'), 
										$evento, 
										$html,
										$cal_id,
										get_empresa($params['emp_id']),
										$user['usr_nombre'].' '.$user['usr_paterno'],
										$user['usr_correo'],
										$data_empresa['emp_responsable'] , 
										$data_empresa['emp_correo']
										,$params['cal_lugar'] );

									}
										else
									{

										send_mail_std_event_serv(
										$this->input->post('mail'), 
										$evento, 
										$html,
										$cal_id,
										get_empresa($emp_id),
										$user['usr_nombre'].' '.$user['usr_paterno'],
										$user['usr_correo'],
										'',
										'',
										$params['cal_lugar'] );

									}
					}
				 
				if ( ($cal_id) && ($error_gsi == 0) && ($error_observaciones_puestos == 0) )
                {
                        $this->load->helper('mail');
                        $evento = $this->agenda->get_evento($cal_id);						
                        $data_email = array('evento' => $evento);						
                        $html = $this->load->view('agenda/email_add_evento_servicio_pedidod',$data_email,TRUE);
						
							if ($emp_id == 31)
							{
								$this->load->model('empresa/Empresa_model','empresa');								
								$data_empresa = $this->empresa->get_empresa_by_id($emp_id);
								
								send_mail_std_event_serv(
								$this->input->post('mail'), 
								$evento, 
								$html,
								$cal_id,
								get_empresa($params['emp_id']),
								$user['usr_nombre'].' '.$user['usr_paterno'],
								$user['usr_correo'],
								$data_empresa['emp_responsable'] , 
								$data_empresa['emp_correo']
								,$params['cal_lugar'],
								 $usuario );

							}
							else
							{
								send_mail_std_event_serv(
								$this->input->post('mail'), 
								$evento, 
								$html,
								$cal_id,
								get_empresa($emp_id),
								$user['usr_nombre'].' '.$user['usr_paterno'],
								$user['usr_correo'],
								'',
								'',
								$params['cal_lugar'],
								$usuario); 
							}
		
		
							if (get_empresas_corporacion($emp_id,'GSI'))
							{
								$gsi_evaluados=$params['cal_evaluados'];
								$gsi_evaluados=str_replace(' | ', '|',$gsi_evaluados);
								$gsi_evaluados=str_replace('||', '|',$gsi_evaluados);
								$gsi_evaluados[0]=' ';
								$gsi_evaluados=trim($gsi_evaluados);
								$gsi_evaluados=str_replace(' - ', '-',$gsi_evaluados);
								$array_gsi_evaluados=explode("|",$gsi_evaluados);
								
								foreach ($array_gsi_evaluados as $gsi_evaluado): 
									if ($gsi_evaluado)
									{	
										$array_gsi_evaluado=explode("-",$gsi_evaluado);								
										$data_y['clte_ida']=$cal_id;
										$this->cliente->actualiza_registro_sin_log($array_gsi_evaluado[0],array_to_upper($data_y));											
									}
								endforeach;
							}	
							
                    send_json_ok('Se guardó de forma correcta.');
                }
                else
                {   if ($error_observaciones_puestos == 1)
					{
						send_json_error('Ha ocurrido un error en los campos de OBSERVACIONES y PUESTOS, por favor revisar.');
					}
			        elseif ($error_gsi == 0)
					{
						if ($detecta_pkts > 0)
						{
							send_json_error('Ocurrió un error al guardar, por favor revise si toda su información este completa y vuelva intentar. Sugerencia valide VIÁTICOS.');
						}
						else
						{
							if ($emp_id == 210)
							{	
						
								if (
									($error_evaluado2 == 1) ||
									($error_evaluado3 == 1) ||
									($error_evaluado4 == 1) 
								   )
								{
									send_json_error('Por favor completar la información de los demás evaluados.');
								}	
								else	
								{						
									send_json_error('No se ha registrado el Archivo de Servicios, por favor revisar.');
								}
								
							}
							else
							{	
								send_json_error('Ocurrió un error al guardar, ¿eligio al menos un examen para este servicio?');
							}						
						}
					}
					else
					{
						send_json_error('No pudo agendarse la fecha deseada, Por favor busque otra fecha con la capacidad deseada.');
					}
				
                }				
				
				
			}
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
			
  			if($this->uri->segment(3) != '')
            {
                $data['evento_dia'] = date('Y-m-d',strtotime($this->uri->segment(3)));
            }
            else
            {
                $data['evento_dia'] = date('Y-m-d');
            }
			
			
			$data['evento_dia'] = date('Y-m-d');
			$data['empresa'] = $emp_id;
			
			$date_string = date('Y-m-d'); 
		
			/*TOMAMOS LA TABAL DE HORARIOS PARA LOS CASOS DE MONTERREY, LA VIGA Y ALPURA*/
			if ( ($user_cei == 4) || ($user_cei == 8) ||  (strstr($usuario['portal'],'ALPURA')) )
			{	
				$data['sheduler']=$this->agenda->horario(intval(date("W", strtotime($date_string))),$table);
			}
			
			/*TRAE A LOS EVAALUDOS SEGUN EL CASO*/
			if (strstr($usuario['portal'],'ALPURA'))
			{
				$data['evaluados'] = $this->cliente->get_allo_alpura_agenda(60,$emp_id);
			}
			elseif (strstr($usuario['acciones'],'SBORJA+'))
			{
				$data['evaluados'] = $this->cliente->get_allo_gsi_agenda_sborja(60,$emp_id);
			}
			else
			{
				$data['evaluados'] = $this->cliente->get_allo_gsi_agenda(60,$emp_id);
			}
			
            $this->load->helper('template');
			
            $params_view = array(
                'title' => 'Servicios',
                'view' => 'servicio/edit_b_pedido',
                'view_data' => $data
               );
			   
            render_template($params_view);  
        }
    }

	


   
/************************************************************************************/   
    public function edita_b($emp_id,$modo=0)
    {
		if ((get_emp_osa($emp_id) == 3) && ($emp_id == 360))
		{	
			$control_empresa_osa_3=360;
		}
		else
		{
			$control_empresa_osa_3=36000;
		}
		$user = $this->session->user;
		$usuario = $this->medico->get($user['usr_id']);
		$user_empresa=$user['emp_id'];
		$user_cei=get_cei_id();		
		
		$data['evento_dia'] = date('Y-m-d',strtotime($this->uri->segment(3)));
		$fecha_div = explode('T', $this->uri->segment(3));
		$error_gsi=0;
		
		$error_observaciones_puestos=0;
		
		/*SE PREPARA A USAR EL SCHEDULER REQUERIDOS*/
		if (strstr($usuario['portal'],'ALPURA'))
		{
			$table='doc12_sheduler';
		}
		elseif (strstr($usuario['acciones'],'SBORJA+'))
		{
			$table='doc09_sheduler';
		}
		elseif ($user_cei == 4)
		{	
			$table='doc10_sheduler';
		}
		elseif ($user_cei == 8)
		{	
			$table='doc11_sheduler';
		}
	

		
		if ($modo == 1)
		{
			$data['modo']=1;
		}
		else
		{
			$data['modo']=0;
		}
		
        if(isset($fecha_div[1]))
        {
            $data['hora_ini'] = date('H:i',strtotime($fecha_div[1]));
        }
        else
        {
            $data['hora_ini'] = date('H:i');
        }	
       
	   if(isset($_POST) && count($_POST) > 0)     
       {
            //recibe los datos
            $this->load->library('form_validation');
           
			if (
				($emp_id == 298) ||  /*SEGUROS BX+ */
				($emp_id == 152) ||  /*SEGUROS MONTERREY*/
				($emp_id  == 193) || /*ALLIANZ*/
				($emp_id  == 210) || /*INSIGNIA LIFE*/
				($emp_id  == 230) || /*AXA*/
				($emp_id  == 142) || /*GENERAL DE SEGUROS*/
				($emp_id  == 311)    /*GNP*/
				|| (get_emp_osa($emp_id) == 3)
			 )
			{	
			
				if ($emp_id == 193)
				{					
					$this->form_validation->set_rules('fsm_autoriza','Autoriza ha Realizar Confirmación','required');
					$this->form_validation->set_rules('nombre1','Nombre de Evaluado','required');
					$this->form_validation->set_rules('paterno1','Apellido Paterno del Evaluado','required');
					$this->form_validation->set_rules('materno1','Apellido Materno del Evaluado','required');
					$this->form_validation->set_rules('materno1','Apellido Materno del Evaluado','required');
					$this->form_validation->set_rules('cp','Código Postal de la dirección del evaluado','required');
					
				}
				elseif ($user['emp_id'] == 31)
				{
					
					
					if ( ($emp_id == 15200) || ($emp_id  == 230) || ($emp_id  == 311) )
					{	
						$this->form_validation->set_rules('serv_orden','Orden de Servicio/Pedido','required');
						$this->form_validation->set_rules('fsm_viaticos','Viáticos','required');
					}
					
					if ($emp_id == 152)
					{					
						$this->form_validation->set_rules('zona','Zona','required');
						if ($this->input->post('zona')=='ZONA 1')
						{ $this->form_validation->set_rules('region1','Región de Zona 1','required'); }
						elseif ($this->input->post('zona')=='ZONA 2')
						{ $this->form_validation->set_rules('region2','Región de Zona 2','required'); }
						if ($this->input->post('zona')=='ZONA 3')
						{ $this->form_validation->set_rules('region3','Región de Zona 3','required'); }
						if ($this->input->post('zona')=='ZONA 4')
						{ $this->form_validation->set_rules('region4','Región de Zona 4','required'); }
						if ($this->input->post('zona')=='ZONA 5')
						{ $this->form_validation->set_rules('region5','Región de Zona 5','required'); }
	
					}

				
					$this->form_validation->set_rules('nombre1','Nombre de Evaluado','required');
					$this->form_validation->set_rules('paterno1','Apellido Paterno del Evaluado','required');
					$this->form_validation->set_rules('materno1','Apellido Materno del Evaluado','required');

					
					if ($emp_id == 152)
					{
						$this->form_validation->set_rules('webflow1','Web Flow del Evaluado','required');
					}
					
					if ($emp_id != $control_empresa_osa_3)
					{
						$this->form_validation->set_rules('cp','Código Postal de la dirección del evaluado','required');
					}

				}
				elseif ($user['emp_id'] == 210)
				{
					$this->form_validation->set_rules('nombre1','Nombre de Evaluado','required');
					$this->form_validation->set_rules('paterno1','Apellido Paterno del Evaluado','required');
					$this->form_validation->set_rules('materno1','Apellido Materno del Evaluado','required');
					$this->form_validation->set_rules('webflow1','ODT','required');	
					$this->form_validation->set_rules('cp','Código Postal de la Dirección donde se aplicara el servicio','required');	
				}				
			}
			elseif (!(strstr($usuario['portal'],'ALPURA')))
			{
				 $this->form_validation->set_rules('observaciones','Observaciones','required');	
			}	

			
			if ((!(valida_corporacion($emp_id,'GSI') == 'GSI')) && !(strstr($usuario['portal'],'ALPURA')))
			{
				$this->form_validation->set_rules('fecha_event_ini','Fecha inicia','required');
				$this->form_validation->set_rules('hora_event_ini','Hora inicia','required');
				$this->form_validation->set_rules('fecha_event_fin','Fecha fin','required');
				$this->form_validation->set_rules('hora_event_fin','Hora fin','required');			
			}
			
			$this->form_validation->set_rules('lugar','Lugar de realización de los servicios','required');
			
            if($this->form_validation->run())
            {
					if ($user['usr_id'] == 261)
					{
						$usr_admin=$this->input->post('administrador');
						if ($usr_admin == 0){$usr_admin = 22;}
						$user=get_a_usuario($usr_admin);						
					}	
				
				
					if
					(
					(strlen ($this->input->post('observaciones')) > 1) &&	
					(strlen ($this->input->post('descripcion')  ) > 1) 
					)
					{
						if ( trim($this->input->post('observaciones')) == trim($this->input->post('descripcion')) ) 
						{ $error_observaciones_puestos=1; }	
						
					}
				
					 if ($error_observaciones_puestos == 0 )
					 {	 
						$total_examenes_selectos=$this->input->post('total_examenes_selectos');
						$paquetes='';
						$detecta_pkts=0;
						for($i=1; $i <= $total_examenes_selectos; $i++)
						{
							$indice='examen_select_pkt_'.strval($i);
							if ($this->input->post($indice) != NULL)
							{	
							$paquetes.=$this->input->post($indice).';';
							$detecta_pkts++;
							}
							
						}				
						
						$id_horario=0;					
						$cuantos_evaluados=0;
						$los_evaluados=$this->input->post('evaluados');
						$modo=$this->input->post('modo');
						
						if ($user['usr_id'] == 466) /*es unidad reclutadora*/
						{
							$modo=1;
						}
						
						if  (
								(($user_root3 == 2) && ($user_root4 == 3)) 
								||
								(strstr($usuario['acciones'],'REGNORMAL'))
							)	
							{$modo = 1;}
							
						
						
						
						if (strstr($usuario['portal'],'ALPURA'))	
						{
							$id_horario=$this->input->post('horario');
							
							$cuantos_evaluados=$this->input->post('num_eva');
							
							if (!($cuantos_evaluados > 0))
							{
								$cuantos_evaluados=1;
							}
							
							$horario_ok=$this->agenda->valida_horario($id_horario,$cuantos_evaluados,$table);
							
							if ($horario_ok)					
							{
								$cuantos_evaluados=0;
								if (strlen($this->input->post('evaluado1')) > 3) 
								{
									if (($horario_ok['she_capacidad']-$cuantos_evaluados) > 0)
									{	
										$el_eva1 = strstr($this->input->post('evaluado1'), ' - ', true); 
										$cuantos_evaluados++;
									}
									else
									{
										$el_eva1 =0;
									}	
								}
								if (strlen($this->input->post('evaluado2')) > 3) 
								{
									if (($horario_ok['she_capacidad']-$cuantos_evaluados) > 0)
									{	
										$el_eva2 = strstr($this->input->post('evaluado2'), ' - ', true); 
										$cuantos_evaluados++;
									}
									else
									{
										$el_eva2 =0;
									}	
								}
								if (strlen($this->input->post('evaluado3')) > 3) 
								{	
									if (($horario_ok['she_capacidad']-$cuantos_evaluados) > 0)
										{	
											$el_eva3 = strstr($this->input->post('evaluado3'), ' - ', true); 
											$cuantos_evaluados++;
										}
										else
										{
											$el_eva3 =0;
										}
								}
								
								$horario_ok['she_capacidad']=$horario_ok['she_capacidad']-$cuantos_evaluados;
								$horario_apartado=$this->agenda->aparta_horario($id_horario,$horario_ok,$table);
			
								$fecha_ini = $horario_ok['she_fecha'].' '.$horario_ok['she_hora_ini'].':02';
								$fecha_fin = $horario_ok['she_fecha'].' '.$horario_ok['she_hora_fin'].':02';

								
								
								foreach (explode(';', $paquetes) as $detalle)
								{
									if ( strlen($detalle) > 0)
									{												
										$exa_sel['nomserv'].= get_nombre_de_examen_por_empresa($detalle,$emp_id);							
									}
								}

						
							$k=0;
								if ( $el_eva1 > 0)
								{
								$cliente_gsi_id = $this->cliente->actualiza( $el_eva1,$exa_sel);
								}
													
								if ( $el_eva2 > 0)
								{
								$cliente_gsi_id = $this->cliente->actualiza($el_eva2,$exa_sel);
								}
								if ( $el_eva3 > 0)
								{
								$cliente_gsi_id = $this->cliente->actualiza($el_eva3,$exa_sel);
								}						

								$los_evaluados='';
								
								if ( $el_eva1 > 0)
								{
									$los_evaluados.=' | '.$this->input->post('evaluado1').' | ';
									$k++;
								}
								if ( $el_eva2 > 0)
								{
									$los_evaluados.=' | '.$this->input->post('evaluado2').' | ';
									$k++;
								}
								if ( $el_eva3 > 0)
								{
									$los_evaluados.=' | '.$this->input->post('evaluado3').' | ';
									$k++;
								}	
												
							}
							else
							{
								$fecha_ini='21-01-01 01:01:01';
								$fecha_fin='21-01-01 01:01:01';
								$error_gsi=1;
							}
							
						}
						elseif ((valida_corporacion($emp_id,'GSI') == 'GSI') && ($modo==0) &&  ( ($user_cei == 4) || ($user_cei == 8) ))
						{
							$id_horario=$this->input->post('horario');
							
							$cuantos_evaluados=$this->input->post('num_eva');
							
							if (!($cuantos_evaluados > 0))
							{
								$cuantos_evaluados=1;
							}
							
							$horario_ok=$this->agenda->valida_horario($id_horario,$cuantos_evaluados,$table);
							
							if ($horario_ok)					
							{

								$cuantos_evaluados=0;
								if (strlen($this->input->post('evaluado1')) > 3) 
								{
									if (($horario_ok['she_capacidad']-$cuantos_evaluados) > 0)
									{	
										$el_eva1 = strstr($this->input->post('evaluado1'), ' - ', true); 
										$cuantos_evaluados++;
									}
									else
									{
										$el_eva1 =0;
									}	
								}
								if (strlen($this->input->post('evaluado2')) > 3) 
								{
									if (($horario_ok['she_capacidad']-$cuantos_evaluados) > 0)
									{	
										$el_eva2 = strstr($this->input->post('evaluado2'), ' - ', true); 
										$cuantos_evaluados++;
									}
									else
									{
										$el_eva2 =0;
									}	
								}
								if (strlen($this->input->post('evaluado3')) > 3) 
								{	
									if (($horario_ok['she_capacidad']-$cuantos_evaluados) > 0)
										{	
											$el_eva3 = strstr($this->input->post('evaluado3'), ' - ', true); 
											$cuantos_evaluados++;
										}
										else
										{
											$el_eva3 =0;
										}
								}
								
								$horario_ok['she_capacidad']=$horario_ok['she_capacidad']-$cuantos_evaluados;
								$horario_apartado=$this->agenda->aparta_horario($id_horario,$horario_ok,$table);
			
								$fecha_ini = $horario_ok['she_fecha'].' '.$horario_ok['she_hora_ini'].':02';
								$fecha_fin = $horario_ok['she_fecha'].' '.$horario_ok['she_hora_fin'].':02';

								
								
								foreach (explode(';', $paquetes) as $detalle)
								{
									if ( strlen($detalle) > 0)
									{												
										$exa_sel['nomserv'].= get_nombre_de_examen_por_empresa($detalle,$emp_id);							
									}
								}

						
							$k=0;
								if ( $el_eva1 > 0)
								{
								$cliente_gsi_id = $this->cliente->actualiza( $el_eva1,$exa_sel);
								}
													
								if ( $el_eva2 > 0)
								{
								$cliente_gsi_id = $this->cliente->actualiza($el_eva2,$exa_sel);
								}
								if ( $el_eva3 > 0)
								{
								$cliente_gsi_id = $this->cliente->actualiza($el_eva3,$exa_sel);
								}						

								$los_evaluados='';
								
								if ( $el_eva1 > 0)
								{
									$los_evaluados.=' | '.$this->input->post('evaluado1').' | ';
									$k++;
								}
								if ( $el_eva2 > 0)
								{
									$los_evaluados.=' | '.$this->input->post('evaluado2').' | ';
									$k++;
								}
								if ( $el_eva3 > 0)
								{
									$los_evaluados.=' | '.$this->input->post('evaluado3').' | ';
									$k++;
								}	
												
							}
							else
							{
								$fecha_ini='21-01-01 01:01:01';
								$fecha_fin='21-01-01 01:01:01';
								$error_gsi=1;
							}
							
						}
						else
						{
							$fecha_ini = formatea_fechahora_mysql($this->input->post('fecha_event_ini').' '.$this->input->post('hora_event_ini'));
							$fecha_fin = formatea_fechahora_mysql($this->input->post('fecha_event_fin').' '.$this->input->post('hora_event_fin'));					
						}				
					
			

						$params = array
						(
							'cal_pkts' => $paquetes,
							//Observaciones
							'cal_observaciones' =>$this->input->post('observaciones'),
							//Evaluados
							'cal_evaluados' => $los_evaluados, 	
							//Solicitante
							'cal_usr_nombre' => $user['usr_nombre'],
							'cal_usr_paterno' => $user['usr_paterno'],
							'cal_usr_materno' => $user['usr_materno'],
							'cal_usr_correo' => $user['usr_correo'],					
							//datos normales de calendario	
							'cal_fecha' => $this->input->post('fecha'),
							'cal_titulo' => $this->input->post('asunto'),
							'cal_servicio' => NULL,
							'cal_descripcion' => $this->input->post('descripcion'),
							'cal_fecha_ini' => $fecha_ini,
							'cal_fecha_fin' => $fecha_fin,
							'cal_id_horario' => $id_horario,					
							'cal_cuantos_evaluados' => $cuantos_evaluados,
							'cal_uid' => uniqid(rand(0, getmypid()))					
						);

						if (($emp_id == 298) ||  ($emp_id == 152) || ($emp_id  == 193) || ($emp_id  == 210) || ($emp_id  == 230) || ($emp_id  == 311) || ($emp_id  == 142))
						{	
							if (strlen($this->input->post('hc1')) > 0)
							{
								$params['hc1'] =$this->input->post('hc1');
							}

							if (strlen($this->input->post('hc2')) > 0)
							{
								$params['hc2'] =$this->input->post('hc2');
							}

							if (strlen($this->input->post('hc3')) > 0)
							{
								$params['hc3'] =$this->input->post('hc3');
							}				
						}

						if ($user['emp_id'] == 31)
						{					
							$params['cal_viaticos'] =$this->input->post('fsm_viaticos');
						}				
						else
						{
							$params['cal_viaticos'] ='NO';
						}	

						if ($emp_id == 193)
						{		
							$params['cal_autoriza'] =$this->input->post('fsm_autoriza');				
						}



						if ($user['emp_id'] == 31)
						{					
							$params['emp_id'] = $emp_id;
						}				
						elseif  (
									($user['emp_id'] == 126)   ||
									($user['emp_id'] ==125)   ||
									($user['emp_id'] ==33)   ||
									($user['emp_id'] ==179)   ||
									($user['emp_id'] ==181)   ||
									($user['emp_id'] ==180)   ||
									($user['emp_id'] ==77)   ||
									($user['emp_id'] ==176)   ||
									($user['emp_id'] ==178)   ||
									($user['emp_id'] ==177)   ||
									($user['emp_id'] ==57)   ||
									($user['emp_id'] ==175)   ||
									($user['emp_id'] ==174)   ||						 
									($user['emp_id'] == 127)    
									|| ($user['emp_id'] == 183)
									|| ($user['emp_id'] ==33)
									|| ($user['emp_id'] ==77)
									|| ($user['emp_id'] ==106)
									|| ($user['emp_id'] ==148)							
								)/*es un despacho de GSI*/
						{
							$params['emp_id'] = $emp_id;
							$params['desp_emp_id'] = $this->input->post('empresa');
						}
						else
						{
							$params['emp_id'] = $emp_id;
							$params['desp_emp_id'] = 0;
						}
						
						

						
						$params['cal_lugar'] = $this->input->post('lugar');
						

						if (!(get_empresas_giro($emp_id,'SEGUROS')))
						{					
							$params['cal_lugar_det'] = $this->input->post('lugar_det');					
						}
						else
						{								
							if ($params['cal_lugar'] == 0)
							{												
								$domicilio=$this->input->post('calle').' ';
								$domicilio.=$this->input->post('next').' '.$this->input->post('nint').' ';
								$domicilio.=$this->input->post('colonia').', ';
								$domicilio.='C.P. '.$this->input->post('cp').', ';
								$domicilio.=$this->input->post('municipio').', ';
								$domicilio.=$this->input->post('localidad').', ';
								$domicilio.=$this->input->post('entidad').', ';
								$domicilio.=$this->input->post('pais').'.';

								$params['cal_lugar_det'] = 	$domicilio;	

								$params['cal_eva_telefono_1'] = $this->input->post('telefono_1');						
								$params['cal_eva_telefono_2'] = $this->input->post('telefono_2');						
							}
							elseif ($params['cal_lugar'] == 2) 
							{	
								$params['cal_lugar_det'] ='Calle San Borja 1365, Vértiz Narvarte, Benito Juárez, C.P. 03600, CDMX'; 
							}
							else
							{	
								$params['cal_lugar_det'] = 'Paseo de la Reforma No. 342, Piso 14, Col. Juárez, Del. Cuauhtémoc, C.P. 06600, CDMX';  
							}							
					
						}

						$params['cal_email'] = $user['usr_correo'].'; '.$this->input->post('mail');


						/******NUEVOS ARCHIVO ANEXO 0 ******************************/
						if(!empty($_FILES['anexo']['name']))
						{
							$nombre_anexo=$_FILES['anexo']['name'];
							$this->load->library('upload');
							$filename = md5(time());
							$config = array(
									'upload_path'   => './../../files/anexos/',
									'overwrite'     => TRUE,
									'file_name'     => $filename,
									'allowed_types' => 'doc|docx|pdf|txt|xlsx|xls|png|jpg|jpeg',
									'max_size'      => '10000'
							);

							$this->upload->initialize($config);
							
							if ( ! $this->upload->do_upload('anexo'))
							{
								echo json_encode(array('status' => 'error','content' => $this->upload->display_errors()));
								exit;
							}
							else 
							{
								$data = $this->upload->data();
								$params['cal_anexo_path'] = $data['file_name'];
								$params['cal_anexo_nombre'] = $nombre_anexo;
								$data_serv['serv_anexo_path'] = $data['file_name'];
								$data_serv['serv_anexo_nombre'] = $nombre_anexo;
								
							}
						/*}*/
						/***********************************************************/	
						}

						/******NUEVOS ARCHIVO ANEXO 1 ******************************/
						if(!empty($_FILES['anexo1']['name']))
						{
							$nombre_anexo=$_FILES['anexo1']['name'];
							$this->load->library('upload');
							
							sleep(1);
							$filename1 = md5(time());
							$config = array(
									'upload_path'   => './../../files/anexos/',
									'overwrite'     => TRUE,
									'file_name'     => $filename1,
									'allowed_types' => 'doc|docx|pdf|txt|xlsx|xls|png|jpg|jpeg',
									'max_size'      => '10000'
							);

							$this->upload->initialize($config);
							
							if ( ! $this->upload->do_upload('anexo1'))
							{
								  echo json_encode(array('status' => 'error','content' => $this->upload->display_errors()));
								exit;
							}
							else 
							{
								$data = $this->upload->data();
								$params['cal_anexo1_path'] = $data['file_name'];
								$params['cal_anexo1_nombre'] = $nombre_anexo;
								$data_serv['serv_anexo1_path'] = $data['file_name'];
								$data_serv['serv_anexo1_nombre'] = $nombre_anexo;
							}
						}
						/***********************************************************/				
						
						/******NUEVOS ARCHIVO ANEXO 2 ******************************/
										if(!empty($_FILES['anexo2']['name']))
										{
											$nombre_anexo=$_FILES['anexo2']['name'];
											$this->load->library('upload');
											
											sleep(1);
											$filename2 = md5(time());
											$config2 = array(
													'upload_path'   => './../../files/anexos/',
													'overwrite'     => TRUE,
													'file_name'     => $filename2,
													'allowed_types' => 'doc|docx|pdf|txt|xlsx|xls|png|jpg|jpeg',
													'max_size'      => '10000'
											);

											$this->upload->initialize($config2);
											
											if ( ! $this->upload->do_upload('anexo2'))
											{

												echo json_encode(array('status' => 'error','content' => $this->upload->display_errors()));
												exit;
											}
											else 
											{
												$data = $this->upload->data();
												$params['cal_anexo2_path'] = $data['file_name'];
												$params['cal_anexo2_nombre'] = $nombre_anexo;
												$data_serv['serv_anexo2_path'] = $data['file_name'];
												$data_serv['serv_anexo2_nombre'] = $nombre_anexo;
											}
										}
						/***********************************************************/	
						/******NUEVOS ARCHIVO ANEXO 3 ******************************/
										if(!empty($_FILES['anexo3']['name']))
										{
											$nombre_anexo=$_FILES['anexo3']['name'];
											$this->load->library('upload');
											
											sleep(1);
											$filename3 = md5(time());
											$config3 = array(
													'upload_path'   => './../../files/anexos/',
													'overwrite'     => TRUE,
													'file_name'     => $filename3,
													'allowed_types' => 'doc|docx|pdf|txt|xlsx|xls|png|jpg|jpeg',
													'max_size'      => '10000'
											);

											$this->upload->initialize($config3);
											
											if ( ! $this->upload->do_upload('anexo3'))
											{

												echo json_encode(array('status' => 'error','content' => $this->upload->display_errors()));
												exit;
											}
											else 
											{
												$data = $this->upload->data();
												$params['cal_anexo3_path'] = $data['file_name'];
												$params['cal_anexo3_nombre'] = $nombre_anexo;
												$data_serv['serv_anexo3_path'] = $data['file_name'];
												$data_serv['serv_anexo3_nombre'] = $nombre_anexo;
												
											}
										}
						/***********************************************************/	
						/******NUEVOS ARCHIVO ANEXO 4 ******************************/
										if(!empty($_FILES['anexo4']['name']))
										{
											$nombre_anexo=$_FILES['anexo4']['name'];
											$this->load->library('upload');
											
											sleep(1);
											$filename4 = md5(time());
											$config = array(
													'upload_path'   => './../../files/anexos/',
													'overwrite'     => TRUE,
													'file_name'     => $filename4,
													'allowed_types' => 'doc|docx|pdf|txt|xlsx|xls|png|jpg|jpeg',
													'max_size'      => '10000'
											);

											$this->upload->initialize($config);
											
											if ( ! $this->upload->do_upload('anexo4'))
											{

												echo json_encode(array('status' => 'error','content' => $this->upload->display_errors()));
												exit;
											}
											else 
											{
												$data = $this->upload->data();
												$params['cal_anexo4_path'] = $data['file_name'];
												$params['cal_anexo4_nombre'] = $nombre_anexo;
												$data_serv['serv_anexo4_path'] = $data['file_name'];
												$data_serv['serv_anexo4_nombre'] = $nombre_anexo;
											}
										}

		/****************** Estructura para generar Orden de Servicio*****************************************/
		 
						$params['cei_control_id'] = $this->input->post('cei_control');
						$data_serv['cei_control_id'] = $this->input->post('cei_control');
						
						if (($user['emp_id'] == 31) &&  (strlen($this->input->post('serv_orden')) > 0))
						{					
							$params['serv_orden'] = $this->input->post('serv_orden');
							$data_serv['serv_orden'] =$this->input->post('serv_orden');
						}
						else
						{	
							$f = new DateTime();
							
							if (get_emp_osa($emp_id) == 3)
							{
								$ff= $emp_id.'_'.strtoupper(trim($this->input->post('nombre1')).'_'.trim($this->input->post('paterno1')).'_'.trim($this->input->post('materno1'))).'_'.$f->getTimestamp();
							}						
							elseif ($user['emp_id'] == 321)
							{
								$ff= 'PROV_'.$this->input->post('zona_securitas').'_'.$f->getTimestamp();
							}						
							else
							{	
								$ff= 'PROVISIONAL_'. $f->getTimestamp();			
							}
							
							$params['serv_orden']= $ff;
							$data_serv['serv_orden'] = $ff;
						}	
						

						if (!(valida_corporacion($emp_id,'GSI') === 'GSI') || ($emp_id !=31) )
						{	
							$data_serv['emp_id'] =  $emp_id;
							$data_serv['usr_id'] = $user['usr_id'];
							$data_serv['serv_f_inicio'] = $fecha_ini;
							$data_serv['serv_f_fin'] = $fecha_fin;
							$data_serv['serv_desc'] = $this->input->post('observaciones');
							$data_serv['serv_ubicacion'] =   $this->input->post('lugar');
							$data_serv['serv_estatus_cve'] = 'PROCESO';
							$data_serv['cei_id'] = $user['cei_id'];

						}
		/***********************************************************/
						if  (
								($params['emp_id'] > 0) && 
								($detecta_pkts > 0) &&
								(strlen($params['cal_viaticos']) == 2) /*control de viaticos*/
							)
						{	
							//SE CREA EVENTO DE LA AGENDA						
							$cal_id = $this->agenda->add_evento_folio(array_to_upper($params));
							
							$serv_id=0;
							
							//para evitar que se genere orden de servicio
							  if (get_emp_osa($emp_id) != 1)
								/*if 	( 	
										!(valida_corporacion($emp_id,'SERVISEG') === 'SERVISEG') &&  
										!(valida_corporacion($emp_id,'GSI') === 'GSI') &&  
										($emp_id != 290) &&
										($emp_id != 353) &&
										($emp_id != 302) &&
										($emp_id != 298) && 
										($emp_id != 152) && 
										($emp_id != 193) && 
										($emp_id  != 230) &&
										($emp_id  != 311) &&
										($emp_id != 31) &&
										($emp_id != 37) &&
										($emp_id != 213) &&
										($emp_id != 253) && //SWOBODA
										($emp_id != 346) && //genesis
										($emp_id != 321) &&
										($emp_id != 69) && //confiar
										($emp_id != 360)
									)*/
								{
									//el evento se le da al servicio
									$data_serv['cal_folio'] = $cal_id;
									$data_serv['cal_id'] = $cal_id;
									
									//el servicio se crea
									$serv_id = $this->servicio->inserta(array_to_upper($data_serv));			
									$serv_id_152=$serv_id ; 

									
									//costos para el servicio creado edita b
									$total_examenes_selectos= $this->input->post('total_examenes_selectos');	
									$fsm_pakts= get_costos_paquetes_empresa($emp_id);
									if($fsm_pakts):
										foreach($fsm_pakts as $fsm_pakt): 
													
												for($i=1; $i <= $total_examenes_selectos; $i++)
												{									
													$indice='examen_select_pkt_'.strval($i);
													$paquetes= $this->input->post($indice);	
															
													if ( $fsm_pakt['cost_nombre_pkt'] === $paquetes)
													{
														$examen_ins['exam_nombre_pkt'] = $fsm_pakt['cost_nombre_pkt']; //nombre del paquete
														$examen_ins['serv_id'] = $serv_id;
														$examen_ins['exam_cve'] = $fsm_pakt['cost_examen_cve']; //lo que contiene el paquete
														$examen_ins['exam_monto'] = $fsm_pakt['cost_monto']; //lo que se cobra del paquete								 	 
														$examen_ins['exam_cantidad'] = 1;
														$examen_ins['exam_estatus_cve'] = 'PEND';
														$examen_ins['exam_tipo_pkt'] = $fsm_pakt['cost_tipo_pkt'];
														$this->servicio->inserta_examen($examen_ins);
													}							
												}	
										endforeach;
									endif;	
								}

								if (($emp_id == 298) ||  ($emp_id == 152) ||  ($emp_id  == 193) ||  ($emp_id  == 210) || ($emp_id  == 230) || ($emp_id  == 311) || ($emp_id  == 142) || (get_emp_osa($emp_id) == 3) )
								{						
									//se extraen examenes de los paquetes para evaluados de seguros
									$nomserv='';
									
									$cat_examen = get_cat_nombre_var('EXAMEN');		
									$cat_categorias = get_cat_nombre_var('CATEGORIA_EX');
									foreach($cat_categorias as $categoria): 
										$linea_examenes=get_examen_de_empresa_por_categoria($emp_id, $categoria['cat_nombre']);
										
										if (strlen($linea_examenes) > 0)
										{
											foreach (explode(';', $linea_examenes) as $det):
												if (strlen($det) > 0)
												{
														$exa=$det.';';
														$nomserv.=$exa;											
												}
											endforeach;										
										}
									endforeach;					
							
									$data_clte['nomserv'] =  $nomserv;	

									//evaluados de seguros

										$j=1;
										for($i=1; $i <= 4; $i++)
										{	
											if 	(
												(strlen($this->input->post('nombre'.strval($i)))>0) &&
												(strlen($this->input->post('paterno'.strval($i)))>0)
												)
												
											{
											//informncion general de evaluado
											$data_clte['clte_nombre_crypt'] =  trim($this->input->post('nombre'.strval($i)));
											$data_clte['clte_2_nombre_crypt'] =  trim($this->input->post('nombre_adic'.strval($i)));
											$data_clte['clte_paterno_crypt'] =  trim($this->input->post('paterno'.strval($i)));
											$data_clte['clte_materno_crypt'] =  trim($this->input->post('materno'.strval($i)));
											$data_clte['clte_f_nac'] = formatea_fecha_mysql($this->input->post('fnac'.strval($i)));
											$data_clte['clte_genero_cve'] =  $this->input->post('genero'.strval($i));                				
											

											$data_clte['clte_rfc_crypt']=substr($data_clte['clte_paterno_crypt'],0,2).substr($data_clte['clte_materno_crypt'],0,1).substr($data_clte['clte_nombre_crypt'],0,1).substr($data_clte['clte_f_nac'],2,2).substr($data_clte['clte_f_nac'],5,2).substr($data_clte['clte_f_nac'],8,2);

											$data_clte['serv_id'] =  $this->input->post('serv_id');
											
											
											
											if ($emp_id == 152)
											{
												if ($j== 1)
												{	
													$data_clte['clte_webflow'] =  $this->input->post('webflow1');
												}
												elseif ($j== 2)
												{
													$data_clte['clte_webflow'] =  $this->input->post('webflow2');
												}
												elseif ($j== 3)
												{
													$data_clte['clte_webflow'] =  $this->input->post('webflow3');
												}
												else
												{
													$data_clte['clte_webflow'] =  $this->input->post('webflow4');
												}
												
												
												if ($this->input->post('region1') !='')
												{	
													$data_clte['clte_region'] =  $this->input->post('region1');
												}
												elseif ($this->input->post('region2') !='')
												{	
													$data_clte['clte_region'] =  $this->input->post('region2');
												}
												elseif ($this->input->post('region3') !='')
												{	
													$data_clte['clte_region'] =  $this->input->post('region3');
												}
												elseif ($this->input->post('region4') !='')
												{	
													$data_clte['clte_region'] =  $this->input->post('region4');
												}
												elseif ($this->input->post('region5') !='')
												{	
													$data_clte['clte_region'] =  $this->input->post('region5');
												}
											
												
												$data_clte['clte_zona'] = $this->input->post('zona');
												
												
												
												$cal_lugar_det= $this->input->post('lugar_det');
												
												/*
												$zonificacion='ZONA 0';												
												if ($cal_lugar_det !=0 )
												{
													$zonificacion='ZONA 1';
												}	
												else
												{
													$cp_codigo=$this->input->post('cp');
													
													$this->db->select('*');
													$this->db->from('cat_dir_cp');
													$this->db->like('cp_codigo',$cp_codigo);
													$this->db->limit(1); 
													$zona=$this->db->get()->row_array();
													
														if (
															($zona['cp_ciudad'] == 'QUERÉTARO') ||
															($zona['cp_ciudad'] == 'CIUDAD DE MÉXICO') ||
															($zona['estado'] == 'MÉXICO') || 
															($zona['estado'] == 'QUERÉTARO') || 
															($zona['cp_ciudad'] == 'MONTERREY')
														   )
														{
															$zonificacion='ZONA 2';
														}
														elseif (
															($zona['cp_ciudad'] == 'PUEBLA (HEROICA PUEBLA)') ||
															($zona['cp_ciudad'] == 'CUERNAVACA') ||
															($zona['estado'] == 'HIDALGO') || 
															($zona['estado'] == 'PUEBLA') ||												
															($zona['estado'] == 'TLAXCALA') ||
															($zona['estado'] == 'GUANAJUATO') ||
															($zona['cp_ciudad'] == 'TLAXCALA (TLAXCALA DE XICOTENCATL)') ||
															($zona['cp_ciudad'] == 'CELAYA') ||
															($zona['cp_ciudad'] == 'IRAPUATO')
														   )
														{
															$zonificacion='ZONA 3';
														}
														elseif (
															($zona['cp_ciudad'] == 'LEÓN DE LOS ALDAMA') ||
															($zona['cp_ciudad'] == 'SAN LUIS POTOSÍ') ||
															($zona['estado'] == 'SAN LUIS POTOSÍ') ||
															($zona['cp_ciudad'] == 'TORREÓN')
														   )
														{
															$zonificacion='ZONA 4';
														}
														else	
														{
															$zonificacion='ZONA 5'; 
														}					
														
												}											
												$data_clte['clte_zona'] = $zonificacion;
												*/
											}	
				
											if ($emp_id == 311)
											{
												if ($cal_lugar_det !=0 )
												{
													$zonificacion='ZONA 01';
												}	
												else
												{
													$cp_codigo=$this->input->post('cp');
													
													$this->db->select('*');
													$this->db->from('cat_dir_cp');
													$this->db->like('cp_codigo',$cp_codigo);
													$this->db->limit(1); 
													$zona=$this->db->get()->row_array();
													
														if (
															($zona['cp_ciudad'] == 'QUERÉTARO') ||
															($zona['cp_ciudad'] == 'CIUDAD DE MÉXICO') ||
															($zona['cp_ciudad'] == 'MONTERREY')
														   )
														{
															$zonificacion='ZONA 01';
														}
														elseif (
															($zona['cp_ciudad'] == 'PUEBLA (HEROICA PUEBLA)') ||
															($zona['cp_ciudad'] == 'CUERNAVACA') ||
															($zona['cp_ciudad'] == 'LEÓN DE LOS ALDAMA') ||
															($zona['cp_ciudad'] == 'GUADALAJARA') ||
															($zona['cp_ciudad'] == 'AGUASCALIENTES')
														   )
														{
															$zonificacion='ZONA 02';
														}
														else	
														{
															$zonificacion='ZONA 03'; 
														}					
														
												}
												$data_clte['clte_zona'] = $zonificacion;
											}

				

											$data_clte['clte_env_pais_cve'] =  $this->input->post('pais');
											$data_clte['clte_env_cp'] =  $this->input->post('cp');
											$data_clte['clte_env_edo_cve'] =  $this->input->post('entidad');
											$data_clte['clte_env_colonia_crypt'] =  $this->input->post('colonia');
											$data_clte['clte_env_localidad'] =  $this->input->post('localidad');
											$data_clte['clte_env_municipio'] =  $this->input->post('municipio');
											$data_clte['clte_env_calle_crypt'] =  $this->input->post('calle');
											$data_clte['clte_env_num_ext_crypt'] =  $this->input->post('next');
											$data_clte['clte_env_num_int_crypt'] =  $this->input->post('nint');														
											$data_clte['clte_edo_civ_cve'] =  $this->input->post('civil'.strval($i));											
											$data_clte['log_insrt_f'] =  date('Y-m-d H:i:s'); 
											$data_clte['log_updt_f'] =  date('Y-m-d H:i:s'); 
											//empresa donde va a loborar la persona
											$data_clte['emp_id'] =  $emp_id;  
											$data_clte['cei_id'] =  $this->input->post('cei_control');
											
											if ($emp_id == 298)
											{
												$data_clte['nomserv'] =  'BX+';
											}
											elseif (($emp_id == 152) || ($emp_id == $control_empresa_osa_3))
											{
												foreach (explode(';', $params['cal_pkts']) as $pkt_examen):
													if (strlen($pkt_examen) > 0)
													{	//$nomserv_serguros.=$pkt_examen.';';
														$nomserv_serguros.=get_cve_exam_per_pakts_by_empresa($emp_id,$pkt_examen);
													}
												endforeach;	
												$data_clte['nomserv'] =  $nomserv_serguros;   
												if (get_emp_osa($emp_id ) == 3)
												{	
													$data_clte['serv_id'] =  $serv_id_152;
												}	
												else
												{	
													$data_clte['serv_id'] =  $this->input->post('serv_orden');
												}
											}
											elseif ($emp_id  == 193)
											{
												$data_clte['nomserv'] =  'ALLIANZ';
												
											}
											elseif ($emp_id  == 142)
											{
												foreach (explode(';', $params['cal_pkts']) as $pkt_examen):
													if (strlen($pkt_examen) > 0)
													{	//$nomserv_serguros.=$pkt_examen.';';
														$nomserv_serguros.=get_cve_exam_per_pakts_by_empresa($emp_id,$pkt_examen);
													}
												endforeach;	
												$data_clte['nomserv'] =  $nomserv_serguros;
												$data_clte['serv_id'] = $serv_id; 
												//$data_clte['serv_id'] =  $this->input->post('serv_orden');
											}
											elseif ($emp_id  == 210)
											{
												$data_clte['nomserv'] = $examen_ins['exam_cve'];// 'INSIGNIA';
												$data_clte['suc_id'] = $usuario['suc_id']; /*insignia*/
												$data_clte['serv_id'] = $serv_id; 
											}
											elseif ($emp_id  == 230)
											{
												foreach (explode(';', $params['cal_pkts']) as $pkt_examen):
													if (strlen($pkt_examen) > 0)
													{	//$nomserv_serguros.=$pkt_examen.';';
														$nomserv_serguros.=get_cve_exam_per_pakts_by_empresa($emp_id,$pkt_examen);
													}
												endforeach;	
												$data_clte['nomserv'] =  $nomserv_serguros.'AXA';
												$data_clte['serv_id'] =  $this->input->post('serv_orden');
											}
											elseif ($emp_id  == 211)
											{
												foreach (explode(';', $params['cal_pkts']) as $pkt_examen):
													if (strlen($pkt_examen) > 0)
													{	//$nomserv_serguros.=$pkt_examen.';';
														$nomserv_serguros.=get_cve_exam_per_pakts_by_empresa($emp_id,$pkt_examen);
													}
												endforeach;	
												$data_clte['nomserv'] =  $nomserv_serguros;
												$data_clte['serv_id'] =  $this->input->post('serv_orden');
											}
											elseif ($emp_id  == 311)
											{
												foreach (explode(';', $params['cal_pkts']) as $pkt_examen):
													if (strlen($pkt_examen) > 0)
													{	//$nomserv_serguros.=$pkt_examen.';';
														$nomserv_serguros.=get_cve_exam_per_pakts_by_empresa($emp_id,$pkt_examen);
													}
												endforeach;	
												$data_clte['nomserv'] =  $nomserv_serguros;
												$data_clte['serv_id'] =  $this->input->post('serv_orden');
											}
											/*********************************************
											validar que el evaluado no este rregistrado
											********************************************/
												
											$data_clte= array_to_upper($data_clte);
												
											$cliente_encontrado = $this->cliente->busca_asegurado($data_clte['clte_nombre_crypt'],
																			$data_clte['clte_2_nombre_crypt'],
																			$data_clte['clte_paterno_crypt'],
																			$data_clte['clte_materno_crypt'],
																			$data_clte['emp_id']);
											
											if ($cliente_encontrado)
											{
												$data_x['clte_zona']=$this->input->post('zona_insignia'); 
												$data_x['clte_env_pais_cve']=$data_clte['clte_env_pais_cve'];
												$data_x['clte_env_cp']=$data_clte['clte_env_cp'];
												$data_x['clte_env_edo_cve']=$data_clte['clte_env_edo_cve'];
												$data_x['clte_env_colonia_crypt']=$data_clte['clte_env_colonia_crypt'];
												$data_x['clte_env_localidad']=$data_clte['clte_env_localidad'];
												$data_x['clte_env_municipio']=$data_clte['clte_env_municipio'];
												$data_x['clte_env_calle_crypt']=$data_clte['clte_env_calle_crypt'];
												$data_x['clte_env_num_ext_crypt']=$data_clte['clte_env_num_ext_crypt'];
												$data_x['clte_env_num_int_crypt']=$data_clte['clte_env_num_int_crypt'];
												$data_x['clte_webflow']=$data_clte['clte_webflow'];
												$data_x['serv_id']=$data_clte['serv_id'];
												$data_x['clte_region']=$data_clte['clte_region'];
												$data_x['nomserv']=$data_clte['nomserv'];
												
												$this->cliente->actualiza_registro_sin_log($cliente_encontrado['clte_id'],array_to_upper($data_x));
											}
											else
											{	
												$cliente_id = $this->cliente->inserta(array_to_upper($data_clte));
											}
											
											
											$param['eva'.strval($j)]=$cliente_id;
											$j++;
											
											}					
										}
								}
							
								if ((get_empresas_giro($emp_id ,'SEGUROS')))
								{	
									
									if ($emp_id == 298)
									{
										$param['cal_titulo']= 'BX+ - ';
									}
									elseif ($emp_id == 152)
									{
										$param['cal_titulo']= 'SMTY - ';
									}
									elseif ($emp_id == 193)
									{
										$param['cal_titulo']= 'ALLIANZ - ';
									}
									elseif ($emp_id == 230)
									{
										$param['cal_titulo']= 'AXA - ';
									}
									elseif ($emp_id == 311)
									{
										$param['cal_titulo']= 'GNP - ';
									}
									elseif ($emp_id == 142)
									{
										$param['cal_titulo']= 'GENERAL DE SEGUROS - ';
									}						
									else
									{
										$param['cal_titulo']= get_empresida($emp_id).' - ';
									}	
									
									$eva0=strtoupper(trim($this->input->post('nombre1')).' '.trim($this->input->post('paterno1')).' '.trim($this->input->post('materno1')));
									$param['cal_titulo'].=$eva0;
									
									
									if (strlen($this->input->post('nombre2')) > 0) 
										{
											$eva0=chr(10).strtoupper(trim($this->input->post('nombre2')).' '.trim($this->input->post('paterno2')).' '.trim($this->input->post('materno2')));
											$param['cal_titulo'].=$eva0; 
										}	
									
									if (strlen($this->input->post('nombre3')) > 0) 
										{
											$eva0=chr(10).strtoupper(trim($this->input->post('nombre3')).' '.trim($this->input->post('paterno3')).' '.trim($this->input->post('materno3')));
											$param['cal_titulo'].=$eva0; 
										}	
									
									if (strlen($this->input->post('nombre4')) > 0) 
										{
											$eva0=chr(10).strtoupper(trim($this->input->post('nombre4')).' '.trim($this->input->post('paterno4')).' '.trim($this->input->post('materno4')));
											$param['cal_titulo'].=$eva0; 
										}						
									
									$param['cal_titulo'].=' ** '.get_options_per_grupo('HC_SEGUROS', $params['hc1']);		
									
								}
								elseif (($emp_id == 210) /*|| ($emp_id == 193)*/ )
								{	
								
									$param['cal_titulo']= get_empresa($params['emp_id']).' ';
									$eva0=strtoupper(trim($this->input->post('nombre1')).' '.trim($this->input->post('paterno1')).' '.trim($this->input->post('materno1')));
									$param['cal_titulo'].=$eva0;
									
									
									if (strlen($this->input->post('nombre2')) > 0) 
										{
											$eva0=chr(10).strtoupper(trim($this->input->post('nombre2')).' '.trim($this->input->post('paterno2')).' '.trim($this->input->post('materno2')));
											$param['cal_titulo'].=$eva0; 
										}	
									
									if (strlen($this->input->post('nombre3')) > 0) 
										{
											$eva0=chr(10).strtoupper(trim($this->input->post('nombre3')).' '.trim($this->input->post('paterno3')).' '.trim($this->input->post('materno3')));
											$param['cal_titulo'].=$eva0; 
										}	
									
									if (strlen($this->input->post('nombre4')) > 0) 
										{
											$eva0=chr(10).strtoupper(trim($this->input->post('nombre4')).' '.trim($this->input->post('paterno4')).' '.trim($this->input->post('materno4')));
											$param['cal_titulo'].=$eva0; 
										}						
									
									$param['cal_titulo'].=' ** '.get_options_per_grupo('HC_SEGUROS', $params['hc1']);		
									
								}
								else
								{	if ($serv_id == 0 )
									{
										$param['cal_titulo']= get_empresa($params['emp_id']).', IDA:'.$cal_id; 
									}
									else
									{
										$param['cal_titulo']= get_empresa($params['emp_id']).', OS:'.$serv_id.', IDA:'.$cal_id; 
									}
								}					

												
								$param['serv_id']=$serv_id;
								$this->agenda->update_evento($cal_id,$param);	
							}
							elseif  ($emp_id == 210) /* PROCESA Insignia Life*/
							{	
								$error_archivo_servcios=0;
								if(!empty($_FILES['paquete']['name']))
								{
									$nombre_anexo_p=$_FILES['paquete']['name'];
									$this->load->library('upload');
									
									sleep(1);

									$filename1 ='insignia_'.date(dmYHis).'_'.rand(1,99);//.md5(time());
									$config = array(
											'upload_path'   => './../../files/anexos/',
											'overwrite'     => TRUE,
											'file_name'     => $filename1,
											'allowed_types' => 'doc|docx|pdf|txt|xlsx|xls|png|jpg|jpeg',
											'max_size'      => '10000'
									);

									$this->upload->initialize($config);
									
									if ( ! $this->upload->do_upload('paquete'))
									{
										  echo json_encode(array('status' => 'error','content' => $this->upload->display_errors()));
										exit;
									}
									else /*HAY QUE ACTUALIZAR*/
									{
										$data_p = $this->upload->data();
										$params['cal_arch_serv_path'] = $data_p['file_name'];
										$params['cal_arch_serv_nombre'] = $nombre_anexo_p;
										$data_serv['serv_arch_serv_path'] = $data_p['file_name'];
										$data_serv['serv_arch_serv_nombre '] = $nombre_anexo_p;
									}
								}
								else
								{
									$error_archivo_servcios=1;
								}					
						
							if  (
								(($this->input->post('nombre2'))	== '') &&				
								(($this->input->post('paterno2')) == '') &&
								(($this->input->post('materno2')) == '') &&
								(($this->input->post('webflow2')) == '')
								)
								{
									$error_evaluado2=0;
								}
								elseif  (
										(($this->input->post('nombre2'))	!= '') &&				
										(($this->input->post('paterno2')) != '') &&
										(($this->input->post('materno2')) != '') &&
										(($this->input->post('webflow2')) != '')
										)
										{
											$error_evaluado2=0;
										}
										else { $error_evaluado2=1;}
										
							if  (
								(($this->input->post('nombre3'))	== '') &&				
								(($this->input->post('paterno3')) == '') &&
								(($this->input->post('materno3')) == '') &&
								(($this->input->post('webflow3')) == '')
								)
								{
									$error_evaluado3=0;
								}
								elseif  (
										(($this->input->post('nombre3'))	!= '') &&				
										(($this->input->post('paterno3')) != '') &&
										(($this->input->post('materno3')) != '') &&
										(($this->input->post('webflow3')) != '')
										)
										{
											$error_evaluado3=0;
										}
										else { $error_evaluado3=1;}

							if  (
								(($this->input->post('nombre4'))	== '') &&				
								(($this->input->post('paterno4')) == '') &&
								(($this->input->post('materno4')) == '') &&
								(($this->input->post('webflow4')) == '')
								)
								{
									$error_evaluado4=0;
								}
								elseif  (
										(($this->input->post('nombre4'))	!= '') &&				
										(($this->input->post('paterno4')) != '') &&
										(($this->input->post('materno4')) != '') &&
										(($this->input->post('webflow4')) != '')
										)
										{
											$error_evaluado4=0;
										}
										else { $error_evaluado4=1;}


						
							if  ( ($error_archivo_servcios == 0) && 
								  ($error_evaluado2 == 0) &&
								  ($error_evaluado3 == 0) &&
								  ($error_evaluado4 == 0) 
								)
							{
								$detecta_pkts = 1;
								$params['cal_viaticos'] = 'NO';
								//se crea evento en agenda
								$params=array_to_upper($params);
								$params['cal_arch_serv_path'] = $data_p['file_name'];
								$params['cal_arch_serv_nombre'] = $nombre_anexo_p;
								$cal_id = $this->agenda->add_evento_folio($params);
								$serv_id=0;
								
								//solo empresas que generaran orden de servicio	
									if ( 	
											!(valida_corporacion($emp_id,'SERVISEG') === 'SERVISEG') &&  
											!(valida_corporacion($emp_id,'GSI') === 'GSI') &&  
											($emp_id != 290) &&
											($emp_id != 353) &&
											($emp_id != 302) &&
											($emp_id != 298) && 
											($emp_id != 152) && 
											($emp_id != 193) && 
											($emp_id != 230) &&
											($emp_id != 311) &&
											($emp_id != 31) &&
											($emp_id != 37) &&
											($emp_id != 213) &&
											($emp_id != 253) && /*SWOBODA*/
											($emp_id != 346) && /*genesis*/
											($emp_id != 321) 
								
										)
									{
										//el evento se le da al servicio
										$data_serv['cal_folio'] = $cal_id;
										$data_serv['cal_id'] = $cal_id;
										
										//el servicio se crea
										$serv_id = $this->servicio->inserta(array_to_upper($data_serv));			

									}

								if (($emp_id == 298) ||  ($emp_id == 152) ||  ($emp_id  == 193) ||  ($emp_id  == 210) || ($emp_id  == 230) || ($emp_id  == 311) || ($emp_id  == 142) )
								{						
									//se extraen examenes de los paquetes para evaluados de seguros
									$nomserv='';
									
							
									$data_clte['nomserv'] =  $nomserv;	

									//evaluados de seguros

										$j=1;
										for($i=1; $i <= 4; $i++)
										{	
											if 	(
												(strlen($this->input->post('nombre'.strval($i)))>0) &&
												(strlen($this->input->post('paterno'.strval($i)))>0)
												)
												
											{
											//informncion general de evaluado
											$data_clte['clte_nombre_crypt'] =  trim($this->input->post('nombre'.strval($i)));
											$data_clte['clte_2_nombre_crypt'] =  trim($this->input->post('nombre_adic'.strval($i)));
											$data_clte['clte_paterno_crypt'] =  trim($this->input->post('paterno'.strval($i)));
											$data_clte['clte_materno_crypt'] =  trim($this->input->post('materno'.strval($i)));
											$data_clte['clte_f_nac'] = formatea_fecha_mysql($this->input->post('fnac'.strval($i)));
											$data_clte['clte_genero_cve'] =  $this->input->post('genero'.strval($i));                				
											

											$data_clte['clte_rfc_crypt']=substr($data_clte['clte_paterno_crypt'],0,2).substr($data_clte['clte_materno_crypt'],0,1).substr($data_clte['clte_nombre_crypt'],0,1).substr($data_clte['clte_f_nac'],2,2).substr($data_clte['clte_f_nac'],5,2).substr($data_clte['clte_f_nac'],8,2);

											$data_clte['serv_id'] =  $this->input->post('serv_id');
											
											if ($emp_id == 210)
											{
												if ($j== 1)
												{	
													$data_clte['clte_webflow'] =  $this->input->post('webflow1');
												}
												elseif ($j== 2)
												{
													$data_clte['clte_webflow'] =  $this->input->post('webflow2');
												}
												elseif ($j== 3)
												{
													$data_clte['clte_webflow'] =  $this->input->post('webflow3');
												}
												else
												{
													$data_clte['clte_webflow'] =  $this->input->post('webflow4');
												}
												
												$data_clte['clte_region'] =  $this->input->post('region');									
												$cal_lugar_det= $this->input->post('lugar_det');
												
												$cp_codigo=$this->input->post('cp');
												
												$this->db->select('*');
												$this->db->from('cat_dir_cp');
												$this->db->like('cp_codigo',$cp_codigo);
												$this->db->limit(1); 
												$zona=$this->db->get()->row_array();
													
												if (
													($zona['cp_ciudad'] == 'QUERÉTARO') ||
													($zona['cp_ciudad'] == 'CIUDAD DE MÉXICO') ||												
													($zona['estado'] == 'QUERÉTARO') || 
													($zona['cp_ciudad'] == 'MONTERREY')
												   )
												{
													$zonificacion='ZONA 1';
												}
												elseif (
													($zona['cp_ciudad'] == 'PUEBLA (HEROICA PUEBLA)') ||
													($zona['cp_ciudad'] == 'CUERNAVACA') ||
													($zona['cp_ciudad'] == 'LEÓN DE LOS ALDAMA') ||												
													($zona['cp_ciudad'] == 'GUADALAJARA') ||
													($zona['cp_ciudad'] == 'AGUASCALIENTES') ||
													($zona['cp_ciudad'] == 'CANCÚN') ||
													($zona['cp_ciudad'] == 'VILLAHERMOSA') ||
													($zona['estado'] == 'JALISCO') ||  
													($zona['estado'] == 'MÉXICO')  
												   )
												{
													$zonificacion='ZONA 2';
												}
												else	
												{
													$zonificacion='ZONA 3'; 
												}					
														
											}								

											$data_clte['clte_zona'] = $zonificacion;
											$data_clte['clte_status_proc'] = 'AGENDADO';
				

											$data_clte['clte_env_pais_cve'] =  $this->input->post('pais');
											$data_clte['clte_env_cp'] =  $this->input->post('cp');
											$data_clte['clte_env_edo_cve'] =  $this->input->post('entidad');
											$data_clte['clte_env_colonia_crypt'] =  $this->input->post('colonia');
											$data_clte['clte_env_localidad'] =  $this->input->post('localidad');
											$data_clte['clte_env_municipio'] =  $this->input->post('municipio');
											$data_clte['clte_env_calle_crypt'] =  $this->input->post('calle');
											$data_clte['clte_env_num_ext_crypt'] =  $this->input->post('next');
											$data_clte['clte_env_num_int_crypt'] =  $this->input->post('nint');
											
															
											$data_clte['clte_edo_civ_cve'] =  $this->input->post('civil'.strval($i));
											
											$data_clte['emp_id'] =  $emp_id;  
											$data_clte['cei_id'] =  $this->input->post('cei_control');
											$data_clte['clte_f_nac'] =  date('Y-m-d');
											
											if ($emp_id  == 210)
											{
												$data_clte['nomserv'] = $examen_ins['exam_cve'].'INSIGEXMED;TOMAM;';// 'INSIGNIA';
												$data_clte['suc_id'] = $usuario['suc_id']; /*insignia*/
												$data_clte['serv_id'] = $serv_id; 
											}
											
											/*********************************************
											validar que el evaluado no este rregistrado
											********************************************/
												
											$data_clte= array_to_upper($data_clte);										
											$cliente_encontrado=0;
											
											if ($cliente_encontrado)
											{
												
												$data_x['clte_env_pais_cve']=$data_clte['clte_env_pais_cve'];
												$data_x['clte_env_cp']=$data_clte['clte_env_cp'];
												$data_x['clte_env_edo_cve']=$data_clte['clte_env_edo_cve'];
												$data_x['clte_env_colonia_crypt']=$data_clte['clte_env_colonia_crypt'];
												$data_x['clte_env_localidad']=$data_clte['clte_env_localidad'];
												$data_x['clte_env_municipio']=$data_clte['clte_env_municipio'];
												$data_x['clte_env_calle_crypt']=$data_clte['clte_env_calle_crypt'];
												$data_x['clte_env_num_ext_crypt']=$data_clte['clte_env_num_ext_crypt'];
												$data_x['clte_env_num_int_crypt']=$data_clte['clte_env_num_int_crypt'];
												$data_x['clte_webflow']=$data_clte['clte_webflow'];
												$data_x['clte_zona'] = $zonificacion;
												$data_x['serv_id']=$data_clte['serv_id'];
												$data_x['clte_region']=$data_clte['clte_region'];
												$data_x['nomserv']=$data_clte['nomserv'];
												
												$this->cliente->actualiza_registro_sin_log($cliente_encontrado['clte_id'],array_to_upper($data_x));
											}
											else
											{	
												$cliente_id = $this->cliente->inserta(array_to_upper($data_clte));
												
												$data_archivero_elect['clte_id'] =  $cliente_id;
												$data_archivero_elect['doc_nombre'] =  'ODT';
												$data_archivero_elect['doc_f'] =  date('Y-m-d H:i:s');
												$data_archivero_elect['serv_id'] =  $data_clte['serv_id'];
												$data_archivero_elect['doc_path'] = $data_p['file_name'];
												$data_archivero_elect['doc_type'] = 'SEGUROS';
												$this->cliente->add_doc(array_to_upper($data_archivero_elect));

												if ($data_serv['serv_anexo_nombre'])
												{	
													$data_archivero_elect['doc_nombre'] =  $data_serv['serv_anexo_nombre'];
													$data_archivero_elect['serv_id'] =  $data_clte['serv_id'];
													$data_archivero_elect['doc_path'] = $data_serv['serv_anexo_path'];
													$this->cliente->add_doc(array_to_upper($data_archivero_elect));
												}
											}
											
											$param['eva'.strval($j)]=$cliente_id;
											$j++;
											
											}					
										}
								}
								
								//el titulo del servicio y evento se actualiza segun empresa 
								if ((get_empresas_giro($emp_id ,'SEGUROS')))
								{	
									
									if ($emp_id == 298)
									{
										$param['cal_titulo']= 'BX+ - ';
									}
									elseif ($emp_id == 152)
									{
										$param['cal_titulo']= 'SMTY - ';
									}
									elseif ($emp_id == 193)
									{
										$param['cal_titulo']= 'ALLIANZ - ';
									}
									elseif ($emp_id == 230)
									{
										$param['cal_titulo']= 'AXA - ';
									}
									elseif ($emp_id == 311)
									{
										$param['cal_titulo']= 'GNP - ';
									}
									elseif ($emp_id == 142)
									{
										$param['cal_titulo']= 'GENERAL DE SEGUROS - ';
									}						
									else
									{
										$param['cal_titulo']= 'INSIGNIA LIFE - ';
									}	
									
									$eva0=strtoupper(trim($this->input->post('nombre1')).' '.trim($this->input->post('paterno1')).' '.trim($this->input->post('materno1')));
									$param['cal_titulo'].=$eva0;
									
									
									if (strlen($this->input->post('nombre2')) > 0) 
										{
											$eva0=chr(10).strtoupper(trim($this->input->post('nombre2')).' '.trim($this->input->post('paterno2')).' '.trim($this->input->post('materno2')));
											$param['cal_titulo'].=$eva0; 
										}	
									
									if (strlen($this->input->post('nombre3')) > 0) 
										{
											$eva0=chr(10).strtoupper(trim($this->input->post('nombre3')).' '.trim($this->input->post('paterno3')).' '.trim($this->input->post('materno3')));
											$param['cal_titulo'].=$eva0; 
										}	
									
									if (strlen($this->input->post('nombre4')) > 0) 
										{
											$eva0=chr(10).strtoupper(trim($this->input->post('nombre4')).' '.trim($this->input->post('paterno4')).' '.trim($this->input->post('materno4')));
											$param['cal_titulo'].=$eva0; 
										}						
									
									$param['cal_titulo'].=' ** '.get_options_per_grupo('HC_SEGUROS', $params['hc1']);		
									
								}
								elseif (($emp_id == 210) /*|| ($emp_id == 193)*/ )
								{				
									$param['cal_titulo']= get_empresa($params['emp_id']).' ';
									$eva0=strtoupper(trim($this->input->post('nombre1')).' '.trim($this->input->post('paterno1')).' '.trim($this->input->post('materno1')));
									$param['cal_titulo'].=$eva0;
									
									
									if (strlen($this->input->post('nombre2')) > 0) 
										{
											$eva0=chr(10).strtoupper(trim($this->input->post('nombre2')).' '.trim($this->input->post('paterno2')).' '.trim($this->input->post('materno2')));
											$param['cal_titulo'].=$eva0; 
										}	
									
									if (strlen($this->input->post('nombre3')) > 0) 
										{
											$eva0=chr(10).strtoupper(trim($this->input->post('nombre3')).' '.trim($this->input->post('paterno3')).' '.trim($this->input->post('materno3')));
											$param['cal_titulo'].=$eva0; 
										}	
									
									if (strlen($this->input->post('nombre4')) > 0) 
										{
											$eva0=chr(10).strtoupper(trim($this->input->post('nombre4')).' '.trim($this->input->post('paterno4')).' '.trim($this->input->post('materno4')));
											$param['cal_titulo'].=$eva0; 
										}						
									
									$param['cal_titulo'].=' ** '.get_options_per_grupo('HC_SEGUROS', $params['hc1']);		
									
								}
								else
								{	if ($serv_id == 0 )
									{
										$param['cal_titulo']= get_empresa($params['emp_id']).', IDA:'.$cal_id; 
									}
									else
									{
										$param['cal_titulo']= get_empresa($params['emp_id']).', OS:'.$serv_id.', IDA:'.$cal_id; 
									}
								}					

													
								$param['serv_id']=$serv_id;
								$this->agenda->update_evento($cal_id,$param);	
							}

						}

					}
			 
					if ($emp_id == 253)
					{   
								$this->load->helper('mail');
								$evento = $this->agenda->get_evento($cal_id);
								
								$data_email = array('evento' => $evento);						
								$html = $this->load->view('agenda/email_add_evento_servicio',$data_email,TRUE);
								$this->load->helper('mail');
							
									if ($emp_id == 31)
									{
										$this->load->model('empresa/Empresa_model','empresa');
										
										$data_empresa = $this->empresa->get_empresa_by_id($emp_id);
										
										send_mail_std_event_serv(
										$this->input->post('mail'), 
										$evento, 
										$html,
										$cal_id,
										get_empresa($params['emp_id']),
										$user['usr_nombre'].' '.$user['usr_paterno'],
										$user['usr_correo'],
										$data_empresa['emp_responsable'] , 
										$data_empresa['emp_correo']
										,$params['cal_lugar'] );

									}
										else
									{

										send_mail_std_event_serv(
										$this->input->post('mail'), 
										$evento, 
										$html,
										$cal_id,
										get_empresa($emp_id),
										$user['usr_nombre'].' '.$user['usr_paterno'],
										$user['usr_correo'],
										'',
										'',
										$params['cal_lugar'] );

									}
					}
				 
				if ( ($cal_id) && ($error_gsi == 0) && ($error_observaciones_puestos == 0) )
                {
                        $this->load->helper('mail');
                        $evento = $this->agenda->get_evento($cal_id);						
                        $data_email = array('evento' => $evento);						
                        $html = $this->load->view('agenda/email_add_evento_servicio',$data_email,TRUE);
						
							if ($emp_id == 31)
							{
								$this->load->model('empresa/Empresa_model','empresa');								
								$data_empresa = $this->empresa->get_empresa_by_id($emp_id);
								
								send_mail_std_event_serv(
								$this->input->post('mail'), 
								$evento, 
								$html,
								$cal_id,
								get_empresa($params['emp_id']),
								$user['usr_nombre'].' '.$user['usr_paterno'],
								$user['usr_correo'],
								$data_empresa['emp_responsable'] , 
								$data_empresa['emp_correo']
								,$params['cal_lugar'],
								 $usuario );

							}
							else
							{
								send_mail_std_event_serv(
								$this->input->post('mail'), 
								$evento, 
								$html,
								$cal_id,
								get_empresa($emp_id),
								$user['usr_nombre'].' '.$user['usr_paterno'],
								$user['usr_correo'],
								'',
								'',
								$params['cal_lugar'],
								$usuario); 
							}
		
		
							if (get_empresas_corporacion($emp_id,'GSI'))
							{
								$gsi_evaluados=$params['cal_evaluados'];
								$gsi_evaluados=str_replace(' | ', '|',$gsi_evaluados);
								$gsi_evaluados=str_replace('||', '|',$gsi_evaluados);
								$gsi_evaluados[0]=' ';
								$gsi_evaluados=trim($gsi_evaluados);
								$gsi_evaluados=str_replace(' - ', '-',$gsi_evaluados);
								$array_gsi_evaluados=explode("|",$gsi_evaluados);
								
								foreach ($array_gsi_evaluados as $gsi_evaluado): 
									if ($gsi_evaluado)
									{	
										$array_gsi_evaluado=explode("-",$gsi_evaluado);								
										$data_y['clte_ida']=$cal_id;
										$this->cliente->actualiza_registro_sin_log($array_gsi_evaluado[0],array_to_upper($data_y));											
									}
								endforeach;
							}	
							
                    send_json_ok('Se guardó de forma correcta.');
                }
                else
                {   if ($error_observaciones_puestos == 1)
					{
						send_json_error('Ha ocurrido un error en los campos de OBSERVACIONES y PUESTOS, por favor revisar.');
					}
			        elseif ($error_gsi == 0)
					{
						if ($detecta_pkts > 0)
						{
							send_json_error('Ocurrió un error al guardar, por favor revise si toda su información este completa y vuelva intentar. Sugerencia valide VIÁTICOS.');
						}
						else
						{
							if ($emp_id == 210)
							{	
						
								if (
									($error_evaluado2 == 1) ||
									($error_evaluado3 == 1) ||
									($error_evaluado4 == 1) 
								   )
								{
									send_json_error('Por favor completar la información de los demás evaluados.');
								}	
								else	
								{						
									send_json_error('No se ha registrado el Archivo de Servicios, por favor revisar.');
								}
								
							}
							else
							{	
								send_json_error('Ocurrió un error al guardar, ¿eligio al menos un examen para este servicio?');
							}						
						}
					}
					else
					{
						send_json_error('No pudo agendarse la fecha deseada, Por favor busque otra fecha con la capacidad deseada.');
					}
				
                }				
				
				
			}
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
			
  			if($this->uri->segment(3) != '')
            {
                $data['evento_dia'] = date('Y-m-d',strtotime($this->uri->segment(3)));
            }
            else
            {
                $data['evento_dia'] = date('Y-m-d');
            }
			
			
			$data['evento_dia'] = date('Y-m-d');
			$data['empresa'] = $emp_id;
			
			$date_string = date('Y-m-d'); 
		
			/*TOMAMOS LA TABAL DE HORARIOS PARA LOS CASOS DE MONTERREY, LA VIGA Y ALPURA*/
			if ( ($user_cei == 4) || ($user_cei == 8) ||  (strstr($usuario['portal'],'ALPURA')) )
			{	
				$data['sheduler']=$this->agenda->horario(intval(date("W", strtotime($date_string))),$table);
			}
			
			/*TRAE A LOS EVAALUDOS SEGUN EL CASO*/
			if (strstr($usuario['portal'],'ALPURA'))
			{
				$data['evaluados'] = $this->cliente->get_allo_alpura_agenda(60,$emp_id);
			}
			elseif (strstr($usuario['acciones'],'SBORJA+'))
			{
				$data['evaluados'] = $this->cliente->get_allo_gsi_agenda_sborja(60,$emp_id);
			}
			else
			{
				$data['evaluados'] = $this->cliente->get_allo_gsi_agenda(60,$emp_id);
			}
			
            $this->load->helper('template');
			
            $params_view = array(
                'title' => 'Servicios',
                'view' => 'servicio/edit_b',
                'view_data' => $data
               );
			   
            render_template($params_view);  
        }
    }


    public function inicio_rep_evaluados_os($serv_id)
    {
		$data['servicio'] = $this->servicio->get($serv_id);
        $this->load->helper('template');
        $params_view = array(
            'title' => 'Inicio',
            'view' => 'servicio/inicio_rep_evaluados_os',
            'view_data' => $data
            );
        render_template($params_view);
    }




/************************************************************************************/   
    public function edita_c($emp_id,$modo=0)
    {
				$user = $this->session->user;
		$usuario = $this->medico->get($user['usr_id']);
		$user_empresa=$user['emp_id'];
		$user_cei=get_cei_id();		
		
		$data['evento_dia'] = date('Y-m-d',strtotime($this->uri->segment(3)));
		$fecha_div = explode('T', $this->uri->segment(3));
		$error_gsi=0;
		
		$error_observaciones_puestos=0;
		
		/*SE PREPARA A USAR EL SCHEDULER REQUERIDOS*/
		if (strstr($usuario['portal'],'ALPURA'))
		{
			$table='doc12_sheduler';
		}
		elseif (strstr($usuario['acciones'],'SBORJA+'))
		{
			$table='doc09_sheduler';
		}
		elseif ($user_cei == 4)
		{	
			$table='doc10_sheduler';
		}
		elseif ($user_cei == 8)
		{	
			$table='doc11_sheduler';
		}
	

		
		if ($modo == 1)
		{
			$data['modo']=1;
		}
		else
		{
			$data['modo']=0;
		}
		
		
		
        if(isset($fecha_div[1]))
        {
            $data['hora_ini'] = date('H:i',strtotime($fecha_div[1]));
        }
        else
        {
            $data['hora_ini'] = date('H:i');
        }	
       
	   if(isset($_POST) && count($_POST) > 0)     
       {
            //recibe los datos
            $this->load->library('form_validation');
           
			if (!(strstr($usuario['portal'],'ALPURA')))	
			{
				 $this->form_validation->set_rules('observaciones','Observaciones','required');	
			}	

			
			if ((!(valida_corporacion($emp_id,'GSI') == 'GSI')) && !(strstr($usuario['portal'],'ALPURA')))
			{
				$this->form_validation->set_rules('fecha_event_ini','Fecha inicia','required');
				$this->form_validation->set_rules('hora_event_ini','Hora inicia','required');
				$this->form_validation->set_rules('fecha_event_fin','Fecha fin','required');
				$this->form_validation->set_rules('hora_event_fin','Hora fin','required');			
			}
			
			$this->form_validation->set_rules('lugar','Lugar de realización de los servicios','required');
			
            if($this->form_validation->run())
            {
					if ($user['usr_id'] == 261)
					{
						$usr_admin=$this->input->post('administrador');
						if ($usr_admin == 0){$usr_admin = 22;}
						$user=get_a_usuario($usr_admin);						
					}	
				
				
					if
					(
					(strlen ($this->input->post('observaciones')) > 1) &&	
					(strlen ($this->input->post('descripcion')  ) > 1) 
					)
					{
						if ( trim($this->input->post('observaciones')) == trim($this->input->post('descripcion')) ) 
						{ $error_observaciones_puestos=1; }	
						
					}
				
			 if ($error_observaciones_puestos == 0 )
			 {	 
				$total_examenes_selectos=$this->input->post('total_examenes_selectos');
				$paquetes='';
				$detecta_pkts=0;
				for($i=1; $i <= $total_examenes_selectos; $i++)
				{
					$indice='examen_select_pkt_'.strval($i);
					if ($this->input->post($indice) != NULL)
					{	
					$paquetes.=$this->input->post($indice).';';
					$detecta_pkts++;
					}
					
				}				
				
				$id_horario=0;					
				$cuantos_evaluados=0;
				$los_evaluados=$this->input->post('evaluados');
				$modo=$this->input->post('modo');
				
				if ($user['usr_id'] == 466) /*es unidad reclutadora*/
				{
					$modo=1;
				}
				
				if  (
						(($user_root3 == 2) && ($user_root4 == 3)) 
						||
						(strstr($usuario['acciones'],'REGNORMAL'))
					)	
					{$modo = 1;}
					
				
				
				
				if (strstr($usuario['portal'],'ALPURA'))	
				{
					$id_horario=$this->input->post('horario');
					
					$cuantos_evaluados=$this->input->post('num_eva');
					
					if (!($cuantos_evaluados > 0))
					{
						$cuantos_evaluados=1;
					}
					
					$horario_ok=$this->agenda->valida_horario($id_horario,$cuantos_evaluados,$table);
					
					if ($horario_ok)					
					{

						$cuantos_evaluados=0;
						if (strlen($this->input->post('evaluado1')) > 3) 
						{
							if (($horario_ok['she_capacidad']-$cuantos_evaluados) > 0)
							{	
								$el_eva1 = strstr($this->input->post('evaluado1'), ' - ', true); 
								
								$gsi_evaluados=$el_eva1;
								$gsi_evaluados=trim($gsi_evaluados);
								$gente = $this->cliente->geton($gsi_evaluados); 
								$gente_telefono=$gente['clte_email'];
								$gente_nombre=$gente['clte_nombre'].' '.$gente['clte_paterno'].' '.$gente['clte_materno'];
								$cuantos_evaluados++;
							}
							else
							{
								$el_eva1 =0;
							}	
						}
						if (strlen($this->input->post('evaluado2')) > 3) 
						{
							if (($horario_ok['she_capacidad']-$cuantos_evaluados) > 0)
							{	
								$el_eva2 = strstr($this->input->post('evaluado2'), ' - ', true); 
								$cuantos_evaluados++;
							}
							else
							{
								$el_eva2 =0;
							}	
						}
						if (strlen($this->input->post('evaluado3')) > 3) 
						{	
							if (($horario_ok['she_capacidad']-$cuantos_evaluados) > 0)
								{	
									$el_eva3 = strstr($this->input->post('evaluado3'), ' - ', true); 
									$cuantos_evaluados++;
								}
								else
								{
									$el_eva3 =0;
								}
						}
						
						$horario_ok['she_capacidad']=$horario_ok['she_capacidad']-$cuantos_evaluados;
						$horario_apartado=$this->agenda->aparta_horario($id_horario,$horario_ok,$table);
	
						$fecha_ini = $horario_ok['she_fecha'].' '.$horario_ok['she_hora_ini'].':02';
						$fecha_fin = $horario_ok['she_fecha'].' '.$horario_ok['she_hora_fin'].':02';

						
						
						foreach (explode(';', $paquetes) as $detalle)
						{
							if ( strlen($detalle) > 0)
							{												
								$exa_sel['nomserv'].= get_nombre_de_examen_por_empresa($detalle,$emp_id);							
							}
						}

				
						$k=0;
						if ( $el_eva1 > 0)
						{
						$cliente_gsi_id = $this->cliente->actualiza( $el_eva1,$exa_sel);
						}
											
						if ( $el_eva2 > 0)
						{
						$cliente_gsi_id = $this->cliente->actualiza($el_eva2,$exa_sel);
						}
						if ( $el_eva3 > 0)
						{
						$cliente_gsi_id = $this->cliente->actualiza($el_eva3,$exa_sel);
						}						

						$los_evaluados='';
						
						if ( $el_eva1 > 0)
						{
							$los_evaluados.=' | '.$this->input->post('evaluado1').' | ';
							$k++;
						}
						if ( $el_eva2 > 0)
						{
							$los_evaluados.=' | '.$this->input->post('evaluado2').' | ';
							$k++;
						}
						if ( $el_eva3 > 0)
						{
							$los_evaluados.=' | '.$this->input->post('evaluado3').' | ';
							$k++;
						}	
										
					}
					else
					{
						$fecha_ini='21-01-01 01:01:01';
						$fecha_fin='21-01-01 01:01:01';
						$error_gsi=1;
					}
					
				}
				elseif ((valida_corporacion($emp_id,'GSI') == 'GSI') && ($modo==0) &&  ( ($user_cei == 4) || ($user_cei == 8) ))
				{
					$id_horario=$this->input->post('horario');
					
					$cuantos_evaluados=$this->input->post('num_eva');
					
					if (!($cuantos_evaluados > 0))
					{
						$cuantos_evaluados=1;
					}
					
					$horario_ok=$this->agenda->valida_horario($id_horario,$cuantos_evaluados,$table);
					
					if ($horario_ok)					
					{

						$cuantos_evaluados=0;
						if (strlen($this->input->post('evaluado1')) > 3) 
						{
							if (($horario_ok['she_capacidad']-$cuantos_evaluados) > 0)
							{	
								$el_eva1 = strstr($this->input->post('evaluado1'), ' - ', true); 
								$cuantos_evaluados++;
							}
							else
							{
								$el_eva1 =0;
							}	
						}
						if (strlen($this->input->post('evaluado2')) > 3) 
						{
							if (($horario_ok['she_capacidad']-$cuantos_evaluados) > 0)
							{	
								$el_eva2 = strstr($this->input->post('evaluado2'), ' - ', true); 
								$cuantos_evaluados++;
							}
							else
							{
								$el_eva2 =0;
							}	
						}
						if (strlen($this->input->post('evaluado3')) > 3) 
						{	
							if (($horario_ok['she_capacidad']-$cuantos_evaluados) > 0)
								{	
									$el_eva3 = strstr($this->input->post('evaluado3'), ' - ', true); 
									$cuantos_evaluados++;
								}
								else
								{
									$el_eva3 =0;
								}
						}
						
						$horario_ok['she_capacidad']=$horario_ok['she_capacidad']-$cuantos_evaluados;
						$horario_apartado=$this->agenda->aparta_horario($id_horario,$horario_ok,$table);
	
						$fecha_ini = $horario_ok['she_fecha'].' '.$horario_ok['she_hora_ini'].':02';
						$fecha_fin = $horario_ok['she_fecha'].' '.$horario_ok['she_hora_fin'].':02';

						
						
						foreach (explode(';', $paquetes) as $detalle)
						{
							if ( strlen($detalle) > 0)
							{												
								$exa_sel['nomserv'].= get_nombre_de_examen_por_empresa($detalle,$emp_id);							
							}
						}

				
					$k=0;
						if ( $el_eva1 > 0)
						{
						$cliente_gsi_id = $this->cliente->actualiza( $el_eva1,$exa_sel);
						}
											
						if ( $el_eva2 > 0)
						{
						$cliente_gsi_id = $this->cliente->actualiza($el_eva2,$exa_sel);
						}
						if ( $el_eva3 > 0)
						{
						$cliente_gsi_id = $this->cliente->actualiza($el_eva3,$exa_sel);
						}						

						$los_evaluados='';
						
						if ( $el_eva1 > 0)
						{
							$los_evaluados.=' | '.$this->input->post('evaluado1').' | ';
							$k++;
						}
						if ( $el_eva2 > 0)
						{
							$los_evaluados.=' | '.$this->input->post('evaluado2').' | ';
							$k++;
						}
						if ( $el_eva3 > 0)
						{
							$los_evaluados.=' | '.$this->input->post('evaluado3').' | ';
							$k++;
						}	
										
					}
					else
					{
						$fecha_ini='21-01-01 01:01:01';
						$fecha_fin='21-01-01 01:01:01';
						$error_gsi=1;
					}
					
				}
				else
				{
					$fecha_ini = formatea_fechahora_mysql($this->input->post('fecha_event_ini').' '.$this->input->post('hora_event_ini'));
					$fecha_fin = formatea_fechahora_mysql($this->input->post('fecha_event_fin').' '.$this->input->post('hora_event_fin'));					
				}				
		    
	

				$params = array
				(
					'cal_pkts' => $paquetes,
					//Observaciones
					'cal_observaciones' =>$this->input->post('observaciones'),
					//Evaluados
					'cal_evaluados' => $los_evaluados, 	
					//Solicitante
					'cal_usr_nombre' => $user['usr_nombre'],
					'cal_usr_paterno' => $user['usr_paterno'],
					'cal_usr_materno' => $user['usr_materno'],
					'cal_usr_correo' => $user['usr_correo'],					
					//datos normales de calendario	
                    'cal_fecha' => $this->input->post('fecha'),
                    'cal_titulo' => $this->input->post('asunto'),
                    'cal_servicio' => NULL,
                    'cal_descripcion' => $this->input->post('descripcion'),
                    'cal_fecha_ini' => $fecha_ini,
                    'cal_fecha_fin' => $fecha_fin,
					'cal_id_horario' => $id_horario,					
					'cal_cuantos_evaluados' => $cuantos_evaluados,
                    'cal_uid' => uniqid(rand(0, getmypid()))					
                );

				if (($emp_id == 298) ||  ($emp_id == 152) || ($emp_id  == 193) || ($emp_id  == 210) || ($emp_id  == 230) || ($emp_id  == 311) || ($emp_id  == 142))
				{	
					if (strlen($this->input->post('hc1')) > 0)
					{
						$params['hc1'] =$this->input->post('hc1');
					}

					if (strlen($this->input->post('hc2')) > 0)
					{
						$params['hc2'] =$this->input->post('hc2');
					}

					if (strlen($this->input->post('hc3')) > 0)
					{
						$params['hc3'] =$this->input->post('hc3');
					}				
				}

				if ($user['emp_id'] == 31)
				{					
					$params['cal_viaticos'] =$this->input->post('fsm_viaticos');
				}				
				else
				{
					$params['cal_viaticos'] ='NO';
				}	

				if ($emp_id == 193)
				{		
					$params['cal_autoriza'] =$this->input->post('fsm_autoriza');				
				}



				if ($user['emp_id'] == 31)
				{					
					$params['emp_id'] = $emp_id;
				}				
				elseif  (
							($user['emp_id'] == 126)   ||
							($user['emp_id'] ==125)   ||
							($user['emp_id'] ==33)   ||
							($user['emp_id'] ==179)   ||
							($user['emp_id'] ==181)   ||
							($user['emp_id'] ==180)   ||
							($user['emp_id'] ==77)   ||
							($user['emp_id'] ==176)   ||
							($user['emp_id'] ==178)   ||
							($user['emp_id'] ==177)   ||
							($user['emp_id'] ==57)   ||
							($user['emp_id'] ==175)   ||
							($user['emp_id'] ==174)   ||						 
							($user['emp_id'] == 127)    
							|| ($user['emp_id'] == 183)
							|| ($user['emp_id'] ==33)
							|| ($user['emp_id'] ==77)
							|| ($user['emp_id'] ==106)
							|| ($user['emp_id'] ==148)							
						)/*es un despacho de GSI*/
				{
					$params['emp_id'] = $emp_id;
					$params['desp_emp_id'] = $this->input->post('empresa');
				}
				else
				{
					$params['emp_id'] = $emp_id;
					$params['desp_emp_id'] = 0;
				}
				
				

				
                $params['cal_lugar'] = $this->input->post('lugar');
				
				//if (($emp_id != 298) && ($emp_id != 152) && ($emp_id  != 193)  && ($emp_id  != 210)  && ($emp_id  != 230))
				if (!(get_empresas_giro($emp_id,'SEGUROS')))
				{					
					$params['cal_lugar_det'] = $this->input->post('lugar_det');					
                }
				else
				{								
					if ($params['cal_lugar'] == 0)
					{												
						$domicilio=$this->input->post('calle').' ';
						$domicilio.=$this->input->post('next').' '.$this->input->post('nint').' ';
						$domicilio.=$this->input->post('colonia').', ';
						$domicilio.='C.P. '.$this->input->post('cp').', ';
						$domicilio.=$this->input->post('municipio').', ';
						$domicilio.=$this->input->post('localidad').', ';
						$domicilio.=$this->input->post('entidad').', ';
						$domicilio.=$this->input->post('pais').'.';

						$params['cal_lugar_det'] = 	$domicilio;	

						$params['cal_eva_telefono_1'] = $this->input->post('telefono_1');						
						$params['cal_eva_telefono_2'] = $this->input->post('telefono_2');						
					}
					elseif ($params['cal_lugar'] == 2) 
					{	
						$params['cal_lugar_det'] ='Calle San Borja 1365, Vértiz Narvarte, Benito Juárez, C.P. 03600, CDMX'; 
					}
					else
					{	
						$params['cal_lugar_det'] = 'Paseo de la Reforma No. 342, Piso 14, Col. Juárez, Del. Cuauhtémoc, C.P. 06600, CDMX';  
					}							
			
				}

                $params['cal_email'] = $user['usr_correo'].'; '.$this->input->post('mail');


				/*if (($emp_id == 152) || ($emp_id  == 193))
				{*/	
				/***********************************************************/				
				/******NUEVOS ARCHIVO ANEXO 0 ******************************/
				if(!empty($_FILES['anexo']['name']))
				{
					$nombre_anexo=$_FILES['anexo']['name'];
					$this->load->library('upload');
					$filename = md5(time());
					$config = array(
							'upload_path'   => './../../files/anexos/',
							'overwrite'     => TRUE,
							'file_name'     => $filename,
							'allowed_types' => 'doc|docx|pdf|txt|xlsx|xls|png|jpg|jpeg',
							'max_size'      => '10000'
					);

					$this->upload->initialize($config);
					
					if ( ! $this->upload->do_upload('anexo'))
					{
						echo json_encode(array('status' => 'error','content' => $this->upload->display_errors()));
						exit;
					}
					else 
					{
						$data = $this->upload->data();
						$params['cal_anexo_path'] = $data['file_name'];
						$params['cal_anexo_nombre'] = $nombre_anexo;
						$data_serv['serv_anexo_path'] = $data['file_name'];
						$data_serv['serv_anexo_nombre'] = $nombre_anexo;
						
					}
				/*}*/
				/***********************************************************/	
				}





				/******NUEVOS ARCHIVO ANEXO 1 ******************************/
                if(!empty($_FILES['anexo1']['name']))
                {
					$nombre_anexo=$_FILES['anexo1']['name'];
                    $this->load->library('upload');
					
					sleep(1);
                    $filename1 = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/anexos/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename1,
                            'allowed_types' => 'doc|docx|pdf|txt|xlsx|xls|png|jpg|jpeg',
                            'max_size'      => '10000'
                    );

                    $this->upload->initialize($config);
					
                    if ( ! $this->upload->do_upload('anexo1'))
                    {
                          echo json_encode(array('status' => 'error','content' => $this->upload->display_errors()));
                        exit;
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $params['cal_anexo1_path'] = $data['file_name'];
						$params['cal_anexo1_nombre'] = $nombre_anexo;
						$data_serv['serv_anexo1_path'] = $data['file_name'];
						$data_serv['serv_anexo1_nombre'] = $nombre_anexo;
                    }
                }
				/***********************************************************/				
				
				//if (($emp_id == 152) || ($emp_id  == 193))
				{	
				/******NUEVOS ARCHIVO ANEXO 2 ******************************/
								if(!empty($_FILES['anexo2']['name']))
								{
									$nombre_anexo=$_FILES['anexo2']['name'];
									$this->load->library('upload');
									
									sleep(1);
									$filename2 = md5(time());
									$config2 = array(
											'upload_path'   => './../../files/anexos/',
											'overwrite'     => TRUE,
											'file_name'     => $filename2,
											'allowed_types' => 'doc|docx|pdf|txt|xlsx|xls|png|jpg|jpeg',
											'max_size'      => '10000'
									);

									$this->upload->initialize($config2);
									
									if ( ! $this->upload->do_upload('anexo2'))
									{

										echo json_encode(array('status' => 'error','content' => $this->upload->display_errors()));
										exit;
									}
									else 
									{
										$data = $this->upload->data();
										$params['cal_anexo2_path'] = $data['file_name'];
										$params['cal_anexo2_nombre'] = $nombre_anexo;
										$data_serv['serv_anexo2_path'] = $data['file_name'];
										$data_serv['serv_anexo2_nombre'] = $nombre_anexo;
									}
								}
				/***********************************************************/	
				/******NUEVOS ARCHIVO ANEXO 3 ******************************/
								if(!empty($_FILES['anexo3']['name']))
								{
									$nombre_anexo=$_FILES['anexo3']['name'];
									$this->load->library('upload');
									
									sleep(1);
									$filename3 = md5(time());
									$config3 = array(
											'upload_path'   => './../../files/anexos/',
											'overwrite'     => TRUE,
											'file_name'     => $filename3,
											'allowed_types' => 'doc|docx|pdf|txt|xlsx|xls|png|jpg|jpeg',
											'max_size'      => '10000'
									);

									$this->upload->initialize($config3);
									
									if ( ! $this->upload->do_upload('anexo3'))
									{

										echo json_encode(array('status' => 'error','content' => $this->upload->display_errors()));
										exit;
									}
									else 
									{
										$data = $this->upload->data();
										$params['cal_anexo3_path'] = $data['file_name'];
										$params['cal_anexo3_nombre'] = $nombre_anexo;
										$data_serv['serv_anexo3_path'] = $data['file_name'];
										$data_serv['serv_anexo3_nombre'] = $nombre_anexo;
										
									}
								}
				/***********************************************************/	
				/******NUEVOS ARCHIVO ANEXO 4 ******************************/
								if(!empty($_FILES['anexo4']['name']))
								{
									$nombre_anexo=$_FILES['anexo4']['name'];
									$this->load->library('upload');
									
									sleep(1);
									$filename4 = md5(time());
									$config = array(
											'upload_path'   => './../../files/anexos/',
											'overwrite'     => TRUE,
											'file_name'     => $filename4,
											'allowed_types' => 'doc|docx|pdf|txt|xlsx|xls|png|jpg|jpeg',
											'max_size'      => '10000'
									);

									$this->upload->initialize($config);
									
									if ( ! $this->upload->do_upload('anexo4'))
									{

										echo json_encode(array('status' => 'error','content' => $this->upload->display_errors()));
										exit;
									}
									else 
									{
										$data = $this->upload->data();
										$params['cal_anexo4_path'] = $data['file_name'];
										$params['cal_anexo4_nombre'] = $nombre_anexo;
										$data_serv['serv_anexo4_path'] = $data['file_name'];
										$data_serv['serv_anexo4_nombre'] = $nombre_anexo;
									}
								}
				/***********************************************************/	
				}

/****************** Estructura para generar Orden de Servicio*****************************************/
 
				$params['cei_control_id'] = $this->input->post('cei_control');
				$data_serv['cei_control_id'] = $this->input->post('cei_control');
				
				if (($user['emp_id'] == 31) &&  (strlen($this->input->post('serv_orden')) > 0))
				{					
					$params['serv_orden'] = $this->input->post('serv_orden');
					$data_serv['serv_orden'] =$this->input->post('serv_orden');
				}
				else
				{	
					$f = new DateTime();
					
					if ($user['emp_id'] == 321)
					{
						$ff= 'PROV_'.$this->input->post('zona_securitas').'_'.$f->getTimestamp();
					}						
					else
					{	
						$ff= 'PROVISIONAL_'. $f->getTimestamp();			
					}
					$params['serv_orden']= $ff;
					$data_serv['serv_orden'] = $ff;
				}	
				

				if (!(valida_corporacion($emp_id,'GSI') === 'GSI') || ($emp_id !=31) )
				{	
					$data_serv['emp_id'] =  $emp_id;
					$data_serv['usr_id'] = $user['usr_id'];
					$data_serv['serv_f_inicio'] = $fecha_ini;
					$data_serv['serv_f_fin'] = $fecha_fin;
					$data_serv['serv_desc'] = $this->input->post('observaciones');
					$data_serv['serv_ubicacion'] =   $this->input->post('lugar');
					$data_serv['serv_estatus_cve'] = 'PROCESO';
					$data_serv['cei_id'] = $user['cei_id'];

				}
				
				$cal_id = $this->agenda->add_evento_folio(array_to_upper($params));
				$serv_id=0;
				$param['cal_titulo']= get_empresa($params['emp_id']).', IDA:'.$cal_id; 
				$param['serv_id']=$serv_id;
				$this->agenda->update_evento($cal_id,$param);
				


	        }
			 
				 
				if ( ($cal_id) && ($error_gsi == 0) && ($error_observaciones_puestos == 0) )
                {
                        $this->load->helper('mail');
                        $evento = $this->agenda->get_evento($cal_id);						
                        $data_email = array('evento' => $evento);	
						 //$data_email = array('emailer' => $gente_telefono);
                        $html = $this->load->view('agenda/email_add_evento_servicio_c',$data_email,TRUE);
						
								send_mail_std_event_serv_c(
								$this->input->post('mail'), 
								$evento, 
								$html,
								$cal_id,
								get_empresa($emp_id),
								$user['usr_nombre'].' '.$user['usr_paterno'],
								$user['usr_correo'],
								$gente_nombre,
								$gente_telefono,
								$params['cal_lugar'],
								$usuario);

		
		
							//if (get_empresas_corporacion($emp_id,'GSI'))
							{
								$gsi_evaluados=$params['cal_evaluados'];
								$gsi_evaluados=str_replace(' | ', '|',$gsi_evaluados);
								$gsi_evaluados=str_replace('||', '|',$gsi_evaluados);
								$gsi_evaluados[0]=' ';
								$gsi_evaluados=trim($gsi_evaluados);
								$gsi_evaluados=str_replace(' - ', '-',$gsi_evaluados);
								$array_gsi_evaluados=explode("|",$gsi_evaluados);
								
								foreach ($array_gsi_evaluados as $gsi_evaluado): 
									if ($gsi_evaluado)
									{	
										$array_gsi_evaluado=explode("-",$gsi_evaluado);								
										$data_y['clte_ida']=$cal_id;
										$this->cliente->actualiza_registro_sin_log($array_gsi_evaluado[0],array_to_upper($data_y));											
									}
								endforeach;
							}	
							
                    send_json_ok('Se guardó de forma correcta.');
                }
                else
                {   if ($error_observaciones_puestos == 1)
					{
						send_json_error('Ha ocurrido un error en los campos de OBSERVACIONES y PUESTOS, por favor revisar.');
					}
			        elseif ($error_gsi == 0)
					{
						if ($detecta_pkts > 0)
						{
							send_json_error('Ocurrió un error al guardar, por favor revise si toda su información este completa y vuelva intentar. Sugerencia valide VIÁTICOS.');
						}
						else
						{
							if ($emp_id == 210)
							{	
						
								if (
									($error_evaluado2 == 1) ||
									($error_evaluado3 == 1) ||
									($error_evaluado4 == 1) 
								   )
								{
									send_json_error('Por favor completar la información de los demás evaluados.');
								}	
								else	
								{						
									send_json_error('No se ha registrado el Archivo de Servicios, por favor revisar.');
								}
								
							}
							else
							{	
								send_json_error('Ocurrió un error al guardar, ¿eligio al menos un examen para este servicio?');
							}						
						}
					}
					else
					{
						send_json_error('No pudo agendarse la fecha deseada, Por favor busque otra fecha con la capacidad deseada.');
					}
				
                }				
				
				
			}
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
			
  			if($this->uri->segment(3) != '')
            {
                $data['evento_dia'] = date('Y-m-d',strtotime($this->uri->segment(3)));
            }
            else
            {
                $data['evento_dia'] = date('Y-m-d');
            }
			
			
			$data['evento_dia'] = date('Y-m-d');
			$data['empresa'] = $emp_id;
			
			$date_string = date('Y-m-d'); 
		
			/*TOMAMOS LA TABAL DE HORARIOS PARA LOS CASOS DE MONTERREY, LA VIGA Y ALPURA*/
			if ( ($user_cei == 4) || ($user_cei == 8) ||  (strstr($usuario['portal'],'ALPURA')) )
			{	
				$data['sheduler']=$this->agenda->horario(intval(date("W", strtotime($date_string))),$table);
			}
			
			/*TRAE A LOS EVAALUDOS SEGUN EL CASO*/
			if (strstr($usuario['portal'],'ALPURA'))
			{
				$data['evaluados'] = $this->cliente->get_allo_alpura_agenda(60,$emp_id);
			}
			elseif (strstr($usuario['acciones'],'SBORJA+'))
			{
				$data['evaluados'] = $this->cliente->get_allo_gsi_agenda_sborja(60,$emp_id);
			}
			else
			{
				$data['evaluados'] = $this->cliente->get_allo_gsi_agenda(60,$emp_id);
			}
			
            $this->load->helper('template');
			
            $params_view = array(
                'title' => 'Servicios',
                'view' => 'servicio/edit_c',
                'view_data' => $data
               );
			   
            render_template($params_view);  
        }
    }	

/************************************************************************************/     
    public function edita_ordenes($serv_id)
    {
       $servicio = $this->servicio->get($serv_id);
       //echo 'A';
	   if(isset($_POST) && count($_POST) > 0)     
        {	$continuar=1;
            $medico = $this->session->user;
            $this->load->library('form_validation');
			
			if ($servicio['serv_estatus_cve'] == 'CONCLUIDO') 
			{
				$this->form_validation->set_rules('cantidad_facturada','Cantidad Facturada (sin iva)','required');
				$this->form_validation->set_rules('estatus','Estatus','required');
			}
			elseif ($servicio['serv_estatus_cve'] == 'FIN') 
			{
				$this->form_validation->set_rules('estatus','Estatus','required');
			}				
			else
			{	
				$this->form_validation->set_rules('orden','Pedido','required');
				//$this->form_validation->set_rules('emp_id','Empresa','required');
				$this->form_validation->set_rules('f_ini','Fecha inicio','required');
				$this->form_validation->set_rules('h_ini','Hora inicio','required');
				$this->form_validation->set_rules('f_fin','Fecha fin','required');
				$this->form_validation->set_rules('h_fin','Hora fin','required');
				$this->form_validation->set_rules('descrip','Descripción','required');
				$this->form_validation->set_rules('ubicacion','Ubicación','required');
				//$this->form_validation->set_rules('responsable','Responsable','required');
				$this->form_validation->set_rules('estatus','Estatus','required');
			}

            if($this->form_validation->run())
            {
               
				$hoy='';
				$factudado=0;
				if ($servicio['serv_estatus_cve'] == 'CONCLUIDO') 
				{
					
					$data_serv['serv_cantidad_facturada'] = $this->input->post('cantidad_facturada');
					$data_serv['serv_quien_factura'] = $medico['usr_nombre'].' '.$medico['usr_paterno'];
					$data_serv['serv_fecha_factura'] = date("Y-m-d H:i:s");
					$data_serv['serv_estatus_cve'] = $this->input->post('estatus');
					$data_serv['serv_f_inicio'] = $fecha_ini=$servicio['serv_f_inicio'];
					$data_serv['serv_f_fin'] = $fecha_fin=$servicio['serv_f_inicio'];
					
					//$hoy='HC_'.$servicio['emp_id'].'_'.date("dmY_His").'_';
					$data_serv['serv_ubicacion'] = $servicio['serv_ubicacion'];
					if(!empty($_FILES['factura']['name']))
					{
						$nombre_anexo=$_FILES['factura']['name'];
						$this->load->library('upload');
						$filename = md5(time());
						$config = array(
								'upload_path'   => './../../files/facturas/',
								'overwrite'     => TRUE,
								'file_name'     => $filename,
								'allowed_types' => 'pdf',
								'max_size'      => '10000'
						);

						$this->upload->initialize($config);
						if ( ! $this->upload->do_upload('factura'))
						{
							echo json_encode(array('status' => 'error','content' => $this->upload->display_errors()));
							exit;
						}
						else 
						{
							$data = $this->upload->data();
							$data_serv['serv_factura_nombre'] = $data['file_name'];
							$data_serv['serv_factura_path '] = $nombre_anexo;
							$factudado++;
						}
					}
					

					if(!empty($_FILES['xml']['name']))
					{
						$nombre_anexo=$_FILES['xml']['name'];
						$this->load->library('upload');
						$filename = md5(time());
						$config = array(
								'upload_path'   => './../../files/facturas/',
								'overwrite'     => TRUE,
								'file_name'     => $filename,
								'allowed_types' => 'xml',
								'max_size'      => '10000'
						);

						$this->upload->initialize($config);
						if ( ! $this->upload->do_upload('xml'))
						{
							echo json_encode(array('status' => 'error','content' => $this->upload->display_errors()));
							exit;
						}
						else 
						{
							$data = $this->upload->data();
							$data_serv['serv_xml_nombre'] = $data['file_name'];
							$data_serv['serv_xml_path '] = $nombre_anexo;
							$factudado++;
						}
					}					
					
					
				}
				else
				{			   
					//$fecha_ini = formatea_fechahora_mysql($this->input->post('f_ini').' '.$this->input->post('h_ini'));
					//$fecha_fin = formatea_fechahora_mysql($this->input->post('f_fin').' '.$this->input->post('h_fin'));
					$fecha_ini = $this->input->post('f_ini').' '.formatea_hora_mysql($this->input->post('h_ini'));
					$fecha_fin = $this->input->post('f_fin').' '.formatea_hora_mysql($this->input->post('h_fin'));					
					$data_serv['serv_orden'] = $this->input->post('orden');
					//$data_serv['emp_id'] = $this->input->post('emp_id');
					//$data_serv['usr_id'] = $medico['usr_id'];
					$data_serv['serv_f_inicio'] = $fecha_ini;
					$data_serv['serv_f_fin'] = $fecha_fin;
					$data_serv['serv_desc'] = $this->input->post('descrip');
					$data_serv['serv_ubicacion'] = $this->input->post('ubicacion');
					$data_serv['serv_contacto_per'] = $this->input->post('responsable');
					$data_serv['serv_contacto_tel'] = limpia_telefono($this->input->post('telefono'));
					$data_serv['serv_acuerdos'] = $this->input->post('clausulas');                
					$data_serv['serv_estatus_cve'] = $this->input->post('estatus');
					$data_serv['cei_id'] = $this->input->post('cei');
					$data_serv['cei_control_id'] = $this->input->post('cei_control');
					$data_serv['reclutador'] = $this->input->post('reclutador');
					
					$data_serv=array_to_upper($data_serv);
				}				
				
				

				/******NUEVOS ARCHIVO ANEXO     ***/				
				if(!empty($_FILES['anexo']['name']))
				{
					$nombre_anexo=$_FILES['anexo']['name'];
					$this->load->library('upload');
					$filename = md5(time());
					$config = array(
							'upload_path'   => './../../files/anexos/',
							'overwrite'     => TRUE,
							'file_name'     => $filename,
							'allowed_types' => 'doc|docx|pdf|txt|xlsx|xls|png|jpg|jpeg',
							'max_size'      => '10000'
					);

					$this->upload->initialize($config);
					if ( ! $this->upload->do_upload('anexo'))
					{
						echo json_encode(array('status' => 'error','content' => $this->upload->display_errors()));
						exit;
					}
					else 
					{
						$data = $this->upload->data();
						$data_serv['serv_anexo_path'] = $data['file_name'];
						$data_serv['serv_anexo_nombre'] = $nombre_anexo;
					}
				}
				else 
				{								
					//$data_serv['serv_anexo_path'] = '';
					//$data_serv['serv_anexo_nombre'] = '';
				}	
				
				/******NUEVOS ARCHIVO ANEXO 1 ******/
                if(!empty($_FILES['anexo1']['name']))
                {
					$nombre_anexo=$_FILES['anexo1']['name'];
                    $this->load->library('upload');
					
					sleep(1);
                    $filename1 = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/anexos/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename1,
                            'allowed_types' => 'doc|docx|pdf|txt|xlsx|xls|png|jpg|jpeg',
                            'max_size'      => '10000'
                    );

                    $this->upload->initialize($config);
					
                    if ( ! $this->upload->do_upload('anexo1'))
                    {
                        echo json_encode(array('status' => 'error','content' => $this->upload->display_errors()));
                        exit;
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_serv['serv_anexo1_path'] = $data['file_name'];
						$data_serv['serv_anexo1_nombre'] = $nombre_anexo;
                    }
                }
				else 
				{
					//$data_serv['serv_anexo1_path'] = '';
					//$data_serv['serv_anexo1_nombre'] = '';
				}
			
				/******NUEVOS ARCHIVO ANEXO 2 ******/
                if(!empty($_FILES['anexo2']['name']))
                {
					$nombre_anexo=$_FILES['anexo2']['name'];
                    $this->load->library('upload');
					
					sleep(1);
                    $filename2 = md5(time());
                    $config2 = array(
                            'upload_path'   => './../../files/anexos/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename2,
                            'allowed_types' => 'doc|docx|pdf|txt|xlsx|xls|png|jpg|jpeg',
                            'max_size'      => '10000'
                    );

                    $this->upload->initialize($config2);
					
                    if ( ! $this->upload->do_upload('anexo2'))
                    {
                        echo json_encode(array('status' => 'error','content' => $this->upload->display_errors()));
                        exit;
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_serv['serv_anexo2_path'] = $data['file_name'];
						$data_serv['serv_anexo2_nombre'] = $nombre_anexo;
                    }
                }
				else 
				{
					//$data_serv['serv_anexo2_path'] = '';
					//$data_serv['serv_anexo2_nombre'] = '';
				}
				
				/******NUEVOS ARCHIVO ANEXO 3 ******/
                if(!empty($_FILES['anexo3']['name']))
                {
					$nombre_anexo=$_FILES['anexo3']['name'];
                    $this->load->library('upload');
					
					sleep(1);
                    $filename3 = md5(time());
                    $config3 = array(
                            'upload_path'   => './../../files/anexos/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename3,
                            'allowed_types' => 'doc|docx|pdf|txt|xlsx|xls|png|jpg|jpeg',
                            'max_size'      => '10000'
                    );

                    $this->upload->initialize($config3);
					
                    if ( ! $this->upload->do_upload('anexo3'))
                    {
                        echo json_encode(array('status' => 'error','content' => $this->upload->display_errors()));
                        exit;
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_serv['serv_anexo3_path'] = $data['file_name'];
						$data_serv['serv_anexo3_nombre'] = $nombre_anexo;
						
                    }
                }
				else 
				{
					//$data_serv['serv_anexo3_path'] = '';
					//$data_serv['serv_anexo3_nombre'] = '';
				}

				/******NUEVOS ARCHIVO ANEXO 4 *****/
                if(!empty($_FILES['anexo4']['name']))
                {
					$nombre_anexo=$_FILES['anexo4']['name'];
                    $this->load->library('upload');
					
					sleep(1);
                    $filename4 = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/anexos/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename4,
                            'allowed_types' => 'doc|docx|pdf|txt|xlsx|xls|png|jpg|jpeg',
                            'max_size'      => '10000'
                    );

                    $this->upload->initialize($config);
					
                    if ( ! $this->upload->do_upload('anexo4'))
                    {
                        echo json_encode(array('status' => 'error','content' => $this->upload->display_errors()));
                        exit;
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_serv['serv_anexo4_path'] = $data['file_name'];
						$data_serv['serv_anexo4_nombre'] = $nombre_anexo;
                    }
                }
				else 
				{
					//$data_serv['serv_anexo4_path'] = '';
					//$data_serv['serv_anexo4_nombre'] = '';
				}

				
				/**********************************************************/
				//$data_serv['cal_id'] = $this->input->post('cal_id');
				if ($servicio['cal_id'] > 0)
				{
					$evento = $this->agenda->get_evento($servicio['cal_id']);				
					
					$evento['serv_orden']=$data_serv['serv_orden'];
					
					$evento['cal_fecha_ini']=$data_serv['serv_f_inicio'] = $fecha_ini;
					$evento['cal_fecha_fin']=$data_serv['serv_f_fin'] = $fecha_fin;
					
					$evento['cal_descripcion'] = $this->input->post('descrip');
					
					if (strlen($data_serv['serv_anexo_path'])>0)
					{	
					$evento['cal_anexo_path']=$data_serv['serv_anexo_path'];
					$evento['cal_anexo_nombre']=$data_serv['serv_anexo_nombre'];
					}
					if (strlen($data_serv['serv_anexo1_path'])>0)
					{
					$evento['cal_anexo1_path']=$data_serv['serv_anexo1_path'];
					$evento['cal_anexo1_nombre']=$data_serv['serv_anexo1_nombre'];
					}
					if (strlen($data_serv['serv_anexo2_path'])>0)
					{
					$evento['cal_anexo2_path']=$data_serv['serv_anexo2_path'];
					$evento['cal_anexo2_nombre']=$data_serv['serv_anexo2_nombre'];	
					}
					if (strlen($data_serv['serv_anexo3_path'])>0)
					{
					$evento['cal_anexo3_path']=$data_serv['serv_anexo3_path'];
					$evento['cal_anexo3_nombre']=$data_serv['serv_anexo3_nombre'];	
					}
					if (strlen($data_serv['serv_anexo4_path'])>0)
					{
					$evento['cal_anexo4_path']=$data_serv['serv_anexo4_path'];
					$evento['cal_anexo4_nombre']=$data_serv['serv_anexo4_nombre'];
					}
				}			
				
				if  (
					  ($servicio['serv_estatus_cve'] == 'CONCLUIDO') &&
					  ($factudado>1)
					)
				{
					$data_serv['serv_estatus_cve'] ='FIN';
					$data_serv['cei_id']=$servicio['cei_id'];
					$data_serv['cei_control_id']=$servicio['cei_control_id'];
					
				}
				elseif  (
					  ($servicio['serv_estatus_cve'] == 'CONCLUIDO') &&
					  ($factudado<2)
					)
				{
					$continuar=0;
				}	
				
				if  ($servicio['serv_estatus_cve'] == 'FIN') 
				{				
					if ($this->input->post('pagado') == 'SI')
					{
						$data_serv['serv_estatus_cve'] ='PAGADO';
						$data_serv['serv_fecha_pago'] =date("Y-m-d H:i:s");
						$data_serv['cei_control_id']=$servicio['cei_control_id'];
						$data_serv['serv_ubicacion'] = $servicio['serv_ubicacion'];
					}	
					
					$data_serv['cei_id']=$servicio['cei_id'];
				}
				
				
				if ($continuar==1)
				{
					if ($this->servicio->update($serv_id,$data_serv))
					{					
						if ($servicio['cal_id'] > 0)
						{
							$cal_id = $this->agenda->update_evento($servicio['cal_id'],$evento);
						
						}					
						//inserta las obervaciones
						if($this->input->post('obervaciones') != '')
						{
							$data_serv_obs['serv_id'] = $serv_id;
							$data_serv_obs['usr_id'] = $medico['usr_id'];
							$data_serv_obs['nota_f'] = date('Y-m-d H:i:s');
							$data_serv_obs['nota_descripcion'] = $this->input->post('obervaciones');
							$this->servicio->inserta_nota(array_to_upper($data_serv_obs));
						}
						
						/*************************************************************************************/                   
						/*                  Nueva estructura para examenes y paquetes asignados              */					
						/*************************************************************************************/   
						
						if 
						(
							($data_serv['serv_estatus_cve'] == 'PROCESO')
						)
						{
							$this->servicio->delete_examenes($serv_id);	
							
							$serv_emp=$this->servicio->get_serv_emp($serv_id);
											
							$fsm_pakts= get_costos_paquetes_empresa($serv_emp['emp_id']);
							
							$total_examenes_selectos= $this->input->post('total_examenes_selectos');	

							
							if($fsm_pakts):
								$paquetes='';
								foreach($fsm_pakts as $fsm_pakt): 
											
										for($i=1; $i <= $total_examenes_selectos; $i++)
										{	
											
											$indice='examen_select_pkt_'.strval($i);
											$cost_id = $this->input->post($indice);	
												
											if ( $fsm_pakt['cost_id'] === $cost_id)
											{
												$examen_ins['exam_nombre_pkt'] = $fsm_pakt['cost_nombre_pkt']; //nombre del paquete
												$examen_ins['serv_id'] = $serv_id;
												$examen_ins['exam_cve'] = $fsm_pakt['cost_examen_cve']; //lo que contiene el paquete
												$paquetes.=$fsm_pakt['cost_nombre_pkt'].';';
												$examen_ins['exam_monto'] = $fsm_pakt['cost_monto']; //lo que contiene el paquete								 	 
												$examen_ins['exam_cantidad'] = 1;
												$examen_ins['exam_estatus_cve'] = 'PEND';
												$examen_ins['exam_tipo_pkt'] = $fsm_pakt['cost_tipo_pkt'];
												$this->servicio->inserta_examen($examen_ins);
												//$i=$total_examenes_selectos+1;
											}										
											
										}	
								endforeach;
							endif;
							$evento['cal_pkts']=$paquetes;
						}
							
						if ($servicio['cal_id'] > 0)
						{
							$cal_id = $this->agenda->update_evento($servicio['cal_id'],$evento);
						
						}

	/*************************************************************************************/                   
	/*                  Solo en caso de concluir la orden de servicios                   */					
	/*************************************************************************************/   

						if  (($data_serv['serv_estatus_cve'] == 'CONCLUIDO') ||
							 ($data_serv['serv_estatus_cve'] == 'FTIEMPOCON'))
						{
							$this->load->helper('mail');
							$data_email['serv'] = $this->servicio->get($serv_id);
							$data_email['personas'] = $this->servicio->get_examenes_serv($serv_id);
							$data_email['clientes'] = $this->servicio->get_examenes_serv($serv_id);
							$html = $this->load->view('agenda/email_service_concluido',$data_email,TRUE);
							//$html='<br>';
							$servicior = $this->servicio->get($serv_id);
							send_mail_service_concluido($servicior, $html,$this->input->post('cei') );
						}
	/*************************************************************************************/ 

	/*************************************************************************************/                   
	/*                  Solo en caso de Facturar la orden de servicios                   */					
	/*************************************************************************************/ 
						if  ($data_serv['serv_estatus_cve'] == 'FIN')
						{
							$this->load->helper('mail');
							$data_email['serv'] = $this->servicio->get($serv_id);
							$data_email['personas'] = $this->servicio->get_examenes_serv($serv_id);
							$data_email['clientes'] = $this->servicio->get_examenes_serv($serv_id);
							$data_email['emp_id'] = $this->input->post('emp_id');							
							$html = $this->load->view('agenda/email_service_facturado',$data_email,TRUE);
							$servicior = $this->servicio->get($serv_id);
							send_mail_service_facturado($servicior, $html,$this->input->post('cei') );
						
						}
	/*************************************************************************************/ 	
						send_json_ok('Se actualizó de forma correcta');
					}
					else
					{
						send_json_error('Ocurrió un error al actualizar el servicio.');
					}
				
				}
				else
				{
					
					send_json_error('Ocurrió un error, faltan los archivos de facturación.');
				}	
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['serv'] = $servicio;
            //echo 'B';
            $data['examenes'] = $this->servicio->get_examenes($serv_id);
			//echo 'C';
            $data['notas'] = $this->servicio->get_notas($serv_id);
			//echo 'D';
            $data['anexos'] = $this->servicio->get_anexos($serv_id);
            //echo 'E';
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Servicios',
                'view' => 'servicio/edit_ordenes',
                'view_data' => $data
               );
			//echo 'F';
            render_template($params_view);  
        }
    }
	

 
  
    public function edita_a($serv_id)
    {
       $servicio = $this->servicio->get($serv_id);
	   $medico = $this->session->user;
	   $usuario = $this->medico->get($medico['usr_id']);
       //echo 'A';
	   if(isset($_POST) && count($_POST) > 0)     
        {	$continuar=1;
            
            $this->load->library('form_validation');
			
			if (
				( ($servicio['serv_estatus_cve'] == 'CONCLUIDO') && ($medico['usr_id'] != 261) )
				/* ||
				( ($servicio['serv_estatus_cve'] == 'PREPAGADO') && ($servicio['serv_factura_path'] == '') &&  ($servicio['serv_xml_path'] == '') )
 			    */
			    )
			{
				$this->form_validation->set_rules('cantidad_facturada','Cantidad Facturada (sin iva)','required');
				$this->form_validation->set_rules('estatus','Estatus','required');
			}
			elseif ($servicio['serv_estatus_cve'] == 'FIN') 
			{
				$this->form_validation->set_rules('estatus','Estatus','required');
			}				
			else
			{	
				$this->form_validation->set_rules('orden','Pedido','required');
				//$this->form_validation->set_rules('emp_id','Empresa','required');
				$this->form_validation->set_rules('f_ini','Fecha inicio','required');
				$this->form_validation->set_rules('h_ini','Hora inicio','required');
				$this->form_validation->set_rules('f_fin','Fecha fin','required');
				$this->form_validation->set_rules('h_fin','Hora fin','required');
				$this->form_validation->set_rules('descrip','Descripción','required');
				//$this->form_validation->set_rules('ubicacion','Ubicación','required');
				//$this->form_validation->set_rules('responsable','Responsable','required');
				$this->form_validation->set_rules('estatus','Estatus','required');
			}

            if($this->form_validation->run())
            {
               
				$hoy='';
				$factudado=0;
				
				if 	(					
						($servicio['serv_estatus_cve'] == 'PREPAGADO') 
						&&
						(!empty($_FILES['factura']['name']))
						&&
						(!empty($_FILES['xml']['name']))
					)
				{
					
					$data_serv['serv_cantidad_facturada'] = $this->input->post('cantidad_facturada');
					$data_serv['serv_quien_factura'] = $medico['usr_nombre'].' '.$medico['usr_paterno'];
					$data_serv['serv_fecha_factura'] = date("Y-m-d H:i:s");
					$data_serv['serv_estatus_cve'] = $this->input->post('estatus');
					$data_serv['serv_f_inicio'] = $fecha_ini=$servicio['serv_f_inicio'];
					$data_serv['serv_f_fin'] = $fecha_fin=$servicio['serv_f_inicio'];
					
					//$hoy='HC_'.$servicio['emp_id'].'_'.date("dmY_His").'_';
					$data_serv['serv_ubicacion'] = $servicio['serv_ubicacion'];
					if(!empty($_FILES['factura']['name']))
					{
						$nombre_anexo=$_FILES['factura']['name'];
						$this->load->library('upload');
						$filename = md5(time());
						$config = array(
								'upload_path'   => './../../files/facturas/',
								'overwrite'     => TRUE,
								'file_name'     => $filename,
								'allowed_types' => 'pdf',
								'max_size'      => '10000'
						);

						$this->upload->initialize($config);
						if ( ! $this->upload->do_upload('factura'))
						{
							echo json_encode(array('status' => 'error','content' => $this->upload->display_errors()));
							exit;
						}
						else 
						{
							$data = $this->upload->data();
							$data_serv['serv_factura_nombre'] = $data['file_name'];
							$data_serv['serv_factura_path '] = $nombre_anexo;
							$factudado++;
						}
					}
					

					if(!empty($_FILES['xml']['name']))
					{
						$nombre_anexo=$_FILES['xml']['name'];
						$this->load->library('upload');
						$filename = md5(time());
						$config = array(
								'upload_path'   => './../../files/facturas/',
								'overwrite'     => TRUE,
								'file_name'     => $filename,
								'allowed_types' => 'xml',
								'max_size'      => '10000'
						);

						$this->upload->initialize($config);
						if ( ! $this->upload->do_upload('xml'))
						{
							echo json_encode(array('status' => 'error','content' => $this->upload->display_errors()));
							exit;
						}
						else 
						{
							$data = $this->upload->data();
							$data_serv['serv_xml_nombre'] = $data['file_name'];
							$data_serv['serv_xml_path '] = $nombre_anexo;
							$factudado++;
						}
					}					
					
					
				}elseif ($servicio['serv_estatus_cve'] == 'CONCLUIDO') 
				{
					
					$data_serv['serv_cantidad_facturada'] = $this->input->post('cantidad_facturada');
					$data_serv['serv_quien_factura'] = $medico['usr_nombre'].' '.$medico['usr_paterno'];
					$data_serv['serv_fecha_factura'] = date("Y-m-d H:i:s");
					$data_serv['serv_estatus_cve'] = $this->input->post('estatus');
					$data_serv['serv_f_inicio'] = $fecha_ini=$servicio['serv_f_inicio'];
					$data_serv['serv_f_fin'] = $fecha_fin=$servicio['serv_f_inicio'];
					
					//$hoy='HC_'.$servicio['emp_id'].'_'.date("dmY_His").'_';
					$data_serv['serv_ubicacion'] = $servicio['serv_ubicacion'];
					if(!empty($_FILES['factura']['name']))
					{
						$nombre_anexo=$_FILES['factura']['name'];
						$this->load->library('upload');
						$filename = md5(time());
						$config = array(
								'upload_path'   => './../../files/facturas/',
								'overwrite'     => TRUE,
								'file_name'     => $filename,
								'allowed_types' => 'pdf',
								'max_size'      => '10000'
						);

						$this->upload->initialize($config);
						if ( ! $this->upload->do_upload('factura'))
						{
							echo json_encode(array('status' => 'error','content' => $this->upload->display_errors()));
							exit;
						}
						else 
						{
							$data = $this->upload->data();
							$data_serv['serv_factura_nombre'] = $data['file_name'];
							$data_serv['serv_factura_path '] = $nombre_anexo;
							$factudado++;
						}
					}
					

					if(!empty($_FILES['xml']['name']))
					{
						$nombre_anexo=$_FILES['xml']['name'];
						$this->load->library('upload');
						$filename = md5(time());
						$config = array(
								'upload_path'   => './../../files/facturas/',
								'overwrite'     => TRUE,
								'file_name'     => $filename,
								'allowed_types' => 'xml',
								'max_size'      => '10000'
						);

						$this->upload->initialize($config);
						if ( ! $this->upload->do_upload('xml'))
						{
							echo json_encode(array('status' => 'error','content' => $this->upload->display_errors()));
							exit;
						}
						else 
						{
							$data = $this->upload->data();
							$data_serv['serv_xml_nombre'] = $data['file_name'];
							$data_serv['serv_xml_path '] = $nombre_anexo;
							$factudado++;
						}
					}					
					
					
				}
				else
				{			   
					//$fecha_ini = formatea_fechahora_mysql($this->input->post('f_ini').' '.$this->input->post('h_ini'));
					//$fecha_fin = formatea_fechahora_mysql($this->input->post('f_fin').' '.$this->input->post('h_fin'));
					$fecha_ini = $this->input->post('f_ini').' '.formatea_hora_mysql($this->input->post('h_ini'));
					$fecha_fin = $this->input->post('f_fin').' '.formatea_hora_mysql($this->input->post('h_fin'));					
					$data_serv['serv_orden'] = $this->input->post('orden');
					//$data_serv['emp_id'] = $this->input->post('emp_id');
					//$data_serv['usr_id'] = $medico['usr_id'];
					$data_serv['serv_f_inicio'] = $fecha_ini;
					$data_serv['serv_f_fin'] = $fecha_fin;
					$data_serv['serv_desc'] = $this->input->post('descrip');
					$data_serv['serv_ubicacion'] = $this->input->post('ubicacion');
					$data_serv['serv_contacto_per'] = $this->input->post('responsable');
					$data_serv['serv_contacto_tel'] = limpia_telefono($this->input->post('telefono'));
					$data_serv['serv_acuerdos'] = $this->input->post('clausulas');                
					$data_serv['serv_estatus_cve'] = $this->input->post('estatus');
					$data_serv['cei_id'] = $this->input->post('cei');
					$data_serv['cei_control_id'] = $this->input->post('cei_control');
					$data_serv['reclutador'] = $this->input->post('reclutador');					
					
					$data_serv['serv_viaticos'] = $this->input->post('viaticos');
					if ( $data_serv['serv_viaticos'] == 0)
					{
						$data_serv['serv_costo_viaticos'] = 0.00;
					}
					else
					{	
						$data_serv['serv_costo_viaticos'] = $this->input->post('gastos_operacion');
					}
					
					$data_serv=array_to_upper($data_serv);
				}				
				
				

				/******NUEVOS ARCHIVO ANEXO     ***/				
				if(!empty($_FILES['anexo']['name']))
				{
					$nombre_anexo=$_FILES['anexo']['name'];
					$this->load->library('upload');
					$filename = md5(time());
					$config = array(
							'upload_path'   => './../../files/anexos/',
							'overwrite'     => TRUE,
							'file_name'     => $filename,
							'allowed_types' => 'doc|docx|pdf|txt|xlsx|xls|png|jpg|jpeg',
							'max_size'      => '10000'
					);

					$this->upload->initialize($config);
					if ( ! $this->upload->do_upload('anexo'))
					{
						echo json_encode(array('status' => 'error','content' => $this->upload->display_errors()));
						exit;
					}
					else 
					{
						$data = $this->upload->data();
						$data_serv['serv_anexo_path'] = $data['file_name'];
						$data_serv['serv_anexo_nombre'] = $nombre_anexo;
					}
				}
				else 
				{								
					//$data_serv['serv_anexo_path'] = '';
					//$data_serv['serv_anexo_nombre'] = '';
				}	
				
				/******NUEVOS ARCHIVO ANEXO 1 ******/
                if(!empty($_FILES['anexo1']['name']))
                {
					$nombre_anexo=$_FILES['anexo1']['name'];
                    $this->load->library('upload');
					
					sleep(1);
                    $filename1 = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/anexos/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename1,
                            'allowed_types' => 'doc|docx|pdf|txt|xlsx|xls|png|jpg|jpeg',
                            'max_size'      => '10000'
                    );

                    $this->upload->initialize($config);
					
                    if ( ! $this->upload->do_upload('anexo1'))
                    {
                        echo json_encode(array('status' => 'error','content' => $this->upload->display_errors()));
                        exit;
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_serv['serv_anexo1_path'] = $data['file_name'];
						$data_serv['serv_anexo1_nombre'] = $nombre_anexo;
                    }
                }
				else 
				{
					//$data_serv['serv_anexo1_path'] = '';
					//$data_serv['serv_anexo1_nombre'] = '';
				}
			
				/******NUEVOS ARCHIVO ANEXO 2 ******/
                if(!empty($_FILES['anexo2']['name']))
                {
					$nombre_anexo=$_FILES['anexo2']['name'];
                    $this->load->library('upload');
					
					sleep(1);
                    $filename2 = md5(time());
                    $config2 = array(
                            'upload_path'   => './../../files/anexos/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename2,
                            'allowed_types' => 'doc|docx|pdf|txt|xlsx|xls|png|jpg|jpeg',
                            'max_size'      => '10000'
                    );

                    $this->upload->initialize($config2);
					
                    if ( ! $this->upload->do_upload('anexo2'))
                    {
                        echo json_encode(array('status' => 'error','content' => $this->upload->display_errors()));
                        exit;
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_serv['serv_anexo2_path'] = $data['file_name'];
						$data_serv['serv_anexo2_nombre'] = $nombre_anexo;
                    }
                }
				else 
				{
					//$data_serv['serv_anexo2_path'] = '';
					//$data_serv['serv_anexo2_nombre'] = '';
				}
				
				/******NUEVOS ARCHIVO ANEXO 3 ******/
                if(!empty($_FILES['anexo3']['name']))
                {
					$nombre_anexo=$_FILES['anexo3']['name'];
                    $this->load->library('upload');
					
					sleep(1);
                    $filename3 = md5(time());
                    $config3 = array(
                            'upload_path'   => './../../files/anexos/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename3,
                            'allowed_types' => 'doc|docx|pdf|txt|xlsx|xls|png|jpg|jpeg',
                            'max_size'      => '10000'
                    );

                    $this->upload->initialize($config3);
					
                    if ( ! $this->upload->do_upload('anexo3'))
                    {
                        echo json_encode(array('status' => 'error','content' => $this->upload->display_errors()));
                        exit;
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_serv['serv_anexo3_path'] = $data['file_name'];
						$data_serv['serv_anexo3_nombre'] = $nombre_anexo;
						
                    }
                }
				else 
				{
					//$data_serv['serv_anexo3_path'] = '';
					//$data_serv['serv_anexo3_nombre'] = '';
				}

				/******NUEVOS ARCHIVO ANEXO 4 *****/
                if(!empty($_FILES['anexo4']['name']))
                {
					$nombre_anexo=$_FILES['anexo4']['name'];
                    $this->load->library('upload');
					
					sleep(1);
                    $filename4 = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/anexos/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename4,
                            'allowed_types' => 'doc|docx|pdf|txt|xlsx|xls|png|jpg|jpeg',
                            'max_size'      => '10000'
                    );

                    $this->upload->initialize($config);
					
                    if ( ! $this->upload->do_upload('anexo4'))
                    {
                        echo json_encode(array('status' => 'error','content' => $this->upload->display_errors()));
                        exit;
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_serv['serv_anexo4_path'] = $data['file_name'];
						$data_serv['serv_anexo4_nombre'] = $nombre_anexo;
                    }
                }
				else 
				{
					//$data_serv['serv_anexo4_path'] = '';
					//$data_serv['serv_anexo4_nombre'] = '';
				}

				
				/**********************************************************/
				//$data_serv['cal_id'] = $this->input->post('cal_id');
				if ($servicio['cal_id'] > 0)
				{
					$evento = $this->agenda->get_evento($servicio['cal_id']);				
					
					$evento['serv_orden']=$data_serv['serv_orden'];
					
					$evento['cal_fecha_ini']=$data_serv['serv_f_inicio'] = $fecha_ini;
					$evento['cal_fecha_fin']=$data_serv['serv_f_fin'] = $fecha_fin;
					
					$evento['cal_descripcion'] = $this->input->post('descrip');
					
					if (strlen($data_serv['serv_anexo_path'])>0)
					{	
					$evento['cal_anexo_path']=$data_serv['serv_anexo_path'];
					$evento['cal_anexo_nombre']=$data_serv['serv_anexo_nombre'];
					}
					if (strlen($data_serv['serv_anexo1_path'])>0)
					{
					$evento['cal_anexo1_path']=$data_serv['serv_anexo1_path'];
					$evento['cal_anexo1_nombre']=$data_serv['serv_anexo1_nombre'];
					}
					if (strlen($data_serv['serv_anexo2_path'])>0)
					{
					$evento['cal_anexo2_path']=$data_serv['serv_anexo2_path'];
					$evento['cal_anexo2_nombre']=$data_serv['serv_anexo2_nombre'];	
					}
					if (strlen($data_serv['serv_anexo3_path'])>0)
					{
					$evento['cal_anexo3_path']=$data_serv['serv_anexo3_path'];
					$evento['cal_anexo3_nombre']=$data_serv['serv_anexo3_nombre'];	
					}
					if (strlen($data_serv['serv_anexo4_path'])>0)
					{
					$evento['cal_anexo4_path']=$data_serv['serv_anexo4_path'];
					$evento['cal_anexo4_nombre']=$data_serv['serv_anexo4_nombre'];
					}
				}			
				
				if  (
					  ($servicio['serv_estatus_cve'] == 'CONCLUIDO') &&
					  ($factudado>1)
					)
				{
					$data_serv['serv_estatus_cve'] ='FIN';
					$data_serv['cei_id']=$servicio['cei_id'];
					$data_serv['cei_control_id']=$servicio['cei_control_id'];
					
				}
				elseif  (
					  ($servicio['serv_estatus_cve'] == 'CONCLUIDO') &&
					  ($factudado<2)
					)
				{
					$continuar=0;
				}	
				
				if  (($servicio['serv_estatus_cve'] == 'FIN'|| ($servicio['serv_estatus_cve'] == 'FINAL')) )
				{				
					if ($this->input->post('pagado') == 'SI')
					{
						$data_serv['serv_estatus_cve'] ='PAGADO';
						$data_serv['serv_fecha_pago'] =date("Y-m-d H:i:s");
						$data_serv['cei_control_id']=$servicio['cei_control_id'];
						$data_serv['serv_ubicacion'] = $servicio['serv_ubicacion'];
					}	
					
					$data_serv['cei_id']=$servicio['cei_id'];
				}
				
				
				if (($continuar==0)  && ($medico['usr_id'] == 261))
				{
					$continuar=1;
				}
				
				if ($continuar==1)
				{
					if ($this->servicio->update($serv_id,$data_serv))
					{					
						if ($servicio['cal_id'] > 0)
						{
							$cal_id = $this->agenda->update_evento($servicio['cal_id'],$evento);
						
						}					
						//inserta las obervaciones
						if($this->input->post('obervaciones') != '')
						{
							$data_serv_obs['serv_id'] = $serv_id;
							$data_serv_obs['usr_id'] = $medico['usr_id'];
							$data_serv_obs['nota_f'] = date('Y-m-d H:i:s');
							$data_serv_obs['nota_descripcion'] = $this->input->post('obervaciones');
							$this->servicio->inserta_nota(array_to_upper($data_serv_obs));
						}
						
						/*************************************************************************************/                   
						/*                  Nueva estructura para examenes y paquetes asignados              */					
						/*************************************************************************************/   
						
						if 
						(
							($data_serv['serv_estatus_cve'] == 'PROCESO')
						)
						{
							$this->servicio->delete_examenes($serv_id);	
							
							$serv_emp=$this->servicio->get_serv_emp($serv_id);
											
							$fsm_pakts= get_costos_paquetes_empresa($serv_emp['emp_id']);
							
							$total_examenes_selectos= $this->input->post('total_examenes_selectos');	

							
							if($fsm_pakts):
								$paquetes='';
								foreach($fsm_pakts as $fsm_pakt): 
											
										for($i=1; $i <= $total_examenes_selectos; $i++)
										{	
											
											$indice='examen_select_pkt_'.strval($i);
											$cost_id = $this->input->post($indice);	
												
											if ( $fsm_pakt['cost_id'] === $cost_id)
											{
												$examen_ins['exam_nombre_pkt'] = $fsm_pakt['cost_nombre_pkt']; //nombre del paquete
												$examen_ins['serv_id'] = $serv_id;
												$examen_ins['exam_cve'] = $fsm_pakt['cost_examen_cve']; //lo que contiene el paquete
												$paquetes.=$fsm_pakt['cost_nombre_pkt'].';';
												$examen_ins['exam_monto'] = $fsm_pakt['cost_monto']; //lo que contiene el paquete								 	 
												$examen_ins['exam_cantidad'] = 1;
												$examen_ins['exam_estatus_cve'] = 'PEND';
												$examen_ins['exam_tipo_pkt'] = $fsm_pakt['cost_tipo_pkt'];
												$this->servicio->inserta_examen($examen_ins);
												//$i=$total_examenes_selectos+1;
											}										
											
										}	
								endforeach;
							endif;
							$evento['cal_pkts']=$paquetes;
						}
							
						if ($servicio['cal_id'] > 0)
						{
							$cal_id = $this->agenda->update_evento($servicio['cal_id'],$evento);
						
						}

	/*************************************************************************************/                   
	/*                  Solo en caso de concluir la orden de servicios                   */					
	/*************************************************************************************/   

						if  (($data_serv['serv_estatus_cve'] == 'CONCLUIDO') ||
							 ($data_serv['serv_estatus_cve'] == 'FTIEMPOCON'))
						{
							$this->load->helper('mail');
							$data_email['serv'] = $this->servicio->get($serv_id);
							$data_email['personas'] = $this->servicio->get_examenes_serv($serv_id);
							$data_email['clientes'] = $this->servicio->get_examenes_serv($serv_id);
							$html = $this->load->view('agenda/email_service_concluido',$data_email,TRUE);
							//$html='<br>';
							$servicior = $this->servicio->get($serv_id);
							send_mail_service_concluido($servicior, $html,$this->input->post('cei') );
						}
	/*************************************************************************************/ 

	/*************************************************************************************/                   
	/*                  Solo en caso de Facturar la orden de servicios                   */					
	/*************************************************************************************/ 
						if  ($data_serv['serv_estatus_cve'] == 'FIN')
						{
							$this->load->helper('mail');
							$data_email['serv'] = $this->servicio->get($serv_id);
							$data_email['personas'] = $this->servicio->get_examenes_serv($serv_id);
							$data_email['clientes'] = $this->servicio->get_examenes_serv($serv_id);
							$data_email['emp_id'] = $this->input->post('emp_id');							
							$html = $this->load->view('agenda/email_service_facturado',$data_email,TRUE);
							$servicior = $this->servicio->get($serv_id);
							send_mail_service_facturado($servicior, $html,$this->input->post('cei') );
						
						}
	/*************************************************************************************/ 	
						send_json_ok('Se actualizó de forma correcta');
					}
					else
					{
						send_json_error('Ocurrió un error al actualizar el servicio.');
					}
				
				}
				else
				{
					//**QUIERO QUE SI ENTRAMOS AL ELSE, SI EL ESTATUS ES FINAL, SE SALTE ESTO, PERO SI NO ES FINAL, QUE SI CONSIDERE EL SEND_JSON_ERROR */

					if ((($servicio['serv_estatus_cve'] == 'FINAL')) )
					{
						send_json_ok('Se actualizó de forma correcta');
					}
					else
					{
						send_json_error('Ocurrió un error, faltan los archivos de facturación.');
					}
				}
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['serv'] = $servicio;
            //echo 'B';
            $data['examenes'] = $this->servicio->get_examenes($serv_id);
			//echo 'C';
            $data['notas'] = $this->servicio->get_notas($serv_id);
			//echo 'D';
            $data['anexos'] = $this->servicio->get_anexos($serv_id);
            //echo 'E';
			$data['usuario']=$usuario;
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Servicios',
                'view' => 'servicio/edit_a',
                'view_data' => $data
               );
			//echo 'F';
            render_template($params_view);  
        }
    }


/************************************************************************************/   
    public function nuevo()
    {
        if(isset($_POST) && count($_POST) > 0)     
        {
            $medico = $this->session->user;
            $this->load->library('form_validation');
            $this->form_validation->set_rules('orden','Pedido','required');
            $this->form_validation->set_rules('emp_id','Empresa','required');
            $this->form_validation->set_rules('f_ini','Fecha inicio','required');
            $this->form_validation->set_rules('h_ini','Hora inicio','required');
            $this->form_validation->set_rules('f_fin','Fecha fin','required');
            $this->form_validation->set_rules('h_fin','Hora fin','required');
            $this->form_validation->set_rules('descrip','Descripción','required');
            $this->form_validation->set_rules('ubicacion','Ubicación','required');
            $this->form_validation->set_rules('responsable','Responsable','required');
            $this->form_validation->set_rules('estatus','Estatus','required');

            if($this->form_validation->run())
            {
                $fecha_ini = formatea_fechahora_mysql($this->input->post('f_ini').' '.$this->input->post('h_ini'));
                $fecha_fin = formatea_fechahora_mysql($this->input->post('f_fin').' '.$this->input->post('h_fin'));
                
                $data_serv['serv_orden'] = $this->input->post('orden');
                $data_serv['emp_id'] = $this->input->post('emp_id');
                $data_serv['usr_id'] = $medico['usr_id'];
                $data_serv['serv_f_inicio'] = $fecha_ini;
                $data_serv['serv_f_fin'] = $fecha_fin;
                $data_serv['serv_desc'] = $this->input->post('descrip');
                $data_serv['serv_ubicacion'] = $this->input->post('ubicacion');
                $data_serv['serv_contacto_per'] = $this->input->post('responsable');
                $data_serv['serv_contacto_tel'] = limpia_telefono($this->input->post('telefono'));
                $data_serv['serv_acuerdos'] = $this->input->post('clausulas');
                $data_serv['serv_estatus_cve'] = $this->input->post('estatus');
				$data_serv['cei_id'] = $this->input->post('cei');
				
				if ($this->input->post('folio_calendario') == "Sin Folio")
				{
					$data_serv['cal_folio'] = 0;
				}
				else
				{
					$data_serv['cal_folio'] = $this->input->post('folio_calendario');
				}
				
				$data_serv['desp_id'] = $this->input->post('despachos');
				
				$data_serv['reclutador'] = $this->input->post('reclutador');
				
				//$folio_solictud_servicio= $this->input->post('folio_calendario');
                
                $examenes = $this->input->post('examen');
                if(count($examenes) > 0)
                {
                    $serv_id = $this->servicio->inserta(array_to_upper($data_serv));
                    if($serv_id)
                    {
                        //inserta las obervaciones
                        if($this->input->post('obervaciones') != '')
                        {
                            $data_serv_obs['serv_id'] = $serv_id;
                            $data_serv_obs['usr_id'] = $medico['usr_id'];
                            $data_serv_obs['nota_f'] = date('Y-m-d H:i:s');
                            $data_serv_obs['nota_descripcion'] = $this->input->post('obervaciones');
                            $this->servicio->inserta_nota(array_to_upper($data_serv_obs));
                        }

                        //inserta los anexos
                        $file = 0;
                        $array_anexos = array();
                        foreach ($_FILES['anexo']['name'] as $filename)
                        {
                            $tmp = $_FILES['anexo']['tmp_name'][$file];
                            $file_name = substr($filename, 0, 30);
                            $file_name_path = md5(time().$filename).get_extension($filename);
                            $path = './../../files/anexos/'.$file_name_path;
                            $array_anexos[$file]['anexo_nombre'] = $file_name;
                            $array_anexos[$file]['anexo_path'] = $file_name_path;
                            $array_anexos[$file]['serv_id'] = $serv_id;
                            move_uploaded_file($tmp,$path);
                            $file++;
                        }
                        $this->servicio->inserta_anexos($array_anexos);

                        //inserta los examanes
                        $this->servicio->inserta_examenes($this->input->post('examen'), $serv_id);
                        
                        //se crea la cita
                        $params = array(
                            'cal_fecha' => date('Y-m-d'),
                            'cal_titulo' => 'Orden de Servicio: '.$serv_id.' | '.'Pedido:'.$this->input->post('orden').' | '.get_empresa($this->input->post('emp_id')),
                            'cal_servicio' => NULL,
                            'cal_descripcion' => $this->input->post('descrip'),
                            'cal_fecha_ini' => $fecha_ini,
                            'cal_fecha_fin' => $fecha_fin,
                            'cal_uid' => uniqid(rand(0, getmypid())),
                            'cal_lugar' => $this->input->post('ubicacion'),
                            'emp_id' => $this->input->post('emp_id'),
							'cal_cei' => $this->input->post('cei')
                        );
                        $this->load->model('util/Agenda_model','agenda');
						
						//si no se ha creado aun en funcion de $this->input->post('folio_de_solicitud');
                        						
						//$cal_id = $this->agenda->add_evento(array_to_upper($params));	
						$cal_id = $this->agenda->add_evento_folio_en_servicio(array_to_upper($params));						
						
						$this->servicio->update_cal_id($serv_id,$cal_id);							
							
						$this->load->helper('mail');
						//se usa el cal_id generado o el proporcionado por el usuario
                        $evento = $this->agenda->get_evento($cal_id);
						
                        $data_email = array('evento' => $evento, 
											'cal_id' => $cal_id, 
											'despacho' => $this->input->post('despachos'));
						
                        $html = $this->load->view('agenda/email_add_std_event',$data_email,TRUE);
                        
						send_mail_std_event($this->input->post('mail'), $evento, $html,$this->input->post('cei'));
                        
						
						send_json_ok('Se guardó de forma correcta la orden de servicio.');
                    }
                    else
                    {
                        send_json_error('Ocurrió un error al guardar el servicio.');
                    }
                }
                else 
                {
                    send_json_error('Agregue al menos un examen para realizar.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $this->load->helper('template');
			//nuevo para despachos
			$data['despachos'] = $this->cliente->get_despachos();

            $params_view = array(
                'title' => 'Servicios',
                'view' => 'servicio/add',
				'view_data' => $data
               );
            render_template($params_view);  
        }
    }
    
 
     public function edita($serv_id)
    {
        $servicio = $this->servicio->get($serv_id);
       
	   if(isset($_POST) && count($_POST) > 0)     
        {
            $medico = $this->session->user;
            $this->load->library('form_validation');
            $this->form_validation->set_rules('orden','Pedido','required');
            //$this->form_validation->set_rules('emp_id','Empresa','required');
            $this->form_validation->set_rules('f_ini','Fecha inicio','required');
            $this->form_validation->set_rules('h_ini','Hora inicio','required');
            $this->form_validation->set_rules('f_fin','Fecha fin','required');
            $this->form_validation->set_rules('h_fin','Hora fin','required');
            $this->form_validation->set_rules('descrip','Descripción','required');
            $this->form_validation->set_rules('ubicacion','Ubicación','required');
            $this->form_validation->set_rules('responsable','Responsable','required');
            $this->form_validation->set_rules('estatus','Estatus','required');

            if($this->form_validation->run())
            {
                $fecha_ini = formatea_fechahora_mysql($this->input->post('f_ini').' '.$this->input->post('h_ini'));
                $fecha_fin = formatea_fechahora_mysql($this->input->post('f_fin').' '.$this->input->post('h_fin'));
                
                $data_serv['serv_orden'] = $this->input->post('orden');
                //$data_serv['emp_id'] = $this->input->post('emp_id');
                //$data_serv['usr_id'] = $medico['usr_id'];
                $data_serv['serv_f_inicio'] = $fecha_ini;
                $data_serv['serv_f_fin'] = $fecha_fin;
                $data_serv['serv_desc'] = $this->input->post('descrip');
                $data_serv['serv_ubicacion'] = $this->input->post('ubicacion');
                $data_serv['serv_contacto_per'] = $this->input->post('responsable');
                $data_serv['serv_contacto_tel'] = limpia_telefono($this->input->post('telefono'));
                $data_serv['serv_acuerdos'] = $this->input->post('clausulas');
                /*************************************************************/
			    $data_serv['serv_estatus_cve'] = $this->input->post('estatus');
				/*************************************************************/
				$data_serv['cei_id'] = $this->input->post('cei');
                
				$data_serv['reclutador'] = $this->input->post('reclutador');
				
                if($this->servicio->update($serv_id, array_to_upper($data_serv)))
                {
                    //inserta las obervaciones
                    if($this->input->post('obervaciones') != '')
                    {
                        $data_serv_obs['serv_id'] = $serv_id;
                        $data_serv_obs['usr_id'] = $medico['usr_id'];
                        $data_serv_obs['nota_f'] = date('Y-m-d H:i:s');
                        $data_serv_obs['nota_descripcion'] = $this->input->post('obervaciones');
                        $this->servicio->inserta_nota(array_to_upper($data_serv_obs));
                    }
                    
                    //inserta los anexos
                    $file = 0;
                    $array_anexos = array();
                    foreach ($_FILES['anexo']['name'] as $filename)
                    {
                        if( ! empty($filename))
                        {
                            $tmp = $_FILES['anexo']['tmp_name'][$file];
                            $file_name = substr($filename, 0, 30);
                            $file_name_path = md5(time().$filename).get_extension($filename);
                            $path = './../../files/servicios/'.$file_name_path;
                            $array_anexos[$file]['anexo_nombre'] = $file_name;
                            $array_anexos[$file]['anexo_path'] = $file_name_path;
                            $array_anexos[$file]['serv_id'] = $serv_id;
                            move_uploaded_file($tmp,$path);
                        }
                        $file++;
                    }
                    if( !empty($array_anexos))
                    {
                        $this->servicio->inserta_anexos($array_anexos);
                    } 
                    
                    //inserta los examanes
                    $this->servicio->inserta_examenes($this->input->post('examen'), $serv_id);
/*************************************************************************************/                   
/*                  Solo en caso de concluir la orden de servicios                   */					
/*************************************************************************************/   

					if  (($data_serv['serv_estatus_cve'] == 'CONCLUIDO') ||
						 ($data_serv['serv_estatus_cve'] == 'FTIEMPOCON'))
					{
						$this->load->helper('mail');
						$data_email['serv'] = $this->servicio->get($serv_id);
						$data_email['personas'] = $this->servicio->get_examenes_serv($serv_id);
						$data_email['clientes'] = $this->servicio->get_examenes_serv($serv_id);
						//$data_email['emp_id'] = $this->input->post('emp_id');
                        $html = $this->load->view('agenda/email_service_concluido',$data_email,TRUE);
						send_mail_service_concluido($serv_id, $html,$this->input->post('cei') );
					}
/*************************************************************************************/   					
                    send_json_ok('Se actualizó de forma correcta');
                }
                else
                {
                    send_json_error('Ocurrió un error al actualizar el servicio.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['serv'] = $servicio;
            
            $data['examenes'] = $this->servicio->get_examenes($serv_id);
            $data['notas'] = $this->servicio->get_notas($serv_id);
            $data['anexos'] = $this->servicio->get_anexos($serv_id);
            
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Servicios',
                'view' => 'servicio/edit',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }
 

    public function id_ordenes($serv_id)
    {   
        if(isset($_POST) && count($_POST) > 0)     
        {
            $medico = $this->session->user;
            $this->load->library('form_validation');
            $this->form_validation->set_rules('obervaciones','Obervaciones','required');
            
            if($this->form_validation->run())
            {
                $data_serv_obs['serv_id'] = $serv_id;
                $data_serv_obs['usr_id'] = $medico['usr_id'];
                $data_serv_obs['nota_f'] = date('Y-m-d H:i:s');
                $data_serv_obs['nota_descripcion'] = $this->input->post('obervaciones');
                if($this->servicio->inserta_nota(array_to_upper($data_serv_obs)))
                {
                    send_json_ok('Se guardó de forma correcta la observación.');
                }
                else 
                {
                    send_json_error('Ocurrió un error al guardar la observación.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else
        {
            $servicio = $this->servicio->get($serv_id,get_desp_id_usr());
           
            $data['serv'] = $servicio;
			$this->load->helper('catalogo');
            $data['examenes'] = $this->servicio->get_examenes($serv_id);
            $data['notas'] = $this->servicio->get_notas($serv_id);
            $data['anexos'] = $this->servicio->get_anexos($serv_id);
            $data['personas'] = $this->servicio->get_examenes_serv($serv_id);			
			//$data['cei']= $this->servicio->get_cei($servicio['cei_id']);

            $this->load->helper('template');
            $params_view = array(
                'title' => 'Servicios',
                'view' => 'servicio/view_ordenes',
                'view_data' => $data
               );
            render_template($params_view);
        }
    }


 
    public function id($serv_id)
    {   
        if(isset($_POST) && count($_POST) > 0)     
        {
            $medico = $this->session->user;
            $this->load->library('form_validation');
            $this->form_validation->set_rules('obervaciones','Obervaciones','required');
            
            if($this->form_validation->run())
            {
                $data_serv_obs['serv_id'] = $serv_id;
                $data_serv_obs['usr_id'] = $medico['usr_id'];
                $data_serv_obs['nota_f'] = date('Y-m-d H:i:s');
                $data_serv_obs['nota_descripcion'] = $this->input->post('obervaciones');
                if($this->servicio->inserta_nota(array_to_upper($data_serv_obs)))
                {
                    send_json_ok('Se guardó de forma correcta la observación.');
                }
                else 
                {
                    send_json_error('Ocurrió un error al guardar la observación.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else
        {
            $servicio = $this->servicio->get($serv_id,get_desp_id_usr());
           
            $data['serv'] = $servicio;
			$this->load->helper('catalogo');
            $data['examenes'] = $this->servicio->get_examenes($serv_id);
            $data['notas'] = $this->servicio->get_notas($serv_id);
            $data['anexos'] = $this->servicio->get_anexos($serv_id);
            $data['personas'] = $this->servicio->get_examenes_serv($serv_id);			
			//$data['cei']= $this->servicio->get_cei($servicio['cei_id']);

            $this->load->helper('template');
            $params_view = array(
                'title' => 'Servicios',
                'view' => 'servicio/view',
                'view_data' => $data
               );
            render_template($params_view);
        }
    }
  

    function borra($serv_id)
    {
        if($this->servicio->delete_servicio($serv_id))
        {
            send_json_ok('Se eliminó de forma correcta la orden.');
        }
        else 
        {
            send_json_error('Ocurrió un error al borrar la orden.');
        }
    }
  
    function borra_examen($serv_id, $exam_id)
    {
        if($this->servicio->delete_examen($serv_id, $exam_id))
        {
            send_json_ok('Se eliminó de forma correcta el examen.');
        }
        else 
        {
            send_json_error('Ocurrió un error al borrar el examen.');
        }
    }
    
    function borra_anexo($serv_id, $anexo_id)
    {
        if($this->servicio->delete_anexo($serv_id, $anexo_id))
        {
            send_json_ok('Se eliminó de forma correcta el anexo.');
        }
        else 
        {
            send_json_error('Ocurrió un error al borrar el anexo.');
        }
    }
    
    function califica($serv_id)
    {
        send_json_ok($this->load->view('servicio/evalua',array('serv_id' => $serv_id),TRUE));
    }
    
    function evalua($serv_id)
    {
        $medico = $this->session->user;
        $this->load->library('form_validation');
        $this->form_validation->set_rules('atn_opor','Atención oportuna','required');
        $this->form_validation->set_rules('amabilidad','Amabilidad, calidad y profesionalismo','required');
        $this->form_validation->set_rules('profesional','El servicio cumplió con lo solicitado','required');
        //$this->form_validation->set_rules('obervaciones','Obervaciones','required');

        if($this->form_validation->run())
        {
            $data_serv_cal['serv_cal_atn_opor_cve'] = $this->input->post('atn_opor');
            $data_serv_cal['serv_cal_amabilidad_cve'] = $this->input->post('amabilidad');
            $data_serv_cal['serv_cal_pro_cve'] = $this->input->post('profesional');
            $data_serv_cal['serv_cal_sugerencia'] = $this->input->post('observaciones');
            $data_serv_cal['serv_cal_usr'] = $medico['usr_id'];
            $data_serv_cal['serv_cal_f'] = date('Y-m-d H:i:s');

            if($this->servicio->update($serv_id, array_to_upper($data_serv_cal)))
            {
                send_json_ok('Se evaluó de forma correcta el servicio.');
            }
            else 
            {
                send_json_error('Ocurrió un error al evaluar el servicio.');
            }
        }
        else
        {
            send_json_error(validation_errors('<div />'));
        }
    }


    public function reporte_nuevo_envio_especial($servicio_id)
    {
        $serv = $this->servicio->get($servicio_id);
        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('usuario_email','Usuario Email','required');

            if($this->form_validation->run())
            {
				
				$usuario_email= $this->input->post('usuario_email');
				$empresa_email = $this->input->post('empresa_email');
				$usuario_nombre = $this->input->post('usuario_nombre');
				$empresa_nombre = $this->input->post('empresa_nombre');
				$mail_adicionales = $this->input->post('mail_adicionales');
				
				$this->load->helper('mail');
				$data_email['serv'] =  $serv;
				//$data_email['personas'] = $this->servicio->get_examenes_serv($servicio_id);
				//$data_email['clientes'] = $this->servicio->get_examenes_serv($servicio_id);

				$html = $this->load->view('servicio/email_reporte_de_servicio_especial',$data_email,TRUE);
				send_mail_report_service($usuario_email,$usuario_nombre,
				$empresa_email,$empresa_nombre,$mail_adicionales,				
				$data_email['serv'], $html);

				if(1)
				{
					send_json_ok('Se guardó de forma correcta');
				}
				else
				{
					send_json_error('Ocurrió un error al guardar el documento.');
				}
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
			
			$this->load->model('empresa/Empresa_model','empresa');
			
			$data['empresa'] = $this->empresa->get_empresa_by_id($serv['emp_id']);
			$data['servicio_id'] = $servicio_id;
			$data['servicio'] = $serv;
	        $this->load->helper('template');
            $params_view = array(
                'title' => 'Enviar',
                'view' => 'servicio/envia_nuevo_reporte_especial',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }	


    public function reporte_nuevo_envio($servicio_id)
    {
        $serv = $this->servicio->get($servicio_id);
        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('usuario_email','Usuario Email','required');

            if($this->form_validation->run())
            {
				
				$usuario_email= $this->input->post('usuario_email');
				$empresa_email = $this->input->post('empresa_email');
				$usuario_nombre = $this->input->post('usuario_nombre');
				$empresa_nombre = $this->input->post('empresa_nombre');
				$mail_adicionales = $this->input->post('mail_adicionales');
				
				$this->load->helper('mail');
				$data_email['serv'] =  $serv;
				//$data_email['personas'] = $this->servicio->get_examenes_serv($servicio_id);
				//$data_email['clientes'] = $this->servicio->get_examenes_serv($servicio_id);

				$html = $this->load->view('agenda/email_reporte_de_servicio',$data_email,TRUE);
				send_mail_report_service($usuario_email,$usuario_nombre,
				$empresa_email,$empresa_nombre,$mail_adicionales,				
				$data_email['serv'], $html);

				if(1)
				{
					send_json_ok('Se guardó de forma correcta');
				}
				else
				{
					send_json_error('Ocurrió un error al guardar el documento.');
				}
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
			
			$this->load->model('empresa/Empresa_model','empresa');
			
			$data['empresa'] = $this->empresa->get_empresa_by_id($serv['emp_id']);
			$data['servicio_id'] = $servicio_id;
			$data['servicio'] = $serv;
	        $this->load->helper('template');
            $params_view = array(
                'title' => 'Enviar',
                'view' => 'servicio/envia_nuevo_reporte',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }	
	
	
	
      function reporte_evaluados_servicios_especiales($servicio_id)
    {
		
		
		$serv = $this->servicio->get($servicio_id);
        $this->load->model('empresa/Empresa_model','empresa');
		$this->load->model('persona/Persona_model','cliente');
		$this->load->helper('util');


		$f_ini = $this->input->post('f_ini');
        $f_fin = $this->input->post('f_fin'); 
		
		$emp_id=$empresa;
/*++++++++++++++++++*/		

		$date2today = date("Y-m-d H:i:s");
		?>
		<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
		<html xmlns="http://www.w3.org/1999/xhtml">

			<head>
				<meta content="es-mx" http-equiv="Content-Language" />
				<meta content="text/html; charset=utf-8" http-equiv="Content-Type" />
				<?php
					header("Content-type: application/octet-stream; charset=latin1");
					header("Content-Disposition: attachment; filename=Reporte_evaluados_x_Servicios.xls");
					header("Pragma: no-cache");
					header("Expires: 0");
				?>
				<title>#</title>
				
				<style type="text/css">
					.auto-style1 {
						font-family: Arial, Helvetica, sans-serif;
						color: #FFFFFF;
						background-color: #3D5588;
						font-size: small;
					}
					.auto-style4 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: xx-small;
					}
					.auto-style5 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: medium;
					}
					.auto-style6 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: x-large;
						text-align: right;
						font-weight: normal;
					}
					.auto-style7 {
						font-size: small;
					}
					.auto-style8 {
						color: #3D5588;
					}
					.auto-style9 {
						color: #3AD4A7;
					}
								.auto-style11 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: small;
						text-align: right;
					}
					.auto-style12 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: small;
						text-align: center;
					}
					.auto-style13 {
						font-size: xx-small;
					}
					.auto-style14 {
						font-family: Arial, Helvetica, sans-serif;
						color: #FFFFFF;
						background-color: #3D5588;
						font-size: 12px;
						text-align: center;
					}

					.auto-style144 {
						font-family: Arial, Helvetica, sans-serif;
						color: #FFFFFF;
						background-color: #3D5588;
						font-size: 19px;
						text-align: center;
					}

					.auto-style144_R {
						font-family: Arial, Helvetica, sans-serif;
						color: #FFFFFF;
						background-color: #FF0000;
						font-size: 10px;
						text-align: center;
					}

					.auto-style144_A {
						font-family: Arial, Helvetica, sans-serif;
						color: #000000;
						background-color: #f7d917;
						font-size: 10px;
						text-align: center;
					}

					.auto-style144_V {
						font-family: Arial, Helvetica, sans-serif;
						color: #ffffff;
						background-color:  #007336;
						font-size: 10px;
						text-align: center;
					}


					.auto-style15 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: x-small;
					}
					.auto-style16 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: x-small;
						text-align: right;
					}
					.auto-style17 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: x-small;
						text-align: left;
						text-align: center;
					}
					.auto-style18 {
						font-family: Arial, Helvetica, sans-serif;
						color: #000000;
						font-size: xx-small;
						text-align: center;
					}

					.auto-style154 {
						font-family: Arial, Helvetica, sans-serif;
						color: #000000;
						font-size: xx-small;
						text-align: center;
						background-color: #BDD7EE;
					}

					.auto-style189 {
						font-family: Arial, Helvetica, sans-serif;
						color: #000000;
						font-size: xx-small;
						text-align: center;
						background-color: #DDEBF7;
					}

					.auto-style188 {
						font-family: Arial, Helvetica, sans-serif;
						color: #000000;
						font-size: xx-small;
						text-align: left;
					}

					.auto-style88 {
						font-family: Arial, Helvetica, sans-serif;
						color: #3D5588;
						font-size: small;
						text-align: right;	
					}

					.auto-style19 {
						color: #3D5588;
						font-size: medium;
					}
					.auto-style20 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: xx-small;
						text-align: center;
						background-color: #BFEADD;
					}
					.auto-style21 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: xx-small;
						background-color: #BFEADD;
					}

					.auto-style190 {
						font-family: Arial, Helvetica, sans-serif;
						color: #0000FF;
					}

					.APTO {
						color: #008000;
						font-weight: bold;
					}
					.NOAPTO {
						color: #FF0000;
						font-weight: bold;
					}

					.PENDIENTE {
						color: #FF00FF;
						font-weight: bold;
					}				
				</style>
			</head>			
			<body>

				<table> 
					<thead>
						<tr>
							<th style="width: 64px" class="auto-style5">&nbsp;</th>
							<th style="width: 78px" class="auto-style5">&nbsp;</th>
							<th style="width: 78px" class="auto-style5">&nbsp;</th>
							<th style="width: 393px" class="auto-style5">&nbsp;</th>
							<th style="width: 281px" class="auto-style5">&nbsp;</th>
							<th style="width: 645px" class="auto-style5">&nbsp;</th>
							<th style="width: 95px" class="auto-style5">&nbsp;</th>
							<th style="width: 283px" class="auto-style5">&nbsp;</th>
						</tr>
						<tr>
							<th class="auto-style5">&nbsp;</th>
							<th class="auto-style5">&nbsp;</th>
							<th class="auto-style5">&nbsp;</th>
							<th class="auto-style6">
							<strong><span class="auto-style8">human</span><span class="auto-style9">center</span></strong></th>
							<th class="auto-style11">&nbsp;</th>
							<th class="auto-style12">Paquetes y Servicios Orden Especial</th>
							<th class="auto-style5">&nbsp;</th>
							<th class="auto-style5">&nbsp;</th>
						</tr>

						<tr>
							<th class="auto-style5">&nbsp;</th>
							<th class="auto-style5">&nbsp;</th>
							<th class="auto-style5">&nbsp;</th>
							<th class="auto-style6">
							<span class="auto-style19">Online</span><sup><span class="auto-style13" style="color: rgb(34, 34, 34); font-family: arial, sans-serif; font-style: normal; font-variant-ligatures: normal; font-variant-caps: normal; font-weight: 400; letter-spacing: normal; orphans: 2; text-align: left; text-indent: 0px; text-transform: none; white-space: normal; widows: 2; word-spacing: 0px; -webkit-text-stroke-width: 0px; background-color: rgb(255, 255, 255); text-decoration-style: initial; text-decoration-color: initial; display: inline !important; float: none;">®</span></sup></th>
							<th class="auto-style16">Empresa:</th>
							<th class="auto-style17">&nbsp;<?php echo get_empresa($serv['emp_id']); ?></th>							
							<th class="auto-style5">&nbsp;</th>
							<th class="auto-style5">&nbsp;</th>
						</tr>



						<tr>
							<th class="auto-style5">&nbsp;</th>
							<th class="auto-style5">&nbsp;</th>
							<th class="auto-style5">&nbsp;</th>
							<th class="auto-style5">&nbsp;</th>
							<th class="auto-style16">Generado el día:</th>
							<th class="auto-style17">&nbsp;&nbsp;<?php echo date("d/m/y h:i:sa"); ?></th>
							<th class="auto-style5">&nbsp;</th>
							<th class="auto-style5">&nbsp;</th>
						</tr>
						<tr>
							<th style="width: 64px" class="auto-style5">&nbsp;</th>
							<th style="width: 78px" class="auto-style5">&nbsp;</th>
							<th style="width: 78px" class="auto-style5">&nbsp;</th>
							<th style="width: 393px" class="auto-style5">&nbsp;</th>
							<th style="width: 281px" class="auto-style5">&nbsp;</th>
							<th style="width: 645px" class="auto-style5">&nbsp;</th>
							<th style="width: 95px" class="auto-style5">&nbsp;</th>
							<th style="width: 283px" class="auto-style5">&nbsp;</th>
						</tr>
						<tr>
							<th style="width: 64px" class="auto-style5">&nbsp;</th>
							<th style="width: 78px" class="auto-style5">&nbsp;</th>
							<th style="width: 78px" class="auto-style5">&nbsp;</th>
							<th style="width: 393px" class="auto-style5">&nbsp;</th>
							<th style="width: 281px" class="auto-style5">&nbsp;</th>
							<th style="width: 645px" class="auto-style5">&nbsp;</th>
							<th style="width: 95px" class="auto-style5">&nbsp;</th>
							<th style="width: 283px" class="auto-style5">&nbsp;</th>
						</tr>						
					</thead>
				</table> 
				
				<?php 
					$la_empresa=$serv['emp_id']; 
					$emp_id=$la_empresa;
					$this->db->select('*');
					$this->db->from('sis30_servicios');
					$this->db->where('emp_id',$la_empresa);
					$this->db->where('serv_id',$serv['serv_id']);
					$todos_los_servicios=$this->db->get()->result_array();

				?>				
					<table class="table table-hover table-striped">
							<tr  style="color: black;" >
								<td align="center" style="width: 35%;  background-color: black; color: white;">No. de Orden</td>								
								<td align="center" style="width: 35%;  background-color: black; color: white;">Fecha Inicial</td>
								<td align="center" style="width: 35%;  background-color: black; color: white;">Fecha Final</td>
								<td align="center" style="width: 35%;  background-color: black; color: white;">Situación</td>
								<td align="center" style="width: 35%;  background-color: black; color: white;">Paquete</td>
								<td  align="center" style="width: 35%;  background-color: black; color: white;">Servicio(s) Contenido(s)</td>
								<td  align="center" style="width: 15%;  background-color: black; color: white;">Costo</td>
							</tr>
							<?php 
								$fsm_pakts= get_costos_paquetes_empresa($la_empresa);
								if($fsm_pakts)
								{	
									foreach($fsm_pakts as $fsm_pakt): 
									if  ($fsm_pakt['cost_tipo_pkt']== 'IGUALA')
									{
										if (get_paquete_desde_servicio($serv['serv_id'],$fsm_pakt['cost_nombre_pkt'])) 
										{
											if (strstr('auto-style154',$class18))																	
											{$class18="auto-style189";}
											else
											{$class18="auto-style154";}	
									?>
										<tr>
											<td class=<?php echo $class18; ?>><?php echo $serv['serv_id']; ?></td>
											
											<td class=<?php echo $class18; ?>><?php echo formatea_fecha($serv['serv_f_inicio']); ?></td>
											<td class=<?php echo $class18; ?>><?php echo formatea_fecha($serv['serv_f_fin']); ?></td>
											<td class=<?php echo $class18; ?>><?php echo $serv['serv_estatus_cve']; ?></td>
											<td class=<?php echo $class18; ?>><?php echo $fsm_pakt['cost_nombre_pkt']; ?></td>
											<td class=<?php echo $class18; ?>>
												<?php
												foreach (explode(';', $fsm_pakt['cost_examen_cve']) as $detalle)
												{
													if ( strlen($detalle) > 0)
													{												
														echo get_nombre_de_examen($detalle, 'EXAMEN');
														echo '<br>';
													}
												}								
												?>
											 </td>
											 
											<td class=<?php echo $class18; ?>>
												<?php echo '<b>'.'$'.number_format( $fsm_pakt['cost_monto'],2).'</b>';  $total= $total+$fsm_pakt['cost_monto']; ?>  
											</td> 
										</tr>
										<?php 
									}
								}	
									endforeach;
									?>
									<tr  style="color: black;" >
										<td align="center" style="width: 35%;  background-color: black; color: white;"></td>
										<td align="center" style="width: 35%;  background-color: black; color: white;"></td>
										<td align="center" style="width: 35%;  background-color: black; color: white;"></td>
										<td align="center" style="width: 35%;  background-color: black; color: white;"></td>
										<td align="center" style="width: 35%;  background-color: black; color: white;"></td>
										<td  align="right" style="width: 35%;  background-color: black; color: white;">TOTAL:</td>
										<td  align="center" style="width: 5%;  background-color: black; color: white;"><?php echo '<b>'.'$'.number_format($total,2).'</b>'; ?></td>
									</tr>
									<?php 
								}
								else
								{
								?>
									<tr>
										<td align="center" ><b>ADVERTENCIA:</b></td>
										<td align="center" ><b>NO HAY PAQUETES DEFINIDOS PARA LA EMPRESA</b></td>
										<td align="center" ><b>NO SE PERMITIRA GUARDAR ESTE REGISTRO</b></td>
									</tr>
								<?php
								$guardar=0;
								}																
							?>
					</table>
            </body>
				
		</html><?php 	
	 }	
 
 
 
    function reporte_evaluados_servicios($servicio_id)
    {
		
		
		$serv = $this->servicio->get($servicio_id);
        $this->load->model('empresa/Empresa_model','empresa');
		$this->load->model('persona/Persona_model','cliente');
		$this->load->helper('util');


		$f_ini = formatea_fecha_mysql($this->input->post('f_ini'));
        $f_fin = formatea_fecha_mysql($this->input->post('f_fin')); 
		
		$emp_id=$empresa;
/*++++++++++++++++++*/		

		$date2today = date("Y-m-d H:i:s");
		?>
		<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
		<html xmlns="http://www.w3.org/1999/xhtml">

			<head>
				<meta content="es-mx" http-equiv="Content-Language" />
				<meta content="text/html; charset=utf-8" http-equiv="Content-Type" />
				<?php
					header("Content-type: application/octet-stream; charset=latin1");
					header("Content-Disposition: attachment; filename=Reporte_evaluados_x_Servicios.xls");
					header("Pragma: no-cache");
					header("Expires: 0");
				?>
				<title>#</title>
				
				<style type="text/css">
					.auto-style1 {
						font-family: Arial, Helvetica, sans-serif;
						color: #FFFFFF;
						background-color: #3D5588;
						font-size: small;
					}
					.auto-style4 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: xx-small;
					}
					.auto-style5 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: medium;
					}
					.auto-style6 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: x-large;
						text-align: right;
						font-weight: normal;
					}
					.auto-style7 {
						font-size: small;
					}
					.auto-style8 {
						color: #3D5588;
					}
					.auto-style9 {
						color: #3AD4A7;
					}
								.auto-style11 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: small;
						text-align: right;
					}
					.auto-style12 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: small;
						text-align: center;
					}
					.auto-style13 {
						font-size: xx-small;
					}
					.auto-style14 {
						font-family: Arial, Helvetica, sans-serif;
						color: #FFFFFF;
						background-color: #3D5588;
						font-size: 12px;
						text-align: center;
					}

					.auto-style144 {
						font-family: Arial, Helvetica, sans-serif;
						color: #FFFFFF;
						background-color: #3D5588;
						font-size: 19px;
						text-align: center;
					}

					.auto-style144_R {
						font-family: Arial, Helvetica, sans-serif;
						color: #FFFFFF;
						background-color: #FF0000;
						font-size: 10px;
						text-align: center;
					}

					.auto-style144_A {
						font-family: Arial, Helvetica, sans-serif;
						color: #000000;
						background-color: #f7d917;
						font-size: 10px;
						text-align: center;
					}

					.auto-style144_V {
						font-family: Arial, Helvetica, sans-serif;
						color: #ffffff;
						background-color:  #007336;
						font-size: 10px;
						text-align: center;
					}


					.auto-style15 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: x-small;
					}
					.auto-style16 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: x-small;
						text-align: right;
					}
					.auto-style17 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: x-small;
						text-align: left;
					}
					.auto-style18 {
						font-family: Arial, Helvetica, sans-serif;
						color: #000000;
						font-size: xx-small;
						text-align: center;
					}

					.auto-style154 {
						font-family: Arial, Helvetica, sans-serif;
						color: #000000;
						font-size: xx-small;
						text-align: center;
						background-color: #BDD7EE;
					}

					.auto-style189 {
						font-family: Arial, Helvetica, sans-serif;
						color: #000000;
						font-size: xx-small;
						text-align: center;
						background-color: #DDEBF7;
					}

					.auto-style188 {
						font-family: Arial, Helvetica, sans-serif;
						color: #000000;
						font-size: xx-small;
						text-align: left;
					}

					.auto-style88 {
						font-family: Arial, Helvetica, sans-serif;
						color: #3D5588;
						font-size: small;
						text-align: right;	
					}

					.auto-style19 {
						color: #3D5588;
						font-size: medium;
					}
					.auto-style20 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: xx-small;
						text-align: center;
						background-color: #BFEADD;
					}
					.auto-style21 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: xx-small;
						background-color: #BFEADD;
					}

					.auto-style190 {
						font-family: Arial, Helvetica, sans-serif;
						color: #0000FF;
					}

					.APTO {
						color: #008000;
						font-weight: bold;
					}
					.NOAPTO {
						color: #FF0000;
						font-weight: bold;
					}

					.PENDIENTE {
						color: #FF00FF;
						font-weight: bold;
					}				
				</style>
			</head>			
			<body>

				<table> 
					<thead>
						<tr>
							<th style="width: 64px" class="auto-style5">&nbsp;</th>
							<th style="width: 78px" class="auto-style5">&nbsp;</th>
							<th style="width: 78px" class="auto-style5">&nbsp;</th>
							<th style="width: 393px" class="auto-style5">&nbsp;</th>
							<th style="width: 281px" class="auto-style5">&nbsp;</th>
							<th style="width: 645px" class="auto-style5">&nbsp;</th>
							<th style="width: 95px" class="auto-style5">&nbsp;</th>
							<th style="width: 283px" class="auto-style5">&nbsp;</th>
						</tr>
						<tr>
							<th class="auto-style5">&nbsp;</th>
							<th class="auto-style5">&nbsp;</th>
							<th class="auto-style5">&nbsp;</th>
							<th class="auto-style6">
							<strong><span class="auto-style8">human</span><span class="auto-style9">center</span></strong></th>
							<th class="auto-style11">&nbsp;</th>
							<th class="auto-style12"></th>
							<th class="auto-style5">&nbsp;</th>
							<th class="auto-style5">&nbsp;</th>
						</tr>
						
						<tr>
							<th class="auto-style5">&nbsp;</th>
							<th class="auto-style5">&nbsp;</th>
							<th class="auto-style5">&nbsp;</th>
							<th class="auto-style6">
							<span class="auto-style19">Online</span><sup><span class="auto-style13" style="color: rgb(34, 34, 34); font-family: arial, sans-serif; font-style: normal; font-variant-ligatures: normal; font-variant-caps: normal; font-weight: 400; letter-spacing: normal; orphans: 2; text-align: left; text-indent: 0px; text-transform: none; white-space: normal; widows: 2; word-spacing: 0px; -webkit-text-stroke-width: 0px; background-color: rgb(255, 255, 255); text-decoration-style: initial; text-decoration-color: initial; display: inline !important; float: none;">®</span></sup></th>
							<th class="auto-style16">Empresa:</th>
							<th class="auto-style17">&nbsp;&nbsp;<?php echo get_empresa($serv['emp_id']); ?></th>							
							<th class="auto-style5">&nbsp;</th>
							<th class="auto-style5">&nbsp;</th>
						</tr>
						<tr>
							<th class="auto-style5">&nbsp;</th>
							<th class="auto-style5">&nbsp;</th>
							<th class="auto-style5">&nbsp;</th>
							<th class="auto-style5">&nbsp;</th>
							<th class="auto-style16">Del</th>
							<th class="auto-style17">&nbsp;&nbsp;<?php echo formatea_fecha($f_ini); ?>&nbsp;al&nbsp;<?php echo formatea_fecha($f_fin); ?> </th>
							<th class="auto-style5">&nbsp;</th>
							<th class="auto-style5">&nbsp;</th>
						</tr>
						<tr>
							<th class="auto-style5">&nbsp;</th>
							<th class="auto-style5">&nbsp;</th>
							<th class="auto-style5">&nbsp;</th>
							<th class="auto-style5">&nbsp;</th>
							<th class="auto-style16">Generado el día:</th>
							<th class="auto-style17">&nbsp;&nbsp;<?php echo date("d/m/y h:i:sa"); ?></th>
							<th class="auto-style5">&nbsp;</th>
							<th class="auto-style5">&nbsp;</th>
						</tr>



					</thead>
				</table> 
				
				<?php 
				edo_page($serv,1,0,1,1,$f_ini,$f_fin);
        
				?>
            </body>
				
		</html><?php 	
	 }	
	
	
    function reporte_evaluados_ordenes_servicios($servicio_id)
    {
		
		$control_ordenes_empresas=1;
		$serv = $this->servicio->get($servicio_id);
        $this->load->model('empresa/Empresa_model','empresa');
		$this->load->model('persona/Persona_model','cliente');
		$this->load->helper('util');
       
		//$f_ini = formatea_fecha_mysql($this->input->post('f_ini'));
        //$f_fin = formatea_fecha_mysql($this->input->post('f_fin')); 

		$f_ini = $this->input->post('f_ini');
        $f_fin = $this->input->post('f_fin'); 
		
		$emp_id=$empresa;
/*++++++++++++++++++*/		

		$date2today = date("Y-m-d H:i:s");
		?>
		<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
		<html xmlns="http://www.w3.org/1999/xhtml">

			<head>
				<meta content="es-mx" http-equiv="Content-Language" />
				<meta content="text/html; charset=utf-8" http-equiv="Content-Type" />
				<?php
					header("Content-type: application/octet-stream; charset=latin1");
					header("Content-Disposition: attachment; filename=Reporte_evaluados_x_Servicios.xls");
					header("Pragma: no-cache");
					header("Expires: 0");
				?>
				<title>#</title>
				
				<style type="text/css">
					.auto-style1 {
						font-family: Arial, Helvetica, sans-serif;
						color: #FFFFFF;
						background-color: #3D5588;
						font-size: small;
					}
					.auto-style4 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: xx-small;
					}
					.auto-style5 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: medium;
					}
					.auto-style6 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: x-large;
						text-align: right;
						font-weight: normal;
					}
					.auto-style7 {
						font-size: small;
					}
					.auto-style8 {
						color: #3D5588;
					}
					.auto-style9 {
						color: #3AD4A7;
					}
								.auto-style11 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: small;
						text-align: right;
					}
					.auto-style12 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: small;
						text-align: center;
					}
					.auto-style13 {
						font-size: xx-small;
					}
					.auto-style14 {
						font-family: Arial, Helvetica, sans-serif;
						color: #FFFFFF;
						background-color: #3D5588;
						font-size: 12px;
						text-align: center;
					}

					.auto-style144 {
						font-family: Arial, Helvetica, sans-serif;
						color: #FFFFFF;
						background-color: #3D5588;
						font-size: 10px;
						text-align: center;
					}

					.auto-style144_R {
						font-family: Arial, Helvetica, sans-serif;
						color: #FFFFFF;
						background-color: #FF0000;
						font-size: 10px;
						text-align: center;
					}

					.auto-style144_A {
						font-family: Arial, Helvetica, sans-serif;
						color: #000000;
						background-color: #f7d917;
						font-size: 10px;
						text-align: center;
					}

					.auto-style144_V {
						font-family: Arial, Helvetica, sans-serif;
						color: #ffffff;
						background-color:  #007336;
						font-size: 10px;
						text-align: center;
					}


					.auto-style15 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: x-small;
					}
					.auto-style16 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: x-small;
						text-align: right;
					}
					.auto-style17 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: x-small;
						text-align: left;
					}
					.auto-style18 {
						font-family: Arial, Helvetica, sans-serif;
						color: #000000;
						font-size: xx-small;
						text-align: center;
					}

					.auto-style154 {
						font-family: Arial, Helvetica, sans-serif;
						color: #000000;
						font-size: xx-small;
						text-align: center;
						background-color: #BDD7EE;
					}

					.auto-style189 {
						font-family: Arial, Helvetica, sans-serif;
						color: #000000;
						font-size: xx-small;
						text-align: center;
						background-color: #DDEBF7;
					}

					.auto-style188 {
						font-family: Arial, Helvetica, sans-serif;
						color: #000000;
						font-size: xx-small;
						text-align: left;
					}

					.auto-style88 {
						font-family: Arial, Helvetica, sans-serif;
						color: #3D5588;
						font-size: small;
						text-align: right;	
					}

					.auto-style19 {
						color: #3D5588;
						font-size: medium;
					}
					.auto-style20 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: xx-small;
						text-align: center;
						background-color: #BFEADD;
					}
					.auto-style21 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: xx-small;
						background-color: #BFEADD;
					}

					.auto-style190 {
						font-family: Arial, Helvetica, sans-serif;
						color: #0000FF;
					}

					.APTO {
						color: #008000;
						font-weight: bold;
					}
					.NOAPTO {
						color: #FF0000;
						font-weight: bold;
					}

					.PENDIENTE {
						color: #FF00FF;
						font-weight: bold;
					}				
				</style>
			</head>			
			<body>

				<table> 
					<thead>
						<tr>
							<th style="width: 64px" class="auto-style5">&nbsp;</th>
							<th style="width: 78px" class="auto-style5">&nbsp;</th>
							<th style="width: 78px" class="auto-style5">&nbsp;</th>
							<th style="width: 393px" class="auto-style5">&nbsp;</th>
							<th style="width: 281px" class="auto-style5">&nbsp;</th>
							<th style="width: 645px" class="auto-style5">&nbsp;</th>
							<th style="width: 95px" class="auto-style5">&nbsp;</th>
							<th style="width: 283px" class="auto-style5">&nbsp;</th>
						</tr>
						<tr>
							<th class="auto-style5">&nbsp;</th>
							<th class="auto-style5">&nbsp;</th>
							<th class="auto-style5">&nbsp;</th>
							<th class="auto-style6">
							<strong><span class="auto-style8">human</span><span class="auto-style9">center</span></strong></th>
							<th class="auto-style11">&nbsp;</th>
							<th class="auto-style12"></th>
							<th class="auto-style5">&nbsp;</th>
							<th class="auto-style5">&nbsp;</th>
						</tr>
						<tr>
							<th class="auto-style5">&nbsp;</th>
							<th class="auto-style5">&nbsp;</th>
							<th class="auto-style5">&nbsp;</th>
							<th class="auto-style6">
							<span class="auto-style19">Online</span><sup><span class="auto-style13" style="color: rgb(34, 34, 34); font-family: arial, sans-serif; font-style: normal; font-variant-ligatures: normal; font-variant-caps: normal; font-weight: 400; letter-spacing: normal; orphans: 2; text-align: left; text-indent: 0px; text-transform: none; white-space: normal; widows: 2; word-spacing: 0px; -webkit-text-stroke-width: 0px; background-color: rgb(255, 255, 255); text-decoration-style: initial; text-decoration-color: initial; display: inline !important; float: none;">®</span></sup></th>
							<th class="auto-style16">
							<?php if ($control_ordenes_empresas == 0) {
							echo 'Empresa:';
							} ?></th>
							<th class="auto-style17">&nbsp;&nbsp;<?php
							if ($control_ordenes_empresas == 0) { 
							echo $serv['emp_razon_social']; 
							}?></th>							
							<th class="auto-style5">&nbsp;</th>
							<th class="auto-style5">&nbsp;</th>
						</tr>

						<tr>
							<th class="auto-style5">&nbsp;</th>
							<th class="auto-style5">&nbsp;</th>
							<th class="auto-style5">&nbsp;</th>
							<th class="auto-style5">&nbsp;</th>
							<th class="auto-style16">Generado el día:</th>
							<th class="auto-style17">&nbsp;&nbsp;<?php echo date("d/m/y h:i:sa"); ?></th>
							<th class="auto-style5">&nbsp;</th>
							<th class="auto-style5">&nbsp;</th>
						</tr>
					</thead>
				</table> 
				
							<?php /* modulo base */
								$CIs =&get_instance();
								$CIs->load->model('vista_reporte_costos/Vista_reporte_costos_model','examenes');

								$this->db->select('*');
								$this->db->from('sis30_servicios');
								$this->db->where('serv_id',$serv['serv_id']);
								$todos_los_servicios=$this->db->get()->result_array();
							
								if ($todos_los_servicios)
								{/*toma servcios*/
									
									foreach($todos_los_servicios  as $el_servicio):
																		
										$class18="auto-style18";
										

										$emp_id=$serv['emp_id'];
										
										//echo $emp_id;
									
										if (  ($emp_id != 298) &&   ($emp_id != 152) && ($emp_id != 194) && ($emp_id != 193)  && ($emp_id != 210) && ($emp_id != 182) )
										{
											//echo '| el servicio: '.$serv['serv_id']. '|'; 
											$examenes_serv_id =get_examenes_by_serv($serv['serv_id']);	
											$examenes_archivo_serv_id = get_archivos_by_serv($serv['serv_id']);
											$clientes =get_evaluados_by_serv($serv['serv_id']);			

												if ($clientes)
												{
												?>
													<hr>
													<h5 class="color-gray"><b>Detalle de Estado de Cuenta por Orden de Servicio: <?php echo $el_servicio['serv_id']; ?> con Pedido: <?php echo $el_servicio['serv_orden']; ?></b></h5>   
												<?php 

												$indice=1;
												$ini = '2017-01-01';
												$fin = '2022-12-31';
												
												$exames_contenidos_en_servicio='';
												if($examenes_serv_id ):
													foreach($examenes_serv_id  as $examen_pkt):
														$titular_pkt[$indice]=$examen_pkt['exam_nombre_pkt'];
														$cont_pkt[$indice]=$examen_pkt['exam_cve'];	
														$exames_contenidos_en_servicio.=$examen_pkt['exam_cve'];	
														$monto_pkt[$indice]=$examen_pkt['exam_monto'];	
														$tipo_pkt[$indice]=$examen_pkt['exam_tipo_pkt'];	
														$indice++;
													endforeach;
												endif;
												$cuantos_examenes_servicios=count_examanes($exames_contenidos_en_servicio);	
												
												
												$total_pkts=$indice-1;
												$total_general=0.0;				
												?>
												<table class="table table-striped" border= 1> 
													<tr>
														<td style="width: 10px" class="auto-style14" >#</td>
														<td style="width: 10px" class="auto-style14" >CEI</td>
														<td style="width: 10px" class="auto-style14" >Id</td>
														<td style="width: 10px" class="auto-style14" >EVALUADO</td>
														<td style="width: 10px" class="auto-style14" >RFC</td>
														<td style="width: 10px" class="auto-style14" >FECHA DE REGISTRO</td>
														<td style="width: 10px" class="auto-style14" >PUESTO</td>
													<?php 
													for ($i=1; $i<= $total_pkts; $i++)
													{
													?>	<td class="auto-style14"> 
														<?php  
															
															{				
																echo $titular_pkt[$i]; 
															}
														?>
														</td> <?php 	
													}
													?>
														<?php if ($control_ordenes_empresas == 0) { ?>
														<td class="auto-style14" >Estatus</td>
														<td class="auto-style14" >Total</td>
														<td class="auto-style14" >Total + IVA</td>
														<?php } ?>
													</tr>
												<?php
												
												if($clientes):
													$j=1;
													
											
													foreach ($clientes as $cliente):
														$clte_examenes='';
														$clte_cuantos_examenes=0;
													
													
														$this->db->select('*');
														$this->db->from('sis05_clientes');
														$this->db->where('clte_id',$cliente['clte_id']);
														$sujeto=$this->db->get()->row_array();	
														if (strstr('auto-style154',$class18))																	
															{$class18="auto-style189";}
															else
															{$class18="auto-style154";}	
														$total_linea=0;	
												?>	
													<tr>
														<td class=<?php echo $class18; ?> valign="top"><?php echo $j; $j++;?></td>
														<td class=<?php echo $class18; ?> valign="top"><?php echo get_cei($cliente['cei_id']); ?></td>
														<td class=<?php echo $class18; ?> valign="top"><?php echo $cliente['clte_id']; ?></td>
														<td class=<?php echo $class18; ?> valign="top">
														<a 	class=<?php echo $class18; ?> href="<?php echo base_url('persona/id/'.$cliente['clte_id']); ?>">
															
																<?php echo $cliente['clte_nombre']; ?> 
																<?php echo $cliente['clte_2_nombre']; ?> 
																<?php echo $cliente['clte_paterno']; ?> 
																<?php echo $cliente['clte_materno']; ?>
														
														</a>
														</td>
														<td class=<?php echo $class18; ?> valign="top">
														<?php echo $cliente['clte_rfc']; ?>										
														</td>
														<td class=<?php echo $class18; ?> valign="top">
														<?php echo formatea_fechahora($sujeto['log_insrt_f']); ?>									
														</td>
														<td class=<?php echo $class18; ?> valign="top">
														<?php echo $sujeto['clte_puesto']; ?>										
														</td>									
												<?php 
													//**************nuevo renglon********************
													
													for ($i=1; $i<= $total_pkts; $i++)
													{
													?>	<td class=<?php echo $class18; ?>> 
														<?php  
															{				
																$titular_pkt[$i];
																$primer_costo=1;
																foreach (explode(';',$cont_pkt[$i]) as $detalle)
																{
																	//echo '-'.$detalle.'-';
																	if (strlen($detalle) > 0)
																	{ 

																		$tabla=select_table_examen_form($detalle);
																		 
																		$fsm_id=0;
																		$doc='';	
																		
																		if
																		(		
																			($detalle == 'COVID') || ($detalle == 'RADIOT') ||  
																			($detalle == 'RADIOL') || ($detalle == 'PAPAN') ||
																			($detalle == 'ALCOSA') || ($detalle == 'ANTICUA') ||
																			($detalle == 'TORAX') || ($detalle == 'PCR') || 
																			($detalle == 'AUDIO')|| ($detalle == 'PUESIC') || 
																			($detalle == 'INTE') || ($detalle == 'PENSA') || 
																			($detalle == 'VISTA') || ($detalle == 'ELECTRO') || 
															
																			($detalle == 'AAFQ') || ($detalle == 'BURO') ||
																			($detalle == 'AHFQ') ||($detalle == 'KOHU') || 
																			
																			($detalle == 'COVID19') || ($detalle == 'EXAMM') ||
																		 
																			($detalle == 'HONE') || ($detalle == 'COMPO') || 
																			($detalle == 'VALPROF') || ($detalle == 'SPIRO')
																			|| ($detalle == 'LABDS') || ($detalle == 'EXMEDDS') 
																			|| ($detalle == 'RECODO') || ($detalle == 'CONODO') 
																			|| ($detalle == 'EVACOM') 
																		)
																		{
																			$doc= get_serv_clte_doc_path_by_table($cliente['clte_id'],$serv['serv_id'],select_table_examen_docs($detalle),$detalle);
																			$count_doc= count_serv_clte_doc_path_by_table($cliente['clte_id'],$serv['serv_id'],select_table_examen_docs($detalle),$detalle);
																			$all_doc= all_serv_clte_doc_path_by_table($cliente['clte_id'],$serv['serv_id'],select_table_examen_docs($detalle),$detalle);
																		}
																		else
																		{
																			if ($detalle == 'CED')
																			{			
																				$fsm_id=get_fsm_id_examen_form($cliente['clte_id'],$serv['serv_id'],select_table_examen_form($detalle),$detalle);
																				$count_fsm_id=count_fsm_id_examen_form($cliente['clte_id'],$serv['serv_id'],select_table_examen_form($detalle),$detalle);
																				$all_fsm_id=all_fsm_id_examen_form($cliente['clte_id'],$serv['serv_id'],select_table_examen_form($detalle),$detalle);
																			}
																			elseif ($detalle == 'POL')
																			{			
																				$fsm_id=get_fsm_id_examen_form($cliente['clte_id'],$serv['serv_id'],select_table_examen_form($detalle),$detalle);
																				$count_fsm_id=count_fsm_id_examen_form($cliente['clte_id'],$serv['serv_id'],select_table_examen_form($detalle),$detalle);
																				$all_fsm_id=all_fsm_id_examen_form($cliente['clte_id'],$serv['serv_id'],select_table_examen_form($detalle),$detalle);
																			}
																			else
																			{																				
																				$fsm_id=get_fsm_id_examen_form($cliente['clte_id'],$serv['serv_id'],select_table_examen_form($detalle));
																				$count_fsm_id=count_fsm_id_examen_form($cliente['clte_id'],$serv['serv_id'],select_table_examen_form($detalle));
																				$all_fsm_id=all_fsm_id_examen_form($cliente['clte_id'],$serv['serv_id'],select_table_examen_form($detalle));
																			}		
																		}			
																		
																		if (($fsm_id > 0) || ($doc != ''))
																		{	
																			if($fsm_id > 0) { $contador_f=$count_fsm_id;  }
																			else { $contador_f=$count_doc; }
																			if (
																				($detalle == 'RADIOT') ||  
																				($detalle == 'TORAX')  ||																		
																				($detalle == 'RADIOL')
																				)
																			{ $contador_f=1; }
																			if ($control_ordenes_empresas == 0) { 
																				if ($primer_costo==1)
																				{	
																					echo $contador_f.' X '.'$'.number_format($monto_pkt[$i],2).'<br>'; $total_linea=$total_linea+($monto_pkt[$i]*$contador_f); 
																					$primer_costo++;
																				}
																			}																			
																		}
																		else
																		{
																			if ($control_ordenes_empresas == 0) { 
																				if ($primer_costo==1)
																				{
																					echo '$'.number_format(0.0,2).'<br>'; 
																					$primer_costo++;
																				}
																			}
																		}	
																		
																		echo '<br>'.get_cat_nombre('EXAMEN',$detalle).'<br>';

																		if ($fsm_id > 0)
																		{	//echo $detalle;
																	        if (($all_fsm_id) &&  ( ($detalle!= 'VPPRO01') && ($detalle!= 'VPPRO02') ) ) :
																					foreach($all_fsm_id as $fsms):
																						$clte_examenes.=$detalle.';';
																						$clte_cuantos_examenes++;																			
																						echo 'ID: '.$fsms[fsm_id].' - '.get_examenes_realizados_detail($detalle, $fsms[fsm_id]).'<br>';
																					endforeach;
																			endif;
																		}
																		elseif ($doc != '')
																		{
																			
																			$clte_examenes.=$detalle.';';
																			$clte_cuantos_examenes++;
																		}
																		else
																		{
																			$que_examen='<a>';
																			$que_examen.='</a><br>';
																			
																		}															
																	}
																}
															}
														?>
														</td> 
														<?php 	
													}
													//************************************
												$exames_contenidos_en_servicio1=$exames_contenidos_en_servicio;
												
												//checar si hay PIE en servicio
												if (strstr($exames_contenidos_en_servicio1,'PIE'))
												{   if ($cliente['clte_genero_cve'] != 'M')
													{ 
														$exames_contenidos_en_servicio1 = str_replace("PIE;",'' , $exames_contenidos_en_servicio1);
														//$cuantos_examenes_servicios--;
													}													
												}
												
												//HOMOLOGAR TOXICOLOGICOS
												if (strstr($exames_contenidos_en_servicio1,'TOX'))
												{   
													$b1=0;$b2=0;
													if (strstr($exames_contenidos_en_servicio1,'TOXI;'))
													{ 
														$exames_contenidos_en_servicio1 = str_replace("TOXI;",'' , $exames_contenidos_en_servicio1);
														//$cuantos_examenes_servicios--;
														$b1=1;
													}
													if (strstr($exames_contenidos_en_servicio1,'TOXIS;'))
													{ 
														$exames_contenidos_en_servicio1 = str_replace("TOXIS;",'' , $exames_contenidos_en_servicio1);
														//$cuantos_examenes_servicios--;
														$b1=1;
													}
													if (strstr($exames_contenidos_en_servicio1,'TOXIN;'))
													{ 
														$exames_contenidos_en_servicio1 = str_replace("TOXIN;",'' , $exames_contenidos_en_servicio1);
														//$cuantos_examenes_servicios--;
														$b1=1;
													}
													if (strstr($exames_contenidos_en_servicio1,'TOXIT;'))
													{ 
														$exames_contenidos_en_servicio1 = str_replace("TOXIT;",'' , $exames_contenidos_en_servicio1);
														//$cuantos_examenes_servicios--;	
														$b1=1;
													}
													
												//RETIRALOS AL EVALUADO
													if (strstr($clte_examenes,'TOXIT;'))
													{ 
														$clte_examenes = str_replace("TOXIT;",'' , $clte_examenes);
														//$clte_cuantos_examenes--;
														$b2=1;
													}												
													if (strstr($clte_examenes,'TOXI;'))
													{ 
														$clte_examenes = str_replace("TOXI;",'' , $clte_examenes);
														//$clte_cuantos_examenes--;
														$b2=1;
													}
													if (strstr($clte_examenes,'TOXIS;'))
													{ 
														$clte_examenes = str_replace("TOXIS;",'' , $clte_examenes);
														//$clte_cuantos_examenes--;
														$b2=1;
													}
													if (strstr($clte_examenes,'TOXIN;'))
													{ 
														$clte_examenes = str_replace("TOXIN;",'' , $clte_examenes);
														//$clte_cuantos_examenes--;
														$b2=1;
													}

													
													if ($b1==1)
													{ 
														$exames_contenidos_en_servicio1.="TOXIG;";
														//$cuantos_examenes_servicios++;
													}

													if ($b2==1)
													{ 
														$clte_examenes.="TOXIG;";
														//$clte_cuantos_examenes++;
													}												
												}												
												
												$examenes_faltantes=dif_examenes_serv_examenes_clte($exames_contenidos_en_servicio1, $clte_examenes);
												
												$cuantos_examenes_servicios=contador_de_elementos_arreglos($exames_contenidos_en_servicio1);
												$clte_cuantos_examenes=contador_de_elementos_arreglos($clte_examenes);
												
												$diferencia_cantidad=$cuantos_examenes_servicios-$clte_cuantos_examenes;
												
												if ($diferencia_cantidad <= 0)
												{ $cuadro_res="auto-style144_V";$cuadro_ancho="width: 19px;";   }
												else
												{ $cuadro_res="auto-style144_A";$cuadro_ancho="width: 40px;"; }
												
												?>		
														<?php if ($control_ordenes_empresas == 0) { ?>
														<td class=<?php echo $cuadro_res; ?>  style="<?php echo $cuadro_ancho; ?> ;"><B>
																					<?php 
																					if ($diferencia_cantidad <= 0)
																					{
																						echo '<br>NO FALTAN EXÁMENES<br>';
																					}
																					else
																					{	
																						echo '<br>FALTAN ESTOS EXÁMENES:<br>';
																					
																						foreach (explode(';',$examenes_faltantes) as $detalle_clte_examenes)
																						{																							
																							echo '<br>*'.get_cat_nombre('EXAMEN',$detalle_clte_examenes);
																							
																						}
																						
																					//	echo '<br>Examenes en serv: '.$exames_contenidos_en_servicio1.'<br>'.'# examenes en serv '.$cuantos_examenes_servicios.'<br>'.'<br>'.'Clte Examenes: '.$clte_examenes.'<br>'.'# Clte examenes '.$clte_cuantos_examenes.'<br>'.'<br>'.'faltan estos examenes:'.dif_examenes_serv_examenes_clte($exames_contenidos_en_servicio1, $clte_examenes) ; 
																					}
																					?>
														</B></td>
														<td class=<?php echo $class18; ?> valign="top"><?php  echo number_format($total_linea,2); ?></td>
														<td class=<?php echo $class18; ?> valign="top"><?php  echo number_format($total_linea*1.16,2); ?></td>
														<?php } ?>
													</tr>
												<?php
												
													$total_general=$total_general + $total_linea;

													endforeach;								
												endif;
												?>

													<tr>
														<td class="auto-style14"></td>
														<td class="auto-style14"></td>
														<td class="auto-style14"></td>
														<td class="auto-style14"></td>
														<td class="auto-style14"></td>
														<td class="auto-style14"></td>	
														<td class="auto-style14"></td>	
												<?php 
												for ($i=1; $i<= $total_pkts; $i++)
												{
												?>
													<td class="auto-style14"></td>
												<?php
												} 
												?>		
												<?php if ($control_ordenes_empresas == 0) { ?>
														<td class="auto-style14"></td>
														<td class="auto-style14" ><?php  echo '$'.number_format($total_general,2); ?></td>
														<td class="auto-style14" ><?php  echo '$'.number_format($total_general*1.16,2); ?></td>
												<?php } ?>		
												</tr>					
												</table>
												<hr>
												<?php 
												}										
										}
										else /* ZONA PARA TRATAR COMPAÑIAS DE SEGUROS */
										{
											
											$examenes_serv_id =get_examenes_by_serv($serv['serv_id']);	
											//$examenes_archivo_serv_id = get_archivos_by_serv($serv['serv_id']);
											$clientes =get_evaluados_by_serv($serv['serv_id']);

											if($clientes)
											{
												?>
													<hr>
													<h4 class="color-gray">Detalle de Estado de Cuenta por Orden de Servicios <?php echo $el_servicio['serv_id']; ?></h4>   
												<?php 
											
													$indice=1;
													$ini = '2017-01-01';
													$fin = '2022-12-31';
													
													if($examenes_serv_id ):
														foreach($examenes_serv_id  as $examen_pkt):
														$titular_pkt[$indice]=$examen_pkt['exam_nombre_pkt'];
														$cont_pkt[$indice]=$examen_pkt['exam_cve'];	
														$monto_pkt[$indice]=$examen_pkt['exam_monto'];	
														$id_pkt[$indice]=$examen_pkt['exam_monto'];	
														$indice++;
														endforeach;
													endif;
													
													$total_pkts=$indice-1;
													$total_general=0.0;
													?>
													<table class="table table-striped" border= 1> 
															<tr>
																<td class="auto-style14" >#</td>
																<td class="auto-style14" >CEI</td>
																<td class="auto-style14" >Id</td>
																<?php
																if  ($emp_id == 182) 
																{
																?>
																	<td class="auto-style14" >Evaluado</td>
																<?php
																}
																else
																{
																?>
																	<td class="auto-style14" >Asegurado</td>
																<?php	
																}
																?>
																
																<?php 
																if  (
																		($emp_id == 298) || 
																		($emp_id == 152) ||
																		($emp_id == 193)
																	)
																{
																?>									
																<td class="auto-style14" >Fecha de Registro</td>
																<td class="auto-style14" >Ciudad del Asegurado</td>
																<?php	
																}
																?>									
																
																
																<?php 
																
																for ($i=1; $i<= $total_pkts; $i++)
																{																
																	 ?>	<td class="auto-style14"> <?php  echo str_replace("ELECTROCARDIOGRAMA ", "ELECTRO", $titular_pkt[$i]) ; ?></td> <?php 
																}
													?>							
																<td class="auto-style14" >Total</td>
																<td class="auto-style14" >Total + IVA</td>
															</tr>

													<?php						
														 if($clientes):
																$j=1;
						
																			
																foreach ($clientes as $cliente): 
																
																	if (strstr('auto-style154',$class18))																	
																		{$class18="auto-style189";}
																		else
																		{$class18="auto-style154";}																
											
																	$this->db->select('*');
																	$this->db->from('sis05_clientes');
																	$this->db->where('clte_id',$cliente['clte_id']);
																	$sujeto=$this->db->get()->row_array();	
																	$total_linea=0;	
																	
																	$this->db->select('*');
																	$this->db->from('sis12_sgmty_doc');
																	$this->db->where('serv_id',$serv['serv_id']);
																	$this->db->where('clte_id',$cliente['clte_id']);
																	$pkts_clte_serv=$this->db->get()->row_array();	
																	
																	$zonificación=0.0;
																	
																	if ($emp_id == 152)
																	{								
																		$this->db->select('mpio_nombre,estado');
																		$this->db->from('cat_dir_cp');
																		$this->db->like('cp_codigo',$sujeto['clte_env_cp']);
																		$this->db->limit(1); 
																		$zona=$this->db->get()->row_array();
																		
																		if ($zona['estado'] == 'QUERÉTARO')
																		{
																			$zonificación=600.0;
																		}
																		if ($zona['estado'] == 'CIUDAD DE MÉXICO')
																		{
																			$zonificación=700.0;
																		}
																		elseif ($zona['estado'] == 'MÉXICO')
																		{
																			$zonificación=800.0; 
																		}
																		else	
																		{
																			$zonificación=1500.0; 
																		}
																	}
																	
																	if ($emp_id == 193)
																	{	
																	 $zonificación=get_zonificacion_193($sujeto['clte_env_cp']);
																	}										
											
																	
																	?>	
																	<tr>
																		<td class=<?php echo $class18; ?>><?php echo $j; $j++;?></td>
																		<td class=<?php echo $class18; ?>><?php echo get_cei($cliente['cei_id']); ?></td>
																		<td class=<?php echo $class18; ?>><?php echo $cliente['clte_id']; ?></td>
																		<td class=<?php echo $class18; ?>>
																			<?php echo $cliente['clte_nombre']; ?> 
																			<?php echo $cliente['clte_2_nombre']; ?> 
																			<?php echo $cliente['clte_paterno']; ?> 
																			<?php echo $cliente['clte_materno']; ?>
																			<?php 
																				if (
																					($emp_id == 298) || 
																					($emp_id == 152) || 
																					($emp_id == 182) 
																				   )
																				{
																					$doc= get_serv_clte_doc_path($cliente['clte_id'], $serv['serv_id']);
																					if (strlen($doc) > 2)
																					{	
																						?>		
																							<br><a target="_blank" href="<?php echo base_url('archivos/descarga/docs/'.strtolower($doc)); ?>"><i class="fa fa-download fa-fw fa-lg" style="color:#0000ff;"></i></a>	
																						<?php 
																					}	
																				}																		
																			?>
																		</td>
																		
																		<?php 
																		if  (
																				($emp_id == 298) || 
																				($emp_id == 152) ||
																				($emp_id == 193)
																			)
																		{
																		?>									
																		<td class=<?php echo $class18; ?>><?php echo formatea_fechahora($sujeto['log_insrt_f']); ?></td>
																		<td class=<?php echo $class18; ?>><?php	echo get_ciudad_by_cp($sujeto['clte_env_cp']);?> </td>
																		<?php	
																		}
																		?>												
																		
									<!------------------------------------------------------------------------------------->
																<?php 
													
																foreach (explode(';', $pkts_clte_serv['doc_pkts']) as $pdetalle)
																{
																	
																	/* IMPORTANTE USAR ESTA PARTE PARA ESCANEAR LO EXAMENES QUE NO PUEDEN VERSE
																	if (strlen($pdetalle) > 2 )
																	{
																		echo $pkts_clte_serv['clte_id'].'}',$pdetalle.' '.'codigo: '.get_cat_cve_by_nombre('EXAMEN',$pdetalle).' '.'precio: '.get_serv_monto_by_cve($el_servicio['serv_id'], get_cat_cve_by_nombre('EXAMEN',$pdetalle).';').'<br>';
																	}
																	*/
																	
																	/*if (strstr($pdetalle,'ANALISIS BACTERIOLOGICO DE HIELO'))
																	{												
																		$cuantos['ANALISIS BACTERIOLOGICO DE HIELO']=$pdetalle;
																	}
																	elseif (strstr($pdetalle,'ANALISIS BACTERIOLOGICO DE AGUA'))
																	{												
																		$cuantos['ANALISIS BACTERIOLOGICO DE AGUA']=$pdetalle;
																	}
																	elseif (strstr($pdetalle,'CULTIVO DE ALIMENTO CRUDO'))
																	{												
																		$cuantos['CULTIVO DE ALIMENTO CRUDO']=$pdetalle;
																	}
																	elseif (strstr($pdetalle,'CULTIVO DE ALIMENTO COCIDO'))
																	{												
																		$cuantos['CULTIVO DE ALIMENTO COCIDO']=$pdetalle;
																	}
																	elseif (strstr($pdetalle,'CULTIVO DE SUPERFICIE INERTE'))
																	{												
																		$cuantos['CULTIVO DE SUPERFICIE INERTE']=$pdetalle;
																	}
																	elseif (strstr($pdetalle,'CULTIVO DE SUPERFICIE VIVA'))
																	{												
																		$cuantos['CULTIVO DE SUPERFICIE VIVA']=$pdetalle;
																	}*/
																		
																}						
																
																
																for ($i=1; $i<= $total_pkts; $i++)
																{
																	$cuantos_son=1;
																	
																	if ($titular_pkt[$i] == 'PRUEBA RAPIDA ANTIGENO COVID-19') 
																	{
																		
																		if ($tipo_pkt[$i] == 'MULTIPLE')
																		{   
																		   $linea='<br>';
																			foreach (explode(';',$cont_pkt[$i]) as $nombre)
																			{
																				$que_examen='<a target="_blank" href=';
																				$que_examen.=base_url(select_pdf_examen($nombre,$un_servicio['fsm_id'],$un_servicio['clte_id']));
																				$que_examen.='><i class="fa fa-file-pdf-o fa-fw fa-lg " style="color:#0000ff;"></i></a>';
																				if (strlen($nombre) > 2)
																				{	
																				$linea.=get_cat_nombre('EXAMEN',$nombre).' '.$que_examen.'<br>';	
																				}
														
																				
																			}
																		?> 	
																			<td class=<?php echo $class18; ?>> 
																			<?php  	
																					echo number_format($monto_pkt[$i],2); $total_linea=$total_linea+$monto_pkt[$i]; 
																					echo '<b>'.$linea.'</b>';
																			?>
																			</td>	
																		<?php
																		}
																		else
																		{
																		?> 			
																			<td class=<?php echo $class18; ?>> <?php  echo number_format($monto_pkt[$i],2); $total_linea=$total_linea+$monto_pkt[$i]; ?><br><a target="_blank" href="<?php echo base_url(select_pdf_examen($mi_detalle,$un_servicio['fsm_id'],$un_servicio['clte_id']));/*'Examen/pie/pdf/'.$un_servicio['clte_id'].'/'.$un_servicio['fsm_id']*/ ?>"><i class="fa fa-file-pdf-o fa-fw fa-lg " style="color:#0000ff;"></i></a></td>	
																		<?php 
																		}										
																		
																	}
																	elseif (strstr($pkts_clte_serv['doc_pkts'],$titular_pkt[$i]))
																	{   
																
																		if ( ($emp_id == 152) && ($titular_pkt[$i] == 'EXAMEN MÉDICO') )
																		{
																		?>	
																			<td class=<?php echo $class18; ?>> <?php  echo number_format($zonificación,2); $total_linea=$total_linea+$zonificación; ?></td> 	
																		<?php
																		}
																		else
																		{	
																			if ( ($emp_id == 152) && ($titular_pkt[$i] == 'EXAMEN MÉDICO') )
																			{
																			?>	
																				<td class=<?php echo $class18; ?>> <?php  echo number_format($zonificación,2); $total_linea=$total_linea+$zonificación; ?></td> 	
																			<?php
																			}														
																		?>
																			<td class=<?php echo $class18; ?>> <?php  echo number_format(($monto_pkt[$i]*$cuantos_son),2); $total_linea=$total_linea+($monto_pkt[$i]*$cuantos_son); ?></td>
																		<?php
																		}																		
																	}
																	else
																	{
																		?>	<td class=<?php echo $class18; ?>> <?php  echo '-'; ?></td>  <?php 
																	}	
																}
																?>							
																	<td class=<?php echo $class18; ?> ><?php echo  number_format($total_linea,2); //$pkts_clte_serv['doc_pkts']; ?></td>
																	<td class=<?php echo $class18; ?> ><?php echo number_format($total_linea*1.16,2); ?> </td>
																</tr>
									<!------------------------------------------------------------------------------------->									
														<?php	
																$total_general+=$total_linea;
																endforeach;								
															endif;
														?>
															<tr>
																<td class="auto-style14"></td>
																<td class="auto-style14"></td>
																<td class="auto-style14"></td>
																<td class="auto-style14"></td>
																<?php 
																if  (
																	($emp_id == 298) || 
																	($emp_id == 152) ||
																	($emp_id == 193)
																)
																{
																?>									
																	<td class="auto-style14"></td>
																	<td class="auto-style14"></td>
																<?php	
																}
																?>										
															
																<?php 
																for ($i=1; $i<= $total_pkts; $i++)
																{
																?>
																	<td class="auto-style14"></td>
																<?php
																} 
																?>											
																<td class="auto-style144" ><?php  echo '$'. number_format($total_general,2); ?></td>
																<td class="auto-style144" ><?php  echo '$'.number_format($total_general*1.16,2); ?></td>
															</tr>						
													</table>
												<hr>
										<?php
											}
										}		
								endforeach;	
								}	/*acaba toma de servicios*/
							?>



            </body>
				
		</html><?php 	
	 }	
}