<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Cps extends CI_Controller {
    function __construct() {
        parent::__construct();
        $this->load->model('persona/Persona_model','cliente');
		$this->load->model('servicio/Servicio_model','servicio');
        $this->load->model('empleado/Empleado_model','medico');
        $this->load->model('examen/Cps_model','cps');
		$this->load->helper('util');
		$this->load->helper('report');
    }
    
    public function nuevo($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
        $user = $this->session->user;		
		$medico = $this->medico->get_id(113);

        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
			if (($persona['serv_id'] == 0) ||(get_status_serv($persona['serv_id']) != 'PROCESO'))
			{					
					$this->form_validation->set_rules('servicio','Orden de servicio','required');
			}
			else
			{
					$this->form_validation->set_rules('servicio','Orden de servicio','integer');
			}
            
			
           
            if($this->form_validation->run())
            {
                $data_insert['usr_id']  = $user['usr_id'];
                $data_insert['med_id']  = $user['usr_id'];
                $data_insert['clte_id'] = $persona['clte_id'];
                $data_insert['emp_id']  = $persona['emp_id'];

				if (($persona['serv_id'] == 0) || (get_status_serv($persona['serv_id']) != 'PROCESO'))
				{	
						$data_insert['serv_id']  = $this->input->post('servicio');
				}
				else
				{	
						$data_insert['serv_id']  = $persona['serv_id'];
				}

                $data_insert['cps_medico_sol'] = $this->input->post('medico_sol');
                $data_insert['cps_f_recibido']   =  formatea_fecha_mysql($this->input->post('f_recibido'));
                $data_insert['cps_f_impresion']  =  formatea_fecha_mysql($this->input->post('f_impresion'));
				//$data_insert['cps_fis_resultado']= $this->input->post('fis_resultado');
				$data_insert['cps_fis_resultado1']= $this->input->post('fis_resultado1');
				$data_insert['cps_fis_resultado2']= $this->input->post('fis_resultado2');
				$data_insert['cps_fis_resultado3']= $this->input->post('fis_resultado3');
				
				
				$data_insert['cps_lab'] = $this->input->post('laboratorista');
				
                $data_insert['log_insrt_f']= date('Y-m-d H:i:s'); 
				
				
				
				$data_insert=array_to_upper($data_insert);	
				$data_insert['cps_obs']= $this->input->post('cps_obs'); 
                $data_insert['cps_fuera_rango'] = $this->input->post('fuera_rango'); 

				$data_insert['cps_fis_resultado1_detalle'] = $this->input->post('fis_resultado1_detalle'); 
				$data_insert['cps_fis_resultado2_detalle'] = $this->input->post('fis_resultado2_detalle'); 
				$data_insert['cps_fis_resultado3_detalle'] = $this->input->post('fis_resultado3_detalle'); 
				
                if($this->cps->insert($data_insert))
                {
                    send_json_ok('Se guardó de forma correcta');
					/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
					$servicios=$persona['domserv'];					
					
					$servicio='CPROPA;'; /*CODIGO DEL EXAMEN*/
					if (!(strstr($servicios,$servicio)))
					{							
						$servicios.=$servicio;
						$data_clte['domserv']=$servicios;
						$res=$this->cliente->actualiza_registro_individual($cliente_id, $data_clte);
					}
					/**************************************************/						
                }
                else
                {
                    send_json_error('Ocurrió un error al guardar.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
            $data['medico'] = $medico;
			$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Cps',
                'view' => 'examen/cps/nuevo_form',
                'view_data' => $data 
               );
            render_template($params_view);
        }
    }
    
    public function pdf($cliente_id, $fsm_id)
    {
        $data['persona'] = $this->cliente->get($cliente_id,get_desp_id_usr());
        $data['fsm'] = $this->cps->get($fsm_id,get_desp_id_usr());
        $data['medico'] = $this->medico->get_id($data['fsm']['med_id']);
        $data['empresa'] = $this->cliente->get_empresa_by_id($data['fsm']['emp_id']);
        $this->load->helper('pdf');

		$med_name=$data['fsm']['cps_lab'];
		$emp_id=$data['fsm']['emp_id'];
		$observaciones=$data['fsm']['cps_obs'];
		$fuera_rango=$data['fsm']['cps_fuera_rango'];
		$data_empresa = $this->cliente->get_empresa_by_id($emp_id);
		
		genera_pdf_lab_new_x($this->load->view('examen/cps/pdf',$data,TRUE),'COPROPARASITOSCÓPICO','COPROPARASITOSCÓPICO',$med_name,$observaciones,$fuera_rango);
		
    }

    public function borra_cps($fsm_id)
    {
        if($this->cps->delete_cps($fsm_id))
        {
            send_json_ok('Se eliminó de forma correcta.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar.');
        }
    }


}