<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Imuno extends CI_Controller {
    function __construct() {
        parent::__construct();
        $this->load->model('persona/Persona_model','cliente');
		$this->load->model('servicio/Servicio_model','servicio');
        $this->load->model('empleado/Empleado_model','medico');
        $this->load->model('examen/Imuno_model','imuno');
		$this->load->helper('util');
    }
    
    public function nuevo($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
        $user = $this->session->user;		
		$medico = $this->medico->get_id(113);

        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
			if (($persona['serv_id'] == 0) ||(get_status_serv($persona['serv_id']) != 'PROCESO'))
			{					
					$this->form_validation->set_rules('servicio','Orden de servicio','required');
			}
			else
			{
					$this->form_validation->set_rules('servicio','Orden de servicio','integer');
			}
            
			//$this->form_validation->set_rules('fis_resultado','GONADOTROPINA CORIÓNICA HUMANA','required'); 
           
            if($this->form_validation->run())
            {
                $data_insert['usr_id']  = $medico['usr_id'];
                $data_insert['med_id']  = $medico['usr_id'];
                $data_insert['clte_id'] = $persona['clte_id'];
                $data_insert['emp_id']  = $persona['emp_id'];

				if (($persona['serv_id'] == 0) || (get_status_serv($persona['serv_id']) != 'PROCESO'))
				{	
						$data_insert['serv_id']  = $this->input->post('servicio');
				}
				else
				{	
						$data_insert['serv_id']  = $persona['serv_id'];
				}

                $data_insert['imuno_medico_sol'] = $this->input->post('medico_sol');
                $data_insert['imuno_f_recibido']   =  formatea_fecha_mysql($this->input->post('f_recibido'));
                $data_insert['imuno_f_impresion']  =  formatea_fecha_mysql($this->input->post('f_impresion'));
				
				$data_insert['imuno_alt_o_tgp']= $this->input->post('alt_o_tgp');
				$data_insert['imuno_fosfata_alcalina']= $this->input->post('fosfata_alcalina');
				$data_insert['imuno_lactato']= $this->input->post('lactato');
				
				
				
				$data_insert['imuno_lab'] = $this->input->post('laboratorista');
				$data_insert['imuno_obs']= $this->input->post('imuno_obs'); 
                $data_insert['log_insrt_f']= date('Y-m-d H:i:s'); 
				
				
				
				$data_insert=array_to_upper($data_insert);	
				
                 
				
                if($this->imuno->insert($data_insert))
                {
                    send_json_ok('Se guardó de forma correcta');
					/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
					$servicios=$persona['domserv'];					
					
					$servicio='HBA1C;'; /*CODIGO DEL EXAMEN*/
					if (!(strstr($servicios,$servicio)))
					{							
						$servicios.=$servicio;
						$data_clte['domserv']=$servicios;
						$res=$this->cliente->actualiza_registro_individual($cliente_id, $data_clte);
					}
					/**************************************************/						
                }
                else
                {
                    send_json_error('Ocurrió un error al guardar.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
            $data['medico'] = $medico;
			$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Imuno',
                'view' => 'examen/imuno/nuevo_form',
                'view_data' => $data 
               );
            render_template($params_view);
        }
    }
    
    public function pdf($cliente_id, $fsm_id)
    {
        $data['persona'] = $this->cliente->get($cliente_id,get_desp_id_usr());
        $data['fsm'] = $this->imuno->get($fsm_id,get_desp_id_usr());
        $data['medico'] = $this->medico->get_id($data['fsm']['med_id']);
        $data['empresa'] = $this->cliente->get_empresa_by_id($data['fsm']['emp_id']);
        $this->load->helper('pdf');

		$med_name=$data['fsm']['imuno_lab'];
		$emp_id=$data['fsm']['emp_id'];
		$observaciones=$data['fsm']['imuno_obs'];
		$data_empresa = $this->cliente->get_empresa_by_id($emp_id);
		if ($data_empresa['emp_giro'] == 'SEGURIDAD')
		{
			genera_pdf_tohuanti($this->load->view('examen/imuno/pdf',$data,TRUE),'imuno','imuno');
		}
		else
		{	
			genera_pdf_lab_new($this->load->view('examen/imuno/pdf',$data,TRUE),'imuno','imuno',$med_name,$observaciones);		
		}
    }

    public function borra_imuno($fsm_id)
    {
        if($this->imuno->delete_imuno($fsm_id))
        {
            send_json_ok('Se eliminó de forma correcta.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar.');
        }
    }


}