<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Percepcion_cromatica extends CI_Controller {
    function __construct() {
        parent::__construct();
        $this->load->model('persona/Persona_model','cliente');
		/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
		$this->load->model('servicio/Servicio_model','servicio');
		/*************************************************/			
        $this->load->model('empleado/Empleado_model','medico');
        $this->load->model('examen/Percepcion_cromatica_model','percepcion_cromatica');
		$this->load->helper('util');
    }
    
    public function nuevo($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
		
        $user = $this->session->user;
		$medico = $this->medico->get_id(302);
	
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
			/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
			if (($persona['serv_id'] == 0) ||(get_status_serv($persona['serv_id']) != 'PROCESO'))
			{
					$this->form_validation->set_rules('servicio','Orden de servicio','required');
			}
            /*************************************************/
            $this->form_validation->set_rules('fsm_med_vis_cve','CAMPO VISUAL','required');
            $this->form_validation->set_rules('fsm_med_aud_cve','ESTEREOPSIS','required');
            $this->form_validation->set_rules('fsm_med_olf_cve','PERCEPCIÓN CROMÁTICA','required');

            
            if($this->form_validation->run())
            {
                $data_insert['emp_id']  = $persona['emp_id'];
                $data_insert['clte_id'] = $persona['clte_id'];
                $data_insert['usr_id']  = $user['usr_id'];
				/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
				if (($persona['serv_id'] == 0) || (get_status_serv($persona['serv_id']) != 'PROCESO'))
				{	
						$data_insert['serv_id']  = $this->input->post('servicio');
				}
				else
				{	
						$data_insert['serv_id']  = $persona['serv_id'];
				}
				/**************************************************/
                //id empleado claudio nieves
                $data_insert['med_id']  = $this->input->post('medicos');;
                $data_insert['fsm_f']   = date("Y-m-d H:i:s");
				$res='NORMAL'; //$res='XXXX';
                $data_insert['fsm_med_vis_cve']     =   $this->input->post('fsm_med_vis_cve');
                $data_insert['fsm_med_vis_info']    =	($this->input->post('fsm_med_vis_info') != '')?$this->input->post('fsm_med_vis_info'):$res;
                $data_insert['fsm_med_aud_cve']     =	$this->input->post('fsm_med_aud_cve');
                $data_insert['fsm_med_aud_info']    =	($this->input->post('fsm_med_aud_info') != '')?$this->input->post('fsm_med_aud_info'):$res;
                $data_insert['fsm_med_olf_cve']     =	$this->input->post('fsm_med_olf_cve');
                $data_insert['fsm_med_olf_info']    =	($this->input->post('fsm_med_olf_info') != '')?$this->input->post('fsm_med_olf_info'):$res;
                $data_insert['fsm_med_pul_cve']     =	$this->input->post('fsm_med_pul_cve');
                $data_insert['fsm_med_pul_info']    =	($this->input->post('fsm_med_pul_info') != '')?$this->input->post('fsm_med_pul_info'):$res;
                $data_insert['fsm_fis_ref_cve']     =	$this->input->post('fsm_fis_ref_cve');
                $data_insert['fsm_fis_ref_info']    =	($this->input->post('fsm_fis_ref_info') != '')?$this->input->post('fsm_fis_ref_info'):$res;
                $data_insert['fsm_fis_cond_cve']    =	$this->input->post('fsm_fis_cond_cve');
                $data_insert['fsm_fis_cond_info']   =	($this->input->post('fsm_fis_cond_info') != '')?$this->input->post('fsm_fis_cond_info'):$res;
                $data_insert['fsm_fis_res_cve']     =	$this->input->post('fsm_fis_res_cve');
                $data_insert['fsm_fis_res_info']    =	($this->input->post('fsm_fis_res_info') != '')?$this->input->post('fsm_fis_res_info'):$res;
                $data_insert['fsm_fis_loc_cve']     =	$this->input->post('fsm_fis_loc_cve');
                $data_insert['fsm_fis_loc_info']    =	($this->input->post('fsm_fis_loc_info') != '')?$this->input->post('fsm_fis_loc_info'):$res;
                $data_insert['log_insrt_f']  =  date('Y-m-d H:i:s');
                if($this->percepcion_cromatica->insert(array_to_upper($data_insert)))
                {
                    send_json_ok('Se guardó de forma correcta');
					/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
					$servicios=$persona['domserv'];					
					
					$servicio='MEDFIS;'; /*CODIGO DEL EXAMEN*/
					if (!(strstr($servicios,$servicio)))
					{							
						$servicios.=$servicio;
						$data_clte['domserv']=$servicios;
						$res=$this->cliente->actualiza_registro_individual($cliente_id, $data_clte);
					}
					/**************************************************/						
                }
                else
                {
                    send_json_error('Ocurrió un error al guardar.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
            $data['medico'] = $medico;
			/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
			$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);
			/**************************************************/			
            $this->load->helper('template');
            $params_view = array(
                'title' => '',
                'view' => 'examen/percepcion_cromatica/nuevo_form',
                'view_data' => $data 
               );
            render_template($params_view);
        }
    }
    
    public function pdf($cliente_id, $fsm_id) 
    {
        $data['persona'] = $this->cliente->get($cliente_id,get_desp_id_usr());
        $data['fsm'] = $this->percepcion_cromatica->get($fsm_id,get_desp_id_usr());
        $data['medico'] = $this->medico->get_id($data['fsm']['med_id']);
        $data['empresa'] = $this->cliente->get_empresa_by_id($data['fsm']['emp_id']);
        $this->load->helper('pdf');
		
		//genera_pdf($this->load->view('examen/percepcion_cromatica/pdf',$data,TRUE),'percepcion_cromatica','percepcion_cromatica','percepcion_cromatica');
		 // xample($this->load->view('examen/percepcion_cromatica/pdf',$data,TRUE),'percepcion_cromatica','percepcion_cromatica','percepcion_cromatica','Humancenter Review S.A de C.V.');
		genera_pdf_lab_new_y($this->load->view('examen/percepcion_cromatica/pdf',$data,TRUE),'percepcion_cromatica','percepcion_cromatica',$med_name,$observaciones,$fuera_rango);
	}
	
    public function nuevo_serviseg($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
		
        $user = $this->session->user;
		

		$medico = $this->medico->get_id(302);

		
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
			/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
			if (($persona['serv_id'] == 0) ||(get_status_serv($persona['serv_id']) != 'PROCESO'))
			{
					$this->form_validation->set_rules('servicio','Orden de servicio','required');
			}
            /*************************************************/
            $this->form_validation->set_rules('fsm_med_vis_cve','Visual','required');
            //$this->form_validation->set_rules('fsm_med_vis_info','required');
            $this->form_validation->set_rules('fsm_med_aud_cve','Auditivo','required');
            //$this->form_validation->set_rules('fsm_med_aud_info','required');
            $this->form_validation->set_rules('fsm_med_olf_cve','Percepción de olores','required');
            //$this->form_validation->set_rules('fsm_med_olf_info','required');
            $this->form_validation->set_rules('fsm_med_pul_cve','Cardiopulmonar','required');
            //$this->form_validation->set_rules('fsm_med_pul_info','required');
            $this->form_validation->set_rules('fsm_fis_ref_cve','Reflejo','required');
            //$this->form_validation->set_rules('fsm_fis_ref_info','required');
            $this->form_validation->set_rules('fsm_fis_cond_cve','Condición','required');
            //$this->form_validation->set_rules('fsm_fis_cond_info','required');
            $this->form_validation->set_rules('fsm_fis_res_cve','Resistencia','required');
            //$this->form_validation->set_rules('fsm_fis_res_info','required');
            $this->form_validation->set_rules('fsm_fis_loc_cve','Locomoción','required');
            // $this->form_validation->set_rules('fsm_fis_loc_info','required'); 
            
            if($this->form_validation->run())
            {
                $data_insert['emp_id']  = $persona['emp_id'];
                $data_insert['clte_id'] = $persona['clte_id'];
                $data_insert['usr_id']  = $user['usr_id'];
				/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
				if (($persona['serv_id'] == 0) || (get_status_serv($persona['serv_id']) != 'PROCESO'))
				{	
						$data_insert['serv_id']  = $this->input->post('servicio');
				}
				else
				{	
						$data_insert['serv_id']  = $persona['serv_id'];
				}
				/**************************************************/
                $data_insert['med_id']  = $medico['usr_id'];
                //$data_insert['fsm_f']   = date("Y-m-d H:i:s");
				$data_insert['fsm_f']   = $this->input->post('fecha_eva');
				$res='NORMAL'; //$res='XXXX';
                $data_insert['fsm_med_vis_cve']     =   $this->input->post('fsm_med_vis_cve');
                $data_insert['fsm_med_vis_info']    =	($this->input->post('fsm_med_vis_info') != '')?$this->input->post('fsm_med_vis_info'):$res;
                $data_insert['fsm_med_aud_cve']     =	$this->input->post('fsm_med_aud_cve');
                $data_insert['fsm_med_aud_info']    =	($this->input->post('fsm_med_aud_info') != '')?$this->input->post('fsm_med_aud_info'):$res;
                $data_insert['fsm_med_olf_cve']     =	$this->input->post('fsm_med_olf_cve');
                $data_insert['fsm_med_olf_info']    =	($this->input->post('fsm_med_olf_info') != '')?$this->input->post('fsm_med_olf_info'):$res;
                $data_insert['fsm_med_pul_cve']     =	$this->input->post('fsm_med_pul_cve');
                $data_insert['fsm_med_pul_info']    =	($this->input->post('fsm_med_pul_info') != '')?$this->input->post('fsm_med_pul_info'):$res;
                $data_insert['fsm_fis_ref_cve']     =	$this->input->post('fsm_fis_ref_cve');
                $data_insert['fsm_fis_ref_info']    =	($this->input->post('fsm_fis_ref_info') != '')?$this->input->post('fsm_fis_ref_info'):$res;
                $data_insert['fsm_fis_cond_cve']    =	$this->input->post('fsm_fis_cond_cve');
                $data_insert['fsm_fis_cond_info']   =	($this->input->post('fsm_fis_cond_info') != '')?$this->input->post('fsm_fis_cond_info'):$res;
                $data_insert['fsm_fis_res_cve']     =	$this->input->post('fsm_fis_res_cve');
                $data_insert['fsm_fis_res_info']    =	($this->input->post('fsm_fis_res_info') != '')?$this->input->post('fsm_fis_res_info'):$res;
                $data_insert['fsm_fis_loc_cve']     =	$this->input->post('fsm_fis_loc_cve');
                $data_insert['fsm_fis_loc_info']    =	($this->input->post('fsm_fis_loc_info') != '')?$this->input->post('fsm_fis_loc_info'):$res;
                
                if($this->percepcion_cromatica->insert(array_to_upper($data_insert)))
                {
                    send_json_ok('Se guardó de forma correcta');
                }
                else
                {
                    send_json_error('Ocurrió un error al guardar.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
            $data['medico'] = $medico;
			/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
			$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);
			/**************************************************/
            $this->load->helper('template');
            $params_view = array(
                'title' => '',
                'view' => 'examen/percepcion_cromatica/nuevo_form_serviseg',
                'view_data' => $data 
               );
            render_template($params_view);
        }
    }
  
    public function edita_serviseg($cliente_id,$fsm_id)
    {
        $persona = $this->cliente->get($cliente_id);		
        $user = $this->session->user;
		$medico = $this->medico->get_id(293);
		$data['fsm'] = $this->percepcion_cromatica->get($fsm_id);
		$empresa = $this->cliente->get_empresa_by_id($persona['emp_id']);
		
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
            
            if(true)
            {
                //$data_insert['fsm_f']   = date("Y-m-d H:i:s");
				$data_insert['fsm_f']   = $this->input->post('fecha_eva');
				$res='NORMAL'; 
                $data_insert['fsm_med_vis_cve']     =   $this->input->post('fsm_med_vis_cve');
                $data_insert['fsm_med_vis_info']    =	($this->input->post('fsm_med_vis_info') != '')?$this->input->post('fsm_med_vis_info'):$res;
                $data_insert['fsm_med_aud_cve']     =	$this->input->post('fsm_med_aud_cve');
                $data_insert['fsm_med_aud_info']    =	($this->input->post('fsm_med_aud_info') != '')?$this->input->post('fsm_med_aud_info'):$res;
                $data_insert['fsm_med_olf_cve']     =	$this->input->post('fsm_med_olf_cve');
                $data_insert['fsm_med_olf_info']    =	($this->input->post('fsm_med_olf_info') != '')?$this->input->post('fsm_med_olf_info'):$res;
                $data_insert['fsm_med_pul_cve']     =	$this->input->post('fsm_med_pul_cve');
                $data_insert['fsm_med_pul_info']    =	($this->input->post('fsm_med_pul_info') != '')?$this->input->post('fsm_med_pul_info'):$res;
                $data_insert['fsm_fis_ref_cve']     =	$this->input->post('fsm_fis_ref_cve');
                $data_insert['fsm_fis_ref_info']    =	($this->input->post('fsm_fis_ref_info') != '')?$this->input->post('fsm_fis_ref_info'):$res;
                $data_insert['fsm_fis_cond_cve']    =	$this->input->post('fsm_fis_cond_cve');
                $data_insert['fsm_fis_cond_info']   =	($this->input->post('fsm_fis_cond_info') != '')?$this->input->post('fsm_fis_cond_info'):$res;
                $data_insert['fsm_fis_res_cve']     =	$this->input->post('fsm_fis_res_cve');
                $data_insert['fsm_fis_res_info']    =	($this->input->post('fsm_fis_res_info') != '')?$this->input->post('fsm_fis_res_info'):$res;
                $data_insert['fsm_fis_loc_cve']     =	$this->input->post('fsm_fis_loc_cve');
                $data_insert['fsm_fis_loc_info']    =	($this->input->post('fsm_fis_loc_info') != '')?$this->input->post('fsm_fis_loc_info'):$res;
 

				$data_insert=array_to_upper($data_insert);
				$this->db->trans_start();
               
                if($this->percepcion_cromatica->update($fsm_id, $data_insert)) 
                {
                    send_json_ok('Se guardó de forma correcta');
                }
                else
                {
                    send_json_error('Ocurrió un error al guardar.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
            $data['medico'] = $medico;
            $this->load->helper('template');
            $params_view = array(
                'title' => '',
                'view' => 'examen/percepcion_cromatica/edita_form_serviseg',
                'view_data' => $data 
               );
            render_template($params_view);
        }
    }


  
    public function pdf_serviseg($cliente_id, $fsm_id) 
    {
        $data['persona'] = $this->cliente->get($cliente_id,get_desp_id_usr());
        $data['fsm'] = $this->percepcion_cromatica->get($fsm_id,get_desp_id_usr());
        $data['medico'] = $this->medico->get_id($data['fsm']['med_id']);
        $data['empresa'] = $this->cliente->get_empresa_by_id($data['fsm']['emp_id']);
        $this->load->helper('pdf');
		$evaluado= $data['persona']['clte_nombre'].' ';		
		if ( strlen($data['persona']['clte_2_nombre']) > 0)
		{
			$evaluado= $evaluado.$data['persona']['clte_2_nombre'].' ';
		}				
		$evaluado= $evaluado.$data['persona']['clte_paterno'].' ';			
		$evaluado= $evaluado.$data['persona']['clte_materno'].' ';
		//genera_pdf_lab_new_y($this->load->view('examen/percepcion_cromatica/pdf_serviseg',$data,TRUE),'percepcion_cromatica','percepcion_cromatica',$med_name,$observaciones,$fuera_rango);
       // genera_pdf($this->load->view('examen/percepcion_cromatica/pdf_serviseg',$data,TRUE),'percepcion_cromatica','percepcion_cromatica','percepcion_cromatica');
		genera_pdf_new_reporte_poli($this->load->view('examen/percepcion_cromatica/pdf_serviseg',$data,TRUE),'percepcion_cromatica','percepcion_cromatica',$evaluado);

   }	

    public function borra_percepcion_cromatica($fsm_id)
    {
        if($this->percepcion_cromatica->delete_percepcion_cromatica($fsm_id))
        {
            send_json_ok('Se eliminó de forma correcta.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar.');
        }
    }		
	
	
}