<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Flotilla extends CI_Controller {
    function __construct() {
        parent::__construct();
        $this->load->model('persona/Persona_model','cliente');
		$this->load->model('servicio/Servicio_model','servicio');
        $this->load->model('empleado/Empleado_model','medico');
        $this->load->model('examen/Flotilla_model','flotilla');
		$this->load->helper('util');
		$this->load->helper('report');
		$this->load->helper('laboratorx');
    }
    public function grafica($cliente_id,$fsm_id)
    {
        $persona = $this->cliente->get($cliente_id);
		$data['fsm'] = $this->flotilla->get($fsm_id);
        $user = $this->session->user;		

        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
			if (($persona['serv_id'] == 0) ||(get_status_serv($persona['serv_id']) != 'PROCESO'))
			{					
					$this->form_validation->set_rules('servicio','Orden de servicio','required');
			}
			else
			{
					$this->form_validation->set_rules('servicio','Orden de servicio','integer');
			}
            
			$this->form_validation->set_rules('razon_social','Razón Social','required'); 
            $this->form_validation->set_rules('giro_negocio','Giro del Negocio','required'); 
			$this->form_validation->set_rules('tamano_empresa','Tamaño de la empresa (empleados)','required'); 
		   
            if($this->form_validation->run())
            {
                $data_update['usr_id']  = $user['usr_id']; 
				$data_update['med_id']  = $user['usr_id'];  //$this->input->post('laboratorista'); 
				
                $data_update['clte_id'] = $persona['clte_id'];
                $data_update['emp_id']  = $persona['emp_id'];

				if (($persona['serv_id'] == 0) || (get_status_serv($persona['serv_id']) != 'PROCESO'))
				{	
						$data_update['serv_id']  = $this->input->post('servicio');
				}
				else
				{	
						$data_update['serv_id']  = $persona['serv_id'];
				}

                $data_update['flotilla_razon_social'] = $this->input->post('razon_social');
                $data_update['flotilla_giro_negocio'] = $this->input->post('giro_negocio');
                $data_update['flotilla_tamano_empresa'] = $this->input->post('tamano_empresa');
                $data_update['flotilla_tamano_empresa_venta'] = $this->input->post('tamano_empresa_venta');
                $data_update['flotilla_domicilio'] = $this->input->post('domicilio');
                $data_update['flotilla_contacto'] = $this->input->post('contacto');
                $data_update['flotilla_email'] = $this->input->post('email');
                $data_update['flotilla_telefono'] = $this->input->post('telefono');
                $data_update['flotilla_rfc'] = $this->input->post('rfc');

				$data_update['flotilla_costo_examen_medico_ingreso'] = $this->input->post('costo_examen_medico_ingreso');
				$data_update['flotilla_nc_examen_medico_ingreso'] = $this->input->post('nc_examen_medico_ingreso');
				$data_update['flotilla_costo_agudeza_visual'] = $this->input->post('costo_agudeza_visual');
				$data_update['flotilla_nc_agudeza_visual'] = $this->input->post('nc_agudeza_visual');
				$data_update['flotilla_costo_examenes_laboratorio'] = $this->input->post('costo_examenes_laboratorio');
				$data_update['flotilla_nc_examenes_laboratorio'] = $this->input->post('nc_examenes_laboratorio');
				$data_update['flotilla_costo_det_psicotropicas'] = $this->input->post('costo_det_psicotropicas');
				$data_update['flotilla_nc_det_psicotropicas'] = $this->input->post('nc_det_psicotropicas');
				$data_update['flotilla_costo_alcoholimetria'] = $this->input->post('costo_alcoholimetria');
				$data_update['flotilla_nc_alcoholimetria'] = $this->input->post('nc_alcoholimetria');
				$data_update['flotilla_costo_p_psicologico'] = $this->input->post('costo_p_psicologico');
				$data_update['flotilla_nc_p_psicologico'] = $this->input->post('nc_p_psicologico');
				$data_update['flotilla_nc_cond_mecanicas'] = $this->input->post('nc_cond_mecanicas');
				$data_update['flotilla_nc_kilometraje'] = $this->input->post('nc_kilometraje');
				$data_update['flotilla_nc_rutas_manejo'] = $this->input->post('nc_rutas_manejo');
				$data_update['flotilla_nc_m_gps'] = $this->input->post('nc_m_gps');
				$data_update['flotilla_nc_p_federales'] = $this->input->post('nc_p_federales');
				$data_update['flotilla_nc_c_p'] = $this->input->post('nc_c_p');

                $data_update['flotilla_medico_sol'] = $this->input->post('medico_sol');
				$data_update['flotilla_f_recibido']   =  formatea_fecha_mysql($this->input->post('f_recibido'));
                $data_update['flotilla_f_impresion']  =  formatea_fecha_mysql($this->input->post('f_impresion'));
				$data_update['flotilla_fis_resultado']= $this->input->post('fis_resultado');
				$data_update['flotilla_lab'] = $this->input->post('laboratorista');

                $data_update['log_insrt_f']= date('Y-m-d H:i:s'); 
				
				
				$data_update['flotilla_obs']= $this->input->post('flotilla_obs');
				$data_update=array_to_upper($data_update);	
				/*$data_update['flotilla_fuera_rango'] = $this->input->post('fuera_rango');*/
                 
				
                if($this->flotilla->update($fsm_id, $data_update))
                {
                    send_json_ok('Se guardó de forma correcta');
					$servicios=$persona['domserv'];					
					$servicio='FLOTILLA;'; /*CODIGO DEL EXAMEN*/
					if (!(strstr($servicios,$servicio)))
					{							
						$servicios.=$servicio;
						$data_clte['domserv']=$servicios;
						$data_clte['clte_status_proc'] = 'EN PROCESO';
						$res=$this->cliente->actualiza_registro_individual($cliente_id, $data_clte);
					}
                }
                else
                {
					if ($metodo == 0)
					{	send_json_error('No has elegido el Método.'); 	}
					else { send_json_error('Ocurrió un error al guardar.'); }
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
            $data['medico'] = $medico;
			$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);
            $this->load->helper('template');
            $params_view = array(
                'title' => 'flotilla',
                'view' => 'examen/flotilla/grafica_form',
                'view_data' => $data 
               );
            render_template($params_view);
        }
    }
    public function nuevo($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
        $user = $this->session->user;		

        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
			if (($persona['serv_id'] == 0) ||(get_status_serv($persona['serv_id']) != 'PROCESO'))
			{					
					$this->form_validation->set_rules('servicio','Orden de servicio','required');
			}
			else
			{
					$this->form_validation->set_rules('servicio','Orden de servicio','integer');
			}
            
			$this->form_validation->set_rules('razon_social','Razón Social','required'); 
            $this->form_validation->set_rules('giro_negocio','Giro del Negocio','required'); 
			$this->form_validation->set_rules('tamano_empresa','Tamaño de la empresa (empleados)','required'); 
		   
            if($this->form_validation->run())
            {
                $data_insert['usr_id']  = $user['usr_id']; 
				$data_insert['med_id']  = $user['usr_id'];  //$this->input->post('laboratorista'); 
				
                $data_insert['clte_id'] = $persona['clte_id'];
                $data_insert['emp_id']  = $persona['emp_id'];

				if (($persona['serv_id'] == 0) || (get_status_serv($persona['serv_id']) != 'PROCESO'))
				{	
						$data_insert['serv_id']  = $this->input->post('servicio');
				}
				else
				{	
						$data_insert['serv_id']  = $persona['serv_id'];
				}

                $data_insert['flotilla_razon_social'] = $this->input->post('razon_social');
                $data_insert['flotilla_giro_negocio'] = $this->input->post('giro_negocio');
                $data_insert['flotilla_tamano_empresa'] = $this->input->post('tamano_empresa');
                $data_insert['flotilla_tamano_empresa_venta'] = $this->input->post('tamano_empresa_venta');
                $data_insert['flotilla_domicilio'] = $this->input->post('domicilio');
                $data_insert['flotilla_contacto'] = $this->input->post('contacto');
                $data_insert['flotilla_email'] = $this->input->post('email');
                $data_insert['flotilla_telefono'] = $this->input->post('telefono');
                $data_insert['flotilla_rfc'] = $this->input->post('rfc');

                $data_insert['flotilla_medico_sol'] = $this->input->post('medico_sol');
                $data_insert['flotilla_f_recibido']   =  formatea_fecha_mysql($this->input->post('f_recibido'));
                $data_insert['flotilla_f_impresion']  =  formatea_fecha_mysql($this->input->post('f_impresion'));
				$data_insert['flotilla_fis_resultado']= $this->input->post('fis_resultado');
				$data_insert['flotilla_lab'] = $this->input->post('laboratorista');
				//$data_insert['flotilla_metodo'] = $this->input->post('laboratorio_metodo');
				$metodo= 1; //$this->input->post('laboratorio_metodo');
                $data_insert['log_insrt_f']= date('Y-m-d H:i:s'); 
				
				
				$data_insert['flotilla_obs']= $this->input->post('flotilla_obs');
				$data_insert=array_to_upper($data_insert);	
				/*$data_insert['flotilla_fuera_rango'] = $this->input->post('fuera_rango');*/
                 
				
                if ($this->flotilla->insert($data_insert))
                {
                    send_json_ok('Se guardó de forma correcta');
					$servicios=$persona['domserv'];					
					$servicio='FLOTILLA;'; /*CODIGO DEL EXAMEN*/
					if (!(strstr($servicios,$servicio)))
					{							
						$servicios.=$servicio;
						$data_clte['domserv']=$servicios;
						$data_clte['clte_status_proc'] = 'EN PROCESO';
						$res=$this->cliente->actualiza_registro_individual($cliente_id, $data_clte);
					}
                }
                else
                {
					if ($metodo == 0)
					{	send_json_error('No has elegido el Método.'); 	}
					else { send_json_error('Ocurrió un error al guardar.'); }
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
            $data['medico'] = $medico;
			$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Hba1c',
                'view' => 'examen/flotilla/nuevo_form',
                'view_data' => $data 
               );
            render_template($params_view);
        }
    }

 
    public function edita($cliente_id,$fsm_id)
    {
        $persona = $this->cliente->get($cliente_id);
		$data['fsm'] = $this->flotilla->get($fsm_id);
        $user = $this->session->user;


		$this->db->select('*');
		$this->db->from('fsm_arvp');
		$this->db->where('serv_id',$data['fsm']['serv_id']);
		$result = $this->db->get();
		//echo print_r($result);
		$cuantos_vehiculos=$result->num_rows();
		
		if ($cuantos_vehiculos == 0)
		{
			$nivel_cumplimiento_vehiculos=0;
		}	
		else
		{
			$this->db->select_sum('fsm_riesgo_total');
			$this->db->from('fsm_arvp');
			$this->db->where('serv_id',$data['fsm']['serv_id']);
			$result = $this->db->get();
			//echo print_r($result);
			$suma=$result->result_array();
			//echo print_r($suma);
			$suma_de_riesgo_total=$suma[0]['fsm_riesgo_total'];
			
			$nivel_cumplimiento_vehiculos=($suma_de_riesgo_total/$cuantos_vehiculos);
		
			$nivel_cumplimiento_vehiculos=($nivel_cumplimiento_vehiculos/205)*100;
		}	
		
		//$nivel_cumplimiento_vehiculos=get_nivel_cumplimiento_vehiculos($data['fsm']['serv_id']); 

        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
			if (($persona['serv_id'] == 0) ||(get_status_serv($persona['serv_id']) != 'PROCESO'))
			{					
					$this->form_validation->set_rules('servicio','Orden de servicio','required');
			}
			else
			{
					$this->form_validation->set_rules('servicio','Orden de servicio','integer');
			}
            
			$this->form_validation->set_rules('razon_social','Razón Social','required'); 
            $this->form_validation->set_rules('giro_negocio','Giro del Negocio','required'); 
			$this->form_validation->set_rules('tamano_empresa','Tamaño de la empresa (empleados)','required'); 
		   
            if($this->form_validation->run())
            {
                $data_update['usr_id']  = $user['usr_id']; 
				$data_update['med_id']  = $user['usr_id'];  //$this->input->post('laboratorista'); 
				
                $data_update['clte_id'] = $persona['clte_id'];
                $data_update['emp_id']  = $persona['emp_id'];

				if (($persona['serv_id'] == 0) || (get_status_serv($persona['serv_id']) != 'PROCESO'))
				{	
						$data_update['serv_id']  = $this->input->post('servicio');
				}
				else
				{	
						$data_update['serv_id']  = $persona['serv_id'];
				}

                $data_update['flotilla_razon_social'] = $this->input->post('razon_social');
                $data_update['flotilla_giro_negocio'] = $this->input->post('giro_negocio');
                $data_update['flotilla_tamano_empresa'] = $this->input->post('tamano_empresa');
                $data_update['flotilla_tamano_empresa_venta'] = $this->input->post('tamano_empresa_venta');
                $data_update['flotilla_domicilio'] = $this->input->post('domicilio');
                $data_update['flotilla_contacto'] = $this->input->post('contacto');
                $data_update['flotilla_email'] = $this->input->post('email');
                $data_update['flotilla_telefono'] = $this->input->post('telefono');
                $data_update['flotilla_rfc'] = $this->input->post('rfc');

				$data_update['flotilla_costo_examen_medico_ingreso'] = $this->input->post('costo_examen_medico_ingreso');
				$data_update['flotilla_nc_examen_medico_ingreso'] = $this->input->post('nc_examen_medico_ingreso');
				$data_update['flotilla_costo_agudeza_visual'] = $this->input->post('costo_agudeza_visual');
				$data_update['flotilla_nc_agudeza_visual'] = $this->input->post('nc_agudeza_visual');
				$data_update['flotilla_costo_examenes_laboratorio'] = $this->input->post('costo_examenes_laboratorio');
				$data_update['flotilla_nc_examenes_laboratorio'] = $this->input->post('nc_examenes_laboratorio');
				$data_update['flotilla_costo_det_psicotropicas'] = $this->input->post('costo_det_psicotropicas');
				$data_update['flotilla_nc_det_psicotropicas'] = $this->input->post('nc_det_psicotropicas');
				$data_update['flotilla_costo_alcoholimetria'] = $this->input->post('costo_alcoholimetria');
				$data_update['flotilla_nc_alcoholimetria'] = $this->input->post('nc_alcoholimetria');
				$data_update['flotilla_costo_p_psicologico'] = $this->input->post('costo_p_psicologico');
				$data_update['flotilla_nc_p_psicologico'] = $this->input->post('nc_p_psicologico');
				
				$data_update['flotilla_nc_cond_mecanicas'] = $this->input->post('nc_cond_mecanicas');
				$data_update['flotilla_nc_kilometraje'] = $this->input->post('nc_kilometraje');
				$data_update['flotilla_nc_rutas_manejo'] = $this->input->post('nc_rutas_manejo');
				$data_update['flotilla_nc_m_gps'] = $this->input->post('nc_m_gps');
				$data_update['flotilla_nc_p_federales'] = $this->input->post('nc_p_federales');
				$data_update['flotilla_nc_c_p'] = $this->input->post('nc_c_p');

$data_update['flotilla_nc_estudio_socioeconomico'] = $this->input->post('flotilla_nc_estudio_socioeconomico');
$data_update['flotilla_nc_nom035'] = $this->input->post('flotilla_nc_nom035');

                $data_update['flotilla_medico_sol'] = $this->input->post('medico_sol');
				$data_update['flotilla_f_recibido']   =  formatea_fecha_mysql($this->input->post('f_recibido'));
                $data_update['flotilla_f_impresion']  =  formatea_fecha_mysql($this->input->post('f_impresion'));
				$data_update['flotilla_fis_resultado']= $this->input->post('fis_resultado');
				$data_update['flotilla_lab'] = $this->input->post('laboratorista');

                $data_update['log_insrt_f']= date('Y-m-d H:i:s'); 
				
				
				$data_update['flotilla_obs']= $this->input->post('flotilla_obs');
				$data_update=array_to_upper($data_update);	
				/*$data_update['flotilla_fuera_rango'] = $this->input->post('fuera_rango');*/

				if(!empty($_FILES['documento']['name']))
                {
                    
					$pre_croquis= carga_imagen('documento','./../../files/docs/');

					if (!($pre_croquis))
                    {                        
						send_json_error('El documento no se ha podido cargar, por favor revisa');
                    }
                    else 
                    {
						$data_clte['doc_path'] = $pre_croquis;					
                        $data_update['flotilla_doc_path'] = $data_clte['doc_path'];
					}
				}

                 
				
                if($this->flotilla->update($fsm_id, $data_update))
                {
                    //send_json_ok('Se guardó de forma correcta');
					send_json_ok(array('msg' =>'Se registro de forma correcta', 'id' => $cliente_id));
					$servicios=$persona['domserv'];					
					$servicio='FLOTILLA;'; /*CODIGO DEL EXAMEN*/
					if (!(strstr($servicios,$servicio)))
					{							
						$servicios.=$servicio;
						$data_clte['domserv']=$servicios;
						$data_clte['clte_status_proc'] = 'EN PROCESO';
						$res=$this->cliente->actualiza_registro_individual($cliente_id, $data_clte);
					}
                }
                else
                {
					send_json_error('Ocurrió un error al guardar.'); 
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
            $data['medico'] = $medico;
			$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);
            $data['nivel_cumplimiento_vehiculos']=$nivel_cumplimiento_vehiculos;
			$this->load->helper('template');
            $params_view = array(
                'title' => 'flotilla',
                'view' => 'examen/flotilla/edit_form',
                'view_data' => $data 
               );
            render_template($params_view);
        }
    }
    
    public function pdf($cliente_id, $fsm_id)
    {
        $data['persona'] = $this->cliente->get($cliente_id,0);
        $data['fsm'] = $this->flotilla->get($fsm_id,0);
       // $data['medico'] = $this->medico->get_id($data['fsm']['med_id']);
        $data['empresa'] = $this->cliente->get_empresa_by_id($data['fsm']['emp_id']);
        $this->load->helper('pdf');
		$emp_id=324; //$data['fsm']['emp_id'];
		$observaciones=$data['fsm']['flotilla_obs'];
		$data_empresa = $this->cliente->get_empresa_by_id($emp_id);
		genera_pdf_lab_new_y($this->load->view('examen/flotilla/pdf',$data,TRUE),'flotilla','flotilla','','','');	
    }

    public function borra_flotilla($fsm_id)
    {
        if($this->flotilla->delete_flotilla($fsm_id))
        {
            send_json_ok('Se eliminó de forma correcta.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar.');
        }
    }


}