<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Toma_muestras_sanguineas_adicional extends CI_Controller {
    function __construct() {
        parent::__construct();
        $this->load->model('persona/Persona_model','cliente');
        $this->load->model('empleado/Empleado_model','medico');
		$this->load->model('servicio/Servicio_model','servicio');
		$this->load->model('examen/Toma_muestras_sanguineas_adicional_model','muestra');
		$this->load->helper('util'); 
    }

	public function nuevorx($cliente_id)
    {
		
		$persona = $this->cliente->get($cliente_id);
		$user = $this->session->user;
		$medico = $this->medico->get($user['usr_id']);  
	
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');

			if (($persona['serv_id'] == 0) ||(get_status_serv($persona['serv_id']) != 'PROCESO'))
			{					
					$this->form_validation->set_rules('servicio','Orden de servicio','required');
			}
			else
			{
					$this->form_validation->set_rules('servicio','Orden de servicio','integer');
			}

            			
			//$this->form_validation->set_rules('ex_obs','Observaciones','required');

            if($this->form_validation->run())
            {


				if (($persona['serv_id'] == 0) || (get_status_serv($persona['serv_id']) != 'PROCESO'))
				{	
						$data_insert['serv_id']  = $this->input->post('servicio');
				}
				else
				{	
						$data_insert['serv_id']  = $persona['serv_id'];
				}
			
				$data_insert['clte_id'] = $persona['clte_id'];
				$data_insert['emp_id'] = $persona['emp_id'];
				$data_insert['suc_id'] = $persona['suc_id'];
                $data_insert['med_id'] = $this->input->post('medicos'); 
                $data_insert['usr_id']  = $user['usr_id'];
				 $data_insert['fsm_fecha_muestra']   =  $this->input->post('f_muestra');
				//$data_insert['fsm_f']   =  date("Y-m-d H:i:s");  
 				$data_insert['log_insrt_f']   = date("Y-m-d H:i:s");  
				$data_insert['log_insrt_usr_cve']   =  $user['usr_id'];  	
				$data_insert['log_updt_f']   =  $data_insert['fsm_f']; 		
				$data_insert['log_updt_usr_cve']   =  $user['usr_id'];				
				$data_insert['fsm_observaciones']=$this->input->post('ex_obs');
				
				$data_insert=array_to_upper($data_insert);

			
		        if($this->muestra->insert_r($data_insert))
                {
                    send_json_ok('Se guardó de forma correcta.');
                }
                else
                {
                    send_json_error('Ocurrió un error al guardar.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
			
			
            $data['persona'] = $persona;
            $data['medico'] = $medico;
			$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);
            $this->load->helper('template');
            $params_view = array(
                'title' => '',
                'view' => 'examen/toma_muestras_sanguineas_adicional/nuevo_form_rx',
                'view_data' => $data 
               );
            render_template($params_view);
        }
    }



    
    public function pdfr($cliente_id, $fsm_id)
    {
        $data['persona'] = $this->cliente->get($cliente_id,get_desp_id_usr());
        $data['fsm'] = $this->muestra->get_r($fsm_id,get_desp_id_usr());
        $data['medico'] = $this->medico->get_id($data['fsm']['med_id']);
        $data['empresa'] = $this->cliente->get_empresa_by_id($data['fsm']['emp_id']);
        $this->load->helper('pdf');
		xamplete($this->load->view('examen/toma_muestras_sanguineas_adicional/pdf_rx',$data,TRUE),'toma_muestras_sanguineas_adicional','toma_muestras_sanguineas_adicional','toma_muestras_sanguineas_adicional','Humancenter Review S.A de C.V.');
	}
	
    public function borra($fsm_id)
    {
        if($this->muestra->delete_nota_psicologica($fsm_id))
        {
            send_json_ok('Se eliminó de forma correcta.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar.');
        }
    }
	
/*****************************************************************/
}