﻿<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Persona extends CI_Controller {
    
    function __construct() {
        parent::__construct();
        $this->load->model('persona/Persona_model','cliente');
		$this->load->model('servicio/Servicio_model','servicio');
		$this->load->model('empleado/Empleado_model','medico');
		$this->load->model('examen/Salud_ocupacional_model','salud_ocupacional');
		$this->load->model('ssiniestros/Ssiniestros_model','asegurado');
		$this->load->helper('util');
		$this->load->helper('catalogo');
		$this->load->helper('laboratorx');
		$this->load->helper('laboratory');
		$this->load->helper('laboratorz');
		$this->load->helper('laboratoru');
		$this->load->helper('laboratorg');
    }

    public function detalle($id) {
        $data['cliente'] = $this->cliente->get_cliente($id);
        $data['sgmty_docs'] = $this->cliente->get_sgmty_docs($id);
        $this->load->view('persona/cliente', $data);
    }

    public function nuevo_sansce_doc2($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
            /*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
            if (($persona['serv_id'] == 0) ||(get_status_serv($persona['serv_id']) != 'PROCESO'))
            {
                $this->form_validation->set_rules('servicio','Orden de servicio','required');
            }
            /*************************************************/                
            $this->form_validation->set_rules('nombre','Nombre documento','required');
            
            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_id'] =  $cliente_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                $data_clte['emp_id'] =  $this->input->post('emp_id');
                /*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
                if (($persona['serv_id'] == 0) || (get_status_serv($persona['serv_id']) != 'PROCESO'))
                {    
                    $data_clte['serv_id']  = $this->input->post('servicio');
                }
                else
                {    
                    $data_clte['serv_id']  = $persona['serv_id'];
                }
                /**************************************************/                
                
                $this->load->library('upload');
                sleep(1);
                if(!empty($_FILES['doc']['name']))
                {
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/docs/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg|pdf|doc|docx',
                            'max_size'      => '25000'
                    );
    
                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('doc'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['doc_path'] = $data['file_name'];
                        if($this->cliente->add_EXAMM_doc(array_to_upper($data_clte)))
                        {
                            send_json_ok('Se guardó de forma correcta');
                            /****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
                            $servicios=$persona['domserv'];                    
                            
                            $servicio='EXAMM;';
                            if (!(strstr($servicios,$servicio)))
                            {                            
                                $servicios.=$servicio;
                                $data_clte_id['domserv']=$servicios;
                                $res=$this->cliente->actualiza_registro_individual($cliente_id, $data_clte_id);
                            }
                            /**************************************************/                            
                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
                    send_json_error($this->upload->display_errors());
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
            /****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
            $data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);
            /**************************************************/            
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'persona/add_sansce_doc2',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }


public function nuevo_CLEAVER_doc($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
			/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
			if (($persona['serv_id'] == 0) ||(get_status_serv($persona['serv_id']) != 'PROCESO'))
			{	

					$this->form_validation->set_rules('servicio','Orden de servicio','required');
			}
            /*************************************************/			
            $this->form_validation->set_rules('nombre','Nombre documento','required');
			
            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_id'] =  $cliente_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                $data_clte['emp_id'] =  $this->input->post('emp_id');
				/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
				if (($persona['serv_id'] == 0) || (get_status_serv($persona['serv_id']) != 'PROCESO'))
				{	
						$data_clte['serv_id']  = $this->input->post('servicio');
				}
				else
				{	
						$data_clte['serv_id']  = $persona['serv_id'];
				}
				/**************************************************/
				
				
                $this->load->library('upload');
				sleep(1);
                if(!empty($_FILES['doc']['name']))
                {
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/docs_psico/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg|pdf|doc|docx',
                            'max_size'      => '25000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('doc'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['doc_path'] = $data['file_name'];
                        if($this->cliente->add_CLEAVER_doc(array_to_upper($data_clte)))
                        {
                            send_json_ok('Se guardó de forma correcta');
							
							/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
							$servicios=$persona['domserv'];					
							
							$servicio='CLEAVER;';
							if (!(strstr($servicios,$servicio)))
							{							
								$servicios.=$servicio;
								$data_clte_id['domserv']=$servicios;
								$res=$this->cliente->actualiza_registro_individual($cliente_id, $data_clte_id);
							}
							/**************************************************/							
							
                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
                    send_json_error($this->upload->display_errors());
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
			/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
			$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);
			/**************************************************/			
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'persona/add_CLEAVER_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }





public function nuevo_CAMA000_doc($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
			if (($persona['serv_id'] == 0) ||(get_status_serv($persona['serv_id']) != 'PROCESO'))
			{
					$this->form_validation->set_rules('servicio','Orden de servicio','required');
			}
            $this->form_validation->set_rules('nombre','Nombre documento','required');
            if($this->form_validation->run())
            {
                $data_clte['clte_id'] =  $cliente_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                $data_clte['emp_id'] =  $this->input->post('emp_id');
				if (($persona['serv_id'] == 0) || (get_status_serv($persona['serv_id']) != 'PROCESO'))
				{	
						$data_clte['serv_id']  = $this->input->post('servicio');
				}
				else
				{	
						$data_clte['serv_id']  = $persona['serv_id'];
				}
                $this->load->library('upload');
				sleep(1);
                if(!empty($_FILES['doc']['name']))
                {
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/docs_nom035/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg|pdf|doc|docx',
                            'max_size'      => '25000'
                    );
                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('doc'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['doc_path'] = $data['file_name'];
                        if($this->cliente->add_CAMA000_doc(array_to_upper($data_clte)))
                        {
                            send_json_ok('Se guardó de forma correcta');
							$servicios=$persona['domserv'];					
							$servicio='CAMA000;';
							if (!(strstr($servicios,$servicio)))
							{							
								$servicios.=$servicio;
								$data_clte_id['domserv']=$servicios;
								$res=$this->cliente->actualiza_registro_individual($cliente_id, $data_clte_id);
							}
                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
                    send_json_error($this->upload->display_errors());
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
			$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);

            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'persona/add_CAMA000_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }

    public function firmaautoriza($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
            if(1)
            {
					$data_clte['clte_gral_med`'] =  $this->input->post('laboratorista');

					if($this->cliente->actualiza($cliente_id, array_to_upper($data_clte)))
					{
						send_json_ok('Se guardó de forma correcta');
					}
					else
					{
						send_json_error('Ocurrió un error al guardar el documento.');
					}	

            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
			//$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'persona/add_FIRMAAUTORIZA',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }


    public function nuevo_PENSA_doc($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
			/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
			if (($persona['serv_id'] == 0) ||(get_status_serv($persona['serv_id']) != 'PROCESO'))
			{	

					$this->form_validation->set_rules('servicio','Orden de servicio','required');
			}
            /*************************************************/			
            $this->form_validation->set_rules('nombre','Nombre documento','required');
			
            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_id'] =  $cliente_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                $data_clte['emp_id'] =  $this->input->post('emp_id');
				/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
				if (($persona['serv_id'] == 0) || (get_status_serv($persona['serv_id']) != 'PROCESO'))
				{	
						$data_clte['serv_id']  = $this->input->post('servicio');
				}
				else
				{	
						$data_clte['serv_id']  = $persona['serv_id'];
				}
				/**************************************************/
				
				
                $this->load->library('upload');
				sleep(1);
                if(!empty($_FILES['doc']['name']))
                {
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/docs/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg|pdf|doc|docx',
                            'max_size'      => '25000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('doc'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['doc_path'] = $data['file_name'];
                        if($this->cliente->add_PENSA_doc(array_to_upper($data_clte)))
                        {
                            send_json_ok('Se guardó de forma correcta');
							
							/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
							$servicios=$persona['domserv'];					
							
							$servicio='PENSA;';
							if (!(strstr($servicios,$servicio)))
							{							
								$servicios.=$servicio;
								$data_clte_id['domserv']=$servicios;
								$res=$this->cliente->actualiza_registro_individual($cliente_id, $data_clte_id);
							}
							/**************************************************/							
							
                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
                    send_json_error($this->upload->display_errors());
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
			/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
			$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);
			/**************************************************/			
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'persona/add_PENSA_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }


    public function rep_eee()
    {
        $this->load->helper('template');
        $params_view = array(
            'title' => 'Inicio',
            'view' => 'persona/inicio_view_rep_eee',
            'view_data' => $data
            );
        render_template($params_view);
    } 
    public function rep_seg()
    {
        $this->load->helper('template');
        $params_view = array(
            'title' => 'Inicio',
            'view' => 'persona/inicio_view_rep_seguridad',
            'view_data' => $data
            );
        render_template($params_view);
    }


    public function rep_seg_pdf()
    {
        $this->load->helper('template');
        $params_view = array(
            'title' => 'Inicio',
            'view' => 'persona/inicio_view_pdf_seguridad',
            'view_data' => $data
            );
        render_template($params_view);
    }


    public function rep_eva()
    {
        $this->load->helper('template');
        $params_view = array(
            'title' => 'Inicio',
            'view' => 'persona/inicio_view_rep_evaluados',
            'view_data' => $data
            );
        render_template($params_view);
    } 

    public function rep_emp()
    {
        $this->load->helper('template');
        $params_view = array(
            'title' => 'Inicio',
            'view' => 'persona/inicio_view_rep_empleados',
            'view_data' => $data
            );
        render_template($params_view);
    } 



    public function rep_emp_sw($modo)
    {
        $this->load->helper('template');
		$data['modo']=$modo;
        $params_view = array(
            'title' => 'Inicio',
            'view' => 'persona/inicio_view_rep_emp_sw',
            'view_data' => $data
            );
        render_template($params_view);
    } 


    public function rep_empleados_mod($modo)
    {
        $this->load->helper('template');
		$data['modo']=$modo;
        $params_view = array(
            'title' => 'Inicio',
            'view' => 'persona/inicio_view_rep_emp_mod',
            'view_data' => $data
            );
        render_template($params_view);
    } 


    public function rep_lab()
    {
        $this->load->helper('template');
        $params_view = array(
            'title' => 'Inicio',
            'view' => 'persona/inicio_view_rep_eva_lab',
            'view_data' => $data
            );
        render_template($params_view);
    }



    public function lista_empleados_gsi()
    {   //date_default_timezone_set('America/Mexico_City');
	    //echo " Punto A ";
		$suc=get_sucursal_id();
		//echo " Punto AA ";
		$user_despacho=get_desp_id_usr();
		//echo " Punto AAA ";
		$user_cei=get_cei_id();
		//echo " Punto AAAA ";
		$user_root1=get_my_user_root1();
		$user_root3=get_my_user_root3();
		$user_root4=get_my_user_root4();
		$user = $this->session->user; 
		$medico = $this->medico->get($user['usr_id']);

        $rows = 30;
        $this->load->library('pagination');
        $config['base_url'] = base_url('persona/lista_empleados_gsi/');
        //$config['total_rows'] = $this->cliente->count_all();

		$gss=get_empresas_corporativo('GSI');		
		//print_r($gss);
		
		$config['total_rows'] = $this->cliente->count_allo_empleados_empresas($gss);			

		
		$config['per_page'] = $rows;
        $config['attributes'] = array('class' => 'pagination');
        $config['full_tag_open'] = '<div class="pagination-full">';
        $config['full_tag_close'] = '</div>';
        $config['uri_segment'] = 3;
        $config['query_string_segment'] = 4;
        $config['use_page_numbers'] = TRUE;
        $this->pagination->initialize($config);
        
		$data['clientes'] = $this->cliente->get_allo_empleados_empresas($rows,$gss);			

        $this->load->model('empresa/Empresa_model','empresa');

		$data['empresas'] =  $this->empresa->get_all_empresas_gss($gss);			
		$data['sucursales'] = $this->empresa->get_all_sucursales_empresas($gss);

        
        $this->load->helper('template');
        $params_view = array(
            'title' => 'Personas',
            'view' => 'persona/index_empleados_gsi',
            'view_data' => $data 
           );
        render_template($params_view);  
    }

    public function lista()
    {   
	   // echo " Punto A-";
		$suc=get_sucursal_id();
		//echo " Punto AA-";
		$user_despacho=get_desp_id_usr();
		//echo " Punto AAA-";
		$user_cei=get_cei_id();
		//echo " Punto AAAA-";
		$user_root1=get_my_user_root1();
		$user_root3=get_my_user_root3();
		$user_root4=get_my_user_root4();
		$user = $this->session->user; 
		$medico = $this->medico->get($user['usr_id']);
		$usuario = $this->medico->get($user['usr_id']);
		
		//echo " Punto b-";
        $rows = 30;
        $this->load->library('pagination');
        $config['base_url'] = base_url('persona/lista/');
        //$config['total_rows'] = $this->cliente->count_all();

		//echo " Punto bb-";
		
		if ( strstr($usuario['modulos'],'CLINICA') )
		{
			$config['total_rows'] = $this->cliente->count_allo_emp_asig(412);		
		}	
		elseif ($user_root4 == 0)
		{
			//echo 'root 4';
			$config['total_rows'] = $this->cliente->count_allo($suc,$user_despacho,$user_cei,$user_root1);
        }
		elseif ($user_root4 == 4)
		{
			$config['total_rows'] = $this->cliente->count_allo_emp_asig($medico['usr_emp_asig']);
		}
		elseif (($user_root4 == 3) || ($user_root4 == 7) )
		{
			$config['total_rows'] = $this->cliente->count_allo_corporacion($suc,'sis15_empresas.emp_corp','GSI');
		}
		elseif ($user_root4 == 5)
		{
			$config['total_rows'] = $this->cliente->count_allo_emp_asig($medico['usr_emp_asig']);
		}
		elseif ($user_root4 == 6)
		{
			$config['total_rows'] = $this->cliente->count_allo_gsi($suc,$user_despacho,$user_cei,$user_root1,0);
		}		


		if ( strstr($usuario['portal'],'CORPO') )
		{	
			if ( strstr($usuario['empresas'],'TCORP') )
			{  //ESTO AUN NO ESTA BIEN
				$config['total_rows'] = $this->cliente->count_allo_corporacion($suc,'sis15_empresas.emp_corp','GSI');
			}
			else
			{
				$i=0;
				foreach ( explode(';',$usuario['empresas'] )  as $esta_empresa) 
				{
					if ($esta_empresa > 0)
					{	
						$gss[$i]=$esta_empresa;
						$i++;
					}
				}


				$config['total_rows'] = $this->cliente->count_allo_emp_asig($gss,$usuario['acciones'],$usuario['suc_id' ] );
				$data['c_empresas'] = $i; 
			}			
		
		}
		elseif ( strstr($usuario['portal'],'EMPSGSI') )
		{	
			if ( strstr($usuario['empresas'],'TGSI') )
			{
				$config['total_rows'] = $this->cliente->count_allo_corporacion($suc,'sis15_empresas.emp_corp','GSI');
			}
			else
			{
				$i=0;
				foreach ( explode(';',$usuario['empresas'] )  as $esta_empresa) 
				{
					if ($esta_empresa > 0)
					{	
						//echo $esta_empresa.'-';
						$gss[$i]=$esta_empresa;
						$i++;
					}
				}	
				$config['total_rows'] = $this->cliente->count_allo_emp_asig($gss,$usuario['acciones'],$usuario['suc_id'] );
				$data['c_empresas'] = $i; 
				//echo $config['total_rows'].'-';
			}			
		
		}		
		
		
		$config['per_page'] = $rows;
        $config['attributes'] = array('class' => 'pagination');
        $config['full_tag_open'] = '<div class="pagination-full">';
        $config['full_tag_close'] = '</div>';
        $config['uri_segment'] = 3;
        $config['query_string_segment'] = 4;
        $config['use_page_numbers'] = TRUE;
        $this->pagination->initialize($config);
        
		if ( strstr($usuario['modulos'],'CLINICA') )
		{
			$data['clientes'] = $this->cliente->get_allo_emp_asig($rows,412);
		}	
		elseif ($user_root4 == 0)
		{
			$data['clientes'] = $this->cliente->get_allo($rows,get_sucursal_id(),$user_despacho,$user_cei,$user_root1);
		//echo " Punto 4 ";  //ssegura 
		}
		elseif ($user_root4 == 4)
		{
			$data['clientes'] = $this->cliente->get_allo_emp_asig($rows,$medico['usr_emp_asig']);
		//echo " Punto 5 ";
		}
		elseif (($user_root4 == 3) || ($user_root4 == 7) /*|| ($user['emp_id']== 701)*/)
		{
		$data['clientes'] = $this->cliente->get_allo_gsi($rows,get_sucursal_id(),$user_despacho,$user_cei,$user_root1);
		//echo " Punto 6 ";
		}
		elseif ($user_root4 == 5)
		{
			$data['clientes'] = $this->cliente->get_allo_emp_asig($rows,$medico['usr_emp_asig']);
		//echo " Punto 7 ";
		}
		elseif ($user_root4 == 6)
		{
			$data['clientes'] = $this->cliente->get_allo_gsi($rows,get_sucursal_id(),$user_despacho,$user_cei,$user_root1);
		//echo " Punto 8 ";
		}		



		if ( strstr($usuario['portal'],'CORPO') )
		{	
			if ( strstr($usuario['empresas'],'TCORP') )
			{
				$data['clientes'] = $this->cliente->get_allo_gsi($rows,get_sucursal_id(),$user_despacho,$user_cei,$user_root1);
			}
			else
			{
				$i=0;
				foreach ( explode(';',$usuario['empresas'] )  as $esta_empresa) 
				{
					if ($esta_empresa > 0)
					{//	echo $esta_empresa.'-';
						$gss[$i]=$esta_empresa;
					//	echo $gss[$i].'-';
						$i++;
					}
				}	
				$data['clientes'] = $this->cliente->get_allo_gss($rows,$gss,$usuario['acciones'],$usuario['suc_id'] );				
				$data['c_empresas'] = $i; 
				
			}				
		
		}
		elseif ( strstr($usuario['portal'],'EMPSGSI') )
		{	
			if ( strstr($usuario['empresas'],'TGSI') )
			{
				$data['clientes'] = $this->cliente->get_allo_gsi($rows,get_sucursal_id(),$user_despacho,$user_cei,$user_root1);
			}
			else
			{
				$i=0;
				foreach ( explode(';',$usuario['empresas'] )  as $esta_empresa) 
				{
					if ($esta_empresa > 0)
					{//	echo $esta_empresa.'-';
						$gss[$i]=$esta_empresa;
					//	echo $gss[$i].'-';
						$i++;
					}
				}	
				$data['clientes'] = $this->cliente->get_allo_gss($rows,$gss,$usuario['acciones'],$usuario['suc_id'] );
				$data['c_empresas'] = $i; 
				
			}				
		
		}



			
        $this->load->model('empresa/Empresa_model','empresa');

		if (($user_root3 == 2) && ($user_root4 == 3))
		{ 
			$data['empresas'] = $this->empresa->get_all_empresas_gsi_id();	
		}
		elseif ($user_root4 == 0)
		{
        $data['empresas'] = $this->empresa->trae_empresas(1);//$this->empresa->get_all_empresas();
		$data['sucursales'] = $this->empresa->get_all_sucursales();
		}
		elseif ($user_root4 == 4)
		{
			$data['empresas'] = $this->empresa->trae_emp_asig($medico['usr_emp_asig']);			
		}
		elseif (($user_root4 == 3) || ($user_root4 == 7))
		{
			$data['empresas'] = $this->empresa->get_all_empresas_gsi_id();			
		}
		elseif ($user_root4 == 5)
		{
			$data['empresas'] = $this->empresa->trae_emp_asig($medico['usr_emp_asig']);			
		}
		elseif ($user_root4 == 6)
		{
			$data['empresas'] = $this->empresa->get_all_empresas_gsi_id();			
		}	

		
		if ( strstr($usuario['portal'],'CORPO') )
		{	
			if ( strstr($usuario['empresas'],'TCORP') )
			{
				$data['empresas'] = $this->empresa->get_all_empresas_gsi_id();	
				$data['c_empresas'] = 0; 
			}
			else
			{
				$i=0;
				foreach ( explode(';',$usuario['empresas'] )  as $esta_empresa) 
				{
					if ($esta_empresa > 0)
					{	
						$gss[$i]=$esta_empresa;
						$i++;
					}
				}	
				
				$data['empresas'] =  $this->empresa->get_all_empresas_gss($gss);
				$data['c_empresas'] = $i; 
			}	
		
		}elseif ( strstr($usuario['portal'],'EMPSGSI') )
		{	
			if ( strstr($usuario['empresas'],'TGSI') )
			{
				$data['empresas'] = $this->empresa->get_all_empresas_gsi_id();	
				$data['c_empresas'] = 0; 
			}
			else
			{
				$i=0;
				foreach ( explode(';',$usuario['empresas'] )  as $esta_empresa) 
				{
					if ($esta_empresa > 0)
					{	
						$gss[$i]=$esta_empresa;
						$i++;
					}
				}	
				
				$data['empresas'] =  $this->empresa->get_all_empresas_gss($gss);
				$data['c_empresas'] = $i; 
			}	
		
		}
       $this->load->helper('template');
        $params_view = array(
            'title' => 'Personas',
            'view' => 'persona/index',
            'view_data' => $data 
           );
        render_template($params_view);  
    }
 
    public function lista_evalua2()
    {   
	   // echo " Punto A-";
		$suc=get_sucursal_id();
		//echo " Punto AA-";
		$user_despacho=get_desp_id_usr();
		//echo " Punto AAA-";
		$user_cei=get_cei_id();
		//echo " Punto AAAA-";
		$user_root1=get_my_user_root1();
		$user_root3=get_my_user_root3();
		$user_root4=get_my_user_root4();
		$user = $this->session->user; 
		$medico = $this->medico->get($user['usr_id']);
		$usuario = $this->medico->get($user['usr_id']);
		
		//echo " Punto b-";
        $rows = 30;
        $this->load->library('pagination');
        $config['base_url'] = base_url('persona/lista_evalua2/');
        //$config['total_rows'] = $this->cliente->count_all();

		//echo " Punto bb-";
		
		if ( strstr($usuario['modulos'],'CLINICA') )
		{
			$config['total_rows'] = $this->cliente->count_allo_emp_asig(412);		
		}	
		elseif ($user_root4 == 0)
		{
			//echo 'root 4';
			$config['total_rows'] = $this->cliente->count_allo($suc,$user_despacho,$user_cei,$user_root1);
        }
		elseif ($user_root4 == 4)
		{
			$config['total_rows'] = $this->cliente->count_allo_emp_asig($medico['usr_emp_asig']);
		}
		elseif (($user_root4 == 3) || ($user_root4 == 7) )
		{
			$config['total_rows'] = $this->cliente->count_allo_corporacion($suc,'sis15_empresas.emp_corp','GSI');
		}
		elseif ($user_root4 == 5)
		{
			$config['total_rows'] = $this->cliente->count_allo_emp_asig($medico['usr_emp_asig']);
		}
		elseif ($user_root4 == 6)
		{
			$config['total_rows'] = $this->cliente->count_allo_gsi($suc,$user_despacho,$user_cei,$user_root1,0);
		}		


		if ( strstr($usuario['portal'],'CORPO') )
		{	
			if ( strstr($usuario['empresas'],'TCORP') )
			{  //ESTO AUN NO ESTA BIEN
				$config['total_rows'] = $this->cliente->count_allo_corporacion($suc,'sis15_empresas.emp_corp','GSI');
			}
			else
			{
				$i=0;
				foreach ( explode(';',$usuario['empresas'] )  as $esta_empresa) 
				{
					if ($esta_empresa > 0)
					{	
						$gss[$i]=$esta_empresa;
						$i++;
					}
				}


				//$config['total_rows'] = $this->cliente->count_allo_emp_asig($gss,$usuario['acciones'],$usuario['suc_id' ] );
				$config['total_rows'] = $this->cliente->count_allo_corp_evaluado_asig($gss,$usuario['acciones'],$usuario['suc_id' ] ); // solo humanos
				$data['c_empresas'] = $i; 
			}			
		
		}
		elseif ( strstr($usuario['portal'],'EMPSGSI') )
		{	
			if ( strstr($usuario['empresas'],'TGSI') )
			{
				$config['total_rows'] = $this->cliente->count_allo_corporacion($suc,'sis15_empresas.emp_corp','GSI');
			}
			else
			{
				$i=0;
				foreach ( explode(';',$usuario['empresas'] )  as $esta_empresa) 
				{
					if ($esta_empresa > 0)
					{	
						//echo $esta_empresa.'-';
						$gss[$i]=$esta_empresa;
						$i++;
					}
				}	
				$config['total_rows'] = $this->cliente->count_allo_emp_asig($gss,$usuario['acciones'],$usuario['suc_id'] );
				$data['c_empresas'] = $i; 
				//echo $config['total_rows'].'-';
			}			
		
		}		
		
		
		$config['per_page'] = $rows;
        $config['attributes'] = array('class' => 'pagination');
        $config['full_tag_open'] = '<div class="pagination-full">';
        $config['full_tag_close'] = '</div>';
        $config['uri_segment'] = 3;
        $config['query_string_segment'] = 4;
        $config['use_page_numbers'] = TRUE;
        $this->pagination->initialize($config);
        
		if ( strstr($usuario['modulos'],'CLINICA') )
		{
			$data['clientes'] = $this->cliente->get_allo_emp_asig($rows,412);
		}	
		elseif ($user_root4 == 0)
		{
			$data['clientes'] = $this->cliente->get_allo($rows,get_sucursal_id(),$user_despacho,$user_cei,$user_root1);
		//echo " Punto 4 ";  //ssegura 
		}
		elseif ($user_root4 == 4)
		{
			$data['clientes'] = $this->cliente->get_allo_emp_asig($rows,$medico['usr_emp_asig']);
		//echo " Punto 5 ";
		}
		elseif (($user_root4 == 3) || ($user_root4 == 7) /*|| ($user['emp_id']== 701)*/)
		{
		$data['clientes'] = $this->cliente->get_allo_gsi($rows,get_sucursal_id(),$user_despacho,$user_cei,$user_root1);
		//echo " Punto 6 ";
		}
		elseif ($user_root4 == 5)
		{
			$data['clientes'] = $this->cliente->get_allo_emp_asig($rows,$medico['usr_emp_asig']);
		//echo " Punto 7 ";
		}
		elseif ($user_root4 == 6)
		{
			$data['clientes'] = $this->cliente->get_allo_gsi($rows,get_sucursal_id(),$user_despacho,$user_cei,$user_root1);
		//echo " Punto 8 ";
		}		



		if ( strstr($usuario['portal'],'CORPO') )
		{	
			if ( strstr($usuario['empresas'],'TCORP') )
			{
				$data['clientes'] = $this->cliente->get_allo_gsi($rows,get_sucursal_id(),$user_despacho,$user_cei,$user_root1);
			}
			else
			{
				$i=0;
				foreach ( explode(';',$usuario['empresas'] )  as $esta_empresa) 
				{
					if ($esta_empresa > 0)
					{//	echo $esta_empresa.'-';
						$gss[$i]=$esta_empresa;
					//	echo $gss[$i].'-';
						$i++;
					}
				}	
				//$data['clientes'] = $this->cliente->get_allo_gss($rows,$gss,$usuario['acciones'],$usuario['suc_id'] );
				$data['clientes'] = $this->cliente->get_allo_gss_corp_empleados($rows,$gss,$usuario['acciones'],$usuario['suc_id'] );
				$data['c_empresas'] = $i; 
				
			}				
		
		}
		elseif ( strstr($usuario['portal'],'EMPSGSI') )
		{	
			if ( strstr($usuario['empresas'],'TGSI') )
			{
				$data['clientes'] = $this->cliente->get_allo_gsi($rows,get_sucursal_id(),$user_despacho,$user_cei,$user_root1);
			}
			else
			{
				$i=0;
				foreach ( explode(';',$usuario['empresas'] )  as $esta_empresa) 
				{
					if ($esta_empresa > 0)
					{//	echo $esta_empresa.'-';
						$gss[$i]=$esta_empresa;
					//	echo $gss[$i].'-';
						$i++;
					}
				}	
				$data['clientes'] = $this->cliente->get_allo_gss($rows,$gss,$usuario['acciones'],$usuario['suc_id'] );
				$data['c_empresas'] = $i; 
				
			}				
		
		}



			
        $this->load->model('empresa/Empresa_model','empresa');

		if (($user_root3 == 2) && ($user_root4 == 3))
		{ 
			$data['empresas'] = $this->empresa->get_all_empresas_gsi_id();	
		}
		elseif ($user_root4 == 0)
		{
        $data['empresas'] = $this->empresa->trae_empresas(1);//$this->empresa->get_all_empresas();
		$data['sucursales'] = $this->empresa->get_all_sucursales();
		}
		elseif ($user_root4 == 4)
		{
			$data['empresas'] = $this->empresa->trae_emp_asig($medico['usr_emp_asig']);			
		}
		elseif (($user_root4 == 3) || ($user_root4 == 7))
		{
			$data['empresas'] = $this->empresa->get_all_empresas_gsi_id();			
		}
		elseif ($user_root4 == 5)
		{
			$data['empresas'] = $this->empresa->trae_emp_asig($medico['usr_emp_asig']);			
		}
		elseif ($user_root4 == 6)
		{
			$data['empresas'] = $this->empresa->get_all_empresas_gsi_id();			
		}	

		
		if ( strstr($usuario['portal'],'CORPO') )
		{	
			if ( strstr($usuario['empresas'],'TCORP') )
			{
				$data['empresas'] = $this->empresa->get_all_empresas_gsi_id();	
				$data['c_empresas'] = 0; 
			}
			else
			{
				$i=0;
				foreach ( explode(';',$usuario['empresas'] )  as $esta_empresa) 
				{
					if ($esta_empresa > 0)
					{	
						$gss[$i]=$esta_empresa;
						$i++;
					}
				}	
				
				$data['empresas'] =  $this->empresa->get_all_empresas_gss($gss);
				$data['c_empresas'] = $i; 
			}	
		
		}elseif ( strstr($usuario['portal'],'EMPSGSI') )
		{	
			if ( strstr($usuario['empresas'],'TGSI') )
			{
				$data['empresas'] = $this->empresa->get_all_empresas_gsi_id();	
				$data['c_empresas'] = 0; 
			}
			else
			{
				$i=0;
				foreach ( explode(';',$usuario['empresas'] )  as $esta_empresa) 
				{
					if ($esta_empresa > 0)
					{	
						$gss[$i]=$esta_empresa;
						$i++;
					}
				}	
				
				$data['empresas'] =  $this->empresa->get_all_empresas_gss($gss);
				$data['c_empresas'] = $i; 
			}	
		
		}
       $this->load->helper('template');
        $params_view = array(
            'title' => 'Personas',
            'view' => 'persona/index_evalua2',
            'view_data' => $data 
           );
        render_template($params_view);  
    }



    public function lista_empresa()
    {   
	   // echo " Punto A-";
		$suc=get_sucursal_id();
		//echo " Punto AA-";
		$user_despacho=get_desp_id_usr();
		//echo " Punto AAA-";
		$user_cei=get_cei_id();
		//echo " Punto AAAA-";
		$user_root1=get_my_user_root1();
		$user_root3=get_my_user_root3();
		$user_root4=get_my_user_root4();
		$user = $this->session->user; 
		$medico = $this->medico->get($user['usr_id']);
		$usuario = $this->medico->get($user['usr_id']);
		
		//echo " Punto b-";
        $rows = 30;
        $this->load->library('pagination');
        $config['base_url'] = base_url('persona/lista_empresa/');
        //$config['total_rows'] = $this->cliente->count_all();

		//echo " Punto bb-";
		
		if ( strstr($usuario['modulos'],'CLINICA') )
		{
			$config['total_rows'] = $this->cliente->count_allo_emp_asig(412);		
		}	
		elseif ($user_root4 == 0)
		{
			//echo 'root 4';
			$config['total_rows'] = $this->cliente->count_allo($suc,$user_despacho,$user_cei,$user_root1);
        }
		elseif ($user_root4 == 4)
		{
			$config['total_rows'] = $this->cliente->count_allo_emp_asig($medico['usr_emp_asig']);
		}
		elseif (($user_root4 == 3) || ($user_root4 == 7) )
		{
			$config['total_rows'] = $this->cliente->count_allo_corporacion($suc,'sis15_empresas.emp_corp','GSI');
		}
		elseif ($user_root4 == 5)
		{
			$config['total_rows'] = $this->cliente->count_allo_emp_asig($medico['usr_emp_asig']);
		}
		elseif ($user_root4 == 6)
		{
			$config['total_rows'] = $this->cliente->count_allo_gsi($suc,$user_despacho,$user_cei,$user_root1,0);
		}		


		if ( strstr($usuario['portal'],'CORPO') )
		{	
			if ( strstr($usuario['empresas'],'TCORP') )
			{  //ESTO AUN NO ESTA BIEN
				$config['total_rows'] = $this->cliente->count_allo_corporacion($suc,'sis15_empresas.emp_corp','GSI');
			}
			else
			{
				$i=0;
				foreach ( explode(';',$usuario['empresas'] )  as $esta_empresa) 
				{
					if ($esta_empresa > 0)
					{	
						$gss[$i]=$esta_empresa;
						$i++;
					}
				}


				//$config['total_rows'] = $this->cliente->count_allo_emp_asig($gss,$usuario['acciones'],$usuario['suc_id' ] );
				$config['total_rows'] = $this->cliente->count_allo_corp_empresa_asig($gss,$usuario['acciones'],$usuario['suc_id' ] ); // solo humanos
				$data['c_empresas'] = $i; 
			}			
		
		}
		elseif ( strstr($usuario['portal'],'EMPSGSI') )
		{	
			if ( strstr($usuario['empresas'],'TGSI') )
			{
				$config['total_rows'] = $this->cliente->count_allo_corporacion($suc,'sis15_empresas.emp_corp','GSI');
			}
			else
			{
				$i=0;
				foreach ( explode(';',$usuario['empresas'] )  as $esta_empresa) 
				{
					if ($esta_empresa > 0)
					{	
						//echo $esta_empresa.'-';
						$gss[$i]=$esta_empresa;
						$i++;
					}
				}	
				//$config['total_rows'] = $this->cliente->count_allo_corp_empresa_asig($gss,$usuario['acciones'],$usuario['suc_id'] );
				$config['total_rows'] = $this->cliente->count_allo_corp_empresa_asig($gss,$usuario['acciones'],$usuario['suc_id'] );
				$data['c_empresas'] = $i; 
				//echo $config['total_rows'].'-';
			}			
		
		}		
		
		
		$config['per_page'] = $rows;
        $config['attributes'] = array('class' => 'pagination');
        $config['full_tag_open'] = '<div class="pagination-full">';
        $config['full_tag_close'] = '</div>';
        $config['uri_segment'] = 3;
        $config['query_string_segment'] = 4;
        $config['use_page_numbers'] = TRUE;
        $this->pagination->initialize($config);
        
		if ( strstr($usuario['modulos'],'CLINICA') )
		{
			$data['clientes'] = $this->cliente->get_allo_emp_asig($rows,412);
		}	
		elseif ($user_root4 == 0)
		{
			$data['clientes'] = $this->cliente->get_allo($rows,get_sucursal_id(),$user_despacho,$user_cei,$user_root1);
		//echo " Punto 4 ";  //ssegura 
		}
		elseif ($user_root4 == 4)
		{
			$data['clientes'] = $this->cliente->get_allo_emp_asig($rows,$medico['usr_emp_asig']);
		//echo " Punto 5 ";
		}
		elseif (($user_root4 == 3) || ($user_root4 == 7) /*|| ($user['emp_id']== 701)*/)
		{
		$data['clientes'] = $this->cliente->get_allo_gsi($rows,get_sucursal_id(),$user_despacho,$user_cei,$user_root1);
		//echo " Punto 6 ";
		}
		elseif ($user_root4 == 5)
		{
			$data['clientes'] = $this->cliente->get_allo_emp_asig($rows,$medico['usr_emp_asig']);
		//echo " Punto 7 ";
		}
		elseif ($user_root4 == 6)
		{
			$data['clientes'] = $this->cliente->get_allo_gsi($rows,get_sucursal_id(),$user_despacho,$user_cei,$user_root1);
		//echo " Punto 8 ";
		}		



		if ( strstr($usuario['portal'],'CORPO') )
		{	
			if ( strstr($usuario['empresas'],'TCORP') )
			{
				$data['clientes'] = $this->cliente->get_allo_gsi($rows,get_sucursal_id(),$user_despacho,$user_cei,$user_root1);
			}
			else
			{
				$i=0;
				foreach ( explode(';',$usuario['empresas'] )  as $esta_empresa) 
				{
					if ($esta_empresa > 0)
					{//	echo $esta_empresa.'-';
						$gss[$i]=$esta_empresa;
					//	echo $gss[$i].'-';
						$i++;
					}
				}	
				//$data['clientes'] = $this->cliente->get_allo_gss($rows,$gss,$usuario['acciones'],$usuario['suc_id'] );
				$data['clientes'] = $this->cliente->get_allo_gss_corp_empresa($rows,$gss,$usuario['acciones'],$usuario['suc_id'] );
				$data['c_empresas'] = $i; 
				
			}				
		
		}
		elseif ( strstr($usuario['portal'],'EMPSGSI') )
		{	
			if ( strstr($usuario['empresas'],'TGSI') )
			{
				$data['clientes'] = $this->cliente->get_allo_gsi($rows,get_sucursal_id(),$user_despacho,$user_cei,$user_root1);
			}
			else
			{
				$i=0;
				foreach ( explode(';',$usuario['empresas'] )  as $esta_empresa) 
				{
					if ($esta_empresa > 0)
					{//	echo $esta_empresa.'-';
						$gss[$i]=$esta_empresa;
					//	echo $gss[$i].'-';
						$i++;
					}
				}	
				$data['clientes'] = $this->cliente->get_allo_gss($rows,$gss,$usuario['acciones'],$usuario['suc_id'] );
				$data['c_empresas'] = $i; 
				
			}				
		
		}



			
        $this->load->model('empresa/Empresa_model','empresa');

		if (($user_root3 == 2) && ($user_root4 == 3))
		{ 
			$data['empresas'] = $this->empresa->get_all_empresas_gsi_id();	
		}
		elseif ($user_root4 == 0)
		{
        $data['empresas'] = $this->empresa->trae_empresas(1);//$this->empresa->get_all_empresas();
		$data['sucursales'] = $this->empresa->get_all_sucursales();
		}
		elseif ($user_root4 == 4)
		{
			$data['empresas'] = $this->empresa->trae_emp_asig($medico['usr_emp_asig']);			
		}
		elseif (($user_root4 == 3) || ($user_root4 == 7))
		{
			$data['empresas'] = $this->empresa->get_all_empresas_gsi_id();			
		}
		elseif ($user_root4 == 5)
		{
			$data['empresas'] = $this->empresa->trae_emp_asig($medico['usr_emp_asig']);			
		}
		elseif ($user_root4 == 6)
		{
			$data['empresas'] = $this->empresa->get_all_empresas_gsi_id();			
		}	

		
		if ( strstr($usuario['portal'],'CORPO') )
		{	
			if ( strstr($usuario['empresas'],'TCORP') )
			{
				$data['empresas'] = $this->empresa->get_all_empresas_gsi_id();	
				$data['c_empresas'] = 0; 
			}
			else
			{
				$i=0;
				foreach ( explode(';',$usuario['empresas'] )  as $esta_empresa) 
				{
					if ($esta_empresa > 0)
					{	
						$gss[$i]=$esta_empresa;
						$i++;
					}
				}	
				
				$data['empresas'] =  $this->empresa->get_all_empresas_gss($gss);
				$data['c_empresas'] = $i; 
			}	
		
		}elseif ( strstr($usuario['portal'],'EMPSGSI') )
		{	
			if ( strstr($usuario['empresas'],'TGSI') )
			{
				$data['empresas'] = $this->empresa->get_all_empresas_gsi_id();	
				$data['c_empresas'] = 0; 
			}
			else
			{
				$i=0;
				foreach ( explode(';',$usuario['empresas'] )  as $esta_empresa) 
				{
					if ($esta_empresa > 0)
					{	
						$gss[$i]=$esta_empresa;
						$i++;
					}
				}	
				
				$data['empresas'] =  $this->empresa->get_all_empresas_gss($gss);
				$data['c_empresas'] = $i; 
			}	
		
		}
       $this->load->helper('template');
        $params_view = array(
            'title' => 'Personas',
            'view' => 'persona/index_empresa',
            'view_data' => $data 
           );
        render_template($params_view);  
    }


    public function lista_vehiculos()
    {   
	   // echo " Punto A-";
		$suc=get_sucursal_id();
		//echo " Punto AA-";
		$user_despacho=get_desp_id_usr();
		//echo " Punto AAA-";
		$user_cei=get_cei_id();
		//echo " Punto AAAA-";
		$user_root1=get_my_user_root1();
		$user_root3=get_my_user_root3();
		$user_root4=get_my_user_root4();
		$user = $this->session->user; 
		$medico = $this->medico->get($user['usr_id']);
		$usuario = $this->medico->get($user['usr_id']);
		
		//echo " Punto b-";
        $rows = 30;
        $this->load->library('pagination');
        $config['base_url'] = base_url('persona/lista_vehiculos/');
        //$config['total_rows'] = $this->cliente->count_all();

		//echo " Punto bb-";
		
		if ( strstr($usuario['modulos'],'CLINICA') )
		{
			$config['total_rows'] = $this->cliente->count_allo_emp_asig(412);		
		}	
		elseif ($user_root4 == 0)
		{
			//echo 'root 4';
			$config['total_rows'] = $this->cliente->count_allo($suc,$user_despacho,$user_cei,$user_root1);
        }
		elseif ($user_root4 == 4)
		{
			$config['total_rows'] = $this->cliente->count_allo_emp_asig($medico['usr_emp_asig']);
		}
		elseif (($user_root4 == 3) || ($user_root4 == 7) )
		{
			$config['total_rows'] = $this->cliente->count_allo_corporacion($suc,'sis15_empresas.emp_corp','GSI');
		}
		elseif ($user_root4 == 5)
		{
			$config['total_rows'] = $this->cliente->count_allo_emp_asig($medico['usr_emp_asig']);
		}
		elseif ($user_root4 == 6)
		{
			$config['total_rows'] = $this->cliente->count_allo_gsi($suc,$user_despacho,$user_cei,$user_root1,0);
		}		


		if ( strstr($usuario['portal'],'CORPO') )
		{	
			if ( strstr($usuario['empresas'],'TCORP') )
			{  //ESTO AUN NO ESTA BIEN
				$config['total_rows'] = $this->cliente->count_allo_corporacion($suc,'sis15_empresas.emp_corp','GSI');
			}
			else
			{
				$i=0;
				foreach ( explode(';',$usuario['empresas'] )  as $esta_empresa) 
				{
					if ($esta_empresa > 0)
					{	
						$gss[$i]=$esta_empresa;
						$i++;
					}
				}


				//$config['total_rows'] = $this->cliente->count_allo_emp_asig($gss,$usuario['acciones'],$usuario['suc_id' ] );
				$config['total_rows'] = $this->cliente->count_allo_corp_vehiculos_asig($gss,$usuario['acciones'],$usuario['suc_id' ] ); // solo vehiculos
				$data['c_empresas'] = $i; 
			}			
		
		}
		elseif ( strstr($usuario['portal'],'EMPSGSI') )
		{	
			if ( strstr($usuario['empresas'],'TGSI') )
			{
				$config['total_rows'] = $this->cliente->count_allo_corporacion($suc,'sis15_empresas.emp_corp','GSI');
			}
			else
			{
				$i=0;
				foreach ( explode(';',$usuario['empresas'] )  as $esta_empresa) 
				{
					if ($esta_empresa > 0)
					{	
						//echo $esta_empresa.'-';
						$gss[$i]=$esta_empresa;
						$i++;
					}
				}	
				$config['total_rows'] = $this->cliente->count_allo_emp_asig($gss,$usuario['acciones'],$usuario['suc_id'] );
				$data['c_empresas'] = $i; 
				//echo $config['total_rows'].'-';
			}			
		
		}		
		
		
		$config['per_page'] = $rows;
        $config['attributes'] = array('class' => 'pagination');
        $config['full_tag_open'] = '<div class="pagination-full">';
        $config['full_tag_close'] = '</div>';
        $config['uri_segment'] = 3;
        $config['query_string_segment'] = 4;
        $config['use_page_numbers'] = TRUE;
        $this->pagination->initialize($config);
        
		if ( strstr($usuario['modulos'],'CLINICA') )
		{
			$data['clientes'] = $this->cliente->get_allo_emp_asig($rows,412);
		}	
		elseif ($user_root4 == 0)
		{
			$data['clientes'] = $this->cliente->get_allo($rows,get_sucursal_id(),$user_despacho,$user_cei,$user_root1);
		//echo " Punto 4 ";  //ssegura 
		}
		elseif ($user_root4 == 4)
		{
			$data['clientes'] = $this->cliente->get_allo_emp_asig($rows,$medico['usr_emp_asig']);
		//echo " Punto 5 ";
		}
		elseif (($user_root4 == 3) || ($user_root4 == 7) /*|| ($user['emp_id']== 701)*/)
		{
		$data['clientes'] = $this->cliente->get_allo_gsi($rows,get_sucursal_id(),$user_despacho,$user_cei,$user_root1);
		//echo " Punto 6 ";
		}
		elseif ($user_root4 == 5)
		{
			$data['clientes'] = $this->cliente->get_allo_emp_asig($rows,$medico['usr_emp_asig']);
		//echo " Punto 7 ";
		}
		elseif ($user_root4 == 6)
		{
			$data['clientes'] = $this->cliente->get_allo_gsi($rows,get_sucursal_id(),$user_despacho,$user_cei,$user_root1);
		//echo " Punto 8 ";
		}		



		if ( strstr($usuario['portal'],'CORPO') )
		{	
			if ( strstr($usuario['empresas'],'TCORP') )
			{
				$data['clientes'] = $this->cliente->get_allo_gsi($rows,get_sucursal_id(),$user_despacho,$user_cei,$user_root1);
			}
			else
			{
				$i=0;
				foreach ( explode(';',$usuario['empresas'] )  as $esta_empresa) 
				{
					if ($esta_empresa > 0)
					{//	echo $esta_empresa.'-';
						$gss[$i]=$esta_empresa;
					//	echo $gss[$i].'-';
						$i++;
					}
				}	
				//$data['clientes'] = $this->cliente->get_allo_gss($rows,$gss,$usuario['acciones'],$usuario['suc_id'] );
				$data['clientes'] = $this->cliente->get_allo_gss_corp_vehiculos($rows,$gss,$usuario['acciones'],$usuario['suc_id'] );
				$data['c_empresas'] = $i; 
				
			}				
		
		}
		elseif ( strstr($usuario['portal'],'EMPSGSI') )
		{	
			if ( strstr($usuario['empresas'],'TGSI') )
			{
				$data['clientes'] = $this->cliente->get_allo_gsi($rows,get_sucursal_id(),$user_despacho,$user_cei,$user_root1);
			}
			else
			{
				$i=0;
				foreach ( explode(';',$usuario['empresas'] )  as $esta_empresa) 
				{
					if ($esta_empresa > 0)
					{//	echo $esta_empresa.'-';
						$gss[$i]=$esta_empresa;
					//	echo $gss[$i].'-';
						$i++;
					}
				}	
				$data['clientes'] = $this->cliente->get_allo_gss($rows,$gss,$usuario['acciones'],$usuario['suc_id'] );
				$data['c_empresas'] = $i; 
				
			}				
		
		}



			
        $this->load->model('empresa/Empresa_model','empresa');

		if (($user_root3 == 2) && ($user_root4 == 3))
		{ 
			$data['empresas'] = $this->empresa->get_all_empresas_gsi_id();	
		}
		elseif ($user_root4 == 0)
		{
        $data['empresas'] = $this->empresa->trae_empresas(1);//$this->empresa->get_all_empresas();
		$data['sucursales'] = $this->empresa->get_all_sucursales();
		}
		elseif ($user_root4 == 4)
		{
			$data['empresas'] = $this->empresa->trae_emp_asig($medico['usr_emp_asig']);			
		}
		elseif (($user_root4 == 3) || ($user_root4 == 7))
		{
			$data['empresas'] = $this->empresa->get_all_empresas_gsi_id();			
		}
		elseif ($user_root4 == 5)
		{
			$data['empresas'] = $this->empresa->trae_emp_asig($medico['usr_emp_asig']);			
		}
		elseif ($user_root4 == 6)
		{
			$data['empresas'] = $this->empresa->get_all_empresas_gsi_id();			
		}	

		
		if ( strstr($usuario['portal'],'CORPO') )
		{	
			if ( strstr($usuario['empresas'],'TCORP') )
			{
				$data['empresas'] = $this->empresa->get_all_empresas_gsi_id();	
				$data['c_empresas'] = 0; 
			}
			else
			{
				$i=0;
				foreach ( explode(';',$usuario['empresas'] )  as $esta_empresa) 
				{
					if ($esta_empresa > 0)
					{	
						$gss[$i]=$esta_empresa;
						$i++;
					}
				}	
				
				$data['empresas'] =  $this->empresa->get_all_empresas_gss($gss);
				$data['c_empresas'] = $i; 
			}	
		
		}elseif ( strstr($usuario['portal'],'EMPSGSI') )
		{	
			if ( strstr($usuario['empresas'],'TGSI') )
			{
				$data['empresas'] = $this->empresa->get_all_empresas_gsi_id();	
				$data['c_empresas'] = 0; 
			}
			else
			{
				$i=0;
				foreach ( explode(';',$usuario['empresas'] )  as $esta_empresa) 
				{
					if ($esta_empresa > 0)
					{	
						$gss[$i]=$esta_empresa;
						$i++;
					}
				}	
				
				$data['empresas'] =  $this->empresa->get_all_empresas_gss($gss);
				$data['c_empresas'] = $i; 
			}	
		
		}
       $this->load->helper('template');
        $params_view = array(
            'title' => 'Personas',
            'view' => 'persona/index_vehiculo',
            'view_data' => $data 
           );
        render_template($params_view);  
    }


 
 
     public function lista_wrk()
    {   
	    //echo " Punto A ";
		$suc=get_sucursal_id();
		//echo " Punto AA ";
		$user_despacho=get_desp_id_usr();
		//echo " Punto AAA ";
		$user_cei=get_cei_id();
		//echo " Punto AAAA ";
		$user_root1=get_my_user_root1();
		$user_root3=get_my_user_root3();
		$user_root4=get_my_user_root4();
		$user = $this->session->user; 
		$medico = $this->medico->get($user['usr_id']);
		$usuario = $this->medico->get($user['usr_id']);
        $rows = 30;
        $this->load->library('pagination');
        $config['base_url'] = base_url('persona/lista_wrk/');
		
		
		//echo $usuario['empresas'];
		$i=0;
		foreach ( explode(';',$usuario['empresas'] )  as $esta_empresa) 
		{
			if ($esta_empresa > 0)
			{	
				$empresas[$i]=$esta_empresa;
				$i++;
			}
		}
		
		
		
		//$empresas= array(31,289,293);
		$config['total_rows'] = $this->cliente->count_all_wrk($empresas);
 		
		$config['per_page'] = $rows;
        $config['attributes'] = array('class' => 'pagination');
        $config['full_tag_open'] = '<div class="pagination-full">';
        $config['full_tag_close'] = '</div>';
        $config['uri_segment'] = 3;
        $config['query_string_segment'] = 4;
        $config['use_page_numbers'] = TRUE;
        $this->pagination->initialize($config);

		$data['clientes'] = $this->cliente->get_all_wrk($rows, $empresas);
			
        $this->load->model('empresa/Empresa_model','empresa');
        $data['empresas'] = $this->empresa->trae_empresas_wrk($empresas);

        $this->load->helper('template');
        $params_view = array(
            'title' => 'Personas',
            'view' => 'persona/index_wrk',
            'view_data' => $data 
           );
        render_template($params_view);  
    }
 
 
 
 
 
     public function lista_evaluados()
    {   
	    //echo " Punto A ";
		$suc=get_sucursal_id();
		//echo " Punto AA ";
		$user_despacho=get_desp_id_usr();
		//echo " Punto AAA ";
		$user_cei=get_cei_id();
		//echo " Punto AAAA ";
		$user_root1=get_my_user_root1();
		$user_root3=get_my_user_root3();
		$user_root4=get_my_user_root4();
		$user = $this->session->user; 
		$medico = $this->medico->get($user['usr_id']);
		$medico['emp_id']=$user['emp_id'];
		

        $rows = 30;
        $this->load->library('pagination');
        $config['base_url'] = base_url('persona/lista_evaluados/');
        //$config['total_rows'] = $this->cliente->count_all();
		
		$config['total_rows'] = $this->cliente->count_allo_emp_asig($medico['emp_id']);

		$config['per_page'] = $rows;
        $config['attributes'] = array('class' => 'pagination');
        $config['full_tag_open'] = '<div class="pagination-full">';
        $config['full_tag_close'] = '</div>';
        $config['uri_segment'] = 3;
        $config['query_string_segment'] = 4;
        $config['use_page_numbers'] = TRUE;
        $this->pagination->initialize($config);
        
		$data['clientes'] = $this->cliente->get_allo_emp_asig_psw($rows,$medico['emp_id']);

        $this->load->model('empresa/Empresa_model','empresa');
		$data['empresas'] = $this->empresa->trae_emp_asig($medico['emp_id']);		

        $this->load->helper('template');
        $params_view = array(
            'title' => 'Personas',
            'view' => 'persona/index_evaluados',
            'view_data' => $data 
           );
        render_template($params_view);  
    }
 

    public function lista_psw()
    {   
	    //echo " Punto A ";
		$suc=get_sucursal_id();
		//echo " Punto AA ";
		$user_despacho=get_desp_id_usr();
		//echo " Punto AAA ";
		$user_cei=get_cei_id();
		//echo " Punto AAAA ";
		$user_root1=get_my_user_root1();
		$user_root3=get_my_user_root3();
		$user_root4=get_my_user_root4();
		$user = $this->session->user; 
		$medico = $this->medico->get($user['usr_id']);
		$medico['emp_id']=253;
		

        $rows = 30;
        $this->load->library('pagination');
        $config['base_url'] = base_url('persona/lista_psw/');
        //$config['total_rows'] = $this->cliente->count_all();
		
		$config['total_rows'] = $this->cliente->count_allo_emp_asig($medico['emp_id']);

		$config['per_page'] = $rows;
        $config['attributes'] = array('class' => 'pagination');
        $config['full_tag_open'] = '<div class="pagination-full">';
        $config['full_tag_close'] = '</div>';
        $config['uri_segment'] = 3;
        $config['query_string_segment'] = 4;
        $config['use_page_numbers'] = TRUE;
        $this->pagination->initialize($config);
        
		$data['clientes'] = $this->cliente->get_allo_emp_asig_psw($rows,$medico['emp_id']);

        $this->load->model('empresa/Empresa_model','empresa');
		$data['empresas'] = $this->empresa->trae_emp_asig($medico['emp_id']);		

        $this->load->helper('template');
        $params_view = array(
            'title' => 'Personas',
            'view' => 'persona/index_psw',
            'view_data' => $data 
           );
        render_template($params_view);  
    }

    public function lista_dx()
    {   
	    //echo " Punto A ";
		
		$user = $this->session->user; 
		$medico = $this->medico->get($user['usr_id']);
		$corporacion=  get_corporativo_consultorio($medico['usr_emp_asig']);
		$suc=get_sucursal_id();
		$user_despacho=get_desp_id_usr();
		$user_cei=get_cei_id();
		$user_root1=get_my_user_root1();

        $rows = 30;
        $this->load->library('pagination');
        $config['base_url'] = base_url('persona/lista_dx/');
		
		$config['total_rows'] = $this->cliente->count_allo_dx();
		

        $config['per_page'] = $rows;
        $config['attributes'] = array('class' => 'pagination');
        $config['full_tag_open'] = '<div class="pagination-full">';
        $config['full_tag_close'] = '</div>';
        $config['uri_segment'] = 3;
        $config['query_string_segment'] = 4;
        $config['use_page_numbers'] = TRUE;
        $this->pagination->initialize($config);
        //echo " Punto ".$medico['usr_emp_asig'];
		//echo " Punto B ";
        //$data['clientes'] = $this->cliente->get_all($rows);
		
		$data['clientes'] = $this->cliente->get_allo_dx($rows);
		
		
		//echo " Punto C ";
		$this->load->model('empresa/Empresa_model','empresa');
		$data['sucursales']=$this->empresa->get_all_sucursales(get_empresa_consultorio($medico['usr_emp_asig']));

		//echo " Punto E ";		
		$data['corporacion']=$corporacion;
        $data['medico']=$medico;
		$this->load->helper('template');
        $params_view = array(
            'title' => 'Personas',
            'view' => 'persona/index_dx',
            'view_data' => $data 
           );
        render_template($params_view);  
    }

    public function lista_px()
    {   
	    //echo " Punto A ";
		
		$user = $this->session->user; 
		$medico = $this->medico->get($user['usr_id']);
		$corporacion=  get_corporativo_consultorio($medico['usr_emp_asig']);		
		$suc=get_sucursal_id();
		$user_despacho=get_desp_id_usr();
		$user_cei=get_cei_id();
		$user_root1=get_my_user_root1();

        $rows = 30;
        $this->load->library('pagination');
        $config['base_url'] = base_url('persona/lista_p/');
		
		$config['total_rows'] = $this->cliente->count_allo_p($suc,$medico['usr_emp_asig'],$user_despacho,$user_cei,$user_root1,1);

        $config['per_page'] = $rows;
        $config['attributes'] = array('class' => 'pagination');
        $config['full_tag_open'] = '<div class="pagination-full">';
        $config['full_tag_close'] = '</div>';
        $config['uri_segment'] = 3;
        $config['query_string_segment'] = 4;
        $config['use_page_numbers'] = TRUE;
        $this->pagination->initialize($config);
        //echo " Punto ".$medico['usr_emp_asig'];
		//echo " Punto B ";
        //$data['clientes'] = $this->cliente->get_all($rows);
		
		$data['clientes'] = $this->cliente->get_allo_p($rows,$medico['usr_emp_asig'],get_sucursal_id(),$user_despacho,$user_cei,$user_root1,1);
		
		
		//echo " Punto C ";
		$this->load->model('empresa/Empresa_model','empresa');
		$data['sucursales']=$this->empresa->get_all_sucursales(get_empresa_consultorio($medico['usr_emp_asig']));

		//echo " Punto E ";		
		$data['corporacion']=$corporacion;
        $data['medico']=$medico;
		$this->load->helper('template');
        $params_view = array(
            'title' => 'Personas',
            'view' => 'persona/index_px',
            'view_data' => $data 
           );
        render_template($params_view);  
    }






    public function lista_pot()
    {   
	    //echo " Punto A ";
		$user = $this->session->user; 
		$medico = $this->medico->get($user['usr_id']);
		$empresa= $medico['usr_emp_asig'];
        $rows = 30;
        $this->load->library('pagination');
        $config['base_url'] = base_url('persona/lista_pot/');
		
		$config['total_rows'] = $this->cliente->count_allo_p_other($empresa,1);

        $config['per_page'] = $rows;
        $config['attributes'] = array('class' => 'pagination');
        $config['full_tag_open'] = '<div class="pagination-full">';
        $config['full_tag_close'] = '</div>';
        $config['uri_segment'] = 3;
        $config['query_string_segment'] = 4;
        $config['use_page_numbers'] = TRUE;
        $this->pagination->initialize($config);
		//echo " Punto C ";
		$data['clientes'] = $this->cliente->get_allo_p_other($rows,$empresa,1);	
		//echo " Punto E ";			
        $data['medico']=$medico;
		$data['empresa']=$empresa;
		$this->load->helper('template');
        $params_view = array(
            'title' => 'Personas',
            'view' => 'persona/index_pot',
            'view_data' => $data 
           );
        render_template($params_view);  
    }




    public function lista_p()
    {   
	    //echo " Punto A ";
		$corporacion='GSI';
		$suc=get_sucursal_id();
		$user_despacho=get_desp_id_usr();
		$user_cei=get_cei_id();
		$user_root1=get_my_user_root1();
		$user = $this->session->user; 
		$medico = $this->medico->get($user['usr_id']);
		

        $rows = 30;
        $this->load->library('pagination');
        $config['base_url'] = base_url('persona/lista_p/');
		
		if ($corporacion == 'GSI')
		{
			if ( (valida_corporacion($medico['usr_emp_asig'],'GSI') === 'GSI') )
			{
				$config['total_rows'] = $this->cliente->count_allo_p_gsi($suc,$medico['usr_emp_asig'],$user_despacho,$user_cei,$user_root1,1);
			}
			else
			{
				
				$config['total_rows'] = $this->cliente->count_allo_p_gsi($suc,0,$user_despacho,$user_cei,$user_root1,1);
			}
		}



		
        $config['per_page'] = $rows;
        $config['attributes'] = array('class' => 'pagination');
        $config['full_tag_open'] = '<div class="pagination-full">';
        $config['full_tag_close'] = '</div>';
        $config['uri_segment'] = 3;
        $config['query_string_segment'] = 4;
        $config['use_page_numbers'] = TRUE;
        $this->pagination->initialize($config);
        //echo " Punto ".$medico['usr_emp_asig'];
		//echo " Punto B ";
        //$data['clientes'] = $this->cliente->get_all($rows);
		
		
		if ($corporacion == 'GSI')
		{
			if ( (valida_corporacion($medico['usr_emp_asig'],'GSI') === 'GSI') )
			{
				$data['clientes'] = $this->cliente->get_allo_p_gsi($rows,$medico['usr_emp_asig'],get_sucursal_id(),$user_despacho,$user_cei,$user_root1,1);
			}
			else
			{
				
				$data['clientes'] = $this->cliente->get_allo_p_gsi($rows,0,get_sucursal_id(),$user_despacho,$user_cei,$user_root1,1);
			}
		}
				
		
		//echo " Punto C ";
		$this->load->model('empresa/Empresa_model','empresa');
		
		if ($corporacion == 'GSI')
		{	//echo " Punto D ";
			$data['empresas'] = $this->empresa->get_sis15_empresas_gsi(); //$this->empresa->get_all_empresas_gsi();
		}
		
		//echo " Punto E ";		
		
        $data['medico']=$medico;
		$this->load->helper('template');
        $params_view = array(
            'title' => 'Personas',
            'view' => 'persona/index_p',
            'view_data' => $data 
           );
        render_template($params_view);  
    }




    public function lista_pox()
    {   

		$suc=get_sucursal_id();
		$user_despacho=get_desp_id_usr();
		
		$user_cei=get_cei_id();
		$user_root1=get_my_user_root1();
		$user = $this->session->user; 
		$medico = $this->medico->get($user['usr_id']);
		
        $rows = 30;
        $this->load->library('pagination');
        $config['base_url'] = base_url('persona/lista_pox/');
		
		$config['total_rows'] = $this->cliente->count_allo_p_gsi($suc,$medico['usr_emp_asig'],$user_despacho,$user_cei,$user_root1,1);

		
        $config['per_page'] = $rows;
        $config['attributes'] = array('class' => 'pagination');
        $config['full_tag_open'] = '<div class="pagination-full">';
        $config['full_tag_close'] = '</div>';
        $config['uri_segment'] = 3;
        $config['query_string_segment'] = 4;
        $config['use_page_numbers'] = TRUE;
        $this->pagination->initialize($config);

		$data['clientes'] = $this->cliente->get_allo_p_gsi($rows,$medico['usr_emp_asig'],get_sucursal_id(),$user_despacho,$user_cei,$user_root1,1);


		//echo " Punto C ";
		$this->load->model('empresa/Empresa_model','empresa');

		if ($corporacion == 'GSI')
		{	
			$data['empresas'] = $this->empresa->get_sis15_empresas_gsi(); //$this->empresa->get_all_empresas_gsi();
		}
		
		//echo " Punto E ";		
		
        $data['medico']=$medico;
		$this->load->helper('template');
        $params_view = array(
            'title' => 'Personas',
            'view' => 'persona/index_p',
            'view_data' => $data 
           );
        render_template($params_view);  
    }
 
    public function nuevo_COSMETOLOGIA_doc($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('nombre','Nombre documento','required');
			
            if($this->form_validation->run())
            {
                $data_clte['clte_id'] =  $cliente_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                $data_clte['emp_id'] =  $this->input->post('emp_id');
				
                $this->load->library('upload');
				sleep(1);
                if(!empty($_FILES['doc']['name']))
                {
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/docs_cosmetologia/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg|pdf|doc|docx',
                            'max_size'      => '25000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('doc'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['doc_path'] = $data['file_name'];
                        if($this->cliente->add_COSMETOLOGIA_doc(array_to_upper($data_clte)))
                        {
                            send_json_ok('Se guardó de forma correcta');
			
                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
                    send_json_error($this->upload->display_errors());
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'persona/add_cosmetologia_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }




    public function nuevo_NUTRICION_doc($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('nombre','Nombre documento','required');
			
            if($this->form_validation->run())
            {
                $data_clte['clte_id'] =  $cliente_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                $data_clte['emp_id'] =  $this->input->post('emp_id');
				
                $this->load->library('upload');
				sleep(1);
                if(!empty($_FILES['doc']['name']))
                {
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/docs_nutricion/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg|pdf|doc|docx',
                            'max_size'      => '25000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('doc'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['doc_path'] = $data['file_name'];
                        if($this->cliente->add_NUTRICION_doc(array_to_upper($data_clte)))
                        {
                            send_json_ok('Se guardó de forma correcta');
			
                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
                    send_json_error($this->upload->display_errors());
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'persona/add_nutricion_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }

    public function id($id,$seg=0)
    {   
		//echo '1';
		 
		$user = $this->session->user; 
		$usuario = $this->medico->get($user['usr_id']);

		if ((strstr($usuario['acciones'], 'VISTA?')))
		{	
			$n=1;
		}		
		else
		{
			$n=get_desp_id_usr();
		}	

		$user_cei=get_cei_id();
		$user_root1=get_my_user_root1();
		
		//echo '2';
		
		if (( strstr($usuario['portal'],'EMPSGSI') ) && (!(strstr($usuario['modulos'],'SUP3RV5AGSI;') )))
		{
		//echo 'a';
			$this->load->model('empresa/Empresa_model','empresa');	
			
			if ( strstr($usuario['empresas'],'TGSI') )
			{   //echo 'b';
				$empresas_gsi = $this->empresa->get_all_empresas_gsi_id();	
				$i=0;
				foreach ( $empresas_gsi as $esta_empresa) 
				{
					if ($esta_empresa > 0)
					{	
						$gss[$i]=$esta_empresa['emp_id'];
						$i++;
					}
				}
			}
			else
			{   //echo 'c';
				$i=0;
				foreach ( explode(';',$usuario['empresas'] )  as $esta_empresa) 
				{
					if ($esta_empresa > 0)
					{	
						$gss[$i]=$esta_empresa;
						$i++;
					}
				}				
			}	
			
			
			
			
			//echo '3';
			if  ($seg == 3)
			{
				//echo '4';
				$data['cliente'] = $this->cliente->get_all_clientes($id);
				//print_r($data['cliente']);
			}
			else
			{
				$data['cliente'] = $this->cliente->get_special($id,$gss);
			}
						
		}
		else
		{	
			//echo 'd';	
			$data['cliente'] = $this->cliente->get($id,$n);
			//print_r($data['cliente']);
			//echo 'e';
		}


		if ( ($data['cliente']['emp_id'] == 210) && ($seg == 1) )
		{
			if ($data['cliente']['clte_status_proc'] == 'CONFIRMADO' )
			{$actualiza['clte_status_proc']='AGENDADO'; } else { $actualiza['clte_status_proc']='CONFIRMADO'; }	
			$data['cliente']['clte_status_proc']=$actualiza['clte_status_proc'];
			$this->cliente->actualiza_registro($id,$actualiza);
			
		}	

		//echo '-3-';

		if ( strstr($usuario['acciones'],'DESP-;') )
		{
			$n=1;			
		}							
		//echo '-4-';
		if($data['cliente'])
        {
			//echo '4';
			$this->load->model('examen/Medicina_estetica_model','medicina_estetica'); 
			$this->load->model('examen/Cosmetologia_model','cosmetologia'); 
			$this->load->model('examen/Nutricion_model','nutricion'); 
			$this->load->model('examen/Fisioterapia_model','fisioterapia');
			$this->load->model('examen/Hicloeo_model','hicloeo');
			$this->load->model('examen/Hicl030_model','hicl030');
            $this->load->model('examen/Entorno_social_model','entorno_social');
            $this->load->model('examen/Socioeconomico_model','socio_economico');
            $this->load->model('examen/Poligrafico_model','poligrafico');            
            $this->load->model('examen/Psicologico_model','psicologico');
			$this->load->model('examen/Hone_aicm_model','hone_aicm');
            $this->load->model('examen/Recetario_model','recetario');
			$this->load->model('examen/Recipe_model','recipe');
			$this->load->model('examen/Rexipe_model','rexipe');
			$this->load->model('examen/Toxicologico_model3','toxicologico3');		    
            $this->load->model('examen/Toxicologico_model6','toxicologico6');
			
			$this->load->model('examen/Toxicologico_model12','toxicologico12');		
			$this->load->model('examen/Toxicologico_model13','toxicologico13');	
            $this->load->model('examen/prueba_model','prueba');
			$this->load->model('examen/Acreditacion_model','acreditacion');
			$this->load->model('examen/Qrconfianza_model','qrconfianza');
			
            $this->load->model('examen/Historia_clinica_model','historia_clinica');
            $this->load->model('examen/Quimica_sanguinea_model','quimicasan');
			
			
			
			
            
            $this->load->model('examen/Quimica_sanguinea12_model','quimicasan12');
            $this->load->model('examen/Quimica_sanguinea15_model','quimicasan15');
            $this->load->model('examen/Quimica_sanguinea24_model','quimicasan24');
			$this->load->model('examen/Quimica_sanguinea27_model','quimicasan27');
            $this->load->model('examen/Quimica_sanguinea38_model','quimicasan38');
			
			$this->load->model('examen/Electrolitos_sericos_model','ele_sericos');
			
			$this->load->model('examen/Quimica_sanguineaall_model','quimicasanall');
			$this->load->model('examen/Quimica_sanguineaaxa_model','quimicasanaxa');
			
			$this->load->model('examen/Quimica_sanguineamch_model','quimicasanmch');
			$this->load->model('examen/Quimica_sanguineasmty_model','quimicasansmty');
			//echo 'B';
			$this->load->model('examen/Quimica_sanguineaprevem_model','quimicasanprevem');
			//echo 'C';
			$this->load->model('examen/Quimica_sanguinea_insignia_model','quimicasan_insignia');
			$this->load->model('examen/Quimica_sanguinea_g_seguros_model','quimicasan_g_seguros');
			
			
			
			$this->load->model('examen/Quimica_sanguineagnp_model','quimicasan_gnp');
			$this->load->model('examen/Perfil_tiroideo_i_model','perfil_tiroideo_i');
			
			
            
           
			
            $this->load->model('examen/Essoec_model','gsi');
            $this->load->model('examen/Sociolaboral_model','sociolaboral');
			$this->load->model('examen/SS/Ssestsoc_model','segurisec');
			
            $this->load->model('examen/Eye_detect_model','eye_detect');
			
			
			$this->load->model('examen/Alcohol_model','alcohol_detect');
			$this->load->model('examen/Colinesterasa_serica_model','colinesterasa');

			
			
			$this->load->model('examen/Historia_clinica_model','fpfh_detect');
			$this->load->model('examen/Historia_clinica_model','fsm_odon_detect');
			$this->load->model('examen/Pie_model','pyb');			
			
			$this->load->model('examen/Nom035_model','nom035');
			$this->load->model('examen/Nom035ii_model','nom035ii');
			$this->load->model('examen/Nom035iii_model','nom035iii');
			
			$this->load->model('examen/Prestamo_model','prestamo');
			
			$this->load->model('examen/Generico_model','generico');			
			$this->load->model('examen/Prost_model','prost');
			$this->load->model('examen/Hba1c_model','hba1c');
			$this->load->model('examen/Plomo_model','plomo');

			$this->load->model('examen/Flotilla_model','flotilla');

			$this->load->model('examen/Analisis_vehicular_model','analisis_vehicular');

			$this->load->model('examen/Reacciones_model','reacciones');
			$this->load->model('examen/Hbsag_model','hbsag');
			$this->load->model('examen/Hcap_model','hcap');
			$this->load->model('examen/Cotinina_model','cotinina');
			
			$this->load->model('examen/Exudado_model','exudado');
			
			//echo '-D-';
			
			$this->load->model('examen/Vih_model','vih');
			$this->load->model('examen/Imuno_model','imuno');
			$this->load->model('examen/Cps_model','cps');
			$this->load->model('examen/Hiv_model','hiv');
			$this->load->model('examen/Aba_model','aba');
			$this->load->model('examen/Abh_model','abh');
			$this->load->model('examen/Cacocido_model','cacocido');
			$this->load->model('examen/Cacrudo_model','cacrudo');
			$this->load->model('examen/Csinerte_model','csinerte');
			$this->load->model('examen/Csvivo_model','csvivo');
			$this->load->model('examen/Cprocu_model','cprocu');
			$this->load->model('examen/Cultun_model','cultun');
			$this->load->model('examen/Adroga_model','adroga');
			$this->load->model('examen/Vdrl_model','vdrl');
			$this->load->model('examen/Spiro_model','spiro');
			$this->load->model('examen/Evacom_model','evacom');
			
			//echo '-d-';
			
			$this->load->model('examen/Notas_medicas_model','nmedica');
			$this->load->model('examen/Notas_psicologicas_model','npsicologica');
			
			$this->load->model('examen/Notas_uni_medicas_model','unimedica');
			$this->load->model('examen/Notas_uni_psicologicas_model','unipsicologica');
			
			
			
			//echo '-q-';
			$this->load->model('examen/Notas_nutricionales_model','nnutricional');
			
			$this->load->model('examen/Entorno_serviseg_model','eserviseg');
			
			$this->load->model('examen/Medico_fisico_ext_model','medico_fisico_ext');
			$this->load->model('examen/Toma_muestras_model','muestras');
			$this->load->model('examen/Toma_muestras_sanguineas_model','muestras_sanguineas');
			$this->load->model('examen/Toma_muestras_orina_model','muestras_orina');
			//echo 'D';
			$this->load->model('examen/Cert_medico_model','certificado');
			//echo 'e';
			$this->load->model('examen/Curso_model','curso');
			
			$this->load->model('examen/Venta_producto_model','venta_producto');
			$this->load->model('examen/Venta_producto02_model','venta_producto02');
			$this->load->model('examen/HCEXME/Exmeper_model','exmeper');
			$this->load->model('examen/EXMEDINIC/Exmedinic_model','exmedinic');
			$this->load->model('examen/Salud_ocupacional_model','salud_ocupacional');
			
			$this->load->model('capacitacion_maritima/Capacitacion_maritima_model','cama');
			//echo 'F';
			$this->load->model('examen/Percepcion_cromatica_model','percro');
			//echo 'G';
			
			$this->load->model('examen/NOM30_model','NOM0');
			$this->load->model('examen/Nom0_model','NOM00');
			
			$this->load->model('examen/Perfil_psicologico_model','psico');
			$this->load->model('examen/FSM_ODON/Perfil_odontologico_model','perfil_odonto');
			
			$this->load->model('examen/Historia_clinica_jr_model','historia_clinica_jr');
			

            $data['medico']=$user;
            $data['socio_economicos'] = $this->socio_economico->get_by_clte($id,$n);            
			$data['entorno_social'] = $this->entorno_social->get_by_clte($id,$n);            
			
			$data['fsms_hicl030'] = $this->hicl030->get_by_clte($id);            
			$data['fsms_hicloeo'] = $this->hicloeo->get_by_clte($id);
			
			
			
			$data['fsms_02'] = $this->poligrafico->get_by_clte($id,'POLI',$n);
            $data['fsmsc_02'] = $this->poligrafico->get_by_clte($id,'CEDULA',$n);						
           		
            $data['fsms_05'] = $this->psicologico->get_by_clte($id,$n); /*CEDULA PSICOLOGICA*/				
			$data['fsms_psicor'] = $this->psicologico->get_by_clte_r($id,$n); /*REPORTE PSICOLOGICO*/		
            $data['fsms_05_simple'] = $this->psicologico->get_by_clte_simple($id,$n); /*CEDULA PSICOLOGICA SIMPLE*/				
			
			$data['fsms_psicor_simple'] = $this->psicologico->get_by_clte_r_simple($id,$n); 	
            $data['fsms_rep_psic_as'] = $data['fsms_psicor_simple']; 	
			
			
			$data['fsms_t3'] = $this->toxicologico3->get_by_clte($id,$n);
           
			$data['fsms_t6'] = $this->toxicologico6->get_by_clte($id,$n);	
			$data['fsms_t12'] = $this->toxicologico12->get_by_clte($id,$n);
			$data['fsms_t13'] = $this->toxicologico13->get_by_clte($id,$n);
            $data['fsms_09'] = $this->prueba->get_by_clte($id,$n);
			
            $data['fsms_03'] = $this->acreditacion->get_by_clte($id,$n);			
			
			$data['fsms_qrconfianza'] = $this->qrconfianza->get_by_clte($id);
			
			//echo '-DD-';
			
            $data['fsms_lala'] = $this->historia_clinica->get_by_clte($id,'',$n);
						
						
            $data['fsm_qs'] = $this->quimicasan->get_by_clte($id,$n);			
            
          
            $data['fsm_qs12'] = $this->quimicasan12->get_by_clte($id,$n);
            $data['fsm_qs15'] = $this->quimicasan15->get_by_clte($id,$n);
            $data['fsm_qs24'] = $this->quimicasan24->get_by_clte($id,$n);
			$data['fsm_qs27'] = $this->quimicasan27->get_by_clte($id,$n);
            $data['fsm_qs38'] = $this->quimicasan38->get_by_clte($id,$n);
			$data['fsm_ele_sericos'] = $this->ele_sericos->get_by_clte($id,$n);
			
			//echo '-DDD-';
			
			$data['fsm_qsall'] = $this->quimicasanall->get_by_clte($id,$n);
			$data['fsm_qsprevem'] = $this->quimicasanprevem->get_by_clte($id);	
			 
		
			$data['fsm_qsaxa'] = $this->quimicasanaxa->get_by_clte($id,$n);

			if ( strstr($data['cliente']['nomserv'],'QSBX+;') )
			{
				$this->load->model('examen/Quimica_sanguinea_bx_model','quimicasan_bx');
				$data['fsm_qsbx'] = $this->quimicasan_bx->get_by_clte($id,$n);			
			}			

			if ( strstr($data['cliente']['nomserv'],'PFIIBX+;') )
			{
				$this->load->model('examen/Quimica_sanguinea_bx_model','quimicasan_bx_pfii');
				$data['fsm_qsbx_pfii'] = $this->quimicasan_bx_pfii->get_by_clte_pfii($id);			
			}
			
			
			$data['fsm_qsinsignia'] = $this->quimicasan_insignia->get_by_clte($id,$n);
			$data['fsm_qsg_seguros'] = $this->quimicasan_g_seguros->get_by_clte($id,$n);

			
			 
			
			$data['fsm_qsgnp'] = $this->quimicasan_gnp->get_by_clte($id,$n);
			$data['fsm_perfil_tiroideo_i'] = $this->perfil_tiroideo_i->get_by_clte($id,$n);


			$data['fsm_qsmch'] = $this->quimicasanmch->get_by_clte($id,$n);
			$data['fsm_qssmty'] = $this->quimicasansmty->get_by_clte($id,$n);

			if ( strstr($data['cliente']['nomserv'],'ODO;') )
			{
				if (strlen($data['cliente']['clte_referencia_evaluado']) > 1)
				{$data['fsm_odon'] = $this->historia_clinica->get_by_clte_referencia_odon($id,$data['cliente']['clte_referencia_evaluado']);}
				else
				{$data['fsm_odon'] = $this->historia_clinica->get_by_clte($id,'fsm_odon',$n);}
			}

			if ( strstr($data['cliente']['nomserv'],'TOXIS;') )
			{
				$this->load->model('examen/Toxicologico_model7','toxicologico7');
				if (strlen($data['cliente']['clte_referencia_evaluado']) > 1)
				{$data['fsms_07'] = $this->toxicologico7->get_by_clte_referencia($id,$data['cliente']['clte_referencia_evaluado']);}
				else
				{$data['fsms_07'] = $this->toxicologico7->get_by_clte($id,$n);}
			}					

			if ( strstr($data['cliente']['nomserv'],'FSM0105;') )
			{
				if (strlen($data['cliente']['clte_referencia_evaluado']) > 1)
				{$data['fpfh'] = $this->historia_clinica->get_by_clte_referencia_fpfh($id,$data['cliente']['clte_referencia_evaluado']);}
				else
				{$data['fpfh'] = $this->historia_clinica->get_by_clte($id,'fpfh',$n);}
			}

			if ( strstr($data['cliente']['nomserv'],'MEDFIS;') )
			{
				$this->load->model('examen/Medico_fisico_model','medico_fisico');
				if (strlen($data['cliente']['clte_referencia_evaluado']) > 1)
				{$data['fsms_04'] = $this->medico_fisico->get_by_clte_referencia($id,$data['cliente']['clte_referencia_evaluado']);}
				else
				{$data['fsms_04'] = $this->medico_fisico->get_by_clte($id,$n);	}
			}	

			if ( strstr($data['cliente']['nomserv'],'TOXI;') )
			{
				$this->load->model('examen/Toxicologico_model','toxicologico');
				if (strlen($data['cliente']['clte_referencia_evaluado']) > 1)
				{$data['fsms_06'] = $this->toxicologico->get_by_clte_referencia($id,$data['cliente']['clte_referencia_evaluado']);}
				else
				{$data['fsms_06'] = $this->toxicologico->get_by_clte($id,$n);}
			}			
			
			if ( strstr($data['cliente']['nomserv'],'BIOHEM;') )
			{
				$this->load->model('examen/Biometria_hematica_model','biometria');
				if (strlen($data['cliente']['clte_referencia_evaluado']) > 1)
				{$data['fsm_bh'] = $this->biometria->get_by_clte_referencia($id,$data['cliente']['clte_referencia_evaluado']);}
				else
				{$data['fsm_bh'] = $this->biometria->get_by_clte($id,$n);}
			}

			if ( strstr($data['cliente']['nomserv'],'GPOSAN;') )
			{
				$this->load->model('examen/Grupo_sanguineo_model','grupo_sanguineo');
				if (strlen($data['cliente']['clte_referencia_evaluado']) > 1)
				{$data['fsm_gs'] = $this->grupo_sanguineo->get_by_clte_referencia($id,$data['cliente']['clte_referencia_evaluado']);}
				else
				{$data['fsm_gs'] = $this->grupo_sanguineo->get_by_clte($id,$n);}
			}			
			
			if ( strstr($data['cliente']['nomserv'],'ORINA;') )
			{
				$this->load->model('examen/Orina_model','orina');
				if (strlen($data['cliente']['clte_referencia_evaluado']) > 1)
				{$data['fsm_or'] = $this->orina->get_by_clte_referencia($id,$data['cliente']['clte_referencia_evaluado']);}
				else
				{$data['fsm_or'] = $this->orina->get_by_clte($id,$n);}
			}			

			if ( strstr($data['cliente']['nomserv'],'QS6;') )
			{
				$this->load->model('examen/Quimica_sanguinea6_model','quimicasan6');
				if (strlen($data['cliente']['clte_referencia_evaluado']) > 1)
				{$data['fsm_qs6'] = $this->quimicasan6->get_by_clte_referencia($id,$data['cliente']['clte_referencia_evaluado']);}
				else
				{$data['fsm_qs6'] = $this->quimicasan6->get_by_clte($id,$n);}
			}	

			if ( strstr($data['cliente']['nomserv'],'COV19R;') )
			{
				$this->load->model('examen/Covid_model','covid_detect');
				if (strlen($data['cliente']['clte_referencia_evaluado']) > 1)
				{$data['fsm_covid'] = $this->covid_detect->get_by_clte_referencia($id,$data['cliente']['clte_referencia_evaluado']);}
				else
				{$data['fsm_covid'] = $this->covid_detect->get_by_clte($id,$n);}
			}

			if ( strstr($data['cliente']['nomserv'],'PIE;') )
			{
				$this->load->model('examen/Pie_model','pie_detect');
				if (strlen($data['cliente']['clte_referencia_evaluado']) > 1)
				{$data['fsm_pie'] = $this->pie_detect->get_by_clte_referencia($id,$data['cliente']['clte_referencia_evaluado']);}
				else
				{$data['fsm_pie'] = $this->pie_detect->get_by_clte($id,$n);}
			}

			if ( strstr($data['cliente']['nomserv'],'TOMAS;') )
			{
				$this->load->model('examen/Toma_muestras_sanguineas_model','muestras_sanguineas');
				$data['fsms_tomas'] = $this->muestras_sanguineas->get_by_clte($id,$n);
			}
			
			if ( strstr($data['cliente']['nomserv'],'TOMAO;') )
			{
				$this->load->model('examen/Toma_muestras_orina_model','muestras_orina');
				$data['fsms_tomao'] = $this->muestras_orina->get_by_clte($id,$n);
			}
		
			if ( strstr($data['cliente']['nomserv'],'TOMAADS;') )
			{
				$this->load->model('examen/Toma_muestras_sanguineas_adicional_model','muestras_sanguineas_adicionales');
				$data['fsms_tomaads'] = $this->muestras_sanguineas_adicionales->get_by_clte($id,$n);
			}
		
			if ( strstr($data['cliente']['nomserv'],'TOMAADO;') )
			{
				$this->load->model('examen/Toma_muestras_orina_adicional_model','muestras_orina_adicionales');
				$data['fsms_tomaado'] = $this->muestras_orina_adicionales->get_by_clte($id,$n);
			}			
			
			if ( strstr($data['cliente']['nomserv'],'ENTFIN;') )
			{
			$data['FINANCIERO_docs'] =$this->cliente->get_generico_docs($id,'ENTFIN;');
			//$data['FINANCIERO_docs'] = $this->cliente->get_FINANCIERO_docs($id);
			}

			if ( strstr($data['cliente']['nomserv'],'BENDER;') )
			{
			$data['bender_docs'] =$this->cliente->get_generico_docs($id,'BENDER;');
			}

			if ( strstr($data['cliente']['nomserv'],'INREFLA;') )
			{
			$data['INREFLA_docs'] =$this->cliente->get_generico_docs($id,'INREFLA;');
			}

			if ( strstr($data['cliente']['nomserv'],'SOCDIGLAB;') )
			{
			$data['SOCDIGLAB_docs'] =$this->cliente->get_generico_docs($id,'SOCDIGLAB;');
			}			
			
            $this->load->model('examen/Quimica_sanguinea3_model','quimicasan3'); 
			$data['fsm_qs3'] = $this->quimicasan3->get_by_clte($id,$n);
            

            $data['sociolaboral'] = $this->sociolaboral->get_by_clte($id,$n);
			
     		$data['essoecs'] = $this->gsi->get_by_clte($id,$n);	
            
			
			$data['fsm_hone_aicm'] = $this->hone_aicm->get_by_clte($id,$n);
            
			$data['fsm_alcohol'] = $this->alcohol_detect->get_by_clte($id,$n);
			$data['fsms_colinesterasa'] = $this->colinesterasa->get_by_clte($id,$n);

			
			$data['fsm_generico'] = $this->generico->get_by_clte($id,$n);
			$data['fsm_prost'] = $this->prost->get_by_clte($id,$n);
			$data['fsm_hba1c'] = $this->hba1c->get_by_clte($id,$n);
			$data['fsm_plomo'] = $this->plomo->get_by_clte($id,$n);
			
			
			$data['fsm_reacciones'] = $this->reacciones->get_by_clte($id,$n);
			$data['fsm_hbsag'] = $this->hbsag->get_by_clte($id,$n);
			$data['fsm_hcap'] = $this->hcap->get_by_clte($id,$n);
			$data['fsm_cotinina'] = $this->cotinina->get_by_clte($id,$n);
			$data['fsm_exudado'] = $this->exudado->get_by_clte($id,$n);
			$data['fsm_vih'] = $this->vih->get_by_clte($id,$n);
			$data['fsm_imuno'] = $this->imuno->get_by_clte($id,$n);	
			
			$data['fsm_cps'] = $this->cps->get_by_clte($id,$n);
			$data['fsm_hiv'] = $this->hiv->get_by_clte($id,$n);
			$data['fsm_aba'] = $this->aba->get_by_clte($id,$n);
			$data['fsm_abh'] = $this->abh->get_by_clte($id,$n);
			$data['fsm_cacocido'] = $this->cacocido->get_by_clte($id,$n);
			$data['fsm_cacrudo'] = $this->cacrudo->get_by_clte($id,$n);
			$data['fsm_csinerte'] = $this->csinerte->get_by_clte($id,$n);
			$data['fsm_csvivo'] = $this->csvivo->get_by_clte($id,$n);
			$data['fsm_cprocu'] = $this->cprocu->get_by_clte($id,$n);
			$data['fsm_cultun'] = $this->cultun->get_by_clte($id,$n);
			$data['fsm_adroga'] = $this->adroga->get_by_clte($id,$n);
			$data['fsm_vdrl'] = $this->vdrl->get_by_clte($id,$n);			
			$data['SPIRO_docs'] = $this->spiro->get_by_clte($id,$n);		
			$data['EVACOM_docs'] = $this->evacom->get_by_clte($id,$n);	
			
			$data['eyes'] = $this->eye_detect->get_by_clte($id,$n);   		
			$data['fsm_pyb'] = $this->pyb->get_by_clte_pyb($id,'fsm_pyb',$n);			
			$data['fsm_ssestsoc'] = $this->segurisec->get_by_clte($id,$n);			
			$data['fsms_nom035'] = $this->nom035->get_by_clte($id,$n);
			$data['fsms_nom035ii'] = $this->nom035ii->get_by_clte($id,$n);
			$data['fsms_nom035iii'] = $this->nom035iii->get_by_clte($id,$n);			
			
			$data['fsms_prestamo'] = $this->prestamo->get_by_clte($id,$n);
		
		    $data['fsms_tomam'] = $this->muestras->get_by_clte($id,$n);
			
	
			
			$data['fsms_certificado_medico'] = $this->certificado->get_by_clte($id,$n);
			$data['fsms_curso'] = $this->curso->get_by_clte($id,$n);
			$data['fsms_venta_producto'] = $this->venta_producto->get_by_clte($id,$n);
			$data['fsms_venta_producto02'] = $this->venta_producto02->get_by_clte($id,$n);

			$data['fsms_ISOAM'] = $this->salud_ocupacional->get_by_clte_ISOAM($id,$n);
			$data['fsms_ISOACC'] = $this->salud_ocupacional->get_by_clte_ISOACC($id,$n);
			$data['fsms_ISOEXP'] = $this->salud_ocupacional->get_by_clte_ISOEXP($id,$n);
			$data['fsms_ISOINC'] = $this->salud_ocupacional->get_by_clte_ISOINC($id,$n);
			$data['fsms_ISOEXI'] = $this->salud_ocupacional->get_by_clte_ISOEXI($id,$n);
			$data['fsms_ISOPV'] = $this->salud_ocupacional->get_by_clte_ISOPV($id,$n);
			$data['fsms_ISOCP'] = $this->salud_ocupacional->get_by_clte_ISOCP($id,$n);
			$data['fsms_ISOEXMP'] = $this->salud_ocupacional->get_by_clte_ISOEXMP($id,$n);
            
			$data['fsms_ISOEXMEDINEX'] = $this->salud_ocupacional->get_by_clte_ISOEXMEDINEX($id,$n);
			$data['fsms_ISONORDICO'] = $this->salud_ocupacional->get_by_clte_ISONORDICO($id,$n);
			$data['fsms_FEHS034'] = $this->salud_ocupacional->get_by_clte_FEHS034($id,$n);
			$data['fsms_FEHS035'] = $this->salud_ocupacional->get_by_clte_FEHS035($id,$n);
			$data['fsms_CARATULA'] = $this->salud_ocupacional->get_by_clte_CARATULA($id,$n);
			$data['fsms_percro'] = $this->percro->get_by_clte($id,$n);
			
			$data['fsms_ISOEXMESAOC'] = $this->NOM0->get_by_clte($id,$n);
			$data['fsms_hcsyngenta'] = $this->NOM00->get_by_clte_hcsyngenta($id);
			
			
			$data['fsms_PERFOD'] = $this->perfil_odonto->get_by_clte_PERFPSC($id,$n);    
            $data['fsms_PERFPSC'] = $this->psico->get_by_clte_PERFPSC($id,$n);
			$data['fsms_FLOTILLA'] = $this->flotilla->get_by_clte($id);
			$data['fsms_ARVP'] = $this->analisis_vehicular->get_by_clte($id,$n);
			$data['docs'] = $this->cliente->get_docs($id);
			$data['coms'] = $this->cliente->get_coms($id);
			
			$data['hon_docs'] = $this->cliente->get_hon_docs($id);
			$data['compo_docs'] = $this->cliente->get_compo_docs($id);

			$data['PENSA_docs'] = $this->cliente->get_PENSA_docs($id);
			$data['EGEREN_docs'] = $this->cliente->get_EGEREN_docs($id);
			$data['TERMAN_docs'] = $this->cliente->get_TERMAN_docs($id);
			$data['RAVEN_docs'] = $this->cliente->get_RAVEN_docs($id);
			$data['STRESS_docs'] = $this->cliente->get_STRESS_docs($id);
			
	        $data['rentoxi_docs'] = $this->cliente->get_rentoxi_docs($id); 
			$data['renpsico_docs'] = $this->cliente->get_renpsico_docs($id); 
			$data['renperfiles_docs'] = $this->cliente->get_renperfiles_docs($id); 
			$data['renodo_docs'] = $this->cliente->get_renodo_docs($id); 
			$data['renexamed_docs'] = $this->cliente->get_renexamed_docs($id); 
			$data['renentsol_docs'] = $this->cliente->get_renentsol_docs($id);
			
			$data['INTE_docs'] = $this->cliente->get_INTE_docs($id);
			
			$data['PUESIC_docs'] = $this->cliente->get_PUESIC_docs($id);
			
			$data['pensante_docs'] = $this->cliente->get_pensante_docs($id);
			$data['cleaver_docs'] = $this->cliente->get_cleaver_docs($id);
			
			$data['cama000_docs'] = $this->cliente->get_cama000_docs($id);
			$data['entrevista_docs'] = $this->cliente->get_entrevista_docs($id);
			$data['proyectivas_docs'] = $this->cliente->get_proyectivas_docs($id);
		
		
		
			
			$data['vendedor_docs'] = $this->cliente->get_vendedor_docs($id);
			$data['sgmty_docs'] = $this->cliente->get_sgmty_docs($id);
			$data['covid_docs'] = $this->cliente->get_covid_docs($id);
			$data['AUDIO_docs'] = $this->cliente->get_AUDIO_docs($id);
			$data['VISTA_docs'] = $this->cliente->get_VISTA_docs($id);
			
			$data['ELECTRO_docs'] = $this->cliente->get_ELECTRO_docs($id);
			$data['ELECTROR_docs'] = $this->cliente->get_ELECTROR_docs($id);
			$data['ELECTROE_docs'] = $this->cliente->get_ELECTROE_docs($id);
			
			$data['CERTIFICADO_docs'] = $this->cliente->get_CERTIFICADO_docs($id);
			$data['PPSM16PF_docs'] = $this->cliente->get_PPSM16PF_docs($id);
			$data['MARINA_docs'] = $this->cliente->get_MARINA_docs($id);

			$data['EVALUACION_DIAGNOSTICA_docs'] = $this->cliente->get_EVALUACION_DIAGNOSTICA_docs($id);
			$data['EVALUACION_FINAL_docs'] = $this->cliente->get_EVALUACION_FINAL_docs($id);
			
			$data['hhcc_docs'] = $this->cliente->get_hhcc_docs($id);
			
			$data['BURO_docs'] = $this->cliente->get_BURO_docs($id);
			$data['LEGAL_docs'] = $this->cliente->get_LEGAL_docs($id);
			$data['EXAMM_docs'] = $this->cliente->get_EXAMM_docs($id);
			
			$data['VDRL_docs'] = $this->cliente->get_VDRL_docs($id);
			
			
			
			$data['KOH_docs'] = $this->cliente->get_KOH_docs($id);
			$data['KOH_docs'] = $this->cliente->get_KOH_docs($id);
			
			$data['VALPROF_docs'] = $this->cliente->get_VALPROF_docs($id);
			

			$data['PAPAN_docs'] = $this->cliente->get_PAPAN_docs($id);
			$data['RADIOT_docs'] = $this->cliente->get_RADIOT_docs($id);
			$data['RADIOL_docs'] = $this->cliente->get_RADIOL_docs($id);
			$data['TORAX_docs'] = $this->cliente->get_TORAX_docs($id);
			$data['RADIOM_docs'] = $this->cliente->get_RADIOM_docs($id);
			
			$data['OPTOM_docs'] = $this->cliente->get_OPTOM_docs($id);
			
			$data['ALCOSA_docs'] = $this->cliente->get_ALCOSA_docs($id);
			$data['ANTICUA_docs'] = $this->cliente->get_ANTICUA_docs($id);
			$data['PCR_docs'] = $this->cliente->get_PCR_docs($id);			
			
			$data['cama001_docs'] = $this->cama->get_cama001_docs($id);
			$data['cama002_docs'] = $this->cama->get_cama002_docs($id);
			$data['cama003_docs'] = $this->cama->get_cama003_docs($id);
			$data['cama004_docs'] = $this->cama->get_cama004_docs($id);
			$data['cama005_docs'] = $this->cama->get_cama005_docs($id);
			
			
			$data['fsms_recetario'] = $this->recetario->get_by_clte_r($id,$n);
			$data['fsms_REFMED'] = $this->recetario->get_by_clte_refmed($id);
			$data['fsms_NOTMED'] = $this->recetario->get_by_clte_notmed($id);
			$data['fsms_NOTDREF'] = $this->recetario->get_by_clte_notdref($id);
			
			$data['fsms_recipe'] = $this->recipe->get_by_clte_r($id,$n);
			$data['fsms_rexipe'] = $this->rexipe->get_by_clte_r($id,$n);
			$data['fsms_nmedica'] = $this->nmedica->get_by_clte_r($id,$n);			
			$data['fsms_nnutricional'] = $this->nnutricional->get_by_clte_r($id,$n);
			$data['fsms_npsicologica'] = $this->npsicologica->get_by_clte_r($id,$n);
			
			
			$data['fsms_unimedica'] = $this->unimedica->get_by_clte_r($id,$n);
			$data['fsms_unipsicologica'] = $this->unipsicologica->get_by_clte_r($id,$n);
			
			
			
			$data['fsms_eserviseg'] = $this->eserviseg->get_by_clte($id,$n);
			//echo 'f';
			$data['fsms_medxfis'] = $this->medico_fisico_ext->get_by_clte($id,$n);
			//echo 'g';
			$data['fsms_exmeper'] = $this->exmeper->get_by_clte($id,$n);
			$data['fsms_exmedinic'] = $this->exmedinic->get_by_clte($id,$n);
			
			
			//echo 'h';
			//$data['fsms_hcext'] = $this->historia_clinica_ext->get_by_clte($id,$n);
			//$data['fsms_HCSYNGENTA'] = $this->historia_clinica_ext->get_by_clte($id,$n);
			$data['EXMEDDS_docs'] = $this->cliente->get_EXAMMDS_docs($id);
			$data['LABORATORIODS_docs'] = $this->cliente->get_LABORATORIODS_docs($id);
			
			$data['recodo_docs'] = $this->cliente->get_gen_docs($id,'RECODO','sis10_clientes_gen_doc');
			$data['conodo_docs'] = $this->cliente->get_gen_docs($id,'CONODO','sis10_clientes_gen_doc');
			
		/*	$data['NUTRICION_docs'] = $this->cliente->get_NUTRICION_docs($id);
            $data['COSMETOLOGIA_docs'] = $this->cliente->get_COSMETOLOGIA_docs($id);*/
            $data['fsm_medicina_estetica'] = $this->medicina_estetica->get_by_clte_r_simple($id); 	
			$data['fsm_cosmetologia'] = $this->cosmetologia->get_by_clte_r_simple($id); 
			$data['fsm_nutricion'] = $this->nutricion->get_by_clte_r_simple($id); 
			$data['fsm_fisioterapia'] = $this->fisioterapia->get_by_clte_r_simple($id); 
			$data['fsms_historia_clinica_jr'] = $this->historia_clinica_jr->get_by_clte($id);
			
			//echo '-z-';
			
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Evaluados',
                'view' => 'persona/cliente',
                'view_data' => $data 
               );

            render_template($params_view);  
        }
        else
        {
            show_error('¡El cliente no existe!');
        }
    }

 
 
 
    public function ref_pac_eva_gsi($id)
    {   
		$user = $this->session->user; 
		$usuario = $this->medico->get($user['usr_id']);
		$cliente = $this->cliente->get($id,$n);

		$data['evaluados'] = $this->cliente->busca(
		$empresa, 
		$cliente['clte_nombre'],
		$cliente['clte_paterno'],
		$cliente['clte_materno'],
		$rfc, 
		$ubicacion,
		$despacho,
		$emp_id_user,
		$id_persona,
		$cei,$sucursal,
		$odt,
		$estatus_proc,
		$gerente,
		$orden_f_ini,
		$orden_f_fin
		);
		$data['cliente']=$cliente;


		if($data['cliente'])
        {
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Evaluados',
                'view' => 'persona/cletus',
                'view_data' => $data 
               );

            render_template($params_view);  
        }
        else
        {
            show_error('El cliente no existe.');
        }
    }


    public function ref_pac_eva_gsi_accion($id_paciente,$id_evaluados)
    {   
	$user = $this->session->user; 
		$usuario = $this->medico->get($user['usr_id']);
		$paciente = $this->cliente->get($id_paciente,$n);
		$data['cliente']=$paciente;	
		$update['nomserv']= $paciente['nomserv'];

		$evaluados_array = explode("_", $id_evaluados);
		foreach ($evaluados_array as $evaluado)
		{
			$evaluado_rec = $this->cliente->get($evaluado,$n);
			$servicios = explode(";", $evaluado_rec['nomserv']);
			foreach($servicios as $servicio)
			{
				if (!(strstr($update['nomserv'],$servicio)))
				{
					$update['nomserv'].=$servicio.';';
				}
			}
		}
		$update['nomserv']=str_replace(";;;", ";", $update['nomserv']) ; 
		$update['nomserv']=str_replace(";;", ";", $update['nomserv']) ; 
		$update['clte_referencia_evaluado']=$id_evaluados;
		
		$this->cliente->actualiza($id_paciente, $update);

		header('Location:'.base_url('persona/ref_pac_eva_gsi').'/'.$id_paciente);
		exit;

    }

    public function ref_pac_eva_gsi_maccion($id_paciente)
    {   
		$user = $this->session->user; 
		$usuario = $this->medico->get($user['usr_id']);
		$paciente = $this->cliente->get($id_paciente,$n);		
		$data['cliente']=$paciente;		

		
		$update['nomserv']= 'RECETA;REFMED;NOTMED;NOTDREF;EXMEPER;';
		$update['clte_referencia_evaluado']=0;

		$this->cliente->actualiza($id_paciente, $update);
		
		header('Location:'.base_url('persona/ref_pac_eva_gsi').'/'.$id_paciente);
		exit;
    }
 
   public function idaa($cliente_id)
    {   
		$user = $this->session->user; 
		$usuario = $this->medico->get($user['usr_id']);
		$data['persona'] = $this->cliente->get($cliente_id,0); 
		$this->load->helper('pdf');
		tamplete($this->load->view('persona/pdf_idaa',$data,TRUE),$data['cliente']['med_id'],$data['cliente']['med_id'],$data['cliente']['med_id'],'Humancenter Review S.A de C.V.');
	}

   public function ida($cliente_id)
    {   
		$user = $this->session->user; 
		$usuario = $this->medico->get($user['usr_id']);
		$data['persona'] = $this->cliente->get($cliente_id,0); //get_desp_id_usr()
		$this->load->helper('pdf');
		tamplete($this->load->view('persona/pdf_ida',$data,TRUE),$data['cliente']['med_id'],$data['cliente']['med_id'],$data['cliente']['med_id'],'Humancenter Review S.A de C.V.');
	}
	
   public function cedula_rh($cliente_id)
    {   
		$user = $this->session->user; 
		$usuario = $this->medico->get($user['usr_id']);
		$data['persona'] = $this->cliente->get($cliente_id,0); //get_desp_id_usr()
		$this->load->helper('pdf');
		tamplete_blank($this->load->view('persona/pdf_cedula_rh',$data,TRUE),$data['cliente']['med_id'],$data['cliente']['med_id'],$data['cliente']['med_id'],'Humancenter Review S.A de C.V.');
	}	
	
	
/***************************************************************************************************************************************/
public function pdf_credencial($cliente_id) {
    $data['persona'] = $this->cliente->get($cliente_id, get_desp_id_usr());
    $this->load->helper('pdf');

    // HTML de la primera página
    $html_pagina1 = $this->load->view('persona/pdf_credencial', $data, TRUE);

    // HTML de la segunda página 
    $html_pagina2 = '
	<br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br> 
<!-- RFC -->       
	<div style="text-align:center; margin-top:200px;">
            <span style="font-size:60px; font-weight:bold; color:black;">' .'   '. $data['persona']['clte_rfc'] . '</span>
        </div>
	<br>      
<!-- NSS -->       
        <div style="text-align:center; margin-top:200px;">
            <span style="font-size:60px; font-weight:bold; color:black;">' .'&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;   '. $data['persona']['clte_nss'] . '</span>
        </div>
	<br><br>      
<!-- TIPO SANGRE -->       
        <div style="text-align:center; margin-top:200px;">
            <span style="font-size:60px; font-weight:bold; color:black;">' .'&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;   '. $data['persona']['clte_tipo_sangre'] . '</span>
        </div>



    ';

    genera_pdf_credencial($html_pagina1, 'credencial.pdf', '', '', '', '', 'Humancenter', 'P', $html_pagina2);
}
/***************************************************************************************************************************************/

    public function reportegral_nuevo($cliente_id, $serv_id)
    {
        $data['persona'] = $this->cliente->get($cliente_id,get_desp_id_usr());
        $data['servicio'] = $serv_id;
   
        $this->load->helper('pdf');    
        $emp_id=$data['fsm']['emp_id'];
    
        $data_empresa = $this->cliente->get_empresa_by_id($emp_id);
        
        if (valida_corporacion($emp_id ,'GSI') == 'GSI')
        {	
            $mi_medico=0;
        }
        else
        {
            $mi_medico=351;
        }	
        
          if (($mi_medico  == 0) || ($mi_medico  == ''))
        {$mi_medico=$this->cliente->get_medico_by_examen($cliente_id, $serv_id,'fsm_toxicologico7');}
        if (($mi_medico  == 0) || ($mi_medico  == ''))
        {$mi_medico=$this->cliente->get_medico_by_examen($cliente_id, $serv_id,'fsm_toxicologico5');}
        if (($mi_medico  == 0) || ($mi_medico  == ''))
        {$mi_medico=$this->cliente->get_medico_by_examen($cliente_id, $serv_id,'fsm_psicologico_perfil');}
        if (($mi_medico  == 0) || ($mi_medico  == ''))
        {$mi_medico=$this->cliente->get_medico_by_examen($cliente_id, $serv_id,'fsm_perfil_odon');}
        
        
        //  crear estructura para en un nuevo archivo de gral pdfgral para llamar todos los servicios necesarios 

        if (($mi_medico  == 0) || ($mi_medico  == ''))
        {$mi_medico=$this->cliente->get_medico_by_examen($cliente_id, $serv_id,'fsm_psicologico');}
        if (($mi_medico  == 0) || ($mi_medico  == ''))
        {$mi_medico=$this->cliente->get_medico_by_examen($cliente_id, $serv_id,'fsm_medico_fisico');}
        
        if ($mi_medico  == 0) 
        {$mi_medico=351;} 
    
        //$data['fsm']['med_id']= $mi_medico; //351;
        //$med_name=agrega_cedula_ext($data['fsm']['med_id']);
       // $observaciones='NINGUNA';
		
        genera_pdf_lab_new_y($this->load->view('persona/pdfgrallock',$data,TRUE),'pdfgral','pdfgral',$med_name,$observaciones,$fuera_rango);
       
        //funcion origina para reporte gral
        //genera_pdf_lab_gral($this->load->view('persona/pdfgral',$data,TRUE),'pdfgral','pdfgral');
    }


    public function hoja_consentimiento($cliente_id, $serv_id)
    {
        $data['persona'] = $this->cliente->get($cliente_id,get_desp_id_usr());
        $data['servicio'] = $serv_id;
		$this->load->helper('pdf');
        genera_pdf_jr($this->load->view('persona/pdfconsentimiento_jr',$data,TRUE),'consentimiento','consentimiento',$med_name,$observaciones,$fuera_rango);
    }

    public function hoja_cinformado($cliente_id, $serv_id)
    {
        $data['persona'] = $this->cliente->get($cliente_id,get_desp_id_usr());
        $data['servicio'] = $serv_id;
		$this->load->helper('pdf');
        genera_pdf_jr($this->load->view('persona/pdfcinformado_jr',$data,TRUE),'informado','informado',$med_name,$observaciones,$fuera_rango);
    }


    public function reportegral_serviseg($cliente_id, $serv_id)
    {
        $data['persona'] = $this->cliente->get($cliente_id,get_desp_id_usr());
        $data['servicio'] = $serv_id;
   
        $this->load->helper('pdf');    
        $emp_id=$data['fsm']['emp_id'];
    
        $data_empresa = $this->cliente->get_empresa_by_id($emp_id);
        
        if (valida_corporacion($emp_id ,'GSI') == 'GSI')
        {	
            $mi_medico=0;
        }
        else
        {
            $mi_medico=351;
        }	
        //echo 1;
        if (($mi_medico  == 0) || ($mi_medico  == ''))
        {$mi_medico=$this->cliente->get_medico_by_examen($cliente_id, $serv_id,'fsm_acreditacion');}
       
        if (($mi_medico  == 0) || ($mi_medico  == ''))
        {$mi_medico=$this->cliente->get_medico_by_examen($cliente_id, $serv_id,'fsm_medico_fisico');}
       // echo '*';
        if (($mi_medico  == 0) || ($mi_medico  == ''))
        {$mi_medico=$this->cliente->get_medico_by_examen($cliente_id, $serv_id,'fsm_toxicologico7');}
        
		if (($mi_medico  == 0) || ($mi_medico  == ''))
        {$mi_medico=$this->cliente->get_medico_by_examen($cliente_id, $serv_id,'fsm_toxicologico5');}
        
		if (($mi_medico  == 0) || ($mi_medico  == ''))
        {$mi_medico=$this->cliente->get_medico_by_examen($cliente_id, $serv_id,'fsm_certificado_medico');}
        
		if (($mi_medico  == 0) || ($mi_medico  == ''))
        {$mi_medico=$this->cliente->get_medico_by_examen($cliente_id, $serv_id,'fsm_reconocimiento');}
        
		if (($mi_medico  == 0) || ($mi_medico  == ''))
        {$mi_medico=$this->cliente->get_medico_by_examen($cliente_id, $serv_id,'fsm_psicologico');}
      
        if ($mi_medico  == 0) 
        {$mi_medico=351;} 
	
		$evaluado= $data['persona']['clte_nombre'].' ';		
		if ( strlen($data['persona']['clte_2_nombre']) > 0)
		{
			$evaluado= $evaluado.$data['persona']['clte_2_nombre'].' ';
		}
			$evaluado= $evaluado.$data['persona']['clte_paterno'].' ';			
		$evaluado= $evaluado.$data['persona']['clte_materno'].' ';	
     //echo 3;
       // genera_pdf_lab_new_y($this->load->view('persona/pdfgralempresas',$data,TRUE),'pdfgral','pdfgral',$med_name,$observaciones,$fuera_rango);
        genera_pdf_new_reporte_poli($this->load->view('persona/pdfgralempresas',$data,TRUE),'pdfgral','pdfgral',$evaluado);
      
    }




    public function reportegral_emp($cliente_id, $serv_id)
    {
        $data['persona'] = $this->cliente->get($cliente_id,get_desp_id_usr());
        $data['servicio'] = $serv_id;
   
        $this->load->helper('pdf');    
        $emp_id=$data['fsm']['emp_id'];
    
        $data_empresa = $this->cliente->get_empresa_by_id($emp_id);
        
        if (valida_corporacion($emp_id ,'GSI') == 'GSI')
        {	
            $mi_medico=0;
        }
        else
        {
            $mi_medico=351;
        }	
        //echo 1;
        if (($mi_medico  == 0) || ($mi_medico  == ''))
        {$mi_medico=$this->cliente->get_medico_by_examen($cliente_id, $serv_id,'fsm_acreditacion');}
       
        if (($mi_medico  == 0) || ($mi_medico  == ''))
        {$mi_medico=$this->cliente->get_medico_by_examen($cliente_id, $serv_id,'fsm_medico_fisico');}
       // echo '*';
        if (($mi_medico  == 0) || ($mi_medico  == ''))
        {$mi_medico=$this->cliente->get_medico_by_examen($cliente_id, $serv_id,'fsm_toxicologico7');}
        
		if (($mi_medico  == 0) || ($mi_medico  == ''))
        {$mi_medico=$this->cliente->get_medico_by_examen($cliente_id, $serv_id,'fsm_toxicologico5');}
        
		if (($mi_medico  == 0) || ($mi_medico  == ''))
        {$mi_medico=$this->cliente->get_medico_by_examen($cliente_id, $serv_id,'fsm_certificado_medico');}
        
		if (($mi_medico  == 0) || ($mi_medico  == ''))
        {$mi_medico=$this->cliente->get_medico_by_examen($cliente_id, $serv_id,'fsm_reconocimiento');}
        
		if (($mi_medico  == 0) || ($mi_medico  == ''))
        {$mi_medico=$this->cliente->get_medico_by_examen($cliente_id, $serv_id,'fsm_psicologico');}
      
        if ($mi_medico  == 0) 
        {$mi_medico=351;} 
	
		$evaluado= $data['persona']['clte_nombre'].' ';		
		if ( strlen($data['persona']['clte_2_nombre']) > 0)
		{
			$evaluado= $evaluado.$data['persona']['clte_2_nombre'].' ';
		}
			$evaluado= $evaluado.$data['persona']['clte_paterno'].' ';			
		$evaluado= $evaluado.$data['persona']['clte_materno'].' ';	
     //echo 3;
       // genera_pdf_lab_new_y($this->load->view('persona/pdfgralempresas',$data,TRUE),'pdfgral','pdfgral',$med_name,$observaciones,$fuera_rango);
        genera_pdf_new_reporte_poli($this->load->view('persona/pdfgralempresas2',$data,TRUE),'pdfgral','pdfgral',$evaluado);
      
    }



    public function reportegral($cliente_id, $serv_id)
    {
    /*    $data['persona'] = $this->cliente->get($cliente_id,get_desp_id_usr());
		$data['servicio'] = $serv_id;

		$this->load->helper('pdf');

		$emp_id=$data['fsm']['emp_id'];

		$data_empresa = $this->cliente->get_empresa_by_id($emp_id);
		
		if (valida_corporacion($emp_id ,'GSI') == 'GSI')
		{	
			$mi_medico=0;
		}
		else
		{
			$mi_medico=351;
		}	
		
		if (($mi_medico  == 0) || ($mi_medico  == ''))
		{$mi_medico=$this->cliente->get_medico_by_examen($cliente_id, $serv_id,'fsm_biometria_hematica');}
	
	    if (($mi_medico  == 0) || ($mi_medico  == ''))
		{$mi_medico=$this->cliente->get_medico_by_examen($cliente_id, $serv_id,'fsm_alcohol');}	
		
		if (($mi_medico  == 0) || ($mi_medico  == ''))
		{$mi_medico=$this->cliente->get_medico_by_examen($cliente_id, $serv_id,'fsm_grupo_sanguineo');}
		
		if (($mi_medico  == 0) || ($mi_medico  == ''))
		{$mi_medico=$this->cliente->get_medico_by_examen($cliente_id, $serv_id,'fsm_hba1c');}
		
		if (($mi_medico  == 0) || ($mi_medico  == ''))
		{$mi_medico=$this->cliente->get_medico_by_examen($cliente_id, $serv_id,'fsm_hbsag');}
		
		if (($mi_medico  == 0) || ($mi_medico  == ''))
		{$mi_medico=$this->cliente->get_medico_by_examen($cliente_id, $serv_id,'fsm_hcap');}
		
		if (($mi_medico  == 0) || ($mi_medico  == ''))
		{$mi_medico=$this->cliente->get_medico_by_examen($cliente_id, $serv_id,'fsm_hiv');}
		
		if (($mi_medico  == 0) || ($mi_medico  == ''))
		{$mi_medico=$this->cliente->get_medico_by_examen($cliente_id, $serv_id,'fsm_orina');}
		
		if (($mi_medico  == 0) || ($mi_medico  == ''))
		{$mi_medico=$this->cliente->get_medico_by_examen($cliente_id, $serv_id,'fsm_pie');}
		
		if (($mi_medico  == 0) || ($mi_medico  == ''))
		{$mi_medico=$this->cliente->get_medico_by_examen($cliente_id, $serv_id,'fsm_quimica_sanguinea');}
		
		if (($mi_medico  == 0) || ($mi_medico  == ''))
		{$mi_medico=$this->cliente->get_medico_by_examen($cliente_id, $serv_id,'fsm_quimica_sanguinea12');}
		
		if (($mi_medico  == 0) || ($mi_medico  == ''))
		{$mi_medico=$this->cliente->get_medico_by_examen($cliente_id, $serv_id,'fsm_quimica_sanguinea15');}
		
		if (($mi_medico  == 0) || ($mi_medico  == ''))
		{$mi_medico=$this->cliente->get_medico_by_examen($cliente_id, $serv_id,'fsm_quimica_sanguinea24');}
		
		if (($mi_medico  == 0) || ($mi_medico  == ''))
		{$mi_medico=$this->cliente->get_medico_by_examen($cliente_id, $serv_id,'fsm_quimica_sanguinea27');}
		
		if (($mi_medico  == 0) || ($mi_medico  == ''))
		{$mi_medico=$this->cliente->get_medico_by_examen($cliente_id, $serv_id,'fsm_quimica_sanguinea38');}
		
		if (($mi_medico  == 0) || ($mi_medico  == ''))
		{$mi_medico=$this->cliente->get_medico_by_examen($cliente_id, $serv_id,'fsm_quimica_sanguinea6');}
		
		if (($mi_medico  == 0) || ($mi_medico  == ''))
		{$mi_medico=$this->cliente->get_medico_by_examen($cliente_id, $serv_id,'fsm_quimica_sanguineaall');}
		
		if (($mi_medico  == 0) || ($mi_medico  == ''))
		{$mi_medico=$this->cliente->get_medico_by_examen($cliente_id, $serv_id,'fsm_quimica_sanguineaaxa');}
		
		if (($mi_medico  == 0) || ($mi_medico  == ''))
		{$mi_medico=$this->cliente->get_medico_by_examen($cliente_id, $serv_id,'fsm_quimica_sanguineamch');}
		
		if (($mi_medico  == 0) || ($mi_medico  == ''))
		{$mi_medico=$this->cliente->get_medico_by_examen($cliente_id, $serv_id,'fsm_quimica_sanguineasmty');}
		
		if (($mi_medico  == 0) || ($mi_medico  == ''))
		{$mi_medico=$this->cliente->get_medico_by_examen($cliente_id, $serv_id,'fsm_quimica_sanguinea_bx');}
		
		if (($mi_medico  == 0) || ($mi_medico  == ''))
		{$mi_medico=$this->cliente->get_medico_by_examen($cliente_id, $serv_id,'fsm_prost');}
		
		if (($mi_medico  == 0) || ($mi_medico  == ''))
		{$mi_medico=$this->cliente->get_medico_by_examen($cliente_id, $serv_id,'fsm_toxicologico');}
	
		if (($mi_medico  == 0) || ($mi_medico  == ''))
		{$mi_medico=$this->cliente->get_medico_by_examen($cliente_id, $serv_id,'fsm_toxicologico3');}
		
		if (($mi_medico  == 0) || ($mi_medico  == ''))
		{$mi_medico=$this->cliente->get_medico_by_examen($cliente_id, $serv_id,'fsm_toxicologico7');}
		
		if (($mi_medico  == 0) || ($mi_medico  == ''))
		{$mi_medico=$this->cliente->get_medico_by_examen($cliente_id, $serv_id,'fsm_toxicologico6');}
		
		if (($mi_medico  == 0) || ($mi_medico  == ''))
		{$mi_medico=$this->cliente->get_medico_by_examen($cliente_id, $serv_id,'fsm_toxicologico12');}
			
		if (($mi_medico  == 0) || ($mi_medico  == ''))
		{$mi_medico=$this->cliente->get_medico_by_examen($cliente_id, $serv_id,'fsm_cotinina');}
		
		if ($mi_medico  == 0) 
		{$mi_medico=351;} 

		$data['fsm']['med_id']= $mi_medico; 
		$med_name=agrega_cedula_ext($data['fsm']['med_id']);
		$observaciones='NINGUNA';
		$observaciones='';
		genera_pdf_lab_new_xxx($this->load->view('persona/pdfgral',$data,TRUE),'pdfgral','pdfgral',$med_name,$observaciones,$fuera_rango);
	*/

       $data['persona'] = $this->cliente->get($cliente_id,get_desp_id_usr());
		
		
		
		$data['servicio'] = $serv_id;

		$this->load->helper('pdf');

		$emp_id=$data['fsm']['emp_id'];

		$data_empresa = $this->cliente->get_empresa_by_id($emp_id);
		
	

		if (($mi_medico  == 0) || ($mi_medico  == ''))
		{$mi_medico=$this->cliente->get_medico_by_examen($cliente_id, $serv_id,'fsm_biometria_hematica');}
	
	    if (($mi_medico  == 0) || ($mi_medico  == ''))
		{$mi_medico=$this->cliente->get_medico_by_examen($cliente_id, $serv_id,'fsm_alcohol');}	
		
		if (($mi_medico  == 0) || ($mi_medico  == ''))
		{$mi_medico=$this->cliente->get_medico_by_examen($cliente_id, $serv_id,'fsm_grupo_sanguineo');}
		
		if (($mi_medico  == 0) || ($mi_medico  == ''))
		{$mi_medico=$this->cliente->get_medico_by_examen($cliente_id, $serv_id,'fsm_hba1c');}
		
		if (($mi_medico  == 0) || ($mi_medico  == ''))
		{$mi_medico=$this->cliente->get_medico_by_examen($cliente_id, $serv_id,'fsm_hbsag');}
		
		if (($mi_medico  == 0) || ($mi_medico  == ''))
		{$mi_medico=$this->cliente->get_medico_by_examen($cliente_id, $serv_id,'fsm_hcap');}
		
		if (($mi_medico  == 0) || ($mi_medico  == ''))
		{$mi_medico=$this->cliente->get_medico_by_examen($cliente_id, $serv_id,'fsm_hiv');}
		
		if (($mi_medico  == 0) || ($mi_medico  == ''))
		{$mi_medico=$this->cliente->get_medico_by_examen($cliente_id, $serv_id,'fsm_orina');}
		
		if (($mi_medico  == 0) || ($mi_medico  == ''))
		{$mi_medico=$this->cliente->get_medico_by_examen($cliente_id, $serv_id,'fsm_pie');}
		
		if (($mi_medico  == 0) || ($mi_medico  == ''))
		{$mi_medico=$this->cliente->get_medico_by_examen($cliente_id, $serv_id,'fsm_quimica_sanguinea');}
		
		if (($mi_medico  == 0) || ($mi_medico  == ''))
		{$mi_medico=$this->cliente->get_medico_by_examen($cliente_id, $serv_id,'fsm_quimica_sanguinea12');}
		
		if (($mi_medico  == 0) || ($mi_medico  == ''))
		{$mi_medico=$this->cliente->get_medico_by_examen($cliente_id, $serv_id,'fsm_quimica_sanguinea15');}
		
		if (($mi_medico  == 0) || ($mi_medico  == ''))
		{$mi_medico=$this->cliente->get_medico_by_examen($cliente_id, $serv_id,'fsm_quimica_sanguinea24');}
		
		if (($mi_medico  == 0) || ($mi_medico  == ''))
		{$mi_medico=$this->cliente->get_medico_by_examen($cliente_id, $serv_id,'fsm_quimica_sanguinea27');}
		
		if (($mi_medico  == 0) || ($mi_medico  == ''))
		{$mi_medico=$this->cliente->get_medico_by_examen($cliente_id, $serv_id,'fsm_quimica_sanguinea38');}
		
		if (($mi_medico  == 0) || ($mi_medico  == ''))
		{$mi_medico=$this->cliente->get_medico_by_examen($cliente_id, $serv_id,'fsm_quimica_sanguinea6');}
		
		if (($mi_medico  == 0) || ($mi_medico  == ''))
		{$mi_medico=$this->cliente->get_medico_by_examen($cliente_id, $serv_id,'fsm_quimica_sanguineaall');}
		
		if (($mi_medico  == 0) || ($mi_medico  == ''))
		{$mi_medico=$this->cliente->get_medico_by_examen($cliente_id, $serv_id,'fsm_quimica_sanguineaaxa');}
		
		if (($mi_medico  == 0) || ($mi_medico  == ''))
		{$mi_medico=$this->cliente->get_medico_by_examen($cliente_id, $serv_id,'fsm_quimica_sanguineamch');}
		
		if (($mi_medico  == 0) || ($mi_medico  == ''))
		{$mi_medico=$this->cliente->get_medico_by_examen($cliente_id, $serv_id,'fsm_quimica_sanguineasmty');}
	
		if (($mi_medico  == 0) || ($mi_medico  == ''))
		{$mi_medico=$this->cliente->get_medico_by_examen($cliente_id, $serv_id,'fsm_quimica_sanguineaprevem');}
		
		if (($mi_medico  == 0) || ($mi_medico  == ''))
		{$mi_medico=$this->cliente->get_medico_by_examen($cliente_id, $serv_id,'fsm_quimica_sanguinea_bx');}
		
		if (($mi_medico  == 0) || ($mi_medico  == ''))
		{$mi_medico=$this->cliente->get_medico_by_examen($cliente_id, $serv_id,'fsm_prost');}
		
		if (($mi_medico  == 0) || ($mi_medico  == ''))
		{$mi_medico=$this->cliente->get_medico_by_examen($cliente_id, $serv_id,'fsm_toxicologico');}
	
		if (($mi_medico  == 0) || ($mi_medico  == ''))
		{$mi_medico=$this->cliente->get_medico_by_examen($cliente_id, $serv_id,'fsm_toxicologico3');}
		
		if (($mi_medico  == 0) || ($mi_medico  == ''))
		{$mi_medico=$this->cliente->get_medico_by_examen($cliente_id, $serv_id,'fsm_toxicologico7');}
		
		if (($mi_medico  == 0) || ($mi_medico  == ''))
		{$mi_medico=$this->cliente->get_medico_by_examen($cliente_id, $serv_id,'fsm_toxicologico6');}
		
		if (($mi_medico  == 0) || ($mi_medico  == ''))
		{$mi_medico=$this->cliente->get_medico_by_examen($cliente_id, $serv_id,'fsm_toxicologico12');}
			
		if (($mi_medico  == 0) || ($mi_medico  == ''))
		{$mi_medico=$this->cliente->get_medico_by_examen($cliente_id, $serv_id,'fsm_cotinina');}
		
		if ($mi_medico  == 0) 
		{$mi_medico=351;} 
		
		
			
		
		if (valida_corporacion($emp_id ,'GSI') == 'GSI')
		{	
			$mi_medico=351;
		}
		elseif (($data['persona']['clte_gral_med']=='') || ($data['persona']['clte_gral_med']==0))
		{
			$mi_medico=351;
		} 
		else
		{
			$mi_medico=$data['persona']['clte_gral_med'];
		}
		
		
		
		
		$data['fsm']['med_id']= $mi_medico; 
		$med_name=agrega_cedula_ext($data['fsm']['med_id']);
	//	$observaciones='NINGUNA';
		$observaciones='';
		genera_pdf_lab_new_x($this->load->view('persona/pdfgral',$data,TRUE),'pdfgral','pdfgral',$med_name,$observaciones,$fuera_rango);
   }


    public function edita_empleado_gsi($cliente_id)
    {   
        $user = $this->session->user;
		$user_root1=get_my_user_root1();
		$user_root3=get_my_user_root3();
		$user_root4=get_my_user_root4();
		$cliente = $this->cliente->get($cliente_id);
		$medico = $this->medico->get($user['usr_id']);

		if ($cliente['serv_id'] > 0)
		{	
			$servicio = $this->servicio->get($cliente['serv_id']);
		}

        if($cliente)
        {

            if(isset($_POST) && count($_POST) > 0)     
            {
                $this->load->library('form_validation');
                $this->form_validation->set_rules('nombre','Nombre','required');
                $this->form_validation->set_rules('paterno','Apellido Paterno','required');
                $this->form_validation->set_rules('materno','Apellido Materno','required');
                /*$this->form_validation->set_rules('fnac','Fecha de nacimiento','required');*/
                $this->form_validation->set_rules('genero','Género','required');
                //$this->form_validation->set_rules('civil','Estado civil','required');
                //$this->form_validation->set_rules('rfc','RFC','required');
                //$this->form_validation->set_rules('curp','CURP','required');

                if($this->form_validation->run())
                {
                    //informncion general de la pérsona
                    $data_clte['clte_nombre_crypt'] =  trim($this->input->post('nombre'));
                    $data_clte['clte_2_nombre_crypt'] =  trim($this->input->post('nombre_adic'));
                    $data_clte['clte_paterno_crypt'] =  trim($this->input->post('paterno'));
                    $data_clte['clte_materno_crypt'] =  trim($this->input->post('materno'));
                    
					//$data_clte['clte_f_nac'] = formatea_fecha_mysql($this->input->post('fnac'));
                    $data_clte['clte_f_nac'] = $this->input->post('fnac');
					
					$data_clte['clte_genero_cve'] =  $this->input->post('genero');
                    $data_clte['clte_rfc_crypt'] =  $this->input->post('rfc');
                    $data_clte['clte_curp_crypt'] =  $this->input->post('curp');					
					
                    //dopmcicio de la persona
                    $data_clte['clte_env_pais_cve'] =  $this->input->post('pais');
                    $data_clte['clte_env_cp'] =  $this->input->post('cp');
                    $data_clte['clte_env_edo_cve'] =  $this->input->post('entidad');
                    $data_clte['clte_env_colonia_crypt'] =  $this->input->post('colonia');
                    $data_clte['clte_env_localidad'] =  $this->input->post('localidad');
                    $data_clte['clte_env_municipio'] =  $this->input->post('municipio');
                    $data_clte['clte_env_calle_crypt'] =  $this->input->post('calle');
                    $data_clte['clte_env_num_ext_crypt'] =  $this->input->post('next');
                    $data_clte['clte_env_num_int_crypt'] =  $this->input->post('nint');
					$data_clte['clte_nss_crypt'] =  $this->input->post('nss');
                    //informacion de conrtaxcto de la persona
                    $data_clte['clte_tel_casa_crypt'] = limpia_telefono($this->input->post('tel'));                
                    $data_clte['clte_cel_crypt'] =  limpia_telefono($this->input->post('cel'));
                    $data_clte['clte_email_crypt'] =  $this->input->post('correo');

                    //nuevos campos
                    $data_clte['clte_grado_acad_cve'] =  $this->input->post('grado');
                    $data_clte['clte_puesto'] =  $this->input->post('puesto');
                    $data_clte['clte_edo_civ_cve'] =  $this->input->post('civil');
                    $data_clte['clte_nac_cve'] =  $this->input->post('nac');

					//empresa donde va a labora la persona
					$data_clte['emp_id'] =  $this->input->post('empresa');
					$data_clte['suc_id'] =  $this->input->post('sucursal');
					
					$data_clte['area_depto'] =  $this->input->post('area_depto');
					$data_clte['num_empleado'] =  $this->input->post('num_empleado');
					
					$data_clte['cei_id'] =  4;
					$data_clte['empleado'] =  1;
					$data_clte['empleado_rol'] =  1;
				
					//examenes
					$data_clte['nomserv'] =  'EXMEPER;'; 
					 

					/****
					$cat_examen = get_cat_nombre_var('EXAMEN');
					$i=0;
					$cat_categorias = get_cat_nombre_var('CATEGORIA_EX');
					foreach($cat_categorias as $categoria): 
						//echo $categoria['cat_nombre'].' ';
						$linea_examenes=get_examen_de_empresa_por_categoria($cliente['emp_id'], $categoria['cat_nombre']);
						
						if (strlen($linea_examenes) > 0)
						{
							foreach (explode(';', $linea_examenes) as $det):
								if (strlen($det) > 0)
								{

										//<?php echo $categoria['cat_nombre'];

										//<?php echo get_nombre_de_examen($det, 'EXAMEN');
										
										$exa=$this->input->post($categoria['cat_nombre'].'_'.$i);
										$nomserv.=$exa;
										$i++;
								}
								
							endforeach;										
						}
					endforeach;
					$data_clte['nomserv'] =  $nomserv;
					**********/

					//orden de servicio
					
					if ($this->input->post('serv_id') > 0)
					{	
							if ($cliente['serv_id'] !=  $this->input->post('serv_id') )
							{
								$data_clte['serv_id'] =$this->input->post('serv_id');	
								$el_servicio=$this->input->post('serv_id');
								$pos = strpos($cliente['ordenes_series'] , $el_servicio);
								if ($pos !==0)
								{	
									$data_clte['ordenes_series'] = $cliente['ordenes_series'].$this->input->post('serv_id').';';
								}
								if (!(strstr( $el_servicio,$data_clte['domserv'] )))
								{	
									$data_clte['domserv'] = '|'.$this->input->post('serv_id').',';
								}								
							}
					}
					else
					{
						$data_clte['serv_id'] = $this->input->post('serv_id'); 
					}	

                    if(!empty($_FILES['foto']['name']))
                    {
                        $this->load->library('upload');
						sleep(1);
                        $filename = md5(time());
                        $config = array(
                                'upload_path'   => './../../files/fotos/',
                                'overwrite'     => TRUE,
                                'file_name'     => $filename,
                                'allowed_types' => 'png|jpg|jpeg',
                                'max_size'      => '25000'
                        );

                        $this->upload->initialize($config);
                        if ( ! $this->upload->do_upload('foto'))
                        {
                            send_json_error($this->upload->display_errors());
                        }
                        else 
                        {
                            $data = $this->upload->data();
                            $data_clte['clte_path_foto'] = $data['file_name'];
                        }
                    }

					if (($data_clte['clte_f_nac'] =='') && ($data_clte['emp_id'] !=152))
					{
						send_json_error('Ocurrió un error, no se registro la FECHA DE NACIMIENTO.');
					}
                    else
					{
						
						if ($this->input->post('rregistrar') == 'rr')
						{						
							if($this->cliente->actualiza_registro($cliente_id, array_to_upper($data_clte)))
							{
								send_json_ok(array('msg' =>'Se actualizó y registro nuevamente al empleado de forma correcta', 'id' => $cliente_id));
							}
							else
							{
								send_json_error('Ocurrió un error al actualizar al empleado.');
							}
						}
						else
						{	
						
							if($this->cliente->actualiza($cliente_id, array_to_upper($data_clte)))
							{
								send_json_ok(array('msg' =>'Se actualizó de forma correcta', 'id' => $cliente_id));
							}
							else
							{
								send_json_error('Ocurrió un error al actualizar la empleado.');
							}
						}
					}
                }
                else
                {
                    send_json_error(validation_errors('<div />'));
                }
            }
            else 
            {

                $this->load->model('empresa/Empresa_model','empresa');				
				$gss=get_empresas_corporativo('GSI');				
				$data['empresas'] =  $this->empresa->get_all_empresas_gss($gss);
				$gss=''; $gss[0]=$cliente['emp_id'];
				$data['sucursales'] = $this->empresa->get_all_sucursales_empresas($gss);
				$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($cliente['emp_id']);
                $data['persona'] = 	$cliente;
				if ($cliente['serv_id'] > 0)
				{
					$data['servicio'] = $servicio;
				}
                $this->load->helper('template');
                $params_view = array(
                    'title' => 'Personas',
                    'view' => 'persona/edit_empleado_gsi',
                    'view_data' => $data
                   );
                render_template($params_view);  
            }
        }
        else 
        {
            show_error('No existe el cliente');
        }
    }



   public function edita_wrk($cliente_id)
    {   //date_default_timezone_set('America/Mexico_City');
        $user = $this->session->user;
		$user_root1=get_my_user_root1();
		$user_root3=get_my_user_root3();
		$user_root4=get_my_user_root4();
		$cliente = $this->cliente->get($cliente_id);
		$medico = $this->medico->get($user['usr_id']);

		if ($cliente['serv_id'] > 0)
		{	
			$servicio = $this->servicio->get($cliente['serv_id']);
		}

        if($cliente)
        {

            if(isset($_POST) && count($_POST) > 0)     
            {
                $this->load->library('form_validation');
                //$this->form_validation->set_rules('nombre','Nombre','required');
                //$this->form_validation->set_rules('paterno','Apellido Paterno','required');
                //$this->form_validation->set_rules('materno','Apellido Materno','required');
                /*$this->form_validation->set_rules('fnac','Fecha de nacimiento','required');*/
                //$this->form_validation->set_rules('genero','Género','required');
                //$this->form_validation->set_rules('civil','Estado civil','required');
                //$this->form_validation->set_rules('rfc','RFC','required');
                //$this->form_validation->set_rules('curp','CURP','required');

                //if($this->form_validation->run())
                if(1)
				{
                    
                    //$data_clte['clte_nombre_crypt'] =  trim($this->input->post('nombre'));
                    //$data_clte['clte_2_nombre_crypt'] =  trim($this->input->post('nombre_adic'));
                    //$data_clte['clte_paterno_crypt'] =  trim($this->input->post('paterno'));
                    //$data_clte['clte_materno_crypt'] =  trim($this->input->post('materno'));
					//$data_clte['clte_f_nac'] = formatea_fecha_mysql($this->input->post('fnac'));
                    // $data_clte['clte_f_nac'] = $this->input->post('fnac');					
					/*
					$data_clte['clte_genero_cve'] =  $this->input->post('genero');
                    $data_clte['clte_rfc_crypt'] =  $this->input->post('rfc');
                    $data_clte['clte_curp_crypt'] =  $this->input->post('curp');					
                    $data_clte['clte_env_pais_cve'] =  $this->input->post('pais');
                    $data_clte['clte_env_cp'] =  $this->input->post('cp');
                    $data_clte['clte_env_edo_cve'] =  $this->input->post('entidad');
                    $data_clte['clte_env_colonia_crypt'] =  $this->input->post('colonia');
                    $data_clte['clte_env_localidad'] =  $this->input->post('localidad');
                    $data_clte['clte_env_municipio'] =  $this->input->post('municipio');
                    $data_clte['clte_env_calle_crypt'] =  $this->input->post('calle');
                    $data_clte['clte_env_num_ext_crypt'] =  $this->input->post('next');
                    $data_clte['clte_env_num_int_crypt'] =  $this->input->post('nint');
					$data_clte['clte_nss_crypt'] =  $this->input->post('nss');                   
                    $data_clte['clte_tel_casa_crypt'] = limpia_telefono($this->input->post('tel'));                
                    $data_clte['clte_cel_crypt'] =  limpia_telefono($this->input->post('cel'));
                    $data_clte['clte_email_crypt'] =  $this->input->post('correo');
                    $data_clte['clte_grado_acad_cve'] =  $this->input->post('grado');
                    $data_clte['clte_puesto'] =  $this->input->post('puesto');
                    $data_clte['clte_edo_civ_cve'] =  $this->input->post('civil');
                    $data_clte['clte_nac_cve'] =  $this->input->post('nac');
                    $data_clte['emp_id'] =  $this->input->post('empresa');
                    $data_clte['clte_nife'] =  $this->input->post('nife');
					$data_clte['clte_centro_costo'] =  $this->input->post('centro_costo');
                    $data_clte['clte_lab_ubicacion'] =  $this->input->post('ubicacion');
					$data_clte['desp_id'] =  $this->input->post('despacho');
					$data_clte['clte_reclutador'] =  $this->input->post('reclutador');	
					$data_clte['clte_region'] =  $this->input->post('region');
					$data_clte['clte_zona'] =  $this->input->post('zonass');
					$data_clte['clte_webflow'] =  $this->input->post('webflow');	
					*/
					$nomserv='';
					if ($this->input->post('nom35i') == 'OK')
					{$nomserv=$nomserv.'nom0351;';}	
					if ($this->input->post('nom35ii') == 'OK')
					{$nomserv=$nomserv.'nom0352;';}
					if ($this->input->post('nom35iii') == 'OK')
					{$nomserv=$nomserv.'nom0353;';}	
					if ($this->input->post('honestidad') == 'OK')
					{$nomserv=$nomserv.'HONE;';}
					if ($this->input->post('comportamiento') == 'OK')
					{$nomserv=$nomserv.'COMPO;';}
					if ($this->input->post('certificado') == 'OK')
					{$nomserv=$nomserv.'CERTI;';}
			
					$cat_examen = get_cat_nombre_var('EXAMEN');
					$i=0;
					$cat_categorias = get_cat_nombre_var('CATEGORIA_EX');
					foreach($cat_categorias as $categoria): 
						//echo $categoria['cat_nombre'].' ';
						$linea_examenes=get_examen_de_empresa_por_categoria($cliente['emp_id'], $categoria['cat_nombre']);
						
						if (strlen($linea_examenes) > 0)
						{
							foreach (explode(';', $linea_examenes) as $det):
								if (strlen($det) > 0)
								{
									if ($categoria['cat_nombre'] != 'ESPECIAL')
									{
										//<?php echo $categoria['cat_nombre'];
										//<?php echo get_nombre_de_examen($det, 'EXAMEN');
										$exa=$this->input->post($categoria['cat_nombre'].'_'.$i);
										$nomserv.=$exa;
										$i++;
										//<input type="checkbox" id="<?php echo $categoria['cat_nombre'].'_'.$i; " name="<?php echo $categoria['cat_nombre'].'_'.$i; " value="<?php echo $det.';'; $i++; " <?php if (strstr($persona['nomserv'], $det.';')) { echo 'checked';} 
									}
								}
								
							endforeach;										
						}
					endforeach;

					$data_clte['nomserv'] =  $nomserv;

					/*
                      $data_clte['desp_id'] =  $this->input->post('despacho');
					  if ($data_clte['desp_id'] == 1) {$data_clte['desp_id']=0;}
					  $data_clte['clte_reclutador'] =  $this->input->post('reclutador');
					*/  
					
					//orden de servicio
					
					if ($this->input->post('serv_id') > 0)
					{	
							if ($cliente['serv_id'] !=  $this->input->post('serv_id') )
							{
								$data_clte['serv_id'] =$this->input->post('serv_id');	
								$el_servicio=$this->input->post('serv_id');
								$pos = strpos($cliente['ordenes_series'] , $el_servicio);
								if ($pos !==0)
								{	
									$data_clte['ordenes_series'] = $cliente['ordenes_series'].$this->input->post('serv_id').';';
								}
								if (!(strstr( $el_servicio,$data_clte['domserv'] )))
								{	
									$data_clte['domserv'] = '|'.$this->input->post('serv_id').',';
								}								
							}
					}
					else
					{
						$data_clte['serv_id'] = $this->input->post('serv_id'); 
					}	
					
					/*$data_clte['suc_id'] =  $this->input->post('sucursal');*/
					
					/*$data_clte['cei_id'] =  $this->input->post('cei');
					if (($user_root3 == 2) && ($user_root4 == 3))
					{
						$data_clte['cei_id'] = 4;
					}
					*/

                    if(!empty($_FILES['foto']['name']))
                    {
                        $this->load->library('upload');
						sleep(1);
                        $filename = md5(time());
                        $config = array(
                                'upload_path'   => './../../files/fotos/',
                                'overwrite'     => TRUE,
                                'file_name'     => $filename,
                                'allowed_types' => 'png|jpg|jpeg',
                                'max_size'      => '25000'
                        );

                        $this->upload->initialize($config);
                        if ( ! $this->upload->do_upload('foto'))
                        {
                            send_json_error($this->upload->display_errors());
                        }
                        else 
                        {
                            $data = $this->upload->data();
                            $data_clte['clte_path_foto'] = $data['file_name'];
                        }
                    }

					if($this->cliente->actualiza($cliente_id, array_to_upper($data_clte)))
					{
						send_json_ok(array('msg' =>'Se actualizó de forma correcta', 'id' => $cliente_id));
					}
					else
					{
						send_json_error('Ocurrió un error al actualizar la persona.');
					}
		
                }
                else
                {
                    send_json_error(validation_errors('<div />'));
                }
            }
            else 
            {

				$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($cliente['emp_id']);
                $data['persona'] = 	$cliente;

				if ($cliente['serv_id'] > 0)
				{
					$data['servicio'] = $servicio;
				}
                $this->load->helper('template');
                $params_view = array(
                    'title' => 'Personas',
                    'view' => 'persona/edit_wrk',
                    'view_data' => $data
                   );
                render_template($params_view);  
            }
        }
        else 
        {
            show_error('No existe el cliente');
        }
    }

 
    public function edita($cliente_id)
    {   //date_default_timezone_set('America/Mexico_City');
        $user = $this->session->user;
		$user_root1=get_my_user_root1();
		$user_root3=get_my_user_root3();
		$user_root4=get_my_user_root4();
		$cliente = $this->cliente->get($cliente_id);
		$medico = $this->medico->get($user['usr_id']);
		$emp_id=$cliente['emp_id'];

		if ($cliente['serv_id'] > 0)
		{	
			$servicio = $this->servicio->get($cliente['serv_id']);
		}

        if($cliente)
        {

            if(isset($_POST) && count($_POST) > 0)     
            {
                $this->load->library('form_validation');
                $this->form_validation->set_rules('nombre','Nombre','required');
                $this->form_validation->set_rules('paterno','Apellido Paterno','required');
                $this->form_validation->set_rules('materno','Apellido Materno','required');
                /*$this->form_validation->set_rules('fnac','Fecha de nacimiento','required');*/
                $this->form_validation->set_rules('genero','Género','required');
                //$this->form_validation->set_rules('civil','Estado civil','required');
                //$this->form_validation->set_rules('rfc','RFC','required');
                //$this->form_validation->set_rules('curp','CURP','required');
				if ((get_emp_osa($emp_id) == 3) && ($servicio['serv_estatus_cve']=='PREORDEN') && ($emp_id==152))
				{
					$this->form_validation->set_rules('webflow','WebFlow','required');
					$this->form_validation->set_rules('zonass','ZONA','required');
					$this->form_validation->set_rules('region','Región','required');
				}

                if($this->form_validation->run())
                {
                    //informncion general de la pérsona
                    $data_clte['clte_nombre_crypt'] =  trim($this->input->post('nombre'));
                    $data_clte['clte_2_nombre_crypt'] =  trim($this->input->post('nombre_adic'));
                    $data_clte['clte_paterno_crypt'] =  trim($this->input->post('paterno'));
                    $data_clte['clte_materno_crypt'] =  trim($this->input->post('materno'));
                    
					$data_clte['clte_f_nac'] = formatea_fecha_mysql($this->input->post('fnac'));
                   // $data_clte['clte_f_nac'] = $this->input->post('fnac');
					
					$data_clte['clte_genero_cve'] =  $this->input->post('genero');
                    $data_clte['clte_rfc_crypt'] =  $this->input->post('rfc');
                    $data_clte['clte_curp_crypt'] =  $this->input->post('curp');					

                    //dopmcicio de la persona
                    $data_clte['clte_env_pais_cve'] =  $this->input->post('pais');
                    $data_clte['clte_env_cp'] =  $this->input->post('cp');
                    $data_clte['clte_env_edo_cve'] =  $this->input->post('entidad');
                    $data_clte['clte_env_colonia_crypt'] =  $this->input->post('colonia');
                    $data_clte['clte_env_localidad'] =  $this->input->post('localidad');
                    $data_clte['clte_env_municipio'] =  $this->input->post('municipio');
                    $data_clte['clte_env_calle_crypt'] =  $this->input->post('calle');
                    $data_clte['clte_env_num_ext_crypt'] =  $this->input->post('next');
                    $data_clte['clte_env_num_int_crypt'] =  $this->input->post('nint');
					$data_clte['clte_nss_crypt'] =  $this->input->post('nss');
                    //informacion de conrtaxcto de la persona
                    $data_clte['clte_tel_casa_crypt'] = limpia_telefono($this->input->post('tel'));                
                    $data_clte['clte_cel_crypt'] =  limpia_telefono($this->input->post('cel'));
                    $data_clte['clte_email_crypt'] =  $this->input->post('correo');

                    //nuevos campos
                    $data_clte['clte_grado_acad_cve'] =  $this->input->post('grado');
                    $data_clte['clte_puesto'] =  $this->input->post('puesto');
					$data_clte['clte_cat_puesto'] =  $this->input->post('cat_puesto');
                    $data_clte['clte_edo_civ_cve'] =  $this->input->post('civil');
                    $data_clte['clte_nac_cve'] =  $this->input->post('nac');





                    //empresa donde va a loborar la persona
                    $data_clte['emp_id'] =  $this->input->post('empresa');
                    $data_clte['clte_nife'] =  $this->input->post('nife');
					$data_clte['clte_centro_costo'] =  $this->input->post('centro_costo');
					
					
                    //nuevo campo de unicacion
                    $data_clte['clte_lab_ubicacion'] =  $this->input->post('ubicacion');
                     
					//despachos 
					$data_clte['desp_id'] =  $this->input->post('despacho');
					$data_clte['clte_reclutador'] =  $this->input->post('reclutador');	
					
					//para seguros monterrey
					$data_clte['clte_region'] =  $this->input->post('region');
					$data_clte['clte_zona'] =  $this->input->post('zonass');
					$data_clte['clte_webflow'] =  $this->input->post('webflow');	
		
					$nomserv='';
					if ($this->input->post('nom35i') == 'OK')
					{$nomserv=$nomserv.'nom0351;';}	
					if ($this->input->post('nom35ii') == 'OK')
					{$nomserv=$nomserv.'nom0352;';}
					if ($this->input->post('nom35iii') == 'OK')
					{$nomserv=$nomserv.'nom0353;';}	
					if ($this->input->post('honestidad') == 'OK')
					{$nomserv=$nomserv.'HONE;';}
					if ($this->input->post('comportamiento') == 'OK')
					{$nomserv=$nomserv.'COMPO;';}
					if ($this->input->post('certificado') == 'OK')
					{$nomserv=$nomserv.'CERTI;';}

					if ((get_emp_osa($emp_id) == 3) && ($servicio['serv_estatus_cve']=='PREORDEN'))
					{

						$total_examenes_selectos=$this->input->post('total_examenes_selectos');
						$paquetes='';
						$detecta_pkts=0;
						for($i=1; $i <= $total_examenes_selectos; $i++)
						{
							$indice='examen_select_pkt_'.strval($i);
							if ($this->input->post($indice) != NULL)
							{	
							$paquetes.=$this->input->post($indice).';';
							$detecta_pkts++;
							}
							
						}						

							//costos para el servicio creado edita b
							$total_examenes_selectos= $this->input->post('total_examenes_selectos');	
							$fsm_pakts= get_costos_paquetes_empresa($emp_id);
							$this->servicio->delete_examenes($cliente['serv_id']);
							if($fsm_pakts):
								foreach($fsm_pakts as $fsm_pakt): 
											
										for($i=1; $i <= $total_examenes_selectos; $i++)
										{									
											$indice='examen_select_pkt_'.strval($i);
											$paquetes= $this->input->post($indice);	
													
											if ( $fsm_pakt['cost_nombre_pkt'] === $paquetes)
											{
												$examen_ins['exam_nombre_pkt'] = $fsm_pakt['cost_nombre_pkt']; //nombre del paquete
												$examen_ins['serv_id'] = $cliente['serv_id'];
												$examen_ins['exam_cve'] = $fsm_pakt['cost_examen_cve']; //lo que contiene el paquete
												$examen_ins['exam_monto'] = $fsm_pakt['cost_monto']; //lo que se cobra del paquete								 	 
												$examen_ins['exam_cantidad'] = 1;
												$examen_ins['exam_estatus_cve'] = 'PEND';
												$examen_ins['exam_tipo_pkt'] = $fsm_pakt['cost_tipo_pkt'];
												$this->servicio->inserta_examen($examen_ins);
												$nomserv.=$examen_ins['exam_cve'];
											}							
										}	
								endforeach;
							endif;
						//mandar la actualización del estatus a la orden de servicio
						$examen_servicio['serv_estatus_cve']="PROCESO";
						$this->servicio->update($cliente['serv_id'],$examen_servicio);
						
					}
					elseif ((get_emp_osa($emp_id) == 3) && ($servicio['serv_estatus_cve']!='PREORDEN'))
					{

							
							$fsm_pakts= get_costos_paquetes_empresa($emp_id);


							if($fsm_pakts):
								$i=1;
								foreach($fsm_pakts as $fsm_pakt):	
									foreach (explode(';', $fsm_pakt['cost_examen_cve']) as $detalle)
									{
										if ( strlen($detalle) > 0)
										{	
											if (get_paquete_desde_servicio($cliente['serv_id'],$fsm_pakt['cost_nombre_pkt'])) 
											{
												$nomserv.=$detalle.';';
											}
										}
									}								
									
								endforeach;													
							endif;
					}
					else
					{
					$cat_examen = get_cat_nombre_var('EXAMEN');
					$i=0;
					$cat_categorias = get_cat_nombre_var('CATEGORIA_EX');
					foreach($cat_categorias as $categoria): 
						//echo $categoria['cat_nombre'].' ';
						$linea_examenes=get_examen_de_empresa_por_categoria($cliente['emp_id'], $categoria['cat_nombre']);
						
						if (strlen($linea_examenes) > 0)
						{
							foreach (explode(';', $linea_examenes) as $det):
								if (strlen($det) > 0)
								{
									//echo $categoria['cat_nombre'];
									//<?php echo get_nombre_de_examen($det, 'EXAMEN');										
									$exa=$this->input->post($categoria['cat_nombre'].'_'.$i);
									$nomserv.=$exa;
									$i++;
									//<input type="checkbox" id="<?php echo $categoria['cat_nombre'].'_'.$i; " name="<?php echo $categoria['cat_nombre'].'_'.$i; " value="<?php echo $det.';'; $i++; " <?php if (strstr($persona['nomserv'], $det.';')) { echo 'checked';} 
								}
								
							endforeach;										
						}
					endforeach;
					}
					
					
/***************************************************************************************/

					$data_clte['nomserv'] =  $nomserv;
					
					if ($data_clte['emp_id'] == 193)
					{
						$data_clte['nomserv'].='ALLIANZ;';
					}
				/*	
					if ($data_clte['emp_id'] == 152)
					{
						$data_clte['nomserv']='SGMTY;';
					}elseif ($data_clte['emp_id'] == 194)
					{
						$data_clte['nomserv']='PREVEM;';
					}else
					elseif ($data_clte['emp_id'] == 182)
					{
						$data_clte['nomserv'].='FILOA;';
					}	
					elseif ($data_clte['emp_id'] == 210)
					{
						$data_clte['nomserv'].='INSIGNIA;';
					}	
					elseif ($data_clte['emp_id'] == 230)
					{
						$data_clte['nomserv'].='AXA;';
					}
				*/	
					
                    //despacho
                      $data_clte['desp_id'] =  $this->input->post('despacho');
					  if ($data_clte['desp_id'] == 1) {$data_clte['desp_id']=0;}
					  $data_clte['clte_reclutador'] =  $this->input->post('reclutador');
					
					//orden de servicio					
					if ($this->input->post('serv_id') > 0)
					{	
							if ($cliente['serv_id'] !=  $this->input->post('serv_id') )
							{
								$data_clte['serv_id'] =$this->input->post('serv_id');	
								$el_servicio=$this->input->post('serv_id');
								$pos = strpos($cliente['ordenes_series'] , $el_servicio);
								if ($pos !==0)
								{	
									$data_clte['ordenes_series'] = $cliente['ordenes_series'].$this->input->post('serv_id').';';
								}
								if (!(strstr( $el_servicio,$data_clte['domserv'] )))
								{	
									$data_clte['domserv'] = '|'.$this->input->post('serv_id').',';
								}								
							}
					}
					else
					{
						$data_clte['serv_id'] = $this->input->post('serv_id'); 
					}	
					
				
					//sucursal
					$data_clte['suc_id'] =  $this->input->post('sucursal');
					
					if ($this->input->post('cei') != 0)  
					{	
						$data_clte['cei_id'] =  $this->input->post('cei');
					}
					
					if (($user_root3 == 2) && ($user_root4 == 3))
					{
						$data_clte['cei_id'] = 4;
					}
					
                    if(!empty($_FILES['foto']['name']))
                    {
                        $this->load->library('upload');
						sleep(1);
                        $filename = md5(time());
                        $config = array(
                                'upload_path'   => './../../files/fotos/',
                                'overwrite'     => TRUE,
                                'file_name'     => $filename,
                                'allowed_types' => 'png|jpg|jpeg',
                                'max_size'      => '25000'
                        );

                        $this->upload->initialize($config);
                        if ( ! $this->upload->do_upload('foto'))
                        {
                            send_json_error($this->upload->display_errors());
                        }
                        else 
                        {
                            $data = $this->upload->data();
                            $data_clte['clte_path_foto'] = $data['file_name'];
                        }
                    }

					if (($data_clte['clte_f_nac'] =='') && ($data_clte['emp_id'] !=152))
					{
						send_json_error('Ocurrió un error, no se registro la FECHA DE NACIMIENTO.');
					}
                    else
					{
						if ($this->input->post('rcontrol') == 'rcontrol')
						{	

							//generar oden de servicio como cuando se registra por primera vez el evaaluado
							if (get_emp_osa($emp_id) == 3)
							{
								$ff= $emp_id.'_'.strtoupper(trim($this->input->post('nombre')).'_'.trim($this->input->post('paterno')).'_'.trim($this->input->post('materno'))).'_'.date('YmdHis');
								$data_serv['serv_orden'] = $ff;
								$data_serv['emp_id'] =  $emp_id;
								$data_serv['usr_id'] = $user['usr_id'];
								$data_serv['serv_f_inicio'] = date('Y-m-d H:i:s');						
								$data_serv['serv_f_fin'] = date("Y-m-d H:i:s",strtotime($data_serv['serv_f_inicio']."+ 20 days"));;
								$data_serv['serv_desc'] = "ORDEN DE SERVICIO GENERADA DESDE EL REGISTRO DEL USUARIO";
								$data_serv['serv_estatus_cve'] = 'PREORDEN';
								$data_serv['cei_control_id'] = $medico['cei_id'];
								$data_serv['serv_ubicacion'] = $medico['cei_id'];
								$data_serv['cei_id'] = $medico['cei_id']; 
								$serv_id = $this->servicio->inserta(array_to_upper($data_serv));
								$data_clte_id['serv_id']=$serv_id;														
								$data_clte_id['nomserv']='';
								if ($this->cliente->actualiza_registro($cliente_id, array_to_upper($data_clte_id)))
								{
									send_json_ok(array('msg' =>'Se genero una nueva orden de control para el evaluado', 'id' => $cliente_id));
								}
								else
								{
									send_json_error('¡Ocurrió un error al actualizar a la persona!');
								}
							
							}
						}
						elseif ($this->input->post('rregistrar') == 'rr')
						{						
							if($this->cliente->actualiza_registro($cliente_id, array_to_upper($data_clte)))
							{
								send_json_ok(array('msg' =>'Se actualizó y registro nuevamente el evaluado de forma correcta', 'id' => $cliente_id));
							}
							else
							{
								send_json_error('Ocurrió un error al actualizar a la persona..');
							}
						}
						else
						{	
						
							if($this->cliente->actualiza($cliente_id, array_to_upper($data_clte)))
							{
								send_json_ok(array('msg' =>'Se actualizó de forma correcta', 'id' => $cliente_id));
							}
							else
							{
								send_json_error('Ocurrió un error al actualizar a la persona...');
							}
						}
					}
                }
                else
                {
                    send_json_error(validation_errors('<div />'));
                }
            }
            else 
            {
				//echo "----------->".$cliente['suc_id']."<-----------";
                $this->load->model('empresa/Empresa_model','empresa');
				
				if ( (strstr($medico['portal'],'CORPO')) && (strstr($medico['modulos'],'EVALOBJ')) )
				{
					$i=0;
					foreach ( explode(';',$medico['empresas'] )  as $esta_empresa) 
					{
						if ($esta_empresa > 0)
						{	
							$gss[$i]=$esta_empresa;
							$i++;
						}
					}	
					$data['empresas'] =  $this->empresa->get_all_empresas_gss($gss);
				}
				elseif (($user_root3 == 2) && ($user_root4 == 3))
				{
					$data['empresas'] = $this->empresa->get_all_empresas_gsi_id();;			
				}
				else
				if ($user_root4 == 5)
				{
				$data['empresas'] = $this->empresa->trae_emp_asig($medico['usr_emp_asig']);			
				}
				else
				{
					$data['empresas'] = $this->empresa->trae_empresas();//$this->empresa->get_all_empresas();
				}
				
				//$data['despachos'] = $this->empresa->get_all_despachos();
				$data['sucursals'] = $this->empresa->get_all_sucursales($cliente['emp_id']);
				$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($cliente['emp_id']);
                $data['persona'] = 	$cliente;
				$data['regiones'] = $this->servicio->get_regiones_sgmty();
				$data['regiones_2'] = $this->servicio->get_cei_regiones_sgmty('2');
				$data['regiones_6'] = $this->servicio->get_cei_regiones_sgmty('6');
				$data['regiones_8'] = $this->servicio->get_cei_regiones_sgmty('8');
				if ($cliente['serv_id'] > 0)
				{
					$data['servicio'] = $servicio;
				}

                $this->load->helper('template');
                $params_view = array(
                    'title' => 'Personas',
                    'view' => 'persona/edit',
                    'view_data' => $data
                   );
                render_template($params_view);  
            }
        }
        else 
        {
            show_error('No existe el cliente');
        }
    }


    public function edita_evaluado($cliente_id)
    {   
        $user = $this->session->user;
		$cliente = $this->cliente->get($cliente_id);


        if($cliente)
        {

            if(isset($_POST) && count($_POST) > 0)     
            {
                $this->load->library('form_validation');

                if(1)
                {
                    $data_clte['empleado'] =  1;
					$data_clte['nomserv'] =  $cliente['nomserv'];
					$nomserv='NOM0351;NOM0352;NOM0353;NMEDICA;NNUTRI;NPSICO;';
					$data_clte['nomserv'] .=  $nomserv;
					$data_clte['clte_puesto'] =  $this->input->post('puesto');
						
					if($this->cliente->actualiza($cliente_id, array_to_upper($data_clte)))
					{
						send_json_ok(array('msg' =>'Se actualizó de forma correcta', 'id' => $cliente_id));
					}
					else
					{
						send_json_error('Ocurrió un error al actualizar la persona.');
					}
                }
                else
                {
                    send_json_error(validation_errors('<div />'));
                }
            }
            else 
            {

                $this->load->model('empresa/Empresa_model','empresa');
				if (($user_root3 == 2) && ($user_root4 == 3))
				{
					$data['empresas'] = $this->empresa->get_all_empresas_gsi_id();;			
				}
				else
				if ($user_root4 == 5)
				{
				$data['empresas'] = $this->empresa->trae_emp_asig($medico['usr_emp_asig']);			
				}
				else
				{
					$data['empresas'] = $this->empresa->trae_empresas();//$this->empresa->get_all_empresas();
				}
				
			//	$data['despachos'] = $this->empresa->get_all_despachos();
				$data['sucursals'] = $this->empresa->get_all_sucursales($cliente['emp_id']);
				$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($cliente['emp_id']);
                $data['persona'] = 	$cliente;
				if ($cliente['serv_id'] > 0)
				{
					$data['servicio'] = $servicio;
				}
                $this->load->helper('template');
                $params_view = array(
                    'title' => 'Personas',
                    'view' => 'persona/edit_evaluado',
                    'view_data' => $data
                   );
                render_template($params_view);  
            }
        }
        else 
        {
            show_error('No existe el cliente');
        }
    }
 
 
    public function edita_pswc($cliente_id)
    {   
        $user = $this->session->user;
		$cliente = $this->cliente->get($cliente_id);


        if($cliente)
        {

            if(isset($_POST) && count($_POST) > 0)     
            {
                $this->load->library('form_validation');

                if(1)
                {
                    $data_clte['empleado'] =  1;
					$data_clte['nomserv'] =  $cliente['nomserv'];
					$nomserv='NOM0351;NOM0352;NOM0353;NMEDICA;NNUTRI;NPSICO;';
					$data_clte['nomserv'] .=  $nomserv;
					$data_clte['clte_puesto'] =  $this->input->post('puesto');
						
					if($this->cliente->actualiza($cliente_id, array_to_upper($data_clte)))
					{
						send_json_ok(array('msg' =>'Se actualizó de forma correcta', 'id' => $cliente_id));
					}
					else
					{
						send_json_error('Ocurrió un error al actualizar la persona.');
					}
                }
                else
                {
                    send_json_error(validation_errors('<div />'));
                }
            }
            else 
            {

                $this->load->model('empresa/Empresa_model','empresa');
				if (($user_root3 == 2) && ($user_root4 == 3))
				{
					$data['empresas'] = $this->empresa->get_all_empresas_gsi_id();;			
				}
				else
				if ($user_root4 == 5)
				{
				$data['empresas'] = $this->empresa->trae_emp_asig($medico['usr_emp_asig']);			
				}
				else
				{
					$data['empresas'] = $this->empresa->trae_empresas();//$this->empresa->get_all_empresas();
				}
				
				//$data['despachos'] = $this->empresa->get_all_despachos();
				$data['sucursals'] = $this->empresa->get_all_sucursales($cliente['emp_id']);
				$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($cliente['emp_id']);
                $data['persona'] = 	$cliente;
				if ($cliente['serv_id'] > 0)
				{
					$data['servicio'] = $servicio;
				}
                $this->load->helper('template');
                $params_view = array(
                    'title' => 'Personas',
                    'view' => 'persona/edit_psw',
                    'view_data' => $data
                   );
                render_template($params_view);  
            }
        }
        else 
        {
            show_error('No existe el cliente');
        }
    }
 

    public function edita_psw($cliente_id)
    {   //date_default_timezone_set('America/Mexico_City');
        $user = $this->session->user;
		$user_root1=get_my_user_root1();
		$user_root3=get_my_user_root3();
		$user_root4=get_my_user_root4();
		$cliente = $this->cliente->get($cliente_id);
		$medico = $this->medico->get($user['usr_id']);

		if ($cliente['serv_id'] > 0)
		{	
			$servicio = $this->servicio->get($cliente['serv_id']);
		}

        if($cliente)
        {

            if(isset($_POST) && count($_POST) > 0)     
            {
                $this->load->library('form_validation');
                $this->form_validation->set_rules('nombre','Nombre','required');
                $this->form_validation->set_rules('paterno','Apellido Paterno','required');
                $this->form_validation->set_rules('materno','Apellido Materno','required');
                /*$this->form_validation->set_rules('fnac','Fecha de nacimiento','required');*/
                $this->form_validation->set_rules('genero','Género','required');
                //$this->form_validation->set_rules('civil','Estado civil','required');
                //$this->form_validation->set_rules('rfc','RFC','required');
                //$this->form_validation->set_rules('curp','CURP','required');

                if($this->form_validation->run())
                {
                    //informncion general de la pérsona
                    $data_clte['clte_nombre_crypt'] =  trim($this->input->post('nombre'));
                    $data_clte['clte_2_nombre_crypt'] =  trim($this->input->post('nombre_adic'));
                    $data_clte['clte_paterno_crypt'] =  trim($this->input->post('paterno'));
                    $data_clte['clte_materno_crypt'] =  trim($this->input->post('materno'));
                    
					//$data_clte['clte_f_nac'] = formatea_fecha_mysql($this->input->post('fnac'));
                    $data_clte['clte_f_nac'] = $this->input->post('fnac');
					
					$data_clte['clte_genero_cve'] =  $this->input->post('genero');
                    $data_clte['clte_rfc_crypt'] =  $this->input->post('rfc');
                    $data_clte['clte_curp_crypt'] =  $this->input->post('curp');					

                    //dopmcicio de la persona
                    $data_clte['clte_env_pais_cve'] =  $this->input->post('pais');
                    $data_clte['clte_env_cp'] =  $this->input->post('cp');
                    $data_clte['clte_env_edo_cve'] =  $this->input->post('entidad');
                    $data_clte['clte_env_colonia_crypt'] =  $this->input->post('colonia');
                    $data_clte['clte_env_localidad'] =  $this->input->post('localidad');
                    $data_clte['clte_env_municipio'] =  $this->input->post('municipio');
                    $data_clte['clte_env_calle_crypt'] =  $this->input->post('calle');
                    $data_clte['clte_env_num_ext_crypt'] =  $this->input->post('next');
                    $data_clte['clte_env_num_int_crypt'] =  $this->input->post('nint');
					$data_clte['clte_nss_crypt'] =  $this->input->post('nss');
                    //informacion de conrtaxcto de la persona
                    $data_clte['clte_tel_casa_crypt'] = limpia_telefono($this->input->post('tel'));                
                    $data_clte['clte_cel_crypt'] =  limpia_telefono($this->input->post('cel'));
                    $data_clte['clte_email_crypt'] =  $this->input->post('correo');

                    //nuevos campos
                    $data_clte['clte_grado_acad_cve'] =  $this->input->post('grado');
                    $data_clte['clte_puesto'] =  $this->input->post('puesto');
                    $data_clte['clte_edo_civ_cve'] =  $this->input->post('civil');
                    $data_clte['clte_nac_cve'] =  $this->input->post('nac');

                    //empresa donde va a loborar la persona
                    $data_clte['emp_id'] =  $this->input->post('empresa');
                    
                    //nuevo campo de unicacion
                    $data_clte['clte_lab_ubicacion'] =  $this->input->post('ubicacion');
                     
					//despachos 
					$data_clte['desp_id'] =  $this->input->post('despacho');
					$data_clte['clte_reclutador'] =  $this->input->post('reclutador');					 
					 
		
					$nomserv='';
					
					if ($this->input->post('nom35i') == 'OK')
					{$nomserv=$nomserv.'nom0351;';}	
					if ($this->input->post('nom35ii') == 'OK')
					{$nomserv=$nomserv.'nom0352;';}
					if ($this->input->post('nom35iii') == 'OK')
					{$nomserv=$nomserv.'nom0353;';}	
					if ($this->input->post('honestidad') == 'OK')
					{$nomserv=$nomserv.'HONE;';}
					if ($this->input->post('comportamiento') == 'OK')
					{$nomserv=$nomserv.'COMPO;';}
					if ($this->input->post('certificado') == 'OK')
					{$nomserv=$nomserv.'CERTI;';}
/***************************************************************************************/
						
					$cat_examen = get_cat_nombre_var('EXAMEN');
					$i=0;
					$cat_categorias = get_cat_nombre_var('CATEGORIA_EX');
					foreach($cat_categorias as $categoria): 
						//echo $categoria['cat_nombre'].' ';
						$linea_examenes=get_examen_de_empresa_por_categoria($cliente['emp_id'], $categoria['cat_nombre']);
						
						if (strlen($linea_examenes) > 0)
						{
							foreach (explode(';', $linea_examenes) as $det):
								if (strlen($det) > 0)
								{

										$exa=$this->input->post($categoria['cat_nombre'].'_'.$i);
										$nomserv.=$exa;
										$i++;
								}
								
							endforeach;										
						}
					endforeach;
/***************************************************************************************/

					$data_clte['nomserv'] =  $nomserv;
					
					
					if ($this->input->post('serv_id') > 0)
					{	
							if ($cliente['serv_id'] !=  $this->input->post('serv_id') )
							{
								$data_clte['serv_id'] =$this->input->post('serv_id');	
								$el_servicio=$this->input->post('serv_id');
								$pos = strpos($cliente['ordenes_series'] , $el_servicio);
								if ($pos !==0)
								{	
									$data_clte['ordenes_series'] = $cliente['ordenes_series'].$this->input->post('serv_id').';';
								}
								if (!(strstr( $el_servicio,$data_clte['domserv'] )))
								{	
									$data_clte['domserv'] = '|'.$this->input->post('serv_id').',';
								}								
							}
					}
					else
					{
						$data_clte['serv_id'] = $this->input->post('serv_id'); 
					}	

					//cei
					$data_clte['cei_id'] =  get_cei_id();


                    if(!empty($_FILES['foto']['name']))
                    {
                        $this->load->library('upload');
						sleep(1);
                        $filename = md5(time());
                        $config = array(
                                'upload_path'   => './../../files/fotos/',
                                'overwrite'     => TRUE,
                                'file_name'     => $filename,
                                'allowed_types' => 'png|jpg|jpeg',
                                'max_size'      => '25000'
                        );

                        $this->upload->initialize($config);
                        if ( ! $this->upload->do_upload('foto'))
                        {
                            send_json_error($this->upload->display_errors());
                        }
                        else 
                        {
                            $data = $this->upload->data();
                            $data_clte['clte_path_foto'] = $data['file_name'];
                        }
                    }

					if (($data_clte['clte_f_nac'] =='') && ($data_clte['emp_id'] !=152))
					{
						send_json_error('Ocurrió un error, no se registro la FECHA DE NACIMIENTO.');
					}
                    else
					{
						
						if ($this->input->post('rregistrar') == 'rr')
						{						
							if($this->cliente->actualiza_registro($cliente_id, array_to_upper($data_clte)))
							{
								send_json_ok(array('msg' =>'Se actualizó y registro nuevamente el evaluado de forma correcta', 'id' => $cliente_id));
							}
							else
							{
								send_json_error('Ocurrió un error al actualizar la persona.');
							}
						}
						else
						{	
						
							if($this->cliente->actualiza($cliente_id, array_to_upper($data_clte)))
							{
								send_json_ok(array('msg' =>'Se actualizó de forma correcta', 'id' => $cliente_id));
							}
							else
							{
								send_json_error('Ocurrió un error al actualizar la persona.');
							}
						}
					}
                }
                else
                {
                    send_json_error(validation_errors('<div />'));
                }
            }
            else 
            {
				//echo "----------->".$cliente['suc_id']."<-----------";
                $this->load->model('empresa/Empresa_model','empresa');
				if (($user_root3 == 2) && ($user_root4 == 3))
				{
					$data['empresas'] = $this->empresa->get_all_empresas_gsi_id();;			
				}
				else
				if ($user_root4 == 5)
				{
				$data['empresas'] = $this->empresa->trae_emp_asig($medico['usr_emp_asig']);			
				}
				else
				{
					$data['empresas'] = $this->empresa->trae_empresas();//$this->empresa->get_all_empresas();
				}
				
				//$data['despachos'] = $this->empresa->get_all_despachos();
				$data['sucursals'] = $this->empresa->get_all_sucursales($cliente['emp_id']);
				$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($cliente['emp_id']);
                $data['persona'] = 	$cliente;
				if ($cliente['serv_id'] > 0)
				{
					$data['servicio'] = $servicio;
				}
                $this->load->helper('template');
                $params_view = array(
                    'title' => 'Personas',
                    'view' => 'persona/edit_psw',
                    'view_data' => $data
                   );
                render_template($params_view);  
            }
        }
        else 
        {
            show_error('No existe el cliente');
        }
    }
 

    public function edita_a($cliente_id)
    {   
        $user = $this->session->user;
		$cliente = $this->cliente->get($cliente_id);
        
		if ($cliente['serv_id'] > 0)
		{	
			$servicio = $this->servicio->get($cliente['serv_id']);
		}
		
        if($cliente)
        {

            if(isset($_POST) && count($_POST) > 0)     
            {
                $this->load->library('form_validation');
                $this->form_validation->set_rules('nombre','Nombre','required');
                $this->form_validation->set_rules('paterno','Apellido Paterno','required');
                $this->form_validation->set_rules('materno','Apellido Materno','required');
                /*$this->form_validation->set_rules('fnac','Fecha de nacimiento','required');*/
                $this->form_validation->set_rules('genero','Género','required');
                //$this->form_validation->set_rules('civil','Estado civil','required');
                //$this->form_validation->set_rules('rfc','RFC','required');
                //$this->form_validation->set_rules('curp','CURP','required');

                if($this->form_validation->run())
                {
                    //informncion general de la pérsona
                    $data_clte['clte_nombre_crypt'] =  trim($this->input->post('nombre'));
                    $data_clte['clte_2_nombre_crypt'] =  trim($this->input->post('nombre_adic'));
                    $data_clte['clte_paterno_crypt'] =  trim($this->input->post('paterno'));
                    $data_clte['clte_materno_crypt'] =  trim($this->input->post('materno'));
                    
					$data_clte['clte_f_nac'] = formatea_fecha_mysql($this->input->post('fnac'));
                    $data_clte['clte_genero_cve'] =  $this->input->post('genero');
                    $data_clte['clte_rfc_crypt'] =  $this->input->post('rfc');
                    $data_clte['clte_curp_crypt'] =  $this->input->post('curp');
					

					

                    //dopmcicio de la persona
                    $data_clte['clte_env_pais_cve'] =  $this->input->post('pais');
                    $data_clte['clte_env_cp'] =  $this->input->post('cp');
                    $data_clte['clte_env_edo_cve'] =  $this->input->post('entidad');
                    $data_clte['clte_env_colonia_crypt'] =  $this->input->post('colonia');
                    $data_clte['clte_env_localidad'] =  $this->input->post('localidad');
                    $data_clte['clte_env_municipio'] =  $this->input->post('municipio');
                    $data_clte['clte_env_calle_crypt'] =  $this->input->post('calle');
                    $data_clte['clte_env_num_ext_crypt'] =  $this->input->post('next');
                    $data_clte['clte_env_num_int_crypt'] =  $this->input->post('nint');
					$data_clte['clte_nss_crypt'] =  $this->input->post('nss');
                    //informacion de conrtaxcto de la persona
                    $data_clte['clte_tel_casa_crypt'] = limpia_telefono($this->input->post('tel'));                
                    $data_clte['clte_cel_crypt'] =  limpia_telefono($this->input->post('cel'));
                    $data_clte['clte_email_crypt'] =  $this->input->post('correo');

                    //nuevos campos
                    $data_clte['clte_grado_acad_cve'] =  $this->input->post('grado');
                    $data_clte['clte_puesto'] =  $this->input->post('puesto');
                    $data_clte['clte_edo_civ_cve'] =  $this->input->post('civil');
                    $data_clte['clte_nac_cve'] =  $this->input->post('nac');

                    //empresa donde va a loborar la persona
                    $data_clte['emp_id'] =  $this->input->post('empresa');
                    
                    //nuevo campo de unicacion
                    $data_clte['clte_lab_ubicacion'] =  $this->input->post('ubicacion');
                     
					//despachos 
					$data_clte['desp_id'] =  $this->input->post('despacho');
					$data_clte['clte_reclutador'] =  $this->input->post('reclutador');	


					if ($user['usr_id']==393)
					{
						$data_clte['hc'] =  $this->input->post('hc');
					}

					
					$nomserv='';
					if ($this->input->post('nom35i') == 'OK')
					{$nomserv=$nomserv.'nom0351;';}	
					if ($this->input->post('nom35ii') == 'OK')
					{$nomserv=$nomserv.'nom0352;';}
					if ($this->input->post('nom35iii') == 'OK')
					{$nomserv=$nomserv.'nom0353;';}	
					
					if ($user['usr_id']==393)
					{
						$nomserv=$nomserv.'PRESTAMO;';
					}

					
					/*
					if ($this->input->post('honestidad') == 'OK')
					{$nomserv=$nomserv.'HONE;';}
					if ($this->input->post('comportamiento') == 'OK')
					{$nomserv=$nomserv.'COMPO;';}
					if ($this->input->post('certificado') == 'OK')
					{$nomserv=$nomserv.'CERTI;';}
					*/
/***************************************************************************************/
						
					$cat_examen = get_cat_nombre_var('EXAMEN');
					$i=0;
					$cat_categorias = get_cat_nombre_var('CATEGORIA_EX');
					foreach($cat_categorias as $categoria): 
						//echo $categoria['cat_nombre'].' ';
						$linea_examenes=get_examen_de_empresa_por_categoria($cliente['emp_id'], $categoria['cat_nombre']);
						
						if (strlen($linea_examenes) > 0)
						{
							foreach (explode(';', $linea_examenes) as $det):
								if (strlen($det) > 0)
								{

										//<?php echo $categoria['cat_nombre'];

										//<?php echo get_nombre_de_examen($det, 'EXAMEN');
										
										$exa=$this->input->post($categoria['cat_nombre'].'_'.$i);
										$nomserv.=$exa;
										$i++;
										//<input type="checkbox" id="<?php echo $categoria['cat_nombre'].'_'.$i; " name="<?php echo $categoria['cat_nombre'].'_'.$i; " value="<?php echo $det.';'; $i++; " <?php if (strstr($persona['nomserv'], $det.';')) { echo 'checked';} 

								}
								
							endforeach;										
						}
					endforeach;
/***************************************************************************************/

					$data_clte['nomserv'] =  $nomserv;
					
					// Se convierte en un empleado de HC
					$data_clte['hc'] =  1;
		
                    //despacho
					/*
                      $data_clte['desp_id'] =  $this->input->post('despacho');
					  if ($data_clte['desp_id'] == 1) {$data_clte['desp_id']=0;}
					  $data_clte['clte_reclutador'] =  $this->input->post('reclutador');
					
					
					if ($this->input->post('serv_id') > 0)
					{	
						$data_clte['serv_id'] =$this->input->post('serv_id');
					}				
					*/
					
					//sucursal
					$data_clte['suc_id'] =  $this->input->post('sucursal');
					
					//cei
					$data_clte['cei_id'] =  $this->input->post('cei');
					
					if (($user_root3 == 2) && ($user_root4 == 3))
					{
						$data_clte['cei_id'] = 4;
					}
//*************************************
//$data_clte['root'] = 'OK';
//*************************************


                    if(!empty($_FILES['foto']['name']))
                    {
                        $this->load->library('upload');
                        $filename = md5(time());
                        $config = array(
                                'upload_path'   => './../../files/fotos/',
                                'overwrite'     => TRUE,
                                'file_name'     => $filename,
                                'allowed_types' => 'png|jpg|jpeg',
                                'max_size'      => '25000'
                        );

                        $this->upload->initialize($config);
                        if ( ! $this->upload->do_upload('foto'))
                        {
                            send_json_error($this->upload->display_errors());
                        }
                        else 
                        {
                            $data = $this->upload->data();
                            $data_clte['clte_path_foto'] = $data['file_name'];
                        }
                    }

					if (($data_clte['clte_f_nac'] =='') && ($data_clte['emp_id'] !=152))
					{
						send_json_error('Ocurrió un error, no se registro la FECHA DE NACIMIENTO.');
					}
                    else
					{
						
						if ($this->input->post('rregistrar') == 'rr')
						{						
							if($this->cliente->actualiza_registro($cliente_id, array_to_upper($data_clte)))
							{
								send_json_ok(array('msg' =>'Se actualizó y registro nuevamente el evaluado de forma correcta', 'id' => $cliente_id));
							}
							else
							{
								send_json_error('Ocurrió un error al actualizar la persona.');
							}
						}
						else
						{	
						
							if($this->cliente->actualiza($cliente_id, array_to_upper($data_clte)))
							{
								send_json_ok(array('msg' =>'Se actualizó y ha sido Contratado en HC de forma correcta', 'id' => $cliente_id));
							}
							else
							{
								send_json_error('Ocurrió un error al actualizar la persona.');
							}
						}
					}
                }
                else
                {
                    send_json_error(validation_errors('<div />'));
                }
            }
            else 
            {
				//echo "----------->".$cliente['suc_id']."<-----------";
                $this->load->model('empresa/Empresa_model','empresa');
                $data['empresas'] = $this->empresa->trae_empresas();//$this->empresa->get_all_empresas();
				//$data['despachos'] = $this->empresa->get_all_despachos();
				$data['sucursals'] = $this->empresa->get_all_sucursales();
				$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($cliente['emp_id']);
                $data['persona'] = 	$cliente;
				if ($cliente['serv_id'] > 0)
				{
					$data['servicio'] = $servicio;
				}
                $this->load->helper('template');
                $params_view = array(
                    'title' => 'Personas',
                    'view' => 'persona/edit_a',
                    'view_data' => $data
                   );
                render_template($params_view);  
            }
        }
        else 
        {
            show_error('No existe el cliente');
        }
    }


    public function edita_hc($cliente_id)
    {    
		$user = $this->session->user;
		$cliente = $this->cliente->get($cliente_id);
        
		if ($cliente['serv_id'] > 0)
		{	
			$servicio = $this->servicio->get($cliente['serv_id']);
		}
		
        if($cliente)
        {

            if(isset($_POST) && count($_POST) > 0)     
            {
                $this->load->library('form_validation');
                $this->form_validation->set_rules('nombre','Nombre','required');
                $this->form_validation->set_rules('paterno','Apellido Paterno','required');
                $this->form_validation->set_rules('materno','Apellido Materno','required');
                /*$this->form_validation->set_rules('fnac','Fecha de nacimiento','required');*/
                $this->form_validation->set_rules('genero','Género','required');
                //$this->form_validation->set_rules('civil','Estado civil','required');
                //$this->form_validation->set_rules('rfc','RFC','required');
                //$this->form_validation->set_rules('curp','CURP','required');

                if($this->form_validation->run())
                {
                    //informncion general de la pérsona
                    $data_clte['clte_nombre_crypt'] =  trim($this->input->post('nombre'));
                    $data_clte['clte_2_nombre_crypt'] =  trim($this->input->post('nombre_adic'));
                    $data_clte['clte_paterno_crypt'] =  trim($this->input->post('paterno'));
                    $data_clte['clte_materno_crypt'] =  trim($this->input->post('materno'));
 					$data_clte['clte_f_nac'] = formatea_fecha_mysql($this->input->post('fnac'));
                    $data_clte['clte_nac_cve'] =  $this->input->post('nac');
					$data_clte['clte_edo_civ_cve'] =  $this->input->post('civil');					
                    $data_clte['clte_rfc_crypt'] =  $this->input->post('rfc');
                    $data_clte['clte_curp_crypt'] =  $this->input->post('curp');
					$data_clte['clte_nss_crypt'] =  $this->input->post('nss');
					$data_clte['clte_genero_cve'] =  $this->input->post('genero');
                    $data_clte['clte_grado_acad_cve'] =  $this->input->post('grado');

                    //dopmcicio de la persona
                    $data_clte['clte_env_pais_cve'] =  $this->input->post('pais');
                    $data_clte['clte_env_cp'] =  $this->input->post('cp');
                    $data_clte['clte_env_edo_cve'] =  $this->input->post('entidad');
                    $data_clte['clte_env_colonia_crypt'] =  $this->input->post('colonia');
                    $data_clte['clte_env_localidad'] =  $this->input->post('localidad');
                    $data_clte['clte_env_municipio'] =  $this->input->post('municipio');
                    $data_clte['clte_env_calle_crypt'] =  $this->input->post('calle');
                    $data_clte['clte_env_num_ext_crypt'] =  $this->input->post('next');
                    $data_clte['clte_env_num_int_crypt'] =  $this->input->post('nint');
					$data_clte['clte_nss_crypt'] =  $this->input->post('nss');
                    //informacion de conrtaxcto de la persona
                    $data_clte['clte_tel_casa_crypt'] = limpia_telefono($this->input->post('tel'));                
                    $data_clte['clte_cel_crypt'] =  limpia_telefono($this->input->post('cel'));
                    $data_clte['clte_email_crypt'] =  $this->input->post('correo');

					
                    $data_clte['clte_lab_ubicacion'] =  $this->input->post('ubicacion');					$data_clte['desp_id'] =  $this->input->post('despacho');
					$data_clte['clte_reclutador'] =  $this->input->post('reclutador');					 
					$data_clte['status'] =  $this->input->post('status'); 


					//Situación Laboral en HUMAN CENTER REVIEW S.A. DE C.V. 
					
					// Se convierte en un empleado de HC
					$data_clte['emp_id'] = 31; //$this->input->post('empresa');
					$data_clte['hc'] =  1;
					$data_clte['status'] =  $this->input->post('status');
					$data_clte['f_ingreso'] = formatea_fecha_mysql($this->input->post('f_ingreso'));
					$data_clte['num_empleado'] =  $this->input->post('num_empleado');
					$data_clte['clte_puesto'] =  $this->input->post('puesto');
                    
					$data_card['card_ingreso'] =  $this->input->post('carrera');
					$data_card['card_carrera'] =  $this->input->post('carrera');
					$data_card['card_institucion'] =  $this->input->post('institucion');
					$data_card['card_cedula'] =  $this->input->post('cedula');
					$data_card['card_horario'] =  $this->input->post('horario');
					$data_card['card_recetas'] =  $this->input->post('recetas');
					$data_card['card_asignado'] =  $this->input->post('asignado');
					$data_card['card_subordinados'] =  $this->input->post('subordinados');
					$data_card['card_cei'] =  $this->input->post('cei');
					$data_card['card_suc'] =  $this->input->post('sucursal');
					$data_card['card_gerencia'] =  $this->input->post('gerencia');
					$data_card['card_area'] =  $this->input->post('area');
					$data_card['card_jefe_im'] =  $this->input->post('jefe_im');
					$data_card['card_clte_id'] =  $this->input->post('idplataforma');
					$data_card['card_usr_id'] =  $this->input->post('usr_id');
					
					
					
					
					//Estatus del Empleado
										
					//Fecha de Ingreso
					
					//Núm. Empleado
					
                    //Sueldo
					$data_clte['sueldo'] =  $this->input->post('sueldo');
                    //Área
					$data_clte['area_depto'] =  $this->input->post('area_depto');
                    //Jefe Inmediato
					$data_clte['supervisor'] =  $this->input->post('supervisor');
                    //ID Usuario HCOL
					$data_clte['usr_id'] =  $this->input->post('usr_id');
                    //EMAIL HC:</label>
					$data_clte['emailhc'] =  $this->input->post('emailhc');
                    //Teléfono Oficina
					$data_clte['telefonohc'] =  $this->input->post('telefonohc');
                    //Extensión
					$data_clte['extensionhc'] =  $this->input->post('extensionhc');
					//Préstamo Activo
					$data_clte['prestamo'] =  $this->input->post('prestamo');

					//sucursal
					$data_clte['suc_id'] =  $this->input->post('sucursal');
					
					//cei
					$data_clte['cei_id'] =  $this->input->post('cei');


					 
	
					$nomserv='';
					if ($this->input->post('nom35i') == 'OK')
					{$nomserv=$nomserv.'nom0351;';}	
					if ($this->input->post('nom35ii') == 'OK')
					{$nomserv=$nomserv.'nom0352;';}
					if ($this->input->post('nom35iii') == 'OK')
					{$nomserv=$nomserv.'nom0353;';}	
					
					if ($user['usr_id']==393)
					{
						$nomserv=$nomserv.'PRESTAMO;';
						$nomserv=$nomserv.'nom0351;';
						$nomserv=$nomserv.'nom0352;';
						$nomserv=$nomserv.'nom0353;';
					}
					
/***************************************************************************************/
						
					$cat_examen = get_cat_nombre_var('EXAMEN');
					$i=0;
					$cat_categorias = get_cat_nombre_var('CATEGORIA_EX');
					foreach($cat_categorias as $categoria): 
						//echo $categoria['cat_nombre'].' ';
						$linea_examenes=get_examen_de_empresa_por_categoria($cliente['emp_id'], $categoria['cat_nombre']);
						
						if (strlen($linea_examenes) > 0)
						{
							foreach (explode(';', $linea_examenes) as $det):
								if (strlen($det) > 0)
								{

										//<?php echo $categoria['cat_nombre'];

										//<?php echo get_nombre_de_examen($det, 'EXAMEN');
										
										$exa=$this->input->post($categoria['cat_nombre'].'_'.$i);
										$nomserv.=$exa;
										$i++;
										//<input type="checkbox" id="<?php echo $categoria['cat_nombre'].'_'.$i; " name="<?php echo $categoria['cat_nombre'].'_'.$i; " value="<?php echo $det.';'; $i++; " <?php if (strstr($persona['nomserv'], $det.';')) { echo 'checked';} 

								}
								
							endforeach;										
						}
					endforeach;
/***************************************************************************************/

					$data_clte['nomserv'] =  $nomserv;
					


					
					
//*************************************
//$data_clte['root'] = 'OK';
//*************************************


                    if(!empty($_FILES['foto']['name']))
                    {
                        $this->load->library('upload');
                        $filename = md5(time());
                        $config = array(
                                'upload_path'   => './../../files/fotos/',
                                'overwrite'     => TRUE,
                                'file_name'     => $filename,
                                'allowed_types' => 'png|jpg|jpeg',
                                'max_size'      => '25000'
                        );

                        $this->upload->initialize($config);
                        if ( ! $this->upload->do_upload('foto'))
                        {
                            send_json_error($this->upload->display_errors());
                        }
                        else 
                        {
                            $data = $this->upload->data();
                            $data_clte['clte_path_foto'] = $data['file_name'];
                        }
                    }

					if (($data_clte['clte_f_nac'] =='') && ($data_clte['emp_id'] !=152))
					{
						send_json_error('Ocurrió un error, no se registro la FECHA DE NACIMIENTO.');
					}
                    else
					{
						
						if ($this->input->post('rregistrar') == 'rr')
						{						
							if($this->cliente->actualiza_registro($cliente_id, array_to_upper($data_clte)))
							{
								
								send_json_ok(array('msg' =>'Se actualizó y registro nuevamente el evaluado de forma correcta', 'id' => $cliente_id));
							}
							else
							{
								send_json_error('Ocurrió un error al actualizar la persona.');
							}
						}
						else
						{	
						
							if($this->cliente->actualiza($cliente_id, array_to_upper($data_clte)))
							{
								send_json_ok(array('msg' =>'Se actualizó y ha sido Contratado en HC de forma correcta', 'id' => $cliente_id));
							}
							else
							{
								send_json_error('Ocurrió un error al actualizar la persona.');
							}
						}
					}
                }
                else
                {
                    send_json_error(validation_errors('<div />'));
                }
            }
            else 
            {
				//echo "----------->".$cliente['suc_id']."<-----------";
                $this->load->model('empresa/Empresa_model','empresa');
                $data['empresas'] = $this->empresa->trae_empresas();//$this->empresa->get_all_empresas();
				//$data['despachos'] = $this->empresa->get_all_despachos();
				$data['sucursals'] = $this->empresa->get_all_sucursales(31);
				$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($cliente['emp_id']);
                $data['persona'] = 	$cliente;
				if ($cliente['serv_id'] > 0)
				{
					$data['servicio'] = $servicio;
				}
                $this->load->helper('template');
                $params_view = array(
                    'title' => 'Personas',
                    'view' => 'persona/edit_hc',
                    'view_data' => $data
                   );
                render_template($params_view);  
            }
        }
        else 
        {
            show_error('No existe el cliente');
        }
    }


    public function edita_c($cliente_id)
    {    
		$user = $this->session->user;
		$cliente = $this->cliente->get($cliente_id);
		$empresa=$cliente['emp_id'];
		$worker= $this->cliente->get_worker($cliente_id,$empresa);
        
		
		
		if ($worker['usr_id'] > 0)
		{
			$worker_usr=$this->medico->get_worker_usuario($worker['usr_id']);
		}	
		
			
		if ($cliente['serv_id'] > 0)
		{	
			$servicio = $this->servicio->get($cliente['serv_id']);
		}
		
        if($cliente)
        {

            if(isset($_POST) && count($_POST) > 0)     
            {
                $this->load->library('form_validation');
                $this->form_validation->set_rules('nombre','Nombre','required');
                $this->form_validation->set_rules('paterno','Apellido Paterno','required');
                $this->form_validation->set_rules('materno','Apellido Materno','required');
                /*$this->form_validation->set_rules('fnac','Fecha de nacimiento','required');*/
                $this->form_validation->set_rules('genero','Género','required');
                //$this->form_validation->set_rules('civil','Estado civil','required');
                //$this->form_validation->set_rules('rfc','RFC','required');
                //$this->form_validation->set_rules('curp','CURP','required');

                if($this->form_validation->run())
                {
                    //informncion general de la pérsona
                    $data_clte['clte_nombre_crypt'] =  trim($this->input->post('nombre'));
                    $data_clte['clte_2_nombre_crypt'] =  trim($this->input->post('nombre_adic'));
                    $data_clte['clte_paterno_crypt'] =  trim($this->input->post('paterno'));
                    $data_clte['clte_materno_crypt'] =  trim($this->input->post('materno'));
                    
					$data_clte['clte_f_nac'] = formatea_fecha_mysql($this->input->post('fnac'));
                    $data_clte['clte_genero_cve'] =  $this->input->post('genero');
                    $data_clte['clte_rfc_crypt'] =  $this->input->post('rfc');
                    $data_clte['clte_curp_crypt'] =  $this->input->post('curp');

                    //dopmcicio de la persona
                    $data_clte['clte_env_pais_cve'] =  $this->input->post('pais');
                    $data_clte['clte_env_cp'] =  $this->input->post('cp');
                    $data_clte['clte_env_edo_cve'] =  $this->input->post('entidad');
                    $data_clte['clte_env_colonia_crypt'] =  $this->input->post('colonia');
                    $data_clte['clte_env_localidad'] =  $this->input->post('localidad');
                    $data_clte['clte_env_municipio'] =  $this->input->post('municipio');
                    $data_clte['clte_env_calle_crypt'] =  $this->input->post('calle');
                    $data_clte['clte_env_num_ext_crypt'] =  $this->input->post('next');
                    $data_clte['clte_env_num_int_crypt'] =  $this->input->post('nint');
					$data_clte['clte_nss_crypt'] =  $this->input->post('nss');
                    //informacion de conrtaxcto de la persona
                    $data_clte['clte_tel_casa_crypt'] = limpia_telefono($this->input->post('tel'));                
                    $data_clte['clte_cel_crypt'] =  limpia_telefono($this->input->post('cel'));
                    $data_clte['clte_email_crypt'] =  $this->input->post('correo');

                    //nuevos campos
                    $data_clte['clte_grado_acad_cve'] =  $this->input->post('grado');
                    
                    $data_clte['clte_edo_civ_cve'] =  $this->input->post('civil');
                    $data_clte['clte_nac_cve'] =  $this->input->post('nac');
					
					$data_clte['clte_ida'] =  $this->input->post('spp');
						

                    //empresa donde va a loborar la persona
                   // $data_clte['emp_id'] =  $cliente['emp_id'];
                    
                    //nuevo campo de unicacion
                    $data_clte['clte_lab_ubicacion'] =  $this->input->post('ubicacion');
                     
					//despachos 
					$data_clte['desp_id'] =  $this->input->post('despacho');
					$data_clte['clte_reclutador'] =  $this->input->post('reclutador');					 
					 
					
					 
	
					$nomserv='';
					if ($this->input->post('nom35i') == 'OK')
					{$nomserv=$nomserv.'nom0351;';}	
					if ($this->input->post('nom35ii') == 'OK')
					{$nomserv=$nomserv.'nom0352;';}
					if ($this->input->post('nom35iii') == 'OK')
					{$nomserv=$nomserv.'nom0353;';}	
					
					if ($user['usr_id']==393)
					{
						$nomserv=$nomserv.'PRESTAMO;';
						$nomserv=$nomserv.'nom0351;';
						$nomserv=$nomserv.'nom0352;';
						$nomserv=$nomserv.'nom0353;';
					}
					
/***************************************************************************************/
						
					$cat_examen = get_cat_nombre_var('EXAMEN');
					$i=0;
					$cat_categorias = get_cat_nombre_var('CATEGORIA_EX');
					foreach($cat_categorias as $categoria): 
						//echo $categoria['cat_nombre'].' ';
						$linea_examenes=get_examen_de_empresa_por_categoria($cliente['emp_id'], $categoria['cat_nombre']);
						
						if (strlen($linea_examenes) > 0)
						{
							foreach (explode(';', $linea_examenes) as $det):
								if (strlen($det) > 0)
								{

										//<?php echo $categoria['cat_nombre'];

										//<?php echo get_nombre_de_examen($det, 'EXAMEN');
										
										$exa=$this->input->post($categoria['cat_nombre'].'_'.$i);
										$nomserv.=$exa;
										$i++;
										//<input type="checkbox" id="<?php echo $categoria['cat_nombre'].'_'.$i; " name="<?php echo $categoria['cat_nombre'].'_'.$i; " value="<?php echo $det.';'; $i++; " <?php if (strstr($persona['nomserv'], $det.';')) { echo 'checked';} 

								}
								
							endforeach;										
						}
					endforeach;
/***************************************************************************************/

					$data_clte['nomserv'] =  $nomserv;
			/*		
					// Se convierte en un empleado de HC
					$data_clte['hc'] =  1;
					//Estatus del Empleado
					$data_clte['status'] =  $this->input->post('status');					
					//Fecha de Ingreso
					$data_clte['f_ingreso'] = formatea_fecha_mysql($this->input->post('f_ingreso'));
					//Núm. Empleado
					$data_clte['num_empleado'] =  $this->input->post('num_empleado');
                    //Sueldo
					$data_clte['sueldo'] =  $this->input->post('sueldo');
                    //Área
					$data_clte['area_depto'] =  $this->input->post('area_depto');
                    //Jefe Inmediato
					$data_clte['supervisor'] =  $this->input->post('supervisor');
                    //ID Usuario HCOL
					$data_clte['usr_id'] =  $this->input->post('usr_id');
                    //EMAIL HC:</label>
					$data_clte['emailhc'] =  $this->input->post('emailhc');
                    //Teléfono Oficina
					$data_clte['telefonohc'] =  $this->input->post('telefonohc');
                    //Extensión
					$data_clte['extensionhc'] =  $this->input->post('extensionhc');
					//Préstamo Activo
					$data_clte['prestamo'] =  $this->input->post('prestamo');

					//sucursal
					$data_clte['suc_id'] =  $this->input->post('sucursal');
					
					//cei*/
					
					
					$data_worker['work_numemp'] =  $this->input->post('work_numemp');
					$data_worker['f_registro'] = $cliente['log_insrt_f'];
					$data_worker['f_ingreso'] =  $this->input->post('f_ingreso'); 
					$data_worker['f_baja'] =  $this->input->post('f_baja');
					
					$data_worker['work_puesto'] =  $this->input->post('puesto');
					$data_clte['clte_puesto'] =  $this->input->post('puesto');
					
					$data_worker['cei_id'] =  $this->input->post('cei');
					$data_clte['cei_id'] =  $this->input->post('cei');
					
					$data_worker['suc_id'] =  $this->input->post('sucursal');
					$data_clte['suc_id'] =  $this->input->post('sucursal');
					
					
					$data_worker['clte_id'] = $cliente['clte_id'];
					$data_worker['emp_id'] = $cliente['emp_id'];
					
					$data_worker['work_estatus'] =  $this->input->post('status'); 
					$data_clte['status'] =  $this->input->post('status'); 
					
					$data_clte['supervisor'] =  $this->input->post('supervisor');
					$data_worker['work_jefe'] =  $this->input->post('supervisor');
					
					
					$data_worker['work_numemp'] =  $this->input->post('work_numemp'); 
					$data_worker['work_area'] =  $this->input->post('area'); 
					$data_worker['work_depto'] =  $this->input->post('depto'); 
					$data_worker['work_subordinados'] =  $this->input->post('work_subordinados');
					$data_worker['work_recetas'] =  $this->input->post('work_recetas');
					
					$data_worker['work_corp'] =  $this->input->post('corporacion');
					$data_worker['work_asignado'] =  $this->input->post('consultorio');
					
					$data_worker['work_sueldo'] =  $this->input->post('sueldo');
					$data_worker['work_prestamo'] =  $this->input->post('prestamo');

					$data_worker['usr_id'] =  $this->input->post('usr_id');

					$data_worker['work_carrera'] =  $this->input->post('work_carrera');
					$data_worker['work_institucion'] =  $this->input->post('work_institucion');
					$data_worker['work_cedula'] =  $this->input->post('work_cedula');
					$data_worker['work_horario'] =  $this->input->post('work_horario');



				    $data_clte['clte_path_foto'] = $cliente ['clte_path_foto'];

                    if(!empty($_FILES['foto']['name']))
                    {
                        $this->load->library('upload');
                        $filename = md5(time());
                        $config = array(
                                'upload_path'   => './../../files/fotos/',
                                'overwrite'     => TRUE,
                                'file_name'     => $filename,
                                'allowed_types' => 'png|jpg|jpeg',
                                'max_size'      => '25000'
                        );

                        $this->upload->initialize($config);
                        if ( ! $this->upload->do_upload('foto'))
                        {
                            send_json_error($this->upload->display_errors());
                        }
                        else 
                        {
                            $data = $this->upload->data();
                            $data_clte['clte_path_foto'] = $data['file_name'];
                        }
                    }


					if ($worker_usr['usr_id'] > 0)
					{

                      if ( ($data_clte['clte_path_foto'] === NULL) && ($worker_usr['usr_path_foto'] ==! NULL)  )
					  { $data_clte['clte_path_foto']=$worker_usr['usr_path_foto']; }
                      else
                      {   
							if ( ($data_clte['clte_path_foto'] !== NULL) && ($worker_usr['usr_path_foto'] === NULL)  ) 
							{ $worker_usr['usr_path_foto']=$data_clte['clte_path_foto']; }						 
                      }
					}


					if (($data_clte['clte_f_nac'] =='') && ($data_clte['emp_id'] !=152))
					{
						send_json_error('Ocurrió un error, no se registro la FECHA DE NACIMIENTO.');
					}
                    else
					{
						
						if ($this->input->post('rregistrar') == 'rr')
						{						
							if($this->cliente->actualiza_registro($cliente_id, array_to_upper($data_clte)))
							{
								send_json_ok(array('msg' =>'Se actualizó y registro nuevamente el evaluado de forma correcta', 'id' => $cliente_id));
							}
							else
							{
								send_json_error('Ocurrió un error al actualizar la persona.');
							}
						}
						else
						{	
						
							if($this->cliente->actualiza($cliente_id, array_to_upper($data_clte)))
							{
								$c=$this->cliente->insrt_update_worker($cliente_id, $cliente['emp_id'],array_to_upper($data_worker) );
								send_json_ok(array('msg' =>'Se actualizó y ha sido Contratado en HC de forma correcta', 'id' => $cliente_id));
							}
							else
							{
								send_json_error('Ocurrió un error al actualizar la persona.');
							}
						}
					}
                }
                else
                {
                    send_json_error(validation_errors('<div />'));
                }
            }
            else 
            {
                $this->load->model('empresa/Empresa_model','empresa');

				$data['sucursals'] = $this->empresa->get_all_sucursales($empresa);
				$data['consultorios'] = $this->empresa->get_lista_consultorios();
                $data['persona'] = 	$cliente;
				$data['worker'] = 	$worker;
				$data['worker_usr'] = 	$worker_usr;
				
				if ($cliente['serv_id'] > 0)
				{
					$data['servicio'] = $servicio;
				}
                $this->load->helper('template');
                $params_view = array(
                    'title' => 'Personas',
                    'view' => 'persona/edit_c',
                    'view_data' => $data
                   );
                render_template($params_view);  
            }
        }
        else 
        {
            show_error('No existe el cliente');
        }
    }
 
    public function edita_d($cliente_id)
    {           
		$cliente = $this->cliente->get($cliente_id);
        
		if ($cliente['serv_id'] > 0)
		{	
			$servicio = $this->servicio->get($cliente['serv_id']);
		}
		
        if($cliente)
        {

            if(isset($_POST) && count($_POST) > 0)     
            {
                $this->load->library('form_validation');
                $this->form_validation->set_rules('nombre','Nombre','required');
                $this->form_validation->set_rules('paterno','Apellido Paterno','required');
                $this->form_validation->set_rules('materno','Apellido Materno','required');
                /*$this->form_validation->set_rules('fnac','Fecha de nacimiento','required');*/
                $this->form_validation->set_rules('genero','Género','required');
                //$this->form_validation->set_rules('civil','Estado civil','required');
                //$this->form_validation->set_rules('rfc','RFC','required');
                //$this->form_validation->set_rules('curp','CURP','required');

                if($this->form_validation->run())
                {
                    //informncion general de la pérsona
                    $data_clte['clte_nombre_crypt'] =  trim($this->input->post('nombre'));
                    $data_clte['clte_2_nombre_crypt'] =  trim($this->input->post('nombre_adic'));
                    $data_clte['clte_paterno_crypt'] =  trim($this->input->post('paterno'));
                    $data_clte['clte_materno_crypt'] =  trim($this->input->post('materno'));
                    
					$data_clte['clte_f_nac'] = formatea_fecha_mysql($this->input->post('fnac'));
                    $data_clte['clte_genero_cve'] =  $this->input->post('genero');
                    $data_clte['clte_rfc_crypt'] =  $this->input->post('rfc');
                    $data_clte['clte_curp_crypt'] =  $this->input->post('curp');

                    //dopmcicio de la persona
                    $data_clte['clte_env_pais_cve'] =  $this->input->post('pais');
                    $data_clte['clte_env_cp'] =  $this->input->post('cp');
                    $data_clte['clte_env_edo_cve'] =  $this->input->post('entidad');
                    $data_clte['clte_env_colonia_crypt'] =  $this->input->post('colonia');
                    $data_clte['clte_env_localidad'] =  $this->input->post('localidad');
                    $data_clte['clte_env_municipio'] =  $this->input->post('municipio');
                    $data_clte['clte_env_calle_crypt'] =  $this->input->post('calle');
                    $data_clte['clte_env_num_ext_crypt'] =  $this->input->post('next');
                    $data_clte['clte_env_num_int_crypt'] =  $this->input->post('nint');
					$data_clte['clte_nss_crypt'] =  $this->input->post('nss');
                    //informacion de conrtaxcto de la persona
                    $data_clte['clte_tel_casa_crypt'] = limpia_telefono($this->input->post('tel'));                
                    $data_clte['clte_cel_crypt'] =  limpia_telefono($this->input->post('cel'));
                    $data_clte['clte_email_crypt'] =  $this->input->post('correo');

                    //nuevos campos
                    $data_clte['clte_grado_acad_cve'] =  $this->input->post('grado');
                    $data_clte['clte_puesto'] =  $this->input->post('puesto');
                    $data_clte['clte_edo_civ_cve'] =  $this->input->post('civil');
                    $data_clte['clte_nac_cve'] =  $this->input->post('nac');

                    //empresa donde va a loborar la persona
                    $data_clte['emp_id'] =  $this->input->post('empresa');
                    
                    //nuevo campo de unicacion
                    $data_clte['clte_lab_ubicacion'] =  $this->input->post('ubicacion');
                     
					//despachos 
					/*
					$data_clte['desp_id'] =  $this->input->post('despacho');
					$data_clte['clte_reclutador'] =  $this->input->post('reclutador');					 
					 
					
					$nomserv='';
					if ($this->input->post('nom35i') == 'OK')
					{$nomserv=$nomserv.'nom0351;';}	
					if ($this->input->post('nom35ii') == 'OK')
					{$nomserv=$nomserv.'nom0352;';}
					if ($this->input->post('nom35iii') == 'OK')
					{$nomserv=$nomserv.'nom0353;';}	
					
					
					if ($this->input->post('honestidad') == 'OK')
					{$nomserv=$nomserv.'HONE;';}
					if ($this->input->post('comportamiento') == 'OK')
					{$nomserv=$nomserv.'COMPO;';}
					if ($this->input->post('certificado') == 'OK')
					{$nomserv=$nomserv.'CERTI;';}
					*/
					
					/*						
					$cat_examen = get_cat_nombre_var('EXAMEN');
					$i=0;
					$cat_categorias = get_cat_nombre_var('CATEGORIA_EX');
					foreach($cat_categorias as $categoria): 
						$linea_examenes=get_examen_de_empresa_por_categoria($cliente['emp_id'], $categoria['cat_nombre']);
						
						if (strlen($linea_examenes) > 0)
						{
							foreach (explode(';', $linea_examenes) as $det):
								if (strlen($det) > 0)
								{
									$exa=$this->input->post($categoria['cat_nombre'].'_'.$i);
									$nomserv.=$exa;
									$i++;
								}								
							endforeach;										
						}
					endforeach;
					

					$data_clte['nomserv'] =  $nomserv;
					*/
					
					
					// Se convierte en un empleado de empresa
					$data_clte['empleado'] =  1;
					//echo $this->input->post('estatus');
					$data_clte['num_empleado'] = $this->input->post('nempleado');
					//if ($this->input->post('estatus') == 'noactivo')
					{
						$data_clte['status'] =  $this->input->post('status');
					}
		
                    //despacho
					/*
                      $data_clte['desp_id'] =  $this->input->post('despacho');
					  if ($data_clte['desp_id'] == 1) {$data_clte['desp_id']=0;}
					  $data_clte['clte_reclutador'] =  $this->input->post('reclutador');
					
					
					if ($this->input->post('serv_id') > 0)
					{	
						$data_clte['serv_id'] =$this->input->post('serv_id');
					}				
					*/
					
					//sucursal
					/*
					$data_clte['suc_id'] =  $this->input->post('sucursal');
					*/
					//cei
					/*
					$data_clte['cei_id'] =  $this->input->post('cei');
					*/
					
//*************************************
//$data_clte['root'] = 'OK';
//*************************************


                    if(!empty($_FILES['foto']['name']))
                    {
                        $this->load->library('upload');
                        $filename = md5(time());
                        $config = array(
                                'upload_path'   => './../../files/fotos/',
                                'overwrite'     => TRUE,
                                'file_name'     => $filename,
                                'allowed_types' => 'png|jpg|jpeg',
                                'max_size'      => '25000'
                        );

                        $this->upload->initialize($config);
                        if ( ! $this->upload->do_upload('foto'))
                        {
                            send_json_error($this->upload->display_errors());
                        }
                        else 
                        {
                            $data = $this->upload->data();
                            $data_clte['clte_path_foto'] = $data['file_name'];
                        }
                    }

					if (($data_clte['clte_f_nac'] =='') && ($data_clte['emp_id'] !=152))
					{
						send_json_error('Ocurrió un error, no se registro la FECHA DE NACIMIENTO.');
					}
                    else
					{
						
						if ($this->input->post('rregistrar') == 'rr')
						{						
							if($this->cliente->actualiza_registro($cliente_id, array_to_upper($data_clte)))
							{
								send_json_ok(array('msg' =>'Se actualizó y registro nuevamente el evaluado de forma correcta', 'id' => $cliente_id));
							}
							else
							{
								send_json_error('Ocurrió un error al actualizar la persona.');
							}
						}
						else
						{	
						
							if($this->cliente->actualiza($cliente_id, array_to_upper($data_clte)))
							{
								send_json_ok(array('msg' =>'Se actualizado el registro del empleado de forma correcta.', 'id' => $cliente_id));
							}
							else
							{
								send_json_error('Ocurrió un error al actualizar al empleado.');
							}
						}
					}
                }
                else
                {
                    send_json_error(validation_errors('<div />'));
                }
            }
            else 
            {
				//echo "----------->".$cliente['suc_id']."<-----------";
                $this->load->model('empresa/Empresa_model','empresa');
                $data['empresas'] = $this->empresa->trae_empresas();//$this->empresa->get_all_empresas();
				//$data['despachos'] = $this->empresa->get_all_despachos();
				$data['sucursals'] = $this->empresa->get_all_sucursales();
				$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($cliente['emp_id']);
                $data['persona'] = 	$cliente;
				if ($cliente['serv_id'] > 0)
				{
					$data['servicio'] = $servicio;
				}
                $this->load->helper('template');
                $params_view = array(
                    'title' => 'Personas',
                    'view' => 'persona/edit_d',
                    'view_data' => $data
                   );
                render_template($params_view);  
            }
        }
        else 
        {
            show_error('No existe el cliente');
        }
    }

    public function edita_fx($cliente_id)
    {           
		$cliente = $this->cliente->get($cliente_id);
        $card = $this->cliente->get_card($cliente_id);
		if ($cliente['serv_id'] > 0)
		{	
			$servicio = $this->servicio->get($cliente['serv_id']);
		}
		
        if($cliente)
        {

            if(isset($_POST) && count($_POST) > 0)     
            {
                $this->load->library('form_validation');
                $this->form_validation->set_rules('nombre','Nombre','required');
                $this->form_validation->set_rules('paterno','Apellido Paterno','required');
                $this->form_validation->set_rules('materno','Apellido Materno','required');
                $this->form_validation->set_rules('genero','Género','required');

                if($this->form_validation->run())
                {
					$error_edad=0;
                    //informncion general de la pérsona
                    $data_clte['clte_nombre_crypt'] =  trim($this->input->post('nombre'));
                    $data_clte['clte_2_nombre_crypt'] =  trim($this->input->post('nombre_adic'));
                    $data_clte['clte_paterno_crypt'] =  trim($this->input->post('paterno'));
                    $data_clte['clte_materno_crypt'] =  trim($this->input->post('materno'));
					$data_clte['clte_f_nac'] = $this->input->post('fnac');
                    $data_clte['clte_genero_cve'] =  $this->input->post('genero');
                    $data_clte['clte_puesto'] =  $this->input->post('puesto');
					$data_clte['paciente'] =  1;
					$data_clte['num_empleado'] = $this->input->post('nempleado');
					$data_clte['suc_id'] = $this->input->post('sucursal');
					
					//$data_clte_card['card_rcv']= get_1_0_by_si_no($this->input->post('rcv'));
					$data_clte_card['card_diabetes']= get_1_0_by_si_no($this->input->post('diabetes'));
					$data_clte_card['card_displipidemia']= get_1_0_by_si_no($this->input->post('displipidemia'));
					$data_clte_card['card_arterial']= get_1_0_by_si_no($this->input->post('arterial'));
					$data_clte_card['card_sobrepeso']= get_1_0_by_si_no($this->input->post('sobrepeso'));	
					$data_clte_card['card_obesidad']= get_1_0_by_si_no($this->input->post('obesidad'));
					//$data_clte_card['card_sedentarismo']= get_1_0_by_si_no($this->input->post('sedentarismo'));
					$data_clte_card['card_tabaquismo']= get_1_0_by_si_no($this->input->post('tabaquismo'));	
					$data_clte['supervisor'] = $this->input->post('supervisor');
					$data_clte_card['card_observaciones']= $this->input->post('observaciones');	
					
					if ($card)
					{	
						$this->cliente->actualiza_registro_card($cliente_id,array_to_upper($data_clte_card));	
					}
					else
					{
						$data_clte_card['clte_id']=$cliente_id;
						$card=$this->cliente->inserta_card($data_clte_card);
					}	
                  /*  if(!empty($_FILES['foto']['name']))
                    {
                        $this->load->library('upload');
                        $filename = md5(time());
                        $config = array(
                                'upload_path'   => './../../files/fotos/',
                                'overwrite'     => TRUE,
                                'file_name'     => $filename,
                                'allowed_types' => 'png|jpg|jpeg',
                                'max_size'      => '25000'
                        );

                        $this->upload->initialize($config);
                        if ( ! $this->upload->do_upload('foto'))
                        {
                            send_json_error($this->upload->display_errors());
                        }
                        else 
                        {
                            $data = $this->upload->data();
                            $data_clte['clte_path_foto'] = $data['file_name'];
                        }
                    }*/


				
					
					

					if (($data_clte['clte_f_nac'] =='') && ($data_clte['emp_id'] !=152))
					{
						send_json_error('Ocurrió un error, no se registro la FECHA DE NACIMIENTO.');
					}
                    else
					{
/***************** 	QUE EDAD TIENE EL INDIVIDUO ***************************************/

						$edad=trim(str_replace("años","",get_edad($data_clte['clte_f_nac'])));
							
						if ((($edad < 18) || ($edad > 70)) && ($data_clte['emp_id'] !=152))
						{
							$error_edad=1;
						}
/*************************************************************************************/		
						if ( $error_edad ==1 )
						{
							send_json_error('Ocurrio un error, la fecha de nacimiento no proporciona una edad laboral.');
						}
						elseif ($this->input->post('rregistrar') == 'rr')
						{						
							if($this->cliente->actualiza_registro($cliente_id, array_to_upper($data_clte)))
							{
								send_json_ok(array('msg' =>'Se actualizó y registro nuevamente el evaluado de forma correcta', 'id' => $cliente_id));
							}
							else
							{
								send_json_error('Ocurrió un error al actualizar la persona.');
							}
						}
						else
						{						
							if($this->cliente->actualiza($cliente_id, array_to_upper($data_clte)))
							{
								send_json_ok(array('msg' =>'Se actualizado el registro del Paciente de forma correcta.', 'id' => $cliente_id));
							}
							else
							{
								send_json_error('Ocurrió un error al actualizar al Paciente.');
							}
						}
					}
                }
                else
                {
                    send_json_error(validation_errors('<div />'));
                }
            }
            else 
            {
                $data['persona'] = 	$cliente;
				$data['card'] = $card;
				if ($cliente['serv_id'] > 0)
				{
					$data['servicio'] = $servicio;
				}
                $this->load->helper('template');
                $params_view = array(
                    'title' => 'Personas',
                    'view' => 'persona/edit_fx',
                    'view_data' => $data
                   );
                render_template($params_view);  
            }
        }
        else 
        {
            show_error('No existe el cliente');
        }
    }


    public function edita_f($cliente_id)
    {           
		$cliente = $this->cliente->get($cliente_id);
        $card = $this->cliente->get_card($cliente_id);
		if ($cliente['serv_id'] > 0)
		{	
			$servicio = $this->servicio->get($cliente['serv_id']);
		}
		
        if($cliente)
        {

            if(isset($_POST) && count($_POST) > 0)     
            {
                $this->load->library('form_validation');
                $this->form_validation->set_rules('nombre','Nombre','required');
                $this->form_validation->set_rules('paterno','Apellido Paterno','required');
                $this->form_validation->set_rules('materno','Apellido Materno','required');
                /*$this->form_validation->set_rules('fnac','Fecha de nacimiento','required');*/
                $this->form_validation->set_rules('genero','Género','required');
                //$this->form_validation->set_rules('civil','Estado civil','required');
                //$this->form_validation->set_rules('rfc','RFC','required');
                //$this->form_validation->set_rules('curp','CURP','required');

                if($this->form_validation->run())
                {
					$error_edad=0;
                    //informncion general de la pérsona
                    $data_clte['clte_nombre_crypt'] =  trim($this->input->post('nombre'));
                    $data_clte['clte_2_nombre_crypt'] =  trim($this->input->post('nombre_adic'));
                    $data_clte['clte_paterno_crypt'] =  trim($this->input->post('paterno'));
                    $data_clte['clte_materno_crypt'] =  trim($this->input->post('materno'));
					$data_clte['clte_f_nac'] = $this->input->post('fnac');
                    $data_clte['clte_genero_cve'] =  $this->input->post('genero');
                    $data_clte['clte_puesto'] =  $this->input->post('puesto');
					$data_clte['paciente'] =  1;
					$data_clte['num_empleado'] = $this->input->post('nempleado');
					
					//$data_clte_card['card_rcv']= get_1_0_by_si_no($this->input->post('rcv'));
					$data_clte_card['card_diabetes']= get_1_0_by_si_no($this->input->post('diabetes'));
					$data_clte_card['card_displipidemia']= get_1_0_by_si_no($this->input->post('displipidemia'));
					$data_clte_card['card_arterial']= get_1_0_by_si_no($this->input->post('arterial'));
					$data_clte_card['card_sobrepeso']= get_1_0_by_si_no($this->input->post('sobrepeso'));	
					$data_clte_card['card_obesidad']= get_1_0_by_si_no($this->input->post('obesidad'));
					//$data_clte_card['card_sedentarismo']= get_1_0_by_si_no($this->input->post('sedentarismo'));
					$data_clte_card['card_tabaquismo']= get_1_0_by_si_no($this->input->post('tabaquismo'));	
					$data_clte['supervisor'] = $this->input->post('supervisor');
					$data_clte_card['card_observaciones']= $this->input->post('observaciones');	
					
					if ($card)
					{	
						$this->cliente->actualiza_registro_card($cliente_id,array_to_upper($data_clte_card));	
					}
					else
					{
						$data_clte_card['clte_id']=$cliente_id;
						$card=$this->cliente->inserta_card($data_clte_card);
					}	
                  /*  if(!empty($_FILES['foto']['name']))
                    {
                        $this->load->library('upload');
                        $filename = md5(time());
                        $config = array(
                                'upload_path'   => './../../files/fotos/',
                                'overwrite'     => TRUE,
                                'file_name'     => $filename,
                                'allowed_types' => 'png|jpg|jpeg',
                                'max_size'      => '25000'
                        );

                        $this->upload->initialize($config);
                        if ( ! $this->upload->do_upload('foto'))
                        {
                            send_json_error($this->upload->display_errors());
                        }
                        else 
                        {
                            $data = $this->upload->data();
                            $data_clte['clte_path_foto'] = $data['file_name'];
                        }
                    }*/


				
					
					

					if (($data_clte['clte_f_nac'] =='') && ($data_clte['emp_id'] !=152))
					{
						send_json_error('Ocurrió un error, no se registro la FECHA DE NACIMIENTO.');
					}
                    else
					{
/***************** 	QUE EDAD TIENE EL INDIVIDUO ***************************************/

						$edad=trim(str_replace("años","",get_edad($data_clte['clte_f_nac'])));
							
						if ((($edad < 18) || ($edad > 70)) && ($data_clte['emp_id'] !=152))
						{
							$error_edad=1;
						}
/*************************************************************************************/		
						if ( $error_edad ==1 )
						{
							send_json_error('Ocurrio un error, la fecha de nacimiento no proporciona una edad laboral.');
						}
						elseif ($this->input->post('rregistrar') == 'rr')
						{						
							if($this->cliente->actualiza_registro($cliente_id, array_to_upper($data_clte)))
							{
								send_json_ok(array('msg' =>'Se actualizó y registro nuevamente el evaluado de forma correcta', 'id' => $cliente_id));
							}
							else
							{
								send_json_error('Ocurrió un error al actualizar la persona.');
							}
						}
						else
						{						
							if($this->cliente->actualiza($cliente_id, array_to_upper($data_clte)))
							{
								send_json_ok(array('msg' =>'Se actualizado el registro del Paciente de forma correcta.', 'id' => $cliente_id));
							}
							else
							{
								send_json_error('Ocurrió un error al actualizar al Paciente.');
							}
						}
					}
                }
                else
                {
                    send_json_error(validation_errors('<div />'));
                }
            }
            else 
            {
				//echo "----------->".$cliente['suc_id']."<-----------";
                $this->load->model('empresa/Empresa_model','empresa');
                if ($cliente['clte_id'] < 325789 )
				{
					$data['empresas'] = $this->empresa->trae_empresas();
				}	
				else
				{	
					$data['empresas'] = $this->empresa->get_all_empresas_gsi();////$this->empresa->get_all_empresas();
				}
				//$data['despachos'] = $this->empresa->get_all_despachos();
				$data['sucursals'] = $this->empresa->get_all_sucursales();
				$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($cliente['emp_id']);
                $data['persona'] = 	$cliente;
				$data['card'] = $card;
				if ($cliente['serv_id'] > 0)
				{
					$data['servicio'] = $servicio;
				}
                $this->load->helper('template');
                $params_view = array(
                    'title' => 'Personas',
                    'view' => 'persona/edit_f',
                    'view_data' => $data
                   );
                render_template($params_view);  
            }
        }
        else 
        {
            show_error('No existe el cliente');
        }
    }
	
	
 
     public function nuevo_empleado_gsi()
    {    
		$user_root1=get_my_user_root1();
		$user_root3=get_my_user_root3();
		$user_root4=get_my_user_root4();
		$user = $this->session->user; 
		$medico = $this->medico->get($user['usr_id']);
	    //date_default_timezone_set('America/Mexico_City');
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('nombre','Nombre','required');
            $this->form_validation->set_rules('paterno','Apellido Paterno','required');
            $this->form_validation->set_rules('materno','Apellido Materno','required');
            //$this->form_validation->set_rules('fnac','Fecha de nacimiento','required');
            $this->form_validation->set_rules('genero','Género','required');
            //$this->form_validation->set_rules('civil','Estado civil','required');
            //$this->form_validation->set_rules('rfc','RFC','required');           
            //$this->form_validation->set_rules('curp','CURP','required');

            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_nombre_crypt'] =  trim($this->input->post('nombre'));
                $data_clte['clte_2_nombre_crypt'] =  trim($this->input->post('nombre_adic'));
                $data_clte['clte_paterno_crypt'] =  trim($this->input->post('paterno'));
                $data_clte['clte_materno_crypt'] =  trim($this->input->post('materno'));
                
				//$data_clte['clte_f_nac'] = formatea_fecha_mysql($this->input->post('fnac'));
                
				$data_clte['clte_f_nac'] = $this->input->post('fnac');				
				$data_clte['clte_genero_cve'] =  $this->input->post('genero');                				
				$data_clte['clte_rfc_crypt'] =  $this->input->post('rfc');                				
				$data_clte['clte_curp_crypt'] =  $this->input->post('curp');
                
                //dopmcicio de la persona
                $data_clte['clte_env_pais_cve'] =  $this->input->post('pais');
                $data_clte['clte_env_cp'] =  $this->input->post('cp');
                $data_clte['clte_env_edo_cve'] =  $this->input->post('entidad');
                $data_clte['clte_env_colonia_crypt'] =  $this->input->post('colonia');
                $data_clte['clte_env_localidad'] =  $this->input->post('localidad');
                $data_clte['clte_env_municipio'] =  $this->input->post('municipio');
                $data_clte['clte_env_calle_crypt'] =  $this->input->post('calle');
                $data_clte['clte_env_num_ext_crypt'] =  $this->input->post('next');
                $data_clte['clte_env_num_int_crypt'] =  $this->input->post('nint');
                $data_clte['clte_nss_crypt'] =  $this->input->post('nss');
                //informacion de conrtaxcto de la persona
                $data_clte['clte_tel_casa_crypt'] =  limpia_telefono($this->input->post('tel'));                
                $data_clte['clte_cel_crypt'] =  limpia_telefono($this->input->post('cel'));
                $data_clte['clte_email_crypt'] =  $this->input->post('correo');
                
                //nuevos campos
                $data_clte['clte_grado_acad_cve'] =  $this->input->post('grado');
                $data_clte['clte_puesto'] =  $this->input->post('puesto');
                $data_clte['clte_edo_civ_cve'] =  $this->input->post('civil');
                $data_clte['clte_nac_cve'] =  $this->input->post('nac');
				//nuevo campo de ubicacion
                //$data_clte['clte_lab_ubicacion'] =  $this->input->post('ubicacion');
				//$data_clte['clte_reclutador'] =  $this->input->post('reclutador');
  
                //empresa donde va a labora la persona
				$data_clte['emp_id'] =  $this->input->post('empresa');
			    $data_clte['suc_id'] =  $this->input->post('sucursal');
				$data_clte['cei_id'] =  4;
                $data_clte['empleado'] =  1;
				$data_clte['empleado_rol'] =  1;
				
				//examenes
				$data_clte['nomserv'] =  'EXMEPER;';
				

                
                if(!empty($_FILES['foto']['name']))
                {
                    $this->load->library('upload');
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/fotos/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg',
                            'max_size'      => '25000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('foto'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['clte_path_foto'] = $data['file_name'];
                    }
                }
				

				$data_clte=array_to_upper($data_clte);
				$encontrado = $this->cliente->buscate($data_clte['clte_nombre_crypt'], $data_clte['clte_2_nombre_crypt'],  $data_clte['clte_paterno_crypt'],$data_clte['clte_materno_crypt']);
				$diff=61;
				
				$rfc_test=$data_clte['clte_rfc_crypt'];
				
				$encontrado_error_long_rfc=0;
				

				{
					if (strlen($data_clte['clte_rfc_crypt']) < 10)
					{						
						$data_clte['clte_rfc_crypt']=substr($data_clte['clte_paterno_crypt'],0,2).substr($data_clte['clte_materno_crypt'],0,1).substr($data_clte['clte_nombre_crypt'],0,1).substr($data_clte['clte_f_nac'],2,2).substr($data_clte['clte_f_nac'],5,2).substr($data_clte['clte_f_nac'],8,2);
					}
				}

				
				if ($encontrado)
				{
					$unafecha=$encontrado[0]['log_insrt_f'];
					$diff= abs(intval(dateDifference($unafecha,date('Y-m-d'))));

				}
	             
				if (($encontrado) && ( $diff < 20))
				{
					send_json_error('Ocurrió un error, el empleado ya fue empleado en la plataforma en la fecha '.formatea_fecha($unafecha).', hace '.$diff.' días.');
				}
				elseif ($data_clte['emp_id'] ==0)
				{
					send_json_error('Ocurrió un error, no se selecciono la EMPRESA.');
					
				}
				elseif (($data_clte['clte_f_nac'] =='') && ($data_clte['emp_id'] !=152))
				{
					send_json_error('Ocurrió un error, no se registro la FECHA DE NACIMIENTO.');
				}				
				elseif($cliente_id = $this->cliente->inserta(array_to_upper($data_clte)))
                {
                    send_json_ok(array('msg' =>'Se guardó de forma correcta el registro del empleado.', 'id' => $cliente_id));
                }
                else
                {
                    send_json_error('Ocurrió un error al guardar la persona.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
			
            $this->load->model('empresa/Empresa_model','empresa');
			$gss=get_empresas_corporativo('GSI');
			$data['empresas'] =  $this->empresa->get_all_empresas_gss($gss);			
			$data['sucursales'] = $this->empresa->get_all_sucursales_empresas($gss);
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'persona/add_empleado_gsi',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }
 
 
 
     public function nuevo_objeto()
    {    
		$user_root1=get_my_user_root1();
		$user_root3=get_my_user_root3();
		$user_root4=get_my_user_root4();
		$user = $this->session->user; 
		$medico = $this->medico->get($user['usr_id']);
	    //date_default_timezone_set('America/Mexico_City');
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('nombre','Número de Serie','required');
            $this->form_validation->set_rules('nombre_adic','Número de Serie del Motor','required');
			$this->form_validation->set_rules('paterno','Marca','required');
			$this->form_validation->set_rules('materno','Submarca','required');
			$this->form_validation->set_rules('puesto','Modelo (Año)','required');
			$this->form_validation->set_rules('nac','Placa','required');
            $this->form_validation->set_rules('curp','Kilometraje presentado','required');
			$this->form_validation->set_rules('rfc','Tarjeta de Circulación','required');
            $this->form_validation->set_rules('fnac','Fecha de Adquisición','required');
            $this->form_validation->set_rules('genero','Carga Máxima (Toneladas)','required');
			$this->form_validation->set_rules('grado','Combustible','required');
			$this->form_validation->set_rules('reclutador','Número de Cilindros','required');
			$this->form_validation->set_rules('empresa','Empresa','required');


            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_nombre_crypt'] =  trim($this->input->post('nombre'));
                $data_clte['clte_2_nombre_crypt'] =  trim($this->input->post('nombre_adic'));
                $data_clte['clte_paterno_crypt'] =  trim($this->input->post('paterno'));
                $data_clte['clte_materno_crypt'] =  trim($this->input->post('materno'));
                
				$data_clte['clte_f_nac'] = formatea_fecha_mysql($this->input->post('fnac'));
				//$data_clte['clte_f_nac'] = $this->input->post('fnac');
				
				$data_clte['clte_genero_cve'] =  $this->input->post('genero');
                				
				$data_clte['clte_rfc_crypt'] =  $this->input->post('rfc');
                				
				$data_clte['clte_curp_crypt'] =  $this->input->post('curp');
                
                //dopmcicio de la persona
                $data_clte['clte_env_pais_cve'] =  $this->input->post('pais');
                $data_clte['clte_env_cp'] =  $this->input->post('cp');
                $data_clte['clte_env_edo_cve'] =  $this->input->post('entidad');
                $data_clte['clte_env_colonia_crypt'] =  $this->input->post('colonia');
                $data_clte['clte_env_localidad'] =  $this->input->post('localidad');
                $data_clte['clte_env_municipio'] =  $this->input->post('municipio');
                $data_clte['clte_env_calle_crypt'] =  $this->input->post('calle');
                $data_clte['clte_env_num_ext_crypt'] =  $this->input->post('next');
                $data_clte['clte_env_num_int_crypt'] =  $this->input->post('nint');
                $data_clte['clte_nss_crypt'] =  $this->input->post('nss');
                //informacion de conrtaxcto de la persona
                $data_clte['clte_tel_casa_crypt'] =  limpia_telefono($this->input->post('tel'));                
                $data_clte['clte_cel_crypt'] =  limpia_telefono($this->input->post('cel'));
                $data_clte['clte_email_crypt'] =  $this->input->post('correo');
                
                //nuevos campos
                $data_clte['clte_grado_acad_cve'] =  $this->input->post('grado');
                $data_clte['clte_puesto'] =  $this->input->post('puesto');
                $data_clte['clte_edo_civ_cve'] =  $this->input->post('civil');
                $data_clte['clte_nac_cve'] =  $this->input->post('nac');
				//nuevo campo de ubicacion
				
                $data_clte['clte_lab_ubicacion'] =  $this->input->post('ubicacion');
				$data_clte['clte_reclutador'] =  $this->input->post('reclutador');
  
                //empresa donde va a loborar la persona
				
				
                $data_clte['emp_id'] =  $this->input->post('empresa');
				
				if ( $data_clte['emp_id'] != 180)
				{
				$data_clte['desp_id'] =  $this->input->post('despacho');
				if ($data_clte['desp_id'] == 1) 
				{$data_clte['desp_id']=0;}
			    $data_clte['suc_id'] =  $this->input->post('sucursal');
				}
				else
				{
					$data_clte['emp_id'] = 117;
					$data_clte['suc_id'] = 43;
				}	
				
				
				//cei
				if ($this->input->post('empresa') == 16)
				{	
					$data_clte['cei_id'] =  7;
				}
				else 
				{
					if ($this->input->post('empresa') == 31)
					{	
						$data_clte['cei_id'] =  2;
					}
					else
					{
						$data_clte['cei_id'] =  $this->input->post('cei');
					}
				}


				if (valida_corporacion($data_clte['emp_id'],'GSI') === 'GSI')
				{
					
					if ( ($data_clte['cei_id'] !=6) || ($data_clte['cei_id'] !=4))
					{
						$data_clte['cei_id'] = get_cei_id();
					}
					
				}

					if (($user_root3 == 2) && ($user_root4 == 3))
					{
						$data_clte['cei_id'] = get_cei_id();
					}

                $data_clte['desp_id'] =  $this->input->post('despacho');
                $data_clte['clte_reclutador'] =  $this->input->post('reclutador');
				
				//examenes
				
					$nomserv='';

                
                if(!empty($_FILES['foto']['name']))
                {
                    $this->load->library('upload');
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/fotos/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg',
                            'max_size'      => '25000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('foto'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['clte_path_foto'] = $data['file_name'];
                    }
                }

				if ($data_clte['emp_id'] == 194)
				{
					$data_clte['nomserv']='PREVEM;';
				}elseif ($data_clte['emp_id'] == 182)
				{
					$data_clte['nomserv']='FILOA;';
				}elseif ($data_clte['emp_id'] == 193)
				{
					$data_clte['nomserv']='ALLIANZ;';
				} 
				elseif ($data_clte['emp_id'] == 230)
					{
						$data_clte['nomserv'].='AXA;';
					}
				$data_clte['clte_objeto'] =  $this->input->post('objeto');
				$data_clte=array_to_upper($data_clte);
				$encontrado = $this->cliente->buscate($data_clte['clte_nombre_crypt'], $data_clte['clte_2_nombre_crypt'],  $data_clte['clte_paterno_crypt'],$data_clte['clte_materno_crypt']);
				$diff=61;
				
				$rfc_test=$data_clte['clte_rfc_crypt'];
				
				$encontrado_error_long_rfc=0;
				

				{
					if (strlen($data_clte['clte_rfc_crypt']) < 10)
					{						
						$data_clte['clte_rfc_crypt']=substr($data_clte['clte_paterno_crypt'],0,2).substr($data_clte['clte_materno_crypt'],0,1).substr($data_clte['clte_nombre_crypt'],0,1).substr($data_clte['clte_f_nac'],2,2).substr($data_clte['clte_f_nac'],5,2).substr($data_clte['clte_f_nac'],8,2);
					}
				}

				
				if ($encontrado)
				{
					$unafecha=$encontrado[0]['log_insrt_f'];
					$diff= abs(intval(dateDifference($unafecha,date('Y-m-d'))));

				}
	             
				if (($encontrado) && ( $diff < 20))
				{
					send_json_error('Ocurrió un error, el candidato ya fue registrado en la plataforma en la fecha '.formatea_fecha($unafecha).', hace '.$diff.' días.');
				}
				elseif ($data_clte['emp_id'] ==0)
				{
					send_json_error('Ocurrió un error, no se selecciono la EMPRESA.');
					
				}
				elseif($cliente_id = $this->cliente->inserta(array_to_upper($data_clte)))
                {
                    send_json_ok(array('msg' =>'Se guardó de forma correcta el registro del evaluado.', 'id' => $cliente_id));
                }
                else
                {
                    send_json_error('Ocurrió un error al guardar la persona.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
			
            $this->load->model('empresa/Empresa_model','empresa');
			
			
			if ( (strstr($medico['portal'],'CORPO')) && (strstr($medico['modulos'],'EVALOBJ')) )
			{
				$i=0;
				foreach ( explode(';',$medico['empresas'] )  as $esta_empresa) 
				{
					if ($esta_empresa > 0)
					{	
						$gss[$i]=$esta_empresa;
						$i++;
					}
				}	
				$data['empresas'] =  $this->empresa->get_all_empresas_gss($gss);
			}
			elseif (($user_root3 == 2) && ($user_root4 == 3))
			{
				$data['empresas'] = $this->empresa->get_all_empresas_gsi_id();;			
			}
			elseif ($user_root4 == 5)
			{
				$data['empresas'] = $this->empresa->trae_emp_asig($medico['usr_emp_asig']);			
			}
			else
			{
				$data['empresas'] = $this->empresa->trae_empresas();//$this->empresa->get_all_empresas();
			}
			$data['sucursals'] = $this->empresa->get_all_sucursales();
			//$data['despachos'] = $this->empresa->get_all_despachos();
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'persona/add_objeto',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }

 
 
    public function nuevo()
    {   
		
		$user_root1=get_my_user_root1();
		$user_root3=get_my_user_root3();
		$user_root4=get_my_user_root4();
		$user = $this->session->user; 
		$medico = $this->medico->get($user['usr_id']);
		
	    //date_default_timezone_set('America/Mexico_City');
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('nombre','Nombre','required');
            $this->form_validation->set_rules('paterno','Apellido Paterno','required');
            $this->form_validation->set_rules('materno','Apellido Materno','required');
            //$this->form_validation->set_rules('fnac','Fecha de nacimiento','required');
            $this->form_validation->set_rules('genero','Género','required');
			$this->form_validation->set_rules('empresa','Empresa','required');
           // $this->form_validation->set_rules('civil','Estado civil','required');
           // $this->form_validation->set_rules('rfc','RFC','required');           
           //$this->form_validation->set_rules('curp','CURP','required');

            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_nombre_crypt'] =  trim($this->input->post('nombre'));
                $data_clte['clte_2_nombre_crypt'] =  trim($this->input->post('nombre_adic'));
                $data_clte['clte_paterno_crypt'] =  trim($this->input->post('paterno'));
                $data_clte['clte_materno_crypt'] =  trim($this->input->post('materno'));
                
				$data_clte['clte_f_nac'] = formatea_fecha_mysql($this->input->post('fnac'));
				//$data_clte['clte_f_nac'] = $this->input->post('fnac');
				
				$data_clte['clte_genero_cve'] =  $this->input->post('genero');
                				
				$data_clte['clte_rfc_crypt'] =  $this->input->post('rfc');
                				
				$data_clte['clte_curp_crypt'] =  $this->input->post('curp');
                
                //dopmcicio de la persona
                $data_clte['clte_env_pais_cve'] =  $this->input->post('pais');
                $data_clte['clte_env_cp'] =  $this->input->post('cp');
                $data_clte['clte_env_edo_cve'] =  $this->input->post('entidad');
                $data_clte['clte_env_colonia_crypt'] =  $this->input->post('colonia');
                $data_clte['clte_env_localidad'] =  $this->input->post('localidad');
                $data_clte['clte_env_municipio'] =  $this->input->post('municipio');
                $data_clte['clte_env_calle_crypt'] =  $this->input->post('calle');
                $data_clte['clte_env_num_ext_crypt'] =  $this->input->post('next');
                $data_clte['clte_env_num_int_crypt'] =  $this->input->post('nint');
                $data_clte['clte_nss_crypt'] =  $this->input->post('nss');
                //informacion de conrtaxcto de la persona
                $data_clte['clte_tel_casa_crypt'] =  limpia_telefono($this->input->post('tel'));                
                $data_clte['clte_cel_crypt'] =  limpia_telefono($this->input->post('cel'));
                $data_clte['clte_email_crypt'] =  $this->input->post('correo');
                
                //nuevos campos
                $data_clte['clte_grado_acad_cve'] =  $this->input->post('grado');
                $data_clte['clte_puesto'] =  $this->input->post('puesto');
				$data_clte['clte_cat_puesto'] =  $this->input->post('cat_puesto');
                $data_clte['clte_edo_civ_cve'] =  $this->input->post('civil');
                $data_clte['clte_nac_cve'] =  $this->input->post('nac');
				//nuevo campo de ubicacion
				
                $data_clte['clte_lab_ubicacion'] =  $this->input->post('ubicacion');
				$data_clte['clte_reclutador'] =  $this->input->post('reclutador');
  
                //empresa donde va a loborar la persona
				
				
                $data_clte['emp_id'] =  $this->input->post('empresa');
				$emp_id =  $this->input->post('empresa');
				if ( $data_clte['emp_id'] != 180)
				{
				$data_clte['desp_id'] =  $this->input->post('despacho');
				if ($data_clte['desp_id'] == 1) 
				{$data_clte['desp_id']=0;}
			    $data_clte['suc_id'] =  $this->input->post('sucursal');
				}
				else
				{
					$data_clte['emp_id'] = 117;
					$data_clte['suc_id'] = 43;
				}	
				
				
				//cei
				if ($this->input->post('empresa') == 16)
				{	
					$data_clte['cei_id'] =  7;
				}
				else 
				{
					if ($this->input->post('empresa') == 31)
					{	
						$data_clte['cei_id'] =  2;
					}
					else
					{
						$data_clte['cei_id'] =  $this->input->post('cei');
					}
				}


				if (valida_corporacion($data_clte['emp_id'],'GSI') === 'GSI')
				{
					
					if ( ($data_clte['cei_id'] !=6) || ($data_clte['cei_id'] !=4))
					{
						$data_clte['cei_id'] = get_cei_id();
					}
					
				}

					if (($user_root3 == 2) && ($user_root4 == 3))
					{
						$data_clte['cei_id'] = get_cei_id();
					}

                $data_clte['desp_id'] =  $this->input->post('despacho');
                $data_clte['clte_reclutador'] =  $this->input->post('reclutador');
				
				//examenes
				
					$nomserv='';

                
                if(!empty($_FILES['foto']['name']))
                {
                    $this->load->library('upload');
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/fotos/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg',
                            'max_size'      => '25000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('foto'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['clte_path_foto'] = $data['file_name'];
                    }
                }
				
			/*	if ($data_clte['emp_id'] == 152)
				{
					$data_clte['nomserv']='SGMTY;';
				}
				else*/
				if ($data_clte['emp_id'] == 194)
				{
					$data_clte['nomserv']='PREVEM;';
				}elseif ($data_clte['emp_id'] == 182)
				{
					$data_clte['nomserv']='FILOA;';
				}elseif ($data_clte['emp_id'] == 193)
				{
					$data_clte['nomserv']='ALLIANZ;';
				} 
				elseif ($data_clte['emp_id'] == 230)
					{
						$data_clte['nomserv'].='AXA;';
					}

				$data_clte=array_to_upper($data_clte);
				$encontrado = $this->cliente->buscate($data_clte['clte_nombre_crypt'], $data_clte['clte_2_nombre_crypt'],  $data_clte['clte_paterno_crypt'],$data_clte['clte_materno_crypt']);
				$diff=61;
				
				$rfc_test=$data_clte['clte_rfc_crypt'];
				
				$encontrado_error_long_rfc=0;
				

				{
					if (strlen($data_clte['clte_rfc_crypt']) < 10)
					{						
						$data_clte['clte_rfc_crypt']=substr($data_clte['clte_paterno_crypt'],0,2).substr($data_clte['clte_materno_crypt'],0,1).substr($data_clte['clte_nombre_crypt'],0,1).substr($data_clte['clte_f_nac'],2,2).substr($data_clte['clte_f_nac'],5,2).substr($data_clte['clte_f_nac'],8,2);
					}
				}

				
				if ($encontrado)
				{
					$unafecha=$encontrado[0]['log_insrt_f'];
					$diff= abs(intval(dateDifference($unafecha,date('Y-m-d'))));

				}
	             
				if (($encontrado) && ( $diff < 20))
				{
					send_json_error('Ocurrió un error, el candidato ya fue registrado en la plataforma en la fecha '.formatea_fecha($unafecha).', hace '.$diff.' días.');
				}
				elseif ($data_clte['emp_id'] ==0)
				{
					send_json_error('Ocurrió un error, no se selecciono la EMPRESA.');
					
				}
				elseif (($data_clte['clte_f_nac'] =='') && ($data_clte['emp_id'] !=152))
				{
					send_json_error('Ocurrió un error, no se registro la FECHA DE NACIMIENTO.');
				}				
				/*elseif( $encontrado_long_rfc ==1)
				{
					send_json_error('Ocurrió un error, el RFC capturado: "'.$rfc_test.'", debe tener al menos 10 caracteres.');
					
				} elseif($encontrado_rfc)
				{
					send_json_error('Ocurrió un error, el evaluado ya habia sido registrado anterioremente con el ID "'.$encontrado_rfc[0]['clte_id'].'", por favor usar el registro ya establecido.');
				}*/				
				elseif($cliente_id = $this->cliente->inserta(array_to_upper($data_clte)))
                {
                    send_json_ok(array('msg' =>'Se guardó de forma correcta el registro del evaluado.', 'id' => $cliente_id));
					
					//crear orden de servicio
					if (get_emp_osa($emp_id) == 3)
					{
						$ff= $emp_id.'_'.strtoupper(trim($this->input->post('nombre')).'_'.trim($this->input->post('paterno')).'_'.trim($this->input->post('materno'))).'_'.date('YmdHis');
						$data_serv['serv_orden'] = $ff;
						$data_serv['emp_id'] =  $emp_id;
						$data_serv['usr_id'] = $user['usr_id'];
						$data_serv['serv_f_inicio'] = date('Y-m-d H:i:s');						
						$data_serv['serv_f_fin'] = date("Y-m-d H:i:s",strtotime($data_serv['serv_f_inicio']."+ 20 days"));;
						$data_serv['serv_desc'] = "ORDEN DE SERVICIO GENERADA DESDE EL REGISTRO DEL USUARIO";
						$data_serv['serv_ubicacion'] =   $user['cei_id'];
						$data_serv['serv_estatus_cve'] = 'PREORDEN';						 	
						$data_serv['cei_control_id '] = $user['cei_id'];
						$data_serv['cei_id'] = $user['cei_id'];
						$serv_id = $this->servicio->inserta(array_to_upper($data_serv));
						$servicios.=$servicio;
						$data_clte_id['serv_id']=$serv_id;
						$this->cliente->actualiza_registro_individual($cliente_id, $data_clte_id);		
					
					}
					
                }
                else
                {
                    send_json_error('Ocurrió un error al guardar la persona.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
			
            $this->load->model('empresa/Empresa_model','empresa');
	


		if ( (strstr($medico['portal'],'CORPO')) && (strstr($medico['modulos'],'EVALOBJ')) )
		{
			$i=0;
			foreach ( explode(';',$medico['empresas'] )  as $esta_empresa) 
			{
				if ($esta_empresa > 0)
				{	
					$gss[$i]=$esta_empresa;
					$i++;
				}
			}	
			$data['empresas'] =  $this->empresa->get_all_empresas_gss($gss);
		}
		elseif ( strstr($medico['modulos'],'CLINICA') )
		{
			$data['empresas'] = $this->empresa->trae_emp_asig(412);					
		}
		elseif (($user_root3 == 2) && ($user_root4 == 3))
		{
			$data['empresas'] = $this->empresa->get_all_empresas_gsi_id();;			
		}
		elseif ($user_root4 == 5)
		{
			$data['empresas'] = $this->empresa->trae_emp_asig($medico['usr_emp_asig']);			
		}
		else
		{
			$data['empresas'] = $this->empresa->trae_empresas();//$this->empresa->get_all_empresas();
		}
			
		
			$data['sucursals'] = $this->empresa->get_all_sucursales();
			
			//$data['despachos'] = $this->empresa->get_all_despachos();
           
			
			$this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'persona/add',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }

/*************************************************************************************/
    public function nuevo_n()
    {    
	    //date_default_timezone_set('America/Mexico_City');
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('nombre','Nombre','required');
            $this->form_validation->set_rules('paterno','Apellido Paterno','required');
            $this->form_validation->set_rules('materno','Apellido Materno','required');
            $this->form_validation->set_rules('fnac','Fecha de nacimiento','required');
            $this->form_validation->set_rules('genero','Género','required');
           // $this->form_validation->set_rules('civil','Estado civil','required');
            $this->form_validation->set_rules('rfc','RFC','required');
            //
            //$this->form_validation->set_rules('curp','CURP','required');

            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_nombre_crypt'] =  trim($this->input->post('nombre'));
                $data_clte['clte_2_nombre_crypt'] =  trim($this->input->post('nombre_adic'));
                $data_clte['clte_paterno_crypt'] =  trim($this->input->post('paterno'));
                $data_clte['clte_materno_crypt'] =  trim($this->input->post('materno'));
                
				$data_clte['clte_f_nac'] = formatea_fecha_mysql($this->input->post('fnac'));
                $data_clte['clte_genero_cve'] =  $this->input->post('genero');
      				
				$data_clte['clte_rfc_crypt'] =  $this->input->post('rfc');
                				
				$data_clte['clte_curp_crypt'] = ''; // $this->input->post('curp');
                
                //dopmcicio de la persona
                $data_clte['clte_env_pais_cve'] =  $this->input->post('pais');
                $data_clte['clte_env_cp'] =  $this->input->post('cp');
                $data_clte['clte_env_edo_cve'] =  $this->input->post('entidad');
                $data_clte['clte_env_colonia_crypt'] =  $this->input->post('colonia');
                $data_clte['clte_env_localidad'] =  $this->input->post('localidad');
                $data_clte['clte_env_municipio'] =  $this->input->post('municipio');
                $data_clte['clte_env_calle_crypt'] =  $this->input->post('calle');
                $data_clte['clte_env_num_ext_crypt'] =  $this->input->post('next');
                $data_clte['clte_env_num_int_crypt'] =  $this->input->post('nint');
				
                $data_clte['clte_nss_crypt'] = ''; // $this->input->post('nss');
                
				//informacion de conrtaxcto de la persona
                $data_clte['clte_tel_casa_crypt'] =  limpia_telefono($this->input->post('tel'));                
                $data_clte['clte_cel_crypt'] =  limpia_telefono($this->input->post('cel'));
                $data_clte['clte_email_crypt'] =  $this->input->post('correo');
                
                //nuevos campos
                $data_clte['clte_grado_acad_cve'] =  $this->input->post('grado');
                $data_clte['clte_puesto'] =  $this->input->post('puesto');
                $data_clte['clte_edo_civ_cve'] =  $this->input->post('civil');
                $data_clte['clte_nac_cve'] =  $this->input->post('nac');
                
                //empresa donde va a loborar la persona
                $data_clte['emp_id'] = 189 ;  // solo NOVERITE //$this->input->post('empresa');
                
                //nuevo campo de ubicacion
                $data_clte['clte_lab_ubicacion'] = ''; // $this->input->post('ubicacion');

                //despacho
				$data_clte['desp_id']=0;
			    $data_clte['clte_reclutador'] ='';  //$this->input->post('reclutador');
				
				//sucursal
                $data_clte['suc_id'] =0;//$this->input->post('sucursal');
				$data_clte['cei_id'] =  2;
					
					$nomserv='';
					
				
					$data_clte['nomserv'] =  $nomserv;

 /***************************** CARGA DE LA FOTO DEL EVALUADO ************************/               
                if(!empty($_FILES['foto']['name']))
                {
                    $this->load->library('upload');
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/fotos/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg',
                            'max_size'      => '25000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('foto'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['clte_path_foto'] = $data['file_name'];
                    }
                }
/*************************************************************************************/
				$data_clte=array_to_upper($data_clte);
				
				$encontrado = $this->cliente->buscate($data_clte['clte_nombre_crypt'], $data_clte['clte_2_nombre_crypt'],  $data_clte['clte_paterno_crypt'],$data_clte['clte_materno_crypt']);
				$diff=61;
				
				$rfc_test=$data_clte['clte_rfc_crypt'];
				
				$encontrado_error_long_rfc=0;
				
				if (strlen($rfc_test) <10)
				{
					$encontrado_long_rfc=1;
				}
				else
				{
					$rfc_test= substr($rfc_test,0,10);
					$encontrado_rfc = $this->cliente->buscate_rfc($rfc_test,$data_clte['emp_id']);
				}	
			
				
				if ($encontrado)
				{
					$unafecha=$encontrado[0]['log_insrt_f'];
					$diff= abs(intval(dateDifference($unafecha,date('Y-m-d'))));

				}
	             
				if (($encontrado) && ( $diff < 20))
				{
					send_json_error('Ocurrió un error, el candidato ya fue registrado en la plataforma en la fecha '.formatea_fecha($unafecha).', hace '.$diff.' días.');
				}
				elseif( $encontrado_long_rfc ==1)
				{
					send_json_error('Ocurrió un error, el RFC capturado: "'.$rfc_test.'", debe tener al menos 10 caracteres.');
					
				}elseif($encontrado_rfc)
				{
					send_json_error('Ocurrió un error, el evaluado ya habia sido registrado anterioremente con el ID "'.$encontrado_rfc[0]['clte_id'].'", por favor usar el registro ya establecido.');
				}
				elseif($cliente_id = $this->cliente->inserta(array_to_upper($data_clte)))
                {
                    send_json_ok(array('msg' =>'Se guardó de forma correcta', 'id' => $cliente_id));
                    
                }
                else
                {
                    send_json_error('Ocurrió un error al guardar la persona.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $this->load->model('empresa/Empresa_model','empresa');
            $data['empresas'] = $this->empresa->get_all_empresas();
			$data['sucursals'] = $this->empresa->get_all_sucursales();
			//$data['despachos'] = $this->empresa->get_all_despachos();
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'persona/add_n',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }


/*************************************************************************************/
    public function nuevo_any()
    {   $user = $this->session->user; 
		$usuario = $this->medico->get($user['usr_id']);	
		$flag_empresa=0;
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('nombre','Nombre','required');
            $this->form_validation->set_rules('paterno','Apellido Paterno','required');
            $this->form_validation->set_rules('materno','Apellido Materno','required');
            $this->form_validation->set_rules('fnac','Fecha de nacimiento','required');
			$this->form_validation->set_rules('nac','Lugar de nacimiento','required');
            $this->form_validation->set_rules('genero','Género','required');
            $this->form_validation->set_rules('civil','Estado civil','required');
            $this->form_validation->set_rules('rfc','RFC','required');
			$this->form_validation->set_rules('grado','Grado académico','required');
			$this->form_validation->set_rules('empresa','Empresa GSI','required');
			$this->form_validation->set_rules('puesto','Puesto','required');
		//	$this->form_validation->set_rules('centro_costo','Centro de Costos','required');
			$this->form_validation->set_rules('pais','País','required');
			$this->form_validation->set_rules('cp','Código Postal','required');
			$this->form_validation->set_rules('entidad','Estado','required');
			$this->form_validation->set_rules('colonia','Colonia','required');
			$this->form_validation->set_rules('localidad','Localidad','required');
			$this->form_validation->set_rules('municipio','Alcadía ó Municipio','required');
			$this->form_validation->set_rules('calle','Calle','required');
			$this->form_validation->set_rules('next','N° exterior','required');
		/*	$this->form_validation->set_rules('tel','Tel. de casa','required');*/
			$this->form_validation->set_rules('cel','Tel. celular','required');
		/*	$this->form_validation->set_rules('correo','Correo electrónico','required');
		*/

            if($this->form_validation->run())
            {
                $data_clte['clte_nombre_crypt'] =  trim($this->input->post('nombre'));
                $data_clte['clte_2_nombre_crypt'] =  trim($this->input->post('nombre_adic'));
                $data_clte['clte_paterno_crypt'] =  trim($this->input->post('paterno'));
                $data_clte['clte_materno_crypt'] =  trim($this->input->post('materno'));
				$data_clte['clte_f_nac'] = formatea_fecha_mysql($this->input->post('fnac'));			
				$data_clte['clte_nac_cve'] = $this->input->post('nac');
				$data_clte['clte_genero_cve'] =  $this->input->post('genero');  
				$data_clte['clte_edo_civ_cve'] =  $this->input->post('civil');
				$data_clte['clte_rfc_crypt'] =  $this->input->post('rfc');
				
				
				
				
				
				if (strlen($data_clte['clte_rfc_crypt']) < 10)
				{						
					$data_clte['clte_rfc_crypt']=substr($data_clte['clte_paterno_crypt'],0,2).substr($data_clte['clte_materno_crypt'],0,1).substr($data_clte['clte_nombre_crypt'],0,1).substr($data_clte['clte_f_nac'],2,2).substr($data_clte['clte_f_nac'],5,2).substr($data_clte['clte_f_nac'],8,2);
				}
				$data_clte['clte_grado_acad_cve'] =  $this->input->post('grado');
				$data_clte['clte_nac_cve'] =  $this->input->post('nac');
			
				$data_clte['emp_id'] = $this->input->post('empresa'); 
				$emp_id= $this->input->post('empresa'); 
				
				if  (
					($data_clte['emp_id'] != 49) &&
					($data_clte['emp_id']!= 132) &&
					($data_clte['emp_id'] != 218) &&
					($data_clte['emp_id'] != 92) &&
					($data_clte['emp_id'] != 204) &&
					($data_clte['emp_id'] != 117) &&
					($data_clte['emp_id'] != 223) &&
					($data_clte['emp_id'] != 196) &&
					($data_clte['emp_id']!= 94) &&
					($data_clte['emp_id']!= 360) && 
					($data_clte['emp_id']!= 321) && 
					($data_clte['emp_id'] != 30) 			
				)
				{					
					$data_clte['suc_id'] =$this->input->post('sucursal');	
					
					if ($data_clte['suc_id'] == 0)
					{						
						$data_clte['suc_id'] =$usuario['suc_id'];
					}
				}
				else
				{					
					if ($data_clte['emp_id'] == 49) { $la_sucursal= $this->input->post('sucursal_tameme');}
					elseif ($data_clte['emp_id'] == 132) { $la_sucursal= $this->input->post('sucursal_sepsa');}	
					elseif ($data_clte['emp_id'] == 218) { $la_sucursal= $this->input->post('sucursal_sepsacv');}	
					elseif ($data_clte['emp_id'] == 204) { $la_sucursal= $this->input->post('sucursal_regio');}
					elseif ($data_clte['emp_id'] == 92) { $la_sucursal= $this->input->post('sucursal_seguritec');}	
					elseif ($data_clte['emp_id'] == 117) { $la_sucursal= $this->input->post('sucursal_gsisp');}		
					elseif ($data_clte['emp_id'] == 223) { $la_sucursal= $this->input->post('sucursal_fabril');}		
					elseif ($data_clte['emp_id'] == 196) { $la_sucursal= $this->input->post('sucursal_mercurio');}		
					elseif ($data_clte['emp_id'] == 94) { $la_sucursal= $this->input->post('sucursal_tecnoval');}		
					elseif ($data_clte['emp_id'] == $usuario['emp_id']) { $la_sucursal= $this->input->post('sucursal_sps');}	
					else { $la_sucursal= $this->input->post('sucursal_cometra');}		
					
					if ($la_sucursal > 0)
					{	
						$data_clte['suc_id'] =$la_sucursal;				
					}
				}	
			

				$data_clte['clte_puesto'] =  $this->input->post('puesto');
				$data_clte['clte_centro_costo'] =  $this->input->post('centro_costo');
                $data_clte['clte_env_pais_cve'] =  $this->input->post('pais');
                $data_clte['clte_env_cp'] =  $this->input->post('cp');
                $data_clte['clte_env_edo_cve'] =  $this->input->post('entidad');
                $data_clte['clte_env_colonia_crypt'] =  $this->input->post('colonia');
                $data_clte['clte_env_localidad'] =  $this->input->post('localidad');
                $data_clte['clte_env_municipio'] =  $this->input->post('municipio');
                $data_clte['clte_env_calle_crypt'] =  $this->input->post('calle');
                $data_clte['clte_env_num_ext_crypt'] =  $this->input->post('next');
                $data_clte['clte_env_num_int_crypt'] =  $this->input->post('nint');
                $data_clte['clte_tel_casa_crypt'] =  limpia_telefono($this->input->post('tel'));                
                $data_clte['clte_cel_crypt'] =  limpia_telefono($this->input->post('cel'));
                $data_clte['clte_email_crypt'] =  $this->input->post('correo');
				$data_clte['clte_reclutador'] = $this->input->post('reclutador');
				
				
				if (strstr($usuario['acciones'],'SBORJA+'))
				{
					$data_clte['cei_id'] = 2;
				}
				else
				{	
					$data_clte['cei_id'] =  get_cei_id();								
				}
				


				if  (
					($data_clte['emp_id'] != 49) &&
					($data_clte['emp_id']!= 132) &&
					($data_clte['emp_id'] != 218) &&
					($data_clte['emp_id'] != 92) &&
					($data_clte['emp_id'] != 204) &&
					($data_clte['emp_id'] != 117) &&
					($data_clte['emp_id'] != 223) &&
					($data_clte['emp_id'] != 196) &&
					($data_clte['emp_id']!= 94) &&
					($data_clte['emp_id']!= 360) &&
					($data_clte['emp_id'] != 30) 			
				)
				{					
					$data_clte['nomserv'] ="";					
				}
				else
				{					
					$data_clte['nomserv'] ='ACRED;GPOSAN;FSM0105;MEDFIS;CED;PSIC;H0N3;SSESTSOC;TOXI;';
				}
				
				
				
              
			  
			  
                if(!empty($_FILES['foto']['name']))
                {
                    $this->load->library('upload');
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/fotos/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg',
                            'max_size'      => '25000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('foto'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['clte_path_foto'] = $data['file_name'];
                    }
                }
				
				$data_clte=array_to_upper($data_clte);

				if ($flag_empresa==1)
				{
					send_json_error('No se ha elegido la empresa.');
				}	
				elseif($cliente_id = $this->cliente->inserta(array_to_upper($data_clte)))
                {
                    send_json_ok(array('msg' =>'Se registro de forma correcta', 'id' => $cliente_id));
					
					//crear orden de servicio
					if (get_emp_osa($emp_id) == 3)
					{
						$ff= $emp_id.'_'.strtoupper(trim($this->input->post('nombre')).'_'.trim($this->input->post('paterno')).'_'.trim($this->input->post('materno'))).'_'.date('YmdHis');
						$data_serv['serv_orden'] = $ff;
						$data_serv['emp_id'] =  $emp_id;
						$data_serv['usr_id'] = $user['usr_id'];
						$data_serv['serv_f_inicio'] = date('Y-m-d H:i:s');						
						$data_serv['serv_f_fin'] = date("Y-m-d H:i:s",strtotime($data_serv['serv_f_inicio']."+ 20 days"));;
						$data_serv['serv_desc'] = "ORDEN DE SERVICIO GENERADA DESDE EL REGISTRO DEL USUARIO";
						$data_serv['serv_ubicacion'] =   $user['cei_id'];
						$data_serv['serv_estatus_cve'] = 'PREORDEN';						 	
						$data_serv['cei_control_id '] = $user['cei_id'];
						$data_serv['cei_id'] = $user['cei_id'];
						$serv_id = $this->servicio->inserta(array_to_upper($data_serv));
						$servicios.=$servicio;
						$data_clte_id['serv_id']=$serv_id;
						$this->cliente->actualiza_registro_individual($cliente_id, $data_clte_id);						
					}
                }
                else
                {
                    send_json_error('Ocurrió un error al guardar la persona.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $this->load->model('empresa/Empresa_model','empresa');
            
			$data['sucursals'] = $this->empresa->get_all_sucursales();
	
			if (($user['usr_id'] == 589) || ($user['usr_id'] == 590) || ($user['usr_id'] == 591))
			{
				$data['empresas'] = $this->empresa->get_all_empresas_subcorp('GSI', 'GSS');	
			}
			elseif ($user['usr_id'] == 510) 
			{		
				$data['empresas'] = $this->empresa->get_all_empresas_subcorp('GSI', 'COMETRA');	
			}elseif (($user['emp_id'] == 126) || ($user['usr_id'] == 701))
			{
				$data['empresas'] = $this->empresa->get_all_empresas_gsi();
			}
			else
			{
				$data['empresas'] = $this->empresa->get_all_empresas();
			}
			
			$data['sucursal_tecnoval']=$this->empresa->get_all_sucursales_empresas(94); 
			$data['sucursal_cometra']=$this->empresa->get_all_sucursales_empresas(30); 
			$data['sucursal_mercurio']=$this->empresa->get_all_sucursales_empresas(196); 
			$data['sucursal_fabril']=$this->empresa->get_all_sucursales_empresas(223); 
			$data['sucursal_gsisp']=$this->empresa->get_all_sucursales_empresas(117); 
			$data['sucursal_regio']=$this->empresa->get_all_sucursales_empresas(204); 
			$data['sucursal_seguritec']=$this->empresa->get_all_sucursales_empresas(92); 
			$data['sucursal_sepsacv']=$this->empresa->get_all_sucursales_empresas(218);
			$data['sucursal_sepsa']=$this->empresa->get_all_sucursales_empresas(132);
			$data['sucursal_tameme']=$this->empresa->get_all_sucursales_empresas(49);
			
			$data['sucursal_sps']=$this->empresa->get_all_sucursales_empresas($usuario['emp_id']);
			
			if ( strstr($usuario['portal'],'EMPSGSI') )
			{	
				if ( strstr($usuario['empresas'],'TGSI') )
				{
					$data['empresas'] = $this->empresa->get_all_empresas_gsi_id();	
					$data['c_empresas'] = 0; 
				}
				else
				{
					$i=0;
					foreach ( explode(';',$usuario['empresas'] )  as $esta_empresa) 
					{
						if ($esta_empresa > 0)
						{	
							$gss[$i]=$esta_empresa;
							$i++;
						}
					}	
					$data['empresas'] =  $this->empresa->get_all_empresas_gss($gss);
					$data['c_empresas'] = $i; 
					$data['la_empresa']=$gss[$i];
				}	
			
			}

			$this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'persona/add_any',
                'view_data' => $data
               );
			   
            render_template($params_view);  
        }
    }	
/*************************************************************************************/

/*************************************************************************************/
    public function nuevo_gsi()
    {   $user = $this->session->user; 
		$usuario = $this->medico->get($user['usr_id']);	
		$flag_empresa=0;
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('nombre','Nombre','required');
            $this->form_validation->set_rules('paterno','Apellido Paterno','required');
            $this->form_validation->set_rules('materno','Apellido Materno','required');
            $this->form_validation->set_rules('fnac','Fecha de nacimiento','required');
			$this->form_validation->set_rules('nac','Lugar de nacimiento','required');
            $this->form_validation->set_rules('genero','Género','required');
            $this->form_validation->set_rules('civil','Estado civil','required');
            $this->form_validation->set_rules('rfc','RFC','required');
			$this->form_validation->set_rules('grado','Grado académico','required');
			$this->form_validation->set_rules('empresa','Empresa GSI','required');
			$this->form_validation->set_rules('puesto','Puesto','required');
			$this->form_validation->set_rules('centro_costo','Centro de Costos','required');
			$this->form_validation->set_rules('pais','País','required');
			$this->form_validation->set_rules('cp','Código Postal','required');
			$this->form_validation->set_rules('entidad','Estado','required');
			$this->form_validation->set_rules('colonia','Colonia','required');
			$this->form_validation->set_rules('localidad','Localidad','required');
			$this->form_validation->set_rules('municipio','Alcadía ó Municipio','required');
			$this->form_validation->set_rules('calle','Calle','required');
			$this->form_validation->set_rules('next','N° exterior','required');
		/*	$this->form_validation->set_rules('tel','Tel. de casa','required');*/
			$this->form_validation->set_rules('cel','Tel. celular','required');
		/*	$this->form_validation->set_rules('correo','Correo electrónico','required');
		*/

            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_nombre_crypt'] =  trim($this->input->post('nombre'));
                $data_clte['clte_2_nombre_crypt'] =  trim($this->input->post('nombre_adic'));
                $data_clte['clte_paterno_crypt'] =  trim($this->input->post('paterno'));
                $data_clte['clte_materno_crypt'] =  trim($this->input->post('materno'));
				$data_clte['clte_f_nac'] = $this->input->post('fnac'); //formatea_fecha_mysql($this->input->post('fnac'));			
				$data_clte['clte_nac_cve'] = $this->input->post('nac');
				$data_clte['clte_genero_cve'] =  $this->input->post('genero');  
				$data_clte['clte_edo_civ_cve'] =  $this->input->post('civil');
				$data_clte['clte_rfc_crypt'] =  $this->input->post('rfc');
				if (strlen($data_clte['clte_rfc_crypt']) < 10)
				{						
					$data_clte['clte_rfc_crypt']=substr($data_clte['clte_paterno_crypt'],0,2).substr($data_clte['clte_materno_crypt'],0,1).substr($data_clte['clte_nombre_crypt'],0,1).substr($data_clte['clte_f_nac'],2,2).substr($data_clte['clte_f_nac'],5,2).substr($data_clte['clte_f_nac'],8,2);
				}
				$data_clte['clte_grado_acad_cve'] =  $this->input->post('grado');
				$data_clte['clte_nac_cve'] =  $this->input->post('nac');
			
				$data_clte['emp_id'] = $this->input->post('empresa'); 
			
				if  (
					($data_clte['emp_id'] != 49) &&
					($data_clte['emp_id']!= 132) &&
					($data_clte['emp_id'] != 218) &&
					($data_clte['emp_id'] != 92) &&
					($data_clte['emp_id'] != 204) &&
					($data_clte['emp_id'] != 117) &&
					($data_clte['emp_id'] != 223) &&
					($data_clte['emp_id'] != 196) &&
					($data_clte['emp_id']!= 94) &&
					($data_clte['emp_id'] != 30) 			
				)
				{
					
					$data_clte['suc_id'] =$this->input->post('sucursal');	
				}
				else
				{					
					if ($data_clte['emp_id'] == 49) { $la_sucursal= $this->input->post('sucursal_tameme');}
					elseif ($data_clte['emp_id'] == 132) { $la_sucursal= $this->input->post('sucursal_sepsa');}	
					elseif ($data_clte['emp_id'] == 218) { $la_sucursal= $this->input->post('sucursal_sepsacv');}	
					elseif ($data_clte['emp_id'] == 204) { $la_sucursal= $this->input->post('sucursal_regio');}
					elseif ($data_clte['emp_id'] == 92) { $la_sucursal= $this->input->post('sucursal_seguritec');}	
					elseif ($data_clte['emp_id'] == 117) { $la_sucursal= $this->input->post('sucursal_gsisp');}		
					elseif ($data_clte['emp_id'] == 223) { $la_sucursal= $this->input->post('sucursal_fabril');}		
					elseif ($data_clte['emp_id'] == 196) { $la_sucursal= $this->input->post('sucursal_mercurio');}		
					elseif ($data_clte['emp_id'] == 94) { $la_sucursal= $this->input->post('sucursal_tecnoval');}		
					else { $la_sucursal= $this->input->post('sucursal_cometra');}		
					$data_clte['suc_id'] =$la_sucursal;				
				}	
			
/*				
				if ($data_clte['emp_id'] == '')
				{
					$flag_empresa=1;
				}
*/
				$data_clte['clte_puesto'] =  $this->input->post('puesto');
				$data_clte['clte_centro_costo'] =  $this->input->post('centro_costo');
                $data_clte['clte_env_pais_cve'] =  $this->input->post('pais');
                $data_clte['clte_env_cp'] =  $this->input->post('cp');
                $data_clte['clte_env_edo_cve'] =  $this->input->post('entidad');
                $data_clte['clte_env_colonia_crypt'] =  $this->input->post('colonia');
                $data_clte['clte_env_localidad'] =  $this->input->post('localidad');
                $data_clte['clte_env_municipio'] =  $this->input->post('municipio');
                $data_clte['clte_env_calle_crypt'] =  $this->input->post('calle');
                $data_clte['clte_env_num_ext_crypt'] =  $this->input->post('next');
                $data_clte['clte_env_num_int_crypt'] =  $this->input->post('nint');
                $data_clte['clte_tel_casa_crypt'] =  limpia_telefono($this->input->post('tel'));                
                $data_clte['clte_cel_crypt'] =  limpia_telefono($this->input->post('cel'));
                $data_clte['clte_email_crypt'] =  $this->input->post('correo');
				$data_clte['clte_reclutador'] = $this->input->post('reclutador');
				
				
				if (strstr($usuario['acciones'],'SBORJA+'))
				{
					$data_clte['cei_id'] = 2;
				}
				else
				{	
					$data_clte['cei_id'] =  get_cei_id();								
				}
				
				$nomserv='';				
				$data_clte['nomserv'] =  $nomserv;

				
                //campos, muertos
					//$data_clte['clte_lab_ubicacion'] = ''; 
					//$data_clte['desp_id']=$this->input->post('despacho');
				
				//sucursal
			/*	if ( ($user['usr_id'] == 736 ) || ($user['usr_id'] == 737 ) )
				{
					$data_clte['suc_id'] =$user['suc_id'];
				}	
				elseif   ($user['suc_id'] >0 )
				{
					$data_clte['suc_id'] =$this->input->post('sucursal');
				}
				else
				{
					$data_clte['suc_id'] =0;
				}	
				*/
				
				

 /***************************** CARGA DE LA FOTO DEL EVALUADO ************************/               
                if(!empty($_FILES['foto']['name']))
                {
                    $this->load->library('upload');
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/fotos/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg',
                            'max_size'      => '25000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('foto'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['clte_path_foto'] = $data['file_name'];
                    }
                }
/*************************************************************************************/
				
				$data_clte=array_to_upper($data_clte);

				
				
				if ($flag_empresa==1)
				{
					send_json_error('No se ha elegido la empresa.');
				}	
				elseif($cliente_id = $this->cliente->inserta(array_to_upper($data_clte)))
                {
                    send_json_ok(array('msg' =>'Se registro de forma correcta', 'id' => $cliente_id));
                    
                }
                else
                {
                    send_json_error('Ocurrió un error al guardar la persona.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $this->load->model('empresa/Empresa_model','empresa');
            
			$data['sucursals'] = $this->empresa->get_all_sucursales();
			//$data['despachos'] = $this->empresa->get_all_empresas_gsi();// $this->empresa->get_all_despachos();
            /*
			if (($user['usr_id'] == 736) || ($user['usr_id'] == 737))
			{
				$data['empresas'] = $this->empresa->get_all_empresas_subcorp('GSI', 'GSS');	
			}
			else
			*/	
			if (($user['usr_id'] == 589) || ($user['usr_id'] == 590) || ($user['usr_id'] == 591))
			{
				$data['empresas'] = $this->empresa->get_all_empresas_subcorp('GSI', 'GSS');	
			}
			elseif ($user['usr_id'] == 510) 
			{		
				$data['empresas'] = $this->empresa->get_all_empresas_subcorp('GSI', 'COMETRA');	
			}elseif (($user['emp_id'] == 126) || ($user['usr_id'] == 701))
			{
				$data['empresas'] = $this->empresa->get_all_empresas_gsi();
			}
			else
			{
				$data['empresas'] = $this->empresa->get_all_empresas();
			}
			
			$data['sucursal_tecnoval']=$this->empresa->get_all_sucursales_empresas(94); 
			$data['sucursal_cometra']=$this->empresa->get_all_sucursales_empresas(30); 
			$data['sucursal_mercurio']=$this->empresa->get_all_sucursales_empresas(196); 
			$data['sucursal_fabril']=$this->empresa->get_all_sucursales_empresas(223); 
			$data['sucursal_gsisp']=$this->empresa->get_all_sucursales_empresas(117); 
			$data['sucursal_regio']=$this->empresa->get_all_sucursales_empresas(204); 
			$data['sucursal_seguritec']=$this->empresa->get_all_sucursales_empresas(92); 
			$data['sucursal_sepsacv']=$this->empresa->get_all_sucursales_empresas(218);
			$data['sucursal_sepsa']=$this->empresa->get_all_sucursales_empresas(132);
			$data['sucursal_tameme']=$this->empresa->get_all_sucursales_empresas(49);
			
			if ( strstr($usuario['portal'],'EMPSGSI') )
			{	
				if ( strstr($usuario['empresas'],'TGSI') )
				{
					$data['empresas'] = $this->empresa->get_all_empresas_gsi_id();	
					$data['c_empresas'] = 0; 
				}
				else
				{
					$i=0;
					foreach ( explode(';',$usuario['empresas'] )  as $esta_empresa) 
					{
						if ($esta_empresa > 0)
						{	
							$gss[$i]=$esta_empresa;
							$i++;
						}
					}	
					$data['empresas'] =  $this->empresa->get_all_empresas_gss($gss);
					$data['c_empresas'] = $i; 
					$data['la_empresa']=$gss[$i];
				}	
			
			}
			
			
			
			$this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'persona/add_gsi',
                'view_data' => $data
               );
			   
            render_template($params_view);  
        }
    }	
/*************************************************************************************/
    public function edita_nuevo_evaluado($cliente_id)
    {    
		$user = $this->session->user;
		$cliente = $this->cliente->get($cliente_id);
		$empresa=$cliente['emp_id'];
		$flag_empresa=0;
		
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('nombre','Nombre','required');
            $this->form_validation->set_rules('paterno','Apellido Paterno','required');
            $this->form_validation->set_rules('materno','Apellido Materno','required');
            $this->form_validation->set_rules('fnac','Fecha de nacimiento','required');
            $this->form_validation->set_rules('genero','Género','required');
            //$this->form_validation->set_rules('civil','Estado civil','required');
            //$this->form_validation->set_rules('rfc','RFC','required');
            //
            //$this->form_validation->set_rules('curp','CURP','required');

            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_nombre_crypt'] =  trim($this->input->post('nombre'));
                $data_clte['clte_2_nombre_crypt'] =  trim($this->input->post('nombre_adic'));
                $data_clte['clte_paterno_crypt'] =  trim($this->input->post('paterno'));
                $data_clte['clte_materno_crypt'] =  trim($this->input->post('materno'));
                
				$data_clte['clte_f_nac'] = formatea_fecha_mysql($this->input->post('fnac'));
                $data_clte['clte_genero_cve'] =  $this->input->post('genero');
      				
				$data_clte['clte_rfc_crypt'] =  $this->input->post('rfc');
                

				if (strlen($data_clte['clte_rfc_crypt']) < 10)
				{						
					$data_clte['clte_rfc_crypt']=substr($data_clte['clte_paterno_crypt'],0,2).substr($data_clte['clte_materno_crypt'],0,1).substr($data_clte['clte_nombre_crypt'],0,1).substr($data_clte['clte_f_nac'],2,2).substr($data_clte['clte_f_nac'],5,2).substr($data_clte['clte_f_nac'],8,2);
				}
				
				$data_clte['clte_curp_crypt'] = ''; // $this->input->post('curp');
                
                //dopmcicio de la persona
                $data_clte['clte_env_pais_cve'] =  $this->input->post('pais');
                $data_clte['clte_env_cp'] =  $this->input->post('cp');
                $data_clte['clte_env_edo_cve'] =  $this->input->post('entidad');
                $data_clte['clte_env_colonia_crypt'] =  $this->input->post('colonia');
                $data_clte['clte_env_localidad'] =  $this->input->post('localidad');
                $data_clte['clte_env_municipio'] =  $this->input->post('municipio');
                $data_clte['clte_env_calle_crypt'] =  $this->input->post('calle');
                $data_clte['clte_env_num_ext_crypt'] =  $this->input->post('next');
                $data_clte['clte_env_num_int_crypt'] =  $this->input->post('nint');
				 
				//informacion de conrtaxcto de la persona
                $data_clte['clte_tel_casa_crypt'] =  limpia_telefono($this->input->post('tel'));                
                $data_clte['clte_cel_crypt'] =  limpia_telefono($this->input->post('cel'));
                $data_clte['clte_email_crypt'] =  $this->input->post('correo');
                
                //nuevos campos
                $data_clte['clte_grado_acad_cve'] =  $this->input->post('grado');
                $data_clte['clte_puesto'] =  $this->input->post('puesto');
                $data_clte['clte_edo_civ_cve'] =  $this->input->post('civil');
                $data_clte['clte_nac_cve'] =  $this->input->post('nac');
/************************/ 
				$data_clte['clte_nss_crypt'] =  $this->input->post('nss');
				$data_clte['clte_accidente_av'] =  $this->input->post('accidente_av'); 					
				$data_clte['clte_parentesco_av'] =  $this->input->post('parentesco_av'); 					
				$data_clte['clte_telefono_av'] =  $this->input->post('telefono_av');					
				$data_clte['area_depto']  =  $this->input->post('area_depto');	
				$data_clte['clte_clinica_imss'] =  $this->input->post('clinica_imss'); 					
				$data_clte['clte_no_consultorio'] =  $this->input->post('no_consultorio');		
				$data_clte['clte_turno'] =  $this->input->post('turno');		
				$data_clte['clte_f_consulta'] =  formatea_fecha_mysql($this->input->post('f_consulta')); 
/***************************/
 

				$data_clte['emp_id'] = $this->input->post('empresa'); 

				if ($data_clte['emp_id'] == '')
				{
					$flag_empresa=1;
				}
	

				$data_clte['cei_id'] =  get_cei_id();
				
				
				if ($data_clte['emp_id'] == 293)
				{	
					$nomserv='ISOEXMEDINEX;FEHS034;NORDICOG;FEHS035;CARATULA;ISOEXI;';
				}
				else
				{	
					$nomserv='ISOEXI;';
				}
				$data_clte['nomserv'] =  $nomserv;
			
 /***************************** CARGA DE LA FOTO DEL EVALUADO ************************/               
                if(!empty($_FILES['foto']['name']))
                {
                    $this->load->library('upload');
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/fotos/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg',
                            'max_size'      => '25000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('foto'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['clte_path_foto'] = $data['file_name'];
                    }
                }
/*************************************************************************************/
				
				

				
				
				if($this->cliente->actualiza_registro($cliente_id, array_to_upper($data_clte)))
                {
                    send_json_ok(array('msg' =>'El registro se ha actualizado', 'id' => $cliente_id));
                    
                }
                else
                {
                    send_json_error('Ocurrió un error al guardae el registro.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
				$this->load->model('empresa/Empresa_model','empresa');

				$data['sucursals'] = $this->empresa->get_all_sucursales($empresa);
				$data['consultorios'] = $this->empresa->get_lista_consultorios();
                $data['persona'] = 	$cliente;
				$data['worker'] = 	$worker;
				$data['worker_usr'] = 	$worker_usr;				
				if ($cliente['serv_id'] > 0)
				{
					$data['servicio'] = $servicio;
				}
				$this->load->helper('template');
				$data['usuario'] = $this->medico->get($user['usr_id']);	
				$params_view = array
			(
                'title' => 'Personas pwd',
                'view' => 'persona/add_new_evaluado',
                'view_data' => $data
               );
			   
            render_template($params_view);  
        }
    }



/*************************************************************************************/
    public function nuevo_evaluado()
    {   $user = $this->session->user; 
		$flag_empresa=0;
		
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('nombre','Nombre','required');
            $this->form_validation->set_rules('paterno','Apellido Paterno','required');
            $this->form_validation->set_rules('materno','Apellido Materno','required');
            $this->form_validation->set_rules('fnac','Fecha de nacimiento','required');
            $this->form_validation->set_rules('genero','Género','required');
            //$this->form_validation->set_rules('civil','Estado civil','required');
            //$this->form_validation->set_rules('rfc','RFC','required');
            //
            //$this->form_validation->set_rules('curp','CURP','required');

            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_nombre_crypt'] =  trim($this->input->post('nombre'));
                $data_clte['clte_2_nombre_crypt'] =  trim($this->input->post('nombre_adic'));
                $data_clte['clte_paterno_crypt'] =  trim($this->input->post('paterno'));
                $data_clte['clte_materno_crypt'] =  trim($this->input->post('materno'));
                
				$data_clte['clte_f_nac'] = formatea_fecha_mysql($this->input->post('fnac'));
                $data_clte['clte_genero_cve'] =  $this->input->post('genero');
      				
				$data_clte['clte_rfc_crypt'] =  $this->input->post('rfc');
                

				if (strlen($data_clte['clte_rfc_crypt']) < 10)
				{						
					$data_clte['clte_rfc_crypt']=substr($data_clte['clte_paterno_crypt'],0,2).substr($data_clte['clte_materno_crypt'],0,1).substr($data_clte['clte_nombre_crypt'],0,1).substr($data_clte['clte_f_nac'],2,2).substr($data_clte['clte_f_nac'],5,2).substr($data_clte['clte_f_nac'],8,2);
				}
				
				$data_clte['clte_curp_crypt'] = ''; // $this->input->post('curp');
                
                //dopmcicio de la persona
                $data_clte['clte_env_pais_cve'] =  $this->input->post('pais');
                $data_clte['clte_env_cp'] =  $this->input->post('cp');
                $data_clte['clte_env_edo_cve'] =  $this->input->post('entidad');
                $data_clte['clte_env_colonia_crypt'] =  $this->input->post('colonia');
                $data_clte['clte_env_localidad'] =  $this->input->post('localidad');
                $data_clte['clte_env_municipio'] =  $this->input->post('municipio');
                $data_clte['clte_env_calle_crypt'] =  $this->input->post('calle');
                $data_clte['clte_env_num_ext_crypt'] =  $this->input->post('next');
                $data_clte['clte_env_num_int_crypt'] =  $this->input->post('nint');
				 
				//informacion de conrtaxcto de la persona
                $data_clte['clte_tel_casa_crypt'] =  limpia_telefono($this->input->post('tel'));                
                $data_clte['clte_cel_crypt'] =  limpia_telefono($this->input->post('cel'));
                $data_clte['clte_email_crypt'] =  $this->input->post('correo');
                
                //nuevos campos
                $data_clte['clte_grado_acad_cve'] =  $this->input->post('grado');
                $data_clte['clte_puesto'] =  $this->input->post('puesto');
                $data_clte['clte_edo_civ_cve'] =  $this->input->post('civil');
                $data_clte['clte_nac_cve'] =  $this->input->post('nac');
/************************/ 
				$data_clte['clte_nss_crypt'] =  $this->input->post('nss');
				$data_clte['clte_accidente_av'] =  $this->input->post('accidente_av'); 					
				$data_clte['clte_parentesco_av'] =  $this->input->post('parentesco_av'); 					
				$data_clte['clte_telefono_av'] =  $this->input->post('telefono_av');					
				$data_clte['area_depto']  =  $this->input->post('area_depto');	
				$data_clte['clte_clinica_imss'] =  $this->input->post('clinica_imss'); 					
				$data_clte['clte_no_consultorio'] =  $this->input->post('no_consultorio');		
				$data_clte['clte_turno'] =  $this->input->post('turno');		
				$data_clte['clte_f_consulta'] =  formatea_fecha_mysql($this->input->post('f_consulta')); 
/***************************/
 

				$data_clte['emp_id'] = $this->input->post('empresa'); 

				if ($data_clte['emp_id'] == '')
				{
					$flag_empresa=1;
				}
	

				$data_clte['cei_id'] =  get_cei_id();
				
				
				if ($data_clte['emp_id'] == 293)
				{	
					$nomserv='ISOEXMEDINEX;FEHS034;NORDICOG;FEHS035;CARATULA;ISOEXI;';
				}
				else
				{	
					$nomserv='ISOEXI;';
				}
				$data_clte['nomserv'] =  $nomserv;
			
 /***************************** CARGA DE LA FOTO DEL EVALUADO ************************/               
                if(!empty($_FILES['foto']['name']))
                {
                    $this->load->library('upload');
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/fotos/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg',
                            'max_size'      => '25000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('foto'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['clte_path_foto'] = $data['file_name'];
                    }
                }
/*************************************************************************************/
				
				$data_clte=array_to_upper($data_clte);

				
				
				if($cliente_id = $this->cliente->inserta(array_to_upper($data_clte)))
                {
                    send_json_ok(array('msg' =>'Se guardó de forma correcta', 'id' => $cliente_id));
                    
                }
                else
                {
                    send_json_error('Ocurrió un error al guardar la persona.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
           // $this->load->model('empresa/Empresa_model','empresa');
 			//$data['empresas'] = $this->empresa->get_all_empresas();

			$this->load->helper('template');
			$data['usuario'] = $this->medico->get($user['usr_id']);	
            $params_view = array(
                'title' => 'Personas pwd',
                'view' => 'persona/add_evaluado',
                'view_data' => $data
               );
			   
            render_template($params_view);  
        }
    }
/*************************************************************************************/
    public function nuevo_psw()
    {   $user = $this->session->user; 
		$flag_empresa=0;
		
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('nombre','Nombre','required');
            $this->form_validation->set_rules('paterno','Apellido Paterno','required');
            $this->form_validation->set_rules('materno','Apellido Materno','required');
            $this->form_validation->set_rules('fnac','Fecha de nacimiento','required');
            $this->form_validation->set_rules('genero','Género','required');
            //$this->form_validation->set_rules('civil','Estado civil','required');
            //$this->form_validation->set_rules('rfc','RFC','required');
            //
            //$this->form_validation->set_rules('curp','CURP','required');

            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_nombre_crypt'] =  trim($this->input->post('nombre'));
                $data_clte['clte_2_nombre_crypt'] =  trim($this->input->post('nombre_adic'));
                $data_clte['clte_paterno_crypt'] =  trim($this->input->post('paterno'));
                $data_clte['clte_materno_crypt'] =  trim($this->input->post('materno'));
                
				$data_clte['clte_f_nac'] = formatea_fecha_mysql($this->input->post('fnac'));
                $data_clte['clte_genero_cve'] =  $this->input->post('genero');
      				
				$data_clte['clte_rfc_crypt'] =  $this->input->post('rfc');
                

				if (strlen($data_clte['clte_rfc_crypt']) < 10)
				{						
					$data_clte['clte_rfc_crypt']=substr($data_clte['clte_paterno_crypt'],0,2).substr($data_clte['clte_materno_crypt'],0,1).substr($data_clte['clte_nombre_crypt'],0,1).substr($data_clte['clte_f_nac'],2,2).substr($data_clte['clte_f_nac'],5,2).substr($data_clte['clte_f_nac'],8,2);
				}
				
				$data_clte['clte_curp_crypt'] = ''; // $this->input->post('curp');
                
                //dopmcicio de la persona
                $data_clte['clte_env_pais_cve'] =  $this->input->post('pais');
                $data_clte['clte_env_cp'] =  $this->input->post('cp');
                $data_clte['clte_env_edo_cve'] =  $this->input->post('entidad');
                $data_clte['clte_env_colonia_crypt'] =  $this->input->post('colonia');
                $data_clte['clte_env_localidad'] =  $this->input->post('localidad');
                $data_clte['clte_env_municipio'] =  $this->input->post('municipio');
                $data_clte['clte_env_calle_crypt'] =  $this->input->post('calle');
                $data_clte['clte_env_num_ext_crypt'] =  $this->input->post('next');
                $data_clte['clte_env_num_int_crypt'] =  $this->input->post('nint');
				
                $data_clte['clte_nss_crypt'] = ''; // $this->input->post('nss');
                
				//informacion de conrtaxcto de la persona
                $data_clte['clte_tel_casa_crypt'] =  limpia_telefono($this->input->post('tel'));                
                $data_clte['clte_cel_crypt'] =  limpia_telefono($this->input->post('cel'));
                $data_clte['clte_email_crypt'] =  $this->input->post('correo');
                
                //nuevos campos
                $data_clte['clte_grado_acad_cve'] =  $this->input->post('grado');
                $data_clte['clte_puesto'] =  $this->input->post('puesto');
                $data_clte['clte_edo_civ_cve'] =  $this->input->post('civil');
                $data_clte['clte_nac_cve'] =  $this->input->post('nac');
                

				$data_clte['emp_id'] = $this->input->post('empresa'); 

				if ($data_clte['emp_id'] == '')
				{
					$flag_empresa=1;
				}
	
				

				
				$data_clte['cei_id'] =  get_cei_id();
				
				$nomserv='';				
				$data_clte['nomserv'] =  $nomserv;

 /***************************** CARGA DE LA FOTO DEL EVALUADO ************************/               
                if(!empty($_FILES['foto']['name']))
                {
                    $this->load->library('upload');
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/fotos/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg',
                            'max_size'      => '25000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('foto'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['clte_path_foto'] = $data['file_name'];
                    }
                }
/*************************************************************************************/
				
				$data_clte=array_to_upper($data_clte);

				
				
				if($cliente_id = $this->cliente->inserta(array_to_upper($data_clte)))
                {
                    send_json_ok(array('msg' =>'Se guardó de forma correcta', 'id' => $cliente_id));
                    
                }
                else
                {
                    send_json_error('Ocurrió un error al guardar la persona.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
           // $this->load->model('empresa/Empresa_model','empresa');
 			//$data['empresas'] = $this->empresa->get_all_empresas();

			$this->load->helper('template');
            $params_view = array(
                'title' => 'Personas pwd',
                'view' => 'persona/add_pwd',
                'view_data' => $data
               );
			   
            render_template($params_view);  
        }
    }
/*************************************************************************************/
    public function nuevo_px()
    {    
		$user = $this->session->user; 
		$medico = $this->medico->get($user['usr_id']);
		
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('nombre','Nombre','required');
            $this->form_validation->set_rules('paterno','Apellido Paterno','required');
            $this->form_validation->set_rules('materno','Apellido Materno','required');
            $this->form_validation->set_rules('fnac','Fecha de nacimiento','required');
            $this->form_validation->set_rules('genero','Género','required');
			//$this->form_validation->set_rules('supervisor','Nombre de Supervisor o Jefe Inmediato','required');

            if($this->form_validation->run())
            {
				$error_edad=0;
				$error_numero_empleado=0;
				$error_supervisor=0;
				$error_empresa=0;
				$error_puesto=0;
                //informncion general de la pérsona
                $data_clte['clte_nombre_crypt'] =  trim($this->input->post('nombre'));
                $data_clte['clte_2_nombre_crypt'] =  trim($this->input->post('nombre_adic'));
                $data_clte['clte_paterno_crypt'] =  trim($this->input->post('paterno'));
                $data_clte['clte_materno_crypt'] =  trim($this->input->post('materno'));
                
				$data_clte['clte_f_nac'] = $this->input->post('fnac');
                $data_clte['clte_genero_cve'] =  $this->input->post('genero');
      				
				$data_clte['clte_rfc_crypt'] =  $this->input->post('rfc');
                				
				$data_clte['clte_curp_crypt'] = ''; // $this->input->post('curp');
                $data_clte['paciente'] = 1;
                $data_clte['med_emp_asig'] = $medico['usr_emp_asig'];
				
				
				$data_clte['emp_id'] = get_empresa_consultorio($medico['usr_emp_asig']);
				$data_clte['suc_id'] = $this->input->post('empresa');
				$data_clte['cei_id'] = get_cei_id();
				$data_clte['root'] =$this->input->post('tpaciente');
	

				$nomserv='RECETA;';
				$data_clte['nomserv'] =  $nomserv;
				
					//$data_clte_card['card_rcv']= get_1_0_by_si_no($this->input->post('rcv'));
					$data_clte_card['card_diabetes']= get_1_0_by_si_no( $this->input->post('diabetes'));
					$data_clte_card['card_displipidemia']= get_1_0_by_si_no( $this->input->post('displipidemia'));
					$data_clte_card['card_arterial']= get_1_0_by_si_no( $this->input->post('arterial'));
					$data_clte_card['card_sobrepeso']= get_1_0_by_si_no( $this->input->post('sobrepeso'));	
					$data_clte_card['card_obesidad']= get_1_0_by_si_no( $this->input->post('obesidad'));
					//$data_clte_card['card_sedentarismo']= get_1_0_by_si_no( $this->input->post('sedentarismo'));
					$data_clte_card['card_tabaquismo']= get_1_0_by_si_no( $this->input->post('tabaquismo'));
					
					$data_clte['clte_puesto'] = $this->input->post('puesto');
					$data_clte['num_empleado'] = $this->input->post('nempleado');
					$data_clte['supervisor'] = $this->input->post('supervisor');
					
					if ($data_clte['suc_id'] == '') 						
					{
						$error_sucursal=1;
					}


					if ($data_clte['clte_puesto'] == '') 						
					{
						$error_puesto=1;
					}
				

					if ($data_clte['num_empleado'] == '') 
					{
						$error_numero_empleado=1;
					}					
					elseif (!(is_numeric($data_clte['num_empleado']))) 
					{
						$error_numero_empleado=1;
					}	


					if ($data_clte['supervisor'] == '') 
					{
						$error_supervisor=1;
					}

					$edad=trim(str_replace("años","",get_edad($data_clte['clte_f_nac'])));
						
					if (($edad < 18) || ($edad > 70))
					{
						$error_edad=1;
					}					

				
				if ($data_clte['emp_id'] == '')
				{
					$error_empresa=1;
				}
				
				if (($data_clte['emp_id'] == 9999) || ($data_clte['emp_id'] == 9998))
				{
					$data_clte_card['card_observaciones']= $this->input->post('observaciones');	
				
					if ($data_clte['emp_id'] == 9998 )
					{

						$data_clte['num_empleado']= $this->input->post('nproveedor');
					}				
				}	


				$data_clte=array_to_upper($data_clte);
		
		

				if ( $error_sucursal == 1 )
				{
					send_json_error('Ocurrio un error, Se debe escribir la sucursal a la que pertence el paciente.');
				}
				elseif ( $error_puesto == 1 )
				{
					send_json_error('Ocurrio un error, Se debe escribir el puesto del paciente.');
				}
				elseif ( $error_empresa == 1 )
				{
					send_json_error('Ocurrio un error, Se debe escribir la empresa a la que pertence el paciente.');
				}
				elseif ( $error_supervisor == 1 )
				{
					send_json_error('Ocurrio un error, Se debe escribir el nombre del supervidor.');
				}
				elseif ( $error_numero_empleado == 1 )
				{
					send_json_error('Ocurrio un error, el número de empleado debe ser númerico.');
				}
				elseif ( $error_edad == 1 )
				{
					send_json_error('Ocurrio un error, la fecha de nacimiento no proporciona una edad laboral.');
				}
				else
				{
					
					$cliente_id = $this->cliente->inserta(array_to_upper($data_clte));
					


					if ($cliente_id)
					{
						$data_clte_card['clte_id']=$cliente_id;
						$card=$this->cliente->inserta_card($data_clte_card);						
						send_json_ok(array('msg' =>'Se registo de forma correcta el Paciente.', 'id' => $cliente_id));
						
					}
					else
					{
						send_json_error('Ocurrió un error al guardar la persona.');
					}
				}
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $this->load->model('empresa/Empresa_model','empresa');			

			$data['sucursales']=$this->empresa->get_all_sucursales(get_empresa_consultorio($medico['usr_emp_asig']));
						
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'persona/add_px',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }



    public function nuevo_pot($empresa)
    {    
		$user = $this->session->user; 
		$medico = $this->medico->get($user['usr_id']);
		
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('nombre','Nombre','required');
            $this->form_validation->set_rules('paterno','Apellido Paterno','required');
            $this->form_validation->set_rules('materno','Apellido Materno','required');
            $this->form_validation->set_rules('fnac','Fecha de nacimiento','required');
            $this->form_validation->set_rules('genero','Género','required');
			//$this->form_validation->set_rules('supervisor','Nombre de Supervisor o Jefe Inmediato','required');

            if($this->form_validation->run())
            {
				$error_edad=0;
				$error_numero_empleado=0;
				$error_supervisor=0;
				$error_empresa=0;
				$error_puesto=0;
                //informncion general de la pérsona
                $data_clte['clte_nombre_crypt'] =  trim($this->input->post('nombre'));
                $data_clte['clte_2_nombre_crypt'] =  trim($this->input->post('nombre_adic'));
                $data_clte['clte_paterno_crypt'] =  trim($this->input->post('paterno'));
                $data_clte['clte_materno_crypt'] =  trim($this->input->post('materno'));
                
				$data_clte['clte_f_nac'] = $this->input->post('fnac');
                $data_clte['clte_genero_cve'] =  $this->input->post('genero');
      				
				$data_clte['clte_rfc_crypt'] =  $this->input->post('rfc');
                				
				$data_clte['clte_curp_crypt'] = ''; 
                $data_clte['paciente'] = 1;
                $data_clte['med_emp_asig'] = $medico['usr_emp_asig'];
				$data_clte['root'] = 'OTROS';

				$data_clte['emp_id'] = $medico['usr_emp_asig'];
				$data_clte['cei_id'] =  2;


				if($data_clte['emp_id'] == 439){
					$nomserv='RECETA;EXAMM;NMEDICA;ISOAM;ISOACC;ISOEXP;ISOINC;ISOEXI;ISOCP;';
				}else{
					$nomserv='RECETA;';
				}
				$data_clte['nomserv'] =  $nomserv;
				
	
					//$data_clte_card['card_rcv']= get_1_0_by_si_no($this->input->post('rcv'));
					$data_clte_card['card_diabetes']= get_1_0_by_si_no( $this->input->post('diabetes'));
					$data_clte_card['card_displipidemia']= get_1_0_by_si_no( $this->input->post('displipidemia'));
					$data_clte_card['card_arterial']= get_1_0_by_si_no( $this->input->post('arterial'));
					$data_clte_card['card_sobrepeso']= get_1_0_by_si_no( $this->input->post('sobrepeso'));	
					$data_clte_card['card_obesidad']= get_1_0_by_si_no( $this->input->post('obesidad'));
					//$data_clte_card['card_sedentarismo']= get_1_0_by_si_no( $this->input->post('sedentarismo'));
					$data_clte_card['card_tabaquismo']= get_1_0_by_si_no( $this->input->post('tabaquismo'));
					
					$data_clte['clte_puesto'] = $this->input->post('puesto');
					$data_clte['num_empleado'] = $this->input->post('nempleado');
					$data_clte['supervisor'] = $this->input->post('supervisor');


						if ($data_clte['clte_puesto'] == '') 						
						{
							$error_puesto=1;
						}
					

						if ($data_clte['num_empleado'] == '') 
						{
							$error_numero_empleado=1;
						}					
						elseif (!(is_numeric($data_clte['num_empleado']))) 
						{
							$error_numero_empleado=1;
						}	


						if ($data_clte['supervisor'] == '') 
						{
							$error_supervisor=1;
						}

						$edad=trim(str_replace("años","",get_edad($data_clte['clte_f_nac'])));
						
					if (($edad < 18) || ($edad > 70))
					{
						$error_edad=1;
					}					

				
				if ($data_clte['emp_id'] == '')
				{
					$error_empresa=1;
				}
				
				$data_clte_card['card_observaciones']= $this->input->post('observaciones');	



 /***************************** CARGA DE LA FOTO DEL EVALUADO ************************/               
                if(!empty($_FILES['foto']['name']))
                {
                    $this->load->library('upload');
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/fotos/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg',
                            'max_size'      => '25000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('foto'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['clte_path_foto'] = $data['file_name'];
                    }
                }
/*************************************************************************************/
				$data_clte=array_to_upper($data_clte);
		
		
if ( $error_puesto == 1 )
				{
					send_json_error('Ocurrio un error, Se debe escribir el puesto del paciente.');
				}
				elseif ( $error_supervisor == 1 )
				{
					send_json_error('Ocurrio un error, Se debe escribir el nombre del supervidor.');
				}
				elseif ( $error_numero_empleado == 1 )
				{
					send_json_error('Ocurrio un error, el número de empleado debe ser númerico.');
				}
				elseif ( $error_edad == 1 )
				{
					send_json_error('Ocurrio un error, la fecha de nacimiento no proporciona una edad laboral.');
				}
				else
				{
					
					$cliente_id = $this->cliente->inserta(array_to_upper($data_clte));
					


					if ($cliente_id)
					{
						$data_clte_card['clte_id']=$cliente_id;
						$card=$this->cliente->inserta_card($data_clte_card);						
						send_json_ok(array('msg' =>'Se registo de forma correcta el Paciente.', 'id' => $cliente_id));
						
					}
					else
					{
						send_json_error('Ocurrió un error al guardar la persona.');
					}
				}
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
			$data['empresa'] =$empresa;
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'persona/add_pot',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }


    public function nuevo_p()
    {    
		$user = $this->session->user; 
		$medico = $this->medico->get($user['usr_id']);
		
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('nombre','Nombre','required');
            $this->form_validation->set_rules('paterno','Apellido Paterno','required');
            $this->form_validation->set_rules('materno','Apellido Materno','required');
            $this->form_validation->set_rules('fnac','Fecha de nacimiento','required');
            $this->form_validation->set_rules('genero','Género','required');
			//$this->form_validation->set_rules('supervisor','Nombre de Supervisor o Jefe Inmediato','required');

            if($this->form_validation->run())
            {
				$error_edad=0;
				$error_numero_empleado=0;
				$error_supervisor=0;
				$error_empresa=0;
				$error_puesto=0;
                //informncion general de la pérsona
                $data_clte['clte_nombre_crypt'] =  trim($this->input->post('nombre'));
                $data_clte['clte_2_nombre_crypt'] =  trim($this->input->post('nombre_adic'));
                $data_clte['clte_paterno_crypt'] =  trim($this->input->post('paterno'));
                $data_clte['clte_materno_crypt'] =  trim($this->input->post('materno'));
                
				$data_clte['clte_f_nac'] = $this->input->post('fnac');
                $data_clte['clte_genero_cve'] =  $this->input->post('genero');
      				
				$data_clte['clte_rfc_crypt'] =  $this->input->post('rfc');
                				
				$data_clte['clte_curp_crypt'] = ''; // $this->input->post('curp');
                $data_clte['paciente'] = 1;
                $data_clte['med_emp_asig'] = $medico['usr_emp_asig'];
				$data_clte['root'] = 'GSI';
				
				
				/*if  (!(valida_corporacion(get_my_emp_asig(),'GSI')))
				{

					$data_clte['emp_id'] = get_my_emp_asig();
					$data_clte['suc_id'] = $this->input->post('empresa');
					$data_clte['cei_id'] = get_cei_id();
					
				}
				else*/
				{	
					$data_clte['emp_id'] =$this->input->post('empresa');
					$data_clte['cei_id'] =  4;
				}	

				$nomserv='RECETA;REFMED;NOTMED;NOTDREF;EXMEPER;';
				$data_clte['nomserv'] =  $nomserv;
				
				if (
					($data_clte['emp_id'] > 0) && 
					($data_clte['emp_id'] < 9998) 
					)
				{	
					//$data_clte_card['card_rcv']= get_1_0_by_si_no($this->input->post('rcv'));
					$data_clte_card['card_diabetes']= get_1_0_by_si_no( $this->input->post('diabetes'));
					$data_clte_card['card_displipidemia']= get_1_0_by_si_no( $this->input->post('displipidemia'));
					$data_clte_card['card_arterial']= get_1_0_by_si_no( $this->input->post('arterial'));
					$data_clte_card['card_sobrepeso']= get_1_0_by_si_no( $this->input->post('sobrepeso'));	
					$data_clte_card['card_obesidad']= get_1_0_by_si_no( $this->input->post('obesidad'));
					//$data_clte_card['card_sedentarismo']= get_1_0_by_si_no( $this->input->post('sedentarismo'));
					$data_clte_card['card_tabaquismo']= get_1_0_by_si_no( $this->input->post('tabaquismo'));
					
					$data_clte['clte_puesto'] = $this->input->post('puesto');
					$data_clte['num_empleado'] = $this->input->post('nempleado');
					$data_clte['supervisor'] = $this->input->post('supervisor');
					
					//if  ((valida_corporacion(get_my_emp_asig(),'GSI')))
					{					
						$data_clte['suc_id'] = '';
						if($this->input->post('sucursal_1') > 0)
						{
							$data_clte['suc_id'] =$this->input->post('sucursal_1');
						}
						elseif($this->input->post('sucursal_2') > 0)
						{
							$data_clte['suc_id'] =$this->input->post('sucursal_2');
						}
						elseif($this->input->post('sucursal_3') > 0)
						{
							$data_clte['suc_id'] =$this->input->post('sucursal_3');
						}
						elseif($this->input->post('sucursal_4') > 0)
						{
							$data_clte['suc_id'] =$this->input->post('sucursal_4');
						}
						elseif($this->input->post('sucursal_5') > 0)
						{
							$data_clte['suc_id'] =$this->input->post('sucursal_5');
						}
						elseif($this->input->post('sucursal_6') > 0)
						{
							$data_clte['suc_id'] =$this->input->post('sucursal_6');
						}
						elseif($this->input->post('sucursal_7') > 0)
						{
							$data_clte['suc_id'] =$this->input->post('sucursal_7');
						}
						elseif($this->input->post('sucursal_8') > 0)
						{
							$data_clte['suc_id'] =$this->input->post('sucursal_8');
						}
						elseif($this->input->post('sucursal_9') > 0)
						{
							$data_clte['suc_id'] =$this->input->post('sucursal_9');
						}
						elseif($this->input->post('sucursal_10') > 0)
						{
							$data_clte['suc_id'] =$this->input->post('sucursal_10');
						}
						elseif($this->input->post('sucursal_11') > 0)
						{
							$data_clte['suc_id'] =$this->input->post('sucursal_11');
						}
						elseif($this->input->post('sucursal_12') > 0)
						{
							$data_clte['suc_id'] =$this->input->post('sucursal_12');
						}
						elseif($this->input->post('sucursal_13') > 0)
						{
							$data_clte['suc_id'] =$this->input->post('sucursal_13');
						}
						elseif($this->input->post('sucursal_14') > 0)
						{
							$data_clte['suc_id'] =$this->input->post('sucursal_14');
						}
						elseif($this->input->post('sucursal_15') > 0)
						{
							$data_clte['suc_id'] =$this->input->post('sucursal_15');
						}
						elseif($this->input->post('sucursal_16') > 0)
						{
							$data_clte['suc_id'] =$this->input->post('sucursal_16');
						}
						elseif($this->input->post('sucursal_17') > 0)
						{
							$data_clte['suc_id'] =$this->input->post('sucursal_17');
						}
						elseif($this->input->post('sucursal_18') > 0)
						{
							$data_clte['suc_id'] =$this->input->post('sucursal_18');
						}elseif($this->input->post('sucursal_19') > 0)
						{
							$data_clte['suc_id'] =$this->input->post('sucursal_19');
						}
						elseif($this->input->post('sucursal_20') > 0)
						{
							$data_clte['suc_id'] =$this->input->post('sucursal_20');
						}
						elseif($this->input->post('sucursal_21') > 0)
						{
							$data_clte['suc_id'] =$this->input->post('sucursal_21');
						}
						elseif($this->input->post('sucursal_22') > 0)
						{
							$data_clte['suc_id'] =$this->input->post('sucursal_22');
						}
						elseif($this->input->post('sucursal_23') > 0)
						{
							$data_clte['suc_id'] =$this->input->post('sucursal_23');
						}
						elseif($this->input->post('sucursal_24') > 0)
						{
							$data_clte['suc_id'] =$this->input->post('sucursal_25');
						}					
						elseif($this->input->post('sucursal_25') > 0)
						{
							$data_clte['suc_id'] =$this->input->post('sucursal_25');
						}
						elseif($this->input->post('sucursal_26') > 0)
						{
							$data_clte['suc_id'] =$this->input->post('sucursal_26');
						}
						elseif($this->input->post('sucursal_27') > 0)
						{
							$data_clte['suc_id'] =$this->input->post('sucursal_27');
						}
						elseif($this->input->post('sucursal_28') > 0)
						{
							$data_clte['suc_id'] =$this->input->post('sucursal_28');
						}
						elseif($this->input->post('sucursal_29') > 0)
						{
							$data_clte['suc_id'] =$this->input->post('sucursal_29');
						}
						elseif($this->input->post('sucursal_30') > 0)
						{
							$data_clte['suc_id'] =$this->input->post('sucursal_30');
						}
						elseif($this->input->post('sucursal_31') > 0)
						{
							$data_clte['suc_id'] =$this->input->post('sucursal_31');
						}
						elseif($this->input->post('sucursal_32') > 0)
						{
							$data_clte['suc_id'] =$this->input->post('sucursal_32');
						}
						elseif($this->input->post('sucursal_33') > 0)
						{
							$data_clte['suc_id'] =$this->input->post('sucursal_33');
						}
						elseif($this->input->post('sucursal_34') > 0)
						{
							$data_clte['suc_id'] =$this->input->post('sucursal_34');
						}	
						elseif($this->input->post('sucursal_35') > 0)
						{
							$data_clte['suc_id'] =$this->input->post('sucursal_35');
						}						
					}

						if ($data_clte['suc_id'] == '') 						
						{
							$error_sucursal=1;
						}


						if ($data_clte['clte_puesto'] == '') 						
						{
							$error_puesto=1;
						}
					

						if ($data_clte['num_empleado'] == '') 
						{
							$error_numero_empleado=1;
						}					
						elseif (!(is_numeric($data_clte['num_empleado']))) 
						{
							$error_numero_empleado=1;
						}	


						if ($data_clte['supervisor'] == '') 
						{
							$error_supervisor=1;
						}

						$edad=trim(str_replace("años","",get_edad($data_clte['clte_f_nac'])));
						
					if (($edad < 18) || ($edad > 70))
					{
						$error_edad=1;
					}					
					
				}
				
				if ($data_clte['emp_id'] == '')
				{
					$error_empresa=1;
				}
				
				if (($data_clte['emp_id'] == 9999) || ($data_clte['emp_id'] == 9998))
				{
					$data_clte_card['card_observaciones']= $this->input->post('observaciones');	
				
					if ($data_clte['emp_id'] == 9998 )
					{

						$data_clte['num_empleado']= $this->input->post('nproveedor');
					}				
				}	



 /***************************** CARGA DE LA FOTO DEL EVALUADO ************************/               
                if(!empty($_FILES['foto']['name']))
                {
                    $this->load->library('upload');
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/fotos/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg',
                            'max_size'      => '25000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('foto'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['clte_path_foto'] = $data['file_name'];
                    }
                }
/*************************************************************************************/
				$data_clte=array_to_upper($data_clte);
		
		

				if ( $error_sucursal == 1 )
				{
					send_json_error('Ocurrio un error, Se debe escribir la sucursal a la que pertence el paciente.');
				}
				elseif ( $error_puesto == 1 )
				{
					send_json_error('Ocurrio un error, Se debe escribir el puesto del paciente.');
				}
				elseif ( $error_empresa == 1 )
				{
					send_json_error('Ocurrio un error, Se debe escribir la empresa a la que pertence el paciente.');
				}
				elseif ( $error_supervisor == 1 )
				{
					send_json_error('Ocurrio un error, Se debe escribir el nombre del supervidor.');
				}
				elseif ( $error_numero_empleado == 1 )
				{
					send_json_error('Ocurrio un error, el número de empleado debe ser númerico.');
				}
				elseif ( $error_edad == 1 )
				{
					send_json_error('Ocurrio un error, la fecha de nacimiento no proporciona una edad laboral.');
				}
				else
				{
					
					$cliente_id = $this->cliente->inserta(array_to_upper($data_clte));
					


					if ($cliente_id)
					{
						$data_clte_card['clte_id']=$cliente_id;
						$card=$this->cliente->inserta_card($data_clte_card);						
						send_json_ok(array('msg' =>'Se registo de forma correcta el Paciente.', 'id' => $cliente_id));
						
					}
					else
					{
						send_json_error('Ocurrió un error al guardar la persona.');
					}
				}
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $this->load->model('empresa/Empresa_model','empresa');
			
            //$data['empresas'] = $this->empresa->get_all_empresas();
			
			/*if  (!(valida_corporacion(get_my_emp_asig(),'GSI')))
			{
				$data['sucursales']=$this->empresa->get_all_sucursales(get_my_emp_asig());
			}
			else*/
			{	
				$data['empresas'] =$this->empresa->get_sis15_empresas_gsi();
				$data['sucursales'] = $this->empresa->get_sis15_sucursales_gsi();
				$data['sucursales_1'] = $this->empresa->get_sis15_sucursales_gsi_by_emp(1);
				$data['sucursales_2'] = $this->empresa->get_sis15_sucursales_gsi_by_emp(2);
				$data['sucursales_3'] = $this->empresa->get_sis15_sucursales_gsi_by_emp(3);
				$data['sucursales_4'] = $this->empresa->get_sis15_sucursales_gsi_by_emp(4);
				$data['sucursales_5'] = $this->empresa->get_sis15_sucursales_gsi_by_emp(5);
				$data['sucursales_6'] = $this->empresa->get_sis15_sucursales_gsi_by_emp(6);
				$data['sucursales_7'] = $this->empresa->get_sis15_sucursales_gsi_by_emp(7);
				$data['sucursales_8'] = $this->empresa->get_sis15_sucursales_gsi_by_emp(8);
				$data['sucursales_9'] = $this->empresa->get_sis15_sucursales_gsi_by_emp(9);
				$data['sucursales_10'] = $this->empresa->get_sis15_sucursales_gsi_by_emp(10);
				$data['sucursales_11'] = $this->empresa->get_sis15_sucursales_gsi_by_emp(11);
				$data['sucursales_12'] = $this->empresa->get_sis15_sucursales_gsi_by_emp(12);
				$data['sucursales_13'] = $this->empresa->get_sis15_sucursales_gsi_by_emp(13);
				$data['sucursales_14'] = $this->empresa->get_sis15_sucursales_gsi_by_emp(14);
				$data['sucursales_15'] = $this->empresa->get_sis15_sucursales_gsi_by_emp(15);
				$data['sucursales_16'] = $this->empresa->get_sis15_sucursales_gsi_by_emp(16);
				$data['sucursales_17'] = $this->empresa->get_sis15_sucursales_gsi_by_emp(17);			
				$data['sucursales_18'] = $this->empresa->get_sis15_sucursales_gsi_by_emp(18);
				$data['sucursales_19'] = $this->empresa->get_sis15_sucursales_gsi_by_emp(19);
				$data['sucursales_20'] = $this->empresa->get_sis15_sucursales_gsi_by_emp(20);
				$data['sucursales_21'] = $this->empresa->get_sis15_sucursales_gsi_by_emp(21);
				$data['sucursales_22'] = $this->empresa->get_sis15_sucursales_gsi_by_emp(22);
				$data['sucursales_23'] = $this->empresa->get_sis15_sucursales_gsi_by_emp(23);
				$data['sucursales_24'] = $this->empresa->get_sis15_sucursales_gsi_by_emp(24);
				$data['sucursales_25'] = $this->empresa->get_sis15_sucursales_gsi_by_emp(25);
				$data['sucursales_26'] = $this->empresa->get_sis15_sucursales_gsi_by_emp(26);
				$data['sucursales_27'] = $this->empresa->get_sis15_sucursales_gsi_by_emp(27);
				$data['sucursales_28'] = $this->empresa->get_sis15_sucursales_gsi_by_emp(28);
				$data['sucursales_29'] = $this->empresa->get_sis15_sucursales_gsi_by_emp(29);
				$data['sucursales_30'] = $this->empresa->get_sis15_sucursales_gsi_by_emp(30);
				$data['sucursales_31'] = $this->empresa->get_sis15_sucursales_gsi_by_emp(31);
				$data['sucursales_32'] = $this->empresa->get_sis15_sucursales_gsi_by_emp(32);
				$data['sucursales_33'] = $this->empresa->get_sis15_sucursales_gsi_by_emp(33);
				$data['sucursales_34'] = $this->empresa->get_sis15_sucursales_gsi_by_emp(34);
				$data['sucursales_35'] = $this->empresa->get_sis15_sucursales_gsi_by_emp(35);
			}
			
			
			
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'persona/add_p',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }




/*************************************************************************************/
    public function nuevo_doc_hc($cliente_id)
       {
        $persona = $this->cliente->get($cliente_id);
        $user = $this->session->user; 
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
			/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
			if (($persona['serv_id'] == 0) ||(get_status_serv($persona['serv_id']) != 'PROCESO'))
			{
					$this->form_validation->set_rules('servicio','Orden de servicio','required');
			}
            /*************************************************/					
            $this->form_validation->set_rules('nombre','Nombre documento','required');
			//$this->form_validation->set_rules('servicio','Orden de servicio','required');
			
            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_id'] =  $cliente_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                $data_clte['emp_id'] =  $this->input->post('emp_id');
				$data_clte['usr_id'] =  $user['usr_id'];
				//$data_clte['serv_id'] = $this->input->post('servicio');
				/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
				if (($persona['serv_id'] == 0) || (get_status_serv($persona['serv_id']) != 'PROCESO'))
				{	
						$data_clte['serv_id']  = $this->input->post('servicio');
				}
				else
				{	
						$data_clte['serv_id']  = $persona['serv_id'];
				}
				/**************************************************/					
				
                $this->load->library('upload');
				sleep(1);
                if(!empty($_FILES['doc']['name']))
                {
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/docs/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'doc|docx|pdf|txt|xlsx|xls|png|jpg|jpeg|mp4',
                            'max_size'      => '25000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('doc'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['doc_path'] = $data['file_name'];
                        if($this->cliente->add_HHCC_doc(array_to_upper($data_clte)))
                        {
                            send_json_ok('Se guardó de forma correcta');
							/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
							$servicios=$persona['domserv'];					
							
							$servicio='HHCC;';
							if (!(strstr($servicios,$servicio)))
							{							
								$servicios.=$servicio;
								$data_clte_id['domserv']=$servicios;
								$res=$this->cliente->actualiza_registro_individual($cliente_id, $data_clte_id);
							}
							/**************************************************/							
                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
                    send_json_error($this->upload->display_errors());
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
			/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
			$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);
			/**************************************************/			
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'persona/add_doc_hhcc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }

/*************************************************************************************/
    
    public function nuevo_doc($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
		$user = $this->session->user;
		$usuario = $this->medico->get($user['usr_id']);
		
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('nombre','Nombre documento','required');

            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_id'] =  $cliente_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
				$data_clte['serv_id'] =  $persona['serv_id'];
                
                $this->load->library('upload');
				sleep(1);
                if(!empty($_FILES['doc']['name']))
                {
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/docs/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'doc|docx|pdf|txt|xlsx|xls|png|jpg|jpeg|mp4',
                            'max_size'      => '25000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('doc'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['doc_path'] = $data['file_name'];
                        if($this->cliente->add_doc(array_to_upper($data_clte)))
                        {
                            send_json_ok('Se guardó de forma correcta');
                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
                    send_json_error($this->upload->display_errors());
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {	$data['usuario'] = $usuario;
            $data['persona'] = $persona;
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'persona/add_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }


/*************************************************************************************/
    
    public function nuevo_doc_gen($cliente_id,$examen)
    {
        $persona = $this->cliente->get($cliente_id);
        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
 			//NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS
			if (($persona['serv_id'] == 0) ||(get_status_serv($persona['serv_id']) != 'PROCESO'))
			{					
					$this->form_validation->set_rules('servicio','Orden de servicio','required');
			}
			else
			{
					$this->form_validation->set_rules('servicio','Orden de servicio','integer');
			}

            
            if($this->form_validation->run())
            {
				//NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS
				if (($persona['serv_id'] == 0) || (get_status_serv($persona['serv_id']) != 'PROCESO'))
				{	
						$data_clte['serv_id']  = $this->input->post('servicio');
				}
				else
				{	
						$data_clte['serv_id']  = $persona['serv_id'];
				}
				
				$data_clte['emp_id'] =  $persona['emp_id'];
                $data_clte['clte_id'] =  $cliente_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                
				
                $this->load->library('upload');
				sleep(1);
                if(!empty($_FILES['doc']['name']))
                {
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/docs/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg|pdf|doc|docx',
                            'max_size'      => '25000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('doc'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['doc_path'] = $data['file_name'];
                        if($this->cliente->add_doc_gen(array_to_upper($data_clte)))
                        {
                            send_json_ok('Se guardó de forma correcta');
                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
                    send_json_error($this->upload->display_errors());
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
			$data['examen'] = $examen;
            $data['persona'] = $persona;
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'persona/add_doc_gen',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }



 
    public function nuevo_hon_doc($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
			/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
			if (($persona['serv_id'] == 0) ||(get_status_serv($persona['serv_id']) != 'PROCESO'))
			{	

					$this->form_validation->set_rules('servicio','Orden de servicio','required');
			}
            /*************************************************/			
            $this->form_validation->set_rules('nombre','Nombre documento','required');
			
            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_id'] =  $cliente_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                $data_clte['emp_id'] =  $this->input->post('emp_id');
				/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
				if (($persona['serv_id'] == 0) || (get_status_serv($persona['serv_id']) != 'PROCESO'))
				{	
						$data_clte['serv_id']  = $this->input->post('servicio');
				}
				else
				{	
						$data_clte['serv_id']  = $persona['serv_id'];
				}
				/**************************************************/
				
				
                $this->load->library('upload');
				sleep(1);
                if(!empty($_FILES['doc']['name']))
                {
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/docs/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg|pdf|doc|docx',
                            'max_size'      => '25000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('doc'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['doc_path'] = $data['file_name'];
                        if($this->cliente->add_hon_doc(array_to_upper($data_clte)))
                        {
                            send_json_ok('Se guardó de forma correcta');
							
							/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
							$servicios=$persona['domserv'];					
							
							$servicio='HONE;';
							if (!(strstr($servicios,$servicio)))
							{							
								$servicios.=$servicio;
								$data_clte_id['domserv']=$servicios;
								$res=$this->cliente->actualiza_registro_individual($cliente_id, $data_clte_id);
							}
							/**************************************************/
                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
                    send_json_error($this->upload->display_errors());
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
			/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
			$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);
			/**************************************************/			
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'persona/add_hon_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }

    public function nuevo_covid_doc($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('nombre','Nombre documento','required');
			$this->form_validation->set_rules('servicio','Orden de servicio','required');
			
            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_id'] =  $cliente_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                $data_clte['emp_id'] =  $this->input->post('emp_id');
				$data_clte['serv_id'] = $this->input->post('servicio');
				
				
                $this->load->library('upload');
				sleep(1);
                if(!empty($_FILES['doc']['name']))
                {
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/docs/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg|pdf|doc|docx',
                            'max_size'      => '25000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('doc'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['doc_path'] = $data['file_name'];
                        if($this->cliente->add_covid_doc(array_to_upper($data_clte)))
                        {
                            send_json_ok('Se guardó de forma correcta');
                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
                    send_json_error($this->upload->display_errors());
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'persona/add_covid_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }



    public function nuevo_LEGAL_doc($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
			/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
			if (($persona['serv_id'] == 0) ||(get_status_serv($persona['serv_id']) != 'PROCESO'))
			{
					$this->form_validation->set_rules('servicio','Orden de servicio','required');
			}
            /*************************************************/				
            $this->form_validation->set_rules('nombre','Nombre documento','required');
			//$this->form_validation->set_rules('servicio','Orden de servicio','required');
			
            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_id'] =  $cliente_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                $data_clte['emp_id'] =  $this->input->post('emp_id');
				//$data_clte['serv_id'] = $this->input->post('servicio');
				/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
				if (($persona['serv_id'] == 0) || (get_status_serv($persona['serv_id']) != 'PROCESO'))
				{	
						$data_clte['serv_id']  = $this->input->post('servicio');
				}
				else
				{	
						$data_clte['serv_id']  = $persona['serv_id'];
				}
				/**************************************************/				
				
                $this->load->library('upload');
				sleep(1);
                if(!empty($_FILES['doc']['name']))
                {
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/docs/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg|pdf|doc|docx',
                            'max_size'      => '25000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('doc'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['doc_path'] = $data['file_name'];
                        if($this->cliente->add_LEGAL_doc(array_to_upper($data_clte)))
                        {
                            send_json_ok('Se guardó de forma correcta');
							/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
							$servicios=$persona['domserv'];					
							
							$servicio='LEGAL;';
							if (!(strstr($servicios,$servicio)))
							{							
								$servicios.=$servicio;
								$data_clte_id['domserv']=$servicios;
								$res=$this->cliente->actualiza_registro_individual($cliente_id, $data_clte_id);
							}
							/**************************************************/							
                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
                    send_json_error($this->upload->display_errors());
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
			/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
			$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);
			/**************************************************/			
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'persona/add_LEGAL_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }



    public function nuevo_BURO_doc($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
			/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
			if (($persona['serv_id'] == 0) ||(get_status_serv($persona['serv_id']) != 'PROCESO'))
			{
					$this->form_validation->set_rules('servicio','Orden de servicio','required');
			}
            /*************************************************/				
            $this->form_validation->set_rules('nombre','Nombre documento','required');
			//$this->form_validation->set_rules('servicio','Orden de servicio','required');
			
            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_id'] =  $cliente_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                $data_clte['emp_id'] =  $this->input->post('emp_id');
				//$data_clte['serv_id'] = $this->input->post('servicio');
				/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
				if (($persona['serv_id'] == 0) || (get_status_serv($persona['serv_id']) != 'PROCESO'))
				{	
						$data_clte['serv_id']  = $this->input->post('servicio');
				}
				else
				{	
						$data_clte['serv_id']  = $persona['serv_id'];
				}
				/**************************************************/				
				
                $this->load->library('upload');
				sleep(1);
                if(!empty($_FILES['doc']['name']))
                {
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/docs/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg|pdf|doc|docx',
                            'max_size'      => '25000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('doc'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['doc_path'] = $data['file_name'];
                        if($this->cliente->add_BURO_doc(array_to_upper($data_clte)))
                        {
                            send_json_ok('Se guardó de forma correcta');
							/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
							$servicios=$persona['domserv'];					
							
							$servicio='BURO;';
							if (!(strstr($servicios,$servicio)))
							{							
								$servicios.=$servicio;
								$data_clte_id['domserv']=$servicios;
								$res=$this->cliente->actualiza_registro_individual($cliente_id, $data_clte_id);
							}
							/**************************************************/							
                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
                    send_json_error($this->upload->display_errors());
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
			/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
			$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);
			/**************************************************/			
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'persona/add_BURO_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }


    public function nuevo_LABORATORIODS_doc($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
			/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
			if (($persona['serv_id'] == 0) ||(get_status_serv($persona['serv_id']) != 'PROCESO'))
			{
					$this->form_validation->set_rules('servicio','Orden de servicio','required');
			}
            /*************************************************/				
            $this->form_validation->set_rules('nombre','Nombre documento','required');
			//$this->form_validation->set_rules('servicio','Orden de servicio','required');
			
            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_id'] =  $cliente_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                $data_clte['emp_id'] =  $this->input->post('emp_id');
				//$data_clte['serv_id'] = $this->input->post('servicio');
				/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
				if (($persona['serv_id'] == 0) || (get_status_serv($persona['serv_id']) != 'PROCESO'))
				{	
						$data_clte['serv_id']  = $this->input->post('servicio');
				}
				else
				{	
						$data_clte['serv_id']  = $persona['serv_id'];
				}
				/**************************************************/				
				
                $this->load->library('upload');
				sleep(1);
                if(!empty($_FILES['doc']['name']))
                {
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/docs/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg|pdf|doc|docx',
                            'max_size'      => '25000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('doc'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['doc_path'] = $data['file_name'];
                        if($this->cliente->add_LABORATORIODS_doc(array_to_upper($data_clte)))
                        {
                            send_json_ok('Se guardó de forma correcta');
							/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
							$servicios=$persona['domserv'];					
							
							$servicio='LABDS;';
							if (!(strstr($servicios,$servicio)))
							{							
								$servicios.=$servicio;
								$data_clte_id['domserv']=$servicios;
								$res=$this->cliente->actualiza_registro_individual($cliente_id, $data_clte_id);
							}
							/**************************************************/							
                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
                    send_json_error($this->upload->display_errors());
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
			/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
			$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);
			/**************************************************/			
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'persona/add_LABORATORIODS_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }



    public function nuevo_EXAMM_DS_doc($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
			/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
			if (($persona['serv_id'] == 0) ||(get_status_serv($persona['serv_id']) != 'PROCESO'))
			{
					$this->form_validation->set_rules('servicio','Orden de servicio','required');
			}
            /*************************************************/				
            $this->form_validation->set_rules('nombre','Nombre documento','required');
			//$this->form_validation->set_rules('servicio','Orden de servicio','required');
			
            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_id'] =  $cliente_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                $data_clte['emp_id'] =  $this->input->post('emp_id');
				//$data_clte['serv_id'] = $this->input->post('servicio');
				/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
				if (($persona['serv_id'] == 0) || (get_status_serv($persona['serv_id']) != 'PROCESO'))
				{	
						$data_clte['serv_id']  = $this->input->post('servicio');
				}
				else
				{	
						$data_clte['serv_id']  = $persona['serv_id'];
				}
				/**************************************************/				
				
                $this->load->library('upload');
				sleep(1);
                if(!empty($_FILES['doc']['name']))
                {
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/docs/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg|pdf|doc|docx',
                            'max_size'      => '25000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('doc'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['doc_path'] = $data['file_name'];
                        if($this->cliente->add_EXAMM_DS_doc(array_to_upper($data_clte)))
                        {
                            send_json_ok('Se guardó de forma correcta');
							/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
							$servicios=$persona['domserv'];					
							
							$servicio='EXMEDDS;';
							if (!(strstr($servicios,$servicio)))
							{							
								$servicios.=$servicio;
								$data_clte_id['domserv']=$servicios;
								$res=$this->cliente->actualiza_registro_individual($cliente_id, $data_clte_id);
							}
							/**************************************************/							
                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
                    send_json_error($this->upload->display_errors());
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
			/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
			$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);
			/**************************************************/			
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'persona/add_EXAMM_DS_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }


    public function nuevo_EXAMM_doc($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
		$user = $this->session->user; 
		$usuario = $this->medico->get($user['usr_id']);
        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');

			if ((($persona['serv_id'] == 0) ||(get_status_serv($persona['serv_id']) != 'PROCESO')) && (!(strstr($usuario['acciones'],'S1N0RD3NEXAMM'))) )
			{
					$this->form_validation->set_rules('servicio','Orden de servicio','required');
			}
			
            $this->form_validation->set_rules('nombre','Nombre documento','required');

			
            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_id'] =  $cliente_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                $data_clte['emp_id'] =  $this->input->post('emp_id');
				/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
				
				if  (!(strstr($usuario['acciones'],'S1N0RD3NEXAMM')))
				{
					if (($persona['serv_id'] == 0) || (get_status_serv($persona['serv_id']) != 'PROCESO'))
					{	
							$data_clte['serv_id']  = $this->input->post('servicio');
					}
					else
					{	
							$data_clte['serv_id']  = $persona['serv_id'];
					}
				}				
				/**************************************************/				
				
                $this->load->library('upload');
				sleep(1);
                if(!empty($_FILES['doc']['name']))
                {
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/docs/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg|pdf|doc|docx',
                            'max_size'      => '25000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('doc'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['doc_path'] = $data['file_name'];
                        if($this->cliente->add_EXAMM_doc(array_to_upper($data_clte)))
                        {
                            send_json_ok('Se guardó de forma correcta');
							/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
							$servicios=$persona['domserv'];					
							
							$servicio='EXAMM;';
							if (!(strstr($servicios,$servicio)))
							{							
								$servicios.=$servicio;
								$data_clte_id['domserv']=$servicios;
								$res=$this->cliente->actualiza_registro_individual($cliente_id, $data_clte_id);
							}
							/**************************************************/							
                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
                    send_json_error($this->upload->display_errors());
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['usuario'] = $usuario;
			$data['persona'] = $persona;
			/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
			$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);
			/**************************************************/			
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'persona/add_EXAMM_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }


    public function nuevo_AUDIO_doc($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
			/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
			if (($persona['serv_id'] == 0) ||(get_status_serv($persona['serv_id']) != 'PROCESO'))
			{
					$this->form_validation->set_rules('servicio','Orden de servicio','required');
			}
            /*************************************************/				
            $this->form_validation->set_rules('nombre','Nombre documento','required');
			//$this->form_validation->set_rules('servicio','Orden de servicio','required');
			
            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_id'] =  $cliente_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                $data_clte['emp_id'] =  $this->input->post('emp_id');
				//$data_clte['serv_id'] = $this->input->post('servicio');
				/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
				if (($persona['serv_id'] == 0) || (get_status_serv($persona['serv_id']) != 'PROCESO'))
				{	
						$data_clte['serv_id']  = $this->input->post('servicio');
				}
				else
				{	
						$data_clte['serv_id']  = $persona['serv_id'];
				}
				/**************************************************/				
				
                $this->load->library('upload');
				sleep(1);
                if(!empty($_FILES['doc']['name']))
                {
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/docs/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg|pdf|doc|docx',
                            'max_size'      => '25000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('doc'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['doc_path'] = $data['file_name'];
                        if($this->cliente->add_AUDIO_doc(array_to_upper($data_clte)))
                        {
                            send_json_ok('Se guardó de forma correcta');
							/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
							$servicios=$persona['domserv'];					
							
							$servicio='AUDIO;';
							if (!(strstr($servicios,$servicio)))
							{							
								$servicios.=$servicio;
								$data_clte_id['domserv']=$servicios;
								$res=$this->cliente->actualiza_registro_individual($cliente_id, $data_clte_id);
							}
							/**************************************************/							
                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
                    send_json_error($this->upload->display_errors());
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
			/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
			$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);
			/**************************************************/			
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'persona/add_AUDIO_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }


    public function nuevo_evacom_doc($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
		$user = $this->session->user; 
        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
			if (($persona['serv_id'] == 0) ||(get_status_serv($persona['serv_id']) != 'PROCESO'))
			{
					$this->form_validation->set_rules('servicio','Orden de servicio','required');
			}
			
            $this->form_validation->set_rules('nombre','Nombre documento','required');
			
            if($this->form_validation->run())
            {

                $data_clte['clte_id'] =  $cliente_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                $data_clte['emp_id'] =  $this->input->post('emp_id');
				$data_clte['usr_id'] = $user['usr_id'];

				if (($persona['serv_id'] == 0) || (get_status_serv($persona['serv_id']) != 'PROCESO'))
				{	
						$data_clte['serv_id']  = $this->input->post('servicio');
				}
				else
				{	
						$data_clte['serv_id']  = $persona['serv_id'];
				}
				
				
                $this->load->library('upload');
				sleep(1);
                if(!empty($_FILES['doc']['name']))
                {
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/docs/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg|pdf|doc|docx',
                            'max_size'      => '25000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('doc'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['doc_path'] = $data['file_name'];
                        if($this->cliente->add_evacom_doc(array_to_upper($data_clte)))
                        {
                            send_json_ok('Se guardó de forma correcta');
							$servicios=$persona['domserv'];					
							
							$servicio='EVACOM;';
							if (!(strstr($servicios,$servicio)))
							{							
								$servicios.=$servicio;
								$data_clte_id['domserv']=$servicios;
								$res=$this->cliente->actualiza_registro_individual($cliente_id, $data_clte_id);
							}

                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
                    send_json_error($this->upload->display_errors());
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
			$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'persona/add_evacom_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }

    public function nuevo_SPIRO_doc($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
			if (($persona['serv_id'] == 0) ||(get_status_serv($persona['serv_id']) != 'PROCESO'))
			{
					$this->form_validation->set_rules('servicio','Orden de servicio','required');
			}
			
            $this->form_validation->set_rules('nombre','Nombre documento','required');
			
            if($this->form_validation->run())
            {

                $data_clte['clte_id'] =  $cliente_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                $data_clte['emp_id'] =  $this->input->post('emp_id');

				if (($persona['serv_id'] == 0) || (get_status_serv($persona['serv_id']) != 'PROCESO'))
				{	
						$data_clte['serv_id']  = $this->input->post('servicio');
				}
				else
				{	
						$data_clte['serv_id']  = $persona['serv_id'];
				}
				
				
                $this->load->library('upload');
				sleep(1);
                if(!empty($_FILES['doc']['name']))
                {
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/docs/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg|pdf|doc|docx',
                            'max_size'      => '25000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('doc'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['doc_path'] = $data['file_name'];
                        if($this->cliente->add_SPIRO_doc(array_to_upper($data_clte)))
                        {
                            send_json_ok('Se guardó de forma correcta');
							$servicios=$persona['domserv'];					
							
							$servicio='SPIRO;';
							if (!(strstr($servicios,$servicio)))
							{							
								$servicios.=$servicio;
								$data_clte_id['domserv']=$servicios;
								$res=$this->cliente->actualiza_registro_individual($cliente_id, $data_clte_id);
							}

                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
                    send_json_error($this->upload->display_errors());
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
			$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'persona/add_SPIRO_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }

	
    public function nuevo_VDRL_doc($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
			if (($persona['serv_id'] == 0) ||(get_status_serv($persona['serv_id']) != 'PROCESO'))
			{
					$this->form_validation->set_rules('servicio','Orden de servicio','required');
			}
			
            $this->form_validation->set_rules('nombre','Nombre documento','required');
			
            if($this->form_validation->run())
            {

                $data_clte['clte_id'] =  $cliente_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                $data_clte['emp_id'] =  $this->input->post('emp_id');

				if (($persona['serv_id'] == 0) || (get_status_serv($persona['serv_id']) != 'PROCESO'))
				{	
						$data_clte['serv_id']  = $this->input->post('servicio');
				}
				else
				{	
						$data_clte['serv_id']  = $persona['serv_id'];
				}
				
				
                $this->load->library('upload');
				sleep(1);
                if(!empty($_FILES['doc']['name']))
                {
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/docs/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg|pdf|doc|docx',
                            'max_size'      => '25000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('doc'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['doc_path'] = $data['file_name'];
                        if($this->cliente->add_VDRL_doc(array_to_upper($data_clte)))
                        {
                            send_json_ok('Se guardó de forma correcta');
							$servicios=$persona['domserv'];					
							
							$servicio='VDRL;';
							if (!(strstr($servicios,$servicio)))
							{							
								$servicios.=$servicio;
								$data_clte_id['domserv']=$servicios;
								$res=$this->cliente->actualiza_registro_individual($cliente_id, $data_clte_id);
							}

                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
                    send_json_error($this->upload->display_errors());
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
			$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'persona/add_VDRL_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }	
	
    public function nuevo_VALPROF_doc($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
			if (($persona['serv_id'] == 0) ||(get_status_serv($persona['serv_id']) != 'PROCESO'))
			{
					$this->form_validation->set_rules('servicio','Orden de servicio','required');
			}
			
            $this->form_validation->set_rules('nombre','Nombre documento','required');
			
            if($this->form_validation->run())
            {

                $data_clte['clte_id'] =  $cliente_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                $data_clte['emp_id'] =  $this->input->post('emp_id');

				if (($persona['serv_id'] == 0) || (get_status_serv($persona['serv_id']) != 'PROCESO'))
				{	
						$data_clte['serv_id']  = $this->input->post('servicio');
				}
				else
				{	
						$data_clte['serv_id']  = $persona['serv_id'];
				}
				
				
                $this->load->library('upload');
				sleep(1);
                if(!empty($_FILES['doc']['name']))
                {
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/docs/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg|pdf|doc|docx',
                            'max_size'      => '25000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('doc'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['doc_path'] = $data['file_name'];
                        if($this->cliente->add_VALPROF_doc(array_to_upper($data_clte)))
                        {
                            send_json_ok('Se guardó de forma correcta');
							$servicios=$persona['domserv'];					
							
							$servicio='VALPROF;';
							if (!(strstr($servicios,$servicio)))
							{							
								$servicios.=$servicio;
								$data_clte_id['domserv']=$servicios;
								$res=$this->cliente->actualiza_registro_individual($cliente_id, $data_clte_id);
							}
						  // header('Location:'.base_url('persona/id/').'/'.$cliente_id);
						  // exit;

                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
                    send_json_error($this->upload->display_errors());
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
			$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'persona/add_VALPROF_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }	

    public function nuevo_KOH_doc($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
			if (($persona['serv_id'] == 0) ||(get_status_serv($persona['serv_id']) != 'PROCESO'))
			{
					$this->form_validation->set_rules('servicio','Orden de servicio','required');
			}
			
            $this->form_validation->set_rules('nombre','Nombre documento','required');
			
            if($this->form_validation->run())
            {

                $data_clte['clte_id'] =  $cliente_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                $data_clte['emp_id'] =  $this->input->post('emp_id');

				if (($persona['serv_id'] == 0) || (get_status_serv($persona['serv_id']) != 'PROCESO'))
				{	
						$data_clte['serv_id']  = $this->input->post('servicio');
				}
				else
				{	
						$data_clte['serv_id']  = $persona['serv_id'];
				}
				
				
                $this->load->library('upload');
				sleep(1);
                if(!empty($_FILES['doc']['name']))
                {
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/docs/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg|pdf|doc|docx',
                            'max_size'      => '25000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('doc'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['doc_path'] = $data['file_name'];
                        if($this->cliente->add_KOH_doc(array_to_upper($data_clte)))
                        {
                            send_json_ok('Se guardó de forma correcta');
							$servicios=$persona['domserv'];					
							
							$servicio='KOHU;';
							if (!(strstr($servicios,$servicio)))
							{							
								$servicios.=$servicio;
								$data_clte_id['domserv']=$servicios;
								$res=$this->cliente->actualiza_registro_individual($cliente_id, $data_clte_id);
							}

                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
                    send_json_error($this->upload->display_errors());
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
			$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'persona/add_KOH_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }


    public function nuevo_CULTIVOU_doc($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
			if (($persona['serv_id'] == 0) ||(get_status_serv($persona['serv_id']) != 'PROCESO'))
			{
					$this->form_validation->set_rules('servicio','Orden de servicio','required');
			}
			
            $this->form_validation->set_rules('nombre','Nombre documento','required');
			
            if($this->form_validation->run())
            {

                $data_clte['clte_id'] =  $cliente_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                $data_clte['emp_id'] =  $this->input->post('emp_id');

				if (($persona['serv_id'] == 0) || (get_status_serv($persona['serv_id']) != 'PROCESO'))
				{	
						$data_clte['serv_id']  = $this->input->post('servicio');
				}
				else
				{	
						$data_clte['serv_id']  = $persona['serv_id'];
				}
				
				
                $this->load->library('upload');
				sleep(1);
                if(!empty($_FILES['doc']['name']))
                {
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/docs/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg|pdf|doc|docx',
                            'max_size'      => '25000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('doc'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['doc_path'] = $data['file_name'];
                        if($this->cliente->add_CULTIVOU_doc(array_to_upper($data_clte)))
                        {
                            send_json_ok('Se guardó de forma correcta');
							$servicios=$persona['domserv'];					
							
							$servicio='CULTUN;';
							if (!(strstr($servicios,$servicio)))
							{							
								$servicios.=$servicio;
								$data_clte_id['domserv']=$servicios;
								$res=$this->cliente->actualiza_registro_individual($cliente_id, $data_clte_id);
							}

                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
                    send_json_error($this->upload->display_errors());
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
			$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'persona/add_CULTIVOU_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }

    public function nuevo_EVALUACION_DIAGNOSTICA_doc($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');

			if (($persona['serv_id'] == 0) ||(get_status_serv($persona['serv_id']) != 'PROCESO'))
			{
					$this->form_validation->set_rules('servicio','Orden de servicio','required');
			}
			
            $this->form_validation->set_rules('nombre','Nombre documento','required');

			
            if($this->form_validation->run())
            {

                $data_clte['clte_id'] =  $cliente_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                $data_clte['emp_id'] =  $this->input->post('emp_id');

				if (($persona['serv_id'] == 0) || (get_status_serv($persona['serv_id']) != 'PROCESO'))
				{	
						$data_clte['serv_id']  = $this->input->post('servicio');
				}
				else
				{	
						$data_clte['serv_id']  = $persona['serv_id'];
				}

                if(!empty($_FILES['doc']['name']))
                {                    
					$pre_croquis= carga_pdf('doc','./../../files/docs_TM/');

					if (!($pre_croquis))
                    {                        
						send_json_error('El documento nos se ha podido cargar, por favor revisa.');
                    }
                    else 
                    {
						$data_clte['doc_path'] = $pre_croquis;
                        if($this->cliente->add_EVALUACION_DIAGNOSTICA_doc(array_to_upper($data_clte)))
						{
                            send_json_ok(array('msg' =>'Se realizo la carga del archivo', 'id' => $cliente_id));

                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
                    send_json_error($this->upload->display_errors());
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
			$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'persona/add_EVALUACION_DIAGNOSTICA_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }

    public function borra_documento_EVALUACION_DIAGNOSTICA($fsm_id)
    {
		$documento=$this->cliente->get_doc_EVALUACION_DIAGNOSTICA($fsm_id);
		
		$doc_borra['clte_id']=$documento['clte_id'];
		$doc_borra['doc_nombre']=$documento['doc_nombre'];
		$doc_borra['doc_path']=strtolower($documento['doc_path']);
		$doc_borra['doc_f']=$documento['doc_f'];
		$doc_borra['empresa']='EVALUADOS';
		$doc_borra['doc_fecha_efectiva']=date();
		
		$this->cliente->inserta_borrado($doc_borra);
        if($this->cliente->delete_doc_EVALUACION_DIAGNOSTICA($fsm_id))
        {
            send_json_ok('Se eliminó de forma correcta.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar.');
        }
    }


    public function nuevo_EVALUACION_FINAL_doc($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');

			if (($persona['serv_id'] == 0) ||(get_status_serv($persona['serv_id']) != 'PROCESO'))
			{
					$this->form_validation->set_rules('servicio','Orden de servicio','required');
			}
			
            $this->form_validation->set_rules('nombre','Nombre documento','required');

			
            if($this->form_validation->run())
            {

                $data_clte['clte_id'] =  $cliente_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                $data_clte['emp_id'] =  $this->input->post('emp_id');

				if (($persona['serv_id'] == 0) || (get_status_serv($persona['serv_id']) != 'PROCESO'))
				{	
						$data_clte['serv_id']  = $this->input->post('servicio');
				}
				else
				{	
						$data_clte['serv_id']  = $persona['serv_id'];
				}

                if(!empty($_FILES['doc']['name']))
                {                    
					$pre_croquis= carga_pdf('doc','./../../files/docs_TM/');

					if (!($pre_croquis))
                    {                        
						send_json_error('El documento nos se ha podido cargar, por favor revisa.');
                    }
                    else 
                    {
						$data_clte['doc_path'] = $pre_croquis;
                        if($this->cliente->add_EVALUACION_FINAL_doc(array_to_upper($data_clte)))
						{
                            send_json_ok(array('msg' =>'Se realizo la carga del archivo', 'id' => $cliente_id));

                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
                    send_json_error($this->upload->display_errors());
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
			$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'persona/add_EVALUACION_FINAL_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }

    public function borra_documento_EVALUACION_FINAL($fsm_id)
    {
		$documento=$this->cliente->get_doc_EVALUACION_FINAL($fsm_id);
		
		$doc_borra['clte_id']=$documento['clte_id'];
		$doc_borra['doc_nombre']=$documento['doc_nombre'];
		$doc_borra['doc_path']=strtolower($documento['doc_path']);
		$doc_borra['doc_f']=$documento['doc_f'];
		$doc_borra['empresa']='EVALUADOS';
		$doc_borra['doc_fecha_efectiva']=date();
		
		$this->cliente->inserta_borrado($doc_borra);
        if($this->cliente->delete_doc_EVALUACION_FINAL($fsm_id))
        {
            send_json_ok('Se eliminó de forma correcta.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar.');
        }
    }


    public function borra_documento_generico($fsm_id)
    {
		$documento=$this->cliente->get_doc_generico($fsm_id);
		
		$doc_borra['clte_id']=$documento['clte_id'];
		$doc_borra['doc_nombre']=$documento['doc_nombre'];
		$doc_borra['doc_path']=strtolower($documento['doc_path']);
		$doc_borra['doc_pkts']=strtolower($documento['doc_pkts']);
		$doc_borra['emp_id']=$documento['emp_id'];
		$doc_borra['doc_f']=$documento['doc_f'];
		$doc_borra['empresa']='EVALUADOS';
		$doc_borra['doc_fecha_efectiva']=date();
		
		$this->cliente->inserta_borrado($doc_borra);
        if($this->cliente->delete_doc_generico($fsm_id))
        {
            send_json_ok('Se eliminó de forma correcta.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar.');
        }
    }


    public function nuevo_FINANCIERO_doc($cliente_id)
    {
		nuevo_generico_doc($cliente_id,'FINANCIERO','FINANCIERO','ENTFIN;','docs_especiales');
    }

	public function nuevo_BENDER_doc($cliente_id)
    {
		nuevo_generico_doc($cliente_id,'BENDER','BENDER','BENDER;','docs_psico');
    }

	public function nuevo_INVESTIGACION_REFERENCIAS_LABORALES_doc($cliente_id)
    {
		nuevo_generico_doc($cliente_id,'INVESTIGACIÓN DE REFERENCIAS LABORALES','INVESTIGACION_REFERENCIAS_LABORALES','INREFLA;','docs_socios');
    }

	public function nuevo_ESTUDIO_SOCIOLABORAL_DIGITAL_doc($cliente_id)
    {
		nuevo_generico_doc($cliente_id,'ESTUDIO SOCIOLABORAL DIGITAL','ESTUDIO_SOCIOLABORAL_DIGITAL','SOCDIGLAB;','docs_socios');
    }


    public function nuevo_CERTIFICADO_doc($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');

			if (($persona['serv_id'] == 0) ||(get_status_serv($persona['serv_id']) != 'PROCESO'))
			{
					$this->form_validation->set_rules('servicio','Orden de servicio','required');
			}
			
            $this->form_validation->set_rules('nombre','Nombre documento','required');

			
            if($this->form_validation->run())
            {

                $data_clte['clte_id'] =  $cliente_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                $data_clte['emp_id'] =  $this->input->post('emp_id');

				if (($persona['serv_id'] == 0) || (get_status_serv($persona['serv_id']) != 'PROCESO'))
				{	
						$data_clte['serv_id']  = $this->input->post('servicio');
				}
				else
				{	
						$data_clte['serv_id']  = $persona['serv_id'];
				}

                if(!empty($_FILES['doc']['name']))
                {                    
					$pre_croquis= carga_pdf('doc','./../../files/docs/');

					if (!($pre_croquis))
                    {                        
						send_json_error('El documento nos se ha podido cargar, por favor revisa.');
                    }
                    else 
                    {
						$data_clte['doc_path'] = $pre_croquis;
                        if($this->cliente->add_CERTIFICADO_doc(array_to_upper($data_clte)))
						{
                            send_json_ok(array('msg' =>'Se realizo la carga del archivo', 'id' => $cliente_id));

                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
                    send_json_error($this->upload->display_errors());
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
			$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'persona/add_CERTIFICADO_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }

    public function borra_documento_CERTIFICADO($fsm_id)
    {
		$documento=$this->cliente->get_doc_CERTIFICADO($fsm_id);
		
		$doc_borra['clte_id']=$documento['clte_id'];
		$doc_borra['doc_nombre']=$documento['doc_nombre'];
		$doc_borra['doc_path']=strtolower($documento['doc_path']);
		$doc_borra['doc_f']=$documento['doc_f'];
		$doc_borra['empresa']='EVALUADOS';
		$doc_borra['doc_fecha_efectiva']=date();
		
		$this->cliente->inserta_borrado($doc_borra);
        if($this->cliente->delete_doc_CERTIFICADO($fsm_id))
        {
            send_json_ok('Se eliminó de forma correcta.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar.');
        }
    }



    public function nuevo_PLOMO_doc($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');

			if (($persona['serv_id'] == 0) ||(get_status_serv($persona['serv_id']) != 'PROCESO'))
			{
					$this->form_validation->set_rules('servicio','Orden de servicio','required');
			}
			
            $this->form_validation->set_rules('nombre','Nombre documento','required');

			
            if($this->form_validation->run())
            {

                $data_clte['clte_id'] =  $cliente_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                $data_clte['emp_id'] =  $this->input->post('emp_id');

				if (($persona['serv_id'] == 0) || (get_status_serv($persona['serv_id']) != 'PROCESO'))
				{	
						$data_clte['serv_id']  = $this->input->post('servicio');
				}
				else
				{	
						$data_clte['serv_id']  = $persona['serv_id'];
				}
			
			/*			
                $this->load->library('upload');
				sleep(1);
                if(!empty($_FILES['doc']['name']))
                {
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/docs/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg|pdf|doc|docx',
                            'max_size'      => '25000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('doc'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['doc_path'] = $data['file_name'];
                        if($this->cliente->add_PLOMO_doc(array_to_upper($data_clte)))
                       
				*/

                if(!empty($_FILES['doc']['name']))
                {                    
					$pre_croquis= carga_pdf('doc','./../../files/docs/');

					if (!($pre_croquis))
                    {                        
						send_json_error('El documento nos se ha podido cargar, por favor revisa.');
                    }
                    else 
                    {
						$data_clte['doc_path'] = $pre_croquis;
                        if($this->cliente->add_PLOMO_doc(array_to_upper($data_clte)))
						{
                            send_json_ok('Se guardó de forma correcta');

						/*	$servicios=$persona['domserv'];					
							
							$servicio='PLOMO;';
							if (!(strstr($servicios,$servicio)))
							{							
								$servicios.=$servicio;
								$data_clte_id['domserv']=$servicios;
								$res=$this->cliente->actualiza_registro_individual($cliente_id, $data_clte_id);
							}*/
                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
                    send_json_error($this->upload->display_errors());
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
			$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'persona/add_PLOMO_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }




    public function nuevo_ELECTRO_doc($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
			/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
			if (($persona['serv_id'] == 0) ||(get_status_serv($persona['serv_id']) != 'PROCESO'))
			{
					$this->form_validation->set_rules('servicio','Orden de servicio','required');
			}
            /*************************************************/					
            $this->form_validation->set_rules('nombre','Nombre documento','required');
			//$this->form_validation->set_rules('servicio','Orden de servicio','required');
			
            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_id'] =  $cliente_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                $data_clte['emp_id'] =  $this->input->post('emp_id');
				//$data_clte['serv_id'] = $this->input->post('servicio');
				/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
				if (($persona['serv_id'] == 0) || (get_status_serv($persona['serv_id']) != 'PROCESO'))
				{	
						$data_clte['serv_id']  = $this->input->post('servicio');
				}
				else
				{	
						$data_clte['serv_id']  = $persona['serv_id'];
				}
				/**************************************************/					
				
                $this->load->library('upload');
				sleep(1);
                if(!empty($_FILES['doc']['name']))
                {
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/docs/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg|pdf|doc|docx',
                            'max_size'      => '25000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('doc'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['doc_path'] = $data['file_name'];
                        if($this->cliente->add_ELECTRO_doc(array_to_upper($data_clte)))
                        {
                            send_json_ok('Se guardó de forma correcta');
							/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
							$servicios=$persona['domserv'];					
							
							$servicio='ELECTRO;';
							if (!(strstr($servicios,$servicio)))
							{							
								$servicios.=$servicio;
								$data_clte_id['domserv']=$servicios;
								$res=$this->cliente->actualiza_registro_individual($cliente_id, $data_clte_id);
							}
							/**************************************************/							
                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
                    send_json_error($this->upload->display_errors());
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
			/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
			$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);
			/**************************************************/			
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'persona/add_ELECTRO_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }

    public function nuevo_ELECTROR_doc($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
			/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
			if (($persona['serv_id'] == 0) ||(get_status_serv($persona['serv_id']) != 'PROCESO'))
			{
					$this->form_validation->set_rules('servicio','Orden de servicio','required');
			}
            /*************************************************/					
            $this->form_validation->set_rules('nombre','Nombre documento','required');
			//$this->form_validation->set_rules('servicio','Orden de servicio','required');
			
            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_id'] =  $cliente_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                $data_clte['emp_id'] =  $this->input->post('emp_id');
				//$data_clte['serv_id'] = $this->input->post('servicio');
				/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
				if (($persona['serv_id'] == 0) || (get_status_serv($persona['serv_id']) != 'PROCESO'))
				{	
						$data_clte['serv_id']  = $this->input->post('servicio');
				}
				else
				{	
						$data_clte['serv_id']  = $persona['serv_id'];
				}
				/**************************************************/					
				
                $this->load->library('upload');
				sleep(1);
                if(!empty($_FILES['doc']['name']))
                {
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/docs/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg|pdf|doc|docx',
                            'max_size'      => '25000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('doc'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['doc_path'] = $data['file_name'];
                        if($this->cliente->add_ELECTROR_doc(array_to_upper($data_clte)))
                        {
                            send_json_ok('Se guardó de forma correcta');
							/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
							$servicios=$persona['domserv'];					
							
							$servicio='ELECTROR;';
							if (!(strstr($servicios,$servicio)))
							{							
								$servicios.=$servicio;
								$data_clte_id['domserv']=$servicios;
								$res=$this->cliente->actualiza_registro_individual($cliente_id, $data_clte_id);
							}
							/**************************************************/							
                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
                    send_json_error($this->upload->display_errors());
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
			/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
			$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);
			/**************************************************/			
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'persona/add_ELECTROR_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }

    public function nuevo_ELECTROE_doc($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
			if (($persona['serv_id'] == 0) ||(get_status_serv($persona['serv_id']) != 'PROCESO'))
			{
					$this->form_validation->set_rules('servicio','Orden de servicio','required');
			}
		
            $this->form_validation->set_rules('nombre','Nombre documento','required');
			
            if($this->form_validation->run())
            {
                $data_clte['clte_id'] =  $cliente_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                $data_clte['emp_id'] =  $this->input->post('emp_id');

				if (($persona['serv_id'] == 0) || (get_status_serv($persona['serv_id']) != 'PROCESO'))
				{	
						$data_clte['serv_id']  = $this->input->post('servicio');
				}
				else
				{	
						$data_clte['serv_id']  = $persona['serv_id'];
				}
				
                $this->load->library('upload');
				sleep(1);
                if(!empty($_FILES['doc']['name']))
                {
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/docs/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg|pdf|doc|docx',
                            'max_size'      => '25000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('doc'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['doc_path'] = $data['file_name'];
                        if($this->cliente->add_ELECTROE_doc(array_to_upper($data_clte)))
                        {
                            send_json_ok('Se guardó de forma correcta');
							$servicios=$persona['domserv'];					
							
							$servicio='ELECTROE;';
							if (!(strstr($servicios,$servicio)))
							{							
								$servicios.=$servicio;
								$data_clte_id['domserv']=$servicios;
								$res=$this->cliente->actualiza_registro_individual($cliente_id, $data_clte_id);
							}
                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
                    send_json_error($this->upload->display_errors());
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
			/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
			$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);
			/**************************************************/			
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'persona/add_ELECTROE_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }
	

    public function nuevo_PCR_doc($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
			/*if (($persona['serv_id'] == 0) ||(get_status_serv($persona['serv_id']) != 'PROCESO'))
			{
					$this->form_validation->set_rules('doc','Archivo','required');
			}*/

			if (($persona['serv_id'] == 0) ||(get_status_serv($persona['serv_id']) != 'PROCESO'))
			{					
					$this->form_validation->set_rules('servicio','Orden de servicio','required');
			}
			else
			{
					$this->form_validation->set_rules('servicio','Orden de servicio','integer');
			}
			
            if($this->form_validation->run())
            {
                $data_clte['clte_id'] =  $cliente_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                $data_clte['emp_id'] =  $this->input->post('emp_id');

				if (($persona['serv_id'] == 0) || (get_status_serv($persona['serv_id']) != 'PROCESO'))
				{	
						$data_clte['serv_id']  = $this->input->post('servicio');
				}
				else
				{	
						$data_clte['serv_id']  = $persona['serv_id'];
				}
				
                $this->load->library('upload');
				sleep(1);
                if(!empty($_FILES['doc']['name']))
                {
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/docs/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg|pdf|doc|docx',
                            'max_size'      => '25000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('doc'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['doc_path'] = $data['file_name'];
                        if($this->cliente->add_PCR_doc(array_to_upper($data_clte)))
                        {
                            send_json_ok('El documento se ha subido adecuadamente.');

							$servicios=$persona['domserv'];					
							
							$servicio='PCR;';
							if (!(strstr($servicios,$servicio)))
							{							
								$servicios.=$servicio;
								$data_clte_id['domserv']=$servicios;
								$res=$this->cliente->actualiza_registro_individual($cliente_id, $data_clte_id);
							}
                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
                    send_json_error($this->upload->display_errors());
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
			$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'persona/add_PCR_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }

    public function nuevo_ANTICUA_doc($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
			if (($persona['serv_id'] == 0) ||(get_status_serv($persona['serv_id']) != 'PROCESO'))
			{
					$this->form_validation->set_rules('doc','Archivo','required');
			}

			if (($persona['serv_id'] == 0) ||(get_status_serv($persona['serv_id']) != 'PROCESO'))
			{					
					$this->form_validation->set_rules('servicio','Orden de servicio','required');
			}
			else
			{
					$this->form_validation->set_rules('servicio','Orden de servicio','integer');
			}
			
            if($this->form_validation->run())
            {
                $data_clte['clte_id'] =  $cliente_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                $data_clte['emp_id'] =  $this->input->post('emp_id');

				if (($persona['serv_id'] == 0) || (get_status_serv($persona['serv_id']) != 'PROCESO'))
				{	
						$data_clte['serv_id']  = $this->input->post('servicio');
				}
				else
				{	
						$data_clte['serv_id']  = $persona['serv_id'];
				}
				
                $this->load->library('upload');
				sleep(1);
                if(!empty($_FILES['doc']['name']))
                {
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/docs/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg|pdf|doc|docx',
                            'max_size'      => '25000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('doc'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['doc_path'] = $data['file_name'];
                        if($this->cliente->add_ANTICUA_doc(array_to_upper($data_clte)))
                        {
                            send_json_ok('El documento se ha subido adecuadamente.');

							$servicios=$persona['domserv'];					
							
							$servicio='ANTICUA;';
							if (!(strstr($servicios,$servicio)))
							{							
								$servicios.=$servicio;
								$data_clte_id['domserv']=$servicios;
								$res=$this->cliente->actualiza_registro_individual($cliente_id, $data_clte_id);
							}
                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
                    send_json_error($this->upload->display_errors());
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
			$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'persona/add_ANTICUA_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }


    public function nuevo_ALCOSA_doc($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
			if (($persona['serv_id'] == 0) ||(get_status_serv($persona['serv_id']) != 'PROCESO'))
			{
					$this->form_validation->set_rules('doc','Archivo','required');
			}

			if (($persona['serv_id'] == 0) ||(get_status_serv($persona['serv_id']) != 'PROCESO'))
			{					
					$this->form_validation->set_rules('servicio','Orden de servicio','required');
			}
			else
			{
					$this->form_validation->set_rules('servicio','Orden de servicio','integer');
			}
			
            if($this->form_validation->run())
            {
                $data_clte['clte_id'] =  $cliente_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                $data_clte['emp_id'] =  $this->input->post('emp_id');

				if (($persona['serv_id'] == 0) || (get_status_serv($persona['serv_id']) != 'PROCESO'))
				{	
						$data_clte['serv_id']  = $this->input->post('servicio');
				}
				else
				{	
						$data_clte['serv_id']  = $persona['serv_id'];
				}
				
                $this->load->library('upload');
				sleep(1);
                if(!empty($_FILES['doc']['name']))
                {
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/docs/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg|pdf|doc|docx',
                            'max_size'      => '25000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('doc'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['doc_path'] = $data['file_name'];
                        if($this->cliente->add_ALCOSA_doc(array_to_upper($data_clte)))
                        {
                            send_json_ok('El documento se ha subido adecuadamente.');

							$servicios=$persona['domserv'];					
							
							$servicio='ALCOSA;';
							if (!(strstr($servicios,$servicio)))
							{							
								$servicios.=$servicio;
								$data_clte_id['domserv']=$servicios;
								$res=$this->cliente->actualiza_registro_individual($cliente_id, $data_clte_id);
							}
                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
                    send_json_error($this->upload->display_errors());
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
			$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'persona/add_ALCOSA_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }


    public function nuevo_RADIOM_doc($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
			if (($persona['serv_id'] == 0) ||(get_status_serv($persona['serv_id']) != 'PROCESO'))
			{
					//$this->form_validation->set_rules('doc','Archivo','required');
			}

			if (($persona['serv_id'] == 0) ||(get_status_serv($persona['serv_id']) != 'PROCESO'))
			{					
					$this->form_validation->set_rules('servicio','Orden de servicio','required');
			}
			else
			{
					$this->form_validation->set_rules('servicio','Orden de servicio','integer');
			}
			
            if($this->form_validation->run())
            {
                $data_clte['clte_id'] =  $cliente_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                $data_clte['emp_id'] =  $this->input->post('emp_id');

				if (($persona['serv_id'] == 0) || (get_status_serv($persona['serv_id']) != 'PROCESO'))
				{	
						$data_clte['serv_id']  = $this->input->post('servicio');
				}
				else
				{	
						$data_clte['serv_id']  = $persona['serv_id'];
				}
				
                $this->load->library('upload');
				sleep(1);
                if(!empty($_FILES['doc']['name']))
                {
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/docs/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg|pdf|doc|docx',
                            'max_size'      => '25000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('doc'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['doc_path'] = $data['file_name'];
                        if($this->cliente->add_RADIOM_doc(array_to_upper($data_clte)))
                        {
                            send_json_ok('El documento se ha subido adecuadamente.');

							$servicios=$persona['domserv'];					
							
							$servicio='RADIOM;';
							if (!(strstr($servicios,$servicio)))
							{							
								$servicios.=$servicio;
								$data_clte_id['domserv']=$servicios;
								$res=$this->cliente->actualiza_registro_individual($cliente_id, $data_clte_id);
							}
                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
                    send_json_error($this->upload->display_errors());
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
			$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'persona/add_RADIOM_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }


    public function nuevo_TORAX_doc($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
			if (($persona['serv_id'] == 0) ||(get_status_serv($persona['serv_id']) != 'PROCESO'))
			{
					//$this->form_validation->set_rules('doc','Archivo','required');
					$this->form_validation->set_rules('nombre','Nombre documento','required');

			}

			if (($persona['serv_id'] == 0) ||(get_status_serv($persona['serv_id']) != 'PROCESO'))
			{					
					$this->form_validation->set_rules('servicio','Orden de servicio','required');
			}
			else
			{
					$this->form_validation->set_rules('servicio','Orden de servicio','integer');
			}
			
            if($this->form_validation->run())
            {
                $data_clte['clte_id'] =  $cliente_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                $data_clte['emp_id'] =  $this->input->post('emp_id');

				if (($persona['serv_id'] == 0) || (get_status_serv($persona['serv_id']) != 'PROCESO'))
				{	
						$data_clte['serv_id']  = $this->input->post('servicio');
				}
				else
				{	
						$data_clte['serv_id']  = $persona['serv_id'];
				}
				
                $this->load->library('upload');
				sleep(1);
                if(!empty($_FILES['doc']['name']))
                {
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/docs/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg|pdf|doc|docx',
                            'max_size'      => '25000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('doc'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['doc_path'] = $data['file_name'];
                        if($this->cliente->add_TORAX_doc(array_to_upper($data_clte)))
                        {
                            send_json_ok('El documento se ha subido adecuadamente.');

							$servicios=$persona['domserv'];					
							
							$servicio='TORAX;';
							if (!(strstr($servicios,$servicio)))
							{							
								$servicios.=$servicio;
								$data_clte_id['domserv']=$servicios;
								$res=$this->cliente->actualiza_registro_individual($cliente_id, $data_clte_id);
							}
                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
                    send_json_error($this->upload->display_errors());
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
			$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'persona/add_TORAX_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }

    public function nuevo_OPTOM_doc($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
			/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
			if (($persona['serv_id'] == 0) ||(get_status_serv($persona['serv_id']) != 'PROCESO'))
			{
					//$this->form_validation->set_rules('doc','Archivo','required');
			}
           
 			//NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS
			if (($persona['serv_id'] == 0) ||(get_status_serv($persona['serv_id']) != 'PROCESO'))
			{					
					$this->form_validation->set_rules('servicio','Orden de servicio','required');
			}
			else
			{
					$this->form_validation->set_rules('servicio','Orden de servicio','integer');
			}
            /*************************************************/
			
            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_id'] =  $cliente_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                $data_clte['emp_id'] =  $this->input->post('emp_id');
				//$data_clte['serv_id'] = $this->input->post('servicio');
				/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
				if (($persona['serv_id'] == 0) || (get_status_serv($persona['serv_id']) != 'PROCESO'))
				{	
						$data_clte['serv_id']  = $this->input->post('servicio');
				}
				else
				{	
						$data_clte['serv_id']  = $persona['serv_id'];
				}
				/**************************************************/					
				
                $this->load->library('upload');
				sleep(1);
                if(!empty($_FILES['doc']['name']))
                {
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/docs/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg|pdf|doc|docx',
                            'max_size'      => '25000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('doc'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['doc_path'] = $data['file_name'];
                        if($this->cliente->add_OPTOM_doc(array_to_upper($data_clte)))
                        {
                            send_json_ok('El documento se ha subido adecuadamente.');
							/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
							$servicios=$persona['domserv'];					
							
							$servicio='OPTOM;';
							if (!(strstr($servicios,$servicio)))
							{							
								$servicios.=$servicio;
								$data_clte_id['domserv']=$servicios;
								$res=$this->cliente->actualiza_registro_individual($cliente_id, $data_clte_id);
							}
							/**************************************************/							
                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
                    //send_json_error($this->upload->display_errors());
					send_json_error("No has referenciado el documento a cargar.");
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
			/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
			$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);
			/**************************************************/			
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'persona/add_OPTOM_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }




    public function nuevo_RADIOL_doc($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
			/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
			if (($persona['serv_id'] == 0) ||(get_status_serv($persona['serv_id']) != 'PROCESO'))
			{
					//$this->form_validation->set_rules('doc','Archivo','required');
					$this->form_validation->set_rules('nombre','Nombre documento','required');

			}
            /*************************************************/				
			/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
 			//NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS
			if (($persona['serv_id'] == 0) ||(get_status_serv($persona['serv_id']) != 'PROCESO'))
			{					
					$this->form_validation->set_rules('servicio','Orden de servicio','required');
			}
			else
			{
					$this->form_validation->set_rules('servicio','Orden de servicio','integer');
			}
            /*************************************************/
			
            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_id'] =  $cliente_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                $data_clte['emp_id'] =  $this->input->post('emp_id');
				//$data_clte['serv_id'] = $this->input->post('servicio');
				/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
				if (($persona['serv_id'] == 0) || (get_status_serv($persona['serv_id']) != 'PROCESO'))
				{	
						$data_clte['serv_id']  = $this->input->post('servicio');
				}
				else
				{	
						$data_clte['serv_id']  = $persona['serv_id'];
				}
				/**************************************************/					
				
                $this->load->library('upload');
				sleep(1);
                if(!empty($_FILES['doc']['name']))
                {
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/docs/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg|pdf|doc|docx',
                            'max_size'      => '25000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('doc'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['doc_path'] = $data['file_name'];
                        if($this->cliente->add_RADIOL_doc(array_to_upper($data_clte)))
                        {
                            send_json_ok('El documento se ha subido adecuadamente.');
							/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
							$servicios=$persona['domserv'];					
							
							$servicio='RADIOL;';
							if (!(strstr($servicios,$servicio)))
							{							
								$servicios.=$servicio;
								$data_clte_id['domserv']=$servicios;
								$res=$this->cliente->actualiza_registro_individual($cliente_id, $data_clte_id);
							}
							/**************************************************/							
                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
                    send_json_error($this->upload->display_errors());
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
			/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
			$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);
			/**************************************************/			
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'persona/add_RADIOL_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }


    public function nuevo_RADIOT_doc($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
			/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
			if (($persona['serv_id'] == 0) ||(get_status_serv($persona['serv_id']) != 'PROCESO'))
			{
					$this->form_validation->set_rules('servicio','Orden de servicio','required');
			}
            /*************************************************/				
            $this->form_validation->set_rules('nombre','Nombre documento','required');
			//$this->form_validation->set_rules('servicio','Orden de servicio','required');
			
            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_id'] =  $cliente_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                $data_clte['emp_id'] =  $this->input->post('emp_id');
				//$data_clte['serv_id'] = $this->input->post('servicio');
				/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
				if (($persona['serv_id'] == 0) || (get_status_serv($persona['serv_id']) != 'PROCESO'))
				{	
						$data_clte['serv_id']  = $this->input->post('servicio');
				}
				else
				{	
						$data_clte['serv_id']  = $persona['serv_id'];
				}
				/**************************************************/				
				
                $this->load->library('upload');
				sleep(1);
                if(!empty($_FILES['doc']['name']))
                {
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/docs/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg|pdf|doc|docx',
                            'max_size'      => '25000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('doc'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['doc_path'] = $data['file_name'];
                        if($this->cliente->add_RADIOT_doc(array_to_upper($data_clte)))
                        {
                            send_json_ok('El documento se ha subido adecuadamente.');
							/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
							$servicios=$persona['domserv'];					
							
							$servicio='RADIOT;';
							if (!(strstr($servicios,$servicio)))
							{							
								$servicios.=$servicio;
								$data_clte_id['domserv']=$servicios;
								$res=$this->cliente->actualiza_registro_individual($cliente_id, $data_clte_id);
							}
							/**************************************************/								
                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
                    send_json_error($this->upload->display_errors());
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
			/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
			$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);
			/**************************************************/			
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'persona/add_RADIOT_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }



    public function nuevo_PAPAN_doc($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
			/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
			if (($persona['serv_id'] == 0) ||(get_status_serv($persona['serv_id']) != 'PROCESO'))
			{
					$this->form_validation->set_rules('servicio','Orden de servicio','required');
			}
            /*************************************************/				
            $this->form_validation->set_rules('nombre','Nombre documento','required');

			
            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_id'] =  $cliente_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                $data_clte['emp_id'] =  $this->input->post('emp_id');
				//$data_clte['serv_id'] = $this->input->post('servicio');
				/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
				if (($persona['serv_id'] == 0) || (get_status_serv($persona['serv_id']) != 'PROCESO'))
				{	
						$data_clte['serv_id']  = $this->input->post('servicio');
				}
				else
				{	
						$data_clte['serv_id']  = $persona['serv_id'];
				}
				/**************************************************/				
				
                $this->load->library('upload');
				sleep(1);
                if(!empty($_FILES['doc']['name']))
                {
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/docs/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg|pdf|doc|docx',
                            'max_size'      => '25000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('doc'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['doc_path'] = $data['file_name'];
                        if($this->cliente->add_PAPAN_doc(array_to_upper($data_clte)))
                        {
                            send_json_ok('Se guardó de forma correcta');
							/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
							$servicios=$persona['domserv'];					
							
							$servicio='PAPAN;';
							if (!(strstr($servicios,$servicio)))
							{							
								$servicios.=$servicio;
								$data_clte_id['domserv']=$servicios;
								$res=$this->cliente->actualiza_registro_individual($cliente_id, $data_clte_id);
							}
							/**************************************************/							
                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
                    send_json_error($this->upload->display_errors());
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
			/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
			$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);
			/**************************************************/			
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'persona/add_PAPAN_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }




    public function nuevo_STRESS_doc($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
			if (($persona['serv_id'] == 0) ||(get_status_serv($persona['serv_id']) != 'PROCESO'))
			{	

					$this->form_validation->set_rules('servicio','Orden de servicio','required');
			}
            $this->form_validation->set_rules('nombre','Nombre documento','required');
			
            if($this->form_validation->run())
            {
                $data_clte['clte_id'] =  $cliente_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                $data_clte['emp_id'] =  $this->input->post('emp_id');
				if (($persona['serv_id'] == 0) || (get_status_serv($persona['serv_id']) != 'PROCESO'))
				{	
						$data_clte['serv_id']  = $this->input->post('servicio');
				}
				else
				{	
						$data_clte['serv_id']  = $persona['serv_id'];
				}
				
                $this->load->library('upload');
				sleep(1);
                if(!empty($_FILES['doc']['name']))
                {
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/docs/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg|pdf|doc|docx',
                            'max_size'      => '25000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('doc'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['doc_path'] = $data['file_name'];
                        if($this->cliente->add_STRESS_doc(array_to_upper($data_clte)))
                        {
                            send_json_ok('Se guardó de forma correcta');
							
							$servicios=$persona['domserv'];					
							
							$servicio='5TR355;';
							if (!(strstr($servicios,$servicio)))
							{							
								$servicios.=$servicio;
								$data_clte_id['domserv']=$servicios;
								$res=$this->cliente->actualiza_registro_individual($cliente_id, $data_clte_id);
							}
                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
                    send_json_error($this->upload->display_errors());
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
			$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'persona/add_STRESS_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }








    public function nuevo_RAVEN_doc($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
			if (($persona['serv_id'] == 0) ||(get_status_serv($persona['serv_id']) != 'PROCESO'))
			{	

					$this->form_validation->set_rules('servicio','Orden de servicio','required');
			}
            $this->form_validation->set_rules('nombre','Nombre documento','required');
			
            if($this->form_validation->run())
            {
                $data_clte['clte_id'] =  $cliente_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                $data_clte['emp_id'] =  $this->input->post('emp_id');
				if (($persona['serv_id'] == 0) || (get_status_serv($persona['serv_id']) != 'PROCESO'))
				{	
						$data_clte['serv_id']  = $this->input->post('servicio');
				}
				else
				{	
						$data_clte['serv_id']  = $persona['serv_id'];
				}
				
                $this->load->library('upload');
				sleep(1);
                if(!empty($_FILES['doc']['name']))
                {
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/docs/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg|pdf|doc|docx',
                            'max_size'      => '25000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('doc'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['doc_path'] = $data['file_name'];
                        if($this->cliente->add_RAVEN_doc(array_to_upper($data_clte)))
                        {
                            send_json_ok('Se guardó de forma correcta');
							
							$servicios=$persona['domserv'];					
							
							$servicio='R4V3N;';
							if (!(strstr($servicios,$servicio)))
							{							
								$servicios.=$servicio;
								$data_clte_id['domserv']=$servicios;
								$res=$this->cliente->actualiza_registro_individual($cliente_id, $data_clte_id);
							}
                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
                    send_json_error($this->upload->display_errors());
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
			$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'persona/add_RAVEN_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }




    public function nuevo_TERMAN_doc($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
			/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
			if (($persona['serv_id'] == 0) ||(get_status_serv($persona['serv_id']) != 'PROCESO'))
			{	

					$this->form_validation->set_rules('servicio','Orden de servicio','required');
			}
            /*************************************************/			
            $this->form_validation->set_rules('nombre','Nombre documento','required');
			
            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_id'] =  $cliente_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                $data_clte['emp_id'] =  $this->input->post('emp_id');
				/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
				if (($persona['serv_id'] == 0) || (get_status_serv($persona['serv_id']) != 'PROCESO'))
				{	
						$data_clte['serv_id']  = $this->input->post('servicio');
				}
				else
				{	
						$data_clte['serv_id']  = $persona['serv_id'];
				}
				/**************************************************/
				
				
                $this->load->library('upload');
				sleep(1);
                if(!empty($_FILES['doc']['name']))
                {
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/docs/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg|pdf|doc|docx',
                            'max_size'      => '25000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('doc'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['doc_path'] = $data['file_name'];
                        if($this->cliente->add_TERMAN_doc(array_to_upper($data_clte)))
                        {
                            send_json_ok('Se guardó de forma correcta');
							
							/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
							$servicios=$persona['domserv'];					
							
							$servicio='TERMAN;';
							if (!(strstr($servicios,$servicio)))
							{							
								$servicios.=$servicio;
								$data_clte_id['domserv']=$servicios;
								$res=$this->cliente->actualiza_registro_individual($cliente_id, $data_clte_id);
							}
							/**************************************************/							
							
                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
                    send_json_error($this->upload->display_errors());
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
			/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
			$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);
			/**************************************************/			
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'persona/add_TERMAN_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }



    public function nuevo_EGEREN_doc($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
			/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
			if (($persona['serv_id'] == 0) ||(get_status_serv($persona['serv_id']) != 'PROCESO'))
			{	

					$this->form_validation->set_rules('servicio','Orden de servicio','required');
			}
            /*************************************************/			
            $this->form_validation->set_rules('nombre','Nombre documento','required');
			
            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_id'] =  $cliente_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                $data_clte['emp_id'] =  $this->input->post('emp_id');
				/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
				if (($persona['serv_id'] == 0) || (get_status_serv($persona['serv_id']) != 'PROCESO'))
				{	
						$data_clte['serv_id']  = $this->input->post('servicio');
				}
				else
				{	
						$data_clte['serv_id']  = $persona['serv_id'];
				}
				/**************************************************/
				
				
                $this->load->library('upload');
				sleep(1);
                if(!empty($_FILES['doc']['name']))
                {
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/docs/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg|pdf|doc|docx',
                            'max_size'      => '25000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('doc'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['doc_path'] = $data['file_name'];
                        if($this->cliente->add_EGEREN_doc(array_to_upper($data_clte)))
                        {
                            send_json_ok('Se guardó de forma correcta');
							
							/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
							$servicios=$persona['domserv'];					
							
							$servicio='EGEREN;';
							if (!(strstr($servicios,$servicio)))
							{							
								$servicios.=$servicio;
								$data_clte_id['domserv']=$servicios;
								$res=$this->cliente->actualiza_registro_individual($cliente_id, $data_clte_id);
							}
							/**************************************************/							
							
                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
                    send_json_error($this->upload->display_errors());
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
			/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
			$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);
			/**************************************************/			
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'persona/add_EGEREN_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }

    public function nuevo_ENTREVISTA_doc($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
			/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
			if (($persona['serv_id'] == 0) ||(get_status_serv($persona['serv_id']) != 'PROCESO'))
			{	

					$this->form_validation->set_rules('servicio','Orden de servicio','required');
			}
            /*************************************************/			
            $this->form_validation->set_rules('nombre','Nombre documento','required');
			
            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_id'] =  $cliente_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                $data_clte['emp_id'] =  $this->input->post('emp_id');
				/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
				if (($persona['serv_id'] == 0) || (get_status_serv($persona['serv_id']) != 'PROCESO'))
				{	
						$data_clte['serv_id']  = $this->input->post('servicio');
				}
				else
				{	
						$data_clte['serv_id']  = $persona['serv_id'];
				}
				/**************************************************/
				
				
                $this->load->library('upload');
				sleep(1);
                if(!empty($_FILES['doc']['name']))
                {
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/docs_psico/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg|pdf|doc|docx',
                            'max_size'      => '25000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('doc'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['doc_path'] = $data['file_name'];
                        if($this->cliente->add_ENTREVISTA_doc(array_to_upper($data_clte)))
                        {
                            send_json_ok('Se guardó de forma correcta');
							
							/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
							$servicios=$persona['domserv'];					
							
							$servicio='ENTREVISTA;';
							if (!(strstr($servicios,$servicio)))
							{							
								$servicios.=$servicio;
								$data_clte_id['domserv']=$servicios;
								$res=$this->cliente->actualiza_registro_individual($cliente_id, $data_clte_id);
							}
							/**************************************************/							
							
                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
                    send_json_error($this->upload->display_errors());
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
			/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
			$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);
			/**************************************************/			
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'persona/add_ENTREVISTA_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }

    public function nuevo_PROYECTIVAS_doc($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
			/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
			if (($persona['serv_id'] == 0) ||(get_status_serv($persona['serv_id']) != 'PROCESO'))
			{	

					$this->form_validation->set_rules('servicio','Orden de servicio','required');
			}
            /*************************************************/			
            $this->form_validation->set_rules('nombre','Nombre documento','required');
			
            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_id'] =  $cliente_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                $data_clte['emp_id'] =  $this->input->post('emp_id');
				/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
				if (($persona['serv_id'] == 0) || (get_status_serv($persona['serv_id']) != 'PROCESO'))
				{	
						$data_clte['serv_id']  = $this->input->post('servicio');
				}
				else
				{	
						$data_clte['serv_id']  = $persona['serv_id'];
				}
				/**************************************************/
				
				
                $this->load->library('upload');
				sleep(1);
                if(!empty($_FILES['doc']['name']))
                {
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/docs_psico/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg|pdf|doc|docx',
                            'max_size'      => '25000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('doc'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['doc_path'] = $data['file_name'];
                        if($this->cliente->add_PROYECTIVAS_doc(array_to_upper($data_clte)))
                        {
                            send_json_ok('Se guardó de forma correcta');
							
							/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
							$servicios=$persona['domserv'];					
							
							$servicio='PROYECTIVAS;';
							if (!(strstr($servicios,$servicio)))
							{							
								$servicios.=$servicio;
								$data_clte_id['domserv']=$servicios;
								$res=$this->cliente->actualiza_registro_individual($cliente_id, $data_clte_id);
							}
							/**************************************************/							
							
                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
                    send_json_error($this->upload->display_errors());
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
			/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
			$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);
			/**************************************************/			
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'persona/add_PROYECTIVAS_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }


    public function nuevo_INTE_doc($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
			/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
			if (($persona['serv_id'] == 0) ||(get_status_serv($persona['serv_id']) != 'PROCESO'))
			{	

					$this->form_validation->set_rules('servicio','Orden de servicio','required');
			}
            /*************************************************/				
            $this->form_validation->set_rules('nombre','Nombre documento','required');
			
            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_id'] =  $cliente_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                $data_clte['emp_id'] =  $this->input->post('emp_id');
				//$data_clte['serv_id'] = $this->input->post('servicio');
				/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
				if (($persona['serv_id'] == 0) || (get_status_serv($persona['serv_id']) != 'PROCESO'))
				{	
						$data_clte['serv_id']  = $this->input->post('servicio');
				}
				else
				{	
						$data_clte['serv_id']  = $persona['serv_id'];
				}
				/**************************************************/				
				
                $this->load->library('upload');
				sleep(1);
                if(!empty($_FILES['doc']['name']))
                {
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/docs/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg|pdf|doc|docx',
                            'max_size'      => '25000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('doc'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['doc_path'] = $data['file_name'];
                        if($this->cliente->add_INTE_doc(array_to_upper($data_clte)))
                        {
                            send_json_ok('Se guardó de forma correcta');
							/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
							$servicios=$persona['domserv'];					
							
							$servicio='INTE;';
							if (!(strstr($servicios,$servicio)))
							{							
								$servicios.=$servicio;
								$data_clte_id['domserv']=$servicios;
								$res=$this->cliente->actualiza_registro_individual($cliente_id, $data_clte_id);
							}
							/**************************************************/							
							
                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
                    send_json_error($this->upload->display_errors());
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
			/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
			$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);
			/**************************************************/			
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'persona/add_INTE_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }

    public function nuevo_PUESIC_doc($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
			
			if (($persona['serv_id'] == 0) ||(get_status_serv($persona['serv_id']) != 'PROCESO'))
			{	

					$this->form_validation->set_rules('servicio','Orden de servicio','required');
			}
           		
            $this->form_validation->set_rules('nombre','Nombre documento','required');
			
			
            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_id'] =  $cliente_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                $data_clte['emp_id'] =  $this->input->post('emp_id');
				$data_clte['fsm_cve']     =	$this->input->post('fsm_cve');
				
				if (($persona['serv_id'] == 0) || (get_status_serv($persona['serv_id']) != 'PROCESO'))
				{	
						$data_clte['serv_id']  = $this->input->post('servicio');
				}
				else
				{	
						$data_clte['serv_id']  = $persona['serv_id'];
				}
								
				
                $this->load->library('upload');
				sleep(1);
                if(!empty($_FILES['doc']['name']))
                {
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/docs/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg|pdf|doc|docx',
                            'max_size'      => '25000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('doc'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['doc_path'] = $data['file_name'];
                        if($this->cliente->add_PUESIC_doc(array_to_upper($data_clte)))
                        {
                            send_json_ok('Se guardó de forma correcta');
							/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
							$servicios=$persona['domserv'];					
							
							$servicio='PUESIC;';
							if (!(strstr($servicios,$servicio)))
							{							
								$servicios.=$servicio;
								$data_clte_id['domserv']=$servicios;
								$res=$this->cliente->actualiza_registro_individual($cliente_id, $data_clte_id);
							}
							/**************************************************/								
							
                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
                    send_json_error($this->upload->display_errors());
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
			/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
			$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);
			/**************************************************/			
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'persona/add_PUESIC_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }

    public function nuevo_VISTA_doc($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
			/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
			if (($persona['serv_id'] == 0) ||(get_status_serv($persona['serv_id']) != 'PROCESO'))
			{	

					$this->form_validation->set_rules('servicio','Orden de servicio','required');
			}
            /*************************************************/					
            $this->form_validation->set_rules('nombre','Nombre documento','required');
			//$this->form_validation->set_rules('servicio','Orden de servicio','required');
			
            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_id'] =  $cliente_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                $data_clte['emp_id'] =  $this->input->post('emp_id');
				//$data_clte['serv_id'] = $this->input->post('servicio');
				/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
				if (($persona['serv_id'] == 0) || (get_status_serv($persona['serv_id']) != 'PROCESO'))
				{	
						$data_clte['serv_id']  = $this->input->post('servicio');
				}
				else
				{	
						$data_clte['serv_id']  = $persona['serv_id'];
				}
				/**************************************************/				
				
                $this->load->library('upload');
				sleep(1);
                if(!empty($_FILES['doc']['name']))
                {
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/docs/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg|pdf|doc|docx',
                            'max_size'      => '25000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('doc'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['doc_path'] = $data['file_name'];
                        if($this->cliente->add_VISTA_doc(array_to_upper($data_clte)))
                        {
                            send_json_ok('Se guardó de forma correcta');
							/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
							$servicios=$persona['domserv'];					
							
							$servicio='VISTA;';
							if (!(strstr($servicios,$servicio)))
							{							
								$servicios.=$servicio;
								$data_clte_id['domserv']=$servicios;
								$res=$this->cliente->actualiza_registro_individual($cliente_id, $data_clte_id);
							}
							/**************************************************/							
                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
                    send_json_error($this->upload->display_errors());
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
			/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
			$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);
			/**************************************************/			
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'persona/add_VISTA_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }




    public function nuevo_compo_doc($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
			/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
			if (($persona['serv_id'] == 0) ||(get_status_serv($persona['serv_id']) != 'PROCESO'))
			{	

					$this->form_validation->set_rules('servicio','Orden de servicio','required');
			}
            /*************************************************/					
            $this->form_validation->set_rules('nombre','Nombre documento','required');
			//$this->form_validation->set_rules('servicio','Orden de servicio','required');
			
            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_id'] =  $cliente_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                $data_clte['emp_id'] =  $this->input->post('emp_id');
				//$data_clte['serv_id'] = $this->input->post('servicio');
				/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
				if (($persona['serv_id'] == 0) || (get_status_serv($persona['serv_id']) != 'PROCESO'))
				{	
						$data_clte['serv_id']  = $this->input->post('servicio');
				}
				else
				{	
						$data_clte['serv_id']  = $persona['serv_id'];
				}
				/**************************************************/					
				
                $this->load->library('upload');
				sleep(1);
                if(!empty($_FILES['doc']['name']))
                {
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/docs/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg|pdf|doc|docx',
                            'max_size'      => '25000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('doc'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['doc_path'] = $data['file_name'];
                        if($this->cliente->add_compo_doc(array_to_upper($data_clte)))
                        {
                            send_json_ok('Se guardó de forma correcta');
							/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
							$servicios=$persona['domserv'];					
							
							$servicio='COMPO;';
							if (!(strstr($servicios,$servicio)))
							{							
								$servicios.=$servicio;
								$data_clte_id['domserv']=$servicios;
								$res=$this->cliente->actualiza_registro_individual($cliente_id, $data_clte_id);
							}
							/**************************************************/								
                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
                    send_json_error($this->upload->display_errors());
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
			/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
			$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);
			/**************************************************/			
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'persona/add_compo_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }
 
 
     public function nuevo_prevem_doc($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
		
		
        
        if(isset($_POST) && count($_POST) > 0)     
        {
			$this->cliente->borra_sgmty_doc($cliente_id);
            $this->load->library('form_validation');
            $this->form_validation->set_rules('nombre','Nombre documento','required');
			$this->form_validation->set_rules('servicio','Orden de servicio','required');
			
            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_id'] =  $cliente_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                $data_clte['emp_id'] =  $this->input->post('emp_id');
				$data_clte['serv_id'] = $this->input->post('servicio');
				$data_clte['doc_pkts'] ='';

				$i=1;
				$paquetes='';
				$fsm_pakts= get_costos_paquetes_empresa($this->input->post('emp_id'));
				if($fsm_pakts):
					foreach($fsm_pakts as $fsm_pakt):			
						$indice=str_replace(' ','_',$fsm_pakt['cost_nombre_pkt']).'_'.$i;
						if (strlen($this->input->post($indice)) > 1)
						{	
							$paquetes.=$this->input->post($indice);										
						}
						$i++;									
					endforeach;
				endif;
				$data_clte['doc_pkts'] = $paquetes;
				//$data_clte['contador']=$this->input->post('contador');

                $this->load->library('upload');
				sleep(1);
                if(!empty($_FILES['doc']['name']))
                {
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/docs/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg|pdf|doc|docx',
                            'max_size'      => '25000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('doc'))
                    {
                        //send_json_error($this->upload->display_errors());
						send_json_error('El documento nos se ha podido cargar, por favor revisa');
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['doc_path'] = $data['file_name'];
                        if($this->cliente->add_sgmty_doc(array_to_upper($data_clte)))
                        {
                            send_json_ok('Se guardó de forma correcta');
                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
                    send_json_error($this->upload->display_errors());
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
			/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
			$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);
			/**************************************************/
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'persona/add_sgmty_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }
 
    public function nuevo_sgmty_venta($cliente_id, $tipo=0)
    {
        $persona = $this->cliente->get($cliente_id);		
        
        if(isset($_POST) && count($_POST) > 0)     
        {
			$this->cliente->borra_sgmty_venta($cliente_id,$venta);
            $this->load->library('form_validation');
			$this->form_validation->set_rules('servicio','Orden de servicio','required');
			
            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_id'] =  $cliente_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                $data_clte['emp_id'] =  $this->input->post('emp_id');
				$data_clte['serv_id'] = $this->input->post('servicio');
				$data_clte['doc_pkts'] ='';

				$i=0;
				$paquetes='';
				$fsm_pakts= get_costos_paquetes_empresa($this->input->post('emp_id'));
				if($fsm_pakts):
					foreach($fsm_pakts as $fsm_pakt):			
						$indice=str_replace(' ','_',$fsm_pakt['cost_nombre_pkt']).'_'.$i;
						if (strlen($this->input->post($indice)) > 1)
						{	
							$paquetes.=$this->input->post($indice);										
						}
						$i++;									
					endforeach;
				endif;
				
				$data_clte['doc_pkts'] = $paquetes;
				$data_clte['doc_path'] = $this->input->post('cantidad');
				
                $this->load->library('upload');				

				if (strlen($data_clte['doc_path']) > 0)
				{
					$data = $this->upload->data();
					if($this->cliente->add_sgmty_doc(array_to_upper($data_clte)))
					{
						send_json_ok('Se guardó de forma correcta');
							/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
							$servicios=$persona['domserv'];					
							
							$servicio='SGMTY_VENTA;';
							if (!(strstr($servicios,$servicio)))
							{							
								$servicios.=$servicio;
								$data_clte_id['domserv']=$servicios;
								$res=$this->cliente->actualiza_registro_individual($cliente_id, $data_clte_id);
							}
							/**************************************************/						
					}
					else
					{
						send_json_error('Ocurrió un error al guardar el documento.');
					}
				}
				else 
				{
					
					send_json_error('No escribio la cantidad, por favor revisa');
				}						
					
            }
            else
            {
                send_json_error(validation_errors('¡Error!<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
			$data['tipo'] = $tipo;
			/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
			$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);
			/**************************************************/				
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'persona/add_sgmty_venta',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }

    public function nuevo_sgmty_doc($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
		
		
        
        if(isset($_POST) && count($_POST) > 0)     
        {
			//$this->cliente->borra_sgmty_doc($cliente_id);
            $this->load->library('form_validation');
			/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
			if (($persona['serv_id'] == 0) ||(get_status_serv($persona['serv_id']) != 'PROCESO'))
			{	

					$this->form_validation->set_rules('servicio','Orden de servicio','required');
			}
            /*************************************************/				
			$this->form_validation->set_rules('nombre','Nombre documento','required');
			//$this->form_validation->set_rules('servicio','Orden de servicio','required');
			
            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_id'] =  $cliente_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                $data_clte['emp_id'] =  $this->input->post('emp_id');
				//$data_clte['serv_id'] = $this->input->post('servicio');
				/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
				if (($persona['serv_id'] == 0) || (get_status_serv($persona['serv_id']) != 'PROCESO'))
				{	
						$data_clte['serv_id']  = $this->input->post('servicio');
				}
				else
				{	
						$data_clte['serv_id']  = $persona['serv_id'];
				}
				/**************************************************/					
				$data_clte['doc_pkts'] ='';

				$i=1;
				$paquetes='';
				$fsm_pakts= get_costos_paquetes_empresa($this->input->post('emp_id'));
				if($fsm_pakts):
					foreach($fsm_pakts as $fsm_pakt):			
						$indice=str_replace(' ','_',$fsm_pakt['cost_nombre_pkt']).'_'.$i;
						if (strlen($this->input->post($indice)) > 1)
						{	
							$paquetes.=$this->input->post($indice);
							if ($this->input->post('emp_id') == 182)
							{
								if (
									($fsm_pakt['cost_nombre_pkt'] == 'ANALISIS BACTERIOLOGICO DE HIELO') 
									||	($fsm_pakt['cost_nombre_pkt'] == 'ANALISIS BACTERIOLOGICO DE AGUA')
									||	($fsm_pakt['cost_nombre_pkt'] == 'CULTIVO DE ALIMENTO CRUDO')
									||	($fsm_pakt['cost_nombre_pkt'] == 'CULTIVO DE ALIMENTO COCIDO')
									||	($fsm_pakt['cost_nombre_pkt'] == 'CULTIVO DE SUPERFICIE INERTE')
									||	($fsm_pakt['cost_nombre_pkt'] == 'CULTIVO DE SUPERFICIE VIVA')
									)
									{
										$indice_muestra=$indice.'_MUESTRA';
										$paquetes=substr($paquetes, 0, -1);
										$paquetes.='x'.$this->input->post($indice_muestra).';';
									}	
							}

						}
						$i++;									
					endforeach;
				endif;
				
				$data_clte['doc_pkts'] = $paquetes;
				
                $this->load->library('upload');
				sleep(1);
				
                if(!empty($_FILES['doc']['name']))
                {
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/docs/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg|pdf|doc|docx',
                            'max_size'      => '30000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('doc'))
                    {
                        
						send_json_error('El documento nos se ha podido cargar, revisar si es de tipo PDF.');
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['doc_path'] = $data['file_name'];
                        if($this->cliente->add_sgmty_doc(array_to_upper($data_clte)))
                        {
                            send_json_ok('Se guardó de forma correcta');
							/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
							$servicios=$persona['domserv'];					
							
							$servicio='SGMTY_DOC;';
							if (!(strstr($servicios,$servicio)))
							{							
								$servicios.=$servicio;
								$data_clte_id['domserv']=$servicios;
								$res=$this->cliente->actualiza_registro_individual($cliente_id, $data_clte_id);
							}
							/**************************************************/								
							
                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
                    send_json_error($this->upload->display_errors());
                }
				
				
				
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
			/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
			$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);
			/**************************************************/			
			$this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'persona/add_sgmty_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }
  /***/ 
 
 
  public function nuevo_sgmty_doc2($cliente_id)
  {
      $persona = $this->cliente->get($cliente_id); 
	  $user = $this->session->user; 
	  $usuario = $this->medico->get($user['usr_id']);
	  
      if(isset($_POST) && count($_POST) > 0)     
      {
          $this->load->library('form_validation');
          if (($persona['serv_id'] == 0) ||(get_status_serv($persona['serv_id']) != 'PROCESO'))
          {	

                  $this->form_validation->set_rules('servicio','Orden de servicio','required');
          }
          
          $this->form_validation->set_rules('nombre','Nombre documento','required');
          
          if($this->form_validation->run())
          {
			$data_clte['clte_id'] =  $cliente_id;
			$data_clte['doc_nombre'] =  $this->input->post('nombre');
			$data_clte['doc_f'] =  date('Y-m-d H:i:s');
			$data_clte['emp_id'] =  $this->input->post('emp_id');
			
			
			$data_clte['log_insrt_f'] =  date('Y-m-d H:i:s'); 
			$data_clte['log_insrt_usr_cve'] = $usuario['usr_username'];
			$data_clte['log_insrt_prg'] =  'nuevo_sgmty_doc2';
			
			
			//$data_clte['serv_id'] = $this->input->post('servicio');

			if (($persona['serv_id'] == 0) || (get_status_serv($persona['serv_id']) != 'PROCESO'))
			{	
				$data_clte['serv_id']  = $this->input->post('servicio');
			}
			else
			{	
				$data_clte['serv_id']  = $persona['serv_id'];
			}

			//$data_clte['electror'] =  $this->input->post('electror');
			//$data_clte['electroe'] =  $this->input->post('electroe');

			$data_clte['vexitosas'] = $this->input->post('exitosas');
			$data_clte['vfallidas'] = $this->input->post('fallidas');
			$data_clte['vcanceladas'] = $this->input->post('canceladas');

						  //CAMPO DE OBSERVACIONES
			  if ($this->input->post('exitosas') >0) {$caso='<b style="color: green;"> CITA EXITOSA,' ;}
			  if ($this->input->post('fallidas') >0) {$caso='<b style="color: red;"> FALSA CITA, ';}
			  if ($this->input->post('canceladas') >0) {$caso='<b style="color: orange;"> CITA CANCELADA, ';}

			  $caso.=date('Y-m-d H:i:s').', '.$usuario['usr_username'].':</b>';
			  $observaciones=$this->input->post('observaciones');
			  if ( $observaciones == '') {$observaciones=' SIN OBSERVACIONES. ';}
			  $data_clte['observaciones'] =$caso.'<b style="color: black;">'.$observaciones.'</b><br><br>';
			
			$data_clte['observaciones_rep'] = $observaciones;
			$data_clte['ciudad_rep'] = $this->input->post('ciudad_rep');
			$data_clte['viaticos_rep'] = $this->input->post('viaticos_rep');
			
			$data_clte['estatus'] = $this->input->post('estatus');
              
            $this->load->library('upload');
            sleep(1);
              
			if ( (!empty($_FILES['doc']['name'])) && ($data_clte['vexitosas'] > 0) )
			{
				$filename = md5(time());
				$config = array(
					'upload_path'   => './../../files/docs/',
					'overwrite'     => TRUE,
					'file_name'     => $filename,
					'allowed_types' => 'png|jpg|jpeg|pdf|doc|docx',
					'max_size'      => '30000'
				);

                $this->upload->initialize($config);                  
                  
				if (!$this->upload->do_upload('doc'))
				{                        
					send_json_error('El documento nos se ha podido cargar, por favor revisa');
				}
				else 
				{
					$data = $this->upload->data();
					$data_clte['doc_path'] = $data['file_name'];

					$existe=$this->cliente->chk_sgmty_doc($cliente_id,$data_clte['emp_id']);

					if ($existe)
					{
						$clte=$this->cliente->update_sgmty_doc($existe['doc_id'], array_to_upper($data_clte));
					}	
					else
					{
						$clte=$this->cliente->add_sgmty_doc(array_to_upper($data_clte));
					}	
                      
                      
                     // if($this->cliente->add_sgmty_doc(array_to_upper($data_clte)))
                      if($clte)	
                      {
                        send_json_ok('Se realizo el registro de manera correcta');  
						//send_json_ok(array('msg' =>'Se realizo el registro de manera correcta', 'id' => $persona['clte_id']));
                      }
                      else
                      {
                          send_json_error('Ocurrió un error al guardar el documento.');
                      }
                  }
            }
            else
            {	
                  if (($data_clte['vfallidas'] > 0) || ($data_clte['vcanceladas'] > 0))
                  {

                      $existe=$this->cliente->chk_sgmty_doc($cliente_id,$data_clte['emp_id']);
                      if ($existe)
                      {
                          $data_clte['vfallidas'] = $existe['vfallidas']+$data_clte['vfallidas'];
                          $data_clte['vcanceladas'] = $existe['vcanceladas']+$data_clte['vcanceladas'];
                          
                          $clte=$this->cliente->update_sgmty_doc($existe['doc_id'], array_to_upper($data_clte));
                      }	
                      else
                      {
                          $clte=$this->cliente->add_sgmty_doc(array_to_upper($data_clte));
                      }					

                      //$this->cliente->add_sgmty_doc(array_to_upper($data_clte));
                      send_json_ok('Se registro de forma correcta.');
                  }
                  else
                  {	
                      //send_json_error($this->upload->display_errors());
                      send_json_error('Ocurrió un error al registrar los resultados de la visita.'.$data_clte['vfallidas'].'|');
                  }
            }
          }
          else
          {
              send_json_error(validation_errors('<div />'));
          }
      }
      else 
      {
		  $data['persona'] = $persona;
		  $data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);          
		  $this->load->helper('template');  
		  $data['regiones'] = $this->servicio->get_regiones_sgmty();
		  $params_view = array(
			  'title' => 'Personas',
			  'view' => 'persona/add_sgmty_doc2',
			  'view_data' => $data
			 );
		  render_template($params_view);  
      }
  }




  public function edita_sgmty_doc2($cliente_id,$doc_id)
  {
      $persona = $this->cliente->get($cliente_id); 
      $fsm= $this->cliente->get_doc_sgmty($cliente_id,$doc_id);
	  $user = $this->session->user; 
	  $usuario = $this->medico->get($user['usr_id']);
  
      if(isset($_POST) && count($_POST) > 0)     
      {
        /*  $this->load->library('form_validation');
          if (($persona['serv_id'] == 0) ||(get_status_serv($persona['serv_id']) != 'PROCESO'))
          {	

                  $this->form_validation->set_rules('servicio','Orden de servicio','required');
          }
          
          $this->form_validation->set_rules('nombre','Nombre documento','required');
          //$this->form_validation->set_rules('servicio','Orden de servicio','required');
          */
          
          if($fsm)
          {
              $data_clte['clte_id'] =  $fsm['clte_id'];
              $data_clte['doc_nombre'] =  $fsm['doc_nombre'];
              $data_clte['doc_f'] =  $fsm['doc_f'];
              $data_clte['emp_id'] =  $fsm['emp_id'];
              $data_clte['serv_id'] =$fsm['serv_id'];
              $data_clte['doc_path'] = $fsm['doc_path'];
			  
			$data_clte['log_updt_f'] =  date('Y-m-d H:i:s'); 
			$data_clte['log_updt_usr_cve'] = $usuario['usr_username'];
			$data_clte['log_updt_prg'] =  'edita_sgmty_doc2';

			/*  $data_clte['electror'] =  $this->input->post('electror');
			  $data_clte['electroe'] =  $this->input->post('electroe');
			  $regional=explode(";",$this->input->post('regioness'));
			  $data_clte['cei_region'] =$regional[0];
			  $data_clte['region_region'] =$regional[1];
			  $data_clte['region_precio'] =$regional[2];*/

			  $data_clte['vexitosas'] = $fsm['vexitosas']+$this->input->post('exitosas');
			  $data_clte['vfallidas'] = $fsm['vfallidas']+$this->input->post('fallidas');
			  $data_clte['vcanceladas'] = $fsm['vcanceladas']+$this->input->post('canceladas');
			  //CAMPO DE OBSERVACIONES
			  if ($this->input->post('exitosas') >0) {$caso='<b style="color: green;"> CITA EXITOSA,' ;}
			  if ($this->input->post('fallidas') >0) {$caso='<b style="color: red;"> FALSA CITA, ';}
			  if ($this->input->post('canceladas') >0) {$caso='<b style="color: orange;"> CITA CANCELADA, ';}

			  $caso.=date('Y-m-d H:i:s').', '.$usuario['usr_username'].':</b>';
			  $observaciones=$this->input->post('observaciones');
			  if ( $observaciones == '') {$observaciones=' SIN OBSERVACIONES. ';}
			  $data_clte['observaciones'] =$fsm['observaciones'].$caso.'<b style="color: black;">'.$observaciones.'</b><br><br>';
	          $data_clte['ciudad_rep'] = $this->input->post('ciudad_rep');
			  $data_clte['viaticos_rep'] = $this->input->post('viaticos_rep');
              $this->load->library('upload');
              sleep(1);
              
              if ( (!empty($_FILES['doc']['name'])) && ($data_clte['vexitosas'] == 1) )
              {
                  $filename = md5(time());
                  $config = array(
                          'upload_path'   => './../../files/docs/',
                          'overwrite'     => TRUE,
                          'file_name'     => $filename,
                          'allowed_types' => 'png|jpg|jpeg|pdf|doc|docx',
                          'max_size'      => '30000'
                  );

                  $this->upload->initialize($config);
                  if ( ! $this->upload->do_upload('doc'))
                  {
                      
                      send_json_error('El documento nos se ha podido cargar, por favor revisa');
                  }
                  else 
                  {
                      $data = $this->upload->data();
                      $data_clte['doc_path'] = $data['file_name'];
                      if($this->cliente->update_sgmty_doc($doc_id,array_to_upper($data_clte)))
                      {
                          send_json_ok('Se guardó de forma correcta el documento.');
                          
                        /*      if ($data_clte['electroe'] == 1 )
                              {	
                                  $data_electroe['clte_id'] =  $cliente_id;
                                  $data_electroe['doc_nombre'] =  "ELECTROCARDIOGRAMA CON ESFUERZO";
                                  $data_electroe['doc_f'] =  date('Y-m-d H:i:s');
                                  $data_electroe['emp_id'] =  $data_clte['emp_id'];
                                  $data_electroe['serv_id'] =  $data_clte['serv_id'] ;
                                  $data_electroe['doc_path'] = $data_clte['doc_path'];
                                  $this->cliente->add_ELECTROE_doc(array_to_upper($data_electroe));
                              }
                              
                              if ($data_clte['electror'] == 1 )
                              {	
                                  $data_electror['clte_id'] =  $cliente_id;
                                  $data_electror['doc_nombre'] =  "ELECTROCARDIOGRAMA CON ESFUERZO";
                                  $data_electror['doc_f'] =  date('Y-m-d H:i:s');
                                  $data_electror['emp_id'] =  $data_clte['emp_id'];
                                  $data_electror['serv_id'] =  $data_clte['serv_id'] ;
                                  $data_electror['doc_path'] = $data_clte['doc_path'];
                                  $this->cliente->add_ELECTROR_doc(array_to_upper($data_electror));

                              }
                          */
                          $servicios=$persona['domserv'];					
                          
                          $servicio='SGMTY_DOC;';
                          if (!(strstr($servicios,$servicio)))
                          {							
                              $servicios.=$servicio;
                              $data_clte_id['domserv']=$servicios;
                              $res=$this->cliente->actualiza_registro_individual($cliente_id, $data_clte_id);
                          }
                      }
                      else
                      {
                          send_json_error('Ocurrió un error al guardar el documento.');
                      }
                  }
              }
              else
              {	
                  if ($data_clte['vexitosas'] > 0)
                  {
                      send_json_error('No es exitoso si no subes el archivo de resultados.');
                  }
                  else
                  {
                      if ( ($data_clte['vfallidas'] > 0) || ($data_clte['vcanceladas'] > 0) )
                      {
                          
                          if($this->cliente->update_sgmty_doc($doc_id,array_to_upper($data_clte)))
                          {
                              send_json_ok('Se Registro de forma correcta la anotación de la visita');
                          }
                          else
                          {
                              send_json_error('Ocurrió un error al hacer el registro.');
                          }	
                      }
                      else
                      {	
                          send_json_error($this->upload->display_errors());
                      }
                  }
              }
          }
          else
          {
              send_json_error(validation_errors('<div />'));
          }
      }
      else 
      {
          $data['persona'] = $persona;
          $data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);
          
          $this->load->helper('template');
  
          $data['regiones'] = $this->servicio->get_regiones_sgmty();
          $data['fsm'] = $fsm; 
          $params_view = array(
              'title' => 'Personas',
              'view' => 'persona/edit_sgmty_doc2',
              'view_data' => $data
             );

          render_template($params_view);  
      }
  }

  public function edita_sgmty_com($cliente_id,$doc_id)
  {
      $persona = $this->cliente->get($cliente_id); 
      $fsm= $this->cliente->get_doc_sgmty($cliente_id,$doc_id);
  
      if(isset($_POST) && count($_POST) > 0)     
      {
        /*  $this->load->library('form_validation');
          if (($persona['serv_id'] == 0) ||(get_status_serv($persona['serv_id']) != 'PROCESO'))
          {	

                  $this->form_validation->set_rules('servicio','Orden de servicio','required');
          }
          
          $this->form_validation->set_rules('nombre','Nombre documento','required');
          //$this->form_validation->set_rules('servicio','Orden de servicio','required');
          */
          
          if($fsm)
          {
              $data_clte['clte_id'] =  $fsm['clte_id'];
              $data_clte['doc_nombre'] =  $fsm['doc_nombre'];
              $data_clte['doc_f'] =  $fsm['doc_f'];
              $data_clte['emp_id'] =  $fsm['emp_id'];
              $data_clte['serv_id'] =$fsm['serv_id'];
              $data_clte['doc_path'] = $fsm['doc_path'];


                  $data_clte['electror'] =  $this->input->post('electror');
                  $data_clte['electroe'] =  $this->input->post('electroe');
                  $regional=explode(";",$this->input->post('regioness'));
                  $data_clte['cei_region'] =$regional[0];
                  $data_clte['region_region'] =$regional[1];
                  $data_clte['region_precio'] =$regional[2];

                  $data_clte['vexitosas'] = $fsm['vexitosas']+$this->input->post('exitosas');
                  $data_clte['vfallidas'] = $fsm['vfallidas']+$this->input->post('fallidas');
                  $data_clte['vcanceladas'] = $fsm['vcanceladas']+$this->input->post('canceladas');
                  //CAMPO DE OBSERVACIONES
                  $data_clte['observaciones'] = $this->input->post('observaciones');
              
              $this->load->library('upload');
              sleep(1);
              
              if ( (!empty($_FILES['doc']['name'])) && ($data_clte['vexitosas'] == 1) )
              {
                  $filename = md5(time());
                  $config = array(
                          'upload_path'   => './../../files/docs/',
                          'overwrite'     => TRUE,
                          'file_name'     => $filename,
                          'allowed_types' => 'png|jpg|jpeg|pdf|doc|docx',
                          'max_size'      => '30000'
                  );

                  $this->upload->initialize($config);
                  if ( ! $this->upload->do_upload('doc'))
                  {
                      
                      send_json_error('El documento nos se ha podido cargar, por favor revisa');
                  }
                  else 
                  {
                      $data = $this->upload->data();
                      $data_clte['doc_path'] = $data['file_name'];
                      if($this->cliente->update_sgmty_doc($doc_id,array_to_upper($data_clte)))
                      {
                          send_json_ok('Se guardó de forma correcta el documento.');
                          
                              if ($data_clte['electroe'] == 1 )
                              {	
                                  $data_electroe['clte_id'] =  $cliente_id;
                                  $data_electroe['doc_nombre'] =  "ELECTROCARDIOGRAMA CON ESFUERZO";
                                  $data_electroe['doc_f'] =  date('Y-m-d H:i:s');
                                  $data_electroe['emp_id'] =  $data_clte['emp_id'];
                                  $data_electroe['serv_id'] =  $data_clte['serv_id'] ;
                                  $data_electroe['doc_path'] = $data_clte['doc_path'];
                                  $this->cliente->add_ELECTROE_doc(array_to_upper($data_electroe));
                              }
                              
                              if ($data_clte['electror'] == 1 )
                              {	
                                  $data_electror['clte_id'] =  $cliente_id;
                                  $data_electror['doc_nombre'] =  "ELECTROCARDIOGRAMA CON ESFUERZO";
                                  $data_electror['doc_f'] =  date('Y-m-d H:i:s');
                                  $data_electror['emp_id'] =  $data_clte['emp_id'];
                                  $data_electror['serv_id'] =  $data_clte['serv_id'] ;
                                  $data_electror['doc_path'] = $data_clte['doc_path'];
                                  $this->cliente->add_ELECTROR_doc(array_to_upper($data_electror));

                              }
                          
                          $servicios=$persona['domserv'];					
                          
                          $servicio='SGMTY_DOC;';
                          if (!(strstr($servicios,$servicio)))
                          {							
                              $servicios.=$servicio;
                              $data_clte_id['domserv']=$servicios;
                              $res=$this->cliente->actualiza_registro_individual($cliente_id, $data_clte_id);
                          }
                      }
                      else
                      {
                          send_json_error('Ocurrió un error al guardar el documento.');
                      }
                  }
              }
              else
              {	
                  if ($data_clte['vexitosas'] > 0)
                  {
                      send_json_error('No es exitoso si no subes el archivo de resultados.');
                  }
                  else
                  {
                      if ( ($data_clte['vfallidas'] > 0) || ($data_clte['vcanceladas'] > 0) )
                      {
                          
                          if($this->cliente->update_sgmty_doc($doc_id,array_to_upper($data_clte)))
                          {
                              send_json_ok('Se Registro de forma correcta la anotación de la visita');
                          }
                          else
                          {
                              send_json_error('Ocurrió un error al hacer el registro.');
                          }	
                      }
                      else
                      {	
                          send_json_error($this->upload->display_errors());
                      }
                  }
              }
          }
          else
          {
              send_json_error(validation_errors('<div />'));
          }
      }
      else 
      {
          $data['persona'] = $persona;
          $data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);
          
          $this->load->helper('template');
  
          $data['regiones'] = $this->servicio->get_regiones_sgmty();
          $data['fsm'] = $fsm; 
          $params_view = array(
              'title' => 'Personas',
              'view' => 'persona/edit_sgmty_com',
              'view_data' => $data
             );

          render_template($params_view);  
      }
  }



    public function edita_sgmty_doc3($cliente_id,$doc_id)
    {
        $persona = $this->cliente->get($cliente_id); 
		$fsm= $this->cliente->get_doc_sgmty($cliente_id,$doc_id);
	
        if(isset($_POST) && count($_POST) > 0)     
        {
          /*  $this->load->library('form_validation');
			if (($persona['serv_id'] == 0) ||(get_status_serv($persona['serv_id']) != 'PROCESO'))
			{	

					$this->form_validation->set_rules('servicio','Orden de servicio','required');
			}
			
			$this->form_validation->set_rules('nombre','Nombre documento','required');
			//$this->form_validation->set_rules('servicio','Orden de servicio','required');
			*/
			
            if($fsm)
            {
            /*    $data_clte['clte_id'] =  $fsm['clte_id'];
                $data_clte['doc_nombre'] =  $fsm['doc_nombre'];
                $data_clte['doc_f'] =  $fsm['doc_f'];
                $data_clte['emp_id'] =  $fsm['emp_id'];
				$data_clte['serv_id'] =$fsm['serv_id'];
				$data_clte['doc_path'] = $fsm['doc_path'];


					$data_clte['electror'] =  $this->input->post('electror');
					$data_clte['electroe'] =  $this->input->post('electroe');
			*/		
					
					$regional=explode(";",$this->input->post('regioness'));
					$clte_clte['clte_region']=$this->input->post('regioness');
					$data_clte['cei_region'] =$regional[0];
					$data_clte['region_region'] =$regional[1];
					$data_clte['region_precio'] =$regional[2];

			/*
					$data_clte['vexitosas'] = $fsm['vexitosas']+$this->input->post('exitosas');
					$data_clte['vfallidas'] = $fsm['vfallidas']+$this->input->post('fallidas');
					$data_clte['vcanceladas'] = $fsm['vcanceladas']+$this->input->post('canceladas');

			*/	

				if($this->cliente->update_sgmty_doc($doc_id,array_to_upper($data_clte)))
				{
					$this->cliente->actualiza($cliente_id, $clte_clte);	
					send_json_ok('Se actualizo la región del documento.');
					
					
				}
				else
				{
					send_json_error('Ocurrió un error al guardar el documento.');
				}

            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
			$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);
			
			$this->load->helper('template');
	
			$data['regiones'] = $this->servicio->get_regiones_sgmty();
			$data['fsm'] = $fsm; 
			$params_view = array(
				'title' => 'Personas',
				'view' => 'persona/edit_sgmty_doc4',
				'view_data' => $data
			   );

            render_template($params_view);  
        }
    }

    public function nuevo_gnp_doc($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
		
		
        
        if(isset($_POST) && count($_POST) > 0)     
        {
			//$this->cliente->borra_sgmty_doc($cliente_id);
            $this->load->library('form_validation');
            $this->form_validation->set_rules('nombre','Nombre documento','required');
			$this->form_validation->set_rules('servicio','Orden de servicio','required');
			
            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_id'] =  $cliente_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                $data_clte['emp_id'] =  $this->input->post('emp_id');
				$data_clte['serv_id'] = $this->input->post('servicio');
				$data_clte['doc_pkts'] ='';


                $this->load->library('upload');
				sleep(1);
                if(!empty($_FILES['doc']['name']))
                {
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/docs/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg|pdf|doc|docx',
                            'max_size'      => '25000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('doc'))
                    {
                        //send_json_error($this->upload->display_errors());
						send_json_error('El documento nos se ha podido cargar, por favor revisa');
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['doc_path'] = $data['file_name'];
                        if($this->cliente->add_sgmty_doc(array_to_upper($data_clte)))
                        {
                            send_json_ok('Se guardó de forma correcta');
                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
                    send_json_error($this->upload->display_errors());
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
			$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);
            $data['persona'] = $persona;
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'persona/add_sgmty_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }


    public function nuevo_grals_doc($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);		
        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
			$this->form_validation->set_rules('comentarios','Comentario','required');
			
            if($this->form_validation->run())
            {
                $data_clte['clte_id'] =  $cliente_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                $data_clte['emp_id'] =  $this->input->post('emp_id');
				$data_clte['serv_id'] = $this->input->post('servicio');
				$data_clte['comentarios'] = $this->input->post('comentarios');				
				$data_clte['electror'] = $this->input->post('electror');
				$data_clte['electroe'] = $this->input->post('electroe');				
				$data_clte['doc_pkts'] ='';

                if(!empty($_FILES['documento']['name']))
                {                    
					$pre_croquis= carga_pdf('documento','./../../files/docs/');

					if (!($pre_croquis))
                    {                        
						send_json_error('El documento nos se ha podido cargar, por favor revisa');
                    }
                    else 
                    {
						
						$data_clte['doc_path'] = $pre_croquis;
                        if($this->cliente->add_sgmty_doc(array_to_upper($data_clte)))
                        {	
				
							send_json_ok(array('msg' =>'Se realizo la carga del archivo', 'id' => $cliente_id));
                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
					send_json_error('Se requiere el DOCUMENTO MÉDICO.');
                }				
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
			$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);
            $data['persona'] = $persona;
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'persona/add_grals_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }



public function add_fotos_siniestros_jpg($sin_id,$folio,$detalle,$modo)
    {
       // $persona = $this->cliente->get($cliente_id);
        if(isset($_POST) && count($_POST) > 0)     
        {
			if(1)				
            {
                if(!empty($_FILES['documento']['name']))
                {
                    
					if ($modo == 'SIN')
					{	
							$ruta='./../../files/sura_iv_siniestrados';
							$data_clte['sin_latitud_sin'] = $this->input->post('biu_latitud');	
							$data_clte['sin_longitud_sin'] = $this->input->post('biu_longitud');								
							
							
					}
					elseif ($modo == 'REP')
					{
							$ruta='./../../files/sura_iv_reparados/';
							$data_clte['sin_latitud_rep'] = $this->input->post('biu_latitud');	
							$data_clte['sin_longitud_rep'] = $this->input->post('biu_longitud');								
					}




					$pre_croquis= carga_imagen_siniestro('documento',$ruta,$folio.'_'.$sin_id,$detalle,$modo);
						
					if (!($pre_croquis))
                    {                        
						send_json_error('El documento nos se ha podido cargar, por favor revisa');
                    }
                    else 
                    {
						$campo =  $this->input->post('campo');
						$data_clte[$campo] = $pre_croquis;
                        if ($this->asegurado->actualiza_siniestro($sin_id, $data_clte))
                        {	
							send_json_ok(array('msg' =>'Se realizo la carga del archivo', 'id' => $sin_id));
                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
					send_json_error('Se requiere el documento.');
                }				
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
			$data['paquete'] = $paquete;
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'persona/add_renovacion_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }



    public function nuevo_renovaciones_doc($cliente_id,$paquete)
    {
        $persona = $this->cliente->get($cliente_id);
        if(isset($_POST) && count($_POST) > 0)     
        {
			if(1)				
            {
                $data_clte['clte_id'] =  $cliente_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                $data_clte['emp_id'] =  $this->input->post('emp_id');
				$data_clte['serv_id'] = $this->input->post('serv_id');
				$data_clte['doc_pkts'] = $paquete;

                if(!empty($_FILES['documento']['name']))
                {
                    
					$pre_croquis= carga_pdf('documento','./../../files/docs_renovaciones/');

					if (!($pre_croquis))
                    {                        
						send_json_error('El documento nos se ha podido cargar, por favor revisa');
                    }
                    else 
                    {

						$data_clte['doc_path'] = $pre_croquis;
                        if($this->cliente->add_renovaciones_doc(array_to_upper($data_clte),$paquete))
                        {	
							send_json_ok(array('msg' =>'Se realizo la carga del archivo', 'id' => $cliente_id));
                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
					send_json_error('Se requiere el documento.');
                }				
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
			$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);
            $data['persona'] = $persona;
			$data['paquete'] = $paquete;
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'persona/add_renovacion_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }


  public function borra_renovacion($doc_id,$paquete)
    {
        if ($this->cliente->borra_renovacion($doc_id,$paquete))
        {
            send_json_ok('Se eliminó de forma correcta.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar.');
        }
    }





    public function nuevo_pensante_doc($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
        if(isset($_POST) && count($_POST) > 0)     
        {
			if(1)				
            {
                $data_clte['clte_id'] =  $cliente_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                $data_clte['emp_id'] =  $this->input->post('emp_id');
				$data_clte['serv_id'] = $this->input->post('servicio');
				$data_clte['doc_pkts'] ='PROCESO PENSANTE';

                if(!empty($_FILES['documento']['name']))
                {
                    
					$pre_croquis= carga_pdf('documento','./../../files/docs_psico/');

					if (!($pre_croquis))
                    {                        
						send_json_error('El documento nos se ha podido cargar, por favor revisa');
                    }
                    else 
                    {

						$data_clte['doc_path'] = $pre_croquis;
                        if($this->cliente->add_pensante_doc(array_to_upper($data_clte)))
                        {	
							send_json_ok(array('msg' =>'Se realizo la carga del archivo', 'id' => $cliente_id));
                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
					send_json_error('Se requiere el documento.');
                }				
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
			$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);
            $data['persona'] = $persona;
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'persona/add_pensante_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }

    public function nuevo_vendedor_doc($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
        if(isset($_POST) && count($_POST) > 0)     
        {
			$this->load->library('form_validation');

			//if (($persona['serv_id'] == 0) || (get_status_serv($persona['serv_id']) != 'PROCESO'))
			//{
					$this->form_validation->set_rules('serv_id','Orden de servicio','required');
			//}
			
            $this->form_validation->set_rules('nombre','Nombre documento','required');

			
            if($this->form_validation->run())				
            {
                //informncion general de la pérsona
                $data_clte['clte_id'] =  $cliente_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                $data_clte['emp_id'] =  $this->input->post('emp_id');
				$data_clte['serv_id'] = $this->input->post('serv_id');
				//$data_clte['comentarios'] = $this->input->post('comentarios');
				$data_clte['doc_pkts'] ='PERFIL DE VENDEDOR';

				if ($data_clte['serv_id'] != 0 )
				{	
						if(!empty($_FILES['documento']['name']))
						{
							
							$pre_croquis= carga_pdf('documento','./../../files/docs_psico/');

							if (!($pre_croquis))
							{                        
								send_json_error('El documento nos se ha podido cargar, por favor revisa');
							}
							else 
							{

								$data_clte['doc_path'] = $pre_croquis;
								if($this->cliente->add_vendedor_doc(array_to_upper($data_clte)))
								{	
									send_json_ok(array('msg' =>'Se realizo la carga del archivo', 'id' => $cliente_id));
								}
								else
								{
									//echo 'adios';
									send_json_error('Ocurrió un error al guardar el documento.');
								}
							}
						}
						else
						{
							send_json_error('Se requiere el documento.');
						}	
				}
				else
				{
					send_json_error('Se requiere la Orden de servicio.');
				}
				
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
			$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);
            $data['persona'] = $persona;
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'persona/add_vendedor_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }


    public function nuevo_allianz_doc_email($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
		/* no hay analistas fijos en ALLIANZ
		$analista=get_usr_username($persona ['log_insrt_usr_cve']);	
		*/
		
		
        if(isset($_POST) && count($_POST) > 0)     
        {

			/* se omite por seguridad
			$this->cliente->borra_sgmty_doc($cliente_id);
			*/
            $this->load->library('form_validation');
			$this->form_validation->set_rules('nombre','Nombre documento','required');
			$this->form_validation->set_rules('servicio','Orden de servicio','required');
			
            if($this->form_validation->run())
            {
                $data_clte['clte_id'] =  $cliente_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                $data_clte['emp_id'] =  $this->input->post('emp_id');
				$data_clte['serv_id'] = $this->input->post('servicio');
				$data_clte['doc_pkts'] ='';

				$i=1;
				$paquetes='';
				$fsm_pakts= get_costos_paquetes_empresa($this->input->post('emp_id'));
				if($fsm_pakts):
					foreach($fsm_pakts as $fsm_pakt):			
						$indice=str_replace(' ','_',$fsm_pakt['cost_nombre_pkt']).'_'.$i;
						if (strlen($this->input->post($indice)) > 1)
						{	
							$paquetes.=$this->input->post($indice);										
						}
						$i++;									
					endforeach;
				endif;
				$data_clte['doc_pkts'] = $paquetes;

                if(!empty($_FILES['documento']['name']))
                {                    
					$pre_croquis= carga_pdf('documento','./../../files/docs/');

					if (!($pre_croquis))
                    {                        
						send_json_error('El documento nos se ha podido cargar, por favor revisa');
                    }
                    else 
                    {
						$data_clte['doc_path'] = $pre_croquis;
                        if($this->cliente->add_sgmty_doc(array_to_upper($data_clte)))
                        {	
							
							$data_email['persona']=$persona; 
							$data_email['data_clte']=array_to_upper($data_clte);
							
							$html = $this->load->view('persona/email_notificacion_insignia_reportes',$data_email,TRUE);
							$this->load->helper('mail');
						
							send_email_notificacion_insignia_reportes($analista,
										$persona['clte_nombre'].' '.$persona['clte_2_nombre'].' '.$persona['clte_paterno'].' '.$persona['clte_materno'],
										$persona['emp_id'],
										$persona['serv_id'],
										$persona['clte_webflow'],$html);
					
							$data_clte1['clte_status_proc'] = 'CONCLUÍDO';
							$res=$this->cliente->actualiza_registro_individual($cliente_id, $data_clte1);
					
					
							send_json_ok(array('msg' =>'Se realizo la carga del archivo', 'id' => $cliente_id));
                            
                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
					send_json_error('Se requiere el DOCUMENTO MÉDICO.');
                }				
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
			$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);
            $data['persona'] = $persona;
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'persona/add_insignia_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }




    public function nuevo_insignia_doc($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
		$analista=get_usr_username($persona ['log_insrt_usr_cve']);	
        if(isset($_POST) && count($_POST) > 0)     
        {
			//$this->cliente->borra_sgmty_doc($cliente_id);
            $this->load->library('form_validation');
            //$this->form_validation->set_rules('documento','el Archivo a Cargar ','required');
			$this->form_validation->set_rules('comentarios','Comentario','required');
			
            if($this->form_validation->run())
            {
                $data_clte['clte_id'] =  $cliente_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                $data_clte['emp_id'] =  $this->input->post('emp_id');
				$data_clte['serv_id'] = $this->input->post('servicio');
				$data_clte['comentarios'] = $this->input->post('comentarios');
				
				$data_clte['electror'] = $this->input->post('electror');
				$data_clte['electroe'] = $this->input->post('electroe');
				
				$data_clte['doc_pkts'] ='';

                if(!empty($_FILES['documento']['name']))
                {                    
					$pre_croquis= carga_pdf('documento','./../../files/docs/');

					if (!($pre_croquis))
                    {                        
						send_json_error('El documento nos se ha podido cargar, por favor revisa');
                    }
                    else 
                    {
						$data_clte['doc_path'] = $pre_croquis;
                        if($this->cliente->add_sgmty_doc(array_to_upper($data_clte)))
                        {	
							
							$data_email['persona']=$persona; 
							$data_email['data_clte']=array_to_upper($data_clte);
							
							$html = $this->load->view('persona/email_notificacion_insignia_reportes',$data_email,TRUE);
							$this->load->helper('mail');
						
							send_email_notificacion_insignia_reportes($analista,
										$persona['clte_nombre'].' '.$persona['clte_2_nombre'].' '.$persona['clte_paterno'].' '.$persona['clte_materno'],
										$persona['emp_id'],
										$persona['serv_id'],
										$persona['clte_webflow'],$html);
					
							$data_clte1['clte_status_proc'] = 'CONCLUÍDO';
							$res=$this->cliente->actualiza_registro_individual($cliente_id, $data_clte1);
					
					
							send_json_ok(array('msg' =>'Se realizo la carga del archivo', 'id' => $cliente_id));
                            
                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
					send_json_error('Se requiere el DOCUMENTO MÉDICO.');
                }				
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
			$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);
            $data['persona'] = $persona;
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'persona/add_insignia_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }
 

 
    public function nuevo_axa_doc($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
		
		
        
        if(isset($_POST) && count($_POST) > 0)     
        {
			//$this->cliente->borra_sgmty_doc($cliente_id);
            $this->load->library('form_validation');
            $this->form_validation->set_rules('nombre','Nombre documento','required');
			$this->form_validation->set_rules('servicio','Orden de servicio','required');
			
            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_id'] =  $cliente_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                $data_clte['emp_id'] =  $this->input->post('emp_id');
				$data_clte['serv_id'] = $this->input->post('servicio');
				$data_clte['doc_pkts'] ='';

				$i=1;
				$paquetes='';
				$fsm_pakts= get_costos_paquetes_empresa($this->input->post('emp_id'));
				if($fsm_pakts):
					foreach($fsm_pakts as $fsm_pakt):			
						$indice=str_replace(' ','_',$fsm_pakt['cost_nombre_pkt']).'_'.$i;
						if (strlen($this->input->post($indice)) > 1)
						{	
							$paquetes.=$this->input->post($indice);										
						}
						$i++;									
					endforeach;
				endif;
				$data_clte['doc_pkts'] = $paquetes;
				//$data_clte['contador']=$this->input->post('contador');

                $this->load->library('upload');
				sleep(1);
                if(!empty($_FILES['doc']['name']))
                {
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/docs/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg|pdf|doc|docx',
                            'max_size'      => '25000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('doc'))
                    {
                        //send_json_error($this->upload->display_errors());
						send_json_error('El documento nos se ha podido cargar, por favor revisa');
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['doc_path'] = $data['file_name'];
                        if($this->cliente->add_sgmty_doc(array_to_upper($data_clte)))
                        {
                            send_json_ok('Se guardó de forma correcta');
                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
                    send_json_error($this->upload->display_errors());
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
			$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);
            $data['persona'] = $persona;
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'persona/add_sgmty_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }
 
 
 
    public function nuevo_allianz_doc($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
		
		
        
        if(isset($_POST) && count($_POST) > 0)     
        {
			//$this->cliente->borra_sgmty_doc($cliente_id);
            $this->load->library('form_validation');
            $this->form_validation->set_rules('nombre','Nombre documento','required');
			$this->form_validation->set_rules('servicio','Orden de servicio','required');
			
            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_id'] =  $cliente_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                $data_clte['emp_id'] =  $this->input->post('emp_id');
				$data_clte['serv_id'] = $this->input->post('servicio');
				$data_clte['doc_pkts'] ='';

				$i=1;
				$paquetes='';
				$fsm_pakts= get_costos_paquetes_empresa($this->input->post('emp_id'));
				if($fsm_pakts):
					foreach($fsm_pakts as $fsm_pakt):			
						$indice=str_replace(' ','_',$fsm_pakt['cost_nombre_pkt']).'_'.$i;
						if (strlen($this->input->post($indice)) > 1)
						{	
							$paquetes.=$this->input->post($indice);										
						}
						$i++;									
					endforeach;
				endif;
				$data_clte['doc_pkts'] = $paquetes;
               
			   $this->load->library('upload');
				sleep(1);
                if(!empty($_FILES['doc']['name']))
                {
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/docs/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg|pdf|doc|docx',
                            'max_size'      => '25000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('doc'))
                    {
                        //send_json_error($this->upload->display_errors());
						send_json_error('El documento nos se ha podido cargar, por favor revisa');
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['doc_path'] = $data['file_name'];
                        if($this->cliente->add_sgmty_doc(array_to_upper($data_clte)))
                        {
                            send_json_ok('Se guardó de forma correcta');
                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
                    send_json_error($this->upload->display_errors());
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
			$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'persona/add_sgmty_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }


    public function nuevo_MARINA_doc($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');

		/*	if (($persona['serv_id'] == 0) ||(get_status_serv($persona['serv_id']) != 'PROCESO'))
			{
					$this->form_validation->set_rules('servicio','Orden de servicio','required');
			}
		*/	
            $this->form_validation->set_rules('nombre','Nombre documento','required');

			
            if($this->form_validation->run())
            {

                $data_clte['clte_id'] =  $cliente_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                $data_clte['emp_id'] =  $this->input->post('emp_id');

			/*	if (($persona['serv_id'] == 0) || (get_status_serv($persona['serv_id']) != 'PROCESO'))
				{	
						$data_clte['serv_id']  = $this->input->post('servicio');
				}
				else*/
				{	
						$data_clte['serv_id']  = $persona['serv_id'];
				}

                if(!empty($_FILES['doc']['name']))
                {                    
					$pre_croquis= carga_pdf('doc','./../../files/docs_TM/');

					if (!($pre_croquis))
                    {                        
						send_json_error('El documento nos se ha podido cargar, por favor revisa.');
                    }
                    else 
                    {
						$data_clte['doc_path'] = $pre_croquis;
                        if($this->cliente->add_MARINA_doc(array_to_upper($data_clte)))
						{
                            send_json_ok(array('msg' =>'Se realizo la carga del archivo', 'id' => $cliente_id));

                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
                    send_json_error($this->upload->display_errors());
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
			$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'persona/add_MARINA_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }

    public function nuevo_PPSM16PF_doc($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');

			if (($persona['serv_id'] == 0) ||(get_status_serv($persona['serv_id']) != 'PROCESO'))
			{
					$this->form_validation->set_rules('servicio','Orden de servicio','required');
			}
			
            $this->form_validation->set_rules('nombre','Nombre documento','required');

			
            if($this->form_validation->run())
            {

                $data_clte['clte_id'] =  $cliente_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                $data_clte['emp_id'] =  $this->input->post('emp_id');

				if (($persona['serv_id'] == 0) || (get_status_serv($persona['serv_id']) != 'PROCESO'))
				{	
						$data_clte['serv_id']  = $this->input->post('servicio');
				}
				else
				{	
						$data_clte['serv_id']  = $persona['serv_id'];
				}

                if(!empty($_FILES['doc']['name']))
                {                    
					$pre_croquis= carga_pdf('doc','./../../files/docs_psico/');

					if (!($pre_croquis))
                    {                        
						send_json_error('El documento nos se ha podido cargar, por favor revisa.');
                    }
                    else 
                    {
						$data_clte['doc_path'] = $pre_croquis;
                        if($this->cliente->add_PPSM16PF_doc(array_to_upper($data_clte)))
						{
                            send_json_ok(array('msg' =>'Se realizo la carga del archivo', 'id' => $cliente_id));

                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
                    send_json_error($this->upload->display_errors());
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
			$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'persona/add_PPSM16PF_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }

    public function borra_documento_MARINA($fsm_id)
    {
		$documento=$this->cliente->get_doc_MARINA($fsm_id);
		
		$doc_borra['clte_id']=$documento['clte_id'];
		$doc_borra['doc_nombre']=$documento['doc_nombre'];
		$doc_borra['doc_path']=strtolower($documento['doc_path']);
		$doc_borra['doc_f']=$documento['doc_f'];
		$doc_borra['empresa']='EVALUADOS';
		$doc_borra['doc_fecha_efectiva']=date();
		
		$this->cliente->inserta_borrado($doc_borra);
        if($this->cliente->delete_doc_MARINA($fsm_id))
        {
            send_json_ok('Se eliminó de forma correcta.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar.');
        }
    }


    public function borra_documento_PPSM16PF($fsm_id)
    {
		$documento=$this->cliente->get_doc_PPSM16PF($fsm_id);
		
		$doc_borra['clte_id']=$documento['clte_id'];
		$doc_borra['doc_nombre']=$documento['doc_nombre'];
		$doc_borra['doc_path']=strtolower($documento['doc_path']);
		$doc_borra['doc_f']=$documento['doc_f'];
		$doc_borra['empresa']='EVALUADOS';
		$doc_borra['doc_fecha_efectiva']=date();
		
		$this->cliente->inserta_borrado($doc_borra);
        if($this->cliente->delete_doc_PPSM16PF($fsm_id))
        {
            send_json_ok('Se eliminó de forma correcta.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar.');
        }
    }
 
    function descarga_doc($file)
    {
        $this->load->helper('download');
        force_download('./docs/'.$file, NULL);
    }

    function busca_empleado_gsi()
    {   $despacho=get_desp_id_usr();
		$emp_id_user=get_emp_id();
		$roots=get_my_user_root2();    
        $empresa = $this->input->post('empresa');
		$id_persona = $this->input->post('id_persona');
        $nombre  = trim(strtoupper($this->input->post('nombre')));
		$paterno  = trim(strtoupper($this->input->post('paterno')));
		$materno  = trim(strtoupper($this->input->post('materno')));
        $rfc     = trim(strtoupper($this->input->post('rfc')));
        $ubicacion     = strtoupper($this->input->post('ubicacion'));
		$cei     = strtoupper($this->input->post('cei'));
		$sucursal  = strtoupper($this->input->post('sucu'));
        $data['clientes'] = $this->cliente->busca_empleado_gsi($empresa, $nombre,$paterno, $materno, $rfc, $ubicacion,$despacho,$emp_id_user,$id_persona,$cei,$sucursal);
        $data['control'] = 'empleados_gsi';
		send_json_ok($this->load->view('persona/busca',$data,TRUE));
    }


    function busca_wrk()
    {   $despacho=get_desp_id_usr();
		$emp_id_user=get_emp_id();
		$roots=get_my_user_root2();    
        $empresa = $this->input->post('empresa');
		$id_persona = $this->input->post('id_persona');
        $nombre  = trim(strtoupper($this->input->post('nombre')));
		$paterno  = trim(strtoupper($this->input->post('paterno')));
		$materno  = trim(strtoupper($this->input->post('materno')));
        $rfc     = trim(strtoupper($this->input->post('rfc')));
        $ubicacion     = strtoupper($this->input->post('ubicacion'));
		$cei     = strtoupper($this->input->post('cei'));
		$sucursal  = strtoupper($this->input->post('sucu'));
		$odt  = strtoupper($this->input->post('odt'));
        $data['clientes'] = $this->cliente->busca_wrk($empresa, $nombre,$paterno, $materno, $rfc, $ubicacion,$despacho,$emp_id_user,$id_persona,$cei,$sucursal,$odt);
        send_json_ok($this->load->view('persona/busca_wrk',$data,TRUE));
    }

	
    function busca()	
    {   
		$user = $this->session->user; 
		$usuario = $this->medico->get($user['usr_id']);
		$despacho=get_desp_id_usr();
		$emp_id_user=get_emp_id();
		
		
		$roots=get_my_user_root2();    
			$empresa = $this->input->post('empresa');
			$id_persona = $this->input->post('id_persona');
			$nombre  = trim(strtoupper($this->input->post('nombre')));
			$paterno  = trim(strtoupper($this->input->post('paterno')));
			$materno  = trim(strtoupper($this->input->post('materno')));
			$rfc     = trim(strtoupper($this->input->post('rfc')));
			$ubicacion     = strtoupper($this->input->post('ubicacion'));
			$cei     = $this->input->post('cei');
			$orden_f_ini = $this->input->post('f_ini');
			$orden_f_fin = $this->input->post('f_fin');

			
			if (strstr($usuario['acciones'],'GERENTE;'))
			{	
				$gerente=1;
			}
			else
			{
				$gerente=0;
			}	
			
			if  (in_array(get_perfil_id(), array(4)))
			{
				$sucursal  = $usuario['suc_id'];				
			}
			else
			{				
				$sucursal  = strtoupper($this->input->post('sucu'));
			}
			
			$estatus_proc = $this->input->post('status_proc');
			$odt  = strtoupper($this->input->post('odt'));
			$data['clientes'] = $this->cliente->busca(
			$empresa, 
			$nombre,
			$paterno, 
			$materno, 
			$rfc, 
			$ubicacion,
			$despacho,
			$emp_id_user,
			$id_persona,
			$cei,$sucursal,
			$odt,
			$estatus_proc,
			$gerente,
			$orden_f_ini,
			$orden_f_fin
			);

			send_json_ok($this->load->view('persona/busca',$data,TRUE));
    }	

    function busca_corp_evalua2()
    {   
		$user = $this->session->user; 
		$usuario = $this->medico->get($user['usr_id']);
	
		$despacho=get_desp_id_usr();
		$emp_id_user=get_emp_id();
		$roots=get_my_user_root2();   
		
		if ($this->input->post('empresa') != '')
		{	
			$empresa = $this->input->post('empresa');
		}
		else
		{
					if ( strstr($usuario['portal'],'CORPO') )
					{	
				
						$this->load->model('empresa/Empresa_model','empresa');	
						
						if ( strstr($usuario['empresas'],'TCORPO') )
						{
							$empresas_gsi = $this->empresa->get_all_empresas_corp_id($usuario['corporacion']);	
							$i=0;
							foreach ( $empresas_gsi as $esta_empresa) 
							{
								if ($esta_empresa > 0)
								{	
									$gss[$i]=$esta_empresa['emp_id'];
									$i++;
								}
							}
						}
						else
						{
							$i=0;
							foreach ( explode(';',$usuario['empresas'] )  as $esta_empresa) 
							{
								if ($esta_empresa > 0)
								{	
									$gss[$i]=$esta_empresa;
									$i++;
								}
							}				
						}	
					
					}
		}
		
		$id_persona = $this->input->post('id_persona');
        $nombre  = trim(strtoupper($this->input->post('nombre')));
		$paterno  = trim(strtoupper($this->input->post('paterno')));
		$materno  = trim(strtoupper($this->input->post('materno')));
        $rfc     = trim(strtoupper($this->input->post('rfc')));
        $ubicacion  = strtoupper($this->input->post('ubicacion'));
		$cei     = strtoupper($this->input->post('cei'));
		$sucursal  = strtoupper($this->input->post('sucu'));
        $data['clientes'] = $this->cliente->busca_corp_evalua2($empresa, $nombre,$paterno, $materno, $rfc, $ubicacion,$despacho,$emp_id_user,$id_persona,$cei,$gss);
        send_json_ok($this->load->view('persona/busca',$data,TRUE));
    }

    function busca_corp_vehiculo()
    {   
		$user = $this->session->user; 
		$usuario = $this->medico->get($user['usr_id']);
	
		$despacho=get_desp_id_usr();
		$emp_id_user=get_emp_id();
		$roots=get_my_user_root2();   
		
		if ($this->input->post('empresa') != '')
		{	
			$empresa = $this->input->post('empresa');
		}
		else
		{
					if ( strstr($usuario['portal'],'CORPO') )
					{	
				
						$this->load->model('empresa/Empresa_model','empresa');	
						
						if ( strstr($usuario['empresas'],'TCORPO') )
						{
							$empresas_gsi = $this->empresa->get_all_empresas_corp_id($usuario['corporacion']);	
							$i=0;
							foreach ( $empresas_gsi as $esta_empresa) 
							{
								if ($esta_empresa > 0)
								{	
									$gss[$i]=$esta_empresa['emp_id'];
									$i++;
								}
							}
						}
						else
						{
							$i=0;
							foreach ( explode(';',$usuario['empresas'] )  as $esta_empresa) 
							{
								if ($esta_empresa > 0)
								{	
									$gss[$i]=$esta_empresa;
									$i++;
								}
							}				
						}	
					
					}
		}
		
		$id_persona = $this->input->post('id_persona');
        $nombre  = trim(strtoupper($this->input->post('nombre')));
		$paterno  = trim(strtoupper($this->input->post('paterno')));
		$materno  = trim(strtoupper($this->input->post('materno')));
        $rfc     = trim(strtoupper($this->input->post('rfc')));
        $ubicacion  = strtoupper($this->input->post('ubicacion'));
		$cei     = strtoupper($this->input->post('cei'));
		$sucursal  = strtoupper($this->input->post('sucu'));
        $data['clientes'] = $this->cliente->busca_corp_vehiculo($empresa, $nombre,$paterno, $materno, $rfc, $ubicacion,$despacho,$emp_id_user,$id_persona,$cei,$gss);
        send_json_ok($this->load->view('persona/busca',$data,TRUE));
    }

    function busca_corp_empresas()
    {   
		$user = $this->session->user; 
		$usuario = $this->medico->get($user['usr_id']);
	
		$despacho=get_desp_id_usr();
		$emp_id_user=get_emp_id();
		$roots=get_my_user_root2();   
		
		if ($this->input->post('empresa') != '')
		{	
			$empresa = $this->input->post('empresa');
		}
		else
		{
					if ( strstr($usuario['portal'],'CORPO') )
					{	
				
						$this->load->model('empresa/Empresa_model','empresa');	
						
						if ( strstr($usuario['empresas'],'TCORPO') )
						{
							$empresas_gsi = $this->empresa->get_all_empresas_corp_id($usuario['corporacion']);	
							$i=0;
							foreach ( $empresas_gsi as $esta_empresa) 
							{
								if ($esta_empresa > 0)
								{	
									$gss[$i]=$esta_empresa['emp_id'];
									$i++;
								}
							}
						}
						else
						{
							$i=0;
							foreach ( explode(';',$usuario['empresas'] )  as $esta_empresa) 
							{
								if ($esta_empresa > 0)
								{	
									$gss[$i]=$esta_empresa;
									$i++;
								}
							}				
						}	
					
					}
		}
		
		$id_persona = $this->input->post('id_persona');
        $nombre  = trim(strtoupper($this->input->post('nombre')));
		$paterno  = trim(strtoupper($this->input->post('paterno')));
		$materno  = trim(strtoupper($this->input->post('materno')));
        $rfc     = trim(strtoupper($this->input->post('rfc')));
        $ubicacion  = strtoupper($this->input->post('ubicacion'));
		$cei     = strtoupper($this->input->post('cei'));
		$sucursal  = strtoupper($this->input->post('sucu'));
        $data['clientes'] = $this->cliente->busca_corp_empresas($empresa, $nombre,$paterno, $materno, $rfc, $ubicacion,$despacho,$emp_id_user,$id_persona,$cei,$gss);
        send_json_ok($this->load->view('persona/busca',$data,TRUE));
    }



    function busca_corp()
    {   
		$user = $this->session->user; 
		$usuario = $this->medico->get($user['usr_id']);
	
		$despacho=get_desp_id_usr();
		$emp_id_user=get_emp_id();
		$roots=get_my_user_root2();   
		
		if ($this->input->post('empresa') != '')
		{	
			$empresa = $this->input->post('empresa');
		}
		else
		{
					if ( strstr($usuario['portal'],'CORPO') )
					{	
				
						$this->load->model('empresa/Empresa_model','empresa');	
						
						if ( strstr($usuario['empresas'],'TCORPO') )
						{
							$empresas_gsi = $this->empresa->get_all_empresas_corp_id($usuario['corporacion']);	
							$i=0;
							foreach ( $empresas_gsi as $esta_empresa) 
							{
								if ($esta_empresa > 0)
								{	
									$gss[$i]=$esta_empresa['emp_id'];
									$i++;
								}
							}
						}
						else
						{
							$i=0;
							foreach ( explode(';',$usuario['empresas'] )  as $esta_empresa) 
							{
								if ($esta_empresa > 0)
								{	
									$gss[$i]=$esta_empresa;
									$i++;
								}
							}				
						}	
					
					}
		}
		
		$id_persona = $this->input->post('id_persona');
        $nombre  = trim(strtoupper($this->input->post('nombre')));
		$paterno  = trim(strtoupper($this->input->post('paterno')));
		$materno  = trim(strtoupper($this->input->post('materno')));
        $rfc     = trim(strtoupper($this->input->post('rfc')));
        $ubicacion  = strtoupper($this->input->post('ubicacion'));
		$cei     = strtoupper($this->input->post('cei'));
		$sucursal  = strtoupper($this->input->post('sucu'));
        $data['clientes'] = $this->cliente->busca_corp($empresa, $nombre,$paterno, $materno, $rfc, $ubicacion,$despacho,$emp_id_user,$id_persona,$cei,$gss);
        send_json_ok($this->load->view('persona/busca',$data,TRUE));
    }



    function busca_gsi()
    {   
		$user = $this->session->user; 
		$usuario = $this->medico->get($user['usr_id']);
	
		$despacho=get_desp_id_usr();
		$emp_id_user=get_emp_id();
		$roots=get_my_user_root2();   
		
		if ($this->input->post('empresa') != '')
		{	
			$empresa = $this->input->post('empresa');
		}
		else
		{
					if ( strstr($usuario['portal'],'EMPSGSI') )
					{	
				
						$this->load->model('empresa/Empresa_model','empresa');	
						if ( strstr($usuario['empresas'],'TGSI') )
						{
							$empresas_gsi = $this->empresa->get_all_empresas_gsi_id();	
							$i=0;
							foreach ( $empresas_gsi as $esta_empresa) 
							{
								if ($esta_empresa > 0)
								{	
									$gss[$i]=$esta_empresa['emp_id'];
									$i++;
								}
							}
						}
						else
						{
							$i=0;
							foreach ( explode(';',$usuario['empresas'] )  as $esta_empresa) 
							{
								if ($esta_empresa > 0)
								{	
									$gss[$i]=$esta_empresa;
									$i++;
								}
							}				
						}	
					
					}
		}
		
		$id_persona = $this->input->post('id_persona');
        $nombre  = trim(strtoupper($this->input->post('nombre')));
		$paterno  = trim(strtoupper($this->input->post('paterno')));
		$materno  = trim(strtoupper($this->input->post('materno')));
        $rfc     = trim(strtoupper($this->input->post('rfc')));
        $ubicacion  = strtoupper($this->input->post('ubicacion'));
		$cei     = strtoupper($this->input->post('cei'));
		$sucursal  = strtoupper($this->input->post('sucu'));




		
        $data['clientes'] = $this->cliente->busca_gsi($empresa, $nombre,$paterno, $materno, $rfc, $ubicacion,$despacho,$emp_id_user,$id_persona,$cei,$gss);
        send_json_ok($this->load->view('persona/busca',$data,TRUE));
    }




    function busca_evaluados()
    {   $despacho=get_desp_id_usr();
		$emp_id_user=get_emp_id();
		$roots=get_my_user_root2(); 
		
        $empresa = $emp_id_user;
		$id_persona = $this->input->post('id_persona');
        $nombre  = trim(strtoupper($this->input->post('nombre')));
		$paterno  = trim(strtoupper($this->input->post('paterno')));
		$materno  = trim(strtoupper($this->input->post('materno')));
        $rfc     = trim(strtoupper($this->input->post('rfc')));
        $ubicacion     = strtoupper($this->input->post('ubicacion'));
		$cei     = strtoupper($this->input->post('cei'));
		$sucursal  = strtoupper($this->input->post('sucu'));
		
        $data['clientes'] = $this->cliente->busca_evalua2($empresa, $nombre,$paterno, $materno, $rfc, $ubicacion,$despacho,$emp_id_user,$id_persona,$cei,$sucursal);
        send_json_ok($this->load->view('persona/busca_evaluados',$data,TRUE));
    }




    function busca_px()
    {   $despacho=get_desp_id_usr();
		$emp_id_user=get_emp_id();
		$roots=get_my_user_root2();  

		
        //$empresa = $this->input->post('empresa');
		 $id_persona = $this->input->post('id_persona');
		 $tpaciente = $this->input->post('tpaciente');
		 $unidad = $this->input->post('unidad');
		 $no_empleado = $this->input->post('no_empleado');
		 $id_persona = $this->input->post('id_paciente');
		 $nombre2 = $this->input->post('nombre2');
		
        $nombre  = strtoupper($this->input->post('nombre'));
		$paterno  = strtoupper($this->input->post('paterno'));
		$materno  = strtoupper($this->input->post('materno'));
        
       
        $data['clientes'] = $this->cliente->busca_px(
		$nombre,
		$nombre2,
		$paterno, 
		$materno,
		$id_persona,
		$tpaciente,
		$unidad,
		$no_empleado);
        send_json_ok($this->load->view('persona/busca_px',$data,TRUE));
    }

    function busca_evaluado()
    {   $despacho=get_desp_id_usr();
		$emp_id_user=get_emp_id();
		$roots=get_my_user_root2();    
        $empresa = $this->input->post('empresa');
		$id_persona = strtoupper($this->input->post('id_persona'));
        $nombre  = strtoupper($this->input->post('nombre'));
		$paterno  = strtoupper($this->input->post('paterno'));
		$materno  = strtoupper($this->input->post('materno'));
        $rfc     = strtoupper($this->input->post('rfc'));
        $ubicacion     = strtoupper($this->input->post('ubicacion'));
        $data['clientes'] = $this->cliente->busca($empresa, $nombre,$paterno, $materno, $rfc, $ubicacion,$despacho,$emp_id_user,$id_persona);
        send_json_ok($this->load->view('persona/busca',$data,TRUE));
    }


    function busca_pot()
    {  
		$user = $this->session->user; 
		$medico=$this->medico->get($user['usr_id']);
        $empresa = $medico['usr_emp_asig'];// $this->input->post('empresa');
        $nombre  = strtoupper($this->input->post('nombre'));
		$nombre2 = strtoupper($this->input->post('nombre2'));
		$empleado =	strtoupper($this->input->post('empleado'));
		$receta=	strtoupper($this->input->post('receta'));
		$paterno  = strtoupper($this->input->post('paterno'));
		$materno  = strtoupper($this->input->post('materno'));
		$data['clientes'] = $this->cliente->busca_pot($empresa, $nombre, $nombre2,$paterno, $materno, $empleado, $receta);
		send_json_ok($this->load->view('persona/busca_pot',$data,TRUE));
    }

    function busca_p()
    {   $despacho=get_desp_id_usr();
		$emp_id_user=get_emp_id();
		$user = $this->session->user; 
		//$usuario = $CIs->empleado->get($user['usr_id']);
		$medico=$this->medico->get($user['usr_id']);
		
		$roots=get_my_user_root2();    
        $empresa = $this->input->post('empresa');
        $nombre  = strtoupper($this->input->post('nombre'));
		$nombre2 = strtoupper($this->input->post('nombre2'));
		$empleado =	strtoupper($this->input->post('empleado'));
		$receta=	strtoupper($this->input->post('receta'));
		$paterno  = strtoupper($this->input->post('paterno'));
		$materno  = strtoupper($this->input->post('materno'));
		$data['clientes'] = $this->cliente->busca_p($empresa, $nombre, $nombre2,$paterno, $materno, $empleado, $receta,$despacho,$medico['usr_emp_asig']);
		send_json_ok($this->load->view('persona/busca_p',$data,TRUE));
    }

	
   public function borra($fsm_id)
    {
        if($this->cliente->borra_evaluado($fsm_id))
        {
            send_json_ok('Se eliminó de forma correcta.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar.');
        }
    }

/*************************************************************************************/
    public function lista_externos()
    {   
	    //echo " Punto A ";
		$suc=get_sucursal_id();
		$user_despacho=get_desp_id_usr();
		$user_cei=get_cei_id();
		$user_root1=get_my_user_root1();
		$user = $this->session->user; 
		$medico = $this->medico->get($user['usr_id']);
		$emp_id=$user['emp_id'];
        $rows = 30;
        $this->load->library('pagination');
        $config['base_url'] = base_url('persona/lista_externos/');
		
		$config['total_rows'] = $this->cliente->count_allo_externos($emp_id,$suc,$user_despacho,$user_cei,$user_root1,1);

		$config['per_page'] = $rows;
        $config['attributes'] = array('class' => 'pagination');
        $config['full_tag_open'] = '<div class="pagination-full">';
        $config['full_tag_close'] = '</div>';
        $config['uri_segment'] = 3;
        $config['query_string_segment'] = 4;
        $config['use_page_numbers'] = TRUE;
        $this->pagination->initialize($config);

		$data['clientes'] = $this->cliente->get_allo_externos($rows,$emp_id,get_sucursal_id(),$user_despacho,$user_cei,$user_root1,1);
        
        $this->load->helper('template');
        $params_view = array(
            'title' => 'Personas',
            'view' => 'persona/index_externos',
            'view_data' => $data 
           );
        render_template($params_view);  
    }

    public function lista_swe()
    {   
	    //echo " Punto A ";
		$suc=get_sucursal_id();
		$user_despacho=get_desp_id_usr();
		$user_cei=get_cei_id();
		$user_root1=get_my_user_root1();
		$user = $this->session->user; 
		$medico = $this->medico->get($user['usr_id']);
		$emp_id=253;//$user['emp_id'];
        $rows = 30;
        $this->load->library('pagination');
        $config['base_url'] = base_url('persona/lista_swe/');
		
		$config['total_rows'] = $this->cliente->count_allo_ee($emp_id,$suc,$user_despacho,$user_cei,$user_root1,1);

		$config['per_page'] = $rows;
        $config['attributes'] = array('class' => 'pagination');
        $config['full_tag_open'] = '<div class="pagination-full">';
        $config['full_tag_close'] = '</div>';
        $config['uri_segment'] = 3;
        $config['query_string_segment'] = 4;
        $config['use_page_numbers'] = TRUE;
        $this->pagination->initialize($config);

		$data['clientes'] = $this->cliente->get_allo_ee($rows,$emp_id,get_sucursal_id(),$user_despacho,$user_cei,$user_root1,1);
        
        $this->load->helper('template');
        $params_view = array(
            'title' => 'Personas',
            'view' => 'persona/index_swe',
            'view_data' => $data 
           );
        render_template($params_view);  
    }
/*************************************************************************************/
  public function lista_bajas()
    {   
	
	    //echo " Punto A ";
		$suc=get_sucursal_id();
		$user_despacho=get_desp_id_usr();
		$user_cei=get_cei_id();
		$user_root1=get_my_user_root1();
		$user = $this->session->user; 
		$medico = $this->medico->get($user['usr_id']);
		$emp_id=$user['emp_id']; 
        $rows = 30;
        $this->load->library('pagination');
        $config['base_url'] = base_url('persona/lista_bajas/');
		
		$config['total_rows'] = $this->cliente->count_allo_b($emp_id,$suc,$user_despacho,$user_cei,$user_root1,1);

		$config['per_page'] = $rows;
        $config['attributes'] = array('class' => 'pagination');
        $config['full_tag_open'] = '<div class="pagination-full">';
        $config['full_tag_close'] = '</div>';
        $config['uri_segment'] = 3;
        $config['query_string_segment'] = 4;
        $config['use_page_numbers'] = TRUE;
        $this->pagination->initialize($config);

		$data['clientes'] = $this->cliente->get_allo_b($rows,$emp_id,get_sucursal_id(),$user_despacho,$user_cei,$user_root1,1);
        
        $this->load->helper('template');
        $params_view = array(
            'title' => 'Personas',
            'view' => 'persona/index_bajas',
            'view_data' => $data 
           );
        render_template($params_view);  
    }


   public function lista_swb()
    {   
	
	    //echo " Punto A ";
		$suc=get_sucursal_id();
		$user_despacho=get_desp_id_usr();
		$user_cei=get_cei_id();
		$user_root1=get_my_user_root1();
		$user = $this->session->user; 
		$medico = $this->medico->get($user['usr_id']);
		
		if ($user['usr_id'] == 622)
		{ $emp_id= 253;	} else { $emp_id=$user['emp_id']; }
        $rows = 30;
        $this->load->library('pagination');
        $config['base_url'] = base_url('persona/lista_swb/');
		
		$config['total_rows'] = $this->cliente->count_allo_b($emp_id,$suc,$user_despacho,$user_cei,$user_root1,1);

		$config['per_page'] = $rows;
        $config['attributes'] = array('class' => 'pagination');
        $config['full_tag_open'] = '<div class="pagination-full">';
        $config['full_tag_close'] = '</div>';
        $config['uri_segment'] = 3;
        $config['query_string_segment'] = 4;
        $config['use_page_numbers'] = TRUE;
        $this->pagination->initialize($config);

		$data['clientes'] = $this->cliente->get_allo_b($rows,$emp_id,get_sucursal_id(),$user_despacho,$user_cei,$user_root1,1);
        
        $this->load->helper('template');
        $params_view = array(
            'title' => 'Personas',
            'view' => 'persona/index_swb',
            'view_data' => $data 
           );
        render_template($params_view);  
    }




/*************************************************************************************/
public function lista_colaboradores()
    {   
		$suc=get_sucursal_id();
		$user_despacho=get_desp_id_usr();
		$user_cei=get_cei_id();
		$user_root1=get_my_user_root1();
		$user = $this->session->user; 
		$medico = $this->medico->get($user['usr_id']);
		$emp_id= $user['emp_id'];
        $rows = 30;
        $this->load->library('pagination');
        $config['base_url'] = base_url('persona/lista_colaboradores/');
		
		//$config['total_rows'] = $this->cliente->count_allo_empleados($emp_id,$suc,$user_despacho,$user_cei,$user_root1,1);

		$config['per_page'] = $rows;
        $config['attributes'] = array('class' => 'pagination');
        $config['full_tag_open'] = '<div class="pagination-full">';
        $config['full_tag_close'] = '</div>';
        $config['uri_segment'] = 3;
        $config['query_string_segment'] = 4;
        $config['use_page_numbers'] = TRUE;
        $this->pagination->initialize($config);

		//$data['clientes'] = $this->cliente->get_allo_empleados_rol($rows,$emp_id,get_sucursal_id(),$user_despacho,$user_cei,$user_root1,1);
        
        $this->load->helper('template');
        $params_view = array(
            'title' => 'Colaboradores',
            'view' => 'persona/index_colaborador',
            'view_data' => $data 
           );
        render_template($params_view);  
    }
/*************************************************************************************/
public function lista_empleados()
    {   
	    //echo " Punto A ";
		$suc=get_sucursal_id();
		$user_despacho=get_desp_id_usr();
		$user_cei=get_cei_id();
		$user_root1=get_my_user_root1();
		$user = $this->session->user; 
		$medico = $this->medico->get($user['usr_id']);
		$emp_id= $user['emp_id'];
        $rows = 30;
        $this->load->library('pagination');
        $config['base_url'] = base_url('persona/lista_empleados/');
		
		$config['total_rows'] = $this->cliente->count_allo_empleados($emp_id,$suc,$user_despacho,$user_cei,$user_root1,1);

		$config['per_page'] = $rows;
        $config['attributes'] = array('class' => 'pagination');
        $config['full_tag_open'] = '<div class="pagination-full">';
        $config['full_tag_close'] = '</div>';
        $config['uri_segment'] = 3;
        $config['query_string_segment'] = 4;
        $config['use_page_numbers'] = TRUE;
        $this->pagination->initialize($config);

		$data['clientes'] = $this->cliente->get_allo_empleados_rol($rows,$emp_id,get_sucursal_id(),$user_despacho,$user_cei,$user_root1,1);
        
        $this->load->helper('template');
        $params_view = array(
            'title' => 'Personas',
            'view' => 'persona/index_empleado',
            'view_data' => $data 
           );
        render_template($params_view);  
    }



/*************************************************************************************/
    public function lista_sw()
    {   
	    //echo " Punto A ";
		$suc=get_sucursal_id();
		$user_despacho=get_desp_id_usr();
		$user_cei=get_cei_id();
		$user_root1=get_my_user_root1();
		$user = $this->session->user; 
		$medico = $this->medico->get($user['usr_id']);
		$emp_id= 253;//$user['emp_id'];
        $rows = 30;
        $this->load->library('pagination');
        $config['base_url'] = base_url('persona/lista_sw/');
		
		$config['total_rows'] = $this->cliente->count_allo_e($emp_id,$suc,$user_despacho,$user_cei,$user_root1,1);

		$config['per_page'] = $rows;
        $config['attributes'] = array('class' => 'pagination');
        $config['full_tag_open'] = '<div class="pagination-full">';
        $config['full_tag_close'] = '</div>';
        $config['uri_segment'] = 3;
        $config['query_string_segment'] = 4;
        $config['use_page_numbers'] = TRUE;
        $this->pagination->initialize($config);

		$data['clientes'] = $this->cliente->get_allo_e($rows,$emp_id,get_sucursal_id(),$user_despacho,$user_cei,$user_root1,1);
        
        $this->load->helper('template');
        $params_view = array(
            'title' => 'Personas',
            'view' => 'persona/index_sw',
            'view_data' => $data 
           );
        render_template($params_view);  
    }
/*************************************************************************************/
    public function extrno_a_intrno_empleado($cliente_id)
    {    
		$user = $this->session->user;
		$cliente = $this->cliente->get($cliente_id);
		$empresa=$cliente['emp_id'];

		if($cliente)
		{
			if(isset($_POST) && count($_POST) > 0)     
			{
					$this->load->library('form_validation');
					$this->form_validation->set_rules('autorizacion','Autorización','required');

					if($this->form_validation->run())
					{

						$data_clte['clte_observaciones'] = $this->input->post('observaciones');
						$data_clte['f_ingreso'] = formatea_fecha_mysql($this->input->post('f_revalida'));
						$data_clte['EMPLEADO_ROL'] = 1;

						if (trim($this->input->post('autorizacion')) == get_cat_nombre_unico('PASS_UNIVERSAL','PASS_UNIVERSAL',$empresa) )
						{
							$pasa=1;
						}	
						else
						{
							$pasa=0;
						}

						
						if ($pasa == 0)
						{
							send_json_error('La AUTORIZACIÓN no es la correcta.');
						}	
						elseif($this->cliente->actualiza($cliente_id, array_to_upper($data_clte)))
						//elseif($this->cliente->actualiza_status($clte_id,'NOACTIVO'))
						{
							send_json_ok(array('msg' =>'Se actualizó registro, Empleado pasa a Nomina de la Empresa.', 'id' => $cliente_id));
						}
						else
						{
							send_json_error('Ocurrió un error al actualizar la persona.');
						}						

					}
					else
					{
						send_json_error(validation_errors('<div />'));
					}
				
			}
			else 
			{
				$this->load->model('empresa/Empresa_model','empresa');

				$data['sucursals'] = $this->empresa->get_all_sucursales($empresa);
				$data['consultorios'] = $this->empresa->get_lista_consultorios();
				$data['persona'] = 	$cliente;
				$data['worker'] = 	$worker;
				$data['worker_usr'] = 	$worker_usr;
				
				if ($cliente['serv_id'] > 0)
				{
					$data['servicio'] = $servicio;
				}
				$this->load->helper('template');
				$params_view = array(
					'title' => 'Personas',
					'view' => 'persona/edit_sw',
					'view_data' => $data
				   );
				render_template($params_view);  
			}		
		}
		else 
		{
			show_error('No existe el cliente');
		}
    }
/*************************************************************************************/
    public function baja_empleado($cliente_id)
    {    
		$user = $this->session->user;
		$cliente = $this->cliente->get($cliente_id);
		$empresa=$cliente['emp_id'];

		if($cliente)
		{
			if(isset($_POST) && count($_POST) > 0)     
			{
					$this->load->library('form_validation');
					$this->form_validation->set_rules('autorizacion','Autorización','required');

					if($this->form_validation->run())
					{


						$data_clte['status'] = 'NOACTIVO'; 
						$data_clte['clte_observaciones'] = $this->input->post('observaciones');
						$data_clte['f_baja'] = formatea_fecha_mysql($this->input->post('f_baja'));
						
						//if (trim($this->input->post('autorizacion')) == get_cat_nombre_unico('PASS_UNIVERSAL','PASS_UNIVERSAL',$empresa) )
						if (trim($this->input->post('autorizacion')) == get_cat_nombre_pass('PASS_UNIVERSAL','PASS_UNIVERSAL',$empresa) )	
						{
							$pasa=1;
						}	
						else
						{
							$pasa=0;
						}

						
						if ($pasa == 0)
						{
							send_json_error('La AUTORIZACIÓN no es la correcta.');
						}	
						elseif($this->cliente->actualiza($cliente_id, array_to_upper($data_clte)))
						//elseif($this->cliente->actualiza_status($clte_id,'NOACTIVO'))
						{
							send_json_ok(array('msg' =>'Se actualizó el registro, ha cambiado el estatus del Empleado, se ha dado de baja.', 'id' => $cliente_id));
						}
						else
						{
							send_json_error('Ocurrió un error al actualizar la persona.');
						}						

					}
					else
					{
						send_json_error(validation_errors('<div />'));
					}
				
			}
			else 
			{
				$this->load->model('empresa/Empresa_model','empresa');

				$data['sucursals'] = $this->empresa->get_all_sucursales($empresa);
				$data['consultorios'] = $this->empresa->get_lista_consultorios();
				$data['persona'] = 	$cliente;
				$data['worker'] = 	$worker;
				$data['worker_usr'] = 	$worker_usr;
				
				if ($cliente['serv_id'] > 0)
				{
					$data['servicio'] = $servicio;
				}
				$this->load->helper('template');
				$params_view = array(
					'title' => 'Personas',
					'view' => 'persona/edit_sw',
					'view_data' => $data
				   );
				render_template($params_view);  
			}		
		}
		else 
		{
			show_error('No existe el cliente');
		}
    }


    public function baja_swe($cliente_id)
    {    
		$user = $this->session->user;
		$cliente = $this->cliente->get($cliente_id);
		$empresa=$cliente['emp_id'];

		if($cliente)
		{
			if(isset($_POST) && count($_POST) > 0)     
			{
					$this->load->library('form_validation');
					$this->form_validation->set_rules('autorizacion','Autorización','required');

					if($this->form_validation->run())
					{


						$data_clte['status'] = 'NOACTIVO'; 
						if (trim($this->input->post('autorizacion')) == get_cat_nombre_unico('SWOBODA','PASS_UNIVERSAL','PASSWORD_SW') )
						{
							$pasa=1;
						}	
						else
						{
							$pasa=0;
						}

						
						if ($pasa == 0)
						{
							send_json_error('La AUTORIZACIÓN no es la correcta.');
						}	
						elseif($this->cliente->actualiza($cliente_id, array_to_upper($data_clte)))
						//elseif($this->cliente->actualiza_status($clte_id,'NOACTIVO'))
						{
							send_json_ok(array('msg' =>'Se actualizó ha cambiado el estatus del Empleado, se ha dado de baja.', 'id' => $cliente_id));
						}
						else
						{
							send_json_error('Ocurrió un error al actualizar la persona.');
						}						

					}
					else
					{
						send_json_error(validation_errors('<div />'));
					}
				
			}
			else 
			{
				$this->load->model('empresa/Empresa_model','empresa');

				$data['sucursals'] = $this->empresa->get_all_sucursales($empresa);
				$data['consultorios'] = $this->empresa->get_lista_consultorios();
				$data['persona'] = 	$cliente;
				$data['worker'] = 	$worker;
				$data['worker_usr'] = 	$worker_usr;
				
				if ($cliente['serv_id'] > 0)
				{
					$data['servicio'] = $servicio;
				}
				$this->load->helper('template');
				$params_view = array(
					'title' => 'Personas',
					'view' => 'persona/edit_sw',
					'view_data' => $data
				   );
				render_template($params_view);  
			}		
		}
		else 
		{
			show_error('No existe el cliente');
		}
    }
	
/*************************************************************************************/
    public function alta_sw($cliente_id)
    {    
		$user = $this->session->user;
		$cliente = $this->cliente->get($cliente_id);
		$empresa=$cliente['emp_id'];

		if($cliente)
		{
			if(isset($_POST) && count($_POST) > 0)     
			{
					$this->load->library('form_validation');
					$this->form_validation->set_rules('autorizacion','Autorización','required');

					if($this->form_validation->run())
					{
						$data_clte['empleado'] = 1; 
						$data_clte['empleado_rol'] = $this->input->post('empleado_rol'); 
						if ($cliente['emp_id'] == 31) {$data_clte['hc'] = 1;}
						$data_clte['status'] = 'ACTIVO'; 
						$data_clte['clte_observaciones'] = trim($this->input->post('observaciones')); 
						$data_clte['f_ingreso'] = $this->input->post('f_alta'); 
						$data_clte['clte_puesto'] = trim($this->input->post('puesto')); 
						
						if ($empresa == 293 ) /*para Generac*/
						{
							$nomserv='ISOEXI;ISOAM;ISOACC;ISOEXP;ISOINC;';				
							$data_clte['nomserv'] =  $nomserv;
						}	
						
						if (trim($this->input->post('autorizacion')) == get_cat_nombre_pass('PASS_UNIVERSAL','PASS_UNIVERSAL',$empresa) )
						{
							$pasa=1;
						}	
						else
						{
							$pasa=0;
						}

						
						if ($pasa == 0)
						{
							send_json_error('La AUTORIZACIÓN no es la correcta.');
						}	
						elseif($this->cliente->actualiza($cliente_id, array_to_upper($data_clte)))
						{
							if ($cliente['status'] == "NOACTIVO")
							{ echo send_json_ok(array('msg' =>'Se ha reactivado al empleado.', 'id' => $cliente_id)); } 
							else { send_json_ok(array('msg' =>'El evaluado se ha registrado como empleado.', 'id' => $cliente_id)); }
							
						}
						else
						{
							send_json_error('Ocurrió un error al actualizar al evalauado.');
						}						

					}
					else
					{
						send_json_error(validation_errors('<div />'));
					}
				
			}
			else 
			{
				//$this->load->model('empresa/Empresa_model','empresa');
				//$data['sucursals'] = $this->empresa->get_all_sucursales($empresa);
				//$data['consultorios'] = $this->empresa->get_lista_consultorios();
				$data['persona'] = 	$cliente;
				//$data['worker'] = 	$worker;
				//$data['worker_usr'] = 	$worker_usr;
				
				if ($cliente['serv_id'] > 0)
				{
					$data['servicio'] = $servicio;
				}
				$this->load->helper('template');
				$params_view = array(
					'title' => 'Personas',
					'view' => 'persona/alta_psw',
					'view_data' => $data
				   );
				render_template($params_view);  
			}		
		}
		else 
		{
			show_error('No existe el cliente');
		}


    }	
	
/*************************************************************************************/
    public function baja_sw($cliente_id)
    {    
		$user = $this->session->user;
		$cliente = $this->cliente->get($cliente_id);
		$empresa=$cliente['emp_id'];

		if($cliente)
		{
			if(isset($_POST) && count($_POST) > 0)     
			{
					$this->load->library('form_validation');
					$this->form_validation->set_rules('autorizacion','Autorización','required');

					if($this->form_validation->run())
					{


						$data_clte['status'] = 'NOACTIVO'; 
						$data_clte['clte_observaciones'] = trim($this->input->post('observaciones')); 
						$data_clte['f_baja'] = formatea_fecha_mysql($this->input->post('f_baja')); 
						
						if (trim($this->input->post('autorizacion')) == get_cat_nombre_unico('SWOBODA','PASS_UNIVERSAL','PASSWORD_SW') )
						{
							$pasa=1;
						}	
						else
						{
							$pasa=0;
						}

						
						if ($pasa == 0)
						{
							send_json_error('La AUTORIZACIÓN no es la correcta.');
						}	
						elseif($this->cliente->actualiza($cliente_id, array_to_upper($data_clte)))
						//elseif($this->cliente->actualiza_status($clte_id,'NOACTIVO'))
						{
							send_json_ok(array('msg' =>'Se actualizó ha cambiado el estatus del Empleado, se ha dado de baja.', 'id' => $cliente_id));
						}
						else
						{
							send_json_error('Ocurrió un error al actualizar la persona.');
						}						

					}
					else
					{
						send_json_error(validation_errors('<div />'));
					}
				
			}
			else 
			{
				$this->load->model('empresa/Empresa_model','empresa');

				$data['sucursals'] = $this->empresa->get_all_sucursales($empresa);
				$data['consultorios'] = $this->empresa->get_lista_consultorios();
				$data['persona'] = 	$cliente;
				$data['worker'] = 	$worker;
				$data['worker_usr'] = 	$worker_usr;
				
				if ($cliente['serv_id'] > 0)
				{
					$data['servicio'] = $servicio;
				}
				$this->load->helper('template');
				$params_view = array(
					'title' => 'Personas',
					'view' => 'persona/edit_sw',
					'view_data' => $data
				   );
				render_template($params_view);  
			}		
		}
		else 
		{
			show_error('No existe el cliente');
		}


    }
/*************************************************************************************/
/*************************************************************************************/
	public function editar_ISONORDICO($cliente_id, $fsm_id)
    {
        $persona = $this->cliente->get($cliente_id);
		$data['fsm'] = $this->salud_ocupacional->get_ISONORDICO($fsm_id);		
        $user = $this->session->user;

        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');

            if(true)
            {
			/*	$data_insert['clte_id'] = $persona['clte_id'];
				$data_insert['fsm_edad']=intval(trim(str_replace("años", "",get_edad($persona['clte_f_nac']))));
				
				$data_insert['fsm_f_nac']=$persona['clte_f_nac'];
				$data_insert['fsm_genero']=$persona['clte_genero_cve'];
				$data_insert['emp_id'] = $persona['emp_id'];
				$data_insert['suc_id'] = $persona['suc_id'];               
                $data_insert['serv_id']  = '';
                $data_insert['usr_id']  = $user['usr_id'];
                $data_insert['fsm_f']   =  date("Y-m-d H:i:s");
				
				$data_insert['fsm_f_y']   =  date("Y");
				$data_insert['fsm_f_m']   =  date("m");
				$data_insert['fsm_f_d']   =  date("d");
				$data_insert['fsm_f_h']   =  date("H");
				$data_insert['fsm_f_i']   =  date("i");
			*/					

/**************************************/
								
				$data_insert['med_id'] = $this->input->post('medico');				
				$medico = $this->medico->get($data_insert['med_id']);

				$data_insert['fsm_jefe'] = $this->input->post('jefe');
				$data_insert['fsm_planta'] = $this->input->post('planta');
				$data_insert['fsm_antiguedad_empresa'] = $this->input->post('antiguedad_empresa');
				$data_insert['fsm_linea'] = $this->input->post('linea');
				$data_insert['fsm_antiguedad_area'] = $this->input->post('antiguedad_area');
				$data_insert['fsm_area_depto'] = $this->input->post('area_depto');
				$data_insert['fsm_edad_custionario'] = $this->input->post('edad_custionario');
				$data_insert['fsm_puesto'] = $this->input->post('puesto');
				$data_insert['fsm_riesgos_trabajo'] = $this->input->post('riesgos_trabajo');
				$data_insert['fsm_mano'] = $this->input->post('mano');
				$data_insert['fsm_cuello'] = $this->input->post('cuello');
				$data_insert['fsm_hombro_der'] = $this->input->post('hombro_der');
				$data_insert['fsm_hombro_izq'] = $this->input->post('hombro_izq');
				$data_insert['fsm_espalda'] = $this->input->post('espalda');
				$data_insert['fsm_codo_der'] = $this->input->post('codo_der');
				$data_insert['fsm_codo_izq'] = $this->input->post('codo_izq');
				$data_insert['fsm_mano_der'] = $this->input->post('mano_der');
				$data_insert['fsm_mano_izq'] = $this->input->post('mano_izq');
				$data_insert['fsm_sentado_20'] = $this->input->post('sentado_20');
				$data_insert['fsm_sentado_40'] = $this->input->post('sentado_40');
				$data_insert['fsm_sentado_60'] = $this->input->post('sentado_60');
				$data_insert['fsm_sentado_80'] = $this->input->post('sentado_80');
				$data_insert['fsm_sentado_100'] = $this->input->post('sentado_100');
				$data_insert['fsm_pie_20'] = $this->input->post('pie_20');
				$data_insert['fsm_pie_40'] = $this->input->post('pie_40');
				$data_insert['fsm_pie_60'] = $this->input->post('pie_60');
				$data_insert['fsm_pie_80'] = $this->input->post('pie_80');
				$data_insert['fsm_pie_100'] = $this->input->post('pie_100');
				$data_insert['fsm_encuclillado_20'] = $this->input->post('encuclillado_20');
				$data_insert['fsm_encuclillado_40'] = $this->input->post('encuclillado_40');
				$data_insert['fsm_encuclillado_60'] = $this->input->post('encuclillado_60');
				$data_insert['fsm_encuclillado_80'] = $this->input->post('encuclillado_80');
				$data_insert['fsm_encuclillado_100'] = $this->input->post('encuclillado_100');
				$data_insert['fsm_ftorax_20'] = $this->input->post('ftorax_20');
				$data_insert['fsm_ftorax_40'] = $this->input->post('ftorax_40');
				$data_insert['fsm_ftorax_60'] = $this->input->post('ftorax_60');
				$data_insert['fsm_ftorax_80'] = $this->input->post('ftorax_80');
				$data_insert['fsm_ftorax_100'] = $this->input->post('ftorax_100');
				$data_insert['fsm_etorax_20'] = $this->input->post('etorax_20');
				$data_insert['fsm_etorax_40'] = $this->input->post('etorax_40');
				$data_insert['fsm_etorax_60'] = $this->input->post('etorax_60');
				$data_insert['fsm_etorax_80'] = $this->input->post('etorax_80');
				$data_insert['fsm_etorax_100'] = $this->input->post('etorax_100');
				$data_insert['fsm_m_125'] = $this->input->post('m_125');
				$data_insert['fsm_c_125'] = $this->input->post('c_125');
				$data_insert['fsm_p_125'] = $this->input->post('p_125');
				$data_insert['fsm_m_250'] = $this->input->post('m_250');
				$data_insert['fsm_c_250'] = $this->input->post('c_250');
				$data_insert['fsm_p_250'] = $this->input->post('p_250');
				$data_insert['fsm_m_375'] = $this->input->post('m_375');
				$data_insert['fsm_c_375'] = $this->input->post('c_375');
				$data_insert['fsm_p_375'] = $this->input->post('p_375');
				$data_insert['fsm_m_500'] = $this->input->post('m_500');
				$data_insert['fsm_c_500'] = $this->input->post('c_500');
				$data_insert['fsm_p_500'] = $this->input->post('p_500');
				$data_insert['fsm_m_501'] = $this->input->post('m_501');
				$data_insert['fsm_c_501'] = $this->input->post('c_501');
				$data_insert['fsm_p_501'] = $this->input->post('p_501');

				$data_insert['fsm_observaciones'] = $this->input->post('observaciones');			
				

				/******
				    $data_clte['clte_path_foto'] = $cliente ['clte_path_foto'];
                    
					if(!empty($_FILES['foto']['name']))
                    {
                        $this->load->library('upload');
                        $filename = md5(time());
                        $config = array(
                                'upload_path'   => './../../files/nordico/',
                                'overwrite'     => TRUE,
                                'file_name'     => $filename,
                                'allowed_types' => 'png|jpg|jpeg',
                                'max_size'      => '25000'
                        );

                        $this->upload->initialize($config);
                        if ( ! $this->upload->do_upload('foto'))
                        {
                            send_json_error($this->upload->display_errors());
                        }
                        else 
                        {
                            $data = $this->upload->data();
                            $data_clte['clte_path_foto'] = $data['file_name'];
                        }
                    }


					if(!empty($_FILES['foto']['name']))
                    {
                        $this->load->library('upload');
                        $filename = md5(time());
                        $config = array(
                                'upload_path'   => './../../files/nordico/',
                                'overwrite'     => TRUE,
                                'file_name'     => $filename,
                                'allowed_types' => 'png|jpg|jpeg',
                                'max_size'      => '25000'
                        );

                        $this->upload->initialize($config);
                        if ( ! $this->upload->do_upload('foto'))
                        {
                            send_json_error($this->upload->display_errors());
                        }
                        else 
                        {
                            $data = $this->upload->data();
                            $data_insert['fsm_path_cuerpo'] = $data['file_name'];
                        }
                    }
					**/

		//$data_insert['fsm_path_cuerpo'] ='PREVIO';			
	  if(!empty($_FILES['foto']['name']))
      {
	  $data_insert['fsm_path_cuerpo'] ='DENTRO';
      $errors= array();
      $file_name = $_FILES['foto']['name'];
      $file_size = $_FILES['foto']['size'];
      $file_tmp = $_FILES['foto']['tmp_name'];
      $file_type = $_FILES['foto']['type'];
      $file_exts=strtolower((explode('.',$_FILES['image']['name'])));
	  
	  //if (strstr(strtolower($_FILES['image']['name']),'jpg'))
	  {$file_ext='jpg';}
	  
      $expensions= array("jpeg","jpg","png");
     
      if(in_array($file_ext,$expensions)=== false){
         $errors[]="extension not allowed, please choose a JPEG or PNG file.";
		 $data_insert['fsm_path_cuerpo'] ='extension not allowed, please choose a JPEG or PNG file.';
	     $errors= array();
	  }
     
      if($file_size > 2097152) {
         $errors[]='File size must be excately 2 MB';
		 $data_insert['fsm_path_cuerpo'] ='File size must be excately 2 MB';
      }
     
      if(empty($errors)==true) {
		 $file_name=strtolower(md5(time())).'.'.$file_ext;
         move_uploaded_file($file_tmp,"./../../files/nordico/".$file_name);
         echo "Success";
		 $data_insert['fsm_path_cuerpo'] = "Success";
      }else{
         print_r($errors);
      }
   }

	$data_insert['fsm_path_cuerpo'] = $file_name;

	
				if ($medico['usr_genero_cve'] == 'H') {$gen= 'Dr. ';} else {$gen= 'Dra. ';}
				$data_insert['fsm_med_nombre'] = $gen.$medico['usr_nombre'].' '.$medico['usr_paterno'].' '.$medico['usr_materno'];
				$data_insert['fsm_med_cedula'] =$medico['usr_cedula'];
				$data_insert['fsm_med_carrera'] =$medico['usr_carrera'];
				$data_insert['fsm_med_escuela'] =$medico['usr_institucion'];

				$data_insert['log_updt_f']   =  date("Y-m-d H:i:s");
				$data_insert['log_updt_usr_cve']  = $user['usr_id']; 

				$data_insert=array_to_upper($data_insert);

				if ($this->salud_ocupacional->update_ISONORDICO($fsm_id,$data_insert))
                {	
					header('Location:'.base_url('persona/id').'/'.$cliente_id); 
					exit;
                   // send_json_ok('Se actualizo el registro en forma correcta.');
                }
                else
                {
                    send_json_error('Ocurrió un error al actualizar el registro.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
            $this->load->helper('template');
            $params_view = array(
                'title' => '',
                'view' => 'examen/salud_ocupacional/edit_ISONORDICO',
                'view_data' => $data 
               );
            render_template($params_view);
        }
    }
/*************************************************************************************/
    public function nuevo_ISONORDICO($cliente_id)
    {    
		$user = $this->session->user;
		$cliente = $this->cliente->get($cliente_id);
		$empresa=$cliente['emp_id'];	
		$persona = $this->cliente->get($cliente_id);

        if($cliente)
        {

            if(isset($_POST) && count($_POST) > 0)     
            {
                $this->load->library('form_validation');
               /* $this->form_validation->set_rules('nombre','Nombre','required');
                $this->form_validation->set_rules('paterno','Apellido Paterno','required');
                $this->form_validation->set_rules('materno','Apellido Materno','required');
                $this->form_validation->set_rules('fnac','Fecha de nacimiento','required');*/
                $this->form_validation->set_rules('jefe','Jefe Inmediato','required');
              /*  $this->form_validation->set_rules('civil','Estado civil','required');
                $this->form_validation->set_rules('rfc','RFC','required');
                $this->form_validation->set_rules('curp','CURP','required');*/

                if($this->form_validation->run())
                {

/*********************************************************************/

				$data_insert['clte_id'] = $persona['clte_id'];
				$data_insert['fsm_edad']=intval(trim(str_replace("años", "",get_edad($persona['clte_f_nac']))));
				
				$data_insert['fsm_f_nac']=$persona['clte_f_nac'];
				$data_insert['fsm_genero']=$persona['clte_genero_cve'];
				$data_insert['emp_id'] = $persona['emp_id'];
				$data_insert['suc_id'] = $persona['suc_id'];               
                $data_insert['serv_id']  = $persona['serv_id']; 
                $data_insert['usr_id']  = $user['usr_id'];
                $data_insert['fsm_f']   =  date("Y-m-d H:i:s");
				
				$data_insert['fsm_f_y']   =  date("Y");
				$data_insert['fsm_f_m']   =  date("m");
				$data_insert['fsm_f_d']   =  date("d");
				$data_insert['fsm_f_h']   =  date("H");
				$data_insert['fsm_f_i']   =  date("i");
								
				$data_insert['med_id'] = $this->input->post('medico');				
				$medico = $this->medico->get($data_insert['med_id']);
			
				$data_insert['fsm_jefe'] = $this->input->post('jefe');
				$data_insert['fsm_planta'] = $this->input->post('planta');
				$data_insert['fsm_antiguedad_empresa'] = $this->input->post('antiguedad_empresa');
				$data_insert['fsm_linea'] = $this->input->post('linea');
				$data_insert['fsm_antiguedad_area'] = $this->input->post('antiguedad_area');
				$data_insert['fsm_area_depto'] = $this->input->post('area_depto');
				$data_insert['fsm_edad_custionario'] = $this->input->post('edad_custionario');
				$data_insert['fsm_puesto'] = $this->input->post('puesto');
				$data_insert['fsm_riesgos_trabajo'] = $this->input->post('riesgos_trabajo');
				$data_insert['fsm_mano'] = $this->input->post('mano');
				$data_insert['fsm_cuello'] = $this->input->post('cuello');
				$data_insert['fsm_hombro_der'] = $this->input->post('hombro_der');
				$data_insert['fsm_hombro_izq'] = $this->input->post('hombro_izq');
				$data_insert['fsm_espalda'] = $this->input->post('espalda');
				$data_insert['fsm_codo_der'] = $this->input->post('codo_der');
				$data_insert['fsm_codo_izq'] = $this->input->post('codo_izq');
				$data_insert['fsm_mano_der'] = $this->input->post('mano_der');
				$data_insert['fsm_mano_izq'] = $this->input->post('mano_izq');
				$data_insert['fsm_sentado_20'] = $this->input->post('sentado_20');
				$data_insert['fsm_sentado_40'] = $this->input->post('sentado_40');
				$data_insert['fsm_sentado_60'] = $this->input->post('sentado_60');
				$data_insert['fsm_sentado_80'] = $this->input->post('sentado_80');
				$data_insert['fsm_sentado_100'] = $this->input->post('sentado_100');
				$data_insert['fsm_pie_20'] = $this->input->post('pie_20');
				$data_insert['fsm_pie_40'] = $this->input->post('pie_40');
				$data_insert['fsm_pie_60'] = $this->input->post('pie_60');
				$data_insert['fsm_pie_80'] = $this->input->post('pie_80');
				$data_insert['fsm_pie_100'] = $this->input->post('pie_100');
				$data_insert['fsm_encuclillado_20'] = $this->input->post('encuclillado_20');
				$data_insert['fsm_encuclillado_40'] = $this->input->post('encuclillado_40');
				$data_insert['fsm_encuclillado_60'] = $this->input->post('encuclillado_60');
				$data_insert['fsm_encuclillado_80'] = $this->input->post('encuclillado_80');
				$data_insert['fsm_encuclillado_100'] = $this->input->post('encuclillado_100');
				$data_insert['fsm_ftorax_20'] = $this->input->post('ftorax_20');
				$data_insert['fsm_ftorax_40'] = $this->input->post('ftorax_40');
				$data_insert['fsm_ftorax_60'] = $this->input->post('ftorax_60');
				$data_insert['fsm_ftorax_80'] = $this->input->post('ftorax_80');
				$data_insert['fsm_ftorax_100'] = $this->input->post('ftorax_100');
				$data_insert['fsm_etorax_20'] = $this->input->post('etorax_20');
				$data_insert['fsm_etorax_40'] = $this->input->post('etorax_40');
				$data_insert['fsm_etorax_60'] = $this->input->post('etorax_60');
				$data_insert['fsm_etorax_80'] = $this->input->post('etorax_80');
				$data_insert['fsm_etorax_100'] = $this->input->post('etorax_100');
				$data_insert['fsm_m_125'] = $this->input->post('m_125');
				$data_insert['fsm_c_125'] = $this->input->post('c_125');
				$data_insert['fsm_p_125'] = $this->input->post('p_125');
				$data_insert['fsm_m_250'] = $this->input->post('m_250');
				$data_insert['fsm_c_250'] = $this->input->post('c_250');
				$data_insert['fsm_p_250'] = $this->input->post('p_250');
				$data_insert['fsm_m_375'] = $this->input->post('m_375');
				$data_insert['fsm_c_375'] = $this->input->post('c_375');
				$data_insert['fsm_p_375'] = $this->input->post('p_375');
				$data_insert['fsm_m_500'] = $this->input->post('m_500');
				$data_insert['fsm_c_500'] = $this->input->post('c_500');
				$data_insert['fsm_p_500'] = $this->input->post('p_500');
				$data_insert['fsm_m_501'] = $this->input->post('m_501');
				$data_insert['fsm_c_501'] = $this->input->post('c_501');
				$data_insert['fsm_p_501'] = $this->input->post('p_501');

				$data_insert['fsm_observaciones'] = $this->input->post('observaciones');

				if ($medico['usr_genero_cve'] == 'H') {$gen= 'Dr. ';} else {$gen= 'Dra. ';}
				$data_insert['fsm_med_nombre'] = $gen.$medico['usr_nombre'].' '.$medico['usr_paterno'].' '.$medico['usr_materno'];
				$data_insert['fsm_med_cedula'] =$medico['usr_cedula'];
				$data_insert['fsm_med_carrera'] =$medico['usr_carrera'];
				$data_insert['fsm_med_escuela'] =$medico['usr_institucion'];
				
				$data_insert['log_insrt_f']   =  date("Y-m-d H:i:s");
				$data_insert['log_insrt_usr_cve']  = $user['usr_id'];
				$data_insert['log_updt_f']   =  date("Y-m-d H:i:s");
				$data_insert['log_updt_usr_cve']  = $user['usr_id']; 

/*********************************************************************/


				    $data_clte['clte_path_foto'] = $cliente ['clte_path_foto'];
                    
					if(!empty($_FILES['foto']['name']))
                    {
                        $this->load->library('upload');
                        $filename = md5(time());
                        $config = array(
                                'upload_path'   => './../../files/nordico/',
                                'overwrite'     => TRUE,
                                'file_name'     => $filename,
                                'allowed_types' => 'png|jpg|jpeg',
                                'max_size'      => '25000'
                        );

                        $this->upload->initialize($config);
                        if ( ! $this->upload->do_upload('foto'))
                        {
                            send_json_error($this->upload->display_errors());
                        }
                        else 
                        {
                            $data = $this->upload->data();
                            $data_clte['clte_path_foto'] = $data['file_name'];
                        }
                    }


					if(!empty($_FILES['foto']['name']))
                    {
                        $this->load->library('upload');
                        $filename = md5(time());
                        $config = array(
                                'upload_path'   => './../../files/nordico/',
                                'overwrite'     => TRUE,
                                'file_name'     => $filename,
                                'allowed_types' => 'png|jpg|jpeg',
                                'max_size'      => '25000'
                        );

                        $this->upload->initialize($config);
                        if ( ! $this->upload->do_upload('foto'))
                        {
                            send_json_error($this->upload->display_errors());
                        }
                        else 
                        {
                            $data = $this->upload->data();
                            $data_insert['fsm_path_cuerpo'] = $data['file_name'];
                        }
                    }


					 
					
					$ISONORDICO=$this->salud_ocupacional->insert_ISONORDICO(array_to_upper($data_insert));

					if($ISONORDICO)
					{
						send_json_ok(array('msg' =>'Se actualizó la información del Empleado', 'id' => $cliente_id));
					}
					else
					{
						send_json_error('Ocurrió un error al actualizar la persona.');
					}
					
					
                }
                else
                {
                    send_json_error(validation_errors('<div />'));
                }
            }
            else 
            {
                $this->load->model('empresa/Empresa_model','empresa');

				$data['sucursals'] = $this->empresa->get_all_sucursales($empresa);
				$data['consultorios'] = $this->empresa->get_lista_consultorios();
                $data['persona'] = 	$cliente;
				$data['worker'] = 	$worker;
				$data['worker_usr'] = 	$worker_usr;
				
				if ($cliente['serv_id'] > 0)
				{
					$data['servicio'] = $servicio;
				}
                $this->load->helper('template');
                $params_view = array(
                    'title' => 'Personas',
                    /*'view' => 'persona/edit_empleado_x',*/
					'view' => 'examen/salud_ocupacional/nuevo_form_ISONORDICO',
                    'view_data' => $data
                   );
                render_template($params_view);  
            }
        }
        else 
        {
            show_error('No existe el cliente');
        }
    }

/*************************************************************************************/
	public function editar_ISOEXMEDINEX($cliente_id, $fsm_id)
    {
        $persona = $this->cliente->get($cliente_id);
		$data['fsm'] = $this->salud_ocupacional->get_ISOEXMEDINEX($fsm_id);		
        $user = $this->session->user;

        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');

            if(true)
            {
			/*	$data_insert['clte_id'] = $persona['clte_id'];
				$data_insert['fsm_edad']=intval(trim(str_replace("años", "",get_edad($persona['clte_f_nac']))));
				
				$data_insert['fsm_f_nac']=$persona['clte_f_nac'];
				$data_insert['fsm_genero']=$persona['clte_genero_cve'];
				$data_insert['emp_id'] = $persona['emp_id'];
				$data_insert['suc_id'] = $persona['suc_id'];               
                $data_insert['serv_id']  = '';
                $data_insert['usr_id']  = $user['usr_id'];
                $data_insert['fsm_f']   =  date("Y-m-d H:i:s");
				
				$data_insert['fsm_f_y']   =  date("Y");
				$data_insert['fsm_f_m']   =  date("m");
				$data_insert['fsm_f_d']   =  date("d");
				$data_insert['fsm_f_h']   =  date("H");
				$data_insert['fsm_f_i']   =  date("i");
			*/					

/**************************************/
								
				$data_insert['med_id'] = $this->input->post('medico');				
				$medico = $this->medico->get($data_insert['med_id']);

/*				
				$data_insert['fsm_area'] = $this->input->post('area');
				$data_insert['fsm_turno'] = $this->input->post('turno');
				$data_insert['fsm_antiguedad'] = $this->input->post('antiguedad'); 
				$data_insert['fsm_accidente_av'] = $this->input->post('accidente_av');
				$data_insert['fsm_parentesco_av'] = $this->input->post('parentesco_av');
				$data_insert['fsm_telefono_av'] = $this->input->post('telefono_av');
				$data_insert['fsm_clinica_imss'] = $this->input->post('clinica_imss');
				$data_insert['fsm_no_consultorio'] = $this->input->post('no_consultorio');
*/
				$data_insert['fsm_religion'] = $this->input->post('religion');
				$data_insert['fsm_profesion'] = $this->input->post('profesion');
				$data_insert['fsm_padre_vive']= $this->input->post('padre_vive');
				$data_insert['fsm_padre_diabetes']= $this->input->post('padre_diabetes');
				$data_insert['fsm_padre_hipertesion']= $this->input->post('padre_hipertesion');
				$data_insert['fsm_padre_corazon']= $this->input->post('padre_corazon');
				$data_insert['fsm_padre_pulmones']= $this->input->post('padre_pulmones');
				$data_insert['fsm_padre_cancer']= $this->input->post('padre_cancer');
				$data_insert['fsm_padre_otros']= $this->input->post('padre_otros');
				$data_insert['fsm_padre_mentales']= $this->input->post('padre_mentales');
				$data_insert['fsm_madre_vive']= $this->input->post('madre_vive');
				$data_insert['fsm_madre_diabetes']= $this->input->post('madre_diabetes');
				$data_insert['fsm_madre_hipertesion']= $this->input->post('madre_hipertesion');
				$data_insert['fsm_madre_corazon']= $this->input->post('madre_corazon');
				$data_insert['fsm_madre_pulmones']= $this->input->post('madre_pulmones');
				$data_insert['fsm_madre_cancer']= $this->input->post('madre_cancer');
				$data_insert['fsm_madre_otros']= $this->input->post('madre_otros');
				$data_insert['fsm_madre_mentales']= $this->input->post('madre_mentales');
				$data_insert['fsm_hermanos_vive']= $this->input->post('hermanos_vive');
				$data_insert['fsm_hermanos_diabetes']= $this->input->post('hermanos_diabetes');
				$data_insert['fsm_hermanos_hipertesion']= $this->input->post('hermanos_hipertesion');
				$data_insert['fsm_hermanos_corazon']= $this->input->post('hermanos_corazon');
				$data_insert['fsm_hermanos_pulmones']= $this->input->post('hermanos_pulmones');
				$data_insert['fsm_hermanos_cancer']= $this->input->post('hermanos_cancer');
				$data_insert['fsm_hermanos_otros']= $this->input->post('hermanos_otros');
				$data_insert['fsm_hermanos_mentales']= $this->input->post('hermanos_mentales');
				$data_insert['fsm_abuelo_paternos_vive']= $this->input->post('abuelo_paternos_vive');
				$data_insert['fsm_abuelo_paternos_diabetes']= $this->input->post('abuelo_paternos_diabetes');
				$data_insert['fsm_abuelo_paternos_hipertesion']= $this->input->post('abuelo_paternos_hipertesion');
				$data_insert['fsm_abuelo_paternos_corazon']= $this->input->post('abuelo_paternos_corazon');
				$data_insert['fsm_abuelo_paternos_pulmones']= $this->input->post('abuelo_paternos_pulmones');
				$data_insert['fsm_abuelo_paternos_cancer']= $this->input->post('abuelo_paternos_cancer');
				$data_insert['fsm_abuelo_paternos_otros']= $this->input->post('abuelo_paternos_otros');
				$data_insert['fsm_abuelo_paternos_mentales']= $this->input->post('abuelo_paternos_mentales');
				$data_insert['fsm_abuela_paternos_vive']= $this->input->post('abuela_paternos_vive');
				$data_insert['fsm_abuela_paternos_diabetes']= $this->input->post('abuela_paternos_diabetes');
				$data_insert['fsm_abuela_paternos_hipertesion']= $this->input->post('abuela_paternos_hipertesion');
				$data_insert['fsm_abuela_paternos_corazon']= $this->input->post('abuela_paternos_corazon');
				$data_insert['fsm_abuela_paternos_pulmones']= $this->input->post('abuela_paternos_pulmones');
				$data_insert['fsm_abuela_paternos_cancer']= $this->input->post('abuela_paternos_cancer');
				$data_insert['fsm_abuela_paternos_otros']= $this->input->post('abuela_paternos_otros');
				$data_insert['fsm_abuela_paternos_mentales']= $this->input->post('abuela_paternos_mentales');
				$data_insert['fsm_abuelo_maternos_vive']= $this->input->post('abuelo_maternos_vive');
				$data_insert['fsm_abuelo_maternos_diabetes']= $this->input->post('abuelo_maternos_diabetes');
				$data_insert['fsm_abuelo_maternos_hipertesion']= $this->input->post('abuelo_maternos_hipertesion');
				$data_insert['fsm_abuelo_maternos_corazon']= $this->input->post('abuelo_maternos_corazon');
				$data_insert['fsm_abuelo_maternos_pulmones']= $this->input->post('abuelo_maternos_pulmones');
				$data_insert['fsm_abuelo_maternos_cancer']= $this->input->post('abuelo_maternos_cancer');
				$data_insert['fsm_abuelo_maternos_otros']= $this->input->post('abuelo_maternos_otros');
				$data_insert['fsm_abuelo_maternos_mentales']= $this->input->post('abuelo_maternos_mentales');
				$data_insert['fsm_abuela_maternos_vive']= $this->input->post('abuela_maternos_vive');
				$data_insert['fsm_abuela_maternos_diabetes']= $this->input->post('abuela_maternos_diabetes');
				$data_insert['fsm_abuela_maternos_hipertesion']= $this->input->post('abuela_maternos_hipertesion');
				$data_insert['fsm_abuela_maternos_corazon']= $this->input->post('abuela_maternos_corazon');
				$data_insert['fsm_abuela_maternos_pulmones']= $this->input->post('abuela_maternos_pulmones');
				$data_insert['fsm_abuela_maternos_cancer']= $this->input->post('abuela_maternos_cancer');
				$data_insert['fsm_abuela_maternos_otros']= $this->input->post('abuela_maternos_otros');
				$data_insert['fsm_abuela_maternos_mentales']= $this->input->post('abuela_maternos_mentales');
				$data_insert['fsm_hijos_vive']= $this->input->post('hijos_vive');
				$data_insert['fsm_hijos_diabetes']= $this->input->post('hijos_diabetes');
				$data_insert['fsm_hijos_hipertesion']= $this->input->post('hijos_hipertesion');
				$data_insert['fsm_hijos_corazon']= $this->input->post('hijos_corazon');
				$data_insert['fsm_hijos_pulmones']= $this->input->post('hijos_pulmones');
				$data_insert['fsm_hijos_cancer']= $this->input->post('hijos_cancer');
				$data_insert['fsm_hijos_otros']= $this->input->post('hijos_otros');
				$data_insert['fsm_hijos_mentales']= $this->input->post('hijos_mentales');
				$data_insert['fsm_alcohol']= $this->input->post('alcohol');
				$data_insert['fsm_inicio_alcohol']= $this->input->post('inicio_alcohol');
				$data_insert['fsm_fin_alcohol']= $this->input->post('fin_alcohol');
				$data_insert['fsm_cantidad_alcohol']= $this->input->post('cantidad_alcohol');
				$data_insert['fsm_tabaco']= $this->input->post('tabaco');
				$data_insert['fsm_inicio_tabaco']= $this->input->post('inicio_tabaco');
				$data_insert['fsm_fin_tabaco']= $this->input->post('fin_tabaco');
				$data_insert['fsm_cantidad_tabaco']= $this->input->post('cantidad_tabaco');
				$data_insert['fsm_drogas']= $this->input->post('drogas');
				$data_insert['fsm_inicio_drogas']= $this->input->post('inicio_drogas');
				$data_insert['fsm_fin_drogas']= $this->input->post('fin_drogas');
				$data_insert['fsm_cantidad_drogas']= $this->input->post('cantidad_drogas');
				$data_insert['fsm_deportes']= $this->input->post('deportes');
				$data_insert['fsm_cual_deportes']= $this->input->post('cual_deportes');
				$data_insert['fsm_frutas']= $this->input->post('frutas');
				$data_insert['fsm_pan']= $this->input->post('pan');
				$data_insert['fsm_pollo']= $this->input->post('pollo');
				$data_insert['fsm_carne']= $this->input->post('carne');
				$data_insert['fsm_refrescos']= $this->input->post('refrescos');
				$data_insert['fsm_tortillas']= $this->input->post('tortillas');
				$data_insert['fsm_frituras']= $this->input->post('frituras');
				$data_insert['fsm_habitaciones']= $this->input->post('habitaciones');
				$data_insert['fsm_material']= $this->input->post('material');
				$data_insert['fsm_luz']= $this->input->post('luz');
				$data_insert['fsm_agua']= $this->input->post('agua');
				$data_insert['fsm_drenaje']= $this->input->post('drenaje');
				$data_insert['fsm_paredes']= $this->input->post('paredes');
				$data_insert['fsm_cirugias']= $this->input->post('cirugias');
				$data_insert['fsm_cuando_cirugias']= $this->input->post('cuando_cirugias');
				$data_insert['fsm_motivo_cirugias']= $this->input->post('motivo_cirugias');
				$data_insert['fsm_transfusiones']= $this->input->post('transfusiones');
				$data_insert['fsm_cuando_transfusiones']= $this->input->post('cuando_transfusiones');
				$data_insert['fsm_motivo_transfusiones']= $this->input->post('motivo_transfusiones');
				$data_insert['fsm_hospitalizaciones']= $this->input->post('hospitalizaciones');
				$data_insert['fsm_cuando_hospitalizaciones']= $this->input->post('cuando_hospitalizaciones');
				$data_insert['fsm_motivo_hospitalizaciones']= $this->input->post('motivo_hospitalizaciones');
				
				$data_insert['fsm_usa_lentes']= $this->input->post('usa_lentes');
				$data_insert['fsm_cuando_usa_lentes']= $this->input->post('cuando_usa_lentes');
				$data_insert['fsm_motivo_usa_lentes']= $this->input->post('motivo_usa_lentes');
				
				
				$data_insert['fsm_alergias']= $this->input->post('alergias');
				$data_insert['fsm_cuando_alergias']= $this->input->post('cuando_alergias');
				$data_insert['fsm_motivo_alergias']= $this->input->post('motivo_alergias');
				$data_insert['fsm_vacunacion']= $this->input->post('vacunacion');
				$data_insert['fsm_ultima_vacuna']= $this->input->post('ultima_vacuna');
				$data_insert['fsm_cronica1']= $this->input->post('cronica1');
				$data_insert['fsm_infecciosas1']= $this->input->post('infecciosas1');
				$data_insert['fsm_neurologicas1']= $this->input->post('neurologicas1');
				$data_insert['fsm_cronica2']= $this->input->post('cronica2');
				$data_insert['fsm_infecciosas2']= $this->input->post('infecciosas2');
				$data_insert['fsm_neurologicas2']= $this->input->post('neurologicas2');
				$data_insert['fsm_cronica3']= $this->input->post('cronica3');
				$data_insert['fsm_infecciosas3']= $this->input->post('infecciosas3');
				$data_insert['fsm_neurologicas3']= $this->input->post('neurologicas3');
				$data_insert['fsm_cronica4']= $this->input->post('cronica4');
				$data_insert['fsm_infecciosas4']= $this->input->post('infecciosas4');
				$data_insert['fsm_neurologicas4']= $this->input->post('neurologicas4');
				$data_insert['fsm_cronica5']= $this->input->post('cronica5');
				$data_insert['fsm_infecciosas5']= $this->input->post('infecciosas5');
				$data_insert['fsm_neurologicas5']= $this->input->post('neurologicas5');
				$data_insert['fsm_trabajo1']= $this->input->post('trabajo1');
				$data_insert['fsm_otras_enf1']= $this->input->post('otras_enf1');
				$data_insert['fsm_smujeres1']= $this->input->post('smujeres1');
				$data_insert['fsm_trabajo2']= $this->input->post('trabajo2');
				$data_insert['fsm_otras_enf2']= $this->input->post('otras_enf2');
				$data_insert['fsm_smujeres2']= $this->input->post('smujeres2');
				$data_insert['fsm_trabajo3']= $this->input->post('trabajo3');
				$data_insert['fsm_otras_enf3']= $this->input->post('otras_enf3');
				$data_insert['fsm_smujeres3']= $this->input->post('smujeres3');
				$data_insert['fsm_trabajo4']= $this->input->post('trabajo4');
				$data_insert['fsm_otras_enf4']= $this->input->post('otras_enf4');
				$data_insert['fsm_smujeres4']= $this->input->post('smujeres4');
				$data_insert['fsm_otras_enf5']= $this->input->post('otras_enf5');
				$data_insert['fsm_otras_enf6']= $this->input->post('otras_enf6');
				$data_insert['fsm_accidentes']= $this->input->post('accidentes');
				$data_insert['fsm_cuales_accidentes']= $this->input->post('cuales_accidentes');
				$data_insert['fsm_cuando_accidente']= $this->input->post('cuando_accidente');
				$data_insert['fsm_sequelas_accidentes']= $this->input->post('sequelas_accidentes');
				$data_insert['fsm_ipp_accidentes']= $this->input->post('ipp_accidentes');
				$data_insert['fsm_enfermedades_trabajo']= $this->input->post('enfermedades_trabajo');
				$data_insert['fsm_cuales_enfermedades_trabajo']= $this->input->post('cuales_enfermedades_trabajo');
				$data_insert['fsm_cuando_enfermedades_trabajo']= $this->input->post('cuando_enfermedades_trabajo');
				$data_insert['fsm_sequelas_enfermedades_trabajo']= $this->input->post('sequelas_enfermedades_trabajo');
				$data_insert['fsm_ipp_enfermedades_trabajo']= $this->input->post('ipp_enfermedades_trabajo');
				$data_insert['fsm_acc_viales']= $this->input->post('acc_viales');
				$data_insert['fsm_cuales_acc_viales']= $this->input->post('cuales_acc_viales');
				$data_insert['fsm_cuando_acc_viales']= $this->input->post('cuando_acc_viales');
				$data_insert['fsm_sequelas_acc_viales']= $this->input->post('sequelas_acc_viales');
				$data_insert['fsm_ipp_acc_viales']= $this->input->post('ipp_acc_viales');
				$data_insert['fsm_puesto_ante1']= $this->input->post('puesto_ante1');
				$data_insert['fsm_puesto_ante_anios1']= $this->input->post('puesto_ante_anios1');
				$data_insert['fsm_puesto_ante_exp1']= $this->input->post('puesto_ante_exp1');
				$data_insert['fsm_puesto_ante2']= $this->input->post('puesto_ante2');
				$data_insert['fsm_puesto_ante_anios2']= $this->input->post('puesto_ante_anios2');
				$data_insert['fsm_puesto_ante_exp2']= $this->input->post('puesto_ante_exp2');
				$data_insert['fsm_puesto_ante3']= $this->input->post('puesto_ante3');
				$data_insert['fsm_puesto_ante_anios3']= $this->input->post('puesto_ante_anios3');
				$data_insert['fsm_puesto_ante_exp3']= $this->input->post('puesto_ante_exp3');
				$data_insert['fsm_puesto_ante4']= $this->input->post('puesto_ante4');
				$data_insert['fsm_puesto_ante_anios4']= $this->input->post('puesto_ante_anios4');
				$data_insert['fsm_puesto_ante_exp4']= $this->input->post('puesto_ante_exp4');
				$data_insert['fsm_puesto_ante5']= $this->input->post('puesto_ante5');
				$data_insert['fsm_puesto_ante_anios5']= $this->input->post('puesto_ante_anios5');
				$data_insert['fsm_puesto_ante_exp5']= $this->input->post('puesto_ante_exp5');
				$data_insert['fsm_puesto_ante6']= $this->input->post('puesto_ante6');
				$data_insert['fsm_puesto_ante_anios6']= $this->input->post('puesto_ante_anios6');
				$data_insert['fsm_puesto_ante_exp6']= $this->input->post('puesto_ante_exp6');
				$data_insert['fsm_puesto_ante7']= $this->input->post('puesto_ante7');
				$data_insert['fsm_puesto_ante_anios7']= $this->input->post('puesto_ante_anios7');
				$data_insert['fsm_puesto_ante_exp7']= $this->input->post('puesto_ante_exp7');
				$data_insert['fsm_puesto_ante8']= $this->input->post('puesto_ante8');
				$data_insert['fsm_puesto_ante_anios8']= $this->input->post('puesto_ante_anios8');
				$data_insert['fsm_puesto_ante_exp8']= $this->input->post('puesto_ante_exp8');
				
				//Examen Médico de IPAS
				//SIGNOS VITALES
				$data_insert['fsm_ta1'] = $this->input->post('ta1');
				$data_insert['fsm_ta2'] = $this->input->post('ta2');
				$data_insert['fsm_sato2'] = $this->input->post('sato2');
				$data_insert['fsm_fc'] = $this->input->post('fc');
				$data_insert['fsm_fr'] = $this->input->post('fr');
				$data_insert['fsm_temp'] = $this->input->post('temp');
				$data_insert['fsm_estatura'] = $this->input->post('estatura');
				$data_insert['fsm_peso'] = $this->input->post('peso');
				$data_insert['fsm_imc'] = $this->input->post('imc');

				$data_insert['fsm_organo_sentidos']= $this->input->post('organo_sentidos');
				$data_insert['fsm_respiratorio']= $this->input->post('respiratorio');
				$data_insert['fsm_cardiovascular']= $this->input->post('cardiovascular');
				$data_insert['fsm_digestivo']= $this->input->post('digestivo');
				$data_insert['fsm_genitourinario']= $this->input->post('genitourinario');
				$data_insert['fsm_musculoesquelético']= $this->input->post('musculoesquelético');
				$data_insert['fsm_menarca']= $this->input->post('menarca');
				$data_insert['fsm_ritmog']= $this->input->post('ritmog');
				$data_insert['fsm_ividasex']= $this->input->post('ividasex');
				$data_insert['fsm_num_parejas']= $this->input->post('num_parejas');
				$data_insert['fsm_umenstraucion']= $this->input->post('umenstraucion');
				$data_insert['fsm_papanicolao']= $this->input->post('papanicolao');
				$data_insert['fsm_exmama']= $this->input->post('exmama');
				$data_insert['fsm_comentariosg']= $this->input->post('comentariosg');
				$data_insert['fsm_gestas']= $this->input->post('gestas');
				$data_insert['fsm_partos']= $this->input->post('partos');
				$data_insert['fsm_cesareas']= $this->input->post('cesareas');
				$data_insert['fsm_abortos']= $this->input->post('abortos');
				$data_insert['fsm_mpf']= $this->input->post('mpf');
				$data_insert['fsm_trauma1']= $this->input->post('trauma1');
				$data_insert['fsm_trauma2']= $this->input->post('trauma2');
				$data_insert['fsm_trauma3']= $this->input->post('trauma3');
				$data_insert['fsm_trauma4']= $this->input->post('trauma4');

				//$data_insert['fsm_ante_no_pato'] = $this->input->post('ante_no_pato');
				//$data_insert['fsm_ante_pato'] = $this->input->post('ante_pato');
				//$data_insert['fsm_padec_actual'] = $this->input->post('padec_actual');
				
				//cabeza
				$data_insert['fsm_craneo'] = $this->input->post('craneo');
				$data_insert['fsm_craneo_exp'] = $this->input->post('craneo_exp');
				$data_insert['fsm_cara'] = $this->input->post('cara');
				$data_insert['fsm_cara_exp'] = $this->input->post('cara_exp');

				//cuello
				$data_insert['fsm_cilindro'] = $this->input->post('cilindro');
				$data_insert['fsm_cilindro_exp'] = $this->input->post('cilindro_exp');
				$data_insert['fsm_traquea'] = $this->input->post('traquea');
				$data_insert['fsm_traquea_exp'] = $this->input->post('traquea_exp');
				$data_insert['fsm_movilidad'] = $this->input->post('movilidad');
				$data_insert['fsm_movilidad_exp'] = $this->input->post('movilidad_exp');
				$data_insert['fsm_ganglios'] = $this->input->post('ganglios');
				$data_insert['fsm_ganglios_exp'] = $this->input->post('ganglios_exp');

				//ojos
				$data_insert['fsm_pupila_der'] = $this->input->post('pupila_der');
				$data_insert['fsm_pupila_izq'] = $this->input->post('pupila_izq');
				$data_insert['fsm_pupila_exp'] = $this->input->post('pupila_exp');
				
				$data_insert['fsm_cornea_der'] = $this->input->post('cornea_der');
				$data_insert['fsm_cornea_izq'] = $this->input->post('cornea_izq');
				$data_insert['fsm_cornea_exp'] = $this->input->post('cornea_exp');
				
				$data_insert['fsm_avisualsl_der'] = $this->input->post('avisualsl_der');
				$data_insert['fsm_avisualsl_izq'] = $this->input->post('avisualsl_izq');
				$data_insert['fsm_avisualsl_exp'] = $this->input->post('avisualsl_exp');
				
				$data_insert['fsm_avisualcl_der'] = $this->input->post('avisualcl_der');
				$data_insert['fsm_avisualcl_izq'] = $this->input->post('avisualcl_izq');
				$data_insert['fsm_avisualcl_exp'] = $this->input->post('avisualcl_exp');
				
				$data_insert['fsm_identifica_colores_der'] = $this->input->post('identifica_colores_der');
				$data_insert['fsm_identifica_colores_izq'] = $this->input->post('identifica_colores_izq');
				$data_insert['fsm_identifica_colores_exp'] = $this->input->post('identifica_colores_exp');
				
				$data_insert['fsm_movimiento_ocular_der'] = $this->input->post('movimiento_ocular_der');
				$data_insert['fsm_movimiento_ocular_izq'] = $this->input->post('movimiento_ocular_izq');
				$data_insert['fsm_movimiento_ocular_exp'] = $this->input->post('movimiento_ocular_exp');
				
				

				$data_insert['fsm_reflejos_oculares_der'] = $this->input->post('reflejos_oculares_der');
				$data_insert['fsm_reflejos_oculares_izq'] = $this->input->post('reflejos_oculares_izq');
				$data_insert['fsm_reflejos_oculares_exp'] = $this->input->post('reflejos_oculares_exp');
				
				
				
				$data_insert['fsm_ptregion_der'] = $this->input->post('ptregion_der');
				$data_insert['fsm_ptregion_izq'] = $this->input->post('ptregion_izq');
				$data_insert['fsm_ptregion_exp'] = $this->input->post('ptregion_exp');
				$data_insert['fsm_ojo_otros_exp'] = $this->input->post('ojo_otros_exp');
				
				//nariz
						$data_insert['fsm_mucosa'] = $this->input->post('mucosa');
						$data_insert['fsm_mucosa_exp'] = $this->input->post('mucosa_exp');
						$data_insert['fsm_cornetes'] = $this->input->post('cornetes');
						$data_insert['fsm_cornetes_exp'] = $this->input->post('cornetes_exp');
						$data_insert['fsm_polipos'] = $this->input->post('polipos');
						$data_insert['fsm_polipos_exp'] = $this->input->post('polipos_exp');
						$data_insert['fsm_septum'] = $this->input->post('septum');
						$data_insert['fsm_septum_exp'] = $this->input->post('septum_exp');

				//oidos
				$data_insert['fsm_membrana_timpano_der'] = $this->input->post('membrana_timpano_der');
				$data_insert['fsm_membrana_timpano_izq'] = $this->input->post('membrana_timpano_izq');
				$data_insert['fsm_membrana_timpano_exp'] = $this->input->post('membrana_timpano_exp');
				
				$data_insert['fsm_conducto_der'] = $this->input->post('conducto_der');
				$data_insert['fsm_conducto_izq'] = $this->input->post('conducto_izq');
				$data_insert['fsm_conducto_exp'] = $this->input->post('conducto_exp');
				
				
				
				$data_insert['fsm_pabellon_der'] = $this->input->post('pabellon_der');
				$data_insert['fsm_pabellon_izq'] = $this->input->post('pabellon_izq');
				$data_insert['fsm_pabellon_exp'] = $this->input->post('pabellon_exp');
				
				//cavida bucal
				$data_insert['fsm_encias'] = $this->input->post('encias');
				$data_insert['fsm_encias_exp'] = $this->input->post('encias_exp');
				$data_insert['fsm_mucosa_bucal'] = $this->input->post('mucosa_bucal');
				$data_insert['fsm_mucosa_bucal_exp'] = $this->input->post('mucosa_bucal_exp');
				$data_insert['fsm_paladar'] = $this->input->post('paladar');
				$data_insert['fsm_paladar_exp'] = $this->input->post('paladar_exp');
				$data_insert['fsm_lengua'] = $this->input->post('lengua');
				$data_insert['fsm_lengua_exp'] = $this->input->post('lengua_exp');
				$data_insert['fsm_amigdalas'] = $this->input->post('amigdalas');
				$data_insert['fsm_amigdalas_exp'] = $this->input->post('amigdalas_exp');
				$data_insert['fsm_dentadura'] = $this->input->post('dentadura');
				$data_insert['fsm_dentadura_exp'] = $this->input->post('dentadura_exp');

				
				//torax
				$data_insert['fsm_simetria'] = $this->input->post('simetria');
				$data_insert['fsm_simetria_exp'] = $this->input->post('simetria_exp');
				$data_insert['fsm_amplexion'] = $this->input->post('amplexion');
				$data_insert['fsm_amplexion_exp'] = $this->input->post('amplexion_exp');
				$data_insert['fsm_murmullo'] = $this->input->post('murmullo');
				$data_insert['fsm_murmullo_exp'] = $this->input->post('murmullo_exp');
				$data_insert['fsm_amplexacion'] = $this->input->post('amplexacion');
				$data_insert['fsm_amplexacion_exp'] = $this->input->post('amplexacion_exp');
				$data_insert['fsm_ventilacion'] = $this->input->post('ventilacion');
				$data_insert['fsm_ventilacion_exp'] = $this->input->post('ventilacion_exp');
				
				
				
				
				//area cardiaca
				$data_insert['fsm_ritmo'] = $this->input->post('ritmo');
				$data_insert['fsm_ritmo_exp'] = $this->input->post('ritmo_exp');
				$data_insert['fsm_intensidad'] = $this->input->post('intensidad');
				$data_insert['fsm_intensidad_exp'] = $this->input->post('intensidad_exp');
				$data_insert['fsm_ruidos'] = $this->input->post('ruidos');
				$data_insert['fsm_ruidos_exp'] = $this->input->post('ruidos_exp');
				$data_insert['fsm_soplos'] = $this->input->post('soplos');
				$data_insert['fsm_soplos_exp'] = $this->input->post('soplos_exp');


				//abdomen
				$data_insert['fsm_conformacion'] = $this->input->post('conformacion');
				
				$data_insert['fsm_peritasis'] = $this->input->post('peritasis');
				$data_insert['fsm_peritasis_exp'] = $this->input->post('peritasis_exp');
				
				$data_insert['fsm_visceromegalias'] = $this->input->post('visceromegalias');
				$data_insert['fsm_visceromegalias_exp'] = $this->input->post('visceromegalias_exp');
				
				$data_insert['fsm_hernias'] = $this->input->post('hernias');
				$data_insert['fsm_hernias_exp'] = $this->input->post('hernias_exp');
				$data_insert['fsm_abdomen_otros_exp'] = $this->input->post('abdomen_otros_exp');
				
				

				
				//lubosacra
				$data_insert['fsm_cv_conformacion'] = $this->input->post('cv_conformacion');
				$data_insert['fsm_cv_conformacion_exp'] = $this->input->post('cv_conformacion_exp');
				
				$data_insert['fsm_arcos_mov'] = $this->input->post('arcos_mov');
				$data_insert['fsm_arcos_mov_exp'] = $this->input->post('arcos_mov_exp');
			

						$data_insert['fsm_mmarcha'] = $this->input->post('mmarcha');
						$data_insert['fsm_mmarcha_exp'] = $this->input->post('mmarcha_exp');
						$data_insert['fsm_puntos_dolorosos'] = $this->input->post('puntos_dolorosos');
						$data_insert['fsm_puntos_dolorosos_exp'] = $this->input->post('puntos_dolorosos_exp');
				
				//miembros toraxixos
				$data_insert['fsm_mt_integridad_der'] = $this->input->post('mt_integridad_der');
				$data_insert['fsm_mt_integridad_izq'] = $this->input->post('mt_integridad_izq');
				$data_insert['fsm_mt_integridad_exp'] = $this->input->post('mt_integridad_exp');
				$data_insert['fsm_mp_integridad_der'] = $this->input->post('mp_integridad_der');
				$data_insert['fsm_mp_integridad_izq'] = $this->input->post('mp_integridad_izq');
				$data_insert['fsm_mp_integridad_exp'] = $this->input->post('mp_integridad_exp');
				$data_insert['fsm_mt_mobilidad_der'] = $this->input->post('mt_mobilidad_der');
				$data_insert['fsm_mt_mobilidad_izq'] = $this->input->post('mt_mobilidad_izq');
				$data_insert['fsm_mt_mobilidad_exp'] = $this->input->post('mt_mobilidad_exp');
				$data_insert['fsm_mp_mobilidad_der'] = $this->input->post('mp_mobilidad_der');
				$data_insert['fsm_mp_mobilidad_izq'] = $this->input->post('mp_mobilidad_izq');
				$data_insert['fsm_mp_mobilidad_exp'] = $this->input->post('mp_mobilidad_exp');
				$data_insert['fsm_mt_rot_der'] = $this->input->post('mt_rot_der');
				$data_insert['fsm_mt_rot_izq'] = $this->input->post('mt_rot_izq');
				$data_insert['fsm_mt_rot_exp'] = $this->input->post('mt_rot_exp');
				$data_insert['fsm_mp_rot_der'] = $this->input->post('mp_rot_der');
				$data_insert['fsm_mp_rot_izq'] = $this->input->post('mp_rot_izq');
				$data_insert['fsm_mp_rot_exp'] = $this->input->post('mp_rot_exp');
				$data_insert['fsm_mt_sensibilidad_der'] = $this->input->post('mt_sensibilidad_der');
				$data_insert['fsm_mt_sensibilidad_izq'] = $this->input->post('mt_sensibilidad_izq');
				$data_insert['fsm_mt_sensibilidad_exp'] = $this->input->post('mt_sensibilidad_exp');
				$data_insert['fsm_mp_sensibilidad_der'] = $this->input->post('mp_sensibilidad_der');
				$data_insert['fsm_mp_sensibilidad_izq'] = $this->input->post('mp_sensibilidad_izq');
				$data_insert['fsm_mp_sensibilidad_exp'] = $this->input->post('mp_sensibilidad_exp');
				$data_insert['fsm_mt_fuerza_der'] = $this->input->post('mt_fuerza_der');
				$data_insert['fsm_mt_fuerza_izq'] = $this->input->post('mt_fuerza_izq');
				$data_insert['fsm_mt_fuerza_exp'] = $this->input->post('mt_fuerza_exp');
				$data_insert['fsm_mp_fuerza_der'] = $this->input->post('mp_fuerza_der');
				$data_insert['fsm_mp_fuerza_izq'] = $this->input->post('mp_fuerza_izq');
				$data_insert['fsm_mp_fuerza_exp'] = $this->input->post('mp_fuerza_exp');
				$data_insert['fsm_mt_pulsos_der'] = $this->input->post('mt_pulsos_der');
				$data_insert['fsm_mt_pulsos_izq'] = $this->input->post('mt_pulsos_izq');
				$data_insert['fsm_mt_pulsos_exp'] = $this->input->post('mt_pulsos_exp');
				$data_insert['fsm_mp_pulsos_der'] = $this->input->post('mp_pulsos_der');
				$data_insert['fsm_mp_pulsos_izq'] = $this->input->post('mp_pulsos_izq');
				$data_insert['fsm_mp_pulsos_exp'] = $this->input->post('mp_pulsos_exp');
				
				//piel y anexos
				
				
				$data_insert['fsm_dermis'] = $this->input->post('dermis');
				$data_insert['fsm_dermis_exp'] = $this->input->post('dermis_exp');
				
				$data_insert['fsm_cabello'] = $this->input->post('cabello');
				$data_insert['fsm_cabello_exp'] = $this->input->post('cabello_exp');
				
				$data_insert['fsm_unias'] = $this->input->post('unias');
				$data_insert['fsm_unias_exp'] = $this->input->post('unias_exp');
				
				$data_insert['fsm_dermatosis'] = $this->input->post('dermatosis');
				$data_insert['fsm_dermatitis'] = $this->input->post('dermatitis');
				$data_insert['fsm_tatuajes'] = $this->input->post('tatuajes');
				$data_insert['fsm_cicatrices'] = $this->input->post('cicatrices');
						
				

				
				$data_insert['fsm_coordinacion'] = $this->input->post('coordinacion');
				$data_insert['fsm_coordinacion_exp'] = $this->input->post('coordinacion_exp');
				$data_insert['fsm_sensibilidad'] = $this->input->post('sensibilidad');
				$data_insert['fsm_sensibilidad_exp'] = $this->input->post('sensibilidad_exp');
				$data_insert['fsm_cv_conformacion'] = $this->input->post('cv_conformacion');
				$data_insert['fsm_cv_conformacion_exp'] = $this->input->post('cv_conformacion_exp');
				$data_insert['fsm_equilibrio'] = $this->input->post('equilibrio');
				$data_insert['fsm_equilibrio_exp'] = $this->input->post('equilibrio_exp');
				
				
				$data_insert['fsm_escoliosis'] = $this->input->post('escoliosis');
				$data_insert['fsm_escoliosis_exp'] = $this->input->post('escoliosis_exp');
				$data_insert['fsm_lordosis'] = $this->input->post('lordosis');
				$data_insert['fsm_lordosis_exp'] = $this->input->post('lordosis_exp');
				$data_insert['fsm_xifosis'] = $this->input->post('xifosis');
				$data_insert['fsm_xifosis_exp'] = $this->input->post('xifosis_exp');
				
				$data_insert['fsm_gineco1'] = $this->input->post('gineco1');
				$data_insert['fsm_gineco1_res'] = $this->input->post('gineco1_res');
				$data_insert['fsm_gineco1_exp'] = $this->input->post('gineco1_exp');
				$data_insert['fsm_gineco2'] = $this->input->post('gineco2');
				$data_insert['fsm_gineco2_res'] = $this->input->post('gineco2_res');
				$data_insert['fsm_gineco2_exp'] = $this->input->post('gineco2_exp');
				$data_insert['fsm_sangre'] = $this->input->post('sangre');
				$data_insert['fsm_fac_a_1'] = $this->input->post('fac_a_1');
				$data_insert['fsm_fac_a_2'] = $this->input->post('fac_a_2');
				$data_insert['fsm_fac_a_3'] = $this->input->post('fac_a_3');
				$data_insert['fsm_fac_a_4'] = $this->input->post('fac_a_4');
				$data_insert['fsm_fac_b_1'] = $this->input->post('fac_b_1');
				$data_insert['fsm_fac_b_2'] = $this->input->post('fac_b_2');
				$data_insert['fsm_fac_b_3'] = $this->input->post('fac_b_3');
				$data_insert['fsm_fac_b_4'] = $this->input->post('fac_b_4');
				$data_insert['fsm_fac_b_5'] = $this->input->post('fac_b_5');
				$data_insert['fsm_fac_b_6'] = $this->input->post('fac_b_6');
				$data_insert['fsm_fac_b_7'] = $this->input->post('fac_b_7');
				$data_insert['fsm_fac_b_8'] = $this->input->post('fac_b_8');
				$data_insert['fsm_fac_total_a'] = $this->input->post('fac_total_a');
				$data_insert['fsm_fac_total_b'] = $this->input->post('fac_total_b');
				
				$data_insert['fsm_diag_imc'] = $this->input->post('diag_imc');
				$data_insert['fsm_diag_antidoping'] = $this->input->post('diag_antidoping');
				$data_insert['fsm_diag_agudesa_visual'] = $this->input->post('diag_agudesa_visual');
				$data_insert['fsm_diag_audiometria'] = $this->input->post('diag_audiometria');
				$data_insert['fsm_diag_odontologico'] = $this->input->post('diag_odontologico');
				$data_insert['fsm_diag_espirometria'] = $this->input->post('diag_espirometria');
				
				$data_insert['fsm_diag_aptitud'] = $this->input->post('diag_aptitud');
				
				$data_insert['fsm_observaciones'] = $this->input->post('observaciones');


				/*
				    $data_clte['clte_path_foto'] = $cliente ['clte_path_foto'];
                    
					if(!empty($_FILES['foto']['name']))
                    {
                        $this->load->library('upload');
                        $filename = md5(time());
                        $config = array(
                                'upload_path'   => './../../files/em/',
                                'overwrite'     => TRUE,
                                'file_name'     => $filename,
                                'allowed_types' => 'png|jpg|jpeg',
                                'max_size'      => '25000'
                        );

                        $this->upload->initialize($config);
                        if ( ! $this->upload->do_upload('foto'))
                        {
                            send_json_error($this->upload->display_errors());
                        }
                        else 
                        {
                            $data = $this->upload->data();
                            $data_clte['clte_path_foto'] = $data['file_name'];
                        }
                    }

					if(!empty($_FILES['foto']['name']))
                    {
                        $this->load->library('upload');
                        $filename = md5(time());
                        $config = array(
                                'upload_path'   => './../../files/em/',
                                'overwrite'     => TRUE,
                                'file_name'     => $filename,
                                'allowed_types' => 'png|jpg|jpeg',
                                'max_size'      => '25000'
                        );

                        $this->upload->initialize($config);
                      if ( ! $this->upload->do_upload('foto'))
                        {
                            send_json_error($this->upload->display_errors());
                        }
                        else 
                        {
                            $data = $this->upload->data();
                            $data_insert['fsm_path_cuerpo'] = $data['file_name'];
                        }
                    } 
	*/				
		//$data_insert['fsm_path_cuerpo'] ='PREVIO';			
	if(!empty($_FILES['foto']['name']))
	{
		$data_insert['fsm_path_cuerpo'] ='DENTRO';
		$errors= array();
		$file_name = $_FILES['foto']['name'];
		$file_size = $_FILES['foto']['size'];
		$file_tmp = $_FILES['foto']['tmp_name'];
		$file_type = $_FILES['foto']['type'];
		$file_exts=strtolower((explode('.',$_FILES['image']['name'])));

		//if (strstr(strtolower($_FILES['image']['name']),'jpg'))
		{$file_ext='jpg';}

		$expensions= array("jpeg","jpg","png");

		if(in_array($file_ext,$expensions)=== false)
		{
			$errors[]="extension not allowed, please choose a JPEG or PNG file.";
			$data_insert['fsm_path_cuerpo'] ='extension not allowed, please choose a JPEG or PNG file.';
			$errors= array();
		}

		if($file_size > 2097152) 
		{
			$errors[]='File size must be excately 2 MB';
			$data_insert['fsm_path_cuerpo'] ='File size must be excately 2 MB';
		}

		if(empty($errors)==true) 
		{
			$file_name=strtolower(md5(time())).'.'.$file_ext;
			move_uploaded_file($file_tmp,"./../../files/em/".$file_name);
			echo "Success";
			$data_insert['fsm_path_cuerpo'] = "Success";
		}
		else
		{
			print_r($errors);
		}
	}

	$data_insert['fsm_path_cuerpo'] = $file_name;

	
				if ($medico['usr_genero_cve'] == 'H') {$gen= 'Dr. ';} else {$gen= 'Dra. ';}
				$data_insert['fsm_med_nombre'] = $gen.$medico['usr_nombre'].' '.$medico['usr_paterno'].' '.$medico['usr_materno'];
				$data_insert['fsm_med_cedula'] =$medico['usr_cedula'];
				$data_insert['fsm_med_carrera'] =$medico['usr_carrera'];
				$data_insert['fsm_med_escuela'] =$medico['usr_institucion'];

				$data_insert['log_updt_f']   =  date("Y-m-d H:i:s");
				$data_insert['log_updt_usr_cve']  = $user['usr_id']; 

				$data_insert=array_to_upper($data_insert);
				$pass=$this->salud_ocupacional->update_ISOEXMEDINEX($fsm_id,$data_insert);
				if ($pass)
                {					
                  //send_json_ok('Se actualizo el registro en forma correcta.');
				  header('Location:'.base_url('persona/id').'/'.$cliente_id); 
				  exit;
				}
                else
                {
                    send_json_error('Ocurrió un error al actualizar el registro.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
            $this->load->helper('template');
            $params_view = array(
                'title' => '',
                'view' => 'examen/salud_ocupacional/edit_ISOEXMEDINEX',
                'view_data' => $data 
               );
            render_template($params_view);
        }
    }
/*************************************************************************************/
    public function nuevo_ISOEXMEDINEX($cliente_id)
    {    
		$user = $this->session->user;
		$cliente = $this->cliente->get($cliente_id);
		$empresa=$cliente['emp_id'];	
		$persona = $this->cliente->get($cliente_id);
//echo 'A';
        if($cliente)
        {

            if(isset($_POST) && count($_POST) > 0)     
            {
                $this->load->library('form_validation');
               /* $this->form_validation->set_rules('nombre','Nombre','required');
                $this->form_validation->set_rules('paterno','Apellido Paterno','required');
                $this->form_validation->set_rules('materno','Apellido Materno','required');
                $this->form_validation->set_rules('fnac','Fecha de nacimiento','required');*/
                $this->form_validation->set_rules('religion','Religión','required');
              /*  $this->form_validation->set_rules('civil','Estado civil','required');
                $this->form_validation->set_rules('rfc','RFC','required');
                $this->form_validation->set_rules('curp','CURP','required');*/

                if($this->form_validation->run())
                {

/*********************************************************************/

				$data_insert['clte_id'] = $persona['clte_id'];
				$data_insert['fsm_edad']=intval(trim(str_replace("años", "",get_edad($persona['clte_f_nac']))));
				
				$data_insert['fsm_f_nac']=$persona['clte_f_nac'];
				$data_insert['fsm_genero']=$persona['clte_genero_cve'];
				$data_insert['emp_id'] = $persona['emp_id'];
				$data_insert['suc_id'] = $persona['suc_id'];               
                $data_insert['serv_id']  = '';
                $data_insert['usr_id']  = $user['usr_id'];
                $data_insert['fsm_f']   =  date("Y-m-d H:i:s");
				
				$data_insert['fsm_f_y']   =  date("Y");
				$data_insert['fsm_f_m']   =  date("m");
				$data_insert['fsm_f_d']   =  date("d");
				$data_insert['fsm_f_h']   =  date("H");
				$data_insert['fsm_f_i']   =  date("i");
								
				$data_insert['med_id'] = $this->input->post('medico');				
				$medico = $this->medico->get($data_insert['med_id']);

/*				
				$data_insert['fsm_area'] = $this->input->post('area');
				$data_insert['fsm_turno'] = $this->input->post('turno');
				$data_insert['fsm_antiguedad'] = $this->input->post('antiguedad'); 
				$data_insert['fsm_accidente_av'] = $this->input->post('accidente_av');
				$data_insert['fsm_parentesco_av'] = $this->input->post('parentesco_av');
				$data_insert['fsm_telefono_av'] = $this->input->post('telefono_av');
				$data_insert['fsm_clinica_imss'] = $this->input->post('clinica_imss');
				$data_insert['fsm_no_consultorio'] = $this->input->post('no_consultorio');
*/
				$data_insert['fsm_religion'] = $this->input->post('religion');
				$data_insert['fsm_profesion'] = $this->input->post('profesion');
				$data_insert['fsm_padre_vive']= $this->input->post('padre_vive');
				$data_insert['fsm_padre_diabetes']= $this->input->post('padre_diabetes');
				$data_insert['fsm_padre_hipertesion']= $this->input->post('padre_hipertesion');
				$data_insert['fsm_padre_corazon']= $this->input->post('padre_corazon');
				$data_insert['fsm_padre_pulmones']= $this->input->post('padre_pulmones');
				$data_insert['fsm_padre_cancer']= $this->input->post('padre_cancer');
				$data_insert['fsm_padre_otros']= $this->input->post('padre_otros');
				$data_insert['fsm_padre_mentales']= $this->input->post('padre_mentales');
				$data_insert['fsm_madre_vive']= $this->input->post('madre_vive');
				$data_insert['fsm_madre_diabetes']= $this->input->post('madre_diabetes');
				$data_insert['fsm_madre_hipertesion']= $this->input->post('madre_hipertesion');
				$data_insert['fsm_madre_corazon']= $this->input->post('madre_corazon');
				$data_insert['fsm_madre_pulmones']= $this->input->post('madre_pulmones');
				$data_insert['fsm_madre_cancer']= $this->input->post('madre_cancer');
				$data_insert['fsm_madre_otros']= $this->input->post('madre_otros');
				$data_insert['fsm_madre_mentales']= $this->input->post('madre_mentales');
				$data_insert['fsm_hermanos_vive']= $this->input->post('hermanos_vive');
				$data_insert['fsm_hermanos_diabetes']= $this->input->post('hermanos_diabetes');
				$data_insert['fsm_hermanos_hipertesion']= $this->input->post('hermanos_hipertesion');
				$data_insert['fsm_hermanos_corazon']= $this->input->post('hermanos_corazon');
				$data_insert['fsm_hermanos_pulmones']= $this->input->post('hermanos_pulmones');
				$data_insert['fsm_hermanos_cancer']= $this->input->post('hermanos_cancer');
				$data_insert['fsm_hermanos_otros']= $this->input->post('hermanos_otros');
				$data_insert['fsm_hermanos_mentales']= $this->input->post('hermanos_mentales');
				$data_insert['fsm_abuelo_paternos_vive']= $this->input->post('abuelo_paternos_vive');
				$data_insert['fsm_abuelo_paternos_diabetes']= $this->input->post('abuelo_paternos_diabetes');
				$data_insert['fsm_abuelo_paternos_hipertesion']= $this->input->post('abuelo_paternos_hipertesion');
				$data_insert['fsm_abuelo_paternos_corazon']= $this->input->post('abuelo_paternos_corazon');
				$data_insert['fsm_abuelo_paternos_pulmones']= $this->input->post('abuelo_paternos_pulmones');
				$data_insert['fsm_abuelo_paternos_cancer']= $this->input->post('abuelo_paternos_cancer');
				$data_insert['fsm_abuelo_paternos_otros']= $this->input->post('abuelo_paternos_otros');
				$data_insert['fsm_abuelo_paternos_mentales']= $this->input->post('abuelo_paternos_mentales');
				$data_insert['fsm_abuela_paternos_vive']= $this->input->post('abuela_paternos_vive');
				$data_insert['fsm_abuela_paternos_diabetes']= $this->input->post('abuela_paternos_diabetes');
				$data_insert['fsm_abuela_paternos_hipertesion']= $this->input->post('abuela_paternos_hipertesion');
				$data_insert['fsm_abuela_paternos_corazon']= $this->input->post('abuela_paternos_corazon');
				$data_insert['fsm_abuela_paternos_pulmones']= $this->input->post('abuela_paternos_pulmones');
				$data_insert['fsm_abuela_paternos_cancer']= $this->input->post('abuela_paternos_cancer');
				$data_insert['fsm_abuela_paternos_otros']= $this->input->post('abuela_paternos_otros');
				$data_insert['fsm_abuela_paternos_mentales']= $this->input->post('abuela_paternos_mentales');
				$data_insert['fsm_abuelo_maternos_vive']= $this->input->post('abuelo_maternos_vive');
				$data_insert['fsm_abuelo_maternos_diabetes']= $this->input->post('abuelo_maternos_diabetes');
				$data_insert['fsm_abuelo_maternos_hipertesion']= $this->input->post('abuelo_maternos_hipertesion');
				$data_insert['fsm_abuelo_maternos_corazon']= $this->input->post('abuelo_maternos_corazon');
				$data_insert['fsm_abuelo_maternos_pulmones']= $this->input->post('abuelo_maternos_pulmones');
				$data_insert['fsm_abuelo_maternos_cancer']= $this->input->post('abuelo_maternos_cancer');
				$data_insert['fsm_abuelo_maternos_otros']= $this->input->post('abuelo_maternos_otros');
				$data_insert['fsm_abuelo_maternos_mentales']= $this->input->post('abuelo_maternos_mentales');
				$data_insert['fsm_abuela_maternos_vive']= $this->input->post('abuela_maternos_vive');
				$data_insert['fsm_abuela_maternos_diabetes']= $this->input->post('abuela_maternos_diabetes');
				$data_insert['fsm_abuela_maternos_hipertesion']= $this->input->post('abuela_maternos_hipertesion');
				$data_insert['fsm_abuela_maternos_corazon']= $this->input->post('abuela_maternos_corazon');
				$data_insert['fsm_abuela_maternos_pulmones']= $this->input->post('abuela_maternos_pulmones');
				$data_insert['fsm_abuela_maternos_cancer']= $this->input->post('abuela_maternos_cancer');
				$data_insert['fsm_abuela_maternos_otros']= $this->input->post('abuela_maternos_otros');
				$data_insert['fsm_abuela_maternos_mentales']= $this->input->post('abuela_maternos_mentales');
				$data_insert['fsm_hijos_vive']= $this->input->post('hijos_vive');
				$data_insert['fsm_hijos_diabetes']= $this->input->post('hijos_diabetes');
				$data_insert['fsm_hijos_hipertesion']= $this->input->post('hijos_hipertesion');
				$data_insert['fsm_hijos_corazon']= $this->input->post('hijos_corazon');
				$data_insert['fsm_hijos_pulmones']= $this->input->post('hijos_pulmones');
				$data_insert['fsm_hijos_cancer']= $this->input->post('hijos_cancer');
				$data_insert['fsm_hijos_otros']= $this->input->post('hijos_otros');
				$data_insert['fsm_hijos_mentales']= $this->input->post('hijos_mentales');
				$data_insert['fsm_alcohol']= $this->input->post('alcohol');
				$data_insert['fsm_inicio_alcohol']= $this->input->post('inicio_alcohol');
				$data_insert['fsm_fin_alcohol']= $this->input->post('fin_alcohol');
				$data_insert['fsm_cantidad_alcohol']= $this->input->post('cantidad_alcohol');
				$data_insert['fsm_tabaco']= $this->input->post('tabaco');
				$data_insert['fsm_inicio_tabaco']= $this->input->post('inicio_tabaco');
				$data_insert['fsm_fin_tabaco']= $this->input->post('fin_tabaco');
				$data_insert['fsm_cantidad_tabaco']= $this->input->post('cantidad_tabaco');
				$data_insert['fsm_drogas']= $this->input->post('drogas');
				$data_insert['fsm_inicio_drogas']= $this->input->post('inicio_drogas');
				$data_insert['fsm_fin_drogas']= $this->input->post('fin_drogas');
				$data_insert['fsm_cantidad_drogas']= $this->input->post('cantidad_drogas');
				$data_insert['fsm_deportes']= $this->input->post('deportes');
				$data_insert['fsm_cual_deportes']= $this->input->post('cual_deportes');
				$data_insert['fsm_frutas']= $this->input->post('frutas');
				$data_insert['fsm_pan']= $this->input->post('pan');
				$data_insert['fsm_pollo']= $this->input->post('pollo');
				$data_insert['fsm_carne']= $this->input->post('carne');
				$data_insert['fsm_refrescos']= $this->input->post('refrescos');
				$data_insert['fsm_tortillas']= $this->input->post('tortillas');
				$data_insert['fsm_frituras']= $this->input->post('frituras');
				$data_insert['fsm_habitaciones']= $this->input->post('habitaciones');
				$data_insert['fsm_material']= $this->input->post('material');
				$data_insert['fsm_luz']= $this->input->post('luz');
				$data_insert['fsm_agua']= $this->input->post('agua');
				$data_insert['fsm_drenaje']= $this->input->post('drenaje');
				$data_insert['fsm_paredes']= $this->input->post('paredes');
				$data_insert['fsm_cirugias']= $this->input->post('cirugias');
				$data_insert['fsm_cuando_cirugias']= $this->input->post('cuando_cirugias');
				$data_insert['fsm_motivo_cirugias']= $this->input->post('motivo_cirugias');
				$data_insert['fsm_transfusiones']= $this->input->post('transfusiones');
				$data_insert['fsm_cuando_transfusiones']= $this->input->post('cuando_transfusiones');
				$data_insert['fsm_motivo_transfusiones']= $this->input->post('motivo_transfusiones');
				$data_insert['fsm_hospitalizaciones']= $this->input->post('hospitalizaciones');
				$data_insert['fsm_cuando_hospitalizaciones']= $this->input->post('cuando_hospitalizaciones');
				$data_insert['fsm_motivo_hospitalizaciones']= $this->input->post('motivo_hospitalizaciones');
				
				$data_insert['fsm_usa_lentes']= $this->input->post('usa_lentes');
				$data_insert['fsm_cuando_usa_lentes']= $this->input->post('cuando_usa_lentes');
				$data_insert['fsm_motivo_usa_lentes']= $this->input->post('motivo_usa_lentes');
				
				
				$data_insert['fsm_alergias']= $this->input->post('alergias');
				$data_insert['fsm_cuando_alergias']= $this->input->post('cuando_alergias');
				$data_insert['fsm_motivo_alergias']= $this->input->post('motivo_alergias');
				$data_insert['fsm_vacunacion']= $this->input->post('vacunacion');
				$data_insert['fsm_ultima_vacuna']= $this->input->post('ultima_vacuna');
				$data_insert['fsm_cronica1']= $this->input->post('cronica1');
				$data_insert['fsm_infecciosas1']= $this->input->post('infecciosas1');
				$data_insert['fsm_neurologicas1']= $this->input->post('neurologicas1');
				$data_insert['fsm_cronica2']= $this->input->post('cronica2');
				$data_insert['fsm_infecciosas2']= $this->input->post('infecciosas2');
				$data_insert['fsm_neurologicas2']= $this->input->post('neurologicas2');
				$data_insert['fsm_cronica3']= $this->input->post('cronica3');
				$data_insert['fsm_infecciosas3']= $this->input->post('infecciosas3');
				$data_insert['fsm_neurologicas3']= $this->input->post('neurologicas3');
				$data_insert['fsm_cronica4']= $this->input->post('cronica4');
				$data_insert['fsm_infecciosas4']= $this->input->post('infecciosas4');
				$data_insert['fsm_neurologicas4']= $this->input->post('neurologicas4');
				$data_insert['fsm_cronica5']= $this->input->post('cronica5');
				$data_insert['fsm_infecciosas5']= $this->input->post('infecciosas5');
				$data_insert['fsm_neurologicas5']= $this->input->post('neurologicas5');
				$data_insert['fsm_trabajo1']= $this->input->post('trabajo1');
				$data_insert['fsm_otras_enf1']= $this->input->post('otras_enf1');
				$data_insert['fsm_smujeres1']= $this->input->post('smujeres1');
				$data_insert['fsm_trabajo2']= $this->input->post('trabajo2');
				$data_insert['fsm_otras_enf2']= $this->input->post('otras_enf2');
				$data_insert['fsm_smujeres2']= $this->input->post('smujeres2');
				$data_insert['fsm_trabajo3']= $this->input->post('trabajo3');
				$data_insert['fsm_otras_enf3']= $this->input->post('otras_enf3');
				$data_insert['fsm_smujeres3']= $this->input->post('smujeres3');
				$data_insert['fsm_trabajo4']= $this->input->post('trabajo4');
				$data_insert['fsm_otras_enf4']= $this->input->post('otras_enf4');
				$data_insert['fsm_smujeres4']= $this->input->post('smujeres4');
				$data_insert['fsm_otras_enf5']= $this->input->post('otras_enf5');
				$data_insert['fsm_otras_enf6']= $this->input->post('otras_enf6');
				$data_insert['fsm_accidentes']= $this->input->post('accidentes');
				$data_insert['fsm_cuales_accidentes']= $this->input->post('cuales_accidentes');
				$data_insert['fsm_cuando_accidente']= $this->input->post('cuando_accidente');
				$data_insert['fsm_sequelas_accidentes']= $this->input->post('sequelas_accidentes');
				$data_insert['fsm_ipp_accidentes']= $this->input->post('ipp_accidentes');
				$data_insert['fsm_enfermedades_trabajo']= $this->input->post('enfermedades_trabajo');
				$data_insert['fsm_cuales_enfermedades_trabajo']= $this->input->post('cuales_enfermedades_trabajo');
				$data_insert['fsm_cuando_enfermedades_trabajo']= $this->input->post('cuando_enfermedades_trabajo');
				$data_insert['fsm_sequelas_enfermedades_trabajo']= $this->input->post('sequelas_enfermedades_trabajo');
				$data_insert['fsm_ipp_enfermedades_trabajo']= $this->input->post('ipp_enfermedades_trabajo');
				$data_insert['fsm_acc_viales']= $this->input->post('acc_viales');
				$data_insert['fsm_cuales_acc_viales']= $this->input->post('cuales_acc_viales');
				$data_insert['fsm_cuando_acc_viales']= $this->input->post('cuando_acc_viales');
				$data_insert['fsm_sequelas_acc_viales']= $this->input->post('sequelas_acc_viales');
				$data_insert['fsm_ipp_acc_viales']= $this->input->post('ipp_acc_viales');
				$data_insert['fsm_puesto_ante1']= $this->input->post('puesto_ante1');
				$data_insert['fsm_puesto_ante_anios1']= $this->input->post('puesto_ante_anios1');
				$data_insert['fsm_puesto_ante_exp1']= $this->input->post('puesto_ante_exp1');
				$data_insert['fsm_puesto_ante2']= $this->input->post('puesto_ante2');
				$data_insert['fsm_puesto_ante_anios2']= $this->input->post('puesto_ante_anios2');
				$data_insert['fsm_puesto_ante_exp2']= $this->input->post('puesto_ante_exp2');
				$data_insert['fsm_puesto_ante3']= $this->input->post('puesto_ante3');
				$data_insert['fsm_puesto_ante_anios3']= $this->input->post('puesto_ante_anios3');
				$data_insert['fsm_puesto_ante_exp3']= $this->input->post('puesto_ante_exp3');
				$data_insert['fsm_puesto_ante4']= $this->input->post('puesto_ante4');
				$data_insert['fsm_puesto_ante_anios4']= $this->input->post('puesto_ante_anios4');
				$data_insert['fsm_puesto_ante_exp4']= $this->input->post('puesto_ante_exp4');
				$data_insert['fsm_puesto_ante5']= $this->input->post('puesto_ante5');
				$data_insert['fsm_puesto_ante_anios5']= $this->input->post('puesto_ante_anios5');
				$data_insert['fsm_puesto_ante_exp5']= $this->input->post('puesto_ante_exp5');
				$data_insert['fsm_puesto_ante6']= $this->input->post('puesto_ante6');
				$data_insert['fsm_puesto_ante_anios6']= $this->input->post('puesto_ante_anios6');
				$data_insert['fsm_puesto_ante_exp6']= $this->input->post('puesto_ante_exp6');
				$data_insert['fsm_puesto_ante7']= $this->input->post('puesto_ante7');
				$data_insert['fsm_puesto_ante_anios7']= $this->input->post('puesto_ante_anios7');
				$data_insert['fsm_puesto_ante_exp7']= $this->input->post('puesto_ante_exp7');
				$data_insert['fsm_puesto_ante8']= $this->input->post('puesto_ante8');
				$data_insert['fsm_puesto_ante_anios8']= $this->input->post('puesto_ante_anios8');
				$data_insert['fsm_puesto_ante_exp8']= $this->input->post('puesto_ante_exp8');
				
				//Examen Médico de IPAS
				//SIGNOS VITALES
				$data_insert['fsm_ta1'] = $this->input->post('ta1');
				$data_insert['fsm_ta2'] = $this->input->post('ta2');
				$data_insert['fsm_sato2'] = $this->input->post('sato2');
				$data_insert['fsm_fc'] = $this->input->post('fc');
				$data_insert['fsm_fr'] = $this->input->post('fr');
				$data_insert['fsm_temp'] = $this->input->post('temp');
				$data_insert['fsm_estatura'] = $this->input->post('estatura');
				$data_insert['fsm_peso'] = $this->input->post('peso');
				$data_insert['fsm_imc'] = $this->input->post('imc');

				$data_insert['fsm_organo_sentidos']= $this->input->post('organo_sentidos');
				$data_insert['fsm_respiratorio']= $this->input->post('respiratorio');
				$data_insert['fsm_cardiovascular']= $this->input->post('cardiovascular');
				$data_insert['fsm_digestivo']= $this->input->post('digestivo');
				$data_insert['fsm_genitourinario']= $this->input->post('genitourinario');
				$data_insert['fsm_musculoesquelético']= $this->input->post('musculoesquelético');
				$data_insert['fsm_menarca']= $this->input->post('menarca');
				$data_insert['fsm_ritmog']= $this->input->post('ritmog');
				$data_insert['fsm_ividasex']= $this->input->post('ividasex');
				$data_insert['fsm_num_parejas']= $this->input->post('num_parejas');
				$data_insert['fsm_umenstraucion']= $this->input->post('umenstraucion');
				$data_insert['fsm_papanicolao']= $this->input->post('papanicolao');
				$data_insert['fsm_exmama']= $this->input->post('exmama');
				$data_insert['fsm_comentariosg']= $this->input->post('comentariosg');
				$data_insert['fsm_gestas']= $this->input->post('gestas');
				$data_insert['fsm_partos']= $this->input->post('partos');
				$data_insert['fsm_cesareas']= $this->input->post('cesareas');
				$data_insert['fsm_abortos']= $this->input->post('abortos');
				$data_insert['fsm_mpf']= $this->input->post('mpf');
				$data_insert['fsm_trauma1']= $this->input->post('trauma1');
				$data_insert['fsm_trauma2']= $this->input->post('trauma2');
				$data_insert['fsm_trauma3']= $this->input->post('trauma3');
				$data_insert['fsm_trauma4']= $this->input->post('trauma4');

				//$data_insert['fsm_ante_no_pato'] = $this->input->post('ante_no_pato');
				//$data_insert['fsm_ante_pato'] = $this->input->post('ante_pato');
				//$data_insert['fsm_padec_actual'] = $this->input->post('padec_actual');
				
				//cabeza
				$data_insert['fsm_craneo'] = $this->input->post('craneo');
				$data_insert['fsm_craneo_exp'] = $this->input->post('craneo_exp');
				$data_insert['fsm_cara'] = $this->input->post('cara');
				$data_insert['fsm_cara_exp'] = $this->input->post('cara_exp');

				//cuello
				$data_insert['fsm_cilindro'] = $this->input->post('cilindro');
				$data_insert['fsm_cilindro_exp'] = $this->input->post('cilindro_exp');
				$data_insert['fsm_traquea'] = $this->input->post('traquea');
				$data_insert['fsm_traquea_exp'] = $this->input->post('traquea_exp');
				$data_insert['fsm_movilidad'] = $this->input->post('movilidad');
				$data_insert['fsm_movilidad_exp'] = $this->input->post('movilidad_exp');
				$data_insert['fsm_ganglios'] = $this->input->post('ganglios');
				$data_insert['fsm_ganglios_exp'] = $this->input->post('ganglios_exp');

				//ojos
				$data_insert['fsm_pupila_der'] = $this->input->post('pupila_der');
				$data_insert['fsm_pupila_izq'] = $this->input->post('pupila_izq');
				$data_insert['fsm_pupila_exp'] = $this->input->post('pupila_exp');
				
				$data_insert['fsm_cornea_der'] = $this->input->post('cornea_der');
				$data_insert['fsm_cornea_izq'] = $this->input->post('cornea_izq');
				$data_insert['fsm_cornea_exp'] = $this->input->post('cornea_exp');
				
				$data_insert['fsm_avisualsl_der'] = $this->input->post('avisualsl_der');
				$data_insert['fsm_avisualsl_izq'] = $this->input->post('avisualsl_izq');
				$data_insert['fsm_avisualsl_exp'] = $this->input->post('avisualsl_exp');
				
				$data_insert['fsm_avisualcl_der'] = $this->input->post('avisualcl_der');
				$data_insert['fsm_avisualcl_izq'] = $this->input->post('avisualcl_izq');
				$data_insert['fsm_avisualcl_exp'] = $this->input->post('avisualcl_exp');
				
				$data_insert['fsm_identifica_colores_der'] = $this->input->post('identifica_colores_der');
				$data_insert['fsm_identifica_colores_izq'] = $this->input->post('identifica_colores_izq');
				$data_insert['fsm_identifica_colores_exp'] = $this->input->post('identifica_colores_exp');
				
				$data_insert['fsm_movimiento_ocular_der'] = $this->input->post('movimiento_ocular_der');
				$data_insert['fsm_movimiento_ocular_izq'] = $this->input->post('movimiento_ocular_izq');
				$data_insert['fsm_movimiento_ocular_exp'] = $this->input->post('movimiento_ocular_exp');
				
				

				$data_insert['fsm_reflejos_oculares_der'] = $this->input->post('reflejos_oculares_der');
				$data_insert['fsm_reflejos_oculares_izq'] = $this->input->post('reflejos_oculares_izq');
				$data_insert['fsm_reflejos_oculares_exp'] = $this->input->post('reflejos_oculares_exp');
				
				
				
				$data_insert['fsm_ptregion_der'] = $this->input->post('ptregion_der');
				$data_insert['fsm_ptregion_izq'] = $this->input->post('ptregion_izq');
				$data_insert['fsm_ptregion_exp'] = $this->input->post('ptregion_exp');
				$data_insert['fsm_ojo_otros_exp'] = $this->input->post('ojo_otros_exp');
				
				//nariz
						$data_insert['fsm_mucosa'] = $this->input->post('mucosa');
						$data_insert['fsm_mucosa_exp'] = $this->input->post('mucosa_exp');
						$data_insert['fsm_cornetes'] = $this->input->post('cornetes');
						$data_insert['fsm_cornetes_exp'] = $this->input->post('cornetes_exp');
						$data_insert['fsm_polipos'] = $this->input->post('polipos');
						$data_insert['fsm_polipos_exp'] = $this->input->post('polipos_exp');
						$data_insert['fsm_septum'] = $this->input->post('septum');
						$data_insert['fsm_septum_exp'] = $this->input->post('septum_exp');

				//oidos
				$data_insert['fsm_membrana_timpano_der'] = $this->input->post('membrana_timpano_der');
				$data_insert['fsm_membrana_timpano_izq'] = $this->input->post('membrana_timpano_izq');
				$data_insert['fsm_membrana_timpano_exp'] = $this->input->post('membrana_timpano_exp');
				
				$data_insert['fsm_conducto_der'] = $this->input->post('conducto_der');
				$data_insert['fsm_conducto_izq'] = $this->input->post('conducto_izq');
				$data_insert['fsm_conducto_exp'] = $this->input->post('conducto_exp');
				
				
				
				$data_insert['fsm_pabellon_der'] = $this->input->post('pabellon_der');
				$data_insert['fsm_pabellon_izq'] = $this->input->post('pabellon_izq');
				$data_insert['fsm_pabellon_exp'] = $this->input->post('pabellon_exp');
				
				//cavida bucal
				$data_insert['fsm_encias'] = $this->input->post('encias');
				$data_insert['fsm_encias_exp'] = $this->input->post('encias_exp');
				$data_insert['fsm_mucosa_bucal'] = $this->input->post('mucosa_bucal');
				$data_insert['fsm_mucosa_bucal_exp'] = $this->input->post('mucosa_bucal_exp');
				$data_insert['fsm_paladar'] = $this->input->post('paladar');
				$data_insert['fsm_paladar_exp'] = $this->input->post('paladar_exp');
				$data_insert['fsm_lengua'] = $this->input->post('lengua');
				$data_insert['fsm_lengua_exp'] = $this->input->post('lengua_exp');
				$data_insert['fsm_amigdalas'] = $this->input->post('amigdalas');
				$data_insert['fsm_amigdalas_exp'] = $this->input->post('amigdalas_exp');
				$data_insert['fsm_dentadura'] = $this->input->post('dentadura');
				$data_insert['fsm_dentadura_exp'] = $this->input->post('dentadura_exp');

				
				//torax
				$data_insert['fsm_simetria'] = $this->input->post('simetria');
				$data_insert['fsm_simetria_exp'] = $this->input->post('simetria_exp');
				$data_insert['fsm_amplexion'] = $this->input->post('amplexion');
				$data_insert['fsm_amplexion_exp'] = $this->input->post('amplexion_exp');
				$data_insert['fsm_murmullo'] = $this->input->post('murmullo');
				$data_insert['fsm_murmullo_exp'] = $this->input->post('murmullo_exp');
				$data_insert['fsm_amplexacion'] = $this->input->post('amplexacion');
				$data_insert['fsm_amplexacion_exp'] = $this->input->post('amplexacion_exp');
				$data_insert['fsm_ventilacion'] = $this->input->post('ventilacion');
				$data_insert['fsm_ventilacion_exp'] = $this->input->post('ventilacion_exp');
				
				
				
				
				//area cardiaca
				$data_insert['fsm_ritmo'] = $this->input->post('ritmo');
				$data_insert['fsm_ritmo_exp'] = $this->input->post('ritmo_exp');
				$data_insert['fsm_intensidad'] = $this->input->post('intensidad');
				$data_insert['fsm_intensidad_exp'] = $this->input->post('intensidad_exp');
				$data_insert['fsm_ruidos'] = $this->input->post('ruidos');
				$data_insert['fsm_ruidos_exp'] = $this->input->post('ruidos_exp');
				$data_insert['fsm_soplos'] = $this->input->post('soplos');
				$data_insert['fsm_soplos_exp'] = $this->input->post('soplos_exp');


				//abdomen
				$data_insert['fsm_conformacion'] = $this->input->post('conformacion');
				
				$data_insert['fsm_peritasis'] = $this->input->post('peritasis');
				$data_insert['fsm_peritasis_exp'] = $this->input->post('peritasis_exp');
				
				$data_insert['fsm_visceromegalias'] = $this->input->post('visceromegalias');
				$data_insert['fsm_visceromegalias_exp'] = $this->input->post('visceromegalias_exp');
				
				$data_insert['fsm_hernias'] = $this->input->post('hernias');
				$data_insert['fsm_hernias_exp'] = $this->input->post('hernias_exp');
				$data_insert['fsm_abdomen_otros_exp'] = $this->input->post('abdomen_otros_exp');
				
				

				
				//lubosacra
				$data_insert['fsm_cv_conformacion'] = $this->input->post('cv_conformacion');
				$data_insert['fsm_cv_conformacion_exp'] = $this->input->post('cv_conformacion_exp');
				
				$data_insert['fsm_arcos_mov'] = $this->input->post('arcos_mov');
				$data_insert['fsm_arcos_mov_exp'] = $this->input->post('arcos_mov_exp');
			

						$data_insert['fsm_mmarcha'] = $this->input->post('mmarcha');
						$data_insert['fsm_mmarcha_exp'] = $this->input->post('mmarcha_exp');
						$data_insert['fsm_puntos_dolorosos'] = $this->input->post('puntos_dolorosos');
						$data_insert['fsm_puntos_dolorosos_exp'] = $this->input->post('puntos_dolorosos_exp');
				
				//miembros toraxixos
				$data_insert['fsm_mt_integridad_der'] = $this->input->post('mt_integridad_der');
				$data_insert['fsm_mt_integridad_izq'] = $this->input->post('mt_integridad_izq');
				$data_insert['fsm_mt_integridad_exp'] = $this->input->post('mt_integridad_exp');
				$data_insert['fsm_mp_integridad_der'] = $this->input->post('mp_integridad_der');
				$data_insert['fsm_mp_integridad_izq'] = $this->input->post('mp_integridad_izq');
				$data_insert['fsm_mp_integridad_exp'] = $this->input->post('mp_integridad_exp');
				$data_insert['fsm_mt_mobilidad_der'] = $this->input->post('mt_mobilidad_der');
				$data_insert['fsm_mt_mobilidad_izq'] = $this->input->post('mt_mobilidad_izq');
				$data_insert['fsm_mt_mobilidad_exp'] = $this->input->post('mt_mobilidad_exp');
				$data_insert['fsm_mp_mobilidad_der'] = $this->input->post('mp_mobilidad_der');
				$data_insert['fsm_mp_mobilidad_izq'] = $this->input->post('mp_mobilidad_izq');
				$data_insert['fsm_mp_mobilidad_exp'] = $this->input->post('mp_mobilidad_exp');
				$data_insert['fsm_mt_rot_der'] = $this->input->post('mt_rot_der');
				$data_insert['fsm_mt_rot_izq'] = $this->input->post('mt_rot_izq');
				$data_insert['fsm_mt_rot_exp'] = $this->input->post('mt_rot_exp');
				$data_insert['fsm_mp_rot_der'] = $this->input->post('mp_rot_der');
				$data_insert['fsm_mp_rot_izq'] = $this->input->post('mp_rot_izq');
				$data_insert['fsm_mp_rot_exp'] = $this->input->post('mp_rot_exp');
				$data_insert['fsm_mt_sensibilidad_der'] = $this->input->post('mt_sensibilidad_der');
				$data_insert['fsm_mt_sensibilidad_izq'] = $this->input->post('mt_sensibilidad_izq');
				$data_insert['fsm_mt_sensibilidad_exp'] = $this->input->post('mt_sensibilidad_exp');
				$data_insert['fsm_mp_sensibilidad_der'] = $this->input->post('mp_sensibilidad_der');
				$data_insert['fsm_mp_sensibilidad_izq'] = $this->input->post('mp_sensibilidad_izq');
				$data_insert['fsm_mp_sensibilidad_exp'] = $this->input->post('mp_sensibilidad_exp');
				$data_insert['fsm_mt_fuerza_der'] = $this->input->post('mt_fuerza_der');
				$data_insert['fsm_mt_fuerza_izq'] = $this->input->post('mt_fuerza_izq');
				$data_insert['fsm_mt_fuerza_exp'] = $this->input->post('mt_fuerza_exp');
				$data_insert['fsm_mp_fuerza_der'] = $this->input->post('mp_fuerza_der');
				$data_insert['fsm_mp_fuerza_izq'] = $this->input->post('mp_fuerza_izq');
				$data_insert['fsm_mp_fuerza_exp'] = $this->input->post('mp_fuerza_exp');
				$data_insert['fsm_mt_pulsos_der'] = $this->input->post('mt_pulsos_der');
				$data_insert['fsm_mt_pulsos_izq'] = $this->input->post('mt_pulsos_izq');
				$data_insert['fsm_mt_pulsos_exp'] = $this->input->post('mt_pulsos_exp');
				$data_insert['fsm_mp_pulsos_der'] = $this->input->post('mp_pulsos_der');
				$data_insert['fsm_mp_pulsos_izq'] = $this->input->post('mp_pulsos_izq');
				$data_insert['fsm_mp_pulsos_exp'] = $this->input->post('mp_pulsos_exp');
				
				//piel y anexos
				
				
				$data_insert['fsm_dermis'] = $this->input->post('dermis');
				$data_insert['fsm_dermis_exp'] = $this->input->post('dermis_exp');
				
				$data_insert['fsm_cabello'] = $this->input->post('cabello');
				$data_insert['fsm_cabello_exp'] = $this->input->post('cabello_exp');
				
				$data_insert['fsm_unias'] = $this->input->post('unias');
				$data_insert['fsm_unias_exp'] = $this->input->post('unias_exp');
				
				$data_insert['fsm_dermatosis'] = $this->input->post('dermatosis');
				$data_insert['fsm_dermatitis'] = $this->input->post('dermatitis');
				$data_insert['fsm_tatuajes'] = $this->input->post('tatuajes');
				$data_insert['fsm_cicatrices'] = $this->input->post('cicatrices');
						
				

				
				$data_insert['fsm_coordinacion'] = $this->input->post('coordinacion');
				$data_insert['fsm_coordinacion_exp'] = $this->input->post('coordinacion_exp');
				$data_insert['fsm_sensibilidad'] = $this->input->post('sensibilidad');
				$data_insert['fsm_sensibilidad_exp'] = $this->input->post('sensibilidad_exp');
				$data_insert['fsm_cv_conformacion'] = $this->input->post('cv_conformacion');
				$data_insert['fsm_cv_conformacion_exp'] = $this->input->post('cv_conformacion_exp');
				$data_insert['fsm_equilibrio'] = $this->input->post('equilibrio');
				$data_insert['fsm_equilibrio_exp'] = $this->input->post('equilibrio_exp');
				
				
				$data_insert['fsm_escoliosis'] = $this->input->post('escoliosis');
				$data_insert['fsm_escoliosis_exp'] = $this->input->post('escoliosis_exp');
				$data_insert['fsm_lordosis'] = $this->input->post('lordosis');
				$data_insert['fsm_lordosis_exp'] = $this->input->post('lordosis_exp');
				$data_insert['fsm_xifosis'] = $this->input->post('xifosis');
				$data_insert['fsm_xifosis_exp'] = $this->input->post('xifosis_exp');
				
				$data_insert['fsm_gineco1'] = $this->input->post('gineco1');
				$data_insert['fsm_gineco1_res'] = $this->input->post('gineco1_res');
				$data_insert['fsm_gineco1_exp'] = $this->input->post('gineco1_exp');
				$data_insert['fsm_gineco2'] = $this->input->post('gineco2');
				$data_insert['fsm_gineco2_res'] = $this->input->post('gineco2_res');
				$data_insert['fsm_gineco2_exp'] = $this->input->post('gineco2_exp');
				$data_insert['fsm_sangre'] = $this->input->post('sangre');
				$data_insert['fsm_fac_a_1'] = $this->input->post('fac_a_1');
				$data_insert['fsm_fac_a_2'] = $this->input->post('fac_a_2');
				$data_insert['fsm_fac_a_3'] = $this->input->post('fac_a_3');
				$data_insert['fsm_fac_a_4'] = $this->input->post('fac_a_4');
				$data_insert['fsm_fac_b_1'] = $this->input->post('fac_b_1');
				$data_insert['fsm_fac_b_2'] = $this->input->post('fac_b_2');
				$data_insert['fsm_fac_b_3'] = $this->input->post('fac_b_3');
				$data_insert['fsm_fac_b_4'] = $this->input->post('fac_b_4');
				$data_insert['fsm_fac_b_5'] = $this->input->post('fac_b_5');
				$data_insert['fsm_fac_b_6'] = $this->input->post('fac_b_6');
				$data_insert['fsm_fac_b_7'] = $this->input->post('fac_b_7');
				$data_insert['fsm_fac_b_8'] = $this->input->post('fac_b_8');
				$data_insert['fsm_fac_total_a'] = $this->input->post('fac_total_a');
				$data_insert['fsm_fac_total_b'] = $this->input->post('fac_total_b');
				
				$data_insert['fsm_diag_imc'] = $this->input->post('diag_imc');
				$data_insert['fsm_diag_antidoping'] = $this->input->post('diag_antidoping');
				$data_insert['fsm_diag_agudesa_visual'] = $this->input->post('diag_agudesa_visual');
				$data_insert['fsm_diag_audiometria'] = $this->input->post('diag_audiometria');
				$data_insert['fsm_diag_odontologico'] = $this->input->post('diag_odontologico');
				$data_insert['fsm_diag_espirometria'] = $this->input->post('diag_espirometria');
				
				$data_insert['fsm_diag_aptitud'] = $this->input->post('diag_aptitud');
				
				$data_insert['fsm_observaciones'] = $this->input->post('observaciones');

				if ($medico['usr_genero_cve'] == 'H') {$gen= 'Dr. ';} else {$gen= 'Dra. ';}
				$data_insert['fsm_med_nombre'] = $gen.$medico['usr_nombre'].' '.$medico['usr_paterno'].' '.$medico['usr_materno'];
				$data_insert['fsm_med_cedula'] =$medico['usr_cedula'];
				$data_insert['fsm_med_carrera'] =$medico['usr_carrera'];
				$data_insert['fsm_med_escuela'] =$medico['usr_institucion'];
				
				$data_insert['log_insrt_f']   =  date("Y-m-d H:i:s");
				$data_insert['log_insrt_usr_cve']  = $user['usr_id'];
				$data_insert['log_updt_f']   =  date("Y-m-d H:i:s");
				$data_insert['log_updt_usr_cve']  = $user['usr_id']; 

/*********************************************************************/


				    $data_clte['clte_path_foto'] = $cliente ['clte_path_foto'];
                    
					if(!empty($_FILES['foto']['name']))
                    {
                        $this->load->library('upload');
                        $filename = md5(time());
                        $config = array(
                                'upload_path'   => './../../files/em/',
                                'overwrite'     => TRUE,
                                'file_name'     => $filename,
                                'allowed_types' => 'png|jpg|jpeg',
                                'max_size'      => '25000'
                        );

                        $this->upload->initialize($config);
                        if ( ! $this->upload->do_upload('foto'))
                        {
                            send_json_error($this->upload->display_errors());
                        }
                        else 
                        {
                            $data = $this->upload->data();
                            $data_clte['clte_path_foto'] = $data['file_name'];
                        }
                    }


					if(!empty($_FILES['foto']['name']))
                    {
                        $this->load->library('upload');
                        $filename = md5(time());
                        $config = array(
                                'upload_path'   => './../../files/em/',
                                'overwrite'     => TRUE,
                                'file_name'     => $filename,
                                'allowed_types' => 'png|jpg|jpeg',
                                'max_size'      => '25000'
                        );

                        $this->upload->initialize($config);
                        if ( ! $this->upload->do_upload('foto'))
                        {
                            send_json_error($this->upload->display_errors());
                        }
                        else 
                        {
                            $data = $this->upload->data();
                            $data_insert['fsm_path_cuerpo'] = $data['file_name'];
                        }
                    }


					 
					
					$ISOEXMEDINEX=$this->salud_ocupacional->insert_ISOEXMEDINEX(array_to_upper($data_insert));

					//$oks= $this->cliente->actualiza($cliente_id, array_to_upper($data_clte));

						
						
					if($ISOEXMEDINEX)
					{
						send_json_ok(array('msg' =>'Se actualizó la información del Empleado', 'id' => $cliente_id));
					}
					else
					{
						send_json_error('Ocurrió un error al actualizar la persona.');
					}
					
					
                }
                else
                {
                    send_json_error(validation_errors('<div />'));
                }
            }
            else 
            {
				
				//echo 'B';
                $this->load->model('empresa/Empresa_model','empresa');

				$data['sucursals'] = $this->empresa->get_all_sucursales($empresa);
				$data['consultorios'] = $this->empresa->get_lista_consultorios();
                $data['persona'] = 	$cliente;
				$data['worker'] = 	$worker;
				$data['worker_usr'] = 	$worker_usr;
				
				
				//echo 'C';
				if ($cliente['serv_id'] > 0)
				{
					$data['servicio'] = $servicio;
				}
                $this->load->helper('template');
                $params_view = array(
                    'title' => 'Personas',
                    /*'view' => 'persona/edit_empleado_x',*/
					'view' => 'examen/salud_ocupacional/nuevo_form_xISOEXMEDINEX',
                    'view_data' => $data
                   );
                render_template($params_view);  
            }
        }
        else 
        {
            show_error('No existe el cliente');
        }
    }




/*************************************************************************************/
    public function edita_empleado($cliente_id)
    {    
		$user = $this->session->user;
		$cliente = $this->cliente->get($cliente_id);
		$empresa=$cliente['emp_id'];
		$usuario = $this->medico->get($user['usr_id']);
		
        if($cliente)
        {

            if(isset($_POST) && count($_POST) > 0)     
            {
                $this->load->library('form_validation');
               /* $this->form_validation->set_rules('nombre','Nombre','required');
                $this->form_validation->set_rules('paterno','Apellido Paterno','required');
                $this->form_validation->set_rules('materno','Apellido Materno','required');
                $this->form_validation->set_rules('fnac','Fecha de nacimiento','required');*/
                $this->form_validation->set_rules('genero','Género','required');
              /*  $this->form_validation->set_rules('civil','Estado civil','required');
                $this->form_validation->set_rules('rfc','RFC','required');
                $this->form_validation->set_rules('curp','CURP','required');*/

                if($this->form_validation->run())
                {
                    //informncion general del empleado
                    $data_clte['clte_nombre_crypt'] =  trim($this->input->post('nombre'));
                    $data_clte['clte_2_nombre_crypt'] =  trim($this->input->post('nombre_adic'));
                    $data_clte['clte_paterno_crypt'] =  trim($this->input->post('paterno'));
                    $data_clte['clte_materno_crypt'] =  trim($this->input->post('materno'));
                    
					$data_clte['clte_f_nac'] = formatea_fecha_mysql($this->input->post('fnac'));
                    $data_clte['clte_genero_cve'] =  $this->input->post('genero');
                    $data_clte['clte_rfc_crypt'] =  $this->input->post('rfc');
                    $data_clte['clte_curp_crypt'] =  $this->input->post('curp');
					$data_clte['clte_nac_cve'] =  $this->input->post('nac');
					$data_clte['clte_edo_civ_cve'] =  $this->input->post('civil');
					$data_clte['clte_grado_acad_cve'] =  $this->input->post('grado');
                    //dopmcicio del empleado
                    $data_clte['clte_env_pais_cve'] =  $this->input->post('pais');
                    $data_clte['clte_env_cp'] =  $this->input->post('cp');
                    $data_clte['clte_env_edo_cve'] =  $this->input->post('entidad');
                    $data_clte['clte_env_colonia_crypt'] =  $this->input->post('colonia');
                    $data_clte['clte_env_localidad'] =  $this->input->post('localidad');
                    $data_clte['clte_env_municipio'] =  $this->input->post('municipio');
                    $data_clte['clte_env_calle_crypt'] =  $this->input->post('calle');
                    $data_clte['clte_env_num_ext_crypt'] =  $this->input->post('next');
                    $data_clte['clte_env_num_int_crypt'] =  $this->input->post('nint');
					$data_clte['clte_nss_crypt'] =  $this->input->post('nss');
					$data_clte['empleado_rol'] =  $this->input->post('empleado_rol'); 
					 //informacion de conrtaxcto de la persona
                    $data_clte['clte_tel_casa_crypt'] = limpia_telefono($this->input->post('tel'));                
                    $data_clte['clte_cel_crypt'] =  limpia_telefono($this->input->post('cel'));
                    $data_clte['clte_email_crypt'] =  $this->input->post('correo');
					$nomserv='';
                   //Información del puesto
                    $data_clte['clte_emp'] = $this->input->post('work_emp');
                    $data_clte['clte_jornada'] = $this->input->post('work_jornada');
                    $data_clte['clte_horario'] = $this->input->post('work_horario');
                    $data_clte['clte_sueldo'] = $this->input->post('work_sueldo');
                    $data_clte['clte_emp_dir'] = $this->input->post('work_emp_dir');
                    $data_clte['clte_emp_suc']  = $this->input->post('work_emp_suc');
                    //Información del equipo tecnologia
                    $data_clte['clte_equipo'] =  $this->input->post('work_equipo');
					$data_clte['clte_num_serie'] =  $this->input->post('work_num_serie');
					$data_clte['clte_sist_pre'] =  $this->input->post('work_sist_pre');
					$data_clte['clte_equipo_tel'] =  $this->input->post('work_equipo_tel');
					$data_clte['clte_num_serie_tel'] =  $this->input->post('work_num_serie_tel');
					$data_clte['clte_num_tel'] =  $this->input->post('work_num_tel');
                    //Informacion adicional
                    $data_clte['clte_cartilla'] =  $this->input->post('cartilla');
                    $data_clte['clte_cedula'] =  $this->input->post('cedula');
                    $data_clte['clte_soli_puesto'] =  $this->input->post('soli_puesto');	
					
					if (! (strstr($usuario['acciones'], 'NOEXPEDIENTSEMP;')) )
					{	
						/***************************************************************************************/			
						$cat_examen = get_cat_nombre_var('EXAMEN');
						$i=0;
						$cat_categorias = get_cat_nombre_var('CATEGORIA_EX');
						foreach($cat_categorias as $categoria): 
							//echo $categoria['cat_nombre'].' ';
							$linea_examenes=get_examen_de_empresa_por_categoria($cliente['emp_id'], $categoria['cat_nombre']);
							
							if (strlen($linea_examenes) > 0)
							{
								foreach (explode(';', $linea_examenes) as $det):
									if (strlen($det) > 0)
									{

											//<?php echo $categoria['cat_nombre'];

											//<?php echo get_nombre_de_examen($det, 'EXAMEN');
											
											$exa=$this->input->post($categoria['cat_nombre'].'_'.$i);
											$nomserv.=$exa;
											$i++;
											//<input type="checkbox" id="<?php echo $categoria['cat_nombre'].'_'.$i; " name="<?php echo $categoria['cat_nombre'].'_'.$i; " value="<?php echo $det.';'; $i++; " <?php if (strstr($persona['nomserv'], $det.';')) { echo 'checked';} 

									}
									
								endforeach;										
							}
						endforeach;
						$data_clte['nomserv'] =  $nomserv;
						/***************************************************************************************/
					}
					else
					{
						$data_clte['nomserv'] = $cliente['nomserv']; 
					}	


					$data_clte['f_ingreso'] =  formatea_fecha_mysql($this->input->post('f_ingreso')); 
					$data_clte['clte_puesto'] =  $this->input->post('puesto');
					if ($cliente['emp_id']==31)
					{	
						$data_clte['cei_id'] =  $this->input->post('cei');
					}
					//$data_clte['suc_id'] =  $this->input->post('sucursal');					
					//$data_clte['status'] =  $this->input->post('status'); 
					
					$data_clte['num_empleado'] =  $this->input->post('work_numemp'); 
					$data_clte['area_depto'] =  $this->input->post('area_depto'); 
					$data_clte['clte_tipo_sangre'] =  $this->input->post('sangre'); 					
					
					$data_clte['clte_accidente_av'] =  $this->input->post('accidente_av'); 					
					$data_clte['clte_parentesco_av'] =  $this->input->post('parentesco_av'); 					
					$data_clte['clte_telefono_av'] =  $this->input->post('telefono_av');					
					
					$data_clte['clte_clinica_imss'] =  $this->input->post('clinica_imss'); 					
					$data_clte['clte_no_consultorio'] =  $this->input->post('no_consultorio');		
					$data_clte['clte_turno'] =  $this->input->post('turno');		
					$data_clte['clte_f_consulta'] =  formatea_fecha_mysql($this->input->post('f_consulta')); 

				    $data_clte['clte_path_foto'] = $cliente ['clte_path_foto'];
                    if(!empty($_FILES['foto']['name']))
                    {
                        $this->load->library('upload');
                        $filename = md5(time());
                        $config = array(
                                'upload_path'   => './../../files/fotos/',
                                'overwrite'     => TRUE,
                                'file_name'     => $filename,
                                'allowed_types' => 'png|jpg|jpeg',
                                'max_size'      => '25000'
                        );

                        $this->upload->initialize($config);
                        if ( ! $this->upload->do_upload('foto'))
                        {
                            send_json_error($this->upload->display_errors());
                        }
                        else 
                        {
                            $data = $this->upload->data();
                            $data_clte['clte_path_foto'] = $data['file_name'];
                        }
                    }




					if (($data_clte['clte_f_nac'] =='') && ($data_clte['emp_id'] !=152))
					{
						send_json_error('Ocurrió un error, no se registro la FECHA DE NACIMIENTO.');
					}
                    else
					{
						
						if ($this->input->post('rregistrar') == 'rr')
						{						
							if($this->cliente->actualiza_registro($cliente_id, array_to_upper($data_clte)))
							{
								send_json_ok(array('msg' =>'Se actualizó el registro del evaluado de forma correcta', 'id' => $cliente_id));
							}
							else
							{
								send_json_error('Ocurrió un error al actualizar la persona.');
							}
						}
						else
						{	
						
							if($this->cliente->actualiza($cliente_id, array_to_upper($data_clte)))
							{
								send_json_ok(array('msg' =>'Se actualizó la información del Empleado', 'id' => $cliente_id));
							}
							else
							{
								send_json_error('Ocurrió un error al actualizar la persona.');
							}
						}
					}
                }
                else
                {
                    send_json_error(validation_errors('<div />'));
                }
            }
            else 
            {
                $this->load->model('empresa/Empresa_model','empresa');

				$data['sucursals'] = $this->empresa->get_all_sucursales($empresa);
				$data['consultorios'] = $this->empresa->get_lista_consultorios();
                $data['persona'] = 	$cliente;
				$data['worker'] = 	$worker;
				$data['worker_usr'] = 	$worker_usr;
				$data['usuario'] =$usuario;
				if ($cliente['serv_id'] > 0)
				{
					$data['servicio'] = $servicio;
				}
                $this->load->helper('template');
                $params_view = array(
                    'title' => 'Personas',
                    'view' => 'persona/edit_empleado',
                    'view_data' => $data
                   );
                render_template($params_view);  
            }
        }
        else 
        {
            show_error('No existe el cliente');
        }
    }



/*************************************************************************************/
    public function edita_sw($cliente_id)
    {    
		$user = $this->session->user;
		$cliente = $this->cliente->get($cliente_id);
		$empresa=$cliente['emp_id'];
		
        if($cliente)
        {

            if(isset($_POST) && count($_POST) > 0)     
            {
                $this->load->library('form_validation');
                $this->form_validation->set_rules('nombre','Nombre','required');
                $this->form_validation->set_rules('paterno','Apellido Paterno','required');
                $this->form_validation->set_rules('materno','Apellido Materno','required');
                $this->form_validation->set_rules('fnac','Fecha de nacimiento','required');
                $this->form_validation->set_rules('genero','Género','required');
                $this->form_validation->set_rules('civil','Estado civil','required');
                $this->form_validation->set_rules('rfc','RFC','required');
                $this->form_validation->set_rules('curp','CURP','required');

                if($this->form_validation->run())
                {
                    //informncion general del empleado
                    $data_clte['clte_nombre_crypt'] =  trim($this->input->post('nombre'));
                    $data_clte['clte_2_nombre_crypt'] =  trim($this->input->post('nombre_adic'));
                    $data_clte['clte_paterno_crypt'] =  trim($this->input->post('paterno'));
                    $data_clte['clte_materno_crypt'] =  trim($this->input->post('materno'));
                    
					$data_clte['clte_f_nac'] = formatea_fecha_mysql($this->input->post('fnac'));
                    $data_clte['clte_genero_cve'] =  $this->input->post('genero');
                    $data_clte['clte_rfc_crypt'] =  $this->input->post('rfc');
                    $data_clte['clte_curp_crypt'] =  $this->input->post('curp');
					$data_clte['clte_nac_cve'] =  $this->input->post('nac');
					$data_clte['clte_edo_civ_cve'] =  $this->input->post('civil');

                    //dopmcicio del empleado
                    $data_clte['clte_env_pais_cve'] =  $this->input->post('pais');
                    $data_clte['clte_env_cp'] =  $this->input->post('cp');
                    $data_clte['clte_env_edo_cve'] =  $this->input->post('entidad');
                    $data_clte['clte_env_colonia_crypt'] =  $this->input->post('colonia');
                    $data_clte['clte_env_localidad'] =  $this->input->post('localidad');
                    $data_clte['clte_env_municipio'] =  $this->input->post('municipio');
                    $data_clte['clte_env_calle_crypt'] =  $this->input->post('calle');
                    $data_clte['clte_env_num_ext_crypt'] =  $this->input->post('next');
                    $data_clte['clte_env_num_int_crypt'] =  $this->input->post('nint');
					$data_clte['clte_nss_crypt'] =  $this->input->post('nss');
	 
	
					$nomserv='';
					
/***************************************************************************************/
						
					$cat_examen = get_cat_nombre_var('EXAMEN');
					$i=0;
					$cat_categorias = get_cat_nombre_var('CATEGORIA_EX');
					foreach($cat_categorias as $categoria): 
						//echo $categoria['cat_nombre'].' ';
						$linea_examenes=get_examen_de_empresa_por_categoria($cliente['emp_id'], $categoria['cat_nombre']);
						
						if (strlen($linea_examenes) > 0)
						{
							foreach (explode(';', $linea_examenes) as $det):
								if (strlen($det) > 0)
								{

										//<?php echo $categoria['cat_nombre'];

										//<?php echo get_nombre_de_examen($det, 'EXAMEN');
										
										$exa=$this->input->post($categoria['cat_nombre'].'_'.$i);
										$nomserv.=$exa;
										$i++;
										//<input type="checkbox" id="<?php echo $categoria['cat_nombre'].'_'.$i; " name="<?php echo $categoria['cat_nombre'].'_'.$i; " value="<?php echo $det.';'; $i++; " <?php if (strstr($persona['nomserv'], $det.';')) { echo 'checked';} 

								}
								
							endforeach;										
						}
					endforeach;
/***************************************************************************************/
					$nomserv.='NNUTRI;NPSICO;NMEDICA;';
					$data_clte['nomserv'] =  $nomserv;

					$data_clte['f_ingreso'] =  formatea_fecha_mysql($this->input->post('f_ingreso')); 
					$data_clte['clte_puesto'] =  $this->input->post('puesto');
					//$data_clte['cei_id'] =  $this->input->post('cei');
					//$data_clte['suc_id'] =  $this->input->post('sucursal');
					
					//$data_clte['status'] =  $this->input->post('status'); 
					
					$data_clte['num_empleado'] =  $this->input->post('work_numemp'); 
					$data_clte['area_depto'] =  $this->input->post('area'); 
					$data_clte['clte_tipo_sangre'] =  $this->input->post('sangre'); 


				    $data_clte['clte_path_foto'] = $cliente ['clte_path_foto'];

                    if(!empty($_FILES['foto']['name']))
                    {
                        $this->load->library('upload');
                        $filename = md5(time());
                        $config = array(
                                'upload_path'   => './../../files/fotos/',
                                'overwrite'     => TRUE,
                                'file_name'     => $filename,
                                'allowed_types' => 'png|jpg|jpeg',
                                'max_size'      => '25000'
                        );

                        $this->upload->initialize($config);
                        if ( ! $this->upload->do_upload('foto'))
                        {
                            send_json_error($this->upload->display_errors());
                        }
                        else 
                        {
                            $data = $this->upload->data();
                            $data_clte['clte_path_foto'] = $data['file_name'];
                        }
                    }




					if (($data_clte['clte_f_nac'] =='') && ($data_clte['emp_id'] !=152))
					{
						send_json_error('Ocurrió un error, no se registro la FECHA DE NACIMIENTO.');
					}
                    else
					{
						
						if ($this->input->post('rregistrar') == 'rr')
						{						
							if($this->cliente->actualiza_registro($cliente_id, array_to_upper($data_clte)))
							{
								send_json_ok(array('msg' =>'Se actualizó y registro nuevamente el evaluado de forma correcta', 'id' => $cliente_id));
							}
							else
							{
								send_json_error('Ocurrió un error al actualizar la persona.');
							}
						}
						else
						{	
						
							if($this->cliente->actualiza($cliente_id, array_to_upper($data_clte)))
							{
								send_json_ok(array('msg' =>'Se actualizó la información del Empleado', 'id' => $cliente_id));
							}
							else
							{
								send_json_error('Ocurrió un error al actualizar la persona.');
							}
						}
					}
                }
                else
                {
                    send_json_error(validation_errors('<div />'));
                }
            }
            else 
            {
                $this->load->model('empresa/Empresa_model','empresa');

				$data['sucursals'] = $this->empresa->get_all_sucursales($empresa);
				$data['consultorios'] = $this->empresa->get_lista_consultorios();
                $data['persona'] = 	$cliente;
				$data['worker'] = 	$worker;
				$data['worker_usr'] = 	$worker_usr;
				
				if ($cliente['serv_id'] > 0)
				{
					$data['servicio'] = $servicio;
				}
                $this->load->helper('template');
                $params_view = array(
                    'title' => 'Personas',
                    'view' => 'persona/edit_sw',
                    'view_data' => $data
                   );
                render_template($params_view);  
            }
        }
        else 
        {
            show_error('No existe el cliente');
        }
    }

/*************************************************************************************/
    public function edita_empleado_ext($cliente_id)
    {    
		$user = $this->session->user;
		$cliente = $this->cliente->get($cliente_id);
		$empresa=$cliente['emp_id'];
		
        if($cliente)
        {

            if(isset($_POST) && count($_POST) > 0)     
            {
                $this->load->library('form_validation');
                $this->form_validation->set_rules('nombre','Nombre','required');
                $this->form_validation->set_rules('paterno','Apellido Paterno','required');
                $this->form_validation->set_rules('materno','Apellido Materno','required');
                $this->form_validation->set_rules('fnac','Fecha de nacimiento','required');
                $this->form_validation->set_rules('genero','Género','required');
                $this->form_validation->set_rules('civil','Estado civil','required');
               /* $this->form_validation->set_rules('rfc','RFC','required');
                $this->form_validation->set_rules('curp','CURP','required');
			*/	
                if($this->form_validation->run())
                {
                    //informncion general del empleado
                    $data_clte['clte_nombre_crypt'] =  trim($this->input->post('nombre'));
                    $data_clte['clte_2_nombre_crypt'] =  trim($this->input->post('nombre_adic'));
                    $data_clte['clte_paterno_crypt'] =  trim($this->input->post('paterno'));
                    $data_clte['clte_materno_crypt'] =  trim($this->input->post('materno'));
                    
					$data_clte['clte_f_nac'] = formatea_fecha_mysql($this->input->post('fnac'));
                    $data_clte['clte_genero_cve'] =  $this->input->post('genero');
                    $data_clte['clte_rfc_crypt'] =  $this->input->post('rfc');
                    $data_clte['clte_curp_crypt'] =  $this->input->post('curp');
					$data_clte['clte_nac_cve'] =  $this->input->post('nac');
					$data_clte['clte_edo_civ_cve'] =  $this->input->post('civil');

                    //dopmcicio del empleado
                    $data_clte['clte_env_pais_cve'] =  $this->input->post('pais');
                    $data_clte['clte_env_cp'] =  $this->input->post('cp');
                    $data_clte['clte_env_edo_cve'] =  $this->input->post('entidad');
                    $data_clte['clte_env_colonia_crypt'] =  $this->input->post('colonia');
                    $data_clte['clte_env_localidad'] =  $this->input->post('localidad');
                    $data_clte['clte_env_municipio'] =  $this->input->post('municipio');
                    $data_clte['clte_env_calle_crypt'] =  $this->input->post('calle');
                    $data_clte['clte_env_num_ext_crypt'] =  $this->input->post('next');
                    $data_clte['clte_env_num_int_crypt'] =  $this->input->post('nint');
					$data_clte['clte_nss_crypt'] =  $this->input->post('nss');
	 
	
					$nomserv='';
					
/***************************************************************************************/
						
					$cat_examen = get_cat_nombre_var('EXAMEN');
					$i=0;
					$cat_categorias = get_cat_nombre_var('CATEGORIA_EX');
					foreach($cat_categorias as $categoria): 
						//echo $categoria['cat_nombre'].' ';
						$linea_examenes=get_examen_de_empresa_por_categoria($cliente['emp_id'], $categoria['cat_nombre']);
						
						if (strlen($linea_examenes) > 0)
						{
							foreach (explode(';', $linea_examenes) as $det):
								if (strlen($det) > 0)
								{

										//<?php echo $categoria['cat_nombre'];

										//<?php echo get_nombre_de_examen($det, 'EXAMEN');
										
										$exa=$this->input->post($categoria['cat_nombre'].'_'.$i);
										$nomserv.=$exa;
										$i++;
										//<input type="checkbox" id="<?php echo $categoria['cat_nombre'].'_'.$i; " name="<?php echo $categoria['cat_nombre'].'_'.$i; " value="<?php echo $det.';'; $i++; " <?php if (strstr($persona['nomserv'], $det.';')) { echo 'checked';} 

								}
								
							endforeach;										
						}
					endforeach;
/***************************************************************************************/

					$data_clte['nomserv'] =  $nomserv;

					$data_clte['f_ingreso'] =  formatea_fecha_mysql($this->input->post('f_ingreso')); 
					$data_clte['clte_puesto'] =  $this->input->post('puesto');
					//$data_clte['cei_id'] =  $this->input->post('cei');
					//$data_clte['suc_id'] =  $this->input->post('sucursal');
					//$data_clte['status'] =  $this->input->post('status'); 
					
					$data_clte['num_empleado'] =  $this->input->post('work_numemp'); 
					$data_clte['area_depto'] =  $this->input->post('area'); 
					
					$data_clte['clte_tipo_sangre'] =  $this->input->post('sangre'); 


				    $data_clte['clte_path_foto'] = $cliente ['clte_path_foto'];

                    if(!empty($_FILES['foto']['name']))
                    {
                        $this->load->library('upload');
                        $filename = md5(time());
                        $config = array(
                                'upload_path'   => './../../files/fotos/',
                                'overwrite'     => TRUE,
                                'file_name'     => $filename,
                                'allowed_types' => 'png|jpg|jpeg',
                                'max_size'      => '25000'
                        );

                        $this->upload->initialize($config);
                        if ( ! $this->upload->do_upload('foto'))
                        {
                            send_json_error($this->upload->display_errors());
                        }
                        else 
                        {
                            $data = $this->upload->data();
                            $data_clte['clte_path_foto'] = $data['file_name'];
                        }
                    }




					if (($data_clte['clte_f_nac'] =='') && ($data_clte['emp_id'] !=152))
					{
						send_json_error('Ocurrió un error, no se registro la FECHA DE NACIMIENTO.');
					}
                    else
					{
						
						if ($this->input->post('rregistrar') == 'rr')
						{						
							if($this->cliente->actualiza_registro($cliente_id, array_to_upper($data_clte)))
							{
								send_json_ok(array('msg' =>'Se actualizó y registro nuevamente el evaluado de forma correcta', 'id' => $cliente_id));
							}
							else
							{
								send_json_error('Ocurrió un error al actualizar la persona.');
							}
						}
						else
						{	
						
							if($this->cliente->actualiza($cliente_id, array_to_upper($data_clte)))
							{
								send_json_ok(array('msg' =>'Se actualizó la información del Empleado', 'id' => $cliente_id));
							}
							else
							{
								send_json_error('Ocurrió un error al actualizar la persona.');
							}
						}
					}
                }
                else
                {
                    send_json_error(validation_errors('<div />'));
                }
            }
            else 
            {
                $this->load->model('empresa/Empresa_model','empresa');

				$data['sucursals'] = $this->empresa->get_all_sucursales($empresa);
				$data['consultorios'] = $this->empresa->get_lista_consultorios();
                $data['persona'] = 	$cliente;
				$data['worker'] = 	$worker;
				$data['worker_usr'] = 	$worker_usr;
				
				if ($cliente['serv_id'] > 0)
				{
					$data['servicio'] = $servicio;
				}
                $this->load->helper('template');
                $params_view = array(
                    'title' => 'Personas',
                    'view' => 'persona/edit_empleado_ext',
                    'view_data' => $data
                   );
                render_template($params_view);  
            }
        }
        else 
        {
            show_error('No existe el cliente');
        }
    }



/*************************************************************************************/
    public function edita_swe($cliente_id)
    {    
		$user = $this->session->user;
		$cliente = $this->cliente->get($cliente_id);
		$empresa=$cliente['emp_id'];
		
        if($cliente)
        {

            if(isset($_POST) && count($_POST) > 0)     
            {
                $this->load->library('form_validation');
                $this->form_validation->set_rules('nombre','Nombre','required');
                $this->form_validation->set_rules('paterno','Apellido Paterno','required');
                $this->form_validation->set_rules('materno','Apellido Materno','required');
                $this->form_validation->set_rules('fnac','Fecha de nacimiento','required');
                $this->form_validation->set_rules('genero','Género','required');
                $this->form_validation->set_rules('civil','Estado civil','required');
                $this->form_validation->set_rules('rfc','RFC','required');
                $this->form_validation->set_rules('curp','CURP','required');

                if($this->form_validation->run())
                {
                    //informncion general del empleado
                    $data_clte['clte_nombre_crypt'] =  trim($this->input->post('nombre'));
                    $data_clte['clte_2_nombre_crypt'] =  trim($this->input->post('nombre_adic'));
                    $data_clte['clte_paterno_crypt'] =  trim($this->input->post('paterno'));
                    $data_clte['clte_materno_crypt'] =  trim($this->input->post('materno'));
                    
					$data_clte['clte_f_nac'] = formatea_fecha_mysql($this->input->post('fnac'));
                    $data_clte['clte_genero_cve'] =  $this->input->post('genero');
                    $data_clte['clte_rfc_crypt'] =  $this->input->post('rfc');
                    $data_clte['clte_curp_crypt'] =  $this->input->post('curp');
					$data_clte['clte_nac_cve'] =  $this->input->post('nac');
					$data_clte['clte_edo_civ_cve'] =  $this->input->post('civil');

                    //dopmcicio del empleado
                    $data_clte['clte_env_pais_cve'] =  $this->input->post('pais');
                    $data_clte['clte_env_cp'] =  $this->input->post('cp');
                    $data_clte['clte_env_edo_cve'] =  $this->input->post('entidad');
                    $data_clte['clte_env_colonia_crypt'] =  $this->input->post('colonia');
                    $data_clte['clte_env_localidad'] =  $this->input->post('localidad');
                    $data_clte['clte_env_municipio'] =  $this->input->post('municipio');
                    $data_clte['clte_env_calle_crypt'] =  $this->input->post('calle');
                    $data_clte['clte_env_num_ext_crypt'] =  $this->input->post('next');
                    $data_clte['clte_env_num_int_crypt'] =  $this->input->post('nint');
					$data_clte['clte_nss_crypt'] =  $this->input->post('nss');
	 
	
					$nomserv='';
					
/***************************************************************************************/
						
					$cat_examen = get_cat_nombre_var('EXAMEN');
					$i=0;
					$cat_categorias = get_cat_nombre_var('CATEGORIA_EX');
					foreach($cat_categorias as $categoria): 
						//echo $categoria['cat_nombre'].' ';
						$linea_examenes=get_examen_de_empresa_por_categoria($cliente['emp_id'], $categoria['cat_nombre']);
						
						if (strlen($linea_examenes) > 0)
						{
							foreach (explode(';', $linea_examenes) as $det):
								if (strlen($det) > 0)
								{

										//<?php echo $categoria['cat_nombre'];

										//<?php echo get_nombre_de_examen($det, 'EXAMEN');
										
										$exa=$this->input->post($categoria['cat_nombre'].'_'.$i);
										$nomserv.=$exa;
										$i++;
										//<input type="checkbox" id="<?php echo $categoria['cat_nombre'].'_'.$i; " name="<?php echo $categoria['cat_nombre'].'_'.$i; " value="<?php echo $det.';'; $i++; " <?php if (strstr($persona['nomserv'], $det.';')) { echo 'checked';} 

								}
								
							endforeach;										
						}
					endforeach;
/***************************************************************************************/

					$data_clte['nomserv'] =  $nomserv;

					$data_clte['f_ingreso'] =  formatea_fecha_mysql($this->input->post('f_ingreso')); 
					$data_clte['clte_puesto'] =  $this->input->post('puesto');
					//$data_clte['cei_id'] =  $this->input->post('cei');
					//$data_clte['suc_id'] =  $this->input->post('sucursal');
					//$data_clte['status'] =  $this->input->post('status'); 
					
					$data_clte['num_empleado'] =  $this->input->post('work_numemp'); 
					$data_clte['area_depto'] =  $this->input->post('area'); 
					$data_clte['clte_tipo_sangre'] =  $this->input->post('sangre'); 


				    $data_clte['clte_path_foto'] = $cliente ['clte_path_foto'];

                    if(!empty($_FILES['foto']['name']))
                    {
                        $this->load->library('upload');
                        $filename = md5(time());
                        $config = array(
                                'upload_path'   => './../../files/fotos/',
                                'overwrite'     => TRUE,
                                'file_name'     => $filename,
                                'allowed_types' => 'png|jpg|jpeg',
                                'max_size'      => '25000'
                        );

                        $this->upload->initialize($config);
                        if ( ! $this->upload->do_upload('foto'))
                        {
                            send_json_error($this->upload->display_errors());
                        }
                        else 
                        {
                            $data = $this->upload->data();
                            $data_clte['clte_path_foto'] = $data['file_name'];
                        }
                    }




					if (($data_clte['clte_f_nac'] =='') && ($data_clte['emp_id'] !=152))
					{
						send_json_error('Ocurrió un error, no se registro la FECHA DE NACIMIENTO.');
					}
                    else
					{
						
						if ($this->input->post('rregistrar') == 'rr')
						{						
							if($this->cliente->actualiza_registro($cliente_id, array_to_upper($data_clte)))
							{
								send_json_ok(array('msg' =>'Se actualizó y registro nuevamente el evaluado de forma correcta', 'id' => $cliente_id));
							}
							else
							{
								send_json_error('Ocurrió un error al actualizar la persona.');
							}
						}
						else
						{	
						
							if($this->cliente->actualiza($cliente_id, array_to_upper($data_clte)))
							{
								send_json_ok(array('msg' =>'Se actualizó la información del Empleado', 'id' => $cliente_id));
							}
							else
							{
								send_json_error('Ocurrió un error al actualizar la persona.');
							}
						}
					}
                }
                else
                {
                    send_json_error(validation_errors('<div />'));
                }
            }
            else 
            {
                $this->load->model('empresa/Empresa_model','empresa');

				$data['sucursals'] = $this->empresa->get_all_sucursales($empresa);
				$data['consultorios'] = $this->empresa->get_lista_consultorios();
                $data['persona'] = 	$cliente;
				$data['worker'] = 	$worker;
				$data['worker_usr'] = 	$worker_usr;
				
				if ($cliente['serv_id'] > 0)
				{
					$data['servicio'] = $servicio;
				}
                $this->load->helper('template');
                $params_view = array(
                    'title' => 'Personas',
                    'view' => 'persona/edit_swe',
                    'view_data' => $data
                   );
                render_template($params_view);  
            }
        }
        else 
        {
            show_error('No existe el cliente');
        }
    }

/*************************************************************************************/
    public function lista_enom()
    {   
		
		$suc=get_sucursal_id();
		$user_despacho=get_desp_id_usr();
		$user_cei=get_cei_id();
		$user_root1=get_my_user_root1();
		$user = $this->session->user; 
		$medico = $this->medico->get($user['usr_id']);
		$emp_id=$user['emp_id'];
        $rows = 30;
        $this->load->library('pagination');
        $config['base_url'] = base_url('persona/lista_enom/');

		$config['total_rows'] = $this->cliente->count_allo_e($emp_id,$suc,$user_despacho,$user_cei,$user_root1,1);

		$config['per_page'] = $rows;
        $config['attributes'] = array('class' => 'pagination');
        $config['full_tag_open'] = '<div class="pagination-full">';
        $config['full_tag_close'] = '</div>';
        $config['uri_segment'] = 3;
        $config['query_string_segment'] = 4;
        $config['use_page_numbers'] = TRUE;
        $this->pagination->initialize($config);

		$data['clientes'] = $this->cliente->get_allo_e($rows,$emp_id,get_sucursal_id(),$user_despacho,$user_cei,$user_root1,1);
        
        $this->load->helper('template');
        $params_view = array(
            'title' => 'Personas',
            'view' => 'persona/index_enom',
            'view_data' => $data 
           );
        render_template($params_view);  
    }
/*************************************************************************************/


    public function lista_enom035()
    {   
		
		$suc=get_sucursal_id();

		$user_cei=get_cei_id();

		$user = $this->session->user; 
		$usuario = $this->medico->get($user['usr_id']);

		$emp_id=$user['emp_id'];
        $rows = 30;
        $this->load->library('pagination');
        $config['base_url'] = base_url('persona/lista_enom/');

		$config['total_rows'] = 1 ; //$this->cliente->count_allo_e($emp_id,$suc,$user_despacho,$user_cei,$user_root1,1);

		$config['per_page'] = $rows;
        $config['attributes'] = array('class' => 'pagination');
        $config['full_tag_open'] = '<div class="pagination-full">';
        $config['full_tag_close'] = '</div>';
        $config['uri_segment'] = 3;
        $config['query_string_segment'] = 4;
        $config['use_page_numbers'] = TRUE;
        $this->pagination->initialize($config);
		
		$data['clientes'] = $this->cliente->get_unique_ee($usuario['clte_id'],$rows,$emp_id,get_sucursal_id(),$user_despacho,$user_cei,$user_root1,1);
        
        $this->load->helper('template');
        $params_view = array(
            'title' => 'Personas',
            'view' => 'persona/index_enom035',
            'view_data' => $data 
           );
        render_template($params_view);  
    }
/*************************************************************************************/


/*************************************************************************************/
    public function lista_e()
    {   
	    //echo " Punto A ";
		$suc=get_sucursal_id();
		$user_despacho=get_desp_id_usr();
		$user_cei=get_cei_id();
		$user_root1=get_my_user_root1();
		$user = $this->session->user; 
		$medico = $this->medico->get($user['usr_id']);
		$emp_id=$user['emp_id'];
        $rows = 30;
        $this->load->library('pagination');
        $config['base_url'] = base_url('persona/lista_e/');
        //$config['total_rows'] = $this->cliente->count_all();
		
		if ($user['usr_id'] == 482)
		{
		$config['total_rows'] = $this->cliente->count_allo_m($emp_id,$suc,$user_despacho,$user_cei,$user_root1,1);
        }
		else
		{
		$config['total_rows'] = $this->cliente->count_allo_e($emp_id,$suc,$user_despacho,$user_cei,$user_root1,1);
        }
		
		$config['per_page'] = $rows;
        $config['attributes'] = array('class' => 'pagination');
        $config['full_tag_open'] = '<div class="pagination-full">';
        $config['full_tag_close'] = '</div>';
        $config['uri_segment'] = 3;
        $config['query_string_segment'] = 4;
        $config['use_page_numbers'] = TRUE;
        $this->pagination->initialize($config);
        //echo " Punto ".$medico['usr_emp_asig'];
		//echo " Punto B ";
        //$data['clientes'] = $this->cliente->get_all($rows);
		//echo " Punto ".$emp_id;
		

		if ($user['usr_id'] == 482)
		{
		$data['clientes'] = $this->cliente->get_allo_m($rows,$emp_id,get_sucursal_id(),$user_despacho,$user_cei,$user_root1,1);
        }
		else
		{
		$data['clientes'] = $this->cliente->get_allo_e($rows,$emp_id,get_sucursal_id(),$user_despacho,$user_cei,$user_root1,1);
        }

		
		//echo " Punto C ";
		
        //$this->load->model('empresa/Empresa_model','empresa');
		//echo " Punto D ";
		
        //$data['empresas'] = $this->empresa->trae_empresas(1);//$this->empresa->get_all_empresas();
		//$data['empresas'] = $this->empresa->get_all_empresas_gsi();
		//echo " Punto E ";
        
        $this->load->helper('template');
        $params_view = array(
            'title' => 'Personas',
            'view' => 'persona/index_e',
            'view_data' => $data 
           );
        render_template($params_view);  
    }
/*************************************************************************************/	
	public function rep_eeebita()
    {
        $this->load->helper('template');
        $params_view = array(
            'title' => 'Inicio',
            'view' => 'persona/inicio_view_rep_eeebita',
            'view_data' => $data
            );
        render_template($params_view);
    }
	
/*************************************************************************************/
    public function lista_hc()
    {   
	    //echo " Punto A ";
		$user = $this->session->user;
		$usuario = $this->medico->get($user['usr_id']);
		//$where = "cei_id = 4 and  (clte_puesto = 'MÉDICO EVALUADOR' OR clte_puesto = 'ENFERMERA' OR clte_puesto = 'PSICOLOGO' OR clte_puesto = 'OPTOMETRISTA')";
		
		$where = "clte_puesto = 'MÉDICO GSI' ";
		
		
		$emp_id=$user['emp_id'];
		
        $rows = 30;
        $this->load->library('pagination');
        $config['base_url'] = base_url('persona/lista_hc/');
		
		if ( strstr($usuario['modulos'],'HC-RH-GSI') )
		{	
			$config['total_rows'] = $this->cliente->count_all_empleados_hc_gsi_medicos(31,$where);
		}
		else //sheldon 
		{
			$config['total_rows'] = $this->cliente->count_allo_e($emp_id,$suc,$user_despacho,$user_cei,$user_root1,1);
		}	
		
		$config['per_page'] = $rows;
        $config['attributes'] = array('class' => 'pagination');
        $config['full_tag_open'] = '<div class="pagination-full">';
        $config['full_tag_close'] = '</div>';
        $config['uri_segment'] = 3;
        $config['query_string_segment'] = 4;
        $config['use_page_numbers'] = TRUE;
        $this->pagination->initialize($config);
		
		
		if ( strstr($usuario['modulos'],'HC-RH-GSI') )
		{	
			$data['clientes'] = $this->cliente->get_all_empleados_hc_gsi_medicos($rows,31,$where);
		}
		else //sheldon 
		{
			$data['clientes'] = $this->cliente->get_allo_hc($rows,$emp_id,get_sucursal_id(),$user_despacho,$user_cei,$user_root1,1);
		}		

		$data['usuario']=$usuario;
        $this->load->helper('template');
        $params_view = array(
            'title' => 'Personas',
            'view' => 'persona/index_hc',
            'view_data' => $data 
           );
        render_template($params_view);  
    }	
	
/*************************************************************************************/
    public function lista_a()
    {   
	    //echo " Punto A ";
		$suc=get_sucursal_id();
		$user_despacho=get_desp_id_usr();
		$user_cei=get_cei_id();
		$user_root1=get_my_user_root1();
		$user = $this->session->user; 
		$medico = $this->medico->get($user['usr_id']);
		$emp_id=$user['emp_id'];
        $rows = 30;
        $this->load->library('pagination');
        $config['base_url'] = base_url('persona/lista_a/');
        //$config['total_rows'] = $this->cliente->count_all();
		$config['total_rows'] = $this->cliente->count_allo_a($emp_id,$suc,$user_despacho,$user_cei,$user_root1,1);
        
		$config['per_page'] = $rows;
        $config['attributes'] = array('class' => 'pagination');
        $config['full_tag_open'] = '<div class="pagination-full">';
        $config['full_tag_close'] = '</div>';
        $config['uri_segment'] = 3;
        $config['query_string_segment'] = 4;
        $config['use_page_numbers'] = TRUE;
        $this->pagination->initialize($config);
		//echo " Punto B ";
		//echo " Punto ".$emp_id;
		$data['clientes'] = $this->cliente->get_allo_a($rows,$emp_id,get_sucursal_id(),$user_despacho,$user_cei,$user_root1,1);
		
		//echo " Punto C ";
		//echo " Punto D ";
		//echo " Punto E ";
        
        $this->load->helper('template');
        $params_view = array(
            'title' => 'Personas',
            'view' => 'persona/index_a',
            'view_data' => $data 
           );
        render_template($params_view);  
    }
/*************************************************************************************/
    public function lista_b()
    {   
	    //echo " Punto A ";
		$suc=get_sucursal_id();
		$user_despacho=get_desp_id_usr();
		$user_cei=get_cei_id();
		$user_root1=get_my_user_root1();
		$user = $this->session->user; 
		$medico = $this->medico->get($user['usr_id']);
		$emp_id=$user['emp_id'];
        $rows = 30;
        $this->load->library('pagination');
        $config['base_url'] = base_url('persona/lista_b/');
        //$config['total_rows'] = $this->cliente->count_all();
		$config['total_rows'] = $this->cliente->count_allo_b($emp_id,$suc,$user_despacho,$user_cei,$user_root1,1);
        
		$config['per_page'] = $rows;
        $config['attributes'] = array('class' => 'pagination');
        $config['full_tag_open'] = '<div class="pagination-full">';
        $config['full_tag_close'] = '</div>';
        $config['uri_segment'] = 3;
        $config['query_string_segment'] = 4;
        $config['use_page_numbers'] = TRUE;
        $this->pagination->initialize($config);
		//echo " Punto B ";
		//echo " Punto ".$emp_id;
		$data['clientes'] = $this->cliente->get_allo_b($rows,$emp_id,get_sucursal_id(),$user_despacho,$user_cei,$user_root1,1);
		
		//echo " Punto C ";
		//echo " Punto D ";
		//echo " Punto E ";
        
        $this->load->helper('template');
        $params_view = array(
            'title' => 'Personas',
            'view' => 'persona/index_b',
            'view_data' => $data 
           );
        render_template($params_view);  
    }


    public function nuevo_externo()
    {    
		$user = $this->session->user; 
		$medico = $this->medico->get($user['usr_id']);
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('nombre','Nombre','required');
            $this->form_validation->set_rules('paterno','Apellido Paterno','required');
            $this->form_validation->set_rules('materno','Apellido Materno','required');
            $this->form_validation->set_rules('fnac','Fecha de nacimiento','required');
            $this->form_validation->set_rules('genero','Género','required');
			$this->form_validation->set_rules('empresa_original','Empresa','required');

            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_nombre_crypt'] =  trim($this->input->post('nombre'));
                $data_clte['clte_2_nombre_crypt'] =  trim($this->input->post('nombre_adic'));
                $data_clte['clte_paterno_crypt'] =  trim($this->input->post('paterno'));
                $data_clte['clte_materno_crypt'] =  trim($this->input->post('materno'));
                
				$data_clte['clte_f_nac'] = formatea_fecha_mysql($this->input->post('fnac'));
                $data_clte['clte_genero_cve'] =  $this->input->post('genero');      				
				$data_clte['clte_rfc_crypt'] =  $this->input->post('rfc');                				
				$data_clte['clte_curp_crypt'] = $this->input->post('curp');
				$data_clte['clte_nss_crypt'] =  $this->input->post('nss');
                $data_clte['clte_grado_acad_cve'] =  $this->input->post('grado');
                $data_clte['clte_edo_civ_cve'] =  $this->input->post('civil');
                $data_clte['clte_nac_cve'] =  $this->input->post('nac');				
			                
                $data_clte['emp_id'] =$this->input->post('empresa');//$medico['usr_emp_asig'];
                $data_clte['clte_puesto'] = $this->input->post('puesto');
				$data_clte['num_empleado'] = $this->input->post('nempleado');
				
                $data_clte['suc_id'] =0;
				$data_clte['cei_id'] =  $medico['cei_id'];
				$data_clte['area_depto'] = $this->input->post('empresa_original');
				$data_clte['empleado'] = 1;
				$data_clte['empleado_rol'] = 0;
				$data_clte['f_ingreso'] = formatea_fecha_mysql($this->input->post('f_ingreso'));
			
				$nomserv='';
				$data_clte['nomserv'] =  $nomserv;

 /***************************** CARGA DE LA FOTO DEL EVALUADO ************************/               
                if(!empty($_FILES['foto']['name']))
                {
                    $this->load->library('upload');
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/fotos/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg',
                            'max_size'      => '25000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('foto'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['clte_path_foto'] = $data['file_name'];
                    }
                }
/*************************************************************************************/
				$data_clte=array_to_upper($data_clte);
				$data_clte['clte_email_crypt'] =  $this->input->post('correo');
				if ($cliente_id = $this->cliente->inserta($data_clte))
                {
                    send_json_ok(array('msg' =>'Se guardó de forma correcta', 'id' => $cliente_id));
                    
                }
                else
                {
                    send_json_error('Ocurrió un error al guardar la persona.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $this->load->model('empresa/Empresa_model','empresa');
            //$data['empresas'] = $this->empresa->get_all_empresas();
			$data['empresas'] =$this->empresa->get_all_empresas_gsi();
			$data['sucursals'] = $this->empresa->get_all_sucursales();
			//$data['despachos'] = $this->empresa->get_all_despachos();
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'persona/add_externo',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }

   public function nuevo_empleado()
    {    
		$user = $this->session->user; 
		$medico = $this->medico->get($user['usr_id']);
		
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('nombre','Nombre','required');
            $this->form_validation->set_rules('paterno','Apellido Paterno','required');
            $this->form_validation->set_rules('materno','Apellido Materno','required');
            $this->form_validation->set_rules('fnac','Fecha de nacimiento','required');
            $this->form_validation->set_rules('genero','Género','required');

            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_nombre_crypt'] =  trim($this->input->post('nombre'));
                $data_clte['clte_2_nombre_crypt'] =  trim($this->input->post('nombre_adic'));
                $data_clte['clte_paterno_crypt'] =  trim($this->input->post('paterno'));
                $data_clte['clte_materno_crypt'] =  trim($this->input->post('materno'));
                
				$data_clte['clte_f_nac'] = formatea_fecha_mysql($this->input->post('fnac'));
                $data_clte['clte_genero_cve'] =  $this->input->post('genero');      				
				$data_clte['clte_rfc_crypt'] =  $this->input->post('rfc');                				
				$data_clte['clte_curp_crypt'] = $this->input->post('curp');
				$data_clte['clte_nss_crypt'] =  $this->input->post('nss');
                $data_clte['clte_grado_acad_cve'] =  $this->input->post('grado');
                $data_clte['clte_edo_civ_cve'] =  $this->input->post('civil');
                $data_clte['clte_nac_cve'] =  $this->input->post('nac');				
				
                $data_clte['empleado'] = 1;
                
                
				
				
                $data_clte['clte_puesto'] = $this->input->post('puesto');
				$data_clte['num_empleado'] = $this->input->post('nempleado');
				
				$data_clte['emp_id'] =$medico['emp_id'];
                $data_clte['suc_id'] =0;
				$data_clte['cei_id'] =$medico['cei_id'];
				$data_clte['empleado_rol'] =  1;
				
				$nomserv='';
				if ( $data_clte['emp_id'] == 293)
				{ $nomserv='ISOAM;ISOACC;ISOEXP;ISOINC;ISOEXI;';}
				elseif ( $data_clte['emp_id'] == 429)
				{$nomserv='ACRED;ALCOHOL;BIOHEM;ORINA;GPOSAN;HBA1C;QS6;HIV;ISOEXMESAOC;PSIC;PPSM16PF;BENDER;PRPRO;REPSIC;TOXI;';} 
				$data_clte['nomserv'] =  $nomserv;

 /***************************** CARGA DE LA FOTO DEL EVALUADO               
                if(!empty($_FILES['foto']['name']))
                {
                    $this->load->library('upload');
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/fotos/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg',
                            'max_size'      => '25000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('foto'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['clte_path_foto'] = $data['file_name'];
                    }
                }
***********************************/
				$data_clte=array_to_upper($data_clte);
				$data_clte['clte_email_crypt'] =  $this->input->post('correo');
				if ($cliente_id = $this->cliente->inserta($data_clte))
                {
					
					if (strstr($medico['portal'],'TRANSPOR;')) 
					{
						
						$data_serv['serv_orden'] = $data_clte['clte_nombre_crypt'].' '.$data_clte['clte_2_nombre_crypt'].' '.$data_clte['clte_paterno_crypt'].' '.$data_clte['clte_materno_crypt'].' - '.$cliente_id;
						$data_serv['emp_id'] = $data_clte['emp_id'];
						$data_serv['usr_id'] = $medico['usr_id'];
						
						$date_now = date('Y-m-d H:i:s');
						$date_future = strtotime('+30 day', strtotime($date_now));
						$date_future = date('Y-m-d H:i:s', $date_future);
						$data_serv['serv_f_inicio'] = $date_now; 
						$data_serv['serv_f_fin'] = $date_future;
						$data_serv['cei_id'] = 2;
						$data_serv['cei_control_id'] = 2;
						$data_serv['serv_desc'] = $data_serv['serv_orden'].'-'.get_empresa($medico['emp_id']);
						$data_serv['serv_contacto_per'] = $medico['usr_nombre'].' '.$medico['usr_paterno'].' '.$medico['usr_materno'] ;
					/*	
						$data_serv['serv_ubicacion'] = $this->input->post('ubicacion');
						$data_serv['serv_contacto_per'] = $this->input->post('responsable');
						$data_serv['serv_contacto_tel'] = limpia_telefono($this->input->post('telefono'));
						$data_serv['serv_acuerdos'] = $this->input->post('clausulas');
						$data_serv['serv_viaticos'] = $this->input->post('viaticos');
				        $data_serv['serv_costo_viaticos'] = $this->input->post('gastos_operacion');
						*/
						$data_serv['serv_estatus_cve'] = 'PROCESO';
						
						$data_serv=array_to_upper($data_serv);
						
						
						$hay_examenes =0;
						
						$cuantos_examnes_evaluados = count(explode(";", $nomserv));
					
						/*
						$total_examenes_selectos= $cuantos_examnes_evalaudos;	
						$fsm_pakts= get_costos_paquetes_empresa($data_clte['emp_id']);
						if($fsm_pakts):
							foreach($fsm_pakts as $fsm_pakt):										
									for($i=1; $i <= $total_examenes_selectos; $i++)
									{	
										$indice='examen_select_pkt_'.strval($i);
										$paquetes= $this->input->post($indice);	
												
										if ( $fsm_pakt['cost_nombre_pkt'] === $paquetes)
										{
											$hay_examenes++;
										}
									}	
							endforeach;
						endif;					
					     */
						if ($cuantos_examnes_evaluados >0)
						{	
							$serv_id = $this->servicio->inserta($data_serv);
						}
						
						
						
						$total_examenes_selectos= $cuantos_examnes_evaluados;	
						$fsm_pakts= get_costos_paquetes_empresa($data_clte['emp_id']);
						if($fsm_pakts):
							foreach($fsm_pakts as $fsm_pakt):										
									//for($i=1; $i <= $total_examenes_selectos; $i++)
									{									
										//$indice='examen_select_pkt_'.strval($i);
										//$paquetes= $this->input->post($indice);	
												
										//if ( $fsm_pakt['cost_nombre_pkt'] === $paquetes)
										{
											$examen_ins['exam_nombre_pkt'] = $fsm_pakt['cost_nombre_pkt']; //nombre del paquete
											$examen_ins['serv_id'] = $serv_id;
											$examen_ins['exam_cve'] = $fsm_pakt['cost_examen_cve']; //lo que contiene el paquete
											$examen_ins['exam_monto'] = $fsm_pakt['cost_monto']; //lo que contiene el paquete								 	 
											$examen_ins['exam_cantidad'] = (count(explode(";", $fsm_pakt['cost_examen_cve']))-1);;
											$examen_ins['exam_estatus_cve'] = 'PEND';
											$examen_ins['exam_tipo_pkt'] = $fsm_pakt['cost_tipo_pkt'];
											$this->servicio->inserta_examen($examen_ins);											
										}							
									}	
							endforeach;
						endif;	
						$data_clte_1['serv_id']= $serv_id;	
						$this->cliente->actualiza($cliente_id, $data_clte_1);	
					
					}		
										
					
                    send_json_ok(array('msg' =>'Se guardó de forma correcta', 'id' => $cliente_id));
                    
                }
                else
                {
                    send_json_error('Ocurrió un error al guardar la persona.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $this->load->model('empresa/Empresa_model','empresa');
            //$data['empresas'] = $this->empresa->get_all_empresas();
			$data['empresas'] =$this->empresa->get_all_empresas_gsi();
			$data['sucursals'] = $this->empresa->get_all_sucursales();
			//$data['despachos'] = $this->empresa->get_all_despachos();
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'persona/add_empleado',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }



    public function nuevo_e()
    {    
		$user = $this->session->user; 
		$medico = $this->medico->get($user['usr_id']);
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('nombre','Nombre','required');
            $this->form_validation->set_rules('paterno','Apellido Paterno','required');
            $this->form_validation->set_rules('materno','Apellido Materno','required');
            $this->form_validation->set_rules('fnac','Fecha de nacimiento','required');
            $this->form_validation->set_rules('genero','Género','required');

            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_nombre_crypt'] =  trim($this->input->post('nombre'));
                $data_clte['clte_2_nombre_crypt'] =  trim($this->input->post('nombre_adic'));
                $data_clte['clte_paterno_crypt'] =  trim($this->input->post('paterno'));
                $data_clte['clte_materno_crypt'] =  trim($this->input->post('materno'));
                
				$data_clte['clte_f_nac'] = formatea_fecha_mysql($this->input->post('fnac'));
                $data_clte['clte_genero_cve'] =  $this->input->post('genero');      				
				$data_clte['clte_rfc_crypt'] =  $this->input->post('rfc');                				
				$data_clte['clte_curp_crypt'] = $this->input->post('curp');
				$data_clte['clte_nss_crypt'] =  $this->input->post('nss');
                $data_clte['clte_grado_acad_cve'] =  $this->input->post('grado');
                $data_clte['clte_edo_civ_cve'] =  $this->input->post('civil');
                $data_clte['clte_nac_cve'] =  $this->input->post('nac');				
				
                $data_clte['empleado'] = 1;
                
                $data_clte['emp_id'] =$this->input->post('empresa');//$medico['usr_emp_asig'];
                $data_clte['clte_puesto'] = $this->input->post('puesto');
				$data_clte['num_empleado'] = $this->input->post('nempleado');
				
				//sucursal
                $data_clte['suc_id'] =0;
				$data_clte['cei_id'] =  4;

				$nomserv='NOM0351;NOM0352;NOM0353;';
				$data_clte['nomserv'] =  $nomserv;

 /***************************** CARGA DE LA FOTO DEL EVALUADO ************************/               
                if(!empty($_FILES['foto']['name']))
                {
                    $this->load->library('upload');
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/fotos/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg',
                            'max_size'      => '25000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('foto'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['clte_path_foto'] = $data['file_name'];
                    }
                }
/*************************************************************************************/
				$data_clte=array_to_upper($data_clte);
				$data_clte['clte_email_crypt'] =  $this->input->post('correo');
				if ($cliente_id = $this->cliente->inserta($data_clte))
                {
                    send_json_ok(array('msg' =>'Se guardó de forma correcta', 'id' => $cliente_id));
                    
                }
                else
                {
                    send_json_error('Ocurrió un error al guardar la persona.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $this->load->model('empresa/Empresa_model','empresa');
            //$data['empresas'] = $this->empresa->get_all_empresas();
			$data['empresas'] =$this->empresa->get_all_empresas_gsi();
			$data['sucursals'] = $this->empresa->get_all_sucursales();
			//$data['despachos'] = $this->empresa->get_all_despachos();
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'persona/add_e',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }

/*************************************************************************************/	
    function busca_bajas()
    {   
		$user = $this->session->user;
		$despacho=get_desp_id_usr();
		$emp_id_user=get_emp_id();
		$roots=get_my_user_root2();    
        $empresa = $emp_id_user; //$this->input->post('empresa');
        $nombre  = strtoupper($this->input->post('nombre'));
		$nombre2 = strtoupper($this->input->post('nombre2'));
		
		$empleado =	strtoupper($this->input->post('empleado'));
		$receta=	strtoupper($this->input->post('receta'));
		$paterno  = strtoupper($this->input->post('paterno'));
		$materno  = strtoupper($this->input->post('materno'));
		
        $data['clientes'] = $this->cliente->busca_swb($empresa, $nombre, $nombre2,$paterno, $materno, $empleado, $receta,$despacho,$emp_id_user);	

		send_json_ok($this->load->view('persona/busca_swb',$data,TRUE));
    }



    function busca_swb()
    {   
		$user = $this->session->user;
		$despacho=get_desp_id_usr();
		$emp_id_user=get_emp_id();
		$roots=get_my_user_root2();    
        $empresa = 253;//$emp_id_user; //$this->input->post('empresa');
        $nombre  = strtoupper($this->input->post('nombre'));
		$nombre2 = strtoupper($this->input->post('nombre2'));
		
		$empleado =	strtoupper($this->input->post('empleado'));
		$receta=	strtoupper($this->input->post('receta'));
		$paterno  = strtoupper($this->input->post('paterno'));
		$materno  = strtoupper($this->input->post('materno'));
		
        $data['clientes'] = $this->cliente->busca_swb($empresa, $nombre, $nombre2,$paterno, $materno, $empleado, $receta,$despacho,$emp_id_user);	

		send_json_ok($this->load->view('persona/busca_swb',$data,TRUE));
    }    

/*************************************************************************************/	
    function busca_empleado()
    {   
		$user = $this->session->user;
		$despacho=get_desp_id_usr();
		$emp_id_user=get_emp_id();
		$roots=get_my_user_root2();    
        
		$empresa=$user['emp_id']; 
		
		$empleado =	strtoupper($this->input->post('empleado'));
		$receta=	strtoupper($this->input->post('receta'));
	
        $nombre  = strtoupper($this->input->post('nombre'));
		$nombre2 = strtoupper($this->input->post('nombre2'));
		
		$paterno  = strtoupper($this->input->post('paterno'));
		$materno  = strtoupper($this->input->post('materno'));
		
        $data['clientes'] = $this->cliente->busca_empleado($empresa, $nombre, $nombre2,$paterno, $materno, $empleado, $receta);	

		send_json_ok($this->load->view('persona/busca_empleado',$data,TRUE));
    }

/*************************************************************************************/	
    function busca_colaboradores()
    {   
		$user = $this->session->user;
		$emp_id_user=get_emp_id();
        
		$empresa=$user['emp_id']; 
		$empleado =	strtoupper($this->input->post('empleado'));
		$receta=	strtoupper($this->input->post('receta'));
	
        $nombre  = strtoupper($this->input->post('nombre'));
		$nombre2 = strtoupper($this->input->post('nombre2'));
		$paterno  = strtoupper($this->input->post('paterno'));
		$materno  = strtoupper($this->input->post('materno'));
		
        $data['clientes'] = $this->cliente->busca_colaborador($empresa, $nombre, $nombre2,$paterno, $materno, $empleado, $receta);	

		send_json_ok($this->load->view('persona/busca_colaborador',$data,TRUE));
    }



    function busca_sw()
    {   
		$user = $this->session->user;
		$despacho=get_desp_id_usr();
		$emp_id_user=get_emp_id();
		$roots=get_my_user_root2();    
        $empresa = $emp_id_user; //$this->input->post('empresa');
		$empresa=253; 
		$empleado =	strtoupper($this->input->post('empleado'));
		$receta=	strtoupper($this->input->post('receta'));
	
        $nombre  = strtoupper($this->input->post('nombre'));
		$nombre2 = strtoupper($this->input->post('nombre2'));
		
		$paterno  = strtoupper($this->input->post('paterno'));
		$materno  = strtoupper($this->input->post('materno'));
		
        $data['clientes'] = $this->cliente->busca_sw($empresa, $nombre, $nombre2,$paterno, $materno, $empleado, $receta);	

		send_json_ok($this->load->view('persona/busca_sw',$data,TRUE));
    }    

/*************************************************************************************/	
    function busca_empleados_ext()
    {   
		$user = $this->session->user;
		$despacho=get_desp_id_usr();
		$emp_id_user=get_emp_id();
		$roots=get_my_user_root2();    
        $empresa = $emp_id_user; //$this->input->post('empresa');
        $nombre  = strtoupper($this->input->post('nombre'));
		$nombre2 = strtoupper($this->input->post('nombre2'));
		
		$empleado =	strtoupper($this->input->post('empleado'));
		$receta=	strtoupper($this->input->post('receta'));
		$paterno  = strtoupper($this->input->post('paterno'));
		$materno  = strtoupper($this->input->post('materno'));
		
        $data['clientes'] = $this->cliente->busca_empleados_ext($empresa, $nombre, $nombre2,$paterno, $materno, $empleado, $receta,$despacho,$emp_id_user);	

		send_json_ok($this->load->view('persona/busca_empleados_ext',$data,TRUE));
    } 



/*************************************************************************************/	
    function busca_swe()
    {   
		$user = $this->session->user;
		$despacho=get_desp_id_usr();
		$emp_id_user=get_emp_id();
		$roots=get_my_user_root2();    
        $empresa = $emp_id_user; //$this->input->post('empresa');
        $nombre  = strtoupper($this->input->post('nombre'));
		$nombre2 = strtoupper($this->input->post('nombre2'));
		
		$empleado =	strtoupper($this->input->post('empleado'));
		$receta=	strtoupper($this->input->post('receta'));
		$paterno  = strtoupper($this->input->post('paterno'));
		$materno  = strtoupper($this->input->post('materno'));
		
        $data['clientes'] = $this->cliente->busca_swe($empresa, $nombre, $nombre2,$paterno, $materno, $empleado, $receta,$despacho,$emp_id_user);	

		send_json_ok($this->load->view('persona/busca_swe',$data,TRUE));
    } 



   function busca_enom()
    {   
		$user = $this->session->user;
		$usuario = $this->medico->get($user['usr_id']);
		$despacho=get_desp_id_usr();
		$emp_id_user=get_emp_id();
		$roots=get_my_user_root2();    
        $empresa = $emp_id_user; 
        $nombre  = strtoupper($this->input->post('nombre'));
		$nombre2 = strtoupper($this->input->post('nombre2'));
		
		$empleado =	strtoupper($this->input->post('empleado'));
		$receta=	strtoupper($this->input->post('receta'));
		$paterno  = strtoupper($this->input->post('paterno'));
		$materno  = strtoupper($this->input->post('materno'));
		$data['clientes'] = $this->cliente->busca_enom($empresa, $nombre, $nombre2,$paterno, $materno, $empleado, $receta,$despacho,$emp_id_user);	
		send_json_ok($this->load->view('persona/busca_enom',$data,TRUE));

		
    } 

   function busca_e() /*BUSCARDOR DE HC*/
    {   
		$user = $this->session->user;
		$usuario = $this->medico->get($user['usr_id']);
		$despacho=get_desp_id_usr();
		$emp_id_user=get_emp_id();
		$roots=get_my_user_root2();    
        $empresa = $emp_id_user; //$this->input->post('empresa');
        $nombre  = strtoupper($this->input->post('nombre'));
		$nombre2 = strtoupper($this->input->post('nombre2'));
		
		$empleado =	strtoupper($this->input->post('empleado'));
		$receta=	strtoupper($this->input->post('receta'));
		$paterno  = strtoupper($this->input->post('paterno'));
		$materno  = strtoupper($this->input->post('materno'));
		if ( strstr($usuario['modulos'],'HCRHGSI') )
		{
			$data['clientes'] = $this->cliente->busca_empleados_hc_gsi_medicos($empresa, $nombre, $nombre2,$paterno, $materno);
		}
		elseif ($user['usr_id'] == 482)
		{
			$data['clientes'] = $this->cliente->busca_m($empresa, $nombre, $nombre2,$paterno, $materno, $empleado, $receta,$despacho,$emp_id_user);
        }
		else
		{
			$data['clientes'] = $this->cliente->busca_e($empresa, $nombre, $nombre2,$paterno, $materno, $empleado, $receta,$despacho,$emp_id_user);	
		}
		
		if ( strstr($usuario['modulos'],'HCRHGSI') )
		{
			send_json_ok($this->load->view('persona/busca_empleados_hc_gsi',$data,TRUE));
		}
		else
		{	
			send_json_ok($this->load->view('persona/busca_e',$data,TRUE));
		}
		
    } 

 /*************************************************************************************/	
    function busca_a()
    {   $despacho=get_desp_id_usr();
		$emp_id_user=get_emp_id();
		$roots=get_my_user_root2();    
        $empresa = $emp_id_user; //$this->input->post('empresa');
        $nombre  = strtoupper($this->input->post('nombre'));
		$nombre2 = strtoupper($this->input->post('nombre2'));
		$paterno  = strtoupper($this->input->post('paterno'));
		$materno  = strtoupper($this->input->post('materno'));
		
		
        $data['clientes'] = $this->cliente->busca_a($empresa, $nombre, $nombre2,$paterno, $materno);
        
		send_json_ok($this->load->view('persona/busca_a',$data,TRUE));
    } 
	
	
    public function borra_comentario($fsm_id)
    {
        if($this->cliente->borrar_comentario($fsm_id))
        {
            send_json_ok('Se eliminó de forma correcta.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar.');
        }
    }	


    public function borra_documento_ALCOSA($fsm_id)
    {
		$documento=$this->cliente->get_doc($fsm_id);
		
		$doc_borra['clte_id']=$documento['clte_id'];
		$doc_borra['doc_nombre']=$documento['doc_nombre'];
		$doc_borra['doc_path']=strtolower($documento['doc_path']);
		$doc_borra['doc_f']=$documento['doc_f'];
		$doc_borra['empresa']='ALCOSA';
		$doc_borra['doc_fecha_efectiva']=date();
		
		$this->cliente->inserta_borrado($doc_borra);
        if($this->cliente->delete_doc_ALCOSA($fsm_id))
        {
            send_json_ok('Se eliminó de forma correcta.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar.');
        }
    }

    public function borra_documento_ANTICUA($fsm_id)
    {
		$documento=$this->cliente->get_doc($fsm_id);
		
		$doc_borra['clte_id']=$documento['clte_id'];
		$doc_borra['doc_nombre']=$documento['doc_nombre'];
		$doc_borra['doc_path']=strtolower($documento['doc_path']);
		$doc_borra['doc_f']=$documento['doc_f'];
		$doc_borra['empresa']='ANTICUA';
		$doc_borra['doc_fecha_efectiva']=date();
		
		$this->cliente->inserta_borrado($doc_borra);
        if($this->cliente->delete_doc_ANTICUA($fsm_id))
        {
            send_json_ok('Se eliminó de forma correcta.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar.');
        }
    }


    public function borra_documento_TORAX($fsm_id)
    {
		$documento=$this->cliente->get_doc($fsm_id);
		
		$doc_borra['clte_id']=$documento['clte_id'];
		$doc_borra['doc_nombre']=$documento['doc_nombre'];
		$doc_borra['doc_path']=strtolower($documento['doc_path']);
		$doc_borra['doc_f']=$documento['doc_f'];
		$doc_borra['empresa']='TORAX';
		$doc_borra['doc_fecha_efectiva']=date();
		
		$this->cliente->inserta_borrado($doc_borra);
        if($this->cliente->delete_doc_TORAX($fsm_id))
        {
            send_json_ok('Se eliminó de forma correcta.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar.');
        }
    }

    public function borra_documento_RADIOL($fsm_id)
    {
		$documento=$this->cliente->get_doc($fsm_id);
		
		$doc_borra['clte_id']=$documento['clte_id'];
		$doc_borra['doc_nombre']=$documento['doc_nombre'];
		$doc_borra['doc_path']=strtolower($documento['doc_path']);
		$doc_borra['doc_f']=$documento['doc_f'];
		$doc_borra['empresa']='EVALUADOS';
		$doc_borra['doc_fecha_efectiva']=date();
		
		$this->cliente->inserta_borrado($doc_borra);
        if($this->cliente->delete_doc_RADIOL($fsm_id))
        {
            send_json_ok('Se eliminó de forma correcta.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar.');
        }
    }


    public function borra_documento_RADIOT($fsm_id)
    {
		$documento=$this->cliente->get_doc($fsm_id);
		
		$doc_borra['clte_id']=$documento['clte_id'];
		$doc_borra['doc_nombre']=$documento['doc_nombre'];
		$doc_borra['doc_path']=strtolower($documento['doc_path']);
		$doc_borra['doc_f']=$documento['doc_f'];
		$doc_borra['empresa']='EVALUADOS';
		$doc_borra['doc_fecha_efectiva']=date();
		
		$this->cliente->inserta_borrado($doc_borra);
        if($this->cliente->delete_doc_RADIOT($fsm_id))
        {
            send_json_ok('Se eliminó de forma correcta.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar.');
        }
    }

    public function borra_documento_PCR($fsm_id)
    {
		$documento=$this->cliente->get_doc($fsm_id);
		
		$doc_borra['clte_id']=$documento['clte_id'];
		$doc_borra['doc_nombre']=$documento['doc_nombre'];
		$doc_borra['doc_path']=strtolower($documento['doc_path']);
		$doc_borra['doc_f']=$documento['doc_f'];
		$doc_borra['empresa']='EVALUADOS';
		$doc_borra['doc_fecha_efectiva']=date();
		
		$this->cliente->inserta_borrado($doc_borra);
        if($this->cliente->delete_doc_PCR($fsm_id))
        {
            send_json_ok('Se eliminó de forma correcta.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar.');
        }
    }


    public function borra_documento_AUDIO($fsm_id)
    {
		$documento=$this->cliente->get_doc_AUDIO($fsm_id);
		
		$doc_borra['clte_id']=$documento['clte_id'];
		$doc_borra['doc_nombre']=$documento['doc_nombre'];
		$doc_borra['doc_path']=strtolower($documento['doc_path']);
		$doc_borra['doc_f']=$documento['doc_f'];
		$doc_borra['empresa']='EVALUADOS';
		$doc_borra['doc_fecha_efectiva']=date();
		
		$this->cliente->inserta_borrado($doc_borra);
        if($this->cliente->delete_doc_AUDIO($fsm_id))
        {
            send_json_ok('Se eliminó de forma correcta.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar.');
        }
    }

    public function borra_documento_SPIRO($fsm_id)
    {
		$documento=$this->cliente->get_doc_SPIRO($fsm_id);
		
		$doc_borra['clte_id']=$documento['clte_id'];
		$doc_borra['doc_nombre']=$documento['doc_nombre'];
		$doc_borra['doc_path']=strtolower($documento['doc_path']);
		$doc_borra['doc_f']=$documento['doc_f'];
		$doc_borra['empresa']='EVALUADOS';
		$doc_borra['doc_fecha_efectiva']=date();
		
		$this->cliente->inserta_borrado($doc_borra);
        if($this->cliente->delete_doc_SPIRO($fsm_id))
        {
            send_json_ok('Se eliminó de forma correcta.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar.');
        }
    }

    public function borra_documento_hc($fsm_id)
    {
		$documento=$this->cliente->get_doc_hc($fsm_id);
		
		$doc_borra['clte_id']=$documento['clte_id'];
		$doc_borra['doc_nombre']=$documento['doc_nombre'];
		$doc_borra['doc_path']=strtolower($documento['doc_path']);
		$doc_borra['doc_f']=$documento['doc_f'];
		$doc_borra['empresa']='EVALUADOS';
		$doc_borra['doc_fecha_efectiva']=date();
		
		$this->cliente->inserta_borrado($doc_borra);
        if($this->cliente->delete_doc_hc($fsm_id))
        {
            send_json_ok('Se eliminó de forma correcta.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar.');
        }
    }

	
    public function borra_documento($fsm_id)
    {
		$documento=$this->cliente->get_doc($fsm_id);
		
		$doc_borra['clte_id']=$documento['clte_id'];
		$doc_borra['doc_nombre']=$documento['doc_nombre'];
		$doc_borra['doc_path']=strtolower($documento['doc_path']);
		$doc_borra['doc_f']=$documento['doc_f'];
		$doc_borra['empresa']='EVALUADOS';
		$doc_borra['doc_fecha_efectiva']=date();
		
		$this->cliente->inserta_borrado($doc_borra);
        if($this->cliente->delete_doc($fsm_id))
        {
            send_json_ok('Se eliminó de forma correcta.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar.');
        }
    }

    public function borra_documento_gen($fsm_id)
    {
		$documento=$this->cliente->get_doc($fsm_id);
		
		$doc_borra['clte_id']=$documento['clte_id'];
		$doc_borra['doc_nombre']=$documento['doc_nombre'];
		$doc_borra['doc_path']=strtolower($documento['doc_path']);
		$doc_borra['doc_f']=$documento['doc_f'];
		$doc_borra['empresa']='EVALUADOS';
		$doc_borra['doc_fecha_efectiva']=date();
		
		$this->cliente->inserta_borrado($doc_borra);
        if($this->cliente->delete_doc_gen($fsm_id))
        {
            send_json_ok('Se eliminó de forma correcta.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar.');
        }
    }


    public function edita_g_gen($fsm_id,$cliente_id)
    {           
		$cliente = $this->cliente->get($cliente_id);		
		$documento=$this->cliente->get_doc_gen($fsm_id);         
		
        if($documento)
        {

            if(isset($_POST) && count($_POST) > 0)     
            {
                $this->load->library('form_validation');
                $this->form_validation->set_rules('nuevo_nombre','Nuevo Nombre del Archivo','required');


                if($this->form_validation->run())
                {

                    $data_clte['doc_nombre'] =  trim($this->input->post('nuevo_nombre'));
					
					if($this->cliente->actualiza_nombre_doc_gen($fsm_id, array_to_upper($data_clte)))
					{
						send_json_ok(array('msg' =>'Se actualizado el Nombre del Archivo.', 'id' => $cliente_id));
					}
					else
					{
						send_json_error('Ocurrió un error al actualizar el nuevo nombre.');
					}
                }
                else
                {
                    send_json_error(validation_errors('<div />'));
                }
            }
            else 
            {

                $data['persona'] = 	$cliente;
				$data['documento'] = 	$documento;
				

                $this->load->helper('template');
                $params_view = array(
                    'title' => 'Personas',
                    'view' => 'persona/edit_g_gen',
                    'view_data' => $data
                   );
                render_template($params_view);  
            }
        }
        else 
        {
            show_error('No existe el registro');
        }
    }


    public function edita_g($fsm_id,$cliente_id)
    {           
		$cliente = $this->cliente->get($cliente_id);		
		$documento=$this->cliente->get_doc($fsm_id);         
		
        if($documento)
        {

            if(isset($_POST) && count($_POST) > 0)     
            {
                $this->load->library('form_validation');
                $this->form_validation->set_rules('nuevo_nombre','Nuevo Nombre del Archivo','required');


                if($this->form_validation->run())
                {

                    $data_clte['doc_nombre'] =  trim($this->input->post('nuevo_nombre'));
					
					if($this->cliente->actualiza_nombre_doc($fsm_id, array_to_upper($data_clte)))
					{
						send_json_ok(array('msg' =>'Se actualizado el Nombre del Archivo.', 'id' => $cliente_id));
					}
					else
					{
						send_json_error('Ocurrió un error al actualizar el nuevo nombre.');
					}
                }
                else
                {
                    send_json_error(validation_errors('<div />'));
                }
            }
            else 
            {

                $data['persona'] = 	$cliente;
				$data['documento'] = 	$documento;
				

                $this->load->helper('template');
                $params_view = array(
                    'title' => 'Personas',
                    'view' => 'persona/edit_g',
                    'view_data' => $data
                   );
                render_template($params_view);  
            }
        }
        else 
        {
            show_error('No existe el registro');
        }
    }
	
 
}