<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Discapacidad extends CI_Controller {
    
        function __construct() {
            parent::__construct();
            $this->load->model('cat/Catalogo_model','cat');
        }
        
        function index()
        {
            $this->load->helper('template');
            $this->load->model('mkt/Mkt_model','mkt');
                
            $camps['todo'] = $this->mkt->get_camp_all();
            $camps['abn'] = $this->mkt->get_camp_abn();
            
            $params_view = array(
                            'title' => 'MiConsultorio.Digital',
                            'view' => 'catalogos/discaps_view',
                            'mkt' => $camps
                           );
            render_template($params_view);
        }
        
        function modal()
        {
            $data_cat['title_modal'] = 'Catálogo de discapacidades (CIE-9)';
            $data_cat['discaps'] = $this->cat->get_discaps();
            $view = $this->load->view('catalogos/discaps_modal_view',$data_cat,TRUE);
            send_json_ok($view);
        }
        
        public function busca_discap()
	{
            $term = $this->input->get('term');
            $discaps = $this->cat->busca_discap($term);
            $discaps_formated = array();
            foreach ($discaps as $discap) {
                $discaps_formated[] = array('label' => mb_strtoupper($discap['discap_cve'].' - '.$discap['discap_descrip']),'value' => $discap['discap_cve']);
            }
            echo json_encode($discaps_formated);
	}
        
        public function id($discap_id)
        {
            $cie['cie'] = $this->cat->get_discap($discap_id);
            if($cie)
            {
                send_json_ok($this->load->view('catalogos/cie_view',$cie,TRUE));
            }   
            else
            {
                send_json_error('No existe');
            }
        }
            
        public function busca_discapacidad_L($nivel)
	{
            $discap_cve = $this->uri->segment(5);
            $discaps = $this->cat->busca_discap_L($discap_cve, $nivel);
            if($discaps)
            {
                $discaps_formated = array();
                foreach ($discaps as $discap) {
                    $discaps_formated[] = array('label' => mb_strtoupper($discap['discap_cve'].' - '.$discap['discap_descrip']),'value' => $discap['discap_cve'],'clave' => $discap['discap_cve']);
                }
                send_json_ok($discaps_formated);
            }
            else
            {
                send_json_error('vacio');
            }
	}
}