<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Procedimiento extends CI_Controller {
    
        function __construct() {
            parent::__construct();
            $this->load->model('cat/Catalogo_model','cat');
        }
        
        function index()
        {
            $data_view['caps'] = $this->cat->get_proc_cap();
            $this->load->helper('template');
            $this->load->model('mkt/Mkt_model','mkt');
                
            $camps['todo'] = $this->mkt->get_camp_all();
            $camps['abn'] = $this->mkt->get_camp_abn();
            
            $params_view = array(
                            'title' => 'MiConsultorio.Digital',
                            'view' => 'catalogos/procs_view',
                            'mkt' => $camps,
                            'view_data' => $data_view
                           );
            render_template($params_view);
        }
        
        function modal()
        {
            $data_cat['caps'] = $this->cat->get_proc_cap();
            $data_cat['title_modal'] = 'Procedimientos (Catálogo CIE9)';
            $view = $this->load->view('catalogos/procs_modal_view',$data_cat,TRUE);
            send_json_ok($view);
        }
        
        public function nivel_3()
        {
            $nivel_4 = $this->uri->segment(4);
            send_json_ok($this->cat->get_proc_nivel_3($nivel_4));
        }
        
        public function nivel_2()
        {
            $nivel_4 = $this->uri->segment(4);
            $nivel_3 = $this->uri->segment(5);
            send_json_ok($this->cat->get_proc_nivel_2($nivel_4, $nivel_3));
        }
        
        public function nivel_1()
        {
            $nivel_4 = $this->uri->segment(4);
            //$nivel_3 = $this->uri->segment(5);
            $nivel_2 = $this->uri->segment(5);
            send_json_ok($this->cat->get_proc_nivel_1($nivel_4, $nivel_2));
        }
        
        public function busca()
        {
            $term = $this->input->get('term');
            $procs = $this->cat->busca_proc($term);
            $procs_formated = array();
            foreach ($procs as $proc) {
                $procs_formated[] = array('label' => mb_strtoupper($proc['proc_descrip']),'value' => $proc['proc_cve_proc']);
            }
            echo json_encode($procs_formated);
        }
        
        public function id($proc_id)
        {
            $proc['proc'] = $this->cat->get_proc($proc_id);
            if($proc)
            {
                send_json_ok($this->load->view('catalogos/proc_view',$proc,TRUE));
            }   
            else
            {
                send_json_error('No existe');
            }
        }
}