﻿<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Activo extends CI_Controller {
    
    function __construct() {
        parent::__construct();
        $this->load->model('activo/Activo_model','activo');
        $this->load->model('servicio/Servicio_model','servicio');
		$this->load->model('empleado/Empleado_model','medico');
		$this->load->helper('util');
    }
 

    public function rep_eva()
    {
        $this->load->helper('template');
        $params_view = array(
            'title' => 'Inicio',
            'view' => 'activo/inicio_view_rep_evaluados',
            'view_data' => $data
            );
        render_template($params_view);
    } 

    public function rep_lab()
    {
        $this->load->helper('template');
        $params_view = array(
            'title' => 'Inicio',
            'view' => 'activo/inicio_view_rep_eva_lab',
            'view_data' => $data
            );
        render_template($params_view);
    }

 
    public function lista()
    {   //date_default_timezone_set('America/Mexico_City');
	    //echo " Punto A ";
		$suc=get_sucursal_id();
		//echo " Punto AA ";
		$user_despacho=get_desp_id_usr();
		//echo " Punto AAA ";
		$user_cei=get_cei_id();
		//echo " Punto AAAA ";
		$user_root1=get_my_user_root1();
		$user_root3=get_my_user_root3();
		$user_root4=get_my_user_root4();
		$user = $this->session->user; 
		$medico = $this->medico->get($user['usr_id']);
		
		
		//echo " cei ".get_cei_id();
		//echo " root1 ".get_my_user_root1();
		
        $rows = 30;
        $this->load->library('pagination');
        $config['base_url'] = base_url('activo/lista/');
        //$config['total_rows'] = $this->activo->count_all();
		
		if ($user_root4 == 0)
		{
			$config['total_rows'] = $this->activo->count_allo($suc,$user_despacho,$user_cei,$user_root1);
        }
		elseif ($user_root4 == 4)
		{
			$config['total_rows'] = $this->activo->count_allo_emp_asig($medico['usr_emp_asig']);
		}
		elseif (($user_root4 == 3) || ($user_root4 == 7))
		{
			$config['total_rows'] = $this->activo->count_allo_gsi($suc,$user_despacho,$user_cei,$user_root1,0);
		}
		elseif ($user_root4 == 5)
		{
			$config['total_rows'] = $this->activo->count_allo_emp_asig($medico['usr_emp_asig']);
		}elseif ($user_root4 == 6)
		{
			$config['total_rows'] = $this->activo->count_allo_gsi($suc,$user_despacho,$user_cei,$user_root1,0);
		}		
		
		$config['per_page'] = $rows;
        $config['attributes'] = array('class' => 'pagination');
        $config['full_tag_open'] = '<div class="pagination-full">';
        $config['full_tag_close'] = '</div>';
        $config['uri_segment'] = 3;
        $config['query_string_segment'] = 4;
        $config['use_page_numbers'] = TRUE;
        $this->pagination->initialize($config);
        
		//echo " Punto B ";
        //$data['activos'] = $this->activo->get_all($rows);
		
		if ($user_root4 == 0)
		{
			$data['activos'] = $this->activo->get_allo($rows,get_sucursal_id(),$user_despacho,$user_cei,$user_root1);
		}
		elseif ($user_root4 == 4)
		{
			$data['activos'] = $this->activo->get_allo_emp_asig($rows,$medico['usr_emp_asig']);
		}
		elseif (($user_root4 == 3) || ($user_root4 == 7))
		{
			$data['activos'] = $this->activo->get_allo_gsi($rows,get_sucursal_id(),$user_despacho,$user_cei,$user_root1);
		}
		elseif ($user_root4 == 5)
		{
			$data['activos'] = $this->activo->get_allo_emp_asig($rows,$medico['usr_emp_asig']);
		}
		elseif ($user_root4 == 6)
		{
			$data['activos'] = $this->activo->get_allo_gsi($rows,get_sucursal_id(),$user_despacho,$user_cei,$user_root1);
		}		
		//echo " Punto C ";
		
        $this->load->model('empresa/Empresa_model','empresa');
		//echo " Punto D ";
		if ($user_root4 == 0)
		{
        $data['empresas'] = $this->empresa->trae_empresas(1);//$this->empresa->get_all_empresas();
		}
		elseif ($user_root4 == 4)
		{
			$data['empresas'] = $this->empresa->trae_emp_asig($medico['usr_emp_asig']);			
		}
		elseif (($user_root4 == 3) || ($user_root4 == 7))
		{
			$data['empresas'] = $this->empresa->get_all_empresas_gsi_id();			
		}
		elseif ($user_root4 == 5)
		{
			$data['empresas'] = $this->empresa->trae_emp_asig($medico['usr_emp_asig']);			
		}
		elseif ($user_root4 == 6)
		{
			$data['empresas'] = $this->empresa->get_all_empresas_gsi_id();			
		}		
		//echo " Punto E ";
        
        $this->load->helper('template');
        $params_view = array(
            'title' => 'Personas',
            'view' => 'activo/index',
            'view_data' => $data 
           );
        render_template($params_view);  
    }
 


    public function lista_p()
    {   //date_default_timezone_set('America/Mexico_City');
	    //echo " Punto A ";
		$suc=get_sucursal_id();
		$user_despacho=get_desp_id_usr();
		$user_cei=get_cei_id();
		$user_root1=get_my_user_root1();
		$user = $this->session->user; 
		$medico = $this->medico->get($user['usr_id']);
		
		/**es el medico ISMAEL PEREZ GUTIERREZ?*/
		$segundo_turno='Saturday';
		$dia='semana';
		if ($user['usr_id'] == 402) 
		{
			$dia=date('l jS \of F Y');
			//echo $dia;
		}
		
        $rows = 30;
        $this->load->library('pagination');
        $config['base_url'] = base_url('activo/lista_p/');
		
		if ( ($user['usr_id'] == 402)  && strstr($dia,$segundo_turno) )
		{
			$config['total_rows'] = $this->activo->count_allo_p($suc,94,$user_despacho,$user_cei,$user_root1,1);
		}
		else
		{
			$config['total_rows'] = $this->activo->count_allo_p($suc,$medico['usr_emp_asig'],$user_despacho,$user_cei,$user_root1,1);
		}
		
        $config['per_page'] = $rows;
        $config['attributes'] = array('class' => 'pagination');
        $config['full_tag_open'] = '<div class="pagination-full">';
        $config['full_tag_close'] = '</div>';
        $config['uri_segment'] = 3;
        $config['query_string_segment'] = 4;
        $config['use_page_numbers'] = TRUE;
        $this->pagination->initialize($config);
        //echo " Punto ".$medico['usr_emp_asig'];
		//echo " Punto B ";
        //$data['activos'] = $this->activo->get_all($rows);
		
		if ( ($user['usr_id'] == 402)  && strstr($dia,$segundo_turno) )
		{
			$data['activos'] = $this->activo->get_allo_p($rows,94,get_sucursal_id(),$user_despacho,$user_cei,$user_root1,1);
		}
		else
		{
			$data['activos'] = $this->activo->get_allo_p($rows,$medico['usr_emp_asig'],get_sucursal_id(),$user_despacho,$user_cei,$user_root1,1);
		}
		$data['activos'] = $this->activo->get_allo_p($rows,$medico['usr_emp_asig'],get_sucursal_id(),$user_despacho,$user_cei,$user_root1,1);
		//echo " Punto C ";
		
        $this->load->model('empresa/Empresa_model','empresa');
		//echo " Punto D ";
		
        //$data['empresas'] = $this->empresa->trae_empresas(1);//$this->empresa->get_all_empresas();
		$data['empresas'] = $this->empresa->get_all_empresas_gsi();
		//echo " Punto E ";
		
		
        $data['medico']=$medico;
        $this->load->helper('template');
        $params_view = array(
            'title' => 'Personas',
            'view' => 'activo/index_p',
            'view_data' => $data 
           );
        render_template($params_view);  
    }


 
    public function id($id)
    {   
		$n=get_desp_id_usr();
		$user_cei=get_cei_id();
		$user_root1=get_my_user_root1();		
        $data['activo'] = $this->activo->get($id,$n);
        
		if($data['activo'])
        {
            $this->load->model('examen/Entorno_social_model','entorno_social');
            $this->load->model('examen/Socioeconomico_model','socio_economico');
            $this->load->model('examen/Poligrafico_model','poligrafico');
            $this->load->model('examen/Medico_fisico_model','medico_fisico');

            $this->load->model('examen/Psicologico_model','psicologico');
            $this->load->model('examen/Recetario_model','recetario');
		    $this->load->model('examen/Toxicologico_model','toxicologico');
            $this->load->model('examen/Toxicologico_model7','toxicologico7');
            $this->load->model('examen/prueba_model','prueba');
            $this->load->model('examen/Acreditacion_model','acreditacion');
            $this->load->model('examen/Historia_clinica_model','historia_clinica');
			
            $this->load->model('examen/Quimica_sanguinea_model','quimicasan');
			
           $this->load->model('examen/Quimica_sanguinea3_model','quimicasan3');
            $this->load->model('examen/Quimica_sanguinea6_model','quimicasan6');
            $this->load->model('examen/Quimica_sanguinea12_model','quimicasan12');
            $this->load->model('examen/Quimica_sanguinea15_model','quimicasan15');
            $this->load->model('examen/Quimica_sanguinea24_model','quimicasan24');
			$this->load->model('examen/Quimica_sanguinea27_model','quimicasan27');
            $this->load->model('examen/Quimica_sanguinea38_model','quimicasan38');
			
			$this->load->model('examen/Biometria_hematica_model','biometria');
            $this->load->model('examen/Grupo_sanguineo_model','grupo_sanguineo');
            $this->load->model('examen/Orina_model','orina');
            $this->load->model('examen/Essoec_model','gsi');
            $this->load->model('examen/Sociolaboral_model','sociolaboral');
            $this->load->model('examen/Eye_detect_model','eye_detect');
			$this->load->model('examen/Pie_model','pie_detect');
			
			$this->load->model('examen/Alcohol_model','alcohol_detect');
			$this->load->model('examen/Covid_model','covid_detect');
			
			$this->load->model('examen/Historia_clinica_model','fpfh_detect');
			$this->load->model('examen/Historia_clinica_model','fsm_odon_detect');
			$this->load->model('examen/Pie_model','pyb');
			$this->load->model('examen/SS/Ssestsoc_model','segurisec');
			$this->load->model('examen/Nom035_model','nom035');
			$this->load->model('examen/Nom035ii_model','nom035ii');
			$this->load->model('examen/Nom035iii_model','nom035iii');

            $user = $this->session->user;

            $data['medico']=$user;
            $data['socio_economicos'] = $this->socio_economico->get_by_clte($id,$n);
            
			$data['entorno_social'] = $this->entorno_social->get_by_clte($id,$n);
            
			$data['fsms_02'] = $this->poligrafico->get_by_clte($id,'POLI',$n);
            $data['fsmsc_02'] = $this->poligrafico->get_by_clte($id,'CEDULA',$n);
						
            $data['fsms_04'] = $this->medico_fisico->get_by_clte($id,$n);
			
            $data['fsms_05'] = $this->psicologico->get_by_clte($id,$n); /*CEDULA PSICOLOGICA*/				
			$data['fsms_psicor'] = $this->psicologico->get_by_clte_r($id,$n); /*REPORTE PSICOLOGICO*/
		
            $data['fsms_05_simple'] = $this->psicologico->get_by_clte_simple($id,$n); /*CEDULA PSICOLOGICA SIMPLE*/				
			$data['fsms_psicor_simple'] = $this->psicologico->get_by_clte_r_simple($id,$n); /*REPORTE PSICOLOGICO SIMPLE*/
		
            $data['fsms_06'] = $this->toxicologico->get_by_clte($id,$n);
			
            $data['fsms_07'] = $this->toxicologico7->get_by_clte($id,$n);
			
            $data['fsms_09'] = $this->prueba->get_by_clte($id,$n);
			
            $data['fsms_03'] = $this->acreditacion->get_by_clte($id,$n);
			
            $data['fsms_lala'] = $this->historia_clinica->get_by_clte($id,'',$n);
			$data['fsm_odon'] = $this->historia_clinica->get_by_clte($id,'fsm_odon',$n);
			$data['fpfh'] = $this->historia_clinica->get_by_clte($id,'fpfh',$n);
			
            $data['fsm_qs'] = $this->quimicasan->get_by_clte($id,$n);
			
            $data['fsm_qs3'] = $this->quimicasan3->get_by_clte($id,$n);
            $data['fsm_qs6'] = $this->quimicasan6->get_by_clte($id,$n);
            $data['fsm_qs12'] = $this->quimicasan12->get_by_clte($id,$n);
            $data['fsm_qs15'] = $this->quimicasan15->get_by_clte($id,$n);
            $data['fsm_qs24'] = $this->quimicasan24->get_by_clte($id,$n);
			$data['fsm_qs27'] = $this->quimicasan27->get_by_clte($id,$n);
            $data['fsm_qs38'] = $this->quimicasan38->get_by_clte($id,$n);
			
            $data['fsm_bh'] = $this->biometria->get_by_clte($id,$n);
			
            $data['fsm_gs'] = $this->grupo_sanguineo->get_by_clte($id,$n);
			
            $data['fsm_or'] = $this->orina->get_by_clte($id,$n);

            $data['sociolaboral'] = $this->sociolaboral->get_by_clte($id,$n);
			
     		$data['essoecs'] = $this->gsi->get_by_clte($id,$n);	
            
			$data['fsm_pie'] = $this->pie_detect->get_by_clte($id,$n);
            
			$data['fsm_alcohol'] = $this->alcohol_detect->get_by_clte($id,$n);
			$data['fsm_covid'] = $this->covid_detect->get_by_clte($id,$n);
			
			$data['eyes'] = $this->eye_detect->get_by_clte($id,$n);
   		
			$data['fsm_pyb'] = $this->pyb->get_by_clte_pyb($id,'fsm_pyb',$n);
			
			$data['fsm_ssestsoc'] = $this->segurisec->get_by_clte($id,$n);
			
			$data['fsms_nom035'] = $this->nom035->get_by_clte($id,$n);
			$data['fsms_nom035ii'] = $this->nom035ii->get_by_clte($id,$n);
			$data['fsms_nom035iii'] = $this->nom035iii->get_by_clte($id,$n);
			
			//$data['root'] = get_my_user_root2(); 
			//echo '--->'.$data['myroot2'].'<--';
            $data['docs'] = $this->activo->get_docs($id);
			$data['coms'] = $this->activo->get_coms($id);
			
			$data['hon_docs'] = $this->activo->get_hon_docs($id);
			$data['compo_docs'] = $this->activo->get_compo_docs($id);
			//echo '--a---';
			$data['PENSA_docs'] = $this->activo->get_PENSA_docs($id);
			$data['INTE_docs'] = $this->activo->get_INTE_docs($id);
			
			$data['PUESIC_docs'] = $this->activo->get_PUESIC_docs($id);
			
		   //echo '--b---';
			$data['sgmty_docs'] = $this->activo->get_sgmty_docs($id);
			$data['covid_docs'] = $this->activo->get_covid_docs($id);
			$data['AUDIO_docs'] = $this->activo->get_AUDIO_docs($id);
			$data['VISTA_docs'] = $this->activo->get_VISTA_docs($id);
			$data['ELECTRO_docs'] = $this->activo->get_ELECTRO_docs($id);

			$data['PAPAN_docs'] = $this->activo->get_PAPAN_docs($id);
			$data['RADIOT_docs'] = $this->activo->get_RADIOT_docs($id);
			$data['RADIOL_docs'] = $this->activo->get_RADIOL_docs($id);



			$data['fsms_recetario'] = $this->recetario->get_by_clte_r($id,$n);
			//echo '--c---';
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Persona',
                'view' => 'activo/activo',
                'view_data' => $data 
               );

            render_template($params_view);  
        }
        else
        {
            show_error('El activo no existe.');
        }
    }
    
    public function edita($activo_id)
    {   //date_default_timezone_set('America/Mexico_City');
        $user = $this->session->user;
		$user_root4=get_my_user_root4();
		$activo = $this->activo->get($activo_id);
		$medico = $this->medico->get($user['usr_id']);
        
		if ($activo['serv_id'] > 0)
		{	
			$servicio = $this->servicio->get($activo['serv_id']);
		}
		
        if($activo)
        {

            if(isset($_POST) && count($_POST) > 0)     
            {
                $this->load->library('form_validation');
                $this->form_validation->set_rules('nombre','Nombre','required');
                $this->form_validation->set_rules('paterno','Apellido Paterno','required');
                $this->form_validation->set_rules('materno','Apellido Materno','required');
                /*$this->form_validation->set_rules('fnac','Fecha de nacimiento','required');*/
                $this->form_validation->set_rules('genero','Género','required');
                //$this->form_validation->set_rules('civil','Estado civil','required');
                //$this->form_validation->set_rules('rfc','RFC','required');
                //$this->form_validation->set_rules('curp','CURP','required');

                if($this->form_validation->run())
                {
                    //informncion general de la pérsona
                    $data_clte['clte_nombre_crypt'] =  trim($this->input->post('nombre'));
                    $data_clte['clte_2_nombre_crypt'] =  trim($this->input->post('nombre_adic'));
                    $data_clte['clte_paterno_crypt'] =  trim($this->input->post('paterno'));
                    $data_clte['clte_materno_crypt'] =  trim($this->input->post('materno'));
                    
					//$data_clte['clte_f_nac'] = formatea_fecha_mysql($this->input->post('fnac'));
                    $data_clte['clte_f_nac'] = $this->input->post('fnac');
					
					$data_clte['clte_genero_cve'] =  $this->input->post('genero');
                    $data_clte['clte_rfc_crypt'] =  $this->input->post('rfc');
                    $data_clte['clte_curp_crypt'] =  $this->input->post('curp');
					

					

                    //dopmcicio de la persona
                    $data_clte['clte_env_pais_cve'] =  $this->input->post('pais');
                    $data_clte['clte_env_cp'] =  $this->input->post('cp');
                    $data_clte['clte_env_edo_cve'] =  $this->input->post('entidad');
                    $data_clte['clte_env_colonia_crypt'] =  $this->input->post('colonia');
                    $data_clte['clte_env_localidad'] =  $this->input->post('localidad');
                    $data_clte['clte_env_municipio'] =  $this->input->post('municipio');
                    $data_clte['clte_env_calle_crypt'] =  $this->input->post('calle');
                    $data_clte['clte_env_num_ext_crypt'] =  $this->input->post('next');
                    $data_clte['clte_env_num_int_crypt'] =  $this->input->post('nint');
					$data_clte['clte_nss_crypt'] =  $this->input->post('nss');
                    //informacion de conrtaxcto de la persona
                    $data_clte['clte_tel_casa_crypt'] = limpia_telefono($this->input->post('tel'));                
                    $data_clte['clte_cel_crypt'] =  limpia_telefono($this->input->post('cel'));
                    $data_clte['clte_email_crypt'] =  $this->input->post('correo');

                    //nuevos campos
                    $data_clte['clte_grado_acad_cve'] =  $this->input->post('grado');
                    $data_clte['clte_puesto'] =  $this->input->post('puesto');
                    $data_clte['clte_edo_civ_cve'] =  $this->input->post('civil');
                    $data_clte['clte_nac_cve'] =  $this->input->post('nac');

                    //empresa donde va a loborar la persona
                    $data_clte['emp_id'] =  $this->input->post('empresa');
                    
                    //nuevo campo de unicacion
                    $data_clte['clte_lab_ubicacion'] =  $this->input->post('ubicacion');
                     
					//despachos 
					$data_clte['desp_id'] =  $this->input->post('despacho');
					$data_clte['clte_reclutador'] =  $this->input->post('reclutador');					 
					 
                 
					
					$nomserv='';
					if ($this->input->post('nom35i') == 'OK')
					{$nomserv=$nomserv.'nom0351;';}	
					if ($this->input->post('nom35ii') == 'OK')
					{$nomserv=$nomserv.'nom0352;';}
					if ($this->input->post('nom35iii') == 'OK')
					{$nomserv=$nomserv.'nom0353;';}	
					if ($this->input->post('honestidad') == 'OK')
					{$nomserv=$nomserv.'HONE;';}
					if ($this->input->post('comportamiento') == 'OK')
					{$nomserv=$nomserv.'COMPO;';}
					if ($this->input->post('certificado') == 'OK')
					{$nomserv=$nomserv.'CERTI;';}
/***************************************************************************************/
						
					$cat_examen = get_cat_nombre_var('EXAMEN');
					$i=0;
					$cat_categorias = get_cat_nombre_var('CATEGORIA_EX');
					foreach($cat_categorias as $categoria): 
						//echo $categoria['cat_nombre'].' ';
						$linea_examenes=get_examen_de_empresa_por_categoria($activo['emp_id'], $categoria['cat_nombre']);
						
						if (strlen($linea_examenes) > 0)
						{
							foreach (explode(';', $linea_examenes) as $det):
								if (strlen($det) > 0)
								{

										//<?php echo $categoria['cat_nombre'];

										//<?php echo get_nombre_de_examen($det, 'EXAMEN');
										
										$exa=$this->input->post($categoria['cat_nombre'].'_'.$i);
										$nomserv.=$exa;
										$i++;
										//<input type="checkbox" id="<?php echo $categoria['cat_nombre'].'_'.$i; " name="<?php echo $categoria['cat_nombre'].'_'.$i; " value="<?php echo $det.';'; $i++; " <?php if (strstr($persona['nomserv'], $det.';')) { echo 'checked';} 

								}
								
							endforeach;										
						}
					endforeach;
/***************************************************************************************/

					$data_clte['nomserv'] =  $nomserv;
					
					if ($data_clte['emp_id'] == 152)
					{
						$data_clte['nomserv']='SGMTY;';
					}elseif ($data_clte['emp_id'] == 194)
					{
						$data_clte['nomserv']='PREVEM;';
					}elseif ($data_clte['emp_id'] == 193)
					{
						$data_clte['nomserv']='ALLIANZ;';
					}
					elseif ($data_clte['emp_id'] == 182)
					{
						$data_clte['nomserv'].='FILOA;';
					}					
					
					
					
                    //despacho
                      $data_clte['desp_id'] =  $this->input->post('despacho');
					  if ($data_clte['desp_id'] == 1) {$data_clte['desp_id']=0;}
					  $data_clte['clte_reclutador'] =  $this->input->post('reclutador');
					
					//orden de servicio
					
					if ($this->input->post('serv_id') > 0)
					{	
						$data_clte['serv_id'] =$this->input->post('serv_id');
					}				
					
					//orden de servicio		13 feb 2020		
					/*if ($this->input->post('serv_id') > 0)
					{	
						if ($this->input->post('empresa') == 31)
						{	
							$data_clte['serv_id'] = 215;
						}
						else
						{
							$servicio_form = $this->servicio->get($this->input->post('serv_id'));
							$data_clte['desp_id'] =  $servicio_form['desp_id'];
							$data_clte['clte_reclutador'] =  $servicio_form['reclutador'];
							$data_clte['serv_id'] =  $this->input->post('serv_id');
						}
					}*/
					
					//sucursal
					$data_clte['suc_id'] =  $this->input->post('sucursal');
					
					//cei
					$data_clte['cei_id'] =  $this->input->post('cei');
					
					
//*************************************
//$data_clte['root'] = 'OK';
//*************************************


                    if(!empty($_FILES['foto']['name']))
                    {
                        $this->load->library('upload');
                        $filename = md5(time());
                        $config = array(
                                'upload_path'   => './../../files/fotos/',
                                'overwrite'     => TRUE,
                                'file_name'     => $filename,
                                'allowed_types' => 'png|jpg|jpeg',
                                'max_size'      => '10000'
                        );

                        $this->upload->initialize($config);
                        if ( ! $this->upload->do_upload('foto'))
                        {
                            send_json_error($this->upload->display_errors());
                        }
                        else 
                        {
                            $data = $this->upload->data();
                            $data_clte['clte_path_foto'] = $data['file_name'];
                        }
                    }

					if (($data_clte['clte_f_nac'] =='') && ($data_clte['emp_id'] !=152))
					{
						send_json_error('Ocurrió un error, no se registro la FECHA DE NACIMIENTO.');
					}
                    else
					{
						
						if ($this->input->post('rregistrar') == 'rr')
						{						
							if($this->activo->actualiza_registro($activo_id, array_to_upper($data_clte)))
							{
								send_json_ok(array('msg' =>'Se actualizó y registro nuevamente el evaluado de forma correcta', 'id' => $activo_id));
							}
							else
							{
								send_json_error('Ocurrió un error al actualizar la persona.');
							}
						}
						else
						{	
						
							if($this->activo->actualiza($activo_id, array_to_upper($data_clte)))
							{
								send_json_ok(array('msg' =>'Se actualizó de forma correcta', 'id' => $activo_id));
							}
							else
							{
								send_json_error('Ocurrió un error al actualizar la persona.');
							}
						}
					}
                }
                else
                {
                    send_json_error(validation_errors('<div />'));
                }
            }
            else 
            {
				//echo "----------->".$activo['suc_id']."<-----------";
                $this->load->model('empresa/Empresa_model','empresa');
				if ($user_root4 == 5)
				{
				$data['empresas'] = $this->empresa->trae_emp_asig($medico['usr_emp_asig']);			
				}
				else
				{
					$data['empresas'] = $this->empresa->trae_empresas();//$this->empresa->get_all_empresas();
				}
				
				$data['despachos'] = $this->empresa->get_all_despachos();
				$data['sucursals'] = $this->empresa->get_all_sucursales();
				$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($activo['emp_id']);
                $data['persona'] = 	$activo;
				if ($activo['serv_id'] > 0)
				{
					$data['servicio'] = $servicio;
				}
                $this->load->helper('template');
                $params_view = array(
                    'title' => 'Personas',
                    'view' => 'activo/edit',
                    'view_data' => $data
                   );
                render_template($params_view);  
            }
        }
        else 
        {
            show_error('No existe el activo');
        }
    }
  

    public function edita_a($activo_id)
    {   //date_default_timezone_set('America/Mexico_City');
        
		$activo = $this->activo->get($activo_id);
        
		if ($activo['serv_id'] > 0)
		{	
			$servicio = $this->servicio->get($activo['serv_id']);
		}
		
        if($activo)
        {

            if(isset($_POST) && count($_POST) > 0)     
            {
                $this->load->library('form_validation');
                $this->form_validation->set_rules('nombre','Nombre','required');
                $this->form_validation->set_rules('paterno','Apellido Paterno','required');
                $this->form_validation->set_rules('materno','Apellido Materno','required');
                /*$this->form_validation->set_rules('fnac','Fecha de nacimiento','required');*/
                $this->form_validation->set_rules('genero','Género','required');
                //$this->form_validation->set_rules('civil','Estado civil','required');
                //$this->form_validation->set_rules('rfc','RFC','required');
                //$this->form_validation->set_rules('curp','CURP','required');

                if($this->form_validation->run())
                {
                    //informncion general de la pérsona
                    $data_clte['clte_nombre_crypt'] =  trim($this->input->post('nombre'));
                    $data_clte['clte_2_nombre_crypt'] =  trim($this->input->post('nombre_adic'));
                    $data_clte['clte_paterno_crypt'] =  trim($this->input->post('paterno'));
                    $data_clte['clte_materno_crypt'] =  trim($this->input->post('materno'));
                    
					$data_clte['clte_f_nac'] = formatea_fecha_mysql($this->input->post('fnac'));
                    $data_clte['clte_genero_cve'] =  $this->input->post('genero');
                    $data_clte['clte_rfc_crypt'] =  $this->input->post('rfc');
                    $data_clte['clte_curp_crypt'] =  $this->input->post('curp');
					

					

                    //dopmcicio de la persona
                    $data_clte['clte_env_pais_cve'] =  $this->input->post('pais');
                    $data_clte['clte_env_cp'] =  $this->input->post('cp');
                    $data_clte['clte_env_edo_cve'] =  $this->input->post('entidad');
                    $data_clte['clte_env_colonia_crypt'] =  $this->input->post('colonia');
                    $data_clte['clte_env_localidad'] =  $this->input->post('localidad');
                    $data_clte['clte_env_municipio'] =  $this->input->post('municipio');
                    $data_clte['clte_env_calle_crypt'] =  $this->input->post('calle');
                    $data_clte['clte_env_num_ext_crypt'] =  $this->input->post('next');
                    $data_clte['clte_env_num_int_crypt'] =  $this->input->post('nint');
					$data_clte['clte_nss_crypt'] =  $this->input->post('nss');
                    //informacion de conrtaxcto de la persona
                    $data_clte['clte_tel_casa_crypt'] = limpia_telefono($this->input->post('tel'));                
                    $data_clte['clte_cel_crypt'] =  limpia_telefono($this->input->post('cel'));
                    $data_clte['clte_email_crypt'] =  $this->input->post('correo');

                    //nuevos campos
                    $data_clte['clte_grado_acad_cve'] =  $this->input->post('grado');
                    $data_clte['clte_puesto'] =  $this->input->post('puesto');
                    $data_clte['clte_edo_civ_cve'] =  $this->input->post('civil');
                    $data_clte['clte_nac_cve'] =  $this->input->post('nac');

                    //empresa donde va a loborar la persona
                    $data_clte['emp_id'] =  $this->input->post('empresa');
                    
                    //nuevo campo de unicacion
                    $data_clte['clte_lab_ubicacion'] =  $this->input->post('ubicacion');
                     
					//despachos 
					$data_clte['desp_id'] =  $this->input->post('despacho');
					$data_clte['clte_reclutador'] =  $this->input->post('reclutador');					 
					 
                     //examenes
					/*
				 	$data_clte['acred'] =  $this->input->post('acreditacion'); 	
					$data_clte['biohem'] =  $this->input->post('biometria_hematica'); 		
					$data_clte['ced_pol'] =  $this->input->post('poligrafo_celula'); 
					
					$data_clte['ced_psci'] =  $this->input->post('psico_celula'); 				
					$data_clte['psci'] =  $this->input->post('psico_reporte'); 	 
					$data_clte['repsic'] =  $this->input->post('psico_reporte');
					$data_clte['pssim'] =  $this->input->post('psico_simple'); 						
					 
					
					$data_clte['sangre'] =  $this->input->post('sangre'); 
					$data_clte['sociol'] =  $this->input->post('sociolaboral'); 						
					$data_clte['hist'] =  $this->input->post('historia_clinica'); 	 	
					$data_clte['entsoc'] =  $this->input->post('entorno_social'); 	 	
					
					
					$data_clte['estsoc'] = $this->input->post('estudio_socioeconomico'); 	 	
					$data_clte['eyed'] =  $this->input->post('eye'); 	 	
					$data_clte['fpfh0105'] =  $this->input->post('fpfh0105'); 	 	
					$data_clte['medfis'] =  $this->input->post('medico_fisico'); 	 	
					$data_clte['odo'] =  $this->input->post('odontologica'); 	 	
					$data_clte['orina'] =  $this->input->post('orina'); 	 	
					$data_clte['pie'] =  $this->input->post('pie'); 	 	
					$data_clte['pol'] =  $this->input->post('poligrafo_reporte'); 	 	
						 	
					
					$data_clte['quisan'] =  $this->input->post('quimica_sanguinea'); 	 	
					$data_clte['socie'] =  $this->input->post('socioeconomico'); 	 	
					$data_clte['toxi'] =  $this->input->post('toxicologico5'); 	
					
					$data_clte['toxin'] =  $this->input->post('toxicologico9'); 	
					$data_clte['toxis'] =  $this->input->post('toxicologico7');
					
					$data_clte['pyb'] =  $this->input->post('pyb');
                    */
					
					$nomserv='';
					if ($this->input->post('nom35i') == 'OK')
					{$nomserv=$nomserv.'nom0351;';}	
					if ($this->input->post('nom35ii') == 'OK')
					{$nomserv=$nomserv.'nom0352;';}
					if ($this->input->post('nom35iii') == 'OK')
					{$nomserv=$nomserv.'nom0353;';}	
					
					/*
					if ($this->input->post('honestidad') == 'OK')
					{$nomserv=$nomserv.'HONE;';}
					if ($this->input->post('comportamiento') == 'OK')
					{$nomserv=$nomserv.'COMPO;';}
					if ($this->input->post('certificado') == 'OK')
					{$nomserv=$nomserv.'CERTI;';}
					*/
/***************************************************************************************/
						
					$cat_examen = get_cat_nombre_var('EXAMEN');
					$i=0;
					$cat_categorias = get_cat_nombre_var('CATEGORIA_EX');
					foreach($cat_categorias as $categoria): 
						//echo $categoria['cat_nombre'].' ';
						$linea_examenes=get_examen_de_empresa_por_categoria($activo['emp_id'], $categoria['cat_nombre']);
						
						if (strlen($linea_examenes) > 0)
						{
							foreach (explode(';', $linea_examenes) as $det):
								if (strlen($det) > 0)
								{

										//<?php echo $categoria['cat_nombre'];

										//<?php echo get_nombre_de_examen($det, 'EXAMEN');
										
										$exa=$this->input->post($categoria['cat_nombre'].'_'.$i);
										$nomserv.=$exa;
										$i++;
										//<input type="checkbox" id="<?php echo $categoria['cat_nombre'].'_'.$i; " name="<?php echo $categoria['cat_nombre'].'_'.$i; " value="<?php echo $det.';'; $i++; " <?php if (strstr($persona['nomserv'], $det.';')) { echo 'checked';} 

								}
								
							endforeach;										
						}
					endforeach;
/***************************************************************************************/

					$data_clte['nomserv'] =  $nomserv;
					
					// Se convierte en un empleado de HC
					$data_clte['hc'] =  1;
		
                    //despacho
					/*
                      $data_clte['desp_id'] =  $this->input->post('despacho');
					  if ($data_clte['desp_id'] == 1) {$data_clte['desp_id']=0;}
					  $data_clte['clte_reclutador'] =  $this->input->post('reclutador');
					
					
					if ($this->input->post('serv_id') > 0)
					{	
						$data_clte['serv_id'] =$this->input->post('serv_id');
					}				
					*/
					
					//sucursal
					$data_clte['suc_id'] =  $this->input->post('sucursal');
					
					//cei
					$data_clte['cei_id'] =  $this->input->post('cei');
					
					
//*************************************
//$data_clte['root'] = 'OK';
//*************************************


                    if(!empty($_FILES['foto']['name']))
                    {
                        $this->load->library('upload');
                        $filename = md5(time());
                        $config = array(
                                'upload_path'   => './../../files/fotos/',
                                'overwrite'     => TRUE,
                                'file_name'     => $filename,
                                'allowed_types' => 'png|jpg|jpeg',
                                'max_size'      => '10000'
                        );

                        $this->upload->initialize($config);
                        if ( ! $this->upload->do_upload('foto'))
                        {
                            send_json_error($this->upload->display_errors());
                        }
                        else 
                        {
                            $data = $this->upload->data();
                            $data_clte['clte_path_foto'] = $data['file_name'];
                        }
                    }

					if (($data_clte['clte_f_nac'] =='') && ($data_clte['emp_id'] !=152))
					{
						send_json_error('Ocurrió un error, no se registro la FECHA DE NACIMIENTO.');
					}
                    else
					{
						
						if ($this->input->post('rregistrar') == 'rr')
						{						
							if($this->activo->actualiza_registro($activo_id, array_to_upper($data_clte)))
							{
								send_json_ok(array('msg' =>'Se actualizó y registro nuevamente el evaluado de forma correcta', 'id' => $activo_id));
							}
							else
							{
								send_json_error('Ocurrió un error al actualizar la persona.');
							}
						}
						else
						{	
						
							if($this->activo->actualiza($activo_id, array_to_upper($data_clte)))
							{
								send_json_ok(array('msg' =>'Se actualizó y ha sido Contratado en HC de forma correcta', 'id' => $activo_id));
							}
							else
							{
								send_json_error('Ocurrió un error al actualizar la persona.');
							}
						}
					}
                }
                else
                {
                    send_json_error(validation_errors('<div />'));
                }
            }
            else 
            {
				//echo "----------->".$activo['suc_id']."<-----------";
                $this->load->model('empresa/Empresa_model','empresa');
                $data['empresas'] = $this->empresa->trae_empresas();//$this->empresa->get_all_empresas();
				$data['despachos'] = $this->empresa->get_all_despachos();
				$data['sucursals'] = $this->empresa->get_all_sucursales();
				$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($activo['emp_id']);
                $data['persona'] = 	$activo;
				if ($activo['serv_id'] > 0)
				{
					$data['servicio'] = $servicio;
				}
                $this->load->helper('template');
                $params_view = array(
                    'title' => 'Personas',
                    'view' => 'activo/edit_a',
                    'view_data' => $data
                   );
                render_template($params_view);  
            }
        }
        else 
        {
            show_error('No existe el activo');
        }
    }

    public function edita_c($activo_id)
    {           
		$activo = $this->activo->get($activo_id);
        
		if ($activo['serv_id'] > 0)
		{	
			$servicio = $this->servicio->get($activo['serv_id']);
		}
		
        if($activo)
        {

            if(isset($_POST) && count($_POST) > 0)     
            {
                $this->load->library('form_validation');
                $this->form_validation->set_rules('nombre','Nombre','required');
                $this->form_validation->set_rules('paterno','Apellido Paterno','required');
                $this->form_validation->set_rules('materno','Apellido Materno','required');
                /*$this->form_validation->set_rules('fnac','Fecha de nacimiento','required');*/
                $this->form_validation->set_rules('genero','Género','required');
                //$this->form_validation->set_rules('civil','Estado civil','required');
                //$this->form_validation->set_rules('rfc','RFC','required');
                //$this->form_validation->set_rules('curp','CURP','required');

                if($this->form_validation->run())
                {
                    //informncion general de la pérsona
                    $data_clte['clte_nombre_crypt'] =  trim($this->input->post('nombre'));
                    $data_clte['clte_2_nombre_crypt'] =  trim($this->input->post('nombre_adic'));
                    $data_clte['clte_paterno_crypt'] =  trim($this->input->post('paterno'));
                    $data_clte['clte_materno_crypt'] =  trim($this->input->post('materno'));
                    
					$data_clte['clte_f_nac'] = formatea_fecha_mysql($this->input->post('fnac'));
                    $data_clte['clte_genero_cve'] =  $this->input->post('genero');
                    $data_clte['clte_rfc_crypt'] =  $this->input->post('rfc');
                    $data_clte['clte_curp_crypt'] =  $this->input->post('curp');
					

					

                    //dopmcicio de la persona
                    $data_clte['clte_env_pais_cve'] =  $this->input->post('pais');
                    $data_clte['clte_env_cp'] =  $this->input->post('cp');
                    $data_clte['clte_env_edo_cve'] =  $this->input->post('entidad');
                    $data_clte['clte_env_colonia_crypt'] =  $this->input->post('colonia');
                    $data_clte['clte_env_localidad'] =  $this->input->post('localidad');
                    $data_clte['clte_env_municipio'] =  $this->input->post('municipio');
                    $data_clte['clte_env_calle_crypt'] =  $this->input->post('calle');
                    $data_clte['clte_env_num_ext_crypt'] =  $this->input->post('next');
                    $data_clte['clte_env_num_int_crypt'] =  $this->input->post('nint');
					$data_clte['clte_nss_crypt'] =  $this->input->post('nss');
                    //informacion de conrtaxcto de la persona
                    $data_clte['clte_tel_casa_crypt'] = limpia_telefono($this->input->post('tel'));                
                    $data_clte['clte_cel_crypt'] =  limpia_telefono($this->input->post('cel'));
                    $data_clte['clte_email_crypt'] =  $this->input->post('correo');

                    //nuevos campos
                    $data_clte['clte_grado_acad_cve'] =  $this->input->post('grado');
                    $data_clte['clte_puesto'] =  $this->input->post('puesto');
                    $data_clte['clte_edo_civ_cve'] =  $this->input->post('civil');
                    $data_clte['clte_nac_cve'] =  $this->input->post('nac');

                    //empresa donde va a loborar la persona
                    $data_clte['emp_id'] =  $this->input->post('empresa');
                    
                    //nuevo campo de unicacion
                    $data_clte['clte_lab_ubicacion'] =  $this->input->post('ubicacion');
                     
					//despachos 
					$data_clte['desp_id'] =  $this->input->post('despacho');
					$data_clte['clte_reclutador'] =  $this->input->post('reclutador');					 
					 
	
					$nomserv='';
					if ($this->input->post('nom35i') == 'OK')
					{$nomserv=$nomserv.'nom0351;';}	
					if ($this->input->post('nom35ii') == 'OK')
					{$nomserv=$nomserv.'nom0352;';}
					if ($this->input->post('nom35iii') == 'OK')
					{$nomserv=$nomserv.'nom0353;';}	
					
					/*
					if ($this->input->post('honestidad') == 'OK')
					{$nomserv=$nomserv.'HONE;';}
					if ($this->input->post('comportamiento') == 'OK')
					{$nomserv=$nomserv.'COMPO;';}
					if ($this->input->post('certificado') == 'OK')
					{$nomserv=$nomserv.'CERTI;';}
					*/
/***************************************************************************************/
						
					$cat_examen = get_cat_nombre_var('EXAMEN');
					$i=0;
					$cat_categorias = get_cat_nombre_var('CATEGORIA_EX');
					foreach($cat_categorias as $categoria): 
						//echo $categoria['cat_nombre'].' ';
						$linea_examenes=get_examen_de_empresa_por_categoria($activo['emp_id'], $categoria['cat_nombre']);
						
						if (strlen($linea_examenes) > 0)
						{
							foreach (explode(';', $linea_examenes) as $det):
								if (strlen($det) > 0)
								{

										//<?php echo $categoria['cat_nombre'];

										//<?php echo get_nombre_de_examen($det, 'EXAMEN');
										
										$exa=$this->input->post($categoria['cat_nombre'].'_'.$i);
										$nomserv.=$exa;
										$i++;
										//<input type="checkbox" id="<?php echo $categoria['cat_nombre'].'_'.$i; " name="<?php echo $categoria['cat_nombre'].'_'.$i; " value="<?php echo $det.';'; $i++; " <?php if (strstr($persona['nomserv'], $det.';')) { echo 'checked';} 

								}
								
							endforeach;										
						}
					endforeach;
/***************************************************************************************/

					$data_clte['nomserv'] =  $nomserv;
					
					// Se convierte en un empleado de HC
					$data_clte['hc'] =  1;
					echo $this->input->post('estatus');
					//if ($this->input->post('estatus') == 'noactivo')
					{
						$data_clte['status'] =  $this->input->post('status');
					}
		
                    //despacho
					/*
                      $data_clte['desp_id'] =  $this->input->post('despacho');
					  if ($data_clte['desp_id'] == 1) {$data_clte['desp_id']=0;}
					  $data_clte['clte_reclutador'] =  $this->input->post('reclutador');
					
					
					if ($this->input->post('serv_id') > 0)
					{	
						$data_clte['serv_id'] =$this->input->post('serv_id');
					}				
					*/
					
					//sucursal
					$data_clte['suc_id'] =  $this->input->post('sucursal');
					
					//cei
					$data_clte['cei_id'] =  $this->input->post('cei');
					
					
//*************************************
//$data_clte['root'] = 'OK';
//*************************************


                    if(!empty($_FILES['foto']['name']))
                    {
                        $this->load->library('upload');
                        $filename = md5(time());
                        $config = array(
                                'upload_path'   => './../../files/fotos/',
                                'overwrite'     => TRUE,
                                'file_name'     => $filename,
                                'allowed_types' => 'png|jpg|jpeg',
                                'max_size'      => '10000'
                        );

                        $this->upload->initialize($config);
                        if ( ! $this->upload->do_upload('foto'))
                        {
                            send_json_error($this->upload->display_errors());
                        }
                        else 
                        {
                            $data = $this->upload->data();
                            $data_clte['clte_path_foto'] = $data['file_name'];
                        }
                    }

					if (($data_clte['clte_f_nac'] =='') && ($data_clte['emp_id'] !=152))
					{
						send_json_error('Ocurrió un error, no se registro la FECHA DE NACIMIENTO.');
					}
                    else
					{
						
						if ($this->input->post('rregistrar') == 'rr')
						{						
							if($this->activo->actualiza_registro($activo_id, array_to_upper($data_clte)))
							{
								send_json_ok(array('msg' =>'Se actualizó y registro nuevamente el evaluado de forma correcta', 'id' => $activo_id));
							}
							else
							{
								send_json_error('Ocurrió un error al actualizar la persona.');
							}
						}
						else
						{	
						
							if($this->activo->actualiza($activo_id, array_to_upper($data_clte)))
							{
								send_json_ok(array('msg' =>'Se actualizó y ha sido Contratado en HC de forma correcta', 'id' => $activo_id));
							}
							else
							{
								send_json_error('Ocurrió un error al actualizar la persona.');
							}
						}
					}
                }
                else
                {
                    send_json_error(validation_errors('<div />'));
                }
            }
            else 
            {
				//echo "----------->".$activo['suc_id']."<-----------";
                $this->load->model('empresa/Empresa_model','empresa');
                $data['empresas'] = $this->empresa->trae_empresas();//$this->empresa->get_all_empresas();
				$data['despachos'] = $this->empresa->get_all_despachos();
				$data['sucursals'] = $this->empresa->get_all_sucursales();
				$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($activo['emp_id']);
                $data['persona'] = 	$activo;
				if ($activo['serv_id'] > 0)
				{
					$data['servicio'] = $servicio;
				}
                $this->load->helper('template');
                $params_view = array(
                    'title' => 'Personas',
                    'view' => 'activo/edit_c',
                    'view_data' => $data
                   );
                render_template($params_view);  
            }
        }
        else 
        {
            show_error('No existe el activo');
        }
    }
 
    public function edita_d($activo_id)
    {           
		$activo = $this->activo->get($activo_id);
        
		if ($activo['serv_id'] > 0)
		{	
			$servicio = $this->servicio->get($activo['serv_id']);
		}
		
        if($activo)
        {

            if(isset($_POST) && count($_POST) > 0)     
            {
                $this->load->library('form_validation');
                $this->form_validation->set_rules('nombre','Nombre','required');
                $this->form_validation->set_rules('paterno','Apellido Paterno','required');
                $this->form_validation->set_rules('materno','Apellido Materno','required');
                /*$this->form_validation->set_rules('fnac','Fecha de nacimiento','required');*/
                $this->form_validation->set_rules('genero','Género','required');
                //$this->form_validation->set_rules('civil','Estado civil','required');
                //$this->form_validation->set_rules('rfc','RFC','required');
                //$this->form_validation->set_rules('curp','CURP','required');

                if($this->form_validation->run())
                {
                    //informncion general de la pérsona
                    $data_clte['clte_nombre_crypt'] =  trim($this->input->post('nombre'));
                    $data_clte['clte_2_nombre_crypt'] =  trim($this->input->post('nombre_adic'));
                    $data_clte['clte_paterno_crypt'] =  trim($this->input->post('paterno'));
                    $data_clte['clte_materno_crypt'] =  trim($this->input->post('materno'));
                    
					$data_clte['clte_f_nac'] = formatea_fecha_mysql($this->input->post('fnac'));
                    $data_clte['clte_genero_cve'] =  $this->input->post('genero');
                    $data_clte['clte_rfc_crypt'] =  $this->input->post('rfc');
                    $data_clte['clte_curp_crypt'] =  $this->input->post('curp');

                    //dopmcicio de la persona
                    $data_clte['clte_env_pais_cve'] =  $this->input->post('pais');
                    $data_clte['clte_env_cp'] =  $this->input->post('cp');
                    $data_clte['clte_env_edo_cve'] =  $this->input->post('entidad');
                    $data_clte['clte_env_colonia_crypt'] =  $this->input->post('colonia');
                    $data_clte['clte_env_localidad'] =  $this->input->post('localidad');
                    $data_clte['clte_env_municipio'] =  $this->input->post('municipio');
                    $data_clte['clte_env_calle_crypt'] =  $this->input->post('calle');
                    $data_clte['clte_env_num_ext_crypt'] =  $this->input->post('next');
                    $data_clte['clte_env_num_int_crypt'] =  $this->input->post('nint');
					$data_clte['clte_nss_crypt'] =  $this->input->post('nss');
                    //informacion de conrtaxcto de la persona
                    $data_clte['clte_tel_casa_crypt'] = limpia_telefono($this->input->post('tel'));                
                    $data_clte['clte_cel_crypt'] =  limpia_telefono($this->input->post('cel'));
                    $data_clte['clte_email_crypt'] =  $this->input->post('correo');

                    //nuevos campos
                    $data_clte['clte_grado_acad_cve'] =  $this->input->post('grado');
                    $data_clte['clte_puesto'] =  $this->input->post('puesto');
                    $data_clte['clte_edo_civ_cve'] =  $this->input->post('civil');
                    $data_clte['clte_nac_cve'] =  $this->input->post('nac');

                    //empresa donde va a loborar la persona
                    $data_clte['emp_id'] =  $this->input->post('empresa');
                    
                    //nuevo campo de unicacion
                    $data_clte['clte_lab_ubicacion'] =  $this->input->post('ubicacion');
                     
					//despachos 
					/*
					$data_clte['desp_id'] =  $this->input->post('despacho');
					$data_clte['clte_reclutador'] =  $this->input->post('reclutador');					 
					 
					
					$nomserv='';
					if ($this->input->post('nom35i') == 'OK')
					{$nomserv=$nomserv.'nom0351;';}	
					if ($this->input->post('nom35ii') == 'OK')
					{$nomserv=$nomserv.'nom0352;';}
					if ($this->input->post('nom35iii') == 'OK')
					{$nomserv=$nomserv.'nom0353;';}	
					
					
					if ($this->input->post('honestidad') == 'OK')
					{$nomserv=$nomserv.'HONE;';}
					if ($this->input->post('comportamiento') == 'OK')
					{$nomserv=$nomserv.'COMPO;';}
					if ($this->input->post('certificado') == 'OK')
					{$nomserv=$nomserv.'CERTI;';}
					*/
					
					/*						
					$cat_examen = get_cat_nombre_var('EXAMEN');
					$i=0;
					$cat_categorias = get_cat_nombre_var('CATEGORIA_EX');
					foreach($cat_categorias as $categoria): 
						$linea_examenes=get_examen_de_empresa_por_categoria($activo['emp_id'], $categoria['cat_nombre']);
						
						if (strlen($linea_examenes) > 0)
						{
							foreach (explode(';', $linea_examenes) as $det):
								if (strlen($det) > 0)
								{
									$exa=$this->input->post($categoria['cat_nombre'].'_'.$i);
									$nomserv.=$exa;
									$i++;
								}								
							endforeach;										
						}
					endforeach;
					

					$data_clte['nomserv'] =  $nomserv;
					*/
					
					
					// Se convierte en un empleado de empresa
					$data_clte['empleado'] =  1;
					//echo $this->input->post('estatus');
					$data_clte['num_empleado'] = $this->input->post('nempleado');
					//if ($this->input->post('estatus') == 'noactivo')
					{
						$data_clte['status'] =  $this->input->post('status');
					}
		
                    //despacho
					/*
                      $data_clte['desp_id'] =  $this->input->post('despacho');
					  if ($data_clte['desp_id'] == 1) {$data_clte['desp_id']=0;}
					  $data_clte['clte_reclutador'] =  $this->input->post('reclutador');
					
					
					if ($this->input->post('serv_id') > 0)
					{	
						$data_clte['serv_id'] =$this->input->post('serv_id');
					}				
					*/
					
					//sucursal
					/*
					$data_clte['suc_id'] =  $this->input->post('sucursal');
					*/
					//cei
					/*
					$data_clte['cei_id'] =  $this->input->post('cei');
					*/
					
//*************************************
//$data_clte['root'] = 'OK';
//*************************************


                    if(!empty($_FILES['foto']['name']))
                    {
                        $this->load->library('upload');
                        $filename = md5(time());
                        $config = array(
                                'upload_path'   => './../../files/fotos/',
                                'overwrite'     => TRUE,
                                'file_name'     => $filename,
                                'allowed_types' => 'png|jpg|jpeg',
                                'max_size'      => '10000'
                        );

                        $this->upload->initialize($config);
                        if ( ! $this->upload->do_upload('foto'))
                        {
                            send_json_error($this->upload->display_errors());
                        }
                        else 
                        {
                            $data = $this->upload->data();
                            $data_clte['clte_path_foto'] = $data['file_name'];
                        }
                    }

					if (($data_clte['clte_f_nac'] =='') && ($data_clte['emp_id'] !=152))
					{
						send_json_error('Ocurrió un error, no se registro la FECHA DE NACIMIENTO.');
					}
                    else
					{
						
						if ($this->input->post('rregistrar') == 'rr')
						{						
							if($this->activo->actualiza_registro($activo_id, array_to_upper($data_clte)))
							{
								send_json_ok(array('msg' =>'Se actualizó y registro nuevamente el evaluado de forma correcta', 'id' => $activo_id));
							}
							else
							{
								send_json_error('Ocurrió un error al actualizar la persona.');
							}
						}
						else
						{	
						
							if($this->activo->actualiza($activo_id, array_to_upper($data_clte)))
							{
								send_json_ok(array('msg' =>'Se actualizado el registro del empleado de forma correcta.', 'id' => $activo_id));
							}
							else
							{
								send_json_error('Ocurrió un error al actualizar al empleado.');
							}
						}
					}
                }
                else
                {
                    send_json_error(validation_errors('<div />'));
                }
            }
            else 
            {
				//echo "----------->".$activo['suc_id']."<-----------";
                $this->load->model('empresa/Empresa_model','empresa');
                $data['empresas'] = $this->empresa->trae_empresas();//$this->empresa->get_all_empresas();
				$data['despachos'] = $this->empresa->get_all_despachos();
				$data['sucursals'] = $this->empresa->get_all_sucursales();
				$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($activo['emp_id']);
                $data['persona'] = 	$activo;
				if ($activo['serv_id'] > 0)
				{
					$data['servicio'] = $servicio;
				}
                $this->load->helper('template');
                $params_view = array(
                    'title' => 'Personas',
                    'view' => 'activo/edit_d',
                    'view_data' => $data
                   );
                render_template($params_view);  
            }
        }
        else 
        {
            show_error('No existe el activo');
        }
    }


    public function edita_f($activo_id)
    {           
		$activo = $this->activo->get($activo_id);
        
		if ($activo['serv_id'] > 0)
		{	
			$servicio = $this->servicio->get($activo['serv_id']);
		}
		
        if($activo)
        {

            if(isset($_POST) && count($_POST) > 0)     
            {
                $this->load->library('form_validation');
                $this->form_validation->set_rules('nombre','Nombre','required');
                $this->form_validation->set_rules('paterno','Apellido Paterno','required');
                $this->form_validation->set_rules('materno','Apellido Materno','required');
                /*$this->form_validation->set_rules('fnac','Fecha de nacimiento','required');*/
                $this->form_validation->set_rules('genero','Género','required');
                //$this->form_validation->set_rules('civil','Estado civil','required');
                //$this->form_validation->set_rules('rfc','RFC','required');
                //$this->form_validation->set_rules('curp','CURP','required');

                if($this->form_validation->run())
                {
                    //informncion general de la pérsona
                    $data_clte['clte_nombre_crypt'] =  trim($this->input->post('nombre'));
                    $data_clte['clte_2_nombre_crypt'] =  trim($this->input->post('nombre_adic'));
                    $data_clte['clte_paterno_crypt'] =  trim($this->input->post('paterno'));
                    $data_clte['clte_materno_crypt'] =  trim($this->input->post('materno'));
                    
					$data_clte['clte_f_nac'] = $this->input->post('fnac');
                    $data_clte['clte_genero_cve'] =  $this->input->post('genero');
                    /*$data_clte['clte_rfc_crypt'] =  $this->input->post('rfc');
                    $data_clte['clte_curp_crypt'] =  $this->input->post('curp');*/

                    //dopmcicio de la persona
                    /* $data_clte['clte_env_pais_cve'] =  $this->input->post('pais');
                    $data_clte['clte_env_cp'] =  $this->input->post('cp');
                    $data_clte['clte_env_edo_cve'] =  $this->input->post('entidad');
                    $data_clte['clte_env_colonia_crypt'] =  $this->input->post('colonia');
                    $data_clte['clte_env_localidad'] =  $this->input->post('localidad');
                    $data_clte['clte_env_municipio'] =  $this->input->post('municipio');
                    $data_clte['clte_env_calle_crypt'] =  $this->input->post('calle');
                    $data_clte['clte_env_num_ext_crypt'] =  $this->input->post('next');
                    $data_clte['clte_env_num_int_crypt'] =  $this->input->post('nint');
					$data_clte['clte_nss_crypt'] =  $this->input->post('nss');*/
                    //informacion de conrtaxcto de la persona
                    /*$data_clte['clte_tel_casa_crypt'] = limpia_telefono($this->input->post('tel'));                
                    $data_clte['clte_cel_crypt'] =  limpia_telefono($this->input->post('cel'));
                    $data_clte['clte_email_crypt'] =  $this->input->post('correo');*/

                    //nuevos campos
                   /* $data_clte['clte_grado_acad_cve'] =  $this->input->post('grado');*/
                    $data_clte['clte_puesto'] =  $this->input->post('puesto');
                    /*$data_clte['clte_edo_civ_cve'] =  $this->input->post('civil');*/
                    /*$data_clte['clte_nac_cve'] =  $this->input->post('nac');*/

                    //empresa donde va a loborar la persona
                    //$data_clte['emp_id'] =  $this->input->post('empresa');
                    
                    //nuevo campo de unicacion
                    //$data_clte['clte_lab_ubicacion'] =  $this->input->post('ubicacion');
                     
					//despachos 
					/*
					$data_clte['desp_id'] =  $this->input->post('despacho');
					$data_clte['clte_reclutador'] =  $this->input->post('reclutador');					 
					 
					
					$nomserv='';
					if ($this->input->post('nom35i') == 'OK')
					{$nomserv=$nomserv.'nom0351;';}	
					if ($this->input->post('nom35ii') == 'OK')
					{$nomserv=$nomserv.'nom0352;';}
					if ($this->input->post('nom35iii') == 'OK')
					{$nomserv=$nomserv.'nom0353;';}	
					
					
					if ($this->input->post('honestidad') == 'OK')
					{$nomserv=$nomserv.'HONE;';}
					if ($this->input->post('comportamiento') == 'OK')
					{$nomserv=$nomserv.'COMPO;';}
					if ($this->input->post('certificado') == 'OK')
					{$nomserv=$nomserv.'CERTI;';}
					*/
					
					/*						
					$cat_examen = get_cat_nombre_var('EXAMEN');
					$i=0;
					$cat_categorias = get_cat_nombre_var('CATEGORIA_EX');
					foreach($cat_categorias as $categoria): 
						$linea_examenes=get_examen_de_empresa_por_categoria($activo['emp_id'], $categoria['cat_nombre']);
						
						if (strlen($linea_examenes) > 0)
						{
							foreach (explode(';', $linea_examenes) as $det):
								if (strlen($det) > 0)
								{
									$exa=$this->input->post($categoria['cat_nombre'].'_'.$i);
									$nomserv.=$exa;
									$i++;
								}								
							endforeach;										
						}
					endforeach;
					

					$data_clte['nomserv'] =  $nomserv;
					*/
					
					
					// Se convierte en un empleado de empresa
					$data_clte['paciente'] =  1;
					//echo $this->input->post('estatus');
					$data_clte['num_empleado'] = $this->input->post('nempleado');
					//if ($this->input->post('estatus') == 'noactivo')
					/*{
						$data_clte['status'] =  $this->input->post('status');
					}*/
		
                    //despacho
					/*
                      $data_clte['desp_id'] =  $this->input->post('despacho');
					  if ($data_clte['desp_id'] == 1) {$data_clte['desp_id']=0;}
					  $data_clte['clte_reclutador'] =  $this->input->post('reclutador');
					
					
					if ($this->input->post('serv_id') > 0)
					{	
						$data_clte['serv_id'] =$this->input->post('serv_id');
					}				
					*/
					
					//sucursal
					/*
					$data_clte['suc_id'] =  $this->input->post('sucursal');
					*/
					//cei
					/*
					$data_clte['cei_id'] =  $this->input->post('cei');
					*/
					
//*************************************
//$data_clte['root'] = 'OK';
//*************************************


                    if(!empty($_FILES['foto']['name']))
                    {
                        $this->load->library('upload');
                        $filename = md5(time());
                        $config = array(
                                'upload_path'   => './../../files/fotos/',
                                'overwrite'     => TRUE,
                                'file_name'     => $filename,
                                'allowed_types' => 'png|jpg|jpeg',
                                'max_size'      => '10000'
                        );

                        $this->upload->initialize($config);
                        if ( ! $this->upload->do_upload('foto'))
                        {
                            send_json_error($this->upload->display_errors());
                        }
                        else 
                        {
                            $data = $this->upload->data();
                            $data_clte['clte_path_foto'] = $data['file_name'];
                        }
                    }

					if (($data_clte['clte_f_nac'] =='') && ($data_clte['emp_id'] !=152))
					{
						send_json_error('Ocurrió un error, no se registro la FECHA DE NACIMIENTO.');
					}
                    else
					{
						
						if ($this->input->post('rregistrar') == 'rr')
						{						
							if($this->activo->actualiza_registro($activo_id, array_to_upper($data_clte)))
							{
								send_json_ok(array('msg' =>'Se actualizó y registro nuevamente el evaluado de forma correcta', 'id' => $activo_id));
							}
							else
							{
								send_json_error('Ocurrió un error al actualizar la persona.');
							}
						}
						else
						{	
						
							if($this->activo->actualiza($activo_id, array_to_upper($data_clte)))
							{
								send_json_ok(array('msg' =>'Se actualizado el registro del Paciente de forma correcta.', 'id' => $activo_id));
							}
							else
							{
								send_json_error('Ocurrió un error al actualizar al Paciente.');
							}
						}
					}
                }
                else
                {
                    send_json_error(validation_errors('<div />'));
                }
            }
            else 
            {
				//echo "----------->".$activo['suc_id']."<-----------";
                $this->load->model('empresa/Empresa_model','empresa');
                $data['empresas'] = $this->empresa->trae_empresas();//$this->empresa->get_all_empresas();
				$data['despachos'] = $this->empresa->get_all_despachos();
				$data['sucursals'] = $this->empresa->get_all_sucursales();
				$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($activo['emp_id']);
                $data['persona'] = 	$activo;
				if ($activo['serv_id'] > 0)
				{
					$data['servicio'] = $servicio;
				}
                $this->load->helper('template');
                $params_view = array(
                    'title' => 'Personas',
                    'view' => 'activo/edit_f',
                    'view_data' => $data
                   );
                render_template($params_view);  
            }
        }
        else 
        {
            show_error('No existe el activo');
        }
    }
 
    public function nuevo()
    {    
		$user_root4=get_my_user_root4();
		$user = $this->session->user; 
		$medico = $this->medico->get($user['usr_id']);
	    //date_default_timezone_set('America/Mexico_City');
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('nombre','Nombre','required');
            $this->form_validation->set_rules('paterno','Apellido Paterno','required');
            $this->form_validation->set_rules('materno','Apellido Materno','required');
            //$this->form_validation->set_rules('fnac','Fecha de nacimiento','required');
            $this->form_validation->set_rules('genero','Género','required');
           // $this->form_validation->set_rules('civil','Estado civil','required');
           // $this->form_validation->set_rules('rfc','RFC','required');           
           //$this->form_validation->set_rules('curp','CURP','required');

            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_nombre_crypt'] =  trim($this->input->post('nombre'));
                $data_clte['clte_2_nombre_crypt'] =  trim($this->input->post('nombre_adic'));
                $data_clte['clte_paterno_crypt'] =  trim($this->input->post('paterno'));
                $data_clte['clte_materno_crypt'] =  trim($this->input->post('materno'));
                
				//$data_clte['clte_f_nac'] = formatea_fecha_mysql($this->input->post('fnac'));
                
				$data_clte['clte_f_nac'] = $this->input->post('fnac');
				
				$data_clte['clte_genero_cve'] =  $this->input->post('genero');
                				
				$data_clte['clte_rfc_crypt'] =  $this->input->post('rfc');
                				
				$data_clte['clte_curp_crypt'] =  $this->input->post('curp');
                
                //dopmcicio de la persona
                $data_clte['clte_env_pais_cve'] =  $this->input->post('pais');
                $data_clte['clte_env_cp'] =  $this->input->post('cp');
                $data_clte['clte_env_edo_cve'] =  $this->input->post('entidad');
                $data_clte['clte_env_colonia_crypt'] =  $this->input->post('colonia');
                $data_clte['clte_env_localidad'] =  $this->input->post('localidad');
                $data_clte['clte_env_municipio'] =  $this->input->post('municipio');
                $data_clte['clte_env_calle_crypt'] =  $this->input->post('calle');
                $data_clte['clte_env_num_ext_crypt'] =  $this->input->post('next');
                $data_clte['clte_env_num_int_crypt'] =  $this->input->post('nint');
                $data_clte['clte_nss_crypt'] =  $this->input->post('nss');
                //informacion de conrtaxcto de la persona
                $data_clte['clte_tel_casa_crypt'] =  limpia_telefono($this->input->post('tel'));                
                $data_clte['clte_cel_crypt'] =  limpia_telefono($this->input->post('cel'));
                $data_clte['clte_email_crypt'] =  $this->input->post('correo');
                
                //nuevos campos
                $data_clte['clte_grado_acad_cve'] =  $this->input->post('grado');
                $data_clte['clte_puesto'] =  $this->input->post('puesto');
                $data_clte['clte_edo_civ_cve'] =  $this->input->post('civil');
                $data_clte['clte_nac_cve'] =  $this->input->post('nac');
                
                //empresa donde va a loborar la persona
                $data_clte['emp_id'] =  $this->input->post('empresa');
				

                
                //nuevo campo de ubicacion
                $data_clte['clte_lab_ubicacion'] =  $this->input->post('ubicacion');

                //despacho
                  $data_clte['desp_id'] =  $this->input->post('despacho');
				  if ($data_clte['desp_id'] == 1) {$data_clte['desp_id']=0;}
			      $data_clte['clte_reclutador'] =  $this->input->post('reclutador');
				
				//orden de servicio	nueva estrutura para evaluados 13 feb 2020
				/* $bandera=0;
				if ($this->input->post('serv_id') > 0)
				{	
					if ($this->input->post('empresa') == 31)
					{	
						$data_clte['serv_id'] = 215;
					}
					else
					{
						$servicio_form = $this->servicio->get_evaluado($this->input->post('serv_id'),$data_clte['emp_id']);
						if ($servicio_form['serv_id'] > 0)
						{	
							$data_clte['desp_id'] =  $servicio_form['desp_id'];
							$data_clte['clte_reclutador'] =  $servicio_form['reclutador'];
							$data_clte['serv_id'] =  $this->input->post('serv_id');
						}
						else
						{
							$bandera=1;
						}	
					}
				} */
				
				
				//sucursal
                $data_clte['suc_id'] =  $this->input->post('sucursal');
				//cei
				if ($this->input->post('empresa') == 16)
				{	
					$data_clte['cei_id'] =  7;
				}
				else 
				{
					if ($this->input->post('empresa') == 31)
					{	
						$data_clte['cei_id'] =  2;
					}
					else
					{
						$data_clte['cei_id'] =  $this->input->post('cei');
					}
				}


				if (valida_corporacion($data_clte['emp_id'],'GSI') === 'GSI')
				{
					
					if ( ($data_clte['cei_id'] !=6) || ($data_clte['cei_id'] !=4) )
					{
						$data_clte['cei_id'] = 4;
					}
					
				}


                $data_clte['desp_id'] =  $this->input->post('despacho');
                $data_clte['clte_reclutador'] =  $this->input->post('reclutador');
				
				//examenes
				
					$nomserv='';





                
                if(!empty($_FILES['foto']['name']))
                {
                    $this->load->library('upload');
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/fotos/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg',
                            'max_size'      => '10000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('foto'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['clte_path_foto'] = $data['file_name'];
                    }
                }
				
				if ($data_clte['emp_id'] == 152)
				{
					$data_clte['nomserv']='SGMTY;';
				}elseif ($data_clte['emp_id'] == 194)
				{
					$data_clte['nomserv']='PREVEM;';
				}elseif ($data_clte['emp_id'] == 182)
				{
					$data_clte['nomserv']='FILOA;';
				}elseif ($data_clte['emp_id'] == 193)
				{
					$data_clte['nomserv']='ALLIANZ;';
				} 

				$data_clte=array_to_upper($data_clte);
				$encontrado = $this->activo->buscate($data_clte['clte_nombre_crypt'], $data_clte['clte_2_nombre_crypt'],  $data_clte['clte_paterno_crypt'],$data_clte['clte_materno_crypt']);
				$diff=61;
				
				$rfc_test=$data_clte['clte_rfc_crypt'];
				
				$encontrado_error_long_rfc=0;
				
				
				//if ($data_clte['emp_id'] == 152)
				{
					if (strlen($data_clte['clte_rfc_crypt']) < 10)
					{						
						$data_clte['clte_rfc_crypt']=substr($data_clte['clte_paterno_crypt'],0,2).substr($data_clte['clte_materno_crypt'],0,1).substr($data_clte['clte_nombre_crypt'],0,1).substr($data_clte['clte_f_nac'],2,2).substr($data_clte['clte_f_nac'],5,2).substr($data_clte['clte_f_nac'],8,2);
					}
				}
             /*   else				
				{	
					if (strlen($rfc_test) <10)
					{
						$encontrado_long_rfc=1;
					}
					else
					{
						$rfc_test= substr($rfc_test,0,10);
						$encontrado_rfc = $this->activo->buscate_rfc($rfc_test,$data_clte['emp_id']);
					}	
				}*/
				
				
				
				if ($encontrado)
				{
					$unafecha=$encontrado[0]['log_insrt_f'];
					$diff= abs(intval(dateDifference($unafecha,date('Y-m-d'))));

				}
	             
				if (($encontrado) && ( $diff < 20))
				{
					send_json_error('Ocurrió un error, el candidato ya fue registrado en la plataforma en la fecha '.formatea_fecha($unafecha).', hace '.$diff.' días.');
				}
				elseif ($data_clte['emp_id'] ==0)
				{
					send_json_error('Ocurrió un error, no se selecciono la EMPRESA.');
					
				}
				elseif (($data_clte['clte_f_nac'] =='') && ($data_clte['emp_id'] !=152))
				{
					send_json_error('Ocurrió un error, no se registro la FECHA DE NACIMIENTO.');
				}				
				/*elseif( $encontrado_long_rfc ==1)
				{
					send_json_error('Ocurrió un error, el RFC capturado: "'.$rfc_test.'", debe tener al menos 10 caracteres.');
					
				} elseif($encontrado_rfc)
				{
					send_json_error('Ocurrió un error, el evaluado ya habia sido registrado anterioremente con el ID "'.$encontrado_rfc[0]['clte_id'].'", por favor usar el registro ya establecido.');
				}*/				
				elseif($activo_id = $this->activo->inserta(array_to_upper($data_clte)))
                {
                    send_json_ok(array('msg' =>'Se guardó de forma correcta el registro del evaluado.', 'id' => $activo_id));
                }
                else
                {
                    send_json_error('Ocurrió un error al guardar la persona.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
			
            $this->load->model('empresa/Empresa_model','empresa');
			if ($user_root4 == 5)
			{
				$data['empresas'] = $this->empresa->trae_emp_asig($medico['usr_emp_asig']);			
			}
			else
			{
				$data['empresas'] = $this->empresa->trae_empresas();//$this->empresa->get_all_empresas();
			}
			$data['sucursals'] = $this->empresa->get_all_sucursales();
			$data['despachos'] = $this->empresa->get_all_despachos();
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'activo/add',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }

/*************************************************************************************/
    public function nuevo_n()
    {    
	    //date_default_timezone_set('America/Mexico_City');
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('nombre','Nombre','required');
            $this->form_validation->set_rules('paterno','Apellido Paterno','required');
            $this->form_validation->set_rules('materno','Apellido Materno','required');
            $this->form_validation->set_rules('fnac','Fecha de nacimiento','required');
            $this->form_validation->set_rules('genero','Género','required');
           // $this->form_validation->set_rules('civil','Estado civil','required');
            $this->form_validation->set_rules('rfc','RFC','required');
            //
            //$this->form_validation->set_rules('curp','CURP','required');

            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_nombre_crypt'] =  trim($this->input->post('nombre'));
                $data_clte['clte_2_nombre_crypt'] =  trim($this->input->post('nombre_adic'));
                $data_clte['clte_paterno_crypt'] =  trim($this->input->post('paterno'));
                $data_clte['clte_materno_crypt'] =  trim($this->input->post('materno'));
                
				$data_clte['clte_f_nac'] = formatea_fecha_mysql($this->input->post('fnac'));
                $data_clte['clte_genero_cve'] =  $this->input->post('genero');
      				
				$data_clte['clte_rfc_crypt'] =  $this->input->post('rfc');
                				
				$data_clte['clte_curp_crypt'] = ''; // $this->input->post('curp');
                
                //dopmcicio de la persona
                $data_clte['clte_env_pais_cve'] =  $this->input->post('pais');
                $data_clte['clte_env_cp'] =  $this->input->post('cp');
                $data_clte['clte_env_edo_cve'] =  $this->input->post('entidad');
                $data_clte['clte_env_colonia_crypt'] =  $this->input->post('colonia');
                $data_clte['clte_env_localidad'] =  $this->input->post('localidad');
                $data_clte['clte_env_municipio'] =  $this->input->post('municipio');
                $data_clte['clte_env_calle_crypt'] =  $this->input->post('calle');
                $data_clte['clte_env_num_ext_crypt'] =  $this->input->post('next');
                $data_clte['clte_env_num_int_crypt'] =  $this->input->post('nint');
				
                $data_clte['clte_nss_crypt'] = ''; // $this->input->post('nss');
                
				//informacion de conrtaxcto de la persona
                $data_clte['clte_tel_casa_crypt'] =  limpia_telefono($this->input->post('tel'));                
                $data_clte['clte_cel_crypt'] =  limpia_telefono($this->input->post('cel'));
                $data_clte['clte_email_crypt'] =  $this->input->post('correo');
                
                //nuevos campos
                $data_clte['clte_grado_acad_cve'] =  $this->input->post('grado');
                $data_clte['clte_puesto'] =  $this->input->post('puesto');
                $data_clte['clte_edo_civ_cve'] =  $this->input->post('civil');
                $data_clte['clte_nac_cve'] =  $this->input->post('nac');
                
                //empresa donde va a loborar la persona
                $data_clte['emp_id'] = 189 ;  // solo NOVERITE //$this->input->post('empresa');
                
                //nuevo campo de ubicacion
                $data_clte['clte_lab_ubicacion'] = ''; // $this->input->post('ubicacion');

                //despacho
				$data_clte['desp_id']=0;
			    $data_clte['clte_reclutador'] ='';  //$this->input->post('reclutador');
				
				//sucursal
                $data_clte['suc_id'] =0;//$this->input->post('sucursal');
				$data_clte['cei_id'] =  2;
				//examenes
				/* 	$data_clte['acred'] =''; //  $this->input->post('acreditacion'); 	
					$data_clte['biohem'] =''; //   $this->input->post('biometria_hematica'); 		
					$data_clte['ced_pol'] =''; //   $this->input->post('poligrafo_celula'); 
					$data_clte['ced_psci'] =''; //   $this->input->post('psico_celula'); 				
					$data_clte['sangre'] =''; //   $this->input->post('sangre'); 
					$data_clte['sociol'] =''; //   $this->input->post('sociolaboral'); 						
					$data_clte['hist'] =''; //   $this->input->post('historia_clinica'); 	 	
					$data_clte['entsoc'] =''; //   $this->input->post('entorno_social'); 	 	
					$data_clte['estsoc'] =''; //   $this->input->post('estudio_socioeconomico'); 	 	
					$data_clte['eyed'] =''; //   $this->input->post('eye'); 	 	
					$data_clte['fpfh0105'] =''; //   $this->input->post('fpfh0105'); 	 	
					$data_clte['medfis'] =''; //   $this->input->post('medico_fisico'); 	 	
					$data_clte['odo'] =''; //   $this->input->post('odontologica'); 	 	
					$data_clte['orina'] =''; //   $this->input->post('orina'); 	 	
					$data_clte['pie'] =''; //   $this->input->post('pie'); 	 	
					$data_clte['pol'] =''; //   $this->input->post('poligrafo_reporte'); 	 	
					$data_clte['psci'] ='OK'; //   $this->input->post('psico_reporte'); 	 	
					$data_clte['repsic'] =''; //   $this->input->post('psico_reporte'); 	 	
					$data_clte['quisan'] =''; //   $this->input->post('quimica_sanguinea'); 	 	
					$data_clte['socie'] ='OK'; //   $this->input->post('socioeconomico'); 	 	
					$data_clte['toxi'] ='OK'; //   $this->input->post('toxicologico5');
					$data_clte['pssim'] =''; //   $this->input->post('psico_simple'); 
					$data_clte['toxin'] =''; //   $this->input->post('toxicologico9'); 	
					$data_clte['toxis'] =''; //   $this->input->post('toxicologico7'); 	 
					$data_clte['pyb'] =''; //   $this->input->post('pyb');*/
					
					$nomserv='';
					
					/*
					if ($this->input->post('nom35i') == 'OK')
					{$nomserv=$nomserv.'nom0351,';}	
					if ($this->input->post('nom35ii') == 'OK')
					{$nomserv=$nomserv.'nom0352,';}
					if ($this->input->post('nom35iii') == 'OK')
					{$nomserv=$nomserv.'nom0353,';}	
					if ($this->input->post('honestidad') == 'OK')
					{$nomserv=$nomserv.'HONE,';}
					if ($this->input->post('comportamiento') == 'OK')
					{$nomserv=$nomserv.'COMPO,';}	
					*/
				
					$data_clte['nomserv'] =  $nomserv;

 /***************************** CARGA DE LA FOTO DEL EVALUADO ************************/               
                if(!empty($_FILES['foto']['name']))
                {
                    $this->load->library('upload');
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/fotos/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg',
                            'max_size'      => '10000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('foto'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['clte_path_foto'] = $data['file_name'];
                    }
                }
/*************************************************************************************/
				$data_clte=array_to_upper($data_clte);
				
				$encontrado = $this->activo->buscate($data_clte['clte_nombre_crypt'], $data_clte['clte_2_nombre_crypt'],  $data_clte['clte_paterno_crypt'],$data_clte['clte_materno_crypt']);
				$diff=61;
				
				$rfc_test=$data_clte['clte_rfc_crypt'];
				
				$encontrado_error_long_rfc=0;
				
				if (strlen($rfc_test) <10)
				{
					$encontrado_long_rfc=1;
				}
				else
				{
					$rfc_test= substr($rfc_test,0,10);
					$encontrado_rfc = $this->activo->buscate_rfc($rfc_test,$data_clte['emp_id']);
				}	
			
				
				if ($encontrado)
				{
					$unafecha=$encontrado[0]['log_insrt_f'];
					$diff= abs(intval(dateDifference($unafecha,date('Y-m-d'))));

				}
	             
				if (($encontrado) && ( $diff < 20))
				{
					send_json_error('Ocurrió un error, el candidato ya fue registrado en la plataforma en la fecha '.formatea_fecha($unafecha).', hace '.$diff.' días.');
				}
				elseif( $encontrado_long_rfc ==1)
				{
					send_json_error('Ocurrió un error, el RFC capturado: "'.$rfc_test.'", debe tener al menos 10 caracteres.');
					
				}elseif($encontrado_rfc)
				{
					send_json_error('Ocurrió un error, el evaluado ya habia sido registrado anterioremente con el ID "'.$encontrado_rfc[0]['clte_id'].'", por favor usar el registro ya establecido.');
				}
				elseif($activo_id = $this->activo->inserta(array_to_upper($data_clte)))
                {
                    send_json_ok(array('msg' =>'Se guardó de forma correcta', 'id' => $activo_id));
                    
                }
                else
                {
                    send_json_error('Ocurrió un error al guardar la persona.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $this->load->model('empresa/Empresa_model','empresa');
            $data['empresas'] = $this->empresa->get_all_empresas();
			$data['sucursals'] = $this->empresa->get_all_sucursales();
			$data['despachos'] = $this->empresa->get_all_despachos();
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'activo/add_n',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }


/*************************************************************************************/


/*************************************************************************************/
    public function nuevo_gsi()
    {    
	    //date_default_timezone_set('America/Mexico_City');
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('nombre','Nombre','required');
            $this->form_validation->set_rules('paterno','Apellido Paterno','required');
            $this->form_validation->set_rules('materno','Apellido Materno','required');
            $this->form_validation->set_rules('fnac','Fecha de nacimiento','required');
            $this->form_validation->set_rules('genero','Género','required');
            //$this->form_validation->set_rules('civil','Estado civil','required');
            //$this->form_validation->set_rules('rfc','RFC','required');
            //
            //$this->form_validation->set_rules('curp','CURP','required');

            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_nombre_crypt'] =  trim($this->input->post('nombre'));
                $data_clte['clte_2_nombre_crypt'] =  trim($this->input->post('nombre_adic'));
                $data_clte['clte_paterno_crypt'] =  trim($this->input->post('paterno'));
                $data_clte['clte_materno_crypt'] =  trim($this->input->post('materno'));
                
				$data_clte['clte_f_nac'] = formatea_fecha_mysql($this->input->post('fnac'));
                $data_clte['clte_genero_cve'] =  $this->input->post('genero');
      				
				$data_clte['clte_rfc_crypt'] =  $this->input->post('rfc');
                

				if (strlen($data_clte['clte_rfc_crypt']) < 10)
				{						
					$data_clte['clte_rfc_crypt']=substr($data_clte['clte_paterno_crypt'],0,2).substr($data_clte['clte_materno_crypt'],0,1).substr($data_clte['clte_nombre_crypt'],0,1).substr($data_clte['clte_f_nac'],2,2).substr($data_clte['clte_f_nac'],5,2).substr($data_clte['clte_f_nac'],8,2);
				}
				
				$data_clte['clte_curp_crypt'] = ''; // $this->input->post('curp');
                
                //dopmcicio de la persona
                $data_clte['clte_env_pais_cve'] =  $this->input->post('pais');
                $data_clte['clte_env_cp'] =  $this->input->post('cp');
                $data_clte['clte_env_edo_cve'] =  $this->input->post('entidad');
                $data_clte['clte_env_colonia_crypt'] =  $this->input->post('colonia');
                $data_clte['clte_env_localidad'] =  $this->input->post('localidad');
                $data_clte['clte_env_municipio'] =  $this->input->post('municipio');
                $data_clte['clte_env_calle_crypt'] =  $this->input->post('calle');
                $data_clte['clte_env_num_ext_crypt'] =  $this->input->post('next');
                $data_clte['clte_env_num_int_crypt'] =  $this->input->post('nint');
				
                $data_clte['clte_nss_crypt'] = ''; // $this->input->post('nss');
                
				//informacion de conrtaxcto de la persona
                $data_clte['clte_tel_casa_crypt'] =  limpia_telefono($this->input->post('tel'));                
                $data_clte['clte_cel_crypt'] =  limpia_telefono($this->input->post('cel'));
                $data_clte['clte_email_crypt'] =  $this->input->post('correo');
                
                //nuevos campos
                $data_clte['clte_grado_acad_cve'] =  $this->input->post('grado');
                $data_clte['clte_puesto'] =  $this->input->post('puesto');
                $data_clte['clte_edo_civ_cve'] =  $this->input->post('civil');
                $data_clte['clte_nac_cve'] =  $this->input->post('nac');
                
                //empresa donde va a laborar la persona
                $data_clte['emp_id'] = $this->input->post('empresa');  // solo GSIS //$this->input->post('empresa');
                
                //nuevo campo de ubicacion
                $data_clte['clte_lab_ubicacion'] = ''; // $this->input->post('ubicacion');

                //despacho
				$data_clte['desp_id']=$this->input->post('despacho');
			    $data_clte['clte_reclutador'] = $this->input->post('reclutador');
				
				//sucursal
                $data_clte['suc_id'] =0;//$this->input->post('sucursal');
				$data_clte['cei_id'] =  4;
				
				/*examenes
				 	$data_clte['acred'] =''; //  $this->input->post('acreditacion'); 	
					$data_clte['biohem'] =''; //   $this->input->post('biometria_hematica'); 		
					$data_clte['ced_pol'] =''; //   $this->input->post('poligrafo_celula'); 
					$data_clte['ced_psci'] =''; //   $this->input->post('psico_celula'); 				
					$data_clte['sangre'] =''; //   $this->input->post('sangre'); 
					$data_clte['sociol'] =''; //   $this->input->post('sociolaboral'); 						
					$data_clte['hist'] =''; //   $this->input->post('historia_clinica'); 	 	
					$data_clte['entsoc'] =''; //   $this->input->post('entorno_social'); 	 	
					$data_clte['estsoc'] =''; //   $this->input->post('estudio_socioeconomico'); 	 	
					$data_clte['eyed'] =''; //   $this->input->post('eye'); 	 	
					$data_clte['fpfh0105'] =''; //   $this->input->post('fpfh0105'); 	 	
					$data_clte['medfis'] =''; //   $this->input->post('medico_fisico'); 	 	
					$data_clte['odo'] =''; //   $this->input->post('odontologica'); 	 	
					$data_clte['orina'] =''; //   $this->input->post('orina'); 	 	
					$data_clte['pie'] =''; //   $this->input->post('pie'); 	 	
					$data_clte['pol'] =''; //   $this->input->post('poligrafo_reporte'); 	 	
					$data_clte['psci'] ='OK'; //   $this->input->post('psico_reporte'); 	 	
					$data_clte['repsic'] =''; //   $this->input->post('psico_reporte'); 	 	
					$data_clte['quisan'] =''; //   $this->input->post('quimica_sanguinea'); 	 	
					$data_clte['socie'] ='OK'; //   $this->input->post('socioeconomico'); 	 	
					$data_clte['toxi'] ='OK'; //   $this->input->post('toxicologico5');
					$data_clte['pssim'] =''; //   $this->input->post('psico_simple'); 
					$data_clte['toxin'] =''; //   $this->input->post('toxicologico9'); 	
					$data_clte['toxis'] =''; //   $this->input->post('toxicologico7'); 	 
					$data_clte['pyb'] =''; //   $this->input->post('pyb');
				*/	
					$nomserv='';
					
				
					$data_clte['nomserv'] =  $nomserv;

 /***************************** CARGA DE LA FOTO DEL EVALUADO ************************/               
                if(!empty($_FILES['foto']['name']))
                {
                    $this->load->library('upload');
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/fotos/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg',
                            'max_size'      => '10000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('foto'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['clte_path_foto'] = $data['file_name'];
                    }
                }
/*************************************************************************************/
				$data_clte=array_to_upper($data_clte);
				
				
				if($activo_id = $this->activo->inserta(array_to_upper($data_clte)))
                {
                    send_json_ok(array('msg' =>'Se guardó de forma correcta', 'id' => $activo_id));
                    
                }
                else
                {
                    send_json_error('Ocurrió un error al guardar la persona.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $this->load->model('empresa/Empresa_model','empresa');
            $data['empresas'] = $this->empresa->get_all_empresas();
			$data['sucursals'] = $this->empresa->get_all_sucursales();
			$data['despachos'] = $this->empresa->get_all_empresas_gsi();// $this->empresa->get_all_despachos();
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'activo/add_gsi',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }


/*************************************************************************************/

    public function nuevo_p()
    {    
		$user = $this->session->user; 
		$medico = $this->medico->get($user['usr_id']);
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('nombre','Nombre','required');
            $this->form_validation->set_rules('paterno','Apellido Paterno','required');
            $this->form_validation->set_rules('materno','Apellido Materno','required');
            $this->form_validation->set_rules('fnac','Fecha de nacimiento','required');
            $this->form_validation->set_rules('genero','Género','required');

            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_nombre_crypt'] =  trim($this->input->post('nombre'));
                $data_clte['clte_2_nombre_crypt'] =  trim($this->input->post('nombre_adic'));
                $data_clte['clte_paterno_crypt'] =  trim($this->input->post('paterno'));
                $data_clte['clte_materno_crypt'] =  trim($this->input->post('materno'));
                
				$data_clte['clte_f_nac'] = $this->input->post('fnac');
                $data_clte['clte_genero_cve'] =  $this->input->post('genero');
      				
				$data_clte['clte_rfc_crypt'] =  $this->input->post('rfc');
                				
				$data_clte['clte_curp_crypt'] = ''; // $this->input->post('curp');
                $data_clte['paciente'] = 1;
                $data_clte['med_emp_asig'] = $medico['usr_emp_asig'];
				
				
                $data_clte['emp_id'] =$this->input->post('empresa');//$medico['usr_emp_asig'];
                $data_clte['clte_puesto'] = $this->input->post('puesto');
				$data_clte['num_empleado'] = $this->input->post('nempleado');
				
				//sucursal
                $data_clte['suc_id'] =0;
				$data_clte['cei_id'] =  4;

				$nomserv='RECETA;';
				$data_clte['nomserv'] =  $nomserv;
				
				

 /***************************** CARGA DE LA FOTO DEL EVALUADO ************************/               
                if(!empty($_FILES['foto']['name']))
                {
                    $this->load->library('upload');
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/fotos/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg',
                            'max_size'      => '10000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('foto'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['clte_path_foto'] = $data['file_name'];
                    }
                }
/*************************************************************************************/
				$data_clte=array_to_upper($data_clte);
				
				if($activo_id = $this->activo->inserta(array_to_upper($data_clte)))
                {
                    send_json_ok(array('msg' =>'Se guardó de forma correcta', 'id' => $activo_id));
                    
                }
                else
                {
                    send_json_error('Ocurrió un error al guardar la persona.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $this->load->model('empresa/Empresa_model','empresa');
            //$data['empresas'] = $this->empresa->get_all_empresas();
			$data['empresas'] =$this->empresa->get_all_empresas_gsi();
			$data['sucursals'] = $this->empresa->get_all_sucursales();
			$data['despachos'] = $this->empresa->get_all_despachos();
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'activo/add_p',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }

/*************************************************************************************/
    
    public function nuevo_doc($activo_id)
    {
        $persona = $this->activo->get($activo_id);
        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('nombre','Nombre documento','required');

            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_id'] =  $activo_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
				$data_clte['serv_id'] =  $persona['serv_id'];
                
                $this->load->library('upload');
                if(!empty($_FILES['doc']['name']))
                {
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/docs/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg|pdf|doc|docx',
                            'max_size'      => '10000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('doc'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['doc_path'] = $data['file_name'];
                        if($this->activo->add_doc(array_to_upper($data_clte)))
                        {
                            send_json_ok('Se guardó de forma correcta');
                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
                    send_json_error($this->upload->display_errors());
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'activo/add_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }
 
    public function nuevo_hon_doc($activo_id)
    {
        $persona = $this->activo->get($activo_id);
        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('nombre','Nombre documento','required');
			$this->form_validation->set_rules('servicio','Orden de servicio','required');
			
            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_id'] =  $activo_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                $data_clte['emp_id'] =  $this->input->post('emp_id');
				$data_clte['serv_id'] = $this->input->post('servicio');
				
				
                $this->load->library('upload');
                if(!empty($_FILES['doc']['name']))
                {
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/docs/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg|pdf|doc|docx',
                            'max_size'      => '10000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('doc'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['doc_path'] = $data['file_name'];
                        if($this->activo->add_hon_doc(array_to_upper($data_clte)))
                        {
                            send_json_ok('Se guardó de forma correcta');
                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
                    send_json_error($this->upload->display_errors());
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'activo/add_hon_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }

    public function nuevo_covid_doc($activo_id)
    {
        $persona = $this->activo->get($activo_id);
        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('nombre','Nombre documento','required');
			$this->form_validation->set_rules('servicio','Orden de servicio','required');
			
            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_id'] =  $activo_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                $data_clte['emp_id'] =  $this->input->post('emp_id');
				$data_clte['serv_id'] = $this->input->post('servicio');
				
				
                $this->load->library('upload');
                if(!empty($_FILES['doc']['name']))
                {
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/docs/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg|pdf|doc|docx',
                            'max_size'      => '10000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('doc'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['doc_path'] = $data['file_name'];
                        if($this->activo->add_covid_doc(array_to_upper($data_clte)))
                        {
                            send_json_ok('Se guardó de forma correcta');
                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
                    send_json_error($this->upload->display_errors());
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'activo/add_covid_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }

    public function nuevo_AUDIO_doc($activo_id)
    {
        $persona = $this->activo->get($activo_id);
        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('nombre','Nombre documento','required');
			$this->form_validation->set_rules('servicio','Orden de servicio','required');
			
            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_id'] =  $activo_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                $data_clte['emp_id'] =  $this->input->post('emp_id');
				$data_clte['serv_id'] = $this->input->post('servicio');
				
				
                $this->load->library('upload');
                if(!empty($_FILES['doc']['name']))
                {
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/docs/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg|pdf|doc|docx',
                            'max_size'      => '10000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('doc'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['doc_path'] = $data['file_name'];
                        if($this->activo->add_AUDIO_doc(array_to_upper($data_clte)))
                        {
                            send_json_ok('Se guardó de forma correcta');
                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
                    send_json_error($this->upload->display_errors());
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'activo/add_AUDIO_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }

    public function nuevo_ELECTRO_doc($activo_id)
    {
        $persona = $this->activo->get($activo_id);
        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('nombre','Nombre documento','required');
			$this->form_validation->set_rules('servicio','Orden de servicio','required');
			
            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_id'] =  $activo_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                $data_clte['emp_id'] =  $this->input->post('emp_id');
				$data_clte['serv_id'] = $this->input->post('servicio');
				
				
                $this->load->library('upload');
                if(!empty($_FILES['doc']['name']))
                {
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/docs/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg|pdf|doc|docx',
                            'max_size'      => '10000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('doc'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['doc_path'] = $data['file_name'];
                        if($this->activo->add_ELECTRO_doc(array_to_upper($data_clte)))
                        {
                            send_json_ok('Se guardó de forma correcta');
                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
                    send_json_error($this->upload->display_errors());
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'activo/add_ELECTRO_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }

    public function nuevo_RADIOL_doc($activo_id)
    {
        $persona = $this->activo->get($activo_id);
        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('nombre','Nombre documento','required');
			$this->form_validation->set_rules('servicio','Orden de servicio','required');
			
            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_id'] =  $activo_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                $data_clte['emp_id'] =  $this->input->post('emp_id');
				$data_clte['serv_id'] = $this->input->post('servicio');
				
				
                $this->load->library('upload');
                if(!empty($_FILES['doc']['name']))
                {
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/docs/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg|pdf|doc|docx',
                            'max_size'      => '10000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('doc'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['doc_path'] = $data['file_name'];
                        if($this->activo->add_RADIOL_doc(array_to_upper($data_clte)))
                        {
                            send_json_ok('Se guardó de forma correcta');
                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
                    send_json_error($this->upload->display_errors());
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'activo/add_RADIOL_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }


    public function nuevo_RADIOT_doc($activo_id)
    {
        $persona = $this->activo->get($activo_id);
        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('nombre','Nombre documento','required');
			$this->form_validation->set_rules('servicio','Orden de servicio','required');
			
            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_id'] =  $activo_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                $data_clte['emp_id'] =  $this->input->post('emp_id');
				$data_clte['serv_id'] = $this->input->post('servicio');
				
				
                $this->load->library('upload');
                if(!empty($_FILES['doc']['name']))
                {
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/docs/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg|pdf|doc|docx',
                            'max_size'      => '10000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('doc'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['doc_path'] = $data['file_name'];
                        if($this->activo->add_RADIOT_doc(array_to_upper($data_clte)))
                        {
                            send_json_ok('Se guardó de forma correcta');
                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
                    send_json_error($this->upload->display_errors());
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'activo/add_RADIOT_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }



    public function nuevo_PAPAN_doc($activo_id)
    {
        $persona = $this->activo->get($activo_id);
        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('nombre','Nombre documento','required');
			$this->form_validation->set_rules('servicio','Orden de servicio','required');
			
            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_id'] =  $activo_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                $data_clte['emp_id'] =  $this->input->post('emp_id');
				$data_clte['serv_id'] = $this->input->post('servicio');
				
				
                $this->load->library('upload');
                if(!empty($_FILES['doc']['name']))
                {
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/docs/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg|pdf|doc|docx',
                            'max_size'      => '10000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('doc'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['doc_path'] = $data['file_name'];
                        if($this->activo->add_PAPAN_doc(array_to_upper($data_clte)))
                        {
                            send_json_ok('Se guardó de forma correcta');
                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
                    send_json_error($this->upload->display_errors());
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'activo/add_PAPAN_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }

    public function nuevo_PENSA_doc($activo_id)
    {
        $persona = $this->activo->get($activo_id);
        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('nombre','Nombre documento','required');
			$this->form_validation->set_rules('servicio','Orden de servicio','required');
			
            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_id'] =  $activo_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                $data_clte['emp_id'] =  $this->input->post('emp_id');
				$data_clte['serv_id'] = $this->input->post('servicio');
				
				
                $this->load->library('upload');
                if(!empty($_FILES['doc']['name']))
                {
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/docs/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg|pdf|doc|docx',
                            'max_size'      => '10000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('doc'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['doc_path'] = $data['file_name'];
                        if($this->activo->add_PENSA_doc(array_to_upper($data_clte)))
                        {
                            send_json_ok('Se guardó de forma correcta');
                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
                    send_json_error($this->upload->display_errors());
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'activo/add_PENSA_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }


    public function nuevo_INTE_doc($activo_id)
    {
        $persona = $this->activo->get($activo_id);
        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('nombre','Nombre documento','required');
			$this->form_validation->set_rules('servicio','Orden de servicio','required');
			
            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_id'] =  $activo_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                $data_clte['emp_id'] =  $this->input->post('emp_id');
				$data_clte['serv_id'] = $this->input->post('servicio');
				
				
                $this->load->library('upload');
                if(!empty($_FILES['doc']['name']))
                {
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/docs/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg|pdf|doc|docx',
                            'max_size'      => '10000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('doc'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['doc_path'] = $data['file_name'];
                        if($this->activo->add_INTE_doc(array_to_upper($data_clte)))
                        {
                            send_json_ok('Se guardó de forma correcta');
                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
                    send_json_error($this->upload->display_errors());
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'activo/add_INTE_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }

    public function nuevo_PUESIC_doc($activo_id)
    {
        $persona = $this->activo->get($activo_id);
        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('nombre','Nombre documento','required');
			$this->form_validation->set_rules('servicio','Orden de servicio','required');
			
            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_id'] =  $activo_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                $data_clte['emp_id'] =  $this->input->post('emp_id');
				$data_clte['serv_id'] = $this->input->post('servicio');
				
				
                $this->load->library('upload');
                if(!empty($_FILES['doc']['name']))
                {
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/docs/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg|pdf|doc|docx',
                            'max_size'      => '10000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('doc'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['doc_path'] = $data['file_name'];
                        if($this->activo->add_PUESIC_doc(array_to_upper($data_clte)))
                        {
                            send_json_ok('Se guardó de forma correcta');
                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
                    send_json_error($this->upload->display_errors());
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'activo/add_PUESIC_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }

    public function nuevo_VISTA_doc($activo_id)
    {
        $persona = $this->activo->get($activo_id);
        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('nombre','Nombre documento','required');
			$this->form_validation->set_rules('servicio','Orden de servicio','required');
			
            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_id'] =  $activo_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                $data_clte['emp_id'] =  $this->input->post('emp_id');
				$data_clte['serv_id'] = $this->input->post('servicio');
				
				
                $this->load->library('upload');
                if(!empty($_FILES['doc']['name']))
                {
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/docs/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg|pdf|doc|docx',
                            'max_size'      => '10000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('doc'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['doc_path'] = $data['file_name'];
                        if($this->activo->add_VISTA_doc(array_to_upper($data_clte)))
                        {
                            send_json_ok('Se guardó de forma correcta');
                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
                    send_json_error($this->upload->display_errors());
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'activo/add_VISTA_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }




    public function nuevo_compo_doc($activo_id)
    {
        $persona = $this->activo->get($activo_id);
        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('nombre','Nombre documento','required');
			$this->form_validation->set_rules('servicio','Orden de servicio','required');
			
            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_id'] =  $activo_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                $data_clte['emp_id'] =  $this->input->post('emp_id');
				$data_clte['serv_id'] = $this->input->post('servicio');
				
				
                $this->load->library('upload');
                if(!empty($_FILES['doc']['name']))
                {
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/docs/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg|pdf|doc|docx',
                            'max_size'      => '10000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('doc'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['doc_path'] = $data['file_name'];
                        if($this->activo->add_compo_doc(array_to_upper($data_clte)))
                        {
                            send_json_ok('Se guardó de forma correcta');
                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
                    send_json_error($this->upload->display_errors());
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'activo/add_compo_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }
 
 
     public function nuevo_prevem_doc($activo_id)
    {
        $persona = $this->activo->get($activo_id);
		
		
        
        if(isset($_POST) && count($_POST) > 0)     
        {
			$this->activo->borra_sgmty_doc($activo_id);
            $this->load->library('form_validation');
            $this->form_validation->set_rules('nombre','Nombre documento','required');
			$this->form_validation->set_rules('servicio','Orden de servicio','required');
			
            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_id'] =  $activo_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                $data_clte['emp_id'] =  $this->input->post('emp_id');
				$data_clte['serv_id'] = $this->input->post('servicio');
				$data_clte['doc_pkts'] ='';

				$i=1;
				$paquetes='';
				$fsm_pakts= get_costos_paquetes_empresa($this->input->post('emp_id'));
				if($fsm_pakts):
					foreach($fsm_pakts as $fsm_pakt):			
						$indice=str_replace(' ','_',$fsm_pakt['cost_nombre_pkt']).'_'.$i;
						if (strlen($this->input->post($indice)) > 1)
						{	
							$paquetes.=$this->input->post($indice);										
						}
						$i++;									
					endforeach;
				endif;
				$data_clte['doc_pkts'] = $paquetes;
				//$data_clte['contador']=$this->input->post('contador');

                $this->load->library('upload');
                if(!empty($_FILES['doc']['name']))
                {
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/docs/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg|pdf|doc|docx',
                            'max_size'      => '10000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('doc'))
                    {
                        //send_json_error($this->upload->display_errors());
						send_json_error('El documento nos se ha podido cargar, por favor revisa');
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['doc_path'] = $data['file_name'];
                        if($this->activo->add_sgmty_doc(array_to_upper($data_clte)))
                        {
                            send_json_ok('Se guardó de forma correcta');
                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
                    send_json_error($this->upload->display_errors());
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'activo/add_sgmty_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }
 
    public function nuevo_sgmty_venta($activo_id, $tipo=0)
    {
        $persona = $this->activo->get($activo_id);		
        
        if(isset($_POST) && count($_POST) > 0)     
        {
			$this->activo->borra_sgmty_venta($activo_id,$venta);
            $this->load->library('form_validation');
			$this->form_validation->set_rules('servicio','Orden de servicio','required');
			
            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_id'] =  $activo_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                $data_clte['emp_id'] =  $this->input->post('emp_id');
				$data_clte['serv_id'] = $this->input->post('servicio');
				$data_clte['doc_pkts'] ='';

				$i=0;
				$paquetes='';
				$fsm_pakts= get_costos_paquetes_empresa($this->input->post('emp_id'));
				if($fsm_pakts):
					foreach($fsm_pakts as $fsm_pakt):			
						$indice=str_replace(' ','_',$fsm_pakt['cost_nombre_pkt']).'_'.$i;
						if (strlen($this->input->post($indice)) > 1)
						{	
							$paquetes.=$this->input->post($indice);										
						}
						$i++;									
					endforeach;
				endif;
				
				$data_clte['doc_pkts'] = $paquetes;
				$data_clte['doc_path'] = $this->input->post('cantidad');
				
                $this->load->library('upload');				

				if (strlen($data_clte['doc_path']) > 0)
				{
					$data = $this->upload->data();
					if($this->activo->add_sgmty_doc(array_to_upper($data_clte)))
					{
						send_json_ok('Se guardó de forma correcta');
					}
					else
					{
						send_json_error('Ocurrió un error al guardar el documento.');
					}
				}
				else 
				{
					
					send_json_error('No escribio la cantidad, por favor revisa');
				}						
					
            }
            else
            {
                send_json_error(validation_errors('¡Error!<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
			$data['tipo'] = $tipo;
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'activo/add_sgmty_venta',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }
 
 
 
    public function nuevo_sgmty_doc($activo_id)
    {
        $persona = $this->activo->get($activo_id);
		
		
        
        if(isset($_POST) && count($_POST) > 0)     
        {
			$this->activo->borra_sgmty_doc($activo_id);
            $this->load->library('form_validation');
			$this->form_validation->set_rules('nombre','Nombre documento','required');
			$this->form_validation->set_rules('servicio','Orden de servicio','required');
			
            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_id'] =  $activo_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                $data_clte['emp_id'] =  $this->input->post('emp_id');
				$data_clte['serv_id'] = $this->input->post('servicio');
				$data_clte['doc_pkts'] ='';

				$i=1;
				$paquetes='';
				$fsm_pakts= get_costos_paquetes_empresa($this->input->post('emp_id'));
				if($fsm_pakts):
					foreach($fsm_pakts as $fsm_pakt):			
						$indice=str_replace(' ','_',$fsm_pakt['cost_nombre_pkt']).'_'.$i;
						if (strlen($this->input->post($indice)) > 1)
						{	
							$paquetes.=$this->input->post($indice);
							if ($this->input->post('emp_id') == 182)
							{
								if (
									($fsm_pakt['cost_nombre_pkt'] == 'ANALISIS BACTERIOLOGICO DE HIELO') 
									||	($fsm_pakt['cost_nombre_pkt'] == 'ANALISIS BACTERIOLOGICO DE AGUA')
									||	($fsm_pakt['cost_nombre_pkt'] == 'CULTIVO DE ALIMENTO CRUDO')
									||	($fsm_pakt['cost_nombre_pkt'] == 'CULTIVO DE ALIMENTO COCIDO')
									||	($fsm_pakt['cost_nombre_pkt'] == 'CULTIVO DE SUPERFICIE INERTE')
									||	($fsm_pakt['cost_nombre_pkt'] == 'CULTIVO DE SUPERFICIE VIVA')
									)
									{
										$indice_muestra=$indice.'_MUESTRA';
										$paquetes=substr($paquetes, 0, -1);
										$paquetes.='x'.$this->input->post($indice_muestra).';';
									}	
							}

						}
						$i++;									
					endforeach;
				endif;
				
				$data_clte['doc_pkts'] = $paquetes;
				
                $this->load->library('upload');
				
				
                if(!empty($_FILES['doc']['name']))
                {
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/docs/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg|pdf|doc|docx',
                            'max_size'      => '10000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('doc'))
                    {
                        
						send_json_error('El documento nos se ha podido cargar, por favor revisa');
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['doc_path'] = $data['file_name'];
                        if($this->activo->add_sgmty_doc(array_to_upper($data_clte)))
                        {
                            send_json_ok('Se guardó de forma correcta');
                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
                    send_json_error($this->upload->display_errors());
                }
				
				
				
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
			$this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'activo/add_sgmty_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }
 
 
 /***/
      public function nuevo_allianz_doc($activo_id)
    {
        $persona = $this->activo->get($activo_id);
		
		
        
        if(isset($_POST) && count($_POST) > 0)     
        {
			$this->activo->borra_sgmty_doc($activo_id);
            $this->load->library('form_validation');
            $this->form_validation->set_rules('nombre','Nombre documento','required');
			$this->form_validation->set_rules('servicio','Orden de servicio','required');
			
            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_id'] =  $activo_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                $data_clte['emp_id'] =  $this->input->post('emp_id');
				$data_clte['serv_id'] = $this->input->post('servicio');
				$data_clte['doc_pkts'] ='';

				$i=1;
				$paquetes='';
				$fsm_pakts= get_costos_paquetes_empresa($this->input->post('emp_id'));
				if($fsm_pakts):
					foreach($fsm_pakts as $fsm_pakt):			
						$indice=str_replace(' ','_',$fsm_pakt['cost_nombre_pkt']).'_'.$i;
						if (strlen($this->input->post($indice)) > 1)
						{	
							$paquetes.=$this->input->post($indice);										
						}
						$i++;									
					endforeach;
				endif;
				$data_clte['doc_pkts'] = $paquetes;
				//$data_clte['contador']=$this->input->post('contador');

                $this->load->library('upload');
                if(!empty($_FILES['doc']['name']))
                {
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/docs/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg|pdf|doc|docx',
                            'max_size'      => '10000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('doc'))
                    {
                        //send_json_error($this->upload->display_errors());
						send_json_error('El documento nos se ha podido cargar, por favor revisa');
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['doc_path'] = $data['file_name'];
                        if($this->activo->add_sgmty_doc(array_to_upper($data_clte)))
                        {
                            send_json_ok('Se guardó de forma correcta');
                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
                    send_json_error($this->upload->display_errors());
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'activo/add_sgmty_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }
 
    function descarga_doc($file)
    {
        $this->load->helper('download');
        force_download('./docs/'.$file, NULL);
    }
	
    function busca()
    {   $despacho=get_desp_id_usr();
		$emp_id_user=get_emp_id();
		$roots=get_my_user_root2();    
        $empresa = $this->input->post('empresa');
		$id_persona = strtoupper($this->input->post('id_persona'));
        $nombre  = strtoupper($this->input->post('nombre'));
		$paterno  = strtoupper($this->input->post('paterno'));
		$materno  = strtoupper($this->input->post('materno'));
        $rfc     = strtoupper($this->input->post('rfc'));
        $ubicacion     = strtoupper($this->input->post('ubicacion'));
        $data['activos'] = $this->activo->busca($empresa, $nombre,$paterno, $materno, $rfc, $ubicacion,$despacho,$emp_id_user,$id_persona);
        send_json_ok($this->load->view('activo/busca',$data,TRUE));
    }	


    function busca_p()
    {   $despacho=get_desp_id_usr();
		$emp_id_user=get_emp_id();
		$user = $this->session->user; 
		//$usuario = $CIs->empleado->get($user['usr_id']);
		$medico=$this->medico->get($user['usr_id']);
		
		$roots=get_my_user_root2();    
        $empresa = $this->input->post('empresa');
        $nombre  = strtoupper($this->input->post('nombre'));
		$nombre2 = strtoupper($this->input->post('nombre2'));
		$empleado =	strtoupper($this->input->post('empleado'));
		$receta=	strtoupper($this->input->post('receta'));
		$paterno  = strtoupper($this->input->post('paterno'));
		$materno  = strtoupper($this->input->post('materno'));

		//echo '--'.$medico['usr_emp_asig'].'--';
        $data['activos'] = $this->activo->busca_p($empresa, $nombre, $nombre2,$paterno, $materno, $empleado, $receta,$despacho,$medico['usr_emp_asig']);
        
		send_json_ok($this->load->view('activo/busca_p',$data,TRUE));
    }

	
   public function borra($fsm_id)
    {
        if($this->activo->borra_evaluado($fsm_id))
        {
            send_json_ok('Se eliminó de forma correcta.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar.');
        }
    }

/*************************************************************************************/
    public function lista_e()
    {   //date_default_timezone_set('America/Mexico_City');
	    //echo " Punto A ";
		$suc=get_sucursal_id();
		$user_despacho=get_desp_id_usr();
		$user_cei=get_cei_id();
		$user_root1=get_my_user_root1();
		$user = $this->session->user; 
		$medico = $this->medico->get($user['usr_id']);
		$emp_id=$user['emp_id'];
        $rows = 30;
        $this->load->library('pagination');
        $config['base_url'] = base_url('activo/lista_e/');
        //$config['total_rows'] = $this->activo->count_all();
		
		if ($user['usr_id'] == 482)
		{
		$config['total_rows'] = $this->activo->count_allo_m($emp_id,$suc,$user_despacho,$user_cei,$user_root1,1);
        }
		else
		{
		$config['total_rows'] = $this->activo->count_allo_e($emp_id,$suc,$user_despacho,$user_cei,$user_root1,1);
        }
		
		$config['per_page'] = $rows;
        $config['attributes'] = array('class' => 'pagination');
        $config['full_tag_open'] = '<div class="pagination-full">';
        $config['full_tag_close'] = '</div>';
        $config['uri_segment'] = 3;
        $config['query_string_segment'] = 4;
        $config['use_page_numbers'] = TRUE;
        $this->pagination->initialize($config);
        //echo " Punto ".$medico['usr_emp_asig'];
		//echo " Punto B ";
        //$data['activos'] = $this->activo->get_all($rows);
		//echo " Punto ".$emp_id;
		

		if ($user['usr_id'] == 482)
		{
		$data['activos'] = $this->activo->get_allo_m($rows,$emp_id,get_sucursal_id(),$user_despacho,$user_cei,$user_root1,1);
        }
		else
		{
		$data['activos'] = $this->activo->get_allo_e($rows,$emp_id,get_sucursal_id(),$user_despacho,$user_cei,$user_root1,1);
        }

		
		//echo " Punto C ";
		
        //$this->load->model('empresa/Empresa_model','empresa');
		//echo " Punto D ";
		
        //$data['empresas'] = $this->empresa->trae_empresas(1);//$this->empresa->get_all_empresas();
		//$data['empresas'] = $this->empresa->get_all_empresas_gsi();
		//echo " Punto E ";
        
        $this->load->helper('template');
        $params_view = array(
            'title' => 'Personas',
            'view' => 'activo/index_e',
            'view_data' => $data 
           );
        render_template($params_view);  
    }
/*************************************************************************************/
    public function lista_a()
    {   
	    //echo " Punto A ";
		$suc=get_sucursal_id();
		$user_despacho=get_desp_id_usr();
		$user_cei=get_cei_id();
		$user_root1=get_my_user_root1();
		$user = $this->session->user; 
		$medico = $this->medico->get($user['usr_id']);
		$emp_id=$user['emp_id'];
        $rows = 30;
        $this->load->library('pagination');
        $config['base_url'] = base_url('activo/lista_a/');
        //$config['total_rows'] = $this->activo->count_all();
		$config['total_rows'] = $this->activo->count_allo_a($emp_id,$suc,$user_despacho,$user_cei,$user_root1,1);
        
		$config['per_page'] = $rows;
        $config['attributes'] = array('class' => 'pagination');
        $config['full_tag_open'] = '<div class="pagination-full">';
        $config['full_tag_close'] = '</div>';
        $config['uri_segment'] = 3;
        $config['query_string_segment'] = 4;
        $config['use_page_numbers'] = TRUE;
        $this->pagination->initialize($config);
		//echo " Punto B ";
		//echo " Punto ".$emp_id;
		$data['activos'] = $this->activo->get_allo_a($rows,$emp_id,get_sucursal_id(),$user_despacho,$user_cei,$user_root1,1);
		
		//echo " Punto C ";
		//echo " Punto D ";
		//echo " Punto E ";
        
        $this->load->helper('template');
        $params_view = array(
            'title' => 'Personas',
            'view' => 'activo/index_a',
            'view_data' => $data 
           );
        render_template($params_view);  
    }
/*************************************************************************************/
    public function lista_b()
    {   
	    //echo " Punto A ";
		$suc=get_sucursal_id();
		$user_despacho=get_desp_id_usr();
		$user_cei=get_cei_id();
		$user_root1=get_my_user_root1();
		$user = $this->session->user; 
		$medico = $this->medico->get($user['usr_id']);
		$emp_id=$user['emp_id'];
        $rows = 30;
        $this->load->library('pagination');
        $config['base_url'] = base_url('activo/lista_b/');
        //$config['total_rows'] = $this->activo->count_all();
		$config['total_rows'] = $this->activo->count_allo_b($emp_id,$suc,$user_despacho,$user_cei,$user_root1,1);
        
		$config['per_page'] = $rows;
        $config['attributes'] = array('class' => 'pagination');
        $config['full_tag_open'] = '<div class="pagination-full">';
        $config['full_tag_close'] = '</div>';
        $config['uri_segment'] = 3;
        $config['query_string_segment'] = 4;
        $config['use_page_numbers'] = TRUE;
        $this->pagination->initialize($config);
		//echo " Punto B ";
		//echo " Punto ".$emp_id;
		$data['activos'] = $this->activo->get_allo_b($rows,$emp_id,get_sucursal_id(),$user_despacho,$user_cei,$user_root1,1);
		
		//echo " Punto C ";
		//echo " Punto D ";
		//echo " Punto E ";
        
        $this->load->helper('template');
        $params_view = array(
            'title' => 'Personas',
            'view' => 'activo/index_b',
            'view_data' => $data 
           );
        render_template($params_view);  
    }


    public function nuevo_e()
    {    
		$user = $this->session->user; 
		$medico = $this->medico->get($user['usr_id']);
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('nombre','Nombre','required');
            $this->form_validation->set_rules('paterno','Apellido Paterno','required');
            $this->form_validation->set_rules('materno','Apellido Materno','required');
            $this->form_validation->set_rules('fnac','Fecha de nacimiento','required');
            $this->form_validation->set_rules('genero','Género','required');

            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_nombre_crypt'] =  trim($this->input->post('nombre'));
                $data_clte['clte_2_nombre_crypt'] =  trim($this->input->post('nombre_adic'));
                $data_clte['clte_paterno_crypt'] =  trim($this->input->post('paterno'));
                $data_clte['clte_materno_crypt'] =  trim($this->input->post('materno'));
                
				$data_clte['clte_f_nac'] = formatea_fecha_mysql($this->input->post('fnac'));
                $data_clte['clte_genero_cve'] =  $this->input->post('genero');      				
				$data_clte['clte_rfc_crypt'] =  $this->input->post('rfc');                				
				$data_clte['clte_curp_crypt'] = $this->input->post('curp');
				$data_clte['clte_nss_crypt'] =  $this->input->post('nss');
                $data_clte['clte_grado_acad_cve'] =  $this->input->post('grado');
                $data_clte['clte_edo_civ_cve'] =  $this->input->post('civil');
                $data_clte['clte_nac_cve'] =  $this->input->post('nac');				
				
                $data_clte['empleado'] = 1;
                
                $data_clte['emp_id'] =$this->input->post('empresa');//$medico['usr_emp_asig'];
                $data_clte['clte_puesto'] = $this->input->post('puesto');
				$data_clte['num_empleado'] = $this->input->post('nempleado');
				
				//sucursal
                $data_clte['suc_id'] =0;
				$data_clte['cei_id'] =  4;

				$nomserv='NOM0351;NOM0352;NOM0353;';
				$data_clte['nomserv'] =  $nomserv;

 /***************************** CARGA DE LA FOTO DEL EVALUADO ************************/               
                if(!empty($_FILES['foto']['name']))
                {
                    $this->load->library('upload');
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/fotos/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg',
                            'max_size'      => '10000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('foto'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['clte_path_foto'] = $data['file_name'];
                    }
                }
/*************************************************************************************/
				$data_clte=array_to_upper($data_clte);
				$data_clte['clte_email_crypt'] =  $this->input->post('correo');
				if ($activo_id = $this->activo->inserta($data_clte))
                {
                    send_json_ok(array('msg' =>'Se guardó de forma correcta', 'id' => $activo_id));
                    
                }
                else
                {
                    send_json_error('Ocurrió un error al guardar la persona.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $this->load->model('empresa/Empresa_model','empresa');
            //$data['empresas'] = $this->empresa->get_all_empresas();
			$data['empresas'] =$this->empresa->get_all_empresas_gsi();
			$data['sucursals'] = $this->empresa->get_all_sucursales();
			$data['despachos'] = $this->empresa->get_all_despachos();
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'activo/add_e',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }


/*************************************************************************************/	
    function busca_e()
    {   
		$user = $this->session->user;
		$despacho=get_desp_id_usr();
		$emp_id_user=get_emp_id();
		$roots=get_my_user_root2();    
        $empresa = $emp_id_user; //$this->input->post('empresa');
        $nombre  = strtoupper($this->input->post('nombre'));
		$nombre2 = strtoupper($this->input->post('nombre2'));
		
		$empleado =	strtoupper($this->input->post('empleado'));
		$receta=	strtoupper($this->input->post('receta'));
		$paterno  = strtoupper($this->input->post('paterno'));
		$materno  = strtoupper($this->input->post('materno'));
		
		if ($user['usr_id'] == 482)
		{
        $data['activos'] = $this->activo->busca_m($empresa, $nombre, $nombre2,$paterno, $materno, $empleado, $receta,$despacho,$emp_id_user);
        }
		else
		{
		  $data['activos'] = $this->activo->busca_e($empresa, $nombre, $nombre2,$paterno, $materno, $empleado, $receta,$despacho,$emp_id_user);	
		}
		
		send_json_ok($this->load->view('activo/busca_e',$data,TRUE));
    } 

 /*************************************************************************************/	
    function busca_a()
    {   $despacho=get_desp_id_usr();
		$emp_id_user=get_emp_id();
		$roots=get_my_user_root2();    
        $empresa = $emp_id_user; //$this->input->post('empresa');
        $nombre  = strtoupper($this->input->post('nombre'));
		$nombre2 = strtoupper($this->input->post('nombre2'));
		$paterno  = strtoupper($this->input->post('paterno'));
		$materno  = strtoupper($this->input->post('materno'));
        $data['activos'] = $this->activo->busca_a($empresa, $nombre, $nombre2,$paterno, $materno);
        
		send_json_ok($this->load->view('activo/busca_a',$data,TRUE));
    } 
 
}