<?php
/* 
 * Generated by CRUDigniter v2.3 Beta 
 * www.crudigniter.com
 */ 
 
class Agenda extends CI_Controller
{
    function __construct()
    {
        parent::__construct();
		$this->load->helper('util');
		$this->load->model('persona/Persona_model','cliente');
        $this->load->model('util/Agenda_model','agenda');
		$this->load->model('empleado/Empleado_model','empleado');
		$this->load->model('empresa/Empresa_model','empresa');
		$this->load->model('servicio/Servicio_model','servicio');
    }
    

    function index()
    {
        $this->load->helper('template');
        $params_view = array(
            'title' => 'Citas',
            'view' => 'agenda/calendar'
           );
        render_template($params_view); 
    }



 
    function eventjson()
    {
        if($this->uri->segment(3))
        {
            $year = date('Y', strtotime($this->uri->segment(3)));
            $month = date('m', strtotime($this->uri->segment(3)));
        }
        else 
        {
            $year = date('Y');
            $month = date('m');
        }
        $eventos = $this->agenda->get_all_eventos_json($year,$month);
        if($eventos)
        {
            send_json_ok($eventos);
        }
        else
        {
            send_json_error('No hay eventos.');
        }
    }
/*************function add_evento() original************************************************************************/	    
    function add_evento()
    {
        $data_view['evento_dia'] = date('Y-m-d',strtotime($this->uri->segment(3)));
        
        $fecha_div = explode('T', $this->uri->segment(3));
        if(isset($fecha_div[1]))
        {
            $data_view['hora_ini'] = date('H:i',strtotime($fecha_div[1]));
        }
        else
        {
            $data_view['hora_ini'] = date('H:i');
        }
        if(isset($_POST) && count($_POST) > 0)     
        {
            //recibe los datos
            $this->load->library('form_validation');
            $this->form_validation->set_rules('fecha','Fecha','required');
            $this->form_validation->set_rules('asunto','Asunto','required');
            $this->form_validation->set_rules('fecha_event_ini','Fecha inicia','required');
            $this->form_validation->set_rules('hora_event_ini','Hora inicia','required');
            $this->form_validation->set_rules('fecha_event_fin','Fecha fin','required');
            $this->form_validation->set_rules('hora_event_fin','Hora fin','required');



			if($this->form_validation->run())
            {
                $fecha_ini = formatea_fechahora_mysql($this->input->post('fecha_event_ini').' '.$this->input->post('hora_event_ini'));
                $fecha_fin = formatea_fechahora_mysql($this->input->post('fecha_event_fin').' '.$this->input->post('hora_event_fin'));
                                
                $params = array(
                    'cal_fecha' => $this->input->post('fecha'),
                    'cal_titulo' => $this->input->post('asunto'),
                    'cal_servicio' => NULL,
                    'cal_descripcion' => $this->input->post('descripcion'),
                    'cal_fecha_ini' => $fecha_ini,
                    'cal_fecha_fin' => $fecha_fin,
                    'cal_uid' => uniqid(rand(0, getmypid()))
                );
                if($this->input->post('lugar'))
                {
                    $params['cal_lugar'] = $this->input->post('lugar');
                }

                if($this->input->post('emp_id'))
                {
                    $params['emp_id'] = $this->input->post('emp_id');
                }
                
                if(get_perfil_id() == 4){
                    $params['emp_id'] = get_emp_id();
                }
                
                if($this->input->post('recordar') == 'si')
                {
                    $params['cal_email'] = $this->input->post('mail');
                }
                else
                {
                    $params['cal_email'] = NULL;
                }
                
                //requerimiento HC-02
                //ALTER TABLE `doc10_calendario` ADD `cal_anexo_path` VARCHAR(150) NULL AFTER `cal_uid`;
                if(!empty($_FILES['anexo']['name']))
                {
                    $this->load->library('upload');
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/anexos/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'doc|docx|pdf|txt|xlsx|xls',
                            'max_size'      => '10000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('anexo'))
                    {
                        //send_json_error($this->upload->display_errors());
                        //send_json_error($this->upload->display_errors());
                        echo json_encode(array('status' => 'error','content' => $this->upload->display_errors()));
                        exit;
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $params['cal_anexo_path'] = $data['file_name'];
                    }
                }
                
                $cal_id = $this->agenda->add_evento(array_to_upper($params));
                if($cal_id)
                {

                        $this->load->helper('mail');
                        $evento = $this->agenda->get_evento($cal_id);
                        $data_email = array('evento' => $evento);
                        $html = $this->load->view('agenda/email_add_std_event',$data_email,TRUE);
                        
					send_mail_std_event($this->input->post('mail'), $evento, $html);
                    send_json_ok('Se guardó de forma correcta.');
                }
                else
                {
                    send_json_error('Ocurrió un error al guardar, intente de nuevo más tarde.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div>'));
            }
        }
        else
        {
            if($this->uri->segment(3) != '')
            {
                $data_view['evento_dia'] = date('Y-m-d',strtotime($this->uri->segment(3)));
            }
            else
            {
                $data_view['evento_dia'] = date('Y-m-d');
            }
            $data_view['pac'] = FALSE;
            //$data_view['title_modal'] = 'Nueva cita';
            $view = $this->load->view('agenda/add',$data_view,TRUE);
            send_json_ok($view);
        }
    }
/*************************************************************************************/	

/*************MODIFICADO ******************************************************************/	    
    function add_sol_serv_hc()
    {
        
		$user = $this->session->user;
		
		$data_view['evento_dia'] = date('Y-m-d',strtotime($this->uri->segment(3)));
        
        $fecha_div = explode('T', $this->uri->segment(3));
        if(isset($fecha_div[1]))
        {
            $data_view['hora_ini'] = date('H:i',strtotime($fecha_div[1]));
        }
        else
        {
            $data_view['hora_ini'] = date('H:i');
        }
        if(isset($_POST) && count($_POST) > 1)     
        {
            //recibe los datos
            $this->load->library('form_validation');
            $this->form_validation->set_rules('fecha','Fecha','required');
           // $this->form_validation->set_rules('asunto','Asunto','required');
            $this->form_validation->set_rules('fecha_event_ini','Fecha inicia','required');
            $this->form_validation->set_rules('hora_event_ini','Hora inicia','required');
            $this->form_validation->set_rules('fecha_event_fin','Fecha fin','required');
            $this->form_validation->set_rules('hora_event_fin','Hora fin','required');			
			$this->form_validation->set_rules('observaciones','Observaciones','required');
			$this->form_validation->set_rules('evaluados','Evaluados','required');
			$this->form_validation->set_rules('lugar','Lugar de realización de los servicios','required');
			
            if($this->form_validation->run())
            {
                $fecha_ini = formatea_fechahora_mysql($this->input->post('fecha_event_ini').' '.$this->input->post('hora_event_ini'));
                $fecha_fin = formatea_fechahora_mysql($this->input->post('fecha_event_fin').' '.$this->input->post('hora_event_fin'));
                                
                $params = array(
					//toxixo
					'cal_toxi5' => $this->input->post('toxi5'),
					'cal_toxi7' => $this->input->post('toxi7'),
					'cal_toxi9' => $this->input->post('toxi9'),
					//LABORATORIO
					'cal_sangre' => $this->input->post('sangre'),
					'cal_orina' => $this->input->post('orina'),
					'cal_electro' => $this->input->post('electro'),
					'cal_muestra' => $this->input->post('muestra'),
					
					//SEGUROS	
					'cal_exmed' => $this->input->post('exmed'),	
					
					'cal_electro_sitio' => $this->input->post('electro_sitio'),	
					'cal_electro_domi' => $this->input->post('electro_domi'),	
					'cal_usonido' => $this->input->post('usonido'),	

					'cal_esfuerzo' => $this->input->post('esfuerzo'),	
					'cal_torax' => $this->input->post('torax'),	
					'cal_papani' => $this->input->post('papani'),	
					
					'cal_cotinina' => $this->input->post('cotinina'),	
					'cal_drogas' => $this->input->post('drogas'),						
					
					'cal_quisan' => $this->input->post('quisan'),
					'cal_biohem' => $this->input->post('biohem'),
					
					'cal_antipro' => $this->input->post('antipro'),
					'cal_hiv' => $this->input->post('hiv'),					
					'cal_pie' => $this->input->post('pie'),					
					
					'cal_HbA1c' => $this->input->post('HbA1c'),
					'cal_HBsAg' => $this->input->post('HBsAg'),
					'cal_hepac' => $this->input->post('hepac'),

					'cal_gposan' => $this->input->post('gposan'),
	
					//MÉDICO FÍSICO
					'cal_medfi' => $this->input->post('medfis'),
					'cal_odon' => $this->input->post('odon'),
									
					
					//ESTUDIOS SOCIOECONÓMICOS
					'cal_estsocv' => $this->input->post('estsocv'),
					'cal_estsosv' => $this->input->post('estsosv'),
					//ESTUDIOS PSICOLÓGICOS
					'cal_estpsicr' => $this->input->post('estpsicr'),
					'cal_estpsisr' => $this->input->post('estpsisr'),
					//ESTUDIOS POLIGRÁFICOS
					'cal_estpolcr' => $this->input->post('estpolcr'),
					'cal_estpolsr' => $this->input->post('estpolsr'),
					//ESPECIALES</td>
					'cal_acre' => $this->input->post('acre'),
					'cal_eye' => $this->input->post('eye'),
					//Observaciones
					'cal_observaciones' => $this->input->post('observaciones'),
					//Evaluados
					'cal_evaluados' => $this->input->post('evaluados'),
					
					'cal_usr_nombre' => $user['usr_nombre'],
					'cal_usr_paterno' => $user['usr_paterno'],
					'cal_usr_materno' => $user['usr_materno'],
					'cal_usr_correo' => $user['usr_correo'],
		
					
					//datos normales de calendario	
                    'cal_fecha' => $this->input->post('fecha'),
                    'cal_titulo' => $this->input->post('asunto'),
                    'cal_servicio' => NULL,
                    'cal_descripcion' => $this->input->post('descripcion'),
                    'cal_fecha_ini' => $fecha_ini,
                    'cal_fecha_fin' => $fecha_fin,
                    'cal_uid' => uniqid(rand(0, getmypid()))
                );


				if ($user['emp_id'] == 31)
				{					
					$params['emp_id'] = $this->input->post('empresa');
				}
				elseif  (
							($user['emp_id'] == 126)   ||
							($user['emp_id'] ==125)   ||
							($user['emp_id'] ==33)   ||
							($user['emp_id'] ==179)   ||
							($user['emp_id'] ==181)   ||
							($user['emp_id'] ==180)   ||
							($user['emp_id'] ==77)   ||
							($user['emp_id'] ==176)   ||
							($user['emp_id'] ==178)   ||
							($user['emp_id'] ==177)   ||
							($user['emp_id'] ==57)   ||
							($user['emp_id'] ==175)   ||
							($user['emp_id'] ==174)   ||						 
							($user['emp_id'] == 127)    
							|| ($user['emp_id'] == 183)
							|| ($user['emp_id'] ==33)
							|| ($user['emp_id'] ==77)
							|| ($user['emp_id'] ==106)
							|| ($user['emp_id'] ==148)							
						)/*es un despacho de GSI*/
				{
					$params['emp_id'] = $user['emp_id'];
					$params['desp_emp_id'] = $this->input->post('empresa');
				}
				else
				{
					$params['emp_id'] = $user['emp_id'];
					$params['desp_emp_id'] = 0;
				}
                
                //if($this->input->post('lugar'))
                
                $params['cal_lugar'] = $this->input->post('lugar');
				
				if (($user['emp_id'] != 152) || ($user['emp_id'] != 230))
				{					
					$params['cal_lugar_det'] = $this->input->post('lugar_det');
					
                }
				else
				{								
				 /*	if ($params['cal_lugar'] == 0)
					{
						$params['cal_lugar_det'] = $this->input->post('lugar_det');
					}
					elseif ($params['cal_lugar'] == 2) 
					{	
						$params['cal_lugar_det'] ='Calle San Borja 1365, Vértiz Narvarte, Benito Juárez, C.P. 03600, CDMX'; 
					}
					else
					{	
						$params['cal_lugar_det'] = 'Paseo de la Reforma No. 342, Piso 14, Col. Juárez, Del. Cuauhtémoc, C.P. 06600, CDMX';  
					}	
				*/					
			
				}	
				
				
				
                /*if($this->input->post('recordar') == 'si')
                {*/
                    $params['cal_email'] = $user['usr_correo'].'; '.$this->input->post('mail');
               /* }
                else
                {
                    $params['cal_email'] = NULL;
                }*/
                
                //requerimiento HC-02
                //ALTER TABLE `doc10_calendario` ADD `cal_anexo_path` VARCHAR(150) NULL AFTER `cal_uid`;
               
			   if(!empty($_FILES['anexo']['name']))
                {
					$nombre_anexo=$_FILES['anexo']['name'];
                    $this->load->library('upload');
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/anexos/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'doc|docx|pdf|txt|xlsx|xls|png|jpg|jpeg',
                            'max_size'      => '10000'
                    );

                    $this->upload->initialize($config);
					
                    if ( ! $this->upload->do_upload('anexo'))
                    {
                        echo json_encode(array('status' => 'error','content' => $this->upload->display_errors()));
                        exit;
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $params['cal_anexo_path'] = $data['file_name'];
						$params['cal_anexo_nombre'] = $nombre_anexo;
                    }
                }
/******NUEVOS ARCHIVO ANEXO 1 ******************************/
                if(!empty($_FILES['anexo1']['name']))
                {
					$nombre_anexo=$_FILES['anexo1']['name'];
                    $this->load->library('upload');
					
					sleep(1);
                    $filename1 = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/anexos/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename1,
                            'allowed_types' => 'doc|docx|pdf|txt|xlsx|xls|png|jpg|jpeg',
                            'max_size'      => '10000'
                    );

                    $this->upload->initialize($config);
					
                    if ( ! $this->upload->do_upload('anexo1'))
                    {
                        echo json_encode(array('status' => 'error','content' => $this->upload->display_errors()));
                        exit;
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $params['cal_anexo1_path'] = $data['file_name'];
						$params['cal_anexo1_nombre'] = $nombre_anexo;
                    }
                }

/**********************************************************/				
				
/******NUEVOS ARCHIVO ANEXO 2 ******************************/
                if(!empty($_FILES['anexo2']['name']))
                {
					$nombre_anexo=$_FILES['anexo2']['name'];
                    $this->load->library('upload');
					
					sleep(1);
                    $filename2 = md5(time());
                    $config2 = array(
                            'upload_path'   => './../../files/anexos/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename2,
                            'allowed_types' => 'doc|docx|pdf|txt|xlsx|xls|png|jpg|jpeg',
                            'max_size'      => '10000'
                    );

                    $this->upload->initialize($config2);
					
                    if ( ! $this->upload->do_upload('anexo2'))
                    {
                        echo json_encode(array('status' => 'error','content' => $this->upload->display_errors()));
                        exit;
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $params['cal_anexo2_path'] = $data['file_name'];
						$params['cal_anexo2_nombre'] = $nombre_anexo;
                    }
                }

/**********************************************************/	
/******NUEVOS ARCHIVO ANEXO 3 ******************************/
                if(!empty($_FILES['anexo3']['name']))
                {
					$nombre_anexo=$_FILES['anexo3']['name'];
                    $this->load->library('upload');
					
					sleep(1);
                    $filename3 = md5(time());
                    $config3 = array(
                            'upload_path'   => './../../files/anexos/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename3,
                            'allowed_types' => 'doc|docx|pdf|txt|xlsx|xls|png|jpg|jpeg',
                            'max_size'      => '10000'
                    );

                    $this->upload->initialize($config3);
					
                    if ( ! $this->upload->do_upload('anexo3'))
                    {
                        echo json_encode(array('status' => 'error','content' => $this->upload->display_errors()));
                        exit;
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $params['cal_anexo3_path'] = $data['file_name'];
						$params['cal_anexo3_nombre'] = $nombre_anexo;
						
                    }
                }

/**********************************************************/	
/******NUEVOS ARCHIVO ANEXO 4 ******************************/
                if(!empty($_FILES['anexo4']['name']))
                {
					$nombre_anexo=$_FILES['anexo4']['name'];
                    $this->load->library('upload');
					
					sleep(1);
                    $filename4 = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/anexos/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename4,
                            'allowed_types' => 'doc|docx|pdf|txt|xlsx|xls|png|jpg|jpeg',
                            'max_size'      => '10000'
                    );

                    $this->upload->initialize($config);
					
                    if ( ! $this->upload->do_upload('anexo4'))
                    {
                        echo json_encode(array('status' => 'error','content' => $this->upload->display_errors()));
                        exit;
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $params['cal_anexo4_path'] = $data['file_name'];
						$params['cal_anexo4_nombre'] = $nombre_anexo;
                    }
                }

/**********************************************************/				
				
				
                if ($params['emp_id'] > 0)
				{	
                $cal_id = $this->agenda->add_evento_folio(array_to_upper($params));
				}
				
				if($cal_id)
                {

                        $this->load->helper('mail');
                        $evento = $this->agenda->get_evento($cal_id);
						
                        $data_email = array('evento' => $evento);						
                        $html = $this->load->view('agenda/email_add_std_event_serv',$data_email,TRUE);
                        
						if ($user['emp_id'] == 31)
						{
							$this->load->model('empresa/Empresa_model','empresa');
							$data_empresa = $this->empresa->get_empresa_by_id($params['emp_id']);
							send_mail_std_event_serv(
							$this->input->post('mail'), 
							$evento, 
							$html,
							$cal_id,
							get_empresa($params['emp_id']),
							$user['usr_nombre'].' '.$user['usr_paterno'],
							$user['usr_correo'],
							$data_empresa['emp_responsable'] , 
							$data_empresa['emp_correo']
							,$params['cal_lugar'] );
						}
						else
						{
							send_mail_std_event_serv(
							$this->input->post('mail'), 
							$evento, 
							$html,
							$cal_id,
							get_empresa($params['emp_id']),
							$user['usr_nombre'].' '.$user['usr_paterno'],
							$user['usr_correo'],
							'',
							'',
							$params['cal_lugar'] );
						}

                    send_json_ok('Se guardó de forma correcta.');
                }
                else
                {
                    send_json_error('Ocurrió un error al guardar, Por favor revise si toda su información esta completa y vuelva intentar.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div>'));
            }
        }
        else
        {
            if($this->uri->segment(3) != '')
            {
                $data_view['evento_dia'] = date('Y-m-d',strtotime($this->uri->segment(3)));
            }
            else
            {
                $data_view['evento_dia'] = date('Y-m-d');
            }
			
			/*if ($cal_id)
			{
				$data_view['cal_id'] = $cal_id;
			}*/
			
            $data_view['pac'] = FALSE;
			$data_view['solicita'] =$user['usr_nombre'].' '.$user['usr_paterno'];
			
			if ($user['emp_id'] == 31)
			{
				$this->load->model('empresa/Empresa_model','empresa');
				//$data_view['las_empresas'] = $this->empresa->get_all_empresas_no_31();
				$data_view['las_empresas'] =$this->empresa->trae_empresas();//$this->empresa->get_all_empresas(); 
			}
			elseif  (
							($user['emp_id'] == 126)   ||
							($user['emp_id'] == 125)   ||
							($user['emp_id'] == 33)   ||
							($user['emp_id'] == 179)   ||
							($user['emp_id'] == 181)   ||
							($user['emp_id'] == 180)   ||
							($user['emp_id'] == 77)   ||
							($user['emp_id'] == 176)   ||
							($user['emp_id'] == 178)   ||
							($user['emp_id'] == 177)   ||
							($user['emp_id'] ==57)   ||
							($user['emp_id'] ==175)   ||
							($user['emp_id'] ==174)   ||						 
							($user['emp_id'] == 127) 
							|| ($user['emp_id'] == 183)
							|| ($user['emp_id'] ==33)
							|| ($user['emp_id'] ==77)
							|| ($user['emp_id'] ==106)
							|| ($user['emp_id'] ==148)
							
						)/*es un despacho de GSI*/
			{
				$this->load->model('empresa/Empresa_model','empresa');
				$data_view['las_empresas'] = $this->empresa->get_all_empresas_gsi();
			}
				$data_view['empresa'] =$user['emp_id'];
	
			
            //$data_view['title_modal'] = 'Nueva cita';
            $view = $this->load->view('agenda/add_serv_hc',$data_view,TRUE);
            send_json_ok($view);
        }
    }
/****************MODIFICADO  hc*********************************************************************/	

	
/*************MODIFICADO ******************************************************************/	    
    function add_sol_serv()
    {
        
		$user = $this->session->user;
		
		$data_view['evento_dia'] = date('Y-m-d',strtotime($this->uri->segment(3)));
        
        $fecha_div = explode('T', $this->uri->segment(3));
        if(isset($fecha_div[1]))
        {
            $data_view['hora_ini'] = date('H:i',strtotime($fecha_div[1]));
        }
        else
        {
            $data_view['hora_ini'] = date('H:i');
        }
        if(isset($_POST) && count($_POST) > 0)     
        {
            //recibe los datos
            $this->load->library('form_validation');
            $this->form_validation->set_rules('fecha','Fecha','required');
           // $this->form_validation->set_rules('asunto','Asunto','required');
            $this->form_validation->set_rules('fecha_event_ini','Fecha inicia','required');
            $this->form_validation->set_rules('hora_event_ini','Hora inicia','required');
            $this->form_validation->set_rules('fecha_event_fin','Fecha fin','required');
            $this->form_validation->set_rules('hora_event_fin','Hora fin','required');
			
			$this->form_validation->set_rules('observaciones','Observaciones','required');
			$this->form_validation->set_rules('evaluados','Evaluados','required');
			$this->form_validation->set_rules('lugar','Lugar de realización de los servicios','required');
			
            if($this->form_validation->run())
            {
                $fecha_ini = formatea_fechahora_mysql($this->input->post('fecha_event_ini').' '.$this->input->post('hora_event_ini'));
                $fecha_fin = formatea_fechahora_mysql($this->input->post('fecha_event_fin').' '.$this->input->post('hora_event_fin'));
                                
                $params = array(
					//toxixo
					'cal_toxi5' => $this->input->post('toxi5'),
					'cal_toxi7' => $this->input->post('toxi7'),
					'cal_toxi9' => $this->input->post('toxi9'),
					//LABORATORIO
					'cal_sangre' => $this->input->post('sangre'),
					'cal_orina' => $this->input->post('orina'),
					'cal_electro' => $this->input->post('electro'),
					'cal_muestra' => $this->input->post('muestra'),
					
					//SEGUROS	
					'cal_exmed' => $this->input->post('exmed'),	
					
					'cal_electro_sitio' => $this->input->post('electro_sitio'),	
					'cal_electro_domi' => $this->input->post('electro_domi'),	
					'cal_usonido' => $this->input->post('usonido'),	

					'cal_esfuerzo' => $this->input->post('esfuerzo'),	
					'cal_torax' => $this->input->post('torax'),	
					'cal_papani' => $this->input->post('papani'),	
					
					'cal_cotinina' => $this->input->post('cotinina'),	
					'cal_drogas' => $this->input->post('drogas'),						
					
					'cal_quisan' => $this->input->post('quisan'),
					'cal_biohem' => $this->input->post('biohem'),
					
					'cal_antipro' => $this->input->post('antipro'),
					'cal_hiv' => $this->input->post('hiv'),					
					'cal_pie' => $this->input->post('pie'),					
					
					'cal_HbA1c' => $this->input->post('HbA1c'),
					'cal_HBsAg' => $this->input->post('HBsAg'),
					'cal_hepac' => $this->input->post('hepac'),

					'cal_gposan' => $this->input->post('gposan'),
	
					//MÉDICO FÍSICO
					'cal_medfi' => $this->input->post('medfis'),
					'cal_odon' => $this->input->post('odon'),
									
					
					//ESTUDIOS SOCIOECONÓMICOS
					'cal_estsocv' => $this->input->post('estsocv'),
					'cal_estsosv' => $this->input->post('estsosv'),
					//ESTUDIOS PSICOLÓGICOS
					'cal_estpsicr' => $this->input->post('estpsicr'),
					'cal_estpsisr' => $this->input->post('estpsisr'),
					//ESTUDIOS POLIGRÁFICOS
					'cal_estpolcr' => $this->input->post('estpolcr'),
					'cal_estpolsr' => $this->input->post('estpolsr'),
					//ESPECIALES</td>
					'cal_acre' => $this->input->post('acre'),
					'cal_eye' => $this->input->post('eye'),
					//Observaciones
					'cal_observaciones' => $this->input->post('observaciones'),
					//Evaluados
					'cal_evaluados' => $this->input->post('evaluados'),
					
					'cal_usr_nombre' => $user['usr_nombre'],
					'cal_usr_paterno' => $user['usr_paterno'],
					'cal_usr_materno' => $user['usr_materno'],
					'cal_usr_correo' => $user['usr_correo'],
		
					
					//datos normales de calendario	
                    'cal_fecha' => $this->input->post('fecha'),
                    'cal_titulo' => $this->input->post('asunto'),
                    'cal_servicio' => NULL,
                    'cal_descripcion' => $this->input->post('descripcion'),
                    'cal_fecha_ini' => $fecha_ini,
                    'cal_fecha_fin' => $fecha_fin,
                    'cal_uid' => uniqid(rand(0, getmypid()))
                );


				if ($user['emp_id'] == 31)
				{					
					$params['emp_id'] = $this->input->post('empresa');
				}
				elseif  (
							($user['emp_id'] == 126)   ||
							($user['emp_id'] ==125)   ||
							($user['emp_id'] ==33)   ||
							($user['emp_id'] ==179)   ||
							($user['emp_id'] ==181)   ||
							($user['emp_id'] ==180)   ||
							($user['emp_id'] ==77)   ||
							($user['emp_id'] ==176)   ||
							($user['emp_id'] ==178)   ||
							($user['emp_id'] ==177)   ||
							($user['emp_id'] ==57)   ||
							($user['emp_id'] ==175)   ||
							($user['emp_id'] ==174)   ||						 
							($user['emp_id'] == 127)    
							|| ($user['emp_id'] == 183)
							|| ($user['emp_id'] ==33)
							|| ($user['emp_id'] ==77)
							|| ($user['emp_id'] ==106)
							|| ($user['emp_id'] ==148)							
						)/*es un despacho de GSI*/
				{
					$params['emp_id'] = $user['emp_id'];
					$params['desp_emp_id'] = $this->input->post('empresa');
				}
				else
				{
					$params['emp_id'] = $user['emp_id'];
					$params['desp_emp_id'] = 0;
				}
                
                //if($this->input->post('lugar'))
                
                $params['cal_lugar'] = $this->input->post('lugar');
				
				if (($user['emp_id'] != 152) || ($user['emp_id'] != 230))
				{					
					$params['cal_lugar_det'] = $this->input->post('lugar_det');
					
                }
				else
				{								
					if ($params['cal_lugar'] == 0)
					{
						$params['cal_lugar_det'] = $this->input->post('lugar_det');
					}
					elseif ($params['cal_lugar'] == 2) 
					{	
						$params['cal_lugar_det'] ='Calle San Borja 1365, Vértiz Narvarte, Benito Juárez, C.P. 03600, CDMX'; 
					}
					else
					{	
						$params['cal_lugar_det'] = 'Paseo de la Reforma No. 342, Piso 14, Col. Juárez, Del. Cuauhtémoc, C.P. 06600, CDMX';  
					}							
			
				}	

                $params['cal_email'] = $user['usr_correo'].'; '.$this->input->post('mail');

                if(!empty($_FILES['anexo']['name']))
                {
					$nombre_anexo=$_FILES['anexo']['name'];
                    $this->load->library('upload');
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/anexos/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'doc|docx|pdf|txt|xlsx|xls|png|jpg|jpeg',
                            'max_size'      => '10000'
                    );

                    $this->upload->initialize($config);
					
                    if ( ! $this->upload->do_upload('anexo'))
                    {
                        echo json_encode(array('status' => 'error','content' => $this->upload->display_errors()));
                        exit;
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $params['cal_anexo_path'] = $data['file_name'];
						$params['cal_anexo_nombre'] = $nombre_anexo;
                    }
                }
/******NUEVOS ARCHIVO ANEXO 1 ******************************/
                if(!empty($_FILES['anexo1']['name']))
                {
					$nombre_anexo=$_FILES['anexo1']['name'];
                    $this->load->library('upload');
					
					sleep(1);
                    $filename1 = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/anexos/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename1,
                            'allowed_types' => 'doc|docx|pdf|txt|xlsx|xls|png|jpg|jpeg',
                            'max_size'      => '10000'
                    );

                    $this->upload->initialize($config);
					
                    if ( ! $this->upload->do_upload('anexo1'))
                    {
                        //send_json_error($this->upload->display_errors());
                        //send_json_error($this->upload->display_errors());
                        echo json_encode(array('status' => 'error','content' => $this->upload->display_errors()));
                        exit;
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $params['cal_anexo1_path'] = $data['file_name'];
						$params['cal_anexo1_nombre'] = $nombre_anexo;
                    }
                }

/**********************************************************/				
				
/******NUEVOS ARCHIVO ANEXO 2 ******************************/
                if(!empty($_FILES['anexo2']['name']))
                {
					$nombre_anexo=$_FILES['anexo2']['name'];
                    $this->load->library('upload');
					
					sleep(1);
                    $filename2 = md5(time());
                    $config2 = array(
                            'upload_path'   => './../../files/anexos/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename2,
                            'allowed_types' => 'doc|docx|pdf|txt|xlsx|xls|png|jpg|jpeg',
                            'max_size'      => '10000'
                    );

                    $this->upload->initialize($config2);
					
                    if ( ! $this->upload->do_upload('anexo2'))
                    {
                        //send_json_error($this->upload->display_errors());
                        //send_json_error($this->upload->display_errors());
                        echo json_encode(array('status' => 'error','content' => $this->upload->display_errors()));
                        exit;
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $params['cal_anexo2_path'] = $data['file_name'];
						$params['cal_anexo2_nombre'] = $nombre_anexo;
                    }
                }

/**********************************************************/	
/******NUEVOS ARCHIVO ANEXO 3 ******************************/
                if(!empty($_FILES['anexo3']['name']))
                {
					$nombre_anexo=$_FILES['anexo3']['name'];
                    $this->load->library('upload');
					
					sleep(1);
                    $filename3 = md5(time());
                    $config3 = array(
                            'upload_path'   => './../../files/anexos/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename3,
                            'allowed_types' => 'doc|docx|pdf|txt|xlsx|xls|png|jpg|jpeg',
                            'max_size'      => '10000'
                    );

                    $this->upload->initialize($config3);
					
                    if ( ! $this->upload->do_upload('anexo3'))
                    {
                        //send_json_error($this->upload->display_errors());
                        //send_json_error($this->upload->display_errors());
                        echo json_encode(array('status' => 'error','content' => $this->upload->display_errors()));
                        exit;
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $params['cal_anexo3_path'] = $data['file_name'];
						$params['cal_anexo3_nombre'] = $nombre_anexo;
						
                    }
                }

/**********************************************************/	
/******NUEVOS ARCHIVO ANEXO 4 ******************************/
                if(!empty($_FILES['anexo4']['name']))
                {
					$nombre_anexo=$_FILES['anexo4']['name'];
                    $this->load->library('upload');
					
					sleep(1);
                    $filename4 = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/anexos/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename4,
                            'allowed_types' => 'doc|docx|pdf|txt|xlsx|xls|png|jpg|jpeg',
                            'max_size'      => '10000'
                    );

                    $this->upload->initialize($config);
					
                    if ( ! $this->upload->do_upload('anexo4'))
                    {
                        echo json_encode(array('status' => 'error','content' => $this->upload->display_errors()));
                        exit;
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $params['cal_anexo4_path'] = $data['file_name'];
						$params['cal_anexo4_nombre'] = $nombre_anexo;
                    }
                }

/**********************************************************/				
				
				
                if ($params['emp_id'] > 0)
				{	
                $cal_id = $this->agenda->add_evento_folio(array_to_upper($params));
				}
				
				if($cal_id)
                {

                        $this->load->helper('mail');
                        $evento = $this->agenda->get_evento($cal_id);
						
                        $data_email = array('evento' => $evento);						
                        $html = $this->load->view('agenda/email_add_std_event_serv',$data_email,TRUE);
                        
						if ($user['emp_id'] == 31)
						{
							$this->load->model('empresa/Empresa_model','empresa');
							$data_empresa = $this->empresa->get_empresa_by_id($params['emp_id']);
							send_mail_std_event_serv(
							$this->input->post('mail'), 
							$evento, 
							$html,
							$cal_id,
							get_empresa($params['emp_id']),
							$user['usr_nombre'].' '.$user['usr_paterno'],
							$user['usr_correo'],
							$data_empresa['emp_responsable'] , 
							$data_empresa['emp_correo']
							,$params['cal_lugar'] );
						}
						else
						{
							send_mail_std_event_serv(
							$this->input->post('mail'), 
							$evento, 
							$html,
							$cal_id,
							get_empresa($params['emp_id']),
							$user['usr_nombre'].' '.$user['usr_paterno'],
							$user['usr_correo'],
							'',
							'',
							$params['cal_lugar'] );
						}

                    send_json_ok('Se guardó de forma correcta.');
                }
                else
                {
                    send_json_error('Ocurrió un error al guardar, Por favor revise si toda su información esta completa y vuelva intentar.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div>'));
            }
        }
        else
        {
            if($this->uri->segment(3) != '')
            {
                $data_view['evento_dia'] = date('Y-m-d',strtotime($this->uri->segment(3)));
            }
            else
            {
                $data_view['evento_dia'] = date('Y-m-d');
            }
			
			/*if ($cal_id)
			{
				$data_view['cal_id'] = $cal_id;
			}*/
			
            $data_view['pac'] = FALSE;
			$data_view['solicita'] =$user['usr_nombre'].' '.$user['usr_paterno'];
			
			if ($user['emp_id'] == 31)
			{
				$this->load->model('empresa/Empresa_model','empresa');
				//$data_view['las_empresas'] = $this->empresa->get_all_empresas_no_31();
				$data_view['las_empresas'] =$this->empresa->trae_empresas();//$this->empresa->get_all_empresas(); 
			}
			elseif  (
							($user['emp_id'] == 126)   ||
							($user['emp_id'] == 125)   ||
							($user['emp_id'] == 33)   ||
							($user['emp_id'] == 179)   ||
							($user['emp_id'] == 181)   ||
							($user['emp_id'] == 180)   ||
							($user['emp_id'] == 77)   ||
							($user['emp_id'] == 176)   ||
							($user['emp_id'] == 178)   ||
							($user['emp_id'] == 177)   ||
							($user['emp_id'] ==57)   ||
							($user['emp_id'] ==175)   ||
							($user['emp_id'] ==174)   ||						 
							($user['emp_id'] == 127) 
							|| ($user['emp_id'] == 183)
							|| ($user['emp_id'] ==33)
							|| ($user['emp_id'] ==77)
							|| ($user['emp_id'] ==106)
							|| ($user['emp_id'] ==148)
							
						)/*es un despacho de GSI*/
			{
				$this->load->model('empresa/Empresa_model','empresa');
				$data_view['las_empresas'] = $this->empresa->get_all_empresas_gsi();
			}
				$data_view['empresa'] =$user['emp_id'];
	
			
            //$data_view['title_modal'] = 'Nueva cita';
            $view = $this->load->view('agenda/add_serv',$data_view,TRUE);
            send_json_ok($view);
        }
    }

/*************************************************************************************/	
    function filtro_cei()
    {							  
		$user = $this->session->user; 
		$usuario = $this->empleado->get($user['usr_id']);
		
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('cei','CEI','required');
			
            if($this->form_validation->run())
            {
				
				$params['filtro_cei_id'] = $this->input->post('cei');
				$empleado_id=$user['usr_id'];

                $cal_id = $this->empleado->actualiza($empleado_id, $params); 
				
				if($cal_id)
                {	
		            send_json_ok('Se guardó el filtro en forma correcta.');
					                }
                else
                {
                    send_json_error('Ocurrió un error al guardar, Por favor revise si toda su información esta completa y vuelva intentar.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div>'));
            }
        }
	
        else
        {   
			$data_view['solicita'] =$user['usr_nombre'].' '.$user['usr_paterno'];
			$data_view['cei_actual'] =$usuario['filtro_cei_id'];
			$data_view['empresa'] =$user['emp_id'];
	
            $view = $this->load->view('agenda/filtro_cei',$data_view,TRUE);
            send_json_ok($view);
        }
    }



/*************************************************************************************/	
public function lista_la_viga()
    {
			$params_view = array(
				'title' => 'Agenda',
				'view' => 'agenda/inicio_view_rep_lista',
				'view_data' => $data
			   );
			
            render_template($params_view);  

    }
	
/*****************************************************************/
 public function reporte_evaluados_la_viga()
    {
        $this->load->helper('template');
		

		$f_ini = $this->input->post('f_ini');
        $f_fin = $this->input->post('f_fin'); 

			?>
				<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
				<html xmlns="http://www.w3.org/1999/xhtml">
				
					<head>
					<meta content="es-mx" http-equiv="Content-Language" />
					<meta content="text/html; charset=utf-8" http-equiv="Content-Type" />
					<?php
						header("Content-type: application/octet-stream; charset=latin1");
						header("Content-Disposition: attachment; filename=Rep_evaluados_".$f_ini.".xls");
						header("Pragma: no-cache");
						header("Expires: 0");
					?>			
					<title>#</title>
					<style type="text/css">
					.auto-style1 {
						font-family: Arial, Helvetica, sans-serif;
						color: #FFFFFF;
						background-color: #3D5588;
						font-size: small;
					}
					.auto-style4 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: xx-small;
					}
					.auto-style5 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: medium;
					}
					.auto-style6 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: x-large;
						text-align: right;
						font-weight: normal;
					}
					.auto-style7 {
						font-size: small;
					}
					.auto-style8 {
						color: #3D5588;
					}
					.auto-style9 {
						color: #3AD4A7;
					}
								.auto-style11 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: small;
						text-align: right;
					}
					.auto-style12 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: small;
						text-align: center;
					}
					.auto-style13 {
						font-size: xx-small;
					}
					.auto-style14 {
						font-family: Arial, Helvetica, sans-serif;
						color: #FFFFFF;
						background-color: #3D5588;
						font-size: 14px;
						text-align: center;
					}

					.auto-style144 {
						font-family: Arial, Helvetica, sans-serif;
						color: #FFFFFF;
						background-color: #3D5588;
						font-size: 16px;
						text-align: center;
					}

					.auto-style144_R {
						font-family: Arial, Helvetica, sans-serif;
						color: #FFFFFF;
						background-color: #FF0000;
						font-size: 10px;
						text-align: center;
					}

					.auto-style144_A {
						font-family: Arial, Helvetica, sans-serif;
						color: #000000;
						background-color: #f7d917;
						font-size: 10px;
						text-align: center;
					}

					.auto-style144_V {
						font-family: Arial, Helvetica, sans-serif;
						color: #ffffff;
						background-color:  #007336;
						font-size: 10px;
						text-align: center;
					}


					.auto-style15 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: x-small;
					}
					.auto-style16 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: x-small;
						text-align: right;
					}
					.auto-style17 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: x-small;
						text-align: left;
					}
					.auto-style18 {
						font-family: Arial, Helvetica, sans-serif;
						color: #000000;
						font-size: xx-small;
						text-align: center;
					}

					.auto-style154 {
						font-family: Arial, Helvetica, sans-serif;
						color: #000000;
						font-size: xx-small;
						text-align: center;
						background-color: #BDD7EE;
					}

					.auto-style189 {
						font-family: Arial, Helvetica, sans-serif;
						color: #000000;
						font-size: xx-small;
						text-align: center;
						background-color: #DDEBF7;
					}

					.auto-style188 {
						font-family: Arial, Helvetica, sans-serif;
						color: #000000;
						font-size: xx-small;
						text-align: left;
					}

					.auto-style88 {
						font-family: Arial, Helvetica, sans-serif;
						color: #3D5588;
						font-size: small;
						text-align: right;	
					}

					.auto-style19 {
						color: #3D5588;
						font-size: medium;
					}
					.auto-style20 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: xx-small;
						text-align: center;
						background-color: #BFEADD;
					}
					.auto-style21 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: xx-small;
						background-color: #BFEADD;
					}

					.auto-style190 {
						font-family: Arial, Helvetica, sans-serif;
						color: #0000FF;
					}

					.APTO {
						color: #008000;
						font-weight: bold;
					}
					.NOAPTO {
						color: #FF0000;
						font-weight: bold;
					}

					.PENDIENTE {
						color: #FF00FF;
						font-weight: bold;
					}
					</style>
					</head>
					<body>
						<div class="contenedor">
							<div class="contenido">
									<table> 
										<thead>
											<tr>												
												<th style="width: 78px" class="auto-style5">&nbsp;</th>
												<th style="width: 78px" class="auto-style5">&nbsp;</th>
												<th style="width: 393px" class="auto-style5">&nbsp;</th>
												<th style="width: 370px" class="auto-style5">&nbsp;</th>
												<th style="width: 95px" class="auto-style5">&nbsp;</th>
												<th style="width: 303px" class="auto-style5">&nbsp;</th>
											</tr>
											<tr>
												
												<th style="width: 78px" class="auto-style5">&nbsp;</th>
												<th style="width: 78px" class="auto-style5">&nbsp;</th>
												<th style="width: 393px" class="auto-style6">
												<strong><span class="auto-style8">human</span><span class="auto-style9">center</span></strong></th>
												<th style="width: 370px" class="auto-style11">&nbsp;</th>
												
												<th style="width: 95px" class="auto-style5">&nbsp;</th>
													<th style="width: 303px" class="auto-style5">&nbsp;</th>
											</tr>
											<tr>
												
												<th style="width: 78px" class="auto-style5">&nbsp;</th>
												<th style="width: 78px" class="auto-style5">&nbsp;</th>
												<th style="width: 393px" class="auto-style6">
												<span class="auto-style19">Online</span><sup><span class="auto-style13" style="color: rgb(34, 34, 34); font-family: arial, sans-serif; font-style: normal; font-variant-ligatures: normal; font-variant-caps: normal; font-weight: 400; letter-spacing: normal; orphans: 2; text-align: left; text-indent: 0px; text-transform: none; white-space: normal; widows: 2; word-spacing: 0px; -webkit-text-stroke-width: 0px; background-color: rgb(255, 255, 255); text-decoration-style: initial; text-decoration-color: initial; display: inline !important; float: none;">®</span></sup></th>
												<th style="width: 370px" class="auto-style88">Empresa:&nbsp;&nbsp;Empresas GSI</th>
																		
												<th style="width: 95px" class="auto-style5">&nbsp;</th>
												<th style="width: 303px" class="auto-style5">&nbsp;</th>
											</tr>
											<tr>
												
												<th style="width: 78px" class="auto-style5">&nbsp;</th>
												<th style="width: 78px" class="auto-style5">&nbsp;</th>
												<th style="width: 393px" class="auto-style5">&nbsp;</th>
												<th style="width: 370px" class="auto-style16">Del:&nbsp;&nbsp;<?php echo formatea_fecha($f_ini) ?></th>
												
												<th style="width: 95px" class="auto-style5">&nbsp;</th>
												<th style="width: 303px" class="auto-style5">&nbsp;</th>
											</tr>

											<tr>
												
												<th style="width: 78px" class="auto-style5">&nbsp;</th>
												<th style="width: 78px" class="auto-style5">&nbsp;</th>
												<th style="width: 393px" class="auto-style5">&nbsp;</th>
												<th style="width: 370px" class="auto-style16">Generado el día:&nbsp;&nbsp;<?php echo date("d/m/y h:i:sa"); ?></th>
												
												<th style="width: 95px" class="auto-style5">&nbsp;</th>
													<th style="width: 303px" class="auto-style5">&nbsp;</th>
											</tr>
											<tr>
												
												<th style="width: 78px" class="auto-style5">&nbsp;</th>
												<th style="width: 78px" class="auto-style5">&nbsp;</th>
												<th style="width: 393px" class="auto-style5">&nbsp;</th>
												<th style="width: 370px" class="auto-style15">&nbsp;</th>
												
												<th style="width: 95px" class="auto-style5">&nbsp;</th>
													<th style="width: 303px" class="auto-style5">&nbsp;</th>
											</tr>
										</thead>
									</table> 
<!-------------------------------------------------------------------------------------->
<!-------------------------------INICIA MODULO COMUN------------------------------------>
<!-------------------------------------------------------------------------------------->
<?php


	$this->db->select('*');
	$this->db->from('doc10_calendario');
	$this->db->where('cal_fecha_ini >= ',$f_ini.' 00:00:00');
	$this->db->where('cal_fecha_ini <=',$f_ini.' 23:59:59' );
	$this->db->where('cal_lugar',4);
	$this->db->order_by('cal_fecha_ini', 'ASC');
	$agendados=$this->db->get()->result_array();

			?> 
				<table border=0>
								
					<tr>
						<th class="auto-style14"> <?php echo 'Horario/fecha'; ?></th>
						<th class="auto-style14"> <?php echo 'ID'; ?></th>
						<th class="auto-style14"> <?php echo formatea_fecha_larga($f_ini); ?></th>						
						<th class="auto-style14"> <?php echo 'Empresa solicitante' ?></th>	
						<th class="auto-style14"><?php echo 'Orden de Servicio'; ?></th>
					</tr>
							
				<?php
				foreach($agendados  as $agenda):
								
						 $hora_inicial=str_replace(':02', ' AM', substr($agenda['cal_fecha_ini'],11,13));
						 //$hora_inicial=str_replace(':02', ' PM', substr($agenda['cal_fecha_ini'],11,13));
						 $hora_final=str_replace(':02', ' AM', substr($agenda['cal_fecha_fin'],11,13));
						// $hora_final=str_replace(':02', ' PM', substr($agenda['cal_fecha_fin'],11,13));
						 $empresa=get_empresa($agenda['emp_id']);
						 $evaluados=str_replace('| |', '|',substr($agenda['cal_evaluados'],2,strlen($agenda['cal_evaluados'])));
						 $evaluados_gsi=explode('|',$evaluados);
						 
						 foreach($evaluados_gsi  as $persona):
							if ( (strval($persona) > 0) )
							{	
								$gsi=explode('-',$persona);
								
								$this->db->select('*');
								$this->db->from('sis05_clientes');
								$this->db->where('clte_id',strval($gsi[0]));
								$servicio=$this->db->get()->result_array();								
								
								if (strstr('auto-style154',$class18))																	
									{$class18="auto-style189";}
									else
									{$class18="auto-style154";}	
							?> 				
									<tr>
										<td class=<?php echo $class18; ?>> <?php echo $hora_inicial.' - '.$hora_final; ?></td>
										<td class=<?php echo $class18; ?>> <?php echo $gsi[0]; ?></td>						
										<td class=<?php echo $class18; ?>> <?php echo $gsi[1]; ?></td>	
										<td class=<?php echo $class18; ?>> <?php echo $empresa; ?></td>
										<td class=<?php echo $class18; ?>> <?php echo $servicio[0]['serv_id']; ?></td>
									</tr>
								<?php
							
							}					
						endforeach;
				endforeach;			
				?>	
				</table>
			<?php
	
	?>
	</div>
	</div>
					</body>
				</html>
			<?php
				
	}		



/*****************************************************************/




	
/*************************************************************************************/	
    function filtro()
    {
        $user_root4=get_my_user_root4();
		$user = $this->session->user; 
		$usuario = $this->empleado->get($user['usr_id']);

        if(isset($_POST) && count($_POST) > 0)     
        {
            //recibe los datos
            $this->load->library('form_validation');
            $this->form_validation->set_rules('empresa','Empresa','required');
           // $this->form_validation->set_rules('asunto','Asunto','required');
			
            if($this->form_validation->run())
            {				
				$params['filtro_id'] = $this->input->post('empresa');
				$empleado_id=$user['usr_id'];

                $cal_id = $this->empleado->actualiza($empleado_id, $params); //$this->agenda->add_evento_folio(array_to_upper($params));

				if($cal_id)
                {
                    send_json_ok('Se guardó el filtro en forma correcta.');
					
                }
                else
                {
                    send_json_error('Ocurrió un error al guardar, Por favor revise si toda su información esta completa y vuelva intentar.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div>'));
            }
        }
        else
        {   

			$data_view['solicita'] =$user['usr_nombre'].' '.$user['usr_paterno'];

			if (strstr($usuario['portal'],'MAQUILA'))
			{
				$i=0;
				foreach ( explode(';',$usuario['empresas'] )  as $esta_empresa) 
				{
					if ($esta_empresa > 0)
					{	
						$gss[$i]=$esta_empresa;
						$i++;
					}
				}	
				$data_view['las_empresas'] =  $this->empresa->get_all_empresas_gss($gss);
			}
			elseif (($usuario['emp_id'] == 31) && ($usuario['corporacion'] == 'GSI'))
			{
				$data_view['las_empresas'] = $this->empresa->get_all_empresas_gsi();
			}
			elseif ($user_root4 > 4)
			{
				$data_view['las_empresas'] = $this->empresa->get_all_empresas_gsi();
			}
			else
			{
				$data_view['las_empresas'] = $this->empresa->trae_empresas();//$this->empresa->get_all_empresas();
			}

			$data_view['empresa'] =$user['emp_id'];
			$data_view['empresa_actual'] =$usuario['filtro_id'];
			$data_view['usuario'] =$usuario;
            //$data_view['title_modal'] = 'Nueva cita';
            $view = $this->load->view('agenda/filtro',$data_view,TRUE);
            send_json_ok($view);
        }
    }
/*************************************************************************************/	
    function nueva_t()
    {   $user = $this->session->user;
		
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
			$this->form_validation->set_rules('empresa','Empresa','required');
			
            if($this->form_validation->run())
            {
				
				$params['emp_id'] = $this->input->post('empresa');
				$empleado_id=$user['usr_id'];
				
				
                if(1)
                {
					$this->empresa->get_empresa($params['emp_id']);
                    send_json_ok('Se guardó de forma correcta');

           $this->load->helper('template');
			$data_view['solicita'] =$user['usr_nombre'].' '.$user['usr_paterno'];
			$data_view['las_empresas'] = $this->empresa->trae_empresas();//$this->empresa->get_all_empresas();
			$data_view['empresa'] =$user['emp_id'];
			$params_view = array(
                'title' => 'Solicita Empresa',
                'view' => 'agenda/add_emp',
				'view_data' => $data_view
               );
            render_template($params_view);  
        
					

                }
                else
                {
                    send_json_error('Ocurrió un error al registrar la empresa.');
                }
				
				
				
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $this->load->helper('template');
			$data_view['solicita'] =$user['usr_nombre'].' '.$user['usr_paterno'];
			$data_view['las_empresas'] = $this->empresa->trae_empresas();//$this->empresa->get_all_empresas();
			$data_view['empresa'] =$user['emp_id'];
			$params_view = array(
                'title' => 'Solicita Empresa',
                'view' => 'agenda/add_emp',
				'view_data' => $data_view
               );
            render_template($params_view);  
        }
    }  



/*********************************/ 
/******************************/
    function nueva_tr()
    {   $user = $this->session->user;
		
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
			$this->form_validation->set_rules('empresa','Empresa','required');
			
            if($this->form_validation->run())
            {
				
				$params['emp_id'] = $this->input->post('empresa');
				$empleado_id=$user['usr_id'];
				
				
                if($this->empresa->get_empresa($params['emp_id']) )
                {
                    send_json_ok('Se guardó de forma correcta');

                }
                else
                {
                    send_json_error('Ocurrió un error al registrar la empresa.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $this->load->helper('template');
			$data_view['solicita'] =$user['usr_nombre'].' '.$user['usr_paterno'];
			$data_view['las_empresas'] = $this->empresa->trae_empresas();//$this->empresa->get_all_empresas();
			$data_view['empresa'] =$user['emp_id'];
			$params_view = array(
                'title' => 'Solicita Empresa',
                'view' => 'agenda/add_emp',
				'view_data' => $data_view
               );
            render_template($params_view);  
        }
    }  



/*********************************/ 
/************* empresa_select ******************************************************************/	    
    function empresa_select()
    {
        
		$user = $this->session->user;
		
		
        if(isset($_POST) && count($_POST) > 0)     
        {
            //recibe los datos
            $this->load->library('form_validation');
            $this->form_validation->set_rules('empresa','Empresa','required');
          			
            if($this->form_validation->run())
            {
				
					$params['filtro_id'] = $this->input->post('empresa');
					$empleado_id=$user['usr_id'];

					$cal_id = $this->empleado->actualiza($empleado_id, $params); //$this->agenda->add_evento_folio(array_to_upper($params));

				if($cal_id)
                {
                    send_json_ok('Se guardó el filtro en forma correcta.');

							
                }
                else
                {
                    send_json_error('Ocurrió un error al guardar, Por favor revise si toda su información esta completa y vuelva intentar.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div>'));
            }
        }
	
        else
        {   

           
			$data_view['solicita'] =$user['usr_nombre'].' '.$user['usr_paterno'];
			$data_view['las_empresas'] = $this->empresa->trae_empresas();//$this->empresa->get_all_empresas();
			$data_view['empresa'] =$user['emp_id'];

            $this->load->helper('template');
            $params_view = array(
                'title' => 'Servicios',
                'view' => 'agenda/empresa_select',
                'view_data' => $data_view
               );
            render_template($params_view); 

			
        //    $view = $this->load->view('agenda/empresa_select',$data_view,TRUE);
        //    send_json_ok($view);
        }
    }	
/*************************************************************************************/	




/*************filtro ******************************************************************/	    
    function empresa_solicita()
    {
        
		$user = $this->session->user;
		
		
        if(isset($_POST) && count($_POST) > 0)     
        {
			
			$user_root4=get_my_user_root4();
            //recibe los datos
            $this->load->library('form_validation');
            $this->form_validation->set_rules('empresa','Empresa','required');
           // $this->form_validation->set_rules('asunto','Asunto','required');
			
            if($this->form_validation->run())
            {
				
					$params['filtro_id'] = $this->input->post('empresa');
					$empleado_id=$user['usr_id'];
				
				
               /* if ($params['emp_id'] > 0)
				{	*/
                $cal_id = $this->empleado->actualiza($empleado_id, $params); //$this->agenda->add_evento_folio(array_to_upper($params));
				/*}*/
				
				if($cal_id)
                {
                    send_json_ok('Se guardó el filtro en forma correcta.');
					redirect('empresa/index');
					exit;
                }
                else
                {
                    send_json_error('Ocurrió un error al guardar, Por favor revise si toda su información esta completa y vuelva intentar.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div>'));
            }
        }
	
        else
        {   

           
			$data_view['solicita'] =$user['usr_nombre'].' '.$user['usr_paterno'];
			//$this->load->model('empresa/Empresa_model','empresa');

			$data_view['las_empresas'] = $this->empresa->trae_empresas();//$this->empresa->get_all_empresas();

			$data_view['empresa'] =$user['emp_id'];
	
			
            //$data_view['title_modal'] = 'Nueva cita';
            $view = $this->load->view('agenda/empresa_solicita',$data_view,TRUE);
            send_json_ok($view);
        }
    }
/*************************************************************************************/	

/*************************************************************************************/ 
/*								Validador DE EVENTOS									 */ 
/*************************************************************************************/ 
public function valida_empresa() 
    {
		$user = $this->session->user;
		$evento = $this->agenda->get_evento('2885');
		$titulo=$evento['cal_titulo'];
        
        if($evento)
        {

            if (0) //  (isset($_POST) && count($_POST) > 0 )     
            {
               $this->load->library('form_validation');
              //  $this->form_validation->set_rules('nombre','Nombre','required');
               // $this->form_validation->set_rules('paterno','Apellido Paterno','required');
              //  $this->form_validation->set_rules('materno','Apellido Materno','required');
              //  $this->form_validation->set_rules('fnac','Fecha de nacimiento','required');
               $this->form_validation->set_rules('clave_valida','Clave de Aprobación','required');
               $this->form_validation->set_rules('valida_obs','Observaciones','required');
                

                   // $data_usr = array_to_upper($data_usr);
                    
					$params['cal_user_valida'] = $this->input->post('user_valida');
					$params['cal_clave_valida'] = $this->input->post('clave_valida');
					$params['cal_det_validacion'] = $this->input->post('valida_obs');
		
					if ($this->input->post('clave_valida') == '2020')
					{	
                    $cal_id = $this->agenda->update_evento($evento['cal_id'], array_to_upper($params));
                    }
					
					if($cal_id)
                    {
						$this->load->helper('mail');
                        $evento_n = $this->agenda->get_evento($evento_id);
                        $data_email = array(
                                            'evento' => $evento_n, 
                                            'evento_old' => $evento
											);
						
						$html = $this->load->view('agenda/email_valid_std_event_serv',$data_email,TRUE);
						send_mail_valid_std_event_serv($this->input->post('mail'), $evento_n, $html,$evento_id,get_empresa($user['emp_id']),$user['usr_nombre'].' '.$user['usr_paterno'],$user['usr_correo'],$params['cal_lugar']);
                        send_json_ok('Se actualizó de forma correcta');
                    }
                    else
                    {
                        send_json_error('Ocurrió un error al v a l id a r el servicio.');
                    }
            }
            else 
            {
				
               // $this->load->model('empresa/Empresa_model','empresa');
               // $data['empresas'] = $this->empresa->get_all_empresas();
			//	$data['sucursals'] = $this->empresa->get_all_sucursales();
               $data['empleado'] = $user;
			   $data['evento'] = $evento;
			//data['empleado_password'] = $empleado_password;
				
				
				
				$this->load->helper('template');
                $params_view = array(
                    'title' => 'Valida',
                    'view' => 'agenda/valida',
                    'view_data' => $data
                   );
                render_template($params_view);  
            }
        }
        else 
        {
            show_error('No existe el Evento');
        }
    } 



/*************************************************************************************/ 
/*								Validador DE EVENTOS									 */ 
/*************************************************************************************/ 
public function valida($evento_id) 
    {
		$user = $this->session->user;
		$evento = $this->agenda->get_evento($evento_id);
		$titulo=$evento['cal_titulo'];
        
        if($evento)
        {

            if(isset($_POST) && count($_POST) > 0)     
            {
               $this->load->library('form_validation');
              //  $this->form_validation->set_rules('nombre','Nombre','required');
               // $this->form_validation->set_rules('paterno','Apellido Paterno','required');
              //  $this->form_validation->set_rules('materno','Apellido Materno','required');
              //  $this->form_validation->set_rules('fnac','Fecha de nacimiento','required');
               $this->form_validation->set_rules('clave_valida','Clave de Aprobación','required');
               $this->form_validation->set_rules('valida_obs','Observaciones','required');
                

                   // $data_usr = array_to_upper($data_usr);
                    
					$params['cal_user_valida'] = $this->input->post('user_valida');
					$params['cal_clave_valida'] = $this->input->post('clave_valida');
					$params['cal_det_validacion'] = $this->input->post('valida_obs');
		
					if ($this->input->post('clave_valida') == '2020')
					{	
                    $cal_id = $this->agenda->update_evento($evento['cal_id'], array_to_upper($params));
                    }
					
					if($cal_id)
                    {
						$this->load->helper('mail');
                        $evento_n = $this->agenda->get_evento($evento_id);
                        $data_email = array(
                                            'evento' => $evento_n, 
                                            'evento_old' => $evento
											);
						
						$html = $this->load->view('agenda/email_valid_std_event_serv',$data_email,TRUE);
						send_mail_valid_std_event_serv($this->input->post('mail'), $evento_n, $html,$evento_id,get_empresa($user['emp_id']),$user['usr_nombre'].' '.$user['usr_paterno'],$user['usr_correo'],$params['cal_lugar']);
                        send_json_ok('Se actualizó de forma correcta');
                    }
                    else
                    {
                        send_json_error('Ocurrió un error al validar el servicio.');
                    }
               // }
               // else
               // {
               //     send_json_error(validation_errors('<div />'));
               // }
            }
            else 
            {
				
               // $this->load->model('empresa/Empresa_model','empresa');
               // $data['empresas'] = $this->empresa->get_all_empresas();
			//	$data['sucursals'] = $this->empresa->get_all_sucursales();
               $data['empleado'] = $user;
			   $data['evento'] = $evento;
			//data['empleado_password'] = $empleado_password;
				
				
				
				$this->load->helper('template');
                $params_view = array(
                    'title' => 'Valida',
                    'view' => 'agenda/valida',
                    'view_data' => $data
                   );
                render_template($params_view);  
            }
        }
        else 
        {
            show_error('No existe el Evento');
        }
    } 



/*************************************************************************************/ 
/*								EDITOR DE EVENTOS									 */ 
/*************************************************************************************/ 
    function evento($evento_id) 
    {
	   $user = $this->session->user;
	   $usuario = $this->empleado->get($user['usr_id']);
       $evento = $this->agenda->get_evento($evento_id);
	   
	   $titulo=$evento['cal_titulo'];
	   $empresa= $this->empresa->get_empresa($evento['emp_id']);
	   $empresa_ori=$evento['emp_id'];
	   
	   if(isset($evento['cal_id']))
       {
            $data_view['evento_dia'] = $evento['cal_fecha'];
           
		   if(isset($_POST) && count($_POST) > 0)     
            {
                //recibe los datos
                $this->load->library('form_validation');
                //$this->form_validation->set_rules('fecha','Fecha','required');
                //$this->form_validation->set_rules('asunto','Asunto','required');
                $this->form_validation->set_rules('fecha_event_ini','Fecha inicia','required');
                $this->form_validation->set_rules('fecha_event_fin','Fecha inicia','required');
                $this->form_validation->set_rules('hora_event_ini','Hora inicia','required');
                $this->form_validation->set_rules('hora_event_fin','Hora fin','required');
				//$this->form_validation->set_rules('observaciones','Observaciones','required');
				
				//$this->form_validation->set_rules('evaluados','Evaluados','required');
				//$this->form_validation->set_rules('lugar','Lugar de realización de los servicios','required');
			
				
                if($this->form_validation->run())
                {

					if ($user['usr_id'] == 261)
					{
						$usr_admin=$this->input->post('administrador');
						if ($usr_admin == 0){$usr_admin = 22;}
						$user=get_a_usuario($usr_admin);						
					}						
					
                    $fecha_ini = formatea_fechahora_mysql($this->input->post('fecha_event_ini').' '.$this->input->post('hora_event_ini'));
                    $fecha_fin = formatea_fechahora_mysql($this->input->post('fecha_event_fin').' '.$this->input->post('hora_event_fin'));

                    $params = array(

						'cal_observaciones' => $this->input->post('observaciones'),

						'cal_evaluados' => $this->input->post('evaluados'),
						
						'cal_usr_nombre' => $user['usr_nombre'],
						'cal_usr_paterno' => $user['usr_paterno'],
						'cal_usr_materno' => $user['usr_materno'],
						
						'cal_usr_correo' => $user['usr_correo'],
						
                        'cal_fecha' => $this->input->post('fecha'),
						'cal_titulo' => $titulo,
                        //'cal_titulo' => $this->input->post('asunto'),                        
						'cal_servicio' => NULL,
                        'cal_descripcion' => $this->input->post('descripcion'),
                        'cal_fecha_ini' => $fecha_ini,
                        'cal_fecha_fin' => $fecha_fin,
                        'cal_uid' => uniqid(rand(0, getmypid()))
                    );
					
				if  (strlen($evento['cal_pkts'])>0)
				{		
					$total_examenes_selectos=$this->input->post('total_examenes_selectos');
					$paquetes='';
					$detecta_pkts=0;
					for($i=1; $i <= $total_examenes_selectos; $i++)
					{
						$indice='examen_select_pkt_'.strval($i);
						if ($this->input->post($indice) != NULL)
						{	
						$paquetes.=$this->input->post($indice).';';
						$detecta_pkts++;
						}						
					}
					$params['cal_pkts'] = $paquetes;
				}				
						
					$params['emp_id'] = $empresa_ori;
					$params['cal_lugar'] = $this->input->post('lugar');
					$params['cal_email'] = $this->input->post('mail');
					
					if ( $user['emp_id'] == 31 ) /* campo de validación*/
					{ 					
						if ( strlen($this->input->post('det_validacion')) > 0 ) /* campo de validación*/
						{ 
						$params['cal_det_validacion'] = $this->input->post('det_validacion');
						$validacion= 1;
						}
					}
					
				if (($evento['emp_id']== 152) || ($evento['emp_id'] == 193) || ($evento['emp_id'] == 210) || ($evento['emp_id'] == 230))
				{	
			
					if ( $user['emp_id'] == 31 ) /* campo de validación*/
					{ 
						$params['hc1'] =$this->input->post('hc1');
						$params['hc2'] =$this->input->post('hc2');
						$params['hc3'] =$this->input->post('hc3');
						
						if	(
								($evento['emp_id'] == 210) &&
								(
									($params['hc1'] != '') ||
									($params['hc2'] != '') ||
									($params['hc3'] != '')  
								)
							)
							{
								$data_clte['clte_status_proc']= 'CONFIRMADO';
							}
					}
					
					$params['cal_eva_telefono_1'] = $this->input->post('telefono_1');						
					$params['cal_eva_telefono_2'] = $this->input->post('telefono_2');		
				}
				
					$params['cal_lugar_det'] = $this->input->post('lugar_det');

                    
                    if(get_perfil_id() == 4)
					{
                        $params['emp_id'] = get_emp_id();
                    }
                    

					if(!empty($_FILES['paquete']['name']))
					{
						$nombre_anexo_p=$_FILES['paquete']['name'];
						$this->load->library('upload');
						
						sleep(1);
						//$filename1 ='insignia_life_'.date(dmYHis).'_'.$usuario['usr_username'];//.md5(time());
						$filename1 ='insignia_'.date(dmYHis).'_'.rand(1,99);//.md5(time());
						$config = array(
								'upload_path'   => './../../files/anexos/',
								'overwrite'     => TRUE,
								'file_name'     => $filename1,
								'allowed_types' => 'doc|docx|pdf|txt|xlsx|xls|png|jpg|jpeg',
								'max_size'      => '10000'
						);

						$this->upload->initialize($config);
						
						if ( ! $this->upload->do_upload('paquete'))
						{
							  echo json_encode(array('status' => 'error','content' => $this->upload->display_errors()));
							exit;
						}
						else /*HAY QUE ACTUALIZAR*/
						{
							$data_p = $this->upload->data();
							$params['cal_arch_serv_path'] = $data_p['file_name'];
							$params['cal_arch_serv_nombre'] = $nombre_anexo_p;
							$data_serv['serv_arch_serv_path'] = $data['file_name'];
							$data_serv['serv_arch_serv_nombre '] = $nombre_anexo_p;
						}
					}


                    if(!empty($_FILES['anexo']['name']))
                    {
						$nombre_anexo=$_FILES['anexo']['name'];
                        $this->load->library('upload');
                        $filename = md5(time());
                        $config = array(
                                'upload_path'   => './../../files/anexos/',
                                'overwrite'     => TRUE,
                                'file_name'     => $filename,
                                'allowed_types' => 'doc|docx|pdf|txt|xlsx|xls|png|jpg|jpeg',
                                'max_size'      => '10000'
                        );

                        $this->upload->initialize($config);
                        if ( ! $this->upload->do_upload('anexo'))
                        {
                            echo json_encode(array('status' => 'error','content' => $this->upload->display_errors()));
                            exit;
                        }
                        else 
                        {
                            $data = $this->upload->data();
                            $params['cal_anexo_path'] = $data['file_name'];
							$params['cal_anexo_nombre'] = $nombre_anexo;
                        }
                    }

                if(!empty($_FILES['anexo1']['name']))
                {
					$nombre_anexo=$_FILES['anexo1']['name'];
                    $this->load->library('upload');
					
					sleep(1);
                    $filename1 = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/anexos/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename1,
                            'allowed_types' => 'doc|docx|pdf|txt|xlsx|xls|png|jpg|jpeg',
                            'max_size'      => '10000'
                    );

                    $this->upload->initialize($config);
					
                    if ( ! $this->upload->do_upload('anexo1'))
                    {
                        echo json_encode(array('status' => 'error','content' => $this->upload->display_errors()));
                        exit;
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $params['cal_anexo1_path'] = $data['file_name'];
						$params['cal_anexo1_nombre'] = $nombre_anexo;
                    }
                }

                if(!empty($_FILES['anexo2']['name']))
                {
					$nombre_anexo=$_FILES['anexo2']['name'];
                    $this->load->library('upload');
					
					sleep(1);
                    $filename2 = md5(time());
                    $config2 = array(
                            'upload_path'   => './../../files/anexos/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename2,
                            'allowed_types' => 'doc|docx|pdf|txt|xlsx|xls|png|jpg|jpeg',
                            'max_size'      => '10000'
                    );

                    $this->upload->initialize($config2);
					
                    if ( ! $this->upload->do_upload('anexo2'))
                    {
                        echo json_encode(array('status' => 'error','content' => $this->upload->display_errors()));
                        exit;
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $params['cal_anexo2_path'] = $data['file_name'];
						$params['cal_anexo2_nombre'] = $nombre_anexo;
                    }
                }

/**********************************************************/	
/******NUEVOS ARCHIVO ANEXO 3 ******************************/
                if(!empty($_FILES['anexo3']['name']))
                {
					$nombre_anexo=$_FILES['anexo3']['name'];
                    $this->load->library('upload');
					
					sleep(1);
                    $filename3 = md5(time());
                    $config3 = array(
                            'upload_path'   => './../../files/anexos/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename3,
                            'allowed_types' => 'doc|docx|pdf|txt|xlsx|xls|png|jpg|jpeg',
                            'max_size'      => '10000'
                    );

                    $this->upload->initialize($config3);
					
                    if ( ! $this->upload->do_upload('anexo3'))
                    {
                        echo json_encode(array('status' => 'error','content' => $this->upload->display_errors()));
                        exit;
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $params['cal_anexo3_path'] = $data['file_name'];
						$params['cal_anexo3_nombre'] = $nombre_anexo;
						
                    }
                }

                if(!empty($_FILES['anexo4']['name']))
                {
					$nombre_anexo=$_FILES['anexo4']['name'];
                    $this->load->library('upload');
					
					sleep(1);
                    $filename4 = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/anexos/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename4,
                            'allowed_types' => 'doc|docx|pdf|txt|xlsx|xls|png|jpg|jpeg',
                            'max_size'      => '10000'
                    );

                    $this->upload->initialize($config);
					
                    if ( ! $this->upload->do_upload('anexo4'))
                    {
                        echo json_encode(array('status' => 'error','content' => $this->upload->display_errors()));
                        exit;
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $params['cal_anexo4_path'] = $data['file_name'];
						$params['cal_anexo4_nombre'] = $nombre_anexo;
                    }
                }

				if ( ($params['emp_id'] == 152) || ($params['emp_id'] == 210)  || ($evento['emp_id'] == 193) || ($evento['emp_id'] == 230))
				{	
					$pos1 = stripos($evento['cal_titulo'], '*');
					$mi_titulo=substr($evento['cal_titulo'],0,$pos1);
					$mi_titulo.=' ** '.get_options_per_grupo('HC_SEGUROS', $params['hc1']);
					$params['cal_titulo']=$mi_titulo;
                }
				else
				{
					$params['cal_titulo']=str_replace("FOLIO", "FOLIO ACTUALIZADO",$evento['cal_titulo']);
				}



					if  (strlen($evento['cal_pkts'])>0)
					{		
						
						$data_serv['serv_f_inicio'] = $fecha_ini;
						$data_serv['serv_f_fin'] = $fecha_fin;
						$data_serv['serv_desc'] = $this->input->post('observaciones');
						$data_serv['serv_ubicacion'] =   $this->input->post('lugar');

						$data_serv['cei_id'] = $user['cei_id'];

						if (strlen($params['cal_anexo_path'])>0)
						{							
						$data_serv['serv_anexo_path'] = $params['cal_anexo_path'];
						$data_serv['serv_anexo_nombre'] = $params['cal_anexo_nombre'];
						}
						if (strlen($params['cal_anexo1_path'])>0)
						{
						$data_serv['serv_anexo1_path'] = $params['cal_anexo1_path'];
						$data_serv['serv_anexo1_nombre'] = $params['cal_anexo1_nombre'];
						}
						if (strlen($params['cal_anexo2_path'])>0)
						{						
						$data_serv['serv_anexo2_path'] = $params['cal_anexo2_path'];
						$data_serv['serv_anexo2_nombre'] = $params['cal_anexo2_nombre'];
						}
						if (strlen($params['cal_anexo3_path'])>0)
						{						
						$data_serv['serv_anexo3_path'] = $params['cal_anexo3_path'];
						$data_serv['serv_anexo3_nombre'] = $params['cal_anexo3_nombre'];
						}
						
						if (strlen($params['cal_anexo4_path'])>0)
						{
						$data_serv['serv_anexo4_path'] = $params['cal_anexo4_path'];
						$data_serv['serv_anexo4_nombre'] = $params['cal_anexo4_nombre'];						
						}
		
					}
					$params=array_to_upper($params);
					$params['cal_arch_serv_path'] = $data_p['file_name'];
					$params['cal_arch_serv_nombre'] = $nombre_anexo_p;
                   
				   
				   $params['eva1'] = $evento['eva1'];
				   $params['eva2'] = $evento['eva2'];
				   $params['eva3'] = $evento['eva3'];
				   $params['eva4'] = $evento['eva4'];
		
				   
				   $cal_id = $this->agenda->update_evento($evento['cal_id'],$params);
					
					if($cal_id)						
                    {
						$evento_n = $this->agenda->get_evento($evento_id);
						
						if ($evento['serv_id'] > 0)
						{	
							$data_serv['serv_desc']=$evento_n['cal_observaciones'];
							$data_serv['serv_arch_serv_path'] = $evento_n['cal_arch_serv_path'];
							$data_serv['serv_arch_serv_nombre '] = $evento_n['cal_arch_serv_nombre'];

							$data_serv['serv_f_inicio'] = $evento_n['cal_fecha_ini'];
							$data_serv['serv_f_fin'] = $evento_n['cal_fecha_fin'];
							
							if	(
									($evento['emp_id'] == 210) &&
									($data_clte['clte_status_proc'] == 'CONFIRMADO')
								)
							{
								if ($evento_n['eva1'] != '')
								{ $this->cliente->actualiza_registro_sin_log($evento_n['eva1'],$data_clte); }
								if ($evento_n['eva2'] != '')
								{ $this->cliente->actualiza_registro_sin_log($evento_n['eva2'],$data_clte); }
								if ($evento_n['eva3'] != '')
								{ $this->cliente->actualiza_registro_sin_log($evento_n['eva3'],$data_clte); }
							}
							
							
						
							if  ( (strlen($evento['cal_pkts'])>0) && ($evento['emp_id'] != 210) )
							{
								$this->servicio->delete_examenes($evento['serv_id']);	
								
								$serv_emp=$this->servicio->get_serv_emp($evento['serv_id']);
												
								$fsm_pakts= get_costos_paquetes_empresa($serv_emp['emp_id']);
								
								$total_examenes_selectos= $this->input->post('total_examenes_selectos');	

									foreach($fsm_pakts as $fsm_pakt): 
												
											for($i=1; $i <= $total_examenes_selectos; $i++)
											{	
												
												$indice='examen_select_pkt_'.strval($i);
												$paquetes= $this->input->post($indice);	
														
												if ( $fsm_pakt['cost_nombre_pkt'] === $paquetes)
												{
													$examen_ins['exam_nombre_pkt'] = $fsm_pakt['cost_nombre_pkt']; //nombre del paquete
													$examen_ins['serv_id'] = $evento['serv_id'];
													$examen_ins['exam_cve'] = $fsm_pakt['cost_examen_cve']; //lo que contiene el paquete
													$examen_ins['exam_monto'] = $fsm_pakt['cost_monto']; //lo que contiene el paquete								 	 
													$examen_ins['exam_cantidad'] = 1;
													$examen_ins['exam_estatus_cve'] = 'PEND';
													$examen_ins['exam_tipo_pkt'] = $fsm_pakt['cost_tipo_pkt'];
													$this->servicio->inserta_examen($examen_ins);
												}	
											}	
									endforeach;
								
									$this->servicio->update($evento['serv_id'],$data_serv);
									
									//costos para el servicio creado
									$total_examenes_selectos= $this->input->post('total_examenes_selectos');	
									$fsm_pakts= get_costos_paquetes_empresa($emp_id);
									if($fsm_pakts):
										foreach($fsm_pakts as $fsm_pakt): 
													
												for($i=1; $i <= $total_examenes_selectos; $i++)
												{									
													$indice='examen_select_pkt_'.strval($i);
													$paquetes= $this->input->post($indice);	
															
													if ( $fsm_pakt['cost_nombre_pkt'] === $paquetes)
													{
														$examen_ins['exam_nombre_pkt'] = $fsm_pakt['cost_nombre_pkt']; //nombre del paquete
														$examen_ins['serv_id'] = $serv_id;
														$examen_ins['exam_cve'] = $fsm_pakt['cost_examen_cve']; //lo que contiene el paquete
														$examen_ins['exam_monto'] = $fsm_pakt['cost_monto']; //lo que contiene el paquete								 	 
														$examen_ins['exam_cantidad'] = 1;
														$examen_ins['exam_estatus_cve'] = 'xPEND';
														$examen_ins['exam_tipo_pkt'] = $fsm_pakt['cost_tipo_pkt'];
														$this->servicio->inserta_examen($examen_ins);
														//$i=$total_examenes_selectos+1;
													}							
												}	
										endforeach;
									endif;								
							}
							elseif  ($evento['emp_id'] == 210) 
							{
								$this->servicio->update($evento['serv_id'],$data_serv);
							}
						}
					   
						$this->load->helper('mail');
						
						$data_email = array(
										'evento' => $evento_n, 
										'evento_old' => $evento
										);

						$html = $this->load->view('agenda/email_edit_evento_servicio',$data_email,TRUE);
						send_mail_edit_std_event_serv($this->input->post('mail'), $evento_n, $html,$evento_id,get_empresa($user['emp_id']),$user['usr_nombre'].' '.$user['usr_paterno'],$user['usr_correo'],$params['cal_lugar']);
  
						send_json_ok('Se actualizó de forma correcta.');
                    }					
                    else
                    {
                        send_json_error('Ocurrió un error al actualizar, intente de nuevo más tarde.');
                    }
                }
                else
                {
                    send_json_error(validation_errors('<div>'));
                }
            }
            else
            {
				
				
                $data_view['title_modal'] = 'Cita';
                $data_view['evento'] = $evento;
				$data_view['empresa'] = $empresa;	

				if (strstr($usuario['portal'],'ALPURA'))
				{
					$view = $this->load->view('agenda/edit_serv_c',$data_view,TRUE);
				}
				else
				{
					$view = $this->load->view('agenda/edit_serv',$data_view,TRUE);
				}
				
                send_json_ok($view);
            }
        }
        else
        {
            send_json_error('No existe el evento.');
        }
    }

    //elimina el evento
    function borra($evento_id)
    { 
        $evento = $this->agenda->get_evento($evento_id);
		
		$id_horario =$evento['cal_id_horario'];
		$cuantos_evaluados=$evento['cal_cuantos_evaluados'];
		
		$horario_ok=$this->agenda->get_horario($id_horario);
		
		$horario_ok['she_capacidad']=$horario_ok['she_capacidad']+$cuantos_evaluados;
		$horario_apartado=$this->agenda->aparta_horario($id_horario,$horario_ok);
		
        if(isset($evento['cal_id']))
        {
            if($this->agenda->delete_evento($evento_id))
            {
                    $this->load->helper('mail');
                    $data_email = array('evento' => $evento);
					
					
                    $html = $this->load->view('agenda/email_del_std_event',$data_email,TRUE);
					send_mail_del_std_event($evento['cal_email'], $evento, $html);
 
                //} 
                send_json_ok('Se eliminó de forma correcta');
            }
            else 
            {
                send_json_error('Ocurrió un error al eliminar el evento, intente de nuevo más tarde');
            }
        }
        else
        {
            send_json_error('No existe el evento.');
        }
    }
    
	
    function borra_c($evento_id)
    { 
		$user = $this->session->user;
        $evento = $this->agenda->get_evento($evento_id);
		
		$id_horario =$evento['cal_id_horario'];
		$cuantos_evaluados=$evento['cal_cuantos_evaluados'];
		
		$horario_ok=$this->agenda->get_horario($id_horario);
		
		$horario_ok['she_capacidad']=$horario_ok['she_capacidad']+$cuantos_evaluados;
		$horario_apartado=$this->agenda->aparta_horario($id_horario,$horario_ok);
		
        if(isset($evento['cal_id']))
        {
            if($this->agenda->delete_evento($evento_id))
            {
                    $this->load->helper('mail');
                    $data_email = array('evento' => $evento);					
                    $html = $this->load->view('agenda/email_del_std_event_c',$data_email,TRUE);
					
								$gsi_evaluados=$evento['cal_evaluados'];
								$gsi_evaluados=str_replace(' | ', '|',$gsi_evaluados);
								$gsi_evaluados=str_replace('||', '|',$gsi_evaluados);
								$gsi_evaluados[0]=' ';
								$gsi_evaluados=trim($gsi_evaluados);
								$gsi_evaluados=str_replace(' - ', '-',$gsi_evaluados);
								$array_gsi_evaluados=explode("|",$gsi_evaluados);
								
								foreach ($array_gsi_evaluados as $gsi_evaluado): 
									if ($gsi_evaluado)
									{	
										$array_gsi_evaluado=explode("-",$gsi_evaluado);								
										$data_y['clte_ida']=0; //   $cal_id;
										$this->cliente->actualiza_registro_sin_log($array_gsi_evaluado[0],array_to_upper($data_y));											
									}
								endforeach;		

								$gsi_evaluados=$evento['cal_evaluados'];
								$gsi_evaluados=trim($gsi_evaluados);
								$gente = $this->cliente->geton($array_gsi_evaluado[0]); 
								$gente_telefono=$gente['clte_email'];
								$gente_nombre=$gente['clte_nombre'].' '.$gente['clte_paterno'].' '.$gente['clte_materno'];

								$cuantos_evaluados++;

								$cal_fecha_ini=$evento['cal_fecha_ini'];
								$cal_fecha_fin=$evento['cal_fecha_fin'];
					
								$cal_fecha=substr($cal_fecha_ini,0,10);
								$cal_hora_ini=trim(substr($cal_fecha_ini,11,17));
								$cal_hora_fin=trim(substr($cal_fecha_fin,11,17));								
								$cal_hora_ini=str_replace(':02','',$cal_hora_ini);
								$cal_hora_fin=str_replace(':02','',$cal_hora_fin);
								
												
								$cadena_de_datos=$cal_fecha.' '.$cal_hora_ini.' '.$cal_hora_fin;
								$data['she_capacidad']=1;
								$CIs =&get_instance();
								$CIs->db->where('she_fecha',$cal_fecha);
								$CIs->db->where('she_hora_ini',$cal_hora_ini);
								$CIs->db->where('she_hora_fin',$cal_hora_fin);
								$CIs->db->update('doc12_sheduler',$data);		
		
								send_mail_del_std_event_c($evento['cal_email'], $evento, $html,$user['usr_nombre'].' '.$user['usr_paterno'],$user['usr_correo'],$gente_nombre,$gente_telefono);
 
             
					send_json_ok('Se eliminó de forma correcta');
            }
            else 
            {
                send_json_error('Ocurrió un error al eliminar el evento, intente de nuevo más tarde');
            }
        }
        else
        {
            send_json_error('No existe el evento.');
        }
    }	
	
	
    public function get_emp_json()
    {
        $this->load->model('empresa/Empresa_model','empresa');
        $term = $this->input->get('term');
        $emps = $this->empresa->find_empresa($term);
        $emps_formated = array();
        foreach ($emps as $emp)
        {
            $emps_formated[] = array('label' => mb_strtoupper($emp['emp_razon_social']),'value' => $emp['emp_id'],'email' => $emp['emp_correo'],'tel'=> $emp['emp_telefono'],'resp' => $emp['emp_responsable']);
        }
        echo json_encode($emps_formated);
    }
}