  <?php
defined('BASEPATH') OR exit('No direct script access allowed');


    
class Costosxserv extends CI_Controller {
    
     function __construct() {
        parent::__construct();
        $this->load->model('persona/Persona_model','cliente');
        $this->load->model('empleado/Empleado_model','medico');
    }
    
    public function index()
    {   $suc=get_sucursal_id();
        $rows = 30;
        $this->load->library('pagination');
        $config['base_url'] = base_url('costosxserv/index/');
        //$config['total_rows'] = $this->cliente->count_all();   
		$config['total_rows'] = $this->cliente->count_allo($suc);
        $config['per_page'] = $rows;
        $config['attributes'] = array('class' => 'pagination');
        $config['full_tag_open'] = '<div class="pagination-full">';
        $config['full_tag_close'] = '</div>';
        $config['uri_segment'] = 3;
        $config['query_string_segment'] = 4;
        $config['use_page_numbers'] = TRUE;
        $this->pagination->initialize($config);
        
        //$data['clientes'] = $this->cliente->get_all($rows);

		
		$data['clientes'] = $this->cliente->get_allo($rows,get_sucursal_id());
        $this->load->model('empresa/Empresa_model','empresa');
        $data['empresas'] = $this->empresa->get_all_empresas();
		
		
		//echo " Punto F ";
        
        $this->load->helper('template');
        $params_view = array(
            'title' => 'Personas',
            'view' => 'costosxserv/index',
            'view_data' => $data 
           );
        render_template($params_view);  
    }
	
	public function busca()
    {        
        $empresa = $this->input->post('empresa');
		$cei = $this->input->post('cei');
        $nombre  = strtoupper($this->input->post('nombre'));
        $rfc     = strtoupper($this->input->post('rfc'));
		$regby = strtoupper($this->input->post('regby'));
		$f_ini = formatea_fecha_mysql($this->input->post('f_ini'));
        $f_fin = formatea_fecha_mysql($this->input->post('f_fin'));
        $data['clientes'] = $this->cliente->buscandote($empresa,$cei, $nombre, $rfc, $regby,$f_ini,$f_fin);
        send_json_ok($this->load->view('costosxserv/busca',$data,TRUE));
    }
	
	
	
}