﻿<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Essoec extends CI_Controller {
    function __construct() {
        parent::__construct();
        $this->load->model('persona/Persona_model','cliente');
		/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
		$this->load->model('servicio/Servicio_model','servicio');
		/*************************************************/			
        $this->load->model('examen/Essoec_model','gsi');
		$this->load->helper('util');
    }
    
    public function nuevo($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
        $medico = $this->session->user;
        $empresa = $this->cliente->get_empresa_by_clte($cliente_id);

        if(isset($_POST) && count($_POST) > 0)  
        {
            $this->load->library('form_validation');
			/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
			if (($persona['serv_id'] == 0) ||(get_status_serv($persona['serv_id']) != 'PROCESO'))
			{					
					$this->form_validation->set_rules('servicio','Orden de servicio','required');
			}
			else
			{
					$this->form_validation->set_rules('servicio','Orden de servicio','integer');
			}
            /*************************************************/             
            
            if($this->form_validation->run())
            {
                //para los socieconomicos   
                
                //datos del clientes (personales)
                $data_upd_clte['clte_env_entre_calles_crypt']  = $this->input->post('entre_calles');
                $data_upd_clte['clte_arraigo']  = $this->input->post('arraigo');
                $data_upd_clte['clte_nacionalidad']  = $this->input->post('nacionalidad');
                $data_upd_clte['clte_regimen']  = $this->input->post('regimen');
                $data_upd_clte['clte_tel_recados_crypt']  = $this->input->post('tel_recados');
                $data_upd_clte['clte_redes_sociales']  = $this->input->post('redes_sociales');
                $this->cliente->actualiza($cliente_id, array_to_upper($data_upd_clte));

                
                $data_insert['clte_id'] = $persona['clte_id'];
                $data_insert['usr_id'] = $medico['usr_id'];
                $data_insert['emp_id'] = $empresa['emp_id'];
				/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
				if (($persona['serv_id'] == 0) || (get_status_serv($persona['serv_id']) != 'PROCESO'))
				{	
						$data_insert['serv_id']  = $this->input->post('servicio');
				}
				else
				{	
						$data_insert['serv_id']  = $persona['serv_id'];
				}
				/**************************************************/
                $data_insert['esc_f'] = date('Y-m-d H:i:s',time()-21600);
                $data_insert['esc_puso']  = $this->input->post('puesto_solicitado');
                $data_insert['esc_fechaeva'] = formatea_fecha_mysql($this->input->post('fecha_eva'));  
                $data_insert['esc_hora']  = $this->input->post('hora');

                $data_insert['esc_ndehabi']  = $this->input->post('ndehabi');
                $data_insert['esc_sielinvisoexmo']  = $this->input->post('sielinvisoexmo');
                $data_insert['esc_obsercqv']  = $this->input->post('obsercqv');
                $data_insert['esc_numaunte']  = $this->input->post('numaunte');
                $data_insert['esc_nodeexpa']  = $this->input->post('nodeexpa');
                $data_insert['esc_edadcqv']  = $this->input->post('edadcqv');
                $data_insert['esc_domicicqv']  = $this->input->post('domicicqv');
                $data_insert['esc_telefocqv']  = $this->input->post('telefocqv');
                $data_insert['esc_grmaescqv']  = $this->input->post('grmaescqv');
                $data_insert['esc_ocupacqv']  = $this->input->post('ocupacqv');
                $data_insert['esc_emprecqv']  = $this->input->post('emprecqv');
                $data_insert['esc_puestcqv']  = $this->input->post('puestcqv');
                $data_insert['esc_modeslase']  = $this->input->post('modeslase');
                
                $data_insert['esc_hijos_fm']  = $this->input->post('hijos_fm');              
               
                $data_insert['esc_nudecine']  = $this->input->post('nudecine');
                $data_insert['esc_quienine']  = $this->input->post('quienine');
                $data_insert['esc_papenine']  = $this->input->post('papenine');
                $data_insert['esc_pdssuine']  = $this->input->post('pdssuine');
                $data_insert['esc_repenine']  = $this->input->post('repenine');
                $data_insert['esc_sueldine']  = $this->input->post('sueldine');
                $data_insert['esc_obserine']  = $this->input->post('obserine');
                
                /*deficit*/
                $data_insert['esc_cosesode']  = $this->input->post('cosesode');
                $data_insert['esc_kehaceex']  = $this->input->post('kehaceex');
                $data_insert['esc_obsedeueco']  = $this->input->post('obsedeueco');
                
                /*actividad depostiva*/
                $data_insert['esc_act_dep']  = $this->input->post('act_dep');
                $data_insert['esc_act_dep_frec']  = $this->input->post('act_dep_frec');
                $data_insert['esc_act_obs']  = $this->input->post('act_obs');
                
                /*habitos salud*/
                $data_insert['esc_hs_estatura']  = $this->input->post('hs_estatura');
                $data_insert['esc_hs_peso']  = $this->input->post('hs_peso');
                $data_insert['esc_hs_fuma']  = $this->input->post('hs_fuma');
                $data_insert['esc_hs_fuma_frec']  = $this->input->post('hs_fuma_frec');
                $data_insert['esc_hs_toma']  = $this->input->post('hs_toma');
                $data_insert['esc_hs_toma_frec']  = $this->input->post('hs_toma_frec');
                $data_insert['esc_hs_enf_cr']  = $this->input->post('hs_enf_cr');
                $data_insert['esc_hs_enf_cr_fam']  = $this->input->post('hs_enf_cr_fam');
                $data_insert['esc_hs_incapacidades']  = $this->input->post('hs_incapacidades');
                $data_insert['esc_hs_cirugia']  = $this->input->post('hs_cirugia');
                $data_insert['esc_hs_estimulante']  = $this->input->post('hs_estimulante');
                $data_insert['esc_hs_tatuajes']  = $this->input->post('hs_tatuajes');
                $data_insert['esc_hs_obs']  = $this->input->post('hs_obs');
                
                /*domicilio*/
                $data_insert['esc_dom_tipo_pro_cve']  = $this->input->post('dom_tipo_pro_cve');
                $data_insert['esc_dom_tipo_pro_otro']  = $this->input->post('dom_tipo_pro_otro');
                $data_insert['esc_dom_rel_pro']  = $this->input->post('dom_rel_pro');
                $data_insert['esc_dom_zona_cve']  = $this->input->post('dom_zona_cve');
                $data_insert['esc_dom_clase_cve']  = $this->input->post('dom_clase_cve');
                $data_insert['esc_dom_calidad_inm_cve']  = $this->input->post('dom_calidad_inm_cve');
                $data_insert['esc_dom_orden_cve']  = $this->input->post('dom_orden_cve');
                
                /*inmuebles*/
                $data_insert['esc_inm_sala']  = $this->input->post('inm_sala');
                $data_insert['esc_inm_comedor']  = $this->input->post('inm_comedor');
                $data_insert['esc_inm_estudio']  = $this->input->post('inm_estudio');
                $data_insert['esc_inm_cocina']  = $this->input->post('inm_cocina');
                $data_insert['esc_inm_banios']  = $this->input->post('inm_banios');
                $data_insert['esc_inm_cto_serv']  = $this->input->post('inm_cto_serv');
                $data_insert['esc_inm_cto_lav']  = $this->input->post('inm_cto_lav');
                $data_insert['esc_inm_bodega']  = $this->input->post('inm_bodega');
                $data_insert['esc_inm_zotehuela']  = $this->input->post('inm_zotehuela');
                $data_insert['esc_inm_jardin']  = $this->input->post('inm_jardin');
                $data_insert['esc_inm_no_rec']  = $this->input->post('inm_no_rec');
                $data_insert['esc_inm_patio']  = $this->input->post('inm_patio');
                $data_insert['esc_inm_garaje']  = $this->input->post('inm_garaje');
                $data_insert['esc_inm_otros']  = $this->input->post('inm_otros');
                $data_insert['esc_inm_cons_mat']  = $this->input->post('inm_cons_mat');
                $data_insert['esc_inm_caracs']  = $this->input->post('inm_caracs');
                $data_insert['esc_inm_mob']  = $this->input->post('inm_mob');
                
                /*referencias personales*/
                $data_insert['esc_ref_per_obs']  = $this->input->post('ref_per_obs');
                
                /*referencias vecinales*/
                $data_insert['esc_ref_vec_obs']  = $this->input->post('ref_vec_obs');
                
                /*anexos*/
                $data_insert['esc_anx_entero_cve']  = $this->input->post('anx_entero_cve');
                $data_insert['esc_anx_entero_otro']  = $this->input->post('anx_entero_otro');
                $data_insert['esc_anx_fam_cve']  = $this->input->post('anx_fam_cve');
                $data_insert['esc_anx_fam_nom']  = $this->input->post('anx_fam_nom');
                $data_insert['esc_anx_fam_puesto']  = $this->input->post('anx_fam_puesto');
                $data_insert['esc_anx_amigo_cve']  = $this->input->post('anx_amigo_cve');
                $data_insert['esc_anx_amigo_nom']  = $this->input->post('anx_amigo_nom');
                $data_insert['esc_anx_amigo_puesto']  = $this->input->post('anx_amigo_puesto');
                $data_insert['esc_anx_fam_pol_cve']  = $this->input->post('anx_fam_pol_cve');
                $data_insert['esc_anx_fam_pol_nom']  = $this->input->post('anx_fam_pol_nom');
                $data_insert['esc_anx_fam_pol_puesto']  = $this->input->post('anx_fam_pol_puesto');
                $data_insert['esc_anx_vecino_cve']  = $this->input->post('anx_vecino_cve');
                $data_insert['esc_anx_vecino_nom']  = $this->input->post('anx_vecino_nom');
                $data_insert['esc_anx_vecino_puesto']  = $this->input->post('anx_vecino_puesto');
                $data_insert['esc_anx_carcel_cve']  = $this->input->post('anx_carcel_cve');
                $data_insert['esc_anx_carcel_nom']  = $this->input->post('anx_carcel_nom');
                $data_insert['esc_anx_carcel_puesto']  = $this->input->post('anx_carcel_puesto');
                $data_insert['esc_anx_manejo_armas']  = $this->input->post('anx_manejo_armas');
                $data_insert['esc_obs']  = $this->input->post('obs');
                
                /*validcaciones finales*/
                $data_insert['esc_val_dom']  = $this->input->post('val_dom');
                $data_insert['esc_com_fam']  = $this->input->post('com_fam');
                $data_insert['esc_val_doc']  = $this->input->post('val_doc');
                $data_insert['esc_ref_vec']  = $this->input->post('ref_vec');
                $data_insert['esc_egre_ingr']  = $this->input->post('egre_ingr');
                $data_insert['esc_obs_adic']  = $this->input->post('obs_adic');
				$data_insert['fsm_apto_v_documentos'] = $this->input->post('fsm_apto_v_documentos');
				$data_insert['fsm_apto_v_academicos'] = $this->input->post('fsm_apto_v_academicos');
				$data_insert['fsm_apto_v_personales'] = $this->input->post('fsm_apto_v_personales');
				$data_insert['fsm_apto_v_laboral'] = $this->input->post('fsm_apto_v_laboral');
				$data_insert['fsm_apto_v_economica'] = $this->input->post('fsm_apto_v_economica');
				$data_insert['fsm_apto_v_patrimonial'] = $this->input->post('fsm_apto_v_patrimonial');
				$data_insert['fsm_apto_v_domicilio'] = $this->input->post('fsm_apto_v_domicilio');
                $data_insert['fsm_apto'] = $this->input->post('fsm_apto');
				
				

                $data_insert = array_to_upper($data_insert);
                
                //recibe las firmas por canvas
                // if($this->input->post('firma_inv') != '')
                // {
                //     $data_insert['esc_firma_inv'] = $this->input->post('firma_inv');
                // }
                // if($this->input->post('firma_resp') != '')
                // {
                //     $data_insert['esc_firma_resp'] = $this->input->post('firma_resp');
                // }
                // if($this->input->post('firma_usr') != '')
                // {
                //     $data_insert['esc_firma_usr'] = $this->input->post('firma_usr');
                // }
                
                //carga la imagen del investigador
                $data_insert['esc_img_firma_usr'] = carga_imagen('firma_img_usr','./esc/');

                //carga la imagen del responsable
                $data_insert['esc_img_firma_resp'] = carga_imagen('firma_img_resp','./esc/');

                //carga la imagen del investigado
                $data_insert['esc_img_firma_inv'] = carga_imagen('firma_img_inv','./esc/');
                
                $fotos = array();
                //asocia las imagenes cargadas
                if($this->input->post('fotos')){
                    foreach($this->input->post('fotos') as $foto){
                        $fotos[] = array('path' => $foto,'tipo' => 'EXT');
                    }
                }

                //asocia las imagenes cargadas
                if($this->input->post('fotos_int')){
                    foreach($this->input->post('fotos_int') as $foto){
                        $fotos[] = array('path' => $foto,'tipo' => 'INT');
                    }
                }

                //carga los croquis
                $data_insert['esc_croquis'] = carga_imagen('croquis','./esc/');

                //carga el aviso de privacidad
                $data_insert['esc_aviso'] = carga_imagen('aviso','./esc/');
                
                $this->db->trans_start();
                $fsm_id = $this->gsi->add($data_insert);
                if($fsm_id)
                {
                    $this->gsi->insert_arreglo($this->input->post('docp'), 'nivel', $fsm_id, 'esc_dopre'); 
                    $this->gsi->insert_arreglo($this->input->post('situacad'), 'academico', $fsm_id, 'esc_sitaca');
                    $this->gsi->insert_arreglo($this->input->post('inffam'), 'pariente', $fsm_id, 'esc_inffam');
                    $this->gsi->insert_arreglo($this->input->post('numdehij'), 'nombnudehi', $fsm_id, 'esc_hifudema');
                    $this->gsi->insert_arreglo($this->input->post('inyadlmdlfa'), 'nombhifu', $fsm_id, 'esc_inapmifa');
                    $this->gsi->insert_arreglo($this->input->post('iyaedop'), 'otrosidop', $fsm_id, 'esc_inapotpe');
                    //$this->gsi->insert_arreglo($this->input->post('egres'), 'egrecpd', $fsm_id, 'esc_egresos');
                    $this->gsi->insert_arreglo($this->input->post('deueco'), 'titudeec', $fsm_id, 'esc_deudeco');
                    $this->gsi->insert_arreglo($this->input->post('tarcre'), 'titutacr', $fsm_id, 'esc_tarjcred');
                    $this->gsi->insert_arreglo($this->input->post('credit'), 'instcred', $fsm_id, 'esc_crditos');
                    $this->gsi->insert_arreglo($this->input->post('propi'), 'bienprop', $fsm_id, 'esc_propie');
                    $this->gsi->inserta_egresos($this->input->post('egreso'), $fsm_id);
                   
                    /*aspectos culturales*/
                    $this->gsi->insert_arreglo($this->input->post('aspcul'), 'org_soc_nombre', $fsm_id, 'esc_aspcul_dep');
                   
                    /*domicilios*/
                    $this->gsi->insert_arreglo($this->input->post('arraigodom'), 'dom_domicilio', $fsm_id, 'esc_dom');
                    
                    /*referencias personales*/
                    $this->gsi->insert_arreglo($this->input->post('refper'), 'refp_nombre', $fsm_id, 'esc_ref_personal');
                    
                    /*referencias vecinales*/
                    $this->gsi->insert_arreglo($this->input->post('refvec'), 'refv_nombre', $fsm_id, 'esc_ref_vecinal');
                   
                    /*antecedentes laborales*/
                    $this->gsi->insert_arreglo($this->input->post('antlab'), 'lab_tipo_cve', $fsm_id, 'esc_ant_lab');
                    
                    /*comprobacion laboral*/
                    $this->gsi->insert_arreglo($this->input->post('comlab'), 'lab_empresa', $fsm_id, 'esc_com_lab');

                    /*inserta fotos*/
                    if($this->input->post('fotos'))
                    {
                        $this->gsi->insert_arreglo($fotos, 'path', $fsm_id, 'esc_fotos',false);
                    }
                   
                    send_json_ok(array('id' => $cliente_id, 'msg' => 'Se guardó de forma correcta'));
					
					/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
					$servicios=$persona['domserv'];					
					
					$servicio='ESTSOC;'; /*CODIGO DEL EXAMEN*/
					if (!(strstr($servicios,$servicio)))
					{							
						$servicios.=$servicio;
						$data_clte['domserv']=$servicios;
						$res=$this->cliente->actualiza_registro_individual($cliente_id, $data_clte);
					}
					/**************************************************/				
					
                }
                else
                {
                    send_json_error('Ocurrió un error al actualizar.');
                }
                $this->db->trans_complete();
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
        
            $data['persona'] = $persona;
            $data['medico'] = $medico;
            $data['empresa'] = $empresa;
			/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
			$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);
			/**************************************************/	
            $this->load->helper('template');
            $params_view = array(
                'title' => '',
                'view' => 'examen/gsi_esteco/nuevo_form',
                'view_data' => $data 
               );
            render_template($params_view);
        }
    }
    
    public function edita($cliente_id, $fsm_id)
    {
        $this->load->model('empleado/Empleado_model','empleado');
        $persona = $this->cliente->get($cliente_id);
        $data['fsm'] = $this->gsi->get($fsm_id);
        $medico = $this->empleado->get_id($data['fsm']['usr_id']);
        $empresa = $this->cliente->get_empresa_by_id($data['fsm']['emp_id']);

        if(isset($_POST) && count($_POST) > 0)  
        {
            $this->load->library('form_validation');
            //$this->form_validation->set_rules('servicio','Orden de servicio','required');
            
            if(true)
            {
                //datos del clientes (personales)
                $data_upd_clte['clte_env_entre_calles_crypt']  = $this->input->post('entre_calles');
                $data_upd_clte['clte_arraigo']  = $this->input->post('arraigo');
                $data_upd_clte['clte_nacionalidad']  = $this->input->post('nacionalidad');
                $data_upd_clte['clte_regimen']  = $this->input->post('regimen');
                $data_upd_clte['clte_tel_recados_crypt']  = $this->input->post('tel_recados');
                $data_upd_clte['clte_redes_sociales']  = $this->input->post('redes_sociales');
                $this->cliente->actualiza($cliente_id, array_to_upper($data_upd_clte));

                //para los socieconomicos
                /*$data_update['clte_id'] = $persona['clte_id'];
                $data_update['usr_id'] = $medico['usr_id'];
                $data_update['emp_id'] = $empresa['emp_id'];
                $data_update['serv_id']  = $this->input->post('servicio');
                $data_update['esc_f'] = date('Y-m-d H:i:s',time()-21600);*/
                $data_update['esc_puso']  = $this->input->post('puesto_solicitado');
                $data_update['esc_fechaeva'] = formatea_fecha_mysql($this->input->post('fecha_eva'));  
                $data_update['esc_hora']  = $this->input->post('hora');

                $data_update['esc_ndehabi']  = $this->input->post('ndehabi');
                $data_update['esc_sielinvisoexmo']  = $this->input->post('sielinvisoexmo');
                $data_update['esc_obsercqv']  = $this->input->post('obsercqv');
                $data_update['esc_numaunte']  = $this->input->post('numaunte');
                $data_update['esc_nodeexpa']  = $this->input->post('nodeexpa');
                $data_update['esc_edadcqv']  = $this->input->post('edadcqv');
                $data_update['esc_domicicqv']  = $this->input->post('domicicqv');
                $data_update['esc_telefocqv']  = $this->input->post('telefocqv');
                $data_update['esc_grmaescqv']  = $this->input->post('grmaescqv');
                $data_update['esc_ocupacqv']  = $this->input->post('ocupacqv');
                $data_update['esc_emprecqv']  = $this->input->post('emprecqv');
                $data_update['esc_puestcqv']  = $this->input->post('puestcqv');
                $data_update['esc_modeslase']  = $this->input->post('modeslase');
                
                $data_update['esc_hijos_fm']  = $this->input->post('hijos_fm');              
               
                $data_update['esc_nudecine']  = $this->input->post('nudecine');
                $data_update['esc_quienine']  = $this->input->post('quienine');
                $data_update['esc_papenine']  = $this->input->post('papenine');
                $data_update['esc_pdssuine']  = $this->input->post('pdssuine');
                $data_update['esc_repenine']  = $this->input->post('repenine');
                $data_update['esc_sueldine']  = $this->input->post('sueldine');
                $data_update['esc_obserine']  = $this->input->post('obserine');
                
                /*deficit*/
                $data_update['esc_cosesode']  = $this->input->post('cosesode');
                $data_update['esc_kehaceex']  = $this->input->post('kehaceex');
                $data_update['esc_obsedeueco']  = $this->input->post('obsedeueco');
                
                /*actividad depostiva*/
                $data_update['esc_act_dep']  = $this->input->post('act_dep');
                $data_update['esc_act_dep_frec']  = $this->input->post('act_dep_frec');
                $data_update['esc_act_obs']  = $this->input->post('act_obs');
                
                /*habitos salud*/
                $data_update['esc_hs_estatura']  = $this->input->post('hs_estatura');
                $data_update['esc_hs_peso']  = $this->input->post('hs_peso');
                $data_update['esc_hs_fuma']  = $this->input->post('hs_fuma');
                $data_update['esc_hs_fuma_frec']  = $this->input->post('hs_fuma_frec');
                $data_update['esc_hs_toma']  = $this->input->post('hs_toma');
                $data_update['esc_hs_toma_frec']  = $this->input->post('hs_toma_frec');
                $data_update['esc_hs_enf_cr']  = $this->input->post('hs_enf_cr');
                $data_update['esc_hs_enf_cr_fam']  = $this->input->post('hs_enf_cr_fam');
                $data_update['esc_hs_incapacidades']  = $this->input->post('hs_incapacidades');
                $data_update['esc_hs_cirugia']  = $this->input->post('hs_cirugia');
                $data_update['esc_hs_estimulante']  = $this->input->post('hs_estimulante');
                $data_update['esc_hs_tatuajes']  = $this->input->post('hs_tatuajes');
                $data_update['esc_hs_obs']  = $this->input->post('hs_obs');
                
                /*domicilio*/
                $data_update['esc_dom_tipo_pro_cve']  = $this->input->post('dom_tipo_pro_cve');
                $data_update['esc_dom_tipo_pro_otro']  = $this->input->post('dom_tipo_pro_otro');
                $data_update['esc_dom_rel_pro']  = $this->input->post('dom_rel_pro');
                $data_update['esc_dom_zona_cve']  = $this->input->post('dom_zona_cve');
                $data_update['esc_dom_clase_cve']  = $this->input->post('dom_clase_cve');
                $data_update['esc_dom_calidad_inm_cve']  = $this->input->post('dom_calidad_inm_cve');
                $data_update['esc_dom_orden_cve']  = $this->input->post('dom_orden_cve');
                
                /*inmuebles*/
                $data_update['esc_inm_sala']  = $this->input->post('inm_sala');
                $data_update['esc_inm_comedor']  = $this->input->post('inm_comedor');
                $data_update['esc_inm_estudio']  = $this->input->post('inm_estudio');
                $data_update['esc_inm_cocina']  = $this->input->post('inm_cocina');
                $data_update['esc_inm_banios']  = $this->input->post('inm_banios');
                $data_update['esc_inm_cto_serv']  = $this->input->post('inm_cto_serv');
                $data_update['esc_inm_cto_lav']  = $this->input->post('inm_cto_lav');
                $data_update['esc_inm_bodega']  = $this->input->post('inm_bodega');
                $data_update['esc_inm_zotehuela']  = $this->input->post('inm_zotehuela');
                $data_update['esc_inm_jardin']  = $this->input->post('inm_jardin');
                $data_update['esc_inm_no_rec']  = $this->input->post('inm_no_rec');
                $data_update['esc_inm_patio']  = $this->input->post('inm_patio');
                $data_update['esc_inm_garaje']  = $this->input->post('inm_garaje');
                $data_update['esc_inm_otros']  = $this->input->post('inm_otros');
                $data_update['esc_inm_cons_mat']  = $this->input->post('inm_cons_mat');
                $data_update['esc_inm_caracs']  = $this->input->post('inm_caracs');
                $data_update['esc_inm_mob']  = $this->input->post('inm_mob');
                
                /*referencias personales*/
                $data_update['esc_ref_per_obs']  = $this->input->post('ref_per_obs');
                
                /*referencias vecinales*/
                $data_update['esc_ref_vec_obs']  = $this->input->post('ref_vec_obs');
                
                /*anexos*/
                $data_update['esc_anx_entero_cve']  = $this->input->post('anx_entero_cve');
                $data_update['esc_anx_entero_otro']  = $this->input->post('anx_entero_otro');
                $data_update['esc_anx_fam_cve']  = $this->input->post('anx_fam_cve');
                $data_update['esc_anx_fam_nom']  = $this->input->post('anx_fam_nom');
                $data_update['esc_anx_fam_puesto']  = $this->input->post('anx_fam_puesto');
                $data_update['esc_anx_amigo_cve']  = $this->input->post('anx_amigo_cve');
                $data_update['esc_anx_amigo_nom']  = $this->input->post('anx_amigo_nom');
                $data_update['esc_anx_amigo_puesto']  = $this->input->post('anx_amigo_puesto');
                $data_update['esc_anx_fam_pol_cve']  = $this->input->post('anx_fam_pol_cve');
                $data_update['esc_anx_fam_pol_nom']  = $this->input->post('anx_fam_pol_nom');
                $data_update['esc_anx_fam_pol_puesto']  = $this->input->post('anx_fam_pol_puesto');
                $data_update['esc_anx_vecino_cve']  = $this->input->post('anx_vecino_cve');
                $data_update['esc_anx_vecino_nom']  = $this->input->post('anx_vecino_nom');
                $data_update['esc_anx_vecino_puesto']  = $this->input->post('anx_vecino_puesto');
                $data_update['esc_anx_carcel_cve']  = $this->input->post('anx_carcel_cve');
                $data_update['esc_anx_carcel_nom']  = $this->input->post('anx_carcel_nom');
                $data_update['esc_anx_carcel_puesto']  = $this->input->post('anx_carcel_puesto');
                $data_update['esc_anx_manejo_armas']  = $this->input->post('anx_manejo_armas');
                $data_update['esc_obs']  = $this->input->post('obs');
                $data_update['fsm_apto_v_documentos'] = $this->input->post('fsm_apto_v_documentos');
				$data_update['fsm_apto_v_academicos'] = $this->input->post('fsm_apto_v_academicos');
				$data_update['fsm_apto_v_personales'] = $this->input->post('fsm_apto_v_personales');
				$data_update['fsm_apto_v_laboral'] = $this->input->post('fsm_apto_v_laboral');
				$data_update['fsm_apto_v_economica'] = $this->input->post('fsm_apto_v_economica');
				$data_update['fsm_apto_v_patrimonial'] = $this->input->post('fsm_apto_v_patrimonial');
				$data_update['fsm_apto_v_domicilio'] = $this->input->post('fsm_apto_v_domicilio');
                $data_update['fsm_apto'] = $this->input->post('fsm_apto');
                /*validcaciones finales*/
                $data_update['esc_val_dom']  = $this->input->post('val_dom');
                $data_update['esc_com_fam']  = $this->input->post('com_fam');
                $data_update['esc_val_doc']  = $this->input->post('val_doc');
                $data_update['esc_ref_vec']  = $this->input->post('ref_vec');
                $data_update['esc_egre_ingr']  = $this->input->post('egre_ingr');
                $data_update['esc_obs_adic']  = $this->input->post('obs_adic');

                $data_update = array_to_upper($data_update);

                //firmas
                // if($this->input->post('firma_inv') != '')
                // {
                //     $data_update['esc_firma_inv'] = $this->input->post('firma_inv');
                // }
                // if($this->input->post('firma_resp') != '')
                // {
                //     $data_update['esc_firma_resp'] = $this->input->post('firma_resp');
                // }
                // if($this->input->post('firma_usr') != '')
                // {
                //     $data_update['esc_firma_usr'] = $this->input->post('firma_usr');
                // }

                $fotos = array();
                //asocia las imagenes cargadas
                if($this->input->post('fotos'))
                {
                    foreach($this->input->post('fotos') as $foto)
                    {
                        $fotos[] = array('path' => $foto,'tipo' => 'EXT');
                    }
                }

                //asocia las imagenes cargadas
                if($this->input->post('fotos_int'))
                {
                    foreach($this->input->post('fotos_int') as $foto)
                    {
                        $fotos[] = array('path' => $foto,'tipo' => 'INT');
                    }
                }

                //carga la imagen del investigador
                $data_update['esc_img_firma_usr'] = carga_imagen('firma_img_usr','./esc/');

                //carga la imagen del responsable
                $data_update['esc_img_firma_resp'] = carga_imagen('firma_img_resp','./esc/');

                //carga la imagen del investigado
                $data_update['esc_img_firma_inv'] = carga_imagen('firma_img_inv','./esc/');

                //carga los croquis './../../files/hm/'
                $pre_croquis= carga_imagen('croquis','./esc/');
                if ($pre_croquis != NULL)
				{
					$data_update['esc_croquis']=$pre_croquis;
				}
				else
				{
					$data_update['esc_croquis']=  $data['fsm']['esc_croquis'] ;
				}            

			
                //carga el aviso de privacidad
                $pre_croquis= carga_imagen('aviso','./esc/');
                if ($pre_croquis != NULL)
				{
					$data_update['esc_aviso'] =$pre_croquis;
				}
				else
				{
					$data_update['esc_aviso'] =  $data['fsm']['esc_aviso'] ;
				}                 
				
				
				
				
				
                $this->db->trans_start();
                $result_update = $this->gsi->update($fsm_id, $data_update);
                if($result_update)
                {
                    $this->gsi->update_arreglo($this->input->post('docp'), 'nivel', $fsm_id, 'esc_dopre'); 
                    $this->gsi->update_arreglo($this->input->post('situacad'), 'academico', $fsm_id, 'esc_sitaca');
                    $this->gsi->update_arreglo($this->input->post('inffam'), 'pariente', $fsm_id, 'esc_inffam');
                    $this->gsi->update_arreglo($this->input->post('numdehij'), 'nombnudehi', $fsm_id, 'esc_hifudema');
                    $this->gsi->update_arreglo($this->input->post('inyadlmdlfa'), 'nombhifu', $fsm_id, 'esc_inapmifa');
                    $this->gsi->update_arreglo($this->input->post('iyaedop'), 'otrosidop', $fsm_id, 'esc_inapotpe');
                    //$this->gsi->update_arreglo($this->input->post('egres'), 'egrecpd', $fsm_id, 'esc_egresos');
                    $this->gsi->update_arreglo($this->input->post('deueco'), 'titudeec', $fsm_id, 'esc_deudeco');
                    $this->gsi->update_arreglo($this->input->post('tarcre'), 'titutacr', $fsm_id, 'esc_tarjcred');
                    $this->gsi->update_arreglo($this->input->post('credit'), 'instcred', $fsm_id, 'esc_crditos');
                    $this->gsi->update_arreglo($this->input->post('propi'), 'bienprop', $fsm_id, 'esc_propie');
                    $this->gsi->update_arreglo($this->input->post('egreso'),'mensual', $fsm_id,'esc_egresos');
                   
                    /*aspectos culturales*/
                    $this->gsi->update_arreglo($this->input->post('aspcul'), 'org_soc_nombre', $fsm_id, 'esc_aspcul_dep');
                   
                    /*domicilios*/
                    $this->gsi->update_arreglo($this->input->post('arraigodom'), 'dom_domicilio', $fsm_id, 'esc_dom');
                    
                    /*referencias personales*/
                    $this->gsi->update_arreglo($this->input->post('refper'), 'refp_nombre', $fsm_id, 'esc_ref_personal');
                    
                    /*referencias vecinales*/
                    $this->gsi->update_arreglo($this->input->post('refvec'), 'refv_nombre', $fsm_id, 'esc_ref_vecinal');
                   
                    /*antecedentes laborales*/
                    $this->gsi->update_arreglo($this->input->post('antlab'), 'lab_tipo_cve', $fsm_id, 'esc_ant_lab');
                    
                    /*comprobacion laboral*/
                    $this->gsi->update_arreglo($this->input->post('comlab'), 'lab_empresa', $fsm_id, 'esc_com_lab');

                    /*inserta fotos nuevas*/
                    if(!empty($fotos))
                    {
                        $this->gsi->insert_arreglo($fotos, 'path', $fsm_id, 'esc_fotos',false);
                    }

                    send_json_ok(array('id' => $cliente_id, 'msg' => 'Se actualizó de forma correcta'));
                }
                else
                {
                    send_json_error('Ocurrió un error al actualizar.');
                }
                $this->db->trans_complete();
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['fsm']['docs'] = $this->gsi->get_data('esc_dopre',$fsm_id);             //documentos
            $data['fsm']['acad'] = $this->gsi->get_data('esc_sitaca',$fsm_id);            //situacion academica
            $data['fsm']['fam'] = $this->gsi->get_data('esc_inffam',$fsm_id);             //familiares
            $data['fsm']['hijos'] = $this->gsi->get_data('esc_hifudema',$fsm_id);         //hijos fuera matrimonio
            $data['fsm']['ingresos'] = $this->gsi->get_data('esc_inapmifa',$fsm_id);      //ingresos miembros
            $data['fsm']['ingresos_otro'] = $this->gsi->get_data('esc_inapotpe',$fsm_id); //ingresos no miembros
            $data['fsm']['egresos'] = $this->gsi->get_data('esc_egresos',$fsm_id);        //egresos
            $data['fsm']['deudas'] = $this->gsi->get_data('esc_deudeco',$fsm_id);         //deudas
            $data['fsm']['tcreditos'] = $this->gsi->get_data('esc_tarjcred',$fsm_id);     //tarejtas credito
            $data['fsm']['creditos'] = $this->gsi->get_data('esc_crditos',$fsm_id);       //tarejtas credito
            $data['fsm']['props'] = $this->gsi->get_data('esc_propie',$fsm_id);           //tarejtas credito
            $data['fsm']['orga'] = $this->gsi->get_data('esc_aspcul_dep',$fsm_id);        //organizaciones
            $data['fsm']['dom'] = $this->gsi->get_data('esc_dom',$fsm_id);                //organizaciones  
            $data['fsm']['rper'] = $this->gsi->get_data('esc_ref_personal',$fsm_id);      //organizaciones
            $data['fsm']['rvec'] = $this->gsi->get_data('esc_ref_vecinal',$fsm_id);       //organizaciones
            $data['fsm']['lab'] = $this->gsi->get_data('esc_ant_lab',$fsm_id);            //organizaciones
            $data['fsm']['comlab'] = $this->gsi->get_data('esc_com_lab',$fsm_id);            //organizaciones
            $data['fsm']['fotos'] = $this->gsi->get_data('esc_fotos',$fsm_id);            //organizaciones
            
            $data['persona'] = $persona;
            $data['medico'] = $medico;
            $data['empresa'] = $empresa;

            $this->load->helper('template');
            $params_view = array(
                'title' => '',
                'view' => 'examen/gsi_esteco/edita_form',
                'view_data' => $data 
               );
            render_template($params_view);
        }
    }
    
    public function pdf($cliente_id, $fsm_id)
    {
        //ini_set("memory_limit","1000M");
        $this->load->model('empleado/Empleado_model','empleado');
        
        $persona = $this->cliente->get($cliente_id,get_desp_id_usr());
        $data['fsm'] = $this->gsi->get($fsm_id,get_desp_id_usr());
        $medico = $this->empleado->get_id($data['fsm']['usr_id']);
        $empresa = $this->cliente->get_empresa_by_id($data['fsm']['emp_id']);
        
        
        $data['fsm']['docs'] = $this->gsi->get_data('esc_dopre',$fsm_id);             //documentos
        $data['fsm']['acad'] = $this->gsi->get_data('esc_sitaca',$fsm_id);            //situacion academica
        $data['fsm']['fam'] = $this->gsi->get_data('esc_inffam',$fsm_id);             //familiares
        $data['fsm']['hijos'] = $this->gsi->get_data('esc_hifudema',$fsm_id);         //hijos fuera matrimonio
        $data['fsm']['ingresos'] = $this->gsi->get_data('esc_inapmifa',$fsm_id);      //ingresos miembros
        $data['fsm']['ingresos_otro'] = $this->gsi->get_data('esc_inapotpe',$fsm_id); //ingresos no miembros
        $data['fsm']['egresos'] = $this->gsi->get_data('esc_egresos',$fsm_id);        //egresos
        $data['fsm']['deudas'] = $this->gsi->get_data('esc_deudeco',$fsm_id);         //deudas
        $data['fsm']['tcreditos'] = $this->gsi->get_data('esc_tarjcred',$fsm_id);     //tarejtas credito
        $data['fsm']['creditos'] = $this->gsi->get_data('esc_crditos',$fsm_id);       //tarejtas credito
        $data['fsm']['props'] = $this->gsi->get_data('esc_propie',$fsm_id);           //tarejtas credito
        $data['fsm']['orga'] = $this->gsi->get_data('esc_aspcul_dep',$fsm_id);        //organizaciones
        $data['fsm']['dom'] = $this->gsi->get_data('esc_dom',$fsm_id);                //organizaciones  
        $data['fsm']['rper'] = $this->gsi->get_data('esc_ref_personal',$fsm_id);      //organizaciones
        $data['fsm']['rvec'] = $this->gsi->get_data('esc_ref_vecinal',$fsm_id);       //organizaciones
        $data['fsm']['lab'] = $this->gsi->get_data('esc_ant_lab',$fsm_id);            //organizaciones
        $data['fsm']['comlab'] = $this->gsi->get_data('esc_com_lab',$fsm_id);            //organizaciones
        $data['fsm']['fotos'] = $this->gsi->get_data('esc_fotos',$fsm_id);            //organizaciones
        
        $data['persona'] = $persona;
        $data['medico'] = $medico;
        $data['empresa'] = $empresa;
        $this->load->helper('pdf');
		
			$evaluado= $persona['clte_nombre'].' ';
			
			if ( strlen($persona['clte_2_nombre']) > 0)
			{
				$evaluado= $evaluado.$data['persona']['clte_2_nombre'].' ';
			}				
			$evaluado= $evaluado.$data['persona']['clte_paterno'].' ';			
			$evaluado= $evaluado.$data['persona']['clte_materno'].' ';
			
			genera_pdf_new_reporte_poli($this->load->view('examen/gsi_esteco/pdf',$data,TRUE),'estudio_socioeconomico','estudio_socioeconomico',$evaluado);		
		
        //genera_pdf($this->load->view('examen/gsi_esteco/pdf',$data,TRUE),'estudio_socioeconomico_','EX');
    }

    public function elimina($mapeo,$fsm_id, $id )
    {
        $array_tablas = array(
            'docs' => 'esc_dopre',
            'acad' => 'esc_sitaca',
            'fam' => 'esc_inffam',
            'hijos' => 'esc_hifudema',
            'ingresos' => 'esc_inapmifa',
            'ingresos_otro' => 'esc_inapotpe',
            'egresos' => 'esc_egresos',
            'deudas' => 'esc_deudeco',
            'tcreditos' => 'esc_tarjcred',
            'creditos' => 'esc_crditos',
            'props' => 'esc_propie',
            'orga' => 'esc_aspcul_dep',
            'dom' => 'esc_dom',
            'rper' => 'esc_ref_personal',
            'rvec' => 'esc_ref_vecinal',
            'lab' => 'esc_ant_lab',
            'comlab' => 'esc_com_lab',
            'foto' => 'esc_fotos'
        );

        if($this->gsi->delete_tabla($fsm_id,$id,$array_tablas[$mapeo]))
        {
            send_json_ok('Se eliminó de forma correcta.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar.');
        }
    }

    public function sube_fotos()
    {
        if(!empty($_FILES['file']['name']))
        {
            $this->load->library('upload');
            $filename = md5(time().$_FILES['file']['name']);
            $config = array(
                    'upload_path'   => './esc/',
                    'overwrite'     => TRUE,
                    'file_name'     => $filename,
                    'allowed_types' => 'png|jpg|jpeg',
                    'max_size'      => '10000'
            );

            $this->upload->initialize($config);
            if ( ! $this->upload->do_upload('file'))
            {
                send_json_error($this->upload->display_errors());
            }
            else 
            {
                $data7 = $this->upload->data();
                send_json_ok($data7['file_name']);
            }
        }
    }
}