<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Eye_detect extends CI_Controller {
    function __construct() {
        parent::__construct();
        $this->load->model('persona/Persona_model','cliente');
		/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
		$this->load->model('servicio/Servicio_model','servicio');
		/*************************************************/			
        $this->load->model('empleado/Empleado_model','medico');
        $this->load->model('examen/Eye_detect_model','eye_detect');
		$this->load->helper('util');   
    }
    
    public function nuevo($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
        $user = $this->session->user;
        $medico_cap = $this->medico->get_id($user['usr_id']);
        $medico = $this->medico->get_id(219);
        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
			/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
			if (($persona['serv_id'] == 0) ||(get_status_serv($persona['serv_id']) != 'PROCESO'))
			{					
					$this->form_validation->set_rules('servicio','Orden de servicio','required');
			}
			else
			{
					$this->form_validation->set_rules('servicio','Orden de servicio','integer');
			}
            /*************************************************/ 
            $this->form_validation->set_rules('motivo','Motivo de de la prueba','required');
            $this->form_validation->set_rules('puesto','Puesto','required');
            $this->form_validation->set_rules('prueba_nombre','Nombre de la prueba','required');
           // $this->form_validation->set_rules('calificacion','Calificación','required');
           // $this->form_validation->set_rules('porcentaje','Porcentaje','required|greater_than_equal_to[1]|less_than_equal_to[100]');
            if($this->form_validation->run())
            {
                $data_insert['emp_id']  = $persona['emp_id'];
                $data_insert['clte_id'] = $persona['clte_id'];
                $data_insert['rev_id']  = 219;
                $data_insert['med_id']  = 219;
                $data_insert['usr_id']  = $user['usr_id'];
				/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
				if (($persona['serv_id'] == 0) || (get_status_serv($persona['serv_id']) != 'PROCESO'))
				{	
						$data_insert['serv_id']  = $this->input->post('servicio');
				}
				else
				{	
						$data_insert['serv_id']  = $persona['serv_id'];
				}
				/**************************************************/
                $data_insert['fsm_f']   = date("Y-m-d H:i:s");
                $data_insert['fsm_motivo'] = $this->input->post('motivo');
                $data_insert['fsm_puesto'] = $this->input->post('puesto');
                $data_insert['fsm_prueba_nombre'] = $this->input->post('prueba_nombre');
      

                $data_insert['fsm_consumo_drogas'] = $this->input->post('consumo_drogas');
                $data_insert['fsm_robo'] = $this->input->post('robo');
                $data_insert['fsm_delicuencia'] = $this->input->post('delicuencia');
                $data_insert['fsm_delitos_graves'] = $this->input->post('delitos_graves');


				$data_insert['fsm_calificacion_texto'] = $this->input->post('calificacion');
                $data_insert['fsm_calificacion'] =	$this->input->post('porcentaje');
				$data_insert['fsm_observaciones'] =	$this->input->post('observaciones');
				$data_insert['log_insrt_f']  =  date('Y-m-d H:i:s');
                
                if($this->eye_detect->insert(array_to_upper($data_insert)))
                {
                    send_json_ok('Se guardó de forma correcta');
					/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
					$servicios=$persona['domserv'];					
					
					$servicio='GPOSAN;'; /*CODIGO DEL EXAMEN*/
					if (!(strstr($servicios,$servicio)))
					{							
						$servicios.=$servicio;
						$data_clte['domserv']=$servicios;
						$res=$this->cliente->actualiza_registro_individual($cliente_id, $data_clte);
					}
					/**************************************************/						
                }
                else
                {
                    send_json_error('Ocurrió un error al guardar.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
            $data['medico'] = $medico;
            $data['medico_cap'] = $medico_cap;
			/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
			$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);
			/**************************************************/			
            $this->load->helper('template');
            $params_view = array(
                'title' => '',
                'view' => 'examen/eye_detect/nuevo_form',
                'view_data' => $data 
               );
            render_template($params_view);
        }
    }
    
    public function pdf($cliente_id, $fsm_id)
    {
        $data['persona'] = $this->cliente->get($cliente_id,get_desp_id_usr());
        $data['fsm'] = $this->eye_detect->get($fsm_id,get_desp_id_usr());
        $data['medico'] = $this->medico->get_id($data['fsm']['med_id']);
        $data['medico_cap'] = $this->medico->get_id($data['fsm']['usr_id']);
        $data['empresa'] = $this->cliente->get_empresa_by_id($data['fsm']['emp_id']);
        $this->load->helper('pdf');
        genera_pdf($this->load->view('examen/eye_detect/pdf',$data,TRUE),'eye_detect','EX');
    }
}