﻿<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Perfil_hepatico extends CI_Controller {
    function __construct() {
        parent::__construct();
        $this->load->model('persona/Persona_model','cliente');
		$this->load->model('servicio/Servicio_model','servicio');
        $this->load->model('empleado/Empleado_model','medico');
        $this->load->model('examen/Perfil_hepatico_model','perfil_hepatico');
		$this->load->helper('util');
		$this->load->helper('report');
    }
    
    public function nuevo($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
        $user = $this->session->user;


        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
			/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
			if (($persona['serv_id'] == 0) ||(get_status_serv($persona['serv_id']) != 'PROCESO'))
			{					
					$this->form_validation->set_rules('servicio','Orden de servicio','required');
			}
			else
			{
					$this->form_validation->set_rules('servicio','Orden de servicio','integer');
			}
            /*************************************************/
			$this->form_validation->set_rules('billi-total','BILIRRUBINA TOTAL','required');   
			$this->form_validation->set_rules('billi-directa','BILIRRUBINA DIRECTA','required');  
			$this->form_validation->set_rules('billi-indirecta','BILIRRUBINA INDIRECTA','required');
			$this->form_validation->set_rules('prot-totales','PROTEÍNAS TOTALES','required');
			$this->form_validation->set_rules('albumina','ALBÚMINA','required'); 
			$this->form_validation->set_rules('globulina','GLOBÚLINA','required');
			$this->form_validation->set_rules('alb-glob','RELACIÓN ALBÚMINA/GLOBÚLINA','required');
			$this->form_validation->set_rules('fosfa-alcalina','FOSFATASA ALCALINA','required'); 
			$this->form_validation->set_rules('lactato-deshidro','LACTATO DESHIDROGENASA','required'); 
			$this->form_validation->set_rules('got-ast','ASPARTATO AMINOTRANSFERASA (GOT/AST)','required');    
			$this->form_validation->set_rules('ggt','GAMMA GLUTAMIL TRANSFERASA (GGT)','required');  
			$this->form_validation->set_rules('tgp','ALANINA-AMINO TRANSFERASA (ALT O TGP)','required'); 
			
            if($this->form_validation->run())
            {
                $data_insert['usr_id']  = $user['usr_id']; 
				$data_insert['med_id']  = $this->input->post('laboratorista'); 
				
                $data_insert['clte_id'] = $persona['clte_id'];
                $data_insert['emp_id']  = $persona['emp_id'];

				if (($persona['serv_id'] == 0) || (get_status_serv($persona['serv_id']) != 'PROCESO'))
				{	
						$data_insert['serv_id']  = $this->input->post('servicio');
				}
				else
				{	
						$data_insert['serv_id']  = $persona['serv_id'];
				}
			
				$data_insert['qui_medico_sol'] = $this->input->post('medico_sol');
				
                $data_insert['qui_f_recibido']   = formatea_fecha_mysql($this->input->post('fecha_rec')); //date('Y-m-d H:i:s'); 
                $data_insert['qui_f_impresion']  = formatea_fecha_mysql($this->input->post('fecha_imp')); //date('Y-m-d H:i:s');
                $data_insert['log_insrt_f']  =  date('Y-m-d H:i:s');
				
				$data_insert['qui_billi-total']=	$this->input->post('billi-total');
				$data_insert['qui_billi-directa']=	$this->input->post('billi-directa');
				$data_insert['qui_billi-indirecta']=	$this->input->post('billi-indirecta');
				$data_insert['qui_prot-totales']=	$this->input->post('prot-totales');
				$data_insert['qui_albumina']=	$this->input->post('albumina');
                $data_insert['qui_globulina']=	$this->input->post('globulina');
				$data_insert['qui_alb-glob']=	$this->input->post('alb-glob');
				$data_insert['qui_fosfa-alcalina']=	$this->input->post('fosfa-alcalina');
                $data_insert['qui_lactato-deshidro']=	$this->input->post('lactato-deshidro');
				$data_insert['qui_got-ast']   =	$this->input->post('got-ast');
				$data_insert['qui_ggt']=	$this->input->post('ggt');
                $data_insert['qui_tgp']=	$this->input->post('tgp');
	
				$data_insert['qui_lab'] = $this->input->post('laboratorista');
				$data_insert= array_to_upper($data_insert);
				$data_insert['qui_obs']  = $this->input->post('q_sang_obs');
				//$data_insert['qui_fuera_rango'] = $this->input->post('fuera_rango');
				$data_insert['log_insrt_f']  =  date('Y-m-d H:i:s'); 
				
				
                if($this->perfil_hepatico->insert($data_insert))
                {
                    send_json_ok('Se guardó de forma correcta');
				}
                else
                {
                    send_json_error('Ocurrió un error al guardar.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
            $data['medico'] = $medico;
			$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);

            $this->load->helper('template');
            $params_view = array(
                'title' => '',
                'view' => 'examen/perfil_hepatico/nuevo_form',
                'view_data' => $data 
               );
            render_template($params_view);
        }
    }
    
    public function pdf($cliente_id, $fsm_id)
    {
        $data['persona'] = $this->cliente->get($cliente_id,get_desp_id_usr());
        $data['fsm'] = $this->perfil_hepatico->get($fsm_id,get_desp_id_usr());
        $data['medico'] = $this->medico->get_id($data['fsm']['med_id']);
        $data['empresa'] = $this->cliente->get_empresa_by_id($data['fsm']['emp_id']);
        $this->load->helper('pdf');
		
		$med_name=$data['fsm']['qui_lab'];
		$emp_id=$data['fsm']['emp_id'];
		$observaciones=$data['fsm']['qui_obs'];
		$fuera_rango=$data['fsm']['qui_fuera_rango'];
        $data_empresa = $this->cliente->get_empresa_by_id($emp_id);	
       // $ruta = base_url('../dist/images/hclogo.jpg');
		$med_name=agrega_cedula_ext($data['fsm']['med_id']);
		genera_pdf_lab_new_x($this->load->view('examen/perfil_hepatico/pdf',$data,TRUE),'perfil_hepatico','perfil_hepatico',$med_name,$observaciones,$fuera_rango);	

	}
	

    public function borra_qui_san($fsm_id)
    {
        if($this->perfil_hepatico->delete_qui_san($fsm_id))
        {
            send_json_ok('Se eliminó de forma correcta.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar.');
        }
    }
	
	
}
