﻿<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Quimica_sanguinea4 extends CI_Controller {
    function __construct() {
        parent::__construct();
        $this->load->model('persona/Persona_model','cliente');
		/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
		$this->load->model('servicio/Servicio_model','servicio');
		/*************************************************/			
        $this->load->model('empleado/Empleado_model','medico');
        $this->load->model('examen/Quimica_sanguinea6_model','qui_san4');
		$this->load->helper('util');
		$this->load->helper('report');
    }
    
    public function nuevo($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
        $user = $this->session->user;
        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
			/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
			if (($persona['serv_id'] == 0) ||(get_status_serv($persona['serv_id']) != 'PROCESO'))
			{					
					$this->form_validation->set_rules('servicio','Orden de servicio','required');
			}
			else
			{
					$this->form_validation->set_rules('servicio','Orden de servicio','integer');
			}
            /*************************************************/
			$this->form_validation->set_rules('glucosa','GLUCOSA BASAL','required');
			$this->form_validation->set_rules('urea','UREA','required');
			$this->form_validation->set_rules('creatinina','CREATININA','required');

			$this->form_validation->set_rules('acidourico','ACIDO URICO','required'); 
			//$this->form_validation->set_rules('colesterol','COLESTEROL TOTAL','required');  
			//$this->form_validation->set_rules('trigliseridos','TRIGLICÉRIDOS','required'); 
			
            if($this->form_validation->run())
            {
                $data_insert['usr_id']  = $user['usr_id']; 
				$data_insert['med_id']  = $this->input->post('laboratorista'); 
                $data_insert['clte_id'] = $persona['clte_id'];
                $data_insert['emp_id']  = $persona['emp_id'];

				if (($persona['serv_id'] == 0) || (get_status_serv($persona['serv_id']) != 'PROCESO'))
				{	
						$data_insert['serv_id']  = $this->input->post('servicio');
				}
				else
				{	
						$data_insert['serv_id']  = $persona['serv_id'];
				}

                $data_insert['qui_medico_sol'] = $this->input->post('medico_sol');

				$data_insert['qui_f_recibido']   = formatea_fecha_mysql($this->input->post('fecha_rec')); //date('Y-m-d H:i:s'); 
                $data_insert['qui_f_impresion']  = formatea_fecha_mysql($this->input->post('fecha_imp')); //date('Y-m-d H:i:s');
                $data_insert['log_insrt_f']  =  date('Y-m-d H:i:s');

                $data_insert['qui_glucosa']      =	$this->input->post('glucosa');
                $data_insert['qui_colesterol']   =	$this->input->post('colesterol');
                $data_insert['qui_trigliseridos']=	$this->input->post('trigliseridos');				
				$data_insert['qui_urea']=	$this->input->post('urea');
				$data_insert['qui_creatinina']=	$this->input->post('creatinina');
				$data_insert['qui_acidourico']=	$this->input->post('acidourico');
                
				$data_insert['qui_lab'] = $this->input->post('laboratorista');
				
				
				$data_insert=array_to_upper($data_insert);
				$data_insert['qui_obs']  = $this->input->post('q_sang_obs');
				//$data_insert['qui_fuera_rango'] = $this->input->post('fuera_rango');

                
                if($this->qui_san4->insert($data_insert))
                {
                    send_json_ok('Se guardó de forma correcta');
					/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
					$servicios=$persona['domserv'];					
					
					$servicio='QS6;'; /*CODIGO DEL EXAMEN*/
					if (!(strstr($servicios,$servicio)))
					{							
						$servicios.=$servicio;
						$data_clte['domserv']=$servicios;
						$res=$this->cliente->actualiza_registro_individual($cliente_id, $data_clte);
					}
					/**************************************************/					
					
                }
                else
                {
                    send_json_error('Ocurrió un error al guardar.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
            $data['medico'] = $medico;
			/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
			$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);
			/**************************************************/				
            $this->load->helper('template');
            $params_view = array(
                'title' => '',
                'view' => 'examen/quimica_sanguinea4/nuevo_form',
                'view_data' => $data 
               );
            render_template($params_view);
        }
    }
    
    public function pdf($cliente_id, $fsm_id)
    {
        $data['persona'] = $this->cliente->get($cliente_id,get_desp_id_usr());
        $data['fsm'] = $this->qui_san4->get($fsm_id,get_desp_id_usr());
        $data['medico'] = $this->medico->get_id($data['fsm']['med_id']);
        $data['empresa'] = $this->cliente->get_empresa_by_id($data['fsm']['emp_id']);
        $this->load->helper('pdf');
		
		$med_name=$data['fsm']['qui_lab']; //'Q.F.B. JAIMES FLORES MONTSERRAT    11322160                                                                                                                        ';
		$emp_id=$data['fsm']['emp_id'];
		$observaciones=$data['fsm']['qui_obs'];
		$fuera_rango=$data['fsm']['qui_fuera_rango'];
		$data_empresa = $this->cliente->get_empresa_by_id($emp_id);	
	
			$med_name=agrega_cedula_ext($data['fsm']['med_id']);
			//genera_pdf_lab_new_xxx
			genera_pdf_lab_new_x($this->load->view('examen/quimica_sanguinea4/pdf',$data,TRUE),'quimica_sanguinea6','quimica_sanguinea6',$med_name,$observaciones,$fuera_rango);
	}
	

    public function borra_qui_san($fsm_id)
    {
        if($this->qui_san4->delete_qui_san($fsm_id))
        {
            send_json_ok('Se eliminó de forma correcta.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar.');
        }
    }
	
	
}