<?php
defined('BASEPATH') OR exit('No direct script access allowed');


if (!function_exists('string_trash'))
{
    function string_trash($pass)
    {																
		if 	
		( 
			(strpos($pass,'|') === false) && (strpos($pass,'$') === false) && (strpos($pass,'!') === false) && (strpos($pass,'¿') === false) && 
			(strpos($pass,'%') === false) && (strpos($pass,'?') === false) && (strpos($pass,'Ñ') === false) && (strpos($pass,'ñ') === false) && 
			(strpos($pass,'.') === false) && (strpos($pass,',') === false) && (strpos($pass,';') === false) && (strpos($pass,'@') === false) && 
			(strpos($pass,'+') === false) && (strpos($pass,'(') === false) && (strpos($pass,')')  == false) && (strpos($pass,'/') === false) && 
			(strpos($pass,'#') === false) && (strpos($pass,'@') === false) && (strpos($pass,'{') === false) && (strpos($pass,'}') === false) && 
			(strpos($pass,'[') === false) && (strpos($pass,']') === false) && (strpos($pass,':') === false) && (strpos($pass,'?') === false) && 
			(strpos($pass,'¡') === false) && (strpos($pass,'+') === false) && (strpos($pass,'*') === false) && (strpos($pass,'°') === false) && 
			(strpos($pass,'¨') === false) && (strpos($pass,' ') === false) && (strpos($pass,'=') === false)
		)				
		{		
		 return 1;
		}
		else
		{
		 return 0;	
		}
    }
}


if (!function_exists('eliminar_acentos'))
{
	function eliminar_acentos($cadena)
	{		
		//Reemplazamos la A y a
		$cadena = str_replace(
		array('Á', 'À', 'Â', 'Ä', 'á', 'à', 'ä', 'â', 'ª'),
		array('A', 'A', 'A', 'A', 'a', 'a', 'a', 'a', 'a'),
		$cadena
		);
		//Reemplazamos la E y e
		$cadena = str_replace(
		array('É', 'È', 'Ê', 'Ë', 'é', 'è', 'ë', 'ê'),
		array('E', 'E', 'E', 'E', 'e', 'e', 'e', 'e'),
		$cadena );
		//Reemplazamos la I y i
		$cadena = str_replace(
		array('Í', 'Ì', 'Ï', 'Î', 'í', 'ì', 'ï', 'î'),
		array('I', 'I', 'I', 'I', 'i', 'i', 'i', 'i'),
		$cadena );
		//Reemplazamos la O y o
		$cadena = str_replace(
		array('Ó', 'Ò', 'Ö', 'Ô', 'ó', 'ò', 'ö', 'ô'),
		array('O', 'O', 'O', 'O', 'o', 'o', 'o', 'o'),
		$cadena );
		//Reemplazamos la U y u
		$cadena = str_replace(
		array('Ú', 'Ù', 'Û', 'Ü', 'ú', 'ù', 'ü', 'û'),
		array('U', 'U', 'U', 'U', 'u', 'u', 'u', 'u'),
		$cadena );
		//Reemplazamos la N, n, C y c
		$cadena = str_replace(
		array('Ñ', 'ñ', 'Ç', 'ç'),
		array('N', 'n', 'C', 'c'),
		$cadena
		);
		
		return $cadena;
	}
}


if (!function_exists('nuevo_generico_doc'))
{
    function nuevo_generico_doc($cliente_id,$titulo,$funcion,$examen,$ruta)
    {
		$CI =&get_instance();
		$CI->load->model('persona/Persona_model','cliente');
		$CI->load->model('servicio/Servicio_model','servicio');
		$CI->load->model('empleado/Empleado_model','medico');
		//echo '-b-';
        $persona = $CI->cliente->get($cliente_id);
        //echo '-c-';
        if(isset($_POST) && count($_POST) > 0)     
        {
			// echo '-e-';
            $CI->load->library('form_validation');

			if (($persona['serv_id'] == 0) ||(get_status_serv($persona['serv_id']) != 'PROCESO'))
			{
					$CI->form_validation->set_rules('servicio','Orden de servicio','required');
			}
			
            $CI->form_validation->set_rules('nombre','Nombre documento','required');

			
            if($CI->form_validation->run())
            {

                $data_clte['clte_id'] =  $cliente_id;
                $data_clte['doc_nombre'] =  $CI->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                $data_clte['emp_id'] =  $CI->input->post('emp_id');				
				$data_clte['doc_clave'] =  $examen;
				$data_clte['doc_pkts'] =  $ruta;

				if (($persona['serv_id'] == 0) || (get_status_serv($persona['serv_id']) != 'PROCESO'))
				{	
						$data_clte['serv_id']  = $CI->input->post('servicio');
				}
				else
				{	
						$data_clte['serv_id']  = $persona['serv_id'];
				}

                if(!empty($_FILES['doc']['name']))
                {   
					//carga_pdf_ext($input,$path, $emp_id,$clte_id,$clave)
					$pre_croquis=carga_pdf_ext('doc',$ruta, $persona['emp_id'],$cliente_id,$examen);  //carga_pdf('doc',$ruta);

					if (!($pre_croquis))
                    {                        
						send_json_error('El documento nos se ha podido cargar, por favor revisa.');
                    }
                    else 
                    {
						$data_clte['doc_path'] = $pre_croquis;
                        if($CI->cliente->add_generico_doc(array_to_upper($data_clte)))
						{
                            send_json_ok(array('msg' =>'Se realizo la carga del archivo', 'id' => $cliente_id));

                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
                    send_json_error($CI->upload->display_errors());
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
			
            $data['persona'] = $persona;
			$data['ordeness'] = $CI->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);
			$data['cliente_id'] = $cliente_id;
			$data['titulo'] = $titulo;
			$data['funcion'] = $funcion;
			$data['examen'] = $examen;
			$data['ruta'] = $ruta;		
			
            $CI->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'persona/add_generico_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }
}






if (!function_exists('busca_archivos_smty'))
{
    function busca_archivos_smty($cliente_id,$serv_id,$emp_id)
    {
        $CI =&get_instance();
        $CI->load->model('persona/Persona_model','cliente');
        
		
		$archivo_sgmty = $CI->cliente->chk_sgmty_doc_ext($cliente_id,$serv_id,$emp_id);

		return $archivo_sgmty;

    }
}


if (!function_exists('precios_zona_sgmty'))
{
    function precios_zona_sgmty($clte_zona)
    {																
		if ($clte_zona == 'ZONA 1')
		{
			$monto_sgmty=630;
		}
		elseif ($clte_zona == 'ZONA 2')
		{
			$monto_sgmty=1050;
		}
		elseif ($clte_zona == 'ZONA 3')
		{
			$monto_sgmty=1600;
		}
		elseif ($clte_zona == 'ZONA 4')
		{
			$monto_sgmty=2100;
		}
		elseif ($clte_zona == 'ZONA 5')
		{
			$monto_sgmty=2600;
		}
		else
		{
			$monto_sgmty=630;
		}
		return $monto_sgmty;
    }
}



if (!function_exists('precios_zona_sgmty_visitas_fallidas'))
{
    function precios_zona_sgmty_visitas_fallidas($clte_zona)
    {																
		$monto_sgmty=precios_zona_sgmty($clte_zona)*0.5;
		return $monto_sgmty;
    }
}




if (!function_exists('get_emp_osa'))
{
    function get_emp_osa($emp_id)
    {
		$CI =& get_instance();
		$CI->load->model('empresa/Empresa_model','empresa');			
		$la_empresa=$CI->empresa->get_empresa_by_id($emp_id);
		return $la_empresa['emp_osa'];
    }
}





if (!function_exists('busca_evaluados_ligados_paciente'))
{
    function busca_evaluados_ligados_paciente($paciente_id)
    {
        $CI =&get_instance();
        $CI->load->model('persona/Persona_model','cliente');
		$CI->load->model('empleado/Empleado_model','medico');
        
		
		$persona = $CI->cliente->get($paciente_id);
		
		
		$despacho=get_desp_id_usr();
		$emp_id_user=get_emp_id();		
		
		$user =  $CI ->session->user; 
		$medico= $CI ->medico->get($user['usr_id']);

       // $empresa = $persona[''];
        $nombre  = $persona['clte_nombre'];
		//$nombre2 = strtoupper($this->input->post('nombre2'));
		//$empleado =	0; //$persona[''];
		//$receta=	$persona[''];
		$paterno  = $persona['clte_paterno'];
		$materno  = $persona['clte_materno'];
		$data_clientes = $CI ->cliente->busca($empresa, $nombre,$paterno, $materno);
		
		if ($data_clientes)
		{ return 1;} else {return 0;}	

    }
}





if (!function_exists('chk_perfil_de_uso'))
{
    function chk_perfil_de_uso($cat_grupo,$cat_cve)
    {
        $CI =&get_instance();
		$CI->load->model('cat/Catalogo_model','catalogo');
        
        $res=$CI->catalogo->get_catalogo_by_clave($cat_grupo,$cat_cve);
		
		if (strlen($res) > 4)
		{
			return $res;
		}	
		else
		{
			return '';
		}	
    }
}


if (!function_exists('conteo_exa_evaluado_by_serv'))
{
    function conteo_exa_evaluado_by_serv($clte_id,$serv_id,$tabla)
    {
        $CI =&get_instance();
		$CI->load->model('servicio/Servicio_model','servicio');
        
        return $CI->servicio->conteo_exa_evaluado_by_serv($clte_id,$serv_id,$tabla);
    }
}

if (!function_exists('get_paquete_desde_servicio_s'))
{
    function get_paquete_desde_servicio_s($serv_id,$pakt)
    {
        $CI =& get_instance();
        $CI->load->model('servicio/Servicio_model','servicio');

        $ev= $CI->servicio->get_paquete_desde_serv($serv_id,$pakt);

        return $ev;
    }
}



if (!function_exists('get_tabla_by_cve'))
{
    function get_tabla_by_cve($cat_cve)
    {
        $CI =&get_instance();
		$CI->load->model('cat/Catalogo_model','catalogo');
        $cat_grupo='EXA_TABLA'; 
		$cat_grupo_nombre='TABLA'; 
        return mb_strtolower($CI->catalogo->get_cat_nombre_unico($cat_grupo,$cat_grupo_nombre,$cat_cve), 'UTF-8');
    }
}

if (!function_exists('get_tabla_by_grupo_cve'))
{
    function get_tabla_by_grupo_cve($cat_grupo,$cat_grupo_nombre,$cat_cve)
    {
        $CI =&get_instance();
		$CI->load->model('cat/Catalogo_model','catalogo');
        return $CI->catalogo->get_cat_nombre_unico($cat_grupo,$cat_grupo_nombre,$cat_cve);
    }
}


if (!function_exists('genera_password'))
{
    function genera_password($usuario)
	{	

		$password="";
		if (strlen($usuario['usr_nombre']) > 2)
		{	
			$password=strtoupper(substr($usuario['usr_nombre'], 0, 1));
		}
		else
		{
			$password="HC";
		}

		$password.= ".";

		if (strlen($usuario['usr_paterno']) > 2)
		{	
			$password.= mb_strtolower($usuario['usr_paterno'], 'UTF-8');
		}
		else
		{
			$password.="JR";
		}

		$password.= "$";

		$password.= $usuario['emp_id'];

		if (strlen($password) < 12)
		{
			$fix=12 -strlen($password);
			$tap=md5(time());
			$password.=substr($tap, 0, $fix);
		}
		else
		{
			$password.=substr($tap, 0, 3);
		}	

        return $password;
    }
}




if (!function_exists('get_pass_activado'))
{
    function get_pass_activado()
    {
        $CI =&get_instance();
		$CI->load->model('cat/Catalogo_model','catalogo');
        
        return $CI->catalogo->get_pass_data('PASS_CAMBIO','PASS_CAMBIO');
    }
}

if (!function_exists('get_pass_dias'))
{
    function get_pass_dias()
    {
        $CI =&get_instance();
		$CI->load->model('cat/Catalogo_model','catalogo');
        
        return intval($CI->catalogo->get_pass_data('PASS_DIAS','PASS_DIAS'));
    }
}



if (!function_exists('cp_extract'))
{
    function cp_extract($direccion)
	{	
		$pieces = explode(" ", $direccion);
		$longitudDireccion=strlen($direccion);
		$cpEncontrado='';
        foreach ($pieces as $piece) 
		{
			if (strlen($piece) == 5) {
			if (is_numeric($piece) ) {
			$cpEncontrado=$piece; } }
        }
        return $cpEncontrado;
    }
}



if (!function_exists('cabecera_reporte_bitacora'))
{
    function cabecera_reporte_bitacora($titulaje,$titulo,$persona,$recibido,$emp_giro,$emp_razon_social,$impresion='',$solicita='LA EMPRESA CLIENTE',$fsm_id=0,$c1=0)
    {
		$azul_hc='#4B5682'; /*azul solido*/
		$gris_rata='#acacac';		
		$gris_raty='#e9e9e9';
		
		$fondo_titular_a='#00004d';/*azul solido*/
		$letras_titulares_a='#fff';
		$fondo_cinta_a='#00004d';  /*azul solido*/
		$letras_cinta_a='#fff';
		
		
		
		$borde_b=0; //1;
		$fondo_titular_b=  '#ffffff'; //'#e9e9e9';  //'#4B5682'; //'#acacac'; //'#fff';  //'#000000'; ///*azul claro*/
		$letras_titulares_b= '#000000'; //'#ffffff';  // '#000'; //'#fff'; //'#ffffff';
		$fondo_cinta_b=  '#ffffff';//'#e9e9e9';  //'#4B5682'; //'#acacac'; //'#fff';  //'#000000'; ///*azul claro*/
		$letras_cinta_b= '#000000'; //'#ffffff';  // '#000'; //'#fff'; //'#ffffff';		

		$size_titulo_b='font-size:175%';
	
		$emp_giro='1';//$emp_giro; //.

		$b_color=$fondo_titular_b;
	
	 
?>

		<table style="width: 100%">
			<tr>

					<td  style="width: 65%;"><img src="<?php echo "./../../files/imagenes/logo_2.png"; ?>" width="200px" /></td>   
				<td align="right" style="width: 35%;"><br><br><i><b style="color: <?php echo $letras_titulares_b;?>;"><?php echo 'ID: '.$persona['usr_id'].'-'.$fsm_id; ?></b></i></td>
			</tr>	
		</table>


		<table border="0" >
			<tr><td></td></tr>
		</table>

		<table border="0">
			<tr>
				<td style="<?php echo $size_titulo_b; ?>;" ><b><?php echo '&nbsp;&nbsp;'.$titulo;?></b></td>
			</tr>		
		</TABLE>		
		
		<table border="0" >
			<tr><td><hr></td></tr>
		</table>
		
		<table border="<?php echo $borde_b;?>" cellpadding="3">
			<tr>
				<td align="left" style="background-color:   <?php echo $fondo_titular_b;?>; width: 20%;">
					<b style="color: <?php echo $letras_titulares_b;?>;">NOMBRE:</b>
				</td>
				<td align="left" "width: 20%;">
					<?php echo $persona['usr_nombre'].' '.$persona['usr_paterno'].' '.$persona['usr_materno']; ?>
				</td>
			</tr>
			<tr>
				<td align="left" style="background-color:   <?php echo $fondo_titular_b;?>; width: 20%;">
					<b style="color: <?php echo $letras_titulares_b;?>;">FECHA DE LA BITÁCORA:</b>
				</td>
				<td align="left" "width: 20%;">
					<?php echo formatea_fecha($recibido) ; ?>
				</td>
			</tr>			
			<tr>
				<td align="left" style="background-color:   <?php echo $fondo_titular_b;?>; width: 20%;">
					<b style="color: <?php echo $letras_titulares_b;?>;">FECHA DE IMPRESIÓN:</b>
				</td>
				<td align="left" "width: 20%;">
					<?php echo formatea_fechahora(date('Y-m-d H:i:s')); ?>
				</td>
			</tr>			
			
		</table>

		<table border="0" >
			<tr><td><hr></td></tr>
		</table>
		
    

<?php 	



    }

	
}




if (!function_exists('string_to_up_low'))
{
    function str_to_up_low($string)
    {
		$data= ucfirst(mb_convert_case($string, MB_CASE_TITLE, 'UTF-8'));
		$data= str_replace('(A)','(a)', $data);
		$data= str_replace(' O ',' o ', $data);
		$data= str_replace(' Al ',' al ', $data);
		$data= str_replace(' Para ',' para ', $data);
		$data= str_replace(' Que ',' que ', $data);
		$data= str_replace(' Con El ',' con el ', $data);
		$data= str_replace(' De La ',' de la ', $data);
		$data= str_replace(' Del ',' del ', $data);
		$data= str_replace(' Y ',' y ', $data);
		$data= str_replace(' De ',' de ', $data);
		$data= str_replace(' Un ',' un ', $data);
		$data= str_replace('(S)','(s)', $data);
		$data= str_replace(' Añ',' añ', $data);
		$data= str_replace('Cdmx','CDMX', $data);
		$data= str_replace('Cch','CCH', $data);
		$data= str_replace('C.p.','C.P.', $data);
		$data= str_replace('Cp','C.P.', $data);
		$data= str_replace('Tdc','TDC', $data);
		$data= str_replace('Didi','DIDI', $data);
		$data= str_replace('Bbva','BBVA', $data);
		$data= str_replace('Hsbc','HSBC', $data);
		$data= str_replace('Gnp','GNP', $data);
		$data= str_replace('Otro, Cuál' ,'Otro, ¿cuál?' , $data); 
		$data= str_replace('N/a' ,'N/A' , $data); 
		$data= str_replace('Dvd' ,'DVD' , $data);
		$data= str_replace('Sura' ,'SURA' , $data);
		$data= str_replace(' En ' ,' en ' , $data);
		$data= str_replace('Sa de Cv' ,'SA de CV' , $data);
		$data= str_replace('S.a. de C.v.' ,'S.A. de C.V.' , $data);
		$data= str_replace('Imss' ,'IMSS' , $data);
		$data= str_replace('imss' ,'IMSS' , $data);
		$data= str_replace('Imss' ,'IMSS' , $data);
		$data= str_replace('issste' ,'ISSSTE' , $data);
		$data= str_replace('Issste' ,'ISSSTE' , $data);
		$data= str_replace('Aicm' ,'AICM' , $data);
		$data= str_replace('Aifa' ,'AIFA' , $data);
		$data= str_replace('nota:' ,'Nota:' , $data);
        $data= str_replace(' Destaca ' ,' destaca ' , $data);
		$data= str_replace(' Candidato ' ,' candidato ' , $data);
		$data= str_replace(' Se ' ,' se ' , $data);
		$data= str_replace(' Gemelo ' ,' gemelo ' , $data);
		$data= str_replace(' El ' ,' el ' , $data);
		$data= str_replace(' Es ' ,' es ' , $data);
		$data= str_replace('Uam ' ,'UAM ' , $data);
		$data= str_replace('Unam ' ,'UNAM ' , $data);
		return $data;
    }
}



if (!function_exists('string_to_up_low_all'))
{
    function str_to_up_low_all($string)
    {
		$data= ucfirst(mb_convert_case($string, MB_CASE_LOWER, 'UTF-8'));
		$data= str_replace('N/a' ,'N/A' , $data); 
		$data= str_replace('Dvd' ,'DVD' , $data);
		$data= str_replace('Si' ,'Sí' , $data);
		$data= str_replace('Imss' ,'IMSS' , $data);
		$data= str_replace('imss' ,'IMSS' , $data);
		$data= str_replace('issste' ,'ISSSTE' , $data);
		$data= str_replace('Issste' ,'ISSSTE' , $data);
		$data= str_replace('Aicm' ,'AICM' , $data);
		$data= str_replace('Aifa' ,'AIFA' , $data);
        return $data;
    }
}


if (!function_exists('encryptador'))
{
    function encryptador($string, $key)
    {
        $result = '';
        for ($i = 0; $i < strlen($string); $i++) {
            $char = substr($string, $i, 1);
            $keychar = substr($key, ($i % strlen($key)) - 1, 1);
            $char = chr(ord($char) + ord($keychar));
            $result .= $char;
        }
        return base64_encode($result);
    }
}

if (!function_exists('desencryptador'))
{
    function desencryptador($string, $key)
    {
        $result = '';
        $string = base64_decode($string);
        for ($i = 0; $i < strlen($string); $i++) {
            $char = substr($string, $i, 1);
            $keychar = substr($key, ($i % strlen($key)) - 1, 1);
            $char = chr(ord($char) - ord($keychar));
            $result .= $char;
        }
        return $result;
    }
}



if (!function_exists('stilos_corporativos'))
{
    function stilos_corporativos()
	{
		
		echo '<style type="text/css">';		
		echo 
			"
			hr.negro_s {
			  border-top: 1px solid black;
			}

			hr.gris_s {
			  border-top: 1px solid silver;
			}			

			 .blink {
				animation: blinker 1s linear infinite;
			}

			@keyframes blinker {
				50% {
				  opacity: 0;
				}
			}


			.auto-negro {
				color: black;			
			";
		echo '</style>';
			
    }	
	
}


if (!function_exists('depende_de_corporativo'))
{
    function depende_de_corporativo($emp_id)
	{
			$CI =& get_instance();
			$CI->load->model('empresa/Empresa_model','empresa');			
			$la_empresa=$CI->empresa->get_empresa_by_id($emp_id);
			if ($la_empresa['emp_depend_corporativo'] == 1)
			{
				return TRUE;
			}
			else
			{
				return FALSE;
			}
			
    }	
	
}


if (!function_exists('que_corporativo_soy'))
{
    function que_corporativo_soy($emp_id)
	{
		$CI =& get_instance();
		$CI->load->model('empresa/Empresa_model','empresa');			
		$la_empresa=$CI->empresa->get_empresa_by_id($emp_id);
		return $la_empresa['emp_corp'];
    }	
	
}


if (!function_exists('de_que_empresa_soy_corporativo'))
{
    function de_que_empresa_soy_corporativo($corp_nombre)
	{
		$CI =& get_instance();
		$CI->load->model('empresa/Empresa_model','empresa');			
		$la_empresa=$CI->empresa->de_que_empresa_soy_corporativo($corp_nombre);
		return $la_empresa['emp_id'];
    }	
	
}





if (!function_exists('histograma_ergonomico_sino'))
{
    function histograma_ergonomico_sino($fsm,$x,$y,$z,$s,$eje_x,$eje_y,$p_ancho,$c_color1,$c_color2,$margen,$size_font=5)
	{
				$p_ancho=$p_ancho+2;
				?>
				<table border="0" class="table table-sinborde">
					<?php
					for ($yy = ($eje_y-1); $yy >= 0; $yy--) 
					{
					?>						
						<tr valign="bottom"; style="color: black;">
							<td style="width: <?php echo $margen;?>%;">&nbsp;</td>
							<td class="borde_derecho" align="left" style="font-size:<?php echo $size_font;?>px; width: <?php echo $p_ancho*10;?>px; height: <?php echo $p_ancho*4;?>px;"><b><?php //echo $y[$yy];; ?></b></td>
							<td style="width: 1%;">&nbsp;</td>
							<?php
							for ($xx = 0; $xx < $eje_x; $xx++) 
							{
							?>
								<?php if ('SI' == $fsm[$z[$xx]] ) { $colors=$c_color1; $s[$xx]= 1;} else { $colors='white';} ?><td align="center" style="width: <?php echo $p_ancho/4;?>%;background-color:<?php echo $colors; ?>;"><b></b></td>
								<?php if ($y[$yy] == $fsm[$z[$xx]]) { $colors=$c_color; $s[$xx]= 1;} else { $colors='white';} ?><td align="center" style="width: <?php echo $p_ancho/4;?>%;"><b></b></td>
								<?php if ('NO' == $fsm[$z[$xx]] ) { $colors=$c_color2; $s[$xx]= 1;} else { $colors='white';} ?><td align="center" style="width: <?php echo $p_ancho/4;?>%;background-color:<?php echo $colors; ?>;"><b></b></td>
								<?php if ($y[$yy] == $fsm[$z[$xx]]) { $colors=$c_color; $s[$xx]= 1;} else { $colors='white';} ?><td align="center" style="width: <?php echo $p_ancho/4;?>%;"><b></b></td>
							<?php		
							}
							?>
						</tr>
					<?php		
					}
					?>

					<tr style="color: black;">
						<td style="width: <?php echo $margen;?>%;">&nbsp;</td>
						<td class="borde_derecho"  align="center" style="width: <?php echo $p_ancho*10;?>px;"><b><?php echo ' '; ?></b></td>
						<td style="width: 1%;">&nbsp;</td>
						<?php						
							for ($xx = 0; $xx < $eje_x; $xx++) 
							{
							?>
								<td align="center" style="font-size:5px; width: <?php echo ($p_ancho/4);?>%;"><b><?php echo 'SI'; ?></b></td>
								<td align="center" style="font-size:5px; width: <?php echo ($p_ancho/4);?>%;"><b><?php echo '&nbsp;'; ?></b></td>
								<td align="center" style="font-size:5px; width: <?php echo ($p_ancho/4);?>%;"><b><?php echo 'NO'; ?></b></td>
								<td align="center" style="font-size:5px; width: <?php echo ($p_ancho/4);?>%;"><b><?php echo '&nbsp;'; ?></b></td>
							<?php		
							}
							?>
                    </tr>

					
					<tr style="color: black;">
						<td style="width: <?php echo $margen;?>%;">&nbsp;</td>
						<td align="center" style="width: <?php echo $p_ancho*10;?>px;"><b><?php echo ' '; ?></b></td>
						<?php						
							for ($xx = 0; $xx < $eje_x; $xx++) 
							{
							?>
								<td class="borde_superior" align="center" style="font-size:<?php echo $size_font;?>px; width: <?php echo $p_ancho;?>%;"><b><?php echo $x[$xx]; ?></b></td>
							<?php		
							}
							?>
                    </tr>
                 </table>
				 <?php
    }	
	
}




if (!function_exists('histograma_ergonomico_2'))
{
    function histograma_ergonomico_2($fsm,$x,$y,$z,$s,$eje_x,$eje_y,$p_ancho,$c_color,$margen,$size_font=5)
	{
				?>
				<table border="0" class="table table-sinborde">
					<?php
					for ($yy = ($eje_y-1); $yy >= 0; $yy--) 
					{
					?>						
						<tr valign="bottom"; style="color: black;">
							<td style="width: <?php echo $margen;?>%;">&nbsp;</td>
							<td align="left" class="borde_derecho" style="font-size:<?php echo $size_font;?>px; width: <?php echo $p_ancho*10;?>px; height: <?php echo $p_ancho*4;?>px;"><b><?php echo $y[$yy];; ?></b></td>
							<?php
							for ($xx = 0; $xx < $eje_x; $xx++) 
							{
							?>
								<?php if ($y[$yy] == $fsm[$z[$xx]] || ($s[$xx]== 1)) { $colors=$c_color; $s[$xx]= 1;} else { $colors='white';} ?><td align="center" style="width: <?php echo $p_ancho/3;?>%;;"><b></b></td>
								<?php if ($y[$yy] == $fsm[$z[$xx]] || ($s[$xx]== 1)) { $colors=$c_color; $s[$xx]= 1;} else { $colors='white';} ?><td align="center" style="width: <?php echo $p_ancho/3;?>%;background-color:<?php echo $colors; ?>;"><b></b></td>
								<?php if ($y[$yy] == $fsm[$z[$xx]] || ($s[$xx]== 1)) { $colors=$c_color; $s[$xx]= 1;} else { $colors='white';} ?><td align="center" style="width: <?php echo $p_ancho/3;?>%;"><b></b></td>
							<?php		
							}
							?>
						</tr>
					<?php		
					}
					?>


					
					<tr style="color: black;">
						<td style="width: <?php echo $margen;?>%;">&nbsp;</td>
						<td align="center" style="width: <?php echo $p_ancho*10;?>px;"><b><?php echo ' '; ?></b></td>
						<?php						
							for ($xx = 0; $xx < $eje_x; $xx++) 
							{
							?>
								<td class="borde_superior" align="center" style="font-size:<?php echo $size_font;?>px; width: <?php echo $p_ancho;?>%;"><b><?php echo $x[$xx]; ?></b></td>
							<?php		
							}
							?>
                    </tr>
                 </table>
				 <?php
    }	
	
}

if (!function_exists('histograma_ergonomico_1'))
{
    function histograma_ergonomico_1($fsm,$x,$y,$z,$s,$eje_x,$eje_y,$p_ancho,$c_color,$margen,$size_font=5)
	{
				?>
				<table border="0" class="table table-sinborde">
					<?php
					for ($yy = ($eje_y-1); $yy >= 0; $yy--) 
					{
					?>						
						<tr valign="bottom"; style="color: black;">
							<td style="width: <?php echo $margen;?>%;">&nbsp;</td>
							<td align="left" style="font-size:<?php echo $size_font;?>px; width: <?php echo $p_ancho*10;?>px; height: <?php echo $p_ancho*4;?>px;"><b><?php echo $y[$yy];; ?></b></td>
							<?php
							for ($xx = 0; $xx < $eje_x; $xx++) 
							{
							?>
								<?php if ($y[$yy] == $fsm[$z[$xx]] || ($s[$xx]== 1)) { $colors=$c_color; $s[$xx]= 1;} else { $colors='white';} ?><td align="center" style="width: <?php echo $p_ancho;?>%;background-color:<?php echo $colors; ?>;"><b></b></td>
							<?php		
							}
							?>
						</tr>
					<?php		
					}
					?>
					
					<tr style="color: black;">
						<td style="width: <?php echo $margen;?>%;">&nbsp;</td>
						<td align="center" style="width: <?php echo $p_ancho*10;?>px;"><b><?php echo ' '; ?></b></td>
						<?php						
							for ($xx = 0; $xx < $eje_x; $xx++) 
							{
							?>
								<td align="center" style="font-size:<?php echo $size_font;?>px; width: <?php echo $p_ancho;?>%;"><b><?php echo $x[$xx]; ?></b></td>
							<?php		
							}
							?>
                    </tr>
                 </table>
				 <?php
    }	
	
}


if (!function_exists('pie_de_pagina_reportes_lab'))
{
    function pie_de_pagina_reportes_lab($obs,$lab,$med_id, $titulo_principal,$sin_obs=0 )
	{
		?>
		
		
		
		<table>
			<?php
				if ($sin_obs == 0)
				{
					if ($obs !='')
					{
					?>
					<tr>
						<td CLASS="<?php echo $titulo_principal; ?>" style="width: 15%"><B>OBSERVACIONES:</B></td>
						<td  align="left" style="width: 85%"><?php echo strtoupper($obs).'<br>';?></td>
					</tr>
					<?php
					}
					else
					{	
					?>
					<tr>
						<td CLASS="<?php echo $titulo_principal; ?>" style="width: 15%"><B>OBSERVACIONES:</B></td>
						<td align="left" style="width: 85%"><?php echo 'NINGUNA.<br>';?></td>
					</tr>
					<?php
					}
				}
				else
				{
					?>
					<tr>
						<td><?php echo '<br>';?></td>
					</tr>
					<?php
				}
			?>					
		</table>

		<table style="width: 100%">
			<tr>
				<td style="font-size: 35%;" align="left">&nbsp;</td>
            </tr>
		</table>

		<table style="width: 100%">
            <tr>
				<td CLASS="<?php echo $titulo_principal; ?>" align="left"><B>Lo(s) resultado(s) fuera de rango validado(s).</B></td>
            </tr>
		</table>
		
		<?php
		$med_name=$lab;
		$med_name=agrega_cedula_ext($med_id);
		$med_name = str_replace("Cédula", "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Cédula",$med_name);
		?>
		
		<table style="width: 100%">
			<tr>
				<td style="font-size: 270%;" align="left">&nbsp;</td>
            </tr>
		</table>
		
		<table style="width: 100%">
            <tr>
				<td CLASS="<?php echo $titulo_principal; ?>" align="left"><B><?php echo $med_name;?></B></td>
            </tr>
		</table>
		<?php

    }	
	
}


if (!function_exists('medidor_riesgo'))
{
    function medidor_riesgo($riesgo)
	{
			$resultado=0;
			if ($riesgo == 'MUY BAJO') { $resultado=5; }
			elseif ($riesgo == 'BAJO') { $resultado=4; }
			elseif ($riesgo == 'MEDIO') { $resultado=3; }
			elseif ($riesgo == 'ALTO') { $resultado=2; }
			elseif ($riesgo == 'MUY ALTO') { $resultado=1; }
			else { $resultado=0; }
			return $resultado;
    }	
	
}


if (!function_exists('get_doc_detail_insignia'))
{
    function get_doc_detail_insignia($clte_id,$emp_id,$serv_id,$doc_nombre )
	{
			$CI =& get_instance();
			$CI->load->model('persona/Persona_model','persona');
			
			$resultado=$CI->persona->get_doc_detail_insignia($clte_id,$emp_id,$serv_id,$doc_nombre );
			return $resultado;
    }	
	
}


if (!function_exists('saber_dia'))
{
	function saber_dia($nombredia) 
	{
		$dias = array('', 'lunes','martes','miércoles','jueves','viernes','sabado', 'domingo');
		$fecha = $dias[date('N', strtotime($nombredia))];
		return $fecha;
	}
}

if (!function_exists('calcular_antiguedad'))
{
	function calcular_antiguedad($fecha)
	{
		if ($fecha != '0000-00-00')
		{	
			$fecha_nac = new DateTime(date('Y/m/d',strtotime($fecha))); // Creo un objeto DateTime de la fecha ingresada
			$fecha_hoy =  new DateTime(date('Y/m/d',time())); // Creo un objeto DateTime de la fecha de hoy
			$edad = date_diff($fecha_hoy,$fecha_nac); // La funcion ayuda a calcular la diferencia, esto seria un objeto
			$antiguedad=  $edad->format('%Y').' años, '.$edad->format('%m').' meses, '.$edad->format('%d').' días'; 
		}
		return $antiguedad;
	}
}


if (!function_exists('factores_riesgo_1'))
{
    function factores_riesgo_1($calificacion)
	{
		
		switch ($calificacion) {
			case "SIEMPRE":
				  return 0;
			break;
			case "CASI SIEMPRE":
				   return 1;
			break;
			case "ALGUNAS VECES":
				   return 2;
			break;
			case "CASI NUNCA":
				   return 3;
			break;
			case "NUNCA":
				   return 4;
			break;
			}
    }	
}


if (!function_exists('factores_riesgo_else'))
{
    function factores_riesgo_else($calificacion)
	{
		
		switch ($calificacion) {
			case "SIEMPRE":
				  return 4;
			break;
			case "CASI SIEMPRE":
				   return 3;
			break;
			case "ALGUNAS VECES":
				   return 2;
			break;
			case "CASI NUNCA":
				   return 1;
			break;
			case "NUNCA":
				   return 0;
			break;
			}
    }	
}






if (!function_exists('dia_de_hoy'))
{
    function dia_de_hoy($day)
	{
		if ($day == '')
		{	
			$day = date("l");
		}
		switch ($day) {
			case "Sunday":
				  return "DOMINGO";
			break;
			case "Monday":
				   return "LUNES";
			break;
			case "Tuesday":
				   return "MARTES";
			break;
			case "Wednesday":
				   return "MIERCOLES";
			break;
			case "Thursday":
				   return "JUEVES";
			break;
			case "Friday":
				   return "VIERNES";
			break;
			case "Saturday":
				  return "SABADO";
			break;
			}
    }	
	
}

if (!function_exists('get_empresas_corporativo'))
{
    function get_empresas_corporativo($corporativo)
	{
			$CI =& get_instance();
			$CI->load->model('empresa/Empresa_model','consultorio');
			
			$id=$CI->consultorio->get_empresas_corporativo($corporativo);
			
			$i=0;
			foreach($id as $idd):
				$resultado[$i]=$idd['emp_id'];
				$i++; 
			endforeach;
			
			return $resultado;
    }	
}


if (!function_exists('get_dias_caduca_ordenes'))
{
    function get_dias_caduca_ordenes($emp_id)
	{
			$CI =& get_instance();
			$CI->load->model('empresa/Empresa_model','empresa');			
			$la_empresa=$CI->empresa->get_empresa($emp_id);
			return $la_empresa['emp_caduca_orden'];
    }	
}


if (!function_exists('get_empresas_categoria('))
{
    function get_empresas_categoria($emp_id)
	{
			$CI =& get_instance();
			$CI->load->model('empresa/Empresa_model','empresa');			
			$la_empresa=$CI->empresa->get_empresa($emp_id);
			return $la_empresa['emp_cat'];
    }	
	
}

if (!function_exists('get_empresas_giro'))
{
    function get_empresas_giro($emp_id,$giro)
	{
			$CI =& get_instance();
			$CI->load->model('empresa/Empresa_model','empresa');			
			$la_empresa=$CI->empresa->get_empresa($emp_id);
			if ($la_empresa['emp_giro'] == $giro)
			{
				return TRUE;
			}
			else
			{
				return FALSE;
			}			
    }		
}

if (!function_exists('get_empresas_giro_detalle'))
{
    function get_empresas_giro_detalle($emp_id)
	{
			$CI =& get_instance();
			$CI->load->model('empresa/Empresa_model','empresa');			
			$la_empresa=$CI->empresa->get_empresa($emp_id);
			return $la_empresa['emp_giro'];
    }		
}

if (!function_exists('get_logo_empresa'))
{
    function get_logo_empresa($emp_id)
	{
			$CI =& get_instance();
			$CI->load->model('empresa/Empresa_model','empresa');			
			$la_empresa=$CI->empresa->get_empresa($emp_id);
			return  $la_empresa['emp_logo'];			
    }	
	
}







if (!function_exists('get_emp_cond_misma_fpdf'))
{
    function get_emp_cond_misma_fpdf($emp_id)
	{
			$CI =& get_instance();
			$CI->load->model('empresa/Empresa_model','empresa');			
			$la_empresa=$CI->empresa->get_empresa($emp_id);
			return $la_empresa['emp_cond_misma_fpdf'];
    }	
	
}

if (!function_exists('get_empresas_emp_cond_cambio'))
{
    function get_empresas_emp_cond_cambio($emp_id)
	{
			$CI =& get_instance();
			$CI->load->model('empresa/Empresa_model','empresa');			
			$la_empresa=$CI->empresa->get_empresa($emp_id);
			return $la_empresa['emp_cond_cambio'];
    }	
	
}



if (!function_exists('get_empresas_corporacion'))
{
    function get_empresas_corporacion($emp_id,$corporacion)
	{
			$CI =& get_instance();
			$CI->load->model('empresa/Empresa_model','empresa');			
			$la_empresa=$CI->empresa->get_empresa($emp_id);
			if ($la_empresa['emp_corp'] == $corporacion)
			{
				return TRUE;
			}
			else
			{
				return FALSE;
			}
			
    }	
	
}


if (!function_exists('rellenador'))
{
    function rellenador($linea)
    {
		$longitud_cadena=strlen(trim($linea));		
		$logitud_final= 300 - $longitud_cadena;
		$entrega='';
		if ($logitud_final > 0)
		{
			for ($i=0; $i < $logitud_final; $i++ )
			{
				$entrega.='&nbsp;';
			}	
		}
		return $entrega;
	}
}

if (!function_exists('put_tab'))
{
    function put_tab($cliente,$clave,$tab,$letrero,$color=0,$background=0)
    {	
		$de_color= '';
		if (strlen($color) > 0)
		{
			$de_color= 'style="color:'.$color.'; background-color:'.$background.';"';
		}	
		
		if (  strstr($cliente['nomserv'],$clave) || ($cliente['root'] == "OK"))
		{ 
			?><li role="presentation" <?php echo $de_color;?>><a  style="color:blue;"  href="#<?php echo $tab;?>"  aria-controls="settings" role="tab" data-toggle="tab"><?php echo $letrero;?></a></li><?php 
		} 
    }
}




if (!function_exists('get_a_usuario'))
{
    function get_a_usuario($id)
    {		
			$CI =& get_instance();
			$CI->load->model('persona/Persona_model','usuarios');			
			$usuario = $CI->usuarios->get_a_usuario($id);			
			return $usuario;
    }
}


if (!function_exists('get_nombre_empleado'))
{
    function get_nombre_empleado($id)
    {
		
			$CI =& get_instance();
			$CI->load->model('empleado/Empleado_model','usuarios');
			
			$usuario = $CI->usuarios->get_id($id);
			
			
			//$titulo=$usuario['usr_titulo'].' ';
			$nombre.='';
				$nombre.=$usuario['usr_nombre'].' ';
				$nombre.=$usuario['usr_paterno'].' ';
				$nombre.=$usuario['usr_materno'].' ';
			return $nombre;
    }			
		
}


if (!function_exists('agrega_cedula_ext'))
{
    function agrega_cedula_ext($id, $anombre=0)
    {
		
			$CI =& get_instance();
			$CI->load->model('empleado/Empleado_model','usuarios');
			
			$usuario = $CI->usuarios->get_id($id);
			
			
			$titulo=$usuario['usr_titulo'].' ';
			$nombre.=' ';
			if ($anombre ==0)
			{
				$nombre.=$usuario['usr_nombre'].' ';
				$nombre.=$usuario['usr_paterno'].' ';
				$nombre.=$usuario['usr_materno'].' ';				
			}
			else
			{	
				$nombre.=$usuario['usr_paterno'].' ';
				$nombre.=$usuario['usr_materno'].' ';
				$nombre.=$usuario['usr_nombre'].' ';
			}
			
			$texto='          Cédula Profesional: ';
			$cedula=$usuario['usr_cedula'];
			
			return $titulo.$nombre.$texto.$cedula;
    }			
		
}

if (!function_exists('cliente_folder_doc'))
{
    function cliente_folder_doc($clave,$user,$cliente,$mis_servicios,$myroot2,$user_root3,$user_root4,$t_nuevo,$t_nuevo_data,$formas,$t_bloque,$t_pdf,$t_edita,$t_borra,$c_os=1)
    {
		$CI =& get_instance();
		$user = $CI->session->user; 
		if ((in_array(get_perfil_id(), array(1,2))) || ($user['usr_id']==393))
		{
			
			
			?><div class="pull-right clearfix"><br><?php
				if (strstr($mis_servicios,$clave) || strstr($mis_servicios,'TODOS'))	
				{
					if ($cliente['emp_id'] == 31)
					{												
						if ($myroot2 == '1')
						{
							?>
							<a href="<?php echo base_url($t_nuevo.$cliente['clte_id'].'/'.$clave); ?>" class="btn btn-success btn-xs pull-right"><i class="fa fa-plus"></i> <?php echo $t_nuevo_data; ?></a>
							<?php
						}
						else
						{
							echo "";		
						}											
					}
					else
					{	
						if ( (($user_root3 < 2) && ($user_root4 != 6)) || (($user_root3 == 2) && ($user_root4 == 3)) )
						{
							?>
							<a href="<?php echo base_url($t_nuevo.$cliente['clte_id'].'/'.$clave); ?>" class="btn btn-success btn-xs pull-right"><i class="fa fa-plus"></i><?php echo $t_nuevo_data; ?></a>
							<?php
						}						
					}
				} 
				else
				{
					echo "";		
				}	
				?>                                    
			</div>
	<?php }  ?>

	<table class="table table-hover table-striped">
		<thead>
			<tr>
				<?php if ($c_os == 1) { ?>
				<th>OS</th>
				<?php } ?>
				<th>Estudio</th>
				<th>Empresa</th>
				<th>Fecha</th>
				<th>Acciones</th>
			</tr>
		</thead>
		<tbody>
		<?php 
			if($formas):
				foreach($formas as $forma): 
				?>
					<tr>
						<?php if ($c_os == 1) { ?>
						<td>
							<?php echo $forma['serv_id']; ?>
						</td>
						<?php } ?>
						<td>
							<?php echo $t_bloque; ?>
						</td>
						<td><?php echo get_empresa($forma['emp_id']); ?></td>
						<td><?php echo formatea_fechahora($forma['doc_f']); ?></td>
						<td>
				<?php 														
						if (strstr($mis_servicios,$clave) || strstr($mis_servicios,'TODOS'))	
						{
							if ($cliente['emp_id'] == 31)
							{
								if ($myroot2 == '1')
								{		
									?> <a target="_blank" href="<?php echo base_url('archivos/descarga/docs/'.strtolower($forma['doc_path'])); ?>"><i class="fa fa-download fa-fw fa-lg"></i></a> <?php
									
									
									if(get_perfil_id() != 4)
									{
										?><a href="<?php echo base_url($t_edita.$forma['doc_id'].'/'.$cliente['clte_id']); ?>"><i class="fa fa-pencil fa-fw fa-lg " style="color:#0F4C81;"></i></a><?php 
									}
									if ($user['usr_id'] == 261) 
									{ 
										?><a href="<?php echo base_url($t_borra.$form['doc_id']);?>" class="delete"><i class="fa fa-trash-o fa-lg" style="color:#f93822;"> </i></a><?php 
									}					
								}
								else
								{
									echo "&#10004;";		
								}											
							}
							else
							{		
								?> <a target="_blank" href="<?php echo base_url('archivos/descarga/docs/'.strtolower($forma['doc_path'])); ?>"><i class="fa fa-download fa-fw fa-lg"></i></a> <?php
									if(get_perfil_id() != 4)
									{
										if ( $t_edita !='')
										{	
										?><a href="<?php echo base_url($t_edita.$forma['doc_id'].'/'.$cliente['clte_id']); ?>"><i class="fa fa-pencil fa-fw fa-lg " style="color:#0F4C81;"></i></a><?php 
										}
									}
									if (($user['usr_id'] == 261) && ( $t_edita !=''))
									{ 
										?><a href="<?php echo base_url($t_borra.$forma['doc_id']);?>" class="delete"><i class="fa fa-trash-o fa-lg" style="color:#f93822;"> </i></a><?php 
									}	
							}
						} 
						else
						{
							echo "&#10004;";		
						}	
						?>
					</td>
				</tr>
				<?php 
				endforeach;
			endif;
		?>
	</tbody>
</table>
<?php			
    }
}


if (!function_exists('produto_folder'))
{
    function producto_folder($clave,$user,$cliente,$mis_servicios,$myroot2,$user_root3,$user_root4,$t_nuevo,$t_nuevo_data,$formas,$t_bloque,$t_pdf,$t_edita,$t_borra,$c_os=1)
    {

		if ((in_array(get_perfil_id(), array(1,2))) || ($user['usr_id']==393)) 
		{

			?><div class="pull-right clearfix"><br><?php
				if (strstr($mis_servicios,$clave) || strstr($mis_servicios,'TODOS'))	
				{
					if ($cliente['emp_id'] == 31)
					{												
						if ($myroot2 == '1')
						{
							?>
							<a href="<?php echo base_url($t_nuevo.$cliente['clte_id']); ?>" class="btn btn-success btn-xs pull-right"><i class="fa fa-plus"></i> <?php echo $t_nuevo_data; ?></a>
							<?php
						}
						else
						{
							echo "";		
						}											
					}
					else
					{	
						if ( (($user_root3 < 2) && ($user_root4 != 6)) || (($user_root3 == 2) && ($user_root4 == 3)) )
						{ 
							?>
							<a href="<?php echo base_url($t_nuevo.$cliente['clte_id']); ?>" class="btn btn-success btn-xs pull-right"><i class="fa fa-plus"></i><?php echo $t_nuevo_data; ?></a>
							<?php
						}						
					}
				} 
				else
				{
					echo "";		
				}	
				?>                                    
			</div>
	<?php }  ?>

	<table class="table table-hover table-striped">
		<thead>
			<tr>
				<?php if ($c_os == 1) { ?>
				<th>OS</th>
				<?php } ?>
				<th>Concepto</th>
				<th>Empresa</th>
				<th>Fecha</th>
				<th>Acciones</th>
			</tr>
		</thead>
		<tbody>
		<?php 
		
			$orden_servicio= -1;
			if($formas):
				foreach($formas as $forma): 
					if ($orden_servicio != $forma['serv_id'])
					{	
					$orden_servicio=$forma['serv_id'];
				?>
					<tr>
						<?php if ($c_os == 1) { ?>
						<td>
							<?php echo $forma['serv_id']; ?>
						</td>
						<?php } ?>
						<td>
							<?php echo $t_bloque; ?>
						</td>
						<td><?php echo get_empresa($forma['emp_id']); ?></td>
						<td><?php 
								if ($forma['fsm_f'])
								{	
									echo formatea_fecha($forma['fsm_f']);
								}
								else
								{
									echo formatea_fechahora($forma['log_insrt_f']);
								}	
							?>
						</td>
						<td>
				<?php 														
						if (strstr($mis_servicios,$clave) || strstr($mis_servicios,'TODOS'))	
						{
							if ($cliente['emp_id'] == 31)
							{
								if ($myroot2 == '1')
								{		
									?><a target="_blank" href="<?php echo base_url($t_pdf.$cliente['clte_id'].'/'.$forma['fsm_id']); ?>"><i class="fa fa-file-pdf-o fa-fw fa-lg " style="color:#0000FF;"></i></a><?php	
									if(get_perfil_id() != 4)
									{ 
										if ($t_edita != 'NULO')
										{	
										?> <a href="<?php echo base_url($t_edita.$cliente['clte_id'].'/'.$forma['fsm_id']); ?>"><i class="fa fa-pencil fa-fw fa-lg" style="color:#00FF00;"></i></a> <?php 
										}
									}
									if ($user['usr_id']==261) 
									{ 
										?> <a href="<?php echo base_url($t_borra.$forma['fsm_id']);?>" class="delete"><i class="fa fa-trash-o fa-lg" style="color:#f93822;"> </i></a>	<?php 
									}					
								}
								else
								{
									echo "&#10004;";		
								}											
							}
							else
							{		
								?><a target="_blank" href="<?php echo base_url($t_pdf.$cliente['clte_id'].'/'.$forma['fsm_id']); ?>"><i class="fa fa-file-pdf-o fa-fw fa-lg " ></i></a> <?php 
								
								if(get_perfil_id() != 4)
								{ 
									if ($t_edita != 'NULO')
									{
									?> <a href="<?php echo base_url($t_edita.$cliente['clte_id'].'/'.$forma['fsm_id']); ?>"><i class="fa fa-pencil fa-fw fa-lg" style="color:#0000FF;"></i></a> <?php 
									}
								}
								
								if (($user['usr_id'] == 261) || ($user['usr_id'] == 351) )
								{ 
									?><a href="<?php echo base_url($t_borra.$forma['fsm_id']);?>" class="delete"><i class="fa fa-trash-o fa-lg" style="color:#f93822;"> </i></a> <?php 
								}	
							}
						} 
						else
						{
							echo "&#10004;";		
						}	
						?>
					</td>
				</tr>
				<?php 
				}
				endforeach;
			endif;
		?>
	</tbody>
</table>
<?php			
    }
}

if (!function_exists('cliente_folder_id_doc_PSIC'))
{
    function cliente_folder_id_doc_PSIC($clave,$user,$cliente,$mis_servicios,$accion_reportar,$accion_mas,$accion_editar,$accion_borrar,$t_nuevo,$t_nuevo_data,$formas,$t_bloque,$t_pdf,$t_edita,$t_borra,$c_os=1)
    {		
		if ((in_array(get_perfil_id(), array(1,2,3,4,5,6)))   ) 
		{			
			?><div class="pull-right clearfix"><br><?php
				if (strstr($mis_servicios,$clave) || strstr($mis_servicios,'TODOS'))	
				{
					
						if ( 
								(
									strstr($user['acciones'],$accion_mas)
								) 
								&&  
								($cliente['status'] != "NOACTIVO")							
							) 
						{ 
							?>
							<a href="<?php echo base_url($t_nuevo.$cliente['clte_id']); ?>" class="btn btn-success btn-xs pull-right"><i class="fa fa-plus"></i><?php echo $t_nuevo_data; ?></a>
							<?php
						}						
					
				} 
				else
				{
					echo "";		
				}	
				?>                                    
			</div>
	<?php }  ?>

	<table class="table table-hover table-striped">
		<thead>
			<tr style="color: black;">
				<?php if ($c_os == 1) { ?>
				<th>Visita</th>
				<?php } ?>
				<th>Documento</th>
			<!--	<th>Empresa</th> -->
				<th>Fecha</th>
				<th>Acciones</th>
			</tr>
		</thead>
		<tbody>
		<?php 
			if($formas):
				foreach($formas as $forma): 
				?>
					<tr style="color: black;">
						<?php if ($c_os == 1) { ?>
						<td>
							<?php echo $forma['serv_id']; ?>
						</td>
						<?php } ?>
						<td>
							<?php echo $t_bloque; ?>
						</td>
					<!--	<td><?php echo get_empresa($forma['emp_id']); ?></td> -->
						<td>
							<?php if (strstr($forma['doc_f'], '00:00:00')) 
							{
								echo formatea_fecha($forma['doc_f']); 
							}
							else
							{	
								echo formatea_fechahora($forma['doc_f']); 
							} 
							?>						
						</td>
						<td>
				<?php 														
						if (strstr($mis_servicios,$clave) || strstr($mis_servicios,'TODOS'))	
						{
							if ( ( strstr($user['acciones'],$accion_reportar) )  )
							{
								if (strlen($forma['doc_path']) > 0 ):								
								?>
									<a target="_blank" href="<?php echo base_url('archivos/descarga/docs_psico/'.strtolower($forma['doc_path'])); ?>"><i class="fa fa-download fa-fw fa-lg"></i></a>			
								<?php endif; 
							}
							
							if(get_perfil_id() != 14)
							{ 
								if ( ( strstr($user['acciones'],$accion_editar) ) && (!( strstr($t_edita,'NULO') )) )
								{
								?> <a href="<?php echo base_url($t_edita.$cliente['clte_id'].'/'.$forma['fsm_id']); ?>"><i class="fa fa-pencil fa-fw fa-lg" style="color:#0000FF;"></i></a> <?php 
								}
								
								if ( ( strstr($user['acciones'],$accion_borrar) ) && (!( strstr($t_borra,'NULO') )) )
								{ 
									?> <a href="<?php echo base_url($t_borra.$forma['doc_id']);?>" class="delete"><i class="fa fa-trash-o fa-lg" style="color:#f93822;"> </i></a>	<?php 
								}
							}							
						} 
						else
						{
							echo "&#10004;";		
						}	
						?>
					</td>
				</tr>
				<?php 
				endforeach;
			endif;
		?>
	</tbody>
</table>
<?php			
    }
}




if (!function_exists('cliente_folder_id_doc_TM'))
{
    function cliente_folder_id_doc_TM($clave,$user,$cliente,$mis_servicios,$accion_reportar,$accion_mas,$accion_editar,$accion_borrar,$t_nuevo,$t_nuevo_data,$formas,$t_bloque,$t_pdf,$t_edita,$t_borra,$c_os=1)
    {		
		if ((in_array(get_perfil_id(), array(1,2,3,4,5,6)))   ) 
		{			
			?><div class="pull-right clearfix"><br><?php
				if (strstr($mis_servicios,$clave) || strstr($mis_servicios,'TODOS'))	
				{
					
						if ( 
								(
									strstr($user['acciones'],$accion_mas)
								) 
								&&  
								($cliente['status'] != "NOACTIVO")							
							) 
						{ 
							?>
							<a href="<?php echo base_url($t_nuevo.$cliente['clte_id']); ?>" class="btn btn-success btn-xs pull-right"><i class="fa fa-plus"></i><?php echo $t_nuevo_data; ?></a>
							<?php
						}						
					
				} 
				else
				{
					echo "";		
				}	
				?>                                    
			</div>
	<?php }  ?>

	<table class="table table-hover table-striped">
		<thead>
			<tr style="color: black;">
				<?php if ($c_os == 1) { ?>
				<th>Visita</th>
				<?php } ?>
				<th>Documento</th>
			<!--	<th>Empresa</th> -->
				<th>Fecha</th>
				<th>Acciones</th>
			</tr>
		</thead>
		<tbody>
		<?php 
			if($formas):
				foreach($formas as $forma): 
				?>
					<tr style="color: black;">
						<?php if ($c_os == 1) { ?>
						<td>
							<?php echo $forma['serv_id']; ?>
						</td>
						<?php } ?>
						<td>
							<?php echo $t_bloque; ?>
						</td>
					<!--	<td><?php echo get_empresa($forma['emp_id']); ?></td> -->
						<td>
							<?php if (strstr($forma['doc_f'], '00:00:00')) 
							{
								echo formatea_fecha($forma['doc_f']); 
							}
							else
							{	
								echo formatea_fechahora($forma['doc_f']); 
							} 
							?>						
						</td>
						<td>
				<?php 														
						if (strstr($mis_servicios,$clave) || strstr($mis_servicios,'TODOS'))	
						{
							if ( ( strstr($user['acciones'],$accion_reportar) )  )
							{
								if (strlen($forma['doc_path']) > 0 ):								
								?>
									<a target="_blank" href="<?php echo base_url('archivos/descarga/docs_TM/'.strtolower($forma['doc_path'])); ?>"><i class="fa fa-download fa-fw fa-lg"></i></a>			
								<?php endif; 
							}
							
							if(get_perfil_id() != 14)
							{ 
								if ( ( strstr($user['acciones'],$accion_editar) ) && (!( strstr($t_edita,'NULO') )) )
								{
								?> <a href="<?php echo base_url($t_edita.$cliente['clte_id'].'/'.$forma['fsm_id']); ?>"><i class="fa fa-pencil fa-fw fa-lg" style="color:#0000FF;"></i></a> <?php 
								}
								
								if ( ( strstr($user['acciones'],$accion_borrar) ) && (!( strstr($t_borra,'NULO') )) )
								{ 
									?> <a href="<?php echo base_url($t_borra.$forma['doc_id']);?>" class="delete"><i class="fa fa-trash-o fa-lg" style="color:#f93822;"> </i></a>	<?php 
								}
							}							
						} 
						else
						{
							echo "&#10004;";		
						}	
						?>
					</td>
				</tr>
				<?php 
				endforeach;
			endif;
		?>
	</tbody>
</table>
<?php			
    }
}



if (!function_exists('cliente_folder_id_doc_8'))
{
    function cliente_folder_id_doc_8($clave,$user,$cliente,$mis_servicios,$accion_reportar,$accion_mas,$accion_editar,$accion_borrar,$t_nuevo,$t_nuevo_data,$formas,$t_bloque,$t_pdf,$t_edita,$t_borra,$c_os=1)
    {		
		if ((in_array(get_perfil_id(), array(1,2,3,4,5,6)))   ) 
		{			
			?><div class="pull-right clearfix"><br><?php
				if (strstr($mis_servicios,$clave) || strstr($mis_servicios,'TODOS'))	
				{
					
						if ( 
								(
									strstr($user['acciones'],$accion_mas)
								) 
								&&  
								($cliente['status'] != "NOACTIVO")							
							) 
						{ 
							?>
							<a href="<?php echo base_url($t_nuevo.$cliente['clte_id']); ?>" class="btn btn-success btn-xs pull-right"><i class="fa fa-plus"></i><?php echo $t_nuevo_data; ?></a>
							<?php
						}						
					
				} 
				else
				{
					echo "";		
				}	
				?>                                    
			</div>
	<?php }  ?>

	<table class="table table-hover table-striped">
		<thead>
			<tr>
				<?php if ($c_os == 1) { ?>
				<th>OS</th>
				<?php } ?>
				<th>Estudio</th>
				<th>Empresa</th>
				<th>Fecha</th>
				<th>Acciones</th>
			</tr>
		</thead>
		<tbody>
		<?php 
			if($formas):
				foreach($formas as $forma): 
				?>
					<tr>
						<?php if ($c_os == 1) { ?>
						<td>
							<?php echo $forma['serv_id']; ?>
						</td>
						<?php } ?>
						<td>
							<?php echo $t_bloque; ?>
						</td>
						<td><?php echo get_empresa($forma['emp_id']); ?></td>
						<td>
							<?php if (strstr($forma['doc_f'], '00:00:00')) 
							{
								echo formatea_fecha($forma['doc_f']); 
							}
							else
							{	
								echo formatea_fechahora($forma['doc_f']); 
							} 
							?>						
						</td>
						<td>
				<?php 														
						if (strstr($mis_servicios,$clave) || strstr($mis_servicios,'TODOS'))	
						{
							if ( ( strstr($user['acciones'],$accion_reportar) )  )
							{
								if (strlen($forma['doc_path']) > 0 ):								
								?>
									<a target="_blank" href="<?php echo base_url('archivos/descarga/docs/'.strtolower($forma['doc_path'])); ?>"><i class="fa fa-download fa-fw fa-lg"></i></a>			
								<?php endif; 
							}
							
							if(get_perfil_id() != 14)
							{ 
								if ( ( strstr($user['acciones'],$accion_editar) ) && (!( strstr($t_edita,'NULO') )) )
								{
								?> <a href="<?php echo base_url($t_edita.$cliente['clte_id'].'/'.$forma['fsm_id']); ?>"><i class="fa fa-pencil fa-fw fa-lg" style="color:#0000FF;"></i></a> <?php 
								}
								
								if ( ( strstr($user['acciones'],$accion_borrar) ) && (!( strstr($t_borra,'NULO') )) )
								{ 
									?> <a href="<?php echo base_url($t_borra.$forma['doc_id']);?>" class="delete"><i class="fa fa-trash-o fa-lg" style="color:#f93822;"> </i></a>	<?php 
								}
							}							
						} 
						else
						{
							echo "&#10004;";		
						}	
						?>
					</td>
				</tr>
				<?php 
				endforeach;
			endif;
		?>
	</tbody>
</table>
<?php			
    }
}

if (!function_exists('cliente_folder_id7'))
{
    function cliente_folder_id7($clave,$user,$cliente,$mis_servicios,$accion_reportar,$accion_mas,$accion_editar,$accion_borrar,$t_nuevo,$t_nuevo_data,$formas,$t_bloque,$t_pdf,$t_edita,$t_borra,$c_os=1)
    {

		if ((in_array(get_perfil_id(), array(1,2,3,4,5,6)))) 
		{

			?><div class="pull-right clearfix"><br><?php
		if ( strstr($mis_servicios,$clave) || strstr($mis_servicios,'TODOS')	||  ($user['usr_id'] == 261) )
				{
			
						if (( 
								(
									strstr($user['acciones'],$accion_mas)
								) 
								&&  
								($cliente['status'] != "NOACTIVO")							
							)
							 ||  ($user['usr_id'] == 261) )
						{ 
						
							if ($cliente['clte_ida'] > 0)
							{	
							?>
							<a href="<?php echo base_url($t_nuevo.$cliente['clte_id']); ?>" class="btn btn-success btn-xs pull-right"><i class="fa fa-plus"></i><?php echo $t_nuevo_data; ?></a>
							<?php
							}
							
						}						
					
				} 
				else
				{
					echo "";		
				}	
				?>                                    
			</div>
	<?php }  ?>

	<table class="table table-hover table-striped">
		<thead>
			<tr>
				<?php if ($c_os == 1) { ?>
				<th>OS</th>
				<?php } ?>
				<th>Estudio</th>
				<th>Empresa</th>
				<th>Fecha</th>
				<th>Acciones</th>
			</tr>
		</thead>
		<tbody>
		<?php 
			if($formas):
				foreach($formas as $forma): 
				?>
					<tr>
						<?php if ($c_os == 1) { ?>
						<td>
							<?php echo $forma['serv_id']; ?>
						</td>
						<?php } ?>
						<td>
							<?php echo $t_bloque; ?>
						</td>
						<td><?php echo get_empresa($forma['emp_id']); ?></td>
						<td><?php 
								if (($forma['fsm_f'])  &&  ($forma['fsm_f']!='0000-00-00 00:00:00'))
								{	
									if (strlen($forma['fsm_f']) > 9)
									{
										echo formatea_fechahora($forma['fsm_f']);
									}
									else
									{
										echo formatea_fecha($forma['fsm_f']);	
									}
								}
								elseif (strlen($forma['fecha_eval']) > 9)
								{ 
									echo formatea_fecha($forma['fecha_eval']); 
								}
								else
								{ 
									echo formatea_fechahora($forma['log_insrt_f']);
								}	
							?>
						</td>
						<td>
				<?php 													
						if ((strstr($mis_servicios,$clave) || strstr($mis_servicios,'TODOS')) ||  ($user['usr_id'] == 261) ) 	
						{
							if (( ( strstr($user['acciones'],$accion_reportar) )  )  ||  ($user['usr_id'] == 261) ) 
							{
								?><a target="_blank" href="<?php echo base_url($t_pdf.$cliente['clte_id'].'/'.$forma['fsm_id']); ?>"><i class="fa fa-file-pdf-o fa-fw fa-lg " ></i></a> <?php 
							}
							
							if(get_perfil_id() != 14)
							{ 
								if ( ( ( strstr($user['acciones'],$accion_editar) ) && (!( strstr($t_edita,'NULO') )) )  ||  ($user['usr_id'] == 261) )
								{
								?> <a href="<?php echo base_url($t_edita.$cliente['clte_id'].'/'.$forma['fsm_id']); ?>"><i class="fa fa-pencil fa-fw fa-lg" style="color:#0000FF;"></i></a> <?php 
								}
								
								if ( ( ( strstr($user['acciones'],$accion_borrar) ) && (!( strstr($t_borra,'NULO') )) )  ||  ($user['usr_id'] == 261) )
								{ 
									?> <a href="<?php echo base_url($t_borra.$forma['fsm_id']);?>" class="delete"><i class="fa fa-trash-o fa-lg" style="color:#f93822;"> </i></a>	<?php 
								}
							}							
						} 
						else
						{
							echo "&#10004;";		
						}	
						?>
					</td>
				</tr>
				<?php 
				endforeach;
			endif;
		?>
	</tbody>
</table>
<?php			
    }
}

if (!function_exists('parrafos_texto'))
{
    function parrafos_texto($fsm,$clave,$clte_id,$fsm_id,$foto,$longitud_total=500,$mayor=3500)
    {
		$fsm=str_replace(">", '&#62;',str_replace("<", '&#60;',$fsm));  
		$longitud_original=strlen ($fsm);
		
		if ($fsm[$longitud_original-1] == "\n")
		{$fsm[$longitud_original-1] = ' ';
		 $fsm= trim($fsm);}	
		
        $parrafos=explode("\n",$fsm);
		$longitud_total=500;
		$longitud_parcial=0;
		$salto=0;
		$mayor=3500;
		foreach($parrafos as $parrafo): 
		
			$longitud_parcial = strlen($parrafo);
			$longitud_total+=$longitud_parcial;
			
			
			if ($longitud_total > $mayor)
			{	$salto=1;
				?>
				<br pagebreak="true"/>
				<table border="0">
					<tr>
						<td align="right" ><b><?php echo $clave.'&nbsp;&nbsp;&nbsp;'.$clte_id.' - '.$fsm_id; ?></b></td>
					</tr>
				</table>				
				<table border="0" cellpadding="5">
				   <tr>
						<td>
							<img src="<?php echo "./../../files/imagenes/logo_2.png"; ?>" width="200px" />
						</td>
						<td align="right" rowspan="2" >
								<?php if($foto ==! NULL): ?>
								 
								<img  src="<?php echo '../../files/fotos/'.strtolower($foto); ?>"  width="100px" height="120px">
								
								<?php else: ?>
									<!-- <img src="<?php echo "http://13.57.91.218/humancenter/dist/images/qr//persona.png"; ?>"  width="100px" height="120px" />-->
								<?php endif; ?>
						</td>
					</tr>		

				</table>
				<p>&nbsp;</p>				

				<?php 
				$longitud_total=0;
				$longitud_total+=$longitud_parcial;
			}	
		?>
		
			<table border="0" >	
			   <tr>
					<td align="center" style="width: 5%;">&nbsp;</td>	   
					<td align="justify" style="width: 90%;">
						<span style="font-size: 9px;">
						<?php echo str_replace("\n", '<BR>', $parrafo ); ?>
						</span>
				   </td>
					<td align="center" style="width: 5%;">&nbsp;</td>		   
				</tr>
			</table>
		<?php 
        endforeach;
	

		/*		if (($salto==0) && ($longitud_total > 2300 ) && ($longitud_total <  3140 ) )
				{
					?>
						<br pagebreak="true"/>

					   <tr>
							<td align="center" style="width: 5%;">&nbsp;</td>	   
							<td align="justify" style="width: 90%;">
								<span style="font-size: 12px;">
									<p>&nbsp;</p>
								</span>
						   </td>
							<td align="center" style="width: 5%;">&nbsp;</td>		   
						</tr>

					<?php
				}
		*/		
	
		?>		

	<?php
	}
}

if (!function_exists('cliente_folder_id10'))
{
    function cliente_folder_id10($clave,$user,$cliente,$mis_servicios,$accion_reportar,$accion_mas,$accion_editar,$accion_borrar,$t_nuevo,$t_nuevo_data,$formas,$t_bloque,$t_pdf,$t_edita,$t_borra,$c_os=1)
    {

		if ((in_array(get_perfil_id(), array(1,2,3,4,5,6)))) 
		{

			?><div class="pull-right clearfix"><br><?php
		if ( strstr($mis_servicios,$clave) || strstr($mis_servicios,'TODOS')	||  ($user['usr_id'] == 261) )
				{
			
						if (( 
								(
									strstr($user['acciones'],$accion_mas)
								) 
								&&  
								($cliente['status'] != "NOACTIVO")							
							)
							 ||  ($user['usr_id'] == 261) )
						{ 
							?>
							<a href="<?php echo base_url($t_nuevo.$cliente['clte_id']); ?>" class="btn btn-success btn-xs pull-right"><i class="fa fa-plus"></i><?php echo $t_nuevo_data; ?></a>
							<?php
						}						
					
				} 
				else
				{
					echo "";		
				}	
				?>                                    
			</div>
	<?php }  ?>

	<table class="table table-hover table-striped">
		<thead>
			<tr style="color:black;">
				<?php if ($c_os == 1) { ?>
				<th>OS</th>
				<?php } ?>
				<th>Estudio</th>
				<th>Empresa</th>
				<th align="center">Sesión</th>
				<th>Fecha</th>
				<th>Acciones</th>
			</tr>
		</thead>
		<tbody>
		<?php 
			if($formas):
				foreach($formas as $forma): 
				?>
					<tr style="color:blue;">
						<?php if ($c_os == 1) { ?>
						<td>
							<?php echo $forma['serv_id']; ?>
						</td>
						<?php } ?>
						<td>
							<?php echo $t_bloque; ?>
						</td>
						<td><?php echo get_empresa($forma['emp_id']); ?></td>
						<td align="center" ><?php if ( $forma['fsm_referencia']==1 ) {echo 'Primera Vez';} else { echo $forma['fsm_referencia'];} ?></td>
						<td><?php 
								if (($forma['fsm_f'])  &&  ($forma['fsm_f']!='0000-00-00 00:00:00'))
								{	
									if (strlen($forma['fsm_f']) > 9)
									{
										echo formatea_fechahora($forma['fsm_f']);
									}
									else
									{
										echo formatea_fecha($forma['fsm_f']);	
									}
								}
								elseif (strlen($forma['fecha_eval']) > 9)
								{ 
									echo formatea_fecha($forma['fecha_eval']); 
								}
								else
								{ 
									echo formatea_fechahora($forma['log_insrt_f']);
								}	
							?>
						</td>
						<td>
				<?php 													
						if ((strstr($mis_servicios,$clave) || strstr($mis_servicios,'TODOS')) ||  ($user['usr_id'] == 261) ) 	
						{
							if (( ( strstr($user['acciones'],$accion_reportar) )  )  ||  ($user['usr_id'] == 261) ) 
							{
								?><a target="_blank" href="<?php echo base_url($t_pdf.$cliente['clte_id'].'/'.$forma['fsm_id']); ?>"><i class="fa fa-file-pdf-o fa-fw fa-lg " ></i></a> <?php 
							}
							
							if(get_perfil_id() != 14)
							{ 
								if ( ( ( strstr($user['acciones'],$accion_editar) ) && (!( strstr($t_edita,'NULO') )) )  ||  ($user['usr_id'] == 261) )
								{
									if ( $forma['fsm_editor_cierra'] != 'CIERRA') 
									{
									?> <a href="<?php echo base_url($t_edita.$cliente['clte_id'].'/'.$forma['fsm_id']); ?>"><i class="fa fa-pencil fa-fw fa-lg" style="color:#0000FF;"></i></a> <?php 
								    }
								}
								
								if ( ( ( strstr($user['acciones'],$accion_borrar) ) && (!( strstr($t_borra,'NULO') )) )  ||  ($user['usr_id'] == 261) )
								{ 
									?> <a href="<?php echo base_url($t_borra.$forma['fsm_id']);?>" class="delete"><i class="fa fa-trash-o fa-lg" style="color:#f93822;"> </i></a>	<?php 
								}
							}							
						} 
						else
						{
							echo "&#10004;";		
						}	
						?>
					</td>
				</tr>
				<?php 
				endforeach;
			endif;
		?>
	</tbody>
</table>
<?php			
    }
}



if (!function_exists('cliente_folder_id8'))
{
    function cliente_folder_id8($clave,$user,$cliente,$mis_servicios,$accion_reportar,$accion_mas,$accion_editar,$accion_borrar,$t_nuevo,$t_nuevo_data,$formas,$t_bloque,$t_pdf,$t_edita,$t_borra,$c_os=1)
    {

		if ((in_array(get_perfil_id(), array(1,2,3,4,5,6)))) 
		{

			?><div class="pull-right clearfix"><br><?php
		if ( strstr($mis_servicios,$clave) || strstr($mis_servicios,'TODOS')	||  ($user['usr_id'] == 261) )
				{
			
						if (( 
								(
									strstr($user['acciones'],$accion_mas)
								) 
								&&  
								($cliente['status'] != "NOACTIVO")							
							)
							 ||  ($user['usr_id'] == 261) )
						{ 
							?>
							<a href="<?php echo base_url($t_nuevo.$cliente['clte_id']); ?>" class="btn btn-success btn-xs pull-right"><i class="fa fa-plus"></i><?php echo $t_nuevo_data; ?></a>
							<?php
						}						
					
				} 
				else
				{
					echo "";		
				}	
				?>                                    
			</div>
	<?php }  ?>

	<table class="table table-hover table-striped">
		<thead>
			<tr style="color: black;" >
				<?php 
				if ($c_os == 1) 
				{ 
					if ((strstr($user['portal'],'TRANSPOR;')) || ($user['portal'] == 'TRANSPOR;'))
					{
					?>
						<th>Visita</th>
					<?php
					}
					else
					{
					?>
						<th>OS</th>
					<?php	
					}	
					?>
					
				<?php } ?>
				<th>Estudio</th>
				<th>Empresa</th>
				<th>Fecha</th>
				<th>Acciones</th>
			</tr>
		</thead>
		<tbody>
		<?php 
			if($formas):
				foreach($formas as $forma): 
					if 
						(	
							($clave == 'ACRED')	&&
							(
							 (($forma['fsm_psi'] != 'ON') || 
							 ($forma['fsm_pol'] != 'ON') || 
							 ($forma['fsm_socioeconomico'] != 'ON') || 
							 ($forma['fsm_med'] != 'ON') || 
							 ($forma['fsm_entsoc'] != 'ON') || 
							 ($forma['fsm_toxi'] != 'ON'))
							)
							&&
							(strstr($user['portal'],'TRANSPOR;')) 
						)
						{
						?>
							<tr style="color: red;" >
						<?php
						}	
						else
						{
						?>
							<tr style="color: black;" >
						<?php
						}		
						?>
					
						<?php if ($c_os == 1) { ?>
						<td>
							<?php echo $forma['serv_id']; ?>
						</td>
						<?php } ?>
						<td>
							<?php echo $t_bloque; ?>
						</td>
						<td><?php 
									if ($cliente['root']== 'GSI')
									{
										echo get_empresa_gsi($cliente['emp_id']);										
									}	
									else
									{	
										echo get_empresa($forma['emp_id']);
									}
							?>
							</td>
						<td>
						<?php 
								if (($forma['fsm_f'])  &&  ($forma['fsm_f']!='0000-00-00 00:00:00'))
								{	
									if (strlen($forma['fsm_f']) > 9)
									{
										echo formatea_fechahora($forma['fsm_f']);
									}
									else
									{
										echo formatea_fecha($forma['fsm_f']);	
									}
								}
								elseif (strlen($forma['fecha_eval']) > 9)
								{ 
									echo formatea_fecha($forma['fecha_eval']); 
								}
								else
								{ 
									echo formatea_fechahora($forma['log_insrt_f']);
								}	
							?>
						</td>
						<td>
				<?php 													
						if ((strstr($mis_servicios,$clave) || strstr($mis_servicios,'TODOS')) ||  ($user['usr_id'] == 261) ) 	
						{   
							if (( ( strstr($user['acciones'],$accion_reportar) )  )  ||  ($user['usr_id'] == 261) ) 
							{
								?><a target="_blank" href="<?php echo base_url($t_pdf.$cliente['clte_id'].'/'.$forma['fsm_id']); ?>"><i class="fa fa-file-pdf-o fa-fw fa-lg " ></i></a> <?php 
							}
							
							if(get_perfil_id() != 14)
							{ 
								if ( ( ( strstr($user['acciones'],$accion_editar) ) && (!( strstr($t_edita,'NULO') )) )  ||  ($user['usr_id'] == 261) )
								{
								?> <a href="<?php echo base_url($t_edita.$cliente['clte_id'].'/'.$forma['fsm_id']); ?>"><i class="fa fa-pencil fa-fw fa-lg" style="color:#0000FF;"></i></a> <?php 
								}
								
								if ( ( ( strstr($user['acciones'],$accion_borrar) ) && (!( strstr($t_borra,'NULO') )) )  ||  ($user['usr_id'] == 261) )
								{ 
									?> <a href="<?php echo base_url($t_borra.$forma['fsm_id']);?>" class="delete"><i class="fa fa-trash-o fa-lg" style="color:#f93822;"> </i></a>	<?php 
								}
							}							
						} 
						else
						{
							echo "&#10004;";		
						}	
						?>
					</td>
				</tr>
				<?php 
				endforeach;
			endif;
		?>
	</tbody>
</table>
<?php			
    }
}






if (!function_exists('cliente_folder_id4'))
{
    function cliente_folder_id4($clave,$user,$cliente,$mis_servicios,$myroot2,$user_root3,$user_root4,$t_nuevo,$t_nuevo_data,$formas,$t_bloque,$t_pdf,$t_edita,$t_borra,$c_os=1)
    {

		if ((in_array(get_perfil_id(), array(1,2,3,4,5,6)))) 
		{

			?><div class="pull-right clearfix"><br><?php
				if (strstr($mis_servicios,$clave) || strstr($mis_servicios,'TODOS'))	
				{
					
					if ($cliente['emp_id'] == 31)
					{												
						if ( ($myroot2 == '1') &&  ($cliente['status'] != "NOACTIVO") )
						{
							?>
							<a href="<?php echo base_url($t_nuevo.$cliente['clte_id']); ?>" class="btn btn-success btn-xs pull-right"><i class="fa fa-plus"></i> <?php echo $t_nuevo_data; ?></a>
							<?php
						}
						else
						{
							echo "";		
						}											
					}
					else
					{	
						if ( 
								(
									(($user_root3 < 2) && ($user_root4 != 6)) 
									|| 
									(($user_root3 == 2) && ($user_root4 == 3))
								) 
								&&  
								($cliente['status'] != "NOACTIVO")							
							)
						{ 
							?>
							<a href="<?php echo base_url($t_nuevo.$cliente['clte_id']); ?>" class="btn btn-success btn-xs pull-right"><i class="fa fa-plus"></i><?php echo $t_nuevo_data; ?></a>
							<?php
						}						
					}
				} 
				else
				{
					echo "";		
				}	
				?>                                    
			</div>
	<?php }  ?>

	<table class="table table-hover table-striped">
		<thead>
			<tr style="color: black;">
				<?php if ($c_os == 1) { ?>
				<th>OS</th>
				<?php } ?>
				<th>Estudio</th>
				<th>Empresa</th>
				<th>Fecha</th>
				<th>Acciones</th>
			</tr>
		</thead>
		<tbody>
		<?php 
			if($formas):
				foreach($formas as $forma): 
				?>
					<tr style="color: black;" >
						<?php if ($c_os == 1) { ?>
						<td>
							<?php echo $forma['serv_id']; ?>
						</td>
						<?php } ?>
						<td>
							<?php echo $t_bloque; ?>
						</td>
						<td>
							<?php 
							if ($cliente['root']=='GSI')
							{
								echo get_empresa_gsi($cliente['emp_id']); 
							}
							else
							{
								echo get_empresa($forma['emp_id']); 
							}
							?>						
						</td>
						<td><?php 
								if ($forma['fsm_f'])
								{	
									if (strlen($forma['fsm_f']) > 9)
									{
										echo formatea_fechahora($forma['fsm_f']);
									}
									else
									{
										echo formatea_fecha($forma['fsm_f']);	
									}
								}
								else
								{
									echo formatea_fechahora($forma['log_insrt_f']);
								}	
							?>
						</td>
						<td>
				<?php 														
						if (strstr($mis_servicios,$clave) || strstr($mis_servicios,'TODOS'))	
						{
							if ($cliente['emp_id'] == 31)
							{
								if ($myroot2 == '1')
								{		
									?><a target="_blank" href="<?php echo base_url($t_pdf.$cliente['clte_id'].'/'.$forma['fsm_id']); ?>"><i class="fa fa-file-pdf-o fa-fw fa-lg " style="color:#0000FF;"></i></a><?php	
									if(get_perfil_id() == 1)
									{ 
										if ( ( strstr($user['acciones'],'W+') ) && (!( strstr($t_edita,'NULO') )) )
										{	
											?> <a href="<?php echo base_url($t_edita.$cliente['clte_id'].'/'.$forma['fsm_id']); ?>"><i class="fa fa-pencil fa-fw fa-lg" style="color:#00FF00;"></i></a> <?php 
										}
										
										if ( ( strstr($user['acciones'],'D-') ) && (!( strstr($t_borra,'NULO') )) )
										{ 
											?> <a href="<?php echo base_url($t_borra.$forma['fsm_id']);?>" class="delete"><i class="fa fa-trash-o fa-lg" style="color:#f93822;"> </i></a>	<?php 
										}
									}
								}
								else
								{
									echo "&#10004;";		
								}											
							}
							else
							{		
								?><a target="_blank" href="<?php echo base_url($t_pdf.$cliente['clte_id'].'/'.$forma['fsm_id']); ?>"><i class="fa fa-file-pdf-o fa-fw fa-lg " ></i></a> <?php 
								
								if($user['emp_id'] == 31)
								{ 
									if ( /*( strstr($user['acciones'],'W+') ) && */ (!( strstr($t_edita,'NULO') )) )
									{
									?> <a href="<?php echo base_url($t_edita.$cliente['clte_id'].'/'.$forma['fsm_id']); ?>"><i class="fa fa-pencil fa-fw fa-lg" style="color:#0000FF;"></i></a> <?php 
									}
								}	
									
									
								if($user['usr_id'] == 261)
								{									
									if ( /*( strstr($user['acciones'],'D-') ) && */(!( strstr($t_borra,'NULO') )) )
									{ 
										?> <a href="<?php echo base_url($t_borra.$forma['fsm_id']);?>" class="delete"><i class="fa fa-trash-o fa-lg" style="color:#f93822;"> </i></a>	<?php 
									}
								}
							}
						} 
						else
						{
							echo "&#10004;";		
						}	
						?>
					</td>
				</tr>
				<?php 
				endforeach;
			endif;
		?>
	</tbody>
</table>
<?php			
    }
}


if (!function_exists('cliente_folder'))
{
    function cliente_folder($clave,$user,$cliente,$mis_servicios,$myroot2,$user_root3,$user_root4,$t_nuevo,$t_nuevo_data,$formas,$t_bloque,$t_pdf,$t_edita,$t_borra,$c_os=1,$accion)
    {

		if (((in_array(get_perfil_id(), array(1,2))) || ($user['usr_id']==393) || (strstr($accion,'GRUMLAB'))) && ($user['usr_id'] != 1254) )
		{

			?><div class="pull-right clearfix"><br><?php
			
				if (strstr($mis_servicios,$clave) || strstr($mis_servicios,'TODOS'))	
				{
					
					if (($cliente['emp_id'] == 31) || (strstr($accion,'GRUMLAB')))
					{												
						if (($myroot2 == '1') || (strstr($accion,'GRUMLAB')))
						{
							?>
							<a href="<?php echo base_url($t_nuevo.$cliente['clte_id']); ?>" class="btn btn-success btn-xs pull-right"><i class="fa fa-plus"></i> <?php echo $t_nuevo_data; ?></a>
							<?php
							if ($clave == 'NNUTRI')
							{
							?>
								<a href="<?php echo base_url('Examen/notas_nutricionales/reporx/'.$cliente['clte_id']); ?>" class="btn btn-success btn-xs pull-right"><i class="fa fa-file-excel-o "></i> <?php echo "Reporte"; ?></a>
							<?php
							}	
						}
						else
						{
							echo "";		
						}											
					}
					else
					{	
						if ( 
							 (($user_root3 < 2) && ($user_root4 != 6)) || (($user_root3 == 2) && ($user_root4 == 3)) 
							)
						{ 
							?>
							<a href="<?php echo base_url($t_nuevo.$cliente['clte_id']); ?>" class="btn btn-success btn-xs pull-right"><i class="fa fa-plus"></i><?php echo $t_nuevo_data; ?></a>
							<?php
							if ($clave == 'NNUTRI')
							{
							?>
								<a href="<?php echo base_url('Examen/notas_nutricionales/reporx/'.$cliente['clte_id']); ?>" class="btn btn-success btn-xs pull-right"><i class="fa fa-file-excel-o "></i> <?php echo "Reporte"; ?></a>
							<?php
							}
						}						
					}
				} 
				else
				{
					echo "";		
				}	
				?>                                    
			</div>
	<?php }  ?>

	<table class="table table-hover table-striped">
		<thead>
			<tr style="color: black;" >
				<?php if ($c_os == 1) { ?>
				<th>OS</th>
				<?php } ?>
				<th>Estudio</th>
				<th>Empresa</th>
				<th>Fecha</th>
				<th>Acciones</th>
			</tr>
		</thead>
		<tbody>
		<?php 
			if($formas):
				foreach($formas as $forma): 
				?>
					<tr style="color: black;" >
						<?php if ($c_os == 1) { ?>
						<td>
							<?php echo $forma['serv_id']; ?>
						</td>
						<?php } ?>
						<td>
							<?php echo $t_bloque; ?>
						</td>
						<td><?php echo get_empresa($forma['emp_id']); ?></td>
						<td><?php 
								if ($forma['fsm_f'])
								{	
									if (strlen($forma['fsm_f']) > 9)
									{
										echo formatea_fechahora($forma['fsm_f']);
									}
									else
									{
										echo formatea_fecha($forma['fsm_f']);	
									}
								}
								else
								{
									echo formatea_fechahora($forma['log_insrt_f']);
								}	
							?>
						</td>
						<td>
				<?php 														
						if (strstr($mis_servicios,$clave) || strstr($mis_servicios,'TODOS'))	
						{
							if ($cliente['emp_id'] == 31)
							{
								if  (
								    ($myroot2 == '1') || 
									( strstr($user['modulos'],'HC-RH-GSI') )
									)
								{		
									?><a target="_blank" href="<?php echo base_url($t_pdf.$cliente['clte_id'].'/'.$forma['fsm_id']); ?>"><i class="fa fa-file-pdf-o fa-fw fa-lg " style="color:green;"></i></a><?php	
									if(get_perfil_id() != 4)
									{ 
										if ($t_edita != 'NULO')
										{	
										?> <a href="<?php echo base_url($t_edita.$cliente['clte_id'].'/'.$forma['fsm_id']); ?>"><i class="fa fa-pencil fa-fw fa-lg" style="color:#00FF00;"></i></a> <?php 
										}
									}
									if ($user['usr_id']==261) 
									{ 
										?> <a href="<?php echo base_url($t_borra.$forma['fsm_id']);?>" class="delete"><i class="fa fa-trash-o fa-lg" style="color:#f93822;"> </i></a>	<?php 
									}					
								}
								else
								{
									echo "&#10004;";		
								}											
							}
							else
							{		
								?><a target="_blank" href="<?php echo base_url($t_pdf.$cliente['clte_id'].'/'.$forma['fsm_id']); ?>"><i class="fa fa-file-pdf-o fa-fw fa-lg " ></i></a> <?php 
								
								if(get_perfil_id() != 4)
								{ 
									if ($t_edita != 'NULO')
									{
									?> <a href="<?php echo base_url($t_edita.$cliente['clte_id'].'/'.$forma['fsm_id']); ?>"><i class="fa fa-pencil fa-fw fa-lg" style="color:#0000FF;"></i></a> <?php 
									}
								}
								
								if (($user['usr_id'] == 261) || ($user['usr_id'] == 351) )
								{ 
									?><a href="<?php echo base_url($t_borra.$forma['fsm_id']);?>" class="delete"><i class="fa fa-trash-o fa-lg" style="color:#f93822;"> </i></a> <?php 
								}	
							}
						} 
						else
						{
							echo "&#10004;";		
						}	
						?>
					</td>
				</tr>
				<?php 
				endforeach;
			endif;
		?>
	</tbody>
</table>
<?php			
    }
}


if (!function_exists('get_tipo_de_empresa'))
{
    function get_tipo_de_empresa($emp_id)
    {
        $CI =&get_instance();
		$CI->load->model('empresa/Empresa_model','empresa');
		if ($emp_id!=0)
		{	
        $res=$CI->empresa->get_giro_de_empresa($emp_id);
		return $res;
		}
		else {return 'OTRO';}
    }
}



if (!function_exists('get_empresas_por_giro'))
{
    function get_empresas_por_giro($giro)
    {
        $CI =&get_instance();
		$CI->load->model('empresa/Empresa_model','empresa');
        $res=$CI->empresa->get_empresas_por_giro($giro);
		return $res;
    }
}





if (!function_exists('toma_muestra_id'))
{
    function toma_muestra_id($clte_id,$emp_id)
    {
        $CI =&get_instance();
		$CI->load->model('examen/Toma_muestras_model','muestra');
        
        $res=$CI->muestra->toma_muestra_id($clte_id,$emp_id);
		
		if ($res)
		{
			return $res;
		}	
		else
		{
			return NULL;
		}	
    }
}


if (!function_exists('toma_muestras_sanguineas_id'))
{
    function toma_muestras_sanguineas_id($clte_id,$emp_id)
    {
        $CI =&get_instance();
		$CI->load->model('examen/Toma_muestras_sanguineas_model','muestra');
        
        $res=$CI->muestra->toma_muestra_id($clte_id,$emp_id);
		
		if ($res)
		{
			return $res;
		}	
		else
		{
			return NULL;
		}	
    }
}

if (!function_exists('toma_muestras_orina_id'))
{
    function toma_muestras_orina_id($clte_id,$emp_id)
    {
        $CI =&get_instance();
		$CI->load->model('examen/Toma_muestras_orina_model','muestra');
        
        $res=$CI->muestra->toma_muestra_id($clte_id,$emp_id);
		
		if ($res)
		{
			return $res;
		}	
		else
		{
			return NULL;
		}	
    }
}



if (!function_exists('get_SSPCDMX'))
{
    function get_SSPCDMX($fsm_f)
    {
		
	$fsm_f = strtotime($fsm_f);
			
			if ($fsm_f >= strtotime('2025-04-22 23:00:00') )
			{
				echo '<b>001-25</b>';
			}
			
			elseif ($fsm_f >= strtotime('2024-09-21 23:00:00') && ($fsm_f <= strtotime('2025-04-22 22:59:59')) )
			{
				echo '<b>007-24</b>';
			}

			elseif ($fsm_f >= strtotime('2023-02-21 00:00:00') && ($fsm_f <= strtotime('2024-09-20 22:59:59')) )
			{
				echo '<b>N-004-23</b>';
			}
			elseif ($fsm_f >= strtotime('2022-02-11 00:00:00') && ($fsm_f <= strtotime('2023-02-20 23:59:59')) )
			{
				echo '<b>009-22</b>';
			}
			elseif (($fsm_f >= strtotime('2021-02-15 00:00:00') ) && ($fsm_f <= strtotime('2022-02-10 23:59:59')) )
			{				
				echo '<b>007-21</b>';
			}
			elseif (($fsm_f >= strtotime('2020-02-14 00:00:00')) && ($fsm_f <= strtotime('2021-02-14 23:59:59')))
			{				
				echo '<b>008-20</b>';
			}
			elseif (($fsm_f >= strtotime('2019-02-13 00:00:00')) && ($fsm_f >= strtotime('2020-02-13 23:59:59')))
			{
				echo '<b>009-19</b>';
			}

			elseif (($fsm_f <= strtotime('2019-02-12 23:59:59')))
			{
				echo '<b>005-18</b>';
			}			

		
			
    }
}

	if (!function_exists('get_format_time'))
	{
		function get_format_time($df) {
			$str = '';
			$str .= ($df->invert == 1) ? ' - ' : '';
			if ($df->y > 0) {
				// years
				$str .= ($df->y > 1) ? $df->y . ' Años ' : $df->y . ' Año ';
			} if ($df->m > 0) {
				// month
				$str .= ($df->m > 1) ? $df->m . ' Meses ' : $df->m . ' Mes ';
			} if ($df->d > 0) {
				// days
				$str .= ($df->d > 1) ? $df->d . ' Días ' : $df->d . ' Día ';
			} if ($df->h > 0) {
				// hours
				$str .= ($df->h > 1) ? $df->h . ' Horas ' : $df->h . ' Hora ';
			} if ($df->i > 0) {
				// minutes
				$str .= ($df->i > 1) ? $df->i . ' Minutos ' : $df->i . ' Minuto ';
			} if ($df->s > 0) {
				// seconds
				$str .= ($df->s > 1) ? $df->s . ' Segundos ' : $df->s . ' Segundo ';
			}
			return $str;
		}
	}

	if (!function_exists('get_format_time_day'))
	{
		function get_format_time_day($df) {
			$str = '';
			$str .= ($df->invert == 1) ? ' -' : '';

			if ($df->d >= 0) {
				// days
				$str .= $df->d;
			}
			

			return $str;
		}
	}

	if (!function_exists('diferencia_entre_2_fechas_dias'))
	{
		function diferencia_entre_2_fechas_dias($fecha_inicial='1965-09-20 09:00:00',$fecha_final='2021-11-04 06:00:00')
		{	
			$date1 = new DateTime($fecha_inicial);
			$date2 = new DateTime($fecha_final);
			$diff = $date1->diff($date2);			
			return get_format_time_day($diff);
		}
	}

	
	if (!function_exists('diferencia_entre_2_fechas'))
	{
		function diferencia_entre_2_fechas($fecha_inicial='1965-09-20 09:00:00',$fecha_final='2021-11-04 06:00:00')
		{	
			$date1 = new DateTime($fecha_inicial);
			$date2 = new DateTime($fecha_final);
			$diff = $date1->diff($date2);
			return get_format_time($diff);
		}
	}	
	
	
	if (!function_exists('minutos_diferencia_entre_2_fechas'))
	{
		function minutos_diferencia_entre_2_fechas($fecha_inicial='1965-09-20 09:00:00',$fecha_final='2021-11-04 06:00:00')
		{	
			$date1 = new DateTime($fecha_inicial);
			$date2 = new DateTime($fecha_final);
			$diff = $date1->diff($date2);
			$segundos=0;
			if ($diff->s > 0) {$segundos=1;}
			return ( ($diff->d * 24 ) * 60 )+ ($diff->h * 60 ) + ( $diff->i ) + $segundos;
		}
	}	
	
	

		
	
	if (!function_exists('columnas_indicadores'))
	{
		function columnas_indicadores($titulo,$tiempos)
		{	
			?>	
			<th class="auto-style14"><?php echo $titulo;?></th>
			<?php
			if ($tiempos == 'minutos')
			{
			?>													
			<th class="auto-style14">DV DIA</th>
			<?php  
			} 
			return 1;
		}
	}	




	if (!function_exists('columnas_desvio'))
	{
		function columnas_desvio($tiempos,$cuantos_minutos,$class18,$abierto='',$dv=1440)
		{	
			  $desvio=0;
			  if ($tiempos == 'minutos')
			  {
				$rata=$cuantos_minutos/$dv;

				if ($rata <=1.0) 
				{
					$miranda= $class18;
				} 
				else 
				{  	$desvio=1;
					$miranda= "auto-style33";
				}
				
				if ($abierto != '') {$miranda="auto-style37";}
				
				
				?> <td class=<?php echo $miranda; ?> style="color: #000000;"> <?php 
					echo round($rata,2).' '.$abierto;			
				?>	</td> <?php  
				} 
				return $desvio;
		}
	}



	if (!function_exists('columnas_total_1'))
	{
		function columnas_total_1($tiempos,$contador,$total,$desvio)
		{	
			
			if (($tiempos == 'minutos') && ($contador >0))
			{
			?>
				<th class="auto-style14"><?php echo round($total/$contador);?></th>
				<th class="auto-style35"><?php echo $desvio;?></th>
				
			<?php		
			}
			else
			{
			?>
				<th class="auto-style14"><?php  if ($contador != 0){ echo $contador;} ?></th>
			<?php
			}

		}
	}


	if (!function_exists('columnas_total_2'))
	{
		function columnas_total_2($contador,$total,$desvio)
		{
		?>
			<th class="auto-style14"><?php echo round(((($total/$contador))/60)/24, 1, PHP_ROUND_HALF_EVEN).' Días';?></th>
			<th class="auto-style34"><?php echo 'Cal.Per: '. (100-round(($desvio/$contador)*100,2)).'%';?></th>		
		<?php	
		}
	}
	

	if (!function_exists('esto_es_un_test'))
	{
		function esto_es_un_test()
		{
			$res=0;
			if (strstr(PHP_OS,'WIN')) 
			{ 
				$salida = 'Estoy en WINDOWS';
				//echo "<pre>$salida</pre>";
				$res=1;
			} 
			else 
			{ 
				$salida =  exec('pwd');
				if ($salida == '/var/www/html/hctester')
				{$res=1;}
				//echo "<pre>$salida</pre>";
			}
			
			return $res;
		}
	}


	if (!function_exists('estoy_en_linux'))
	{
		function estoy_en_linux()
		{
			$res=1;
			if (strstr(PHP_OS,'WIN')) 
			{ 
				$salida = 'Estoy en WINDOWS';
				$res=0;
			} 
			return $res;
		}
	}


	if (!function_exists('presion_detalle'))
	{
		function presion_detalle($presion)
		{	
			$resultado='';
			$presion_array= explode('/',$presion);
			
			$presion_sistolica=$presion_array[0];
			$presion_diastolica=$presion_array[1];
			
			if (($presion_sistolica < 120 ) && ($presion_diastolica < 80 ))
			{ $resultado='normal';}
			elseif (($presion_sistolica >= 120 ) && ($presion_sistolica <= 129 ) && ($presion_diastolica < 80 ))
			{$resultado='elevada';}
			elseif ( (($presion_sistolica >= 130 ) && ($presion_sistolica <= 139 )) || (($presion_diastolica >= 80 ) && ($presion_diastolica <= 89 )) )
			{$resultado='alta_hg1';}	
			elseif ( (($presion_sistolica >= 140 ) && ($presion_sistolica < 180 )) || (($presion_diastolica >= 90 ) && ($presion_diastolica < 120 )) )
			{$resultado='alta_hg2';}
			else 
			{$resultado='crisis_impertensa';}
			
		
			return $resultado;
		}		
		 
	}


	if (!function_exists('cabecera_inicio_reporte'))
	{
		function cabecera_inicio_reporte($tema,$empresa,$f_ini_o,$f_fin_o)
		{	
			$resultado='';
			?>
				<table> 
					<thead>
						<tr>
							<th style="width: 64px" class="auto-style5">&nbsp;</th>
							<th style="width: 78px" class="auto-style5">&nbsp;</th>
							<th style="width: 78px" class="auto-style5">&nbsp;</th>
							<th style="width: 393px" class="auto-style5">&nbsp;</th>
							<th style="width: 281px" class="auto-style5">&nbsp;</th>
							<th style="width: 625px" class="auto-style5">&nbsp;</th>
							<th style="width: 95px" class="auto-style5">&nbsp;</th>
								<th style="width: 303px" class="auto-style5">&nbsp;</th>
						</tr>
						<tr>
							<th style="width: 64px" class="auto-style5">&nbsp;</th>
							<th style="width: 78px" class="auto-style5">&nbsp;</th>
							<th style="width: 78px" class="auto-style5">&nbsp;</th>
							<th style="width: 393px" class="auto-style6">
							<strong><span class="auto-style8">human</span><span class="auto-style9">center</span></strong></th>
							<th style="width: 281px" class="auto-style11">&nbsp;</th>
							<th style="width: 625px" class="auto-style12"></th>
							<th style="width: 95px" class="auto-style5">&nbsp;</th>
								<th style="width: 303px" class="auto-style5">&nbsp;</th>
						</tr>
						<tr>
							<th style="width: 64px" class="auto-style5">&nbsp;</th>
							<th style="width: 78px" class="auto-style5">&nbsp;</th>
							<th style="width: 78px" class="auto-style5">&nbsp;</th>
							<th style="width: 393px" class="auto-style6">
							<span class="auto-style19">Online</span><sup><span class="auto-style13" style="color: rgb(34, 34, 34); font-family: arial, sans-serif; font-style: normal; font-variant-ligatures: normal; font-variant-caps: normal; font-weight: 400; letter-spacing: normal; orphans: 2; text-align: left; text-indent: 0px; text-transform: none; white-space: normal; widows: 2; word-spacing: 0px; -webkit-text-stroke-width: 0px; background-color: rgb(255, 255, 255); text-decoration-style: initial; text-decoration-color: initial; display: inline !important; float: none;">®</span></sup></th>

						<?php if ($empresas == '')
						{ ?>
							<th style="width: 281px" class="auto-style16"></th>
							<th style="width: 625px" class="auto-style17"><?php echo '&nbsp;'.$tema.'(s)'; ?></th>	
						<?php }
						else
						{ 												
							?>
							<th style="width: 281px" class="auto-style16"><?php echo '&nbsp;'.$tema.':'; ?>:</th>
							<th style="width: 625px" class="auto-style17">&nbsp;&nbsp;<?php echo get_empresa($empresa); ?></th>							
						<?php 
						} 
						?>

							<th style="width: 95px" class="auto-style5">&nbsp;</th>
							<th style="width: 303px" class="auto-style5">&nbsp;</th>
						</tr>
						<tr>
							<th style="width: 64px" class="auto-style5">&nbsp;</th>
							<th style="width: 78px" class="auto-style5">&nbsp;</th>
							<th style="width: 78px" class="auto-style5">&nbsp;</th>
							<th style="width: 393px" class="auto-style5">&nbsp;</th>
							<th style="width: 281px" class="auto-style16">Del:</th>
							<th style="width: 625px" class="auto-style17">&nbsp;&nbsp;<?php echo formatea_fecha($f_ini_o); ?></th>
							<th style="width: 95px" class="auto-style5">&nbsp;</th>
								<th style="width: 303px" class="auto-style5">&nbsp;</th>
						</tr>
						<tr>
							<th style="width: 64px" class="auto-style5">&nbsp;</th>
							<th style="width: 78px" class="auto-style5">&nbsp;</th>
							<th style="width: 78px" class="auto-style5">&nbsp;</th>
							<th style="width: 393px" class="auto-style5">&nbsp;</th>
							<th style="width: 281px" class="auto-style16">al:</th>
							<th style="width: 625px" class="auto-style17">&nbsp;&nbsp;<?php echo formatea_fecha($f_fin_o); ?></th>
							<th style="width: 95px" class="auto-style5">&nbsp;</th>
								<th style="width: 303px" class="auto-style5">&nbsp;</th>
						</tr>
						<tr>
							<th style="width: 64px" class="auto-style5">&nbsp;</th>
							<th style="width: 78px" class="auto-style5">&nbsp;</th>
							<th style="width: 78px" class="auto-style5">&nbsp;</th>
							<th style="width: 393px" class="auto-style5">&nbsp;</th>
							<th style="width: 281px" class="auto-style16">Generado el día:</th>
							<th style="width: 625px" class="auto-style17">&nbsp;&nbsp;<?php echo date("d/m/y h:i:sa"); ?></th>
							<th style="width: 95px" class="auto-style5">&nbsp;</th>
								<th style="width: 303px" class="auto-style5">&nbsp;</th>
						</tr>
						<tr>
							<th style="width: 64px" class="auto-style5">&nbsp;</th>
							<th style="width: 78px" class="auto-style5">&nbsp;</th>
							<th style="width: 78px" class="auto-style5">&nbsp;</th>
							<th style="width: 393px" class="auto-style5">&nbsp;</th>
							<th style="width: 281px" class="auto-style15">&nbsp;</th>
							<th style="width: 625px" class="auto-style5">&nbsp;</th>
							<th style="width: 95px" class="auto-style5">&nbsp;</th>
							<th style="width: 303px" class="auto-style5">&nbsp;</th>
						</tr>
					</thead>
				</table> 			
			<?php
			return $resultado;
		}		
		 
	}



	if (!function_exists('imc_detalle'))
	{
		function imc_detalle($imc)
		{	
			$resultado='';
			

			if ( $imc == 'N/A')
			{ $resultado='';}
			elseif ( $imc < 18.49)
			{$resultado='peso_bajo';}
			elseif ( $imc >= 18.50 && $imc <= 24.99)
			{$resultado='peso_normal';}	
			elseif ( $imc >= 25.00 && $imc <= 29.99)
			{$resultado='sobrepeso';}
			elseif ( $imc >= 30.00 && $imc <= 34.99)
			{$resultado='obesidad_leve';}
			elseif ( $imc >= 35.00 && $imc <= 39.99)
			{$resultado='obesidad_media';}
			else
			{$resultado='obesidad_morbida';}			
		
			return $resultado;
		}		
		 
	}




	if (!function_exists('list_to_array_cat'))
	{
		function list_to_array_cat($alergias)
		{	

			//depuración
			$alergias = str_replace(",,", ",", $alergias);
			$alergias = str_replace(", ", ",", $alergias);
			$alergias = str_replace(" , ", ",", $alergias);
			$alergias = str_replace(" ,", ",", $alergias);
			$alergias = str_replace("OO", "O", $alergias);
			$alergias = str_replace(" Y ", ",", $alergias);
			$alergias = str_replace("NINGUNO", "NEGADAS", $alergias);
			$alergias = str_replace("NEGATIVO", "NEGADAS", $alergias);
			$alergias = str_replace("NAGAGAS", "NEGADAS", $alergias);
			$alergias = str_replace("NAGADAS", "NEGADAS", $alergias);
			$alergias = str_replace("NEGADA,", "NEGADAS,", $alergias);
			$alergias = str_replace("NEGADO,", "NEGADAS,", $alergias);
			$alergias = str_replace("NEGADOS,", "NEGADAS,", $alergias);
			
			//la lista se convierte en array
			$alergias_array= explode(',',$alergias);

			//se realiza el conteo de los elementos	
			$alergias_array_conteo= array_count_values($alergias_array);
			
			
			//$diagnosticos_array_conteo_ordenado=$diagnosticos_array_conteo;
			//asort($diagnosticos_array_conteo_ordenado, SORT_STRING | SORT_FLAG_CASE | SORT_NATURAL);
			
			$resultados = print_r($alergias_array_conteo, true);
			$resultados_alergias_array = print_r($alergias_array, true);
		
			//se obtiene catalogo
			$cat_alergias=array_keys($alergias_array_conteo);
			$cuantos_tipos=count($cat_alergias);
			//se homogenizan los datos
			    $index_ale=0;
				
				for($jj=0; $jj < $cuantos_tipos; $jj++)
				{
					if ($cat_alergias[$jj] != '')
					{	
						$ale_stat[$index_ale]['cat_nombre']=$cat_alergias[$jj];
						$ale_stat[$index_ale]['cuantos']=$alergias_array_conteo[$cat_alergias[$jj]];
					?>
					<!--	<tr>
							<td><?php echo $ale_stat[$index_ale]['cat_nombre'].':'?></td><td align="center" ><?php echo $ale_stat[$index_ale]['cuantos'];?></td>
						</tr> -->
					<?php	
						$index_ale++;
					}
				}


			

			//se ordenan los datos de acuerdo a cuantos
			$cuantos = array_column($ale_stat, 'cuantos');
			array_multisort($cuantos, SORT_DESC, $ale_stat);

			return $ale_stat;
		}		
		 
	}


	if (!function_exists('list_to_array_cat_dx'))
	{
		function list_to_array_cat_dx($diagnosticos)
		{	

			//depuración
			$diagnosticos = str_replace("|||||", "|", $diagnosticos);
			$diagnosticos = str_replace("||||", "|", $diagnosticos);
			$diagnosticos = str_replace("|||", "|", $diagnosticos);
			$diagnosticos = str_replace("||", "|", $diagnosticos);

			//la lista se convierte en array
			$diagnosticos_array= explode('|',$diagnosticos);

			//se realiza el conteo de los elementos	
			$diagnosticos_array_conteo= array_count_values($diagnosticos_array);
			
			
			//$diagnosticos_array_conteo_ordenado=$diagnosticos_array_conteo;
			//asort($diagnosticos_array_conteo_ordenado, SORT_STRING | SORT_FLAG_CASE | SORT_NATURAL);
			
			//$resultados = print_r($diagnosticos_array_conteo, true);
			//$resultados1 = print_r($diagnosticos_array_conteo_ordenado, true);
		
			//se obtiene la base CIE_10
			   //$cat_dx=get_cat_list_by_grupo('CIE_10');
			
			
			$cat_diagnosticos=array_keys($diagnosticos_array_conteo);
			$cuantos_tipos=count($cat_diagnosticos);
			
			
			//se homogenizan los datos
			    $index_ale=0;				
				for($jj=0; $jj < $cuantos_tipos; $jj++)
				{
					if ($cat_diagnosticos != '')
					{	
						$dx_stat[$index_ale]['cat_nombre']=$cat_diagnosticos[$jj];
						$dx_stat[$index_ale]['cuantos']=$diagnosticos_array_conteo[$cat_diagnosticos[$jj]];
						$index_ale++;
					}
				}			
			
			
			/*$index_dx=0;
			foreach($cat_dx  as $dx)
			{
				
				if ($diagnosticos_array_conteo[$dx['cat_cve']] > 0)
				{
					$dx_stat[$index_dx]['cat_cve']=$dx['cat_cve'];
					$dx_stat[$index_dx]['cat_nombre']=$dx['cat_nombre'];
					$dx_stat[$index_dx]['cuantos']=$diagnosticos_array_conteo[$dx['cat_cve']];
					$index_dx++;
				}
			}*/

			//se ordenan los datos de acuerdo a cuantos
			$cuantos = array_column($dx_stat, 'cuantos');
			array_multisort($cuantos, SORT_DESC, $dx_stat);

			return $dx_stat;
		}		
		 
	}



if (!function_exists('select_pdf_examen'))
{
    function select_pdf_examen($examen,$fsm_id,$clte_id,$emp_id)
    {

		$accion='';
		$parametros=$clte_id.'/'.$fsm_id;

		if ($examen ==  'PFIIBX+') 	
		{$accion='Examen/quimica_sanguinea_bx/pdf_pfii/';}
		elseif ($examen ==  'QSBX+') 
		{ $accion='Examen/quimica_sanguinea_bx/pdf/';	}
		elseif ($examen == '3L35ER1C0S')
		{ $accion='Examen/electrolitos_sericos/pdf/';
		}elseif ($examen == 'R3P51C')
		{ $accion='Examen/psicologico/pdfr/';
		}elseif ($examen == 'H0N3')
		{ $accion='Examen/hone_aicm/pdf_aicm/';
		}elseif ($examen == 'SSESTSOC')
		{ $accion='Examen/SS/Ssestsoc/pdf/';
		}elseif ($examen == 'PS1C3XT')
		{ $accion='Examen/psicologico/pdfext/';
		}elseif ($examen == 'HIV')
		{ $accion='Examen/hiv/pdf/';
		}elseif ($examen == 'QSMTY')
		{ $accion='Examen/quimica_sanguineasmty/pdfr/';
		}elseif ($examen == 'TOMAM')
		{ $accion='Examen/toma_muestras/pdfr/';
		}elseif ($examen == 'HMEDXFIS')
		{ $accion='Examen/medico_fisico_ext/pdf/';
		}elseif ($examen == 'QS38')
		{ $accion='Examen/quimica_sanguinea38/pdf/';
		}elseif ($examen == 'QS24')
		{
			$accion='Examen/quimica_sanguinea24/pdf/';
        }elseif ($examen == 'QS15')
		{
			$accion='Examen/quimica_sanguinea15/pdf/';
        }elseif ($examen == 'QS12')
		{
			$accion='Examen/quimica_sanguinea12/pdf/';
        }elseif ($examen == 'QS6')
		{
			$accion='Examen/quimica_sanguinea6/pdf/';
        }elseif ($examen == 'QS3')
		{
			$accion='Examen/quimica_sanguinea3/pdf/';
        }elseif ($examen == 'QS27')
		{
			$accion='Examen/quimica_sanguinea27/pdf/';
        }elseif ($examen == 'COV19R')
		{
			$accion='Examen/covid/pdf/';
        }elseif ($examen == 'COVID')
		{
			$accion='archivos/descarga/docs/';
        }elseif ($examen == 'RADIOT')
		{
			$accion='archivos/descarga/docs/';
        }elseif ($examen == 'RADIOL')
		{
			$accion='archivos/descarga/docs/';
        }elseif ($examen == 'RADIO_SAP')
		{
			$accion='archivos/descarga/docs/';
        }elseif ($examen == 'RADIO_LAT')
		{
			$accion='archivos/descarga/docs/';
        }elseif ($examen == 'PAPAN')
		{
			$accion='archivos/descarga/docs/';
        }elseif ($examen == 'AUDIO')
		{
			$accion='archivos/descarga/docs/';
        }elseif ($examen == 'PUESIC')
		{
			$accion='archivos/descarga/docs/';
        }elseif ($examen == 'INTE')
		{
			$accion='archivos/descarga/docs/';
        }elseif ($examen == 'PENSA')
		{
			$accion='archivos/descarga/docs/';
        }elseif ($examen == 'ENTFIN')
		{
			$accion='archivos/descarga/docs_especiales/';
        }elseif ($examen == 'VISTA')
		{
			$accion='archivos/descarga/docs/';
        }elseif ($examen == 'ELECTRO')
		{
			$accion='archivos/descarga/docs/';
        }elseif ($examen == 'ACRED')
		{
			$accion='Examen/acreditacion/pdf/';
        }
		elseif (strstr($examen, 'ALCOHOL'))
		{
			$accion='Examen/alcohol/pdf/';
        }		
		elseif ($examen == 'TOXIW')
		{
			$accion='Examen/toxicologico12/pdf/';
        }elseif ($examen == 'TOXI')
		{
			$accion='Examen/toxicologico/pdf/';
        }elseif ($examen == 'TOXIS')
		{
			$accion='Examen/toxicologico7/pdf/';
        }elseif ($examen == 'TOXIX')
		{
			$accion='Examen/toxicologico6/pdf/';
        }elseif ($examen == 'TOXIT')
		{
			$accion='Examen/toxicologico3/pdf/';
        }elseif ($examen == 'PSIC')
		{
			$accion='Examen/psicologico/pdfr_simple/';
        }elseif ($examen == 'MEDFIS')
		{
			$accion='Examen/medico_fisico/pdf/';
        }elseif ($examen == 'SOCIE')
		{	
			if ( $emp_id == 136)
			{
				$accion='Examen/SS/Ssestsoc/pdf/';
			}
			else
			{		
				$accion='Examen/socioeconomico/pdf/';
			}
        }elseif ($examen == 'ENTSOC')
		{
				$accion='Examen/entorno_social/pdf/';
        }elseif ($examen == 'CED')
		{
				$accion='Examen/poligrafico/pdf/';
        }elseif ($examen == 'POL')
		{
				$accion='Examen/poligrafico/pdf/';
        }elseif ($examen == 'HIST')
		{
				$accion='Examen/historia_clinica/pdf/';
        }elseif ($examen == 'TOXIN')
		{
				$accion='Examen/prueba/pdf/';
        }elseif ($examen == 'ESTSOC')
		{
				$accion='Examen/Essoec/pdf/';
        }elseif ($examen == 'QUISAN')
		{
				$accion='Examen/quimica_sanguinea/pdf/';
        }elseif ($examen == 'ORINA')
		{
				$accion='Examen/orina/pdf/';

        }elseif ($examen == 'BIOHEM')
		{
				$accion='Examen/biometria_hematica/pdf/';
        }elseif ($examen == 'GPOSAN')
		{
				$accion='Examen/grupo_sanguineo/pdf/';
        }elseif ($examen == 'REPSIC')
		{
				$accion='Examen/psicologico/pdfr/';
        }elseif ($examen == 'EYED')
		{
				$accion='Examen/eye_detect/pdf/';
        }elseif ($examen == 'PIE')
		{
				$accion='Examen/pie/pdf/';
        }elseif ($examen == 'ODO')
		{
				$accion='Examen/FSM_ODON/Essoec/pdfhco/';		
        }elseif (($examen == 'fpfh0105') ||  ($examen == 'FSM0105'))  
		{
			if ( $emp_id == 49)
			{
				$accion='Examen/HCSEPSA/Hcsepsa/pdf/';
			}
			else
			{
				$accion='Examen/FPFH-01-05/Essoec/pdf/';
			}	
				
        }elseif ($examen == 'SOCLAB')
		{
				$accion='Examen/sociolaboral/pdf/';
        }elseif (($examen == 'ALCOHOL') && ($i=0))
		{			
				$acci0n='Examen/alcohol/pdf/';
		}
		elseif ($examen == 'FEBRILES')
		{			
				$accion='Examen/reacciones/pdf/';
		}
		elseif ($examen == 'PROST')
		{			
				$accion='Examen/prost/pdf/';
		}
		elseif ($examen == 'HBSAG')
		{			
				$accion='Examen/hbsag/pdf/';
		}
		elseif ($examen == 'HCAP')
		{			
				$accion='Examen/hcap/pdf/';
		}		
		elseif ($examen == 'HBA1C')
		{			
				$accion='Examen/hba1c/pdf/';
		}
		elseif ($examen == 'CONTIN')
		{			
				$accion='Examen/cotinina/pdf/';
		} 
		elseif ($examen == 'EXUF')
		{			
				$accion='Examen/exudado/pdf/';
		}
		elseif ($examen == 'VIH')
		{			
				$accion='Examen/vih/pdf/';
		}
		elseif ($examen == 'IMUNO')
		{			
				$accion='Examen/imuno/pdf/';
		}		
		
		
		
		
		
		
		
		
		elseif ($examen == 'CPROPA')
		{//CPROPA	COPROPARASITOSCOPICO 			

		}elseif ($examen == 'CPROCU')
		{//CPROCU 	COPROCULTIVO							

		}elseif ($examen == 'QS6')
		{//QS6 	QUIMICA SANGUINEA DE 6
				$accion='Examen/quimica_sanguinea6/pdf/';
		}elseif ($examen == 'AAFQ')
		{//AAFQ 	ANALISIS DE AGUA FISICO-QUIMICO					

		}elseif ($examen == 'AHFQ')
		{//AHFQ 	ANALISIS DE HIELO FISICO-QUIMICO		

		}elseif ($examen == 'KOHU')
		{
		}elseif ($examen == 'CSVIVA')
		{//CSVIVA 	CULTIVO DE SUPERFICIE VIVA			

		}elseif ($examen == 'CSINERTE')
		{//CSINERTE 	CULTIVO DE SUPERFICIE INERTE			

		}elseif ($examen == 'CACRUDO')
		{//CACRUDO 	CULTIVO DE ALIMENTO CRUDO		

		}elseif ($examen == 'CACOCIDO')
		{//CACOCIDO 	CULTIVO DE ALIMENTO COCIDO				

		}elseif ($examen == 'ABA')
		{			

		}elseif ($examen == 'COVID19')
		{			

		}
		elseif ($examen == 'ABH')
		{			

			//$sql=$sql." limit 1";
		}elseif ($examen == 'PSSIM')
		{			
				$accion='Examen/psicologico/pdf_simple/';
		}elseif ($examen == 'HONE')
		{			
				$accion='archivos/descarga/docs/';
		}elseif ($examen == 'COMPO')
		{			
				$accion='archivos/descarga/docs/';
		}elseif ($examen == 'TOXIV')
		{			

		
		}else
		{
			 return NULL;
		}

		
		return $accion.$parametros;
    }
}



if (!function_exists('select_table_examen_form'))
{
    function select_table_examen_form($examen)
    {  

		//$CI =&get_instance();
		//$CI->load->model('cat/Catalogo_model','catalogo');
		

		$accion='';
		
		//$accion_2=$CI->catalogo->get_cat_nombre_unico('EXA_TABLA','TABLA',$examen);
		
		
	
		if ($examen ==  'HCSYNGENTA') 
		{ 
			$accion='fsm_hcsyngenta';
		}		
		elseif ($examen ==  'SOCIO_SERV') 
		{ 
			$accion='socioeconomico';
		}
		elseif ($examen ==  'SOCIO_RES') 
		{ 
			$accion='socio_resultado';
		}
		elseif ($examen ==  'INSU_BASAL') 
		{ 
			$accion='fsm_insulina_basal';
		}
		elseif ($examen ==  'COLISER') 
		{ 
			$accion='fsm_colinesterasa_serica';
		}
		elseif ($examen ==  'TOMAADS') 
		{ 
			$accion='fsm_toma_muestras_sanguineas_adicional';
		}
		elseif ($examen ==  'TOMAADO') 
		{ 
			$accion='fsm_toma_muestras_orina_adicional';
		}
		elseif ($examen ==  'EXMEPER') 
		{ 
			$accion='fsm_exmeper';
		}
		elseif ($examen ==  'PFIIBX+') 
		{ 
			$accion='fsm_quimica_sanguinea_bx_pfii';
		}
		elseif ($examen ==  'QSBX+') 
		{ 
			$accion='fsm_quimica_sanguinea_bx';
		}
		elseif ($examen ==  'ISOEXMESAOC') 
		{ 
			$accion='fsm_isoexmesaoc';
		}
		elseif ($examen ==  'HICLOEO') 
		{ 
			$accion='fsm_hicloeo';
		}
		elseif ($examen ==  'PERFPSC') 
		{ 
			$accion='fsm_psicologico_perfil';
		}
		elseif ($examen ==  'POL') 
		{ 
			$accion='fsm_poligrafico';
		}
		elseif ($examen ==  'CED') 
		{ 
			$accion='fsm_poligrafico';
		}
		elseif ($examen ==  'NOM0353') 
		{ 
			$accion='fsm_nom035iii';
		}
		elseif ($examen ==  'NOM0352' ) 
		{ 
			$accion='fsm_nom035ii';
		}
		elseif ($examen ==  'NOM0351')
		{ 
			$accion='fsm_nom035';
		}
		elseif ($examen == '3L35ER1C0S')
		{ 
			$accion='fsm_electrolitos_sericos';
		}
		elseif ($examen == 'NUNIPSICO')
		{ 
			$accion='fsm_nota_uni_psicologica';
		}
		elseif ($examen == 'NUNIMEDICA')
		{ 
			$accion='fsm_nota_uni_medica';
		}
		elseif ($examen == 'R3P51C')
		{ 
			$accion='fsm_psicologico_2';
		}
		elseif ($examen == 'QRC0NF')
		{ 
			$accion='fsm_qrconfianza';
		}
		elseif ($examen == 'PERCRO')
		{ 
			$accion='fsm_percepcion_cromatica';
		}
		elseif ($examen == 'H0N3')
		{ 
			$accion='fsm_hone_aicm';
		}
		elseif ($examen == 'SSESTSOC')
		{ 
			$accion='fsm_ss_estsoc';
		}
		elseif ($examen == 'HICL030')
		{ 
			$accion='fsm_hicl030';
		}
		elseif ($examen == 'PS1C3XT')
		{ 
			$accion='fsm_psicologico';
		}
		elseif ($examen == 'P551M')
		{ 
			$accion='fsm_psicologico_4';
		}
		elseif ($examen == 'ARVP')
		{ 
			$accion='fsm_arvp';
		}
		elseif ($examen == 'FLOTILLA')
		{ 
			$accion='fsm_flotilla';
		}
		elseif ($examen == 'HICL030')
		{ 
			$accion='fsm_hicl030';
		}
		elseif ($examen == 'ACRED')
		{ 
			$accion='fsm_acreditacion';
		}
		elseif ($examen == 'PLOMO')
		{ 
			$accion='fsm_plomo';
		}
		elseif ($examen == 'QSGRAL')
		{ 
			$accion='fsm_quimica_sanguinea_g_seguros';
		}
		elseif ($examen == 'TOMAS')
		{ 
			$accion='fsm_toma_muestras_sanguineas';
		}
		elseif ($examen == 'TOMAO')
		{ 
			$accion='fsm_toma_muestras_orina';
		}
		elseif ($examen == 'EXUF')
		{ 
			$accion='fsm_exudado';
		}
		elseif ($examen == 'QSGNP')
		{ 
			$accion='fsm_quimica_sanguineagnp';
		}
		elseif ($examen == 'TOX01')
		{ 
			$accion='fsm_toxicologico3';
		}
		elseif ($examen == 'QSINSIGNIA')
		{ 
			$accion='fsm_quimica_sanguinea_insignia';
		}
		elseif ($examen == 'QSALLZ')
		{ 
			$accion='fsm_quimica_sanguineaall';
		}
		elseif ($examen == 'QSMTY')
		{ 
			$accion='fsm_quimica_sanguineasmty';
		}
		elseif ($examen == 'TOMAM')
		{ 
			$accion='fsm_toma_muestras';
		}
		elseif ($examen == 'NPSICO')
		{ 
			$accion='fsm_nota_psicologica';
		}
		elseif ($examen == 'CERTMED')
		{ 
			$accion='fsm_certificado_medico';
		}
		elseif ($examen == 'CURSOHC')
		{ 
			$accion='fsm_curso';
		}
		elseif ($examen == 'VPPRO02')
		{ 
			$accion='fsm_venta_producto02 ';
		}
		elseif ($examen == 'VPPRO01')
		{ 
			$accion='fsm_venta_producto ';
		}
		elseif ($examen == 'HMEDXFIS')
		{ 
			$accion='fsm_medico_fisico_ext';
		}
		elseif ($examen == 'QS38')
		{ 
			$accion='fsm_quimica_sanguinea38';
		}
		elseif ($examen == 'QS24')
		{
			$accion='fsm_quimica_sanguinea24';
        }
		elseif ($examen == 'QS15')
		{
			$accion='fsm_quimica_sanguinea15';
        }elseif ($examen == 'QS12')
		{
			$accion='fsm_quimica_sanguinea12';
        }elseif ($examen == 'QS6')
		{
			$accion='fsm_quimica_sanguinea6';
        }elseif ($examen == 'QS3')
		{
			$accion='fsm_quimica_sanguinea3';
        }elseif ($examen == 'QS27')
		{
			$accion='fsm_quimica_sanguinea27';
        }elseif ($examen == 'COV19R')
		{
			$accion='fsm_covid';
        }elseif ($examen == 'TOXIW')
		{
			$accion='fsm_toxicologico12';
        }elseif ($examen == 'TOXIX')
		{
			$accion='fsm_toxicologico6';
        }elseif ($examen == 'TOXI')
		{
			$accion='fsm_toxicologico';
        }elseif ($examen == 'TOXIS')
		{
			$accion='fsm_toxicologico7';
        }elseif ($examen == 'TOXIT')
		{
			$accion='fsm_toxicologico3';
        }elseif ($examen == 'PSIC')
		{
			$accion='fsm_psicologico';
        }elseif ($examen == 'MEDFIS')
		{
			$accion='fsm_medico_fisico';
        }elseif ($examen == 'SOCIE')
		{	
			if ( $emp_id == 136)
			{
				$accion=''; //$accion='Examen/SS/Ssestsoc/pdf/';
			}
			else
			{		
				$accion='socio_eco';//$accion='Examen/socioeconomico/pdf/';
			}
        }elseif ($examen == 'SOCIE_VISITA')
		{	
			if ( $emp_id == 136)
			{
				$accion=''; //$accion='Examen/SS/Ssestsoc/pdf/';
			}
			else
			{		
				$accion='socio_eco';//$accion='Examen/socioeconomico/pdf/';
			}
        }
		elseif ($examen == 'ENTSOC')
		{
				$accion='entorno_soc';
        }elseif ($examen == 'CED')
		{
				$accion='fsm_poligrafico';
        }elseif ($examen == 'POL')
		{
				$accion='fsm_poligrafico';
        }elseif ($examen == 'HIST')
		{
				$accion='fsm_historia_clinica';
        }elseif ($examen == 'TOXIN')
		{
				$accion='';
        }elseif ($examen == 'ESTSOC')
		{
				$accion='esc';
        }elseif ($examen == 'QUISAN')
		{
				$accion='fsm_quimica_sanguinea';
        }elseif ($examen == 'ORINA')
		{
				$accion='fsm_orina';

        }elseif ($examen == 'BIOHEM')
		{
				$accion='fsm_biometria_hematica';
        }elseif ($examen == 'GPOSAN')
		{
				$accion='fsm_grupo_sanguineo';
        }elseif ($examen == 'REPSIC')
		{
				$accion='fsm_psicologico_2';
        }elseif ($examen == 'EYED')
		{
				$accion='fsm_eye_detect';
        }elseif ($examen == 'PIE')
		{
				$accion='fsm_pie';
        }elseif ($examen == 'ODO')
		{
				$accion='fsm_odon';		
        }elseif (($examen == 'fpfh0105') ||  ($examen == 'FSM0105'))  
		{
				$accion='fpfh_01_05';
        }elseif ($examen == 'SOCLAB')
		{
				$accion='fsm_sociolab';
        }elseif ($examen == 'ALCOHOL')
		{			
				$accion='fsm_alcohol';
		}elseif ($examen == 'PSSIM')
		{			
				$accion='fsm_psicologico_3'; 
		}
		elseif ($examen == 'FEBRILES')
		{			
				$accion='fsm_reacciones'; 
		}
		elseif ($examen == 'PROST')
		{			
				$accion='fsm_prost'; 
		}
		elseif ($examen == 'HBSAG')
		{			
				$accion='fsm_hbsag'; 
		}
		elseif ($examen == 'HCAP')
		{			
				$accion='fsm_hcap'; 
		}		
		elseif ($examen == 'HBA1C')
		{			
				$accion='fsm_hba1c';
		}
		elseif ($examen == 'CONTIN')
		{			
				$accion='fsm_cotinina'; 
		} 
		elseif ($examen == 'EXUF')
		{			
				$accion='fsm_exudado'; 
		}
		elseif ($examen == 'VIH')
		{			
				$accion='fsm_vih'; 
		}
		elseif ($examen == 'IMUNO')
		{			
				$accion='fsm_imuno'; 
		}
		elseif ($examen == 'CSVIVA')
		{			
				$accion='fsm_csvivo'; 
		}
		elseif ($examen == 'CSINERTE')
		{			
				$accion='fsm_csinerte'; 
		}

		elseif ($examen == 'CACRUDO')
		{			
				$accion='fsm_cacrudo'; 
		}
		elseif ($examen == 'CACOCIDO')
		{			
				$accion='fsm_cacocido'; 
		}		

		elseif ($examen == 'ABA')
		{			
				$accion='fsm_aba'; 
		}
		elseif ($examen == 'ABH')
		{			
				$accion='fsm_abh'; 
		}

		elseif ($examen == 'HIV')
		{			
				$accion='fsm_hiv'; 
		}

		elseif ($examen == 'CPROPA')
		{			
				$accion='fsm_cps'; 
		}		
		elseif ($examen == 'CPROCU')
		{			
				$accion='fsm_cprocu'; 
		}elseif ($examen == 'CULTUN')
		{			
			$accion='fsm_cultun';
		}
		elseif ($examen == 'ADROGA')
		{			
			$accion='fsm_adroga';
		}elseif ($examen == 'VDRL')
		{			
				$accion='fsm_vdrl';
		}else
		{
			$accion='';
		}	
		
		//$accion=$accion_2;
		//echo '|'.$accion_2.'|';
		
		return $accion;
    }
}


if (!function_exists('select_table_examen_docs'))
{
    function select_table_examen_docs($examen)
    {

		$accion='';
		//$accion=get_1("EXA_TABLA","TABLA",$examen);
		
		if ($examen == 'SOCDIGLAB')
		{
			$accion='sis12_generico_doc';
        }
		elseif ($examen == 'ENTFIN')
		{
			$accion='sis12_generico_doc';
        }
		elseif ($examen == 'CAMA000') 
		{   
			$accion='sis12_cama000_doc';
		}
		elseif ($examen == 'INREFLA') 
		{   
			$accion='sis12_generico_doc';
		}
		elseif ($examen == 'BENDER') 
		{   
			$accion='sis12_generico_doc';
		}
		elseif ($examen == 'EVADIATM') 
		{   
			$accion='sis12_evaluacion_final_doc';
		}
		elseif ($examen == 'EVAFINATM') 
		{    
			$accion='sis12_evaluacion_diagnostica_doc';
		}
		elseif ($examen == 'R3N00D') 
		{   
			$accion='sis13_renodo';
		}
		elseif ($examen == 'R3N3X4M3D') 
		{    
			$accion='sis13_renexamed';
		}
		elseif ($examen == 'R3NT00X') 
		{ 
			$accion='sis13_rentoxi';
	    }
		elseif ($examen == 'R3NP52') 
		{ 
			$accion='sis13_renpsico';
		}
		elseif ($examen== 'R3NP3RF') 
		{  
			$accion='sis13_renperfiles';
		}
		elseif ($examen== 'R3N3NTS0C') 
		{	 
			$accion='sis13_renentsol';
		}		
		elseif ($examen == 'R4V3N')
		{
			$accion='sis12_raven_doc';
        }elseif ($examen == 'WNTPZI')
		{
			$accion='sis12_entrevista_doc';
        }elseif ($examen == 'PRPRO')
		{
			$accion='sis12_proyectivas_doc';
        }elseif ($examen == 'TERMAN')
		{
			$accion='sis12_terman_doc';
        }elseif ($examen == 'CLEAVER')
		{
			$accion='sis12_cleaver_doc';
        }elseif ($examen == 'EGEREN')
		{
			$accion='sis12_egeren_doc';
        }elseif ($examen == 'V3ND3D0R')
		{
			$accion='sis13_vendedor_doc';
        }elseif ($examen == 'P3NS4NT3')
		{
			$accion='sis13_pensante_doc';
        }elseif ($examen == 'PPSM16PF')
		{
			$accion='sis12_ppsm16mf_doc';
        }elseif ($examen == 'RADIOM')
		{
			$accion='sis12_radiom_doc';
        }elseif ($examen == 'CMCARGA')
		{
			$accion='sis12_certificado_doc';
        }elseif ($examen == 'PUESIC;')
		{
			$accion='sis12_pruebas_psico_doc';
        }elseif ($examen == 'PLLMO')
		{
			$accion='sis12_plomo_doc';
        }elseif ($examen == 'GRALSEXMED')
		{
			$accion='sis12_sgmty_doc';
        }elseif ($examen == 'CAMA005')
		{
			$accion='sis12_cama005_doc';
        }elseif ($examen == 'CAMA004')
		{
			$accion='sis12_cama004_doc';
        }elseif ($examen == 'CAMA003')
		{
			$accion='sis12_cama003_doc';
        }elseif ($examen == 'CAMA002')
		{
			$accion='sis12_cama002_doc';
        }elseif ($examen == 'CAMA001')
		{
			$accion='sis12_cama001_doc';
        }elseif ($examen == 'EGEREN')
		{
			$accion='sis12_egeren_doc';
        }elseif ($examen == 'PENSA')
		{
			$accion='sis12_pensa_doc';
        }elseif ($examen == 'GNPMED')
		{
			$accion='sis12_sgmty_doc';
        }elseif ($examen == 'INSIGEXMED')
		{
			$accion='sis12_sgmty_doc';
        }elseif ($examen == 'LEGAL')
		{
			$accion='sis12_legal_doc';
        }elseif ($examen == 'OPTOM')
		{
			$accion='sis12_optom_doc';
        }elseif ($examen == 'HHCC')
		{
			$accion='sis12_hhcc_doc';
        }elseif ($examen == 'SGMTY')
		{
			$accion='sis12_sgmty_doc';
        }elseif ($examen == 'ALLIANZ')
		{
			$accion='sis12_sgmty_doc';
        }elseif ($examen == 'ANTICUA')
		{
			$accion='sis12_anticua_doc';
        }elseif ($examen == 'ALCOSA')
		{
			$accion='sis12_alcosa_doc';
        }elseif ($examen == 'PCR')
		{
			$accion='sis12_pcr_doc';
        }elseif ($examen == 'TORAX')
		{
			$accion='sis12_torax_doc';
        }elseif ($examen == 'EVACOM')
		{
			$accion='sis12_evacom_doc';
        }elseif (($examen == 'RECODO') || ($examen == 'CONODO'))
		{
			$accion='sis10_clientes_gen_doc';
        }elseif ($examen == 'EXMEDDS')
		{
			$accion='sis12_examm_ds_doc';
        }elseif ($examen == 'LABDS')
		{
			$accion='sis12_laboratorio_ds_doc';
        }elseif ($examen == 'COVID')
		{
			$accion='sis12_covid_doc';
        }elseif ($examen == 'RADIOT')
		{
			$accion='sis12_radiot_doc';
        }elseif ($examen == 'RADIOL')
		{
			$accion='sis12_radiol_doc';
        }elseif ($examen == 'RADIO_SAP')
		{
			$accion='sis12_radio_sap_doc';
        }elseif ($examen == 'RADIO_LAT')
		{
			$accion='sis12_radio_lat_doc';
        }
		elseif ($examen == 'PAPAN')
		{
			$accion='sis12_papan_doc';
        }elseif ($examen == 'AUDIO')
		{
			$accion='sis12_audio_doc';
        }elseif ($examen == 'PUESIC')
		{
			$accion='sis12_pruebas_psico_doc';
        }elseif ($examen == 'INTE')
		{
			$accion='sis12_inte_doc';
        }elseif ($examen == 'PENSA')
		{
			$accion='sis12_pensa_doc';
        }elseif ($examen == 'VISTA')
		{
			$accion='sis12_vista_doc';
        }elseif ($examen == 'ELECTROR')
		{
			$accion='sis12_electror_doc';
        }elseif ($examen == 'ELECTROE')
		{
			$accion='sis12_electroe_doc';
        }
		elseif ($examen == 'EXUF')
		{

		}elseif ($examen == 'CPROPA')
		{

		}elseif ($examen == 'CPROCU')
		{				

		}elseif ($examen == 'AAFQ')
		{	

		}elseif ($examen == 'AHFQ')
		{

		}elseif ($examen == 'KOHU')
		{
			$accion='sis12_koh_doc';
		}elseif ($examen == 'CSVIVA')
		{

		}elseif ($examen == 'CSINERTE')
		{

		}elseif ($examen == 'CACRUDO')
		{

		}elseif ($examen == 'CACOCIDO')
		{

		}elseif ($examen == 'ABA')
		{			

		}
		elseif ($examen == 'ABH')
		{			

			
		}elseif ($examen == 'PROST')
		{			

		}elseif ($examen == 'HONE')
		{			
				$accion='sis12_honestidad_doc';
		}elseif ($examen == 'COMPO')
		{			
				$accion='sis13_comportamiento_doc';
		}elseif ($examen == 'SPIRO')
		{			
				$accion='sis12_spiro_doc';
		}elseif ($examen == 'VALPROF')
		{			
				$accion='sis12_valprof_doc';
		}elseif ($examen == 'BURO')
		{			
				$accion='sis12_buro_doc';
		}elseif ($examen == 'EXAMM')
		{			
				$accion='sis12_examm_doc';
		}		
	
		return $accion;
    }
}


if (!function_exists('dif_examenes_serv_examenes_clte'))
{
    function dif_examenes_serv_examenes_clte($examenes_serv, $examenes_clte)
    {

		$examenes_serv_array=explode(";",$examenes_serv);		
		$examenes_clte_array=explode(";",$examenes_clte);
		
		$resultado = array_diff($examenes_serv_array, $examenes_clte_array);
		return implode(";", $resultado);
    }
}




if (!function_exists('get_qr_code'))
{
    function get_qr_code($texto,$size='L')
    {

		if (strstr(PHP_OS,'WIN')) 
		{ 
			require_once './../../htdocs/qr/phpqrcode/qrlib.php';
			
			$server="http://localhost/humancenter_forms/index.php/usuario/login/verifica_hc/";
		} 
		else 
		{ 
			require_once './../../html/humancenter/application/libraries/phpqrcode/qrlib.php';
			$server="http://13.57.91.218/humancenter/index.php/usuario/login/verifica_hc/";
		}

		$ruta='./../../files/qr/';
		$file=uniqid().".png";
		$filep=$ruta.$file;
		$texto_c = $texto; 
		$txt=$server.$texto_c;
		QRcode::png($txt,$filep,$size,10,2);

		return $filep;
    }
}


if (!function_exists('get_qr_code_txt'))
{
    function get_qr_code_txt($texto,$size='L')
    {

		if (strstr(PHP_OS,'WIN')) 
		{ 
			require_once './../../htdocs/qr/phpqrcode/qrlib.php';
			$ruta='./../../files/qr/';
		} 
		else 
		{ 
			require_once './../../html/hc/application/libraries/phpqrcode/qrlib.php';
			//$ruta='./../../html/humancenter/qr/';
			$ruta='./../../files/qr/';
		}

		$file=uniqid().".png";
		$filep=$ruta.$file;
		$txt= $texto; 
		QRcode::png($txt,$filep,$size,10,2);

		return $filep;
    }
}


if (!function_exists('get_qr_code_pro'))
{
    function get_qr_code_pro($cliente,$fsm_id,$fsm_code,$size='L',$where=0)
    {

		if (strstr(PHP_OS,'WIN')) 
		{ 
			/*
				require_once './../../htdocs/qr/phpqrcode/qrlib.php';
			
			$server="http://localhost/humancenter_forms/index.php/usuario/login/verifica_hc/";
			
			if ($where == 1)
			{
				$ruta='./../../htdocs/humancenter/dist/images/qr/';
				$ruta_mail='http://13.57.91.218/humancenter/dist/images/qr/';
			}
			else
			{	
				$ruta='./../../files/qr/';
			}*/
			
			$filep='';
		} 
		else 
		{ 
			require_once './../../html/hc/application/libraries/phpqrcode/qrlib.php';
			$server="https://online.humancenter.com.mx/hc/index.php/usuario/login/verifica_hc/";
		    if ($where == 1)
			{
				$ruta='./../../html/hc/dist/images/qr/';
				$ruta_mail='http://13.57.91.218/humancenter/dist/images/qr/';
			}
			else
			{	
				$ruta='./../../files/qr/';		
			}
			
			
			$file=uniqid().".png";		
			$filep=$ruta.$file;
			$texto_c = $cliente; 
			$txt=$server.$texto_c.'/'.$fsm_id.'/'.$fsm_code;
			if ($where == 1)
			{
				QRcode::png($txt,$filep,'L',1,1);
			}

			
			{
				QRcode::png($txt,$filep,$size,10,2);
			}
			
			if ($where == 1)
			{
				$filep=$ruta_mail.'blank_qr.png';
			}
			else
			{
				$filep=$ruta.'blank_qr.png';
			}			
				
			
		}




		return $filep;

		
    }
}


if (!function_exists('et_qr_confiaza'))
{
    function get_qr_confiaza($fsm_code,$size='L',$where=0)
    {

		if (strstr(PHP_OS,'WIN')) 
		{ 
			require_once './../../htdocs/qr/phpqrcode/qrlib.php';
			
			$server="http://localhost/humancenter_forms/index.php/usuario/login/qrreader/";
			
			
			if ($where == 1)
			{
				$ruta='./../../htdocs/humancenter/dist/images/qr/';
				$ruta_mail='http://13.57.91.218/humancenter/dist/images/qr/';
			}
			else
			{	
				$ruta='./../../files/qrconfianza/';
			}
		} 
		else 
		{ 
			require_once './../../html/hc/application/libraries/phpqrcode/qrlib.php';

			$server="https://online.humancenter.com.mx/hc/index.php/usuario/login/qrreader/";
			

		    if ($where == 1)
			{
				$ruta='./../../html/humancenter/dist/images/qr/';
				$ruta_mail='http://13.57.91.218/humancenter/dist/images/qr/';
			}
			else
			{	
				$ruta='./../../files/qrconfianza/';
				//$ruta='./../../html/humancenter/qr/';
			}
		}

		
		$file=uniqid().".png";		
		$filep=$ruta.$file;
		$txt=$server.$fsm_code;
		
		QRcode::png($txt,$filep,$size,10,2);


		//return $filep;
		return $file;

		
    }
}






if (!function_exists('encriptador'))
{
    function encriptador($texto)
    {

        $cripto=$texto;
		
		$cripto=str_replace("0", "H", $cripto);
		$cripto=str_replace("1", "u", $cripto);
		$cripto=str_replace("2", "m", $cripto);
		$cripto=str_replace("3", "a", $cripto);
		$cripto=str_replace("4", "n", $cripto);
		$cripto=str_replace("5", "C", $cripto);
		$cripto=str_replace("6", "e", $cripto);
		$cripto=str_replace("7", "N", $cripto);
		$cripto=str_replace("8", "t", $cripto);
		$cripto=str_replace("9", "E", $cripto);

		return $cripto;
    }
}

if (!function_exists('desencriptador'))
{
    function desencriptador($texto)
    {

        $cripto=$texto;
		
		$cripto=str_replace("H", "0", $cripto);
		$cripto=str_replace("u", "1", $cripto);
		$cripto=str_replace("m", "2", $cripto);
		$cripto=str_replace("a", "3", $cripto);
		$cripto=str_replace("n", "4", $cripto);
		$cripto=str_replace("C", "5", $cripto);
		$cripto=str_replace("e", "6", $cripto);
		$cripto=str_replace("N", "7", $cripto);
		$cripto=str_replace("t", "8", $cripto);
		$cripto=str_replace("E", "9", $cripto);

		return $cripto;
    }
}


if (!function_exists('formatea_fecha'))
{
    function formatea_fecha($fecha)
    {
        if( $fecha != '0000-00-00' && $fecha != '' && $fecha != NULL )
        {
            $fecha_array = explode('-', $fecha);
            
            //$dia = date('d', strtotime($fecha));
            $dias = explode(' ',$fecha_array[2]);
            $dia = $dias[0];
            
            //$mes = date('n', strtotime($fecha));
            
            $mes = intval($fecha_array[1]);
            
            //$anio = date('Y', strtotime($fecha));
            $anio = $fecha_array[0];
            
            $mes_array = array('Ene','Feb','Mar','Abr','May','Jun','Jul','Ago','Sep','Oct','Nov','Dic');
            return $dia.'/'.$mes_array[$mes-1].'/'.$anio;
        }
        else
        {
            return '';
        }
    }
}



if (!function_exists('formatea_fecha_larga'))
{
    function formatea_fecha_larga($fecha)
    {
        if( $fecha != '0000-00-00' && $fecha != '' && $fecha != NULL )
        {
            $fecha_array = explode('-', $fecha);
            
            //$dia = date('d', strtotime($fecha));
            $dias = explode(' ',$fecha_array[2]);
            $dia = $dias[0];
            
            //$mes = date('n', strtotime($fecha));
            
            $mes = intval($fecha_array[1]);
            
            //$anio = date('Y', strtotime($fecha));
            $anio = $fecha_array[0];
            
            $mes_array = array('ENERO','FEBRERO','MARZO','ABRIL','MAYO','JUNIO','JULIO','AGOSTO','SEPTIEMBRE','OCTUBRE','NOVIEMBRE','DICIEMBRE');
            return $dia.' DE '.$mes_array[$mes-1].' DE '.$anio;
        }
        else
        {
            return '';
        }
    }
}

if (!function_exists('formatea_fecha_mysql'))
{
    function formatea_fecha_mysql($fecha)
    {
        if($fecha != '0000-00-00' && $fecha != '' && $fecha != NULL )
        {
            $fecha_array = explode('/', $fecha);
            $mes = array('Ene' => '01','Feb'=> '02','Mar'=> '03','Abr'=> '04','May'=> '05','Jun'=> '06','Jul'=> '07','Ago'=> '08','Sep'=> '09','Oct'=> '10','Nov'=> '11','Dic'=> '12');
            //return date('Y-m-d', strtotime($fecha_array[2].'-'.$mes[$fecha_array[1]].'-'.$fecha_array[0]));
            return $fecha_array[2].'-'.$mes[ucfirst($fecha_array[1])].'-'.$fecha_array[0];
        }
        else 
        {
            return NULL;
        }
    }
}



if (!function_exists('nom035_2_calificacion'))
{
    function nom035_2_calificacion($respuesta)
    {
		if ($respuesta == 'SIEMPRE')	
		{ return 4;
		}elseif ($respuesta == 'CASI SIEMPRE')	
		{ return 3;	
        }elseif ($respuesta == 'ALGUNAS VECES')	
		{ return 2;
		}elseif ($respuesta == 'CASI NUNCA')	
		{ return 1;	
		}elseif ($respuesta == 'NUNCA')	
		{ return 0;
		}else { return 0; }			
    }
}


if (!function_exists('nom035_2_calificacion'))
{
    function nom035_2_calificacion($respuesta)
    {
		if ($respuesta == 'SIEMPRE')	
		{ return 4;
		}elseif ($respuesta == 'CASI SIEMPRE')	
		{ return 3;	
        }elseif ($respuesta == 'ALGUNAS VECES')	
		{ return 2;
		}elseif ($respuesta == 'CASI NUNCA')	
		{ return 1;	
		}elseif ($respuesta == 'NUNCA')	
		{ return 0;
		}else { return 0; }			
    }
}

if (!function_exists('nom035_2_calificacion_rev'))
{
    function nom035_2_calificacion_rev($respuesta)
    {
		if ($respuesta == 'SIEMPRE')	
		{ return 0;
		}elseif ($respuesta == 'CASI SIEMPRE')	
		{ return 1;	
        }elseif ($respuesta == 'ALGUNAS VECES')	
		{ return 2;
		}elseif ($respuesta == 'CASI NUNCA')	
		{ return 3;	
		}elseif ($respuesta == 'NUNCA')	
		{ return 4;
		}else 
		{ return 0; }			
    }
}


if (!function_exists('nom035_2_riesgot'))
{
    function nom035_2_riesgot($valor,$t1,$t2,$t3,$t4)
    {
		if ($valor >= $t4)
			{ 
				return 'malto';
			}	
			elseif (($valor < $t4) &&  ($valor >= $t3))
			{ 
				return 'alto';	
			}
			elseif (($valor < $t3 ) &&  ($valor >= $t2 ))
			{ 
				return 'medio';
			}
			elseif (($valor < $t2 ) &&  ($valor >= $t1))	
			{ 
				return 'bajo';	
			}
			elseif ($valor < $t1)
			{ 
				return 'mbajo';
			}
			else 
			{ 
			return 'mbajo'; 
			}			
	}
}





if (!function_exists('nom035_2_riesgo'))
{
    function nom035_2_riesgo($valor)
    {
		if (($valor < 1.001) &&  ($valor > 0.79))
		{ 
			return 'malto';
		}
		elseif (($valor < 0.8) &&  ($valor > 0.59))
		{ 
			return 'alto';	
        }
		elseif (($valor < 0.60) &&  ($valor > 0.39))
		{ 
			return 'medio';
		}
		elseif (($valor <0.4) &&  ($valor > 0.19))	
		{ 
			return 'bajo';	
		}
		elseif (($valor < 0.2) &&  ($valor > 0))
		{ 
			return 'mbajo';
		}
		else 
		{ 
		return 'mbajo'; 
		}			
   

	}
}



if (!function_exists('formatea_fechahora_mysql'))
{
    function formatea_fechahora_mysql($fecha)
    {
        $fecha_array = explode('/', $fecha);
        $anio = explode(' ', $fecha_array[2]);
        $mes = array('Ene' => '01','Feb'=> '02','Mar'=> '03','Abr'=> '04','May'=> '05','Jun'=> '06','Jul'=> '07','Ago'=> '08','Sep'=> '09','Oct'=> '10','Nov'=> '11','Dic'=> '12');
        return $anio[0].'-'.$mes[ucfirst($fecha_array[1])].'-'.$fecha_array[0].' '.date('H:i:s', strtotime($anio[1]));
    }
}

if (!function_exists('formatea_hora_mysql'))
{
    function formatea_hora_mysql($hora)
    {
        return date('H:i:s', strtotime($hora));
    }
}

if (!function_exists('get_time_from_date'))
{
    function get_time_from_date($fecha)
    {
        if( $fecha > '1970-01-01' && $fecha != '' )
        {
            $dia = date('d', strtotime($fecha));
            $mes = date('n', strtotime($fecha));
            $anio = date('Y', strtotime($fecha));
            $mes_array = array('Ene','Feb','Mar','Abr','May','Jun','Jul','Ago','Sep','Oct','Nov','Dic');
            return date('g:iA',strtotime($fecha));
        }
        else
        {
            return '--';
        }
    }
}

if (!function_exists('count_examanes'))
{
    function count_examanes($exames_contenidos_en_servicio)
    {
		$cuantos_examenes_servicios=0;																
		foreach (explode(';',$exames_contenidos_en_servicio) as $examen_servicio)
		{
			if (strlen($examen_servicio) > 2)
			{
				$cuantos_examenes_servicios++;
			}	
		}
        return $cuantos_examenes_servicios;
    }
}






if (!function_exists('log_insert'))
{
    function log_insert($programa = '')
    {
        $CI =& get_instance();
        $array_log = array();
        $array_log['log_insrt_f'] = date("Y-m-d H:i:s");
        $array_log['log_insrt_usr_cve'] = 'sistema';
        if($CI->session->has_userdata('user'))
        {
            $user = $CI->session->user;
            $array_log['log_insrt_usr_cve'] = $user['usr_username'];
        }
        $array_log['log_insrt_prg'] = $programa;
        return $array_log;
    }
}

if (!function_exists('log_update'))
{
    function log_update($programa = '')
    {
        $CI =& get_instance();
        $array_log = array();
        $array_log['log_updt_f'] = date("Y-m-d H:i:s");
        $array_log['log_updt_usr_cve'] = 'sistema';
        if($CI->session->has_userdata('user'))
        {
            $user = $CI->session->user;
            $array_log['log_updt_usr_cve'] = $user['usr_username'];
        }
        $array_log['log_updt_prg'] = $programa;
        return $array_log;
    }
}


if (!function_exists('log_update_reg'))
{
    function log_update_reg($programa = '')
    {
        $CI =& get_instance();
        $array_log = array();
		$array_log['log_insrt_f'] = date("Y-m-d H:i:s");
        $array_log['log_updt_f'] = date("Y-m-d H:i:s");
        $array_log['log_updt_usr_cve'] = 'sistema';
        if($CI->session->has_userdata('user'))
        {
            $user = $CI->session->user;
            $array_log['log_updt_usr_cve'] = $user['usr_username'];
        }
        $array_log['log_updt_prg'] = $programa;
        return $array_log;
    }
}

if (!function_exists('get_abn_id'))
{
    function get_abn_id()
    {
        $CI =& get_instance();
        $abd_id = 0;
        if($CI->session->has_userdata('user'))
        {
            $user = $CI->session->user;
            $abd_id = $user['abn_id'];
        }
        return $abd_id;
    }
}

if (!function_exists('get_db'))
{
    function get_db()
    {
        $CI =& get_instance();
        $db = 'adm';
        if($CI->session->has_userdata('db'))
        {
            $db = $CI->session->db;
        }
        return $db;
    }
}

if (!function_exists('array_to_upper'))
{
    function array_to_upper($data)
    {
        $array_upper = array();
        foreach ($data as $key => $value)
        {
            $array_upper[$key] = mb_strtoupper($value);
        }
        return $array_upper;
    }
}





if (!function_exists('email_exist'))
{
    function email_exist($mail , $stf_id = '')
    {
        $CI =& get_instance();
        $CI->load->model('util/Util_model','util');
        return $CI->util->check_exist_mail($mail, $stf_id, get_abn_id());
    }
}


if (!function_exists('get_examen_de_empresa_por_categoria'))
{
    function get_examen_de_empresa_por_categoria($emp_id , $categoria)
    {
        $CI =& get_instance();
		$CI->load->model('empresa/Empresa_model','empresa');
        
        return $CI->empresa->examen_de_empresa_por_categoria($emp_id , $categoria);
    }
}

if (!function_exists('get_examenes_order_by'))
{
    function get_examenes_order_by($serv)
    {
        $CI =&get_instance();
		$CI->load->model('servicio/Servicio_model','servicio');
        
        return $CI->servicio->get_examenes_order_by($serv);
    }
}


if (!function_exists('get_examenes_by_serv'))
{
    function get_examenes_by_serv($serv)
    {
        $CI =&get_instance();
		$CI->load->model('servicio/Servicio_model','servicio');
        
        return $CI->servicio->get_examenes($serv);
    }
}

if (!function_exists('get_examenes_per_serv'))
{
    function get_examenes_per_serv($corporativo)
    {
		
		if ($corporativo == 'GSI')
		{	
			$examenes = array(
				array(
					"exam_id" => 43229,
					"serv_id" => 7514,
					"exam_nombre_pkt" => "BIOMETRÍA HEMÁTICA",
					"exam_cve" => "BIOHEM;",
					"exam_cantidad" => 1,
					"exam_estatus_cve" => "PEND",
					"exam_tipo_pkt" => "INDIVIDUAL",
					"exam_monto" => 95,
					"log_insrt_f" => "2023-04-25 14:00:09",
					"log_insrt_usr_cve" => "LFUENTES",
					"log_insrt_prg" => "ADD_SERV_EXAM",
					"log_updt_f" => NULL,
					"log_updt_usr_cve" => NULL,
					"log_updt_prg" => NULL,
				),
				array(
					"exam_id" => 43230,
					"serv_id" => 7514,
					"exam_nombre_pkt" => "EXAMEN GENERAL DE ORINA",
					"exam_cve" => "ORINA;",
					"exam_cantidad" => 1,
					"exam_estatus_cve" => "PEND",
					"exam_tipo_pkt" => "INDIVIDUAL",
					"exam_monto" => 75,
					"log_insrt_f" => "2023-04-25 14:00:09",
					"log_insrt_usr_cve" => "LFUENTES",
					"log_insrt_prg" => "ADD_SERV_EXAM",
					"log_updt_f" => NULL,
					"log_updt_usr_cve" => NULL,
					"log_updt_prg" => NULL,
				),
				array(
					"exam_id" => 43231,
					"serv_id" => 7514,
					"exam_nombre_pkt" => "EXAMEN ODONTOLÓGICO",
					"exam_cve" => "ODO;",
					"exam_cantidad" => 1,
					"exam_estatus_cve" => "PEND",
					"exam_tipo_pkt" => "INDIVIDUAL",
					"exam_monto" => 155,
					"log_insrt_f" => "2023-04-25 14:00:09",
					"log_insrt_usr_cve" => "LFUENTES",
					"log_insrt_prg" => "ADD_SERV_EXAM",
					"log_updt_f" => NULL,
					"log_updt_usr_cve" => NULL,
					"log_updt_prg" => NULL,
				),
				array(
					"exam_id" => 43232,
					"serv_id" => 7514,
					"exam_nombre_pkt" => "GRUPO SANGRUPO SANGUÍNEO Y FACTOR RHGUINEO",
					"exam_cve" => "GPOSAN;",
					"exam_cantidad" => 1,
					"exam_estatus_cve" => "PEND",
					"exam_tipo_pkt" => "INDIVIDUAL",
					"exam_monto" => 66,
					"log_insrt_f" => "2023-04-25 14:00:09",
					"log_insrt_usr_cve" => "LFUENTES",
					"log_insrt_prg" => "ADD_SERV_EXAM",
					"log_updt_f" => NULL,
					"log_updt_usr_cve" => NULL,
					"log_updt_prg" => NULL,
				),
				array(
					"exam_id" => 43233,
					"serv_id" => 7514,
					"exam_nombre_pkt" => "MÉDICO FÍSICO",
					"exam_cve" => "MEDFIS;",
					"exam_cantidad" => 1,
					"exam_estatus_cve" => "PEND",
					"exam_tipo_pkt" => "INDIVIDUAL",
					"exam_monto" => 235,
					"log_insrt_f" => "2023-04-25 14:00:09",
					"log_insrt_usr_cve" => "LFUENTES",
					"log_insrt_prg" => "ADD_SERV_EXAM",
					"log_updt_f" => NULL,
					"log_updt_usr_cve" => NULL,
					"log_updt_prg" => NULL,
				),
				array(
					"exam_id" => 53233,
					"serv_id" => 7514,
					"exam_nombre_pkt" => "HISTORIA CLÍNICA",
					"exam_cve" => "FSM0105;",
					"exam_cantidad" => 1,
					"exam_estatus_cve" => "PEND",
					"exam_tipo_pkt" => "INDIVIDUAL",
					"exam_monto" => 235,
					"log_insrt_f" => "2023-04-25 14:00:09",
					"log_insrt_usr_cve" => "LFUENTES",
					"log_insrt_prg" => "ADD_SERV_EXAM",
					"log_updt_f" => NULL,
					"log_updt_usr_cve" => NULL,
					"log_updt_prg" => NULL,
				),			
				array(
					"exam_id" => 43234,
					"serv_id" => 7514,
					"exam_nombre_pkt" => "QUÍMICA SANGUÍNEA DE 6 ELEMENTOS",
					"exam_cve" => "QS6;",
					"exam_cantidad" => 1,
					"exam_estatus_cve" => "PEND",
					"exam_tipo_pkt" => "INDIVIDUAL",
					"exam_monto" => 200,
					"log_insrt_f" => "2023-04-25 14:00:09",
					"log_insrt_usr_cve" => "LFUENTES",
					"log_insrt_prg" => "ADD_SERV_EXAM",
					"log_updt_f" => NULL,
					"log_updt_usr_cve" => NULL,
					"log_updt_prg" => NULL,
				),
				array(
					"exam_id" => 43235,
					"serv_id" => 7514,
					"exam_nombre_pkt" => "TOXICOLÓGICO 5",
					"exam_cve" => "TOXI;",
					"exam_cantidad" => 1,
					"exam_estatus_cve" => "PEND",
					"exam_tipo_pkt" => "INDIVIDUAL",
					"exam_monto" => 155,
					"log_insrt_f" => "2023-04-25 14:00:09",
					"log_insrt_usr_cve" => "LFUENTES",
					"log_insrt_prg" => "ADD_SERV_EXAM",
					"log_updt_f" => NULL,
					"log_updt_usr_cve" => NULL,
					"log_updt_prg" => NULL,
				),
				array(
					"exam_id" => 43236,
					"serv_id" => 7514,
					"exam_nombre_pkt" => "TOXICOLÓGICO 7",
					"exam_cve" => "TOXIS;",
					"exam_cantidad" => 1,
					"exam_estatus_cve" => "PEND",
					"exam_tipo_pkt" => "INDIVIDUAL",
					"exam_monto" => 192,
					"log_insrt_f" => "2023-04-25 14:00:09",
					"log_insrt_usr_cve" => "LFUENTES",
					"log_insrt_prg" => "ADD_SERV_EXAM",
					"log_updt_f" => NULL,
					"log_updt_usr_cve" => NULL,
					"log_updt_prg" => NULL,
				),
			);
		}
		elseif ($corporativo == 'LOCK')
		{
				$examenes= array(

				
				array(
					"exam_id" => 44316,
					"serv_id" => 7007,
					"exam_nombre_pkt" => "ENTORNO SOCIAL",
					"exam_cve" => "ENTSOC;",
					"exam_cantidad" => 1,
					"exam_estatus_cve" => "PEND",
					"exam_tipo_pkt" => "INDIVIDUAL",
					"exam_monto" => 745,
					"log_insrt_f" => "2023-05-15 17:41:12",
					"log_insrt_usr_cve" => "SHELDON",
					"log_insrt_prg" => "ADD_SERV_EXAM",
					"log_updt_f" => NULL,
					"log_updt_usr_cve" => NULL,
					"log_updt_prg" => NULL,
				),

				array(
					"exam_id" => 44317,
					"serv_id" => 7007,
					"exam_nombre_pkt" => "EXAMEN PSICOMÉTRICO",
					"exam_cve" => "PUESIC;",
					"exam_cantidad" => 1,
					"exam_estatus_cve" => "PEND",
					"exam_tipo_pkt" => "INDIVIDUAL",
					"exam_monto" => 500,
					"log_insrt_f" => "2023-05-15 17:41:12",
					"log_insrt_usr_cve" => "SHELDON",
					"log_insrt_prg" => "ADD_SERV_EXAM",
					"log_updt_f" => NULL,
					"log_updt_usr_cve" => NULL,
					"log_updt_prg" => NULL,
				),
				
				array(
					"exam_id" => 44318,
					"serv_id" => 7007,
					"exam_nombre_pkt" => "GRUPO SANGUINEO Y FACTOR RH",
					"exam_cve" => "GPOSAN;",
					"exam_cantidad" => 1,
					"exam_estatus_cve" => "PEND",
					"exam_tipo_pkt" => "INDIVIDUAL",
					"exam_monto" => 95,
					"log_insrt_f" => "2023-05-15 17:41:12",
					"log_insrt_usr_cve" => "SHELDON",
					"log_insrt_prg" => "ADD_SERV_EXAM",
					"log_updt_f" => NULL,
					"log_updt_usr_cve" => NULL,
					"log_updt_prg" => NULL,
				),

				array(
					"exam_id" => 44320,
					"serv_id" => 7007,
					"exam_nombre_pkt" => "CÉDULA PSICOLÓGICA",
					"exam_cve" => "PSIC;",
					"exam_cantidad" => 1,
					"exam_estatus_cve" => "PEND",
					"exam_tipo_pkt" => "",
					"exam_monto" => 325,
					"log_insrt_f" => "2023-05-15 17:41:12",
					"log_insrt_usr_cve" => "SHELDON",
					"log_insrt_prg" => "ADD_SERV_EXAM",
					"log_updt_f" => NULL,
					"log_updt_usr_cve" => NULL,
					"log_updt_prg" => NULL,
				),
				
				
				array(
					"exam_id" => 44321,
					"serv_id" => 7007,
					"exam_nombre_pkt" => "MÉDICO FÍSICO",
					"exam_cve" => "MEDFIS;",
					"exam_cantidad" => 1,
					"exam_estatus_cve" => "PEND",
					"exam_tipo_pkt" => "MULTIPLE",
					"exam_monto" => 380,
					"log_insrt_f" => "2023-05-15 17:41:12",
					"log_insrt_usr_cve" => "SHELDON",
					"log_insrt_prg" => "ADD_SERV_EXAM",
					"log_updt_f" => NULL,
					"log_updt_usr_cve" => NULL,
					"log_updt_prg" => NULL,
				),
				array(
					"exam_id" => 44319,
					"serv_id" => 7007,
					"exam_nombre_pkt" => "TOXICOLOGICO 7",
					"exam_cve" => "TOXIS;",
					"exam_cantidad" => 1,
					"exam_estatus_cve" => "PEND",
					"exam_tipo_pkt" => "MULTIPLE",
					"exam_monto" => 690,
					"log_insrt_f" => "2023-05-15 17:41:12",
					"log_insrt_usr_cve" => "SHELDON",
					"log_insrt_prg" => "ADD_SERV_EXAM",
					"log_updt_f" => NULL,
					"log_updt_usr_cve" => NULL,
					"log_updt_prg" => NULL,
				),				
				
			);		
		}		
		elseif ($corporativo == 'SERVISEG')
		{
			$examenes  = array(
			array(
				"exam_id" => 44304,
				"serv_id" => 7358,
				"exam_nombre_pkt" => "ACREDITACIÓN",
				"exam_cve" => "ACRED;",
				"exam_cantidad" => 1,
				"exam_estatus_cve" => "PEND",
				"exam_tipo_pkt" => "INDIVIDUAL",
				"exam_monto" => 250,
				"log_insrt_f" => "2023-05-15 17:06:30",
				"log_insrt_usr_cve" => "SHELDON",
				"log_insrt_prg" => "ADD_SERV_EXAM",
				"log_updt_f" => NULL,
				"log_updt_usr_cve" => NULL,
				"log_updt_prg" => NULL,
			),
			array(
				"exam_id" => 44310,
				"serv_id" => 7358,
				"exam_nombre_pkt" => "CÉDULA POLIGRÁFICA",
				"exam_cve" => "CED;",
				"exam_cantidad" => 1,
				"exam_estatus_cve" => "PEND",
				"exam_tipo_pkt" => "MULTIPLE",
				"exam_monto" => 1400,
				"log_insrt_f" => "2023-05-15 17:06:30",
				"log_insrt_usr_cve" => "SHELDON",
				"log_insrt_prg" => "ADD_SERV_EXAM",
				"log_updt_f" => NULL,
				"log_updt_usr_cve" => NULL,
				"log_updt_prg" => NULL,
			),			
			array(
				"exam_id" => 54305,
				"serv_id" => 7358,
				"exam_nombre_pkt" => "CERTIFICADO MÉDICO SERVISEG",
				"exam_cve" => "CERTI;",
				"exam_cantidad" => 1,
				"exam_estatus_cve" => "PEND",
				"exam_tipo_pkt" => "MULTIPLE",
				"exam_monto" => 200,
				"log_insrt_f" => "2023-05-15 17:06:30",
				"log_insrt_usr_cve" => "SHELDON",
				"log_insrt_prg" => "ADD_SERV_EXAM",
				"log_updt_f" => NULL,
				"log_updt_usr_cve" => NULL,
				"log_updt_prg" => NULL,
			),			
			array(
				"exam_id" => 44306,
				"serv_id" => 7358,
				"exam_nombre_pkt" => "ENTORNO SOCIAL",
				"exam_cve" => "ENTSOC;",
				"exam_cantidad" => 1,
				"exam_estatus_cve" => "PEND",
				"exam_tipo_pkt" => "INDIVIDUAL",
				"exam_monto" => 275,
				"log_insrt_f" => "2023-05-15 17:06:30",
				"log_insrt_usr_cve" => "SHELDON",
				"log_insrt_prg" => "ADD_SERV_EXAM",
				"log_updt_f" => NULL,
				"log_updt_usr_cve" => NULL,
				"log_updt_prg" => NULL,
			),
			array(
				"exam_id" => 44307,
				"serv_id" => 7358,
				"exam_nombre_pkt" => "MÉDICO FÍSICO",
				"exam_cve" => "MEDFIS;",
				"exam_cantidad" => 1,
				"exam_estatus_cve" => "PEND",
				"exam_tipo_pkt" => "MULTIPLE",
				"exam_monto" => 500,
				"log_insrt_f" => "2023-05-15 17:06:30",
				"log_insrt_usr_cve" => "SHELDON",
				"log_insrt_prg" => "ADD_SERV_EXAM",
				"log_updt_f" => NULL,
				"log_updt_usr_cve" => NULL,
				"log_updt_prg" => NULL,
			),
			array(
				"exam_id" => 44308,
				"serv_id" => 7358,
				"exam_nombre_pkt" => "RECONOCIMIENTO MÉDICO",
				"exam_cve" => "FSM0105;",
				"exam_cantidad" => 1,
				"exam_estatus_cve" => "PEND",
				"exam_tipo_pkt" => "INDIVIDUAL",
				"exam_monto" => 500,
				"log_insrt_f" => "2023-05-15 17:06:30",
				"log_insrt_usr_cve" => "SHELDON",
				"log_insrt_prg" => "ADD_SERV_EXAM",
				"log_updt_f" => NULL,
				"log_updt_usr_cve" => NULL,
				"log_updt_prg" => NULL,
			),
			array(
				"exam_id" => 44309,
				"serv_id" => 7358,
				"exam_nombre_pkt" => "CÉDULA PSICOLÓGICA",
				"exam_cve" => "PSIC;",
				"exam_cantidad" => 1,
				"exam_estatus_cve" => "PEND",
				"exam_tipo_pkt" => "MULTIPLE",
				"exam_monto" => 250,
				"log_insrt_f" => "2023-05-15 17:06:30",
				"log_insrt_usr_cve" => "SHELDON",
				"log_insrt_prg" => "ADD_SERV_EXAM",
				"log_updt_f" => NULL,
				"log_updt_usr_cve" => NULL,
				"log_updt_prg" => NULL,
			),

			array(
				"exam_id" => 44311,
				"serv_id" => 7358,
				"exam_nombre_pkt" => "REPORTE POLIGRÁFICO",
				"exam_cve" => "POL;",
				"exam_cantidad" => 1,
				"exam_estatus_cve" => "PEND",
				"exam_tipo_pkt" => "MULTIPLE",
				"exam_monto" => 1200,
				"log_insrt_f" => "2023-05-15 17:06:30",
				"log_insrt_usr_cve" => "SHELDON",
				"log_insrt_prg" => "ADD_SERV_EXAM",
				"log_updt_f" => NULL,
				"log_updt_usr_cve" => NULL,
				"log_updt_prg" => NULL,
			),
			array(
				"exam_id" => 44312,
				"serv_id" => 7358,
				"exam_nombre_pkt" => "PRUEBA PARA DETECCIÓN DE COVID-19",
				"exam_cve" => "COV19R;",
				"exam_cantidad" => 1,
				"exam_estatus_cve" => "PEND",
				"exam_tipo_pkt" => "INDIVIDUAL",
				"exam_monto" => 450,
				"log_insrt_f" => "2023-05-15 17:06:30",
				"log_insrt_usr_cve" => "SHELDON",
				"log_insrt_prg" => "ADD_SERV_EXAM",
				"log_updt_f" => NULL,
				"log_updt_usr_cve" => NULL,
				"log_updt_prg" => NULL,
			),
			array(
				"exam_id" => 44314,
				"serv_id" => 7358,
				"exam_nombre_pkt" => "SOCIO ECONÓMICO",
				"exam_cve" => "SOCIE;",
				"exam_cantidad" => 1,
				"exam_estatus_cve" => "PEND",
				"exam_tipo_pkt" => "INDIVIDUAL",
				"exam_monto" => 550,
				"log_insrt_f" => "2023-05-15 17:06:30",
				"log_insrt_usr_cve" => "SHELDON",
				"log_insrt_prg" => "ADD_SERV_EXAM",
				"log_updt_f" => NULL,
				"log_updt_usr_cve" => NULL,
				"log_updt_prg" => NULL,
			),
			array(
				"exam_id" => 44315,
				"serv_id" => 7358,
				"exam_nombre_pkt" => "TOXICOLÓGICO 5",
				"exam_cve" => "TOXI;",
				"exam_cantidad" => 1,
				"exam_estatus_cve" => "PEND",
				"exam_tipo_pkt" => "INDIVIDUAL",
				"exam_monto" => 80,
				"log_insrt_f" => "2023-05-15 17:06:30",
				"log_insrt_usr_cve" => "SHELDON",
				"log_insrt_prg" => "ADD_SERV_EXAM",
				"log_updt_f" => NULL,
				"log_updt_usr_cve" => NULL,
				"log_updt_prg" => NULL,
			),
		);
		
		}

        return $examenes;
    }
}




if (!function_exists('get_status_serv'))
{
    function get_status_serv($serv)
    {   
		if ($serv > 0)
		{
        $CI =&get_instance();
		$CI->load->model('servicio/Servicio_model','servicio');
        $res=$CI->servicio->get_estatus($serv);
        return $res['serv_estatus_cve'];
		}
		else
		{
			return 'nada';
		}
    }
}




if (!function_exists('get_archivos_by_serv'))
{
    function get_archivos_by_serv($serv)
    {
        $CI =&get_instance();
		$CI->load->model('servicio/Servicio_model','servicio');
        
        return $CI->servicio->get_archivos_examenes($serv);
    }
}



if (!function_exists('get_orden_venta_by_servicio'))
{
    function get_orden_venta_by_servicio($serv)
    {
        $CI =&get_instance();
		$CI->load->model('servicio/Servicio_model','servicio');
        
        $res= $CI->servicio->get_serv_emp($serv);
		return $res['serv_orden'];
    }
}



if (!function_exists('get_1'))
{
    function get_1($cat_grupo,$cat_grupo_nombre,$cat_cve)
    {
		$CI =&get_instance();
		$CI->load->model('cat/Catalogo_model','catalogo');
		$k=$CI->catalogo->get_cat_nombre_unico($cat_grupo,$cat_grupo_nombre,$cat_cve);
        //$k='hola';
        return $k;
    }
}


if (!function_exists('get_cat_nombre_unico'))
{
    function get_cat_nombre_unico($cat_grupo,$cat_grupo_nombre,$cat_cve)
    {
        $CI =&get_instance();
		$CI->load->model('cat/Catalogo_model','catalogo');        
        return $CI->catalogo->get_cat_nombre_unico($cat_grupo,$cat_grupo_nombre,$cat_cve);
    }
}

if (!function_exists('get_cat_nombre_pass'))
{
    function get_cat_nombre_pass($cat_grupo,$cat_grupo_nombre,$cat_cve)
    {
		$CI =&get_instance();
		$CI->load->model('cat/Catalogo_model','catalogo');
		$k=$CI->catalogo->get_cat_nombre_unico($cat_grupo,$cat_grupo_nombre,$cat_cve);
        return $k;
    }
}


if (!function_exists('get_evaluados_by_serv_fechados'))
{
    function get_evaluados_by_serv_fechados($serv,$modo)
    {
        $CI =&get_instance();
		$CI->load->model('servicio/Servicio_model','servicio');
        
        return $CI->servicio->get_examenes_serv($serv,$modo,$emp_id);
    }
}



if (!function_exists('get_evaluados_by_serv'))
{
    function get_evaluados_by_serv($serv,$emp_id,$ini,$fin)
    {
        $CI =&get_instance();
		$CI->load->model('servicio/Servicio_model','servicio');
        
        return $CI->servicio->get_examenes_serv($serv,0,$emp_id,$ini,$fin);
    }
}


if (!function_exists('count_evaluados_by_serv'))
{
    function count_evaluados_by_serv($serv)
    {
        $CI =&get_instance();
		$CI->load->model('servicio/Servicio_model','servicio');
        
        return $CI->servicio->get_examenes_serv($serv,1);
    }
}


if (!function_exists('valida_corporacion'))
{
    function valida_corporacion($emp_id,$corporacion)
    {
        $CI =& get_instance();
		$CI->load->model('empresa/Empresa_model','empresa');
        
        return $CI->empresa->corporacion_chk($emp_id,$corporacion);
    }
}



if (!function_exists('get_corporacion'))
{
    function get_corporacion($emp_id)
    {
        $CI =& get_instance();
		$CI->load->model('empresa/Empresa_model','empresa');
        
        return $CI->empresa->get_corporacion($emp_id);
    }
}

if (!function_exists('dame_un_empleado'))
{
    function dame_un_empleado($user)
    {
        $CI =& get_instance();
		$CI->load->model('empleado/Empleado_model','empleado');
        
        return $CI->empleado->get_sp($user);
    }
}


if (!function_exists('get_usr_username'))
{
    function get_usr_username($user)
    {
        $CI =& get_instance();
		$CI->load->model('empleado/Empleado_model','empleado');
        
        return $CI->empleado->get_usr_username($user);
    }
}





if (!function_exists('get_usuario_by_username'))
{
    function get_usuario_by_username($user)
    {
        $CI =& get_instance();
		$CI->load->model('empleado/Empleado_model','empleado');
        $usuario=$CI->empleado->get_usr_username($user);
        return $usuario['usr_nombre'].' '.$usuario['usr_paterno'].' '.$usuario['usr_materno'];
    }
}




if (!function_exists('reordena_array'))
{
    function reordena_array(&$items,$string)
    {
        mt_srand(strlen($string)); 
        for ($i = count($items) - 1; $i > 0; $i--){ 
            $j = @mt_rand(0, $i); 
            $tmp = $items[$i]; 
            $items[$i] = $items[$j]; 
            $items[$j] = $tmp; 
        }
    }
}


if (!function_exists('get_perfil_id'))
{
    function get_perfil_id()
    {
        $CI =& get_instance();
        $perfil_id = 0;
        if($CI->session->has_userdata('user'))
        {
            $user = $CI->session->user;
            $perfil_id = $user['perfil_id'];
        }
        return $perfil_id;
    }
	
}


if (!function_exists('get_empresa_razon_social'))
{
    function get_empresa_razon_social($emp_id)
    {
        $CI =& get_instance();
		$CI->load->model('empresa/Empresa_model','empresa');

		$CI->empresa->get_empresa_razon_social($emp_id);
		
        return $CI->empresa->get_empresa_razon_social($emp_id);
    }
}

if (!function_exists('get_desp_id_usr'))
{
    function get_desp_id_usr()
    {
        $CI =& get_instance();
		$CI->load->model('empresa/Empresa_model','empresa');
        $emp_id = 0;
		
        if($CI->session->has_userdata('user'))
        {
            $user = $CI->session->user;
			
			if (($user['usr_id'] == 589) || ($user['usr_id'] == 590) || ($user['usr_id'] == 591)
				||  ($user['usr_id'] == 1254) )
			{	
				$emp_id = 1;
			}		
			else
			{
				$emp_id = $user['emp_id'];
				
				$la_empresa = $CI->empresa->get_empresa($emp_id);
				
				if ($la_empresa['emp_desp'] == 0)
				{
					$emp_id = 0;
				}
			}				
			
        }
		
        return $emp_id;
    }
}



if (!function_exists('get_nom035_calificacion'))
{
    function get_nom035_calificacion($calificacion)
    {
        $CI =& get_instance();
		$CI->load->model('examen/Nom035_model','nom035');

	    $la_calificacion = $CI->nom035->get_calificacion($calificacion);

        return $la_calificacion['fsm_acciones'];
    }
	
}
	

if (!function_exists('get_empleados_nom035'))
{
    function get_empleados_nom035($emp_id)
    {
        $CI =& get_instance();
		$CI->load->model('persona/Persona_model','usuarios');
        $res=$CI->usuarios->get_empleados_nom035($emp_id);
        return $res;
    }
}


if (!function_exists('get_my_user_servicios'))
{
    function get_my_user_servicios()
    {
			$CI =& get_instance();
			$CI->load->model('persona/Persona_model','usuarios');
			
			$id = 0;
			if($CI->session->has_userdata('user'))
			{
			$user = $CI->session->user;
			$id = $user['usr_id'];
			}
			
			$la_root = $CI->usuarios->get_my_servicios($id);
			
			return $la_root['servicios'];
    }	
	
}

if (!function_exists('get_my_user_modulos'))
{
    function get_my_user_modulos()
    {
			$CI =& get_instance();
			$CI->load->model('persona/Persona_model','usuarios');
			
			$id = 0;
			if($CI->session->has_userdata('user'))
			{
			$user = $CI->session->user;
			$id = $user['usr_id'];
			}
			
			$la_root = $CI->usuarios->get_my_modulos($id);
			
			return $la_root['servicios'];
    }	
	
}

if (!function_exists('get_my_user_unidad_reclutadora'))
{
    function get_my_user_unidad_reclutadora()
    {
			$CI =& get_instance();
			$CI->load->model('empleado/Empleado_model','usuario');
			
			$id = 0;
			if($CI->session->has_userdata('user'))
			{
			$user = $CI->session->user;
			$id = $user['usr_id'];
			}
			
			$la_root = $CI->usuario->get_unidad_reclutador($id);
			
			return $la_root['usr_unidad_reclutadora'];
    }	
	
}


if (!function_exists('get_my_user_root1'))
{
    function get_my_user_root1()
    {
			$CI =& get_instance();
			$CI->load->model('empleado/Empleado_model','usuario');
			
			$id = 0;
			if($CI->session->has_userdata('user'))
			{
			$user = $CI->session->user;
			$id = $user['usr_id'];
			}
			
			$la_root = $CI->usuario->get_roots($id);
			
			return $la_root['root1'];
    }	
	
}

if (!function_exists('get_my_user_root2'))
{
    function get_my_user_root2()
    {
			$CI =& get_instance();
			$CI->load->model('empleado/Empleado_model','usuario');
			
			$id = 0;
			if($CI->session->has_userdata('user'))
			{
			$user = $CI->session->user;
			$id = $user['usr_id'];
			}
			
			$la_root = $CI->usuario->get_roots($id);
			
			return $la_root['root2'];
    }	
	
}


if (!function_exists('get_my_user_root3'))
{
    function get_my_user_root3()
    {
			$CI =& get_instance();
			$CI->load->model('empleado/Empleado_model','usuario');
			
			$id = 0;
			if($CI->session->has_userdata('user'))
			{
			$user = $CI->session->user;
			$id = $user['usr_id'];
			}
			
			$la_root = $CI->usuario->get_roots($id);
			
			return $la_root['root3'];
    }	
	
}

if (!function_exists('get_my_user_root6'))
{
    function get_my_user_root6()
    {
			$CI =& get_instance();
			$CI->load->model('empleado/Empleado_model','usuario');
			
			$id = 0;
			if($CI->session->has_userdata('user'))
			{
			$user = $CI->session->user;
			$id = $user['usr_id'];
			}
			
			$la_root = $CI->usuario->get_roots($id);
			
			return $la_root['root6'];
    }	
	
}


if (!function_exists('get_my_emp_asig'))
{
    function get_my_emp_asig()
    {
			$CI =& get_instance();
			$CI->load->model('empleado/Empleado_model','usuario');
			
			$id = 0;
			if($CI->session->has_userdata('user'))
			{
			$user = $CI->session->user;
			$id = $user['usr_id'];
			}
			
			$la_root = $CI->usuario->get_roots($id);
			
			return $la_root['usr_emp_asig'];
    }	
	
}



if (!function_exists('titular_empresa_seguridad'))
{
    function titular_empresa_seguridad($titulo)
    {		?>
			<table border="1">
				<tr>
					<td align="center" style="width: 0.1px; font-size:60%;"><b>&nbsp;</b></td>				
					<td align="center" style="width: 100%; font-size:150%;"><b><?php echo $titulo; ?></b></td>
					<td align="center" style="width: 0.1px;"><b></b></td>	
				</tr>
			</table>	
			<?php
			return 1;
    }	
	
}

if (!function_exists('pie_de_pagina_seguridad'))
{
    function pie_de_pagina_seguridad($cuantos)
    {		?>
			<table>
				<?php
				for ($i=0; $i<=$cuantos; $i++)
				{
				?>	
				<tr>
					<td colspan="2"></td>
				</tr>
				<?php
				}
				?>						
				<tr>
					<td colspan="2" align="left" style="font-size:100%; width: 537px;"><?php echo 'Q.F.B. JAIMES FLORES MONTSERRAT    11322160       ';?></td>
				</tr>
				<tr>
					<td colspan="2" style="background-color: #00004d; font-size:120%; width: 537px;"></td>
				</tr>
				<tr>
					<td align="left"  colspan="2"><b>Nota: Para validar resultados, se tendrá 3 días, posteriores a la aplicación de la evaluación.</b></td>
				</tr>				
				<tr>
					<td align="center"  colspan="2" style="width: 537px;"><b>Human Center Review S.A. de C.V.</b></td>
				</tr>
				<tr>
					<td align="center"  colspan="2" style="width: 537px;"><b>San Borja 1365 Col. Vértiz Narvarte Alc. Benito Juárez C.P. 03600 Ciudad de México. Tel. 55-36-40-44-36</b></td>
				</tr>
			</table>	
			<?php
			return 1;
    }	
	
}

if (!function_exists('cuenta_elementos'))
{
    function cuenta_elementos($items)
    {
		$i=0;
			foreach($items as $item):
				$i++;
			endforeach;			
		return $i;
    }	
	
}


if (!function_exists('get_corporativo_consultorio'))
{
    function get_corporativo_consultorio($cons_id)
	{
			$CI =& get_instance();
			$CI->load->model('empresa/Empresa_model','consultorio');
			
			$id=$CI->consultorio->get_corporativo_consultorio($cons_id);
			return $id;
    }	
	
}

if (!function_exists('get_empresa_consultorio'))
{
    function get_empresa_consultorio($cons_id)
	{
			$CI =& get_instance();
			$CI->load->model('empresa/Empresa_model','consultorio');
			
			$id=$CI->consultorio->get_empresa_consultorio($cons_id);
			return $id;
    }	
	
}


if (!function_exists('get_razon_social_consultorio'))
{
    function get_razon_social_consultorio($cons_id)
	{
			$CI =& get_instance();
			$CI->load->model('empresa/Empresa_model','consultorio');
			
			$id=$CI->consultorio->get_razon_social_consultorio($cons_id);
			return $id;
    }	
	
}


if (!function_exists('array_empresas_subcorp'))
{
    function array_empresas_subcorp($corporativo, $subcorporativo)
	{
			$CI =& get_instance();
			$CI->load->model('empresa/Empresa_model','empresa');
			
			$empresas_id=$CI->empresa->get_all_empresas_subcorp($corporativo, $subcorporativo);
			$i=0;
			if($empresas_id)
			{
				foreach ($empresas_id as $empresa)
				{
					$array_empresas[$i]=$empresa['emp_id'];
					$i++;				
				}
			}
			
			return $array_empresas;
    }	
	
}


if (!function_exists('get_my_user_root4'))
{
    function get_my_user_root4()
    {
			$CI =& get_instance();
			$CI->load->model('empleado/Empleado_model','usuario');
			
			$id = 0;
			if($CI->session->has_userdata('user'))
			{
			$user = $CI->session->user;
			$id = $user['usr_id'];
			}
			
			$la_root = $CI->usuario->get_roots($id);
			
			return $la_root['root4'];
    }	
	
}


if (!function_exists('get_my_user_root5'))
{
    function get_my_user_root5()
    {
			$CI =& get_instance();
			$CI->load->model('empleado/Empleado_model','usuario');
			
			$id = 0;
			if($CI->session->has_userdata('user'))
			{
			$user = $CI->session->user;
			$id = $user['usr_id'];
			}
			
			$la_root = $CI->usuario->get_roots($id);
			
			return $la_root['root5'];
    }	
	
}



if (!function_exists('get_emp_asig'))
{
    function get_emp_asig()
    {
			$CI =& get_instance();
			$CI->load->model('empleado/Empleado_model','usuario');
			
			$id = 0;
			if($CI->session->has_userdata('user'))
			{
			$user = $CI->session->user;
			$id = $user['usr_id'];
			}
			
			$la_root = $CI->usuario->get_emp_asig($id);
			
			return $la_root;
    }	
	
}


if (!function_exists('get_user_modulo'))
{
    function get_user_modulo($modulo)
    {
			$CI =& get_instance();
			$CI->load->model('empleado/Empleado_model','usuario');
			
			$id = 0;
			if($CI->session->has_userdata('user'))
			{
			$user = $CI->session->user;
			$id = $user['usr_id'];
			}

			$cuenta = $CI->usuario->get($id);
			
			if (strstr($cuenta['modulos'],$modulo))
			{
				return TRUE;
			}
			else
			{
				return FALSE;
			}			
    }	
	
}


if (!function_exists('get_user_modulo'))
{
    function get_user_servicios($servicios)
    {
			$CI =& get_instance();
			$CI->load->model('empleado/Empleado_model','usuario');
			
			$id = 0;
			if($CI->session->has_userdata('user'))
			{
			$user = $CI->session->user;
			$id = $user['usr_id'];
			}

			$cuenta = $CI->usuario->get($id);
			
			if (strstr($cuenta['servicios'],$servicios))
			{
				return TRUE;
			}
			else
			{
				return FALSE;
			}			
    }	
	
}


if (!function_exists('get_cei_id'))
{
    function get_cei_id()
    {
        $CI =& get_instance();
        $cei_id = 0;
        if($CI->session->has_userdata('user'))
        {
            $user = $CI->session->user;
            $cei_id = $user['cei_id'];
        }
        return $cei_id;
    }
}


if (!function_exists('get_user_id'))
{
    function get_user_id()
    {
        $CI =& get_instance();
        $perfil_id = 0;
        if($CI->session->has_userdata('user'))
        {
            $user = $CI->session->user;
            $usr_id = $user['usr_id'];
        }
        return $usr_id;
    }
}


if (!function_exists('get_permiso_vista'))
{
    function get_permiso_vista($niveles)
    {
        if(in_array(get_perfil_id(), $niveles))
        {
            return TRUE;
        }
        else
        {
            return FALSE;
        }
    }
}

if (!function_exists('parsea_eventos'))
{
    function parsea_eventos($eventos)
    {
        $eventos_parsed = array();
        if($eventos)
        {
            foreach ($eventos as $key => $value)
            {
                $html = '<ul class="agenda-events">';
                foreach ($value as $row)
                {
                    $html .= '<li><a class="event" href="'.$row['url'].'"><b>'.$row['time'].'</b> '.$row['title'].'</a></li>';
                }
                $html .= '</ul>';
                $eventos_parsed[$key] = $html;
            }
            return $eventos_parsed;
        }
        else
        {
            return $eventos_parsed;
        }
    }
}

if (!function_exists('get_usr_cve'))
{
    function get_usr_cve()
    {
        $CI =& get_instance();
        $abd_id = 0;
        if($CI->session->has_userdata('user'))
        {
            $user = $CI->session->user;
            $usr_cve = $user['usr_username'];
        }
        return $usr_cve;
    }
}

if (!function_exists('get_edad'))
{
    function get_edad($f_nac)
    {
       if($f_nac != '' && $f_nac != NULL)
       {
           list($Y,$m,$d) = explode("-",$f_nac);
           $anios = ( date("md") < $m.$d ? date("Y")-$Y-1 : date("Y")-$Y );
           if($anios >= 2)
           {
            return $anios.' años';;
           }
           else 
           {
            $meses = (date('Y') > $Y)?(12-$m) + date('n'):date('n') - $m;
            $meses = (date("md") < $m.$d)?$meses:$meses-1;
            return ($meses > 1)?$meses.' meses':$meses.' mes';
           }
       }
       else 
       {
        return '--';
       }
    }
}


if (!function_exists('formatea_tel'))
{
    function formatea_tel($telefono)
    {
        $lada_int = '';
        $lada_nac = '';
        $telseg1 = '';
        $telseg2 = '';
        $lada = '';
        if(strlen($telefono) >= 10)
        {
            $lada_int = '';
            $lada_nac = '';
            $telseg1 = '';
            $telseg2 = '-'.substr($telefono, -4);
            $lada = substr($telefono, 0, 3);
            //si es gringo
            if($lada == '001')
            {
                $lada_int = '001 ';
                $lada_nac = '('.substr($telefono, 3 , 3).') ';
                $telseg1 = substr($telefono, 6 , 3);
            }
            else
            {
                //si los dos primero digitos de la lada es 33,55 u 81
                if(in_array(substr($lada, 0, 2), array('33','55','81')))
                {
                    $lada_nac = '('.substr($lada, 0, 2).') ';
                    $telseg1 = substr($telefono, 2, 4);
                }
                else 
                {
                    $lada_nac = '('.$lada.') ';
                    $telseg1 = substr($telefono, 3, 3);
                }
            }
        }
        else if(strlen($telefono) < 10 && strlen($telefono) >= 8) 
        {
            $telseg1 = substr($telefono, 0, 4);
            $telseg2 = '-'.substr($telefono, -4);
        }
        else
        {
            $telseg1 = '';
            $telseg2 = '';
        }
        return $lada_int.$lada_nac.$telseg1.$telseg2;
    }
}

if (!function_exists('get_prefijo'))
{
    function get_prefijo($medico = '')
    {
        $CI =& get_instance();
        $prefijo = '';
        
        //si no es aux administrativo
        if(get_permiso_vista(array(50,52)))
        {
            if($medico == '')
            {
                $CI->load->model('medico/Medico_model','medico');
                $medico = $CI->medico->get_medico(get_abn_id());
            }

            if($medico)
            {
                if(in_array($medico['med_tipo_prof_cve'],array('MEGRAL','MERESI','MEESPE','NUTRI','HOMEO','MEDTRAC')))
                {
                    if($medico['med_genero_cve'] == 'M')
                    {
                        $prefijo = 'DRA. ';
                    }
                    else if($medico['med_genero_cve'] == 'H')
                    {
                        $prefijo = 'DR. ';
                    }
                }
            }
        }
        return $prefijo;
    }
}

if (!function_exists('formatea_fechahora'))
{
    function formatea_fechahora($fecha)
    {
        if( $fecha > '1970-01-01' && $fecha != '' )
        {
            $dia = date('d', strtotime($fecha));
            $mes = date('n', strtotime($fecha));
            $anio = date('Y', strtotime($fecha));
            $mes_array = array('Ene','Feb','Mar','Abr','May','Jun','Jul','Ago','Sep','Oct','Nov','Dic');
            return $dia.'/'.$mes_array[$mes-1].'/'.$anio.' '.date('g:iA',strtotime($fecha));
        }
        else
        {
            return '--';
        }
    }
}


if (!function_exists('formatea_fechahora_y'))
{
    function formatea_fechahora_y($fecha)
    {
        if( $fecha > '1970-01-01' && $fecha != '' )
        {
            $dia = date('d', strtotime($fecha));
            $mes = date('n', strtotime($fecha));
            $anio = date('Y', strtotime($fecha));
            $mes_array = array('Ene','Feb','Mar','Abr','May','Jun','Jul','Ago','Sep','Oct','Nov','Dic');
            $fechahora=$dia.'/'.$mes_array[$mes-1].'/'.$anio.' '.date('g:iA',strtotime($fecha));
			$fechahora=str_replace("AM", " AM", $fechahora);
			$fechahora=str_replace("PM", " PM", $fechahora);
			return $fechahora;
        }
        else
        {
            return '--';
        }
    }
}


if (!function_exists('formatea_fechahora_yy'))
{
    function formatea_fechahora_yy($fecha)
    {
        if( $fecha > '1970-01-01' && $fecha != '' )
        {
            $dia = date('d', strtotime($fecha));
            $mes = date('n', strtotime($fecha));
            $anio = date('y', strtotime($fecha));
            $mes_array = array('Ene','Feb','Mar','Abr','May','Jun','Jul','Ago','Sep','Oct','Nov','Dic');
            return $dia.'/'.$mes_array[$mes-1].'/'.$anio.' '.date('g:iA',strtotime($fecha));
        }
        else
        {
            return '--';
        }
    }
}

//elimina caracteres del telefono enmascarado
if (!function_exists('limpia_telefono'))
{
    function limpia_telefono($telefono)
    {
        return preg_replace('/[-[\]{}()+?.,\\/^$|#\s]/', '', $telefono);
    }
}

/* cuenta las notificaciones de soporte */
if (!function_exists('count_responses_tickets'))
{
    function count_responses_tickets()
    {
        $CI =& get_instance();
        $CI->load->model('medico/Soporte_model');
        $user = $CI->session->user;
        $tickets = $CI->Soporte_model->count_all_responses_by_user($user['usr_id']);
        if($tickets['nuevos_msg'] > 0)
        {
            return $tickets['nuevos_msg'];
        }
        else
        {
            return FALSE;
        }
    }
}

if (!function_exists('encripta'))
{
    function encripta($InputString)
    {
	$KeyPhrase = "holaquetal";
        $InputString = XOREncryption($InputString, $KeyPhrase);
        $InputString = base64_encode(urlencode($InputString));
        return $InputString;
    }
}

if (!function_exists('desencripta'))
{
    function desencripta($InputString)
    {
	$KeyPhrase = "holaquetal";
        $InputString = base64_decode(urldecode($InputString));
        $InputString = XOREncryption($InputString, $KeyPhrase);
        return $InputString;
    }
}

if (!function_exists('XOREncryption'))
{
    function XOREncryption($InputString, $KeyPhrase)
    {
        $KeyPhraseLength = strlen($KeyPhrase);
        for ($i = 0; $i < strlen($InputString); $i++)
        {
            $rPos = $i % $KeyPhraseLength;
            $r = ord($InputString[$i]) ^ ord($KeyPhrase[$rPos]);
            $InputString[$i] = chr($r);
        }
        return $InputString;
    }
}

if (!function_exists('dateDifference'))
{
    function dateDifference($date_1 , $date_2 , $differenceFormat = '%R%a' )
    {
        $datetime1 = date_create($date_2);
        $datetime2 = date_create($date_1);
        $interval = date_diff($datetime1, $datetime2);
        return intval($interval->format($differenceFormat));
		//return intval($interval->days);
    }
}


if (!function_exists('refresca_session'))
{
    function refresca_session()
    {
        $CI =& get_instance();
        $user = $CI->session->user;
        $CI->load->model('user/Login_model');
        $user_updated = $CI->Login_model->get_user($user['usr_id']);
        if($user_updated)
        {
            $CI->session->unset_userdata('user');
            $CI->session->set_userdata('user', $user_updated);
        }
    }
}

if (!function_exists('get_breadcum'))
{
    function get_breadcum($array_li)
    {
        $html = '<ol class="breadcrumb">';
        // $html .= '<li><a href="'.base_url('manual/inicio').'"><i class="fa fa-home"></i></a></li>';
        if($array_li)
        {
            if(count($array_li) > 0)
            {
                foreach ($array_li as $li)
                {
                    $html .= '<li><a href="'.$li['href'].'">'.$li['text'].'</a></li>';
                }
            }
        }
        $html .= '</ol>';
        return $html;
    }
}

if (!function_exists('get_key'))
{
    function get_key()
    {
        $CI =& get_instance();
        $CI->load->library('encryption');
        return $CI->encryption->decrypt($CI->session->key);
    }
}

if (!function_exists('set_key'))
{
    function set_key($pass)
    {
        $CI =& get_instance();
        $CI->load->library('encryption');
        $CI->session->set_userdata('key' , $CI->encryption->encrypt($pass));
    }
}

if (!function_exists('get_suscripcion'))
{
    function get_suscripcion()
    {
        $CI =& get_instance();
        return $CI->session->suscripcion;
    }
}

if (!function_exists('set_suscripcion'))
{
    function set_suscripcion($str)
    {
        $CI =& get_instance();
        $CI->session->set_userdata('suscripcion' , $str);
    }
}


if (!function_exists('parsea_select'))
{
    function parsea_select($str, $key)
    {
        $array_columns = explode(',', str_replace('`', '', $str));
        $i = 0;
        foreach ($array_columns as $column)
        {
            $pos = strpos($column, '_crypt');
            if($pos !== false)
            {
                $alias = str_replace('_crypt', '', $column);
                $punto = strpos($alias, '.');
                if($punto !== false)
                {
                    $alias = substr($alias, $punto + 1);
                }
                $array_columns[$i] = "AES_DECRYPT(".$column.",'$key') as ".$alias;
            }
            $i++;
        }
        return implode(',', $array_columns);
    }
}

if (!function_exists('parsea_insert'))
{
    function parsea_insert($data, &$db, $key)
    {
        $i = 0;
        foreach ($data as $columna => $value) 
        {
            $pos = strpos($columna, '_crypt');
            if($pos !== false)
            {
                $db->set("$columna", "AES_ENCRYPT('".$value."','$key')",FALSE);
            }
            else 
            {
                $db->set("$columna", "$value");
            }
            $i++;
        }
    }
}

if (!function_exists('parsea_insert_test'))
{
    function parsea_insert_test($data)
    {
        $sql = '';
        foreach ($data as $columna => $value) 
        {
            $pos = strpos($columna, '_crypt');
            if($pos !== false)
            {
                $sql .= "AES_ENCRYPT($value,v_abn_key),";
            }
            else 
            {
                $sql .= "$value,";
            }
        }
        return $sql;
    }
}

if (!function_exists('get_emp_id'))
{
    function get_emp_id()
    {
        $CI =& get_instance();
        $emp = 0;
        if($CI->session->has_userdata('user'))
        {
            $user = $CI->session->user;
            $emp = $user['emp_id'];
        }
        return $emp;
    }
}


if (!function_exists('get_filtro_so_id'))
{
    function get_filtro_so_id($user_id)
    {
		
		$CI =& get_instance();
		$CI->load->model('empleado/Empleado_model','empleado');
        $filtro_id = 0;
		

	        $filtro_id = $CI->empleado->get_so_filtro($user_id);


		return $filtro_id;
    }
}


if (!function_exists('get_filtro_cei_id'))
{
    function get_filtro_cei_id($user_id)
    {
		
		$CI =& get_instance();
		$CI->load->model('empleado/Empleado_model','empleado');
        $filtro_id = 0;
	    $filtro_id = $CI->empleado->get_cei_filtro($user_id);
		return $filtro_id;
    }
}

if (!function_exists('get_filtro_id'))
{
    function get_filtro_id($user_id)
    {
		
		$CI =& get_instance();
		$CI->load->model('empleado/Empleado_model','empleado');
        $filtro_id = 0;
		

	        $filtro_id = $CI->empleado->get_filtro($user_id);


		return $filtro_id;
    }
}


if (!function_exists('buscar_ingreso'))
{
    function busca_ingreso($texto, $array_buscar)
    {
        return array_search($texto, array_column($array_buscar, 'tipo_cve'));
    }
}

if (!function_exists('get_ingreso'))
{
    function get_ingreso($indice, $array_buscar, $columna)
    {
        if($indice !== FALSE)
        {
            return $array_buscar[$indice][$columna];
        }
        else
        {
            return '';
        }
    }
}

if (!function_exists('get_extension'))
{   
    function get_extension($filename)
    {
        $x = explode('.', $filename);

        if (count($x) === 1)
        {
                return '';
        }

        $ext = strtolower(end($x));
        return '.'.$ext;
    }
}

if (!function_exists('get_doc'))
{
    function get_doc($folder, $file)
    {
        echo site_url()."./../../files/$folder/$file";
    }
}

if (!function_exists('genera_url_examen_qr'))
{
    function genera_url_examen_qr($fsm)
    {
        $mapeo = unserialize(MAPEO_EXAMENES);
        return base_url('valida/examen/'.$mapeo[$fsm['fsm_alias']]['id'].'/'.$fsm['fsm_uuid']);
    }
}

if (!function_exists('formatea_fecha_larga'))
{
    function formatea_fecha_larga($fecha)
    {
        if( $fecha != '0000-00-00' && $fecha != '' && $fecha != NULL )
        {
            $fecha_array = explode('-', $fecha);
            
            //$dia = date('d', strtotime($fecha));
            $dias = explode(' ',$fecha_array[2]);
            $dia = $dias[0];
            
            //$mes = date('n', strtotime($fecha));
            
            $mes = intval($fecha_array[1]);
            
            //$anio = date('Y', strtotime($fecha));
            $anio = $fecha_array[0];
            
            $mes_array = array('Enero','Febrero','Marzo','Abril','Mayo','Junio','Julio','Agosto','Septiembre','Octubre','Noviembre','Diciembre');
            return $dia.' de '.$mes_array[$mes-1].' del '.$anio;
        }
        else
        {
            return '';
        }
    }
}



if (!function_exists('carga_imagen_siniestro'))
{
    function carga_imagen_siniestro($input,$path,$folio,$detalle,$modo)
    {
        if(!empty($_FILES[$input]['name']))
        {
            $CI =& get_instance();
            $CI->load->library('upload');
            //$filename = md5(time().$_FILES[$input]['name']);
			$filename = $folio.'_'.$detalle.'_'.$modo;
            $config = array(
                    'upload_path'   => $path,
                    'overwrite'     => TRUE,
                    'file_name'     => $filename,
                    'allowed_types' => 'png|jpg|jpeg',
                    'max_size'      => '90000'
            );

            $CI->upload->initialize($config);
            if ( ! $CI->upload->do_upload($input))
            {
                return send_json_error($CI->upload->display_errors());
            }
            else 
            {
                $data = $CI->upload->data();
                return $data['file_name'];
            }
        }
        else{
            return NULL;
        }
    }
}



if (!function_exists('carga_imagen'))
{
    function carga_imagen($input,$path)
    {
        if(!empty($_FILES[$input]['name']))
        {
            $CI =& get_instance();
            $CI->load->library('upload');
            $filename = md5(time().$_FILES[$input]['name']);
            $config = array(
                    'upload_path'   => $path,
                    'overwrite'     => TRUE,
                    'file_name'     => $filename,
                    'allowed_types' => 'png|jpg|jpeg',
                    'max_size'      => '90000'
            );

            $CI->upload->initialize($config);
            if ( ! $CI->upload->do_upload($input))
            {
                return send_json_error($CI->upload->display_errors());
            }
            else 
            {
                $data = $CI->upload->data();
                return $data['file_name'];
            }
        }
        else{
            return NULL;
        }
    }
}




if (!function_exists('carga_pdf_personalizados'))
{
    function carga_pdf_personalizados($input,$path,$persona)
    {
        if(!empty($_FILES[$input]['name']))
        {
            $CI =& get_instance();
            $CI->load->library('upload');
            //$filename = md5(time().$_FILES[$input]['name']);
			$filename = $persona;
            $config = array(
                    'upload_path'   => $path,
                    'overwrite'     => TRUE,
                    'file_name'     => $filename,
                    'allowed_types' => 'pdf',
                    'max_size'      => '90000'
            );

            $CI->upload->initialize($config);
            if ( ! $CI->upload->do_upload($input))
            {
                return send_json_error($CI->upload->display_errors());
            }
            else 
            {
                $data = $CI->upload->data();
                return $data['file_name'];
            }
        }
        else{
            return NULL;
        }
    }
}

if (!function_exists('carga_pdf_ext'))
{
    function carga_pdf_ext($input,$path, $emp_id,$clte_id,$clave)
    {
        if(!empty($_FILES[$input]['name']))
        {
            $CI =& get_instance();
            $CI->load->library('upload');
            $filename =$emp_id.'_'.$clte_id.'_'.strtolower(str_replace(";", "", $clave)).'_'.date(dmYHis);   //md5(time().$_FILES[$input]['name']);
            $config = array(
                    'upload_path'   => './../../files/'.$path.'/',
                    'overwrite'     => TRUE,
                    'file_name'     => $filename,
                    'allowed_types' => 'pdf',
                    'max_size'      => '90000'
            );

            $CI->upload->initialize($config);
            if ( ! $CI->upload->do_upload($input))
            {
                return send_json_error($CI->upload->display_errors());
            }
            else 
            {
                $data = $CI->upload->data();
                return $data['file_name'];
            }
        }
        else{
            return NULL;
        }
    }
}

if (!function_exists('carga_pdf'))
{
    function carga_pdf($input,$path)
    {
        if(!empty($_FILES[$input]['name']))
        {
            $CI =& get_instance();
            $CI->load->library('upload');
            $filename = md5(time().$_FILES[$input]['name']);
            $config = array(
                    'upload_path'   => $path,
                    'overwrite'     => TRUE,
                    'file_name'     => $filename,
                    'allowed_types' => 'pdf',
                    'max_size'      => '90000'
            );

            $CI->upload->initialize($config);
            if ( ! $CI->upload->do_upload($input))
            {
                return send_json_error($CI->upload->display_errors());
            }
            else 
            {
                $data = $CI->upload->data();
                return $data['file_name'];
            }
        }
        else{
            return NULL;
        }
    }
}





	if (!function_exists('get_ciudad_by_cp'))
	{
		function get_ciudad_by_cp($codigo_postal)
		{	$CI =& get_instance();
			$CI->load->model('empresa/Empresa_model','empresa');
			$zona = $CI->empresa->get_ciudad_mpio_estado($codigo_postal);	
			return $zona['cp_ciudad'];
		}		
		 
	}



	if (!function_exists('get_zonificacion_193'))
	{
		function get_zonificacion_193($codigo_postal)
		{	
		
			$CI =& get_instance();
			$CI->load->model('empresa/Empresa_model','empresa');
			$zona = $CI->empresa->get_ciudad_mpio_estado($codigo_postal);
			
			if ($zona['estado'] == 'AGUASCALIENTES')
			{
				$zonificación=1500.0;
				
			}
			elseif ($zona['cp_ciudad'] == 'LEÓN DE LOS ALDAMA')
			{
				$zonificación=1500.0; 
			}											
			elseif ($zona['estado'] == 'GUANAJUATO')
			{
				$zonificación=2700.0;
			}
			elseif ($zona['cp_ciudad'] == 'CUERNAVACA')
			{
				$zonificación=1500.0; 
			}											
			elseif ($zona['estado'] == 'PUEBLA')
			{
				$zonificación=2700.0;
			}
			elseif ($zona['estado'] == 'QUERÉTARO')
			{
				$zonificación=0.0;
			}
			elseif ($zona['estado'] == 'SAN LUIS POTOSÍ')
			{
				$zonificación=2700.0;
			}
			else	
			{
				$zonificación=0.0; 
			}
			
			return $zonificación; 
		}
		
		
	}


if (!function_exists('get_despachos'))
{
    function get_despachos($emp_id)
    {
        $CI =& get_instance();
        $desp_ids = array();
        $CI->load->model('empresa/Despacho_model','despacho');
        $despachos = $CI->despacho->get($emp_id);
        if($despachos){
            foreach($despachos as $despacho){
                array_push($desp_ids,$despacho['emp_id']);
            }
        }
        return $desp_ids;
    }
}


if (!function_exists('get_si_no_by_1_0'))
{
    function get_si_no_by_1_0($id)
    {
        if($id == 0)
		{
			return 'NO';
        }
		elseif($id == 1)
        {
			return 'SI';
        }
		else
        {
			return '';
        }			
    }
}

if (!function_exists('get_1_0_by_si_no'))
{
    function get_1_0_by_si_no($id)
    {
        if($id == 'SI')
		{
			return 1;
        }
		else
		{
			return 0;
        }	
			
    }
}


if (!function_exists('cabecera_nota_venta'))
{
    function cabecera_nota_venta($titulaje,$titulo,$persona,$recibido,$emp_giro,$emp_razon_social,$impresion='',$solicita='LA EMPRESA CLIENTE',$fsm_id=0,$c1=0)
    {
		$azul_hc='#4B5682'; /*azul solido*/
		$gris_rata='#acacac';		
		$gris_raty='#e9e9e9';
		
		$fondo_titular_a='#00004d';/*azul solido*/
		$letras_titulares_a='#fff';
		$fondo_cinta_a='#00004d';  /*azul solido*/
		$letras_cinta_a='#fff';
		
		
		
		$borde_b=0; //1;
		$fondo_titular_b=  '#ffffff'; //'#e9e9e9';  //'#4B5682'; //'#acacac'; //'#fff';  //'#000000'; ///*azul claro*/
		$letras_titulares_b= '#000000'; //'#ffffff';  // '#000'; //'#fff'; //'#ffffff';
		$fondo_cinta_b=  '#ffffff';//'#e9e9e9';  //'#4B5682'; //'#acacac'; //'#fff';  //'#000000'; ///*azul claro*/
		$letras_cinta_b= '#000000'; //'#ffffff';  // '#000'; //'#fff'; //'#ffffff';		

		$size_titulo_b='font-size:117%';
	
$emp_giro=$emp_giro; //.'1';

	if ($emp_giro == 'SEGURIDAD')
	{
	 $b_color=$fondo_titular_a;
	 
	?>
    <img src="<?php echo base_url('../dist/images/logo_2.png'); ?>" width="300px" />
    <h3 align="center"><?php echo $titulo;?></h3>
    <h4>DATOS DEL SOLICITANTE</h4>
    <table border="1" cellpadding="3">
        <tr>
            <td align="center" style="background-color: <?php echo $b_color;?>;">
                <b style="color: <?php echo $letras_titulares_a;?>;">NOMBRE</b>
            </td>
            <td align="center" style="background-color: <?php echo $b_color;?>;">
                <b style="color: <?php echo $letras_titulares_a;?>;">RFC</b>
            </td>
        </tr>
        <tr>
            <td align="center">
                <?php echo $persona['clte_paterno'].' '.$persona['clte_materno'].' '.$persona['clte_nombre'].' '.$persona['clte_2_nombre']; ?>
            </td>
            <td align="center">
                <?php echo $persona['clte_rfc']; ?>
            </td>
        </tr>
    </table>
   <h4>
        EMPRESA EN LA QUE LABORA O ASPIRA A INGRESAR
    </h4>
    <h3 align="center" style="border: 1px solid #000; width: 50%; display: inline-block;"><?php echo $emp_razon_social; ?></h3>
	
    <table border="0" cellpadding="2">
        <tr>
            <td>
                <b style="color: <?php echo $letras_titulares_a;?>;">NOMBRE</b>
            </td>
        </tr>
    </table>
	
	<?php
	
	if ($titulo == 'GONADOTROPINA CORIÓNICA HUMANA')
	{
		$titulo='PRUEBA GONADOTROPINA CORIÓNICA HUMANA (hCG)';
	}	
	
	
	if ($titulaje == 1)
	{
	 ?>
	 <table border="0" >
            <tr>
                <td align="center" style="background-color: <?php echo $fondo_cinta_a;?>; width: 175px;"><b  style="color: <?php echo $letras_titulares_a;?>;">ESTUDIO</b></td>
				<td align="center" style="background-color: <?php echo $fondo_cinta_a;?>; width: 138px;"><b  style="color: <?php echo $letras_titulares_a;?>;">RESULTADO</b></td>
				<td align="center" style="background-color: <?php echo $fondo_cinta_a;?>; width: 45px;"><b  style="color: <?php echo $letras_titulares_a;?> ;">ANORMAL</b></td>
				<td align="center" style="background-color: <?php echo $fondo_cinta_a;?>; width: 60px;"><b  style="color: <?php echo $letras_titulares_a;?> ;">UNIDADES</b></td>	
				<td align="center" style="background-color: <?php echo $fondo_cinta_a;?>; width: 116px;"><b  style="color: <?php echo $letras_titulares_a;?> ;">REFERENCIA</b></td>				
            </tr>
		<!--	<tr>
				<td colspan="5"><b><?php echo $titulo;?></b></td>
			</tr> -->
	 </table>
	 
	<?php 
	}
	elseif ($titulaje == 2)
	{	
	?>
	 <table border="0" >
            <tr>
                <td align="center" style="background-color: <?php echo $fondo_cinta_a;?>; width: 33%;"><b  style="color: <?php echo $letras_titulares_a;?> ;">ESTUDIO</b></td>
				<td align="center" style="background-color: <?php echo $fondo_cinta_a;?>; width: 33%;"><b  style="color: <?php echo $letras_titulares_a;?> ;">RESULTADO</b></td>
				<td align="center" style="background-color: <?php echo $fondo_cinta_a;?>; width: 34%;"><b  style="color: <?php echo $letras_titulares_a;?> ;">REFERENCIA</b></td>				
            </tr>
		<!--	<tr>
				<td colspan="3"><b><?php echo $titulo;?></b></td>
			</tr>	-->		
	  </table>
	<?php
	}
	elseif ($titulaje == 3)
	{	
	?>

	<table border="0">
		<tr>
			<td align="center" style="background-color: <?php echo $fondo_cinta_a;?>; width: 175px;"><b  style="color: <?php echo $letras_titulares_a;?> ;">ESTUDIO:</b></td>
			<td align="center" style="background-color: <?php echo $fondo_cinta_a;?>; width: 356px;"><b  style="color: <?php echo $letras_titulares_a;?> ;">RESULTADO</b></td>
			<td align="center" style="background-color: <?php echo $fondo_cinta_a;?>; width: 1px;"><b  style="color: <?php echo $letras_titulares_a;?> ;"></b></td>
			<td align="center" style="background-color: <?php echo $fondo_cinta_a;?>; width: 1px;"><b  style="color: <?php echo $letras_titulares_a;?> ;"></b></td>	
			<td align="center" style="background-color: <?php echo $fondo_cinta_a;?>; width: 1px;"><b  style="color: <?php echo $letras_titulares_a;?> ;"></b></td>				
		</tr>
		<!--	<tr>
				<td colspan="5"><b><?php echo $titulo;?></b></td>
			</tr>	-->	
	</TABLE>
	  
	<?php
	}
	?>
<?php 
}
elseif ($emp_giro != 'SEGURIDAD')
{
	$b_color=$fondo_titular_b;
	
	 
?>

<table style="width: 100%">
	<tr>
		<td  style="width: 65%;"><img src="<?php echo base_url('../dist/images/logo_2.png'); ?>" width="200px" /></td>
		<td align="right" style="width: 35%;"><br><br><i><b style="color: <?php echo $letras_titulares_b;?>;"><?php echo 'ID: '.$persona['clte_id'].'-'.$fsm_id; ?></b></i></td>
	</tr>	
</table>
<table border="0" ><tr><td></td></tr></table>


<table border="<?php echo $borde_b;?>" cellpadding="3">
	<tr>
		<td align="center" style="background-color:  <?php echo $fondo_titular_b;?>; width: 60%;">
			<b style="color: <?php echo $letras_titulares_b;?>;">
			<?php 
			if  ( strstr( $solicita,'LA EMPRESA CLIENTE') ||  strstr( $solicita,'A QUIEN CORRESPONDA') || ( $solicita==''))
			{	
				echo 'EMPRESA QUE ADQUIERE';
			}
			else
			{
				echo 'PERSONA QUE ADQUIERE';
			}	
			?>
			</b>
		</td>
		<td align="center" style="background-color:  <?php echo $fondo_titular_b;?>; width: 20%;">
			<b style="color: <?php echo $letras_titulares_b;?>;"><?php if ($c1==1) {echo 'FECHA DE COMPRA';} else {echo 'FECHA DE RECIBO';} ?></b>
		</td>
		<td align="center" style="background-color:  <?php echo $fondo_titular_b;?>; width: 20%;">
		<!--	<b style="color: <?php echo $letras_titulares_b;?>;">FECHA DE IMPRESIÓN</b> -->
		</td>		
	</tr>
	<tr>
		<td align="center">
			<?php
			if  (( $solicita == 'LA EMPRESA CLIENTE') || ( $solicita == 'A QUIEN CORRESPONDA') || ( $solicita==''))
			{	
				echo $emp_razon_social;
			}
			else
			{
				echo $solicita;
			}	
			?>		
		</td>
		<td align="center">
			<?php echo formatea_fecha($recibido) ; ?>
		</td>
		<!-- <td align="center"><?php if ($impresion == '') {echo formatea_fecha(date('Y-m-d H:i:s'));}else{echo formatea_fecha(date('Y-m-d H:i:s')); /*formatea_fecha($impresion);*/} ?></td>	-->	
	</tr>
</table>

<table border="<?php echo $borde_b;?>" cellpadding="3">
	<tr>
		<td align="center" style="background-color:   <?php echo $fondo_titular_b;?>; width: 60%;">
			<b style="color: <?php echo $letras_titulares_b;?>;">NOMBRE</b>
		</td>
		
		

		<td align="center" style="background-color:   <?php echo $fondo_titular_b;?>; width: 20%;">
		<!--	<b style="color: <?php echo $letras_titulares_b;?>;">FECHA DE NACIMIENTO</b> -->
		</td>

		<td align="center" style="background-color:   <?php echo $fondo_titular_b;?>; width: 20%;">
		<!--	<b style="color: <?php echo $letras_titulares_b;?>;">GÉNERO</b> -->
		</td>		
	</tr>
	<tr>
		<td align="center">
			<?php echo $persona['clte_nombre'].' '.$persona['clte_2_nombre'].' '.$persona['clte_paterno'].' '.$persona['clte_materno']; ?>
		</td>
		

		<td align="center">
<!--			<?php echo formatea_fecha($persona['clte_f_nac']) ; ?> -->
		</td>		

		
		<td align="center"> <!--
			 <?php 
				if ($persona['clte_genero_cve'] == "H")
				{
					echo "MASCULINO";
				}
				else
				{
					echo "FEMENINO";
				}
			  ?> -->
		</td>		
	</tr>
</table>


	<table border="0" >
		<tr>
			<td><hr></td>
		</tr>
	</table>

	


	<?php
	if ($titulaje == 1)
	{
	 ?>
	 <table border="0" >
            <tr>
                <td align="center" style="background-color: <?php echo $fondo_cinta_b;?>; width: 33%;"><b  style="color: <?php echo $letras_cinta_b;?>;">ESTUDIO <?php //echo $titulo;?></b></td>
				<td align="center" style="background-color: <?php echo $fondo_cinta_b;?>; width: 25%;"><b  style="color: <?php echo $letras_cinta_b;?>;">RESULTADO</b></td>
				<td align="center" style="background-color: <?php echo $fondo_cinta_b;?>; width: 10%;"><b  style="color: <?php echo $letras_cinta_b;?>;">ANORMAL</b></td>
				<td align="center" style="background-color: <?php echo $fondo_cinta_b;?>; width: 10%;"><b  style="color: <?php echo $letras_cinta_b;?>;">UNIDADES</b></td>	
				<td align="center" style="background-color: <?php echo $fondo_cinta_b;?>; width: 22%;"><b  style="color: <?php echo $letras_cinta_b;?>;">REFERENCIA</b></td>				
            </tr>
			<tr>
				<td style="<?php echo $size_titulo_b; ?>;" colspan="5"><b><?php echo $titulo;?></b></td>
			</tr>				
	 </table>         
	<?php 
	}elseif ($titulaje == 2)
	{	
	?>
	 <table border="0" >
            <tr>
                 <td align="center" style="background-color: <?php echo $fondo_cinta_b;?>; width: 33%;"><b  style="color: <?php echo $letras_cinta_b;?>;">ESTUDIO <?php //echo $titulo;?></b></td>
				<td align="center" style="background-color: <?php echo $fondo_cinta_b;?>; width: 33%;"><b  style="color: <?php echo $letras_cinta_b;?>;">RESULTADO</b></td>
				<td align="center" style="background-color: <?php echo $fondo_cinta_b;?>; width: 34%;"><b  style="color: <?php echo $letras_cinta_b;?>;">REFERENCIA</b></td>				
            </tr>
			<tr>
				<td style="<?php echo $size_titulo_b; ?>;" colspan="3"><b><?php echo $titulo;?></b></td>
			</tr>			
	  </table>
	<?php
	}
	elseif ($titulaje == 3)
	{	
	?>

	<table border="0">
		<tr>
			<td align="center" style="background-color: <?php echo $fondo_cinta_b;?>; width: 175px;"><b  style="color: <?php echo $letras_cinta_b;?>;">ESTUDIO</b></td>
			<td align="center" style="background-color: <?php echo $fondo_cinta_b;?>; width: 356px;"><b  style="color: <?php echo $letras_cinta_b;?>;">RESULTADO</b></td>
			<td align="center" style="background-color: <?php echo $fondo_cinta_b;?>; width: 1px;"><b  style="color: <?php echo $letras_cinta_b;?>;"></b></td>
			<td align="center" style="background-color: <?php echo $fondo_cinta_b;?>; width: 1px;"><b  style="color: <?php echo $letras_cinta_b;?>;"></b></td>	
			<td align="center" style="background-color: <?php echo $fondo_cinta_b;?>; width: 1px;"><b  style="color: <?php echo $letras_cinta_b;?>;"></b></td>				
		</tr>
			<tr>
				<td style="<?php echo $size_titulo_b; ?>;"  colspan="5"><b><?php echo $titulo;?></b></td>
			</tr>		
	</TABLE>
	  
	<?php
	}elseif ($titulaje == 4)
	{	
	?>

	<table border="0">
		<tr>
			<td align="center" style="background-color: <?php echo $fondo_cinta_b;?>; width: 175px;"><b  style="color: <?php echo $letras_cinta_b;?>;"></b></td>
			<td align="center" style="background-color: <?php echo $fondo_cinta_b;?>; width: 356px;"><b  style="color: <?php echo $letras_cinta_b;?>;"></b></td>
			<td align="center" style="background-color: <?php echo $fondo_cinta_b;?>; width: 1px;"><b  style="color: <?php echo $letras_cinta_b;?>;"></b></td>
			<td align="center" style="background-color: <?php echo $fondo_cinta_b;?>; width: 1px;"><b  style="color: <?php echo $letras_cinta_b;?>;"></b></td>	
			<td align="center" style="background-color: <?php echo $fondo_cinta_b;?>; width: 1px;"><b  style="color: <?php echo $letras_cinta_b;?>;"></b></td>				
		</tr>
			<tr>
				<td style="<?php echo $size_titulo_b; ?>;"  colspan="5"><b><?php echo $titulo;?></b></td>
			</tr>		
	</TABLE>
	  
	<?php
	}elseif ($titulaje == 5)
	{	
	?>
	<table border="0">

			<tr>
				<td style="<?php echo $size_titulo_b; ?>;"  colspan="5"><b><?php echo $titulo;?></b></td>
			</tr>		
	</TABLE>
	  
	<?php
	}
	?>
<?php 	
}
else
{
$b_color=$gris_rata;
?>
<p>&nbsp;</p>
    <table>
		<tr>
			<td align="left">
				<img src="<?php echo base_url('../dist/images/logo_2.png'); ?>" width="170px" />
			</td>
		</tr>
	</table>
	
    <table border="0" class="table">
        <tr>
            <td align="center"   style="background-color: <?php echo $b_color;?>; width: 240px"><b>NOMBRE DEL PACIENTE</b></td>
            <td align="center" style="background-color: <?php echo $b_color;?>; width: 55px"><b>EDAD</b></td>
            <td align="center" style="background-color: <?php echo $b_color;?>; width: 65px"><b>SEXO</b></td>
            <td align="center" style="background-color: <?php echo $b_color;?>; width: 173px"><b>EMPRESA SOLICITANTE</b></td>			
        </tr>

        <tr>
            <td align="center"><?php echo $persona['clte_nombre'].' '.$persona['clte_2_nombre'].' '.$persona['clte_paterno'].' '.$persona['clte_materno']; ?>
            </td>
            <td align="center">
                <?php echo str_replace("años", "AÑOS", get_edad($persona['clte_f_nac'])) ; ?>
            </td>

            <td align="center">
                <?php 
				if ($persona['clte_genero_cve'] == "H")
				{
					echo "M";
				}
				else
				{
					echo "F";
				}
				?>
            </td>

            <td align="center"><?php echo $emp_razon_social; ?></td>
        </tr>
	</table>
	
    <table border="0" class="table">
        <tr>
            <td align="center"   style="background-color: <?php echo $b_color;?>; width: 177px"><b>IDENTIFICACIÓN - ODT</b></td>
            <td align="center" style="background-color: <?php echo $b_color;?>; width: 177px"><b>FECHA RECIBIDO</b></td>
            <td align="center" style="background-color: <?php echo $b_color;?>; width: 178px"><b>FECHA DE IMPRESIÓN</b></td>
        </tr>

        <tr>
            <td align="center" ></td>
            <td align="center">
                <?php echo formatea_fecha($recibido) ; ?>
            </td>
            <td align="center"><?php echo formatea_fechahora(date('Y-m-d H:i:s')); ?></td>
        </tr>		
	</TABLE>
	
	<table border="0">
		<tr>
			<td align="left" style="background-color: <?php echo $b_color;?>; width: 175px;"><b>ESTUDIO: EXÁMEN GENERAL DE ORINA</b></td>
			<td align="center" style="background-color: <?php echo $b_color;?>; width: 138px;"><b>RESULTADO</b></td>
			<td align="center" style="background-color: <?php echo $b_color;?>; width: 45px;"><b>ANORMAL</b></td>
			<td align="center" style="background-color: <?php echo $b_color;?>; width: 60px;"><b>UNIDADES</b></td>	
			<td align="center" style="background-color: <?php echo $b_color;?>; width: 116px;"><b>REFERENCIA</b></td>				
		</tr>
	</TABLE>
	
<?php 
}

    }

	
}







/*******************************************/
if (!function_exists('cabecera_reporte_lab_sp'))
{
    function cabecera_reporte_lab_sp($persona,$fsm_id,$fsm_f)
    {
		$azul_hc='#4B5682'; /*azul solido*/
		$gris_rata='#acacac';		
		$gris_raty='#e9e9e9';
		
		$fondo_titular_a='#00004d';/*azul solido*/
		$letras_titulares_a='#fff';
		$fondo_cinta_a='#00004d';  /*azul solido*/
		$letras_cinta_a='#fff';
		
		
		
		$borde_b=0; //1;
		$fondo_titular_b=  '#ffffff'; //'#e9e9e9';  //'#4B5682'; //'#acacac'; //'#fff';  //'#000000'; ///*azul claro*/
		$letras_titulares_b= '#000000'; //'#ffffff';  // '#000'; //'#fff'; //'#ffffff';
		$fondo_cinta_b=  '#ffffff';//'#e9e9e9';  //'#4B5682'; //'#acacac'; //'#fff';  //'#000000'; ///*azul claro*/
		$letras_cinta_b= '#000000'; //'#ffffff';  // '#000'; //'#fff'; //'#ffffff';		

		$size_titulo_b='font-size:117%';
		
		
		?>
		
		<table style="width: 100%">
			<tr>
				<!-- <img src="<?php echo base_url('../dist/images/logo_2.png'); ?>" width="200px" />-->
				<td  style="width: 65%;"><img src="<?php echo "./../../files/imagenes/logo_2.png"; ?>" width="200px" /></td>
				<td align="right" style="width: 35%;"><br><br><i><b style="color: <?php echo $letras_titulares_b;?>;"><?php echo 'ID: '.$persona['clte_id'].'-'.$fsm_id; ?></b></i></td>
			</tr>	
		</table>
		<table border="0" class="table">        
			 <tr>
				<td></td>
			</tr>
		</table>
		<table border="0" class="table">
			<tr>
				<td align="LEFT"   style="font-size: 125%; background-color: #e9e9e9; width: 233px"><b>NOMBRE DEL PACIENTE</b></td>
				<td align="center" style="font-size: 125%; background-color: #e9e9e9; width: 75px"><b>EDAD</b></td>
				<td align="center" style="font-size: 125%; background-color: #e9e9e9; width: 75px"><b>SEXO</b></td>
				<td align="center" style="font-size: 125%; background-color: #e9e9e9; width: 150px"><b>MÉDICO SOLITANTE</b></td>			
			</tr>

			<tr style="font-size: 125%;">
				<td class="auto-style3"><?php echo $persona['clte_nombre'].' '.$persona['clte_2_nombre'].' '.$persona['clte_paterno'].' '.$persona['clte_materno']; ?>
				</td>
				<td align="center">
					<?php echo str_replace("años", "", get_edad($persona['clte_f_nac'])) ; ?>
				</td>

				<td align="center">
					<?php 
					if ($persona['clte_genero_cve'] == "H")
					{
						echo "MASCULINO";
					}
					else
					{
						echo "FEMENINO";
					}
					?>
				</td>

				<td align="center"><?php echo 'A QUIEN CORRESPONDA';//echo $fsm['gs_medico_sol']; ?></td>
			</tr>
		</TABLE>	
		
		<table border="0" class="table">        
			 <tr>
				<td align="LEFT" style="font-size: 125%; background-color: #e9e9e9;  width: 150px"><b>IDENTIFICACIÓN DEL PACIENTE</b></td>
				<td align="LEFT" style="font-size: 125%; background-color: #e9e9e9;  width: 55px"><b></b></td>
				<td align="center" style="font-size: 125%; background-color: #e9e9e9; width: 165px"><b>FECHA RECIBIDO</b></td>
				<td align="center" style="font-size: 125%; background-color: #e9e9e9; width: 163px"><b>FECHA IMPRESIÓN</b></td>
			</tr>
			<tr style="font-size: 125%;">
				<td align="CENTER" ><?php echo $persona['clte_rfc']; ?></td>
				<td align="CENTER" ></td>
				<td align="center" ><?php echo formatea_fecha($fsm_f); ?></td>
				<td align="center"><?php echo formatea_fecha(date("Y-m-d")); ?></td>
			</tr>	
		</table>	

		<table border="0" class="table">        
			 <tr>
				<td></td>
			</tr>
		</table>
		
	<?php	
		
		

	}
}


/*****************************************/
if (!function_exists('cabecera_reporte_analisis_riesgo'))
{
    function cabecera_reporte_analisis_riesgo($titulaje,$titulo,$objeto,$recibido,$fsm_id)
    {
		$azul_hc='#4B5682'; /*azul solido*/
		$gris_rata='#acacac';		
		$gris_raty='#e9e9e9';
		
		$fondo_titular_a='#00004d';/*azul solido*/
		$letras_titulares_a='#fff';
		$fondo_cinta_a='#00004d';  /*azul solido*/
		$letras_cinta_a='#fff';
		
		
		
		$borde_b=0; //1;
		$fondo_titular_b=  '#ffffff'; //'#e9e9e9';  //'#4B5682'; //'#acacac'; //'#fff';  //'#000000'; ///*azul claro*/
		$letras_titulares_b= '#000000'; //'#ffffff';  // '#000'; //'#fff'; //'#ffffff';
		$fondo_cinta_b=  '#ffffff';//'#e9e9e9';  //'#4B5682'; //'#acacac'; //'#fff';  //'#000000'; ///*azul claro*/
		$letras_cinta_b= '#000000'; //'#ffffff';  // '#000'; //'#fff'; //'#ffffff';		

		$size_titulo_b='font-size:117%';
		$CIs = &get_instance();
		$CIs->load->model('persona/Persona_model', 'cliente');
		$el_objeto=$CIs->cliente->get($objeto['clte_id']);
		
		$emp_giro='1'; //$emp_giro; 

			$b_color=$fondo_titular_b;
		?>

			<table style="width: 100%">
				<tr>
					<td  style="width: 65%;"><img src="<?php echo "./../../files/imagenes/logo_2.png"; ?>" width="200px" /></td>
						<td align="right" style="width: 35%;"><br><br><i><b style="color: <?php echo $letras_titulares_b;?>;"><?php echo 'ID: '.$objeto['clte_id'].'-'.$fsm_id; ?></b></i></td>
				</tr>	
			</table>
			
			<table border="0" >
				<tr>
					<td></td>
				</tr>
			</table>


			<table border="<?php echo $borde_b;?>" cellpadding="3">
				<tr>
					<td align="center" style="background-color:  <?php echo $fondo_titular_b;?>; width: 40%;">
						<b style="color: <?php echo $letras_titulares_b;?>;">
						<?php echo 'ASEGURADORA';	?>
						</b>
					</td>				
					<td align="center" style="background-color:   <?php echo $fondo_titular_b;?>; width: 40%;">
						<b style="color: <?php echo $letras_titulares_b;?>;">EMPRESA EN ANÁLISIS</b>
					</td>
					<td align="center" style="background-color:   <?php echo $fondo_titular_b;?>; width: 20%;">
						<b style="color: <?php echo $letras_titulares_b;?>;">FECHA DEL ESTUDIO</b>
					</td>
				</tr>
				<tr>
					<td align="center">
							<?php echo get_matriz(get_corporacion($el_objeto['emp_id']) ); ?>	
					</td>			
					<td align="center">
							<?php echo get_empresa($el_objeto['emp_id']); ?>
					</td>
					<td align="center">
						<?php echo formatea_fecha($recibido) ; ?>
					</td>		
				</tr>
			</table>
			

			<table border="0" >
				<tr>
					<td><hr></td>
				</tr>
			</table>

	<?php
	if ($titulaje == 1)
	{
	 ?>
	 <table border="0" >
			<tr>
				<td align="center" style="<?php echo $size_titulo_b; ?>;" colspan="5"><b><?php echo $titulo;?></b></td>
			</tr>				
	 </table>         
	<?php 
	}elseif ($titulaje == 2)
	{	
	?>
	 <table border="0" >
            <tr>
                 <td align="center" style="background-color: <?php echo $fondo_cinta_b;?>; width: 33%;"><b  style="color: <?php echo $letras_cinta_b;?>;">ESTUDIO <?php //echo $titulo;?></b></td>
				<td align="center" style="background-color: <?php echo $fondo_cinta_b;?>; width: 33%;"><b  style="color: <?php echo $letras_cinta_b;?>;">RESULTADO</b></td>
				<td align="center" style="background-color: <?php echo $fondo_cinta_b;?>; width: 34%;"><b  style="color: <?php echo $letras_cinta_b;?>;">REFERENCIA</b></td>				
            </tr>
			<tr>
				<td style="<?php echo $size_titulo_b; ?>;" colspan="3"><b><?php echo $titulo;?></b></td>
			</tr>			
	  </table>
	<?php
	}
	elseif ($titulaje == 3)
	{	
	?>
	<table border="0">
		<tr>
			<td align="center" style="background-color: <?php echo $fondo_cinta_b;?>; width: 175px;"><b  style="color: <?php echo $letras_cinta_b;?>;">ESTUDIO</b></td>
			<td align="center" style="background-color: <?php echo $fondo_cinta_b;?>; width: 356px;"><b  style="color: <?php echo $letras_cinta_b;?>;">RESULTADO</b></td>
			<td align="center" style="background-color: <?php echo $fondo_cinta_b;?>; width: 1px;"><b  style="color: <?php echo $letras_cinta_b;?>;"></b></td>
			<td align="center" style="background-color: <?php echo $fondo_cinta_b;?>; width: 1px;"><b  style="color: <?php echo $letras_cinta_b;?>;"></b></td>	
			<td align="center" style="background-color: <?php echo $fondo_cinta_b;?>; width: 1px;"><b  style="color: <?php echo $letras_cinta_b;?>;"></b></td>				
		</tr>
			<tr>
				<td style="<?php echo $size_titulo_b; ?>;"  colspan="5"><b><?php echo $titulo;?></b></td>
			</tr>		
	</TABLE>
	  
	<?php
	}elseif ($titulaje == 4)
	{	
	?>

	<table border="0">
		<tr>
			<td align="center" style="background-color: <?php echo $fondo_cinta_b;?>; width: 175px;"><b  style="color: <?php echo $letras_cinta_b;?>;"></b></td>
			<td align="center" style="background-color: <?php echo $fondo_cinta_b;?>; width: 356px;"><b  style="color: <?php echo $letras_cinta_b;?>;"></b></td>
			<td align="center" style="background-color: <?php echo $fondo_cinta_b;?>; width: 1px;"><b  style="color: <?php echo $letras_cinta_b;?>;"></b></td>
			<td align="center" style="background-color: <?php echo $fondo_cinta_b;?>; width: 1px;"><b  style="color: <?php echo $letras_cinta_b;?>;"></b></td>	
			<td align="center" style="background-color: <?php echo $fondo_cinta_b;?>; width: 1px;"><b  style="color: <?php echo $letras_cinta_b;?>;"></b></td>				
		</tr>
			<tr>
				<td style="<?php echo $size_titulo_b; ?>;"  colspan="5"><b><?php echo $titulo;?></b></td>
			</tr>		
	</TABLE>
	  
	<?php
	}elseif ($titulaje == 5)
	{	
	?>
	<table border="0">

			<tr>
				<td style="<?php echo $size_titulo_b; ?>;"  colspan="5"><b><?php echo $titulo;?></b></td>
			</tr>		
	</TABLE>
	  
	<?php
	}


    }

	
}


/*****************************************/
if (!function_exists('cabecera_reporte_analisis'))
{
    function cabecera_reporte_analisis($titulaje,$titulo,$persona,$recibido,$emp_giro,$emp_razon_social,$impresion='',$solicita='LA EMPRESA CLIENTE',$fsm_id=0,$c1=0)
    {
		$azul_hc='#4B5682'; /*azul solido*/
		$gris_rata='#acacac';		
		$gris_raty='#e9e9e9';
		
		$fondo_titular_a='#00004d';/*azul solido*/
		$letras_titulares_a='#fff';
		$fondo_cinta_a='#00004d';  /*azul solido*/
		$letras_cinta_a='#fff';
		
		
		
		$borde_b=0; //1;
		$fondo_titular_b=  '#ffffff'; //'#e9e9e9';  //'#4B5682'; //'#acacac'; //'#fff';  //'#000000'; ///*azul claro*/
		$letras_titulares_b= '#000000'; //'#ffffff';  // '#000'; //'#fff'; //'#ffffff';
		$fondo_cinta_b=  '#ffffff';//'#e9e9e9';  //'#4B5682'; //'#acacac'; //'#fff';  //'#000000'; ///*azul claro*/
		$letras_cinta_b= '#000000'; //'#ffffff';  // '#000'; //'#fff'; //'#ffffff';		

		$size_titulo_b='font-size:117%';
	
		$emp_giro='1'; //$emp_giro; 

		if ($emp_giro != 'SEGURIDAD')
		{
			$b_color=$fondo_titular_b;
		?>

			<table style="width: 100%">
				<tr>
					<td  style="width: 65%;"><img src="<?php echo "./../../files/imagenes/logo_2.png"; ?>" width="200px" /></td>
					<td align="right" style="width: 35%;"><br><br><i><b style="color: <?php echo $letras_titulares_b;?>;"><?php echo 'ID: '.$persona['clte_id'].'-'.$fsm_id; ?></b></i></td>
				</tr>	
			</table>
			
			<table border="0" >
				<tr>
					<td></td>
				</tr>
			</table>


			<table border="<?php echo $borde_b;?>" cellpadding="3">
				<tr>
					<td align="center" style="background-color:  <?php echo $fondo_titular_b;?>; width: 40%;">
						<b style="color: <?php echo $letras_titulares_b;?>;">
						<?php 
						if  ( strstr( $solicita,'LA EMPRESA CLIENTE') ||  strstr( $solicita,'A QUIEN CORRESPONDA') || ( $solicita==''))
						{	
							echo 'EMPRESA SOLICITANTE';
						}
						else
						{
							echo 'MÉDICO';
						}	
						?>
						</b>
					</td>				
					<td align="center" style="background-color:   <?php echo $fondo_titular_b;?>; width: 40%;">
						<b style="color: <?php echo $letras_titulares_b;?>;">EMPRESA DE ESTUDIO</b>
					</td>
					<td align="center" style="background-color:   <?php echo $fondo_titular_b;?>; width: 20%;">
						<b style="color: <?php echo $letras_titulares_b;?>;">FECHA DEL ESTUDIO</b>
					</td>
				</tr>
				<tr>
					<td align="center">
						<?php
						if  (( $solicita == 'LA EMPRESA CLIENTE') || ( $solicita == 'A QUIEN CORRESPONDA') || ( $solicita==''))
						{	
							echo $emp_razon_social;
						}
						else
						{
							echo $solicita;
						}	
						?>		
					</td>			
					<td align="center">
						<?php echo $persona['clte_nombre'].' '.$persona['clte_2_nombre'].' '.$persona['clte_paterno'].' '.$persona['clte_materno']; ?>
					</td>
					<td align="center">
						<?php echo formatea_fecha($recibido) ; ?>
					</td>		
				</tr>
			</table>
			
			
			<!--
			<table border="<?php echo $borde_b;?>" cellpadding="3">
				<tr>
					<td align="center" style="background-color:   <?php echo $fondo_titular_b;?>; width: 60%;">
						<b style="color: <?php echo $letras_titulares_b;?>;">NOMBRE</b>
					</td>
					<td align="center" style="background-color:   <?php echo $fondo_titular_b;?>; width: 20%;">
						<b style="color: <?php echo $letras_titulares_b;?>;">FECHA DE NACIMIENTO</b>
					</td>
					<td align="center" style="background-color:   <?php echo $fondo_titular_b;?>; width: 20%;">
						<b style="color: <?php echo $letras_titulares_b;?>;">GÉNERO</b>
					</td>		
				</tr>
				<tr>
					<td align="center">
						<?php echo $persona['clte_nombre'].' '.$persona['clte_2_nombre'].' '.$persona['clte_paterno'].' '.$persona['clte_materno']; ?>
					</td>
					<td align="center">
						<?php echo formatea_fecha($persona['clte_f_nac']) ; ?>
					</td>		
					<td align="center">
						 <?php 
							if ($persona['clte_genero_cve'] == "H")
							{
								echo "MASCULINO";
							}
							else
							{
								echo "FEMENINO";
							}
						  ?>
					</td>		
				</tr>
			</table>

			<table border="<?php echo $borde_b;?>" cellpadding="3">
				<tr>
					<td align="center" style="background-color:  <?php echo $fondo_titular_b;?>; width: 60%;">
						<b style="color: <?php echo $letras_titulares_b;?>;">
						<?php 
						if  ( strstr( $solicita,'LA EMPRESA CLIENTE') ||  strstr( $solicita,'A QUIEN CORRESPONDA') || ( $solicita==''))
						{	
							echo 'EMPRESA SOLICITANTE';
						}
						else
						{
							echo 'MÉDICO';
						}	
						?>
						</b>
					</td>
					<td align="center" style="background-color:  <?php echo $fondo_titular_b;?>; width: 20%;">
						<b style="color: <?php echo $letras_titulares_b;?>;"><?php if ($c1==1) {echo 'FECHA DE TOMA';} else {echo 'FECHA DE RECIBO';} ?></b>
					</td>
					<td align="center" style="background-color:  <?php echo $fondo_titular_b;?>; width: 20%;">
						<b style="color: <?php echo $letras_titulares_b;?>;">FECHA DE IMPRESIÓN</b>
					</td>		
				</tr>
				<tr>
					<td align="center">
						<?php
						if  (( $solicita == 'LA EMPRESA CLIENTE') || ( $solicita == 'A QUIEN CORRESPONDA') || ( $solicita==''))
						{	
							echo $emp_razon_social;
						}
						else
						{
							echo $solicita;
						}	
						?>		
					</td>
					<td align="center">
						<?php echo formatea_fecha($recibido) ; ?>
					</td>
					<td align="center">
						<?php if ($impresion == '') {echo formatea_fecha(date('Y-m-d H:i:s'));}else{echo formatea_fecha(date('Y-m-d H:i:s')); } ?>
					</td>
				</tr>
			</table> -->

			<table border="0" >
				<tr>
					<td><hr></td>
				</tr>
			</table>

	<?php
	if ($titulaje == 1)
	{
	 ?>
	 <table border="0" >
 <!---           <tr>
                <td align="center" style="background-color: <?php echo $fondo_cinta_b;?>; width: 33%;"><b  style="color: <?php echo $letras_cinta_b;?>;">ESTUDIO <?php //echo $titulo;?></b></td>
				<td align="center" style="background-color: <?php echo $fondo_cinta_b;?>; width: 25%;"><b  style="color: <?php echo $letras_cinta_b;?>;">RESULTADO</b></td>
				<td align="center" style="background-color: <?php echo $fondo_cinta_b;?>; width: 10%;"><b  style="color: <?php echo $letras_cinta_b;?>;">ANORMAL</b></td>
				<td align="center" style="background-color: <?php echo $fondo_cinta_b;?>; width: 10%;"><b  style="color: <?php echo $letras_cinta_b;?>;">UNIDADES</b></td>	
				<td align="center" style="background-color: <?php echo $fondo_cinta_b;?>; width: 22%;"><b  style="color: <?php echo $letras_cinta_b;?>;">REFERENCIA</b></td>				
            </tr>
--->			
			<tr>
				<td align="center" style="<?php echo $size_titulo_b; ?>;" colspan="5"><b><?php echo $titulo;?></b></td>
			</tr>				
	 </table>         
	<?php 
	}elseif ($titulaje == 2)
	{	
	?>
	 <table border="0" >
            <tr>
                 <td align="center" style="background-color: <?php echo $fondo_cinta_b;?>; width: 33%;"><b  style="color: <?php echo $letras_cinta_b;?>;">ESTUDIO <?php //echo $titulo;?></b></td>
				<td align="center" style="background-color: <?php echo $fondo_cinta_b;?>; width: 33%;"><b  style="color: <?php echo $letras_cinta_b;?>;">RESULTADO</b></td>
				<td align="center" style="background-color: <?php echo $fondo_cinta_b;?>; width: 34%;"><b  style="color: <?php echo $letras_cinta_b;?>;">REFERENCIA</b></td>				
            </tr>
			<tr>
				<td style="<?php echo $size_titulo_b; ?>;" colspan="3"><b><?php echo $titulo;?></b></td>
			</tr>			
	  </table>
	<?php
	}
	elseif ($titulaje == 3)
	{	
	?>
	<table border="0">
		<tr>
			<td align="center" style="background-color: <?php echo $fondo_cinta_b;?>; width: 175px;"><b  style="color: <?php echo $letras_cinta_b;?>;">ESTUDIO</b></td>
			<td align="center" style="background-color: <?php echo $fondo_cinta_b;?>; width: 356px;"><b  style="color: <?php echo $letras_cinta_b;?>;">RESULTADO</b></td>
			<td align="center" style="background-color: <?php echo $fondo_cinta_b;?>; width: 1px;"><b  style="color: <?php echo $letras_cinta_b;?>;"></b></td>
			<td align="center" style="background-color: <?php echo $fondo_cinta_b;?>; width: 1px;"><b  style="color: <?php echo $letras_cinta_b;?>;"></b></td>	
			<td align="center" style="background-color: <?php echo $fondo_cinta_b;?>; width: 1px;"><b  style="color: <?php echo $letras_cinta_b;?>;"></b></td>				
		</tr>
			<tr>
				<td style="<?php echo $size_titulo_b; ?>;"  colspan="5"><b><?php echo $titulo;?></b></td>
			</tr>		
	</TABLE>
	  
	<?php
	}elseif ($titulaje == 4)
	{	
	?>

	<table border="0">
		<tr>
			<td align="center" style="background-color: <?php echo $fondo_cinta_b;?>; width: 175px;"><b  style="color: <?php echo $letras_cinta_b;?>;"></b></td>
			<td align="center" style="background-color: <?php echo $fondo_cinta_b;?>; width: 356px;"><b  style="color: <?php echo $letras_cinta_b;?>;"></b></td>
			<td align="center" style="background-color: <?php echo $fondo_cinta_b;?>; width: 1px;"><b  style="color: <?php echo $letras_cinta_b;?>;"></b></td>
			<td align="center" style="background-color: <?php echo $fondo_cinta_b;?>; width: 1px;"><b  style="color: <?php echo $letras_cinta_b;?>;"></b></td>	
			<td align="center" style="background-color: <?php echo $fondo_cinta_b;?>; width: 1px;"><b  style="color: <?php echo $letras_cinta_b;?>;"></b></td>				
		</tr>
			<tr>
				<td style="<?php echo $size_titulo_b; ?>;"  colspan="5"><b><?php echo $titulo;?></b></td>
			</tr>		
	</TABLE>
	  
	<?php
	}elseif ($titulaje == 5)
	{	
	?>
	<table border="0">

			<tr>
				<td style="<?php echo $size_titulo_b; ?>;"  colspan="5"><b><?php echo $titulo;?></b></td>
			</tr>		
	</TABLE>
	  
	<?php
	}
	?>
<?php 	
}

    }

	
}

/******************************************/
if (!function_exists('cabecera_reporte_lab_seguridad'))
{
    function cabecera_reporte_lab_seguridad($titulaje,$titulo,$persona,$recibido,$emp_giro,$emp_razon_social,$impresion='',$solicita='LA EMPRESA CLIENTE',$fsm_id=0,$c1=0)
    {
		$azul_hc='#4B5682'; 
		$gris_rata='#acacac';		
		$gris_raty='#e9e9e9';
		
		$fondo_titular_a='#00004d';
		$letras_titulares_a='#fff';
		$fondo_cinta_a='#00004d'; 
		$letras_cinta_a='#fff';
		
		
		
		$borde_b=0; //1;
		$fondo_titular_b=  '#ffffff'; 
		$letras_titulares_b= '#000000'; //'#ffffff';  // '#000'; //'#fff'; //'#ffffff';
		$fondo_cinta_b=  '#ffffff';//'#e9e9e9';  //'#4B5682'; //'#acacac'; //'#fff';  //'#000000'; ///*azul claro*/
		$letras_cinta_b= '#000000'; //'#ffffff';  // '#000'; //'#fff'; //'#ffffff';		

		$size_titulo_b='font-size:117%';
	
$emp_giro='1';

if ($emp_giro != 'SEGURIDAD')
{
	$b_color=$fondo_titular_b;
?>

	<table style="width: 100%">
		<tr>
		<!--	<td  style="width: 65%;"><img src="<?php echo base_url('../dist/images/logo_2.png'); ?>" width="200px" /></td> -->
			<td  style="width: 65%;"><img src="<?php echo "./../../files/imagenes/logo_2.png"; ?>" width="200px" /></td>
			<td align="right"  style="width: 35%;"><br><br><i><b style="color: <?php echo $letras_titulares_b;?>;"><?php echo 'ID: '.$persona['clte_id'].'-'.$fsm_id; ?></b></i></td>
		</tr>	
	</table>

		<table border="0" ><tr><td></td></tr></table>

		<table border="<?php echo $borde_b;?>" cellpadding="3">
			<tr>
				<td align="center" style="background-color:   <?php echo $fondo_titular_b;?>; width: 47%;">
					<b style="color: <?php echo $letras_titulares_b;?>;">NOMBRE</b>
				</td>
				<?php if($persona['emp_id']=311){
					?>
					<td align="center" style="background-color:   <?php echo $fondo_titular_b;?>; width: 20%;">
						<b style="color: <?php echo $letras_titulares_b;?>;">FECHA DE NACIMIENTO</b>
					</td>	
					<td align="center" style="background-color:   <?php echo $fondo_titular_b;?>; width: 14%;">
						<b style="color: <?php echo $letras_titulares_b;?>;">EDAD</b>
					</td>
					<?php
					}
					else{ 
					?>
					<td align="center" style="background-color:   <?php echo $fondo_titular_b;?>; width: 20%;">
						<b style="color: <?php echo $letras_titulares_b;?>;">FECHA DE NACIMIENTO</b>

					<td align="center" style="background-color:   <?php echo $fondo_titular_b;?>; width: 14%;">
						<b style="color: <?php echo $letras_titulares_b;?>;">RFC</b>
					</td>
					<?php 
					 }
					?>
				<?php
				if  ( $persona['clte_id'] == 338340)  
				{
				?>
				<td align="center" style="background-color:   <?php echo $fondo_titular_b;?>; width: 19%;">
					<b style="color: <?php echo $letras_titulares_b;?>;">EDAD</b>
				</td>		
				<?php
				}
				else
				{	
				?>
				<td align="center" style="background-color:   <?php echo $fondo_titular_b;?>; width: 20%;">
					<b style="color: <?php echo $letras_titulares_b;?>;">FECHA DE NACIMIENTO</b>
				</td>
				<?php
				}
				?>		
				
				<td align="center" style="background-color:   <?php echo $fondo_titular_b;?>; width: 19%;">
					<b style="color: <?php echo $letras_titulares_b;?>;">GÉNERO</b>
				</td>	
			</tr>
			<tr>
				<td align="center">
					<?php echo $persona['clte_nombre'].' '.$persona['clte_2_nombre'].' '.$persona['clte_paterno'].' '.$persona['clte_materno']; ?>
				</td>
				<?php
				if($persona['emp_id']==311){
					?>
				<td align="center">
					<?php echo str_replace("años", "AÑOS", get_edad($persona['clte_f_nac'])) ; ?>
				</td>
				<?php	
				}
				else{	
				?>	
				<td align="center">
					<?php echo $persona['clte_rfc']; ?>
				</td>
				<?php }
				?>

				<?php
				if  ( $persona['clte_id'] == 338340)  
				{
				?>
				<td align="center">
					<?php echo '60 AÑOS'; ?>
				</td>		
				<?php
				}
				else
				{	
				?>
				<td align="center">
					<?php echo formatea_fecha($persona['clte_f_nac']) ; ?>
				</td>		

				<?php
				}
				?>		
				
				<td align="center">
					 <?php 
						if ($persona['clte_genero_cve'] == "H")
						{
							echo "MASCULINO";
						}
						else
						{
							echo "FEMENINO";
						}
					  ?>
				</td>		
			</tr>
		</table>

		<table border="<?php echo $borde_b;?>" cellpadding="3">
			<tr>
				<td align="center" style="background-color:  <?php echo $fondo_titular_b;?>; width: 47%;">
					<b style="color: <?php echo $letras_titulares_b;?>;">
					<?php 
					if  ( strstr( $solicita,'LA EMPRESA CLIENTE') ||  strstr( $solicita,'A QUIEN CORRESPONDA') || ( $solicita==''))
					{	
						echo 'EMPRESA SOLICITANTE';
					}
					else
					{
						echo 'MÉDICO';
					}	
					?>
					</b>
				</td>
				<td align="center" style="background-color:  <?php echo $fondo_titular_b;?>; width: 28%;">
					<b style="color: <?php echo $letras_titulares_b;?>;"><?php if ($c1==1) {echo 'FECHA DE TOMA';} else {echo 'FECHA DE RECIBO';} ?></b>
				</td>
				<td align="center" style="background-color:  <?php echo $fondo_titular_b;?>; width: 25%;">
					<b style="color: <?php echo $letras_titulares_b;?>;">FECHA DE IMPRESIÓN</b>
				</td>		
			</tr>
			<tr>
				<td align="center">
					<?php
					if  (( $solicita == 'LA EMPRESA CLIENTE') || ( $solicita == 'A QUIEN CORRESPONDA') || ( $solicita==''))
					{	
						echo $emp_razon_social;
					}
					else
					{
						echo $solicita;
					}	
					?>		
				</td>
				<td align="center">
					<?php echo formatea_fecha($recibido) ; ?>
				</td>
				
				<?php
				if ((get_emp_cond_misma_fpdf($persona['emp_id']) == 1) ||
					($persona['emp_id'] == 360)
					)
				{
				?>
					<td align="center">
						<?php echo formatea_fecha($recibido) ; ?>
					</td>
				<?php
				}
				else
				{
					
					if (
						($persona['clte_id'] == 356391) ||
						($persona['clte_id'] == 356390) ||
						($persona['clte_id'] == 356389) ||
						($persona['clte_id'] == 356388) ||
						
						($persona['clte_id'] == 356387) ||
						($persona['clte_id'] == 356386) ||
						($persona['clte_id'] == 356385) ||
						($persona['clte_id'] == 356384) ||
						($persona['clte_id'] == 356383) ||
						($persona['clte_id'] == 356382) ||
						($persona['clte_id'] == 356381) 
						)
					{
					?>		
					<td align="center"><?php echo formatea_fecha($recibido); ?></td>		
					<?php				
					}
					else
					{
					?>
					<td align="center"><?php if ($impresion == '') {echo formatea_fecha(date('Y-m-d H:i:s'));} else {echo formatea_fecha(date('Y-m-d H:i:s')); /*formatea_fecha($impresion);*/} ?></td>		
					<?php
					}
				}
				?>
			</tr>
		</table>



	<table border="0" >
		<tr>
			<td><hr></td>
		</tr>
	</table>

	


			<?php
			if ($titulaje == 1)
			{
			 ?>
			 <table border="0" >
					<tr>
						<td align="center" style="background-color: <?php echo $fondo_cinta_b;?>; width: 33%;"><b  style="color: <?php echo $letras_cinta_b;?>;">ESTUDIO <?php //echo $titulo;?></b></td>
						<td align="center" style="background-color: <?php echo $fondo_cinta_b;?>; width: 25%;"><b  style="color: <?php echo $letras_cinta_b;?>;">RESULTADO</b></td>
						<td align="center" style="background-color: <?php echo $fondo_cinta_b;?>; width: 10%;"><b  style="color: <?php echo $letras_cinta_b;?>;">ANORMAL</b></td>
						<td align="center" style="background-color: <?php echo $fondo_cinta_b;?>; width: 10%;"><b  style="color: <?php echo $letras_cinta_b;?>;">UNIDADES</b></td>	
						<td align="center" style="background-color: <?php echo $fondo_cinta_b;?>; width: 22%;"><b  style="color: <?php echo $letras_cinta_b;?>;">REFERENCIA</b></td>				
					</tr>
					<tr>
						<td style="<?php echo $size_titulo_b; ?>;" colspan="5"><b><?php echo $titulo;?></b></td>
					</tr>				
			 </table>         
			<?php 
			}
			elseif ($titulaje == 2)
			{	
			?>
			 <table border="0" >
					<tr>
						 <td align="center" style="background-color: <?php echo $fondo_cinta_b;?>; width: 33%;"><b  style="color: <?php echo $letras_cinta_b;?>;">ESTUDIO <?php //echo $titulo;?></b></td>
						<td align="center" style="background-color: <?php echo $fondo_cinta_b;?>; width: 33%;"><b  style="color: <?php echo $letras_cinta_b;?>;">RESULTADO</b></td>
						<td align="center" style="background-color: <?php echo $fondo_cinta_b;?>; width: 34%;"><b  style="color: <?php echo $letras_cinta_b;?>;">REFERENCIA</b></td>				
					</tr>
					<tr>
						<td style="<?php echo $size_titulo_b; ?>;" colspan="3"><b><?php echo $titulo;?></b></td>
					</tr>			
			  </table>
			<?php
			}
			elseif ($titulaje == 3)
			{	
			?>

			<table border="0">
				<tr>
					<td align="center" style="background-color: <?php echo $fondo_cinta_b;?>; width: 175px;"><b  style="color: <?php echo $letras_cinta_b;?>;">ESTUDIO</b></td>
					<td align="center" style="background-color: <?php echo $fondo_cinta_b;?>; width: 356px;"><b  style="color: <?php echo $letras_cinta_b;?>;">RESULTADO</b></td>
					<td align="center" style="background-color: <?php echo $fondo_cinta_b;?>; width: 1px;"><b  style="color: <?php echo $letras_cinta_b;?>;"></b></td>
					<td align="center" style="background-color: <?php echo $fondo_cinta_b;?>; width: 1px;"><b  style="color: <?php echo $letras_cinta_b;?>;"></b></td>	
					<td align="center" style="background-color: <?php echo $fondo_cinta_b;?>; width: 1px;"><b  style="color: <?php echo $letras_cinta_b;?>;"></b></td>				
				</tr>
					<tr>
						<td style="<?php echo $size_titulo_b; ?>;"  colspan="5"><b><?php echo $titulo;?></b></td>
					</tr>		
			</TABLE>
			  
			<?php
			}
			elseif ($titulaje == 4)
			{	
			?>

			<table border="0">
				<tr>
					<td align="center" style="background-color: <?php echo $fondo_cinta_b;?>; width: 175px;"><b  style="color: <?php echo $letras_cinta_b;?>;"></b></td>
					<td align="center" style="background-color: <?php echo $fondo_cinta_b;?>; width: 356px;"><b  style="color: <?php echo $letras_cinta_b;?>;"></b></td>
					<td align="center" style="background-color: <?php echo $fondo_cinta_b;?>; width: 1px;"><b  style="color: <?php echo $letras_cinta_b;?>;"></b></td>
					<td align="center" style="background-color: <?php echo $fondo_cinta_b;?>; width: 1px;"><b  style="color: <?php echo $letras_cinta_b;?>;"></b></td>	
					<td align="center" style="background-color: <?php echo $fondo_cinta_b;?>; width: 1px;"><b  style="color: <?php echo $letras_cinta_b;?>;"></b></td>				
				</tr>
					<tr>
						<td style="<?php echo $size_titulo_b; ?>;"  colspan="5"><b><?php echo $titulo;?></b></td>
					</tr>		
			</TABLE>
			  
			<?php
			}
			elseif ($titulaje == 5)
			{	
			?>
			<table border="0">

					<tr>
						<td style="<?php echo $size_titulo_b; ?>;"  colspan="5"><b><?php echo $titulo;?></b></td>
					</tr>		
			</TABLE>
			  
			<?php
			}
			?>
<?php 	
}
else
{
$b_color=$gris_rata;
?>
<p>&nbsp;</p>
    <table>
		<tr>
			<td align="left">
				<!-- <img src="<?php echo base_url('../dist/images/logo_2.png'); ?>" width="170px" />-->
				<img src="<?php echo "./../../files/imagenes/logo_2.png"; ?>" width="170px" />
			</td>
		</tr>
	</table>
	
    <table border="0" class="table">
        <tr>
            <td align="center"   style="background-color: <?php echo $b_color;?>; width: 240px"><b>NOMBRE DEL PACIENTE</b></td>
            <td align="center" style="background-color: <?php echo $b_color;?>; width: 55px"><b>EDAD</b></td>
            <td align="center" style="background-color: <?php echo $b_color;?>; width: 65px"><b>SEXO</b></td>
            <td align="center" style="background-color: <?php echo $b_color;?>; width: 173px"><b>EMPRESA SOLICITANTE</b></td>			
        </tr>

        <tr>
            <td align="center"><?php echo $persona['clte_nombre'].' '.$persona['clte_2_nombre'].' '.$persona['clte_paterno'].' '.$persona['clte_materno']; ?>
            </td>
            <td align="center">
                <?php echo str_replace("años", "AÑOS", get_edad($persona['clte_f_nac'])) ; ?>
            </td>

            <td align="center">
                <?php 
				if ($persona['clte_genero_cve'] == "H")
				{
					echo "M";
				}
				else
				{
					echo "F";
				}
				?>
            </td>

            <td align="center"><?php echo $emp_razon_social; ?></td>
        </tr>
	</table>
	
    <table border="0" class="table">
        <tr>
            <td align="center"   style="background-color: <?php echo $b_color;?>; width: 177px"><b>IDENTIFICACIÓN - ODT</b></td>
            <td align="center" style="background-color: <?php echo $b_color;?>; width: 177px"><b>FECHA RECIBIDO</b></td>
            <td align="center" style="background-color: <?php echo $b_color;?>; width: 178px"><b>FECHA DE IMPRESIÓN</b></td>
        </tr>

        <tr>
            <td align="center" ></td>
            <td align="center">
                <?php echo formatea_fecha($recibido) ; ?>
            </td>
            <td align="center"><?php echo formatea_fechahora(date('Y-m-d H:i:s')); ?></td>
        </tr>		
	</TABLE>
	
	<table border="0">
		<tr>
			<td align="left" style="background-color: <?php echo $b_color;?>; width: 175px;"><b>ESTUDIO: EXÁMEN GENERAL DE ORINA</b></td>
			<td align="center" style="background-color: <?php echo $b_color;?>; width: 138px;"><b>RESULTADO</b></td>
			<td align="center" style="background-color: <?php echo $b_color;?>; width: 45px;"><b>ANORMAL</b></td>
			<td align="center" style="background-color: <?php echo $b_color;?>; width: 60px;"><b>UNIDADES</b></td>	
			<td align="center" style="background-color: <?php echo $b_color;?>; width: 116px;"><b>REFERENCIA</b></td>				
		</tr>
	</TABLE>
	
<?php 
}

    }

	
}

/**********************************************/
if (!function_exists('cabecera_reporte_psico'))
{
    function cabecera_reporte_psico($titulaje,$titulo,$persona,$recibido,$emp_giro,$emp_razon_social,$impresion='',$solicita='LA EMPRESA CLIENTE',$fsm_id=0,$c1=0)
    {
		$azul_hc='#4B5682'; /*azul solido*/
		$gris_rata='#acacac';		
		$gris_raty='#e9e9e9';
		
		$fondo_titular_a='#00004d';/*azul solido*/
		$letras_titulares_a='#fff';
		$fondo_cinta_a='#00004d';  /*azul solido*/
		$letras_cinta_a='#fff';
		
		
		
		$borde_b=0; //1;
		$fondo_titular_b=  '#ffffff'; //'#e9e9e9';  //'#4B5682'; //'#acacac'; //'#fff';  //'#000000'; ///*azul claro*/
		$letras_titulares_b= '#000000'; //'#ffffff';  // '#000'; //'#fff'; //'#ffffff';
		$fondo_cinta_b=  '#ffffff';//'#e9e9e9';  //'#4B5682'; //'#acacac'; //'#fff';  //'#000000'; ///*azul claro*/
		$letras_cinta_b= '#000000'; //'#ffffff';  // '#000'; //'#fff'; //'#ffffff';		

		$size_titulo_b='font-size:117%';
	
//$emp_giro='1';//$emp_giro; //.

	if ($emp_giro == 'SEGURIDAD')
	{
	 $b_color=$fondo_titular_a;
	 
	?>
    <img src="<?php echo "./../../files/imagenes/logo_2.png"; ?>" width="300px" />
    <h3 align="center"><?php echo $titulo;?></h3>
    <h4>DATOS DEL SOLICITANTE</h4>
    <table border="1" cellpadding="3">
        <tr>
            <td align="center" style="background-color: <?php echo $b_color;?>;">
                <b style="color: <?php echo $letras_titulares_a;?>;">NOMBRE</b>
            </td>
            <td align="center" style="background-color: <?php echo $b_color;?>;">
                <b style="color: <?php echo $letras_titulares_a;?>;">RFC</b>
            </td>
        </tr>
        <tr>
            <td align="center">
                <?php echo $persona['clte_paterno'].' '.$persona['clte_materno'].' '.$persona['clte_nombre'].' '.$persona['clte_2_nombre']; ?>
            </td>
            <td align="center">
                <?php echo $persona['clte_rfc']; ?>
            </td>
        </tr>
    </table>
   <h4>
        EMPRESA EN LA QUE LABORA O ASPIRA A INGRESAR
    </h4>
    <h3 align="center" style="border: 1px solid #000; width: 50%; display: inline-block;"><?php echo $emp_razon_social; ?></h3>
	
    <table border="0" cellpadding="2">
        <tr>
            <td>
                <b style="color: <?php echo $letras_titulares_a;?>;">NOMBRE</b>
            </td>
        </tr>
    </table>
	
	<?php
	
	
	if ($titulaje == 1)
	{
	 ?>
	 <table border="0" >
            <tr>
                <td align="center" style="background-color: <?php echo $fondo_cinta_a;?>; width: 175px;"><b  style="color: <?php echo $letras_titulares_a;?>;">ESTUDIO</b></td>
				<td align="center" style="background-color: <?php echo $fondo_cinta_a;?>; width: 138px;"><b  style="color: <?php echo $letras_titulares_a;?>;">RESULTADO</b></td>
				<td align="center" style="background-color: <?php echo $fondo_cinta_a;?>; width: 45px;"><b  style="color: <?php echo $letras_titulares_a;?> ;">ANORMAL</b></td>
				<td align="center" style="background-color: <?php echo $fondo_cinta_a;?>; width: 60px;"><b  style="color: <?php echo $letras_titulares_a;?> ;">UNIDADES</b></td>	
				<td align="center" style="background-color: <?php echo $fondo_cinta_a;?>; width: 116px;"><b  style="color: <?php echo $letras_titulares_a;?> ;">REFERENCIA</b></td>				
            </tr>
		<!--	<tr>
				<td colspan="5"><b><?php echo $titulo;?></b></td>
			</tr> -->
	 </table>
	 
	<?php 
	}
	elseif ($titulaje == 2)
	{	
	?>
	 <table border="0" >
            <tr>
                <td align="center" style="background-color: <?php echo $fondo_cinta_a;?>; width: 33%;"><b  style="color: <?php echo $letras_titulares_a;?> ;">ESTUDIO</b></td>
				<td align="center" style="background-color: <?php echo $fondo_cinta_a;?>; width: 33%;"><b  style="color: <?php echo $letras_titulares_a;?> ;">RESULTADO</b></td>
				<td align="center" style="background-color: <?php echo $fondo_cinta_a;?>; width: 34%;"><b  style="color: <?php echo $letras_titulares_a;?> ;">REFERENCIA</b></td>				
            </tr>
	  </table>
	<?php
	}
	elseif ($titulaje == 3)
	{	
	?>

	<table border="0">
		<tr>
			<td align="center" style="background-color: <?php echo $fondo_cinta_a;?>; width: 175px;"><b  style="color: <?php echo $letras_titulares_a;?> ;">ESTUDIO:</b></td>
			<td align="center" style="background-color: <?php echo $fondo_cinta_a;?>; width: 356px;"><b  style="color: <?php echo $letras_titulares_a;?> ;">RESULTADO</b></td>
			<td align="center" style="background-color: <?php echo $fondo_cinta_a;?>; width: 1px;"><b  style="color: <?php echo $letras_titulares_a;?> ;"></b></td>
			<td align="center" style="background-color: <?php echo $fondo_cinta_a;?>; width: 1px;"><b  style="color: <?php echo $letras_titulares_a;?> ;"></b></td>	
			<td align="center" style="background-color: <?php echo $fondo_cinta_a;?>; width: 1px;"><b  style="color: <?php echo $letras_titulares_a;?> ;"></b></td>				
		</tr>
	</TABLE>
	  
	<?php
	}
	?>
<?php 
}
elseif ($emp_giro != 'SEGURIDAD')
{
	$b_color=$fondo_titular_b;
	
?>

<table style="width: 100%">
	<tr>
		<td  style="width: 65%;"><img src="<?php echo "./../../files/imagenes/logo_2.png"; ?>" width="200px" /></td>
		<td align="right" style="width: 35%;"><br><br><i><b style="color: <?php echo $letras_titulares_b;?>;"><?php echo 'ID: '.$persona['clte_id'].'-'.$fsm_id; ?></b></i></td>
	</tr>	
</table>
<table border="0" ><tr><td></td></tr></table>
<table border="<?php echo $borde_b;?>" cellpadding="3">
	<tr>
		<td align="center" style="background-color:   <?php echo $fondo_titular_b;?>; width: 60%;">
			<b style="color: <?php echo $letras_titulares_b;?>;">NOMBRE</b>
		</td>
		<td align="center" style="background-color:   <?php echo $fondo_titular_b;?>; width: 20%;">
			<b style="color: <?php echo $letras_titulares_b;?>;">FECHA DE NACIMIENTO</b>
		</td>
		
		<td align="center" style="background-color:   <?php echo $fondo_titular_b;?>; width: 20%;">
			<b style="color: <?php echo $letras_titulares_b;?>;">GÉNERO</b>
		</td>		
	</tr>
	<tr>
		<td align="center">
			<?php echo $persona['clte_nombre'].' '.$persona['clte_2_nombre'].' '.$persona['clte_paterno'].' '.$persona['clte_materno']; ?>
		</td>
		<td align="center">
			<?php echo formatea_fecha($persona['clte_f_nac']) ; ?>
		</td>		
	
		
		<td align="center">
			 <?php 
				if ($persona['clte_genero_cve'] == "H")
				{
					echo "MASCULINO";
				}
				else
				{
					echo "FEMENINO";
				}
			  ?>
		</td>		
	</tr>
</table>

<table border="<?php echo $borde_b;?>" cellpadding="3">
	<tr>
		<td align="center" style="background-color:  <?php echo $fondo_titular_b;?>; width: 60%;">
			<b style="color: <?php echo $letras_titulares_b;?>;">
			<?php echo 'EMPRESA SOLICITANTE';?>
			</b>
		</td>
		
		<td align="center" style="background-color:  <?php echo $fondo_titular_b;?>; width: 20%;">
			<b style="color: <?php echo $letras_titulares_b;?>;"><?php {echo 'FECHA DE REGISTRO';}  ?></b>
		</td> 
		
		<td align="center" style="background-color:  <?php echo $fondo_titular_b;?>; width: 20%;">
			<b style="color: <?php echo $letras_titulares_b;?>;">FECHA DE IMPRESIÓN</b>
		</td>		
	</tr>
	<tr>
		<td align="center">
			<?php
			if  (( $solicita == 'LA EMPRESA CLIENTE') || ( $solicita == 'A QUIEN CORRESPONDA') || ( $solicita==''))
			{	
				echo $emp_razon_social;
			}
			else
			{
				echo $solicita;
			}	
			?>		
		</td>
		
		

		<td align="center">
			<?php echo formatea_fecha($recibido) ; ?>
		</td>
		
		<td align="center">
			<?php if ($impresion == '') {echo formatea_fecha(date('Y-m-d H:i:s'));} else {echo formatea_fecha(date('Y-m-d H:i:s')); } ?>
		</td>	
	</tr>
</table>



	<table border="0" >
		<tr>
			<td><hr></td>
		</tr>
	</table>

	


	<?php
	if ($titulaje == 1)
	{
	 ?>
	 <table border="0" >
            <tr>
                <td align="center" style="background-color: <?php echo $fondo_cinta_b;?>; width: 33%;"><b  style="color: <?php echo $letras_cinta_b;?>;">ESTUDIO <?php //echo $titulo;?></b></td>
				<td align="center" style="background-color: <?php echo $fondo_cinta_b;?>; width: 25%;"><b  style="color: <?php echo $letras_cinta_b;?>;">RESULTADO</b></td>
				<td align="center" style="background-color: <?php echo $fondo_cinta_b;?>; width: 10%;"><b  style="color: <?php echo $letras_cinta_b;?>;">ANORMAL</b></td>
				<td align="center" style="background-color: <?php echo $fondo_cinta_b;?>; width: 10%;"><b  style="color: <?php echo $letras_cinta_b;?>;">UNIDADES</b></td>	
				<td align="center" style="background-color: <?php echo $fondo_cinta_b;?>; width: 22%;"><b  style="color: <?php echo $letras_cinta_b;?>;">REFERENCIA</b></td>				
            </tr>
			<tr>
				<td style="<?php echo $size_titulo_b; ?>;" colspan="5"><b><?php echo $titulo;?></b></td>
			</tr>				
	 </table>         
	<?php 
	}elseif ($titulaje == 2)
	{	
	?>
	 <table border="0" >
            <tr>
                 <td align="center" style="background-color: <?php echo $fondo_cinta_b;?>; width: 33%;"><b  style="color: <?php echo $letras_cinta_b;?>;">ESTUDIO <?php //echo $titulo;?></b></td>
				<td align="center" style="background-color: <?php echo $fondo_cinta_b;?>; width: 33%;"><b  style="color: <?php echo $letras_cinta_b;?>;">RESULTADO</b></td>
				<td align="center" style="background-color: <?php echo $fondo_cinta_b;?>; width: 34%;"><b  style="color: <?php echo $letras_cinta_b;?>;">REFERENCIA</b></td>				
            </tr>
			<tr>
				<td style="<?php echo $size_titulo_b; ?>;" colspan="3"><b><?php echo $titulo;?></b></td>
			</tr>			
	  </table>
	<?php
	}
	elseif ($titulaje == 3)
	{	
	?>

	<table border="0">
		<tr>
			<td align="center" style="background-color: <?php echo $fondo_cinta_b;?>; width: 175px;"><b  style="color: <?php echo $letras_cinta_b;?>;">ESTUDIO</b></td>
			<td align="center" style="background-color: <?php echo $fondo_cinta_b;?>; width: 356px;"><b  style="color: <?php echo $letras_cinta_b;?>;">RESULTADO</b></td>
			<td align="center" style="background-color: <?php echo $fondo_cinta_b;?>; width: 1px;"><b  style="color: <?php echo $letras_cinta_b;?>;"></b></td>
			<td align="center" style="background-color: <?php echo $fondo_cinta_b;?>; width: 1px;"><b  style="color: <?php echo $letras_cinta_b;?>;"></b></td>	
			<td align="center" style="background-color: <?php echo $fondo_cinta_b;?>; width: 1px;"><b  style="color: <?php echo $letras_cinta_b;?>;"></b></td>				
		</tr>
			<tr>
				<td style="<?php echo $size_titulo_b; ?>;"  colspan="5"><b><?php echo $titulo;?></b></td>
			</tr>		
	</TABLE>
	  
	<?php
	}elseif ($titulaje == 4)
	{	
	?>

	<table border="0">
		<tr>
			<td align="center" style="background-color: <?php echo $fondo_cinta_b;?>; width: 175px;"><b  style="color: <?php echo $letras_cinta_b;?>;"></b></td>
			<td align="center" style="background-color: <?php echo $fondo_cinta_b;?>; width: 356px;"><b  style="color: <?php echo $letras_cinta_b;?>;"></b></td>
			<td align="center" style="background-color: <?php echo $fondo_cinta_b;?>; width: 1px;"><b  style="color: <?php echo $letras_cinta_b;?>;"></b></td>
			<td align="center" style="background-color: <?php echo $fondo_cinta_b;?>; width: 1px;"><b  style="color: <?php echo $letras_cinta_b;?>;"></b></td>	
			<td align="center" style="background-color: <?php echo $fondo_cinta_b;?>; width: 1px;"><b  style="color: <?php echo $letras_cinta_b;?>;"></b></td>				
		</tr>
			<tr>
				<td style="<?php echo $size_titulo_b; ?>;"  colspan="5"><b><?php echo $titulo;?></b></td>
			</tr>		
	</TABLE>
	  
	<?php
	}elseif ($titulaje == 5)
	{	
	?>
	<table border="0">

			<tr>
				<td style="<?php echo $size_titulo_b; ?>;"  colspan="5"><b><?php echo $titulo;?></b></td>
			</tr>		
	</TABLE>
	  
	<?php
	}
	?>
<?php 	
}
else
{
$b_color=$gris_rata;
?>
<p>&nbsp;</p>
    <table>
		<tr>
			<td align="left">
				<img src="<?php echo base_url('../dist/images/logo_2.png'); ?>" width="170px" />
			</td>
		</tr>
	</table>
	
    <table border="0" class="table">
        <tr>
            <td align="center"   style="background-color: <?php echo $b_color;?>; width: 240px"><b>NOMBRE DEL PACIENTE</b></td>
            <td align="center" style="background-color: <?php echo $b_color;?>; width: 55px"><b>EDAD</b></td>
            <td align="center" style="background-color: <?php echo $b_color;?>; width: 65px"><b>SEXO</b></td>
            <td align="center" style="background-color: <?php echo $b_color;?>; width: 173px"><b>EMPRESA SOLICITANTE</b></td>			
        </tr>

        <tr>
            <td align="center"><?php echo $persona['clte_nombre'].' '.$persona['clte_2_nombre'].' '.$persona['clte_paterno'].' '.$persona['clte_materno']; ?>
            </td>
            <td align="center">
                <?php echo str_replace("años", "AÑOS", get_edad($persona['clte_f_nac'])) ; ?>
            </td>

            <td align="center">
                <?php 
				if ($persona['clte_genero_cve'] == "H")
				{
					echo "M";
				}
				else
				{
					echo "F";
				}
				?>
            </td>

            <td align="center"><?php echo $emp_razon_social; ?></td>
        </tr>
	</table>
	
    <table border="0" class="table">
        <tr>
            <td align="center"   style="background-color: <?php echo $b_color;?>; width: 177px"><b>IDENTIFICACIÓN - ODT</b></td>
            <td align="center" style="background-color: <?php echo $b_color;?>; width: 177px"><b>FECHA RECIBIDO</b></td>
            <td align="center" style="background-color: <?php echo $b_color;?>; width: 178px"><b>FECHA DE IMPRESIÓN</b></td>
        </tr>

        <tr>
            <td align="center" ></td>
            <td align="center">
                <?php echo formatea_fecha($recibido) ; ?>
            </td>
            <td align="center"><?php echo formatea_fechahora(date('Y-m-d H:i:s')); ?></td>
        </tr>		
	</TABLE>
	
	<table border="0">
		<tr>
			<td align="left" style="background-color: <?php echo $b_color;?>; width: 175px;"><b>ESTUDIO: EXÁMEN GENERAL DE ORINA</b></td>
			<td align="center" style="background-color: <?php echo $b_color;?>; width: 138px;"><b>RESULTADO</b></td>
			<td align="center" style="background-color: <?php echo $b_color;?>; width: 45px;"><b>ANORMAL</b></td>
			<td align="center" style="background-color: <?php echo $b_color;?>; width: 60px;"><b>UNIDADES</b></td>	
			<td align="center" style="background-color: <?php echo $b_color;?>; width: 116px;"><b>REFERENCIA</b></td>				
		</tr>
	</TABLE>
	
<?php 
}

    }

	
}



/****************************************************/







/**********************************************/
if (!function_exists('cabecera_reporte_lab'))
{
    function cabecera_reporte_lab($titulaje,$titulo,$persona,$recibido,$emp_giro,$emp_razon_social,$impresion='',$solicita='LA EMPRESA CLIENTE',$fsm_id=0,$c1=0,$laboratorio=0)
    {
		$azul_hc='#4B5682'; /*azul solido*/
		$gris_rata='#acacac';		
		$gris_raty='#e9e9e9';
		
		$fondo_titular_a='#00004d';/*azul solido*/
		$letras_titulares_a='#fff';
		$fondo_cinta_a='#00004d';  /*azul solido*/
		$letras_cinta_a='#fff';
		
		
		
		$borde_b=0; //1;
		$fondo_titular_b=  '#ffffff'; //'#e9e9e9';  //'#4B5682'; //'#acacac'; //'#fff';  //'#000000'; ///*azul claro*/
		$letras_titulares_b= '#000000'; //'#ffffff';  // '#000'; //'#fff'; //'#ffffff';
		$fondo_cinta_b=  '#ffffff';//'#e9e9e9';  //'#4B5682'; //'#acacac'; //'#fff';  //'#000000'; ///*azul claro*/
		$letras_cinta_b= '#000000'; //'#ffffff';  // '#000'; //'#fff'; //'#ffffff';		

		$size_titulo_b='font-size:117%';
	
$emp_giro='1';//$emp_giro; //.

	if ($emp_giro == 'SEGURIDAD')
	{
	 $b_color=$fondo_titular_a;
	 
	?>
	<!--    <img src="<?php echo base_url('../dist/images/logo_2.png'); ?>" width="300px" /> -->
	<img src="<?php echo "./../../files/imagenes/logo_2.png"; ?>" width="300px" />
    <h3 align="center"><?php echo $titulo;?></h3>
    <h4>DATOS DEL SOLICITANTE</h4>
    <table border="1" cellpadding="3">
        <tr>
            <td align="center" style="background-color: <?php echo $b_color;?>;">
                <b style="color: <?php echo $letras_titulares_a;?>;">NOMBRE</b>
            </td>
    <?php if($persona['emp_id']==311)
			{
			?>
				<td align="center" style="background-color:   <?php echo $fondo_titular_b;?>; width: 20%;">
					<b style="color: <?php echo $letras_titulares_b;?>;">FECHA DE NACIMIENTO</b>
				</td>	
				<td align="center" style="background-color:   <?php echo $fondo_titular_b;?>; width: 14%;">
					<b style="color: <?php echo $letras_titulares_b;?>;">EDAD</b>
				</td>
			<?php
			}
			else
			{ 
			?>
				<td align="center" style="background-color:   <?php echo $fondo_titular_b;?>; width: 14%;">
					<b style="color: <?php echo $letras_titulares_b;?>;">RFC</b>
				</td>
			<?php 
			}
			?>
        </tr>
        <tr>
            <td align="center">
                <?php echo $persona['clte_paterno'].' '.$persona['clte_materno'].' '.$persona['clte_nombre'].' '.$persona['clte_2_nombre']; ?>
            </td>
           <?php
				if($persona['emp_id']==311)
				{
				?>
				<td align="center">
					<?php echo str_replace("años", "AÑOS", get_edad($persona['clte_f_nac'])) ; ?>
				</td>
				<?php	
				}
				else
				{	
				?>	
				<td align="center">
					<?php echo $persona['clte_rfc']; ?>
				</td>
				<?php 
				}
				?>

        </tr>
    </table>
   <h4>
        EMPRESA EN LA QUE LABORA O ASPIRA A INGRESAR
    </h4>
    <h3 align="center" style="border: 1px solid #000; width: 50%; display: inline-block;"><?php echo $emp_razon_social; ?></h3>
	
    <table border="0" cellpadding="2">
        <tr>
            <td>
                <b style="color: <?php echo $letras_titulares_a;?>;">NOMBRE</b>
            </td>
        </tr>
    </table>
	
	<?php
	
	if ($titulo == 'GONADOTROPINA CORIÓNICA HUMANA')
	{
		$titulo='PRUEBA GONADOTROPINA CORIÓNICA HUMANA (hCG)';
	}	
	
	
	if ($titulaje == 1)
	{
	 ?>
	 <table border="0" >
            <tr>
                <td align="center" style="background-color: <?php echo $fondo_cinta_a;?>; width: 175px;"><b  style="color: <?php echo $letras_titulares_a;?>;">ESTUDIO</b></td>
				<td align="center" style="background-color: <?php echo $fondo_cinta_a;?>; width: 138px;"><b  style="color: <?php echo $letras_titulares_a;?>;">RESULTADO</b></td>
				<td align="center" style="background-color: <?php echo $fondo_cinta_a;?>; width: 45px;"><b  style="color: <?php echo $letras_titulares_a;?> ;">ANORMAL</b></td>
				<td align="center" style="background-color: <?php echo $fondo_cinta_a;?>; width: 60px;"><b  style="color: <?php echo $letras_titulares_a;?> ;">UNIDADES</b></td>	
				<td align="center" style="background-color: <?php echo $fondo_cinta_a;?>; width: 116px;"><b  style="color: <?php echo $letras_titulares_a;?> ;">REFERENCIA</b></td>				
            </tr>
	 </table>
	 
	<?php 
	}
	elseif ($titulaje == 2)
	{	
	?>
	 <table border="0" >
            <tr>
                <td align="center" style="background-color: <?php echo $fondo_cinta_a;?>; width: 33%;"><b  style="color: <?php echo $letras_titulares_a;?> ;">ESTUDIO</b></td>
				<td align="center" style="background-color: <?php echo $fondo_cinta_a;?>; width: 33%;"><b  style="color: <?php echo $letras_titulares_a;?> ;">RESULTADO</b></td>
				<td align="center" style="background-color: <?php echo $fondo_cinta_a;?>; width: 34%;"><b  style="color: <?php echo $letras_titulares_a;?> ;">REFERENCIA</b></td>				
            </tr>
	  </table>
	<?php
	}
	elseif ($titulaje == 3)
	{	
	?>
	<table border="0">
		<tr>
			<td align="center" style="background-color: <?php echo $fondo_cinta_a;?>; width: 175px;"><b  style="color: <?php echo $letras_titulares_a;?> ;">ESTUDIO:</b></td>
			<td align="center" style="background-color: <?php echo $fondo_cinta_a;?>; width: 356px;"><b  style="color: <?php echo $letras_titulares_a;?> ;">RESULTADO</b></td>
			<td align="center" style="background-color: <?php echo $fondo_cinta_a;?>; width: 1px;"><b  style="color: <?php echo $letras_titulares_a;?> ;"></b></td>
			<td align="center" style="background-color: <?php echo $fondo_cinta_a;?>; width: 1px;"><b  style="color: <?php echo $letras_titulares_a;?> ;"></b></td>	
			<td align="center" style="background-color: <?php echo $fondo_cinta_a;?>; width: 1px;"><b  style="color: <?php echo $letras_titulares_a;?> ;"></b></td>				
		</tr>
	</TABLE>	  
	<?php
	}	
	elseif ($titulaje == 4)
	{
	 ?>
	 <table border="0" >
            <tr>
                <td align="center" style="background-color: <?php echo $fondo_cinta_a;?>; width: 175px;"><b  style="color: <?php echo $letras_titulares_a;?>;">ESTUDIO</b></td>
				<td align="center" style="background-color: <?php echo $fondo_cinta_a;?>; width: 138px;"><b  style="color: <?php echo $letras_titulares_a;?>;">RESULTADO</b></td>
				<td align="center" style="background-color: <?php echo $fondo_cinta_a;?>; width: 45px;"><b  style="color: <?php echo $letras_titulares_a;?> ;"></b></td>
				<td align="center" style="background-color: <?php echo $fondo_cinta_a;?>; width: 60px;"><b  style="color: <?php echo $letras_titulares_a;?> ;"></b></td>	
				<td align="center" style="background-color: <?php echo $fondo_cinta_a;?>; width: 116px;"><b  style="color: <?php echo $letras_titulares_a;?> ;">REFERENCIA</b></td>				
            </tr>
	 </table>
	 
	<?php 
	}	
}
elseif ($emp_giro != 'SEGURIDAD')
{
	$b_color=$fondo_titular_b;
	
	 
?>

<table style="width: 100%">
	<tr>
		
	    <td  style="width: 65%;">
			<img src="<?php echo base_url('../dist/images/logo_2.png'); ?>" width="200px" />
			<!--<img src="<?php echo "./../../files/imagenes/logo_2.png"; ?>" width="200px" /> -->
		</td>   
		<td align="right" style="width: 35%;"><br><br><i><b style="color: <?php echo $letras_titulares_b;?>;"><?php if ($laboratorio == 0) {echo 'ID: '.$persona['clte_id'].'-'.$fsm_id;} else {echo 'ID: '.$persona['clte_id'].'-'.$fsm_id.'-'.$laboratorio;}  ?></b></i></td>
	</tr>	
</table>
<table border="0" ><tr><td></td></tr></table>
<table border="<?php echo $borde_b;?>" cellpadding="3">
	<tr>
		<td align="center" style="background-color:   <?php echo $fondo_titular_b;?>; width: 50%;">
			<b style="color: <?php echo $letras_titulares_b;?>;">NOMBRE</b>
		</td>
		<?php
//		if  ( $persona['clte_id'] == 338340)  
		if($persona['emp_id'] != 311)  
		{
		?>
		<td align="center" style="background-color:   <?php echo $fondo_titular_b;?>; width: 20%;">
			<b style="color: <?php echo $letras_titulares_b;?>;">FECHA DE NACIMIENTO</b>
		</td>
		<?php
		}
		if($persona['emp_id'] == 311)  
		{
		?>
		<td align="center" style="background-color:   <?php echo $fondo_titular_b;?>; width: 10%;">
			<b style="color: <?php echo $letras_titulares_b;?>;">EDAD</b> 
			<!-- LABORATORIO GNP -->
		</td>		

		<td align="center" style="background-color:   <?php echo $fondo_titular_b;?>; width: 20%;">
			<b style="color: <?php echo $letras_titulares_b;?>;">FECHA DE NACIMIENTO</b>
		</td>
		<?php
		}
		?>		
		
		<td align="center" style="background-color:   <?php echo $fondo_titular_b;?>; width: 20%;">
			<b style="color: <?php echo $letras_titulares_b;?>;">GÉNERO</b>
		</td>		
	</tr>


	
	<tr>
		<td align="center">
			<?php echo $persona['clte_nombre'].' '.$persona['clte_2_nombre'].' '.$persona['clte_paterno'].' '.$persona['clte_materno']; ?>
		</td>
		
		<?php
		//if  ( $persona['emp_id'] == 338340) 
		if($persona['emp_id'] != 311)
		{
		?>
		<td align="center">
			<?php echo formatea_fecha($persona['clte_f_nac']) ; ?>
		</td>		

		<?php
		} 
		if($persona['emp_id'] == 311)
		{
		?>
		<td align="center">
			<?php// echo '60 AÑOS'; ?>
			<?php echo str_replace("años", "AÑOS", get_edad($persona['clte_f_nac'])) ; ?>

		</td>		

		<td align="center">
			<?php echo formatea_fecha($persona['clte_f_nac']) ; ?>
		</td>		

		<?php
		}
		?>		
		
		<td align="center">
			 <?php 
				if ($persona['clte_genero_cve'] == "H")
				{
					echo "MASCULINO";
				}
				else
				{
					echo "FEMENINO";
				}
			  ?>
		</td>		
	</tr>
</table>

<table border="<?php echo $borde_b;?>" cellpadding="3">
	<tr>
		<td align="center" style="background-color:  <?php echo $fondo_titular_b;?>; width: 60%;">
			<b style="color: <?php echo $letras_titulares_b;?>;">
			<?php 
			if  ( strstr( $solicita,'LA EMPRESA CLIENTE') ||  strstr( $solicita,'A QUIEN CORRESPONDA') || ( $solicita==''))
			{	
				echo 'EMPRESA SOLICITANTE';
			}
			else
			{
				echo 'MÉDICO';
			}	
			?>
			</b>
		</td>
		
		<td align="center" style="background-color:  <?php echo $fondo_titular_b;?>; width: 20%;">
			<b style="color: <?php echo $letras_titulares_b;?>;"><?php if ($c1==1) {echo 'FECHA DE TOMA';} else {echo 'FECHA DE RECIBO';} ?></b>
		</td> 
		
		<td align="center" style="background-color:  <?php echo $fondo_titular_b;?>; width: 20%;">
			<b style="color: <?php echo $letras_titulares_b;?>;">FECHA DE IMPRESIÓN</b>
		</td>		
	</tr>
	<tr>
		<td align="center">
			<?php
			if  (( $solicita == 'LA EMPRESA CLIENTE') || ( $solicita == 'A QUIEN CORRESPONDA') || ( $solicita==''))
			{	
				echo $emp_razon_social;
			}
			else
			{
				echo $solicita;
			}	
			?>		
		</td>
		
		

		<td align="center">
			<?php echo formatea_fecha($recibido) ; ?>
		</td>
		
		<?php
		if 	(
			(get_emp_cond_misma_fpdf($persona['emp_id']) == 1) ||
			($persona['emp_id'] == 164) ||
			($persona['emp_id'] == 136) ||
			($persona['emp_id'] == 360) 
			)
		{
		?>
			<td align="center">
				<?php echo formatea_fecha($recibido) ; ?>
			</td>
		<?php
		}
		else
		{
			
			if (
				($persona['clte_id'] == 356391) ||
				($persona['clte_id'] == 356390) ||
				($persona['clte_id'] == 356389) ||
				($persona['clte_id'] == 356388) ||
				
				($persona['clte_id'] == 356387) ||
				($persona['clte_id'] == 356386) ||
				($persona['clte_id'] == 356385) ||
				($persona['clte_id'] == 356384) ||
				($persona['clte_id'] == 356383) ||
				($persona['clte_id'] == 356382) ||
				($persona['clte_id'] == 356381) 
				)
			{
			?>		
			<td align="center"><?php echo formatea_fecha($recibido); ?></td>		
			<?php				
			}
			else
			{
			?>
			<td align="center"><?php if ($impresion == '') {echo formatea_fecha(date('Y-m-d H:i:s'));} else {echo formatea_fecha(date('Y-m-d H:i:s')); /*formatea_fecha($impresion);*/} ?></td>		
			<?php
			}
		}
		?>
	</tr>
</table>



	<table border="0" >
		<tr>
			<td><hr></td>
		</tr>
	</table>

	


	<?php 
	if ($titulaje == 1)
	{
	 ?>
	 <table border="0" >
            <tr>
                <td align="center" style="background-color: <?php echo $fondo_cinta_b;?>; width: 33%;"><b  style="color: <?php echo $letras_cinta_b;?>;">ESTUDIO <?php //echo $titulo;?></b></td>
				<td align="center" style="background-color: <?php echo $fondo_cinta_b;?>; width: 25%;"><b  style="color: <?php echo $letras_cinta_b;?>;">RESULTADO</b></td>
				<td align="center" style="background-color: <?php echo $fondo_cinta_b;?>; width: 10%;"><b  style="color: <?php echo $letras_cinta_b;?>;">ANORMAL</b></td>
				<td align="center" style="background-color: <?php echo $fondo_cinta_b;?>; width: 10%;"><b  style="color: <?php echo $letras_cinta_b;?>;">UNIDADES</b></td>	
				<td align="center" style="background-color: <?php echo $fondo_cinta_b;?>; width: 22%;"><b  style="color: <?php echo $letras_cinta_b;?>;">REFERENCIA</b></td>				
            </tr>
			<tr>
				<td style="<?php echo $size_titulo_b; ?>;" colspan="5"><b><?php echo $titulo;?></b></td>
			</tr>				
	 </table>         
	<?php 
	}
	elseif ($titulaje == 2)
	{	
	?>
	 <table border="0" >
            <tr>
                 <td align="center" style="background-color: <?php echo $fondo_cinta_b;?>; width: 33%;"><b  style="color: <?php echo $letras_cinta_b;?>;">ESTUDIO <?php //echo $titulo;?></b></td>
				<td align="center" style="background-color: <?php echo $fondo_cinta_b;?>; width: 33%;"><b  style="color: <?php echo $letras_cinta_b;?>;">RESULTADO</b></td>
				<td align="center" style="background-color: <?php echo $fondo_cinta_b;?>; width: 34%;"><b  style="color: <?php echo $letras_cinta_b;?>;">REFERENCIA</b></td>				
            </tr>
			<tr>
				<td style="<?php echo $size_titulo_b; ?>;" colspan="3"><b><?php echo $titulo;?></b></td>
			</tr>			
	  </table>
	<?php
	}
	elseif ($titulaje == 3)
	{	
	?>

	<table border="0">
		<tr>
			<td align="center" style="background-color: <?php echo $fondo_cinta_b;?>; width: 175px;"><b  style="color: <?php echo $letras_cinta_b;?>;">ESTUDIO</b></td>
			<td align="center" style="background-color: <?php echo $fondo_cinta_b;?>; width: 356px;"><b  style="color: <?php echo $letras_cinta_b;?>;">RESULTADO</b></td>
			<td align="center" style="background-color: <?php echo $fondo_cinta_b;?>; width: 1px;"><b  style="color: <?php echo $letras_cinta_b;?>;"></b></td>
			<td align="center" style="background-color: <?php echo $fondo_cinta_b;?>; width: 1px;"><b  style="color: <?php echo $letras_cinta_b;?>;"></b></td>	
			<td align="center" style="background-color: <?php echo $fondo_cinta_b;?>; width: 1px;"><b  style="color: <?php echo $letras_cinta_b;?>;"></b></td>				
		</tr>
			<tr>
				<td style="<?php echo $size_titulo_b; ?>;"  colspan="5"><b><?php echo $titulo;?></b></td>
			</tr>		
	</TABLE>
	  
	<?php
	}elseif ($titulaje == 4)
	{	
	?>

	<table border="0">
		<tr>
			<td align="center" style="background-color: <?php echo $fondo_cinta_b;?>; width: 175px;"><b  style="color: <?php echo $letras_cinta_b;?>;"></b></td>
			<td align="center" style="background-color: <?php echo $fondo_cinta_b;?>; width: 356px;"><b  style="color: <?php echo $letras_cinta_b;?>;"></b></td>
			<td align="center" style="background-color: <?php echo $fondo_cinta_b;?>; width: 1px;"><b  style="color: <?php echo $letras_cinta_b;?>;"></b></td>
			<td align="center" style="background-color: <?php echo $fondo_cinta_b;?>; width: 1px;"><b  style="color: <?php echo $letras_cinta_b;?>;"></b></td>	
			<td align="center" style="background-color: <?php echo $fondo_cinta_b;?>; width: 1px;"><b  style="color: <?php echo $letras_cinta_b;?>;"></b></td>				
		</tr>
			<tr>
				<td style="<?php echo $size_titulo_b; ?>;"  colspan="5"><b><?php echo $titulo;?></b></td>
			</tr>		
	</TABLE>
	  
	<?php
	}elseif ($titulaje == 5)
	{	
	?>
	<table border="0">

			<tr>
				<td style="<?php echo $size_titulo_b; ?>;"  colspan="5"><b><?php echo $titulo;?></b></td>
			</tr>		
	</TABLE>
	  
	<?php
	}
	elseif ($titulaje == 6)
	{
	 ?>
	 <table border="0" >
            <tr>
                <td align="center" style="background-color: <?php echo $fondo_cinta_b;?>; width: 33%;"><b  style="color: <?php echo $letras_cinta_b;?>;">ESTUDIO</b></td>
				<td align="center" style="background-color: <?php echo $fondo_cinta_b;?>; width: 25%;"><b  style="color: <?php echo $letras_cinta_b;?>;">RESULTADO</b></td>
				<td align="center" style="background-color: <?php echo $fondo_cinta_b;?>; width: 10%;"><b  style="color: <?php echo $letras_cinta_b;?>;"></b></td>
				<td align="center" style="background-color: <?php echo $fondo_cinta_b;?>; width: 10%;"><b  style="color: <?php echo $letras_cinta_b;?>;"></b></td>	
				<td align="center" style="background-color: <?php echo $fondo_cinta_b;?>; width: 22%;"><b  style="color: <?php echo $letras_cinta_b;?>;">REFERENCIA</b></td>				
            </tr>
			<tr>
				<td style="<?php echo $size_titulo_b; ?>;" colspan="5"><b><?php echo $titulo;?></b></td>
			</tr>				
	 </table>         
	<?php 
	}
	
}
else
{
$b_color=$gris_rata;
?>
<p>&nbsp;</p>
    <table>
		<tr>
			<td align="left">
				<img src="<?php echo base_url('../dist/images/logo_2.png'); ?>" width="170px" />
			</td>
		</tr>
	</table>
	
    <table border="0" class="table">
        <tr>
            <td align="center"   style="background-color: <?php echo $b_color;?>; width: 240px"><b>NOMBRE DEL PACIENTE</b></td>
            <td align="center" style="background-color: <?php echo $b_color;?>; width: 55px"><b>EDAD</b></td>
            <td align="center" style="background-color: <?php echo $b_color;?>; width: 65px"><b>SEXO</b></td>
            <td align="center" style="background-color: <?php echo $b_color;?>; width: 173px"><b>EMPRESA SOLICITANTE</b></td>			
        </tr>

        <tr>
            <td align="center"><?php echo $persona['clte_nombre'].' '.$persona['clte_2_nombre'].' '.$persona['clte_paterno'].' '.$persona['clte_materno']; ?>
            </td>
            <td align="center">
                <?php echo str_replace("años", "AÑOS", get_edad($persona['clte_f_nac'])) ; ?>
            </td>

            <td align="center">
                <?php 
				if ($persona['clte_genero_cve'] == "H")
				{
					echo "M";
				}
				else
				{
					echo "F";
				}
				?>
            </td>

            <td align="center"><?php echo $emp_razon_social; ?></td>
        </tr>
	</table>
	
    <table border="0" class="table">
        <tr>
            <td align="center"   style="background-color: <?php echo $b_color;?>; width: 177px"><b>IDENTIFICACIÓN - ODT</b></td>
            <td align="center" style="background-color: <?php echo $b_color;?>; width: 177px"><b>FECHA RECIBIDO</b></td>
            <td align="center" style="background-color: <?php echo $b_color;?>; width: 178px"><b>FECHA DE IMPRESIÓN</b></td>
        </tr>

        <tr>
            <td align="center" ></td>
            <td align="center">
                <?php echo formatea_fecha($recibido) ; ?>
            </td>
            <td align="center"><?php echo formatea_fechahora(date('Y-m-d H:i:s')); ?></td>
        </tr>		
	</TABLE>
	
	<table border="0">
		<tr>
			<td align="left" style="background-color: <?php echo $b_color;?>; width: 175px;"><b>ESTUDIO: EXÁMEN GENERAL DE ORINA</b></td>
			<td align="center" style="background-color: <?php echo $b_color;?>; width: 138px;"><b>RESULTADO</b></td>
			<td align="center" style="background-color: <?php echo $b_color;?>; width: 45px;"><b>ANORMAL</b></td>
			<td align="center" style="background-color: <?php echo $b_color;?>; width: 60px;"><b>UNIDADES</b></td>	
			<td align="center" style="background-color: <?php echo $b_color;?>; width: 116px;"><b>REFERENCIA</b></td>				
		</tr>
	</TABLE>
	
<?php 
}

    }

	
}



/****************************************************/
if (!function_exists('cabecera_lab'))
{
    function cabecera_lab($titulo,$persona,$recibido,$emp_giro,$emp_razon_social,$impresion='',$c1=0)
    {
		
	/*	$fondo_titular_b= '#e9e9e9';  
		$fondo_cinta_b=  '#e9e9e9';  
		$letras_cinta_b= '#000000';	*/

		$azul_solido='#ffffff';//'#e9e9e9';
		$azul_hc= '#ffffff';//'#e9e9e9';
		$gris_rata= '#ffffff';//'#e9e9e9';
		$letras_cinta= '#000000';	
		
	/*	$azul_solido='#00004d';
		$azul_hc='#4B5682';
		$gris_rata='#acacac';*/

	if ($emp_giro == 'SEGURIDAD')
	{
	 $b_color=$azul_solido;
	 
	?>
    <!-- <img src="<?php echo base_url('../dist/images/logo_2.png'); ?>" width="300px" /> -->
	<img src="<?php echo "./../../files/imagenes/logo_2.png"; ?>" width="300px" />
	
    <h3 align="center"><?php echo $titulo;?></h3>
    <h4>DATOS DEL SOLICITANTE</h4>
    <table border="1" cellpadding="3">
        <tr>
            <td align="center" style="background-color: <?php echo $b_color;?>;">
                <b style="color: #fff;">NOMBRE</b>
            </td>
    <?php if($persona['emp_id']==311)
			{
			?>
				<td align="center" style="background-color:   <?php echo $fondo_titular_b;?>; width: 20%;">
					<b style="color: <?php echo $letras_titulares_b;?>;">FECHA DE NACIMIENTO</b>
				</td>	
				<td align="center" style="background-color:   <?php echo $fondo_titular_b;?>; width: 14%;">
					<b style="color: <?php echo $letras_titulares_b;?>;">EDAD</b>
				</td>
			<?php
			}
			else
			{ 
			?>
				<td align="center" style="background-color:   <?php echo $fondo_titular_b;?>; width: 14%;">
					<b style="color: <?php echo $letras_titulares_b;?>;">RFC</b>
				</td>
			<?php 
			}
			?>
        </tr>
        <tr>
            <td align="center">
                <?php echo $persona['clte_paterno'].' '.$persona['clte_materno'].' '.$persona['clte_nombre'].' '.$persona['clte_2_nombre']; ?>
            </td>
           <?php
				if($persona['emp_id']==311)
				{
				?>
				<td align="center">
					<?php echo str_replace("años", "AÑOS", get_edad($persona['clte_f_nac'])) ; ?>
				</td>
				<?php	
				}
				else
				{	
				?>	
				<td align="center">
					<?php echo $persona['clte_rfc']; ?>
				</td>
				<?php 
				}
				?>
        </tr>
    </table>
   <h4>
        EMPRESA EN LA QUE LABORA O ASPIRA A INGRESAR
    </h4>
    <h3 align="center" style="border: 1px solid #000; width: 50%; display: inline-block;"><?php echo $emp_razon_social; ?></h3>
	
    <table border="0" cellpadding="2">
        <tr>
            <td>
                <b style="color: #fff;">NOMBRE</b>
            </td>
        </tr>
    </table>
	
	<?php
	

}


elseif ($emp_giro != 'SEGURIDAD')
{
	$b_color=$azul_hc;
	
	 
?>

<table style="width: 100%">
	<tr>
		<!--<img src="<?php echo base_url('../dist/images/logo_2.png'); ?>" width="200px" />-->
		<td style="width: 65%;"><img src="<?php echo "./../../files/imagenes/logo_2.png"; ?>" width="200px" /></td>
	</tr>
</table>
<table border="0" ><tr><td></td></tr></table>
<table border="0" cellpadding="3">
	<tr>
		<td align="center" style="background-color:   <?php echo $b_color;?>; width: 60%;">
			<b style="color: <?php echo $letras_cinta;?>;">NOMBRE</b>
		</td>
		<td align="center" style="background-color:   <?php echo $b_color;?>; width: 20%;">
			<b style="color: <?php echo $letras_cinta;?>;">FECHA DE NACIMIENTO</b>
		</td>
		<td align="center" style="background-color:   <?php echo $b_color;?>; width: 20%;">
			<b style="color: <?php echo $letras_cinta;?>;">GENERO</b>
		</td>		
	</tr>
	<tr>
		<td align="center">
			<?php echo $persona['clte_nombre'].' '.$persona['clte_2_nombre'].' '.$persona['clte_paterno'].' '.$persona['clte_materno']; ?>
		</td>
		<td align="center">
			<?php echo formatea_fecha($persona['clte_f_nac']) ; ?>
		</td>
		<td align="center">
			 <?php 
				if ($persona['clte_genero_cve'] == "H")
				{
					echo "MASCULINO";
				}
				else
				{
					echo "FEMENINO";
				}
			  ?>
		</td>		
	</tr>
</table>

<table border="0" cellpadding="3">
	<tr>
		<td align="center" style="background-color:  <?php echo $b_color;?>; width: 60%;">
			<b style="color: <?php echo $letras_cinta;?>;">EMPRESA SOLICITANTE</b>
		</td>
		<td align="center" style="background-color:  <?php echo $b_color;?>; width: 20%;">
			<b style="color: <?php echo $letras_cinta;?>;"><?php if ($c1==1) {echo 'FECHA DE TOMA';} else {echo 'FECHA RECIBIDO';}?></b>
		</td>
		<td align="center" style="background-color:  <?php echo $b_color;?>; width: 20%;">
			<b style="color: <?php echo $letras_cinta;?>;">FECHA DE IMPRESIÓN</b>
		</td>		
	</tr>
	<tr>
		<td align="center">
			<?php echo $emp_razon_social; ?>
		</td>
		<td align="center">
			<?php echo formatea_fecha($recibido) ; ?>
		</td>
		<td align="center"><?php if ($impresion == '') {echo formatea_fecha(date('Y-m-d H:i:s'));}else{echo formatea_fecha($impresion);} ?></td>		
	</tr>
</table>

	<table border="0" ><tr><td><HR></td></tr></table>
<?php
}
else
{
$b_color=$gris_rata;
?>
<p>&nbsp;</p>
    <table>
		<tr>
			<td align="left">
				<!-- <img src="<?php echo base_url('../dist/images/logo_2.png'); ?>" width="170px" /> -->
				<img src="<?php echo "./../../files/imagenes/logo_2.png"; ?>" width="170px" />
			</td>
		</tr>
	</table>
	
    <table border="0" class="table">
        <tr>
            <td align="center"   style="background-color: <?php echo $b_color;?>; width: 240px"><b>NOMBRE DEL PACIENTE</b></td>
            <td align="center" style="background-color: <?php echo $b_color;?>; width: 55px"><b>EDAD</b></td>
            <td align="center" style="background-color: <?php echo $b_color;?>; width: 65px"><b>SEXO</b></td>
            <td align="center" style="background-color: <?php echo $b_color;?>; width: 173px"><b>EMPRESA SOLICITANTE</b></td>			
        </tr>

        <tr>
            <td align="center"><?php echo $persona['clte_nombre'].' '.$persona['clte_2_nombre'].' '.$persona['clte_paterno'].' '.$persona['clte_materno']; ?>
            </td>
            <td align="center">
                <?php echo str_replace("años", "AÑOS", get_edad($persona['clte_f_nac'])) ; ?>
            </td>

            <td align="center">
                <?php 
				if ($persona['clte_genero_cve'] == "H")
				{
					echo "M";
				}
				else
				{
					echo "F";
				}
				?>
            </td>

            <td align="center"><?php echo $emp_razon_social; ?></td>
        </tr>
	</table>
	
    <table border="0" class="table">
        <tr>
            <td align="center"   style="background-color: <?php echo $b_color;?>; width: 177px"><b>IDENTIFICACIÓN - ODT</b></td>
            <td align="center" style="background-color: <?php echo $b_color;?>; width: 177px"><b>FECHA RECIBIDO</b></td>
            <td align="center" style="background-color: <?php echo $b_color;?>; width: 178px"><b>FECHA DE IMPRESIÓN</b></td>
        </tr>

        <tr>
            <td align="center" ></td>
            <td align="center">
                <?php echo formatea_fecha($recibido) ; ?>
            </td>
            <td align="center"><?php echo formatea_fechahora(date('Y-m-d H:i:s')); ?></td>
        </tr>		
	</TABLE>
	
	
<?php 
	}

    }
}



/**********************/


if (!function_exists('cabecera_titular_lab'))
{
    function cabecera_titular_lab($titulaje,$titulo,$emp_giro)
    {


	/*	$fondo_titular_b= '#e9e9e9';  
		$fondo_cinta_b=  '#e9e9e9';  
		$letras_cinta_b= '#000000';	*/

		/*$azul_solido='#ffffff';//'#e9e9e9';
		$azul_hc='#ffffff';//'#e9e9e9';
		$gris_rata='#ffffff';//'#e9e9e9';*/
		$letras_cinta= '#000000';	
		
	/*	$azul_solido='#00004d';
		$azul_hc='#4B5682';
		$gris_rata='#acacac';*/
		

	if ($emp_giro == 'SEGURIDAD')
	{
	 $b_color=$azul_solido;
	 
	if ($titulaje == 1)
	{
	 ?>
	 <table border="0" >
            <tr>
                <td align="center" style="background-color: <?php echo $b_color;?>; width: 175px;"><b  style="color: #fff;">ESTUDIO</b></td>
				<td align="center" style="background-color: <?php echo $b_color;?>; width: 138px;"><b  style="color: #fff;">RESULTADO</b></td>
				<td align="center" style="background-color: <?php echo $b_color;?>; width: 45px;"><b  style="color: #fff;">ANORMAL</b></td>
				<td align="center" style="background-color: <?php echo $b_color;?>; width: 60px;"><b  style="color: #fff;">UNIDADES</b></td>	
				<td align="center" style="background-color: <?php echo $b_color;?>; width: 116px;"><b  style="color: #fff;">REFERENCIA</b></td>				
            </tr>
			<tr>
				<td colspan="5"><b><?php echo $titulo;?></b></td>
			</tr>
	 </table>
	 
	<?php 
	}
	elseif ($titulaje == 2)
	{	
	?>
	 <table border="0" >
            <tr>
                <td align="center" style="background-color: <?php echo $b_color;?>; width: 33%;"><b  style="color: #fff;">ESTUDIO</b></td>
				<td align="center" style="background-color: <?php echo $b_color;?>; width: 33%;"><b  style="color: #fff;">RESULTADO</b></td>
				<td align="center" style="background-color: <?php echo $b_color;?>; width: 34%;"><b  style="color: #fff;">REFERENCIA</b></td>				
            </tr>
			<tr>
				<td colspan="3"><b><?php echo $titulo;?></b></td>
			</tr>			
	  </table>
	<?php
	}
	elseif ($titulaje == 3)
	{	
	?>

	<table border="0">
		<tr>
			<td align="center" style="background-color: <?php echo $b_color;?>; width: 175px;"><b  style="color: #fff;">ESTUDIO:</b></td>
			<td align="center" style="background-color: <?php echo $b_color;?>; width: 356px;"><b  style="color: #fff;">RESULTADO</b></td>
			<td align="center" style="background-color: <?php echo $b_color;?>; width: 1px;"><b  style="color: #fff;"></b></td>
			<td align="center" style="background-color: <?php echo $b_color;?>; width: 1px;"><b  style="color: #fff;"></b></td>	
			<td align="center" style="background-color: <?php echo $b_color;?>; width: 1px;"><b  style="color: #fff;"></b></td>				
		</tr>
			<tr>
				<td colspan="5"><b><?php echo $titulo;?></b></td>
			</tr>		
	</TABLE>
	  
	<?php
	}
	?>
<?php 
}


elseif ($emp_giro != 'SEGURIDAD')
{
	$b_color=$azul_hc;
	?>
	<table border="0" ><tr><td></td></tr></table>
	<?php
	if ($titulaje == 1)
	{
	 ?>
	 <table border="0" >
            <tr>
                <td align="left" style="background-color: <?php echo $b_color;?>; width: 33%;"><b  style="color: <?php echo $letras_cinta;?>;">ESTUDIO: <?php echo $titulo;?></b></td>
				<td align="center" style="background-color: <?php echo $b_color;?>; width: 25%;"><b  style="color: <?php echo $letras_cinta;?>;">RESULTADO</b></td>
				<td align="center" style="background-color: <?php echo $b_color;?>; width: 10%;"><b  style="color: <?php echo $letras_cinta;?>;">ANORMAL</b></td>
				<td align="center" style="background-color: <?php echo $b_color;?>; width: 10%;"><b  style="color:<?php echo $letras_cinta;?>;">UNIDADES</b></td>	
				<td align="center" style="background-color: <?php echo $b_color;?>; width: 22%;"><b  style="color: <?php echo $letras_cinta;?>;">REFERENCIA</b></td>				
            </tr>
	 </table>         
	<?php 
	}elseif ($titulaje == 2)
	{	
	?>
	 <table border="0" >
            <tr>
                <td align="left" style="background-color: <?php echo $b_color;?>; width: 33%;"><b  style="color: <?php echo $letras_cinta;?>;">ESTUDIO: <?php echo $titulo;?></b></td>
				<td align="center" style="background-color: <?php echo $b_color;?>; width: 33%;"><b  style="color: <?php echo $letras_cinta;?>;">RESULTADO</b></td>
				<td align="center" style="background-color: <?php echo $b_color;?>; width: 34%;"><b  style="color: <?php echo $letras_cinta;?>;">REFERENCIA</b></td>				
            </tr>
	  </table>
	<?php
	}
	elseif ($titulaje == 3)
	{	
	?>

	<table border="0">
		<tr>
			<td align="left" style="background-color: <?php echo $b_color;?>; width: 175px;"><b  style="color: <?php echo $letras_cinta;?>;">ESTUDIO: <?php echo $titulo;?></b></td>
			<td align="center" style="background-color: <?php echo $b_color;?>; width: 356px;"><b  style="color: <?php echo $letras_cinta;?>;">RESULTADO</b></td>
			<td align="center" style="background-color: <?php echo $b_color;?>; width: 1px;"><b  style="color: <?php echo $letras_cinta;?>;"></b></td>
			<td align="center" style="background-color: <?php echo $b_color;?>; width: 1px;"><b  style="color: <?php echo $letras_cinta;?>;"></b></td>	
			<td align="center" style="background-color: <?php echo $b_color;?>; width: 1px;"><b  style="color: <?php echo $letras_cinta;?>;"></b></td>				
		</tr>
	</TABLE>
	  
	<?php
	}
	?>

<?php 	
}
else
{
$b_color=$gris_rata;
?>
	<table border="0">
		<tr>
			<td align="left" style="background-color: <?php echo $b_color;?>; width: 175px;"><b>ESTUDIO: EXÁMEN GENERAL DE ORINA</b></td>
			<td align="center" style="background-color: <?php echo $b_color;?>; width: 138px;"><b>RESULTADO</b></td>
			<td align="center" style="background-color: <?php echo $b_color;?>; width: 45px;"><b>ANORMAL</b></td>
			<td align="center" style="background-color: <?php echo $b_color;?>; width: 60px;"><b>UNIDADES</b></td>	
			<td align="center" style="background-color: <?php echo $b_color;?>; width: 116px;"><b>REFERENCIA</b></td>				
		</tr>
	</TABLE>
	
<?php 
}

    }
}




/******************************************************/

if (!function_exists('lineas_en_blanco'))
{
    function lineas_en_blanco($lineas)
    {
		?>
		<table>
				<?php 
				for ($i=0; $i < $lineas; $i++)
				{ ?>
				<tr>
					<td></td>
				</tr>
				<?php 
				} 
				?>
		</table>
		<?php
		return  $lineas;
	}
}

if (!function_exists('media_rep_obs'))
{
    function media_rep_obs($emp_giro,$obs,$rango,$lineas,$bio='',$gral=0)
    {
		if ($emp_giro == 'SEGURIDAD')
		{	
		
		if (strtoupper($obs) != 'NINGUNA')
			{
			?>
			<table>
				<?php 
				for ($i=0; $i < $lineas; $i++)
				{ ?>
				<tr>
					<td></td>
				</tr>
				<?php 
				} 
				?>
				<tr>
					<td align="center" style="background-color: #00004d;"><b style="color: #fff;">OBSERVACIONES</b></td>
				</tr>		
				<tr>
					<td align="left"><?php echo $obs; ?></td>
				</tr>
			</table>
			<?php
			}
		}
		elseif ($gral == 1)
		{
			?>
			<table>
				<?php 
				for ($i=0; $i < $lineas; $i++)
				{ ?>
				<tr>
					<td></td>
				</tr>
				<?php 
				} 
				
				?>
				<tr>
					<td align="left" style="font-size:110%;"><b><?php echo 'OBSERVACIONES:&nbsp;'.$obs; ?></b></td>
				</tr>
				<tr>
					<td style="font-size:110%;"></td>
				</tr>
				<tr>
					<td align="left" style="font-size:110%;"><b><?php echo 'Lo(s) resultado(s) fuera de rango validado(s):&nbsp;'.$rango; ?></b></td>
				</tr>
				<tr>
					<td style="font-size:110%;"></td>
				</tr>
				<tr>
					<td style="font-size:110%;">&nbsp;</td>
				</tr>
				<tr>
					<td style="font-size:110%;">&nbsp;</td>
				</tr>
				<tr>
					<td style="font-size:110%;">&nbsp;</td>
				</tr>				
				<tr>
					<td align="left" style="font-size:110%;"><b><?php echo agrega_cedula($bio,'&nbsp;Cédula Profesional:'); ?></b></td>
				</tr>				
			</table>
			<?php
		
		}	
		
	}
}	






if (!function_exists('cabecera_repana_lab'))
{
    function cabecera_repana_lab($titulaje,$titulo,$muestra,$dedonde,$persona,$recibido,$emp_giro,$emp_razon_social)
    {
		
		$azul_solido='#00004d';
		$azul_hc='#4B5682';
		$gris_rata='#acacac';

	if ($emp_giro == 'SEGURIDAD')
	{
	 $b_color=$azul_solido;
	 
	?>
    <!-- <img src="<?php echo base_url('../dist/images/logo_2.png'); ?>" width="300px" /> -->
	<img src="<?php echo "./../../files/imagenes/logo_2.png"; ?>" width="300px" />
    <h3 align="center"><?php echo $titulo;?></h3>
    <h4>DATOS DEL SOLICITANTE</h4>
    <table border="1" cellpadding="3">
        <tr>
            <td align="center" style="background-color: <?php echo $b_color;?>;">
                <b style="color: #fff;">NOMBRE</b>
            </td>
            <td align="center" style="background-color: <?php echo $b_color;?>;">
                <b style="color: #fff;">RFC</b>
            </td>
        </tr>
        <tr>
            <td align="center">
                <?php echo $persona['clte_paterno'].' '.$persona['clte_materno'].' '.$persona['clte_nombre'].' '.$persona['clte_2_nombre']; ?>
            </td>
            <td align="center">
                <?php echo $persona['clte_rfc']; ?>
            </td>
        </tr>
    </table>
   <h4>
        EMPRESA EN LA QUE LABORA O ASPIRA A INGRESAR
    </h4>
    <h3 align="center" style="border: 1px solid #000; width: 50%; display: inline-block;"><?php echo $emp_razon_social; ?></h3>
	
    <table border="0" cellpadding="2">
        <tr>
            <td>
                <b style="color: #fff;">NOMBRE</b>
            </td>
        </tr>
    </table>
	
	<?php
	if ($titulaje == 1)
	{
	 ?>
	 <table border="0" >
            <tr>
                <td align="center" style="background-color: <?php echo $b_color;?>; width: 175px;"><b  style="color: #fff;">ESTUDIO</b></td>
				<td align="center" style="background-color: <?php echo $b_color;?>; width: 138px;"><b  style="color: #fff;">RESULTADO</b></td>
				<td align="center" style="background-color: <?php echo $b_color;?>; width: 45px;"><b  style="color: #fff;">ANORMAL</b></td>
				<td align="center" style="background-color: <?php echo $b_color;?>; width: 60px;"><b  style="color: #fff;">UNIDADES</b></td>	
				<td align="center" style="background-color: <?php echo $b_color;?>; width: 116px;"><b  style="color: #fff;">REFERENCIA</b></td>				
            </tr>
	 </table>
	<?php 
	}
	elseif ($titulaje == 2)
	{	
	?>
	 <table border="0" >
            <tr>
                <td align="center" style="background-color: <?php echo $b_color;?>; width: 33%;"><b  style="color: #fff;">ESTUDIO</b></td>
				<td align="center" style="background-color: <?php echo $b_color;?>; width: 33%;"><b  style="color: #fff;">RESULTADO</b></td>
				<td align="center" style="background-color: <?php echo $b_color;?>; width: 34%;"><b  style="color: #fff;">REFERENCIA</b></td>				
            </tr>
	  </table>
	<?php
	}
	elseif ($titulaje == 3)
	{	
	?>

	<table border="0">
		<tr>
			<td align="center" style="background-color: <?php echo $b_color;?>; width: 175px;"><b  style="color: #fff;">ESTUDIO:</b></td>
			<td align="center" style="background-color: <?php echo $b_color;?>; width: 356px;"><b  style="color: #fff;">RESULTADO</b></td>
			<td align="center" style="background-color: <?php echo $b_color;?>; width: 1px;"><b  style="color: #fff;"></b></td>
			<td align="center" style="background-color: <?php echo $b_color;?>; width: 1px;"><b  style="color: #fff;"></b></td>	
			<td align="center" style="background-color: <?php echo $b_color;?>; width: 1px;"><b  style="color: #fff;"></b></td>				
		</tr>
	</TABLE>
	  
	<?php
	}
	?>
<?php 
}
elseif ($emp_giro != 'SEGURIDAD')
{
	$b_color=$azul_hc;
	
	 
?>

<table style="width: 100%">
	<tr>
		<td style="width: 65%;"><img src="<?php echo base_url('../dist/images/logo_2.png'); ?>" width="200px" /></td>
	</tr>
</table>
<table border="0" ><tr><td></td></tr></table>
<table border="1" cellpadding="3">
	<tr>
		<td align="center" style="background-color:   <?php echo $b_color;?>; width: 33%;">
			<b style="color: #fff;">EMPRESA SOLICITANTE</b>
		</td>
		<td align="center" style="background-color:   <?php echo $b_color;?>; width: 33%;">
			<b style="color: #fff;">TIPO DE ESTUDIO</b>
		</td>
		<td align="center" style="background-color:   <?php echo $b_color;?>; width: 34%;">
			<b style="color: #fff;">SUCURSAL DE TOMA</b>
		</td>		
	</tr>
	<tr>
		<td align="center">
			<?php echo $emp_razon_social; ?>
		</td>

		<td align="center">
			<?php echo $titulo; ?>
		</td>
		<td align="center">
			<?php echo $persona['clte_nombre'].' '.$persona['clte_2_nombre'].' '.$persona['clte_paterno'].' '.$persona['clte_materno']; ?>
		</td>		
	</tr>
</table>

<table border="1" cellpadding="3">
	<tr>
		<td align="center" style="background-color:  <?php echo $b_color;?>; width: 60%;">
			<b style="color: #fff;"> DETALLE DE MUESTRA</b>
		</td>
		<td align="center" style="background-color:  <?php echo $b_color;?>; width: 20%;">
			<b style="color: #fff;">FECHA RECIBIDO</b>
		</td>
		<td align="center" style="background-color:  <?php echo $b_color;?>; width: 20%;">
			<b style="color: #fff;">FECHA DE IMPRESIÓN</b>
		</td>		
	</tr>
	<tr>
		<td align="center">
			<?php echo $muestra; ?>
		</td>
		<td align="center">
			<?php echo formatea_fecha($recibido) ; ?>
		</td>
		<td align="center"><?php echo formatea_fecha(date('Y-m-d H:i:s')); ?></td>		
	</tr>
</table>

	<table border="0" ><tr><td></td></tr></table>
	<?php
	if ($titulaje == 1)
	{
	 ?>
	 <table border="0" >
            <tr>
                <td align="left" style="background-color: <?php echo $b_color;?>; width: 100%;"><b  style="color: #fff;">ESTUDIO: <?php echo $titulo.' PROVENIENTE DE '.$dedonde;?></b></td>
            </tr>
	 </table>         
	<?php 
	}elseif ($titulaje == 2)
	{	
	?>
	 <table border="0" >
            <tr>
                <td align="left" style="background-color: <?php echo $b_color;?>; width: 33%;"><b  style="color: #fff;">ESTUDIO: <?php echo $titulo;?></b></td>
				<td align="center" style="background-color: <?php echo $b_color;?>; width: 33%;"><b  style="color: #fff;">RESULTADO</b></td>
				<td align="center" style="background-color: <?php echo $b_color;?>; width: 34%;"><b  style="color: #fff;">REFERENCIA</b></td>				
            </tr>
	  </table>
	<?php
	}
	elseif ($titulaje == 3)
	{	
	?>

	<table border="0">
		<tr>
			<td align="left" style="background-color: <?php echo $b_color;?>; width: 175px;"><b  style="color: #fff;">ESTUDIO: <?php echo $titulo;?></b></td>
			<td align="center" style="background-color: <?php echo $b_color;?>; width: 356px;"><b  style="color: #fff;">RESULTADO</b></td>
			<td align="center" style="background-color: <?php echo $b_color;?>; width: 1px;"><b  style="color: #fff;"></b></td>
			<td align="center" style="background-color: <?php echo $b_color;?>; width: 1px;"><b  style="color: #fff;"></b></td>	
			<td align="center" style="background-color: <?php echo $b_color;?>; width: 1px;"><b  style="color: #fff;"></b></td>				
		</tr>
	</TABLE>
	  
	<?php
	}
	?>

<?php 	
}
else
{
$b_color=$gris_rata;
?>
<p>&nbsp;</p>
    <table>
		<tr>
			<td align="left">
				<img src="<?php echo base_url('../dist/images/logo_2.png'); ?>" width="170px" />
			</td>
		</tr>
	</table>
	
    <table border="0" class="table">
        <tr>
            <td align="center"   style="background-color: <?php echo $b_color;?>; width: 240px"><b>NOMBRE DEL PACIENTE</b></td>
            <td align="center" style="background-color: <?php echo $b_color;?>; width: 55px"><b>EDAD</b></td>
            <td align="center" style="background-color: <?php echo $b_color;?>; width: 65px"><b>SEXO</b></td>
            <td align="center" style="background-color: <?php echo $b_color;?>; width: 173px"><b>EMPRESA SOLICITANTE</b></td>			
        </tr>

        <tr>
            <td align="center"><?php echo $persona['clte_nombre'].' '.$persona['clte_2_nombre'].' '.$persona['clte_paterno'].' '.$persona['clte_materno']; ?>
            </td>
            <td align="center">
                <?php echo str_replace("años", "AÑOS", get_edad($persona['clte_f_nac'])) ; ?>
            </td>

            <td align="center">
                <?php 
				if ($persona['clte_genero_cve'] == "H")
				{
					echo "M";
				}
				else
				{
					echo "F";
				}
				?>
            </td>

            <td align="center"><?php echo $emp_razon_social; ?></td>
        </tr>
	</table>
	
    <table border="0" class="table">
        <tr>
            <td align="center"   style="background-color: <?php echo $b_color;?>; width: 177px"><b>IDENTIFICACIÓN - ODT</b></td>
            <td align="center" style="background-color: <?php echo $b_color;?>; width: 177px"><b>FECHA RECIBIDO</b></td>
            <td align="center" style="background-color: <?php echo $b_color;?>; width: 178px"><b>FECHA DE IMPRESIÓN</b></td>
        </tr>

        <tr>
            <td align="center" ></td>
            <td align="center">
                <?php echo formatea_fecha($recibido) ; ?>
            </td>
            <td align="center"><?php echo formatea_fechahora(date('Y-m-d H:i:s')); ?></td>
        </tr>		
	</TABLE>
	
	<table border="0">
		<tr>
			<td align="left" style="background-color: <?php echo $b_color;?>; width: 175px;"><b>ESTUDIO: EXÁMEN GENERAL DE ORINA</b></td>
			<td align="center" style="background-color: <?php echo $b_color;?>; width: 138px;"><b>RESULTADO</b></td>
			<td align="center" style="background-color: <?php echo $b_color;?>; width: 45px;"><b>ANORMAL</b></td>
			<td align="center" style="background-color: <?php echo $b_color;?>; width: 60px;"><b>UNIDADES</b></td>	
			<td align="center" style="background-color: <?php echo $b_color;?>; width: 116px;"><b>REFERENCIA</b></td>				
		</tr>
	</TABLE>
	
<?php 
}

    }
}



if (!function_exists('agrega_cedula'))
{
    function agrega_cedula($med_name,$titulo)
    {
			$laboratorista=explode(" ",$med_name);
			$med_cedula = str_replace(" ", "", $med_cedula);
			
			$med_name1='';
			$med_cedula=$med_name;
			for ($i=0; ($laboratorista[$i] != NULL); $i++)
			{
				$med_name1.=$laboratorista[$i].' ';
				$med_cedula = str_replace($laboratorista[$i], "", $med_cedula);
			}
			$med_cedula = str_replace(" ", "", $med_cedula);
			$med_name = $med_name1.'               '.$titulo.' '.$med_cedula;
        
		return $med_name;
    }
}



if (!function_exists('get_empresas_array'))
{
    function get_empresas_array()
    {
        $CI =& get_instance();
        $empresas = array();
        if($CI->session->has_userdata('user'))
        {
            $user = $CI->session->user;
            $empresas = $user['despachos'];
        }
        $emp_id = get_emp_id();
        array_push($empresas,$emp_id);
        return $empresas;
    }
}


if (!function_exists('get_sucursal_id'))
{
    function get_sucursal_id()
    {

        $CI =& get_instance();
        if($CI->session->has_userdata('user'))
        {
            $user = $CI->session->user;
            $usr_ido = $user['usr_id'];
        }
		$CI->load->model('empleado/Empleado_model','despacho');
        $despachos = $CI->despacho->get($usr_ido);
	//echo "--->". $despachos['suc_id']."<---";
		return $despachos['suc_id'];
    }
}


if (!function_exists('get_emp_by_suc'))
{
    function get_emp_by_suc($suc_id)
    {
		$CI =&get_instance();
		$sql="SELECT * FROM sis65_sucursales where suc_id = ".$suc_id;
		$result = $CI ->db->query($sql);
		$resultado=$result->row_array();
		return $resultado['emp_id'];
    }
}



if (!function_exists('get_examenes_realizados_detail'))
{
    function get_examenes_realizados_detail($examen, $fsm_id )
    {
		$pass=0;
		$sql = "select * "; 
	
		if ($examen == 'R3P51C')
		{ 
			$sql = $sql. "	
				FROM fsm_psicologico_2
				where				
				fsm_id = ".$fsm_id;
				$pass++;
        }
		elseif ($examen == 'SSESTSOC')
		{
			$sql = $sql. "	
				FROM fsm_ss_estsoc
				where				
				fsm_id = ".$fsm_id;
				$pass++;
        }
		elseif ($examen == 'H0N3')
		{
			$sql = $sql. "	
				FROM fsm_hone_aicm
				where				
				fsm_id = ".$fsm_id;
				$pass++;
        }
		elseif ($examen == 'PS1C3XT')
		{
			$sql = $sql. "	
				FROM fsm_psicologico
				where				
				fsm_id = ".$fsm_id;
				$pass++;
        }
		elseif ($examen == 'HIV')
		{
			$sql = $sql." FROM fsm_hiv
				where 
				fsm_id = ".$fsm_id;
				$pass++;
        }elseif ($examen == 'TOXIW')
		{
			$sql = $sql." FROM fsm_toxicologico12
				where 
				fsm_id = ".$fsm_id;
				$pass++;
        }elseif ($examen == 'TOXIX')
		{
			$sql = $sql." FROM fsm_toxicologico6
				where 
				fsm_id = ".$fsm_id;
				$pass++;
        }elseif ($examen == 'HMEDXFIS')
		{
			$sql = $sql." FROM fsm_medico_fisico_ext  
				where 
				fsm_id = ".$fsm_id;
				$pass++;
        }elseif ($examen == 'TOXIT')
		{
			$sql = $sql." FROM fsm_toxicologico3
				where 
				fsm_id = ".$fsm_id;
				$pass++;
        }elseif ($examen == 'TOXI')
		{
			$sql = $sql." FROM fsm_toxicologico
				where 
				fsm_id = ".$fsm_id;
				$pass++;
        }elseif ($examen == 'TOXIS')
		{
			$sql = $sql. " FROM fsm_toxicologico7
				where 
				fsm_id = ".$fsm_id;
				$pass++;
        }elseif ($examen == 'MEDFIS')
		{
			$sql = $sql. "	FROM fsm_medico_fisico
				where 
				fsm_id = ".$fsm_id;
				$pass++;
        }elseif ($examen == 'FSM0105')
		{
			$sql = $sql. "
				FROM fpfh_01_05
				where 
				fsm_id = ".$fsm_id;
				$pass++;
        }elseif ($examen == 'PIE')
		{
			$sql = $sql. "
				FROM fsm_pie
				where 
				fsm_id = ".$fsm_id;
				$pass++;
        }elseif ($examen == 'SOCIE')
		{
			$sql = $sql. "	FROM socio_eco
				where 
				fsm_id = ".$fsm_id;
				$pass++;
        }elseif ($examen == 'SOCIE_VISITA')
		{
			$sql = $sql. "	FROM socio_eco
				where 
				fsm_id = ".$fsm_id;
				$pass++;
        }elseif ($examen == 'CED')
		{
			$sql = $sql. "	FROM fsm_poligrafico
				where 
				fsm_id = ".$fsm_id." and polig_tipo_cve = 'CEDULA' " ;
				$pass++;
        }elseif ($examen == 'POL')
		{
			$sql = $sql. "	FROM fsm_poligrafico
				where 
				fsm_id = ".$fsm_id." and polig_tipo_cve = 'POLI' ";
				$pass++;
        }elseif ($examen == 'ENTSOC')
		{
			$sql = $sql. "
				FROM entorno_soc
				where 
				fsm_id = ".$fsm_id;
				$pass++;
        }elseif ($examen == 'ESTSOC')
		{
			$sql = $sql. "
				FROM esc
				where 
				fsm_id = ".$fsm_id;
				$pass++;
        }elseif ($examen == 'EYED')
		{
			$sql = $sql. "
				FROM fsm_eye_detect
				where 
				fsm_id = ".$fsm_id;
				$pass++;
        }elseif ($examen == 'COV19R')
		{
			$sql = $sql. "
				FROM fsm_covid
				where 
				fsm_id = ".$fsm_id;
				$pass++;
        }
		elseif ($examen == 'PSIC')
		{
			$sql = $sql. "	
				FROM fsm_psicologico
				where				
				fsm_id = ".$fsm_id;
				$pass++;
        }
		elseif ($examen == 'REPSIC')
		{
			$sql = $sql. "	
				FROM fsm_psicologico_2
				where				
				fsm_id = ".$fsm_id;
				$pass++;
        }		
		
		//echo $sql;
		$calificacion='';
		if ($pass == 1)
		{
			$CI =& get_instance();
			$result = $CI ->db->query($sql);
			$resultado=$result->row_array();
			
			if ($examen == 'R3P51C')
			{
				if ($resultado['fsm_cve'] == 'APTO')
				{
					$calificacion='<span class="APTO">APTO</span>';
				}
				else
				{
					$calificacion= '<span class="NOAPTO">NO APTO</span>';
				}
			}			
			elseif ($examen == 'SSESTSOC')
			{
				if ($resultado['fss_cp_photo_1'] != '')
				{
					$calificacion='<span class="APTO">CON FOTOS</span>';
				}
				else
				{
					$calificacion= '<span class="PENDIENTE">SIN FOTOS</span>';
				}
			}			
			elseif ($examen == 'H0N3')
			{
				if ($resultado['fsm_cve'] == 'APTO')
				{
					$calificacion='<span class="APTO">APTO</span>';
				}
				else
				{
					$calificacion= '<span class="NOAPTO">NO APTO</span>';
				}
			}			
			elseif ($examen == 'HMEDXFIS')
			{
				if (
					($resultado['fsm_resultados'] == 'APTO')   	
				)
				{
					$calificacion= '<span class="APTO">APTO</span>';
				}
				else 
				{
					$calificacion='<span class="NOAPTO">NO APTO</span>';
				}
				
			}elseif ($examen == 'TOXIT')
			{
								
				if (
					($resultado['fsm_opi_cve'] == 'NEGATIVO') && 
					($resultado['fsm_coc_cve'] == 'NEGATIVO') &&  
					($resultado['fsm_mar_cve'] == 'NEGATIVO')   	
				)
				{
					
					$calificacion= '<span class="APTO">APTO</span>';
				}
				else 
				{
					$calificacion='<span class="NOAPTO">NO APTO</span>';
				}
				
			}elseif ($examen == 'TOXI')
			{
				if (
					($resultado['fsm_anf_cve'] == 'NEGATIVO') && 
					($resultado['fsm_coc_cve'] == 'NEGATIVO') &&  
					($resultado['fsm_mar_cve'] == 'NEGATIVO') && 
					($resultado['fsm_opi_cve'] == 'NEGATIVO') && 
					($resultado['fsm_pcp_cve'] == 'NEGATIVO')  	
				)
				{
					$calificacion= '<span class="APTO">APTO</span>';
				}
				else 
				{
					$calificacion='<span class="NOAPTO">NO APTO</span>';
				}
			}elseif ($examen == 'TOXIW')
			{
				if (
					($resultado['fsm_anf_cve'] == 'NEGATIVO') && 
					($resultado['fsm_coc_cve'] == 'NEGATIVO') &&  
					($resultado['fsm_mar_cve'] == 'NEGATIVO') && 
					($resultado['fsm_opi_cve'] == 'NEGATIVO') && 
					($resultado['fsm_met_cve'] == 'NEGATIVO') &&
					($resultado['fsm_bzd_cve'] == 'NEGATIVO') && 
					($resultado['fsm_bar_cve'] == 'NEGATIVO') && 
					($resultado['fsm_mtd_cve'] == 'NEGATIVO') && 
					($resultado['fsm_pcp_cve'] == 'NEGATIVO') &&
					($resultado['fsm_ppx_cve'] == 'NEGATIVO') && 
					($resultado['fsm_tca_cve'] == 'NEGATIVO') && 
					($resultado['fsm_xtc_cve'] == 'NEGATIVO') 	
				)
				{
					$calificacion='<span class="APTO">APTO</span>';
				}
				else 
				{
					$calificacion= '<span class="NOAPTO">NO APTO</span>';
				}
			}elseif ($examen == 'TOXIS')
			{
				if (
					($resultado['fsm_anf_cve'] == 'NEGATIVO') && 
					($resultado['fsm_coc_cve'] == 'NEGATIVO') &&  
					($resultado['fsm_mar_cve'] == 'NEGATIVO') && 
					($resultado['fsm_opi_cve'] == 'NEGATIVO') && 
					($resultado['fsm_pcp_cve'] == 'NEGATIVO') &&
					($resultado['fsm_bzd_cve'] == 'NEGATIVO') && 
					($resultado['fsm_bar_cve'] == 'NEGATIVO') 	
				)
				{
					$calificacion='<span class="APTO">APTO</span>';
				}
				else 
				{
					$calificacion= '<span class="NOAPTO">NO APTO</span>';
				}
			}elseif ($examen == 'MEDFIS')
			{
				if (
					($resultado['fsm_med_vis_cve'] == 'APTO')	&&
					($resultado['fsm_med_aud_cve'] == 'APTO')	&& 	
					($resultado['fsm_med_olf_cve'] == 'APTO')	&&	
					($resultado['fsm_med_pul_cve'] == 'APTO')	&& 	
					($resultado['fsm_fis_ref_cve'] == 'APTO')	&& 	
					($resultado['fsm_fis_cond_cve'] == 'APTO')	&& 	
					($resultado['fsm_fis_res_cve'] == 'APTO')	&& 	
					($resultado['fsm_fis_loc_cve'] == 'APTO')				
				)
				{
					$calificacion='<span class="APTO">APTO</span>';
				}
				else 
				{
					$calificacion= '<span class="NOAPTO">NO APTO</span>';
				}

			}elseif ($examen == 'FSM0105')
			{
				
				
				if (
						strstr($resultado['fpfh_resultado'],'APTO') ||
						($resultado['fpfh_resultado'] == 'PENDIENTE') 
					)
					{
							if (($resultado['fpfh_resultado'] == 'APTO'))
							{
								$calificacion='<span class="APTO">APTO</span>';
							}
							elseif (($resultado['fpfh_resultado'] == 'PENDIENTE')) 
							{
								$calificacion= '<span class="PENDIENTE">PENDIENTE</span>';
							}
							else
							{
								$calificacion= '<span class="NOAPTO">NO APTO</span>';
							}						
					}
					else
					{
						if (($resultado['fpfh_resultado'] == 'URGENTE'))
							{
								$calificacion='REC. REVALORACIÓN: <span class="NOAPTO">'.$resultado['fpfh_resultado'].'</span>';
							}
							else
							{
								$calificacion='REC. REVALORACIÓN: <span class="APTO">'.$resultado['fpfh_resultado'].'</span>';						
							}
					}	
				


			}elseif ($examen == 'HIV')
			{
				if (($resultado['hiv_fis_resultado'] == 'NEGATIVO'))
				{
					$calificacion='<span class="APTO">NEGATIVO</span>';
				}
				else
				{
					$calificacion= '<span class="NOAPTO">POSITIVO</span>';
				}

			}elseif ($examen == 'PIE')
			{
				if (($resultado['pie_fis_resultado'] == 'NEGATIVO'))
				{
					$calificacion='<span class="APTO">NEGATIVO</span>';
				}
				else
				{
					$calificacion= '<span class="NOAPTO">POSITIVO</span>';
				}

			}elseif ($examen == 'SOCIE')
			{	
				if (($resultado['fsm_apto'] == 'APTO'))
				{
					$calificacion='<span class="APTO">APTO</span>';
				}
				elseif (($resultado['fsm_apto'] == 'NO APTO'))
				{
					$calificacion= '<span class="NOAPTO">NO APTO</span>';
				}				
				elseif (($resultado['fsm_apto'] == 'NOAPTO'))
				{
					$calificacion= '<span class="NOAPTO">NO APTO</span>';
				}
				elseif (($resultado['fsm_apto'] == 'APTO CON RESERVA'))
				{
					$calificacion= '<span class="APTO">APTO CON RESERVA</span>';
				}
				else
				{
					$calificacion= '<span class="PENDIENTE">PENDIENTE</span>';
				}

			}elseif ($examen == 'SOCIE_VISITA')
			{	
				if (($resultado['fsm_apto'] == 'APTO'))
				{
					$calificacion='<span class="APTO">APTO</span>';
				}
				elseif (($resultado['fsm_apto'] == 'NO APTO'))
				{
					$calificacion= '<span class="NOAPTO">NO APTO</span>';
				}				
				elseif (($resultado['fsm_apto'] == 'NOAPTO'))
				{
					$calificacion= '<span class="NOAPTO">NO APTO</span>';
				}
				elseif (($resultado['fsm_apto'] == 'APTO CON RESERVA'))
				{
					$calificacion= '<span class="APTO">APTO CON RESERVA</span>';
				}
				else
				{
					$calificacion= '<span class="PENDIENTE">PENDIENTE</span>';
				}

			}elseif ($examen == 'CED')
			{
				if ($resultado['polig_cedula_resultado'] == 'APTO')
				{
					$calificacion='<span class="APTO">APTO</span>';
				}
				elseif ($resultado['polig_cedula_resultado'] == 'NOAPTO')
				{
					$calificacion= '<span class="NOAPTO">NO APTO</span>';
				}else
				{
					$calificacion= '<span class="PENDIENTE">PENDIENTE</span>';
				}

			}elseif ($examen == 'POL')
			{
				if ($resultado['polig_resultado_tecnico'] == 'APTO')
				{
					$calificacion='<span class="APTO">APTO</span>';
				}
				elseif ($resultado['polig_resultado_tecnico'] == 'NOAPTO')
				{
					$calificacion= '<span class="NOAPTO">NO APTO</span>';
				}
				else
				{
					$calificacion= '<span class="PENDIENTE">PENDIENTE</span>';
				}

			}elseif ($examen == 'ENTSOC')
			{
				if (($resultado['fsm_apto'] == 'APTO'))
				{
					$calificacion='<span class="APTO">APTO</span>';
				}
				elseif (($resultado['fsm_apto'] == 'NO APTO'))
				{
					$calificacion= '<span class="NOAPTO">NO APTO</span>';
				}
				elseif (($resultado['fsm_apto'] == 'APTO CON RESERVA'))
				{
					$calificacion= '<span class="APTO">APTO CON RESERVA</span>';
				}				
				elseif (($resultado['fsm_apto'] == 'NOAPTO'))
				{
					$calificacion= '<span class="NOAPTO">NO APTO</span>';
				}else
				{
					$calificacion= '<span class="PENDIENTE">PENDIENTE</span>';
				}

			}elseif ($examen == 'ESTSOC')
			{
				if (($resultado['fsm_apto'] == 'APTO'))
				{
					$calificacion='<span class="APTO">APTO</span>';
				}
				elseif (($resultado['fsm_apto'] == 'NOAPTO'))
				{
					$calificacion= '<span class="NOAPTO">NO APTO</span>';
				}
				elseif (($resultado['fsm_apto'] == 'NO APTO'))
				{
					$calificacion= '<span class="NOAPTO">NO APTO</span>';
				}
				elseif (($resultado['fsm_apto'] == 'APTO CON RESERVA'))
				{
					$calificacion= '<span class="APTO">APTO CON RESERVA</span>';
				}				
				else
				{
					$calificacion= '<span class="PENDIENTE">PENDIENTE</span>';
				}

			}elseif (($examen == 'EYED'))
			{
				$resultado_promedio= ($resultado['fsm_consumo_drogas']+$resultado['fsm_robo']+$resultado['fsm_delicuencia'] + $resultado['fsm_delitos_graves'])/4.0;
	
				if
				(
					(($resultado['fsm_consumo_drogas'] >= 1) && ($resultado['fsm_consumo_drogas'] <= 50) )||
					(($resultado['fsm_robo'] >= 1) && ($resultado['fsm_robo'] <= 50)) ||
					(($resultado['fsm_delicuencia'] >= 1) && ($resultado['fsm_delicuencia'] <= 50) )||
					(($resultado['fsm_delitos_graves'] >= 1) && ($resultado['fsm_delitos_graves'] <= 50)) 
				)
				{
					//$resultado = 'No Apto - Presenta engaño en al menos un tema';
					//$resultado_c = 'No Veraz';
					$calificacion= '<span class="NOAPTO">NO VERAZ</span>';
				} elseif($resultado_promedio >= 1.0 && $resultado_promedio <= 50.99)
				{
					//$resultado = 'No confiable y no Veraz';
					//$resultado_c = 'No Veraz';
					$calificacion= '<span class="NOAPTO">NO VERAZ</span>';
				} else if($resultado_promedio >= 51.0 && $resultado_promedio <= 100.0)
				{
					//$resultado = 'Confiable y Veraz';
					//$resultado_c = 'Veraz';
					$calificacion='<span class="APTO">VERAZ</span>';
				}else 
				{
					//$resultado = 'Error: Rango no definido';
					$resultado_c = 'Error';
					$calificacion= '<span class="PENDIENTE">ERROR</span>';
				}
			}elseif ($examen == 'COV19R')
			{	
				if
				(
					(trim($resultado['antigeno_sars_resultado']) == 'NEGATIVO')  ||
					
					(trim($resultado['antigeno_sars_resultado']) == 'NEGATIVA')  ||

					( (trim($resultado['anticuerpos_IgG_resultado']) == 'NEGATIVO') && (trim($resultado['anticuerpos_IgM_resultado'])== 'NEGATIVO')) 
				)
				{
					$calificacion='<span class="APTO">NEGATIVO</span>';
				} else
				{
					$calificacion= '<span class="NOAPTO">POSITIVO</span>';
				}
			}
			elseif ($examen == 'PS1C3XT')
			{
				if ($resultado['fsm_cve'] == 'APTO')
				{
					$calificacion='<span class="APTO">APTO</span>';
				}
				else
				{
					$calificacion= '<span class="NOAPTO">NO APTO</span>';
				}
			}			
			elseif ($examen == 'PSIC')
			{
				if ($resultado['fsm_cve'] == 'APTO')
				{
					$calificacion='<span class="APTO">APTO</span>';
				}
				else
				{
					$calificacion= '<span class="NOAPTO">NO APTO</span>';
				}
			}			
			elseif ($examen == 'REPSIC')
			{
				if ($resultado['fsm_cve'] == 'APTO')
				{
					$calificacion='<span class="APTO">APTO</span>';
				}
				elseif ($resultado['fsm_cve'] == 'SIN RESULTADO')
				{
					$calificacion= '';
				}
				elseif ($resultado['fsm_cve'] == 'NOAPTO')
				{
					$calificacion= '<span class="NOAPTO">NO APTO</span>';
				}
			}
		}

		return $calificacion;
    }	
	
	
	
	
}




if (!function_exists('formatMoney'))
{
	function formatMoney($number, $fractional=false) {
		if ($fractional) {
			$number = sprintf('%.4f', $number);
		}
		while (true) {
			$replaced = preg_replace('/(-?\d+)(\d\d\d)/', '$1,$2', $number);
			if ($replaced != $number) {
				$number = $replaced;
			} else {
				break;
			}
		}
		return $number;
	}
}

if (!function_exists('get_code_html'))
{
		function get_code_html($datos)
		{
			$html_especiales=array("&iexcl;","&cent;","&pound;","&curren;","&yen;",
			"&brvbar;","&sect;","&uml;","&copy;","&ordf;","&laquo;","&not;","&shy;",
			"&reg;","&macr;","&deg;","&plusmn;","&sup2;","&sup3;","&acute;","&micro;",
			"&para;","&middot;","&cedil;","&sup1;","&ordm;","&raquo;","&frac14;","&frac12;",
			"&frac34;","&iquest;","&Agrave;","&Aacute;","&Acirc;","&Atilde;","&Auml;","&Aring;",
			"&AElig;","&Ccedil;","&Egrave;","&Eacute;","&Ecirc;","&Euml;","&Igrave;","&Iacute;",
			"&Icirc;","&Iuml;","&ETH;","&Ntilde;","&Ograve;","&Oacute;","&Ocirc;","&Otilde;",
			"&Ouml;","&times;","&Oslash;","&Ugrave;","&Uacute;","&Ucirc;","&Uuml;","&Yacute;",
			"&THORN;","&szlig;","&agrave;","&aacute;","&acirc;","&atilde;","&auml;","&aring;",
			"&aelig;","&ccedil;","&egrave;","&eacute;","&ecirc;","&euml;","&igrave;","&iacute;",
			"&icirc;","&iuml;","&eth;","&ntilde;","&ograve;","&oacute;","&ocirc;","&otilde;",
			"&ouml;","&divide;","&oslash;","&ugrave;","&uacute;","&ucirc;","&uuml;","&yacute;",
			"&thorn;","&yuml;","&euro;");

			$car_especiales=array("¡","¢","£","¤","¥",
			"¦","§","¨","©","ª","«","¬","­","®","¯","°","±","²",
			"³","´","µ","¶","·","¸","¹","º","»","¼","½","¾","¿",
			"À","Á","Â","Ã","Ä","Å","Æ","Ç","È","É","Ê","Ë",
			"Ì","Í","Î","Ï","Ð","Ñ","Ò","Ó","Ô","Õ","Ö","×","Ø",
			"Ù","Ú","Û","Ü","Ý","Þ","ß","à","á","â","ã","ä",
			"å","æ","ç","è","é","ê","ë","ì","í","î","ï","ð",
			"ñ","ò","ó","ô","õ","ö","÷","ø","ù","ú","û","ü","ý",
			"þ","ÿ","€");

			$palabra=$datos;
			for ($i = 0; $i < 96; $i++) {
				$palabra= str_replace($car_especiales[$i], $html_especiales[$i], $palabra);
			}

			 return $palabra;
		}
}



/*******************************************************/
if (!function_exists('unidad'))
{
function unidad($numuero)
{
	switch ($numuero)
	{
		case 9:
		{
			$numu = "NUEVE";
			break;
		}
		case 8:
		{

			$numu = "OCHO";

			break;

		}

		case 7:

		{

			$numu = "SIETE";

			break;

		}

		case 6:

		{

			$numu = "SEIS";

			break;

		}

		case 5:

		{

			$numu = "CINCO";

			break;

		}

		case 4:

		{

			$numu = "CUATRO";

			break;

		}

		case 3:

		{

			$numu = "TRES";

			break;

		}

		case 2:

		{

			$numu = "DOS";

			break;

		}

		case 1:

		{

			$numu = "UNO";

			break;

		}

		case 0:

		{

			$numu = "";

			break;

		}

	}

	return $numu;

}
}

 
if (!function_exists('decena'))
{
function decena($numdero)
{

 

		if ($numdero >= 90 && $numdero <= 99)

		{

			$numd = "NOVENTA ";

			if ($numdero > 90)

				$numd = $numd."Y ".(unidad($numdero - 90));

		}

		else if ($numdero >= 80 && $numdero <= 89)

		{

			$numd = "OCHENTA ";

			if ($numdero > 80)

				$numd = $numd."Y ".(unidad($numdero - 80));

		}

		else if ($numdero >= 70 && $numdero <= 79)

		{

			$numd = "SETENTA ";

			if ($numdero > 70)

				$numd = $numd."Y ".(unidad($numdero - 70));

		}

		else if ($numdero >= 60 && $numdero <= 69)

		{

			$numd = "SESENTA ";

			if ($numdero > 60)

				$numd = $numd."Y ".(unidad($numdero - 60));

		}

		else if ($numdero >= 50 && $numdero <= 59)

		{

			$numd = "CINCUENTA ";

			if ($numdero > 50)

				$numd = $numd."Y ".(unidad($numdero - 50));

		}

		else if ($numdero >= 40 && $numdero <= 49)

		{

			$numd = "CUARENTA ";

			if ($numdero > 40)

				$numd = $numd."Y ".(unidad($numdero - 40));

		}

		else if ($numdero >= 30 && $numdero <= 39)

		{

			$numd = "TREINTA ";

			if ($numdero > 30)

				$numd = $numd."Y ".(unidad($numdero - 30));

		}

		else if ($numdero >= 20 && $numdero <= 29)

		{

			if ($numdero == 20)

				$numd = "VEINTE ";

			else

				$numd = "VEINTI".(unidad($numdero - 20));

		}

		else if ($numdero >= 10 && $numdero <= 19)

		{

			switch ($numdero){

			case 10:

			{

				$numd = "DIEZ ";

				break;

			}

			case 11:

			{

				$numd = "ONCE ";

				break;

			}

			case 12:

			{

				$numd = "DOCE ";

				break;

			}

			case 13:

			{

				$numd = "TRECE ";

				break;

			}

			case 14:

			{

				$numd = "CATORCE ";

				break;

			}

			case 15:

			{

				$numd = "QUINCE ";

				break;

			}

			case 16:

			{

				$numd = "DIECISEIS ";

				break;

			}

			case 17:

			{

				$numd = "DIECISIETE ";

				break;

			}

			case 18:

			{

				$numd = "DIECIOCHO ";

				break;

			}

			case 19:

			{

				$numd = "DIECINUEVE ";

				break;

			}

			}

		}

		else

			$numd = unidad($numdero);

	return $numd;

}
}

 
if (!function_exists('centena'))
{
	function centena($numc)
	{

		if ($numc >= 100)

		{

			if ($numc >= 900 && $numc <= 999)

			{

				$numce = "NOVECIENTOS ";

				if ($numc > 900)

					$numce = $numce.(decena($numc - 900));

			}

			else if ($numc >= 800 && $numc <= 899)

			{

				$numce = "OCHOCIENTOS ";

				if ($numc > 800)

					$numce = $numce.(decena($numc - 800));

			}

			else if ($numc >= 700 && $numc <= 799)

			{

				$numce = "SETECIENTOS ";

				if ($numc > 700)

					$numce = $numce.(decena($numc - 700));

			}

			else if ($numc >= 600 && $numc <= 699)

			{

				$numce = "SEISCIENTOS ";

				if ($numc > 600)

					$numce = $numce.(decena($numc - 600));

			}

			else if ($numc >= 500 && $numc <= 599)

			{

				$numce = "QUINIENTOS ";

				if ($numc > 500)

					$numce = $numce.(decena($numc - 500));

			}

			else if ($numc >= 400 && $numc <= 499)

			{

				$numce = "CUATROCIENTOS ";

				if ($numc > 400)

					$numce = $numce.(decena($numc - 400));

			}

			else if ($numc >= 300 && $numc <= 399)

			{

				$numce = "TRESCIENTOS ";

				if ($numc > 300)

					$numce = $numce.(decena($numc - 300));

			}

			else if ($numc >= 200 && $numc <= 299)

			{

				$numce = "DOSCIENTOS ";

				if ($numc > 200)

					$numce = $numce.(decena($numc - 200));

			}

			else if ($numc >= 100 && $numc <= 199)

			{

				if ($numc == 100)

					$numce = "CIEN ";

				else

					$numce = "CIENTO ".(decena($numc - 100));

			}

		}

		else

			$numce = decena($numc);

 

		return $numce;

}
}

 
if (!function_exists('miles'))
{
	function miles($nummero)
	{

		if ($nummero >= 1000 && $nummero < 2000){

			$numm = "MIL ".(centena($nummero%1000));

		}

		if ($nummero >= 2000 && $nummero <10000){

			$numm = unidad(Floor($nummero/1000))." MIL ".(centena($nummero%1000));

		}

		if ($nummero < 1000)

			$numm = centena($nummero);

 

		return $numm;

	}
}

 
if (!function_exists('decmiles'))
{
	function decmiles($numdmero)
	{

		if ($numdmero == 10000)

			$numde = "DIEZ MIL";

		if ($numdmero > 10000 && $numdmero <20000){

			$numde = decena(Floor($numdmero/1000))."MIL ".(centena($numdmero%1000));

		}

		if ($numdmero >= 20000 && $numdmero <100000){

			$numde = decena(Floor($numdmero/1000))." MIL ".(miles($numdmero%1000));

		}

		if ($numdmero < 10000)

			$numde = miles($numdmero);

 

		return $numde;

	}
}

 
if (!function_exists('cienmiles'))
{
	function cienmiles($numcmero)
	{

		if ($numcmero == 100000)

			$num_letracm = "CIEN MIL";

		if ($numcmero >= 100000 && $numcmero <1000000){

			$num_letracm = centena(Floor($numcmero/1000))." MIL ".(centena($numcmero%1000));

		}

		if ($numcmero < 100000)

			$num_letracm = decmiles($numcmero);

		return $num_letracm;

	}
}

 
if (!function_exists('millon'))
{
	function millon($nummiero)
	{

		if ($nummiero >= 1000000 && $nummiero <2000000){

			$num_letramm = "UN MILLON ".(cienmiles($nummiero%1000000));

		}

		if ($nummiero >= 2000000 && $nummiero <10000000){

			$num_letramm = unidad(Floor($nummiero/1000000))." MILLONES ".(cienmiles($nummiero%1000000));

		}

		if ($nummiero < 1000000)

			$num_letramm = cienmiles($nummiero);

 

		return $num_letramm;

	}
}

 
if (!function_exists('decmillon'))
{
	function decmillon($numerodm)
	{

		if ($numerodm == 10000000)

			$num_letradmm = "DIEZ MILLONES";

		if ($numerodm > 10000000 && $numerodm <20000000){

			$num_letradmm = decena(Floor($numerodm/1000000))."MILLONES ".(cienmiles($numerodm%1000000));

		}

		if ($numerodm >= 20000000 && $numerodm <100000000){

			$num_letradmm = decena(Floor($numerodm/1000000))." MILLONES ".(millon($numerodm%1000000));

		}

		if ($numerodm < 10000000)

			$num_letradmm = millon($numerodm);

 

		return $num_letradmm;

	}
}

 
if (!function_exists('cienmillon'))
{
	function cienmillon($numcmeros)
	{
		if ($numcmeros == 100000000)
			$num_letracms = "CIEN MILLONES";
		if ($numcmeros >= 100000000 && $numcmeros <1000000000){
			$num_letracms = centena(Floor($numcmeros/1000000))." MILLONES ".(millon($numcmeros%1000000));
		}

		if ($numcmeros < 100000000)
			$num_letracms = decmillon($numcmeros);

		return $num_letracms;
	}
}

 
if (!function_exists('milmillon'))
{
	function milmillon($nummierod)
	{
		if ($nummierod >= 1000000000 && $nummierod <2000000000){
			$num_letrammd = "MIL ".(cienmillon($nummierod%1000000000));
		}

		if ($nummierod >= 2000000000 && $nummierod <10000000000){
			$num_letrammd = unidad(Floor($nummierod/1000000000))." MIL ".(cienmillon($nummierod%1000000000));
		}

		if ($nummierod < 1000000000)
			$num_letrammd = cienmillon($nummierod); 

		return $num_letrammd;
	}
}

 
if (!function_exists('convertir'))
{
	function convertir($numero)
	{
				 $num = str_replace(",","",$numero);
				 $num = number_format($num,2,'.','');
				 $cents = substr($num,strlen($num)-2,strlen($num)-1);
				 $num = (int)$num;
				 $numf = milmillon($num);
			return " PESOS  ".$numf." CON ".$cents."/100";
	}
}

if (!function_exists('salto_control_qs'))
{
	function salto_control_qs($control,$titulaje,$titulo,$persona,$recibido,$emp_giro,$emp_razon_social,$impresion,$fsm_id)
	{

		if ($emp_giro == $control)
		{
		?>	
			<br pagebreak="true" />
			<?php cabecera_reporte_lab($titulaje,$titulo,$persona,$recibido,$emp_giro,$emp_razon_social,$impresion,$fsm_id); ?>
			<table border="0">
	         <tr>
                <td align="left" style="width: 33%;"><b></b></td>
				<td align="center" style="width: 25%;"><b></b></td>
				<td align="center" style="width: 10%;"><b></b></td>
				<td align="center" style="width: 10%;"><b></b></td>	
				<td align="center" style=" width: 22%;"><b></b></td>				
            </tr>			
			
		<?php
		}		

			return 1;
	}
}

if (!function_exists('salto_control_qs_no'))
{
	function salto_control_qs_no($control,$titulaje,$titulo,$persona,$recibido,$emp_giro,$emp_razon_social,$impresion,$fsm)
	{

		if ($emp_giro != $control)
		{
		?>	
			<br pagebreak="true" />
			
			<?php	
			$muestra=toma_muestra_id($persona['clte_id'],$persona['emp_id']);
			if ($muestra)
			{
				$fecha_recibo=$muestra['fsm_fecha_muestra'];	
				$c=1;
			}
			else
			{
				$fecha_recibo=$recibido;
			}		
			?>	
			
			<?php cabecera_reporte_lab($titulaje,$titulo,$persona,$fecha_recibo,$emp_giro,$emp_razon_social,$impresion,$fsm['qui_medico_sol'],$fsm['fsm_id'],$c); ?>
			<table border="0">
	         <tr>
                <td align="left" style="width: 33%;"><b></b></td>
				<td align="center" style="width: 25%;"><b></b></td>
				<td align="center" style="width: 10%;"><b></b></td>
				<td align="center" style="width: 10%;"><b></b></td>	
				<td align="center" style=" width: 22%;"><b></b></td>				
            </tr>			
			
		<?php
		}		

			return 1;
	}
}


if (!function_exists('poner_titulo'))
{
	function poner_titulo($titulo)
	{
		?>	
		<img src="<?php echo base_url('../dist/images/logo_2.png'); ?>" width="300px" />
		<h3 align="center"><?php echo $titulo;?></h3>			
		<?php	
	}
}


if (!function_exists('get_una_sucursal_para_evaluado'))
{
    function get_una_sucursal_para_evaluado($suc_id)
    {
		$suc_alias=get_una_sucursal($suc_id);
		if ($suc_alias)
		{
			$suc_alias= ' * '.$suc_alias;
		}
		else
		{
			$suc_alias='';
		}	
        return $suc_alias;
    }
}

if (!function_exists('get_matriz'))
{
    function get_matriz($corp_nombre)
    {
		$CI =&get_instance();
		$sql="SELECT emp_razon_social FROM sis15_corporativos where corp_nombre like '".$corp_nombre."'";
		$result = $CI ->db->query($sql);
		$resultado=$result->row_array();
		return $resultado['emp_razon_social'];
    }
}


if (!function_exists('get_sucursal'))
{
    function get_sucursal($suc_id)
    {
		$CI =&get_instance();
		$sql="SELECT suc_alias FROM sis65_sucursales where suc_id = ".$suc_id;
		$result = $CI ->db->query($sql);
		$resultado=$result->row_array();
		return $resultado['suc_alias'];
    }
}
/********************************************************/