<?php
if (!defined('BASEPATH')) exit('No direct script access allowed');

if (!function_exists('genera_pdf')) {

    function genera_pdf($html, $filename = '',$title='', $subject='', $author='Humancenter Review S.A de C.V.', $tipo_pdf = 'P') {
        $CI =& get_instance();

        // Llamada a la libreria TCPDF
        $CI->load->library('tcpdf/Tcpdf');

        // Crear Nuevo PDF
        $pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

        //info del PDF  
        $pdf->SetCreator(PDF_CREATOR);
        $pdf->SetAuthor($author);
        $pdf->SetTitle($title);
        $pdf->SetSubject($subject);

        // Cabecera del PDF
        $pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE.' 001', PDF_HEADER_STRING, array(0,64,255), array(0,64,128));
        //$pdf->setFooterData(array(0,64,0), array(0,64,128));
        // set header and footer fonts
        $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
        $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
        $pdf->SetPrintHeader(false);
        // set default monospaced font
        //$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

        // set margins
        $pdf->SetMargins(10, 10);
        $pdf->SetHeaderMargin(1);
        $pdf->SetFooterMargin(5);

        // set auto page breaks
        $pdf->SetAutoPageBreak(TRUE, 10);

        // set image scale factor
        $pdf->setImageScale(1);
        $pdf->setFontSubsetting(true);
        $pdf->SetFont('helvetica', '', 9);
        $pdf->AddPage($tipo_pdf);
        $pdf->setTextShadow(array('enabled'=>false, 'depth_w'=>0.2, 'depth_h'=>0.2, 'color'=>array(196,196,196), 'opacity'=>1, 'blend_mode'=>'Normal'));

        $pdf->writeHTML($html, true, 0, true, true);
        $pdf->lastPage();
        ob_end_clean();
        $pdf->Output($filename,'I');
    }
}


if (!function_exists('genera_pdf_ma')) {

    function genera_pdf_ma($html, $filename = '',$title='', $subject='', $author='Humancenter Review S.A de C.V.', $tipo_pdf = 'P') 
	{
        $CI =& get_instance();
        $CI->load->library('tcpdf/Tcpdf');
		
// Extend the TCPDF class to create custom Header and Footer
class MYPDF extends TCPDF {

    //Page header
    public function Header() {
        // Logo
        $image_file = K_PATH_IMAGES.'hclogo.jpg';
        $this->Image($image_file, 20, 50, 175, 175, 'JPG', '', 'T', false, 300, '', false, false, 0, false, false, false);
        // Set font
        //$this->SetFont('helvetica', 'B', 10);
        // Title
        //$this->Cell(0, 0, '<< TCPDF Example 003 >>', 0, false, 'C', 0, '', 0, false, 'M', 'M');
    }

    // Page footer
    public function Footer() {
        // Position at 15 mm from bottom
		 $this->SetY(-19);	
		 $this->SetFont('helvetica', 'B', 7);		 	 
		 $this->Cell(0, 0,"San Borja 1365 Col. Vértiz Narvarte, Alcadía Benito Juárez, C.P. 03600, Ciudad de México",  0, false, 'C', 0, '', 0, false, 'T', 'M');
		 $this->SetY(-16);	
		 $this->Cell(0, 0,"_______________________________________________________________________________________________________________________________________________",  0, false, 'C', 0, '', 0, false, 'T', 'M');
		 $this->SetY(-15);
        // Set font
         $this->SetFont('helvetica', 'I', 8);
        // Page number
         $this->Cell(0, 10, 'Página '.$this->getAliasNumPage().'/'.$this->getAliasNbPages(), 0, false, 'C', 0, '', 0, false, 'T', 'M');
    }
}

	// create new PDF document
	$pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

	// set document information
	$pdf->SetCreator(PDF_CREATOR);
	$pdf->SetAuthor($author);
	$pdf->SetTitle($title);
	$pdf->SetSubject($subject);
	$pdf->SetKeywords('TCPDF, PDF, RECETAS, HUMANCENTER, PLATAFORMA');

	// set default header data
	$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE, PDF_HEADER_STRING);

	// set header and footer fonts
	$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
	$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

	// set default monospaced font
	$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

	// set margins
	//$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
	//$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
	//$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

	$pdf->SetMargins(10, 10);
	$pdf->SetHeaderMargin(10);
	$pdf->SetFooterMargin(5);

	// set auto page breaks
	$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);


	//$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
	$pdf->setImageScale(1);
	$pdf->setFontSubsetting(true);
	// set font
	$pdf->SetFont('helvetica', '', 9);


	// set some language-dependent strings (optional)
	if (@file_exists(dirname(__FILE__).'/lang/eng.php')) {
		require_once(dirname(__FILE__).'/lang/eng.php');
		$pdf->setLanguageArray($l);
		}

	//$pdf->SetFont('times', 'BI', 12);

	// add a page
	
	$pdf->AddPage();
	$pdf->writeHTML($html, true, 0, true, true);
	$pdf->lastPage();
	ob_end_clean();
	//$pdf->Output(K_PATH_IMAGES.'reporte_pdf_seguridad.pdf','F');
	$pdf->Output($filename,'I');
    }
}


if (!function_exists('genera_pdf_documento')) {

    function genera_pdf_documento($html, $filename = '',$title='', $subject='', $author='Humancenter Review S.A de C.V.', $tipo_pdf = 'P',$ruta) {
        $CI =& get_instance();

        // Llamada a la libreria TCPDF
        $CI->load->library('tcpdf/Tcpdf');

		// Extend the TCPDF class to create custom Header and Footer
		class MYPDF extends TCPDF 
		{
		
			// Page footer
			public function Footer() 
			{		 
				 $this->SetTextColorArray($this->footer_text_color);
				 $mueve=-38;
				 $mueve+=4;
				 $this->SetFont('helvetica', 'B', 7);
				 $mueve+=3;
				 $this->SetY($mueve);
				 $this->Cell(0, 0,"San Borja 1365 Col. Vértiz Narvarte, Alcaldía Benito Juárez, C.P. 03600 Ciudad de México. Tel. 55-36-40-44-36 ",  0, false, 'C', 0, '', 0, false, 'T', 'M');		 
			}
		}


        // Crear Nuevo PDF
        $pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

        //info del PDF  
        $pdf->SetCreator(PDF_CREATOR);
        $pdf->SetAuthor($author);
        $pdf->SetTitle($title);
        $pdf->SetSubject($subject);

        // Cabecera del PDF
        $pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE.' 001', PDF_HEADER_STRING, array(0,64,255), array(0,64,128));
        //$pdf->setFooterData(array(0,64,0), array(0,64,128));
        // set header and footer fonts
        $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
        $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
        $pdf->SetPrintHeader(false);
        // set default monospaced font
        //$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

        // set margins
        $pdf->SetMargins(25, 25);
        $pdf->SetHeaderMargin(1);
        $pdf->SetFooterMargin(5);

        // set auto page breaks
        $pdf->SetAutoPageBreak(TRUE, 10);

        // set image scale factor
        $pdf->setImageScale(1);
        $pdf->setFontSubsetting(true);
        $pdf->SetFont('helvetica', '', 9);
        //$pdf->AddPage($tipo_pdf);
		$pdf->AddPage('P', 'letter');
		//$pdf->Image('C:\xampp\htdocs\humancenter_forms\dist\images\hclogo.jpg', 55, 20, 100, 100, 'JPG', '', '', true, 200, '', false, false, 0, false, false, true); 
        //$pdf->Image($ruta, 60, 20, 100, 100, 'JPG', '', '', true, 200, '', false, false, 0, false, false, true); 
		$pdf->Image($ruta, 60, 30, 100, 100, 'JPG', '', '', true, 200, '', false, false, 0, false, false, true); 
		$pdf->setTextShadow(array('enabled'=>false, 'depth_w'=>0.2, 'depth_h'=>0.2, 'color'=>array(196,196,196), 'opacity'=>1, 'blend_mode'=>'Normal'));
		
        $pdf->writeHTML($html, true, 0, true, true);
        $pdf->lastPage();
        ob_end_clean();
        $pdf->Output($filename,'I');
    }
}

if (!function_exists('genera_pdf_documento2')) {

    function genera_pdf_documento2($html, $filename = '',$title='', $subject='', $author='Humancenter Review S.A de C.V.', $tipo_pdf = 'P',$ruta) {
        $CI =& get_instance();

        // Llamada a la libreria TCPDF
        $CI->load->library('tcpdf/Tcpdf');

// Extend the TCPDF class to create custom Header and Footer
	class MYPDF extends TCPDF {

	public $laboratorista;
	public $observaciones;

    // Page footer
    public function Footer() {
        // Position at 15 mm from bottom

        // Set font
         $this->SetFont('helvetica', 'B', 7);
		 $mueve=-15;
		 $this->SetY($mueve);
		 $this->SetFont('helvetica', 'B', 8);
		 $this->SetLineStyle(array('width' => 0.01, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 77)));
		 $this->SetFillColor(0, 0, 77);
		 $this->Cell(0, 0,"",1, 1, 'L', 1, 0);
		 $mueve+=4;
		 $this->SetFont('helvetica', 'B', 7);
		 $this->SetY($mueve);		 
		 $this->Cell(0, 0,"San Borja 1365 Col. Vértiz Narvarte, Alc. Benito Juárez C.P. 03600 Ciudad de México",  0, false, 'C', 0, '', 0, false, 'T', 'M');
    }
}


        // Crear Nuevo PDF
        $pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
		$pdf->laboratorista=$subject;
		$pdf->observaciones=$obs;
        //info del PDF
        $pdf->SetCreator(PDF_CREATOR);
        $pdf->SetAuthor($author);
        $pdf->SetTitle($title);
        $pdf->SetSubject($subject);

        // Cabecera del PDF
        $pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE.' 001', PDF_HEADER_STRING, array(0,64,255), array(0,64,128));
        //$pdf->setFooterData(array(0,64,0), array(0,64,128));
        // set header and footer fonts
        $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
        $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
        $pdf->SetPrintHeader(false);
        // set default monospaced font
        //$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

        // set margins
        $pdf->SetMargins(25, 25);
        $pdf->SetHeaderMargin(1);
        $pdf->SetFooterMargin(5);

        // set auto page breaks
        $pdf->SetAutoPageBreak(TRUE, 10);
		//$pdf->Image('C:\xampp\htdocs\humancenter_forms\application\views\examen\pie\hclogo.jpg', 15, 140, 75, 113, 'JPG', 'http://www.tcpdf.org', '', true, 150, '', false, false, 1, false, false, false);

        // set image scale factor
        $pdf->setImageScale(1);
		
        $pdf->setFontSubsetting(true);
        $pdf->SetFont('helvetica', '', 9);
       // $pdf->AddPage($tipo_pdf);
		$pdf->AddPage('P', 'letter');
		$pdf->Image($ruta_1, 35, 107, 150, 150, 'JPG', '', '', true, 200, '', false, false, 0, false, false, true); 
		//$pdf->Image('C:\xampp\htdocs\humancenter_forms\application\views\examen\pie\hclogo.jpg', 10, 55, 300, 300, 'JPG', '', '', true, 200, '', false, false, 0, false, false, true);       
		$pdf->setTextShadow(array('enabled'=>false, 'depth_w'=>0.2, 'depth_h'=>0.2, 'color'=>array(196,196,196), 'opacity'=>1, 'blend_mode'=>'Normal'));

        $pdf->writeHTML($html, true, 0, true, true);
        $pdf->lastPage();
        ob_end_clean();
        $pdf->Output($filename,'I');
    }
}

if (!function_exists('genera_pdf_lab_new_g')) {

    function genera_pdf_lab_new_g($html, $filename = '',$title='', $subject='',$obs='', $fuera_rango='', $author='Humancenter Review S.A de C.V.', $tipo_pdf = 'P') 
	//($html, $filename = '',$title='', $subject='', $author='Humancenter Review S.A de C.V.') 
	{
        $CI =& get_instance();
        $CI->load->library('tcpdf/Tcpdf');
		
// Extend the TCPDF class to create custom Header and Footer
class MYPDF extends TCPDF {

	public $laboratorista;
	public $observaciones;
	public $fuera_rango;
	
    //Page header
    public function Header() {
        // Logo
        //$image_file = K_PATH_IMAGES.'hclogo.jpg';
		$image_file = K_PATH_IMAGES.'hclogo_g.jpg';
		// 20, 50, 175, 175,
        $this->Image($image_file, 50, 80, 105, 105, 'JPG', '', 'T', false, 300, '', false, false, 0, false, false, false);
        // Set font
        //$this->SetFont('helvetica', 'B', 10);
        // Title
        //$this->Cell(0, 0, $image_file.'<< TCPDF Example 003 >>', 0, false, 'C', 0, '', 0, false, 'M', 'M');
    }

    // Page footer
    public function Footer() {
        // Position at 15 mm from bottom
         $this->SetFont('helvetica', 'B', 8);
		// $mueve=-55;
		$mueve=-15;
		$this->SetY($mueve);
		/*  $this->Cell(0, 0,"OBSERVACIONES:");
		 $this->SetX(40);
		 
		 
		 $longitud=strlen($this->observaciones);
		 
		 if ( $longitud > 77)
		 {	 
			$parte=77;
			$arr=$this->observaciones;
			
			while ($arr[$parte] !=' ')
			{
				$parte--;
			}
	 
			$arr1 = substr($this->observaciones, 0, $parte );
			$arr2 = substr($this->observaciones, $parte, $longitud );
			 $this->Cell(0, 0,$arr1);
			 $mueve+=1;
			 $mueve+=1;
			 $mueve+=1;
			 $this->SetY($mueve);
			 $this->SetX(39);			 
			 $this->Cell(0, 0,$arr2);			
			 $this->SetY($mueve);
			 $this->SetX(40);			
			
		 }
		 else
		 {			 
			 $this->Cell(0, 0,$this->observaciones);
			 $mueve+=3;
			 $this->SetY($mueve);
			 $this->SetX(40);		 
		 }	  
		 
		 $mueve+=3;
		 $mueve+=3;
		 $this->SetY($mueve);
		 $this->Cell(0, 0,"Lo(s) resultado(s) fuera de rango validado(s).");
		 $this->SetX(75);		 
		 $this->Cell(0, 0,$this->fuera_rango);		 
		 $mueve+=3;
		 $this->SetY($mueve);
		 $this->SetY($mueve);$mueve+=3;		 
		 $this->SetY($mueve);$mueve+=3;
		 $this->SetY($mueve);$mueve+=3;
		 $this->SetY($mueve);$mueve+=3;
		 $this->SetY($mueve);$mueve+=3;
		 //$this->SetY($mueve);$mueve+=3;
		 //$this->SetY($mueve);$mueve+=3;
		 $this->SetFont('helvetica', 'B', 8);
		 $this->Cell(0, 0,$this->laboratorista);
		 $mueve+=2;
		 $this->SetY($mueve); 
		 $this->Cell(0, 0,"Para validar resultados, se tendrá 3 días posteriores a la aplicación de la evaluación.                                                                           ");
		 $mueve+=1;
		 $this->SetY($mueve);
		 //$this->SetFont('helvetica', 'B', 2);
		 

		 $mueve+=1;
		 $this->SetFillColor(75,86,130);
		 $this->Cell(0, 0,"_________________________________________________________________________________________________________________________",  0, false, 'C', 0, '', 0, false, 'T', 'M');		 


		 $mueve+=4;
		 $this->SetFont('helvetica', 'B', 8);
		 $this->SetY($mueve);
		 $this->Cell(0, 0,"Human Center Review S.A. de C.V.",  0, false, 'C', 0, '', 0, false, 'T', 'M');
		 

		 
		 $mueve+=3;
		 $this->SetY($mueve);
		 $this->Cell(0, 0,"San Borja 1365 Col. Vértiz Narvarte Alc. Benito Juárez C.P. 03600 Ciudad de México. Tel. 55-36-40-44-36 ",  0, false, 'C', 0, '', 0, false, 'T', 'M');

		 $this->SetY(-15); */
        // Set font
         $this->SetFont('helvetica', 'I', 8);
        // Page number
         $this->Cell(0, 10, 'Página '.$this->getAliasNumPage().'/'.$this->getAliasNbPages(), 0, false, 'C', 0, '', 0, false, 'T', 'M');
    }
}

	// create new PDF document
	$pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

		$pdf->laboratorista=$subject;
		$pdf->observaciones=$obs;
		
		/*if ($fuera_rango == '')
		{
			$pdf->fuera_rango='Ninguno';
		}	
		else*/
		{
			$pdf->fuera_rango=$fuera_rango;
		}	
	// set document information
	$pdf->SetCreator(PDF_CREATOR);
	$pdf->SetAuthor($author);
	$pdf->SetTitle($title);
	$pdf->SetSubject($subject);
	$pdf->SetKeywords('TCPDF, PDF, RECETAS, HUMANCENTER, PLATAFORMA');

	// set default header data
	$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE, PDF_HEADER_STRING);

	// set header and footer fonts
	$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
	$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

	// set default monospaced font
	$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

	// set margins
	//$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
	//$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
	//$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

	$pdf->SetMargins(5, 5);
	$pdf->SetHeaderMargin(5);
	$pdf->SetFooterMargin(5);

	// set auto page breaks
	$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);


	//$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
	$pdf->setImageScale(1);
	$pdf->setFontSubsetting(true);
	// set font
	$pdf->SetFont('helvetica', '', 9);


	// set some language-dependent strings (optional)
	if (@file_exists(dirname(__FILE__).'/lang/eng.php')) {
		require_once(dirname(__FILE__).'/lang/eng.php');
		$pdf->setLanguageArray($l);
		}

	//$pdf->SetFont('times', 'BI', 12);

	// add a page
	$pdf->AddPage();
	$pdf->writeHTML($html, true, 0, true, true);
	$pdf->lastPage();
// write some JavaScript code
//$js = <<<EOD

//EOD;

// force print dialog
//$js .= 'print(true);';

// set javascript
//$pdf->IncludeJS($js);	

	ob_end_clean();
	//$pdf->Output(UPLOAD_PATH.'example_001.pdf', 'FI'); //PARA SACAR A UN ARCHIVO EL RESULTADO
	//$pdf->Output('example_001.pdf', 'F'); //PARA SACAR A UN ARCHIVO EL RESULTADO
	$pdf->Output($filename,'I');  //modo normal

//$pdf->Output($filename,'D'); 
    }
}


if (!function_exists('genera_pdf_lab_new_xxx')) {

    function genera_pdf_lab_new_xxx($html, $filename = '',$title='', $subject='',$obs='', $fuera_rango='', $author='Humancenter Review S.A de C.V.', $tipo_pdf = 'P') 
	{
        $CI =& get_instance();
        $CI->load->library('tcpdf/Tcpdf');
		
// Extend the TCPDF class to create custom Header and Footer
class MYPDF extends TCPDF {

	public $laboratorista;
	public $observaciones;
	public $fuera_rango;
	
    //Page header
    public function Header() {
        // Logo
        //$image_file = K_PATH_IMAGES.'hclogo.jpg';
		$image_file = K_PATH_IMAGES.'hclogo_g.jpg';
		// 20, 50, 175, 175,
        $this->Image($image_file, 50, 80, 105, 105, 'JPG', '', 'T', false, 300, '', false, false, 0, false, false, false);
        // Set font
        //$this->SetFont('helvetica', 'B', 10);
        // Title
        //$this->Cell(0, 0, $image_file.'<< TCPDF Example 003 >>', 0, false, 'C', 0, '', 0, false, 'M', 'M');
    }

    // Page footer
    public function Footer() {
        // Position at 15 mm from bottom
         $this->SetFont('helvetica', 'B', 8);
		 $mueve=-55;
		 $this->SetY($mueve);
	//	$this->Cell(0, 0,"OBSERVACIONES:");
		 $this->SetX(40);
		 
		 
		/* $longitud=strlen($this->observaciones);
		 
		 if ( $longitud > 77)
		 {	 
			$parte=77;
			$arr=$this->observaciones;
			
			while ($arr[$parte] !=' ')
			{
				$parte--;
			}
	 
			$arr1 = substr($this->observaciones, 0, $parte );
			$arr2 = substr($this->observaciones, $parte, $longitud );
			 $this->Cell(0, 0,$arr1);
			 $mueve+=1;
			 $mueve+=1;
			 $mueve+=1;
			 $this->SetY($mueve);
			 $this->SetX(39);			 
			 $this->Cell(0, 0,$arr2);			
			 $this->SetY($mueve);
			 $this->SetX(40);			
			
		 }
		 else*/
		 {			 
			 //$this->Cell(0, 0,$this->observaciones);
			 $mueve+=3;
			 $this->SetY($mueve);
			 $this->SetX(40);		 
		 }	  
		 
		 $mueve+=3;
		 $mueve+=3;
		 $this->SetY($mueve);
		// $this->Cell(0, 0,"Lo(s) resultado(s) fuera de rango validado(s).");
		 $this->SetX(75);		 
		 $this->Cell(0, 0,$this->fuera_rango);		 
		 $mueve+=3;
		 $this->SetY($mueve);
		 $this->SetY($mueve);$mueve+=3;		 
		 $this->SetY($mueve);$mueve+=3;
		 $this->SetY($mueve);$mueve+=3;
		 $this->SetY($mueve);$mueve+=3;
		 $this->SetY($mueve);$mueve+=3;
		 //$this->SetY($mueve);$mueve+=3;
		 //$this->SetY($mueve);$mueve+=3;
		 $this->SetFont('helvetica', 'B', 8);
		// $this->Cell(0, 0,$this->laboratorista);
		 $mueve+=2;
		 $this->SetY($mueve); 
		 $this->Cell(0, 0,"Para validar resultados, se tendrá 3 días posteriores a la aplicación de la evaluación.                                                                           ");
		 $mueve+=1;
		 $this->SetY($mueve);
		 //$this->SetFont('helvetica', 'B', 2);
		 
		 /* linea*/
		 $mueve+=1;
		 $this->SetFillColor(75,86,130);
		 $this->Cell(0, 0,"_________________________________________________________________________________________________________________________",  0, false, 'C', 0, '', 0, false, 'T', 'M');		 
		 /**/

		 $mueve+=4;
		 $this->SetFont('helvetica', 'B', 8);
		 $this->SetY($mueve);
		 $this->Cell(0, 0,"Human Center Review S.A. de C.V.",  0, false, 'C', 0, '', 0, false, 'T', 'M');
		 

		 
		 $mueve+=3;
		 $this->SetY($mueve);
		 $this->Cell(0, 0,"San Borja 1365 Col. Vértiz Narvarte Alc. Benito Juárez C.P. 03600 Ciudad de México. Tel. 55-36-40-44-36 ",  0, false, 'C', 0, '', 0, false, 'T', 'M');

		 $this->SetY(-15);
        // Set font
         $this->SetFont('helvetica', 'I', 8);
        // Page number
         $this->Cell(0, 10, 'Página '.$this->getAliasNumPage().'/'.$this->getAliasNbPages(), 0, false, 'C', 0, '', 0, false, 'T', 'M');
    }
}

	// create new PDF document
	$pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

		$pdf->laboratorista=$subject;
		$pdf->observaciones=$obs;
		
		/*if ($fuera_rango == '')
		{
			$pdf->fuera_rango='Ninguno';
		}	
		else*/
		{
			$pdf->fuera_rango=$fuera_rango;
		}	
	// set document information
	$pdf->SetCreator(PDF_CREATOR);
	$pdf->SetAuthor($author);
	$pdf->SetTitle($title);
	$pdf->SetSubject($subject);
	$pdf->SetKeywords('TCPDF, PDF, RECETAS, HUMANCENTER, PLATAFORMA');

	// set default header data
	$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE, PDF_HEADER_STRING);

	// set header and footer fonts
	$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
	$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

	// set default monospaced font
	$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

	// set margins
	//$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
	//$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
	//$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

	$pdf->SetMargins(10, 10);
	$pdf->SetHeaderMargin(10);
	$pdf->SetFooterMargin(5);

	// set auto page breaks
	$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);


	//$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
	$pdf->setImageScale(1);
	$pdf->setFontSubsetting(true);
	// set font
	$pdf->SetFont('helvetica', '', 9);


	// set some language-dependent strings (optional)
	if (@file_exists(dirname(__FILE__).'/lang/eng.php')) {
		require_once(dirname(__FILE__).'/lang/eng.php');
		$pdf->setLanguageArray($l);
		}

	//$pdf->SetFont('times', 'BI', 12);

	// add a page
	$pdf->AddPage();
	$pdf->writeHTML($html, true, 0, true, true);
	$pdf->lastPage();
// write some JavaScript code
//$js = <<<EOD

//EOD;

// force print dialog
//$js .= 'print(true);';

// set javascript
//$pdf->IncludeJS($js);	

	ob_end_clean();
	//$pdf->Output(UPLOAD_PATH.'example_001.pdf', 'FI'); //PARA SACAR A UN ARCHIVO EL RESULTADO
	//$pdf->Output('example_001.pdf', 'F'); //PARA SACAR A UN ARCHIVO EL RESULTADO
	$pdf->Output($filename,'I');  //modo normal

//$pdf->Output($filename,'D'); 
    }
}






if (!function_exists('genera_pdf_normalizado')) {

    function genera_pdf_normalizado($html, $filename = '',$title='', $subject='',$obs='', $fuera_rango='', $author='Humancenter Review S.A de C.V.', $tipo_pdf = 'P') 
	{
        $CI =& get_instance();
        $CI->load->library('tcpdf/Tcpdf');
		
// Extend the TCPDF class to create custom Header and Footer
class MYPDF extends TCPDF {

	public $laboratorista;
	public $observaciones;
	public $fuera_rango;
	
    //Page header
    public function Header() {
        // Logo
        $image_file = K_PATH_IMAGES.'hclogo.jpg';
		//$image_file = K_PATH_IMAGES.'hclogo_g.jpg';
		// 20, 50, 175, 175,
        $this->Image($image_file, 50, 80, 105, 105, 'JPG', '', 'T', false, 300, '', false, false, 0, false, false, false);
        // Set font
        $this->SetFont('helvetica', 'B', 10);
        // Title
        //$this->Cell(0, 0, $image_file.'<< TCPDF Example 003 >>', 0, false, 'C', 0, '', 0, false, 'M', 'M');
    }

    // Page footer
    public function Footer() {
        // Position at 15 mm from bottom
         $this->SetFont('helvetica', 'B', 8);
		 $mueve=-55;
		 $this->SetY($mueve);
	//	$this->Cell(0, 0,"OBSERVACIONES:");
		 $this->SetX(40);
		 
		 
		/* $longitud=strlen($this->observaciones);
		 
		 if ( $longitud > 77)
		 {	 
			$parte=77;
			$arr=$this->observaciones;
			
			while ($arr[$parte] !=' ')
			{
				$parte--;
			}
	 
			$arr1 = substr($this->observaciones, 0, $parte );
			$arr2 = substr($this->observaciones, $parte, $longitud );
			 $this->Cell(0, 0,$arr1);
			 $mueve+=1;
			 $mueve+=1;
			 $mueve+=1;
			 $this->SetY($mueve);
			 $this->SetX(39);			 
			 $this->Cell(0, 0,$arr2);			
			 $this->SetY($mueve);
			 $this->SetX(40);			
			
		 }
		 else*/
		 {			 
			 //$this->Cell(0, 0,$this->observaciones);
			 $mueve+=3;
			 $this->SetY($mueve);
			 $this->SetX(40);		 
		 }	  
		 
		 $mueve+=3;
		 $mueve+=3;
		 $this->SetY($mueve);
		// $this->Cell(0, 0,"Lo(s) resultado(s) fuera de rango validado(s).");
		 $this->SetX(75);		 
		 $this->Cell(0, 0,$this->fuera_rango);		 
		 $mueve+=3;
		 $this->SetY($mueve);
		 $this->SetY($mueve);$mueve+=3;		 
		 $this->SetY($mueve);$mueve+=3;
		 $this->SetY($mueve);$mueve+=3;
		 $this->SetY($mueve);$mueve+=3;
		 $this->SetY($mueve);$mueve+=3;
		 //$this->SetY($mueve);$mueve+=3;
		 //$this->SetY($mueve);$mueve+=3;
		 $this->SetFont('helvetica', 'B', 8);
		// $this->Cell(0, 0,$this->laboratorista);
		 $mueve+=2;
		 $this->SetY($mueve); 
		 $this->Cell(0, 0,"");
		 $mueve+=1;
		 $this->SetY($mueve);
		 //$this->SetFont('helvetica', 'B', 2);
		 
		 /* linea*/
		 $mueve+=1;
		 $this->SetFillColor(75,86,130);
		 $this->Cell(0, 0,"_________________________________________________________________________________________________________________________",  0, false, 'C', 0, '', 0, false, 'T', 'M');		 
		 /**/

		 $mueve+=4;
		 $this->SetFont('helvetica', 'B', 8);
		 $this->SetY($mueve);
		 $this->Cell(0, 0,"Human Center Review S.A. de C.V.",  0, false, 'C', 0, '', 0, false, 'T', 'M');
		 

		 
		 $mueve+=3;
		 $this->SetY($mueve);
		 $this->Cell(0, 0,"San Borja 1365 Col. Vértiz Narvarte Alc. Benito Juárez C.P. 03600 Ciudad de México. Tel. 55-36-40-44-36 ",  0, false, 'C', 0, '', 0, false, 'T', 'M');

		 $this->SetY(-15);
        // Set font
         $this->SetFont('helvetica', 'I', 8);
        // Page number
         $this->Cell(0, 10, 'Página '.$this->getAliasNumPage().'/'.$this->getAliasNbPages(), 0, false, 'C', 0, '', 0, false, 'T', 'M');
    }
}

	// create new PDF document
	$pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

		$pdf->laboratorista=$subject;
		$pdf->observaciones=$obs;
		
		/*if ($fuera_rango == '')
		{
			$pdf->fuera_rango='Ninguno';
		}	
		else*/
		{
			$pdf->fuera_rango=$fuera_rango;
		}	
	// set document information
	$pdf->SetCreator(PDF_CREATOR);
	$pdf->SetAuthor($author);
	$pdf->SetTitle($title);
	$pdf->SetSubject($subject);
	$pdf->SetKeywords('TCPDF, PDF, RECETAS, HUMANCENTER, PLATAFORMA');

	// set default header data
	$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE, PDF_HEADER_STRING);

	// set header and footer fonts
	$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
	$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

	// set default monospaced font
	$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

	// set margins
	//$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
	//$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
	//$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

	$pdf->SetMargins(10, 10);
	$pdf->SetHeaderMargin(10);
	$pdf->SetFooterMargin(5);

	// set auto page breaks
	$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);


	//$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
	$pdf->setImageScale(1);
	$pdf->setFontSubsetting(true);
	// set font
	$pdf->SetFont('helvetica', '', 9);


	// set some language-dependent strings (optional)
	if (@file_exists(dirname(__FILE__).'/lang/eng.php')) {
		require_once(dirname(__FILE__).'/lang/eng.php');
		$pdf->setLanguageArray($l);
		}

	//$pdf->SetFont('times', 'BI', 12);

	// add a page
	$pdf->AddPage();
	$pdf->writeHTML($html, true, 0, true, true);
	$pdf->lastPage();
// write some JavaScript code
//$js = <<<EOD

//EOD;

// force print dialog
//$js .= 'print(true);';

// set javascript
//$pdf->IncludeJS($js);	

	ob_end_clean();
	//$pdf->Output(UPLOAD_PATH.'example_001.pdf', 'FI'); //PARA SACAR A UN ARCHIVO EL RESULTADO
	//$pdf->Output('example_001.pdf', 'F'); //PARA SACAR A UN ARCHIVO EL RESULTADO
	$pdf->Output($filename,'I');  //modo normal

//$pdf->Output($filename,'D'); 
    }
}






if (!function_exists('genera_pdf_nom035')) {

    function genera_pdf_nom035($html, $filename = '',$title='', $subject='',$obs='', $fuera_rango='', $author='Humancenter Review S.A de C.V.', $tipo_pdf = 'P') 
	{
        $CI =& get_instance();
        $CI->load->library('tcpdf/Tcpdf');
		
// Extend the TCPDF class to create custom Header and Footer
class MYPDF extends TCPDF {

	public $laboratorista;
	public $observaciones;
	public $fuera_rango;
	
    //Page header
    public function Header() {
        // Logo
        //$image_file = K_PATH_IMAGES.'hclogo.jpg';
		$image_file = K_PATH_IMAGES.'hclogo_g.jpg';
		// 20, 50, 175, 175,
     //   $this->Image($image_file, 50, 80, 105, 105, 'JPG', '', 'T', false, 300, '', false, false, 0, false, false, false);
        // Set font
        //$this->SetFont('helvetica', 'B', 10);
        // Title
        //$this->Cell(0, 0, $image_file.'<< TCPDF Example 003 >>', 0, false, 'C', 0, '', 0, false, 'M', 'M');
    }

    // Page footer
    public function Footer() {
        // Position at 15 mm from bottom
         $this->SetFont('helvetica', 'B', 8);
		 $mueve=-55;
		 $this->SetY($mueve);
	//	$this->Cell(0, 0,"OBSERVACIONES:");
		 $this->SetX(40);
		 
		 
		/* $longitud=strlen($this->observaciones);
		 
		 if ( $longitud > 77)
		 {	 
			$parte=77;
			$arr=$this->observaciones;
			
			while ($arr[$parte] !=' ')
			{
				$parte--;
			}
	 
			$arr1 = substr($this->observaciones, 0, $parte );
			$arr2 = substr($this->observaciones, $parte, $longitud );
			 $this->Cell(0, 0,$arr1);
			 $mueve+=1;
			 $mueve+=1;
			 $mueve+=1;
			 $this->SetY($mueve);
			 $this->SetX(39);			 
			 $this->Cell(0, 0,$arr2);			
			 $this->SetY($mueve);
			 $this->SetX(40);			
			
		 }
		 else*/
		 {			 
			 //$this->Cell(0, 0,$this->observaciones);
			 $mueve+=3;
			 $this->SetY($mueve);
			 $this->SetX(40);		 
		 }	  
		 
		 $mueve+=3;
		 $mueve+=3;
		 $this->SetY($mueve);
		// $this->Cell(0, 0,"Lo(s) resultado(s) fuera de rango validado(s).");
		 $this->SetX(75);		 
		 $this->Cell(0, 0,$this->fuera_rango);		 
		 $mueve+=3;
		 $this->SetY($mueve);
		 $this->SetY($mueve);$mueve+=3;		 
		 $this->SetY($mueve);$mueve+=3;
		 $this->SetY($mueve);$mueve+=3;
		 $this->SetY($mueve);$mueve+=3;
		 $this->SetY($mueve);$mueve+=3;
		 //$this->SetY($mueve);$mueve+=3;
		 //$this->SetY($mueve);$mueve+=3;
		 $this->SetFont('helvetica', 'B', 8);
		// $this->Cell(0, 0,$this->laboratorista);
		 $mueve+=2;
		 $this->SetY($mueve); 
		 $this->Cell(0, 0,"");
		 $mueve+=1;
		 $this->SetY($mueve);
		 //$this->SetFont('helvetica', 'B', 2);
		 
		 /* linea*/
		 $mueve+=1;
		 $this->SetFillColor(75,86,130);
		 $this->Cell(0, 0,"_________________________________________________________________________________________________________________________",  0, false, 'C', 0, '', 0, false, 'T', 'M');		 
		 /**/

		 $mueve+=4;
		 $this->SetFont('helvetica', 'B', 8);
		 $this->SetY($mueve);
		 $this->Cell(0, 0,"Human Center Review S.A. de C.V.",  0, false, 'C', 0, '', 0, false, 'T', 'M');
		 

		 
		 $mueve+=3;
		 $this->SetY($mueve);
		 $this->Cell(0, 0,"San Borja 1365 Col. Vértiz Narvarte Alc. Benito Juárez C.P. 03600 Ciudad de México. Tel. 55-36-40-44-36 ",  0, false, 'C', 0, '', 0, false, 'T', 'M');

		 $this->SetY(-15);
        // Set font
         $this->SetFont('helvetica', 'I', 8);
        // Page number
         $this->Cell(0, 10, 'Página '.$this->getAliasNumPage().'/'.$this->getAliasNbPages(), 0, false, 'C', 0, '', 0, false, 'T', 'M');
    }
}

	// create new PDF document
	$pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

		$pdf->laboratorista=$subject;
		$pdf->observaciones=$obs;
		
		/*if ($fuera_rango == '')
		{
			$pdf->fuera_rango='Ninguno';
		}	
		else*/
		{
			$pdf->fuera_rango=$fuera_rango;
		}	
	// set document information
	$pdf->SetCreator(PDF_CREATOR);
	$pdf->SetAuthor($author);
	$pdf->SetTitle($title);
	$pdf->SetSubject($subject);
	$pdf->SetKeywords('TCPDF, PDF, RECETAS, HUMANCENTER, PLATAFORMA');

	// set default header data
	$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE, PDF_HEADER_STRING);

	// set header and footer fonts
	$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
	$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

	// set default monospaced font
	$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

	// set margins
	//$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
	//$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
	//$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

	$pdf->SetMargins(10, 10);
	$pdf->SetHeaderMargin(10);
	$pdf->SetFooterMargin(5);

	// set auto page breaks
	$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);


	//$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
	$pdf->setImageScale(1);
	$pdf->setFontSubsetting(true);
	// set font
	$pdf->SetFont('helvetica', '', 9);


	// set some language-dependent strings (optional)
	if (@file_exists(dirname(__FILE__).'/lang/eng.php')) {
		require_once(dirname(__FILE__).'/lang/eng.php');
		$pdf->setLanguageArray($l);
		}

	//$pdf->SetFont('times', 'BI', 12);

	// add a page
	$pdf->AddPage();
	$pdf->writeHTML($html, true, 0, true, true);
	$pdf->lastPage();
// write some JavaScript code
//$js = <<<EOD

//EOD;

// force print dialog
//$js .= 'print(true);';

// set javascript
//$pdf->IncludeJS($js);	

	ob_end_clean();
	//$pdf->Output(UPLOAD_PATH.'example_001.pdf', 'FI'); //PARA SACAR A UN ARCHIVO EL RESULTADO
	//$pdf->Output('example_001.pdf', 'F'); //PARA SACAR A UN ARCHIVO EL RESULTADO
	$pdf->Output($filename,'I');  //modo normal

//$pdf->Output($filename,'D'); 
    }
}

if (!function_exists('genera_pdf_lab_new_xg')) {

    function genera_pdf_lab_new_xg($html, $filename = '',$title='', $subject='',$obs='', $fuera_rango='', $author='Humancenter Review S.A de C.V.', $tipo_pdf = 'P') 
	//($html, $filename = '',$title='', $subject='', $author='Humancenter Review S.A de C.V.') 
	{
        $CI =& get_instance();
        $CI->load->library('tcpdf/Tcpdf');
		
// Extend the TCPDF class to create custom Header and Footer
class MYPDF extends TCPDF {

	public $laboratorista;
	public $observaciones;
	public $fuera_rango;
	
    //Page header
    public function Header() {
        // Logo
        //$image_file = K_PATH_IMAGES.'hclogo.jpg';
		$image_file = K_PATH_IMAGES.'hclogo_gg.jpg';
        // 20, 50, 175, 175,
        $this->Image($image_file, 12, 10, 170, 170, 'JPG', '', 'T', false, 300, '', false, false, 0, false, false, false);
        // Set font
        //$this->SetFont('helvetica', 'B', 10);
        // Title
        //$this->Cell(0, 0, $image_file.'<< TCPDF Example 003 >>', 0, false, 'C', 0, '', 0, false, 'M', 'M');
    }

    // Page footer
    public function Footer() {
        // Position at 15 mm from bottom
         $this->SetFont('helvetica', 'B', 8);
		 $mueve=-55;
		 $this->SetY($mueve);
		 $this->Cell(0, 0,"OBSERVACIONES:");
		 $this->SetX(40);
		 
		 
		 $longitud=strlen($this->observaciones);
		 
		 if ( $longitud > 77)
		 {	 
			$parte=77;
			$arr=$this->observaciones;
			
			while ($arr[$parte] !=' ')
			{
				$parte--;
			}
	 
			$arr1 = substr($this->observaciones, 0, $parte );
			$arr2 = substr($this->observaciones, $parte, $longitud );
			 $this->Cell(0, 0,$arr1);
			 $mueve+=1;
			 $mueve+=1;
			 $mueve+=1;
			 $this->SetY($mueve);
			 $this->SetX(39);			 
			 $this->Cell(0, 0,$arr2);			
			 $this->SetY($mueve);
			 $this->SetX(40);			
			
		 }
		 else
		 {			 
			 $this->Cell(0, 0,$this->observaciones);
			 $mueve+=3;
			 $this->SetY($mueve);
			 $this->SetX(40);		 
		 }	  
		 
		 $mueve+=3;
		 $mueve+=3;
		 $this->SetY($mueve);
		 $this->Cell(0, 0,"Lo(s) resultado(s) fuera de rango validado(s).");
		 $this->SetX(75);		 
		 $this->Cell(0, 0,$this->fuera_rango);		 
		 $mueve+=3;
		 $this->SetY($mueve);
		 $this->SetY($mueve);$mueve+=3;		 
		 $this->SetY($mueve);$mueve+=3;
		 $this->SetY($mueve);$mueve+=3;
		 $this->SetY($mueve);$mueve+=3;
		 $this->SetY($mueve);$mueve+=3;
		 //$this->SetY($mueve);$mueve+=3;
		 //$this->SetY($mueve);$mueve+=3;
		 $this->SetFont('helvetica', 'B', 8);
		 $this->Cell(0, 0,$this->laboratorista);
		 $mueve+=2;
		 $this->SetY($mueve); 
		 $this->Cell(0, 0,"Para validar resultados, se tendrá 3 días posteriores a la aplicación de la evaluación.                                                                           ");
		 $mueve+=1;
		 $this->SetY($mueve);
		 //$this->SetFont('helvetica', 'B', 2);
		 
		 /* linea*/
		 $mueve+=1;
		 $this->SetFillColor(75,86,130);
		 $this->Cell(0, 0,"_________________________________________________________________________________________________________________________",  0, false, 'C', 0, '', 0, false, 'T', 'M');		 
		 /**/

		 $mueve+=4;
		 $this->SetFont('helvetica', 'B', 8);
		 $this->SetY($mueve);
		 $this->Cell(0, 0,"Human Center Review S.A. de C.V.",  0, false, 'C', 0, '', 0, false, 'T', 'M');
		 

		 
		 $mueve+=3;
		 $this->SetY($mueve);
		 $this->Cell(0, 0,"San Borja 1365 Col. Vértiz Narvarte Alc. Benito Juárez C.P. 03600 Ciudad de México. Tel. 55-36-40-44-36 ",  0, false, 'C', 0, '', 0, false, 'T', 'M');

		 $this->SetY(-15);
        // Set font
         $this->SetFont('helvetica', 'I', 8);
        // Page number
         $this->Cell(0, 10, 'Página '.$this->getAliasNumPage().'/'.$this->getAliasNbPages(), 0, false, 'C', 0, '', 0, false, 'T', 'M');
    }
}

	// create new PDF document
	$pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

		$pdf->laboratorista=$subject;
		$pdf->observaciones=$obs;
		
		/*if ($fuera_rango == '')
		{
			$pdf->fuera_rango='Ninguno';
		}	
		else*/
		{
			$pdf->fuera_rango=$fuera_rango;
		}	
	// set document information
	$pdf->SetCreator(PDF_CREATOR);
	$pdf->SetAuthor($author);
	$pdf->SetTitle($title);
	$pdf->SetSubject($subject);
	$pdf->SetKeywords('TCPDF, PDF, RECETAS, HUMANCENTER, PLATAFORMA');

	// set default header data
	$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE, PDF_HEADER_STRING);

	// set header and footer fonts
	$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
	$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

	// set default monospaced font
	$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

	// set margins
	//$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
	//$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
	//$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

	$pdf->SetMargins(10, 10);
	$pdf->SetHeaderMargin(10);
	$pdf->SetFooterMargin(5);

	// set auto page breaks
	$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);


	//$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
	$pdf->setImageScale(1);
	$pdf->setFontSubsetting(true);
	// set font
	$pdf->SetFont('helvetica', '', 9);


	// set some language-dependent strings (optional)
	if (@file_exists(dirname(__FILE__).'/lang/eng.php')) {
		require_once(dirname(__FILE__).'/lang/eng.php');
		$pdf->setLanguageArray($l);
		}

	//$pdf->SetFont('times', 'BI', 12);

	// add a page
	$pdf->AddPage();
	$pdf->writeHTML($html, true, 0, true, true);
	$pdf->lastPage();
// write some JavaScript code
//$js = <<<EOD

//EOD;

// force print dialog
//$js .= 'print(true);';

// set javascript
//$pdf->IncludeJS($js);	

	ob_end_clean();
	//$pdf->Output(UPLOAD_PATH.'example_001.pdf', 'FI'); //PARA SACAR A UN ARCHIVO EL RESULTADO
	//$pdf->Output('example_001.pdf', 'F'); //PARA SACAR A UN ARCHIVO EL RESULTADO
	$pdf->Output($filename,'I');  //modo normal

//$pdf->Output($filename,'D'); 
    }
}



if (!function_exists('genera_pdf_lab_new_x')) {

    function genera_pdf_lab_new_x($html, $filename = '',$title='', $subject='',$obs='', $fuera_rango='', $author='Humancenter Review S.A de C.V.', $tipo_pdf = 'P') 
	//($html, $filename = '',$title='', $subject='', $author='Humancenter Review S.A de C.V.') 
	{
        $CI =& get_instance();
        $CI->load->library('tcpdf/Tcpdf');
		
// Extend the TCPDF class to create custom Header and Footer
class MYPDF extends TCPDF {

	public $laboratorista;
	public $observaciones;
	public $fuera_rango;
	
    //Page header
    public function Header() {
        // Logo
        //$image_file = K_PATH_IMAGES.'hclogo.jpg';
		$image_file = K_PATH_IMAGES.'hclogo_g.jpg';
		// 20, 50, 175, 175,
        $this->Image($image_file, 50, 80, 105, 105, 'JPG', '', 'T', false, 300, '', false, false, 0, false, false, false);
        // Set font
        //$this->SetFont('helvetica', 'B', 10);
        // Title
        //$this->Cell(0, 0, $image_file.'<< TCPDF Example 003 >>', 0, false, 'C', 0, '', 0, false, 'M', 'M');
    }

    // Page footer
    public function Footer() {
        // Position at 15 mm from bottom
         $this->SetFont('helvetica', 'B', 8);
		 $mueve=-55;
		 $this->SetY($mueve);
		 $this->Cell(0, 0,"OBSERVACIONES:");
		 $this->SetX(40);
		 
		 
		 $longitud=strlen($this->observaciones);
		 
		 if ( $longitud > 77)
		 {	 
			$parte=77;
			$arr=$this->observaciones;
			
			while ($arr[$parte] !=' ')
			{
				$parte--;
			}
	 
			$arr1 = substr($this->observaciones, 0, $parte );
			$arr2 = substr($this->observaciones, $parte, $longitud );
			 $this->Cell(0, 0,$arr1);
			 $mueve+=1;
			 $mueve+=1;
			 $mueve+=1;
			 $this->SetY($mueve);
			 $this->SetX(39);			 
			 $this->Cell(0, 0,$arr2);			
			 $this->SetY($mueve);
			 $this->SetX(40);			
			
		 }
		 else
		 {			 
			 $this->Cell(0, 0,$this->observaciones);
			 $mueve+=3;
			 $this->SetY($mueve);
			 $this->SetX(40);		 
		 }	  
		 
		 $mueve+=3;
		 $mueve+=3;
		 $this->SetY($mueve);
		 $this->Cell(0, 0,"Lo(s) resultado(s) fuera de rango validado(s).");
		 $this->SetX(75);		 
		 $this->Cell(0, 0,$this->fuera_rango);		 
		 $mueve+=3;
		 $this->SetY($mueve);
		 $this->SetY($mueve);$mueve+=3;		 
		 $this->SetY($mueve);$mueve+=3;
		 $this->SetY($mueve);$mueve+=3;
		 $this->SetY($mueve);$mueve+=3;
		 $this->SetY($mueve);$mueve+=3;
		 //$this->SetY($mueve);$mueve+=3;
		 //$this->SetY($mueve);$mueve+=3;
		 $this->SetFont('helvetica', 'B', 8);
		 $this->Cell(0, 0,$this->laboratorista);
		 $mueve+=2;
		 $this->SetY($mueve); 
		 $this->Cell(0, 0,"Para validar resultados, se tendrá 3 días posteriores a la aplicación de la evaluación.                                                                           ");
		 $mueve+=1;
		 $this->SetY($mueve);
		 //$this->SetFont('helvetica', 'B', 2);
		 
		 /* linea*/
		 $mueve+=1;
		 $this->SetFillColor(75,86,130);
		 $this->Cell(0, 0,"_________________________________________________________________________________________________________________________",  0, false, 'C', 0, '', 0, false, 'T', 'M');		 
		 /**/

		 $mueve+=4;
		 $this->SetFont('helvetica', 'B', 8);
		 $this->SetY($mueve);
		 $this->Cell(0, 0,"Human Center Review S.A. de C.V.",  0, false, 'C', 0, '', 0, false, 'T', 'M');
		 

		 
		 $mueve+=3;
		 $this->SetY($mueve);
		 $this->Cell(0, 0,"San Borja 1365 Col. Vértiz Narvarte Alc. Benito Juárez C.P. 03600 Ciudad de México. Tel. 55-36-40-44-36 ",  0, false, 'C', 0, '', 0, false, 'T', 'M');

		 $this->SetY(-15);
        // Set font
         $this->SetFont('helvetica', 'I', 8);
        // Page number
         $this->Cell(0, 10, 'Página '.$this->getAliasNumPage().'/'.$this->getAliasNbPages(), 0, false, 'C', 0, '', 0, false, 'T', 'M');
    }
}

	// create new PDF document
	$pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

		$pdf->laboratorista=$subject;
		$pdf->observaciones=$obs;
		
		/*if ($fuera_rango == '')
		{
			$pdf->fuera_rango='Ninguno';
		}	
		else*/
		{
			$pdf->fuera_rango=$fuera_rango;
		}	
	// set document information
	$pdf->SetCreator(PDF_CREATOR);
	$pdf->SetAuthor($author);
	$pdf->SetTitle($title);
	$pdf->SetSubject($subject);
	$pdf->SetKeywords('TCPDF, PDF, RECETAS, HUMANCENTER, PLATAFORMA');

	// set default header data
	$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE, PDF_HEADER_STRING);

	// set header and footer fonts
	$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
	$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

	// set default monospaced font
	$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

	// set margins
	//$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
	//$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
	//$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

	$pdf->SetMargins(10, 10);
	$pdf->SetHeaderMargin(10);
	$pdf->SetFooterMargin(5);

	// set auto page breaks
	$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);


	//$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
	$pdf->setImageScale(1);
	$pdf->setFontSubsetting(true);
	// set font
	$pdf->SetFont('helvetica', '', 9);


	// set some language-dependent strings (optional)
	if (@file_exists(dirname(__FILE__).'/lang/eng.php')) {
		require_once(dirname(__FILE__).'/lang/eng.php');
		$pdf->setLanguageArray($l);
		}

	//$pdf->SetFont('times', 'BI', 12);

	// add a page
	$pdf->AddPage();
	$pdf->writeHTML($html, true, 0, true, true);
	$pdf->lastPage();
// write some JavaScript code
//$js = <<<EOD

//EOD;

// force print dialog
//$js .= 'print(true);';

// set javascript
//$pdf->IncludeJS($js);	

	ob_end_clean();
	//$pdf->Output(UPLOAD_PATH.'example_001.pdf', 'FI'); //PARA SACAR A UN ARCHIVO EL RESULTADO
	//$pdf->Output('example_001.pdf', 'F'); //PARA SACAR A UN ARCHIVO EL RESULTADO
	$pdf->Output($filename,'I');  //modo normal

//$pdf->Output($filename,'D'); 
    }
}


if (!function_exists('genera_pdf_lab_new_u')) {

    function genera_pdf_lab_new_u($html, $filename = '',$title='',$evaluado, $author='Humancenter Review S.A de C.V.', $tipo_pdf = 'P') 
	//($html, $filename = '',$title='', $subject='', $author='Humancenter Review S.A de C.V.') 
	{
        $CI =& get_instance();
        $CI->load->library('tcpdf/Tcpdf');
		
// Extend the TCPDF class to create custom Header and Footer
class MYPDF extends TCPDF {

	public $evaluado;
	public $laboratorista;
	public $observaciones;
	public $fuera_rango;
	
    //Page header
    public function Header() {
        // Logo
        //$image_file = K_PATH_IMAGES.'hclogo.jpg';
		$image_file = K_PATH_IMAGES.'hclogo_g.jpg';
        // 20, 50, 175, 175,
        $this->Image($image_file, 50, 80, 105, 105, 'JPG', '', 'T', false, 300, '', false, false, 0, false, false, false);
        // Set font
        //$this->SetFont('helvetica', 'B', 10);
        // Title
        //$this->Cell(0, 0, $image_file.'<< TCPDF Example 003 >>', 0, false, 'C', 0, '', 0, false, 'M', 'M');
    }

    // Page footer
    public function Footer() {
        // Position at 15 mm from bottom
         $this->SetFont('helvetica', 'B', 8);
		 $mueve=-55;
		 $this->SetY($mueve);
		 //$this->Cell(0, 0,"OBSERVACIONES:");
		 $this->SetX(40);
		 $this->Cell(0, 0,$this->observaciones);
		 $mueve+=3;
		 $this->SetY($mueve);
		 $this->SetX(40);
		 $mueve+=3;
		 $mueve+=3;
		 $this->SetY($mueve);
		 //$this->Cell(0, 0,"Lo(s) resultado(s) fuera de rango validado(s).");
		 $this->SetX(75);		 
		 $this->Cell(0, 0,$this->fuera_rango);		 
		 $mueve+=3;
		 $this->SetY($mueve);
		 $this->SetY($mueve);$mueve+=3;		 
		 $this->SetY($mueve);$mueve+=3;
		 $this->SetY($mueve);$mueve+=3;
		 $this->SetY($mueve);$mueve+=3;
		 $this->SetY($mueve);$mueve+=3;
		 $this->SetY($mueve);$mueve+=3;
		 $this->SetY($mueve);$mueve+=3;
		  $this->SetY($mueve);$mueve+=1;
		 $this->SetFont('helvetica', 'B', 7);
		 $this->Cell(0, 0,$this->evaluado);
		 $mueve+=1;
		 $this->SetY($mueve); 
		 //$this->Cell(0, 0,"Para validar resultados, se tendrá 3 días posteriores a la aplicación de la evaluación.                                                                           ");
		 $mueve+=1;
		 $this->SetY($mueve);
		 $this->SetFont('helvetica', 'B', 2);


		 $mueve+=1;
		 $this->SetFont('helvetica', 'B', 8);
		 $this->SetY($mueve);
		 $this->Cell(0, 0,"Human Center Review S.A. de C.V.",  0, false, 'C', 0, '', 0, false, 'T', 'M');
		 
		 /* linea
		 $mueve+=1;
		 $this->SetFillColor(75,86,130);
		 $this->Cell(0, 0,"___________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________",  0, false, 'C', 0, '', 0, false, 'T', 'M');		 
		 */
		 
		 $mueve+=3;
		 $this->SetY($mueve);
		 $this->Cell(0, 0,"San Borja 1365 Col. Vértiz Narvarte Alc. Benito Juárez C.P. 03600 Ciudad de México. Tel. 55-36-40-44-36 ",  0, false, 'C', 0, '', 0, false, 'T', 'M');

		 $this->SetY(-15);
        // Set font
         $this->SetFont('helvetica', 'I', 8);
        // Page number
         $this->Cell(0, 10, '                    Página '.$this->getAliasNumPage().'/'.$this->getAliasNbPages(), 0, false, 'C', 0, '', 0, false, 'T', 'M');
    }
}

	// create new PDF document
	$pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

		$pdf->laboratorista=$subject;
		$pdf->observaciones=$obs;
		$pdf->evaluado=$evaluado;
		/*if ($fuera_rango == '')
		{
			$pdf->fuera_rango='Ninguno';
		}	
		else*/
		{
			$pdf->fuera_rango=$fuera_rango;
		}	
	// set document information
	$pdf->SetCreator(PDF_CREATOR);
	$pdf->SetAuthor($author);
	$pdf->SetTitle($title);
	$pdf->SetSubject($subject);
	$pdf->SetKeywords('TCPDF, PDF, RECETAS, HUMANCENTER, PLATAFORMA');

	// set default header data
	$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE, PDF_HEADER_STRING);

	// set header and footer fonts
	$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
	$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

	// set default monospaced font
	$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

	// set margins
	//$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
	//$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
	//$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

	$pdf->SetMargins(10, 10);
	$pdf->SetHeaderMargin(10);
	$pdf->SetFooterMargin(5);

	// set auto page breaks
	$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);


	//$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
	$pdf->setImageScale(1);
	$pdf->setFontSubsetting(true);
	// set font
	$pdf->SetFont('helvetica', '', 9);


	// set some language-dependent strings (optional)
	if (@file_exists(dirname(__FILE__).'/lang/eng.php')) {
		require_once(dirname(__FILE__).'/lang/eng.php');
		$pdf->setLanguageArray($l);
		}

	//$pdf->SetFont('times', 'BI', 12);

	// add a page
	$pdf->AddPage();
	$pdf->writeHTML($html, true, 0, true, true);
	$pdf->lastPage();
	ob_end_clean();
//	$pdf->Output(UPLOAD_PATH.'example_001.pdf', 'FI'); PARA SACAR A UN ARCHIVO EL RESULTADO
	$pdf->Output($filename,'I'); 
    }
}

if (!function_exists('genera_pdf_jr')) {

    function genera_pdf_jr($html, $filename = '',$title='', $subject='',$obs='', $fuera_rango='', $author='Humancenter Review S.A de C.V.', $tipo_pdf = 'P') 
	//($html, $filename = '',$title='', $subject='', $author='Humancenter Review S.A de C.V.') 
	{
        $CI =& get_instance();
        $CI->load->library('tcpdf/Tcpdf');
		
// Extend the TCPDF class to create custom Header and Footer
class MYPDF extends TCPDF {

	public $laboratorista;
	public $observaciones;
	public $fuera_rango;
	
    //Page header
    public function Header() {
        // Logo
        //$image_file = K_PATH_IMAGES.'hclogo.jpg';
		$image_file = K_PATH_IMAGES.'jrlogo.jpg';
        // 20, 50, 175, 175,
        $this->Image($image_file, 55, 80, 100, 100, 'JPG', '', 'T', false, 300, '', false, false, 0, false, false, false);
        // Set font
        //$this->SetFont('helvetica', 'B', 10);
        // Title
        //$this->Cell(0, 0, $image_file.'<< TCPDF Example 003 >>', 0, false, 'C', 0, '', 0, false, 'M', 'M');
    }

    // Page footer
    public function Footer() {
        // Position at 15 mm from bottom
         $this->SetFont('helvetica', 'B', 8);
		 $mueve=-55;
		 $this->SetY($mueve);
		 //$this->Cell(0, 0,"OBSERVACIONES:");
		 $this->SetX(40);
		 $this->Cell(0, 0,$this->observaciones);
		 $mueve+=3;
		 $this->SetY($mueve);
		 $this->SetX(40);
		 $mueve+=3;
		 $mueve+=3;
		 $this->SetY($mueve);
		 //$this->Cell(0, 0,"Lo(s) resultado(s) fuera de rango validado(s).");
		 $this->SetX(75);		 
		 $this->Cell(0, 0,$this->fuera_rango);		 
		 $mueve+=3;
		 $this->SetY($mueve);
		 $this->SetY($mueve);$mueve+=3;		 
		 $this->SetY($mueve);$mueve+=3;
		 $this->SetY($mueve);$mueve+=3;
		 $this->SetY($mueve);$mueve+=3;
		 $this->SetY($mueve);$mueve+=3;
		 //$this->SetY($mueve);$mueve+=3;
		 //$this->SetY($mueve);$mueve+=3;
		 $this->SetFont('helvetica', 'B', 8);
		 $this->Cell(0, 0,$this->laboratorista);
		 $mueve+=2;
		 $this->SetY($mueve); 
		 //$this->Cell(0, 0,"Para validar resultados, se tendrá 3 días posteriores a la aplicación de la evaluación.                                                                           ");
		 $mueve+=4;
		 $this->SetY($mueve);
		 $this->SetFont('helvetica', 'B', 2);


		 $mueve+=1;
		 $this->SetFont('helvetica', 'B', 8);
		 $this->SetY($mueve);
		 $this->Cell(0, 0,"Juventud Real",  0, false, 'C', 0, '', 0, false, 'T', 'M');
		 
		 /* linea
		 $mueve+=1;
		 $this->SetFillColor(75,86,130);
		 $this->Cell(0, 0,"___________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________",  0, false, 'C', 0, '', 0, false, 'T', 'M');		 
		 */
		 
		 $mueve+=3;
		 $this->SetY($mueve);
		 $this->Cell(0, 0,"C. Yácatas 510, Narvarte Poniente, Alcaldía Benito Juárez, 03020, CDMX",  0, false, 'C', 0, '', 0, false, 'T', 'M');

		 $this->SetY(-15);
        // Set font
         $this->SetFont('helvetica', 'I', 8);
        // Page number
         $this->Cell(0, 10, '                    Página '.$this->getAliasNumPage().'/'.$this->getAliasNbPages(), 0, false, 'C', 0, '', 0, false, 'T', 'M');
    }
}

	// create new PDF document
	$pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

		$pdf->laboratorista=$subject;
		$pdf->observaciones=$obs;
		
		/*if ($fuera_rango == '')
		{
			$pdf->fuera_rango='Ninguno';
		}	
		else*/
		{
			$pdf->fuera_rango=$fuera_rango;
		}	
	// set document information
	$pdf->SetCreator(PDF_CREATOR);
	$pdf->SetAuthor($author);
	$pdf->SetTitle($title);
	$pdf->SetSubject($subject);
	$pdf->SetKeywords('TCPDF, PDF, RECETAS, HUMANCENTER, PLATAFORMA');

	// set default header data
	$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE, PDF_HEADER_STRING);

	// set header and footer fonts
	$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
	$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

	// set default monospaced font
	$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

	// set margins
	//$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
	//$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
	//$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

	$pdf->SetMargins(10, 10);
	$pdf->SetHeaderMargin(10);
	$pdf->SetFooterMargin(5);

	// set auto page breaks
	$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);


	//$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
	$pdf->setImageScale(1);
	$pdf->setFontSubsetting(true);
	// set font
	$pdf->SetFont('helvetica', '', 9);


	// set some language-dependent strings (optional)
	if (@file_exists(dirname(__FILE__).'/lang/eng.php')) {
		require_once(dirname(__FILE__).'/lang/eng.php');
		$pdf->setLanguageArray($l);
		}

	//$pdf->SetFont('times', 'BI', 12);

	// add a page
	$pdf->AddPage();
	$pdf->writeHTML($html, true, 0, true, true);
	$pdf->lastPage();
	ob_end_clean();
//	$pdf->Output(UPLOAD_PATH.'example_001.pdf', 'FI'); PARA SACAR A UN ARCHIVO EL RESULTADO
	$pdf->Output($filename,'I'); 
    }
}




if (!function_exists('genera_pdf_lab_new_yg')) {

    function genera_pdf_lab_new_yg($html, $filename = '',$title='', $subject='',$obs='', $fuera_rango='', $author='Humancenter Review S.A de C.V.', $tipo_pdf = 'P') 
	//($html, $filename = '',$title='', $subject='', $author='Humancenter Review S.A de C.V.') 
	{
        $CI =& get_instance();
        $CI->load->library('tcpdf/Tcpdf');
		
// Extend the TCPDF class to create custom Header and Footer
class MYPDF extends TCPDF {

	public $laboratorista;
	public $observaciones;
	public $fuera_rango;
	
    //Page header
    public function Header() {
        // Logo
        //$image_file = K_PATH_IMAGES.'hclogo.jpg';
		$image_file = K_PATH_IMAGES.'hclogo_gg.jpg';
        // 20, 50, 175, 175,
        $this->Image($image_file, 12, 10, 170, 170, 'JPG', '', 'T', false, 300, '', false, false, 0, false, false, false);
        // Set font
        //$this->SetFont('helvetica', 'B', 10);
        // Title
        //$this->Cell(0, 0, $image_file.'<< TCPDF Example 003 >>', 0, false, 'C', 0, '', 0, false, 'M', 'M');
    }

    // Page footer
    public function Footer() {
        // Position at 15 mm from bottom
         $this->SetFont('helvetica', 'B', 8);
		 $mueve=-55;
		 $this->SetY($mueve);
		 //$this->Cell(0, 0,"OBSERVACIONES:");
		 $this->SetX(40);
		 $this->Cell(0, 0,$this->observaciones);
		 $mueve+=3;
		 $this->SetY($mueve);
		 $this->SetX(40);
		 $mueve+=3;
		 $mueve+=3;
		 $this->SetY($mueve);
		 //$this->Cell(0, 0,"Lo(s) resultado(s) fuera de rango validado(s).");
		 $this->SetX(75);		 
		 $this->Cell(0, 0,$this->fuera_rango);		 
		 $mueve+=3;
		 $this->SetY($mueve);
		 $this->SetY($mueve);$mueve+=3;		 
		 $this->SetY($mueve);$mueve+=3;
		 $this->SetY($mueve);$mueve+=3;
		 $this->SetY($mueve);$mueve+=3;
		 $this->SetY($mueve);$mueve+=3;
		 //$this->SetY($mueve);$mueve+=3;
		 //$this->SetY($mueve);$mueve+=3;
		 $this->SetFont('helvetica', 'B', 8);
		 $this->Cell(0, 0,$this->laboratorista);
		 $mueve+=2;
		 $this->SetY($mueve); 
		 //$this->Cell(0, 0,"Para validar resultados, se tendrá 3 días posteriores a la aplicación de la evaluación.                                                                           ");
		 $mueve+=4;
		 $this->SetY($mueve);
		 $this->SetFont('helvetica', 'B', 2);


		 $mueve+=1;
		 $this->SetFont('helvetica', 'B', 8);
		 $this->SetY($mueve);
		 $this->Cell(0, 0,"Human Center Review S.A. de C.V.",  0, false, 'C', 0, '', 0, false, 'T', 'M');
		 
		 /* linea
		 $mueve+=1;
		 $this->SetFillColor(75,86,130);
		 $this->Cell(0, 0,"___________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________",  0, false, 'C', 0, '', 0, false, 'T', 'M');		 
		 */
		 
		 $mueve+=3;
		 $this->SetY($mueve);
		 $this->Cell(0, 0,"San Borja 1365 Col. Vértiz Narvarte Alc. Benito Juárez C.P. 03600 Ciudad de México. Tel. 55-36-40-44-36 ",  0, false, 'C', 0, '', 0, false, 'T', 'M');

		 $this->SetY(-15);
        // Set font
         $this->SetFont('helvetica', 'I', 8);
        // Page number
         $this->Cell(0, 10, '                    Página '.$this->getAliasNumPage().'/'.$this->getAliasNbPages(), 0, false, 'C', 0, '', 0, false, 'T', 'M');
    }
}

	// create new PDF document
	$pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

		$pdf->laboratorista=$subject;
		$pdf->observaciones=$obs;
		
		/*if ($fuera_rango == '')
		{
			$pdf->fuera_rango='Ninguno';
		}	
		else*/
		{
			$pdf->fuera_rango=$fuera_rango;
		}	
	// set document information
	$pdf->SetCreator(PDF_CREATOR);
	$pdf->SetAuthor($author);
	$pdf->SetTitle($title);
	$pdf->SetSubject($subject);
	$pdf->SetKeywords('TCPDF, PDF, RECETAS, HUMANCENTER, PLATAFORMA');

	// set default header data
	$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE, PDF_HEADER_STRING);

	// set header and footer fonts
	$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
	$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

	// set default monospaced font
	$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

	// set margins
	//$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
	//$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
	//$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

	$pdf->SetMargins(10, 10);
	$pdf->SetHeaderMargin(10);
	$pdf->SetFooterMargin(5);

	// set auto page breaks
	$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);


	//$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
	$pdf->setImageScale(1);
	$pdf->setFontSubsetting(true);
	// set font
	$pdf->SetFont('helvetica', '', 9);


	// set some language-dependent strings (optional)
	if (@file_exists(dirname(__FILE__).'/lang/eng.php')) {
		require_once(dirname(__FILE__).'/lang/eng.php');
		$pdf->setLanguageArray($l);
		}

	//$pdf->SetFont('times', 'BI', 12);

	// add a page
	$pdf->AddPage();
	$pdf->writeHTML($html, true, 0, true, true);
	$pdf->lastPage();
	ob_end_clean();
//	$pdf->Output(UPLOAD_PATH.'example_001.pdf', 'FI'); PARA SACAR A UN ARCHIVO EL RESULTADO
	$pdf->Output($filename,'I'); 
    }
}

/***************************************************************************************************************************************/
if (!function_exists('genera_pdf_credencial')) {

    function genera_pdf_credencial($html, $filename = '', $title = '', $subject = '', $obs = '', $fuera_rango = '', $author = 'Humancenter Review S.A de C.V.', $tipo_pdf = 'P', $html_pagina2 = '') 
    {
        $CI =& get_instance();
        $CI->load->library('tcpdf/Tcpdf');
        class MYPDF extends TCPDF {
            public function Header() {
                $page = $this->getPage();
                if ($page == 1) {
                    $image_file = ('https://online.humancenter.com.mx/hc/index.php/../dist/images/'.'creden_a.png');
                } else {
                    $image_file = ('https://online.humancenter.com.mx/hc/index.php/../dist/images/'.'creden_b.png');
                }
                $this->Image($image_file, 0, 0, $this->getPageWidth(), $this->getPageHeight(), 'PNG', '', '', false, 300, '', false, false, 0, false, false, true);
            }
            public function Footer() {}
        }
        $pageWidth = 404.81;
        $pageHeight = 612.18;
        $pdf = new MYPDF('P', 'mm', array($pageWidth, $pageHeight), true, 'UTF-8', false);
        $pdf->SetCreator(PDF_CREATOR);
        $pdf->SetAuthor($author);
        $pdf->SetTitle($title);
        $pdf->SetSubject($subject);
        $pdf->SetKeywords('TCPDF, PDF, RECETAS, HUMANCENTER, PLATAFORMA');
        $pdf->SetMargins(0, 0, 0);
        $pdf->SetHeaderMargin(0);
        $pdf->SetFooterMargin(0);
        $pdf->SetAutoPageBreak(false, 0);
        $pdf->SetFont('helvetica', '', 9);

        // Pgina 1
        $pdf->AddPage();
        $pdf->writeHTML($html, true, 0, true, true);

        // Pgina 2 (si hay contenido)
        if ($html_pagina2 != '') {
            $pdf->AddPage();
            $pdf->writeHTML($html_pagina2, true, 0, true, true);
        }

        ob_end_clean();
        $pdf->Output($filename, 'I'); 
    }
}
/***************************************************************************************************************************************/


if (!function_exists('genera_pdf_lab_new_y')) {

    function genera_pdf_lab_new_y($html, $filename = '',$title='', $subject='',$obs='', $fuera_rango='', $author='Humancenter Review S.A de C.V.', $tipo_pdf = 'P') 
	//($html, $filename = '',$title='', $subject='', $author='Humancenter Review S.A de C.V.') 
	{
        $CI =& get_instance();
        $CI->load->library('tcpdf/Tcpdf');
		
// Extend the TCPDF class to create custom Header and Footer
class MYPDF extends TCPDF {

	public $laboratorista;
	public $observaciones;
	public $fuera_rango;
	
    //Page header
    public function Header() {
        // Logo
        //$image_file = K_PATH_IMAGES.'hclogo.jpg';
		$image_file = K_PATH_IMAGES.'hclogo_g.jpg';
        // 20, 50, 175, 175,
        $this->Image($image_file, 50, 80, 105, 105, 'JPG', '', 'T', false, 300, '', false, false, 0, false, false, false);
        // Set font
        //$this->SetFont('helvetica', 'B', 10);
        // Title
        //$this->Cell(0, 0, $image_file.'<< TCPDF Example 003 >>', 0, false, 'C', 0, '', 0, false, 'M', 'M');
    }

    // Page footer
    public function Footer() {
        // Position at 15 mm from bottom
         $this->SetFont('helvetica', 'B', 8);
		 $mueve=-55;
		 $this->SetY($mueve);
		 //$this->Cell(0, 0,"OBSERVACIONES:");
		 $this->SetX(40);
		 $this->Cell(0, 0,$this->observaciones);
		 $mueve+=3;
		 $this->SetY($mueve);
		 $this->SetX(40);
		 $mueve+=3;
		 $mueve+=3;
		 $this->SetY($mueve);
		 //$this->Cell(0, 0,"Lo(s) resultado(s) fuera de rango validado(s).");
		 $this->SetX(75);		 
		 $this->Cell(0, 0,$this->fuera_rango);		 
		 $mueve+=3;
		 $this->SetY($mueve);
		 $this->SetY($mueve);$mueve+=3;		 
		 $this->SetY($mueve);$mueve+=3;
		 $this->SetY($mueve);$mueve+=3;
		 $this->SetY($mueve);$mueve+=3;
		 $this->SetY($mueve);$mueve+=3;
		 //$this->SetY($mueve);$mueve+=3;
		 //$this->SetY($mueve);$mueve+=3;
		 $this->SetFont('helvetica', 'B', 8);
		 $this->Cell(0, 0,$this->laboratorista);
		 $mueve+=2;
		 $this->SetY($mueve); 
		 //$this->Cell(0, 0,"Para validar resultados, se tendrá 3 días posteriores a la aplicación de la evaluación.                                                                           ");
		 $mueve+=4;
		 $this->SetY($mueve);
		 $this->SetFont('helvetica', 'B', 2);


		 $mueve+=1;
		 $this->SetFont('helvetica', 'B', 8);
		 $this->SetY($mueve);
		 $this->Cell(0, 0,"Human Center Review S.A. de C.V.",  0, false, 'C', 0, '', 0, false, 'T', 'M');
		 
		 /* linea
		 $mueve+=1;
		 $this->SetFillColor(75,86,130);
		 $this->Cell(0, 0,"___________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________",  0, false, 'C', 0, '', 0, false, 'T', 'M');		 
		 */
		 
		 $mueve+=3;
		 $this->SetY($mueve);
		 $this->Cell(0, 0,"San Borja 1365 Col. Vértiz Narvarte Alc. Benito Juárez C.P. 03600 Ciudad de México. Tel. 55-36-40-44-36 ",  0, false, 'C', 0, '', 0, false, 'T', 'M');

		 $this->SetY(-15);
        // Set font
         $this->SetFont('helvetica', 'I', 8);
        // Page number
         $this->Cell(0, 10, '                    Página '.$this->getAliasNumPage().'/'.$this->getAliasNbPages(), 0, false, 'C', 0, '', 0, false, 'T', 'M');
    }
}

	// create new PDF document
	$pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

		$pdf->laboratorista=$subject;
		$pdf->observaciones=$obs;
		
		/*if ($fuera_rango == '')
		{
			$pdf->fuera_rango='Ninguno';
		}	
		else*/
		{
			$pdf->fuera_rango=$fuera_rango;
		}	
	// set document information
	$pdf->SetCreator(PDF_CREATOR);
	$pdf->SetAuthor($author);
	$pdf->SetTitle($title);
	$pdf->SetSubject($subject);
	$pdf->SetKeywords('TCPDF, PDF, RECETAS, HUMANCENTER, PLATAFORMA');

	// set default header data
	$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE, PDF_HEADER_STRING);

	// set header and footer fonts
	$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
	$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

	// set default monospaced font
	$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

	// set margins
	//$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
	//$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
	//$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

	$pdf->SetMargins(10, 10);
	$pdf->SetHeaderMargin(10);
	$pdf->SetFooterMargin(5);

	// set auto page breaks
	$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);


	//$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
	$pdf->setImageScale(1);
	$pdf->setFontSubsetting(true);
	// set font
	$pdf->SetFont('helvetica', '', 9);


	// set some language-dependent strings (optional)
	if (@file_exists(dirname(__FILE__).'/lang/eng.php')) {
		require_once(dirname(__FILE__).'/lang/eng.php');
		$pdf->setLanguageArray($l);
		}

	//$pdf->SetFont('times', 'BI', 12);

	// add a page
	$pdf->AddPage();
	$pdf->writeHTML($html, true, 0, true, true);
	$pdf->lastPage();
	ob_end_clean();
//	$pdf->Output(UPLOAD_PATH.'example_001.pdf', 'FI'); PARA SACAR A UN ARCHIVO EL RESULTADO
	$pdf->Output($filename,'I'); 
    }
}


if (!function_exists('genera_pdf_lab_new_zg')) {

    function genera_pdf_lab_new_zg($html, $filename = '',$title='', $subject='',$obs='', $fuera_rango='', $author='Humancenter Review S.A de C.V.', $tipo_pdf = 'P') 
	//($html, $filename = '',$title='', $subject='', $author='Humancenter Review S.A de C.V.') 
	{
        $CI =& get_instance();
        $CI->load->library('tcpdf/Tcpdf');
		
// Extend the TCPDF class to create custom Header and Footer
class MYPDF extends TCPDF {

	public $laboratorista;
	public $observaciones;
	public $fuera_rango;
	
    //Page header
    public function Header() {
        // Logo
        //$image_file = K_PATH_IMAGES.'hclogo.jpg';
		$image_file = K_PATH_IMAGES.'hclogo_gg.jpg';
        // 20, 50, 175, 175,
        $this->Image($image_file, 12, 10, 170, 170, 'JPG', '', 'T', false, 300, '', false, false, 0, false, false, false);
        // Set font
        //$this->SetFont('helvetica', 'B', 10);
        // Title
        //$this->Cell(0, 0, $image_file.'<< TCPDF Example 003 >>', 0, false, 'C', 0, '', 0, false, 'M', 'M');
    }

    // Page footer
    public function Footer() {
        // Position at 15 mm from bottom
         $this->SetFont('helvetica', 'B', 8);
		 $mueve=-55;
		 $this->SetY($mueve);
		 //$this->Cell(0, 0,"OBSERVACIONES:");
		 $this->SetX(40);
		 //$this->Cell(0, 0,$this->observaciones);
		 $mueve+=3;
		 $this->SetY($mueve);
		 $this->SetX(40);
		 $mueve+=3;
		 $mueve+=3;
		 $this->SetY($mueve);
		 //$this->Cell(0, 0,"Lo(s) resultado(s) fuera de rango validado(s).");
		 $this->SetX(75);		 
		 //$this->Cell(0, 0,$this->fuera_rango);		 
		 $mueve+=3;
		 $this->SetY($mueve);
		 $this->SetY($mueve);$mueve+=3;		 
		 $this->SetY($mueve);$mueve+=3;
		 $this->SetY($mueve);$mueve+=3;
		 $this->SetY($mueve);$mueve+=3;
		 $this->SetY($mueve);$mueve+=3;
		 //$this->SetY($mueve);$mueve+=3;
		 //$this->SetY($mueve);$mueve+=3;
		 $this->SetFont('helvetica', 'B', 6);
		 $this->Cell(0, 0,$this->observaciones,  0, false, 'C', 0, '', 0, false, 'T', 'M');
		 $mueve+=2;
		 $this->SetY($mueve); 
		 //$this->Cell(0, 0,"Para validar resultados, se tendrá 3 días posteriores a la aplicación de la evaluación.                                                                           ");
		 $mueve+=4;
		 $this->SetY($mueve);
		 $this->SetFont('helvetica', 'B', 2);


		 $mueve+=1;
		 $this->SetFont('helvetica', 'B', 8);
		 $this->SetY($mueve);
		 $this->Cell(0, 0,"Human Center Review S.A. de C.V.",  0, false, 'C', 0, '', 0, false, 'T', 'M');
		 
		 /* linea
		 $mueve+=1;
		 $this->SetFillColor(75,86,130);
		 $this->Cell(0, 0,"___________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________",  0, false, 'C', 0, '', 0, false, 'T', 'M');		 
		 */
		 
		 $mueve+=3;
		 $this->SetY($mueve);
		 $this->Cell(0, 0,"San Borja 1365 Col. Vértiz Narvarte Alc. Benito Juárez C.P. 03600 Ciudad de México. Tel. 55-36-40-44-36 ",  0, false, 'C', 0, '', 0, false, 'T', 'M');

		 $this->SetY(-15);
        // Set font
         $this->SetFont('helvetica', 'I', 8);
        // Page number
         $this->Cell(0, 10, '                    Página '.$this->getAliasNumPage().'/'.$this->getAliasNbPages(), 0, false, 'C', 0, '', 0, false, 'T', 'M');
    }
}

	// create new PDF document
	$pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

		$pdf->laboratorista=$subject;
		$pdf->observaciones=$obs;
		
		/*if ($fuera_rango == '')
		{
			$pdf->fuera_rango='Ninguno';
		}	
		else*/
		{
			$pdf->fuera_rango=$fuera_rango;
		}	
	// set document information
	$pdf->SetCreator(PDF_CREATOR);
	$pdf->SetAuthor($author);
	$pdf->SetTitle($title);
	$pdf->SetSubject($subject);
	$pdf->SetKeywords('TCPDF, PDF, RECETAS, HUMANCENTER, PLATAFORMA');

	// set default header data
	$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE, PDF_HEADER_STRING);

	// set header and footer fonts
	$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
	$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

	// set default monospaced font
	$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

	// set margins
	//$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
	//$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
	//$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

	$pdf->SetMargins(10, 10);
	$pdf->SetHeaderMargin(10);
	$pdf->SetFooterMargin(5);

	// set auto page breaks
	$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);


	//$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
	$pdf->setImageScale(1);
	$pdf->setFontSubsetting(true);
	// set font
	$pdf->SetFont('helvetica', '', 9);


	// set some language-dependent strings (optional)
	if (@file_exists(dirname(__FILE__).'/lang/eng.php')) {
		require_once(dirname(__FILE__).'/lang/eng.php');
		$pdf->setLanguageArray($l);
		}

	//$pdf->SetFont('times', 'BI', 12);

	// add a page
	$pdf->AddPage();
	$pdf->writeHTML($html, true, 0, true, true);
	$pdf->lastPage();
	ob_end_clean();
//	$pdf->Output(UPLOAD_PATH.'example_001.pdf', 'FI'); PARA SACAR A UN ARCHIVO EL RESULTADO
	$pdf->Output($filename,'I'); 
    }
}


if (!function_exists('genera_pdf_lab_new_z')) {

    function genera_pdf_lab_new_z($html, $filename = '',$title='', $subject='',$obs='', $fuera_rango='', $author='Humancenter Review S.A de C.V.', $tipo_pdf = 'P') 
	//($html, $filename = '',$title='', $subject='', $author='Humancenter Review S.A de C.V.') 
	{
        $CI =& get_instance();
        $CI->load->library('tcpdf/Tcpdf');
		
// Extend the TCPDF class to create custom Header and Footer
class MYPDF extends TCPDF {

	public $laboratorista;
	public $observaciones;
	public $fuera_rango;
	
    //Page header
    public function Header() {
        // Logo
        //$image_file = K_PATH_IMAGES.'hclogo.jpg';
		$image_file = K_PATH_IMAGES.'hclogo_g.jpg';
       // $this->Image($image_file, 20, 50, 175, 175, 'JPG', '', 'T', false, 300, '', false, false, 0, false, false, false);
        // Set font
        //$this->SetFont('helvetica', 'B', 10);
        // Title
        //$this->Cell(0, 0, $image_file.'<< TCPDF Example 003 >>', 0, false, 'C', 0, '', 0, false, 'M', 'M');
    }

    // Page footer
    public function Footer() {
        // Position at 15 mm from bottom
         $this->SetFont('helvetica', 'B', 8);
		 $mueve=-55;
		 $this->SetY($mueve);
		 //$this->Cell(0, 0,"OBSERVACIONES:");
		 $this->SetX(40);
		 //$this->Cell(0, 0,$this->observaciones);
		 $mueve+=3;
		 $this->SetY($mueve);
		 $this->SetX(40);
		 $mueve+=3;
		 $mueve+=3;
		 $this->SetY($mueve);
		 //$this->Cell(0, 0,"Lo(s) resultado(s) fuera de rango validado(s).");
		 $this->SetX(75);		 
		 //$this->Cell(0, 0,$this->fuera_rango);		 
		 $mueve+=3;
		 $this->SetY($mueve);
		 $this->SetY($mueve);$mueve+=3;		 
		 $this->SetY($mueve);$mueve+=3;
		 $this->SetY($mueve);$mueve+=3;
		 $this->SetY($mueve);$mueve+=3;
		 $this->SetY($mueve);$mueve+=3;
		 //$this->SetY($mueve);$mueve+=3;
		 //$this->SetY($mueve);$mueve+=3;
		 $this->SetFont('helvetica', 'B', 6);
		 $this->Cell(0, 0,$this->observaciones,  0, false, 'C', 0, '', 0, false, 'T', 'M');
		 $mueve+=2;
		 $this->SetY($mueve); 
		 //$this->Cell(0, 0,"Para validar resultados, se tendrá 3 días posteriores a la aplicación de la evaluación.                                                                           ");
		 $mueve+=4;
		 $this->SetY($mueve);
		 $this->SetFont('helvetica', 'B', 2);


		 $mueve+=1;
		 $this->SetFont('helvetica', 'B', 8);
		 $this->SetY($mueve);
		 $this->Cell(0, 0,"Human Center Review S.A. de C.V.",  0, false, 'C', 0, '', 0, false, 'T', 'M');
		 
		 /* linea
		 $mueve+=1;
		 $this->SetFillColor(75,86,130);
		 $this->Cell(0, 0,"___________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________",  0, false, 'C', 0, '', 0, false, 'T', 'M');		 
		 */
		 
		 $mueve+=3;
		 $this->SetY($mueve);
		 $this->Cell(0, 0,"San Borja 1365 Col. Vértiz Narvarte Alc. Benito Juárez C.P. 03600 Ciudad de México. Tel. 55-36-40-44-36 ",  0, false, 'C', 0, '', 0, false, 'T', 'M');

		 $this->SetY(-15);
        // Set font
         $this->SetFont('helvetica', 'I', 8);
        // Page number
         $this->Cell(0, 10, '                    Página '.$this->getAliasNumPage().'/'.$this->getAliasNbPages(), 0, false, 'C', 0, '', 0, false, 'T', 'M');
    }
}

	// create new PDF document
	$pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

		$pdf->laboratorista=$subject;
		$pdf->observaciones=$obs;
		
		/*if ($fuera_rango == '')
		{
			$pdf->fuera_rango='Ninguno';
		}	
		else*/
		{
			$pdf->fuera_rango=$fuera_rango;
		}	
	// set document information
	$pdf->SetCreator(PDF_CREATOR);
	$pdf->SetAuthor($author);
	$pdf->SetTitle($title);
	$pdf->SetSubject($subject);
	$pdf->SetKeywords('TCPDF, PDF, RECETAS, HUMANCENTER, PLATAFORMA');

	// set default header data
	$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE, PDF_HEADER_STRING);

	// set header and footer fonts
	$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
	$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

	// set default monospaced font
	$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

	// set margins
	//$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
	//$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
	//$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

	$pdf->SetMargins(10, 10);
	$pdf->SetHeaderMargin(10);
	$pdf->SetFooterMargin(5);

	// set auto page breaks
	$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);


	//$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
	$pdf->setImageScale(1);
	$pdf->setFontSubsetting(true);
	// set font
	$pdf->SetFont('helvetica', '', 9);


	// set some language-dependent strings (optional)
	if (@file_exists(dirname(__FILE__).'/lang/eng.php')) {
		require_once(dirname(__FILE__).'/lang/eng.php');
		$pdf->setLanguageArray($l);
		}

	//$pdf->SetFont('times', 'BI', 12);

	// add a page
	$pdf->AddPage();
	$pdf->writeHTML($html, true, 0, true, true);
	$pdf->lastPage();
	ob_end_clean();
//	$pdf->Output(UPLOAD_PATH.'example_001.pdf', 'FI'); PARA SACAR A UN ARCHIVO EL RESULTADO
	$pdf->Output($filename,'I'); 
    }
}

if (!function_exists('xamplete_b')) {

    function xamplete_b($html, $title='', $subject='', $author='Humancenter Review S.A de C.V.') {
        $CI =& get_instance();
        $CI->load->library('tcpdf/Tcpdf');
		
// Extend the TCPDF class to create custom Header and Footer
class MYPDF extends TCPDF {

    //Page header
    public function Header() {
        // Logo
        //$image_file = K_PATH_IMAGES.'hclogo.jpg';
        $this->Image($image_file, 20, 50, 175, 175, 'JPG', '', 'T', false, 300, '', false, false, 0, false, false, false);
    }

    // Page footer
    public function Footer() {
        // Position at 15 mm from bottom
		 $this->SetY(-19);	
		 $this->SetFont('helvetica', 'B', 7);		 	 
		 $this->Cell(0, 0,"San Borja 1365 Col. Vértiz Narvarte, Alcadía Benito Juárez, C.P. 03600, Ciudad de México",  0, false, 'C', 0, '', 0, false, 'T', 'M');
		 $this->SetY(-16);	
		 $this->Cell(0, 0,"_______________________________________________________________________________________________________________________________________________",  0, false, 'C', 0, '', 0, false, 'T', 'M');
		 $this->SetY(-15);
        // Set font
         $this->SetFont('helvetica', 'I', 8);
        // Page number
         $this->Cell(0, 10, 'Página '.$this->getAliasNumPage().'/'.$this->getAliasNbPages(), 0, false, 'C', 0, '', 0, false, 'T', 'M');
    }
}

	// create new PDF document
	$pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

	// set document information
	$pdf->SetCreator(PDF_CREATOR);
	$pdf->SetAuthor($author);
	$pdf->SetTitle($title);
	$pdf->SetSubject($subject);
	$pdf->SetKeywords('TCPDF, PDF, RECETAS, HUMANCENTER, PLATAFORMA');

	// set default header data
	$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE, PDF_HEADER_STRING);

	// set header and footer fonts
	$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
	$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

	// set default monospaced font
	$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

	// set margins
	//$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
	//$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
	//$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

	$pdf->SetMargins(10, 10);
	$pdf->SetHeaderMargin(10);
	$pdf->SetFooterMargin(5);

	// set auto page breaks
	$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);


	//$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
	$pdf->setImageScale(1);
	$pdf->setFontSubsetting(true);
	// set font
	$pdf->SetFont('helvetica', '', 9);


	// set some language-dependent strings (optional)
	if (@file_exists(dirname(__FILE__).'/lang/eng.php')) {
		require_once(dirname(__FILE__).'/lang/eng.php');
		$pdf->setLanguageArray($l);
		}

	//$pdf->SetFont('times', 'BI', 12);

	// add a page
	$pdf->AddPage();
	$pdf->writeHTML($html, true, 0, true, true);
	$pdf->lastPage();
	ob_end_clean();
	$pdf->Output($filename,'I');
    }
}




if (!function_exists('xamplete_certificado')) {

    function xamplete_certificado($html, $title='', $subject='', $author='Humancenter Review S.A de C.V.') {
        $CI =& get_instance();
        $CI->load->library('tcpdf/Tcpdf');
		
// Extend the TCPDF class to create custom Header and Footer
class MYPDF extends TCPDF {

    //Page header
    public function Header() {
        // Logo
        $image_file = K_PATH_IMAGES.'hclogocert.jpg';
        $this->Image($image_file, 2, 35, 220, 270, 'JPG', '', 'T', false, 300, '', false, false, 0, false, false, false);
        // Set font
        //$this->SetFont('helvetica', 'B', 10);
        // Title
        //$this->Cell(0, 0, '<< TCPDF Example 003 >>', 0, false, 'C', 0, '', 0, false, 'M', 'M');
    }

    // Page footer
    public function Footer() {
        // Position at 15 mm from bottom
		 $this->SetY(-19);	
		 $this->SetFont('helvetica', 'B', 7);		 	 
		// $this->Cell(0, 0,"San Borja 1365 Col. Vértiz Narvarte, Alcadía Benito Juárez, C.P. 03600, Ciudad de México",  0, false, 'C', 0, '', 0, false, 'T', 'M');
		 $this->Cell(0, 0,"",  0, false, 'C', 0, '', 0, false, 'T', 'M');
		 $this->SetY(-16);	
		 $this->Cell(0, 0,"_______________________________________________________________________________________________________________________________________________",  0, false, 'C', 0, '', 0, false, 'T', 'M');
		 $this->SetY(-15);
        // Set font
         $this->SetFont('helvetica', 'I', 8);
        // Page number
         $this->Cell(0, 10, 'Página '.$this->getAliasNumPage().'/'.$this->getAliasNbPages(), 0, false, 'C', 0, '', 0, false, 'T', 'M');
    }
}

	// create new PDF document
	$pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

	// set document information
	$pdf->SetCreator(PDF_CREATOR);
	$pdf->SetAuthor($author);
	$pdf->SetTitle($title);
	$pdf->SetSubject($subject);
	$pdf->SetKeywords('TCPDF, PDF, RECETAS, HUMANCENTER, PLATAFORMA');

	// set default header data
	$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE, PDF_HEADER_STRING);

	// set header and footer fonts
	$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
	$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

	// set default monospaced font
	$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

	// set margins
	//$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
	//$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
	//$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

	$pdf->SetMargins(10, 10);
	$pdf->SetHeaderMargin(10);
	$pdf->SetFooterMargin(5);

	// set auto page breaks
	$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);


	//$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
	$pdf->setImageScale(1);
	$pdf->setFontSubsetting(true);
	// set font
	$pdf->SetFont('helvetica', '', 9);


	// set some language-dependent strings (optional)
	if (@file_exists(dirname(__FILE__).'/lang/eng.php')) {
		require_once(dirname(__FILE__).'/lang/eng.php');
		$pdf->setLanguageArray($l);
		}

	//$pdf->SetFont('times', 'BI', 12);

	// add a page
	$pdf->AddPage();
	$pdf->writeHTML($html, true, 0, true, true);
	$pdf->lastPage();
	ob_end_clean();
	$pdf->Output($filename,'I');
    }
}

if (!function_exists('xamplete_exmepre')) {

    function xamplete_exmepre($html, $title='', $subject='', $author='Humancenter Review S.A de C.V.') {
        $CI =& get_instance();
        $CI->load->library('tcpdf/Tcpdf');
		
// Extend the TCPDF class to create custom Header and Footer
class MYPDF extends TCPDF {

    //Page header
    public function Header() {
        // Logo
        //$image_file = K_PATH_IMAGES.'hclogocons.jpg';
        //$this->Image($image_file, 2, 35, 220, 270, 'JPG', '', 'T', false, 300, '', false, false, 0, false, false, false);
        // Set font
        //$this->SetFont('helvetica', 'B', 10);
        // Title
        //$this->Cell(0, 0, '<< TCPDF Example 003 >>', 0, false, 'C', 0, '', 0, false, 'M', 'M');
    }

    // Page footer
    public function Footer() {
        // Position at 15 mm from bottom
		 $this->SetY(-19);	
		 $this->SetFont('helvetica', 'B', 7);		 	 
		// $this->Cell(0, 0,"San Borja 1365 Col. Vértiz Narvarte, Alcadía Benito Juárez, C.P. 03600, Ciudad de México",  0, false, 'C', 0, '', 0, false, 'T', 'M');
		 $this->Cell(0, 0,"",  0, false, 'C', 0, '', 0, false, 'T', 'M');
		 $this->SetY(-16);	
		 $this->Cell(0, 0,"_______________________________________________________________________________________________________________________________________________",  0, false, 'C', 0, '', 0, false, 'T', 'M');
		 $this->SetY(-15);
        // Set font
         $this->SetFont('helvetica', 'I', 8);
        // Page number
         $this->Cell(0, 10, 'Página '.$this->getAliasNumPage().'/'.$this->getAliasNbPages(), 0, false, 'C', 0, '', 0, false, 'T', 'M');
    }
}

	// create new PDF document
	$pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

	// set document information
	$pdf->SetCreator(PDF_CREATOR);
	$pdf->SetAuthor($author);
	$pdf->SetTitle($title);
	$pdf->SetSubject($subject);
	$pdf->SetKeywords('TCPDF, PDF, RECETAS, HUMANCENTER, PLATAFORMA');

	// set default header data
	$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE, PDF_HEADER_STRING);

	// set header and footer fonts
	$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
	$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

	// set default monospaced font
	$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

	// set margins
	//$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
	//$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
	//$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

	$pdf->SetMargins(10, 10);
	$pdf->SetHeaderMargin(10);
	$pdf->SetFooterMargin(5);

	// set auto page breaks
	$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);


	//$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
	$pdf->setImageScale(1);
	$pdf->setFontSubsetting(true);
	// set font
	$pdf->SetFont('helvetica', '', 9);


	// set some language-dependent strings (optional)
	if (@file_exists(dirname(__FILE__).'/lang/eng.php')) {
		require_once(dirname(__FILE__).'/lang/eng.php');
		$pdf->setLanguageArray($l);
		}

	//$pdf->SetFont('times', 'BI', 12);

	// add a page
	$pdf->AddPage();
	$pdf->writeHTML($html, true, 0, true, true);
	$pdf->lastPage();
	ob_end_clean();
	$pdf->Output($filename,'I');
    }
}


if (!function_exists('xamplete_constancia')) {

    function xamplete_constancia($html, $title='', $subject='', $author='Humancenter Review S.A de C.V.') {
        $CI =& get_instance();
        $CI->load->library('tcpdf/Tcpdf');
		
// Extend the TCPDF class to create custom Header and Footer
class MYPDF extends TCPDF {

    //Page header
    public function Header() {
        // Logo
        $image_file = K_PATH_IMAGES.'hclogocons.jpg';
        $this->Image($image_file, 2, 35, 220, 270, 'JPG', '', 'T', false, 300, '', false, false, 0, false, false, false);
        // Set font
        //$this->SetFont('helvetica', 'B', 10);
        // Title
        //$this->Cell(0, 0, '<< TCPDF Example 003 >>', 0, false, 'C', 0, '', 0, false, 'M', 'M');
    }

    // Page footer
    public function Footer() {
        // Position at 15 mm from bottom
		 $this->SetY(-19);	
		 $this->SetFont('helvetica', 'B', 7);		 	 
		// $this->Cell(0, 0,"San Borja 1365 Col. Vértiz Narvarte, Alcadía Benito Juárez, C.P. 03600, Ciudad de México",  0, false, 'C', 0, '', 0, false, 'T', 'M');
		 $this->Cell(0, 0,"",  0, false, 'C', 0, '', 0, false, 'T', 'M');
		 $this->SetY(-16);	
		 $this->Cell(0, 0,"_______________________________________________________________________________________________________________________________________________",  0, false, 'C', 0, '', 0, false, 'T', 'M');
		 $this->SetY(-15);
        // Set font
         $this->SetFont('helvetica', 'I', 8);
        // Page number
         $this->Cell(0, 10, 'Página '.$this->getAliasNumPage().'/'.$this->getAliasNbPages(), 0, false, 'C', 0, '', 0, false, 'T', 'M');
    }
}

	// create new PDF document
	$pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

	// set document information
	$pdf->SetCreator(PDF_CREATOR);
	$pdf->SetAuthor($author);
	$pdf->SetTitle($title);
	$pdf->SetSubject($subject);
	$pdf->SetKeywords('TCPDF, PDF, RECETAS, HUMANCENTER, PLATAFORMA');

	// set default header data
	$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE, PDF_HEADER_STRING);

	// set header and footer fonts
	$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
	$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

	// set default monospaced font
	$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

	// set margins
	//$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
	//$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
	//$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

	$pdf->SetMargins(10, 10);
	$pdf->SetHeaderMargin(10);
	$pdf->SetFooterMargin(5);

	// set auto page breaks
	$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);


	//$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
	$pdf->setImageScale(1);
	$pdf->setFontSubsetting(true);
	// set font
	$pdf->SetFont('helvetica', '', 9);


	// set some language-dependent strings (optional)
	if (@file_exists(dirname(__FILE__).'/lang/eng.php')) {
		require_once(dirname(__FILE__).'/lang/eng.php');
		$pdf->setLanguageArray($l);
		}

	//$pdf->SetFont('times', 'BI', 12);

	// add a page
	$pdf->AddPage();
	$pdf->writeHTML($html, true, 0, true, true);
	$pdf->lastPage();
	ob_end_clean();
	$pdf->Output($filename,'I');
    }
}



if (!function_exists('xamplete_nom')) {

    function xamplete_nom($html, $title='', $subject='', $author='Humancenter Review S.A de C.V.') {
        $CI =& get_instance();
        $CI->load->library('tcpdf/Tcpdf');
		
// Extend the TCPDF class to create custom Header and Footer
class MYPDF extends TCPDF {

    //Page header
    public function Header() {
        // Logo
        $image_file = K_PATH_IMAGES.'hclogo.jpg';
        $this->Image($image_file, 20, 50, 175, 175, 'JPG', '', 'T', false, 300, '', false, false, 0, false, false, false);
        // Set font
        //$this->SetFont('helvetica', 'B', 10);
        // Title
        //$this->Cell(0, 0, '<< TCPDF Example 003 >>', 0, false, 'C', 0, '', 0, false, 'M', 'M');
    }

    // Page footer
    public function Footer() {
        // Position at 15 mm from bottom
		 $this->SetY(-19);	
		 $this->SetFont('helvetica', 'B', 7);		 	 
		 $this->Cell(0, 0,"San Borja 1365 Col. Vértiz Narvarte, Alcadía Benito Juárez, C.P. 03600, Ciudad de México",  0, false, 'C', 0, '', 0, false, 'T', 'M');
		 $this->SetY(-16);	
		 $this->Cell(0, 0,"_______________________________________________________________________________________________________________________________________________",  0, false, 'C', 0, '', 0, false, 'T', 'M');
		 $this->SetY(-15);
        // Set font
         $this->SetFont('helvetica', 'I', 8);
        // Page number
         $this->Cell(0, 10, 'Página '.$this->getAliasNumPage().'/'.$this->getAliasNbPages(), 0, false, 'C', 0, '', 0, false, 'T', 'M');
    }
}

	// create new PDF document
	$pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

	// set document information
	$pdf->SetCreator(PDF_CREATOR);
	$pdf->SetAuthor($author);
	$pdf->SetTitle($title);
	$pdf->SetSubject($subject);
	$pdf->SetKeywords('TCPDF, PDF, RECETAS, HUMANCENTER, PLATAFORMA');

	// set default header data
	$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE, PDF_HEADER_STRING);

	// set header and footer fonts
	$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
	$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

	// set default monospaced font
	$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

	// set margins
	//$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
	//$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
	//$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

	$pdf->SetMargins(10, 10);
	$pdf->SetHeaderMargin(10);
	$pdf->SetFooterMargin(5);

	// set auto page breaks
	$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);


	//$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
	$pdf->setImageScale(1);
	$pdf->setFontSubsetting(true);
	// set font
	$pdf->SetFont('helvetica', '', 9);


	// set some language-dependent strings (optional)
	if (@file_exists(dirname(__FILE__).'/lang/eng.php')) {
		require_once(dirname(__FILE__).'/lang/eng.php');
		$pdf->setLanguageArray($l);
		}

	//$pdf->SetFont('times', 'BI', 12);

	// add a page
	//$pdf->AddPage();
	$pdf->AddPage('L', 'A4');
	$pdf->writeHTML($html, true, 0, true, true);
	$pdf->lastPage();
	ob_end_clean();
	$pdf->Output($filename,'I');
    }
}



if (!function_exists('xamplete')) {

    function xamplete($html, $title='', $subject='', $author='Humancenter Review S.A de C.V.') {
        $CI =& get_instance();
        $CI->load->library('tcpdf/Tcpdf');
		
// Extend the TCPDF class to create custom Header and Footer
class MYPDF extends TCPDF {

    //Page header
    public function Header() {
        // Logo
        $image_file = K_PATH_IMAGES.'hclogo.jpg';
        $this->Image($image_file, 20, 50, 175, 175, 'JPG', '', 'T', false, 300, '', false, false, 0, false, false, false);
        // Set font
        //$this->SetFont('helvetica', 'B', 10);
        // Title
        //$this->Cell(0, 0, '<< TCPDF Example 003 >>', 0, false, 'C', 0, '', 0, false, 'M', 'M');
    }

    // Page footer
    public function Footer() {
        // Position at 15 mm from bottom
		 $this->SetY(-19);	
		 $this->SetFont('helvetica', 'B', 7);		 	 
		 $this->Cell(0, 0,"San Borja 1365 Col. Vértiz Narvarte, Alcadía Benito Juárez, C.P. 03600, Ciudad de México",  0, false, 'C', 0, '', 0, false, 'T', 'M');
		 $this->SetY(-16);	
		 $this->Cell(0, 0,"_______________________________________________________________________________________________________________________________________________",  0, false, 'C', 0, '', 0, false, 'T', 'M');
		 $this->SetY(-15);
        // Set font
         $this->SetFont('helvetica', 'I', 8);
        // Page number
         $this->Cell(0, 10, 'Página '.$this->getAliasNumPage().'/'.$this->getAliasNbPages(), 0, false, 'C', 0, '', 0, false, 'T', 'M');
    }
}

	// create new PDF document
	$pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

	// set document information
	$pdf->SetCreator(PDF_CREATOR);
	$pdf->SetAuthor($author);
	$pdf->SetTitle($title);
	$pdf->SetSubject($subject);
	$pdf->SetKeywords('TCPDF, PDF, RECETAS, HUMANCENTER, PLATAFORMA');

	// set default header data
	$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE, PDF_HEADER_STRING);

	// set header and footer fonts
	$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
	$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

	// set default monospaced font
	$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

	// set margins
	//$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
	//$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
	//$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

	$pdf->SetMargins(10, 10);
	$pdf->SetHeaderMargin(10);
	$pdf->SetFooterMargin(5);

	// set auto page breaks
	$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);


	//$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
	$pdf->setImageScale(1);
	$pdf->setFontSubsetting(true);
	// set font
	$pdf->SetFont('helvetica', '', 9);


	// set some language-dependent strings (optional)
	if (@file_exists(dirname(__FILE__).'/lang/eng.php')) {
		require_once(dirname(__FILE__).'/lang/eng.php');
		$pdf->setLanguageArray($l);
		}

	//$pdf->SetFont('times', 'BI', 12);

	// add a page
	$pdf->AddPage();
	$pdf->writeHTML($html, true, 0, true, true);
	$pdf->lastPage();
	ob_end_clean();
	$pdf->Output($filename,'I');
    }
}


if (!function_exists('tamplete')) {

    function tamplete($html, $title='', $subject='', $author='Humancenter Review S.A de C.V.') {
        $CI =& get_instance();
        $CI->load->library('tcpdf/Tcpdf');
		
// Extend the TCPDF class to create custom Header and Footer
class MYPDF extends TCPDF {

    //Page header
    public function Header() {
        // Logo
        $image_file = K_PATH_IMAGES.'hclogotkt.jpg';
        $this->Image($image_file, 16, 15, 250, 250, 'JPG', '', 'T', false, 300, '', false, false, 0, false, false, false);
        // Set font
        //$this->SetFont('helvetica', 'B', 10);
        // Title
        //$this->Cell(0, 0, '<< TCPDF Example 003 >>', 0, false, 'C', 0, '', 0, false, 'M', 'M');
    }

    // Page footer
    public function Footer() {
        // Position at 15 mm from bottom
		
	/*	 $this->SetY(-25);	
		 $this->SetFont('helvetica', 'I', 8);
		 $this->Cell(0, 10, '    '.$this->getAliasNumPage().'/'.$this->getAliasNbPages(), 0, false, 'C', 0, '', 0, false, 'T', 'M');
		 $this->SetY(-22);	
		 $this->SetTextColor(84,141,212);
		 $this->SetFont('Times', 'B', 12);
		 $this->Cell(0, 0,"________________________________________________________________",  0, false, 'C', 0, '', 0, false, 'T', 'M');
		 $this->SetY(-16);
		 $this->Cell(0, 0,"EL VALOR DE LA CONFIANZA",  0, false, 'C', 0, '', 0, false, 'T', 'M');
	*/		
		//  $this->SetY(-15);
        }
}

	// create new PDF document
	$pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

	// set document information
	$pdf->SetCreator(PDF_CREATOR);
	$pdf->SetAuthor($author);
	$pdf->SetTitle($title);
	$pdf->SetSubject($subject);
	$pdf->SetKeywords('TCPDF, PDF, RECETAS, HUMANCENTER, PLATAFORMA');

	// set default header data
	$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE, PDF_HEADER_STRING);

	// set header and footer fonts
	$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
	$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

	// set default monospaced font
	$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

	// set margins
	//$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
	//$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
	//$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

	$pdf->SetMargins(10, 10);
	$pdf->SetHeaderMargin(10);
	$pdf->SetFooterMargin(5);

	// set auto page breaks
	//$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
	$pdf->SetAutoPageBreak(TRUE, 4);

	//$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
	$pdf->setImageScale(1);
	$pdf->setFontSubsetting(true);
	// set font
	$pdf->SetFont('helvetica', '', 9);


	// set some language-dependent strings (optional)
	if (@file_exists(dirname(__FILE__).'/lang/eng.php')) {
		require_once(dirname(__FILE__).'/lang/eng.php');
		$pdf->setLanguageArray($l);
		}

	//$pdf->SetFont('times', 'BI', 12);

	// add a page
	$pdf->AddPage();
	$pdf->writeHTML($html, true, 0, true, true);
	$pdf->lastPage();
	ob_end_clean();
	$pdf->Output($filename,'I');
    }
}




if (!function_exists('zamplete')) {

    function zamplete($html, $title='', $subject='', $author='Humancenter Review S.A de C.V.') {
        $CI =& get_instance();
        $CI->load->library('tcpdf/Tcpdf');
		
// Extend the TCPDF class to create custom Header and Footer
class MYPDF extends TCPDF {

    //Page header
    public function Header() {
        // Logo
        $image_file = K_PATH_IMAGES.'hclogore.jpg';
        $this->Image($image_file, 16, 15, 250, 250, 'JPG', '', 'T', false, 300, '', false, false, 0, false, false, false);
        // Set font
        //$this->SetFont('helvetica', 'B', 10);
        // Title
        //$this->Cell(0, 0, '<< TCPDF Example 003 >>', 0, false, 'C', 0, '', 0, false, 'M', 'M');
    }

    // Page footer
    public function Footer() {
        // Position at 15 mm from bottom
		
		 $this->SetY(-25);	
		 $this->SetFont('helvetica', 'I', 8);
		 $this->Cell(0, 10, '    '.$this->getAliasNumPage().'/'.$this->getAliasNbPages(), 0, false, 'C', 0, '', 0, false, 'T', 'M');
		 $this->SetY(-22);	
		 $this->SetTextColor(84,141,212);
		 $this->SetFont('Times', 'B', 12);
		 $this->Cell(0, 0,"________________________________________________________________",  0, false, 'C', 0, '', 0, false, 'T', 'M');
		 $this->SetY(-16);
		 $this->Cell(0, 0,"EL VALOR DE LA CONFIANZA",  0, false, 'C', 0, '', 0, false, 'T', 'M');
			
		//  $this->SetY(-15);
        }
}

	// create new PDF document
	$pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

	// set document information
	$pdf->SetCreator(PDF_CREATOR);
	$pdf->SetAuthor($author);
	$pdf->SetTitle($title);
	$pdf->SetSubject($subject);
	$pdf->SetKeywords('TCPDF, PDF, RECETAS, HUMANCENTER, PLATAFORMA');

	// set default header data
	$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE, PDF_HEADER_STRING);

	// set header and footer fonts
	$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
	$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

	// set default monospaced font
	$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

	// set margins
	//$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
	//$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
	//$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

	$pdf->SetMargins(10, 10);
	$pdf->SetHeaderMargin(10);
	$pdf->SetFooterMargin(5);

	// set auto page breaks
	//$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
	$pdf->SetAutoPageBreak(TRUE, 4);

	//$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
	$pdf->setImageScale(1);
	$pdf->setFontSubsetting(true);
	// set font
	$pdf->SetFont('helvetica', '', 9);


	// set some language-dependent strings (optional)
	if (@file_exists(dirname(__FILE__).'/lang/eng.php')) {
		require_once(dirname(__FILE__).'/lang/eng.php');
		$pdf->setLanguageArray($l);
		}

	//$pdf->SetFont('times', 'BI', 12);

	// add a page
	$pdf->AddPage();
	$pdf->writeHTML($html, true, 0, true, true);
	$pdf->lastPage();
	ob_end_clean();
	$pdf->Output($filename,'I');
    }
}


if (!function_exists('sura_amplete')) {

    function sura_amplete($html, $title='', $subject='', $author='Humancenter Review S.A de C.V.') {
        $CI =& get_instance();
        $CI->load->library('tcpdf/Tcpdf');
		
// Extend the TCPDF class to create custom Header and Footer
class MYPDF extends TCPDF {

    //Page header
    public function Header() {
        // Logo
        $image_file = K_PATH_IMAGES.'';
        $this->Image($image_file, 20, 50, 175, 175, 'JPG', '', 'T', false, 300, '', false, false, 0, false, false, false);
        // Set font
        //$this->SetFont('helvetica', 'B', 10);
        // Title
        //$this->Cell(0, 0, '<< TCPDF Example 003 >>', 0, false, 'C', 0, '', 0, false, 'M', 'M');
    }

    // Page footer
    public function Footer() {
        // Position at 15 mm from bottom
		 $this->SetY(-19);	
		 $this->SetFont('helvetica', 'B', 7);		 	 
		 $this->Cell(0, 0,"San Borja 1365 Col. Vértiz Narvarte, Alcadía Benito Juárez, C.P. 03600, Ciudad de México",  0, false, 'C', 0, '', 0, false, 'T', 'M');
		 $this->SetY(-16);	
		 $this->Cell(0, 0,"_______________________________________________________________________________________________________________________________________________",  0, false, 'C', 0, '', 0, false, 'T', 'M');
		 $this->SetY(-15);
        // Set font
         $this->SetFont('helvetica', 'I', 8);
        // Page number
         $this->Cell(0, 10, 'Página '.$this->getAliasNumPage().'/'.$this->getAliasNbPages(), 0, false, 'C', 0, '', 0, false, 'T', 'M');
    }
}

	// create new PDF document
	$pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

	// set document information
	$pdf->SetCreator(PDF_CREATOR);
	$pdf->SetAuthor($author);
	$pdf->SetTitle($title);
	$pdf->SetSubject($subject);
	$pdf->SetKeywords('TCPDF, PDF, RECETAS, HUMANCENTER, PLATAFORMA');

	// set default header data
	$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE, PDF_HEADER_STRING);

	// set header and footer fonts
	$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
	$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

	// set default monospaced font
	$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

	// set margins
	//$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
	//$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
	//$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

	$pdf->SetMargins(10, 10);
	$pdf->SetHeaderMargin(10);
	$pdf->SetFooterMargin(5);

	// set auto page breaks
	$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);


	//$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
	$pdf->setImageScale(1);
	$pdf->setFontSubsetting(true);
	// set font
	$pdf->SetFont('helvetica', '', 9);


	// set some language-dependent strings (optional)
	if (@file_exists(dirname(__FILE__).'/lang/eng.php')) {
		require_once(dirname(__FILE__).'/lang/eng.php');
		$pdf->setLanguageArray($l);
		}

	//$pdf->SetFont('times', 'BI', 12);

	// add a page
	$pdf->AddPage();
	$pdf->writeHTML($html, true, 0, true, true);
	$pdf->lastPage();
	ob_end_clean();
	$pdf->Output($filename,'I');
    }
}




if (!function_exists('xamplete')) {

    function xamplete($html, $title='', $subject='', $author='Humancenter Review S.A de C.V.') {
        $CI =& get_instance();
        $CI->load->library('tcpdf/Tcpdf');
		
// Extend the TCPDF class to create custom Header and Footer
class MYPDF extends TCPDF {

    //Page header
    public function Header() {
        // Logo
        $image_file = K_PATH_IMAGES.'hclogo.jpg';
        $this->Image($image_file, 20, 50, 175, 175, 'JPG', '', 'T', false, 300, '', false, false, 0, false, false, false);
        // Set font
        //$this->SetFont('helvetica', 'B', 10);
        // Title
        //$this->Cell(0, 0, '<< TCPDF Example 003 >>', 0, false, 'C', 0, '', 0, false, 'M', 'M');
    }

    // Page footer
    public function Footer() {
        // Position at 15 mm from bottom
		 $this->SetY(-19);	
		 $this->SetFont('helvetica', 'B', 7);		 	 
		 $this->Cell(0, 0,"San Borja 1365 Col. Vértiz Narvarte, Alcadía Benito Juárez, C.P. 03600, Ciudad de México",  0, false, 'C', 0, '', 0, false, 'T', 'M');
		 $this->SetY(-16);	
		 $this->Cell(0, 0,"_______________________________________________________________________________________________________________________________________________",  0, false, 'C', 0, '', 0, false, 'T', 'M');
		 $this->SetY(-15);
        // Set font
         $this->SetFont('helvetica', 'I', 8);
        // Page number
         $this->Cell(0, 10, 'Página '.$this->getAliasNumPage().'/'.$this->getAliasNbPages(), 0, false, 'C', 0, '', 0, false, 'T', 'M');
    }
}

	// create new PDF document
	$pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

	// set document information
	$pdf->SetCreator(PDF_CREATOR);
	$pdf->SetAuthor($author);
	$pdf->SetTitle($title);
	$pdf->SetSubject($subject);
	$pdf->SetKeywords('TCPDF, PDF, RECETAS, HUMANCENTER, PLATAFORMA');

	// set default header data
	$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE, PDF_HEADER_STRING);

	// set header and footer fonts
	$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
	$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

	// set default monospaced font
	$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

	// set margins
	//$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
	//$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
	//$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

	$pdf->SetMargins(10, 10);
	$pdf->SetHeaderMargin(10);
	$pdf->SetFooterMargin(5);

	// set auto page breaks
	$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);


	//$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
	$pdf->setImageScale(1);
	$pdf->setFontSubsetting(true);
	// set font
	$pdf->SetFont('helvetica', '', 9);


	// set some language-dependent strings (optional)
	if (@file_exists(dirname(__FILE__).'/lang/eng.php')) {
		require_once(dirname(__FILE__).'/lang/eng.php');
		$pdf->setLanguageArray($l);
		}

	//$pdf->SetFont('times', 'BI', 12);

	// add a page
	$pdf->AddPage();
	$pdf->writeHTML($html, true, 0, true, true);
	$pdf->lastPage();
	ob_end_clean();
	$pdf->Output($filename,'I');
    }
}



if (!function_exists('genera_pdf_receta_bk')) {

    function genera_pdf_receta_bk($html, $filename = '',$title='', $subject='', $author='Humancenter Review S.A de C.V.',$ruta) {
        $CI =& get_instance();

        // Llamada a la libreria TCPDF
        $CI->load->library('tcpdf/Tcpdf');
		
	// Extend the TCPDF class to create custom Header and Footer
		class MYPDF extends TCPDF {

		public $laboratorista;
		public $observaciones;

		public function Header()
		{
			
			$this->SetFont('Arial','B',50);
			$this->SetTextColor(255,192,203);
			$this->Cell(0, 0,"San Borja 1365 Col. Vértiz Narvarte, Alc. Benito Juárez C.P. 03600 Ciudad de México",  0, false, 'C', 0, '', 0, false, 'T', 'M');
		}
		
		public function Footer() {
				 $this->SetFont('helvetica', 'B', 7);
				 $mueve=-15;
				 $this->SetY($mueve);
				 $this->SetFont('helvetica', 'B', 8);
				 $this->SetLineStyle(array('width' => 0.01, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 77)));
				 $this->SetFillColor(0, 0, 77);
				 $this->Cell(0, 0,"",1, 1, 'L', 1, 0);
				 $mueve+=4;
				 $this->SetFont('helvetica', 'B', 7);
				 $this->SetY($mueve);		 
				 $this->Cell(0, 0,"San Borja 1365 Col. Vértiz Narvarte, Alcaldía Benito Juárez C.P. 03600 Ciudad de México",  0, false, 'C', 0, '', 0, false, 'T', 'M');
			}		

	}		
		

        // Crear Nuevo PDF
        $pdf = new TCPDF();

        //info del PDF  
        $pdf->SetCreator(PDF_CREATOR);
        $pdf->SetAuthor($author);
        $pdf->SetTitle($title);
        $pdf->SetSubject($subject);
		$pdf->laboratorista=1;
		$pdf->observaciones=1;
        // Cabecera del PDF
        $pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE.' 001', PDF_HEADER_STRING, array(0,64,255), array(0,64,128));
        //$pdf->setFooterData(array(0,64,0), array(0,64,128));
        // set header and footer fonts
        $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
        $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
        $pdf->SetPrintHeader(FALSE);
		
        // set default monospaced font
        //$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

        // set margins
        $pdf->SetMargins(10, 10);
        $pdf->SetHeaderMargin(10);
        $pdf->SetFooterMargin(5);
		
        // set auto page breaks
        $pdf->SetAutoPageBreak(TRUE, 10);

        // set image scale factor
        $pdf->setImageScale(1);
        $pdf->setFontSubsetting(true);
        $pdf->SetFont('helvetica', '', 9);
        //$pdf->AddPage($tipo_pdf);
		$pdf->AddPage('P', 'letter');
		//$pdf->Image('C:\xampp\htdocs\humancenter_forms\dist\images\hclogo.jpg', 55, 20, 100, 100, 'JPG', '', '', true, 200, '', false, false, 0, false, false, true); 
        //$pdf->Image($ruta, 60, 20, 100, 100, 'JPG', '', '', true, 200, '', false, false, 0, false, false, true); 
		$pdf->Image($ruta, 60, 30, 100, 100, 'JPG', '', '', true, 200, '', false, false, 0, false, false, true); 
		$pdf->setTextShadow(array('enabled'=>false, 'depth_w'=>0.2, 'depth_h'=>0.2, 'color'=>array(196,196,196), 'opacity'=>1, 'blend_mode'=>'Normal'));

        $pdf->writeHTML($html, true, 0, true, true);
        $pdf->lastPage();
        ob_end_clean();
        $pdf->Output($filename,'I');
    }
}




if (!function_exists('genera_pdf_receta')) {

    function genera_pdf_receta($html, $filename = '',$title='', $subject='', $author='Humancenter Review S.A de C.V.', $tipo_pdf = 'P',$ruta) {
        $CI =& get_instance();

        // Llamada a la libreria TCPDF
        $CI->load->library('tcpdf/Tcpdf');

        // Crear Nuevo PDF
        $pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

        //info del PDF  
        $pdf->SetCreator(PDF_CREATOR);
        $pdf->SetAuthor($author);
        $pdf->SetTitle($title);
        $pdf->SetSubject($subject);

        // Cabecera del PDF
        $pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE.' 001', PDF_HEADER_STRING, array(0,64,255), array(0,64,128));
        //$pdf->setFooterData(array(0,64,0), array(0,64,128));
        // set header and footer fonts
        $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
        $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
        $pdf->SetPrintHeader(false);
        // set default monospaced font
        //$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

        // set margins
        $pdf->SetMargins(10, 10);
        $pdf->SetHeaderMargin(1);
        $pdf->SetFooterMargin(5);

        // set auto page breaks
        $pdf->SetAutoPageBreak(TRUE, 10);

        // set image scale factor
        $pdf->setImageScale(1);
        $pdf->setFontSubsetting(true);
        $pdf->SetFont('helvetica', '', 9);
        //$pdf->AddPage($tipo_pdf);
		$pdf->AddPage('P', 'letter');
		//$pdf->Image('C:\xampp\htdocs\humancenter_forms\dist\images\hclogo.jpg', 55, 20, 100, 100, 'JPG', '', '', true, 200, '', false, false, 0, false, false, true); 
        //$pdf->Image($ruta, 60, 20, 100, 100, 'JPG', '', '', true, 200, '', false, false, 0, false, false, true); 
		$pdf->Image($ruta, 60, 30, 100, 100, 'JPG', '', '', true, 200, '', false, false, 0, false, false, true); 
		$pdf->setTextShadow(array('enabled'=>false, 'depth_w'=>0.2, 'depth_h'=>0.2, 'color'=>array(196,196,196), 'opacity'=>1, 'blend_mode'=>'Normal'));

        $pdf->writeHTML($html, true, 0, true, true);
        $pdf->lastPage();
        ob_end_clean();
        $pdf->Output($filename,'I');
    }
}


if (!function_exists('genera_pdf_reporte')) {

    function genera_pdf_reporte($html, $filename = '',$title='', $subject='', $author='Humancenter Review S.A de C.V.', $tipo_pdf = 'L') {
        $CI =& get_instance();

        // Llamada a la libreria TCPDF
        $CI->load->library('tcpdf/Tcpdf');

        // Crear Nuevo PDF
        $pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

        //info del PDF
        $pdf->SetCreator(PDF_CREATOR);
        $pdf->SetAuthor($author);
        $pdf->SetTitle($title);
        $pdf->SetSubject($subject);

        // Cabecera del PDF
        $pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE.' 001', PDF_HEADER_STRING, array(0,64,255), array(0,64,128));
        //$pdf->setFooterData(array(0,64,0), array(0,64,128));
        // set header and footer fonts
        $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
        $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
        $pdf->SetPrintHeader(false);
        // set default monospaced font
        //$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

        // set margins
        $pdf->SetMargins(10, 10);
        $pdf->SetHeaderMargin(1);
        $pdf->SetFooterMargin(5);

        // set auto page breaks
        $pdf->SetAutoPageBreak(TRUE, 10);

        // set image scale factor
        $pdf->setImageScale(1);
        $pdf->setFontSubsetting(true);
        $pdf->SetFont('helvetica', '', 6);
        $pdf->AddPage($tipo_pdf);
        $pdf->setTextShadow(array('enabled'=>false, 'depth_w'=>0.2, 'depth_h'=>0.2, 'color'=>array(196,196,196), 'opacity'=>1, 'blend_mode'=>'Normal'));

        $pdf->writeHTML($html, true, 0, true, true);
        $pdf->lastPage();
        ob_end_clean();
        $pdf->Output($filename,'I');
    }
}



if (!function_exists('genera_pdf_todo')) {

    function genera_pdf_todo($html, $filename = '',$title='', $subject='', $author='Humancenter Review S.A de C.V.', $tipo_pdf = 'P') {
        $CI =& get_instance();

        // Llamada a la libreria TCPDF
        $CI->load->library('tcpdf/Tcpdf');

// Extend the TCPDF class to create custom Header and Footer
	class MYPDF extends TCPDF 
	{
	
    // Page footer
    public function Footer() 
	{
        // Position at 15 mm from bottom

        /* Set font
        $this->SetFont('helvetica', 'B', 8);
		$mueve=-35;
		$this->SetY($mueve);
		$this->Cell(0, 0,"San Borja 1365 Col. Vértiz Narvarte Del. Benito Juárez C.P. 03600 Ciudad de México", 'T', 0, 'C');
		 
		$this->SetTextColorArray($this->footer_text_color);
		
		$mueve+=3;
		$this->SetY($mueve);
		$line_width = (0.85 / $this->k);
		$mueve+=3;
		$this->SetY($mueve);
        $this->Cell(0, 0,"San Borja 1365 Col. Vértiz Narvarte Del. Benito Juárez C.P. 03600 Ciudad de México", 'T', 0, 'C');
         */  

         		 
		 $this->SetTextColorArray($this->footer_text_color);
		 $mueve=-38;
		/* $this->SetY($mueve);
		 $this->Cell(0, 0,"RESPONSABLE:");
		 $mueve+=4;
		 $this->SetY($mueve);
		 $this->Cell(0, 0,"Q.F.B. JAIMES FLORES MONTSERRAT    11322160                                                                                                                        ");
		 $mueve+=4;
		 $this->SetY($mueve);
		 $this->SetFont('helvetica', 'B', 8);
		 $line_width = (0.85 / $this->k);*/
		 //$this->SetLineStyle(array('width' => 0.1, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 77)));
		 //$this->SetFillColor(0, 0, 77);
		 //$this->Cell(0, 0,"",1, 1, 'L', 1, 0);
		 $mueve+=4;
		 $this->SetFont('helvetica', 'B', 7);
		 $mueve+=3;
		 $this->SetY($mueve);
		 $this->Cell(0, 0,"San Borja 1365 Col. Vértiz Narvarte, Alcaldía Benito Juárez, C.P. 03600 Ciudad de México. Tel. 01-55-36-40-44-36 ",  0, false, 'C', 0, '', 0, false, 'T', 'M');
	 
	}
}

        // Crear Nuevo PDF
        $pdf = new  MYPDF (PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
        
        //info del PDF
        $pdf->SetCreator(PDF_CREATOR);
        $pdf->SetAuthor($author);
        $pdf->SetTitle($title);
        $pdf->SetSubject($subject);

        // Cabecera del PDF
        $pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE.' 001', PDF_HEADER_STRING, array(0,64,255), array(0,64,128));
        //$pdf->setFooterData(array(0,64,0), array(0,64,128));
        // set header and footer fonts
        $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
        $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
        $pdf->SetPrintHeader(false);
        // set default monospaced font
        //$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

        // set margins original
        /*$pdf->SetMargins(10, 10);
        $pdf->SetHeaderMargin(1);
        $pdf->SetFooterMargin(5);*/

        // set margins
        $pdf->SetMargins(10, 20,10,5);
        $pdf->SetHeaderMargin(1);
        $pdf->SetFooterMargin(8);

        // set auto page breaks
        $pdf->SetAutoPageBreak(TRUE, 35);

        // set image scale factor
        $pdf->setImageScale(1);
        $pdf->setFontSubsetting(true);
        $pdf->SetFont('helvetica', '', 9);
        $pdf->AddPage($tipo_pdf);
        $pdf->setTextShadow(array('enabled'=>false, 'depth_w'=>0.2, 'depth_h'=>0.2, 'color'=>array(196,196,196), 'opacity'=>1, 'blend_mode'=>'Normal'));

        $pdf->writeHTML($html, true, 0, true, true);
        $pdf->lastPage();
        ob_end_clean();
        $pdf->Output($filename,'I');
    }
}


if (!function_exists('genera_pdf_new_reporte_bitacora')) {

    function genera_pdf_new_reporte_bitacora($html, $filename = '',$title='', $subject='', $author='Humancenter Review S.A de C.V.', $tipo_pdf = 'P',$fecha_exp) 
	{
        $CI =& get_instance();
        $CI->load->library('tcpdf/Tcpdf');
		
// Extend the TCPDF class to create custom Header and Footer
class MYPDF extends TCPDF {

	public $evaluado;
	public $observaciones;
	public $fuera_rango;
	public $fecha_expediente;
	
    //Page header
    public function Header() {
        // Logo
        //$image_file = K_PATH_IMAGES.'hclogo.jpg';
		$image_file = K_PATH_IMAGES.'hclogo_g.jpg';
		// 20, 50, 175, 175,
        $this->Image($image_file, 50, 80, 105, 105, 'JPG', '', 'T', false, 300, '', false, false, 0, false, false, false);
        // Set font
        //$this->SetFont('helvetica', 'B', 10);
        // Title
        //$this->Cell(0, 0, $image_file.'<< TCPDF Example 003 >>', 0, false, 'C', 0, '', 0, false, 'M', 'M');
    }

    // Page footer
    public function Footer() {
        // Position at 15 mm from bottom
         $this->SetFont('helvetica', 'B', 8);
		 $mueve=-33;
		 $mueve+=4;
		 $mueve+=3;
		 $this->SetY($mueve);
		 //$this->Cell(0, 0,"          ");
		 $this->Cell(0, 0,$this->fecha_expediente);
		 $muevo=192;//202;
		 $ajuste=$muevo - strlen($this->evaluado)*1.50;
		 $this->SetX($ajuste);
		 $this->Cell(0, 0,$this->evaluado);
		 $mueve+=1;
		 $this->SetY($mueve);
		 //$this->SetFont('helvetica', 'B', 2);
		 
		 /* linea*/
		 $mueve+=1;
		 $this->SetFillColor(75,86,130);
		 $this->Cell(0, 0,"_________________________________________________________________________________________________________________________",  0, false, 'C', 0, '', 0, false, 'T', 'M');		 
		 /**/

		 $mueve+=4;
		 $this->SetFont('helvetica', 'B', 8);
		 $this->SetY($mueve);
		 $this->Cell(0, 0,"Human Center Review S.A. de C.V.",  0, false, 'C', 0, '', 0, false, 'T', 'M');
		 

		 
		 $mueve+=3;
		 $this->SetY($mueve);
		 $this->Cell(0, 0,"San Borja 1365 Col. Vértiz Narvarte Alc. Benito Juárez C.P. 03600 Ciudad de México. Tel. 55-36-40-44-36 ",  0, false, 'C', 0, '', 0, false, 'T', 'M');

		 $this->SetY(-15);
        // Set font
         $this->SetFont('helvetica', 'I', 8);
        // Page number
         $this->Cell(0, 10, 'Página '.$this->getAliasNumPage().'/'.$this->getAliasNbPages(), 0, false, 'C', 0, '', 0, false, 'T', 'M');
    }
}

	// create new PDF document
	$pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

		$pdf->evaluado=$subject;
		$pdf->observaciones=$obs;
		$pdf->fecha_expediente= $fecha_exp;
		/*if ($fuera_rango == '')
		{
			$pdf->fuera_rango='Ninguno';
		}	
		else*/
		{
			$pdf->fuera_rango=$fuera_rango;
		}	
	// set document information
	$pdf->SetCreator(PDF_CREATOR);
	$pdf->SetAuthor($author);
	$pdf->SetTitle($title);
	$pdf->SetSubject($subject);
	$pdf->SetKeywords('TCPDF, PDF, RECETAS, HUMANCENTER, PLATAFORMA');

	// set default header data
	$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE, PDF_HEADER_STRING);

	// set header and footer fonts
	$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
	$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

	// set default monospaced font
	$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

	// set margins
	//$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
	//$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
	//$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

	//$pdf->SetMargins(10, 10);
	//$pdf->SetHeaderMargin(10);
	//$pdf->SetFooterMargin(5);


		$pdf->SetMargins(10,20,10);
        $pdf->SetHeaderMargin(1);
        $pdf->SetFooterMargin(8);



	// set auto page breaks
	//$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
	$pdf->SetAutoPageBreak(TRUE, 41);

	//$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
	$pdf->setImageScale(1);
	$pdf->setFontSubsetting(true);
	// set font
	$pdf->SetFont('helvetica', '', 9);


	// set some language-dependent strings (optional)
	if (@file_exists(dirname(__FILE__).'/lang/eng.php')) {
		require_once(dirname(__FILE__).'/lang/eng.php');
		$pdf->setLanguageArray($l);
		}

	//$pdf->SetFont('times', 'BI', 12);

	// add a page
	$pdf->AddPage();
	$pdf->writeHTML($html, true, 0, true, true);
	$pdf->lastPage();
// write some JavaScript code
//$js = <<<EOD

//EOD;

// force print dialog
//$js .= 'print(true);';

// set javascript
//$pdf->IncludeJS($js);	

	ob_end_clean();
	//$pdf->Output(UPLOAD_PATH.'example_001.pdf', 'FI'); //PARA SACAR A UN ARCHIVO EL RESULTADO
	//$pdf->Output('example_001.pdf', 'F'); //PARA SACAR A UN ARCHIVO EL RESULTADO
	
	//$pdf->Output($filename,'I');  //modo normal

	$pdf->Output($filename,'F');

//$pdf->Output($filename,'D'); 
    }
}













if (!function_exists('genera_pdf_new_reporte_poli')) {

    function genera_pdf_new_reporte_poli($html, $filename = '',$title='', $subject='', $author='Humancenter Review S.A de C.V.', $tipo_pdf = 'P',$fecha_exp) 
	{
        $CI =& get_instance();
        $CI->load->library('tcpdf/Tcpdf');
		
// Extend the TCPDF class to create custom Header and Footer
class MYPDF extends TCPDF {

	public $evaluado;
	public $observaciones;
	public $fuera_rango;
	public $fecha_expediente;
	
    //Page header
    public function Header() {
        // Logo
        //$image_file = K_PATH_IMAGES.'hclogo.jpg';
		$image_file = K_PATH_IMAGES.'hclogo_g.jpg';
		// 20, 50, 175, 175,
        $this->Image($image_file, 50, 80, 105, 105, 'JPG', '', 'T', false, 300, '', false, false, 0, false, false, false);
        // Set font
        //$this->SetFont('helvetica', 'B', 10);
        // Title
        //$this->Cell(0, 0, $image_file.'<< TCPDF Example 003 >>', 0, false, 'C', 0, '', 0, false, 'M', 'M');
    }

    // Page footer
    public function Footer() {
        // Position at 15 mm from bottom
         $this->SetFont('helvetica', 'B', 8);
		 $mueve=-33;
		 $mueve+=4;
		 $mueve+=3;
		 $this->SetY($mueve);
		 //$this->Cell(0, 0,"          ");
		 $this->Cell(0, 0,$this->fecha_expediente);
		 $muevo=192;//202;
		 $ajuste=$muevo - strlen($this->evaluado)*1.50;
		 $this->SetX($ajuste);
		 $this->Cell(0, 0,$this->evaluado);
		 $mueve+=1;
		 $this->SetY($mueve);
		 //$this->SetFont('helvetica', 'B', 2);
		 
		 /* linea*/
		 $mueve+=1;
		 $this->SetFillColor(75,86,130);
		 $this->Cell(0, 0,"_________________________________________________________________________________________________________________________",  0, false, 'C', 0, '', 0, false, 'T', 'M');		 
		 /**/

		 $mueve+=4;
		 $this->SetFont('helvetica', 'B', 8);
		 $this->SetY($mueve);
		 $this->Cell(0, 0,"Human Center Review S.A. de C.V.",  0, false, 'C', 0, '', 0, false, 'T', 'M');
		 

		 
		 $mueve+=3;
		 $this->SetY($mueve);
		 $this->Cell(0, 0,"San Borja 1365 Col. Vértiz Narvarte Alc. Benito Juárez C.P. 03600 Ciudad de México. Tel. 55-36-40-44-36 ",  0, false, 'C', 0, '', 0, false, 'T', 'M');

		 $this->SetY(-15);
        // Set font
         $this->SetFont('helvetica', 'I', 8);
        // Page number
         $this->Cell(0, 10, 'Página '.$this->getAliasNumPage().'/'.$this->getAliasNbPages(), 0, false, 'C', 0, '', 0, false, 'T', 'M');
    }
}

	// create new PDF document
	$pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

		$pdf->evaluado=$subject;
		$pdf->observaciones=$obs;
		$pdf->fecha_expediente= $fecha_exp;
		/*if ($fuera_rango == '')
		{
			$pdf->fuera_rango='Ninguno';
		}	
		else*/
		{
			$pdf->fuera_rango=$fuera_rango;
		}	
	// set document information
	$pdf->SetCreator(PDF_CREATOR);
	$pdf->SetAuthor($author);
	$pdf->SetTitle($title);
	$pdf->SetSubject($subject);
	$pdf->SetKeywords('TCPDF, PDF, RECETAS, HUMANCENTER, PLATAFORMA');

	// set default header data
	$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE, PDF_HEADER_STRING);

	// set header and footer fonts
	$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
	$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

	// set default monospaced font
	$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

	// set margins
	//$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
	//$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
	//$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

	//$pdf->SetMargins(10, 10);
	//$pdf->SetHeaderMargin(10);
	//$pdf->SetFooterMargin(5);


		$pdf->SetMargins(10,20,10);
        $pdf->SetHeaderMargin(1);
        $pdf->SetFooterMargin(8);



	// set auto page breaks
	//$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
	$pdf->SetAutoPageBreak(TRUE, 41);

	//$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
	$pdf->setImageScale(1);
	$pdf->setFontSubsetting(true);
	// set font
	$pdf->SetFont('helvetica', '', 9);


	// set some language-dependent strings (optional)
	if (@file_exists(dirname(__FILE__).'/lang/eng.php')) {
		require_once(dirname(__FILE__).'/lang/eng.php');
		$pdf->setLanguageArray($l);
		}

	//$pdf->SetFont('times', 'BI', 12);

	// add a page
	$pdf->AddPage();
	$pdf->writeHTML($html, true, 0, true, true);
	$pdf->lastPage();
// write some JavaScript code
//$js = <<<EOD

//EOD;

// force print dialog
//$js .= 'print(true);';

// set javascript
//$pdf->IncludeJS($js);	

	ob_end_clean();
	//$pdf->Output(UPLOAD_PATH.'example_001.pdf', 'FI'); //PARA SACAR A UN ARCHIVO EL RESULTADO
	//$pdf->Output('example_001.pdf', 'F'); //PARA SACAR A UN ARCHIVO EL RESULTADO
	
	$pdf->Output($filename,'I');  //modo normal

	//$pdf->Output('./../../files/docs_bitacora/report_real.pdf','F');

//$pdf->Output($filename,'D'); 
    }
}




if (!function_exists('genera_pdf_reporte_poli')) {

    function genera_pdf_reporte_poli($html, $filename = '',$title='', $subject='', $author='Humancenter Review S.A de C.V.', $tipo_pdf = 'P') {
        $CI =& get_instance();

        // Llamada a la libreria TCPDF
        $CI->load->library('tcpdf/Tcpdf');

// Extend the TCPDF class to create custom Header and Footer
	class MYPDF extends TCPDF 
	{
	 public $evaluado;
    // Page footer
    public function Footer() 
	{
        // Position at 15 mm from bottom

        /* Set font
        $this->SetFont('helvetica', 'B', 8);
		$mueve=-35;
		$this->SetY($mueve);
		$this->Cell(0, 0,"San Borja 1365 Col. Vértiz Narvarte Del. Benito Juárez C.P. 03600 Ciudad de México", 'T', 0, 'C');
		 
		$this->SetTextColorArray($this->footer_text_color);
		
		$mueve+=3;
		$this->SetY($mueve);
		$line_width = (0.85 / $this->k);
		$mueve+=3;
		$this->SetY($mueve);
        $this->Cell(0, 0,"San Borja 1365 Col. Vértiz Narvarte Del. Benito Juárez C.P. 03600 Ciudad de México", 'T', 0, 'C');
         */  

         		 
		 $this->SetTextColorArray($this->footer_text_color);
		 $mueve=-40;
		/* $this->SetY($mueve);
		 $this->Cell(0, 0,"RESPONSABLE:");
		 $mueve+=4;
		 $this->SetY($mueve);
		 $this->Cell(0, 0,"Q.F.B. JAIMES FLORES MONTSERRAT    11322160                                                                                                                        ");
		 $mueve+=4;
		 $this->SetY($mueve);
		 $this->SetFont('helvetica', 'B', 8);
		 $line_width = (0.85 / $this->k);*/
		 //$this->SetLineStyle(array('width' => 0.1, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 77)));
		 //$this->SetFillColor(0, 0, 77);
		 //$this->Cell(0, 0,"",1, 1, 'L', 1, 0);
		 $mueve+=4;
		 $this->SetFont('helvetica', 'B', 7);
		 $mueve+=3;
		 $this->SetY($mueve);
		 $this->Cell(0, 0,"          ");
		 //$this->Cell(0, 0,"SSP 009-22");
		 $muevo=202;
		 $ajuste=$muevo - strlen($this->evaluado)*1.50;
		 $this->SetX($ajuste);
		 $this->Cell(0, 0,$this->evaluado);
		 $mueve+=2;
		 $this->SetY($mueve);
		 $this->Cell(0, 0,"_______________________________________________________________________________________________________________________________________________",  0, false, 'C', 0, '', 0, false, 'T', 'M');
		 $mueve+=4;
		 $this->SetY($mueve);
		 $this->Cell(0, 0,"San Borja 1365 Col. Vértiz Narvarte Alc. Benito Juárez C.P. 03600 Ciudad de México. Tel. 01-55-36-40-44-36 ",  0, false, 'C', 0, '', 0, false, 'T', 'M');
	 
	}
}

        // Crear Nuevo PDF
        $pdf = new  MYPDF (PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
        $pdf->evaluado=$subject;
        //info del PDF
        $pdf->SetCreator(PDF_CREATOR);
        $pdf->SetAuthor($author);
        $pdf->SetTitle($title);
        $pdf->SetSubject($subject);

        // Cabecera del PDF
        $pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE.' 001', PDF_HEADER_STRING, array(0,64,255), array(0,64,128));
        //$pdf->setFooterData(array(0,64,0), array(0,64,128));
        // set header and footer fonts
        $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
        $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
        $pdf->SetPrintHeader(false);
        // set default monospaced font
        //$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

        // set margins original
        /*$pdf->SetMargins(10, 10);
        $pdf->SetHeaderMargin(1);
        $pdf->SetFooterMargin(5);*/

        // set margins
        $pdf->SetMargins(10, 20,10,5);
        $pdf->SetHeaderMargin(1);
        $pdf->SetFooterMargin(8);

        // set auto page breaks
        $pdf->SetAutoPageBreak(TRUE, 35);

        // set image scale factor
        $pdf->setImageScale(1);
        $pdf->setFontSubsetting(true);
        $pdf->SetFont('helvetica', '', 9);
        $pdf->AddPage($tipo_pdf);
        $pdf->setTextShadow(array('enabled'=>false, 'depth_w'=>0.2, 'depth_h'=>0.2, 'color'=>array(196,196,196), 'opacity'=>1, 'blend_mode'=>'Normal'));

        $pdf->writeHTML($html, true, 0, true, true);
        $pdf->lastPage();
        ob_end_clean();
        $pdf->Output($filename,'I');
    }
}

/************************************************************************************/
if (!function_exists('genera_pdf_san_borja')) {

    function genera_pdf_san_borja($html, $filename = '',$title='', $subject='', $author='Humancenter Review S.A de C.V.', $tipo_pdf = 'P') {
        $CI =& get_instance();

        // Llamada a la libreria TCPDF
        $CI->load->library('tcpdf/Tcpdf');

// Extend the TCPDF class to create custom Header and Footer
	class MYPDF extends TCPDF {

    // Page footer
    public function Footer() {
        // Position at 15 mm from bottom

        // Set font
         $this->SetFont('helvetica', 'B', 8);
		 $mueve=-43;
		 $this->SetY($mueve);
		 //$this->Cell(0, 0,"RESPONSABLE:");$mueve+=3;
		 $this->SetY($mueve);
		 //$this->Cell(0, 0,"Q.F.B. JAIMES FLORES MONTSERRAT    11322160                                                                                                                        No. Reg SSP: 009-19");
		 $this->Cell(0, 0,"Q.F.B. MUÑOZ GARCÍA LETICIA        1392938                                                                                                                        ");
		 $mueve+=4;
		 $this->SetY($mueve);
		 $this->SetFont('helvetica', 'B', 8);
		 //$this->SetLineStyle(array('width' => 0.5, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(61, 85, 136)));
		 $this->SetLineStyle(array('width' => 0.5, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 77)));
		 //$this->SetFillColor(61, 85, 136);
		 $this->SetFillColor(0, 0, 77);
		 $this->Cell(0, 0,"",1, 1, 'L', 1, 0);
		 $mueve+=4;
		 $this->SetFont('helvetica', 'B', 8);
		 $this->SetY($mueve);
		 //$this->Cell(0, 0,"Nota: Para validar resultados, se tendrá 3 días posteriores a la aplicación de la evaluación.                                                                           FGP06");
		 $this->Cell(0, 0,"Nota: Para validar resultados, se tendrá 3 días posteriores a la aplicación de la evaluación.                                                                           ");
		 $mueve+=3;
		 $this->SetY($mueve);
		 $this->Cell(0, 0,"Human Center Review S.A. de C.V.",  0, false, 'C', 0, '', 0, false, 'T', 'M');
		 $mueve+=3;
		 $this->SetY($mueve);
		 $this->Cell(0, 0,"San Borja 1365 Col. Vértiz Narvarte Alc. Benito Juárez C.P. 03600 Ciudad de México. Tel. 55-36-40-44-36 ",  0, false, 'C', 0, '', 0, false, 'T', 'M');
    }
}


        // Crear Nuevo PDF
        $pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

        //info del PDF
        $pdf->SetCreator(PDF_CREATOR);
        $pdf->SetAuthor($author);
        $pdf->SetTitle($title);
        $pdf->SetSubject($subject);

        // Cabecera del PDF
        $pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE.' 001', PDF_HEADER_STRING, array(0,64,255), array(0,64,128));
        //$pdf->setFooterData(array(0,64,0), array(0,64,128));
        // set header and footer fonts
        $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
        $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
        $pdf->SetPrintHeader(false);
        // set default monospaced font
        //$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

        // set margins
        $pdf->SetMargins(10, 10);
        $pdf->SetHeaderMargin(1);
        $pdf->SetFooterMargin(5);

        // set auto page breaks
        $pdf->SetAutoPageBreak(TRUE, 10);



        // set image scale factor
        $pdf->setImageScale(1);
        $pdf->setFontSubsetting(true);
        $pdf->SetFont('helvetica', '', 9);
        $pdf->AddPage($tipo_pdf);
        $pdf->setTextShadow(array('enabled'=>false, 'depth_w'=>0.2, 'depth_h'=>0.2, 'color'=>array(196,196,196), 'opacity'=>1, 'blend_mode'=>'Normal'));

        $pdf->writeHTML($html, true, 0, true, true);
        $pdf->lastPage();
        ob_end_clean();
        $pdf->Output($filename,'I');
    }
}
/************************************************************************************/
if (!function_exists('genera_pdf_lab_c')) {

    function genera_pdf_lab_c($html, $filename = '',$title='', $subject='',$obs='',$ruta, $author='Humancenter Review S.A de C.V.', $tipo_pdf = 'P') {
        $CI =& get_instance();

        // Llamada a la libreria TCPDF
        $CI->load->library('tcpdf/Tcpdf');

// Extend the TCPDF class to create custom Header and Footer
	class MYPDF extends TCPDF {

	public $laboratorista;
	public $observaciones;

    // Page footer
    public function Footer() {
        // Position at 15 mm from bottom

        // Set font
         $this->SetFont('helvetica', 'B', 7);
		 $mueve=-53;
		 $this->SetY($mueve);
		 $this->Cell(0, 0,"OBSERVACIONES:");
		 $this->SetX(40);
		 $this->Cell(0, 0,$this->observaciones);
		 $mueve+=3;
		 $this->SetY($mueve);
		 $this->Cell(0, 0,"Lo(s) resultado(s) fuera de rango validado(s)");$mueve+=3;
		 $this->SetY($mueve);$mueve+=3;		 
		 $this->SetY($mueve);$mueve+=3;
		 $this->SetY($mueve);$mueve+=3;$mueve+=3;
		 $this->SetFont('helvetica', 'B', 7);
		 $this->Cell(0, 0,$this->laboratorista);
		 $this->SetY($mueve);$mueve+=3;
		 $this->Cell(0, 0,"Nota: Si existe dudas, todo valor será corroborado de los siguientes 3 días después de tomado el estudio.                                                                           ");
		 $mueve+=1;
		 $this->SetY($mueve);
		 $this->SetFont('helvetica', 'B', 8);
		 //$this->SetLineStyle(array('width' => 0.5, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 77)));
		 //$this->SetFillColor(0, 0, 77);
		 //$this->Cell(0, 0,"",1, 1, 'L', 1, 0);
		 $mueve+=4;
		 $this->SetFont('helvetica', 'B', 7);
		 $this->SetY($mueve);
		 $this->Cell(0, 0,"Human Center Review S.A. de C.V.",  0, false, 'C', 0, '', 0, false, 'T', 'M');
		 $mueve+=3;
		 $this->SetY($mueve);
		 $this->Cell(0, 0,"Laboratorio Médico y de Diagnóstico del Sector Privado",  0, false, 'C', 0, '', 0, false, 'T', 'M');
		 $mueve+=3;		 
		 $this->SetY($mueve);
		 $this->Cell(0, 0,"Número de Registro COFEPRIS: 213300536X0279",  0, false, 'C', 0, '', 0, false, 'T', 'M');
		 $mueve+=3;		 
		 $this->SetY($mueve);		 
		 $this->Cell(0, 0,"San Borja 1365 Col. Vértiz Narvarte Alc. Benito Juárez C.P. 03600 Ciudad de México. Tel. 55-36-40-44-36  contacto@humancenter.com.mx",  0, false, 'C', 0, '', 0, false, 'T', 'M');
    }
}


        // Crear Nuevo PDF
        $pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
		$pdf->laboratorista=$subject;
		$pdf->observaciones=$obs;
        //info del PDF
        $pdf->SetCreator(PDF_CREATOR);
        $pdf->SetAuthor($author);
        $pdf->SetTitle($title);
        $pdf->SetSubject($subject);

        // Cabecera del PDF
        $pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE.' 001', PDF_HEADER_STRING, array(0,64,255), array(0,64,128));
        //$pdf->setFooterData(array(0,64,0), array(0,64,128));
        // set header and footer fonts
        $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
        $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
        $pdf->SetPrintHeader(false);
        // set default monospaced font
        //$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

        // set margins
        $pdf->SetMargins(10, 10);
        $pdf->SetHeaderMargin(1);
        $pdf->SetFooterMargin(5);

        // set auto page breaks
        $pdf->SetAutoPageBreak(TRUE, 10);
		//$pdf->Image('C:\xampp\htdocs\humancenter_forms\application\views\examen\pie\hclogo.jpg', 15, 140, 75, 113, 'JPG', 'http://www.tcpdf.org', '', true, 150, '', false, false, 1, false, false, false);

        // set image scale factor
        $pdf->setImageScale(1);
		
        $pdf->setFontSubsetting(true);
        $pdf->SetFont('helvetica', '', 9);
       // $pdf->AddPage($tipo_pdf);
		$pdf->AddPage('P', 'letter');
		$pdf->Image($ruta, 35, 107, 150, 150, 'JPG', '', '', true, 200, '', false, false, 0, false, false, true); 
		//$pdf->Image($ruta, 35, 107, 105, 105, 'JPG', '', '', true, 200, '', false, false, 0, false, false, true); 
		//$pdf->Image('C:\xampp\htdocs\humancenter_forms\application\views\examen\pie\hclogo.jpg', 10, 55, 300, 300, 'JPG', '', '', true, 200, '', false, false, 0, false, false, true);       
		$pdf->setTextShadow(array('enabled'=>false, 'depth_w'=>0.2, 'depth_h'=>0.2, 'color'=>array(196,196,196), 'opacity'=>1, 'blend_mode'=>'Normal'));

        $pdf->writeHTML($html, true, 0, true, true);
        $pdf->lastPage();
        ob_end_clean();
        $pdf->Output($filename,'I');
    }
}
/************************************************************************************/


/************************************************************************************/
if (!function_exists('genera_pdf_lab_b')) {

    function genera_pdf_lab_b($html, $filename = '',$title='', $subject='',$obs='',$ruta, $author='Humancenter Review S.A de C.V.', $tipo_pdf = 'P') {
        $CI =& get_instance();

        // Llamada a la libreria TCPDF
        $CI->load->library('tcpdf/Tcpdf');

// Extend the TCPDF class to create custom Header and Footer
	class MYPDF extends TCPDF {

	public $laboratorista;
	public $observaciones;

    //Page header
    public function Header() {
        // Logo
        $image_file = K_PATH_IMAGES.'hclogo.jpg';
        $this->Image($image_file, 20, 82, 175, 175, 'JPG', '', 'T', false, 300, '', false, false, 0, false, false, false);
        // Set font
        //$this->SetFont('helvetica', 'B', 10);
        // Title
        //$this->Cell(0, 0, '<< TCPDF Example 003 >>', 0, false, 'C', 0, '', 0, false, 'M', 'M');
    }

    // Page footer
    // Page footer
    public function Footer() {
        // Position at 15 mm from bottom

        // Set font
         $this->SetFont('helvetica', 'B', 7);
		 $mueve=-53;
		 $this->SetY($mueve);
		 $this->Cell(0, 0,"OBSERVACIONES:");
		 $this->SetX(40);
		 $this->Cell(0, 0,$this->observaciones);
		 $mueve+=3;
		 $this->SetY($mueve);
		 $this->Cell(0, 0,"Lo(s) resultado(s) fuera de rango validado(s)");$mueve+=3;
		 $this->SetY($mueve);$mueve+=3;		 
		 $this->SetY($mueve);$mueve+=3;
		 $this->SetY($mueve);$mueve+=3;
		 $this->SetFont('helvetica', 'B', 7);
		 $this->Cell(0, 0,$this->laboratorista);
		 $this->SetY($mueve);$mueve+=3;
		 $this->Cell(0, 0,"Nota: Si existe dudas, todo valor será corroborado de los siguientes 3 días después de tomado el estudio.                                                                           ");
		 $mueve+=1;
		 $this->SetY($mueve);
		 $this->SetFont('helvetica', 'B', 8);
		 $this->SetLineStyle(array('width' => 0.5, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 77)));
		 $this->SetFillColor(0, 0, 77);
		 $this->Cell(0, 0,"",1, 1, 'L', 1, 0);
		 $mueve+=4;
		 $this->SetFont('helvetica', 'B', 7);
		 $this->SetY($mueve);
		 $this->Cell(0, 0,"Human Center Review S.A. de C.V.",  0, false, 'C', 0, '', 0, false, 'T', 'M');
		 $mueve+=3;
		 $this->SetY($mueve);
		 $this->Cell(0, 0,"Laboratorio Médico y de Diagnóstico del Sector Privado",  0, false, 'C', 0, '', 0, false, 'T', 'M');
		 $mueve+=3;		 
		 $this->SetY($mueve);
		 $this->Cell(0, 0,"Número de Registro COFEPRIS: 213300536X0279",  0, false, 'C', 0, '', 0, false, 'T', 'M');
		 $mueve+=3;		 
		 $this->SetY($mueve);		 
		 $this->Cell(0, 0,"San Borja 1365 Col. Vértiz Narvarte Alc. Benito Juárez C.P. 03600 Ciudad de México. Tel. 55-36-40-44-36  contacto@humancenter.com.mx",  0, false, 'C', 0, '', 0, false, 'T', 'M');
    }
}

	// create new PDF document
	$pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
	$pdf->laboratorista=$subject;
	$pdf->observaciones=$obs;


	// set document information
	$pdf->SetCreator(PDF_CREATOR);
	$pdf->SetAuthor($author);
	$pdf->SetTitle($title);
	$pdf->SetSubject($subject);
	$pdf->SetKeywords('TCPDF, PDF, RECETAS, HUMANCENTER, PLATAFORMA');

	// set default header data
	$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE, PDF_HEADER_STRING);

	// set header and footer fonts
	$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
	$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

	// set default monospaced font
	$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

	// set margins
	//$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
	//$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
	//$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

	$pdf->SetMargins(10, 10);
	$pdf->SetHeaderMargin(10);
	$pdf->SetFooterMargin(5);

	// set auto page breaks
	$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);


	//$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
	$pdf->setImageScale(1);
	$pdf->setFontSubsetting(true);
	// set font
	$pdf->SetFont('helvetica', '', 9);


	// set some language-dependent strings (optional)
	if (@file_exists(dirname(__FILE__).'/lang/eng.php')) {
		require_once(dirname(__FILE__).'/lang/eng.php');
		$pdf->setLanguageArray($l);
		}

	//$pdf->SetFont('times', 'BI', 12);

	// add a page
	$pdf->AddPage();
	$pdf->writeHTML($html, true, 0, true, true);
	$pdf->lastPage();
	ob_end_clean();
	$pdf->Output($filename,'I');
    }
}
/************************************************************************************/

/************************************************************************************/
if (!function_exists('genera_pdf_lab_new')) {

    function genera_pdf_lab_new($html, $filename = '',$title='', $subject='',$obs='', $fuera_rango='', $author='Humancenter Review S.A de C.V.', $tipo_pdf = 'P') {
        $CI =& get_instance();

        // Llamada a la libreria TCPDF
        $CI->load->library('tcpdf/Tcpdf');

// Extend the TCPDF class to create custom Header and Footer
	class MYPDF extends TCPDF {

	public $laboratorista;
	public $observaciones;
	public $fuera_rango;

    // Page footer
    public function Footer() {
        // Position at 15 mm from bottom

        // Set font
         $this->SetFont('helvetica', 'B', 8);
		 $mueve=-55;
		 $this->SetY($mueve);
		 $this->Cell(0, 0,"OBSERVACIONES:");
		 $this->SetX(40);
		  $this->Cell(0, 0,$this->observaciones);
		 $mueve+=3;
		 $this->SetY($mueve);
		 $this->SetX(40);
		 
		
		 
		 $mueve+=3;
		 $mueve+=3;
		 
		 $this->SetY($mueve);
		 $this->Cell(0, 0,"Lo(s) resultado(s) fuera de rango validado(s):");
		 $this->SetX(75);		 
		 $this->Cell(0, 0,$this->fuera_rango);		 
		 $mueve+=3;
		 $this->SetY($mueve);

		 //$mueve+=3;		 
		// $mueve+=3;
		 $this->SetY($mueve);$mueve+=3;		 
		 $this->SetY($mueve);$mueve+=3;
		 $this->SetY($mueve);$mueve+=3;
		 $this->SetY($mueve);$mueve+=3;
		 $this->SetY($mueve);$mueve+=3;
		 $this->SetY($mueve);$mueve+=3;
		 $this->SetY($mueve);$mueve+=3;
		 $this->SetFont('helvetica', 'B', 8);
		 $this->Cell(0, 0,$this->laboratorista);
		 $this->SetY($mueve);$mueve+=3;
		 $this->Cell(0, 0,"Si existe duda, todo valor será corroborado dentro de los 3 días después de realizado el estudio.                                                                           ");
		 $mueve+=1;
		 $this->SetY($mueve);
		 $this->SetFont('helvetica', 'B', 2);
//$this->SetLineStyle(array('width' => 0.0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(75,86,130)));
		 $this->SetFillColor(75,86,130);
		 $this->Cell(0, 0,"___________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________",  0, false, 'C', 0, '', 0, false, 'T', 'M');
		 $mueve+=1;
		 $this->SetFont('helvetica', 'B', 8);
		 $this->SetY($mueve);
		 $this->Cell(0, 0,"Human Center Review S.A. de C.V.",  0, false, 'C', 0, '', 0, false, 'T', 'M');
		 $mueve+=3;
		 $this->SetY($mueve);
		 $this->Cell(0, 0,"San Borja 1365 Col. Vértiz Narvarte Alc. Benito Juárez C.P. 03600 Ciudad de México. Tel. 55-36-40-44-36 ",  0, false, 'C', 0, '', 0, false, 'T', 'M');
    }
}


        // Crear Nuevo PDF
        $pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
		$pdf->laboratorista=$subject;
		$pdf->observaciones=$obs;
		
		if ($fuera_rango == '')
		{
			$pdf->fuera_rango='Ninguno';
		}	
		else
		{
			$pdf->fuera_rango=$fuera_rango;
		}	
		
        //info del PDF
        $pdf->SetCreator(PDF_CREATOR);
        $pdf->SetAuthor($author);
        $pdf->SetTitle($title);
        $pdf->SetSubject($subject);

        // Cabecera del PDF
        $pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE.' 001', PDF_HEADER_STRING, array(0,64,255), array(0,64,128));
        //$pdf->setFooterData(array(0,64,0), array(0,64,128));
        // set header and footer fonts
        $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
        $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
        $pdf->SetPrintHeader(false);
        // set default monospaced font
        //$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

        // set margins
        $pdf->SetMargins(10, 10);
        $pdf->SetHeaderMargin(1);
        $pdf->SetFooterMargin(5);

        // set auto page breaks
        $pdf->SetAutoPageBreak(TRUE, 10);
		//$pdf->Image('C:\xampp\htdocs\humancenter_forms\application\views\examen\pie\hclogo.jpg', 15, 140, 75, 113, 'JPG', 'http://www.tcpdf.org', '', true, 150, '', false, false, 1, false, false, false);
/****************************************************************/

// remove default header/footer
//$pdf->setPrintHeader(false);
//$pdf->setPrintFooter(false);

// set margins
//$pdf->SetMargins(0, 0, 0, true);

// set auto page breaks false
//$pdf->SetAutoPageBreak(false, 0);

// add a page
//$pdf->AddPage('P', 'A4');

// Display image on full page
//$pdf->Image('C:\xampp\htdocs\humancenter_forms\application\views\examen\pie\hclogo.jpg', 0, 0, 210, 297, 'JPG', '', '', true, 200, '', false, false, 0, false, false, true);

/*****************************************************************/
        // set image scale factor
        $pdf->setImageScale(1);
		
        $pdf->setFontSubsetting(true);
        $pdf->SetFont('helvetica', '', 9);
       // $pdf->AddPage($tipo_pdf);
		$pdf->AddPage('P', 'letter');
		//$pdf->Image('C:\xampp\htdocs\humancenter_forms\application\views\examen\pie\hclogo.jpg', 10, 55, 300, 300, 'JPG', '', '', true, 200, '', false, false, 0, false, false, true);       
		$pdf->setTextShadow(array('enabled'=>false, 'depth_w'=>0.2, 'depth_h'=>0.2, 'color'=>array(196,196,196), 'opacity'=>1, 'blend_mode'=>'Normal'));

        $pdf->writeHTML($html, true, 0, true, true);
        $pdf->lastPage();
        ob_end_clean();
        $pdf->Output($filename,'I');
    }
}
/************************************************************************************/
/************************************************************************************/
if (!function_exists('genera_pdf_rep_rec')) {

    function genera_pdf_rep_rec($html, $filename = '',$title='', $author='Humancenter Review S.A de C.V.', $tipo_pdf = 'L') {
        $CI =& get_instance();

        // Llamada a la libreria TCPDF
        $CI->load->library('tcpdf/Tcpdf');

// Extend the TCPDF class to create custom Header and Footer
	class MYPDF extends TCPDF {


    // Page footer
    public function Footer() {
        // Position at 15 mm from bottom

        // Set font
         $this->SetFont('helvetica', 'B', 8);
		 $mueve=-55;
		 $this->SetY($mueve);
		 $this->Cell(0, 0,"");
		 $this->SetX(40);
		 $this->Cell(0, 0,"");
		 $mueve+=3;
		 $this->SetY($mueve);
		 $this->SetX(40);		 
		 $mueve+=3;
		 $mueve+=3;		 
		 $this->SetY($mueve);
		 $this->Cell(0, 0,"");
		 $this->SetX(75);		 

		 $this->Cell(0, 0,"");		 
		 $mueve+=3;
		 $this->SetY($mueve);

		 //$mueve+=3;		 
		// $mueve+=3;
		 $this->SetY($mueve);$mueve+=3;		 
		 $this->SetY($mueve);$mueve+=3;
		 $this->SetY($mueve);$mueve+=3;
		 $this->SetY($mueve);$mueve+=3;
		 $this->SetY($mueve);$mueve+=3;
		 $this->SetY($mueve);$mueve+=3;
		 $this->SetY($mueve);$mueve+=3;
		 $this->SetFont('helvetica', 'B', 8);
		 $this->SetY($mueve);$mueve+=3;
		 $mueve+=1;
		 $this->SetY($mueve);
		 $this->SetFont('helvetica', 'B', 2);
//$this->SetLineStyle(array('width' => 0.0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(75,86,130)));
		 $this->SetFillColor(75,86,130);
		 $this->Cell(0, 0,"___________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________",  0, false, 'C', 0, '', 0, false, 'T', 'M');
		 $mueve+=1;
		 $this->SetFont('helvetica', 'B', 8);
		 $this->SetY($mueve);
		 $this->Cell(0, 0,"Human Center Review S.A. de C.V.",  0, false, 'C', 0, '', 0, false, 'T', 'M');
		 $mueve+=3;
		 $this->SetY($mueve);
		 $this->Cell(0, 0,"San Borja 1365 Col. Vértiz Narvarte Alc. Benito Juárez C.P. 03600 Ciudad de México. Tel. 55-36-40-44-36 ",  0, false, 'C', 0, '', 0, false, 'T', 'M');
    }
}


        // Crear Nuevo PDF
        $pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
		
        //info del PDF
        $pdf->SetCreator(PDF_CREATOR);
        $pdf->SetAuthor($author);
        $pdf->SetTitle($title);
        $pdf->SetSubject($subject);

        // Cabecera del PDF
        $pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE.' 001', PDF_HEADER_STRING, array(0,64,255), array(0,64,128));
        //$pdf->setFooterData(array(0,64,0), array(0,64,128));
        // set header and footer fonts
        $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
        $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
        $pdf->SetPrintHeader(false);
        // set default monospaced font
        //$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

        // set margins
        $pdf->SetMargins(10, 10);
        $pdf->SetHeaderMargin(1);
        $pdf->SetFooterMargin(5);

        // set auto page breaks
        $pdf->SetAutoPageBreak(TRUE, 10);
		//$pdf->Image('C:\xampp\htdocs\humancenter_forms\application\views\examen\pie\hclogo.jpg', 15, 140, 75, 113, 'JPG', 'http://www.tcpdf.org', '', true, 150, '', false, false, 1, false, false, false);
        // set image scale factor
        $pdf->setImageScale(1);
		
        $pdf->setFontSubsetting(true);
        $pdf->SetFont('helvetica', '', 9);
       // $pdf->AddPage($tipo_pdf);
		$pdf->AddPage('L', 'letter');
		//$pdf->Image('C:\xampp\htdocs\humancenter_forms\application\views\examen\pie\hclogo.jpg', 10, 55, 300, 300, 'JPG', '', '', true, 200, '', false, false, 0, false, false, true);       
		$pdf->setTextShadow(array('enabled'=>false, 'depth_w'=>0.2, 'depth_h'=>0.2, 'color'=>array(196,196,196), 'opacity'=>1, 'blend_mode'=>'Normal'));

        $pdf->writeHTML($html, true, 0, true, true);
        $pdf->lastPage();
        ob_end_clean();
        $pdf->Output($filename,'I');
    }
}
/************************************************************************************/



/************************************************************************************/
if (!function_exists('genera_pdf_lab_gral')) {

    function genera_pdf_lab_gral($html, $filename = '',$title='', $subject='',$obs='', $fuera_rango='', $author='Humancenter Review S.A de C.V.', $tipo_pdf = 'P') {
        $CI =& get_instance();

        // Llamada a la libreria TCPDF
        $CI->load->library('tcpdf/Tcpdf');

// Extend the TCPDF class to create custom Header and Footer
	class MYPDF extends TCPDF {

	public $laboratorista;
	public $observaciones;
	public $fuera_rango;

    // Page footer
    public function Footer() {
        // Position at 15 mm from bottom

        // Set font
         $this->SetFont('helvetica', 'B', 8);
		 $mueve=-55;
		 $this->SetY($mueve);
		// $this->Cell(0, 0,"OBSERVACIONES:");
		 $this->Cell(0, 0,"");
		 $this->SetX(40);
		 //$this->Cell(0, 0,$this->observaciones);
		 $this->Cell(0, 0,"");
		 $mueve+=3;
		 $this->SetY($mueve);
		 $this->SetX(40);		 
		 $mueve+=3;
		 $mueve+=3;		 
		 $this->SetY($mueve);
		 //$this->Cell(0, 0,"Lo(s) resultado(s) fuera de rango validado(s):");
		 $this->Cell(0, 0,"");
		 $this->SetX(75);		 
		 //$this->Cell(0, 0,$this->fuera_rango);	
		 $this->Cell(0, 0,"");		 
		 $mueve+=3;
		 $this->SetY($mueve);

		 //$mueve+=3;		 
		// $mueve+=3;
		 $this->SetY($mueve);$mueve+=3;		 
		 $this->SetY($mueve);$mueve+=3;
		 $this->SetY($mueve);$mueve+=3;
		 $this->SetY($mueve);$mueve+=3;
		 $this->SetY($mueve);$mueve+=3;
		 $this->SetY($mueve);$mueve+=3;
		 $this->SetY($mueve);$mueve+=3;
		 $this->SetFont('helvetica', 'B', 8);
		 $this->Cell(0, 0,$this->laboratorista);
		 $this->SetY($mueve);$mueve+=3;
		 $this->Cell(0, 0,"Si existe duda, todo valor será corroborado dentro de los 3 días después de realizado el estudio.                                                                           ");
		 $mueve+=1;
		 $this->SetY($mueve);
		 $this->SetFont('helvetica', 'B', 2);
//$this->SetLineStyle(array('width' => 0.0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(75,86,130)));
		 $this->SetFillColor(75,86,130);
		 $this->Cell(0, 0,"___________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________",  0, false, 'C', 0, '', 0, false, 'T', 'M');
		 $mueve+=1;
		 $this->SetFont('helvetica', 'B', 8);
		 $this->SetY($mueve);
		 $this->Cell(0, 0,"Human Center Review S.A. de C.V.",  0, false, 'C', 0, '', 0, false, 'T', 'M');
		 $mueve+=3;
		 $this->SetY($mueve);
		 $this->Cell(0, 0,"San Borja 1365 Col. Vértiz Narvarte Alc. Benito Juárez C.P. 03600 Ciudad de México. Tel. 55-36-40-44-36 ",  0, false, 'C', 0, '', 0, false, 'T', 'M');
    }
}


        // Crear Nuevo PDF
        $pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
		$pdf->laboratorista=$subject;
		$pdf->observaciones=$obs;
		
		if ($fuera_rango == '')
		{
			$pdf->fuera_rango='Ninguno';
		}	
		else
		{
			$pdf->fuera_rango=$fuera_rango;
		}	
		
        //info del PDF
        $pdf->SetCreator(PDF_CREATOR);
        $pdf->SetAuthor($author);
        $pdf->SetTitle($title);
        $pdf->SetSubject($subject);

        // Cabecera del PDF
        $pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE.' 001', PDF_HEADER_STRING, array(0,64,255), array(0,64,128));
        //$pdf->setFooterData(array(0,64,0), array(0,64,128));
        // set header and footer fonts
        $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
        $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
        $pdf->SetPrintHeader(false);
        // set default monospaced font
        //$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

        // set margins
        $pdf->SetMargins(10, 10);
        $pdf->SetHeaderMargin(1);
        $pdf->SetFooterMargin(5);

        // set auto page breaks
        $pdf->SetAutoPageBreak(TRUE, 10);
		//$pdf->Image('C:\xampp\htdocs\humancenter_forms\application\views\examen\pie\hclogo.jpg', 15, 140, 75, 113, 'JPG', 'http://www.tcpdf.org', '', true, 150, '', false, false, 1, false, false, false);
        // set image scale factor
        $pdf->setImageScale(1);
		
        $pdf->setFontSubsetting(true);
        $pdf->SetFont('helvetica', '', 9);
       // $pdf->AddPage($tipo_pdf);
		$pdf->AddPage('P', 'letter');
		//$pdf->Image('C:\xampp\htdocs\humancenter_forms\application\views\examen\pie\hclogo.jpg', 10, 55, 300, 300, 'JPG', '', '', true, 200, '', false, false, 0, false, false, true);       
		$pdf->setTextShadow(array('enabled'=>false, 'depth_w'=>0.2, 'depth_h'=>0.2, 'color'=>array(196,196,196), 'opacity'=>1, 'blend_mode'=>'Normal'));

        $pdf->writeHTML($html, true, 0, true, true);
        $pdf->lastPage();
        ob_end_clean();
        $pdf->Output($filename,'I');
    }
}
/************************************************************************************/
if (!function_exists('genera_pdf_lab_new_l')) {

    function genera_pdf_lab_new_l($html, $filename = '', $title = '', $subject = '', $obs = '', $author = 'Humancenter Review S.A de C.V.', $tipo_pdf = 'P', $ruta)
    {
        $CI = &get_instance();

        // Llamada a la libreria TCPDF
        $CI->load->library('tcpdf/Tcpdf');


        // Extend the TCPDF class to create custom Header and Footer
        class MYPDF extends TCPDF
        {

            public $laboratorista;
            public $observaciones;

            public function Header()
            {
                // Select Arial bold 15
                //$imagen = $this->Image('C:\xampp\htdocs\humancenter_forms\dist\images\hclogo.jpg', 35, 90, 140, 150, 'JPG', '', '', true, 400, '', false, false, 0, false, false, true);
            }
            // Page footer
            public function Footer()
            {
                // Position at 15 mm from bottom

                // Set font
                // $this->Image('C:\xampp\htdocs\humancenter_forms\dist\images\hclogo.jpg', 35, 90, 140, 150, 'JPG', '', '', true, 400, '', false, false, 0, false, false, true);
                $this->SetFont('helvetica', 'B', 7);
                $mueve = -53;
                $this->SetY($mueve);
                $this->Cell(0, 0, "OBSERVACIONES:");
                $this->SetX(40);
                $this->Cell(0, 0, $this->observaciones);
                $mueve += 3;
                $this->SetY($mueve);
                $this->Cell(0, 0, "Lo(s) resultado(s) fuera de rango validado(s)");
                $mueve += 3;
                $this->SetY($mueve);
                $mueve += 3;
                $this->SetY($mueve);
                $mueve += 3;
                $this->SetY($mueve);
                $mueve += 3;
                $this->SetFont('helvetica', 'B', 7);
                $this->Cell(0, 0, $this->laboratorista);
                $this->SetY($mueve);
                $mueve += 3;
                $this->Cell(0, 0, "Nota: Si existe dudas, todo valor será corroborado de los siguientes 3 días después de tomado el estudio.                                                                           ");
                $mueve += 1;
                $this->SetY($mueve);
                $this->SetFont('helvetica', 'B', 8);
                $this->SetLineStyle(array('width' => 0.5, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 77)));
                $this->SetFillColor(0, 0, 77);
                $this->Cell(0, 0, "", 1, 1, 'L', 1, 0);
                $mueve += 4;
                $this->SetFont('helvetica', 'B', 7);
                $this->SetY($mueve);
                $this->Cell(0, 0, "Human Center Review S.A. de C.V.",  0, false, 'C', 0, '', 0, false, 'T', 'M');
                $mueve += 3;
                $this->SetY($mueve);
                $this->Cell(0, 0, "San Borja 1365 Col. Vértiz Narvarte Alc. Benito Juárez C.P. 03600 Ciudad de México. Tel. 55-36-40-44-36 ",  0, false, 'C', 0, '', 0, false, 'T', 'M');
                $this->SetX(-15);
                //$this->AliasNbPages();
                //$this->AliasNbPages('{totalPages}');
                //$this->Cell(0, 5, $this->PageNo() . "/{totalPages}", 0, 1);
                $this->Write(5, $this->PageNo());
                $ruta;
                //$this->Write(5, $this->PageNo().'/{nb}');
                // $this->Image('C:\xampp\htdocs\humancenter_forms\dist\images\hclogo.jpg', 35, 90, 140, 150, 'JPG', '', '', true, 400, '', false, false, 0, false, false, true);

            }
        }


        // Crear Nuevo PDF
        $pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
        $pdf->laboratorista = $subject;
        $pdf->observaciones = $obs;
        //$pdf->AliasNbPages();
        //info del PDF
        $pdf->SetCreator(PDF_CREATOR);
        $pdf->SetAuthor($author);
        $pdf->SetTitle($title);
        $pdf->SetSubject($subject);

        // Cabecera del PDF
        $pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE . ' 001', PDF_HEADER_STRING, array(0, 64, 255), array(0, 64, 128));
        //$pdf->setFooterData(array(0,64,0), array(0,64,128));
        // set header and footer fonts
        $pdf->setHeaderFont(array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
        $pdf->setFooterFont(array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
        $pdf->SetPrintHeader(false);
        // set default monospaced font
        //$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

        // set margins
        $pdf->SetMargins(10, 10);
        $pdf->SetHeaderMargin(1);
        $pdf->SetFooterMargin(5);

        // set auto page breaks
        $pdf->SetAutoPageBreak(TRUE, 10);
        // $pdf->Image('C:\xampp\htdocs\humancenter_forms\dist\images\hclogo.jpg', 35, 90, 140, 150, 'JPG', '', '', true, 400, '', false, false, 0, false, false, true);
        //$pdf->Image('C:\xampp\htdocs\humancenter_forms\application\views\examen\pie\hclogo.jpg', 15, 140, 75, 113, 'JPG', 'http://www.tcpdf.org', '', true, 150, '', false, false, 1, false, false, false);
        /****************************************************************/

        // remove default header/footer
        //$pdf->setPrintHeader(false);
        //$pdf->setPrintFooter(false);

        // set margins
        //$pdf->SetMargins(0, 0, 0, true);

        // set auto page breaks false
        //$pdf->SetAutoPageBreak(false, 0);

        // add a page
        //$pdf->AddPage('P', 'A4');

        // Display image on full page
        //$pdf->Image('C:\xampp\htdocs\humancenter_forms\application\views\examen\pie\hclogo.jpg', 0, 0, 210, 297, 'JPG', '', '', true, 200, '', false, false, 0, false, false, true);

        /*****************************************************************/
        // set image scale factor
        $pdf->setImageScale(1);

        $pdf->setFontSubsetting(true);
        $pdf->SetFont('helvetica', '', 9);
        //$pdf->AddPage($tipo_pdf);
        //$pdf->AliasNbPages();
        $pdf->AddPage('P', 'letter');

        //$pdf->Image('C:\xampp\htdocs\humancenter_forms\dist\images\hclogo.jpg', 35, 90, 140, 150, 'JPG', '', '', true, 400, '', false, false, 0, false, false, true); 

        //$pdf->Image('C:\xampp\htdocs\humancenter_forms\dist\images\hclogo.jpg', 35, 90, 140, 150, 'JPG', '', '', true, 400, '', false, false, 0, false, false, true); 


        //$pdf->Image($ruta, 60, 20, 100, 100, 'JPG', '', '', true, 200, '', false, false, 0, false, false, true);

        //$pdf->Image('C:\xampp\htdocs\humancenter_forms\dist\images\hclogo.jpg', 35, 90, 140, 150, 'JPG', '', '', true, 400, '', false, false, 0, false, false, true);       
        $pdf->setTextShadow(array('enabled' => false, 'depth_w' => 0.2, 'depth_h' => 0.2, 'color' => array(196, 196, 196), 'opacity' => 1, 'blend_mode' => 'Normal'));

        $pdf->writeHTML($html, true, 0, true, true);

        $pdf->lastPage();
        ob_end_clean();
        $pdf->Output($filename, 'I');
    }
}





/************************************************************************************/
if (!function_exists('genera_pdf_lab')) {

    function genera_pdf_lab($html, $filename = '',$title='', $subject='', $author='Humancenter Review S.A de C.V.', $tipo_pdf = 'P') {
        $CI =& get_instance();

        // Llamada a la libreria TCPDF
        $CI->load->library('tcpdf/Tcpdf');

// Extend the TCPDF class to create custom Header and Footer
	class MYPDF extends TCPDF {

	public $laboratorista;

    // Page footer
    public function Footer() {
        // Position at 15 mm from bottom

        // Set font
         $this->SetFont('helvetica', 'B', 8);
		 $mueve=-43;
		 $this->SetY($mueve);
		 //$this->Cell(0, 0,"RESPONSABLE:");$mueve+=3;
		 $this->SetY($mueve);
		 //$this->Cell(0, 0,"Q.F.B. JAIMES FLORES MONTSERRAT    11322160                                                                                                                        No. Reg SSP: 009-19");
		 //$this->Cell(0, 0,"Q.F.B. JAIMES FLORES MONTSERRAT    11322160                                                                                                                        ");
		 $this->Cell(0, 0,$this->laboratorista);
		 $mueve+=4;
		 $this->SetY($mueve);
		 $this->SetFont('helvetica', 'B', 8);
		 //$this->SetLineStyle(array('width' => 0.5, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(61, 85, 136)));
		 $this->SetLineStyle(array('width' => 0.5, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 77)));
		 //$this->SetFillColor(61, 85, 136);
		 $this->SetFillColor(0, 0, 77);
		 $this->Cell(0, 0,"",1, 1, 'L', 1, 0);
		 $mueve+=4;
		 $this->SetFont('helvetica', 'B', 8);
		 $this->SetY($mueve);
		 //$this->Cell(0, 0,"Nota: Para validar resultados, se tendrá 3 días posteriores a la aplicación de la evaluación.                                                                           FGP06");
		 $this->Cell(0, 0,"Nota: Para validar resultados, se tendrá 3 días posteriores a la aplicación de la evaluación.                                                                           ");
		 $mueve+=3;
		 $this->SetY($mueve);
		 $this->Cell(0, 0,"Human Center Review S.A. de C.V.",  0, false, 'C', 0, '', 0, false, 'T', 'M');
		 $mueve+=3;
		 $this->SetY($mueve);
		 $this->Cell(0, 0,"San Borja 1365 Col. Vértiz Narvarte Del. Benito Juárez C.P. 03600 Ciudad de México. Tel. 55-36-40-44-36 ",  0, false, 'C', 0, '', 0, false, 'T', 'M');
    }
}


        // Crear Nuevo PDF
        $pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
		$pdf->laboratorista=$subject;
        //info del PDF
        $pdf->SetCreator(PDF_CREATOR);
        $pdf->SetAuthor($author);
        $pdf->SetTitle($title);
        $pdf->SetSubject($subject);

        // Cabecera del PDF
        $pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE.' 001', PDF_HEADER_STRING, array(0,64,255), array(0,64,128));
        //$pdf->setFooterData(array(0,64,0), array(0,64,128));
        // set header and footer fonts
        $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
        $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
        $pdf->SetPrintHeader(false);
        // set default monospaced font
        //$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

        // set margins
        $pdf->SetMargins(10, 10);
        $pdf->SetHeaderMargin(1);
        $pdf->SetFooterMargin(5);

        // set auto page breaks
        $pdf->SetAutoPageBreak(TRUE, 10);



        // set image scale factor
        $pdf->setImageScale(1);
        $pdf->setFontSubsetting(true);
        $pdf->SetFont('helvetica', '', 9);
        $pdf->AddPage($tipo_pdf);
        $pdf->setTextShadow(array('enabled'=>false, 'depth_w'=>0.2, 'depth_h'=>0.2, 'color'=>array(196,196,196), 'opacity'=>1, 'blend_mode'=>'Normal'));

        $pdf->writeHTML($html, true, 0, true, true);
        $pdf->lastPage();
        ob_end_clean();
        $pdf->Output($filename,'I');
    }
}
/************************************************************************************/
if (!function_exists('genera_pdf_tohuanti2')) {

    function genera_pdf_tohuanti2($html, $filename = '',$title='', $subject='', $author='Humancenter Review S.A de C.V.', $tipo_pdf = 'P') {
        $CI =& get_instance();

        // Llamada a la libreria TCPDF
        $CI->load->library('tcpdf/Tcpdf');

// Extend the TCPDF class to create custom Header and Footer
	class MYPDF extends TCPDF {

    // Page footer
    public function Footer() {
        // Position at 15 mm from bottom

        // Set font
         $this->SetFont('helvetica', 'B', 8);
		 $mueve=-43;
		 $this->SetY($mueve);
		 $this->Cell(0, 0,"RESPONSABLE:");$mueve+=3;
		 $this->SetY($mueve);
			$this->Cell(0, 0,"Q.F.B. MUÑOZ GARCÍA LETICIA        1392938                                                                                                                         ");
		// $this->Cell(0, 0,"Quím. ALEJANDRA SANCHEZ GUTIERREZ  10629800                                                                                                                        No. Reg SSP: 009-19");
		 $mueve+=4;
		 $this->SetY($mueve);
		 $this->SetFont('helvetica', 'B', 8);
		 $this->SetY($mueve);
		 //$this->Cell(0, 0,"Nota: Para validar resultados, se tendrá 3 días posteriores a la aplicación de la evaluación.                                                                           FGP06");
		 $this->Cell(0, 0,"Nota: Para validar resultados, se tendrá 3 días posteriores a la aplicación de la evaluación.                                                                          FGP06");
		 //$this->SetLineStyle(array('width' => 0.5, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(61, 85, 136)));
		 $mueve+=4;
		 $this->SetY($mueve);		
		$this->SetLineStyle(array('width' => 0.5, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 77)));
		 //$this->SetFillColor(61, 85, 136);
		 $this->SetFillColor(0, 0, 77);
		 $this->Cell(0, 0,"",1, 1, 'L', 1, 0);
		 //$mueve+=4;
		 $this->SetFont('helvetica', 'B', 8);
		 //$this->SetY($mueve);
		 //$this->Cell(0, 0,"Nota: Para validar resultados, se tendrá 3 días posteriores a la aplicación de la evaluación.                                                                           FGP06");
		 //$this->Cell(0, 0,"Nota: Para validar resultados, se tendrá 3 días posteriores a la aplicación de la evaluación.                                                                           ");
		 $mueve+=4;
		 $this->SetY($mueve);
		 $this->Cell(0, 0,"Human Center Review S.A. de C.V.",  0, false, 'C', 0, '', 0, false, 'T', 'M');
		 $mueve+=3;
		 $this->SetY($mueve);
		 $this->Cell(0, 0,"San Borja 1365 Col. Vértiz Narvarte Del. Benito Juárez C.P. 03600 Ciudad de México. Tel. 01-55-36-40-44-36 ",  0, false, 'C', 0, '', 0, false, 'T', 'M');
    }
}


        // Crear Nuevo PDF
        $pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

        //info del PDF
        $pdf->SetCreator(PDF_CREATOR);
        $pdf->SetAuthor($author);
        $pdf->SetTitle($title);
        $pdf->SetSubject($subject);

        // Cabecera del PDF
        $pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE.' 001', PDF_HEADER_STRING, array(0,64,255), array(0,64,128));
        //$pdf->setFooterData(array(0,64,0), array(0,64,128));
        // set header and footer fonts
        $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
        $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
        $pdf->SetPrintHeader(false);
        // set default monospaced font
        //$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

        // set margins
        $pdf->SetMargins(10, 10);
        $pdf->SetHeaderMargin(1);
        $pdf->SetFooterMargin(5);

        // set auto page breaks
        $pdf->SetAutoPageBreak(TRUE, 10);



        // set image scale factor
        $pdf->setImageScale(1);
        $pdf->setFontSubsetting(true);
        $pdf->SetFont('helvetica', '', 9);
        $pdf->AddPage($tipo_pdf);
        $pdf->setTextShadow(array('enabled'=>false, 'depth_w'=>0.2, 'depth_h'=>0.2, 'color'=>array(196,196,196), 'opacity'=>1, 'blend_mode'=>'Normal'));

        $pdf->writeHTML($html, true, 0, true, true);
        $pdf->lastPage();
        ob_end_clean();
        $pdf->Output($filename,'I');
    }
}
/*********************************************************************************/
/************************************************************************************/
if (!function_exists('genera_pdf_tohuanti')) {

    function genera_pdf_tohuanti($html, $filename = '',$title='', $subject='', $author='Humancenter Review S.A de C.V.', $tipo_pdf = 'P') {
        $CI =& get_instance();

        // Llamada a la libreria TCPDF
        $CI->load->library('tcpdf/Tcpdf');

// Extend the TCPDF class to create custom Header and Footer
	class MYPDF extends TCPDF {

    // Page footer
    public function Footer() {
        // Position at 15 mm from bottom

        // Set font
         $this->SetFont('helvetica', 'B', 8);
		 $mueve=-43;
		 $this->SetY($mueve);
		 //$this->Cell(0, 0,"RESPONSABLE:");$mueve+=3;
		 $this->SetY($mueve);
		 $this->Cell(0, 0,"Q.F.B. MUÑOZ GARCÍA LETICIA        1392938                                                                                                                      ");
	     //$this->Cell(0, 0,"Q.F.B. JAIMES FLORES MONTSERRAT    11322160                                                                                                                        No. Reg SSP: 009-19");
		 //$this->Cell(0, 0,"Quím. ALEJANDRA SANCHEZ GUTIERREZ  10629800                                                                                                                        ");
		 $mueve+=4;
		 $this->SetY($mueve);
		 $this->SetFont('helvetica', 'B', 8);
		 //$this->SetLineStyle(array('width' => 0.5, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(61, 85, 136)));
		 $this->SetLineStyle(array('width' => 0.5, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 77)));
		 //$this->SetFillColor(61, 85, 136);
		 $this->SetFillColor(0, 0, 77);
		 $this->Cell(0, 0,"",1, 1, 'L', 1, 0);
		 $mueve+=4;
		 $this->SetFont('helvetica', 'B', 8);
		 $this->SetY($mueve);
		 //$this->Cell(0, 0,"Nota: Para validar resultados, se tendrá 3 días posteriores a la aplicación de la evaluación.                                                                           FGP06");
		 $this->Cell(0, 0,"Nota: Para validar resultados, se tendrá 3 días posteriores a la aplicación de la evaluación.                                                                           ");
		 $mueve+=3;
		 $this->SetY($mueve);
		 $this->Cell(0, 0,"Human Center Review S.A. de C.V.",  0, false, 'C', 0, '', 0, false, 'T', 'M');
		 $mueve+=3;
		 $this->SetY($mueve);
		 $this->Cell(0, 0,"San Borja 1365 Col. Vértiz Narvarte Del. Benito Juárez C.P. 03600 Ciudad de México. Tel. 55-36-40-44-36 ",  0, false, 'C', 0, '', 0, false, 'T', 'M');
    }
}


        // Crear Nuevo PDF
        $pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

        //info del PDF
        $pdf->SetCreator(PDF_CREATOR);
        $pdf->SetAuthor($author);
        $pdf->SetTitle($title);
        $pdf->SetSubject($subject);

        // Cabecera del PDF
        $pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE.' 001', PDF_HEADER_STRING, array(0,64,255), array(0,64,128));
        //$pdf->setFooterData(array(0,64,0), array(0,64,128));
        // set header and footer fonts
        $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
        $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
        $pdf->SetPrintHeader(false);
        // set default monospaced font
        //$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

        // set margins
        $pdf->SetMargins(10, 10);
        $pdf->SetHeaderMargin(1);
        $pdf->SetFooterMargin(5);

        // set auto page breaks
        $pdf->SetAutoPageBreak(TRUE, 10);



        // set image scale factor
        $pdf->setImageScale(1);
        $pdf->setFontSubsetting(true);
        $pdf->SetFont('helvetica', '', 9);
        $pdf->AddPage($tipo_pdf);
        $pdf->setTextShadow(array('enabled'=>false, 'depth_w'=>0.2, 'depth_h'=>0.2, 'color'=>array(196,196,196), 'opacity'=>1, 'blend_mode'=>'Normal'));

        $pdf->writeHTML($html, true, 0, true, true);
        $pdf->lastPage();
        ob_end_clean();
        $pdf->Output($filename,'I');
    }
}
/*********************************************************************************/
if (!function_exists('genera_pdf_tohuanti_odo')) {

    function genera_pdf_tohuanti_odo($html, $filename = '',$title='', $subject='', $author='Humancenter Review S.A de C.V.', $tipo_pdf = 'P') {
        $CI =& get_instance();

        // Llamada a la libreria TCPDF
        $CI->load->library('tcpdf/Tcpdf'); 

// Extend the TCPDF class to create custom Header and Footer
	class MYPDF extends TCPDF {

    // Page footer
    public function Footer() {
        // Position at 15 mm from bottom

        // Set font
        // $this->SetTextColorArray($this->footer_text_color);
		 $this->SetFont('helvetica', 'B', 9);
		 $mueve=-45; //-43;
		 $this->SetY($mueve);
		 $this->Cell(0, 0,"                                                                                                                                                                                  FOD-01",  0, false, 'C', 0, '', 0, false, 'T', 'M');
		 $mueve+=5;
         $this->SetTextColorArray($this->footer_text_color);
		 $this->SetFont('helvetica', 'B', 7);		
		 $this->SetY($mueve);
		 $this->Cell(0, 0,"Esta historia está basada en la NOM-004-SSA3-2012, Del expediente clínico, NOM-013-SSA2-2015, Para la prevención y control de enfermedades",  0, false, 'C', 0, '', 0, false, 'T', 'M');
		 $mueve+=3;
		 $this->SetY($mueve);
		 $this->Cell(0, 0,"bucales, y retoma conceptos y criterio de la OMS",  0, false, 'C', 0, '', 0, false, 'T', 'M');
		/*
		 $mueve+=3;
		 $this->SetY($mueve);
		 $this->Cell(0, 0,"Realizado por el cirujano Dentista Guerrero Vergara José Armando No. de cdelula 9719648",  0, false, 'C', 0, '', 0, false, 'T', 'M');
		*/
		$mueve+=3;
		 $this->SetY($mueve);
		 $this->Cell(0, 0,"Human Center Review S.A. de C.V.",  0, false, 'C', 0, '', 0, false, 'T', 'M');
		 $mueve+=3;
		 $this->SetY($mueve);
		 $this->Cell(0, 0,"4 San Borja 1365 Col. Vértiz Narvarte Del. Benito Juárez C.P. 03600 Ciudad de México. Tel. 01-55-36-40-44-36 ",  0, false, 'C', 0, '', 0, false, 'T', 'M');
    }
}


        // Crear Nuevo PDF
        $pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

        //info del PDF
        $pdf->SetCreator(PDF_CREATOR);
        $pdf->SetAuthor($author);
        $pdf->SetTitle($title);
        $pdf->SetSubject($subject);

        // Cabecera del PDF
        $pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE.' 001', PDF_HEADER_STRING, array(0,64,255), array(0,64,128));
        //$pdf->setFooterData(array(0,64,0), array(0,64,128));
        // set header and footer fonts
        $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
        $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
        $pdf->SetPrintHeader(false);
        // set default monospaced font
        //$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

        // set margins
        $pdf->SetMargins(10, 10);
        $pdf->SetHeaderMargin(1);
        $pdf->SetFooterMargin(5);

        // set auto page breaks
        $pdf->SetAutoPageBreak(TRUE, 10);
		
        // set image scale factor
        $pdf->setImageScale(1);
        $pdf->setFontSubsetting(true);
        $pdf->SetFont('helvetica', '', 9);
        $pdf->AddPage($tipo_pdf);
        $pdf->setTextShadow(array('enabled'=>false, 'depth_w'=>0.2, 'depth_h'=>0.2, 'color'=>array(196,196,196), 'opacity'=>1, 'blend_mode'=>'Normal'));

        $pdf->writeHTML($html, true, 0, true, true);
        $pdf->lastPage();
        ob_end_clean();
        $pdf->Output($filename,'I');
    }
}
/*********************************************************************************/
/*********************************************************************************/
if (!function_exists(' ')) {

    function genera_pdf_mkw($html, $filename = '',$title='', $subject='', $author='Humancenter Review S.A de C.V.', $tipo_pdf = 'P') {
        $CI =& get_instance();

        // Llamada a la libreria TCPDF
        $CI->load->library('tcpdf/Tcpdf'); 

// Extend the TCPDF class to create custom Header and Footer
	class MYPDF extends TCPDF {
	public $imagenwm;
	
	// Page head
    public function Header() {
        // get the current page break margin
        $bMargin = $this->getBreakMargin();
        // get current auto-page-break mode
        $auto_page_break = $this->AutoPageBreak;
        // disable auto-page-break
        $this->SetAutoPageBreak(false, 0);
        // set bacground image
        //$img_file = $this->$imagenwm;//K_PATH_IMAGES.'image_demo.jpg';
        $this->Image('http://localhost/humancenter_forms/index.php/../dist/images/persona.png', 0, 0, 210, 297, '', '', '', false, 300, '', false, false, 0);
        // restore auto-page-break status
        $this->SetAutoPageBreak($auto_page_break, $bMargin);
        // set the starting point for the page content
        $this->setPageMark();
    }

    // Page footer
    public function Footer() {
        // Position at 15 mm from bottom

        // Set font
         /*$this->SetTextColorArray($this->footer_text_color);
		 $this->SetFont('helvetica', 'B', 7);
		 $mueve=-43;
		 $this->SetY($mueve);
		 $this->Cell(0, 0,"Esta historia está basada en la NOM-004-SSA3-2012, Del expediente clínico, NOM-013-SSA2-2015, Para la prevención y control de enfermedades",  0, false, 'C', 0, '', 0, false, 'T', 'M');
		 $mueve+=3;
		 $this->SetY($mueve);
		 $this->Cell(0, 0,"bucales, y retoma conceptos y criterio de la OMS",  0, false, 'C', 0, '', 0, false, 'T', 'M');
		 $mueve+=3;
		 $this->SetY($mueve);
		 $this->Cell(0, 0,"Realizado por el cirujano Dentista Guerrero Vergara José Armando No. de cdelula 9719648",  0, false, 'C', 0, '', 0, false, 'T', 'M');
		 $mueve+=3;
		 $this->SetY($mueve);
		 $this->Cell(0, 0,"Human Center Review S.A. de C.V.",  0, false, 'C', 0, '', 0, false, 'T', 'M');
		 $mueve+=3;
		 $this->SetY($mueve);
		 $this->Cell(0, 0,"San Borja 1365 Col. Vértiz Narvarte Del. Benito Juárez C.P. 03600 Ciudad de México. Tel. 01-55-36-40-44-36 ",  0, false, 'C', 0, '', 0, false, 'T', 'M');*/
    }
	
	
	
}


        // Crear Nuevo PDF
        $pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
		$pdf->$imagenwm=$subject;
 // set default monospaced font
$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

// set margins
$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
$pdf->SetHeaderMargin(0);
$pdf->SetFooterMargin(0);

// remove default footer
$pdf->setPrintFooter(false);

// set auto page breaks
$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

// set image scale factor
$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

// set some language-dependent strings (optional)
if (@file_exists(dirname(__FILE__).'/lang/eng.php')) {
    require_once(dirname(__FILE__).'/lang/eng.php');
    $pdf->setLanguageArray($l);
}

// ---------------------------------------------------------

// set font
$pdf->SetFont('times', '', 48);

// add a page
$pdf->AddPage();

        $pdf->writeHTML($html, true, 0, true, true);
      //  $pdf->lastPage();
       // ob_end_clean();
        $pdf->Output($filename,'I');
    }
}
/*********************************************************************************/
if (!function_exists('genera_pdf_tohuanti_hc_gsi')) {

    function genera_pdf_tohuanti_hc_gsi($html, $filename = '',$title='', $subject='', $author='Humancenter Review S.A de C.V.', $tipo_pdf = 'P') {
        $CI =& get_instance();

        // Llamada a la libreria TCPDF
        $CI->load->library('tcpdf/Tcpdf');

// Extend the TCPDF class to create custom Header and Footer
	class MYPDF extends TCPDF {

    // Page footer
   public function Footer() {
        // Position at 15 mm from bottom
         $this->SetFont('times', 'B', 10);
		 $mueve=-55;
		 $mueve+=3;
		 $mueve+=3;


		 $mueve+=4;
		 $this->SetFont('times', '', 10);
		 $this->SetY($mueve);
		 $mueve+=3;
		 $this->SetY($mueve);
		 $this->SetY(-15);
         $this->Cell(0, 10, '                   V02                                                                                                                                                                                             '.$this->getAliasNumPage().'/'.$this->getAliasNbPages(), 0, false, 'C', 0, '', 0, false, 'T', 'M');
    }
}


        // Crear Nuevo PDF
        $pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

        //info del PDF
        $pdf->SetCreator(PDF_CREATOR);
        $pdf->SetAuthor($author);
        $pdf->SetTitle($title);
        $pdf->SetSubject($subject);

        // Cabecera del PDF
        $pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE.' 001', PDF_HEADER_STRING, array(0,64,255), array(0,64,128));
        //$pdf->setFooterData(array(0,64,0), array(0,64,128));
        // set header and footer fonts
        $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
        $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
        $pdf->SetPrintHeader(false);
        // set default monospaced font
        //$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

        // set margins original
        /*$pdf->SetMargins(10, 10);
        $pdf->SetHeaderMargin(1);
        $pdf->SetFooterMargin(5);*/

        // set margins
        $pdf->SetMargins(6, 0,6,2);
        $pdf->SetHeaderMargin(1);
        $pdf->SetFooterMargin(0);


        // set auto page breaks
        $pdf->SetAutoPageBreak(TRUE, 10);

        // set image scale factor
        $pdf->setImageScale(1);
        $pdf->setFontSubsetting(true);
        //$pdf->SetFont('helvetica', '', 9);
		$pdf->SetFont('helvetica', '', 9.5);
        $pdf->AddPage($tipo_pdf);
        $pdf->setTextShadow(array('enabled'=>false, 'depth_w'=>0.2, 'depth_h'=>0.2, 'color'=>array(196,196,196), 'opacity'=>1, 'blend_mode'=>'Normal'));

        $pdf->writeHTML($html, true, 0, true, true);
        $pdf->lastPage();
        ob_end_clean();
        $pdf->Output($filename,'I');
    }
}

/*********************************************************************************/

if (!function_exists('genera_pdf_tohuanti_hm')) {

    function genera_pdf_tohuanti_hm($html, $filename = '',$title='', $subject='', $author='Humancenter Review S.A de C.V.', $tipo_pdf = 'P') {
        $CI =& get_instance();

        // Llamada a la libreria TCPDF
        $CI->load->library('tcpdf/Tcpdf');

// Extend the TCPDF class to create custom Header and Footer
	class MYPDF extends TCPDF {

    // Page footer
    public function Footer() {
        // Position at 15 mm from bottom

        // Set font
        /* $this->SetFont('helvetica', 'B', 7);
		 $mueve=-12;
		 $this->SetY($mueve);
		 $this->Cell(0, 0,"Laboratorio Human Center Review S.A. de C.V.",  0, false, 'C', 0, '', 0, false, 'T', 'M');
		 $mueve+=2;
		 $this->SetY($mueve);
		 $this->Cell(0, 0,"San Borja 1365 Col. Vértiz Narvarte Del. Benito Juárez C.P. 03600 Ciudad de México. Tel. 01-55-56-03-44-43 ",  0, false, 'C', 0, '', 0, false, 'T', 'M');*/
    }
}


        // Crear Nuevo PDF
        $pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

        //info del PDF
        $pdf->SetCreator(PDF_CREATOR);
        $pdf->SetAuthor($author);
        $pdf->SetTitle($title);
        $pdf->SetSubject($subject);

        // Cabecera del PDF
        $pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE.' 001', PDF_HEADER_STRING, array(0,64,255), array(0,64,128));
        //$pdf->setFooterData(array(0,64,0), array(0,64,128));
        // set header and footer fonts
        $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
        $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
        $pdf->SetPrintHeader(false);
        // set default monospaced font
        //$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

        // set margins original
        /*$pdf->SetMargins(10, 10);
        $pdf->SetHeaderMargin(1);
        $pdf->SetFooterMargin(5);*/

        // set margins
        $pdf->SetMargins(6, 0,6,2);
        $pdf->SetHeaderMargin(1);
        $pdf->SetFooterMargin(0);


        // set auto page breaks
        $pdf->SetAutoPageBreak(TRUE, 10);

        // set image scale factor
        $pdf->setImageScale(1);
        $pdf->setFontSubsetting(true);
        //$pdf->SetFont('helvetica', '', 9);
		$pdf->SetFont('helvetica', '', 9.5);
        $pdf->AddPage($tipo_pdf);
        $pdf->setTextShadow(array('enabled'=>false, 'depth_w'=>0.2, 'depth_h'=>0.2, 'color'=>array(196,196,196), 'opacity'=>1, 'blend_mode'=>'Normal'));

        $pdf->writeHTML($html, true, 0, true, true);
        $pdf->lastPage();
        ob_end_clean();
        $pdf->Output($filename,'I');
    }
}


/*********************************************************************************/
if (!function_exists('genera_pdf_ss_es')) {

    function genera_pdf_ss_es($html, $filename = '',$title='', $subject='', $author='Humancenter Review S.A de C.V.', $tipo_pdf = 'P') 
	{
        $CI =& get_instance();
        $CI->load->library('tcpdf/Tcpdf');
		
// Extend the TCPDF class to create custom Header and Footer
class MYPDF extends TCPDF {

	public $evaluado;
	public $observaciones;
	public $fuera_rango;
	
    //Page header
    public function Header() {
        // Logo
        //$image_file = K_PATH_IMAGES.'hclogo.jpg';
		$image_file = K_PATH_IMAGES.'hclogo_g.jpg';
		// 20, 50, 175, 175,
        $this->Image($image_file, 50, 80, 105, 105, 'JPG', '', 'T', false, 300, '', false, false, 0, false, false, false);
        // Set font
        //$this->SetFont('helvetica', 'B', 10);
        // Title
        //$this->Cell(0, 0, $image_file.'<< TCPDF Example 003 >>', 0, false, 'C', 0, '', 0, false, 'M', 'M');
    }

    // Page footer
    public function Footer() {
        // Position at 15 mm from bottom
         $this->SetFont('helvetica', 'B', 8);
		 $mueve=-33;
		 $mueve+=4;
		 $mueve+=3;
		 $this->SetY($mueve);
		 //$this->Cell(0, 0,"          ");
		 $this->Cell(0, 0,"    Expediente: N-004-23");
		 $muevo=192;//202;
		 $ajuste=$muevo - strlen($this->evaluado)*1.50;
		 $this->SetX($ajuste);
		 $this->Cell(0, 0,$this->evaluado);
		 $mueve+=1;
		 $this->SetY($mueve);
		 //$this->SetFont('helvetica', 'B', 2);
		 
		 /* linea*/
		 $mueve+=1;
		 $this->SetFillColor(75,86,130);
		 $this->Cell(0, 0,"_________________________________________________________________________________________________________________________",  0, false, 'C', 0, '', 0, false, 'T', 'M');		 
		 /**/

		 $mueve+=4;
		 $this->SetFont('helvetica', 'B', 8);
		 $this->SetY($mueve);
		 $this->Cell(0, 0,"Human Center Review S.A. de C.V.",  0, false, 'C', 0, '', 0, false, 'T', 'M');
		 

		 
		 $mueve+=3;
		 $this->SetY($mueve);
		 $this->Cell(0, 0,"San Borja 1365 Col. Vértiz Narvarte Alc. Benito Juárez C.P. 03600 Ciudad de México. Tel. 55-36-40-44-36 ",  0, false, 'C', 0, '', 0, false, 'T', 'M');

		 $this->SetY(-15);
        // Set font
         $this->SetFont('helvetica', 'I', 8);
        // Page number
         $this->Cell(0, 10, 'Página '.$this->getAliasNumPage().'/'.$this->getAliasNbPages(), 0, false, 'C', 0, '', 0, false, 'T', 'M');
    }
}

	// create new PDF document
	$pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

		$pdf->evaluado=$subject;
		$pdf->observaciones=$obs;
		
		/*if ($fuera_rango == '')
		{
			$pdf->fuera_rango='Ninguno';
		}	
		else*/
		{
			$pdf->fuera_rango=$fuera_rango;
		}	
	// set document information
	$pdf->SetCreator(PDF_CREATOR);
	$pdf->SetAuthor($author);
	$pdf->SetTitle($title);
	$pdf->SetSubject($subject);
	$pdf->SetKeywords('TCPDF, PDF, RECETAS, HUMANCENTER, PLATAFORMA');

	// set default header data
	$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE, PDF_HEADER_STRING);

	// set header and footer fonts
	$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
	$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

	// set default monospaced font
	$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

	// set margins
	//$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
	//$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
	//$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

	//$pdf->SetMargins(10, 10);
	//$pdf->SetHeaderMargin(10);
	//$pdf->SetFooterMargin(5);


		$pdf->SetMargins(10,15,10);
        $pdf->SetHeaderMargin(1);
        $pdf->SetFooterMargin(8);



	// set auto page breaks
	//$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
	$pdf->SetAutoPageBreak(TRUE, 41);

	//$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
	$pdf->setImageScale(1);
	$pdf->setFontSubsetting(true);
	// set font
	$pdf->SetFont('helvetica', '', 9);


	// set some language-dependent strings (optional)
	if (@file_exists(dirname(__FILE__).'/lang/eng.php')) {
		require_once(dirname(__FILE__).'/lang/eng.php');
		$pdf->setLanguageArray($l);
		}

	//$pdf->SetFont('times', 'BI', 12);

	// add a page
	$pdf->AddPage();
	$pdf->writeHTML($html, true, 0, true, true);
	$pdf->lastPage();
// write some JavaScript code
//$js = <<<EOD

//EOD;

// force print dialog
//$js .= 'print(true);';

// set javascript
//$pdf->IncludeJS($js);	

	ob_end_clean();
	//$pdf->Output(UPLOAD_PATH.'example_001.pdf', 'FI'); //PARA SACAR A UN ARCHIVO EL RESULTADO
	//$pdf->Output('example_001.pdf', 'F'); //PARA SACAR A UN ARCHIVO EL RESULTADO
	$pdf->Output($filename,'I');  //modo normal

//$pdf->Output($filename,'D'); 
    }
}



if (!function_exists('genera_pdf_file')) {

    function genera_pdf_file($html, $filename = 'Humancenter', $author='', $title='', $subject='', $tipo_pdf = 'P', $path = '') {
        $CI =& get_instance();

        // Llamada a la libreria TCPDF
        $CI->load->library('tcpdf/Tcpdf');

        // Crear Nuevo PDF
        $pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

        //info del PDF
        $pdf->SetCreator(PDF_CREATOR);
        $pdf->SetAuthor($author);
        $pdf->SetTitle($title);
        $pdf->SetSubject($subject);

        // Cabecera del PDF
        $pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE.' 001', PDF_HEADER_STRING, array(0,64,255), array(0,64,128));
        $pdf->setFooterData(array(0,64,0), array(0,64,128));
        // set header and footer fonts
        $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
        $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
        $pdf->SetPrintHeader(false);
        // set default monospaced font
        $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

        // set margins
        $pdf->SetMargins(3, 3, 3);
        $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
        $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

        // set auto page breaks
        $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

        // set image scale factor
        $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
        $pdf->setFontSubsetting(true);
        $pdf->SetFont('dejavusans', '', 9);
        $pdf->AddPage($tipo_pdf);
        $pdf->setTextShadow(array('enabled'=>true, 'depth_w'=>0.2, 'depth_h'=>0.2, 'color'=>array(196,196,196), 'opacity'=>1, 'blend_mode'=>'Normal'));

        $pdf->writeHTML($html, true, 0, true, true);
        $pdf->lastPage();
        $pdf->Output($path.$filename,'F');
    }
}
