<?php 
defined('BASEPATH') OR exit('No direct script access allowed');

class Easegurados_model extends CI_Model {
    
        function __construct()
        {
            parent::__construct();
            $this->load->database();
            $this->load->helper('util');
        }

        function get_all_reg_by_fecha($f_ini,$f_fin)
        {
            $this->db->select('*');
            $this->db->from('sis02_sura_comercial');
            $this->db->where('log_insrt_f >=', $f_ini);
			$this->db->where('log_insrt_f <=', $f_fin);
			$this->db->order_by('sura_id desc');
            $result = $this->db->get();
            return $result->result_array();
        }

        function busca($id,$numserie,$mail,$analista)
        {            
            $this->db->select('*');
            $this->db->from('sis02_sura_comercial');		
			
            if($id != ''){ $this->db->where('sura_id',$id); }
            if($numserie != ''){ $this->db->like('sura_numeroserie',$numserie); }			
			if($mail != ''){ $this->db->like('sura_correo',$mail); }    
			if($analista != ''){ $this->db->where('usr_id',$analista); }  
		
            $this->db->order_by('sura_id','ASC');
            $result = $this->db->get();
            return $result->result_array();
        }

		function borra($sura_id)
		{
			$this->db->where('sura_id', $sura_id);
			return $this->db->delete('sis02_sura_comercial');
		}

        function inserta($params)
        {
            $data = array_merge($params, log_insert('Nuevo registro'));
            $this->db->insert('sis02_sura_comercial', $data);
            return $this->db->insert_id();
        }

        function inserta_ins_log($params,$texto)
        {
            $data = array_merge($params, log_insert($texto));
            $this->db->insert('sis02_sura_comercial_log', $data);
            return $this->db->insert_id();
        }

        function inserta_upd_log($params,$texto)
        {
            $data = array_merge($params, log_update($texto));
            $this->db->insert('sis02_sura_comercial_log', $data);
            return $this->db->insert_id();
        }


        function actualiza($usr_id, $params)
        {
            $data = array_merge($params, log_insert('Reenviar correo'));
            $this->db->where('sura_id',$usr_id);
            return $this->db->update('sis02_sura_comercial',$data);
        }


        function get($id)
        {
            $this->db->select('*');
            $this->db->from('sis02_sura_comercial');
            $this->db->where('sura_id', $id);
            $result = $this->db->get();
            return $result->row_array();
        }

        function buscat($numeroserie)
        {            
            $this->db->select('sura_numeroserie');
            $this->db->from('sis02_sura_comercial');
			$this->db->like('sura_numeroserie',$numeroserie); 
            $result = $this->db->get();
            $row = $result->row_array();
			return $row['sura_numeroserie'];
        }


		function count_all()
        {
            $this->db->select("count(sura_id) as regs");
            $this->db->from('sis02_sura_comercial');
            $result = $this->db->get();
            $row = $result->row_array();
            return $row['regs'];
        }

	    function get_allo($rows)
        {			
			$page = ($this->uri->segment(3) != '')?($this->uri->segment(3)-1)*$rows:0;
            $this->db->select('*');
            $this->db->from('sis02_sura_comercial');
			$this->db->order_by('sura_id desc' );
			$this->db->limit($rows, $page);
            $result = $this->db->get();
            return $result->result_array();
        }



    function get_allo_by_user($rows, $usr_id)
        {			
			$page = ($this->uri->segment(3) != '')?($this->uri->segment(3)-1)*$rows:0;
            $this->db->select('*');
            $this->db->from('sis02_sura_comercial');
			$this->db->where('usr_id', $usr_id);
			$this->db->order_by('sura_id desc' );
			$this->db->limit($rows, $page);
            $result = $this->db->get();
            return $result->result_array();
        }	

		function count_all_by_user($usr_id)
        {
            $this->db->select("count(sura_id) as regs");
            $this->db->from('sis02_sura_comercial');
			$this->db->where('usr_id', $usr_id);
            $result = $this->db->get();
            $row = $result->row_array();
            return $row['regs'];
        }

        function busca_by_user($id,$numserie,$mail,$usr_id)
        {            
            $this->db->select('*');
            $this->db->from('sis02_sura_comercial');		
			
            if($id != ''){ $this->db->where('sura_id',$id); }
            if($numserie != ''){ $this->db->like('sura_numeroserie',$numserie); }			
			if($mail != ''){ $this->db->like('sura_correo',$mail); }            
			$this->db->where('usr_id', $usr_id);
            $this->db->order_by('sura_id','ASC');
            $result = $this->db->get();
            return $result->result_array();
        }



    function get_analistas($filtro)
        {			
            $this->db->select('*');
            $this->db->from('sis20_usuarios');
			$this->db->like('acciones',$filtro);
			$this->db->order_by('usr_username desc' );
            $result = $this->db->get();
            return $result->result_array();
        }	

		
/**********************************************************************/

}