<?php 
defined('BASEPATH') OR exit('No direct script access allowed');

class Biometria_hematica_model extends CI_Model {
    
    function __construct()
    {
        parent::__construct();
        $this->load->database();
    }
    
    function insert($data_insert)
    {
        $this->db->insert('fsm_biometria_hematica', $data_insert);
        return $this->db->insert_id();
    }

    function get($fsm_id,$es_usr_de_un_despacho=0)
    {
        $this->db->select('*');
        $this->db->from('fsm_biometria_hematica');
        $this->db->where('fsm_id', $fsm_id);
        /*if(get_perfil_id() == 4)
        {
            $this->db->where('emp_id', get_emp_id());    
        }
        if(get_perfil_id() == 4)
        {
			if ($es_usr_de_un_despacho==0)
			{	
            $this->db->where('emp_id', get_emp_id());
			}
        }*/
        $result = $this->db->get();
        return $result->row_array();
    }

    function get_by_clte($cliente_id,$es_usr_de_un_despacho=0)
    {
        $this->db->select('*');
        $this->db->from('fsm_biometria_hematica');
        $this->db->where('clte_id', $cliente_id);
      /*  if(get_perfil_id() == 4)
        {
			if ($es_usr_de_un_despacho==0)
			{	
            $this->db->where('emp_id', get_emp_id());
			}
        }*/
        $this->db->order_by('log_insrt_f','DESC');
        $result = $this->db->get();
        return $result->result_array();
    }

    function get_by_clte_referencia($cliente_id,$referencia_id)
    {
		$referencia_id.=$cliente_id.'_';
		$evaluados_array = explode("_", $referencia_id);
        $this->db->select('*');
        $this->db->from('fsm_biometria_hematica');
        $this->db->where_in('clte_id', $evaluados_array);
        $this->db->order_by('log_insrt_f','DESC');
        $result = $this->db->get();
        return $result->result_array();
    }


    function get_by_clte_servicio($cliente_id,$serv_id,$es_usr_de_un_despacho=0)
    {

		$this->db->select('*');
        $this->db->from('fsm_biometria_hematica');
        $this->db->where('clte_id', $cliente_id);
		$this->db->where('serv_id', $serv_id);
        $this->db->order_by('bio_f_recibido','DESC');
        $result = $this->db->get();
        return $result->result_array();
    }

	
	function delete_biometria_hematica($fsm_id)
    {
        $this->db->where('fsm_id', $fsm_id);
        return $this->db->delete('fsm_biometria_hematica');
    }
}