<?php 
defined('BASEPATH') OR exit('No direct script access allowed');

class Recetario_model extends CI_Model {
    
    function __construct()
    {
        parent::__construct();
        $this->load->database();
    }
    
    
    function insert($data_insert)
    {
        $this->db->insert('fsm_psicologico', $data_insert);
        return $this->db->insert_id();
    }
	
    function update($id, $params)
    {
		$this->db->where('fsm_id', $id);
        return $this->db->update('fsm_psicologico', $params);
    }	

    function insert_simple($data_insert)
    {
        $this->db->insert('fsm_psicologico_3', $data_insert);
        return $this->db->insert_id();
    }

    function insert_notmed($data_insert)
    {
        $this->db->insert('fsm_notmed', $data_insert);
        return $this->db->insert_id();
    }

    function insert_notdref($data_insert)
    {
        $this->db->insert('fsm_notdref', $data_insert);
        return $this->db->insert_id();
    }

    function insert_refmed($data_insert)
    {
        $this->db->insert('fsm_refmed', $data_insert);
        return $this->db->insert_id();
    }

    function insert_r($data_insert)
    {
        $this->db->insert('fsm_recetario', $data_insert);
        return $this->db->insert_id();
    }
	
    function update_r($id, $params)
    {
        $this->db->where('fsm_id', $id);
        return $this->db->update('fsm_psicologico_2', $params);
    }
	
	function insert_r_simple($data_insert)
    {
        $this->db->insert('fsm_psicologico_4', $data_insert);
        return $this->db->insert_id();
    }
	
    function update_r_simple($id, $params)
    {
        $this->db->where('fsm_id', $id);
        return $this->db->update('fsm_psicologico_4', $params);
    }
	
	
    function get($fsm_id,$es_usr_de_un_despacho=0)
    {
        $this->db->select('*');
        $this->db->from('fsm_psicologico');
        $this->db->where('fsm_id', $fsm_id);
        /*if(get_perfil_id() == 4)
        {
            $this->db->where('emp_id', get_emp_id());
        }*/
        if(get_perfil_id() == 4)
        {
			if ($es_usr_de_un_despacho==0)
			{	
            $this->db->where('emp_id', get_emp_id());
			}
        }		
        $result = $this->db->get();
        return $result->row_array();
    }

    function get_recetas_paciente($clte_id)
    {
        $this->db->select("count(clte_id) as regs");
        $this->db->from('fsm_recetario');
        $this->db->where('clte_id', $clte_id);
		$result = $this->db->get();
		$row = $result->row_array();
		return $row['regs'];
    }

    function get_refmed_paciente($clte_id)
    {
        $this->db->select("count(clte_id) as regs");
        $this->db->from('fsm_refmed');
        $this->db->where('clte_id', $clte_id);
		$result = $this->db->get();
		$row = $result->row_array();
		return $row['regs'];
    }

    function get_notdref_paciente($clte_id)
    {
        $this->db->select("count(clte_id) as regs");
        $this->db->from('fsm_notdref');
        $this->db->where('clte_id', $clte_id);
		$result = $this->db->get();
		$row = $result->row_array();
		return $row['regs'];
    }

    function get_notmed_paciente($clte_id)
    {
        $this->db->select("count(clte_id) as regs");
        $this->db->from('fsm_notmed');
        $this->db->where('clte_id', $clte_id);
		$result = $this->db->get();
		$row = $result->row_array();
		return $row['regs'];
    }

    function get_notdref($fsm_id)
    {
        $this->db->select('*');
        $this->db->from('fsm_notdref');
        $this->db->where('fsm_id', $fsm_id);
        $result = $this->db->get();
        return $result->row_array();
    }

    function get_notmed($fsm_id)
    {
        $this->db->select('*');
        $this->db->from('fsm_notmed');
        $this->db->where('fsm_id', $fsm_id);
        $result = $this->db->get();
        return $result->row_array();
    }

    function get_refmed($fsm_id)
    {
        $this->db->select('*');
        $this->db->from('fsm_refmed');
        $this->db->where('fsm_id', $fsm_id);
        $result = $this->db->get();
        return $result->row_array();
    }

    function get_r($fsm_id,$es_usr_de_un_despacho=0)
    {
        $this->db->select('*');
        $this->db->from('fsm_recetario');
        $this->db->where('fsm_id', $fsm_id);
/*
        if(get_perfil_id() == 4)
        {
			if ($es_usr_de_un_despacho==0)
			{	
            $this->db->where('emp_id', get_emp_id());
			}
        }		*/
        $result = $this->db->get();
        return $result->row_array();
    }

  function get_max_numerador_notdref($fsm_emp_atte)
    {
        $this->db->select_max('fsm_numerador','maximo');
        $this->db->from('fsm_notdref');
        $this->db->where('fsm_emp_atte', $fsm_emp_atte);
        $result = $this->db->get();
        return $result->row_array();
    }

  function get_max_numerador_refmed($fsm_emp_atte)
    {
        $this->db->select_max('fsm_numerador','maximo');
        $this->db->from('fsm_refmed');
        $this->db->where('fsm_emp_atte', $fsm_emp_atte);
        $result = $this->db->get();
        return $result->row_array();
    }

  function get_max_numerador_notmed($fsm_emp_atte)
    {
        $this->db->select_max('fsm_numerador','maximo');
        $this->db->from('fsm_notmed');
        $this->db->where('fsm_emp_atte', $fsm_emp_atte);
        $result = $this->db->get();
        return $result->row_array();
    }

  function get_max_numerador($fsm_emp_atte)
    {
        $this->db->select_max('fsm_numerador','maximo');
        $this->db->from('fsm_recetario');
        $this->db->where('fsm_emp_atte', $fsm_emp_atte);
        $result = $this->db->get();
        return $result->row_array();
    }

	
	function get_simple($fsm_id,$es_usr_de_un_despacho=0)
    {
        $this->db->select('*');
        $this->db->from('fsm_psicologico_3');
        $this->db->where('fsm_id', $fsm_id);
        /*if(get_perfil_id() == 4)
        {
            $this->db->where('emp_id', get_emp_id());
        }
        if(get_perfil_id() == 4)
        {
			if ($es_usr_de_un_despacho==0)
			{	
            $this->db->where('emp_id', get_emp_id());
			}
        }	*/	
        $result = $this->db->get();
        return $result->row_array();
    }


    function get_r_simple($fsm_id,$es_usr_de_un_despacho=0)
    {
        $this->db->select('*');
        $this->db->from('fsm_psicologico_4');
        $this->db->where('fsm_id', $fsm_id);
        /* 
		if(get_perfil_id() == 4)
        {
            $this->db->where('emp_id', get_emp_id());
        }
		*/
        if(get_perfil_id() == 4)
        {
			if ($es_usr_de_un_despacho==0)
			{	
            $this->db->where('emp_id', get_emp_id());
			}
        }		
        $result = $this->db->get();
        return $result->row_array();
    }

    function get_by_clte($cliente_id,$es_usr_de_un_despacho=0)
    {
        $this->db->select('*');
        $this->db->from('fsm_psicologico');
        $this->db->where('clte_id', $cliente_id);
        /*
		if(get_perfil_id() == 4)
        {
            $this->db->where('emp_id', get_emp_id());
        }
		*/
        if(get_perfil_id() == 4)
        {
			if ($es_usr_de_un_despacho==0)
			{	
            $this->db->where('emp_id', get_emp_id());
			}
        }		
        $this->db->order_by('fsm_f','DESC');
        $result = $this->db->get();
        return $result->result_array();
    }

    function get_by_clte_notdref($cliente_id) 
    {
        $this->db->select('*');
        $this->db->from('fsm_notdref');
        $this->db->where('clte_id', $cliente_id);
        $this->db->order_by('fsm_f','DESC');
        $result = $this->db->get();
        return $result->result_array();
    }

    function get_by_clte_notmed($cliente_id) 
    {
        $this->db->select('*');
        $this->db->from('fsm_notmed');
        $this->db->where('clte_id', $cliente_id);
        $this->db->order_by('fsm_f','DESC');
        $result = $this->db->get();
        return $result->result_array();
    }
	


    function get_by_clte_refmed($cliente_id) 
    {
        $this->db->select('*');
        $this->db->from('fsm_refmed');
        $this->db->where('clte_id', $cliente_id);
        $this->db->order_by('fsm_f','DESC');
        $result = $this->db->get();
        return $result->result_array();
    }
	
    function get_by_clte_r($cliente_id,$es_usr_de_un_despacho=0) 
    {
        $this->db->select('*');
        $this->db->from('fsm_recetario');
        $this->db->where('clte_id', $cliente_id);

        if(get_perfil_id() == 4)
        {
			if ($es_usr_de_un_despacho==0)
			{	
            $this->db->where('emp_id', get_emp_id());
			}
        }
        $this->db->order_by('fsm_f','DESC');
        $result = $this->db->get();
        return $result->result_array();
    }

    function get_by_clte_simple($cliente_id,$es_usr_de_un_despacho=0)
    {
        $this->db->select('*');
        $this->db->from('fsm_psicologico_3');
        $this->db->where('clte_id', $cliente_id);
        /*
		if(get_perfil_id() == 4)
        {
            $this->db->where('emp_id', get_emp_id());
        }
		*/
        if(get_perfil_id() == 4)
        {
			if ($es_usr_de_un_despacho==0)
			{	
            $this->db->where('emp_id', get_emp_id());
			}
        }		
        $this->db->order_by('fsm_f','DESC');
        $result = $this->db->get();
        return $result->result_array();
    }
	
	
    function get_by_clte_r_simple($cliente_id,$es_usr_de_un_despacho=0) 
    {
        $this->db->select('*');
        $this->db->from('fsm_psicologico_4');
        $this->db->where('clte_id', $cliente_id);
        /*
		if(get_perfil_id() == 4)
        {
            $this->db->where('emp_id', get_emp_id());  
        }
		*/
        if(get_perfil_id() == 4)
        {
			if ($es_usr_de_un_despacho==0)
			{	
            $this->db->where('emp_id', get_emp_id());
			}
        }
        $this->db->order_by('fsm_f','DESC');
        $result = $this->db->get();
        return $result->result_array();
    }	
	
}