<?php
/* 
 * Generated by CRUDigniter v2.3 Beta 
 * www.crudigniter.com
 */
 
class Egreso_model extends CI_Model
{
    function __construct()
    {
        parent::__construct();
        $this->load->database();
    }
    
    /*
     * Get all egreso
     */
    function get_all_egresos()
    {
        return $this->db->get('socio_eco_egreso')->result_array();
    }
    
    /*
     * Get all egresos by fsm_id
     */
    function get_egresos($fsm_id)
    {
        $this->db->select('*');
        $this->db->from('socio_eco_egreso');
        $this->db->where('fsm_id', $fsm_id);
        $result = $this->db->get();
        return $result->result_array();
    }
    
    /*
     * function to add new egreso
     */
    function inserta($params)
    {
        $this->db->insert('socio_eco_egreso',$params);
        return $this->db->insert_id();
    }
    
    /*
     * function to add new egresos
     */
    function inserta_egresos($egresos, $fsm_id)
    {
        if(!empty($egresos))
        {
            foreach($egresos as $egreso)
            {
                if($egreso['tipo_cve'] != '' && $egreso['mensual'] != '')
                {
                    if(isset($egreso['egreso_id']))
                    {
                        $egreso_id = $egreso['egreso_id'];
                        unset($egreso['egreso_id']);
                        $this->db->where('egreso_id', $egreso_id);
                        $this->db->update('socio_eco_egreso',  array_to_upper($egreso));
                    }
                    else
                    {
                        $egreso['fsm_id'] = $fsm_id;
                        $this->db->reset_query();
                        $this->db->insert('socio_eco_egreso',array_to_upper($egreso));
                    }
                }
            }
        }
        return $this->db->insert_id();
    }
}